#!/bin/sh

set -e

PACKAGE=mediatomb
giturl=git://git.code.sf.net/p/mediatomb/code
#USE_CUSTOM_COMMIT=master

CWD_DIR=${PWD}
GOS_DIR=${CWD_DIR}/get-orig-source

DEB_SOURCE=$(dpkg-parsechangelog 2>/dev/null | sed -n 's/^Source: //p')
DEB_VERSION=$(dpkg-parsechangelog 2>/dev/null | sed -n 's/^Version: //p')
if [ -z ${USE_CUSTOM_COMMIT} ]; then
	UPSTREAM_VERSION=$(echo ${DEB_VERSION} | sed -r 's/[^:]+://; s/-[^-]+$$//')
else
	UPSTREAM_VERSION=${USE_CUSTOM_COMMIT}
fi

if [ "${DEB_SOURCE}" != "${PACKAGE}" ]; then
	echo 'Please run this script from the sources root directory.'
	exit 1
fi

rm -rf ${GOS_DIR}
mkdir ${GOS_DIR} && cd ${GOS_DIR}

# Download sources
# If the UPSTREAM_VERSION/USE_CUSTOM_COMMIT does not exist then download master
git clone --no-checkout ${giturl} ${DEB_SOURCE}
cd ${GOS_DIR}/${DEB_SOURCE}
UPSTREAM_SHA1=$(git rev-parse --quiet --verify ${UPSTREAM_VERSION}^{commit} || true)
if [ -z ${UPSTREAM_SHA1} ]; then
	git checkout master
else
	git checkout ${UPSTREAM_SHA1}
fi
UPSTREAM_VERSION=$(git describe --tags | sed -e 's/v\(.*\)/\1/')
cd ${GOS_DIR}
mv ${GOS_DIR}/${DEB_SOURCE} ${GOS_DIR}/${DEB_SOURCE}-${UPSTREAM_VERSION}

# Setting times... (to make reproducible tarballs)
cd ${GOS_DIR}/${DEB_SOURCE}-${UPSTREAM_VERSION}
for F in $(git ls-files); do touch -h -d "$(git log -1 --format="%ai" -- $F)" "$F"; done

# Clean-up...
cd ${GOS_DIR}/${DEB_SOURCE}-${UPSTREAM_VERSION}
rm -rf .git*

# Packing...
cd ${GOS_DIR}
find -L ${DEB_SOURCE}-${UPSTREAM_VERSION} -xdev -type f -print | LC_ALL=C sort \
| XZ_OPT="-6v" tar -caf "${CWD_DIR}/${DEB_SOURCE}_${UPSTREAM_VERSION}.orig.tar.xz" -T- --owner=root --group=root --mode=a+rX

cd ${CWD_DIR} && rm -rf ${GOS_DIR}
