[comment {-*- tcl -*- doctools}]
[manpage_begin fifo n 2.1]
[moddesc   {Memory channels}]
[titledesc {Create and manipulate u-turn fifo channels}]
[copyright {1996-2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[require Tcl]
[require memchan]
[description]
[list_begin definitions]

[call [cmd fifo]]

creates a stream-oriented in-memory channel and returns its
handle. There is no restriction on the ultimate size of the channel,
it will always grow as much as is necessary to accommodate the data
written into it.
[nl]
In contrast to the channels generated by [cmd memchan] a channel
created here effectively represents an U-turn. All data written into
it can be read out, but only in the same order. This also means that a
fifo channel is not seekable.
[nl]
The channels created here can be transferred between interpreters in
the same thread and between threads, but only as a whole. It is not
possible to use them to create a bi- or unidirectional connection
between two interpreters.

[list_end]
[para]
Memory channels created by [cmd fifo] provide two read-only options
which can be queried via the standard [cmd fconfigure] command. These
are

[list_begin definitions]
	[lst_item -length]

	The value of this option is the number of bytes currently
	stored in the queried memory channel.

	[lst_item -allocated]
	The value of this option is the number of bytes currently
	allocated by the queried memory channel. This number is at
	least as big as the value of [strong -length].
	
[list_end]
[para]
As the channels generated by [cmd fifo] grow as necessary they are
always writable. This means that a writable [cmd fileevent]-handler
will fire continuously.

[para]
The channels are also readable if they contain more than zero
bytes. Under this conditions a readable [cmd fileevent]-handler will
fire continuously.

[section NOTES]
[para]
One possible application of memory channels created by [cmd memchan]
or [cmd fifo] is as temporary storage device to collect data coming in
over a pipe or a socket. If part of the processing of the incoming
data is to read and process header bytes or similar fifo are easier to
use as they do not require seeking back and forth to switch between
the assimilation of headers at the beginning and writing new data at
the end.


[see_also memchan fifo2 null]
[keywords fifo stream memchan {in-memory channel} channel i/o]
[manpage_end]
