#!/bin/bash
set -euo pipefail

# Prepare pandoc filters
if [ -d pandocfilters/.git ]; then
    (cd pandocfilters && git remote update && git merge --ff-only)
else
    git clone https://github.com/Lothiraldan/pandocfilters.git
fi

pip2 install pandocfilters
pip2 install pygraphviz
pip2 install panflute
pip2 install hg+https://bitbucket.org/octobus/mercurial_docgraph
pip2 install hg-evolve

mkdir -p graphs output

CMD_NOT_FOUND=0
check_command() {
    cmd=$1
    if ! which "$cmd" >/dev/null 2>&1; then
        echo "Error: command '$cmd' not found in \$PATH"
        echo "Please install '$cmd'"
        CMD_NOT_FOUND=1
    else
        echo "$cmd command was found"
    fi
}

check_command pandoc
check_command aha

if [ "$CMD_NOT_FOUND" -ne "0" ]; then
    exit 1
fi

# Prepare directory for repositories generated by the training.t file
mkdir -p base-repos

rm -Rf base-repos/*
