/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Product_H
#define Product_H

#include <set>
#include <string>
#include <vector>

using namespace std;

class Path;

class Product
{
public:
	Product(const string&,const string&,const string&,const std::set<string>&,bool);
	bool find(const string&);
	string title() {return title_;}
	string description() {return description_;}
	bool hasImage() {return hasImage_;}
	string imagePath();
	string path() {return path_;}
	
	static void find(const string& str,vector<Product*>&);
	
protected:	
	static void scan();
	static void scan(const Path&);
	
	string path_;
	string title_;
	string description_;
	std::set<string> keys_;
	bool hasImage_;
};

#endif	