/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQTreeView_H
#define MvQTreeView_H

#include <QPoint>
#include <QTreeView>

using namespace std;


class MvQTreeView : public QTreeView
{
	Q_OBJECT

public:
	MvQTreeView(QWidget *parent=0);
	//~MvQTreeView(); 
	void keyboardSearch(const QString &);
	void setActvatedByKeyNavigation(bool b) {activatedByKeyNavigation_=b;}
	void setColumnToDrag(int i) {columnToDrag_=i;} 

signals:
	//void dropAccepted(QString);

protected:
	void keyReleaseEvent(QKeyEvent*);
	/*void mousePressEvent(QMouseEvent*);
	void mouseMoveEvent(QMouseEvent*);
	void dragEntermouseMoveEvent(QMouseEvent*);
	void dragEnterEvent(QDragEnterEvent *);
	void dragMoveEvent(QDragMoveEvent *);
	void dropEvent(QDropEvent *);	
	void performDrag();*/

	bool dragEnabled();
	bool dropEnabled();

	bool activatedByKeyNavigation_;
	QPoint startPos_;

	int columnToDrag_;

};

#endif
