/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvGribTableC_H
#define MvGribTableC_H

/*--------------------------------------------------------*/
/*-- MAX_TABLE2_VERSIONS defines the maximum number of  --*/
/*-- different versions of GRIB Table 2 that can be     --*/
/*-- used at any time. Increase the number if required. --*/
/*--------------------------------------------------------*/

#define MAX_TABLE2_VERSIONS 10



typedef struct
{
	char	shortName[ 7 ];
	char	longName[ 1 ]; /* not used */
	char	fieldType;
	
} MvGribTEntryStruct;

typedef struct
{
	int	version;
	int	start;
	int	end;
	MvGribTEntryStruct*	entry;
} MvGribTStruct;

typedef struct
{
	int		nelems;
	MvGribTStruct*	partable[ MAX_TABLE2_VERSIONS ];
} MvGribParStruct;

/*
** Prototypes
*/

#if defined(__STDC__) || defined(__cplusplus) || defined (c_plusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

#if defined(__cplusplus) || defined (c_plusplus)
extern "C"
{
#endif

/*
** PUBLIC FUNCTIONS
*/

MvGribParStruct*    MvGribParOpen P_((void));
void                MvGribParClose P_((MvGribParStruct*));
MvGribTEntryStruct* MvGribParEntry P_((MvGribParStruct*,int,int));
int                 MvGribParIndex P_((MvGribParStruct*,int,const char*));

#if defined(__cplusplus) || defined (c_plusplus)
}
#endif

#undef P_
#endif
