
;;; file: pao_equal.scm


(display"

Begin of pao_equal.scm

")



(begin

(display"

IC: equality defined as ≼ ≽
IC(α,β) :≡ α≼β & β≽α

")

; (remove-program-constant "IC")
(add-program-constant
 "IC"
 (mk-arrow (py "ord") (py "ord") (py "boole"))
 1 'const 2
)

(add-computation-rule (pt "IC ord1 ord2") (pt "ord1 ≼ ord2 and ord2 ≼ ord1"))

(display-program-constants "IC")

(define (icsimp)
  (simp (pf "all ord1,ord2.(¬(ord2≺ord1) and ¬(ord1≺ord2))=IC ord1 ord2")))


(display"
Test for IC
")
(pnt  "IC ø ø")
;  0= ø => True
(pnt  "IC ø ①")
;  0=1 => False
(pnt  "IC (OP ø ω) ω")
; 1+ω=ω => True
(pnt  "IC ω (OP ø ω)")
; ω=1+ω => True
(pnt "IC  (OP ω ①) (OP ø (OP ω ①))")
; ω+1=1+ω+1 => True

; End
)




(begin
(add-token
 "~"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "IC")) x y)))

(add-display
 (py "boole")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "IC"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "~"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))

(display-program-constants "IC")
)


(begin
(display "
ø ~ ①\t\t") (pnt "ø ~ ①")
; "F"
(display "ord ~ ord\t") (pnt "ord~ord")
; "T"
(display "ord1 ~ ord2\t") (pnt "ord1~ord2")
; "[if (ord0 =b) True [if (ord0 ≺ ord1) False [if (ord1 ≺a) False True]]]"
)





(set! COMMENT-FLAG #f)



; Trivial but important

(display "

IC: α~β -> α≼β

")

; (hide-output)

(begin
(sg "ord1~ord2 ⇔ (ord1≼ord2 & ord2≼ord1)")
(assume "ord1" "ord2")
(ng)
(cd "ord1≺ord2" "1<2")
(cd "ord2≺ord1" "2<1")
(auto)

; Proof finished.

(save "ic")
(display-theorems "ic")
)



(display"

RW-rules for IC ~

")

; already normalising when ~ defined by ≼ and ≽

(begin
(pnt  "ord ~ ø")
; ord= ø
(pnt  "ø ~ ord")
; ord= ø
(pnt "ord ~ OP ø ord")
; ω ≼ord
(pnt " OP ø ord ~ ord")
; ω ≼ord
(pnt "ord1 ~ OP ord1 ord2") 
; False
(pnt "OP ord1 ord2 ~ ord1")
; False
(pnt "ord2 ~ OP ord1 ord2") 
; OP ord1 ord2≼ord2
(pnt "OP ord1 ord2 ~ ord2")
; OP ord1 ord2≼ord2
)

(display-program-constants "IC")


(display"
ICsym :  α~β->β~α 

PROOF:
")

(begin
(sg "(ord1 ~ ord2) = (ord2 ~ ord1)")
(assume "ord1" "ord2")
(ng)
(cd "ord1≺ord2" "1<2")
(auto)

; Proof finished.

(save"ICsym")
(display-theorems"ICsym")
)



(display"
ICtrans:
(α~β and β~γ) → α~γ

PROOF:
")

(begin

(sg "(ord1 ~ ord2 and ord2 ~ ord3) → ord1 ~ ord3")
(assume "ord1" "ord2" "ord3")
(ng #t)
(cd "ord1≺ord2" "1<2")
  (auto)
(assume "2≤1")
(cd "ord2≺ord3" "2<3")
  (auto)
(assume "3≤2")
(ng #t)
(simp(pf"¬(ord1≺ord3)"))
(use "Truth-Axiom")
(use "LEtrans" (pt"ord2"))
(ng)
(simp "3≤2")
(use "Truth-Axiom")
(ng)
(simp "2≤1")
(use "Truth-Axiom")
)
; Proof finished.

(nrw "(¬(ord2≺ord1) and ¬(ord1≺ord2))
   and  (¬(ord3≺ord2) and ¬(ord2≺ord3))
   →    (¬(ord3≺ord1) and ¬(ord1≺ord3))")




(begin

(sg "ord1 ~ ord2 -> ord2 ~ ord3 -> ord1 ~ ord3")
(assume "ord1" "ord2" "ord3")
(use "BooleImp2")
(use "Truth-Axiom")

; Proof finished.

(save"ICtrans")
(display-theorems"ICtrans")

)




(begin
(display"

IC ~ is an equivalence relation.

1) Reflexsive

ord ~ ord   :  ")
(pnt "ord ~ ord")

(display"

2) Symmetrie

")
(display-theorems"ICsym")
(display"

3) Transitivity

(ord1 ~ ord2 and ord2 ~ ord3) → ord1 ~ ord3    :  ")

(pnt"(ord1 ~ ord2 and ord2 ~ ord3) → ord1 ~ ord3")

)



(display"

SMALLERlinear: α~β | α≺β | α>β

PROOF:
")

(begin

(sg (ORB "ord1~ord2" "ord1≺ord2" "ord2≺ord1"))
(assume "ord1" "ord2")
(ng)
(cd "ord1≺ord2" "1<2")
(auto)
)
; Proof finished.

(nrw "¬( ¬(¬(ord2≺ord1) and ¬(ord1≺ord2)) and ¬(ord1≺ord2) and ¬(ord2≺ord1))")



(begin

(sg (⋁ "ord1~ord2" "ord1≺ord2"  "ord2≺ord1"))
(assume "ord1" "ord2")
(use "BooleOr2")
(use "Truth-Axiom")
)
; Proof finished.

(save "SMALLERlinear")
(display-theorems "SMALLERlinear")

; (add-theorem "SMALLERlinearSoundness"
; 	     (proof-to-soundness-proof 
; 		 (theorem-name-to-proof "SMALLERlinear")))
;(display-theorems "SMALLERlinearSoundness")



(test-extracted-binary "SMALLERlinear")







(display "
SMALLERlinearProp

       (ord2 ≺ ord1) = left  (cSMALLERlinear ord1 ord2)
   and (ord1 ≺ ord2) = right (cSMALLERlinear ord1 ord2)

")


(begin
(animate "BooleOr2")
(animate "SMALLERlinear")
(sg "  (ord2 ≺ ord1) = left  (cSMALLERlinear ord1 ord2)
   and (ord1 ≺ ord2) = right (cSMALLERlinear ord1 ord2)")
(ng)
(assume "ord2" "ord1")
(cd "ord1≺ord2" "1<2")
(cas "¬(ord2≺ord1)" "1≤2")
(auto)
(simp "<-" (pf"¬(ord1≺ord2 and ord2≺ord1)"))
(simp "1<2")
(auto)

; Proof finished.

(save "SMALLERlinearProp")
(deanimate "SMALLERlinear")
(deanimate "BooleOr2")
(display-theorems "SMALLERlinearProp")
)





(display "
Extracion of cMAX: ord² -> ord

")

(animate "BooleOr2")
(animate "SMALLERlinear")
(sg "ex ord.ord1≼ord and ord2≼ord and ( ord~ord1 | ord~ord2 )")
(begin
(assume "ord1" "ord2")
(cases (pt "left(cSMALLERlinear ord1 ord2)"))
(assume "l")
(ex-intro(pt"ord1"))
(ng)
(simp "<-" (pf "¬(ord1≺ord2 and ord2≺ord1)"))
(simp "l")
(auto)
(assume "¬l")
(ex-intro(pt"ord2"))
(ng)
(simp "¬l")
(auto)
)
; Proof finished.

(save "MAX")

;(add-theorem "MAXSoundness"
;	     (np(proof-to-soundness-proof 
;		 (theorem-name-to-proof "MAX"))))

(deanimate "SMALLERlinear")
(deanimate "BooleOr2")
(display-theorems "MAX")
;(display-theorems "MAXSoundness")



(begin
(animate "SMALLERlinear")
(test-extracted-binary "MAX")
(deanimate "SMALLERlinear")
)




; Some arithmetic

(display"
InfiniteSmaller+One:
α≠0 -> γ≺ ①+ω^α+β -> γ≺ω^α+β

PROOF:
")

(begin
(sg "(¬(ord1= ø) and ord3≺OP ø (OP ord1 ord2)) → ord3≺OP ord1 ord2")
(cases)
   (auto)
(assume "ord11" "ord12")
(ng)
(cases)
   (auto)
(assume "ord31" "ord32" "ord2")
(ng)
(cds "ord31= ø" "31=0")
(auto)
)
; Proof finished.

(nrw "(¬(ord1= ø) and ord3≺OP ø (OP ord1 ord2)) → ord3≺OP ord1 ord2")




(display"
equalsmaller:
α~β -> (γ≺α = γ≺β)

PROOF:
")

(begin
(sg "ord1~ord2 → ((ord3 ≺ ord1) = (ord3 ≺ ord2))")
(assume "ord1" "ord2" "ord3")
(ng)
(cases (pt"ord1≺ord2"))
  (auto)
(assume "2≤1")
(cd"ord3≺ord2" "3<2")
  (ng)
  (simp(pf"ord3≺ord1"))
  (auto)
  (cases(pt"ord3≺ord1"))
  (auto)
  (assume "3≤1")
  (simp "<-" (pf"(ord3≺ord2 and ¬(ord1≺ord2)) → ord3≺ord1"))
  (simp "2≤1")
  (simp"3<2")
  (simp "3≤1")
  (auto)
(assume "2≤3")
(ng)
(simp "BooleStab")
(simp(pf"(¬(ord2≺ord1) and ord3≺ord1)=(ord3≺ord1 and ¬(ord2≺ord1) and ¬(ord3≺ord2))"))
(use "Truth-Axiom")
(simp "2≤3")
(ng)
(use "AndSwap")
)
; Proof finished.

(nrw "¬(¬(ord2≺ord1) and ¬(ord1≺ord2) and ¬((ord3≺ord1)=(ord3≺ord2)))")




(display"
equalslarger:
α~β -> (α≺γ = β≺γ)

PROOF:
")

(begin
(sg "ord1~ord2 → ((ord1 ≺ ord3) = (ord2 ≺ ord3))")
(assume "ord1" "ord2" "ord3")
(ng)
(cases (pt"ord2≺ord1"))
  (auto)
(assume "1≤2")
(cd"ord2≺ord3" "2<3")
  (ng)
  (simp(pf"ord1≺ord3"))
  (auto)
  (cases(pt"ord1≺ord3"))
  (auto)
  (assume "3≤1")
  (simp "<-" (pf"(¬(ord2≺ord1) and ord2≺ord3) → ord1≺ord3"))
  (simp "1≤2")
  (simp"2<3")
  (simp "3≤1")
  (auto)
(assume "3≤2")
(ng)
(simp "BooleStab")
(simp(pf"(¬(ord1≺ord2) and ord1≺ord3)=(¬(ord1≺ord2) and ord1≺ord3 and ¬(ord2≺ord3))"))
(use "Truth-Axiom")
(simp "3≤2")
(use "Truth-Axiom")
)
; Proof finished.

(nrw "¬(¬(ord2≺ord1) and ¬(ord1≺ord2) and ¬((ord3≺ord1)=(ord3≺ord2)))")





(display"
minusexp:

ω^α ≼ β -> ∃ξ (β ~ OP α ξ)

cminusexp(α,β)  ~   α - ω^β

PROOF:
")

(begin

(sg "(ord1 ≺ OP ord2 ø) ∨ (ex ord. ord1 ~ OP ord2 ord)")

(ind) ; 1
  (assume "ord2")
  (ng)
  (ex-intro (pt "F"))
  (split)
  (search)
  (assume "F")
  (ex-intro (pt "ø"))
  (use "F")
(assume "ord11" "ord12" "IH11" "IH12" "ord2")
(drop "IH11")
(ng)
(cd "ord11 ≺ ord2" "11<2")
(simp (pf "¬(ord2 ≺ ord11)"))
(ng)
(inst-with-to "IH12" (pt "ord2")  "IH12_2")
(exel  "IH12_2" "boole1"  "IH12_2p")
(ex-intro (pt"boole1"))
(ng)
(split)
(use  "IH12_2p" )
(ng)
(assume "b1")
(ex-elim (pf "ex ord.(OP ord2 ord≺ord12)=F and (ord12≺OP ord2 ord)=F"))
(use "IH12_2p")
(use "b1")
(assume "ord" "IH12_2ord")
(ex-intro (pt"ord"))
(search)
(simp "<-" (pf"¬(ord2≺ord11 and ord11≺ord2)"))
(simp "11<2")
(search)
(use "Truth-Axiom")
(assume "2≤11")
(ex-intro (pt"T"))
(ng)
(split)
(search)
(assume "T")
(cd "ord2 ≺ ord11" "2<11")
(ex-intro (pt "OP ord11 ord12"))
(ng)
(use "T")
(assume "2≮11")
(ex-intro (pt"ord12"))
(ng)
(use "T")
)
; Proof finished.

(save "minusexp")
(display-theorems "minusexp")

;(add-theorem "minusexpSoundness"
;	     (proof-to-soundness-proof 
;		 (theorem-name-to-proof "minusexp")))
;(display-theorems "minusexpSoundness")

(test-extracted-binary "minusexp")


; We check some properties of cminusexp

(animate "minusexp")

(display"
left (cminusexp ord1 ord2) = (ω^ord2 ≼ ord1)

PROOF:
")
(sg "left (cminusexp ord1 ord2) = ((ω^ ord2)≼ord1)")
(begin
(ind) ; 1
  (ng)
  (cases)
  (auto)
(assume "ord11" "ord12"  "IH11" "IH12" "ord2")
(drop "IH11")
(ng)
(cd "ord11 ≺ ord2"  "11<2")
(auto)
)
; Proof finished.

(save "cminusexpTrue")
(display-theorems  "cminusexpTrue")



(deanimate "minusexp")


(display"
¬left (cminusexp ord1 ord2)) = (ord1 ≺ ω^ord2)

PROOF:
")

(sg "(¬left (cminusexp ord1 ord2)) = (ord1 ≺ (ω^ ord2))")
(begin
(assume "ord1" "ord2")
(simp "cminusexpTrue")
(ng)
(casedist (pt "ord1≺OP ord2ø"))
(auto)
)
; Proof finished.

(save "cminusexpFalse")
(display-theorems  "cminusexpFalse")



(animate "minusexp")

(display"
minexp:
left(cminusexp α β) = ( α ~ OP β right(cminusexp α β) )

PROOF:
")

(sg "all ord1.left (cminusexp ord1 ord2) = (ord1 ~ OP ord2 (right (cminusexp ord1 ord2)))")
(begin
(assume "ord2")
(ind)
  (auto)
(assume "ord11" "ord12" "IH11" "IH12")
(drop "IH11")
(ng #t)
(cd "ord11≺ord2" "11<2")
(simp (pf "¬(ord2≺ord11)"))
(ng #t)
(simp "IH12")
(use "Truth-Axiom")
(use "SMALLERantisym")
(use "11<2")

(assume "2≤11")
(ng #t)
(cd "ord2≺ord11" "2<11")
(auto)
)
; Proof finished.

(save "minexp")
(display-theorems "minexp")







(display"
minusexpsmaller:  α≺ω^β -> α-ω^β = ø

PROOF:
")

(begin

(sg "(ord2 ≼ (ω^ ord1)) = (right(cminusexp ord2 ord1)= ø)")
(ind)
  (search)
(assume "ord21" "ord22" "IH21" "IH22" "ord1")
(ng #t)
(cd "ord21≺ord1" "21<1")
(simp(pf"¬(ord1≺ord21)"))
(ng #t)
(simp-with "<-" "IH22" (pt"ord1"))
(use "Truth-Axiom")
(use "SMALLERantisym")
(use "21<1")
(assume "1≤21")
(cd "ord1≺ord21" "1<21")
  (use "Truth-Axiom")
(ng #t)
(assume "21≤1")
(cases (pt"ord22= ø"))
(auto)

; Proof finished.

(save "minusexpsmaller")
(display-theorems "minusexpsmaller")

)



(deanimate "minusexp")


(display"
α ≺ ω^β+[α-ω^β] = α<ω^β

PROOF:
")

(sg "(ord2 ≺ OP ord1 (right (cminusexp ord2 ord1))) = (ord2 ≺ OP ord1 ø)")
(begin
(assume "ord2" "ord1")
(cd "ord2≺OP ord1 ø" "2< 1 0")
  (simp (pf"right(cminusexp ord2 ord1) = ø"))
  (simp "2< 1 0")
  (use "Truth-Axiom")
  (simp "<-" "minusexpsmaller")
  (ng)
  (use "SMALLERantisym")
  (use  "2< 1 0")
(assume "2 ≮ 1 0")
(use-with (pf"ord2≼OP ord1(right(cminusexp ord2 ord1)) and OP ord1 right(cminusexp ord2 ord1)≼ord2") 'right)
(ng #t)
(simp "<-" "minexp")
(simp "cminusexpTrue")
(ng)
(simp "2 ≮ 1 0")
(use "Truth-Axiom")
)
; Proof finished.

(add-rewrite-rule (pt "ord2 ≺ (OP ord1 (right(cminusexp ord2 ord1)))") (pt"ord2 ≺ OP ord1 ø"))
(add-rewrite-rule (pt "ord2≺ OP ord1
                                ((Rec ord=>ord=>ord)([ord3]ø)
                                 ([ord3,ord4,(ord=>ord)_5,(ord=>ord)_6,ord7]
                                   [if (ord3≺ord7)
                                     ((ord=>ord)_6 ord7)
                                     [if (ord7≺ord3) (OP ord3 ord4) ord4]])
                                 ord2 ord1)") (pt"ord2 ≺ OP ord1 ø"))



(animate "minusexp")

(sg "¬(ord1 ≺ (right(cminusexp ord1 ord2)))")
(begin
(ind)
   (auto)
(assume "ord11" "ord12" "IH11" "IH12")
(drop "IH11")
(cases)
  (ng #t)
  (cd "ord11= ø" "11=0")
  (auto)
(assume "ord21" "ord22")
(use "Atom-False")
(ng #t)
(cd "ord11≺OP ord21 ord22" "11<21 22")
  (ng #t)
  (assume "11 12<12m21 22")
  (simp-with "<-" "IH12" (pt "OP ord21 ord22"))
  (cases(pt"ord12≺right(cminusexp ord12(OP ord21 ord22))"))
  (search)
  (assume "r12(21 22)≤12")
  (simp "<-"
	(pf"(ord12≼OP ord11 ord12 and OP ord11 ord12≺right(cminusexp ord12(OP ord21 ord22)))
          → ord12≺right(cminusexp ord12(OP ord21 ord22))"))
  (simp "r12(21 22)≤12")
  (ng #t)
  (use "11 12<12m21 22")
  (use (pf "all ord1,ord2,ord3.(ord1≼ ord2  and ord2≺ord3) → ord1≺ord3"))
  (search)
(assume "11≮21 22")
(ng #t)
(cd "OP ord21 ord22≺ord11" "21 22<11")
(auto)
)
; Proof finished.

(deanimate "minusexp")

(add-rewrite-rule (pt "ord1 ≺ (right(cminusexp ord1 ord2))") (pt"F"))
(add-rewrite-rule (pt "ord1≺(Rec ord=>ord=>ord)([ord3]ø)
                            ([ord3,ord4,(ord=>ord)_5,(ord=>ord)_6,ord7]
                              [if (ord3≺ord7) ((ord=>ord)_6 ord7) [if (ord7≺ord3) (OP ord3 ord4) ord4]])
                            ord1 ord2") (pt"F"))





(display"
OPfunctional

(ord1~ord3 and ord2~ord4) →  OP ord1 ord2 ~ OP ord3 ord4

PROOF:
")

(sg "(ord1~ord3 and ord2~ord4) → OP ord1 ord2 ~ OP ord3 ord4")
(begin
(assume "ord1" "ord3" "ord2" "ord4")
(ng)
(cd "ord3≺ord1" "3<1")
  (use "Truth-Axiom")
(assume "1≤3")
(ng)
(cd "ord1≺ord3" "1<3")
(auto)
)
; Proof finished.

(nrw "¬(¬(ord3≺ord1) and ¬(ord1≺ord3) and (¬(ord4≺ord2) and ¬(ord2≺ord4)) and
          ¬(¬[if (ord3≺ord1)(ord4≺OP ord1 ord2) [if (ord1≺ord3) (OP ord3 ord4≺ord2) (ord4≺ord2)]]
              and
           ¬[if (ord1≺ord3) (ord2≺OP ord3 ord4) [if (ord3≺ord1) (OP ord1 ord2≺ord4) (ord2≺ord4)]]))")


(sg "(ord1~ord3) -> (ord2~ord4) -> (OP ord1 ord2 ~ OP ord3 ord4)")
(strip 4)
(use "BooleImp2")
(auto)
; Proof finished.
(save "OPfunctional")
(display-theorems "OPfunctional")

; (show-output)


(set! COMMENT-FLAG #t)


(display "

End of pao_equal.scm
")

;EOF

