; ***********************************************************
; ; Adapt path if necessary:
; (define path "~/minlog/examples/tait/diplomarbeit_schlenker/")

; ; Defines the function "pload" to load files 
; ; from the path defined above
; (define pload (lambda (x) (load (string-append path x))))

; ; Used Modules:
; (pload "./initiate.scm")
; (pload "./defsLamCalc.scm")
; (pload "./defsSubst.scm")
; (pload "./omega.scm")
; (pload "./defsNT.scm")
; (pload "./defsAxiomsSpecial.scm")
; 
; NOTICE: Uncomment modules only when file is run on its own
; ***********************************************************

; =========================
;  Section: Trivial Lemmas
; =========================
; contains general, trivial lemmas

; Subsection: Lemmas on natural numbers
; =====================================

; Lemma: "Trivial1"
; -----------------
; trivial auxiliary for "FrIntro1"

(set-goal (pf "all n. n < n -> F"))
(ind)
(prop)
(assume "n" 1)
(prop)
(save "Trivial1")

; Lemma: "Trivial3"
; -----------------
(set-goal (pf "all m,n. ((m < Succ n) -> F) -> n < m"))
(ind)
(assume "n")
(prop)
(assume "m" "IH")
(cases)
(prop)
(assume "n")
(ng)
(use "IH")
(save "Trivial3")

; Lemma: "Trivial4"
; -----------------
(set-goal (pf "all m,n. m = n -> ((n < m) -> F)"))

(cases)
(assume "n" 1)
(simp-with 1)
(use "Trivial1")
(assume "m")
(assume "n" 1)
(simp-with 1)
(use "Trivial1")
(save "Trivial4")

; Lemma: "Trivial5"
; -----------------
(set-goal (pf "all m,n,k. m<n -> m<n+k "))

(ind)
(cases)
(assume "k")
(ng)
(prop)
(assume "n")
(assume "k" 1)
(ng)
(prop)
(assume "m" "IH")
(cases)
(assume "k" 1)
(prop)
(assume "n" "k" 1)
(ng)
(inst-with "IH" (pt "n") (pt "k") 2)
(prop)
(save "Trivial5")

; Lemma: "Trivial6"
; -----------------
(set-goal(pf "all m. m<0 -> F"))
(cases)
(ng)
(prop)
(assume "m" 1)
(ng)
(prop)
(save "Trivial6")

; Lemma: "Trivial7"
; -----------------
(add-global-assumption "Trivial7"
  (pf "all k,m,n.(k<m+n -> F) -> k<m -> F"))

; Lemma: "Trivial8"
; -----------------
(add-global-assumption "Trivial8"
 (pf "all k,n,sigs.k<n -> k<Succ(n+Lh sigs)"))

; Lemma: "Trivial9"
; -----------------
(add-global-assumption "Trivial9"
 (pf "all k,n,sigs.k<n -> k<n+Lh sigs"))

; Lemma: "Trivial10"
; ------------------
(add-global-assumption "Trivial10"
  (pf "all k,n.(k<Succ n -> F) -> k=(k-Succ n)+Succ n"))

; Lemma: "Transitivity"
; ---------------------
(add-global-assumption "Transitivity" 
   (pf "all m,n,k.m<n & n<k -> m <k"))

; Lemma: "Transitivity 2"
; -----------------------
(add-global-assumption "Transitivity 2"
   (pf "all k,m,n.(m<n -> F) -> (k<m ->F) -> (k<n -> F)"))

; Lemma: "SRAux6Trivial"
; ----------------------
(add-global-assumption "SRAux6Trivial" 
 (pf "all rhos,k.Lh rhos+Lh(Var map Seq 0 k)<Lh rhos -> F"))


; Subsection: Lemmas on Lists
; ===========================
; Lemma: "ListAppendAssoc"
; ------------------------
; Associativity

(add-global-assumption "ListAppendAssoc"
 (pf "all (list alpha)_1,(list alpha)_2,(list alpha)_3.
       Equal(((list alpha)_1:+:(list alpha)_2):+:(list alpha)_3)
            ((list alpha)_1:+:((list alpha)_2:+:(list alpha)_3))"))

; Lemma: "ListAssoc"
; ------------------
(add-global-assumption "ListAssoc" (pf "all rhos, sigs, taus.
 (rhos:+:sigs:+:taus) = (rhos:+:(sigs:+:taus))"))

; Lemma: "LhRhosSigs"
; -------------------
(add-global-assumption "LhRhosSigs"
  (pf "all rhos, sigs. Lh (rhos :+: sigs) = Lh rhos + Lh sigs"))

; Lemma "NilAppend"
; -----------------
(add-global-assumption "NilAppend"
 (pf "all rhos. rhos=rhos:+:(Nil type)"))

; Lemma: "NilAppend2"
; -------------------
(add-global-assumption "NilAppend2"
  (pf "all rhos.(Nil type):+:rhos = rhos"))

; Lemma: "SRAux2aTrivial"
; -----------------------
(add-global-assumption "SRAux2aTrivial"
 (pf "all sigs,rho1,rhos.sigs:+:(rho1::rhos)=
      sigs:+:rho1: :+:rhos"))

; Lemma: "SRAux7Trivial"
; ----------------------
(add-global-assumption "SRAux7Trivial2"
 (pf "all s,ss.(s::ss) = (s:):+:ss"))


; Subsection: Miscellaneous
; =========================
; Lemma: "Symmetry"
; -----------------
(add-global-assumption "Symmetry"(pf "all sigs, s, theta, rhos.
 Typ sigs(Sub s theta) = Typ rhos s ->
 Typ rhos s = Typ sigs(Sub s theta)"))
