# configfile.py
#
#   Copyright (C) 2003 Daniel Burrows <dburrows@debian.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from serialize import skip_ws
import serialize

# A configuration file is simply a bunch of nested dictionaries.
# However, the syntax is a bit different, for human-readability:
#
# ConfigFile ::= Section*
# Section ::= <identifier> { (<identifier> = PEXP)* }
#
# Nested sections are not presently supported, although it wouldn't be
# hard to support them.

# "dict" here is a dictionary which will be read into.  If it is not
# specified, a new dictionary is created and returned.
def read_config_file(f, rval={}, reader=serialize.Reader()):
    # Return True iff EOF was *not* reached.
    def read_section(name):
        loc,c=skip_ws(f)

        while c <> '}':
            option=''

            if not c.isalpha():
                raise IOError,'Bad character in identifier name'

            while c.isalnum():
                option+=c
                c=f.read(1)

            if c.isspace():
                loc,c=skip_ws(f)

            if c <> '=':
                raise IOError,'In configuration file: expected \'=\', got \'%s\''%c

            val=reader.read(f)

            rval.setdefault(name, {})[option]=val

            loc,c=skip_ws(f)

    loc,c=skip_ws(f)
    while c <> '':
        if not c.isalpha():
            raise IOError,'Bad character in section name: %s'%c
        else:
            section=''

            while c.isalnum():
                section+=c
                loc=f.tell()
                c=f.read(1)

            if c.isspace():
                loc,c=skip_ws(f)

            if c <> '{':
                raise IOError, 'Parsing configuration file: expected \'{\', got \'%s\''%c

            read_section(section)
            loc,c=skip_ws(f)

    return rval

# Inverse of the above.  Assumes its input is in the correct
# format. (a dictionary of dictionaries, with appropriate keys)
def write_config_file(f, cfg, writer=serialize.Writer()):
    sections=cfg.items()
    sections.sort(lambda a,b:cmp(a[0],b[0]))

    for section,optionsdict in sections:
        f.write('%s {\n'%section)

        options=optionsdict.items()
        options.sort(lambda a,b:cmp(a[0], b[0]))

        for name, val in options:
            f.write('  %s = '%name)

            writer.write(f, val, 5+len(name))

            f.write('\n')

        f.write('}\n')
