from typing import Any
from werkzeug.exceptions import HTTPException

def parse_converter_args(argstr): ...
def parse_rule(rule): ...

class RoutingException(Exception): ...

class RequestRedirect(HTTPException, RoutingException):
    code = ...  # type: Any
    new_url = ...  # type: Any
    def __init__(self, new_url): ...
    def get_response(self, environ): ...

class RequestSlash(RoutingException): ...

class RequestAliasRedirect(RoutingException):
    matched_values = ...  # type: Any
    def __init__(self, matched_values): ...

class BuildError(RoutingException, LookupError):
    endpoint = ...  # type: Any
    values = ...  # type: Any
    method = ...  # type: Any
    suggested = ...  # type: Any
    def __init__(self, endpoint, values, method, adapter=None): ...
    def closest_rule(self, adapter): ...

class ValidationError(ValueError): ...

class RuleFactory:
    def get_rules(self, map): ...

class Subdomain(RuleFactory):
    subdomain = ...  # type: Any
    rules = ...  # type: Any
    def __init__(self, subdomain, rules): ...
    def get_rules(self, map): ...

class Submount(RuleFactory):
    path = ...  # type: Any
    rules = ...  # type: Any
    def __init__(self, path, rules): ...
    def get_rules(self, map): ...

class EndpointPrefix(RuleFactory):
    prefix = ...  # type: Any
    rules = ...  # type: Any
    def __init__(self, prefix, rules): ...
    def get_rules(self, map): ...

class RuleTemplate:
    rules = ...  # type: Any
    def __init__(self, rules): ...
    def __call__(self, *args, **kwargs): ...

class RuleTemplateFactory(RuleFactory):
    rules = ...  # type: Any
    context = ...  # type: Any
    def __init__(self, rules, context): ...
    def get_rules(self, map): ...

class Rule(RuleFactory):
    rule = ...  # type: Any
    is_leaf = ...  # type: Any
    map = ...  # type: Any
    strict_slashes = ...  # type: Any
    subdomain = ...  # type: Any
    host = ...  # type: Any
    defaults = ...  # type: Any
    build_only = ...  # type: Any
    alias = ...  # type: Any
    methods = ...  # type: Any
    endpoint = ...  # type: Any
    redirect_to = ...  # type: Any
    arguments = ...  # type: Any
    def __init__(self, string, defaults=None, subdomain=None, methods=None, build_only=False, endpoint=None, strict_slashes=None, redirect_to=None, alias=False, host=None): ...
    def empty(self): ...
    def get_empty_kwargs(self): ...
    def get_rules(self, map): ...
    def refresh(self): ...
    def bind(self, map, rebind=False): ...
    def get_converter(self, variable_name, converter_name, args, kwargs): ...
    def compile(self): ...
    def match(self, path): ...
    def build(self, values, append_unknown=True): ...
    def provides_defaults_for(self, rule): ...
    def suitable_for(self, values, method=None): ...
    def match_compare_key(self): ...
    def build_compare_key(self): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...

class BaseConverter:
    regex = ...  # type: Any
    weight = ...  # type: Any
    map = ...  # type: Any
    def __init__(self, map): ...
    def to_python(self, value): ...
    def to_url(self, value): ...

class UnicodeConverter(BaseConverter):
    regex = ...  # type: Any
    def __init__(self, map, minlength=1, maxlength=None, length=None): ...

class AnyConverter(BaseConverter):
    regex = ...  # type: Any
    def __init__(self, map, *items): ...

class PathConverter(BaseConverter):
    regex = ...  # type: Any
    weight = ...  # type: Any

class NumberConverter(BaseConverter):
    weight = ...  # type: Any
    fixed_digits = ...  # type: Any
    min = ...  # type: Any
    max = ...  # type: Any
    def __init__(self, map, fixed_digits=0, min=None, max=None): ...
    def to_python(self, value): ...
    def to_url(self, value): ...

class IntegerConverter(NumberConverter):
    regex = ...  # type: Any
    num_convert = ...  # type: Any

class FloatConverter(NumberConverter):
    regex = ...  # type: Any
    num_convert = ...  # type: Any
    def __init__(self, map, min=None, max=None): ...

class UUIDConverter(BaseConverter):
    regex = ...  # type: Any
    def to_python(self, value): ...
    def to_url(self, value): ...

DEFAULT_CONVERTERS = ...  # type: Any

class Map:
    default_converters = ...  # type: Any
    default_subdomain = ...  # type: Any
    charset = ...  # type: Any
    encoding_errors = ...  # type: Any
    strict_slashes = ...  # type: Any
    redirect_defaults = ...  # type: Any
    host_matching = ...  # type: Any
    converters = ...  # type: Any
    sort_parameters = ...  # type: Any
    sort_key = ...  # type: Any
    def __init__(self, rules=None, default_subdomain='', charset='', strict_slashes=True, redirect_defaults=True, converters=None, sort_parameters=False, sort_key=None, encoding_errors='', host_matching=False): ...
    def is_endpoint_expecting(self, endpoint, *arguments): ...
    def iter_rules(self, endpoint=None): ...
    def add(self, rulefactory): ...
    def bind(self, server_name, script_name=None, subdomain=None, url_scheme='', default_method='', path_info=None, query_args=None): ...
    def bind_to_environ(self, environ, server_name=None, subdomain=None): ...
    def update(self): ...

class MapAdapter:
    map = ...  # type: Any
    server_name = ...  # type: Any
    script_name = ...  # type: Any
    subdomain = ...  # type: Any
    url_scheme = ...  # type: Any
    path_info = ...  # type: Any
    default_method = ...  # type: Any
    query_args = ...  # type: Any
    def __init__(self, map, server_name, script_name, subdomain, url_scheme, path_info, default_method, query_args=None): ...
    def dispatch(self, view_func, path_info=None, method=None, catch_http_exceptions=False): ...
    def match(self, path_info=None, method=None, return_rule=False, query_args=None): ...
    def test(self, path_info=None, method=None): ...
    def allowed_methods(self, path_info=None): ...
    def get_host(self, domain_part): ...
    def get_default_redirect(self, rule, method, values, query_args): ...
    def encode_query_args(self, query_args): ...
    def make_redirect_url(self, path_info, query_args=None, domain_part=None): ...
    def make_alias_redirect_url(self, path, endpoint, values, method, query_args): ...
    def build(self, endpoint, values=None, method=None, force_external=False, append_unknown=True): ...
