## What does this do?

When copying files, it's common for operating systems to append a numerical increment or the word 'copy' to a file name to prevent the existing file from being overwritten.

This library allows you to do the same thing in your Node.js application, using the correct conventions for the most commonly used [operating systems](#operating-systems). 

## Usage

All methods automatically detect the platform to use, unless `platform` is defined on the [options](#options).

```js
const increment = require('{%= name %}');
```

## API
{%= apidocs("index.js") %}


## Options

### options.fs

**Description**: Check the file system, and automatically increment the file based on existing files. Thus, if the file name is `foo.txt`, and `foo (2).txt` already exists, the file will automatically be renamed to `foo (3).txt`. 

Also uses the correct conventions for Linux, Windows (win32), and MacOS (darwin).

**Type**: `boolean`

**Default**: `undefined`


### options.increment

**Description**: Custom function to handling incrementing a file name. This is mostly useful when `options.fs` is also defined, since this function will only be called if a file name needs to be incremented, allowing you to control how incrementing is done.

**Type**: `function`

**Default**: `undefined`


### options.platform

**Description**: Specify the platform conventions to use. 

**Type**: `string`

**Default**: Uses `process.platform`. Valid values are `linux`, `win32`, and `darwin`.


## Operating Systems

- [Linux](#linux)
- [MacOS](#macos)
- [Windows](#windows)

**Supported Operating Systems**

Currently Windows, Darwin (MacOS), and Linux are supported. This library attempts to automatically use the correct conventions for each operating system. Please [create an issue](../../issues/new) if you ecounter a bug.

If you use an operating system with different conventions, and you would like for this library to add support, please [create an issue](../../issues/new) with a detailed description of those conventions, or feel free to do a [pull request](.github/contributing.md).

### Linux

When a file is copied or moved, and the destination file path already exists, Linux uses the following conventions for incrementing the file name.

| **Source path** | **Destination path** | **Type** | **Directory<sup>1</sup>** |
| --- | --- | --- | --- |
| `foo.txt` | `foo (copy).txt`, `foo (another copy).txt`, `foo (3rd copy).txt`, ... | file | Same directory as source |
| `foo` | `foo (copy)`, `foo (another copy)`, `foo (3rd copy)`, ... | directory | Same directory as source |

<small><sup>1</sup> _On Linux, when a file or folder is copied or moved to a different directory and another file or folder with the same name exists in that directory, you are prompted to choose a new name for the file or folder, or to cancel or skip the operation._ </small>

### MacOS

When a file is copied or moved, and the destination file path already exists, MacOS uses the following conventions for incrementing the file name.

| **Source path** | **Destination path** | **Type** | **Directory<sup>1</sup>** |
| --- | --- | --- | --- |
| `foo.txt` | `foo copy.txt`, `foo copy 2.txt`, ... | file | Same directory as source |
| `foo.txt` | `foo 2.txt`, `foo 3.txt`, ... | file | Different directory than source |
| `foo` | `foo copy`, `foo copy 2`, ... | directory | Same directory as source |

<small><sup>1</sup> _MacOS uses different conventions for incrementing file names when the source file is copied, moved or renamed to a different directory, versus when the file is copied into the same directory._ </small>

### Windows

When a file is copied or moved, and the destination file path already exists, Windows uses the following conventions for incrementing the file name.

| **Source path** | **Destination path** | **Type** | **Directory<sup>1</sup>** |
| --- | --- | --- | --- |
| `foo.txt` | `foo - Copy.txt` | file | Same directory as source |
| `foo.txt` | `foo (2).txt` | file | Different directory than source |
| `foo (2).txt` | `foo (3).txt` | file | Different directory than source |
| `foo` | `foo - Copy` | directory | Same directory as source |
| `foo - Copy` | `foo - Copy (2)` | directory | Same directory as source |

<small><sup>1</sup> _Windows uses different conventions for incrementing file names when the source file is copied, moved or renamed to a different directory, versus when the file is copied into the same directory. Also, when a folder is copied to a new directory, and the new directory already has a folder with the same name, Windows just merges the folders automatically._ </small>
