#!/usr/bin/perl

#!#############################################################################
#!#             Copyright (c) 2022, Achim Hoffmann
#!#----------------------------------------------------------------------------
#!# If this tool is valuable for you and we meet some day,  you can spend me an
#!# O-Saft. I'll accept good wine or beer too :-). Meanwhile -- 'til we meet --
#!# your're encouraged to make a donation to any needy child you see.   Thanks!
#!#----------------------------------------------------------------------------
#!# This software is provided "as is", without warranty of any kind, express or
#!# implied,  including  but not limited to  the warranties of merchantability,
#!# fitness for a particular purpose.  In no event shall the  copyright holders
#!# or authors be liable for any claim, damages or other liability.
#!# This software is distributed in the hope that it will be useful.
#!#
#!# This  software is licensed under GPLv2.
#!#
#!# GPL - The GNU General Public License, version 2
#!#                       as specified in:  http://www.gnu.org/licenses/gpl-2.0
#!#      or a copy of it https://github.com/OWASP/O-Saft/blob/master/LICENSE.md
#!# Permits anyone the right to use and modify the software without limitations
#!# as long as proper  credits are given  and the original  and modified source
#!# code are included. Requires  that the final product, software derivate from
#!# the original  source or any  software  utilizing a GPL  component, such  as
#!# this, is also licensed under the same GPL license.
#!#############################################################################

#!# WARNING:
#!# This is no "academically" certified code,  but written to be understood and
#!# modified by humans (you:) easily.  Please see the documentation  in section
#!# "Program Code"  (file coding.txt) if you want to improve the program.

# NOTE: Perl's  `use' and `require' will be used for common and well known Perl
#       modules only. All other modules, in particular our own ones, are loaded
#       using an internal function, see _load_file().  All required modules are
#       included as needed. This keeps away noisy messages and allows to be run
#       and print some information even if installed incompletely.

## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
#  NOTE: SEE Perl:binmode()

## no critic qw(Variables::RequireLocalizedPunctuationVars)
#  NOTE: Perl::Critic seems to be buggy as it does not honor the  allow  option
#        for this policy (see  .perlcriticrc  also).  It even doesn't honor the
#        setting here, hence it's disabled at each line using  $ENV{} = ...

## no critic qw(Variables::ProhibitPackageVars)
#  NOTE: we have a couple of global variables, but do not want to write them in
#        all CAPS (as it would be required by Perl::Critic)

## no critic qw(ErrorHandling::RequireCarping)
#  NOTE: Using carp() is nice in modules,  as it also prints the calling stack.
#        But here it is sufficient to see the line number, hence we use warn().

## no critic qw(Subroutines::ProhibitExcessComplexity)
#  NOTE: It's the nature of checks to be complex, hence don't complain.

## no critic qw(Modules::ProhibitExcessMainComplexity)
#  NOTE: Yes, it's a high, very high complexity here.
#       BUG: this pragma does not work here, needs mccabe value ...


use warnings;

our $SID_main   = "@(#) yeast.pl 2.51 22/11/16 10:06:25"; # version of this file
my  $VERSION    = _VERSION();           ## no critic qw(ValuesAndExpressions::RequireConstantVersion)
    # SEE Perl:constant
    # see _VERSION() below for our official version number
use autouse 'Data::Dumper' => qw(Dumper);
#use Encode;    # see _load_modules()

sub _set_binmode    {
    # set discipline for I/O operations (STDOUT, STDERR)
    # SEE Perl:binmode()
    my $layer = shift;
    binmode(STDOUT, $layer);
    binmode(STDERR, $layer);
    return;
} # _set_binmode
_set_binmode(":unix:utf8"); # set I/O layers very early

sub _is_argv    { my $rex = shift; return (grep{/$rex/i} @ARGV); }  # SEE Note:ARGV
    # return 1 if value in command-line arguments @ARGV
sub _is_v_trace { my $rex = shift; return (grep{/--(?:v|trace(?:=\d*)?$)/} @ARGV); }  # case-sensitive! SEE Note:ARGV
    # need to check @ARGV directly as this is called before any options are parsed

# SEE Make:OSAFT_MAKE (in Makefile.pod)
our $time0  = time();   # must be set very early, cannot be done in osaft.pm
    $time0 += ($time0 % 2) if (defined $ENV{'OSAFT_MAKE'});
    # normalise to even seconds, allows small time diffs
sub _yeast_TIME(@)  {
    # print timestamp if --trace-time was given; similar to _y_CMD
    my @txt = @_;
    return if (_is_argv('(?:--trace.?(?:time|cmd))') <= 0);
    my $me  = $0; $me =~ s{.*?([^/\\]+)$}{$1};
    my $now = time();
       $now = time() - ($time0 || 0) if not _is_argv('(?:--time.*absolut)');
       $now +=1 if (0 > $now);  # fix runtime error: $now == -1
       $now += ($now % 2) if (defined $ENV{'OSAFT_MAKE'});
       $now = sprintf("%02s:%02s:%02s", (localtime($now))[2,1,0]);


    if (defined $ENV{'OSAFT_MAKE'}) {   # SEE Make:OSAFT_MAKE (in Makefile.pod)
       $now = "HH:MM:SS (OSAFT_MAKE exists)" if (not $time0);# time0 unset or 0
    }
    printf("#$me %s CMD: %s\n", $now, @txt);
    return;
} # _yeast_TIME
sub _yeast_EXIT($)  {
    # exit if parameter matches given argument in @ARGV
    my $txt =  shift;   # example: INIT0 - initialisation start
    my $arg =  $txt;
       $arg =~ s# .*##; # strip off anything right of a space
    if ((grep{/(?:([+,]|--)$arg).*/i} @ARGV) > 0) { # case-sensitve, cannot use _is_argv()
        printf STDERR ("#o-saft.pl  _yeast_EXIT $txt\n");
        exit 0;
    }
    return;
} # _yeast_EXIT
sub _yeast_NEXT($)  {
    # return 1 if parameter matches given argument in @ARGV; 0 otherwise
    my $txt =  shift;   # example: INIT0 - initialisation start
    my $arg =  $txt;
       $arg =~ s# .*##; # strip off anything right of a space
    if ((grep{/(?:([+,]|--)$arg).*/i} @ARGV) > 0) { # case-sensitve, cannot use _is_argv()
        printf STDERR ("#o-saft.pl  _yeast_EXIT $txt\n");
        return 1;
    }
    return 0;
} # _yeast_NEXT
sub _version_exit   { print _VERSION() . "\n"; exit 0; }
    # print VERSION and exit

#$DB::single=1;          # for debugging; start with: PERL5OPT='-dt' $0

BEGIN {
    # SEE Perl:BEGIN
    # SEE Perl:BEGIN perlcritic
    _yeast_TIME("BEGIN{");
    _yeast_EXIT("exit=BEGIN0 - BEGIN start");
    sub _VERSION { return "22.11.22"; } # <== our official version number
        # get official version (used for --help=* and in private modules)
    my $_me   = $0;     $_me   =~ s#.*[/\\]##;
    my $_path = $0;     $_path =~ s#[/\\][^/\\]*$##;
    my $_pwd  = $ENV{PWD} || ".";   # . as fallback if $ENV{PWD} not defined
    # SEE Perl:@INC
    #unshift(@INC, "..")     if (1 > (grep{/^\.\.$/}   @INC));
    unshift(@INC, "bin")    if (1 > (grep{/^bin$/}    @INC));
    unshift(@INC, "lib")    if (1 > (grep{/^lib$/}    @INC));
    unshift(@INC, $_path)   if (1 > (grep{/^$_path$/} @INC));
    unshift(@INC, $_pwd)    if (1 > (grep{/^$_pwd$/}  @INC));
    unshift(@INC, ".")      if (1 > (grep{/^\.$/}     @INC));
    # handle simple help very quickly; _is_argv() cannot be used because upper case
    if ((grep{/(?:[+]|,|--)VERSION/} @ARGV) > 0) { _version_exit(); }
    # be smart to users if systems behave strange :-/
    print STDERR "**WARNING: 019: on $^O additional option  --v  required, sometimes ...\n" if ($^O =~ m/MSWin32/);
    _yeast_EXIT("exit=BEGIN1 - BEGIN end");
} # BEGIN
_yeast_TIME("BEGIN}");          # missing for +VERSION, however, +VERSION --trace-TIME makes no sense
_yeast_EXIT("exit=INIT0 - initialisation start");

$::osaft_standalone = 0;        # SEE Note:Stand-alone

## PACKAGES         # dummy comment used by some generators, do not remove
#!/usr/bin/perldoc
#?
# Generated by o-saft.pl .
# Unfortunately the format in  @help is incomplete,  for example proper  =over
# and corresponding =back  paragraph is missing. It is mandatory around  =item
# paragraphs. However, to avoid tools complaining about that,  =over and =back
# are added to each  =item  to avoid error messages in the viewer tools.
# Hence the additional identations for text following the =item are missing.
# Tested viewers: podviewer, perldoc, pod2usage, tkpod

=pod

=encoding utf8


=head1 _____________________________________________________________________________

=head1 NAME

O-Saft - OWASP SSL advanced forensic tool
    OWASP SSL audit for testers

=head1 SYNOPSIS

	o-saft.pl [COMMANDS ..] [OPTIONS ..] target [target target ...]

where  [COMMANDS]  and  [OPTIONS]  are described below  and target is
a hostname either as full qualified domain name or an IP address.
Multiple commands and targets may be combined.

All  commands  and  options  can also be specified in a  rc-file, see
L</RC-FILE>  below.

I.g. all commands start with a  C<+>  character and options start with
C<->  or  C<-->  characters. Anything else is treated as target name.

=head1 DESCRIPTION

This tool lists  information  about remote target's  SSL certificate,
and tests the remote target according given list of ciphers.

Note:  Throughout this description  C<$0>  is used as an alias for the
program name  C<o-saft.pl>.

=head1 QUICKSTART

Before going into  a detailed description  of the  purpose and usage,
here are some examples of the most common use cases:

=over

=item * Show supported (enabled) ciphers of target:

=back

	o-saft.pl +cipher --enabled example.tld

=over

=item * Show supported (enabled) ciphers with their DH parameters:

=back

	o-saft.pl +cipher-dh example.tld

=over

=item * Show details of certificate and connection of target:

=back

	o-saft.pl +info example.tld

=over

=item * Check certificate, ciphers and SSL connection of target:

=back

	o-saft.pl +check example.tld

=over

=item * Check connection to target for vulnerabilities:

=back

	o-saft.pl +vulns example.tld

=over

=item * Check for all known ciphers (independant of SSL library):

=back

	checkAllCiphers.pl example.tld
	checkAllCiphers.pl example.tld --range=full --v

=over

=item * Get the certificate's Common Name for a bunch of servers:

=back

	o-saft.pl +cn example.tld some.tld other.tld

=over

=item * List more usage examples

=back

	o-saft.pl --help=examples

=over

=item * List all available commands:

=back

	o-saft.pl --help=commands

=over

=item * Get table of contents for complete help

=back

	o-saft.pl --help=toc

=over

=item * Show just one section, for example SECURITY, from help

=back

	o-saft.pl --help=SECURITY

=over

=item * Show all  --help=*  commands

=back

	o-saft.pl --help=HELP

=over

=item * Search for text in O-Saft's help and show with context

=back

o-saft --help=your-text

=over

=item * Start the simple GUI

=back

	o-saft.tcl 

=over

=item * Start the simple GUI which uses o-saft.pl in a Docker image

=back

	o-saft.tcl --docker

For more specialised test cases, refer to the sections  L</COMMANDS>  and
L</OPTIONS>  below. For more examples please refer to  L</EXAMPLES>  section.

For more details, please see  L</Requirements>  and  L</INSTALLATION>  below.

=head1 WHY?

Why a new tool for checking SSL security and configuration when there
are already a dozen or more such good tools in existence (in 2012)?

Unique features:

=over

=item * working in closed environments, i.e. without internet connection

=back

=over

=item * checking availability of ciphers independent of installed library

=back

=over

=item * checking for all possible ciphers (up to 65535 per SSL protocol)

=back

=over

=item * mainly same results on all platforms.

=back

Currently available tools suffer from some or all of following issues:

=over

=item * lack of tests of unusual SSL certificate configurations

=back

=over

=item * may return different results for the same checks on given target

=back

=over

=item * missing tests for modern SSL/TLS functionality

=back

=over

=item * missing tests for specific, known SSL/TLS vulnerabilities

=back

=over

=item * no support for newer, advanced, features e.g. CRL, OCSP, EV

=back

=over

=item * limited capability to create your own customised tests

=back

Other  reasons or problems  are that other tools are either binary or
use additional binaries and hence are not portable to other platforms.

In contrast to (all?) most other tools, including L<openssl(1)|openssl(1)>, it can
be used to "ask simple questions" like "does target support STS" just
by calling:

	o-saft.pl +hsts_sts example.tld

For more, please see  L</EXAMPLES>  section below.
If it should run on systems with old software (perl or Perl modules),
please see  L</DEBUG>  section below.

=head1 SECURITY

This tool is designed to be used by people doing security or forensic
analyses. Hence no malicious input is expected.

There are no special security checks implemented. Some parameters are
roughly sanitised according unwanted characters.  In particular there
are no checks according any kind of code injection.

Care should be taken, when additional tools and modules are installed
as described in  L</INSTALLATION>  below. In particular it is recommended
to do these installations into directoies  specially prepared for use
with  o-saft.pl .
No other tools of your system  should use  these additional installed
tools, for example by accident or because environment variables point
to them.

Note that compilation and installation of  additional tools (openssl,
Net::SSLeay, etc.) uses known insecure configurations and features!
This is essential to make  o-saft.pl  able to check for such insecurities.

It is  highly recommended to do these installations and use the tools
on a separate testing system.

B<DO NOT USE THESE INSTALLATIONS ON PRODUCTIVE SYSTEMS.>

=head1 CONCEPTS

The purpose of  O-Saft  is to do the work,  not to force the user  to
learn a new tool or to install "newer" software first.
However, the user "should do something" if necessary depending on the
reported results.

Developers may read more details on the concept in  docs/concepts.txt

=head2 This help text

The sequence of the sections in the help text doesn't strictly follow
the common guidlines for UNIX-style man pages.  This is because it is
important to understand the concepts of the tool and what options and
commands are in context of the tool. In particular the  L</DESCRIPTION>  
section contains only a very brief description. The  L</OPTIONS>  section
follows the  L</COMMANDS>  section.

=head2 Results

Results of checks are marked  C<yes>  or C<no>.  This leaves the proper
interpretation, if the result is "good" or "bad", to the user.
Background:  it is not always possible to rate a result as  "good" or
"bad" or "insecure" or whatever. That's why  O-Saft  can not give the
"the best" or "proper" recommendation.  In practice it depends on the
context what a recommendation or countermeasure should be. That's why
results are marked  C<yes>  or  C<no>  if considered "questionable", or
"not good" (for example according other checks).

For more details please see  L</RESULTS>  below.

=head1 TECHNICAL INFORMATION

It is important to understand, which provided information is based on
data returned by underlaying (used) libraries and the information
computed directly.

=head2 Version 19.11.19 and later

Starting with version 19.11.19 the  I<+cipher>  command does not use any
external library. Checking for ciphers is done using plain Perl code.
Only other collected SSL/TLS related information requires an external
library, in general libssl.
The description about OpenSSL and libssl below applies only if any of
the options  I<--ciphermode=openssl>  or  I<--ciphermode=ssleay>  are given
with the  I<+cipher>  command.

Therefore following commands and options changed:

=over

=item * +cipher     uses internal method

=back

=over

=item * +cipherall  command obsolete, !!Hint is printed

=back

=over

=item * +cipherraw  command obsolete, !!Hint is printed

=back

=over

=item * --openssl-ciphers  --force-openssl  changed to  --ciphermode=openssl

=back

=over

=item * --openssl=TOOL  TOOL only used for  +cipher  --ciphermode=openssl

=back

=over

=item * --legacy=owasp  option obsolete

=back

The historic commands  I<+cipherall>  and  I<+cipherraw> should be replaced
with the new syntax, as follows:

	VERSION < 19.11.19           VERSION > 19.11.19
#----------------------------+---------------------------------

=over

=item * +cipher                      +cipher  --ciphermode=ssleay

=back

=over

=item * +cipher  --force-openssl     +cipher  --ciphermode=openssl

=back

=over

=item * +cipherall                   +cipher

=back

=over

=item * +cipherraw                   +cipher  --ciphermode=intern

=back

#----------------------------+---------------------------------

=head2 Version before 19.11.19

Up to version 19.11.19 the default behaviour for the  I<+cipher> command
was to use libssl. The commands  I<+cipherall>  and  I<+cipherraw>  did not
use any other library as described below.

=head2 OpenSSL, libssl, libcrypto

In general the tool uses Perl's L<Net::SSLeay(3pm)|Net::SSLeay(3pm)> module which itself
is based on libssl and/or libssleay library of the operating system.
It's possible to use other versions of these libraries, see options:

=over

=item * --exe-path=PATH  --exe=PATH

=back

=over

=item * --lib-path=PATH  --lib=PATH

=back

=over

=item * --envlibvar=NAME

=back

The external L<openssl(1)|openssl(1)> is called to extract  some information from
its output. The version of  openssl  can be controlled with following
options:

=over

=item * --openssl=TOOL

=back

=over

=item * --no-openssl

=back

=over

=item * --openssl-ciphers   --force-openssl

=back

=over

=item * --exe-path=PATH     --exe=PATH

=back

=over

=item * --openssl-cnf=PATH

=back

=over

=item * --openssl-s_client  --s_client

=back

OpenSSL is recommended to be used for libssl and libcrypto.  Versions
0.9.8k to 1.0.2e (Jan. 2016) are known to work. However, versions be-
for 1.0.0 may not provide all information.
Some functionality (checks) of  O-Saft  may be missing or fail,  when
openssl versions 1.1.x are used (because functionality was removed).
LibreSSL  is not recommended, because  some functionality  considered
insecure, has been removed.
For more details, please see  L</INSTALLATION>  below.

=head2 Certificates and CA

All checks according the validity of the certificate chain  are based
on the root CAs installed on the system.  Note that L<Net::SSLeay(3pm)|Net::SSLeay(3pm)>
and L<openssl(1)|openssl(1)> may have their own rules where to find the root CAs.
Please refer to the documentation on your system for these tools.
However, there are folloing options to tweak these rules:

=over

=item * --ca-file=FILE

=back

=over

=item * --ca-path=DIR

=back

=over

=item * --ca-depth=INT

=back

=head2 Commands and options

All arguments  starting with  C<+>  are considered  L</COMMANDS>  for this
tool. All arguments starting with  C<-->  are considered  L</OPTIONS>  for
this tool.

Reading any data from STDIN or here-documents is not yet supported.
It's reserved for future use.

=head2 Environment variables

Please see  L</ENVIRONMENT>  .

=head2 Requirements

For  I<+info>  and  I<+check>  (and all related) commands,  perl (5.x) with
following modules (minimal version) is recommended:

=over

=item * IO               1.25 (2011)

=back

=over

=item * IO::Socket::INET 1.37 (2011)

=back

=over

=item * IO::Socket::SSL  1.90 (2013)

=back

=over

=item * Net::DNS         0.66 (2011)

=back

=over

=item * Net::SSLeay      1.49 (2012)

=back

However, it is recommended to use the most recent version of the mod-
ules which then gives more accurate results and less warnings. If the
modules are missing, they can be installed for example with:

	cpan Net::SSLeay

Note: if you want to use advanced features of openssl or Net::SSLeay,
please see  L</INSTALLATION> section how to compile and install the tools
fully customised. Requirements for  openssl  are described there.

Also an openssl executable should be available, but is not mandatory.

For checking DH parameters of ciphers, openssl 1.0.2  or newer should
be available. If an older version of openssl is found, we try hard to
extract the  DH parameters  from the data returned by the server, see
I<+cipher-dh>  command.

If you need to run on systems with older perl or Perl module versions
please refer to the  L</DEBUG>  section for more information.

=head2 External tools

For building and/or viewing the documentation, any of following tools
should be available:

=over

=item * aha              0.5-1

=back

=over

=item * perldoc          v3.2801

=back

=over

=item * pod2man

=back

=over

=item * pod2usage

=back

=over

=item * podviewer        v0.18

=back

=over

=item * tkpod

=back

=over

=item * tput

=back

=over

=item * stty

=back

=head1 COMMANDS

There are commands for various tests according the  SSL connection to
the target, the targets certificate and the used ciphers.

All commands are preceded by a  C<+>  to easily distinguish from other
arguments and options. However, some I<--OPTIONS> options are treated as
commands for historical reason or compatibility to other programs.

The most important commands are (in alphabetical order):
I<+check> I<+cipher> I<+info> I<+http> I<+list> I<+quick> I<+sni> I<+sni_check> I<+version>

A list of all available commands will be printed with:

	o-saft.pl --help=cmds

The description of all other commands will be printed with:

	o-saft.pl --header --help=commands

The summary and internal commands return requested information or the
results of checks. These are described below.

Note that some commands may be a combination of other commands, see:

	o-saft.pl --header --help=intern

The following sub-sections only describe the commands,  which do more
than giving a simple information from the target.  All other commands
can be listed with:

	o-saft.pl --header --help=commands

The final sub-sections  L</Notes about commands>  describes some notes
about special commands and related commands.

=head2 Commands for information about this tool

All these commands will exit after execution (cannot be used together
with other commands).

=head3 +ciphers

Show known ciphers in format like "openssl ciphers".
It also accepts the  -v  and  -V  option.
Use  I<+list>  command for more information according ciphers.

=head3 +list

Show all ciphers supported by this tool. This includes cryptogrphic
details of the cipher and some internal details.

Different output formats are used for the  I<--legacy=*>  option:

=over

=item * --legacy=simple   simple space-separated output

=back

=over

=item * --legacy=full     TAB-separated output with more data

=back

=over

=item * --legacy=owasp    simple output sorted according OWASP scoring

=back

=over

=item * --legacy=openssl  output like with  +ciphers  command

=back

=over

=item * --legacy=ssltest  output like "ssltest --list"

=back

=head3 +VERSION

Just show version and exit.

=head3 +version

Show version information for both the program and the  Perl modules
that it uses, then exit.

Use  I<--v>  option to show more details.

=head3 +libversion

Show version of openssl.

=head3 +quit

Show internal data and exit, used for testing and debugging only.
Please see  L</TESTING>  below.

=head2 Commands to check SSL details

Following (summary and internal) commands are simply a shortcut for a
list of other commands. For details of the list use:

	o-saft.pl --help=intern

=head3 +check

Check the SSL connection for security issues. Implies  I<+cipher> .

=head3 +host

Print details about the targets hostname, DNS, etc.
These details are usually printed only for the  I<+check>  and  I<+info>
command, but not for any individual command.

=head3 +http

Perform HTTP checks (like STS, redirects etc.).

=head3 +info

Overview of most important details of the SSL connection.

Use  I<--v>  option to show details also, which span multiple lines.

=head3 +info--v

Overview of all details of the SSL connection. It is a shortcut for
all commands listed below but not including  I<+cipher>.

This command is intended for debugging as it prints some details of
the used L<Net::SSLinfo|Net::SSLinfo> module.

=head3 +quick

Quick overview of checks. Implies  I<--enabled>  and  I<--label=short>.

=head3 +pfs

Check if servers offers ciphers with prefect forward secrecy (PFS).

=head3 +protocols

Check for protocols supported by target.

=head3 +vulns

Check for various vulnerabilities.

=head3 +sts

=head3 +hsts

Various checks according STS HTTP header.
This option implies  I<--http>,  means that  I<--no-http> is ignored.

=head3 +sni

Check for Server Name Indication (SNI) usage.

=head3 +sni_check

=head3 +check_sni

Check for Server Name Indication (SNI) usage  and  validity  of all
names (CN, subjectAltName, FQDN, etc.).

=head3 +bsi

Various checks according BSI TR-02102-2 and TR-03116-4 compliance.

=head3 +ev

Various checks according certificate's extended Validation (EV).

Hint: use option  I<--v>  I<--v>  to get information about failed checks.

=head3 +sizes

Check length, size and count of some values in the certificate.

=head3 +s_client

Dump data retrieved from  "openssl s_client ..."  call. This should
be used for debugging only.
It can be used just like openssl itself, for example:

	openssl s_client -connect host:443 -no_sslv2

=head3 +dump

Dumps internal data for SSL connection and target certificate. This
is mainly for debugging and  should not be used together with other
commands (except  I<+cipher>).
Each key-value pair is enclosed in  C<#{>  and  C<#}> .

Using  I<--trace>  I<--trace>  dumps data of L<Net::SSLinfo|Net::SSLinfo> too.

=head3 +exec

Command used internally when requested to use other libraries.
This command should not be used directly.

=head2 Commands to test ciphers provided by target

Beside the description of the commands itself here, please see also
L</Notes about commands>  below.

=head3 +cipher

Check target for ciphers,  either all ciphers, or ciphers specified
with  I<--cipher=CIPHER>  option.

Use  I<--v>  option to see all ciphers being checked.

=head3 +cipher-default

Lists the cipher selected by the server for each protocol sometimes
referred to as "default cipher".

For each protocol the two selected ciphers are shown,  one returned
by the server if the cipher list in the  ClientHello is sorted with
the strongest cipher first, and one returned  if the cipher list in
the ClientHello is sorted with strongest cipher last.
See  L</Notes about commands>  for details.

=head3 +cipher-dh

Checked target for ciphers. All ciphers supported by the server are
printed with their DH or ECDH paramaters (if available).
ciphers.

=head3 +null

=head3 +cipher-null

Check if target accepts NULL ciphers.

=head3 +adh

=head3 +cipher-adh

Check if target accepts ciphers with anonymous key exchange.

=head3 +export

=head3 +cipher-exp

Check if target accepts EXPORT ciphers.

=head3 +cbc

=head3 +cipher-cbc

Check if target accepts CBC ciphers.

=head3 +des

=head3 +cipher-des

Check if target accepts DES ciphers.

=head3 +cipher-rc4

Check if target accepts RC4 ciphers.

=head3 +edh

=head3 +cipher-edh

Check if target supports ephemeral ciphers.

=head3 +cipher-pfs

Check if target supports ciphers with PFS.

=head3 +cipher-strong

Check if target selects strongest cipher.

=head3 +cipher-weak

Check if target selects weak cipher (oposite of  I<+cipher-strong>).

=head2 Discrete commands to test SSL connection and certificate details

Discrete commands, please see:

	o-saft.pl --help=commands

=head2 Notes about commands

=head3 +cipher vs. +cipher-dh

While  I<+cipher>  prints checked ciphers,  I<+cipher-dh>  prints ciphers
with their DH or ECDH paramaters (if available)  only for supported
ciphers.

=head3 +cipher vs. +cipher-default

Both commands show the default cipher foreach protocol.

I<+cipher>  lists a summary of ciphers selected by the server for each
protocol requested by the user (for example by using options like:
I<--sslv3>  I<--tlsv1> etc.). When the  I<--v>  option is used, all selected
ciphers for all known protocols are listed. This summary focuses on
counts for various ciphers.

I<+cipher-default>  lists the  cipher selected  by the server for each
protocol.

=head3 +cipher-selected vs. +cipher-default

I<+selected>  lists the cipher selected by the server if no particular
protocol was specified and the system's default cipher list is send
in the ClientHello to the server.

I<+cipher-default>  lists the  cipher selected  by the server for each
protocol.

=head3 +cipher-strong vs. +cipher-default

I<+strong-cipher>  shows the result of the check if strong ciphers are
preferred by the server. It is a check command.

I<+cipher-default>  lists the  cipher selected  by the server for each
protocol. It is a information command.

It is not possible to check if a server uses C<SSLHonorCipherOrder>.
Even if it is used (switched on),  it is not possible to  check the
specified order of the ciphers.

I. g. it is expected that the order is according the cipher suite's
strength, meaning the most strongest first, and the weakest last.
It does not make sense to use an order where a weak cipher preceeds
a stronger one. Such a (mis-)configuration should be detected.

Having this in mind, the algorithm to detect a  proper cipher order
is as simply as follows:
1. pass sorted cipher list with strongest cipher first
2. pass sorted cipher list with strongest cipher last
if the server returns the same cipher for both checks, it's assumed
that it prefers to use the most strongest cipher. In this case it's
obvious that C<SSLHonorCipherOrder> is set (exceptions see below).

Exceptions:
If either, the server or the client,  uses only one cipher suite in
the list, SSLHonorCipherOrder cannot be detected at all.
The same happens, if only one cipher in the client's list matches a
cipher in the server's list.

=head3 +tlsextdebug

=head3 +tlsextensions

=head3 +extensions vs. +tlsextensions

"Certificate extensions" are shown with  I<+extensions>  while the TLS
protocol extensions are shown with  I<+tlsextensions>.
Use  I<+tlsextdebug>  to show more information about the  TLS protocol
extensions.

=head3 +http2 +spdy +spdy3 +spdy31 +spdy4 +prots

These commands are just an alias for the  I<+protocols>  command.

=head3 +wildcard

=head3 +hostname vs. +wildhost vs. +altname vs. +rfc_2818

The commands  I<+cn>  and  I<+altname>  print the  information stored  in
the certificate.
The command  I<+hostname>  checks if the given hostname matches the CN
value in the certificate.  Note that wildcard names in the CN, only
allow to contain one C<*>.
The command  I<+wildcard>  checks if the given hostname does not match
any name specified in the certificate's "subjectAltname". This check
is useful  if the certificate and the configuration  must comply to
RFC 6125 or EV certificates.

=head1 OPTIONS

All options are written in lowercase. Words written in all capital in
the description here is text provided by the user.

=head2 Options for help and documentation

=head3 --h

Brief documentation of  I<--help*>  options/commands.

=head3 --help

Complete user documentation.

=head3 --help*

=head3 --help=cmds

Show available commands; short form.

=head3 --help=commands

Show available commands with short description.

=head3 --help=opt

Show available options; short form.

=head3 --help=options

Show available options with their description.

=head3 --help=checks

Show available checks.

=head3 --help=tools

Description of tools around O-Saft, when, where and how to use.

=head3 --help=cmd

Show additional and user specified commands.

=head3 --help=cfg-cmd

Show additional and user specified commands.  Output can be used in
L</RC-FILE>  or as option.

=head3 --help=check-cfg

=head3 --help=cfg-check

Show texts used as labels in output for checks (see  I<+check>)  ready
for use in  L</RC-FILE>  or as option.

=head3 --help=data

Show available information.

=head3 --help=data-cfg

=head3 --help=cfg-data

=head3 --help=cfg-info

Show texts used  as labels in output for  data  (see  I<+info>)  ready
for use in  L</RC-FILE>  or as option.

=head3 --help=hint

Show texts used in hint messages.

=head3 --help=hint-cfg

=head3 --help=cfg-hint

Show texts used in hint messages ready for use in  L</RC-FILE>  or as
option.

=head3 --help=text

Show texts used in various messages.

=head3 --help=text-cfg

=head3 --help=cfg-text

Show texts used in various messages ready for use in  L</RC-FILE>  or
as option.

=head3 --help=legacy

Show possible legacy formats (used as value in  I<--legacy=TOOL >).

=head3 --help=compliance

Show available compliance checks.

=head3 --help=intern

Show internal commands.

=head3 --help=alias

Show alias for commands and options.

=head3 --help=pattern

Show list of cipher pattern (used for  I<--cipher=CIPHER>).

=head3 --help=range

Show list of cipherranges (see  I<--cipherrange=RANGE>).

=head3 --help=toc

=head3 --help=content

Show headlines from help text. Useful to get an overview.

=head3 --help=SECTION

Show  C<SECTION>  from documentation, see  I<--help=toc>  for a list.
Example:

	o-saft.pl --help=EXAMPLES

=head3 --help=ourstr

Show regular expressions to match our own strings used in output.

=head3 --help=regex

Show regular expressions used internally.

=head3 --help=gen-html

Print documentation in HTML format.

=head3 --help=gen-pod

Print documentation in POD format.

=head3 --help=gen-wiki

Print documentation in mediawiki format.

=head3 --help=gen-cgi

Print HTML form to be used for CGI.

=head3 --help=error

=head3 --help=problem

Show  L</KNOWN PROBLEMS>  section with  description of known  error and
warning messages.

=head3 --help=faq

Show  L</KNOWN PROBLEMS>  and  L</LIMITATIONS>  section.

=head3 --help=glossary

Show common abbreviation used in the world of security.

=head3 --help=links

Show list of URLs related to SSL/TLS.

=head3 --help=rfc

Show list of RFC related to SSL/TLS.

=head3 --help=todo

Show known problems and bugs.

=head3 --help=exit

Show possible  I<--exit=KEY>  options. Used for debugging only.

=head3 --help=warnings

Show warning messages defined in code.

=head3 --help=program.code

For developers.

=head2 Options for all commands (general)

=head3 --dns

Do DNS lookups to map given hostname to IP, do a reverse lookup.

=head3 --no-dns

Do not make DNS lookups.
Note  that the corresponding IP and reverse hostname may be missing
in some messages then.

=head3 --host=HOST

Specify HOST as target to be checked. Legacy option.

=head3 --port=PORT

Specify PORT of target to be used. Legacy option.

=head3 --host=HOST --port=PORT HOST:PORT HOST

When giving more than one HOST argument,  the sequence of the given
HOST argument and the given  I<--port=PORT> and the given  I<--host=HOST>
options are important.
The rule how ports and hosts are mapped is as follows:

=over

=item * HOST:PORT arguments are used as is (connection to HOST on PORT)

=back

=over

=item * only HOST is given, then previous specified PORT is used

=back

Note that URLs are treated as HOST:PORT, if they contain a port.
Example:

	o-saft.pl +cmd host-1 --port 23 host-2 host-3:42 host-4

will connect to:

=over

=item * host-1:443

=back

=over

=item * host-2:23

=back

=over

=item * host-3:42

=back

=over

=item * host-4:23

=back

=head3 --proxyhost=PROXYHOST --proxy=PROXYHOST:PROXYPORT

Make all connection to target using PROXYHOST.

Also possible is: I<--proxy=PROXYUSER:PROXYPASS@PROXYHOST:PROXYPORT>

=head3 --proxyport=PROXYPORT

Make all connection to target using PROXYHOST:PROXYPORT.

=head3 --proxyuser=PROXYUSER

Specify username for proxy authentication.

=head3 --proxypass=PROXYPASS

Specify password for proxy authentication.

=head3 --starttls

Use C<STARTTLS> command to start a TLS connection via SMTP.
This option is a shortcut for  I<--starttls=SMTP> .

=head3 --starttls=SMTP

=head3 --starttls=PROT

Use C<STARTTLS> command to start a TLS connection via protocol.
C<PROT> may be any of:  C<SMTP>, C<IMAP>, C<IMAP2>, C<POP3>, C<FTPS>,
C<RDP>, C<LDAP> or C<XMPP> .

For  I<--starttls=SMTP>  see  I<--dns-mx>  also to use MX records instead
of host

=head3 --starttls-delay=SEC

Number of seconds to wait before sending a packet, to slow down the
C<STARTTLS> requests. Default is 0.
This may prevent blocking of requests by the target due to too much
or too fast connections.
Note:  In this case there is an automatic suspension and retry with
a longer delay.

=head3 --cgi

=head3 --cgi-exec

Internal use for CGI mode only.

=head2 Options for SSL tool

=head3 --rc

Read  L</RC-FILE>  if exists, from directory where program was found.

=head3 --no-rc

Do not read  L</RC-FILE>.

=head3 --exitcode

The exit status code will be greater 0, if any of following applies:

=over

=item * any check returns  C<no>, except if  C<no (<<...>>)>

=back

=over

=item * insecure protocols are available

=back

=over

=item * insecure ciphers are supported

=back

=over

=item * ciphers without PFS are supported, disable with  --exitcode-cipher

=back

In particular, the status code will be the total count of all these
checks. The status code will also be printed at end, like:

	# EXIT 23

Parts of these checks can be diasabled,  see  I<--exitcode-*>  options
below.

Use  I<--v> or  I<--exitcode-v> to see details about the performed checks.

Functionality implemented experimental, may change in future.

=head3 --exitcode-v

Print information about performed checks.

=head3 --exitcode-quiet

Do not print status code at end, like C<# EXIT 23>.

=head3 --exitcode-no-checks

Do not count checks with result C<no> for  I<--exitcode> .

=head3 --exitcode-no-low  --exitcode-no-weak  --exitcode-no-medium

Do not count LOW, WEAK or MEDIUM security ciphers for  I<--exitcode> .

=head3 --exitcode-no-ciphers

Do not count any ciphers for  I<--exitcode> .

=head3 --exitcode-no-pfs

Do not count ciphers without PFS for  I<--exitcode> .

=head3 --openssl-s_client --s_client

Use  "openssl s_slient ..."  call to retrieve more information from
the SSL connection.  This is disabled by default on Windows because
of performance problems. Without this option (default on Windows !)
following information are missing:

	compression, expansion, renegotiation, resumption,
	selfsigned, verify, chain, protocols, DH parameters

See L<Net::SSLinfo|Net::SSLinfo> for details.

If used together with  I<--trace>, s_client  data will also be printed
in debug output of L<Net::SSLinfo|Net::SSLinfo>.

=head3 --no-openssl

Do not use external "openssl"  tool to retrieve information. Use of
"openssl" is disabled by default on Windows.
Note that this results in some missing information, see above.

=head3 --openssl=TOOL

C<TOOL>        can be a path to openssl executable; default: openssl

=head3 --openssl-cnf=FILE --openssl-conf=FILE

C<FILE>        path of directory or full path of openssl.cnf

If set, environment variable OPENSSL_CONF will be set to given path
(or file) when L<openssl(1)|openssl(1)> is started. Please see openssl's man page
for details about specifying alternate  openssl.cnf  files.

=head3 --openssl-ciphers --force-openssl

Use openssl to check for supported ciphers; default: L<IO::Socket(3pm)|IO::Socket(3pm)>

This option forces to use  "openssl s_slient -connect CIPHER .." to
check if a cipher is supported by the remote target. This is useful
if the  I<--lib=PATH>  option doesn't work (for example due to changes
of the API or other incompatibilities).

=head3 --exe-path=PATH

=head3 --exe=PATH

C<PATH>        is a full path where to find openssl.

=head3 --lib-path=PATH

=head3 --lib=PATH

C<PATH>        is a full path where to find libssl.so, libcrypto.so.

See L</HACKER's INFO> below for a detailed description how it works.

=head3 --envlibvar=NAME

C<NAME>  is the name of a environment variable containing additional
paths for searching dynamic shared libraries.
Default is LD_LIBRARY_PATH.

Check your system for the proper name, for example:

	DYLD_LIBRARY_PATH, LIBPATH, RPATH, SHLIB_PATH.

=head3 --ssl-error

The connection to  a target may fail, or even block, due to various
reasons for example lost network at all, blocking at firewall, etc.
In particular when checking ciphers with  I<+cipher> , this may result
in long delays until results are printed.
Using this option stops trying to do more connections to the target
when  I<--ssl-error-max=CNT>  consecutive errors occoured, or when the
total amount of errors increases  I<--ssl-error-total=CNT>.

Note that this may result in loss of information and/or checks.

=head3 --ssl-error-max=CNT

Max. amount of consecutive errors (default: 5).

=head3 --ssl-error-timeout=SEC

Timeout in seconds when a failed connection is treated as error and
then counted (default: 1).

=head3 --ssl-error-total=CNT

Max. total amount of errors (default: 10).

=head3 --ssl-lazy

I.g. this tools tries to identify available functionality according
SSL versions from the underlaying libraries.  Unsupported  versions
are then disables and a warning is shown.
Unfortunately some libraries have  not implemented all functions to
check availability of a specific SSL version, which then results in
a compile error.

This option disables the strict check of availability.
If the underlaying library doesn't support the required SSL version
at all, following error may occour:

	Can't locate auto/Net/SSLeay/CTX_v2_new.al in @INC ...

See L</Note on SSL versions>  for a general note about SSL versions.
A more detailled description of the problem and how Net::SSLeay be-
haves, can be found in the source of  o-saft.pl ,
see section starting at

	#| check for supported SSL versions

=head3 --timeout=SEC

Timeout in seconds when connecting to the target (default: 2).

=head3 --call=METHOD

C<METHOD>      method to be used for specific functionality

Available methods:

=over

=item * C<info-socket>       use internal socket to retrieve information

=back

=over

=item * C<info-openssl>      use external openssl to retrieve information

=back

=over

=item * C<info-user>         use usr_getinfo() to retrieve information

=back

=over

=item * C<cipher-socket>     use internal socket to ckeck for ciphers

=back

=over

=item * C<cipher-openssl>    use external openssl to ckeck for ciphers

=back

=over

=item * C<cipher-user>       use usr_getciphers() to ckeck for ciphers

=back

Method names starting with:

=over

=item * C<info->

=back

are responsible to retrieve information  about the SSL connection
and the target certificate (i.e. what the I<+info> command provides)

=over

=item * C<cipher->

=back

are responsible to connect to the target  and test if it supports
the specified ciphers  (i.e. what the  I<+cipher>  command provides)

=over

=item * C<check->

=back

are responsible for performing the checks (i.e. what's shown with
the  I<+check>  command)

=over

=item * C<score->

=back

are responsible to compute  the score based on check results

The second part of the name denotes which kind of method to call:

=over

=item * C<socket>    the internal functionality with sockets is used

=back

=over

=item * C<openssl>   the exteranl openssl executable is used

=back

=over

=item * C<user>      the external special function, as specified in user's

=back

           o-saft-usr.pm,  is used.

Example:

	--call=cipher-openssl

will use the external L<openssl(1)|openssl(1)> executable to check the target for
supported ciphers.

Default settings are:

	--call=info-socket --call=cipher-socket --call=check-socket

Just for curiosity, instead of using:

	o-saft.pl --call=info-user --call=cipher-user --call=check-user --call=score-user ...

consider to use your own script like:

	#!/usr/bin/env perl
	usr_getinfo();usr_getciphers();usr_checkciphers();usr_score();

:-))

=head3 -v

Print list of ciphers in style like: "openssl ciphers -v".
Option used with  I<+ciphers>  command only.

=head3 -V

Print list of ciphers in style like: "openssl ciphers -V".
Option used with  I<+ciphers>  command only.

=head2 Options for SSL connection to target

=head3 --ciphermode=intern

=head3 --ciphermode=openssl

=head3 --ciphermode=ssleay

=head3 --ciphermode=MODE

Following C<MODE>s are supported:

=over

=item * C<intern>    scan for ciphers using internal method; (default)

=back

=over

=item * C<openssl>   scan for ciphers using external openssl executable

=back

=over

=item * C<ssleay>    scan for ciphers using  IO::Socket  and  Net::SSLeay

=back

=over

=item * C<dump>      same as C<intern> but print  all cipher information,

=back

           useful when postprocessed by contrib/* tools

=head3 --cipher=CIPHER

C<CIPHER> can be any cipher suite name or (internal) hex constant.
If C<CIPHER> does not match a hex key, for example 0x03000035, it is
used as pattern (RegEx) to match cipher suite names. For example:
C<AES256-SHA> matches 23 cipher suites, 
For example C<AES256-SHA> matches 23 ciphers,  while C<AES256-SHA$>
matches 2 ciphers, see:

	OSaft/Ciphers.pm find-names=AES256-SHA
	OSaft/Ciphers.pm find-names=AES256-SHA$

To be sure that exactly one cipher suite matches, use for example:

	--cipher=^AES256-SHA$

When  I<--ciphermode=openssl> or I<--ciphermode=ssleay> is used, C<CIPHER>
can be any string accepted by openssl or a hex constant. Examples:

=over

=item * --cipher=DHE_DSS_WITH_RC4_128_SHA

=back

=over

=item * --cipher=0x03000066

=back

=over

=item * --cipher=66

=back

will be mapped to   C<DHE-DSS-RC4-SHA>

Note: if more than one cipher matches, just one will be selected.

Default is C<ALL:NULL:eNULL:aNULL:LOW> as specified in L<Net::SSLinfo|Net::SSLinfo>.

=head3 --socket-reuse

TCP socket will be reused for  next connection attempt  even if SSL
connection failed.

=head3 --no-socket-reuse

Close TCP socket and then reopen for next connection attempt if SSL
connection failed.

This is useful for some servers which may return an "TLS alert"  if
the connection fails and then fail again on the same socket.

=head3 --ignore-no-connect

A simple check if the target can be connected  will be performed by
default.  If this check fails, the target will be ignored, means no
more requested checks will be done.  As this connection check some-
times fails due to various reasons, the check can be disabled using
this option.

=head3 --no-md5-cipher

Do not use *-MD5 ciphers for other protocols than SSLv2.
This option is only effective with  I<+cipher>  command.

The purpose is to avoid warnings from L<IO::Socket::SSL(3pm)|IO::Socket::SSL(3pm)> like:

	Use of uninitialized value in subroutine entry at lib/IO/Socket/SSL.pm line 430.

which occours with some versions of L<IO::Socket::SSL(3pm)|IO::Socket::SSL(3pm)> when a
*-MD5  ciphers will be used with other protocols than SSLv2.

Note that these ciphers will be checked for SSLv2 only.

=head3 --sslv2

=head3 --sslv3

=head3 --tlsv1

=head3 --tlsv11

=head3 --tlsv12

=head3 --tlsv13

=head3 --dtlsv09

=head3 --dtlsv1

=head3 --dtlsv11

=head3 --dtlsv12

=head3 --dtlsv13

=head3 --SSL, --protocol SSL

=head3 --no-sslv2

=head3 --no-sslv3

=head3 --no-tlsv1

=head3 --no-tlsv11

=head3 --no-tlsv12

=head3 --no-tlsv13

=head3 --no-dtlsv09

=head3 --no-dtlsv1

=head3 --no-dtlsv11

=head3 --no-dtlsv12

=head3 --no-dtlsv13

=head3 --no-SSL

=over

=item * C<SSL>       can be any of:

=back

ssl, ssl2, ssl3, sslv2, sslv3, tls1, tls1, tls11, tls1.1, tls1-1,
tlsv1, tlsv11, tlsv1.1, tlsv1-1 (and similar variants for tlsv1.2).
For example:  I<--tls1>  I<--tlsv1>  I<--tlsv1_1>  are all the same.

(--SSL variants):    Test ciphers for this SSL/TLS version.
(--no-SSL variants): Don't test ciphers for this SSL/TLS version.

=head3 --no-tcp

Shortcut for:
I<--no-sslv2> I<--no-sslv3> I<--no-tlsv1> I<--no-tlsv11> I<--no-tlsv12> I<--no-tlsv13>

=head3 --tcp

Shortcut for:  I<--sslv2> I<--sslv3> I<--tlsv1> I<--tlsv11> I<--tlsv12> I<--tlsv13>

=head3 --no-udp

Shortcut for:
I<--no-dtlsv09> I<--no-dtlsv1> I<--no-dtlsv11> I<--no-dtlsv12> I<--no-dtlsv13>

=head3 --udp

Shortcut for:  I<--dtlsv09> I<--dtlsv1> I<--dtlsv11> I<--dtlsv12> I<--dtlsv13>

=head3 --nullsslv2

This option  forces  to assume that  SSLv2  is enabled  even if the
target does not accept any ciphers.

The target server may accept connections with  SSLv2  but not allow
any cipher. Some checks verify if  SSLv2  is enabled at all,  which
then would result in a failed test.
The default behaviour is to assume that  SSLv2 is not enabled if no
ciphers are accepted.

=head3 --http

Make a HTTP request if cipher is supported.

If used twice debugging will be enabled using  environment variable
C<HTTPS_DEBUG>.

=head3 --no-http

Do not make HTTP request.

=head3 --sni

Make SSL connection in SNI mode.

=head3 --no-sni

Do not make SSL connection in SNI mode (default: SNI mode).

=head3 --sni-toggle

=head3 --toggle-sni

Test with and witout SNI mode.

=head3 --force-sni

Do not check if SNI seems to be supported by L<Net::SSLeay(3pm)|Net::SSLeay(3pm)>.
Older versions of openssl and its libries do not support SNI or the
SNI support is implemented buggy. By default it's checked if SNI is
properly supported. With this option this check can be disabled.

Be warned that this may result in improper results.

=head3 --servername=NAME

=head3 --sni-name=NAME

If SNI mode is active, see  I<--sni>  above, C<NAME> is used instead of
hostname for connections to the target.  If SNI mode is not active,
see  I<--no-sni>  above, C<NAME> is not used. The default is undefined,
which forces to use the given FQDN.

This is useful, for example when an IP instead of a FQDN was given,
where a correct hostname (i.g. a FQDN) needs to be specified.

Note: i.g. there is no need to use this option,  as a correct value
for the SNI name will be choosen automatically (except for IPs).
However, it is kind of fuzzing ... even setting to an  empty string
is possible.

Limitation:  the same C<NAME> is used for all targets,  if more than
one target was specified.

=head3 --no-cert

Do not get data from target's certificate, return empty string.

=head3 --no-cert --no-cert

Do not get data from  target's certificate,  return  default string
of L<Net::SSLinfo|Net::SSLinfo> (see  I<--no-cert-text=TEXT>  option).

=head3 --no-cert-text=TEXT

Set C<TEXT> to be returned from L<Net::SSLinfo|Net::SSLinfo> if no certificate data
is collected due to use of  I<--no-cert>.

=head3 --ca-depth=INT

Check certificate chain to depth C<INT> (like openssl's -verify).

=head3 --ca-file=FILE

Use C<FILE> with bundle of CAs to verify target's certificate chain.

=head3 --ca-path=DIR

Use C<DIR> where to find CA certificates in PEM format.

=head3 --ca-force

=head3 --force-ca

B<NOT YET IMPLEMENTED>
I. g. openssl uses default settings where to find certificate files.
When  I<--ca-file=FILE>  and/or  I<--ca-path=DIR>  was used,  this default
will be overwritten by appropriate options passed to openssl. If the
default does not work as expected,  I<--force-ca>  can be used to force
setting of proper values according well known common defaults. See:

	o-saft.pl +version
	o-saft.pl +version --force-ca

to see the used settings.

=head3 --alpn

Use  -alpn  option for openssl.

=head3 --no-alpn

Do not use  -alpn  option for openssl.

=head3 --no-npn

=head3 --no-nextprotoneg

Do not use  -nextprotoneg  option for openssl.

=head3 --proto-alpn=NAME

Name of protocol to be added to list of  applcation layer protocols
(ALPN), which is used for any connection to the targets.
See  I<--cipher-alpn=NAME>  also.

=head3 --proto-npn=NAME

Name of protocol to be added to list of  next protocol negotiations
(NPN), which is used for any connection to the targets.
See  I<--cipher-npn=NAME>  also.

=head3 --ssl-compression --compression

Use SSL option "compression" for connection.

=head3 --no-ssl-compression --no-compression

Use SSL option "no compression" for connection (default: don't use)

=head3 --no-reconnect

Do not use  -reconnect  option for openssl.

=head3 --no-tlsextdebug

Do not use  -tlsextdebug  option for openssl.

=head3 --sclient-opt=VALUE

Argument or option passed to openssl's  s_client  command.

=head2 Options for  +cipher  command

=head3 --connect-delay=SEC

Additional delay in seconds  after each connect for a cipher check.
This is useful when connecting to servers which have IPS in place,
or are slow in accepting new connections or requests.

=head3 --cipher-alpn=NAME

Name of protocol to be added to list of  applcation layer protocols
(ALPN), which is used for cipher checks.

I<--cipher-alpn=>,   sets empty list.
I<--cipher-alpn=>,,  sets list to empty element "".

=head3 --cipher-npn=NAME

Name of protocol to be added to list of  next protocol negotiations
(NPN), which is used for cipher checks.

I<--cipher-npn=>,   sets empty list.
I<--cipher-npn=>,,  sets list to empty element "".

Note:  setting empty list or element most likely does not work with
openssl executable (for example  I<--force-openssl>).

=head3 --cipher-curve=NAME

Name of ecliptic curve to be added to list of ecliptic curves (EC),
which is used for cipher checks.

I<--cipher-curve=>,   sets empty list.
I<--cipher-curve=>,,  sets list to empty element "".

Note:  setting empty list or element most likely does not work with
openssl executable (for example  I<--force-openssl>).

=head3 --range=RANGE

=head3 --cipherrange=RANGE

Specify range of cipher constants to be tested with  I<+cipher>  .
Following C<RANGE>s are supported:

=over

=item * C<rfc>               all ciphers defined in various RFCs; default

=back

=over

=item * C<shifted>           C<rfc>, shifted by 64 bytes to the right

=back

=over

=item * C<long>              like C<rfc> but more lazy list of constants

=back

=over

=item * C<huge>              all constants  0x03000000 .. 0x0300FFFF

=back

=over

=item * C<safe>              all constants  0x03000000 .. 0x032FFFFF

=back

=over

=item * C<full>              all constants  0x03000000 .. 0x03FFFFFF

=back

=over

=item * C<SSLv2>             all ciphers according RFC for SSLv2

=back

=over

=item * C<SSLv2_long>        more lazy list of constants for SSLv2 ciphers

=back

=over

=item * C<SSLv3>             all ciphers according RFC for SSLv3

=back

=over

=item * C<SSLv3_SSLv2>       all ciphers for SSLv3 with SSLv2

=back

=over

=item * C<TLSv12>            all ciphers according RFC for TLSv12

=back

=over

=item * C<TLSv13>            all ciphers according RFC for TLSv13

=back

=over

=item * C<c0xx>              constants for ciphers using ECC 0x0300C000 .. 0x0300C0FF

=back

=over

=item * C<ccxx>              constants for ciphers using ECC 0x0300CC00 .. 0x0300CCFF

=back

=over

=item * C<ecc>               all constants for ciphers using ECC

=back

Note: C<SSLv2> is the internal list used for testing SSLv2 ciphers.
It does not make sense to use it for other protocols; however ...

For details about the ranges, please see:

	o-saft.pl --help=range

If any  I<--cipher=CIPHER>  is used,  I<--cipherrange=RANGE>  is ignored.

=head3 --slow-server-delay=SEC

Additional delay in seconds  after the server is connected  using a
proxy or before starting C<STARTTLS>.
This is useful when connecting via  slow proxy chains or connecting
to slow servers before sending the C<STARTTLS> sequence.

=head3 --ssl-maxciphers=CNT

Maximal number of ciphers sent in a sslhello (default: 32).

=head3 --ssl-double-reneg

Send SSL extension  C<reneg_info>  even if list of ciphers includes
C<TLS_EMPTY_RENEGOTIATION_INFO_SCSV> (default: do not include)

=head3 --ssl-nodata-nocipher

Some servers do not answer  (i.g. they disconnect) if  none of  the
offered ciphers is supported by the server.

Continue testing with next ciphers  when the target  disconnects or
does not send data within specified timeout (see  I<--timeout>).
Useful for TLS intolerant servers.

=head3 --no-ssl-nodata-nocipher

Abort testing with next ciphers when the target disconnects.

=head3 --ssl-use-ecc

Use supported elliptic curves.  Default on.

=head3 --ssl-use-ec-point

Use TLS C<ec_point_formats> extension.  Default on.

=head3 --ssl-use-reneg

Test for ciphers with "secure renegotiation" flag set.
Default: don't set "secure renegotiation" flag.

=head3 --ssl-retry=CNT

Number of retries when connection timed-out (default: 2).

=head3 --ssl-timeout=SEC

Number of seconds to wait until connection is qualified as timeout.

=head3 --dns-mx

=head3 --mx

Get DNS MX records for given target and check the returned targets.
(only useful with  I<--starttls=SMTP>).

=head2 Options for checks and results

Options used for  I<+check>  command:

=head3 --enabled

Only print result for ciphers accepted by target.

=head3 --disabled

Only print result for ciphers not accepted by target.

=head3 --https_body

Prints HTTP response body of the target also, if requested with
I<+https_body>  , which is disabled by default (because it may be huge
amount of data not related to SSL/TLS).

=head3 --ignorecase

Checks are done case insensitive.

=head3 --no-ignorecase

Checks are done case sensitive. Default: case insensitive.
Currently only checks according CN, alternate names in the target's
certificate compared to the given hostname are effected.

=head3 --ignore-no-reply

When checking for the TLS "heartbeat" extension, the server may not
respond at all, which would result in a  "no reply"  message.  This
marks the check for  I<+heartbleed>  as C<no>.
I.g.  a server is  not vulnerable to the  heartbleed attack  if the
TLS "heartbeat" extension is disabled. Hence the check result  C<no>
may be mis-leading.  This option  treats the  "no reply"  result as
"not vulnerable" and returns  C<yes>  then.

Note: if the server does not respond for this check,  does not mean
that the "heartbeat" extension is switched off.  If unsure, disable
this lazy check with  I<--no-ignore-no-reply> .

=head2 Options for output format

=head3 --label=TYPE

Defines the format of the descriptive text (label) for  I<+check>  and
I<+info>  command.

Following C<TYPE>s are supported:

=head3 --label=long

Prints full text for labels:

	Certificate Common Name:  some.tld

=head3 --label=short

Prints short less descriptive text for labels:

	Common Name:              some.tld

=head3 --label=key

Internal format: print name of key instead of text as label. Key is
Prints name of key instead of text as label. The key is that of the
internal data structure(s).

	[cn]                      some.tld

For ciphers and protocols, the corresponding  hex value  is used as
key. Note that these values are unique.

=head3 --legacy=*

=head3 --legacy=TOOL

For compatibility with other tools,  the output format used for the
result of the  I<+cipher>  command can be adjusted to mimic the format
of other SSL testing tools.

The argument to the  I<--legacy=TOOL >  option  is the name of the tool
to be simulated.

Following C<TOOL>s are supported:

=over

=item * C<sslaudit>          format of output similar to  sslaudit

=back

=over

=item * C<sslcipher>         format of output similar to  ssl-cipher-check

=back

=over

=item * C<ssldiagnos>        format of output similar to  ssldiagnos

=back

=over

=item * C<sslscan>           format of output similar to  sslscan

=back

=over

=item * C<ssltest>           format of output similar to  ssltest

=back

=over

=item * C<ssltestg>          format of output similar to  ssltest -g

=back

=over

=item * C<ssltest-g>         format of output similar to  ssltest -g

=back

=over

=item * C<sslyze>            format of output similar to  sslyze

=back

=over

=item * C<ssl-cipher-check>  same as sslcipher

=back

=over

=item * C<ssl-cert-check>    format of output similar to  ssl-cert-check

=back

=over

=item * C<testsslserver>     format of output similar to  TestSSLServer.jar

=back

=over

=item * C<thcsslcHeck>       format of output similar to  THCSSLCheck

=back

Note that these legacy formats only apply to  output of the checked
ciphers. Other texts like headers and footers are adapted slightly.

When using ths option, please do not expect identical output as the
C<TOOL>. It is a best guess and should be parsable in a very similar
way.

=head3 --legacy=TYPE

=head3 --legacy=compact

Internal format: mainly avoid tabs and spaces format is as follows:

	Some Label:<-- anything right of colon is data

=head3 --legacy=full

Internal format: pretty print each label in its own line,  followed
by data prepended by tab character (useful for  I<+info>  only).

=head3 --legacy=owasp

Results for cipher checks use rating from OWASP Cipher Cheat Sheet.

=head3 --legacy=quick

Internal format: use tab as separator; ciphers are printed with bit
length (implies  I<--tab>).

=head3 --legacy=simple

Internal default format.

=head3 --format=0x

=head3 --format=\x

=head3 --format=/x

=head3 --format=hex

=head3 --format=raw

This option is used to specify the format of the result lines. This
covers the value of the result line only.

=over

=item * C<raw>       Print raw data as passed from L<Net::SSLinfo|Net::SSLinfo>.

=back

Note:  all data will be printed as is,  without  additional label
or formatting. It's recommended to use the  option in conjunction
with exactly one command.  Otherwise the user needs  to know  how
to "read" the printed data.

=over

=item * C<hex>       Convert some data to hex: 2 bytes separated by C<:>.

=back

=over

=item * C<0x>        Convert some data with hex values:

=back

              2 bytes preceded by C<0x> and separated by a space.

=over

=item * C</x>        Same as  --format=\x

=back

=over

=item * C<\x>        Convert some data with hex values:

=back

              2 bytes preceded by C<\x> and no separating char.

=head3 --tty

=head3 --format-tty

Get the screen width and then adapt  output of documentation to fit
to that width. If the environment variable C<COLUMNS> is not set the
command C<tput> or C<stty> of system is used to get the screen width.

It's a very simple approach to make texts better readable on narrow
devices like tablets. For more details, please see:

	perdoc o-saft.pl   # the section Note:tty  there

=head3 --format-width=NN

Set the screen width to C<NN> characters (see  I<--format-tty>  also).
Default will be calculated automatically.

=head3 --format-ident=NN

Set the amount of spaces used for identation (see  I<--tty>  also).
Default is 2.

=head3 --format-arrow=CHR

Set the additional chacacter when lines are split. Default: ↲

=head3 --header

Print formatting header.  Default for  I<+check>,  I<+info>,  I<+quick>  and
and  I<+cipher>  only.

=head3 --no-header

Do not print formatting header.
Usefull if raw output should be passed to other programs.

Note: must be used on command-line to inhibit all header lines.

=head3 --ignore-cmd=CMD

=head3 --ignore-output=CMD

=head3 --no-cmd=CMD

=head3 --no-output=CMD

Do not print output (data or check result) for command C<CMD>. C<CMD>
is any valid command, see  L</COMMANDS> ,  without leading C<+>.
Option can be used multiple times.

I<--ignore-out=>,    sets empty list.

=head3 --score

Print scoring results. Default for  I<+check>.

=head3 --no-score

Do not print scoring results.

=head3 --separator=CHAR

=head3 --sep=CHAR

C<CHAR>    will be used as separator between  label and value of the
       printed results. Default is  C<:>.

=head3 --tab

C<TAB> character (0x09, \t)  will be used as separator between label
and value of the printed results.
As label and value are already separated by a  TAB  character, this
options is only useful in conjunction with the  I<--legacy=compact>
option.

=head3 --showhost

Prefix each printed line with the given hostname (target).
The hostname will be followed by the separator character.

=head3 --std-format=*

=head3 --std-format=utf8

=head3 --std-format=crlf

=head3 --std-format=raw

=head3 --std-format=unix

=head3 --std-format=CHARSET

This option is used to specify the general output format for STDOUT
and STDERR. All results are written to STDOUT,  errors and warnings
may also be written to STDERR .  The default is C<:unix:utf8>, which
is the perlish definition used internally.

Following values are supported:

=over

=item * C<raw>

=back

=over

=item * C<unix>      Print raw data, binary in bytes without conversion.

=back

Note:  binary here just means characters (as all output is text).

=over

=item * C<utf8>      Convert all characters to UTF-8.

=back

=over

=item * C<crlf>      Use CR LF as end of line.

=back

=over

=item * C<CHARSET>   C<CHARSET> can be any of the local installed character

=back

           sets, like UTF-8, UTF-16LE, CP1252, iso-8859-7, etc..
           This conversion may print its own warnings.

The option can be used multiple times with different values.
To reset the  default behaviour, either  C<raw>  or  C<unix>  must be
used. Obviously, they must be used first. All other values are used
additionally.
Note:  C<utf8> just defines the format of the characters, it does no
further checks on the converted characters. In contrast, C<UTF-8> is
used as real encoding and does some checks.

For more details, please see  "perldoc -f binmode" .

Currently (Jan. 2018), these options must be used before any I<--help>
option.

=head3 --win-CR

Obsolete, please use  I<--std-format=crlf> .

=head2 Options for compatibility with other programs

Please see other programs for detailed description (if not obvious:).
Note that often only the long form options are accepted as most short
form options are ambiguous.
If other programs use the same option,but with a different behaviour,
then thes other options are not supported.
For a list of supported options, please see:

	o-saft.pl --help=alias

Following list contains only those options not shown with:

	o-saft.pl --help=alias

   Tool's Option       (Tool)          o-saft.pl Option
#---------------------+---------------+------------------------

=over

=item * --checks CMD        (TLS-Check.pl)  same as  +CMD

=back

=over

=item * -h, -h=HOST         (various tools) same as  --host HOST

=back

=over

=item * -p, -p=PORT         (various tools) same as  --port PORT

=back

=over

=item * -t HOST             (ssldiagnos)    same as  --host HOST

=back

=over

=item * --UDP               (ssldiagnos)    same as  --udp

=back

=over

=item * --timeout, --grep   (ssltest.pl)    ignored

=back

=over

=item * -r,  -s,  -t,  -x   (ssltest.pl)    ignored

=back

=over

=item * --insecure          (cnark.pl)      ignored

=back

=over

=item * --nopct --nocolor   (ssldiagnos)    ignored

=back

=over

=item * -connect, -H, -u, -url, -U          ignored

=back

=over

=item * -noSSL                              same as  --no-SSL

=back

=over

=item * -no_SSL                             same as  --no-SSL

=back

#---------------------+---------------+------------------------

For definition of  C<SSL>  see  I<--SSL >  and  I<--no-SSL >  above.

=head2 Options for customisation

=head3 --cfg-CFG

Option for customisation have the general from:  I<--cfg-CFG=KEY=TEXT>
For general descriptions please see  L</CUSTOMISATION>  section below.

=head3 --cfg-cmd=CMD=LIST

Redefine list of commands. Sets  C<%cfg{cmd-CMD}>  to  C<LIST>.
Commands can be written without the leading  C<+>.
If  CMD  is any of the known internal commands, it will be redifned.
If  CMD  is a unknown command, it will be created.

Example:

	--cfg-cmd=sni="sni hostname"
An example  I<+preload>  can be found in  C<.o-saft.pl> .

To get a list of commands and their settings, use:

	o-saft.pl --help=intern

Main purpose is to reduce list of commands or to print them sorted.

=head3 --cfg-checks=KEY=TEXT

=head3 --cfg-data=KEY=TEXT

Redefine texts used for labels in output. Sets C<%data{KEY}{txt}>  or
C<%checks{KEY}{txt}>  to  C<TEXT>.

To get a list of preconfigured labels, use:

	o-saft.pl --help=cfg-checks
	o-saft.pl --help=cfg-data

=head3 --cfg-cipher=CIPHER=value

Redefine the security value (i.e. HIGH) in the cipher description.
Example:

	--cfg-cipher=NULL-MD5=no-security-at-all

=head3 --cfg-text=KEY=TEXT

Redefine general texts used in output. Sets C<%text{KEY}>  to  C<TEXT>.

To get a list of preconfigured texts, use:

	o-saft.pl --help=cfg-text

Note that \n, \r and \t are replaced by the corresponding character
when read from L</RC-FILE>.

=head3 --cfg-text=FILE

Read definitions for  C<%text{KEY}="my text"> from file  C<FILE>.

=head3 --cfg-hint=KEY=TEXT

Redefine texts used for hints. Sets  C<%cfg{hints}{KEY}>  to  C<TEXT>.

To get a list of preconfigured texts, use:

	o-saft.pl --help=cfg-hint

=head3 --cfg-init=KEY=VALUE

Set the internal  C<%cfg> hash. This options is intended for testing
and debugging only. Please see  L</TESTING>  below.

=head3 --call=METHOD

See  L</Options for SSL tool>.

=head3 --usr

Execute functions defined in L<o-saft-usr.pm|o-saft-usr.pm>.

=head3 --usr-*

=head3 --user-*

Options ignored, but stored as is internal in  $cfg{usr-args} .
These options can be used in L<o-saft-usr.pm|o-saft-usr.pm> or L<o-saft-dbx.pm|o-saft-dbx.pm>.

=head3 --experimental

Use experimental functionality.
Some functionality of this tool is  under development and only used
when this option is given.

=head2 Options for tracing and debugging

=head3 --n

Do not execute, just show commands (only useful in conjunction with
using openssl).

=head3 Difference --trace vs. --v

While  I<--v>  is used to print more data,  I<--trace>  is used to  print
more information about internal data such as procedure names and/or
variable names and program flow.

=head3 --v

=head3 --verbose

Print more information about checks.

Note that this option should be first otherwise some debug messages
are missing.

Note that  I<--v>  is different from  -v  (see above).

=head3 --v --v

Print remotely checked ciphers.

=head3 --v-cipher --cipher-v

Print remotely checked ciphers.
In contrast to  I<--v> I<--v>  above,  this just prints the ciphers while
being checked, but no other verbose messages.

=head3 --trace

Print debugging messages.

=head3 --trace --trace

Print more debugging messages and pass C<trace=2> to Net::SSLeay and
L<Net::SSLinfo|Net::SSLinfo>.

=head3 --trace --trace --trace

Print more debugging messages and pass C<trace=3> to Net::SSLeay and
L<Net::SSLinfo|Net::SSLinfo>.

=head3 --trace --trace --trace --trace

Print processing of all command-line arguments.

=head3 --trace-cli

Print complete command-line first. Used for internal testing.

=head3 --trace-arg

=head3 --trace--

Print command-line argument processing.

=head3 --trace-cmd

Trace execution of command processing (those given as  I<+CMD>).

=head3 --trace-key

=head3 --trace@

Print some internal variable names in output texts (labels).
Variable names are prefixed to printed line and enclosed in  # .
Example without  I<--trace-key> :

	Certificate Serial Number:          deadbeef

Example with     I<--trace-key> :

	#serial#          Certificate Serial Number:          deadbeef

=head3 --trace-time

Prints trace output with timestamps. More timestamps are printed if
used together with  I<--trace-cmd>.

=head3 --trace=VALUE

Alias for  I<--trace-VALUE>  options (see above).

Trace Option          Alias Option
#--------------------+----------------------------

=over

=item * --trace=1           same as  --trace

=back

=over

=item * --trace=2           same as  --trace  --trace

=back

=over

=item * --trace=arg         same as  --trace-arg

=back

=over

=item * --trace=cmd         same as  --trace-cmd

=back

=over

=item * --trace=cli         same as  --trace-cli

=back

=over

=item * --trace=key         same as  --trace-key

=back

=over

=item * --trace=time        same as  --trace-time

=back

#--------------------+----------------------------

=head3 --trace=FILE

Use FILE instead of the default  L</RC-FILE>, for example C<.o-saft.pl>.

=head3 --trace-me

Print debugging messages for  o-saft.pl  only, but not any modules.

=head3 --trace-not-me

Print debugging messages for modules only, but not o-saft.pl itself.

=head3 --hint

Print hint messages (!!Hint:).

=head3 --no-hint

Do not print hint messages (!!Hint:).

=head3 --warning

Print warning messages (**WARNING:).

=head3 --no-warning

Do not print warning messages (**WARNING:).

=head3 --warnings-dups

=head3 --no-warnings-no-dups

	  Do not suppress duplicate warning messages (**WARNING:).

=head3 --exit=KEY

Terminate  o-saft.pl  at specified C<KEY>. Please see  L</TESTING>  below.

=head2 Options vs. Commands

For compatibility with other programs and lazy users,  some arguments
looking like options are silently taken as commands.  This means that
I<--THIS>  becomes  I<+THIS>  then. These options are:

=over

=item * --help

=back

=over

=item * --abbr

=back

=over

=item * --todo

=back

=over

=item * --chain

=back

=over

=item * --default

=back

=over

=item * --fingerprint

=back

=over

=item * --list

=back

=over

=item * --version

=back

Take care that this behaviour may be removed in future versions as it
conflicts with those options and commands which actually exist, like:

I<--sni>  vs.  I<+sni>

=head1 LAZY SYNOPSIS

=head2 Commands

Following strings are treated as a command instead of target names:

=over

=item * ciphers

=back

=over

=item * s_client

=back

=over

=item * version

=back

A warning will be printed.

=head2 Options

We support following options, which are all identical, for lazy users
and for compatibility with other programs.

=head3 Option variants

=over

=item * --port PORT

=back

=over

=item * --port=PORT

=back

This applies to most such options,  I<--port>  is just an example.  When
used in the  L</RC-FILE>, the  I<--OPTION=VALUE>  variant must be used.

=head3 Option Names

Dash C<->, dot C<.> and/or underscore C<_> in option names are optional,
all following are the same:

=over

=item * --no.dns

=back

=over

=item * --no-dns

=back

=over

=item * --no_dns

=back

=over

=item * --nodns

=back

This applies to all such options,  I<--no-dns>  is just an example.

=head2 Targets

Following syntax is supported also:

	o-saft.pl http://some.tld other.tld:3889/some/path?a=b

Note that only the hostname and the port are used from an URL.

=head2 Options vs. Commands

See  L</Options vs. Commands>  in  L</OPTIONS>  section above

=head1 RESULTS

All output is designed to be easily parsed by postprocessors.  Please
see  L</OUTPUT>  section below for details.

For the results,  we have to distinguish  those  returned by  I<+cipher>
command  and those from  all other tests and checks like   I<+check>  or
I<+info>  command.

=head3 +cipher

The cipher checks will return  one line for each  tested cipher. It
contains at least the cipher name,  C<yes>  or  C<no>  whether  it is
supported or not, and a security qualification. It may look like:

	AES256-SHA       yes    HIGH
	NULL-SHA         no     weak

Depending on the used  I<--legacy=*>  option the format may differ and
also contain more information.  For details see  I<--legacy=*>  option
below.

The text for security qualifications are (mainly) those returned by
openssl (version 1.0.1): LOW, MEDIUM, HIGH and WEAK.
The same texts, but with all lower case characters, are used if the
qualification was adapted herein. Following rules for adjusting the
qualification were used:

=over

=item * weak:

=back

=over

=item ** all *NULL* ciphers

=back

=over

=item ** all *RC2* and *RC4* ciphers

=back

=over

=item ** all *EXPORT*  ciphers

=back

=over

=item ** all *anon* (a.k.a ADH a.k.a DHA) ciphers

=back

=over

=item ** all *CBC* and *CBC3* (a.k.a 3DES, EDE-CBC) and DES ciphers

=back

=over

=item * low:

=back

=over

=item * medium:

=back

=over

=item ** all *PSK* ciphers using CBC (assumes that the PSK is secure)

=back

=over

=item * high:

=back

=over

=item ** all *DHE*AES(128|256)* ciphers

=back

=over

=item ** all *CHACHA* ciphers

=back

=over

=item ** all *PSK* ciphers (except those using 

=back

=head3 +check

These tests return a line with  a label  describing the test  and a
test result for it. The  idea is to report  C<yes>  if the result is
considered "secure"  otherwise report  C<no>  followed by the reason
why it's considered insecure. Example of a check considered secure:

	Label of the performed check:           yes

Example of a check considered insecure:

	Label of the performed check:           no (reason why)

Note  that there are tests where the results  appear confusing when
first viewed, like for www.wi.ld:

	Certificate is valid according given hostname:  no (*.wi.ld)
	Certificate's wildcard does not match hostname: yes

This can for example occur with:

	Certificate Common Name:                *.wi.ld
	Certificate Subject's Alternate Names:  DNS:www.wi.ld

Please check the result with the  I<+info>  command also to  verify if
the check sounds reasonable.

=head3 +info

The test result contains detailed information. The labels there are
mainly the same as for the  I<+check>  command.

=head1 CHECKS

All SSL related check performed by the tool will be described here.

=head2 General checks

Lookup the IP of the given hostname (FQDN), and then tries to reverse
resolve the FQDN again.

=head2 SSL ciphers

Check which ciphers are supported by target. Please see  L</RESULTS>  for
details of this check.

=head2 SSL connection

=head3 heartbeat

Check if "heartbeat" extension is supported by target.

=head3 poodle

Check if target is vulnerable to POODLE attack (SSLv3 enabled).

=head3 robot

Check if target is vulnerable to ROBOT attack (server offers ciphers
with RSA encryption).

=head3 sloth

Check if target is vulnerable to SLOTH attack  (server offers RSA-MD5
or ECDSA-MD5 ciphers).

=head3 sweet32

Check if target is vulnerable to Sweet32 attack (server offers CBC or
CBC3 or DES or 3DES ciphers).

Note that FIPS-140 compliance requires 3DES ciphers, hence compliant
systems are then vulnerable to Sweet32 attacks.

=head3 ALPN

Check if target supports ALPN. Following messages are evaluated:

	ALPN protocol: h2-14
	No ALPN negotiated

Please see also  L</CHECKS>  ALPN and NPN  below.

=head2 SSL vulnerabilities

=head3 ADH

Check if ciphers for anonymous key exchange are supported: ADH|DHA.
Such key exchanges can be sniffed.

=head3 EDH

Check if ephemeral ciphers are supported: DHE|EDH.
They are necessary to support Perfect Forward Secrecy (PFS).

=head3 BEAST

Check if ciphers with CBC for protocol SSLv1, SSLv3 or TLSv1 are used.
TLSv1.2 checks are not yet implemented.

=head3 CRIME

Connection is vulnerable if target supports SSL-level compression, or
supports SPDY/3 (because SPDY/3 uses compression).
See http://zoompf.com/2012/09/explaining-the-crime-weakness-in-spdy-and-ssl

Note: SPDY/3 is only possible if the client explicitely asks for this
alternate protocol (for example  "openssl ... -nextprotoneg spdy/3").

=head3 DROWN

Connection is vulnerable if target supports SSLv2.

=head3 FREAK

Attack against SSL/TLS to downgrade to EXPORT ciphers.
Currently (2018) a simple check is used:   SSLv3 enabled and EXPORT
ciphers supported by server.
See CVE-2015-0204 and https://freakattack.com/ .

=head3 HEARTBLEED

Check if target is vulnerable to heartbleed attack, see CVE-2014-0160
and http://heartbleed.com/ .

=head3 HEIST

Not implemented.

There are no checks for the HEIST attack implemented, because this is
an attack on TCP/IP rather than SSL/TLS on top of TCP/IP.

=head3 KCI

To perform a MiTM attack with Key Compromise Impersonation, the atta-
cker needs to engage the victim to install and use a client certificate.
This is considered a low risk and hence not tested here.

=head3 Logjam

Check if target is vulenerable to Logjam attack.
Check if target suports  EXPORT ciphers  and/or  DH Parameter is less
than 2048 bits. ECDH must be greater to 511 bits.

=head3 Lucky13

Check if CBC ciphers are offered.
Note the recommendation  to be safe against  Lucky13  was to use  RC4
ciphers. But they are also subject to attacks (see below).  Hence the
check is only for CBC ciphers.

=head3 RC4

Check if RC4 ciphers are supported.
They are assumed to be broken.
Note that  I<+rc4>  reports the vulnerabilitiy to the  RC4 Attack, while
I<+cipher-rc4>  simply reports if  RC4 ciphers are offered.  However the
check, and hence the result, is the same.

=head3 PFS

Check if DHE ciphers are used.  Checks also if the TLS session ticket
is random or not used at all.
TLSv1.2 checks are not yet implemented.

=head3 POODLE

Check if target is vulnerable to  POODLE attack (just check if  SSLv3
is enabled).

=head3 Practical Invalid Curve Attack

This attack allows an attacker to read the servers private key if the
server does not check properly the passed points for a ecliptic curve
when EDH ciphers are used.

This check will not send multiple invalid points,  but only checks if
the server closes the connection or responds with no matching cipher.

=head3 ROBOT

Bleichebacher's Oracle attack against SSL/TLS ciphers.

Not implemented.
https://robotattack.org/

=head3 SLOTH

Currently (2016) we check for ciphers with  ECDSA, RSA-MD5.
Checking the TLS extension C<tls-unique> is not yet implemented.

=head3 Sweet32

Currently (2016) we check for ciphers with CBC or CBC3 or DES or 3DES.

=head3 Ticketbleed

B<NOT YET IMPLEMENTED>
Check if target is vulnerable to ticketbleed, means that it returns
up to 31 random bytes from memory as Session Ticket, see CVE-2016-9244
and https://filippo.io/Ticketbleed/ .

=head2 Target (server) configuration and support

=head3 BEAST, BREACH, CRIME, DROWN, FREAK, Logjam, Lucky13, POODLE, RC4, ROBOT,

=head3 SLOTH, Sweet32

See above.

=head3 Renegotiation

Check if the server allows client-side initiated renegotiation.

=head3 Version rollback attacks

B<NOT YET IMPLEMENTED>
Check if the server allows changing the protocol.

=head3 DH parameter

Check if target's DH Parameter is less 512 or 2048 bits.

=head3 SSTP

Check if target supports SSTP by accepting method SSTP_DUPLEX_POST.

The check does not send other methods (like CONNECT) to verify if the
protocol is fully supported.

Supporting SSTP is considered insecure, because SSTP allows to tunnel
other, probably insecure, protocols.

=head2 Target (server) certificate

=head3 Certificate Hashes

Check that fingerprint is not MD5.
Check that certificate private key signature is SHA2 or better.

=head3 Root CA

Provided certificate by target should not be a Root CA.

=head3 Self-signed certificate

Certificate should not be self-signed.

=head3 FQDN is listed in subjectAltname (RFC2818)

The FQDN must be listed in the certificates subjectAltname.
The check command  I<+rfc_2818_names>  is based on the info command
I<+verify_hostname> . The check was added in 05/2017 because browsers
started to complain if the FQDN is not part of the subjectAltname.

=head3 IP in CommonName or subjectAltname (RFC6125)

B<NOT YET IMPLEMENTED>

=head3 Basic Constraints

Certificate extension Basic Constraints should be CA:FALSE.

=head3 OCSP, CRL, CPS

Certificate should contain URL for OCSP and CRL.

=head3 Private Key encyption

Certificates signature key supports encryption.

=head3 Private Key encyption well known

Certificates signature key encryption algorithm is well known.

=head3 Public Key encyption

Certificates public key supports encryption.

=head3 Public Key encyption well known

Certificates public key encryption algorithm is well known.

=head3 Public Key Modulus Exponent size

The modulus exponent should be = 65537 as it is a prime number and an
easy to calculate exponent.
If the exponent is less than 65537, "Boradcast" attacks are possible.

However, some (mainly historic) SSL implementations may have problems
to connect because they are not able to do the crypt mathematics with
exponenents larger than 65536.

If ecliptic curves are used, the result for these checks is always
C<no (<<N/A ...)>.

=head3 Sizes and Lengths of Certificate Settings

Serial Number <= 20 octets (RFC5280, 4.1.2.2.  Serial Number)

B<...>

=head3 DV-SSL - Domain Validation Certificate

The Certificate must provide:

=over

=item * Common Name C</CN=> field

=back

=over

=item * Common Name C</CN=> in C<subject> or C<subjectAltname> field

=back

=over

=item * Domain name in C<commonName> or C<altname> field

=back

=head3 EV-SSL - Extended Validation Certificate

This check is performed according the requirements defined by the CA/
Browser Forum  https://www.cabforum.org/contents.html .
The certificate must provide:

=over

=item * DV - Domain Validation Certificate (see above)

=back

=over

=item * Organization name C</O=> or C<subject> field

=back

=over

=item * Organization name must be less to 64 characters

=back

=over

=item * Business Category C</businessCategory=> in C<subject> field

=back

=over

=item * Registration Number C</serialNumber=> in C<subject> field

=back

=over

=item * Address of Place of Business in C<subject> field

=back

Required are: C</C=>, C</ST=>, C</L=>

Optional are: C</street=>, C</postalCode=>

=over

=item * Validation period does not exceed 27 month

=back

See  L</LIMITATIONS>  also.

=head2 Target (server) HTTP(S) support

=head3 STS header (see RFC 6797)

Using STS is no perfect security.  While the very first request using
http: is always prone to a MiTM attack, MiTM is possible to following
requests again, if STS is not well implemented on the server.

=over

=item * Request with http: should be redirected to https:

=back

=over

=item * Redirects should use status code 301 (even others will work)

=back

=over

=item * Redirect's Location header must contain schema https:

=back

=over

=item * Redirect's Location header must redirect to same FQDN

=back

=over

=item * Redirect may use Refresh instead of Location header (not RFC6797)

=back

=over

=item * Redirects from HTTP must not contain STS header

=back

=over

=item * Answer from redirected page (HTTPS) must contain STS header

=back

=over

=item * Answer from redirected page for IP must not contain STS header

=back

=over

=item * STS header must contain includeSubDirectoy directive

=back

=over

=item * STS header max-age should be less than 1 month

=back

=over

=item * STS must not be set in http-equiv attribute of a meta TAG

=back

=head3 STS header preload attribute (+preload)

To satisfy the requirements on  https://hstspreload.appspot.com/  the
HSTS header must:

=over

=item * have the max-age with at least 18 weeks (10886400 seconds)

=back

=over

=item * have the includeSubDomains attribute

=back

=over

=item * have the preload attribute

=back

=over

=item * redirect to https first, then to sub-domains (if redirected)

=back

=over

=item * have an HSTS header in each redirect to https.

=back

Additionally, the site must have:

=over

=item * a valid certificate

=back

=over

=item * serve all subdomains over https.

=back

Except the last requirement,  I<+preload>  will do the checks.
Note that  I<+preload>  is defined in  C<.o-saft.pl>  only.

=head3 Public Key Pins header

TBD - to be described ...

=head2 Sizes

Mainly in the certificate various counts, lengths and sizes of values
are checked and reported. All commands for these checks start with
C<+cnt_>  or  C<+len_>.  Up to now, there is no  C<yes>  or  C<no>  value
for these checks.

Following commands will check the value to be in  a specific range to
become  C<yes>  or  C<no>:

=over

=item * +sts_maxage1d       - yes if HSTS maxage < 1 day

=back

=over

=item * +sts_maxage1m       - yes if HSTS maxage < 1 month

=back

=over

=item * +sts_maxage1y       - yes if HSTS maxage < 1 year

=back

=over

=item * +sts_maxage18       - yes if HSTS maxage < 18 weeks (5 months)

=back

=over

=item * +sts_maxagexy       - yes if HSTS maxage > 1 year

=back

=over

=item * +modulus_exp_1      - Public Key Modulus Exponent <>1

=back

=over

=item * +modulus_exp_65537  - Public Key Modulus Exponent =65537

=back

=over

=item * +modulus_exp_oldssl - Public Key Modulus Exponent <65537

=back

=over

=item * +modulus_size_oldssl - Public Key Modulus <16385 bits

=back

For some details of these checks, please see the description above at
Public Key Modulus Exponent size

The recommendations for  DH parameters (RSA and ecliptice curve)  are
are checked as follows:

=over

=item * +dh_512             - DH Parameter >= 512 bits

=back

=over

=item * +dh_2048            - DH Parameter >= 2048 bits

=back

=over

=item * +ecdh_256           - DH Parameter >= 256 bits (ECDH)

=back

=over

=item * +ecdh_512           - DH Parameter >= 512 bits (ECDH)

=back

Note that only one of the checks  C<+dh_*>  and  C<+ecdh_*>  can return
C<yes>.

=head2 ALPN and NPN

The commands for the checks to report  C<yes>  or  C<no>, are  I<+hasalpn>
and  I<+hasnpn>.

Both, the Application Layer Protocol Negotiation (ALPN) and the  Next
Protocol Negotiation (NPN) will be tested. The commands for that are:

=over

=item * +alpns

=back

=over

=item * +npns

=back

Each, ALPN and NPN, is tested separately with all known protocols.
The test sets only one protocol,  tries to make a connection and then
checks if the protocol was accepted by the server. The collected list
of protocols will be printed with the aforementioned commands, or the
I<+info>  command. Note the difference for the commands  I<+next_protocols>
and  I<+alpns>, where  I<+next_protocols>  simply reports  what  the server
itself advertises, while  I<+alpns>  reports what the server supports if
asked for.

=head2 Compliances

Note that it is not possible to satisfy all following compliances.
Best match is: C<PSF> and C<ISM> and C<PCI> and C<lazy BSI TR-02102-2>.
In general it is difficult to satisfy all conditions of a compliance,
and it is also difficult to check  all these conditions.  That is why
some compliance checks are not completely implemented.
For details see below please.

Also note that in the  L</RC-FILE>  the output of results for some checks
is disabled by default. A  C<!!Hint:>  message will be printed, if any
of these checks are used.

=over

=item * FIPS-140

=back

=over

=item * ISM

=back

=over

=item * PCI

=back

=over

=item * BSI TR-02102-2 (2016-01)

=back

=over

=item * BSI TR-03116-4

=back

=over

=item * RFC 2818

=back

=over

=item * RFC 6125

=back

=over

=item * RFC 6797

=back

=over

=item * RFC 7525

=back

=head3 BSI TR-02102-2 (+tr-02102+ +tr-02102- +bsi)

Checks if connection and ciphers are compliant according TR-02102-2,
see https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Publikationen
/TechnischeRichtlinien/TR02102/BSI-TR-02102-2_pdf.pdf?__blob=publicationFile

(following headlines are taken from TR-02102-2 Version 2016-01)

3.1.3 Schlüssellängen bei EC-Verfahren
die EC-Verfahren ...  und weitere Erläuterungen siehe Bemerkung 4 in Kapitel 3 in [TR-02102-1] .

3.2   SSL/TLS_Versionen

Only TLSv1.2 allowed (except for  I<+tr-02102->  which also allows
TLSv1.1)

3.3.1 Empfohlene Cipher Suites

Allows only *DHE-*-SHA256, *DHE-*-SHA384, *DH-*-SHA256 and
*DH-*-SHA384 ciphers and PSK ciphers with ephermeral keys.
For  I<+tr-02102+>  they must be AES-GCM,  I<+tr02102-> also allows
B<AES-CBC.>

3.3.2 Übergangsregelungen

SHA1 temporary allowed. SHA256 and SHA384 recommended.
RC4 not reocmmended.
Use of SHA1 will only be checked for  I<+tr-02102+>

3.4.1 Session Renegotation

Only server-side (secure) renegotiation allowed (see RFC 5746).

3.4.2 Verkürzung der HMAC-Ausgabe

Truncated HMAC according RFC 6066 not recommended.

3.4.3 TLS-Kompression und der CRIME-Angriff

No TLS compression.

3.4.4 Der Lucky13-Angriff
3.4.5 Die "Encrypt-then-MAC"-Erweiterung

Use of AES-GCM ciphers only.
Use of Encrypt-then-MAC according RFC 7366 cannot be checked.

3.4.6 Die Heartbeat-Erweiterung

Target must not support the heartbeat extension.

3.4.7 Die Extended Master Secret Extension

Use of Extended Master Secret Extension according RFC 7627 cannot
be checked.

3.5 Authentisierung der Kommunikationspartner

Not checked as only applicable for VPN connections.

3.6 Domainparameter und Schlüssellängen

Check if signature key is > 2048 bits.

3.6.1 Verwendung von elliptischen Kurven

**NOT YET IMPLEMENTED**

Use only following curves according RFC 5639 and RFC 7027:
brainpoolP256r1, brainpoolP384r1, brainpoolP512r1

Use of secp256r1 and secp384r1  temporary allowed.

4.1 Schlüsselspeicherung

This requirement is not testable from remote.

4.2 Umgang mit Ephemeralschlüsseln

This requirement is not testable from remote.

4.3 Zufallszahlen

This requirement is not testable from remote.

=head3 BSI TR-03116-4 (+tr-03116+ +tr-03116- +bsi)

Checks if connection and ciphers are compliant according TR-03116-4,
see https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Publikationen
/TechnischeRichtlinien/TR03116/BSI-TR-03116-4.pdf?__blob=publicationFile

(following headlines are taken from there)

2.1.1 TLS-Versionen und Sessions

Allows only TLS 1.2.

2.1.2 Cipher Suites

Cipher suites must be ECDHE-ECDSA or -RSA with AES128 and SHA265.
For curiosity, stronger cipher suites with AES256 and/or SHA384 are
not not allowed. To follow this curiosity the  I<+tr-03116->  (lazy)
check allows the stronger cipher suites ;-)

2.1.1 TLS-Versionen und Sessions

The TLS session lifetime must not exceed 2 days.

2.1.4.2 Encrypt-then-MAC-Extension

2.1.4.3 OCSP-Stapling

MUST have C<OCSP Stapling URL>.

4.1.1 Zertifizierungsstellen/Vertrauensanker

Certificate must provide all root CAs. (NOT YET IMPLEMENTED).

Should use a small certificate trust chain.

4.1.2 Zertifikate

Must have C<CRLDistributionPoint> or C<AuthorityInfoAccess>.

End-user certificate must not be valid longer than 3 years.
Root-CA certificate must not be valid longer than 5 years.

Certificate extension C<pathLenConstraint> must exist, and should be
a small value ("small" is not defined).

All certificates must contain the extension C<KeyUsage>.

Wildcards for C<CN> or C<Subject> or C<SubjectAltName> are not allowed
in any certificate.

EV certificates are recommended (NOT YET checked properly).

4.1.3 Zertifikatsverifikation

Must verify all certificates in the chain down to their root-CA.
(NOT YET IMPLEMENTED).

Certificate must be valid according issue and expire date.

All Checks must be doen for all certificates in the chain.

4.1.4 Domainparameter und Schlüssellängen

This requirement is not testable from remote.

4 5.2 Zufallszahlen

This requirement is not testable from remote.

=head3 RFC 2818 (+rfc2818)

Check if the FQDN is listed in the certificates C<subjectAltname>.

=head3 RFC 6125 (+rfc6125)

Checks values C<CommonName>, C<Subject> and C<SubjectAltname>  of the
certificate for:

=over

=item * must all be valid characters for DNS

=back

=over

=item * must not contain more than one wildcard

=back

=over

=item * must not contain invalid wildcards

=back

=over

=item * must not contain invalid IDN characters

=back

=head3 RFC 6797 (+rfc6797)

Same as STS header  I<+hsts> .

=head3 RFC 7525 (+rfc7525)

Checks if connection and ciphers are compliant according RFC 7525.
See http://tools.ietf.org/rfc/rfc7525.txt
(following headlines are taken from there)

3.1.1.  SSL/TLS Protocol Versions

SSLv2 and SSLv3 must not be supportetd.
TLSv1 should only be supported if there is no TLSv1.1 or TLSv1.2.
Either TLSv1.1 or TLSv1.2 must be supported, preferred is TLSv1.2.

3.1.2.  DTLS Protocol Versions

DTLSv1 and DTLSv1.1 must not be supported.

3.1.3.  Fallback to Lower Versions

(check implecitely done by 3.1.1, see above)

3.2.  Strict TLS

Check if server provides Strict Transport Security.
(C<STARTTLS> check NOT YET IMPLEMENTED).

3.3.  Compression

Compression on TLS must not be supported.

3.4.  TLS Session Resumption

Server must support resumtion and random session tickets.
(Randomnes of session tickets implemented YET experimental.)

Check if ticket is authenticated and encrypted NOT YET IMPLEMENTED.

3.5.  TLS Renegotiation

Server must support renegotiation.

3.6.  Server Name Indication

(Check for SNI support implemented experimental.)

4.  Recommendations: Cipher Suites

4.1.  General Guidelines
4.2.  Recommended Cipher Suites

Check for recommended ciphers.

4.3.  Public Key Length

DH parameter must be at least 256 bits or 2048 bits with EC.
(Check currently, 4/2016, based on openssl which may not provide DH

=over

=item *            parameters for all ciphers.)

=back

4.5.  Truncated HMAC

TLS extension "truncated hmac" must not be used.

6.  Security Considerations
6.1.  Host Name Validation

Given hostname must matches hostname in certificate's subject.

6.2.  AES-GCM
6.3.  Forward Secrecy
6.4.  Diffie-Hellman Exponent Reuse
(NOT YET IMPLEMENTED).

6.5.  Certificate Revocation

OCSP and CRL Distrbution Point in cetificate must be defined.

=head1 OUTPUT

All output is designed to make it  easily parsable by postprocessors.
Following rules are used:

=over

=item * Lines for formatting or header lines start with  C<=>.

=back

=over

=item * Lines for verbosity or tracing start with  C<#>.

=back

=over

=item * Errors and warnings start with  C<**>, hints start with C<!!>.

=back

=over

=item * Empty lines are comments ;-)

=back

=over

=item * Label texts end with a separation character; default is  C<:>.

=back

=over

=item * Label and value for all checks are separated by at least one  TAB

=back

character.

=over

=item * Texts for additional information are enclosed in C<<<>  and  C<>>>.

=back

=over

=item * C<N/A>  is used  when no proper information was found or provided.

=back

Replace  C<N/A>  by whatever you think is adequate:  "No answer",
"Not available",  "Not applicable",  ...

Examples:                                                             

	=== Title line ===                                              
	= this is a comment                                             

	Label for information or check:  TABresult                      
	!!Hint: above result depends on the target

For more details on these lines, please refer to  L</RESULTS>  above.

When used in  I<--legacy=full>  or  I<--legacy=simple> mode, the output may
contain formatting lines for better (human) readability.

=head2 Errors, Warnings, Hints

Errors, warnings and hints may be part of the output as needed. While
errors and warnings are printed immediately as they occour during the
program flow, hints are printed right after the corresponding result.

Errors and warnings start with a unique 3-digit number.

Hints print an additional explanation of a specific result.  They are
are defined statically in the program code, or can be added on demand
by using the option  I<--cfg-hint=KEY=TEXT> .

=head2 Postprocessing output

It is recommended to use the   I<--legacy=quick>   option, if the output
should be postprocessed, as it omits the default separation character
(C<:> , see above) and just uses on single tab character (0x09, \t  or
TAB) to separate the label text from the text of the result. Example:

	Label of the performed checkTABresult

More examples for postprocessing the output can be found here:

	https://github.com/OWASP/O-Saft/blob/master/contrib

=head1 EXIT STATUS

Following exit codes are used:

=over

=item * 0   - normal usage and execution

=back

=over

=item * 2   - command-line parsing failed, command or option missing

=back

=over

=item * >0  - only if  --exitcode  was used

=back



=head1 ENVIRONMENT

Following environment variables are incorporated:

=over

=item * LD_LIBRARY_PATH - used and extended with definitions from options

=back

=over

=item * OPENSSL         - if set, full path to openssl executable

=back

=over

=item * OPENSSL_CONF    - if set, full path to openssl's openssl.cnf or

=back

                 directory where to find openssl.cnf

=head1 CUSTOMISATION

This tool can be customised as follows:

=over

=item * Using command-line options

=back

This is a simple way to redefine  specific settings.  Please  see
L</CONFIGURATION OPTIONS>  below.

=over

=item * Using configuration file

=back

A configuration file can contain multiple configuration settings.
Syntax is simply  KEY=VALUE. Please see L</CONFIGURATION FILE> below.

=over

=item * Using resource files

=back

A resource file can contain multiple command-line options. Syntax
is the same as for command-line options iteself.  Each  directory
may contain its own resource file. Please see  L</RC-FILE>  below.

=over

=item * Using debugging files

=back

These files are - nomen est omen - used for debugging purposes.
However, they can be (mis-)used to redefine all settings too.
Please see  L</DEBUG-FILE>  below.

=over

=item * Using user specified code

=back

This file contains  user specified  program code.  It can also be
(mis-)used to redefine all settings. Please see L</USER-FILE>  below.

Customisation is done by redefining values in internal data structure
which are:  %cfg,  %data,  %checks,  %text.

Unless used in  L</DEBUG-FILE>  or  L</USER-FILE>,  there is  no need to know
these internal data structures or the names of variables; the options
will set the  proper values.  The key names being part of the option,
are printed in output with the  I<--trace-key>  option.

Texts (values) of keys in  C<%data>  are those  used in  output of the
"Information" section.  The texts of keys in  C<%checks>  are used for
output in "Performed Checks" section.  Texts of keys in  C<%text>  are
used for additional information lines or texts (mainly beginning with
C<=>).

Configuration file vs. L</RC-FILE> vs. L</DEBUG-FILE>

=over

=item * CONFIGURATION FILE

=back

Configuration files must be specified with one of the  I<--cfg-*>
options. The specified file can be a valid path. Please note that
only the characters: C<a-zA-Z_0-9,.\/()->  are allowed as pathname.
Syntax in configuration file is:  C<KEY=VALUE>  where C<KEY> is any
key as used in internal data structure.

=over

=item * RC-FILE

=back

Resource files are searched for and used automatically.
For details see  L</RC-FILE>  below.

=over

=item * DEBUG-FILE

=back

Debug files are searched for and used automatically.
For details see  L</DEBUG-FILE>  below.

=over

=item * USER-FILE

=back

The user program file is included only  if the  I<--usr>  option was
used. For details see  L</USER-FILE>  below.

=head2 CONFIGURATION OPTIONS

Configuration options are used to redefine  texts and labels or score
settings used in output. The options are:

=over

=item * --cfg-cmd=CMD=LIST

=back

=over

=item * --cfg-checks=KEY=TEXT

=back

=over

=item * --cfg-data=KEY=TEXT

=back

=over

=item * --cfg-hint=KEY=TEXT

=back

=over

=item * --cfg-text=KEY=TEXT

=back

=over

=item * --cfg-cipher=CIPHER=TEXT

=back

C<KEY>  is the key used in the internal data structure, and  C<TEXT> is
the value to be set for this key.  Note that unknown keys are ignored
silently.

If  C<KEY=TEXT>  is an existing filename, all lines from that file are
read and set. For details see  L</CONFIGURATION FILE>  below.

C<CIPHER>  must be a valid cipher suite name as shown with:

	o-saft.pl ciphers

Note that such configuration options should be used before any I<--help>
or  I<--help=*>  option, otherwise the changed setting is not visible.

=head2 CONFIGURATION FILE

Note that the file can contain  C<KEY=TEXT> pairs for any kind of the
configuration as given by the  I<--cfg-CFG>  option.

For example  when used with  I<--cfg-text=FILE>  only values for  %text
will be set, when used with  I<--cfg-data=FILE>  only values for  %data
will be set, and so on. C<KEY> will not be used when C<KEY=TEXT> is an
existing filename.  It is recommended to use a non-existing key, for
example  I<--cfg-text=my_file=some/path/to/private/file> .

=head2 RC-FILE

The rc-file will be searched for in the working directory only.

The name of the rc-file is the name of the program file prefixed by a
C<.>  (dot),  for example:  C<.o-saft.pl>.

A  rc-file  can contain any of the commands and options valid for the
tool itself. The syntax for them is the same as on command-line. Each
command or option must be in a single line. Any empty or comment line
will be ignored. Comment lines start with  C<#>  or  C<=>.

Note that options with arguments must be used as  C<KEY=VALUE> instead
of  C<KEY VALUE>.

Configurations options must be written like C<--cfg-CFG=KEY=VALUE>.
Where  C<CFG>  is any of:  C<cmd>, C<check>, C<data>, C<text>  and  C<KEY>
is any key from internal data structure (see above).

All commands and options given on command-line will  overwrite  those
found in the rc-file.

=head2 DEBUG-FILE

All debugging functionality is defined in L<o-saft-dbx.pm|o-saft-dbx.pm> , which will
be searched for using paths available in  C<@INC>  variable.

Syntax in this file is Perl code.  For details see  L</DEBUG>  below.

=head2 USER-FILE

All user functionality is defined in  L<o-saft-usr.pm|o-saft-usr.pm> ,  which will be
searched for using paths available in  C<@INC>  variable.

Syntax in this file is Perl code.

All functions defined in  L<o-saft-usr.pm|o-saft-usr.pm>  are called when the option
I<--usr>  was given.  The functions are defined as empty stub,  any code
can be inserted as need.  Please see   perldoc L<o-saft-usr.pm|o-saft-usr.pm>  to see
when and how these functions are called.

=head2 SHELL TWEAKS

Configuring the shell environment where the tool is startet,  must be
done before the tool starts. It isn't a task for the tool itself, but
it can simplify your life, somehow.

There exist customisations for some commonly used shells,  please see
the files in the ./contrib/ directory.

=head2 COMMANDS

The option  I<--cfg-cmd=CMD=LIST>  can be used to define own commands.
When configuring own commands,  CMD  must not be  one of the commands
listed with  I<--help=intern>  and CMD  must constist only of digits and
letters.

Examples in  C<.o-saft.pl>  are  I<+preload>  and  I<+ciphercheck> .

=head1 CIPHER NAMES

While the SSL/TLS protocol uses integer numbers to identify  ciphers,
almost all tools use some kind of  "human readable"  texts for cipher
names.

These numbers (which are most likely written  as hex values in source
code and documentations) are the only true identifier, and we have to
rely on the tools that they use the proper integers.

As such integer or hex numbers are difficult to handle by humans,  we
decided to use human readable texts. Unfortunately no common standard
exists how to construct the names and map them to the correct number.
Some, but by far not all, oddities are described in  L</Name Rodeo>.

The rules for specifying cipher names are:

=over

=item *           1) textual names as defined by IANA (see [IANA])

=back

=over

=item *           2) mapping of names and numbers as defined by IANA (see [IANA])

=back

=over

=item *           3) C<->  and  C<_>  are treated the same

=back

=over

=item *           4) abbreviations are allowed, as long as they are unique

=back

=over

=item *           5) beside IANA, openssl's cipher names are preferred

=back

=over

=item *           6) name variants are supported, as long as they are unique

=back

=over

=item *           7) hex numbers can be used

=back

=over

=item *           8) our internal hex numbers for ciphers are like C<0x0300CCA9>

=back

[IANA]    http://www.iana.org/assignments/tls-parameters/tls-parameters.txt August 2022

[openssl] ... openssl 1.0.1

If in any doubt, use any of the  provided commands or options to list
to show our known ciphers. For example:

	o-saft.pl --test-ciphers-show  # or any other  --test-ciphers-*
	o-saft.pl --list
	o-saft.pl --help=ciphers-text
	o-saft.pl ciphers -V

Use  I<--help=regex>  to see which regex are used to handle all variants
of cipher suite names herein.

Mind the traps and dragons with cipher names and what number they are
actually mapped to. In particular when  I<--lib>,  I<--exe>  or  I<--openssl>
options are in use. Always use these options with  I<+list> command too.

=head2 Name Rodeo

As said above, the  SSL/TLS protocol uses integer numbers to identify
ciphers, but almost all tools use some kind of  human readable  texts
for cipher names.

For example the cipher commonly known as C<DES-CBC3-SHA> is identified
by C<0x020701c0> (in openssl) and has C<SSL2_DES_192_EDE3_CBC_WITH_SHA>
as constant name. A definition is missing in IANA, but there is
C<TLS_RSA_WITH_3DES_EDE_CBC_SHA>.  There is also C<0x000A> for the same
cipher C<DES-CBC3-SHA>.  Both are valid, first one if used with SSLv2,
and second one when used with SSLv3.
It's the responsibility of each tool to map the human readable cipher
name to the correct (hex, integer) identifier.

For example Firefox uses  C<dhe_dss_des_ede3_sha>,  which is what?

Furthermore, there are different acronyms for the same thing in use.
For example  C<DHE>  and  C<EDH>  both mean "Ephemeral Diffie-Hellman".
Comments in the L<openssl(1)|openssl(1)> sources mention this.  And for curiosity
these sources use both in cypher names, but allow  C<EDH>  as shortcut
only in openssl's "ciphers"  command. Wonder about (up to 1.0.1h):

	openssl ciphers -V EDH
	openssl ciphers -V DHE
	openssl ciphers -V EECDH
	openssl ciphers -V ECDHE

Next example is  C<ADH>  which is also known as  C<DH_anon> or C<DHAnon>
or  C<DHA>  or  C<ANON_DH>.

You think this is enough? Then have a look how many acronyms are used
for  "Tripple DES".

Compared to above, the interchangeable use of  C<->  vs.  C<_> in human
readable cipher names is just a very simple one. However, see openssl
again what following means (returns):

	openssl ciphers -v RC4-MD5
	openssl ciphers -v RC4+MD5
	openssl ciphers -v RC4:-MD5
	openssl ciphers -v RC4:!MD5
	openssl ciphers -v RC4!MD5

Looking at all these oddities, it would be nice to have a common unique
naming scheme for cipher names. We have not.  As the SSL/TLS protocol
just uses a number, it would be natural to use the number as uniq key
for all cipher names, at least as key in our internal sources.

Unfortunately, the assignment of ciphers to numbers  changed over the
years, which means that the same number refers to a  different cipher
depending on the standard, and/or tool, or version of a tool you use.

As a result, we cannot use human readable cipher names as  identifier
(a.k.a unique key), as there are to many aliases for the same cipher.
And also the number  cannot be used  as unique key, as a key may have
multiple ciphers assigned.

The default behaviour will be to use the cipher names like L<openssl(1)|openssl(1)>
does. If a name is ambigous, the first matching will be choosen. This
-first matching- only applies to names provided by the user by option
or whatever, internally the latest IANA number will be used,  because
they have the most less ambiguities.

=head1 KNOWN PROBLEMS

This section describes knwon problems, and known error messages which
may occour when using o-saft.pl. This sections can be used as FAQ too
as it gives hints and workarounds.

=head2 Segmentation fault

Sometimes  the program terminates with a  C<Segmentation fault>.  This
mainly happens if the target does not return certificate information.
If so, the  I<--no-cert>  option may help.

=head2 **WARNING: 311: empty result from openssl; ignored at ...

This most likely occurs when the  provided cipher is  not accepted by
the server, or the server expects client certificates.

=head2 **WARNING: 311: unknown result from openssl; ignored at ...

This most likely occurs when the L<openssl(1)|openssl(1)> executable is used with a
very slow connection. Typically the reason is a connection timeout.
Try to use  I<--timeout=SEC>  option.
To get more information, use  I<--v> I<--v>  and/or  I<--trace>  also.

=head2 **WARNING: 016: undefined cipher description

May occour if ciphers are checked, but no description is available for
them herein. This results in printed cipher checks like:

	EXP-KRB5-RC4-MD5                no       <<undef>>

instead of:

	EXP-KRB5-RC4-MD5                no       weak

=head2 **WARNING: 205: Can't make a connection to your.tld:443; no initial data

=head2 **WARNING: 205: Can't make a connection to your.tld:443; target ignored

This message occours if the underlaying  SSL library (i.e. libssl.a)
was not able to connect to the target. Known observed reasons are:

=over

=item * target does not support SSL protocol on specified port

=back

=over

=item * target expects a client certificate in ClientHello message

=back

More details why the connection failed can be seen using  I<--trace=2> .

=head2 Use of uninitialized value $headers in split ... do_httpx2.al)

The warning message (like follows or similar):

	Use of uninitialized value $headers in split at blib/lib/Net/SSLeay.pm
	(autosplit into blib/lib/auto/Net/SSLeay/do_httpx2.al) line 1290.

occurs if the target refused a connection on port 80.
This is considered a bug in L<Net::SSLeay(3pm)|Net::SSLeay(3pm)>.
Workaround to get rid of this message: use  I<--no-http>  option.

=head2 invalid SSL_version specified at ... IO/Socket/SSL.pm

This error may occur on systems where a specific  SSL version is not
supported. Subject are mainly  SSLv2, SSLv3 TLSv1.3 and DTLSv1.
For DTLSv1 the full message looks like:

	invalid SSL_version specified at C:/programs/perl/perl/vendor/lib/IO/Socket/SSL.

See also  L</Note on SSL versions> .

Workaround: use option:  I<--no-sslv2>  I<--no-sslv3>  I<--no-tlsv13>  I<--no-dtlsv1>

=head2 Use of uninitialized value $_[0] in length at (eval 4) line 1.

This warning occours with IO::Socket::SSL 1.967, reason is unknown.
It seems not to harm functionality, hence no workaround, just ignore.

=head2 Use of uninitialized value in subroutine entry at lib/IO/Socket/SSL.pm line 430.

Some versions of  IO::Socket::SSL return this error message if  *-MD5
ciphers are used with other protocols than SSLv2.

Workaround: use  I<--no-md5-cipher>  option.

=head2 Can't locate auto/Net/SSLeay/CTX_v2_new.al in @INC ...

Underlaying library doesn't support the required SSL version.
See also  L</Note on SSL versions> .

Workaround: use  I<--ssl-lazy> option, or corresponding I<--no-SSL > option.

=head2 Read error: Connection reset by peer (,199725) at blib/lib/Net/SSLeay.pm\

=head2 (autosplit into blib/lib/auto/Net/SSLeay/tcp_read_all.al) line 535.

Error reported by some Net::SSLeay versions. Reason may be a timeout.
This error cannot be omitted or handled properly.

Workaround: try to use same call again (no guarantee, unfortunatelly)

=head2 Odd number of elements in anonymous hash at Net/SSLinfo.pm line 1613.

This warning from perl have been observed  when the connection to the
target to check for supported ciphers cannot be established.

This message can be ignored.

=head2 openssl: ...some/path.../libssl.so.1.0.0: no version information available (required by openssl)

Mismatch of  openssl executable  and loaded underlaying library. This
most likely happens when options  I<--lib=PATH>  and/or  I<--exe=PATH>  are
used.  See also  L</Note on SSL versions> .

Hint: use following commands to get information about used libraries:

	o-saft.pl +version
	o-saft.pl --v --v +version

=head2 Integer overflow in hexadecimal number at ...

This error message may occour on  32-bit systems if perl was not com-
piled with proper options. I.g. perl automatically converts the value
to a floating pont number.
Please report a bug with output of following command:

	o-saft.pl +s_client +dump your.tld

=head2 openssl did not return DH Paramter>>

Text may be part of a value. This means that all checks according  DH
parameters and logkam attack cannot be done.

Workaround: try to use  I<--openssl=TOOL >  option.

This text may appear in any of the compliance checks (like  I<+rfc7525>)
which may be a false positive.  For these checks openssl is also used
to get the DH Parameter.

Workaround: not available yet

=head2 No output with  +help  and/or  --help=todo

On some (mainly Windows-based) systems using

	o-saft.pl +help
	o-saft.pl --help

does not print anything.

Workaround: use  I<--v>  option.

	o-saft.pl +help --v

or

	o-saft.pl +help | more

=head2 Character set (like UTF-8) not recognised in some tools

Some tools  do not display all characters properly,  for example some
versions of  podviewer.  It is not the obligation of this tool to fix
well known bugs in other tools. However, we can offer workarounds.

Workaround: generate the affected output using  I<--std-format=*>  options
For example:

	o-saft.pl --no-rc --std-format=raw --help=gen-pod

=head2 **WARNING: on MSWin32 additional option  --v  required, sometimes ...

On some (mainly Windows-based) systems  this may happen  when calling
for example:

	o-saft.pl --help=FAQ

which then may produce:

	**WARNING: on MSWin32 additional option  --v  required, sometimes ...
	=== reading: ./.o-saft.pl (RC-FILE done) ===
	=== reading: Net/SSLinfo.pm (O-Saft module done) ===
	**USAGE: no command given
	# most common usage:
	o-saft.pl I+info&   your.tld&
	o-saft.pl I+check&  your.tld&
	o-saft.pl I+cipher& your.tld&
	# for more help use:
	o-saft.pl I--help&&

Workaround: use full path to perl.exe, for example

	C:\Programs\perl\bin\perl.exe o-saft.pl --help=FAQ

=head2 Performance problems

There are various reasons when the program responds slow, or seems to
hang. Performance issues are most likely a target-side problem.  Most
common reasons are (no specific order):

=over

=item *           a) DNS resolver problems

=back

Try with  I<--no-dns>

=over

=item *           b) target does not accept connections for https

=back

Try with  I<--no-http>

=over

=item *           c) target's certificate is not valid

=back

Try with  I<--no-cert>

=over

=item *           d) target expects that the client provides a client certificate

=back

No option provided yet ...

=over

=item *           e) target does not handle Server Name Indication (SNI)

=back

Try with  I<--no-sni>

=over

=item *           f) use of external L<openssl(1)|openssl(1)> executable

=back

Use  I<--no-openssl>

=over

=item *           g) target does not respond at all and/or blocks

=back

Use  I<--ssl-error>
For a detailed description, please see L</Connection problems>.

Other options which may help to get closer to the problem's cause:
I<--trace-time>,  I<--timeout=SEC>,  I<--trace>,  I<--trace-cmd>

Using  I<--trace-time>   should show following times:

=over

=item * DNS:             1 -  10 sec

=back

=over

=item * need_default:    <5 sec

=back

=over

=item * need_cipher:     1 - 299 sec (+cipher with socket)

=back

=over

=item * no SNI:          1 -  10 sec

=back

=over

=item * connection test: 1 -   5 sec

=back

=over

=item * prepare checks:  2 -  20 sec

=back

=over

=item *   checkalpn.     1 -  15 sec

=back

=over

=item *   checkprot.     1 -  15 sec

=back

=over

=item * cipher:          <1 sec

=back

=over

=item * info:            <1 sec

=back

=over

=item * check:           <1 sec

=back

=head1 LIMITATIONS

=head2 Commands

Some commands cannot be used together with others, for example:
I<+cipher>,  I<+ciphers>,  I<+list>,  I<+libversion>,  I<+version>,  I<+check>,  I<+help>,
I<+protocols> .

I<+quick>  should not be used together with other commands, it returns
strange output then. It is the only command which allows  I<+cipher>
together with other commands.

I<+protocols>  requires L<openssl(1)|openssl(1)> with support for  C<-nextprotoneg>
option. Otherwise the value will be empty.

=head2 Options

The option  I<--port=PORT>  must preceed  I<--host=HOST>  for a target like
HOST:PORT  .

The characters  C<+> and C<=>  cannot be used for  I<--separator=CHAR>
option.

Following strings should not be used in any value for options:
C<+check>, C<+info>, C<+quick>, C<--header>
as they my trigger the  I<--header>   option unintentional.

The used L<timeout(1)|timeout(1)> command cannot be defined with a full path like
L<openssl(1)|openssl(1)> can with the  I<--openssl=path/to/openssl> .

I<--cfg-text=FILE>  cannot be used to redefine the texts  C<yes> and C<no>
as used in the output for  I<+cipher>  command.

=head2 Checks (general)

=head3 +constraints

This check is only done for the certificate provided by the target.
All other certificate in the chain are not checked.

This is currently (2018) a limitation in  o-saft.pl.

=head2 Broken pipe

This error message most likely means that the connection to specified
target was not possible (firewall or whatever reason).

=head2 Target Certificate Chain Verification

The systems default capabilities for example  libssl.so, openssl, are
used to verify the target's certificate chain.  Unfortunately various
systems have implemented different  approaches and rules how identify
and how to report a successful verification.  Consequently, this tool
can only return the same information  about the chain verification as
the used underlying tools. If that information is trustworthy depends
on how trustworthy the tools are.

These limitations apply to following commands:

=over

=item * +verify

=back

=over

=item * +selfsigned

=back

Following commands and options are useful to get more information:

=over

=item * +chain_verify,  +verify,  +error_verify,  +chain,  +s_client

=back

=over

=item * --ca-file,  --ca-path,  --ca-depth

=back

=head2 User provided files

Please note that there cannot be any guarantee that the code provided
in the  L</DEBUG-FILE> L<o-saft-dbx.pm|o-saft-dbx.pm> or  L</USER-FILE> L<o-saft-usr.pm|o-saft-usr.pm> will
work flawless. Obviously this is the user's responsibility.

=head2 Problems and errors

Checking the target for supported ciphers may return that a cipher is
not supported by the server  misleadingly.  Reason is most likely  an
improper timeout for the connection. See  I<--timeout=SEC>  option.

If the specified targets accepts connections but does not speak  SSL,
the connection will be closed after the system's TCP/IP-timeout. This
script will hang (about 2-3 minutes).

If reverse DNS lookup fails, an error message is returned as hostname,
like:  C<<<gethostbyaddr() failed>>>.
Workaround to get rid of this message: use  I<--no-dns>  option.

All checks for EV are solely based on the information provided by the
certificate.

Some versions of openssl (< 1.x) may not support all required options
which results in various error messages,  or  more worse,  may not be
visibale at all. Available functionalitity of openssl will be checked
for right at the beginning. Proper warnings and hints are printed.
Following table shows the openssl option and how to disable it within

	o-saft.pl:

=over

=item * -nextprotoneg       --no-nextprotoneg

=back

=over

=item * -reconnect          --no-reconnect

=back

=over

=item * -tlsextdebug        --no-tlsextdebug

=back

=over

=item * -alpn               --no-alpn

=back

=head2 Connection problems

Sometimes the connection cannot be established. This may have various
reasons.  Unfortunaly this script seems to hang then.  In  particular
when checking for ciphers with  I<+cipher>  command.  The reason is most
likely that the server does not respond to the TCP/IP request,  hence
the script closes the connection after the configured timeout (please
see  I<--timeout=SEC>  option).

Continous connection attempts  can be inhibited with the  I<--ssl-error>
option, which is set by default. Avoiding further connections results
in a loss of information and consequentely, leads to wrong checks.

It is a trade-off to wait for all information done accurately,  or to
get the results quickly. The logic to stop connecting for I<--ssl-error>
can be controlled with following additional options:

=over

=item * --ssl-error-max=CNT      - max. continous errors

=back

=over

=item * --ssl-error-timeout=SEC  - treat a failure as error after timeout

=back

=over

=item * --ssl-error-total=CNT    - max. amount of errors

=back

This means that no more connections are made when more than

=over

=item * --ssl-error-max errors occour sequentialy

=back

or

=over

=item * --ssl-error-total errors occoured

=back

Examples:

=over

=item * --ssl-error-max=3

=back

=over

=item * --ssl-error-timeout=6

=back

=over

=item * --ssl-error-total=6

=back

no more connections are made if for example  any sequence of timeouts
occour:

	0 5 2 2                   - --ssl-error-max matches
	0 1 3 0 0 0 4 1 2 2 2     - --ssl-error-max matches
	0 5 0 2 0 2 2 0 2 0 2     - --ssl-error-total matches

This allows to fine-tune the condition when to stop connecting to the
target. For example, continous but not consecutive timeouts may indi-
cate a bad or instable network connection, but not that the target to
be connected blocks. In such a case sequence of timeouts like follows
may be observed (assuming  I<--ssl-error-max=3>):

	0 5 1 2 2 2 4 2 3 2 3 3 3 2
	. . . ^                 ^____ stop for  --ssl-error-timeout=3
	. . . |______________________ stop for  --ssl-error-timeout=2

On normal (even slow) network connections  dozens of  connections per
second are usual, hence the timeout is always  0 or 1.  Based on that
experience  I<--ssl-error>  is enabled and set with defaults as follows:

=over

=item * --ssl-error-max=5

=back

=over

=item * --ssl-error-timeout=1

=back

=over

=item * --ssl-error-total=10

=back

=head2 Poor systems

Use of L<openssl(1)|openssl(1)> is disabled by default on  Windows due to various
performance problems. It needs to be enabled with  I<--openssl>  option.

On Windows the usage of  "openssl s_client" needs to be enabled using
I<--s_client>  option.

On Windows it's a pain to specify a correct path for  I<--openssl=TOOL >
option. Variants are:

=over

=item * --openssl=/path/to/openssl.exe

=back

=over

=item * --openssl=X:/path/to/openssl.exe

=back

=over

=item * --openssl=\path\to\openssl.exe

=back

=over

=item * --openssl=X:\path\to\openssl.exe

=back

=over

=item * --openssl=\\path\\to\\openssl.exe

=back

=over

=item * --openssl=X:\\path\\to\\openssl.exe

=back

You have to fiddle around to find the proper one.

=head2 Debug and trace output

When both  I<--trace-key>  and  I<--trace-cmd>  options are used, output is
mixed, obviously.
Hint: output for  I<--trace-cmd>  always contains "CMD".

Any  I<--trace*>  option implies  I<--trace-time> .

=head1 DEPENDENCIES

All Perl modules and all  private moduels and files  will be searched
for using paths  available in the  C<@INC>  variable.  C<@INC>  will be
prepended by following paths:

=over

=item * .

=back

=over

=item * ./lib

=back

=over

=item * INSTALL_PATH

=back

=over

=item * INSTALL_PATH/lib

=back

Where  C<INSTALL_PATH>  is the path where the tool is installed.
To see which files have been included use:

	o-saft.pl +version --v --user

=head2 Perl modules

=over

=item * L<IO::Socket::SSL(3pm)|IO::Socket::SSL(3pm)>

=back

=over

=item * L<IO::Socket::INET(3pm)|IO::Socket::INET(3pm)>

=back

=over

=item * L<Net::SSLeay(3pm)|Net::SSLeay(3pm)>

=back

=over

=item * L<Net::SSLinfo|Net::SSLinfo>

=back

=over

=item * L<Net::SSLhello|Net::SSLhello>

=back

Perl modules loaded and used for some options only:

=over

=item * Net::DNS(3pm)

=back

=over

=item * Time::Local(3pm)

=back

=head2 Additional files used if requested

=over

=item * .o-saft.pl

=back

=over

=item * L<o-saft-dbx.pm|o-saft-dbx.pm>

=back

=over

=item * L<o-saft-man.pm|o-saft-man.pm>

=back

=over

=item * L<o-saft-usr.pm|o-saft-usr.pm>

=back

=over

=item * o-saft-docker

=back

=over

=item * L<o-saft-README|o-saft-README>

=back

=head1 INSTALLATION

The tool can be installed in any path. It just requres the modules as
described in  L</DEPENDENCIES>  above. However, it's recommended that the
modules L<Net::SSLhello|Net::SSLhello> and L<Net::SSLinfo|Net::SSLinfo> are found in the directory
C<./Net/>  where  C<o-saft.pl>  is installed.

For security reasons, most modern libraries  disabled or even removed
insecure or "dirty" functionality.  As the purpose of this tool is to
detect such insecure settings, functions, etc.,  it needs these dirty
things enabled. It needs (incomplete list):

=over

=item * insecure protocols like SSLv2, SSLv3,

=back

=over

=item * more ciphers enabled, like NULL-MD5, AECDH-NULL-SHA, etc.,

=back

=over

=item * some SSL extensions and options.

=back

Therefore we recommend to compile and install at least following:

=over

=item * OpenSSL  with SSLv2, SSLv3 and more ciphers enabled,

=back

=over

=item * Net::SSLeay  compiled with openssl version as described before.

=back

Please read the  L</SECURITY>  section first before following the install
instructions below.

=head2 Quickstart

The script  INSTALL.sh  provides a quick method to check, compile and
install anything needed. Please see:

INSTALL.sh I<--help>

For more details, read on ...

=head2 Requirements for OpenSSL

To build openssl following packages are requred  (note that the names
may differ depending on the used platform):

=over

=item * libidn11-dev

=back

=over

=item * libidn2-0-dev

=back

=over

=item * libgmp-dev

=back

=over

=item * libzip-dev

=back

=over

=item * libsctp-dev

=back

=over

=item * libkrb5-dev

=back

Also, following Perl modules should be installed:

=over

=item * Module::Build

=back

=over

=item * Net::LibIDN

=back

=over

=item * Net::LibIDN2

=back

=over

=item * Mozilla::CA

=back

=head2 OpenSSL

Currently (since 18.06.18) it is recommend to build openssl using:

	contrib/install_openssl.sh

Other possibilities are:

=over

=item * compiling openssl using following sources

=back

https://github.com/PeterMosmans/openssl/
see  L</Example: Compile openssl>,

=over

=item * use any of the precomiled versions provided by https://testssl.sh/

=back

=over

=item * use Docker owasp/o-saft (which contains a special openssl)

=back

The sources are available at

=over

=item * https://github.com/PeterMosmans/openssl/archive/1.0.2-chacha.zip

=back

A precomiled static versions are available at

=over

=item * https://github.com/drwetter/testssl.sh/ (see bin directory there)

=back

For all following installation examples we assume:

=over

=item * openssl-1.0.2-chacha.zip or openssl-1.0.2d.tar.gz

=back

=over

=item * /usr/local as base installation directory

=back

=over

=item * a bourne shell (sh) compatible shell

=back

=head2 Example: Precompiled OpenSSL

Simply download the tarball or zip file for your platform, unpack it,
and install (copy) the binaries into a directory of your choice.

Note that  Net::SSLeay  needs to be adapted properly then.

=head2 Example: Compile openssl

OpenSSL can be used from http://openssl.org/ or, as recommended, from
https://github.com/PeterMosmans/openssl/ .

OpenSSL-chacha
Compiling and installing the later is as simple as:

	unzip openssl-1.0.2-chacha.zip
	cd openssl-1.0.2-chacha
	./config --shared -Wl,-rpath=/usr/local/lib
	make
	make test
	make install

which will install openssl, libssl.so, libcrypto.so  and some include
files as well as the include files in  /usr/local/ .
The shared version of the libraries are necessary for  Net::SSLeay.

For a more complete build, plese see:  contrib/install_openssl.sh .

OpenSSL.org
Building openssl from the offical  openssl.org  sources requires some
patching before compiling and installing the libraries and binaries.

Example with openssl-1.0.2d:

	echo == unpack tarball
	tar xf openssl-1.0.2d.tar.gz
	cd openssl-1.0.2d

	echo == backup files to be modified
	cp ssl/s2_lib.c{,.bak}
	cp ssl/s3_lib.c{,.bak}
	cp ssl/ssl3.h{,.bak}
	cp ssl/tls1.h{,.bak}

	echo == patch files
	vi ssl/tls1.h         +/TLS1_ALLOW_EXPERIMENTAL_CIPHERSUITES/
	# define TLS1_ALLOW_EXPERIMENTAL_CIPHERSUITES  1
	vi ssl/ssl3.h ssl/s{2,3}_lib.c   +"/# *if 0/"
	#==> remove all   # if 0  and corresponding  #endif
	#    except if lines contain:
	#        _FZA
	#        /* Fortezza ciphersuite from SSL 3.0
	#        /* Do not set the compare functions,
	#        if (s->shutdown  SSL_SEND_SHUTDOWN)&

	echo == configure with static libraries
	echo omitt the zlib options if zlib-1g-dev is not installed
	echo omitt the krb5 options if no kerberos libraries available
	LD_RUN_PATH=/usr/local/openssl/lib
	LDFLAGS="-rpath=$LD_RUN_PATH" & export LDFLAGS&
	./config --prefix=/usr/local --openssldir=/usr/local/ssl \
	enable-zlib zlib zlib-dynamic enable-ssl2 \
	enable-krb5 --with-krb5-flavor=MIT \
	enable-mdc2 enable-md2 enable-rc5  enable-rc2 \
	enable-cms  enable-ec  enable-ec2m enable-ecdh enable-ecdsa \
	enable-gost enable-seed enable-idea enable-camellia \
	enable-rfc3779 enable-ec_nistp_64_gcc_128 \
	experimental-jpake -fPIC \
	-DTEMP_GOST_TLS -DTLS1_ALLOW_EXPERIMENTAL_CIPHERSUITES \
	-shared

	echo == make binaries and libraries
	make depend
	make
	make test
	make install

	echo == if you want static binaries and libraries
	make clean
	echo same ./config as before but without shared option
	./config --prefix=/usr/local --openssldir=/usr/local/ssl \
	enable-zlib zlib zlib-dynamic enable-ssl2 \
	enable-krb5 --with-krb5-flavor=MIT \
	enable-mdc2 enable-md2 enable-rc5  enable-rc2 \
	enable-cms  enable-ec  enable-ec2m enable-ecdh enable-ecdsa \
	enable-gost enable-seed enable-idea enable-camellia \
	enable-rfc3779 enable-ec_nistp_64_gcc_128 \
	experimental-jpake -fPIC  -static \
	-DTEMP_GOST_TLS -DTLS1_ALLOW_EXPERIMENTAL_CIPHERSUITES
	make depend
	make
	make test
	echo next make will overwrite the previously installed dynamic
	echo shared openssl binary with the static openssl binary
	make install

=head2 Example: Compile Net::SSLeay

To enable support for ancient protocol versions,  Net::SSLeay must be
compiled manually after patching C<SSLeay.xs> (see below).
Reason is, that  Net::SSLeay  enables some functionality for  SSL/TLS
according the identified openssl version. There is, currently (2015),
no possibility to enable this functionality  by passing options on to
the configuration script C<perl Makefile.PL>.

Building our own library and module (with openssl from C</usr/local>):

	echo == unpack tarball
	tar xf Net-SSLeay-1.72.tar.gz
	cd Net-SSLeay-1.72

	echo == patch files
	echo "edit SSLeay.xs and change some #if as described below"
	LD_RUN_PATH=/usr/local/openssl/lib
	LDFLAGS="-rpath=$LD_RUN_PATH" & export LDFLAGS&
	env OPENSSL_PREFIX=/usr/local perl Makefile.PL PREFIX=/usr/local \
	INC=-I/usr/local/include  DEFINE=-DOPENSSL_BUILD_UNSAFE=1
	make
	make install
	cd /tmp & o-saft.pl +version&

SSLeay.xs needs to be changed as follows:

=over

=item * search for

=back

	#ifndef OPENSSL_NO_SSL2
	#if OPENSSL_VERSION_NUMBER < 0x10000000L

	const SSL_METHOD *
	SSLv2_method()

	#endif
	#endif

	#ifndef OPENSSL_NO_SSL3
	#if OPENSSL_VERSION_NUMBER < 0x10002000L

	const SSL_METHOD *
	SSLv3_method()

	#endif
	#endif

=over

=item * and replace by

=back

	const SSL_METHOD *
	SSLv2_method()

	const SSL_METHOD *
	SSLv3_method()

Note that  Net::SSLeay  will be installed in C</usr/local/> then. This
can be adapted to your needs by passing another path to the  C<PREFIX>
and  C<DESTDIR>  parameter.

Following command can be used to check  which methods are avilable in
Net::SSLeay, hence above patches can be verified:

	perl -MNet::SSLinfo -le 'print Net::SSLinfo::ssleay_test();'

=head2 Testing OpenSSL

After installation as descibed above finished, openssl may be tested:

	echo already installed openssl (found with PATH environment)
	openssl ciphers -v
	openssl ciphers -V -ssl2
	openssl ciphers -V -ssl3
	openssl ciphers -V ALL
	openssl ciphers -V ALL:COMPLEMENTOFALL
	openssl ciphers -V ALL:eNULL:EXP

	echo own compiled and installed openssl
	/usr/local/openssl ciphers -v
	/usr/local/openssl ciphers -V -ssl2
	/usr/local/openssl ciphers -V -ssl3
	/usr/local/openssl ciphers -V ALL
	/usr/local/openssl ciphers -V ALL:COMPLEMENTOFALL
	/usr/local/openssl ciphers -V ALL:eNULL:EXP

The difference should be obvious.
Note, the commands using  C<ALL:COMPLEMENTOFALL>  and  C<ALL:eNULL:EXP>
should return the same result.

=head2 Testing Net::SSLeay

As we want to test the separately installed  Net::SSLeay,  it is best
to do it with  o-saft.pl  itself:

	o-saft.pl +version

we should see a line similar to follwong at the end of the output:

	Net::SSLeay   1.72  /usr/local/lib/x86_64-linux-gnu/perl/5.20.2/Net/SSLeay.pm

Now check for supported (known) ciphers:

	o-saft.pl ciphers -V

we should see lines similar to those of the last C</usr/local/openssl>
call. However, it should contain more cipher lines.

=head2 Stand-alone executable

Some people asked for a stand-alone executable (mainly for Windows).
Even Perl is a scripting language there are situations where a stand-
alone executable would be nice, for example if the installed perl and
its libraries are outdated, or if perl is missing at all.

Currently (2016) there are following possibilities to generate such a
stand-alone executable:

=over

=item * perl with PAR::Packer module

=back

	pp -C -c o-saft.pl
	pp -C -c o-saft.pl -M Net::DNS -M Net::SSLeay -M IO::Socket \
	-M Net::SSLinfo -M Net::SSLhello -M osaft
	pp -C -c checkAllCiphers.pl
	pp -C -c checkAllCiphers.pl -M Net::DNS

=over

=item * ActiveState perl with its perlapp

=back

	perlapp --clean o-saft.pl
	perlapp --clean o-saft.pl -M Net::DNS -M Net::SSLeay -M IO::Socket \
	-M Net::SSLinfo -M Net::SSLhello -M osaft
	perlapp --clean checkAllCiphers.pl
	perlapp --clean checkAllCiphers.pl -M Net::DNS -M osaft

=over

=item * perl2exe from IndigoSTar

=back

	perl2exe o-saft.pl
	perl2exe checkAllCiphers.pl

For details  on building the executable,  for example  how to include
all required modules, please refer to the documentation of the tool.

=over

=item * http://search.cpan.org/~rschupp/PAR-Packer-1.030/lib/PAR/Packer.pm

=back

=over

=item * http://docs.activestate.com/pdk/6.0/PerlApp.html

=back

=over

=item * http://www.indigostar.com

=back

Note that  pre-build executables (build by perlapp, perl2exe)  cannot
be provided due to licence problems.
Also note that using  stand-alone executable have not been tested the
same way as the  o-saft.pl  itself. Use them at your own risk.

=head1 ABOUT CGI

This script can be used as CGI application.  Output is the same as in
common CLI mode. The output will be prefixed with the HTTP header
C<Content-Type:text/plain>.
The script  o-saft.cgi  should be used as wrapper for o-saft.pl .
The HTML form  o-saft.cgi.html  which can be generated with:

	o-saft.pl --help=gen-cgi

should be used as front-end for  o-saft.cgi.

=head2 CGI-form functionality

This form provides following functionality:

=over

=item * top menu bar with following menus:

=back

=over

=item * ☰           - general informations about CGI usage

=back

=over

=item * Cmd         - quick commands menu

=back

=over

=item * Opt         - quick options menu

=back

=over

=item * Help        - various help pages

=back

=over

=item * input field for a target (hostname or URL)

=back

=over

=item * GUI sections

=back

=over

=item * Simple GUI  - simple form with most common commands and options

=back

             Each provided I<+command> buttons submit the form with
             the selected options and the clicked command.

=over

=item * Full GUI Commands & Options

=back

           - form with all commands and options,  its content is
             The same as the  L</COMMANDS>  and  L</OPTIONS>  section of
             the complete help page (see  I<--help>  ).

In both GUI sections following buttons exist:

=over

=item * ^             - return to top of form

=back

=over

=item * start         - submit form with selected command and options

=back

In general, command buttons which submit the form are yellow. Buttons
which show some help, mainly in a new browser tab, are gray.

=head2 CGI-form limitations

=over

=item * The generated form provides commands and options which are rejected

=back

by  o-saft.cgi  (see below).

=over

=item * The generated form may contain references (links) to sections which

=back

are not part of the form.

=over

=item * Only one target can be provided,  however, it is obvious how to use

=back

more targets ...

=over

=item * The  --format=html  option should be used together with  --header ,

=back

otherwise the generated HTML may be corrupted for some commands.

=head2 CGI script limitations

The script returns an empty page (HTML body) for following reasons:

=over

=item * Use of local or multicast IPs as target.

=back

=over

=item * Use of dangerous commands or options.

=back

For deatils pleasesee

	perldoc o-saft.cgi

=head1 DOCKER

The tool can be used inside a Docker image. To start  o-saft.pl  inside
the Docker image, use following:

	o-saft-docker +info some.tld
or

	docker run --rm -it owasp/o-saft +info some.tld

For more details, please refer to:

	o-saft-docker usage
	o-saft-docker -help

=head1 BUILD DOCKER IMAGE

The Docker image can be installed as follows:

	docker pull owasp/o-saft

The image can also easily be build from the Dockerfile (which is part
of the distribution) as follows:

	o-saft-docker build

To build the image from the Dockerfile with docker commands, see:

	o-saft-docker -n build

For more details, please refer to:

	o-saft-docker -help

=head1 SEE ALSO

=over

=item * L<openssl(1)|openssl(1)>, L<Net::SSLeay(3pm)|Net::SSLeay(3pm)>, L<Net::SSLhello|Net::SSLhello>, L<Net::SSLinfo|Net::SSLinfo>, L<timeout(1)|timeout(1)>

=back

=over

=item * http://www.openssl.org/docs/apps/ciphers.html

=back

=over

=item * L<IO::Socket::SSL(3pm)|IO::Socket::SSL(3pm)>, L<IO::Socket::INET(3pm)|IO::Socket::INET(3pm)>

=back

=over

=item * o-saft, o-saft-docker, o-saft-docker-dev, Dockerfile, docker

=back

=head1 HACKER's INFO

=head2 Note on SSL versions

Automatically detecting the supported SSL versions of the underlaying
system is a hard job and not always possible. Reasons could be:

=over

=item * used Perl modules (Socket::SSL, Net::SSLeay) does not handle errors

=back

properly. Erros may be:

	invalid SSL_version specified at ... IO/Socket/SSL.pm
	Use of uninitialized value in subroutine entry at lib/IO/Socket/SSL.pm

There're some workarounds implemented since version 15.11.15 .

=over

=item * the underlaying libssl does not support the version, which then may

=back

result in segmentation fault

=over

=item * the underlaying libssl is newer than the Perl module and the module

=back

has not been reinstalled. This most often happens with  Net::SSLeay
This can be detected with (see version numbers for Net::SSLeay):

	o-saft.pl +version

=over

=item * perl (in particular a used module, see above)  may bail out  with a

=back

compile error, like

	Can't locate auto/Net/SSLeay/CTX_v2_new.al in @INC ...

There're some workarounds implemented since version 15.11.15 .

We try to detect unsupported versions and disable them automatically,
a warning like follwoing is shown then:

	**WARNING: 303: SSL version 'SSLv2': not supported by openssl

All such warnings look like:

	**WARNING: 303: SSL version 'SSLv2': ...

If problems occour with  SSL versions, following commands and options
may help to get closer to the reason or can be used as workaround:

	o-saft.pl +version
	o-saft.pl +version --v
	o-saft.pl +version | grep versions
	o-saft.pl +version | grep 0x
	o-saft.pl +protocols your.tld
	o-saft.pl +protocols your.tld --no-rc

Checking for SSL version is done at one place in the code, search for

	supported SSL versions

However, there are some dirty hacks where  SSLv2 and SSLv3 is checked
again.

=head2 Using private libssl.so and libcrypt.so

For all  cryptographic functionality  the libraries  installed on the
system will be used. In particular Perl's L<Net::SSLeay(3pm)|Net::SSLeay(3pm)> module, the
system's  libssl.so and libcrypt.so  and the L<openssl(1)|openssl(1)> executable.

It is possible to provide your own libraries, if the  Perl module and
the executable are  linked using dynamic shared objects (a.k.a shared
library, position independent code).
The appropriate option is  I<--lib=PATH>.

On most systems these libraries are loaded at startup of the program.
The runtime loader uses a preconfigured list of directories  where to
find these libraries. Also most systems provide a special environment
variable to specify  additional paths  to directories where to search
for libraries, for example the  LD_LIBRARY_PATH environment variable.
This is the default environment variable used herein.  If your system
uses  another name it must be specified with the  I<--envlibvar=NAME>
option, where  L</NAME>  is the name of the environment variable.

=head2 Understanding  --exe=PATH, --lib=PATH, --openssl=TOOL

If any of  I<--exe=PATH>  or  I<--lib=PATH>  is provided, the pragram calls
(C<exec>) itself recursively with all given options, except the option
itself. The environment variables  C<LD_LIBRARY_PATH>  and C<PATH>  are
set before executing as follows:

=over

=item * prepend  C<PATH>  with all values given by  --exe=PATH

=back

=over

=item * prepend  C<LD_LIBRARY_PATH>  with all values given by  --lib=PATH

=back

This is exactly, what L</Cumbersome Approach> below describes. So these
option simply provide a shortcut for that.

Note that  I<--openssl=TOOL >  is a full path to the  openssl  executable
and will not be changed.  However, if it is a relative path, it might
be searched for using the previously set  C<PATH>  (see above).

Note that  C<LD_LIBRARY_PATH>  is the default.  It can be changed with
the  I<--envlibvar=NAME>  option.

While  I<--exe>  mainly impacts the L<openssl(1)|openssl(1)> executable,  I<--lib>  also
impacts o-saft.pl itself, as it loads other shared libraries if found.

Bear in mind that  all these options  can affect the behaviour of the
openssl subsystem,  influencing both  which executable is called  and
which shared libraries will be used.

Note that no checks are done if the options are set proper. To verify
the settings, following commands may be used:

	o-saft.pl --lib=YOUR-PATH --exe=YOUR-EXE +version
	o-saft.pl --lib=YOUR-PATH --exe=YOUR-EXE --v +version
	o-saft.pl --lib=YOUR-PATH --exe=YOUR-EXE --v --v +version

Why so many options?  Exactly as described above, these options allow
the users to tune the behaviour of the tool to their needs.  A common
use case is to enable the use of a separate openssl build independent
of the openssl package used by the operating system.  This allows the
user fine grained control over openssl's encryption suites  which are
compiled/available, without affecting the core system.

=head2 Caveats

Depending on your system and the used modules and executables, it can
be tricky to replace the configured shared libraries with own ones.
Reasons are:

=over

=item *           a) the linked library name contains a version number,

=back

=over

=item *           b) the linked library uses a fixed path,

=back

=over

=item *           c) the linked library is searched at a predefined path,

=back

=over

=item *           d) the executable checks the library version when loaded.

=back

Only the first one a) can be circumvented.  The last one d) can often
be ignored as it only prints a warning or error message.

To circumvent the "name with version number" problem try following:

=over

=item *         1) use L<ldd(1)|ldd(1)> (or a similar tool) to get the names used by openssl:

=back

	ldd /usr/bin/openssl

which returns something like:

	libssl.so.0.9.8 => /lib/libssl.so.0.9.8 (0x00007f940cb6d000)
	libcrypto.so.0.9.8 => /lib/libcrypto.so.0.9.8 (0x00007f940c7de000)
	libdl.so.2 => /lib/x86_64-linux-gnu/libdl.so.2 (0x00007f940c5d9000)
	libz.so.1 => /lib/x86_64-linux-gnu/libz.so.1 (0x00007f940c3c1000)
	libc.so.6 => /lib/x86_64-linux-gnu/libc.so.6 (0x00007f940c02c000)
	/lib64/ld-linux-x86-64.so.2 (0x00007f940cdea000)

Here only the first two libraries are important.  Both,  libcrypto.so
and libssl.so  need to be version "0.9.8" (in this example).

=over

=item *         2) create a directory for your libraries, for example:

=back

	mkdir /tmp/dada

=over

=item *         3) place your libraries there, assuming they are:

=back

	/tmp/dada/libssl.so.1.42
	/tmp/dada/libcrypto.so.1.42

=over

=item *         4) create symbolic links in that directory:

=back

	ln -s libssl.so.1.42    libssl.so.0.9.8
	ln -s libcrypto.so.1.42 libcrypto.so.0.9.8

=over

=item *         5) test program with following option:

=back

	o-saft.pl +libversion --lib=/tmp/dada
	o-saft.pl +list --v   --lib=/tmp/dada

or:

	o-saft.pl +libversion --lib=/tmp/dada -exe=/path/to-openssl
	o-saft.pl +list --v   --lib=/tmp/dada -exe=/path/to-openssl

=over

=item *         6) start program with your options, for example:

=back

	o-saft.pl --lib=/tmp/dada +ciphers

This works if L<openssl(1)|openssl(1)> uses the same shared libraries as
L<Net::SSLeay(3pm)|Net::SSLeay(3pm)>,  which most likely is the case.

It's tested with Unix/Linux only. It may work on other platforms also
if they support such an environment variable and the installed
L<Net::SSLeay(3pm)|Net::SSLeay(3pm)> and L<openssl(1)|openssl(1)> are linked using dynamic shared
objects.

Depending on  compile time settings  and/or  the location of the used
tool or lib, a warning like following may occur:

	WARNING: can't open config file: /path/to/openssl/ssl/openssl.cnf

This warning can be ignored, usually as  req  or  ca  sub commands of
openssl is not used here.
To fix the problem, either use  I<--openssl-cnf=FILE>  option or set the
the environment variable OPENSSL_CONF properly.

=head3 Cumbersome Approach

A more cumbersome approach to call  this program is to set  following
environment variables in your shell:

	PATH=/tmp/dada-1.42/apps:$PATH
	LD_LIBRARY_PATH=/tmp/dada-1.42

=head3 Windows Caveats

I.g. the used libraries on Windows are libeay32.dll and ssleay32.dll.

Windows also supports the LD_LIBRARY_PATH environment variable. If it
does not work as expected with that variable, it might be possible to
place the libs in the same directory as the  corresponding executable
(which is found by the PATH environment variable).

=head2 Using CGI mode

This script can be used as  CGI application. Output is the same as in
common CLI mode, using  C<Content-Type:text/plain>.  Keep in mind that
the used modules like L<Net::SSLeay(3pm)|Net::SSLeay(3pm)> will write some debug messages
on  STDERR instead  STDOUT.  Therefore multiple  I<--v>  and/or  I<--trace>
options behave slightly different.

No additional external files like  L</RC-FILE>  or  L</DEBUG-FILE>  are read
in CGI mode; they are silently ignored.
Some options are disabled in CGI mode  because they are dangerous  or
don't make any sense.

=head3 WARNING

There are  no  input data validation checks implemented herein. All
input data is url-decoded once and then used verbatim.
More advanced checks must be done outside before calling this tool.

It is not recommended to run this tool in CGI mode.
You have been warned!

=head2 Using user specified code

There are some functions called within the program flow, which can be
filled with any Perl code.  Empty stubs of the functions are prepared
in L<o-saft-usr.pm|o-saft-usr.pm>.  See also  L</USER-FILE> .

=head1 DEBUG

=head2 Debugging, Tracing

Following  options and commands  are useful for hunting problems with
SSL connections and/or this tool. Note that some options can be given
multiple times to increase amount of listed information. Also keep in
mind that it's best to specify  I<--v>  as very first argument.

Note that the file L<o-saft-dbx.pm|o-saft-dbx.pm> is required,  if any  I<--trace*>  or
I<--v>   option is used.

=head2 Commands

=over

=item * +dump

=back

=over

=item * +libversion

=back

=over

=item * +s_client

=back

=over

=item * +todo

=back

=over

=item * +version

=back

=head2 Options

=over

=item * --v

=back

=over

=item * --v--

=back

=over

=item * --trace

=back

=over

=item * --trace-arg

=back

=over

=item * --trace-cmd

=back

=over

=item * --trace-cli

=back

=over

=item * --trace-key

=back

=over

=item * --trace-me

=back

=over

=item * --trace-time

=back

=over

=item * --trace=FILE

=back

Please see  L</OPTIONS>  section above for detailed description.

Empty or undefined strings are written as  C<<<undefined>>>  in texts.
Some parameters, in particular those of  HTTP responses,  are written
as  C<<<response>>>.  Long parameter lists are abbreviated with C<...>.
In general, single-line values are always printed,  multi-line values
are printed with  I<--trace=2>  only.

Hint: start with  I<--trace-me>, then  I<--trace>  and finally  I<--trace=2> .

=head2 Output

When using  I<--v>  and/or  I<--trace>  options,  additional output will be
prefixed with a  C<#>  (mainly as first, left-most character.
Following formats are used:

=over

=item *            #[space]

=back

Additional text for verbosity (--v options).

=over

=item *            #[variable name][TAB]

=back

Internal variable name (--trace-key options).

=over

=item *            #o-saft.pl::

=back

=over

=item *            #L&Net::SSLinfo&::

=back

Trace information for  I<--trace>  options.

=over

=item *            #{

=back

Trace information from  NET::SSLinfo  for  I<--trace>  options.
These are data lines in the format:

	#{ variable name : value #}

Note that C<value>  here can span multiple lines and ends with:

	#}

=head2 Using outdated modules

This tool was designed to work with old Perl modules too.  When using
old modules, a proper  C<**WARNING:>  will be printed. These warinings
cannot be switched of using  I<--no-warning>  .
The warning also informs about the missing functionality or check.

I.g. it is best to install newer versions of the module if possible.
A good practice to check if modules are available in a proper version
is to call:

	o-saft.pl +version
	o-saft.pl +version --v --v

Following example shows the result without warnings:

	=== reading: ./.o-saft.pl (RC-FILE done) ===
	=== reading: Net/SSLhello.pm (O-Saft module done) ===
	=== reading: Net/SSLinfo.pm (O-Saft module done) ===
	=== ./o-saft.pl 16.09.09 ===
	Net::SSLeay::
	::OPENSSL_VERSION_NUMBER()       0x268443744
	::SSLeay()                       0x268443744
	::SSLEAY_DIR                     ENGINESDIR: "/usr/lib/x86_64-linux-gnu/engines-1.1"
	::SSLEAY_BUILD_ON                platform: debian-amd64
	::SSLEAY_PLATFORM                OPENSSLDIR: "/usr/lib/ssl"
	::SSLEAY_CFLAGS                  built on: Fri Jun 24 20:22:19 2022 UTC
	Net::SSLeay::SSLeay_version()    OpenSSL 1.0.2-chacha (1.0.2f-dev)
	= openssl =
	external executable              /opt/openssl-chacha/bin/openssl
	external executable (TLSv1.3)    openssl
	version of external executable   OpenSSL 1.0.2-chacha (1.0.2f-dev)
	used environment variable (name) LD_LIBRARY_PATH
	environment variable (content)   <<undef>>
	path to shared libraries
	full path to openssl.cnf file    <<undef>>
	common openssl.cnf files         /usr/lib/ssl/openssl.cnf \
	.                                /etc/ssl/openssl.cnf \
	.                                /System//Library/OpenSSL/openssl.cnf \
	.                                /usr/ssl/openssl.cnf
	URL where to find CRL file       <<undef>>
	directory with PEM files for CAs /opt/tools/openssl-chacha/ssl/certs
	PEM format file with CAs         /etc/ssl/certs/ca-certificates.crt
	common paths to PEM files for CAs /etc/ssl/certs /usr/lib/certs \
	.                                 /System/Library/OpenSSL
	.  existing path to CA PEM files /etc/ssl/certs
	common PEM filenames for CAs     ca-certificates.crt certificates.crt certs.pem
	.  existing PEM file for CA      /etc/ssl/certs/ca-certificates.crt
	number of supported ciphers      201
	openssl supported SSL versions   SSLv3 TLSv1 TLSv11 TLSv12
	o-saft.pl known SSL versions     SSLv2 SSLv3 TLSv1 TLSv11 TLSv12 TLSv13 \
	.                                DTLSv09 DTLSv1 DTLSv11 DTLSv12 DTLSv13
	= o-saft.pl +cipher --ciphermode=intern =
	used cipherrange                 intern
	number of supported ciphers      2640
	default list of ciphers          0x03000100 .. 0x0300013F, 0x0300FE00 .. 0x0300FFFF,
	.                                0x03000000 .. 0x030000FF, 0x03001300 .. 0x030013FF,
	.                                0x0300C000 .. 0x0300C1FF, 0x0300CC00 .. 0x0300CCFF,
	.                                0x0300D000 .. 0x0300D0FF,
	.                                0x0300FE00 .. 0x0300FFFF,
	.                                0x03000A0A, 0x03001A1A, 0x03002A2A, 0x03003A3A, 0x03004A4A,
	.                                0x03005A5A, 0x03006A6A, 0x03007A7A, 0x03008A8A, 0x03009A9A,
	.                                0x0300AAAA, 0x0300BABA, 0x0300CACA, 0x0300DADA, 0x0300EAEA, 0x0300FAFA,
	long list of ciphers             0x03000000 .. 0x030000FF, 0x0300C000 .. 0x0300FFFF
	huge list of ciphers             0x03000000 .. 0x0300FFFF
	safe list of ciphers             0x03000000 .. 0x032FFFFF
	full list of ciphers             0x03000000 .. 0x03FFFFFF
	C0xx list, range C0xx..C0FF      0x0300C000 .. 0x0300C0FF
	CCxx list, range CCxx..CCFF      0x0300C000 .. 0x0300C0FF
	ECC list, ephermeral ciphers     0x0300C000 .. 0x0300C0FF, 0x0300CC00 .. 0x0300CCFF
	SSLv2 list of ciphers            0x02000000,   0x02010080, 0x02020080, 0x02030080,
	.                                0x02040080,
	.                                0x02050080,   0x02060040, 0x02060140, 0x020700C0, 0x020701C0,
	.                                0x02FF0800,   0x02FF0810, 0x02FFFFFF,
	.                                0x03000000 .. 0x03000002, 0x03000007 .. 0x0300002C,
	.                                0x030000FF,0x0300FEE0,
	.                                0x0300FEE1, 0x0300FEFE, 0x0300FEFF,
	SSLv2_long list of ciphers       0x02000000,   0x02010080, 0x02020080, 0x02030080,
	.                                0x02040080,
	.                                0x02050080,   0x02060040, 0x02060140, 0x020700C0, 0x020701C0,
	.                                0x02FF0800,   0x02FF0810, 0x02FFFFFF,
	.                                0x03000000 .. 0x0300002F, 0x030000FF,0x0300FEE0,
	.                                0x0300FEE1, 0x0300FEFE, 0x0300FEFF,
	shifted list of ciphers          0x03000100 .. 0x0300013F, 0x0300FE00 .. 0x0300FFFF,
	.                                0x03000000 .. 0x030000FF, 0x03001300 .. 0x030013FF,
	.                                0x0300C000 .. 0x0300C1FF, 0x0300CC00 .. 0x0300CCFF,
	.                                0x0300D000 .. 0x0300D0FF,
	.                                0x0300FE00 .. 0x0300FFFF,
	.                                0x03000A0A, 0x03001A1A, 0x03002A2A, 0x03003A3A, 0x03004A4A,
	.                                0x03005A5A, 0x03006A6A, 0x03007A7A, 0x03008A8A, 0x03009A9A,
	.                                0x0300AAAA, 0x0300BABA, 0x0300CACA, 0x0300DADA,
	.                                0x0300EAEA, 0x0300FAFA,
	= Required (and used) Modules =
	@INC                 ./ ./lib . /bin /usr/share/perl5 \
	.                    /usr/lib/x86_64-linux-gnu/perl5/5.20 \
	.                    /usr/lib/x86_64-linux-gnu/perl/5.20 \
	.                    /usr/share/perl/5.20 /usr/local/lib/site_perl .
	=   module name            VERSION  found in
	=   ----------------------+--------+------------------------------------------
	IO::Socket::INET       1.41     /usr/lib/x86_64-linux-gnu/perl/5.20/IO/Socket/INET.pm
	IO::Socket::SSL        2.069    /usr/share/perl5/IO/Socket/SSL.pm
	Time::Local            1.2300   /usr/share/perl/5.24/Time/Local.pm
	Net::DNS               1.29     /usr/lib/x86_64-linux-gnu/perl5/5.20/Net/DNS.pm
	Net::SSLeay            1.88     /usr/lib/x86_64-linux-gnu/perl5/5.20/Net/SSLeay.pm
	Net::SSLinfo           22.11.22 Net/SSLinfo.pm
	Net::SSLhello          22.06.22 Net/SSLhello.pm
	Ciphers
	osaft                  22.11.22 osaft.pm

Following example shows the result with warnings (line nr. may vary):

	=== reading: ./.o-saft.pl (RC-FILE done) ===
	=== reading: ./Net/SSLhello.pm (O-Saft module done) ===
	**WARNING: 121: ancient Net::SSLeay 1.35 < 1.49; cannot use ::initialise at /Net/SSLinfo.pm line 481.
	=== reading: ./Net/SSLinfo.pm (O-Saft module done) ===
	**WARNING: 120: ancient perl has no 'version' module; version checks may not be accurate; at o-saft.pl line 1662.
	**WARNING: 121: ancient Net::SSLeay 1.35 < 1.49 detected; at o-saft.pl line 1687.
	**WARNING: 121: ancient IO::Socket::SSL 1.22 < 1.37 detected; at o-saft.pl line 1687.
	**WARNING: 124: ancient version IO::Socket::SSL 1.22 < 1.90 does not support SNI or is known to be buggy; SNI disabled; at o-saft.pl line 5905.
	!!Hint: --force-openssl can be used to disables this check
	**WARNING: 851: ancient version Net::SSLeay 1.35 < 1.49  may throw warnings and/or results may be missing; at o-saft.pl line 5934.
	**WARNING: SSL version 'TLSv11': not supported by Net::SSLeay; not checked
	**WARNING: SSL version 'TLSv12': not supported by Net::SSLeay; not checked
	**WARNING: SSL version 'TLSv13': not supported by Net::SSLeay; not checked
	=== o-saft.pl 16.09.09 ===
	Net::SSLeay::
	::OPENSSL_VERSION_NUMBER()       0x9470143
	**WARNING: 851: ancient version Net::SSLeay 1.35 < 1.49; cannot compare SSLeay with openssl version at o-saft.pl line 4778.
	::SSLeay()                       0x1.35
	**WARNING: 851: ancient version Net::SSLeay 1.35 < 1.49; detailed version not available at o-saft.pl line 4806.
	= openssl =
	version of external executable   OpenSSL 0.9.8y 5 Feb 2013
	external executable              /usr/bin/openssl
	used environment variable (name) LD_LIBRARY_PATH
	environment variable (content)   <<undef>>
	path to shared libraries
	full path to openssl.cnf file    <<undef>>
	common openssl.cnf files         /usr/lib/ssl/openssl.cnf \
	.                                /etc/ssl/openssl.cnf \
	.                                /System//Library/OpenSSL/openssl.cnf \
	.                                /usr/ssl/openssl.cnf
	URL where to find CRL file       <<undef>>
	directory with PEM files for CAs /System/Library/OpenSSL/certs
	PEM format file with CAs         <<undef>>
	common paths to PEM files for CAs /etc/ssl/certs /usr/lib/certs /System/Library/OpenSSL
	common PEM filenames for CAs     ca-certificates.crt certificates.crt certs.pem
	number of supported ciphers      43
	openssl supported SSL versions   SSLv2 SSLv3 TLSv1
	o-saft.pl known SSL versions     SSLv2 SSLv3 TLSv1 TLSv11 TLSv12 TLSv13 \
	.                                DTLSv09 DTLSv1 DTLSv11 DTLSv12 DTLSv13
	**WARNING: 851: ancient version Net::SSLeay 1.35 < 1.49; cannot compare SSLeay with openssl version at o-saft.pl line 4778.
	**WARNING: 841: used openssl version '9470143' differs from compiled Net:SSLeay '1.35'; ignored
	= o-saft.pl +cipherall =
	default list of ciphers          0x03000000 .. 0x030000FF, 0x0300C000 .. 0x0300C0FF,
	.                                0x0300CC00 .. 0x0300CCFF, 0x0300FE00 .. 0x0300FFFF,
	= Required (and used) Modules =
	@INC                 ./ ./lib /bin /Library/Perl/Updates/5.10.0 \
	.                    /System/Library/Perl/5.10.0/darwin-thread-multi-2level \
	.                    /System/Library/Perl/5.10.0 \
	.                    /Library/Perl/5.10.0/darwin-thread-multi-2level \
	.                    /Library/Perl/5.10.0 \
	.                    /Network/Library/Perl/5.10.0/darwin-thread-multi-2level \
	.                    /Network/Library/Perl/5.10.0 \
	.                    /Network/Library/Perl \
	.                    /System/Library/Perl/Extras/5.10.0/darwin-thread-multi-2level \
	.                    /System/Library/Perl/Extras/5.10.0 .
	=   module name            VERSION  found in
	=   ----------------------+--------+------------------------------------------
	IO::Socket::INET       1.31     /System/Library/Perl/5.10.0/darwin-thread-multi-2level/IO/Socket/INET.pm
	IO::Socket::SSL        1.22     /System/Library/Perl/Extras/5.10.0/IO/Socket/SSL.pm
	Net::DNS               0.65     /System/Library/Perl/Extras/5.10.0/darwin-thread-multi-2level/Net/DNS.pm
	Net::SSLeay            1.35     /System/Library/Perl/Extras/5.10.0/darwin-thread-multi-2level/Net/SSLeay.pm
	Net::SSLinfo           16.06.01 ./Net/SSLinfo.pm
	Net::SSLhello          16.05.16 ./Net/SSLhello.pm
	osaft                  16.05.10 /osaft.pm

Please keep in mind that the shown version numbers and the shown line
numbers are examples and may differ on your system.

When starting o-saft.pl with outdated modules, more C<**WARNING:> will
be shown. The warnings depend on the installed version of the module.

	o-saft.pl  is known to work with at least:
	IO::Socket::INET 1.31, IO::Socket::SSL 1.22, Net::DNS 0.65
	Net::SSLeay 1.30

=head1 TESTING

What is "testing"?
This tool itself is for testing something (TLS etc.),  so it needs to
be explained what testing here is about.  Following testing types are
distinguished and then described:

=over

=item * User testing

=back

=over

=item * Functional testing

=back

=over

=item * Developer (internal) testing

=back

All descriptions below, except  "User testing", are only intended for
development.

=head2 User testing

During normal use of the tool, "testing" is only required for hunting
problems with the connected target. Following options for tracing and
verbosity can be used for that:

=head3 --v

Print more information about checks.

=head3 --trace

Print debugging messages.
For more details, please see  L</Options for tracing and debugging> .

=head2 Functional testing

This section describes "developer" rather than "user" testing.

Functional testing mainly means testing the functionality of the tool
itself, for example: do the commands and options work as described in
the documentation:  o-saft.pl I<--help>

Makefiles are used for testing  functionality and code quality during
development. These tests are implemented in the  ./t/  directory, see
all C<Makefile.*> there, start with C<Makefile.pod>.

=head2 Developer (internal) testing

Testing SSL/TLS  is a challenging task. Beside the oddities described
elsewhere, for example  L</Name Rodeo>,  there are a bunch of problems
and errors which may occour during runtime.

Following options and commands for  o-saft.pl  are available to improve
testing.  They mainly can simulate error conditions or stop execution
properly (they are not intended for other use cases):

=head3 +quit

Stop execution after processing all arguments and before precessing
any target. The runtime configuration is complete at this point.

=head3 --exit=KEY

Terminate tool at specified C<KEY>. For available C<KEY>, please see:

	o-saft.pl --help=exit
	grep exit= o-saft.pl

=head3 --cfg-init=KEY=VALUE

With this option values in the internal  C<%cfg>  hash can be set:

	$cfg{KEY} = VALUE

Only (perl) scalars or arrays can be set. The type will be detected
automatically.

Example,  this option can be used to change the text used as prefix
in each output line triggerd by the  I<--v>  option:

	o-saft.pl --cfg-init=prefix_verbose="#VERBOSE: "

or the text used as prefix triggerd by the  I<--trace>  option:

	o-saft.pl --cfg-init=prefix_trace="#TRACE: "

The options which provide information about  internal data structures
and alike described below, behave like the command  I<+quit>  and do not
perform any checks on the target(s).  
See C<t/Makefile.*> how to use these tests.

=head3 --tests

Print overview of following commands/options.

=head3 --test-data

Print overview of all available commands and checks.

=head3 --test-maps

Print internal data strucures  C<%cfg{openssl}>,  C<%cfg{ssleay}>.

=head3 --test-prot

Print internal data according protocols.

=head3 --test-regex

Print results for applying various texts to defined regex.

=head3 --test-ciphers-dump

=head3 --test-ciphers-overview

=head3 --test-ciphers-openssl

=head3 --test-ciphers-show

=head3 --test-ciphers-simple

=head3 --test-ciphers-sorted

=head3 --test-ciphers-ssltest

Print ciphers in various formats, please see: OSaft/Ciphers.pm .
These options are aliases for:  I<+list> I<--legacy=TYP>  .

=head3 --test-ciphers-hex=*

=head3 --test-ciphers-key=*

=head3 --test-ciphers-list

Print some special information, please see: OSaft/Ciphers.pm .

=head3 --test-init

Print parts of  data structure  C<%cfg>.  In contrast to the options
described above,  I<--test-init>  exits straight before performing the
specified commands on the target.  Therefore it prints the settings
in  C<%cfg>  containing all applied commands and options.

=head3 --test-memory

Print overview of variables' memory usage, used for debugging only.

=head3 --test-methods

Print available methods for C<openssl> in Net::SSLeay.

=head3 --test-sclient

Print available options for C<openssl s_client> from Net::SSLeay.

=head3 --test-sslmap

Print SSL protocols constants from Net::SSLeay.

=head3 --test-ssleay

Print information about Net::SSLeay capabilities.

=head3 --test-sub

Obsolete, please use:

	make test.dev.grep.sub
	make test.dev-grep.subs
	make test.dev-grep.desc

=head2 Testing results

Finally there should be tests, which prove that the results of  o-saft.pl
are really what they should be. A test target is necessary therefore,
which produces reliable results.
However, some of the implemented tests in C<t/Makefile.*> (see section
"Functional testing" above) already work properly. This test coverage
needs to be improved ...

=head1 EXAMPLES

(o-saft.pl in all following examples is the name of the tool)

=head2 General

	o-saft.pl +cipher some.tld
	o-saft.pl +info   some.tld
	o-saft.pl +check  some.tld
	o-saft.pl +quick  some.tld
	o-saft.pl +help=commands
	o-saft.pl +certificate  some.tld
	o-saft.pl +fingerprint  some.tld 444
	o-saft.pl +after +dates some.tld
	o-saft.pl +version
	o-saft.pl +version --v
	o-saft.pl +list
	o-saft.pl +list    --v

=head2 Some specials

=over

=item * Get an idea how messages look like

=back

	o-saft.pl +check --cipher=RC4 some.tld

=over

=item * Check for Server Name Indication (SNI) usage only

=back

	o-saft.pl +sni some.tld

=over

=item * Check for SNI and print certificate's subject and altname

=back

	o-saft.pl +sni +cn +altname some.tld

=over

=item * Check for all SNI, certificate's subject and altname issues

=back

	o-saft.pl +sni_check some.tld

=over

=item * Only print supported ciphers

=back

	o-saft.pl +cipher --enabled some.tld

=over

=item * Only print unsupported ciphers

=back

	o-saft.pl +cipher --disabled some.tld

=over

=item * Test for a specific ciphers

=back

	o-saft.pl +cipher --cipher=ADH-AES256-SHA some.tld

=over

=item * Show supported (enabled) ciphers with their DH parameters:

=back

	o-saft.pl +cipher-dh some.tld

=over

=item * Test using a private libssl.so, libcrypto.so and openssl

=back

	o-saft.pl +cipher --lib=/foo/bar-1.42 --exe=/foo/bar-1.42/apps some.tld

=over

=item * Test using a private openssl

=back

	o-saft.pl +cipher --openssl=/foo/bar-1.42/openssl some.tld

=over

=item * Test using a private openssl also for testing supported ciphers

=back

	o-saft.pl +cipher --openssl=/foo/bar-1.42/openssl --force-openssl some.tld

=over

=item * Use your private texts in output

=back

	o-saft.pl +check some.tld --cfg-text=desc="my special description"

=over

=item * Use your private texts from RC-FILE

=back

	o-saft.pl --help=cfg-text >> .o-saft.pl
edit as needed: .o-saft.pl

	o-saft.pl +check some.tld

=over

=item * Use your private hint texts in output

=back

	o-saft.pl +check some.tld --cfg-hint=renegotiation="my special hint text"

=over

=item * Get the certificate's Common Name for a bunch of servers:

=back

	o-saft.pl +cn example.tld some.tld other.tld
	o-saft.pl +cn example.tld some.tld other.tld --showhost --no-header

=over

=item * Generate simple parsable output

=back

	o-saft.pl --legacy=quick --no-header +info  some.tld
	o-saft.pl --legacy=quick --no-header +check some.tld
	o-saft.pl --legacy=quick --no-header --trace-key +info  some.tld
	o-saft.pl --legacy=quick --no-header --trace-key +check some.tld

=over

=item * Generate simple parsable output for multiple hosts

=back

	o-saft.pl --legacy=quick --no-header --trace-key --showhost +check some.tld other.tld

=over

=item * Just for curiosity

=back

	o-saft.pl some.tld +fingerprint --format=raw
	o-saft.pl some.tld +certificate --format=raw | openssl x509 -noout -fingerprint

=head2 Testing with exit code

=over

=item * Test SSL/TLS connection and return exit code

=back

	o-saft.pl +check  --exitcode  some.tld

=over

=item * Test ciphers and return exit code with details about exit code

=back

	o-saft.pl +cipher --exitcode --exitcode-v  some.tld

=over

=item * Test ciphers and return exit code for ciphers only

=back

	o-saft.pl +cipher --exitcode --exitcode-no-prot  some.tld

=over

=item * Test with exit code but avoid checks considered C<yes> even if C<no>

=back

	o-saft.pl +check  --exitcode --ignore-out=ev- --ignore-out=rfc_7525 some.tld

=head2 Specials for hunting problems with connections etc.

=over

=item * Do not read RC-FILE .o-saft.pl

=back

	o-saft.pl +info some.tld --no-rc

=over

=item * Show command-line argument processing

=back

	o-saft.pl +info some.tld --trace-arg

=over

=item * Simple tracing

=back

	o-saft.pl +cn   some.tld --trace
	o-saft.pl +info some.tld --trace

=over

=item * A bit more tracing

=back

	o-saft.pl +cn   some.tld --trace --trace

=over

=item * Show internal variable names in output

=back

	o-saft.pl +info some.tld --trace-key

=over

=item * Show internal argument processeing

=back

	o-saft.pl +info --trace-arg some.tld

=over

=item * Show internal control flow

=back

	o-saft.pl +info some.tld --trace-cmd

=over

=item * Show internal timing

=back

	o-saft.pl +info some.tld --trace-time

=over

=item * Show checking ciphers

=back

	o-saft.pl +cipher some.tld --v --v

=over

=item * Show values retrieved from target certificate directly

=back

	o-saft.pl +info some.tld --no-cert --no-cert --no-cert-text=Value-from-Certificate

=over

=item * Show certificate CA verifications

=back

	o-saft.pl some.tld +chain_verify +verify +error_verify +chain

=over

=item * Avoid most performance and timeout problems (don't use  --v)

=back

	o-saft.pl +info some.tld --no-dns --no-sni --ignore-no-conn
	o-saft.pl +info some.tld --no-dns --no-sni --no-cert --no-http --no-openssl

=over

=item * Identify timeout problems

=back

	o-saft.pl +info some.tld --trace-cmd

this will show lines containing:
#O-Saft  CMD: test ...

=head1 DOCUMENTATION

=head2 User documentation

Documentation is mainly intented for the user, which is provided with

	o-saft.pl --help

But it may be difficult to find the proper information there.  To get
more selective documentations, the  I<--help=*>  options can be used. To
get an overview which  I<--help=*>  options are available, use:

	o-saft.pl --help=HELP

This only provides the complete user documentation, or the well known
parts specified by the keyword, (HELP in example above).  To find any
text with some lines of context, following could be used:

	o-saft.pl --help | egrep -i -C 3 "some text"

This is simply avaiable with:

o-saft --help="some text"

In the GUI a more sophisticate search is implemented, see the  "Help"
window there:

	o-saft.tcl 

=head2 Developer documentation

Documentation for developers is provided in various ways. Information
for developers can be found found in:

=over

=item * the files itself

=back

=over

=item * with:

=back

	o-saft.pl --help=test
	o-saft.pl --test

=over

=item * reading:

=back

	docs/concepts.txt
	Makefile.pod
	perldoc Makefile.pod

=over

=item * using:

=back

	make
	make help.doc

Using make for development uses additional external tools and/or Perl
modules:

=over

=item * perl-analyzer

=back

(also requires Perl modules, JSON, Text::MicroTemplate)

=over

=item * Debug::Trace Devel::Trace Devel::DProf Devel::NYTProf

=back

=head1 ATTRIBUTION

Based on ideas (in alphabetical order) of:

=over

=item * cnark.pl, SSLAudit.pl sslscan, ssltest.pl, sslyze.py, testssl.sh

=back

=over

=item * O-Saft - OWASP SSL advanced forensic tool

=back

Thanks to Gregor Kuznik for this title.

=over

=item * Basic cipher check and some proxy functionality implemented by Torsten Gigler.

=back

=over

=item * For re-writing some docs in proper English, thanks to Robb Watson.

=back

=over

=item * Code to check heartbleed vulnerability adapted from

=back

Steffen Ullrich (08. April 2014):
https://github.com/noxxi/p5-scripts/blob/master/check-ssl-heartbleed.pl

=over

=item * Colouration inspired by https://testssl.sh/ .

=back

=head1 VERSION

@(#) 22.11.22

=head1 AUTHOR

31. July 2012 Achim Hoffmann

Project Home: https://owasp.org/www-project-o-saft/

=head1 TODO

=over

=item * new features

=back

=over

=item ** client certificate

=back

=over

=item ** some STRATTLS need : HELP STARTTLS HELP as output of HELPs are different

=back

=over

=item ** Checking fallback from TLS 1.1 to TLS 1.0 (see ssl-cipher-check.pl)

=back

=over

=item ** Minimal encryption strength: weak encryption (40-bit) (TestSSLServer.jar)

=back

=over

=item * missing checks

=back

=over

=item ** SSL_honor_cipher_order => 1

=back

=over

=item ** implement TLSv1.2 checks

=back

=over

=item ** DNSEC and TLSA

=back

=over

=item ** checkcert(): KeyUsage, keyCertSign, BasicConstraints

=back

=over

=item ** DV and EV miss some minor checks; see checkdv() and checkev()

=back

=over

=item ** +constraints does not check +constraints in the certificate of

=back

the certificate chain.

=over

=item ** TR-03116-4: does not check data in certificate chain

=back

=over

=item ** RFC 7525: does not check data in certificate chain

=back

=over

=item ** RFC 7525: 3.2.  Strict TLS (for C<STARTTLS>)

=back

=over

=item ** RFC 7525: 3.4.  TLS Session Resumption (session ticket must be

=back

authenticated and encrypted)

=over

=item ** RFC 7525: 3.6.  Server Name Indication (more reliable check)

=back

=over

=item ** RFC 7525: 4.3.  Public Key Length (need more reliable check)

=back

=over

=item ** RFC 7525: 6.2.  AES-GCM

=back

=over

=item ** RFC 7525: 6.3.  Forward Secrecy

=back

=over

=item ** RFC 7525: 6.4.  Diffie-Hellman Exponent Reuse

=back

=over

=item * vulnerabilities

=back

=over

=item ** Ticketbleed

=back

=over

=item ** complete TIME, BREACH check

=back

=over

=item ** BEAST more checks, see: http://www.bolet.org/TestSSLServer/

=back

=over

=item * verify CA chain:

=back

=over

=item ** L<Net::SSLinfo|Net::SSLinfo>.pm implement verify*

=back

=over

=item ** implement +check_chain (see L<Net::SSLinfo|Net::SSLinfo>.pm implement verify* also)

=back

=over

=item ** implement +ca = +verify +chain +rootcert +expired +fingerprint

=back

=over

=item * postprocessing

=back

Remove all options for output formatting. Use a "postprocess" script
instead.

=over

=item ** scoring

=back

implement score for PFS; lower score if not all ciphers support PFS
make clear usage of score from %checks

=over

=item ** write postprocessor for tabular data, like

=back

ssl-cert-check -p 443 -s mail.google.com -i -V

=over

=item * L<Net::SSLinfo|Net::SSLinfo>

=back

=over

=item ** Net::SSLeay::ctrl()  sometimes fails, but doesn't return error message

=back

=over

=item ** Net::SSLeay::CTX_clear_options()

=back

Need to check the difference between the  SSL_OP_LEGACY_SERVER_CONNECT  and
SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION;  see also SSL_clear_options().
see https://www.openssl.org/docs/ssl/SSL_CTX_set_options.html

=over

=item ** L<Net::SSLinfo|Net::SSLinfo>::do_ssl_close()  does not really work

=back

=over

=item * Windows

=back

=over

=item ** Unicode:

=back

try: cmd /K chcp 65001
or:  chcp 65001
or:  reg add hklm\system\currentcontrolset\control\nls\codepage -v oemcp -d 65001

=over

=item ** perl

=back

perl 5.10.x from PortableApps does not work, because it misses
IO/Socket/SSL.pm, however, checkAllCiphers.pl works.
perl from older PortableApps/xampp (i.e. 1.7.x) does not work,
because IO/Socket/SSL.pm is too old (1.37).

=over

=item ** Windows

=back

on Windows print of strings > 32k does not work.
Ugly workaround using I<--v> implemented in L<o-saft-man.pm|o-saft-man.pm> only.

=over

=item * internal

=back

=over

=item ** move all configuration and code for command-line arguments to Arg.pm

=back

=over

=item ** use qr() for defining regex, see $cfg{C<regex>}

=back

=over

=item ** print_line() has ugly code for legacy=cipher

=back

=over

=item ** "Label" texts are defined twice: o-saft.pl and Net::SSLeay

=back

=over

=item ** make a clear concept how to handle +CMD whether they report

=back

checks or information (a.k.a %data vs. %check_*)
currently (2016) each single command returns all values

=over

=item ** client certificates not yet implemented in _usesocket() _useopenssl(),

=back

see t.client-cert.txt

=over

=item ** (nicht wichtig, aber sauber programmieren)

=back

_get_default(): L<Net::SSLinfo|Net::SSLinfo>::default() benutzen

Generated with:

        o-saft.pl --no-warnings --no-header --help=gen-pod > o-saft.pod

=cut

# begin abbr

# =head1 abbr


# # SID	@(#) glossary.txt 1.31 22/11/01 19:28:24
# 
# # acronym | description
# #------+----------------------------------------------------------------------+
# 0-RTT	zero Round-Trip Time
# 3Fish	see Threefish
# 3SHAKE	sometimes for: TLS Triple Handshake Attack
# AA	Attribute Authority
# AAD	Additional Authenticated Data
# ACME	Automated Certificate Management Environment
# ACL	Access Control List
# Adiantum	ChaCha stream cipher with Poly1305 and XChaCha12
# ADH	Anonymous Diffie-Hellman
# Adler32	hash function
# AE	Authenticated Encryption
# AEAD	Authenticated Encryption with Additional Data
# AECDHE	Anonymous Ephemeral ECDH
# AEM	Authenticated Encryption Mode aka Advanced Encryption Mode aka OCB3
# AES	Advanced Encryption Standard, block cipher
# AESCCM	AES with CCM
# AESCCM8	AES with CCM8
# AESGCM	AEAD algorithms AEAD_AES_128_GCM and AEAD_AES_256_GCM
# AES-CCM	alias for AESCCM
# AES-GCM	alias for AESGCM
# # AES-GCM	AES-GCM is an authenticated encryption mode that uses the AES block cipher in counter mode with a polynomial MAC based on Galois field multiplication.
# AES-GCM-SIV	Nonce Misuse-Resistant Authenticated Encryption (RFC8452)
# AES-CTR	?
# AES-XTS	?
# AIA	Authority Information Access (certificate extension)
# AKC	Agreement with Key Confirmation
# AKID	Authority Key IDentifier
# ALPN	Application Layer Protocol Negotiation
# ALPACA	Application Layer and Content Confusion Attack	(Exploit SSL/TLS)
# AMASTRID	stream cipher algorithm
# ARC4	Alleged RC4 (see RC4)
# ARCFOUR	alias for ARC4
# Argon2	Password hashing function (J. Aumasson, 2014)
# Argon2d	variant of Argon2
# Argon2i	variant of Argon2
# Argon2id	variant of Argon2
# ARIA	128-bit symmetric block cipher
# ARX	add–rotate–xor
# ASN	Autonomous System Number
# ASN.1	Abstract Syntax Notation number One
# AtE	Authenticate-then-Encrypt (see also MtE)
# BACPA	Blockwise-Adaptive Chosen-Plaintext Attack
# BADA55	"locate weak cryptography somewhere", Bernstein, Lange, et al.
# BADA55-VPR-224	improved verifiably pseudorandom 224-bit curve
# BADA55-VR-224	curve using the same prime as NIST P-224
# BADA55-VR-256	curve using the same prime as NIST P-256
# BADA55-VR-384	curve using the same prime as NIST P-384
# Bar Mitzvah	vulnerabilty of TLS sessions protected with RC4
# BDH	Bilinear Diffie-Hellman
# BEAR	block cipher combining stream cipher and hash function
# BEAST	Browser Exploit Against SSL/TLS	(Exploit SSL/TLS)
# BEAST .	fast block cipher for arbitrary blocksizes
# BER	Basic Encoding Rules
# BGP	Boorder Gateway Protocol
# bcrypt	hash function (Niels Provos, David Mazières, 1999)
# BLAKE	hash function (Jean-Philippe Aumasson, Luca Henzen, Willi Meier, Raphael C.-W. Phan, 2008)
# BLAKE2	fast secure hashing function (2012)
# BLAKE2b	see BLAKE (64 bit)
# BLAKE2s-128	see BLAKE (32 bit)
# BLAKE3	fast secure hashing function (20??)
# BLAKE3	??
# BLAKE-32	see BLAKE (32 bit)
# BLAKE-64	see BLAKE (64 bit)
# BLAKE-224	see BLAKE (224 bit)
# BLAKE-256	see BLAKE (256 bit)
# BLAKE-384	see BLAKE (384 bit)
# BLAKE-512	see BLAKE (512 bit)
# Blowfish	symmetric block cipher
# boomerang attack	attack on BLAKE
# BPA	Branch Prediction Analysis
# Brainpool	signature algorithm, from BSI
# BREACH	Browser Reconnaissance & Exfiltration via Adaptive Compression of Hypertext; a variant of CRIME	(Exploit SSL/TLS)
# Bullrun	NSA program to break encrypted communication
# CAMELLIA	symmetric key block cipher; encryption algorithm 128 bit (by Mitsubishi and NTT)
# CAST	Carlisle Adams and Stafford Tavares, block cipher
# CAST-128	Carlisle Adams and Stafford Tavares, block cipher
# CAST5	alias for CAST-128
# CAST-256	Carlisle Adams and Stafford Tavares, block cipher
# CAST6	alias for CAST-256
# cipher suite	cipher suite is a named combination of authentication, encryption, and message authentication code algorithms
# CA	Certificate Authority (aka root CA)
# CAA	Certificate Authority Authorization
# CAA RR	CAA Resource Record
# CBC	Cyclic Block Chaining
# CBC 	Cipher Block Chaining (sometimes)
# CBC  	Ciplier Block Chaining (sometimes)
# CBC-MAC	Cipher Block Chaining - Message Authentication Code
# CBC-MAC-ELB	Cipher Block Chaining - Message Authentication Code - Encrypt Last Block
# CBC3	alias for Tripple DES (sometimes, used in cipher suite names)
# CCA	chosen-ciphertext attack
# CCM	Counter with CBC-MAC Mode (authenticated encryption block cipher mode) (with 16-octet authentication tag)
# CCM-8	Counter with CBC-MAC Mode (authenticated encryption block cipher mode) (with 8-octet authentication tag)
# CCS	Change Cipher Spec (protocol)
# CDH	?  Diffie-Hellman
# CDP	CRL Distribution Points
# CECPQ1	key-agreement algorithm; Combined elliptic Curve and Post-Quantum Cryptography Key Exchange
# CECPQ2	Combined elliptic Curve and Post-Quantum Cryptography Key Exchange
# CEK	Content Encryption Key
# CFB	Cipher Feedback
# CFB3	Cipher Feedback
# CFBx	Cipher Feedback x bit mode
# CFRG	Crypto Forum Research Group
# CGN	Carrier- Grade NAT (RFC6598)
# ChaCha	stream cipher algorithm (with 256-bit key)
# ChaCha8	see ChaCha
# ChaCha12	see ChaCha (aka 12-round ChaCha)
# ChaCha20	see ChaCha (aka 20-round ChaCha)
# ChaCha-Poly1305	Authenticated Encryption with Associated Data (AEAD)
# CHAP	Challenge Handshake Authentication Protocol
# CLEFIA	lightweight block cipher algorithm
# CKA	(PKCS#11)
# CKK	(PKCS#11)
# CKM	(PKCS#11)
# CMAC	Cipher-based MAC
# CMC	CBC-mask-CBC
# CMP	X509 Certificate Management Protocol
# CMS	Cryptographic Message Syntax
# CMVP	Cryptographic Module Validation Program (NIST)
# CN	Common Name
# CNT_IMIT	cipher suite
# CTR_OMAC	cipher suite (GOST R 34.12-2015 aka GOST3412-2015)
# CP	Certificate Policy (certificate extension)
# CPA	chosen-plaintext attack
# CPD	Certificate Policy Definitions
# CPS	Certification Practice Statement
# CRC	Cyclic Redundancy Check
# CRC8	CRC with polynomial length 8
# CRC16	CRC with polynomial length 16
# CRC32	CRC with polynomial length 32
# CRC64	CRC with polynomial length 64
# CRAM	Challenge Response Authentication Mechanism
# CRIME	Compression Ratio Info-leak Made Easy	(Exploit SSL/TLS)
# CRL	Certificate Revocation List
# CRYPTON	128 bit block cipher (1998)
# CRYPTREC	Cryptography Research and Evaluation Committees
# CRYSTALS	post-quantum hash function, signature
# CRYSTALS-Dilithium	post-quantum hash function, signature
# CRYSTALS-Kyber	post-quantum hash function, signature
# CSP	Certificate Service Provider
# CSP 	Cryptographic Service Provider
# CSP  	Critical Security Parameter (used in FIPS 140-2)
# CSP:	Content Security Policy (used as HTTP header)
# CSR	Certificate Signing Request
# CSPRNG	Cryptographically Secure Pseudo-Random Number Generator
# CT	Certificate Transparency
# CTL	Certificate Trust Line
# CTR	Counter Mode (sometimes: CM; block cipher mode)
# CTS	Cipher Text Stealing
# Curve448	signature algorithm, aka Goldilocks (224 bit)
# Curve25519	signature algorithm by Dan J. Bernstein (ca. 128 bit)
# CWC	CWC Mode (Carter-Wegman + CTR mode; block cipher mode)
# CyaSSL	formerly name of wolfSSL
# DAA	Data Authentication Algorithm
# DAC	Data Authentication Code
# DACL	Discretionary Access Control List
# DANE	DNS-based Authentication of Named Entities
# DDH	Decisional Diffie-Hellman (Problem)
# DEA	Data Encryption Algorithm (sometimes a synonym for DES)
# DEAL	128, 192, 256 bit block cipher (Lars Knudsen, 1998)
# DECIPHER	synonym for decryption
# DEK	Data Encryption Key
# DER	Distinguished Encoding Rules
# DES	Data Encryption Standard
# DESede	alias for 3DES ?java only?
# DESX	extended DES
# 3DES	Tripple DES (168 bit)
# 3DES-EDE	alias for 3DES
# 3TDEA	Three-key  Tripple DEA (sometimes: Tripple DES; 168 bit)
# 2TDEA	Double-key Tripple DEA (sometimes: Double DES; 112 bit)
# D5	Verhoeff's Dihedral Group D5 Check
# DH	Diffie-Hellman
# DHE	Diffie-Hellman ephemeral (historic acronym, often used, mainly in openssl)
# Dilithium	digital signature scheme
# Dilithium2-AES	alias for Dilithium
# Dilithium3-AES	alias for Dilithium
# Dilithium5-AES	alias for Dilithium
# DLIES	Discrete Logarithm Integrated Encryption Scheme
# DLP	Discrete Logarithm Problem
# DN	Distinguished Name
# DNSSEC	DNS Security Extension
# DPA	Dynamic Passcode Authentication (see CAP)
# DRAGON	stream cipher algorithm
# DRG	Deterministic Random Generator
# DRBG	Deterministic Random Bit Generator
# DROWN	Decrypting RSA with Obsolete and Weakened eNcryption	(Exploit SSL/TLS)
# DSA	Digital Signature Algorithm
# DSCP	Differentiated Services Code Point
# DSPR	?
# DSS	Digital Signature Standard
# DTLS	Datagram TLS
# DTLSv1	Datagram TLS 1.0
# Dual EC DBRG	Dual Elliptic Curve Deterministic Random Bit Generator (NIST)
# Dual_EC_DBRG	Dual Elliptic Curve Deterministic Random Bit Generator (NIST)
# DV	Domain Validation
# DV-SSL	Domain Validated Certificate
# EAL	Evaluation Assurance Level
# EAP	Extensible Authentication Protocol
# EAP-PSK	Extensible Authentication Protocol using a Pre-Shared Key
# EAX	Encrypt-then-Authenticate-then-Translate
# EAX 	EAX Mode (block cipher mode)
# EAXprime	alias for EAX Mode
# EBC	Edge Boundery Controller
# EC	Elliptic Curve
# ECB	Electronic Code Book mode (block cipher mode)
# ECC 	Error Corection Code
# ECC	Elliptic Curve Cryptography
# ECCSI	Elliptic Curve-Based Certificateless Signatures for Identity-Based Encryption
# ECDH	Elliptic Curve Diffie-Hellman
# ECDHE	Ephemeral ECDH
# ECDHE_ECDSA	Ephemeral ECDH with ECDSA or EdDSA signatures
# ECDHE_RSA	Ephemeral ECDH with RSA signatures
# ECDH_anon	Anonymous ephemeral ECDH, no signatures
# ECDLP	Elliptic Curve Discrete Logarithm Problem
# ECDSA	Elliptic Curve Digital Signature Algorithm
# ECDSA-256	Elliptic Curve Digital Signature Algorithm (256 bits)
# ECDSA-384	Elliptic Curve Digital Signature Algorithm (384 bits)
# ECDSA-521	Elliptic Curve Digital Signature Algorithm (521 bits)
# ECGDSA	Elliptic Curve ??? DSA
# ECHO	hash function (Ryad Benadjila, Olivier Billet, Henri Gilbert, Gilles Macario-Rat, Thomas Peyrin, Matt Robshaw, Yannick Seurin, 2010)
# ECIES	Elliptic Curve Integrated Encryption Scheme
# ECKA	Elliptic Curve Key Agreement
# ECKA-EG	Elliptic Curve Key Agreement of ElGamal Type
# ECKDSA	Elliptic Curve ??? DSA
# ECMQV	Elliptic Curve Menezes-Qu-Vanstone
# ECN	Explicit Congestion Notification
# ECOH	Elliptic Curve only hash
# # ECRYPT	??
# ECSVDP-DH	Elliptic Curve Secret Value Derivation Primitive, Diffie-Hellman version
# Ed25519	alias for Curve25519
# Ed448	alias for Curve448
# edwards25519	alias for Curve25519
# edwards448	alias for Curve448
# EdDSA	alias for signatures using public key and private key formats, like Curve448 and Curve25519
# EDE	Encryption-Decryption-Encryption
# EDH	Ephemeral Diffie-Hellman
# EGADS	Entropy Gathering and Distribution System
# EGD	Entropy Gathering Daemon
# EKU	Extended Key Usage
# ELB	Encrypt Last Block
# ElGamal	asymmetric block cipher
# ENCIPHER	synonym for encryption
# EME	ECB-mask-ECB
# EME 	Encoding Method for Encryption
# EMS 	Extended Master Secret (sometimes)
# EMS 	Encrypted Master Secret
# ESNI	Encrypted Server Name Indication
# ESP	Encapsulating Security Payload
# ESSIV	Encrypted salt-sector initialization vector
# EtA	Encrypt-then-Authenticate (see also EtM)
# E&A	Encrypt-and-Authenticate (see also E&M)
# E&M	Encrypt-and-MAC (see also E&A)
# EtM	Encrypt-then-MAC (see also EtA)
# eTLS	Enterprise TLS (social attack on privacy by ETSI; renamed to ETS)
# ETS	Enterprise Transport Security (renamed from eTLS)
# ETSI-TS	European Telecommunications Standards Institute - Technical Specification
# EV	Extended Validation
# EV-SSL	Extended Validation Certificate
# FALCON	Fast-Fourier Lattice-based Compact Signatures over NTRU; post-quantum signature
# FEAL	Fast Data Encryption Algorithm
# FFC	Finite Field Cryptography
# FFT	Fast Fourier Transform
# FIPS	Federal Information Processing Standard
# FIPS46-2	FIPS Data Encryption Standard (DES)
# FIPS73	FIPS Guidelines for Security of Computer Applications
# FIPS140-2	FIPS Security Requirements for Cryptographic Modules
# FIPS140-3	proposed revision of FIPS 140-2
# FIPS180-3	FIPS Secure Hash Standard
# FIPS186-3	FIPS Digital Signature Standard (DSS)
# FIPS197	FIPS Advanced Encryption Standard (AES)
# FIPS198-1	FIPS The Keyed-Hash Message Authentication Code (HMAC)
# FREAK	Factoring Attack on RSA-EXPORT Keys	(Exploit SSL/TLS)
# FQDN	Fully-qualified Domain Name
# FSB	Fast Syndrome Based Hash
# FSM	Finite State Machine
# FZA	FORTEZZA
# G-DES	??? DES
# GCM	Galois/Counter Mode (authenticated encryption block cipher mode)
# GHASH	Hash funtion used in GCM
# GMAC	MAC for GCM
# Grøstl	hash function (Lars Knudsen, 2010)
# Goldilocks	see Curve448
# GOST	Gossudarstwenny Standard, block cipher
# GOST 	hash function (used in GOST cipher suite)
# GOST28147-89	block cipher
# GOST3410-2012	signature algorithm
# GOST3411-2012	hash algorithm
# GOST3412-2015	block cipher
# GOST3413-2015	modes of operation for block ciphers
# GOST3431095	cryptographic algorithm?
# GOST3431004	cryptographic algorithm?
# GOST3431195	cryptographic algorithm?
# GOSTR341001	cryptographic algorithm?
# GOSTR341094	cryptographic algorithm?
# GOSTR341194	cryptographic algorithm?
# Grainv1	stream cipher (64-bit IV)
# Grainv128	stream cipher (96-bit IV)
# GREASE	Generate Random Extensions And Sustain Extensibility
# GRØSTL256	hash function
# GRØSTL512	hash function
# GROESTL256	alias for GRØSTL256
# GROESTL512	alias for GRØSTL512
# HAIFA	HAsh Iterative FrAmework
# hash127	fast hash function (by Dan Bernstein)
# HAVAL	one-way hashing
# HAS-160	hash function
# HAS-V	hash function
# HC128	alias for HC128
# HC256	alias for HC256
# HC-128	stream cipher algorithm
# HC-256	stream cipher algorithm
# HCH	Hash-Coputer-Hash
# HCTR	a variable-input-length encryption mode
# HEARTBLEED	attack against TLS extension heartbeat
# HEIST	HTTP Encrypted Information can be Stolen through TCP-windows
# HIBE	hierarchical identity-based encryption
# HKDF	HMAC-based Extract-and-Expand Key Derivation Function
# HNF-256	hash function (Harshvardhan Tiwari, Krishna Asawa, 2014)
# HMAC	keyed-Hash Message Authentication Code (aka Hashed MAC)
# HMQV	h? Menezes-Qu-Vanstone
# HPC	Hasty Putting Cipher
# HPKP	HTTP Public Key Pinning
# HPolyC	ChaCha stream cipher with Poly1305 and XChaCha12, XChaCha20
# HRSS	encryption algorithm
# HSM	Hardware Security Module
# HSR	Header + Secret + Random
# HSTS	HTTP Strict Transport Security
# HTOP	HMAC-Based One-Time Password
# IAPM	Integrity Aware Parallelizable Mode (block cipher mode of operation)
# IBE	Identity-Based Encryption
# ICM	Integer Counter Mode (alias for CTR)
# IDP	Issuing Distribution Points
# IDEA	International Data Encryption Algorithm (by James Massey and Xuejia Lai)
# IESG	Internet Engineering Steering Group
# IETF	Internet Engineering Task Force
# IFC	Integer Factorization Cryptography
# IGE	Infinite Garble Extension
# IKE	Internet Key Exchange
# IKEv2	IKE version 2
# IND-BACPA	Indistinguishability of encryptions under blockwise-adaptive chosen-plaintext attack
# IND-CCA	Indistinguishability of encryptions under chosen-cipgertext attack
# IND-CPA	Indistinguishability of encryptions under chosen-plaintext attack
# INT-CTXT	Integrity of ciphertext
# INT-PTXT	Integrity of plaintext
# IRTF	Internet Research Task Force
# ISAKMP	Internet Security Association and Key Management Protocol
# IV	Initialization Vector
# JH	hash function (Hongjun Wu, 2011)
# JH-224	see JH (224 bits)
# JH-256	see JH (256 bits)
# JH-384	see JH (384 bits)
# JH-512	see JH (512 bits)
# Jolkit-BC	tweakable block cipher
# JSSE	Java Secure Socket Extension
# KATAN	lightweight block cipher algorithm
# KLEIN	lightweight block cipher algorithm
# Keccak	hash function (Guido Bertoni, Joan Daemen, Michaël Peeters und Gilles Van Assche, 2012)
# KCI	Key Compromise Impersonation
# KDC	Key Distribution Center (mainly Kerberos)
# KDF	Key Derivation Function
# KEA	Key Exchange Algorithm (alias for FORTEZZA-KEA)
# KEK	Key Encryption Key
# KEM	Key Encapsulation Mechanisms
# KMS	Key Management Service
# KPAK	KMS Public Authentication Key
# KRB	Key Exchange Kerberos
# KRB5	Key Exchange Kerberos 5
# KSAK	KMS Secret Authentication Key
# KSK	Key Signing Key (DNSSEC)
# KU	Key Usage
# Kuznyechik	block cipher  (used in GOST)
# Magma	block cipher  (used in GOST)
# LAKE	hash function (Jean-Philippe Aumasson, Willi Meier, Raphael C.-W. Phan, 2008)
# LEA	? algorithm
# LEA-128	see LEA
# LEA-256	see LEA
# LED	lightweight block cipher algorithm
# LEXv2	stream cipher algorithm
# LFSR	Linear Feedback Shift Register
# LION	block cipher combining stream cipher and hash function
# LLL	Lenstra–Lenstra–Lovász, lattice basis reduction algorithm
# LM hash	LAN Manager hash aka LanMan hash
# LogJam	Attack to force server to downgrade to export ciphers	(Exploit SSL/TLS)
# Logjam	see LogJam
# LRA	Local Registration Authority
# LRW	Liskov, Rivest, and Wagner (block encryption)
# LSN	large-scale NAT (same as CGN)
# Lucifer	block cipher (developed at IBM in the 1970s)
# Lucky13	Break SSL/TLS Protocol with ciphers using CBC-mode	(Exploit SSL/TLS)
# Lucky 13	Break SSL/TLS Protocol	(Exploit SSL/TLS)
# Lucky Thirteen	see Lucky 13
# MANTIS	block cipher, low-latency variant of SKINNY
# MARS	128-bit block cipher (developed at IBM)
# MAC	Message Authentication Code
# MCF	Modular Crypt Format
# MDC	Modification Detection Code
# MDC2	Modification Detection Code 2 aka Meyer-Schilling
# MDC-2	same as MDC2
# MD2	Message Digest 2
# MD4	Message Digest 4
# MD5	Message Digest 5
# MEE	MAC-then-Encode-then-Encrypt (see also MtE, AtE)
# MEK	Message Encryption Key
# MECAI	Mutually Endorsing CA Infrastrukture
# MGF	Mask Generation Function
# MIDORI	lightweight block cipher algorithm (64 or 128 bit) (2015)
# Midori64	see MIDORI
# Midori128	see MIDORI
# MISTY1	block cipher algorithm
# MPQS	Multiple Polynomial Quadratic Sieve
# MQV	Menezes-Qu-Vanstone (authentecated key agreement)
# MS-SSTP	see SSTP
# MtE	MAC-then-encrypt (see also AtE)
# NaCl	"Salt", crypto library (by D. Bernstein, Tanja Lange, Peter Schwabe)
# NCP	Normalized Certification Policy (according TS 102 042)
# NOEKEON	symmetric block cipher algorithm
# Neokeon	see NOEKEON (probaly typo)
# NewHope	post-quantum key exchange
# nistp192	alias for P-192
# nistp224	alias for P-224
# nistp256	alias for P-256
# nistp384	alias for P-384
# nistp521	alias for P-521
# NLSv2	stream cipher algorithm
# nonce	(arbitrary) number used only once
# NPN	Next Protocol Negotiation
# NSS	Network Security Services
# NTG	none-Deterministic Random Generator
# NTLM	NT Lan Manager. Microsoft Windows challenge-response authentication method.
# NTRU	asymetric cipher algorithm using lattice reduction
# NTRUEncrypt	alias for NTRU
# NOMORE	Numerous Occurrence MOnitoring & Recovery Exploit, aka RC4 NOMORE
# NULL	no encryption
# NUMS	nothing up my sleeve numbers
# OAEP	Optimal Asymmetric Encryption Padding
# OCB	Offset Codebook Mode (block cipher mode of operation)
# OCB1	same as OCB
# OCB2	improved OCB aka AEM
# OCB3	improved OCB2
# OCELOT1	stream cipher algorithm
# OCELOT2	stream cipher algorithm
# OCSP	Online Certificate Status Protocol
# OCSP stapling	formerly known as: TLS Certificate Status Request
# OFB	Output Feedback
# OFBx	Output Feedback x bit mode
# OID	Object Identifier
# OMAC	One-Key CMAC, aka CBC-MAC
# OMAC1	same as CMAC
# OMAC2	same as OMAC
# OPIE	One-time pad Password system
# OTP	One Time Pad
# OV	Organisational Validation
# OV-SSL	Organisational Validated Certificate
# P12	see PKCS#12
# P7B	see PKCS#7
# P-192	Elliptic Curve used in FIPS 186-4 (NIST)
# P-224	Elliptic Curve used in FIPS 186-4 (NIST)
# P-256	Elliptic Curve used in FIPS 186-4 (NIST)
# P-384	Elliptic Curve used in FIPS 186-4 (NIST)
# P-521	Elliptic Curve used in FIPS 186-4 (NIST)
# PACE	Password Authenticated Connection Establishment
# PAD	Peer Authorization Database
# PAKE	Password Authenticated Key Exchange
# Panama	stream cipher algorithm
# PCN	Pre-Congestion Notification
# PBE	Password Based Encryption
# PBKDF2	Password Based Key Derivation Function
# PC	Policy Constraints (certificate extension)
# PCBC	Propagating Cipher Block Chaining
# PCFB	Periodic Cipher Feedback Mode
# PCT	Private Communications Transport
# PEM	Privacy Enhanced Mail
# PES	Proposed Encryption Standard
# PFS	Perfect Forward Secrecy
# PFX	see PKCS#12 (Personal Information Exchange)
# PGP	Pretty Good Privacy
# PII	Personally Identifiable Information
# Picollo	lightweight block cipher algorithm
# PKCS	Public Key Cryptography Standards
# PKCS1	PKCS #1: RSA Encryption Standard
# PKCS3	PKCS #3: RSA Encryption Standard on how to implement the Diffie-Hellman key exchange protocol
# PKCS5	PKCS #5: RSA Encryption Standard on how to derive cryptographic keys from a password
# PKCS6	PKCS #6: RSA Extended Certificate Syntax Standard
# PKCS7	PKCS #7: RSA Cryptographic Message Syntax Standard
# PKCS8	PKCS #8: RSA Private-Key Information Syntax Standard
# PKCS10	PKCS #10: Describes a standard syntax for certification requests
# PKCS11	PKCS #11: RSA Cryptographic Token Interface Standard (keys in hardware devices, cards)
# PKCS12	PKCS #12: RSA Personal Information Exchange Syntax Standard (public + private key stored in files)
# PKE	Public Key Enablement
# PKI	Public Key Infrastructure
# PKIX	Internet Public Key Infrastructure Using X.509
# PKP	Public-Key-Pins
# PM	Policy Mappings (certificate extension)
# PMAC	Parallelizable MAC (by Phillip Rogaway)
# PMS	Pre-Master Secret
# Poly1305	Authenticator (MAC)
# Poly1305-AES	MAC (by D. Bernstein)
# POP	Proof of Possession
# POODLE	Padding Oracle On Downgraded Legacy Encryption	(Exploit SSL/TLS)
# PQC	Post-Quantum Crypto
# PRESENT	block cipher algorithm (80 or 128 bit) (2007)
# PRF	Pseudo-Random Function
# PRP	Pseudo-Random Permutation
# PRINCE	low-latency block cipher algorithm (64 bit) (2012)
# prime192v1	alias for P-192
# prime224v1	alias for P-224
# prime256v1	alias for P-256
# prime384v1	alias for P-384
# prime521v1	alias for P-521
# PRNG	Pseudo-Random Number Generator
# PSK	Pre-shared Key
# PSKC	Portable Symmetric Key Container
# PTG	Physical Random Generator
# PVT	Public Validation Token
# PWKE	Pair-Wise Key Establishment Schemes Using Discrete Logarithm Cryptography
# QUIC	Quick UDP Internet Connection
# RA	Registration Authority (aka Registration CA)
# Rabbit	stream cipher algorithm
# RACCOON	Timing vulnerability in TLS' DH key exchange	(Exploit SSL/TLS)
# RADIUS	Remote Authentication Dial-In User Service
# Radix-64	alias for Base-64
# RAINBOW	post-quantum signature (broken 2/2022)
# RBG	Random Bit Generator
# RC2	Rivest Cipher 2, block cipher by Ron Rivest (64-bit blocks)
# RC4	Rivest Cipher 4, stream cipher (aka Ron's Code)
# RC5	Rivest Cipher 5, block cipher (32-bit word)
# RC5-64	Rivest Cipher 5, block cipher (64-bit word)
# RC6	Rivest Cipher 6
# RCSU	Reuters' Compression Scheme for Unicode (aka SCSU)
# RFC	Request for Comments
# Rijndael	symmetric block cipher algorithm (AES)
# RIPEMD	RACE Integrity Primitives Evaluation Message Digest
# RIPE-MD	alias for RIPEMD
# RLWE	Ring Learning-with-Errors
# RMAC	Randomized MAC (block cipher authentication mode)
# RMD	
# RNG	Random Number Generator
# ROCA	Return of the Coppersmith Attack	(Exploit SSL/TLS)
# ROT-13	see XOR
# ROBOT	Return Of Bleichenbacher's Oracle Threat	(Exploit SSL/TLS)
# RTP	Real-time Transport Protocol
# RSASSA-PSS	RSA Probabilistic Signature Scheme
# RSA	Rivest Sharmir Adelman (public key cryptographic algorithm)
# RSS-14	Reduced Space Symbology, see GS1
# RTN	Routing transit number
# S/KEY	One-time pad Password system
# SA	Subordinate Authority (aka Subordinate CA)
# SACL	System Access Control List
# SAD	Security Association Database
# SAE	Simultaneous Authentication of Equals
# SAFER	Secure And Fast Encryption Routine, block cipher
# Salsa20	stream cipher (by D. Bernstein, 2005), see ChaCha20
# Salsa20/8	see scrypt
# Salsa20/12	see Salsa20
# Salsa20/20	see Salsa20
# SAM	syriac abbreviation mark
# SAN	Subject Alternate Name
# Sarmal	hash function
# SAX	Symmetric Authenticated eXchange
# SBCS	single-byte character set
# SBPA	Simple Branch Prediction Analysis
# SCA	Selfsigned CA signature
# SCEP	Simple Certificate Enrollment Protocol
# SCREAM	tweakable word-based stream cipher (2002)
# scrypt	password based key derivation function (Colin Percival)
# SCSU	Standard Compression Scheme for Unicode (compressed UTF-16)
# SCSV	Signaling Cipher Suite Value
# SCVP	Server-Based Certificate Validation Protocol
# SCT	Signed Certificate Timestamp
# SDES	Security Description Protokol
# secp192r1	alias for P-192
# secp224r1	alias for P-224
# secp256r1	alias for P-256
# secp384r1	alias for P-384
# secp521r1	alias for P-521
# SEAL	Software-Optimized Encryption Algorithm; 32-bit word stream cipher (1994)
# SEED	128-bit symmetric block cipher (1998)
# Serpent	symmetric key block cipher (128 bit)
# SGC	Server-Gated Cryptography
# SGCM	Sophie Germain Counter Mode (authenticated encryption block cipher mode)
# SIV	Synthetic Initialization Vector
# SHA	Secure Hash Algorithm
# SHA-0	Secure Hash Algorithm (insecure version before 1995)
# SHA-1	Secure Hash Algorithm (since 1995)
# SHA-2	Secure Hash Algorithm (since 2002)
# SHA-3	Secure Hash Algorithm (since 2015), see Keccak also
# SHA-128	Secure Hash Algorithm (128 bit)
# SHA-224	Secure Hash Algorithm (224 bit)
# SHA-256	Secure Hash Algorithm (256 bit)
# SHA-384	Secure Hash Algorithm (384 bit)
# SHA-512	Secure Hash Algorithm (512 bit)
# SHA1	alias for SHA-1 (160 bit)
# SHA2	alias for SHA-2 (128, 224, 256, 384 or 512 bit)
# SHA3	alias for SHA-3 (224, 256, 384 or 512 bit)
# SHA3256	alias for SHA3-256
# SHA3-224	Secure Hash Algorithm (224 bit)
# SHA3-256	Secure Hash Algorithm (256 bit)
# SHA3-384	Secure Hash Algorithm (384 bit)
# SHA3-512	Secure Hash Algorithm (512 bit)
# SHAKE128	Secure Hash Algorithm (variable bit)
# SHAKE256	Secure Hash Algorithm (variable bit)
# SHAttered	The first concrete collision attack against SHA1	(Exploit SSL/TLS)
# SHAvite-3	hash function (Eli Biham, Orr Dunkelman, 2009)
# SHS	Secure Hash Standard
# SIA	Subject Information Access (certificate extension)
# SIC	Segmented Integer Counter (alias for CTR)
# SIDH	Supersingular Isogeny Diffie-Hellman (key exchange)
# SIKE	post-quantum hash function, signature (broken 7/2022)
# SIKEp434	post-quantum hash function, signature (broken 7/2022)
# SIKEp503	post-quantum hash function, signature (broken 7/2022)
# SIKEp610	post-quantum hash function, signature (broken 7/2022)
# SIKEp751	post-quantum hash function, signature (broken 7/2022)
# SIMON	lightweight block cipher (NSA algorithm, questionable security)
# SipHash	hash function (J. Aumasson, Daniel Bernstein, 2012)
# Skein	hash function (Niels Ferguson, Stefan Lucks, Bruce Schneier, Doug Whiting, Mihir Bellare, Tadayoshi Kohno, Jon Callas, Jesse Walker, 2010)
# Skein-256-256	see Skein (256 bits)
# Skein-512-256	see Skein (256 bits)
# Skein-512-512	see Skein (512 bits)
# Skein-1024-1024	see Skein (1024 bits)
# SKID	Subject Key ID (certificate extension)
# SKINNY	SPN tweakable block cipher
# SKINNY-128-256	see SLINNY
# SKIP	Message Skipping Attacks on TLS	(Exploit SSL/TLS)
# SKIP-TLS	see SKIP
# Skipjack	block cipher encryption algorithm specified as part of the Fortezza
# SLOTH	Security Losses from Obsolete and Truncated Transcript Hashes	(Exploit SSL/TLS)
# SM2	ShangMi authentication function
# SM3	ShangMi hash function
# SM4	ShangMi block cipher algorithm (Chinese gouvernment algorithm, questionable but no objections yet)
# SM4CCM	AEAD algorithms AEAD_SM4_CCM
# SM4GCM	AEAD algorithms AEAD_SM4_GCM
# SMS4	see SM4
# SMACK	State Machine AttaCKs	(Exploit SSL/TLS)
# Snefu	hash function
# Snow20	stream cipher algorithm
# SNI	Server Name Indication
# SNOW	word-based synchronous stream ciphers (by Thomas Johansson and Patrik Ekdahl )
# Snuffle 2005	see Salsa20
# Snuffle 2008	see ChaCha
# Sosemanuk	stream cipher algorithm
# SPARX	? algorithm
# SPECK	lightweight block cipher algorithm (NSA algorithm, questionable security)
# Speck64	see Speck
# Speck128	see Speck
# Speck256	see Speck
# Speck256-XTS	see Speck
# SPD	Security Policy Database
# SPDY	Google's application-layer protocol on top of SSL
# SPECK	block cipher combining
# SPHINCS	Stateless hash-based signatures, post-quantum hash function, signature
# SPHINCS-256	alias for SPHINCS
# SPHINCS-SHAKE256	alias for SPHINCS
# SPHINCS-SHA-256	alias for SPHINCS
# SPI	Security Parameters Index
# SPKI	Subject Public Key Infrastructure
# SPN	Substitution-Permutation Network
# SPRP	Strong Pseudo-Random Permutation
# Square	block cipher
# SRI	Subresource Integrity
# SRP	Secure Remote Password protocol
# SRTP	Secure RTP
# SSCD	Secure Signature Creation Device
# SSEE	Sichere Signaturerstellungseinheit (same as SSCD)
# SSK	Secret Signing Key
# SSL	Secure Sockets Layer
# SSLv2	Secure Sockets Layer Version 2
# SSLv3	Secure Sockets Layer Version 3
# SSP	Security Support Provider
# SSPI	Security Support Provider Interface
# SST	Serialized Certificate Store format
# SSTP	Secure Socket Tunneling Protocol
# STES	stream cipher algorithm
# Streebog	hash function
# Streebog-256	see Streebog
# Streebog-512	see Streebog
# STS	Strict Transport Security
# STS 	Station-to-Station protocol
# SUF-CMA	Strong UnForgeability against Chosen-Message Attacks
# Sweet32	Birthday attacks on 64-bit block ciphers in TLS and OpenVPN	(Exploit SSL/TLS)
# SWIFFT	hash function (Vadim Lyubashevsky, Daniele Micciancio, Chris Peikert, Alon Rosen, 2008)
# SWIFFTX	see SWIFFT
# TA	Trust Agent
# TACK	Trust Assertions for Certificate Keys
# TCB	Trusted Computing Base
# TDEA	Tripple DEA
# TEA	Tiny Encryption Algorithm
# TEK	Traffic Encryption Key
# TET	?
# TGS	Ticket Granting Service (mainly Kerberos)
# TGT	Ticket Granting Ticket (mainly Kerberos)
# Tiger	hash function
# TIME	Timing Info-leak Made Easy	(Exploit SSL/TLS)
# TIME 	A Perfect CRIME? TIME Will Tell
# Threefish	hash function
# TLS	Transport Layer Security
# TLSA	TLS Trust Anchors
# TLSv1	Transport Layer Security version 1
# TLSA RR	TLSA resource Record
# TMAC	Two-Key CMAC, variant of CBC-MAC
# TOCTOU	Time-of-check, time-of-use
# TOFU	Trust on First Use
# TR-02102	Technische Richtlinie 02102 (des BSI)
# TR-03116	Technische Richtlinie 03116 (des BSI)
# Trivium	stream cipher algorithm
# TSK	Transmission Security Key
# TSK 	TACK signing key
# TSP	trust-Management Service Provider
# TSS	Time Stamp Service
# TTP	trusted Third Party
# Twofish	symmetric key block cipher (128 bit)
# UC 	Unified Capabilities
# UC	Unified Communications (SSL Certificate using SAN)
# UCC	Unified Communications Certificate (rarley used)
# UMAC	Message Authentication Code based on universal hashing; aka universal hashing MAC; optimized for 32-bit architectures
# URI	Uniform Resource Identifier
# URL	Uniform Resource Locator
# VMAC	Universal hashing MAC; 64-bit variant of UMAC (by Ted Krovetz and Wei Dai)
# VMPC	stream cipher algorithm
# VR-224	alias for BADA55-VR-224
# VR-256	alias for BADA55-VR-256
# VR-384	alias for BADA55-VR-384
# WHIRLPOOL	hash function
# WPAD	Web Proxy Auto-Discovery
# wolfSSL	SSL library mainly intended and used for embedded and real-time systems
# X.680	X.680: ASN.1
# X.509	X.509: The Directory - Authentication Framework
# X25519	alias for Curve25519 ?
# X448	alias for Curve448 ?
# X680	X.680: ASN.1
# X509	X.509: The Directory - Authentication Framework
# X3DH	Extended Triple Diffie-Hellman
# XCBC	eXtended CBC-MAC
# XCBC-MAC	same as XCBC
# XChaCha	stream cipher algorithm (with 512-bit key)
# XChaCha12	see ChaCha (aka 12-round XChaCha)
# XChaCha20	see ChaCha (aka 20-round XChaCha)
# XEX	XOR Encrypt XOR
# XKMS	XML Key Management Specification
# XMACC	counter-based XOR-MAC
# XMACR	radomized XOR-MAC
# XMLSIG	XML-Signature Syntax and Processing
# XMSS	hash function
# XSalsa2	variant of Salsa20
# XTEA	extended Tiny Encryption Algorithm
# XTS	XEX-based tweaked-codebook mode with ciphertext stealing
# XUDA	Xcert Universal Database API
# XXTEA	enhanced/corrected Tiny Encryption Algorithm
# yaSSL	same as CyaSSL
# ZLIB	Lossless compression file format
# ZRTP	SRTP for VoIP
# ZSK	Zone Signing Key (DNSSEC)
# 
#
# end abbr

# begin rfc

# =head1 rfc


# # SID	@(#) rfc.txt 1.18 22/11/05 11:37:10
# 
# # number| title / description
# #------+----------------------------------------------------------------------+
# # url	base URL for RFC descriptions
# #	http://tools.ietf.org/html/rfcXXXX
# #	http://tools.ietf.org/rfc/rfcXXXX.txt
# url	http://tools.ietf.org/
# 6101	SSL Version 3.0
# 6601	SSL Version 3.0
# 2246	TLS Version 1.0 (with Cipher Suites)
# 4346	TLS Version 1.1 (with Cipher Suites)
# 5246	TLS Version 1.2 (with Cipher Suites)
# 8446	TLS Version 1.3 (with Cipher Suites)
# 4347	DTLS Version 0.9
# 6347	DTLS Version 1.2
# 8447	IANA Registry Updates for TLS and DTLS
# 2616	Hypertext Transfer Protocol Version 1 (HTTP/1.1)
# 7540	Hypertext Transfer Protocol Version 2 (HTTP/2)
# 7230	HTTP/1.1: Message Syntax and Routing
# 7231	HTTP/1.1: Semantics and Content
# 7232	HTTP/1.1: Conditional Requests
# 7233	HTTP/1.1: Range Requests
# 7234	HTTP/1.1: Caching
# 7235	HTTP/1.1: Authentication
# 2144	CAST-128 Encryption Algorithms
# 2612	CAST-256 Encryption Algorithms
# 2950	Telnet Encryption: CAST-128 64 bit Cipher Feedback
# 2984	Use of the CAST-128 Encryption Algorithm in CMS
# 3490	Internationalizing Domain Names in Applications (IDNA)
# 3987	Internationalized Resource Identifiers (IRIs)
# 4518	Internationalized String Preparation in LDAP
# 3986	Uniform Resource Identifier (URI): Generic Syntax
# 2104	HMAC: Keyed-Hashing for Message Authentication
# 2405	The ESP DES-CBC Cipher Algorithm With Explicit IV
# 2406	IP Encapsulating Security Payload (ESP)
# 4303	IP Encapsulating Security Payload (ESP)
# 2407	The Internet IP Security Domain of Interpretation for ISAKMP
# 2408	Internet Security Association and Key Management Protocol (ISAKMP)
# 2409	The Internet Key Exchange (IKE) - 1998
# 4306	The Internet Key Exchange (IKEv2) Protocol - 2005
# 7296	The Internet Key Exchange Protocol 2 (IKEv2) - 2014
# 4753	ECP Groups for IKE and IKEv2
# 4754	IKE and IKEv2 Authentication Using the Elliptic Curve Digital Signature Algorithm (ECDSA)
# 2412	AKLEY Key Determination Protocol (PFS - Perfect Forward Secrec)
# 2817	Upgrading to TLS Within HTTP/1.1
# 2818	HTTP Over TLS
# 2945	SRP Authentication & Key Exchange System
# 2986	PKCS#10
# 5967	PKCS#10
# 2313	PKCS#1: RSA Cryptography Specifications Version 1.5
# 2437	PKCS#1: RSA Cryptography Specifications Version 2.0
# 3447	PKCS#1: RSA Cryptography Specifications Version 2.1
# 8017	PKCS#1: RSA Cryptography Specifications Version 2.2
# 2712	TLSKRB: Addition of Kerberos Cipher Suites to TLS
# 3268	TLSAES: Advanced Encryption Standard (AES) Cipher Suites for TLS
# 4279	TLSPSK: Pre-Shared Key Ciphersuites for TLS
# 5081	TLSPGP: Using OpenPGP Keys for Transport Layer Security (TLS) Authentication - 2007
# 6091	TLSPGP: Using OpenPGP Keys for Transport Layer Security (TLS) Authentication - 2011
# 3711	The Secure Real-time Transport Protocol (SRTP)
# 6189	ZRTP: Media Path Key Agreement for Unicast Secure RTP
# 4106	Use of Galois/Counter Mode (GCM) in IPsec Encapsulating Security Payload (ESP)
# 4309	AES-CCM Mode with IPsec Encapsulating Security Payload (ESP)
# 5116	An Interface and Algorithms for Authenticated Encryption (AEAD)
# 3749	TLS Compression Method (obsolete)
# 3943	TLS Protocol Compression Using Lempel-Ziv-Stac (LZS)
# 4680	TLS Handshake Message for Supplemental Data
# 4749	TLS Compression Methods
# 3546	TLS Extensions (obsolete)
# 4366	TLS Extensions
# 5746	TLS Extension: Renegotiation Indication Extension
# 5764	TLS Extension: Secure Real-time Transport Protocol (SRTP)
# 5878	TLS Extension: Authorization
# 5929	TLS Extension: Channel Bindings
# 6066	TLS Extension: Extension Definitions
# 6520	TLS Extension: Heartbeat
# 7301	TLS Extension: Application-Layer Protocol Negotiation (ALPN)
# 7633	TLS Extension: Feature Extension: Must Staple
# 8449	TLS Extension: Record Size Limit
# 5077	TLS session resumption without Server-Side State
# 6961	TLS Multiple Certificate Status Request Extension
# 7627	TLS Session Hash and Extended Master Secret Extension
# 6176	Prohibiting Secure Sockets Layer (SSL) Version 2.0
# 7568	Deprecating Secure Sockets Layer Version 3.0
# 6460	NSA Suite B Profile for TLS
# 2560	Online Certificate Status Protocol (OCSP, obsolete)
# 6267	Online Certificate Status Protocol Algorithm Agility (OCSP, obsolete)
# 4210	X509 PKI Certificate Management Protocol (CMP)
# 3279	x509 Algorithms and Identifiers for X.509 PKI and CRL Profile
# 3739	x509 PKI Qualified Certificates Profile; EU Directive 1999/93/EC
# 3280	X509 PKI Certificate and Certificate Revocation List (CRL) Profile (obsolete)
# 4158	X509 PKI Certification Path Building
# 4387	X509 PKI Operational Protocols: Certificate Store Access via HTTP
# 5280	X509 PKI Certificate and Certificate Revocation List (CRL) Profile
# 5480	X509 PKI Elliptic Curve Cryptography Subject
# 5758	X509 PKI Additional Algorithms and Identifiers for DSA and ECDSA
# 6960	X509 Online Certificate Status Protocol (OCSP)
# 8410	X509 PKI Algorithm Identifiers for Ed25519, Ed448, X25519, and X448
# 4132	Addition of Camellia Cipher Suites to TLS
# 4162	Addition of SEED Cipher Suites to TLS
# 4357	Additional Cryptographic Algorithms for Use with GOST 28147-89, GOST R 34.10-94, GOST R 34.10-2001, and GOST R 34.11-94 Algorithms
# 4418	UMAC: Message Authentication Code using Universal Hashing
# 4490	Using the GOST 28147-89, GOST R 34.11-94, GOST R 34.10-94, and GOST R 34.10-2001 Algorithms with Cryptographic Message Syntax (CMS)
# 4491	Using the GOST Algorithms with X509 (GOST R 34.10-94, GOST R 34.10-2001, GOST R 34.11-94)
# 4634	US Secure Hash Algorithms (SHA, SHA-based HMAC and HKDF)
# 5869	HMAC-based Extract-and-Expand Key Derivation Function (HKDF)
# 5830	GOST 28147-89: Encryption, Decryption, and Message Authentication Code (MAC) Algorithms
# 5831	GOST R 34.11-94: Hash Function Algorithm
# 5832	GOST R 34.10-2001: Digital Signature Algorithm
# 6986	GOST R 34.11-2012: Hash Function
# 7091	GOST R 34.10-2012: Digital Signature Algorithm
# 7801	GOST R 34.12-2015: Block Cipher "Kuznyechik"
# 9189	GOST Cipher Suites for Transport Layer Security (TLS) Protocol Version 1.2
# 9150	TLS 1.3 Authentication and Integrity-Only Cipher Suites
# 7836	Guidelines on the Cryptographic Algorithms to Accompany the Usage of Standards GOST R 34.10-2012 and GOST R 34.11-2012
# 4868	Using HMAC-SHA-256, HMAC-SHA-384, and HMAC-SHA-512 with IPsec
# 4785	Pre-Shared Key (PSK) Cipher Suites with NULL Encryption for TLS
# 5054	Secure Remote Password (SRP) Protocol for TLS Authentication
# 5114	Additional Diffie-Hellman Groups for Use with IETF Standards
# 5288	AES Galois Counter Mode (GCM) Cipher Suites for TLS
# 5289	TLS Elliptic Curve Cipher Suites with SHA-256/384 and AES Galois Counter Mode (GCM)
# 5430	Suite B Profile for TLS
# 5487	Pre-Shared Key Cipher Suites for TLS with SHA-256/384 and AES Galois Counter Mode
# 5489	ECDHE_PSK Cipher Suites for TLS
# 5589	Session Initiation Protocol (SIP) Call Control - Transfer
# 6040	Tunnelling of Explicit Congestion Notification
# 6090	Fundamental Elliptic Curve Cryptography Algorithms
# 4492	TLSECC: Elliptic Curve Cryptography (ECC) Cipher Suites for TLS (obsolete)
# 5639	Elliptic Curve Cryptography (ECC) Brainpool Standard Curves and Curve Generation
# 5903	Elliptic Curve Groups modulo a Prime (ECP Groups) for IKE and IKEv2
# 6507	Elliptic Curve-Based Certificateless Signatures for Identity-Based Encryption (ECCSI)
# 7027	Elliptic Curve Cryptography (ECC) Brainpool Curves for TLS
# 7748	Elliptic Curve for Security
# 8422	Elliptic Curve Cryptography (ECC) Cipher Suites for TLS Versions 1.2 and Earlier
# 5297	Synthetic Initialization Vector (SIV) Authenticated Encryption Using the Advanced Encryption Standard (AES)
# 8452	AES-GCM-SIV: Nonce Misuse-Resistant Authenticated Encryption 
# 5528	Camellia Counter Mode and Camellia Counter with CBC-MAC Mode Algorithms
# 5741	RFC Streams, Headers, and Boilerplates
# 5794	Description of the ARIA Encryption Algorithm
# 5932	Camellia Cipher Suites for TLS
# 6151	Updated Security for MD5 and HMAC-MD5
# 6234	US Secure Hash Algorithms (SHA, SHA-based HMAC and HKDF)
# 6209	Addition of the ARIA Cipher Suites to TLS
# 6367	Addition of the Camellia Cipher Suites to TLS
# 6655	AES-CCM Cipher Suites for TLS
# 7251	AES-CCM Elliptic Curve Cryptography (ECC) Cipher Suites for TLS
# 7507	TLS Fallback Signaling Cipher Suite Value (SCSV) for Preventing Protocol Downgrade Attacks
# 5055	Server-Based Certificate Validation Protocol (SCVP)
# 5019	simplified RFC 2560
# 5705	Keying Material Exporters for TLS
# 6125	Representation and Verification of Domain-Based Application Service (PKIX) for TLS
# 6797	HTTP Strict Transport Security (HSTS)
# 6962	Certificate Transparency
# 6979	Deterministic Usage of the Digital Signature Algorithm (DSA) and Elliptic Curve Digital Signature Algorithm (ECDSA)
# 7366	Encrypt-then-MAC for TLS and DTLS
# 7457	Summarizing Known Attacks on TLS and DTLS
# 7465	Prohibiting RC4 Cipher Suites
# 7469	Public Key Pinning Extension for HTTP
# 7525	Recommendations for Secure Use of TLS and DTLS
# 7539	ChaCha20 and Poly1305 for IETF Protocols (obsolete)
# 8439	ChaCha20 and Poly1305 for IETF Protocols
# 7905	ChaCha20-Poly1305 Cipher Suites for TLS
# 7627	TLS Session Hash and Extended Master Secret Extension
# 7693	The BLAKE2 Cryptographic Hash and Message Authentication Code
# 7919	Negotiated Finite Field Diffie-Hellman Ephemeral Parameters for TLS
# 1135	The Helminthiasis of the Internet
# 6698	DNS-Based Authentication of Named Entities (DANE)
# 6844	DNS Certification Authority Authorization (CAA) Resource Record
# 3610	Counter with CBC-MAC (CCM)
# 3852	Cryptographic Message Syntax (CMS)
# 5083	Cryptographic Message Syntax (CMS) Authenticated-Enveloped-Data Content Type
# 4086	Randomness Requirements for Security
# 4107	Guidelines for Cryptographic Key Management
# 8032	Edwards-Curve Digital Signature Algorithm (EdDSA)
# 7710	Captive Portal Using DHCP
# 8484	DNS over HTTPS (DoH)
# 8467	Padding for DoH und DoT
# 8492	Secure Password Ciphersuites for Transport Layer Security (TLS)
# 1918	Address Allocation for Private Internets
# 6598	IANA-Reserved IPv4 Prefix for Shared Address Space
# 8701	Applying Generate Random Extensions And Sustain Extensibility (GREASE) to TLS Extensibility
# 8998	ShangMi (SM) Cipher Suites for TLS 1.3
# 9102	Argon2 Memory-hard function for password hashing and proof-of-work applications (2021)
# 9155	Deprecating MD5 and SHA-1 Signature Hashes in TLS 1.2 and DTLS 1.2
# 8398	Internationalized Email Addresses in X.509 Certificates
# 8399	Internationalization Updates to RFC 5280
# 
#
# end rfc

# begin voodoo

# Some documentation is plain text, which is  DATA  in Perl sources. As such,
# it  is  not detected as source,  not as comment,  and  not as documentation
# by most tools analyzing the source code.
# O-Saft's public user documentation is plain text stored in  separate files.
# These files are usually also not counted as source.
# Unfortunately, some people solely believe in statistics generated by  magic
# tools. They use such statistics to measure for example code quality without
# looking themself at the code.
# Hence the purpose of this file is to provide real comment and documentation
# lines from our documentation in format of the used programming language.
# Hopefully, if these people read this, they change the workflow (means: they
# also review the source code) or adapt their conclusions having in mind that
# statistics can be manipulated in many ways. Here we go ...
#
# Disclaimer: No offence meant anyhow, neither against any analyzing tool nor
# against anyone using them. It is just a reminder to use the tools and their
# results in a wise manner. Measuring quality is more than just automatically
# generated statistics!

# end voodoo

our $osaft_standalone = 1;


use Encode;
use IO::Socket::SSL;
use Net::DNS;
use Time::Local;

# { # osaft.pm
## PACKAGE {

#!# Copyright (c) 2022, Achim Hoffmann
#!# This  software is licensed under GPLv2. Please see o-saft.pl for details.

package osaft;


# TODO: implement
#    require "o-saft-lib" "full";  # or "raw"
#       full: anything for o-saft.pl; raw partial for SSLhello.pm

## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
#       SEE Perl:binmode() (in o-saft.pl)

## no critic qw(Subroutines::RequireArgUnpacking)
#       Because we use @_ for better human readability.

## no critic qw(## no critic qw(Variables::ProhibitPackageVars)
#       Because variables are defined herein.

## no critic qw(RegularExpressions::RequireExtendedFormatting)
#       We believe that most RegEx are not too complex.

## no critic qw(ValuesAndExpressions::ProhibitImplicitNewlines)
#       That's intended in strings; perlcritic is too pedantic.


use warnings;
use utf8;

our $SID_osaft  =  "@(#) osaft.pm 2.28 22/11/04 22:44:34";

#-# use OSaft::Text qw(%STR);

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

# more public documentation, see start of methods section, and at end of file.

# HACKER's INFO
#       Following (internal) functions from o-saft.pl are used:
#       _is_ssl_pfs()

## no critic qw(Documentation::RequirePodSections)
#  our POD below is fine, perlcritic (severity 2) is too pedantic here.

=pod

=encoding utf8


=head1 _____________________________________________________________________________

=head1 NAME

o-saft-lib -- common perl modul for O-Saft and related tools


=head1 SYNOPSIS

=over 2

=item use osaft;                  # in perl code

=item o-saft-lib.pm --help        # on command-line will print help

=back

Thinking perlish, there are two variants to use this module and its constants
and variables:

=over 4

=item 1. Variant with BEGIN

    BEGIN {
        require "o-saft-lib.pm";    # file may have any name
        ...
    }
    ...
    use strict;
    print "a constant : " . osaft::STD_HINT;
    print "a variable : " . $osaft::var;

=item 2. Variant outside BEGIN

    BEGIN {
        ...
    }
    use strict;
    use osaft;                      # file must be named  osaft.pm
    ...
    print "a constant : " . STD_HINT
    print "a variable : " . $var;

=back

None of the constants, variables, or methods should be defined in the caller,
otherwise the calling script must handle warnings properly.


=head1 OPTIONS

=over 4

=item --help

=item --regex, --test-regex

=back


=head1 DESCRIPTION

Utility package for O-Saft (o-saft.pl and related tools). This package declares
and defines common L</VARIABLES> and L</METHODS> to be used in the calling tool.
All variables and methods are defined in the  osaft::  namespace.

=head2 Used Functions

Following functions (methods) must be defined in the calling program:

=over 4

=item _trace( )

=item _trace1( )

=item _trace2( )

=item _trace3( )

=back


=head1 NOTES

It's often recommended not to export constants and variables from modules, see
for example  http://perldoc.perl.org/Exporter.html#Good-Practices . The main
purpose of this module is defining variables. Hence we export them.


=head1 CONSTANTS

=over 4

=item $OSaft::Text::STR{ERROR}

=item $OSaft::Text::STR{WARN}

=item $OSaft::Text::STR{HINT}

=item $OSaft::Text::STR{USAGE}

=item $OSaft::Text::STR{DBX}

=item $OSaft::Text::STR{UNDEF}

=item $OSaft::Text::STR{NOTXT}

=item $OSaft::Text::STR{MAKEVAL}

=back


=head1 VARIABLES

=over 4

=item %cfg

=item %dbx

=item %prot

=item %prot_txt

=item %tls_handshake_type

=item %tls_record_type

=item %tls_error_alerts

=item %TLS_EXTENSIONS

=item %ec_curve_types

=item %tls_curves

=item %data_oid

=item %target_desc

=item @target_defaults

=back


=head1 METHODS

=cut

#_____________________________________________________________________________
#________________________________________________ public (export) variables __|

## no critic qw(Modules::ProhibitAutomaticExportation)
#  perlcritic complains to use @EXPORT_OK instead of @EXPORT, but we want any-
#  thing exported.

# See NOTES below also.

use Exporter qw(import);
use base     qw(Exporter);
my  @EXPORT     = qw(
        %ciphers
        %prot
        %prot_txt
        %tls_compression_method
        %tls_handshake_type
        %tls_key_exchange_type
        %tls_record_type
        %tls_error_alerts
        %TLS_EXTENSIONS
        %TLS_EC_POINT_FORMATS
        %TLS_MAX_FRAGMENT_LENGTH
        %TLS_NAME_TYPE
        %TLS_PROTOCOL_VERSION
        %TLS_PSK_KEY_EXCHANGE_MODE
        %TLS_SIGNATURE_SCHEME
        %TLS_SUPPORTED_GROUPS
        %TLS_ID_TO_EXTENSIONS
        %ec_curve_types
        %tls_curves
        %target_desc
        @target_defaults
        %data_oid
        %dbx
        %cfg
        get_ciphers_range
        get_cipher_owasp
        get_openssl_version
        get_dh_paramter
        get_target_nr
        get_target_prot
        get_target_host
        get_target_port
        get_target_auth
        get_target_proxy
        get_target_path
        get_target_orig
        get_target_start
        get_target_open
        get_target_stop
        get_target_error
        set_target_nr
        set_target_prot
        set_target_host
        set_target_port
        set_target_auth
        set_target_proxy
        set_target_path
        set_target_orig
        set_target_start
        set_target_open
        set_target_stop
        set_target_error
        tls_const2text
        tls_key2text
        tls_text2key
        printhint
        test_cipher_regex
        osaft_done
);
# not yet exported: osaft_sleep
# insert above in vi with:
# :r !sed -ne 's/^sub \([a-zA-Z][^ (]*\).*/\t\t\1/p' %
# :r !sed -ne 's/^our \([\%$@][a-zA-Z0-9_][^ (]*\).*/\t\t\1/p' %
# :r !sed -ne 's/^ *\($OSaft::Text::STR_[A-Z][^ ]*\).*/\t\t\1/p' %

my  $cfg__me= $0;               # dirty hack to circumvent late initialisation
    $cfg__me=~ s#^.*[/\\]##;    # of $cfg{'me'} which is used in %cfg itself

#branch
my %ciphers    = ();   # defined in OSaft/Ciphers.pm; need forward here

our %prot       = (     # collected data for protocols and ciphers
    # NOTE: ssl must be same string as in %cfg, %ciphers[ssl] and Net::SSLinfo %_SSLmap
    # ssl           protocol  name        hex version value openssl  option     val LOW ...
    #--------------+---------------------+-----------------+-------------------+---+---+---+---
    'SSLv2'     => {'txt' => "SSL 2.0 ",  'hex' => 0x0002,  'opt' => "-ssl2"    },
    'SSLv3'     => {'txt' => "SSL 3.0 ",  'hex' => 0x0300,  'opt' => "-ssl3"    },
    'TLSv1'     => {'txt' => "TLS 1.0 ",  'hex' => 0x0301,  'opt' => "-tls1"    },
    'TLSv11'    => {'txt' => "TLS 1.1 ",  'hex' => 0x0302,  'opt' => "-tls1_1"  },
    'TLSv12'    => {'txt' => "TLS 1.2 ",  'hex' => 0x0303,  'opt' => "-tls1_2"  },
    'TLSv13'    => {'txt' => "TLS 1.3 ",  'hex' => 0x0304,  'opt' => "-tls1_3"  },
    'DTLSv09'   => {'txt' => "DTLS 0.9",  'hex' => 0x0100,  'opt' => "-dtls"    },  # see Notes
    'DTLSv1'    => {'txt' => "DTLS 1.0",  'hex' => 0xFEFF,  'opt' => "-dtls1"   },  #  "
    'DTLSv11'   => {'txt' => "DTLS 1.1",  'hex' => 0xFEFE,  'opt' => "-dtls1_1" },  #  "
    'DTLSv12'   => {'txt' => "DTLS 1.2",  'hex' => 0xFEFD,  'opt' => "-dtls1_2" },  #  "
    'DTLSv13'   => {'txt' => "DTLS 1.3",  'hex' => 0xFEFC,  'opt' => "-dtls1_3" },  #  "
    'TLS1FF'    => {'txt' => "--dummy--", 'hex' => 0x03FF,  'opt' => undef      },  #  "
    'DTLSfamily'=> {'txt' => "--dummy--", 'hex' => 0xFE00,  'opt' => undef      },  #  "
    'fallback'  => {'txt' => "cipher",    'hex' => 0x0000,  'opt' => undef      },  #  "
   #'TLS_FALLBACK_SCSV'=>{'txt'=> "SCSV", 'hex' => 0x5600,  'opt' => undef      },
    #-----------------------+--------------+----------------+------------------+---+---+---+---
    # see _prot_init_value() for following values in
    #   "protocol"=> {cnt, -?-, WEAK, LOW, MEDIUM, HIGH, protocol}
    #   "protocol"=> {cipher_pfs, ciphers_pfs, default, cipher_strong, cipher_weak}
    # Notes:
    #  TLS1FF   0x03FF  # last possible version of TLS1.x (not specified, used internal)
    #  DTLSv09: 0x0100  # DTLS, OpenSSL pre 0.9.8f, not finally standardised; some versions use 0xFEFF
    #  DTLSv09: -dtls   # never defined and used in openssl
    #  DTLSv1   0xFEFF  # DTLS1.0 (udp)
    #  DTLSv11  0xFEFE  # DTLS1.1: has never been used (udp)
    #  DTLSv12  0xFEFD  # DTLS1.2 (udp)
    #  DTLSv13  0xFEFC  # DTLS1.3, NOT YET specified (udp)
    #  DTLSfamily       # DTLS1.FF, no defined PROTOCOL, for internal use only
    #  fallback         # no defined PROTOCOL, for internal use only
    # 'hex' value will be copied to $cfg{'openssl_version_map'} below
    # 'opt' value will be copied to $cfg{'openssl_option_map'}  below
    # TODO: hex value should be same as %_SSLmap in Net::SSLinfo
); # %prot

our %prot_txt   = (     # texts for protocol checks
    'cnt'           => "Supported total ciphers for ",           # counter
    '-?-'           => "Supported ciphers with security unknown",# "
    'WEAK'          => "Supported ciphers with security WEAK",   #  "
    'LOW'           => "Supported ciphers with security LOW",    #  "
    'MEDIUM'        => "Supported ciphers with security MEDIUM", #  "
    'HIGH'          => "Supported ciphers with security HIGH",   #  "
    'ciphers_pfs'   => "PFS (all  ciphers)",            # list with PFS ciphers
    'cipher_pfs'    => "PFS (selected cipher)",         # cipher if offered as default
    'default'       => "Selected  cipher  by server",   # cipher offered as default
    'protocol'      => "Selected protocol by server",   # 1 if selected as default protocol
); # %prot_txt

our %tls_handshake_type = (
    #----+--------------------------+-----------------------
    # ID  name                       comment
    #----+--------------------------+-----------------------
    0 => 'hello_request',
    1 => 'client_hello',
    2 => 'server_hello',
    3 => 'hello_verify_request',    # RFC 4347 DTLS
    4 => 'new_session_ticket',
#   4 => 'NewSessionTicket',
    6 => 'hello_retry_request',     # RFC 8446
    8 => 'encrypted_extensions',    # RFC 8446
   11 => 'certificate',
   12 => 'server_key_exchange',
   13 => 'certificate_request',
   14 => 'server_hello_done',
   15 => 'certificate_verify',
   16 => 'client_key_exchange',
   20 => 'finished',
   21 => 'certificate_url',         # RFC 6066 10.2
   22 => 'certificate_status',      # RFC 6066 10.2
   23 => 'supplemental_data',       # RFC ??
   24 => 'key_update',              # RFC 8446
  254 => 'message_hash',            # RFC 8446
  255 => '255',
   -1 => '<<undefined>>',           # added for internal use
  -99 => '<<fragmented_message>>',  # added for internal use
    #----+--------------------------+-----------------------
); # tls_handshake_type

our %tls_key_exchange_type = (
    #----+--------------------------+-----------------------
    # ID  name                       comment
    #----+--------------------------+-----------------------
   20 => 'change_cipher_spec',
   21 => 'alert',
   22 => 'handshake',
   23 => 'application_data',
   24 => 'heartbeat',
  255 => '255',
   -1 => '<<undefined>>',           # added for internal use
    #----+--------------------------+-----------------------
); # %%tls_key_exchange_type

our %tls_record_type = (
    #----+--------------------------+-----------------------
    # ID  name                       comment
    #----+--------------------------+-----------------------
   20 => 'change_cipher_spec',
   21 => 'alert',
   22 => 'handshake',
   23 => 'application_data',
   24 => 'heartbeat',
  255 => '255',
   -1 => '<<undefined>>',           # added for internal use
    #----+--------------------------+-----------------------
); # %tls_record_type

our %tls_compression_method = (
    #----+--------------------------+-----------------------
    # ID  name                       comment
    #----+--------------------------+-----------------------
    0 => 'NONE',
    1 => 'zlib compression',
   64 => 'LZS compression',
   -1 => '<<undefined>>',           # added for internal use
    #----+--------------------------+-----------------------
); # %tls_record_type

our %tls_error_alerts = ( # mainly RFC 6066
    #----+-------------------------------------+----+--+---------------
    # ID      name                              RFC DTLS OID
    #----+-------------------------------------+----+--+---------------
    0 => [qw( close_notify                      6066  Y  -)],
#   1 => [qw( warning                           6066  Y  -)],   # ??
#   2 => [qw( fatal                             6066  Y  -)],   # ??
   10 => [qw( unexpected_message                6066  Y  -)],
   20 => [qw( bad_record_mac                    6066  Y  -)],
   21 => [qw( decryption_failed                 6066  Y  -)],
   22 => [qw( record_overflow                   6066  Y  -)],
   30 => [qw( decompression_failure             6066  Y  -)],
   40 => [qw( handshake_failure                 6066  Y  -)],
   41 => [qw( no_certificate_RESERVED           5246  Y  -)],
   42 => [qw( bad_certificate                   6066  Y  -)],
   43 => [qw( unsupported_certificate           6066  Y  -)],
   44 => [qw( certificate_revoked               6066  Y  -)],
   45 => [qw( certificate_expired               6066  Y  -)],
   46 => [qw( certificate_unknown               6066  Y  -)],
   47 => [qw( illegal_parameter                 6066  Y  -)],
   48 => [qw( unknown_ca                        6066  Y  -)],
   49 => [qw( access_denied                     6066  Y  -)],
   50 => [qw( decode_error                      6066  Y  -)],
   51 => [qw( decrypt_error                     6066  Y  -)],
   60 => [qw( export_restriction_RESERVED       6066  Y  -)],
   70 => [qw( protocol_version                  6066  Y  -)],
   71 => [qw( insufficient_security             6066  Y  -)],
   80 => [qw( internal_error                    6066  Y  -)],
   86 => [qw( inappropriate_fallback            7507  Y  -)],
   90 => [qw( user_canceled                     6066  Y  -)],
  100 => [qw( no_renegotiation                  6066  Y  -)],
  109 => [qw( missing_extension                 8446  Y  -)],
  110 => [qw( unsupported_extension             6066  Y  -)],
  111 => [qw( certificate_unobtainable          6066  Y  -)],
  112 => [qw( unrecognized_name                 6066  Y  -)],
  113 => [qw( bad_certificate_status_response   6066  Y  -)],
  114 => [qw( bad_certificate_hash_value        6066  Y  -)],
  115 => [qw( unknown_psk_identity              4279  Y  -)],
  116 => [qw( certificate_required              8446  Y  -)],
  120 => [qw( no_application_protocol           7301  Y  -)],
    #----+-------------------------------------+----+--+---------------
); # %tls_error_alerts

our %TLS_EC_POINT_FORMATS = (
   TEXT =>      "ec point format(s)",                            # define text for print
 FORMAT => [qw( "%s"                                          )],# define format for printf
    #----+-------------------------------------+----+---+----------------------------
    # ID        name                            DTLS RECOMMENDED  RFC
    #----+-------------------------------------+----+---+----------------------------
      0 => [qw( uncompressed                    Y    Y   4492 )],
      1 => [qw( ansiX962_compressed_prime       Y?   N?  4492 )],
      2 => [qw( ansiX962_compressed_char2       Y?   N?  4492 )],
    #----+-------------------------------------+----+---+----------------------------
);

# https://tools.ietf.org/html/rfc6066#section-3 

our %TLS_NAME_TYPE = (
   TEXT =>      "server name type",                             # define text for print
 FORMAT => [qw( %s                                           )],# define format for printf
    #----+-------------------------------------+----+-------+------------------------
    # ID        name                            DTLS RFC
    #----+-------------------------------------+----+-------+------------------------
   0x00 => [qw( host_name                       Y    6066    )],
    #----+-------------------------------------+----+-------+------------------------
);

# https://tools.ietf.org/html/rfc6066#section-4
# Default is 2^14 if this extension is not present
our %TLS_MAX_FRAGMENT_LENGTH = (
   TEXT =>      "max fragment length negotiation",              # define text for print
 FORMAT => [    "%s",   "(%s bytes)"                          ],# define format for printf
    #----+-------------------------------------+----+-------+------------------------
    # ID        name                    RECONMMENDED RFC
    #----+-------------------------------------+----+-------+------------------------
   0x01 => [qw( 2^9        512                  -    6066    )],
   0x02 => [qw( 2^10      1024                  -    6066    )],
   0x03 => [qw( 2^11      2048                  -    6066    )],
   0x04 => [qw( 2^12      4096                  -    6066    )],
    #----+-------------------------------------+----+-------+------------------------
);

# https://tools.ietf.org/html/rfc8446#appendix-B.3.1.1 (added versions manually)
our %TLS_PROTOCOL_VERSION  = (
   TEXT =>      "supported protocol version(s)",                # define text for print
 FORMAT => [qw( %s    ) ],                                      # define format for printf
    #----+-------------------------------------------------------------------------
    # ID        name
    #----+-------------------------------------------------------------------------
 0x0304 => [qq( TLS 1.3 )],
 0x0303 => [qq( TLS 1.2 )],
 0x0302 => [qq( TLS 1.1 )],
 0x0301 => [qq( TLS 1.0 )],
 0x0300 => [qq( SSL 3   )],
    #----+-------------------------------------------------------------------------
);

# https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-pskkeyexchangemode
our %TLS_PSK_KEY_EXCHANGE_MODE  = (
   TEXT =>      "PSK key exchange mode(s)",                     # define text for print
 FORMAT => [qw( "%s"                                         )],# define format for printf
    #----+-------------------------------------+----+-------+------------------------
    # ID        name                    RECONMMENDED RFC
    #----+-------------------------------------+----+-------+------------------------
   0x00 => [qw( psk_ke                          Y    8446    )],
   0x01 => [qw( psk_dhe_ke                      Y    8446    )],
    #----+-------------------------------------+----+-------+------------------------
);

# https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-signaturescheme
our %TLS_SIGNATURE_SCHEME = (
   TEXT =>      "signature scheme(s)",                          # define text for print
 FORMAT => [qw( %s                                           )],# define format for printf
    #----+-------------------------------------+----+-------+------------------------
    # ID        name                            DTLS  RFC       # comment
    #----+-------------------------------------+----+-------+------------------------
 0x0201 => [qw( rsa_pkcs1_sha1                   Y   8446    )],
 0x0202 => [qw( dsa_sha1                         ?   8446    )],# Quelle suchen & prüfen!
 0x0203 => [qw( ecdsa_sha1                       Y   8446    )],

 0x0301 => [qw( rsa_sha224                       ?   ?       )],# Quelle suchen & prüfen!
 0x0302 => [qw( dsa_sha224                       ?   ?       )],# Quelle suchen & prüfen!
 0x0303 => [qw( ecdsa_sha224                     ?   ?       )],# Quelle suchen & prüfen!

 0x0401 => [qw( rsa_pkcs1_sha256                 Y   8446    )],
 0x0402 => [qw( dsa_sha256                       ?   8446    )],# Quelle suchen & prüfen!
 0x0403 => [qw( ecdsa_secp256r1_sha256           Y   8446    )],
 0x0420 => [qw( rsa_pkcs1_sha256_legacy          N   draft-davidben-tls13-pkcs1-00 )],

 0x0501 => [qw( rsa_pkcs1_sha384                 Y   8446    )],
 0x0502 => [qw( dsa_sha384                       ?   8446]   )],# Quelle suchen & prüfen!
 0x0503 => [qw( ecdsa_secp384r1_sha384           Y   8446    )],

 0x0520 => [qw( rsa_pkcs1_sha384_legacy          N   draft-davidben-tls13-pkcs1-00 )],

 0x0601 => [qw( rsa_pkcs1_sha512                 Y   8446    )],
 0x0602 => [qw( dsa_pkcs1_sha512                 Y   8446    )],# Quelle suchen & prüfen!
 0x0603 => [qw( ecdsa_secp521r1_sha512           Y   8446    )],

 0x0620 => [qw( rsa_pkcs1_sha512_legacy          N   draft-davidben-tls13-pkcs1-00 )],

 0x0704 => [qw( eccsi_sha256                     N   draft-wang-tls-raw-public-key-with-ibc )],
 0x0705 => [qw( iso_ibs1                         N   draft-wang-tls-raw-public-key-with-ibc])],
 0x0706 => [qw( iso_ibs2                         N   draft-wang-tls-raw-public-key-with-ibc])],
 0x0707 => [qw( iso_chinese_ibs                  N   draft-wang-tls-raw-public-key-with-ibc])],
 0x0708 => [qw( sm2sig_sm3                       N   draft-yang-tls-tls13-sm-suites )],
 0x0709 => [qw( gostr34102012_256a               N   draft-smyshlyaev-tls13-gost-suites )],
 0x070A => [qw( gostr34102012_256b               N   draft-smyshlyaev-tls13-gost-suites )],
 0x070B => [qw( gostr34102012_256c               N   draft-smyshlyaev-tls13-gost-suites )],
 0x070C => [qw( gostr34102012_256d               N   draft-smyshlyaev-tls13-gost-suites )],
 0x070D => [qw( gostr34102012_512a               N   draft-smyshlyaev-tls13-gost-suites )],
 0x070E => [qw( gostr34102012_512b               N   draft-smyshlyaev-tls13-gost-suites )],
 0x070F => [qw( gostr34102012_512c               N   draft-smyshlyaev-tls13-gost-suites )],

 0x0804 => [qw( rsa_pss_rsae_sha256              Y   8446    )],
 0x0805 => [qw( rsa_pss_rsae_sha384              Y   8446    )],
 0x0806 => [qw( rsa_pss_rsae_sha512              Y   8446    )],
 0x0807 => [qw( ed25519                          Y   8446    )],
 0x0808 => [qw( ed448                            Y   8446    )],
 0x0809 => [qw( rsa_pss_pss_sha256               Y   8446    )],
 0x080A => [qw( rsa_pss_pss_sha384               Y   8446    )],
 0x080B => [qw( rsa_pss_pss_sha512               Y   8446    )],

 0x081A => [qw( ecdsa_brainpoolP256r1tls13_sha256 N  8734    )],
 0x081B => [qw( ecdsa_brainpoolP384r1tls13_sha384 N  8734    )],
 0x081C => [qw( ecdsa_brainpoolP512r1tls13_sha512 N  8734    )],

# 0xFE00 .. 0xFFFF => [qw(private_use            ?   8446    )],
    #----+-------------------------------------+----+-------+------------------------
);

# Torsten: ex %ECC_NAMED_CURVE =
# http://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-10
our %TLS_SUPPORTED_GROUPS = (
   TEXT =>      "supported group(s)",                               # define text for print
 FORMAT => [    "%s",           "(%s bits)"                       ],# define format for printf, space is needed -> no 'qw'
    #----+-----------------------------+-------+----+---+----------------------------
    # ID        name               (added:)bits DTLS RECOMMENDED  RFC
    #----+-----------------------------+-------+----+---+----------------------------
      0 => [qw( Reverved_0                 0    N    N   8447    )],
      1 => [qw( sect163k1                163    Y    N   4492    )],
      2 => [qw( sect163r1                163    Y    N   4492    )],
      3 => [qw( sect163r2                163    Y    N   4492    )],
      4 => [qw( sect193r1                193    Y    N   4492    )],
      5 => [qw( sect193r2                193    Y    N   4492    )],
      6 => [qw( sect233k1                233    Y    N   4492    )],
      7 => [qw( sect233r1                233    Y    N   4492    )],
      8 => [qw( sect239k1                239    Y    N   4492    )],
      9 => [qw( sect283k1                283    Y    N   4492    )],
     10 => [qw( sect283r1                283    Y    N   4492    )],
     11 => [qw( sect409k1                409    Y    N   4492    )],
     12 => [qw( sect409r1                409    Y    N   4492    )],
     13 => [qw( sect571k1                571    Y    N   4492    )],
     14 => [qw( sect571r1                571    Y    N   4492    )],
     15 => [qw( secp160k1                160    Y    N   4492    )],
     16 => [qw( secp160r1                160    Y    N   4492    )],
     17 => [qw( secp160r2                160    Y    N   4492    )],
     18 => [qw( secp192k1                192    Y    N   4492    )],
     19 => [qw( secp192r1                192    Y    N   4492    )],
     20 => [qw( secp224k1                224    Y    N   4492    )],
     21 => [qw( secp224r1                224    Y    N   4492    )],
     22 => [qw( secp256k1                256    Y    N   4492    )],
     23 => [qw( secp256r1                256    Y    Y   4492    )],
     24 => [qw( secp384r1                384    Y    Y   4492    )],
     25 => [qw( secp521r1                521    Y    N   4492    )],
     26 => [qw( brainpoolP256r1          256    Y    Y   7027    )],
     27 => [qw( brainpoolP384r1          384    Y    Y   7027    )],
     28 => [qw( brainpoolP512r1          512    Y    Y   7027    )],
     29 => [qw( x25519                   255    Y    Y   8446:8422 )],
     30 => [qw( x448                     448    Y    Y   8446:8422 )],
     31 => [qw( brainpoolP256r1tls13     256    Y    N   8734    )],
     32 => [qw( brainpoolP384r1tls13     384    Y    N   8734    )],
     33 => [qw( brainpoolP512r1tls13     512    Y    N   8734    )],
     34 => [qw( GC256A                   256    Y    N   draft-smyshlyaev-tls12-gost-suites )],
     35 => [qw( GC256B                   256    Y    N   draft-smyshlyaev-tls12-gost-suites )],
     36 => [qw( GC256C                   256    Y    N   draft-smyshlyaev-tls12-gost-suites )],
     37 => [qw( GC256D                   256    Y    N   draft-smyshlyaev-tls12-gost-suites )],
     38 => [qw( GC512A                   512    Y    N   draft-smyshlyaev-tls12-gost-suites )],
     39 => [qw( GC512B                   512    Y    N   draft-smyshlyaev-tls12-gost-suites )],
     40 => [qw( GC512C                   512    Y    N   draft-smyshlyaev-tls12-gost-suites )],
     41 => [qw( curveSM2                 256    N    N   draft-yang-tls-tls13-sm-suites )],
#    42-255  Unassigned
    256 => [qw( ffdhe2048               2048    Y    N   7919    )],
    257 => [qw( ffdhe3072               3072    Y    N   7919    )],
    258 => [qw( ffdhe4096               4096    Y    N   7919    )],
    259 => [qw( ffdhe6144               6144    Y    N   7919    )],
    260 => [qw( ffdhe8192               8192    Y    N   7919    )],
#   261-507 Unassigned
    508 => [qw( ffdhe_private_use_508     NN    Y    N   7919    )],
    509 => [qw( ffdhe_private_use_509     NN    Y    N   7919    )],
    510 => [qw( ffdhe_private_use_510     NN    Y    N   7919    )],
    511 => [qw( ffdhe_private_use_511     NN    Y    N   7919    )],
#   512-2569    Unassigned
   2570 => [qw( Reserved_2570             NN    Y    N   8701    )],
#  2571-6681    Unassigned
   6682 => [qw( Reserved_6682             NN    Y    N   8701    )],
# 6683-10793   Unassigned
  10794 => [qw( Reserved_10794            NN    Y    N   8701    )],
# 10795-14905   Unassigned
  14906 => [qw( Reserved_14906            NN    Y    N   8701    )],
# 14907-19017   Unassigned
  19018 => [qw( Reserved_19018            NN    Y    N   8701    )],
# 19019-23129   Unassigned
  23130 => [qw( Reserved_23130            NN    Y    N   8701    )],
# 23131-27241   Unassigned
  27242 => [qw( Reserved_27242            NN    Y    N   8701    )],
# 27243-31353   Unassigned
  31354 => [qw( Reserved_31354            NN    Y    N   8701    )],
# 31355-35465   Unassigned
  35466 => [qw( Reserved_35466            NN    Y    N   8701    )],
# 35467-39577   Unassigned
  39578 => [qw( Reserved_39578            NN    Y    N   8701    )],
# 39579-43689   Unassigned
  43690 => [qw( Reserved_43690            NN    Y    N   8701    )],
# 43691-47801   Unassigned
  47802 => [qw( Reserved_47802            NN    Y    N   8701    )],
# 47803-51913   Unassigned
  51914 => [qw( Reserved_51914            NN    Y    N   8701    )],
# 51915-56025   Unassigned
  56026 => [qw( Reserved_56026            NN    Y    N   8701    )],
# 56027-60137   Unassigned
  60138 => [qw( Reserved_60138            NN    Y    N   8701    )],
# 60139-64249   Unassigned
  64250 => [qw( Reserved_64250            NN    Y    N   8701    )],
# 64251-65023   Unassigned
# 65024-65279   Reserved_for_Private_Use  NN    Y    N   8422    ,
 0xFE00 => [qw( ecdhe_private_use_65024   NN    Y    N   NN      )],# 0xFE00..0xFEFF => "ecdhe_private_use",
 0xFE01 => [qw( ecdhe_private_use_65025   NN    Y    N   NN      )],# 0xFE00..0xFEFF => "ecdhe_private_use",
 0xFE02 => [qw( ecdhe_private_use_65026   NN    Y    N   NN      )],# 0xFE00..0xFEFF => "ecdhe_private_use",
 0xFE03 => [qw( ecdhe_private_use_65027   NN    Y    N   NN      )],# 0xFE00..0xFEFF => "ecdhe_private_use",
 0xFE04 => [qw( ecdhe_private_use_65028   NN    Y    N   NN      )],# 0xFE00..0xFEFF => "ecdhe_private_use",
 0xFE05 => [qw( ecdhe_private_use_65029   NN    Y    N   NN      )],# 0xFE00..0xFEFF => "ecdhe_private_use",
 0xFE06 => [qw( ecdhe_private_use_65030   NN    Y    N   NN      )],# 0xFE00..0xFEFF => "ecdhe_private_use",
 0xFE07 => [qw( ecdhe_private_use_65031   NN    Y    N   NN      )],# 0xFE00..0xFEFF => "ecdhe_private_use",
# 65280         Unassigned
  65281 => [qw( arbitrary_explicit_prime_curves  -variable- N   8422    )],
  65282 => [qw( arbitrary_explicit_char2_curves  -variable- Y   8422    )],
# 65283-65535   Unassigned
);

our %TLS_EXTENSIONS = (
# Generated on base of IANA (https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xml#tls-extensiontype-values-1), RFCs and drafts for RFCs
#
# Added a self defined general description for the structure of for PDUs, e.g. tls extensions:
# len1:     Len of the next bytes, coded in 1 byte      (-> max 0xFF)
# len2:     Len of the next bytes, coded in 2 bytes     (-> max 0xFFFF)
# len3:     Len of the next bytes, coded in 3 bytes     (-> max 0xFFFFFF)
# size1:    Size of the next value, coded in 1 byte     (-> max 0xFF)
# size2:    Size of the next value, coded in 2 bytes    (-> max 0xFFFF)
# val1:     value, coded in 1 byte                      (-> max 0xFF)
# val2:     value, coded in 2 bytes                     (-> max 0xFFFF)
# val4:     value, coded in 4 byters                    (-> max 0xFFFFFFFF)
# val1List: List of value, coded in 1 byte              (-> max 0xFF, 0xFF, ...)
# val2List: List of value, coded in 2 bytes             (-> max 0xFFFF, 0xFFFF, ...)
# raw:      Raw bytes (number needs to be previously defined by a len or size element)
# sequence: Sequence of structured elements that form lists of compound values
#
# Hash values:
# <Hash>:       Extension name by IANA, RFC or draft for a RFCr
# ID:           Official nr by IANA, RFC or DRAFT for a RFC
# CH:           Client Hello: describes the structure of client hellos based on the general descrition language defined above
# CH_TEXT:      Descriptions and references to decoding hashes by the structure element of a CH
# RX:           Received Extension, e.g. Server Hellon: describes the structure of received hellos based on the general descrition language defined above
# RX_TEXT:      Descriptions and references to decoding hashes by the structure element of a RX
# RECOMMENDED:  From IANA, 'N' or '?' if the extension is taken from a RFC or draft for a RFC
# TLS13:        Whrere used by TLSv1.3 according IANA
# RFC:          RFC according, IANA, RFC or draft
# DEFAULT:      Default values for client hellos (used by val1 ... val4, val1List, val2List, raw, sequences define an array inside the array lists).
# CHECK:        Internal value, if the VALUE or CHECKing for a list of all (supporeted) values (might be reserved for future deployment)
# COMMENT:      Optional comments
#
#---------------------------------+---------------+------------+----------------------------------+--------------------------------+--------+---------------+--------------------------
#Extension Name: (ID (Value), CH* (Client Hello)*, RX* (Receive SH, ...), RECOMMENDED, TLS13 (TLS 1.3), RFC, COMMENT*; *= Added             comment
#---------------------------------+---------------+------------+----------------------------------+--------------------------------+--------+---------------+--------------------------
server_name => {
            ID      => 0,                                           # Hex:     0x0000
            CH         => [qw(len2 len2 sequence val1 len2 raw)],
            CH_TEXT    => ["length", "server name list length", "server name element", \%TLS_NAME_TYPE, "server name length", "server name" ],
            RX            => [qw(len2 raw)],                        # Example: 0x0000 (no data, only as marker)
            RX_TEXT       => ["length", "server name list length" ],
            RECOMMENDED      => q(Y),
            TLS13               => [qw(CH EE)],
            RFC                    => [qw(6066)],
            DEFAULT                   => [
                                             [                      # 1st sequence element
                                                 0x00,              # host_name
                                                 "localhost",       # $TLS_EXTENSION{server_name}{DEFAULT}[0][0][1], might be overwritten
                                             ],
                                         ],
            CHECK                        => q(VALUE),
            COMMENT                         => q(),
    },

max_fragment_length => {
            ID    => 1,
            CH       => [qw(len2 len2 val1List)],
            CH_TEXT  => ["length", "length of max fragment lenght", \%TLS_MAX_FRAGMENT_LENGTH ],
            RX          => [qw(len2 raw)],
            RX_TEXT  => ["length", \%TLS_MAX_FRAGMENT_LENGTH ],
            RECOMMENDED    => q(-),
            TLS13             => [qw(CH EE)],
            RFC                  => [qw(6066 8449)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q(replaced by extension 'record_size_limit'; Default max length is 2^14 if this extension is not negotiated),
    },

client_certificate_url => {
            ID    => 2,
            CH       => [qw(len2 len2 val1 sequence len2 val1 raw)],#TBD Check sequence position
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(-)],
            RFC                  => [qw(6066)],
            DEFAULT                 => [ ],                         # [ [<seqence>], ],
            CHECK                      => q(VALUE),
            COMMENT                       => q(val20 oder len2_val?),
    },

trusted_ca_keys => {
            ID    => 3,
            CH       => [qw(len2 len2 val1 len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(N)],
            RFC                  => [qw(6066)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q(?),
    },
truncated_hmac => {
            ID    => 4,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q[N],
            TLS13             => [qw(N)],
            RFC                  => [qw(6066 IESG_Action_2018-08-16)],
            DEFAULT                 => [],
            CHECK                      => q[VALUE],
            COMMENT                       => q[Shall be empty],
    },
status_request => {
            ID    => 5,
            CH       => [qw(len2 val1 len2 raw len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH CR CT)],
            RFC                  => [qw(6066)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[SH ext_form_val1_len2_val?],
    },
user_mapping => {
            ID    => 6,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(-)],
            RFC                  => [qw(4681)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q(),
    },
client_authz => {
            ID    => 7,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(N),
            TLS13             => [qw(-)],
            RFC                  => [qw(5878)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q(),
    },
server_authz => {
            ID    => 8,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(N),
            TLS13             => [qw(-)],
            RFC                  => [qw(5878)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q(),
    },
cert_type => {
            ID    => 9,
            CH       => [qw(len2 len1 val1List)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(N),
            TLS13             => [qw(-)],
            RFC                  => [qw(6091)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q(Server: val1),
    },
#elliptic_curves  =>                                                             # old name
supported_groups => {
            ID    => 10,
            CH       => [qw(len2 len2 val2List)],
            CH_TEXT  => ["length", "supported groups list length", \%TLS_SUPPORTED_GROUPS],
            RX          => [qw(len2 val2)],
            RX_TEXT     => ["length", \%TLS_SUPPORTED_GROUPS],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH EE)],
            RFC                  => [qw(8422 7919)],
            DEFAULT                 => [
                                         [ #0x0000, # 0x0000 (Unassigned_0)       ## disabled by default
                                            0x0001, # sect163k1
                                            0x0002, # sect163r1
                                            0x0003, # sect163r2
                                            0x0004, # sect193r1
                                            0x0005, # sect193r2
                                            0x0006, # sect233k1
                                            0x0007, # sect233r1
                                            0x0008, # sect239k1
                                            0x0009, # sect283k1
                                            0x000a, # sect283r1
                                            0x000b, # sect409k1
                                            0x000c, # sect409r1
                                            0x000d, # sect571k1
                                            0x000e, # sect571r1
                                            0x000f, # secp160k1
                                            0x0010, # secp160r1
                                            0x0011, # secp160r2
                                            0x0012, # secp192k1
                                            0x0013, # secp192r1
                                            0x0014, # secp224k1
                                            0x0015, # secp224r1
                                            0x0016, # secp256k1
                                            0x0017, # secp256r1     ## => common default curve
                                            0x0018, # secp384r1
                                            0x0019, # secp512r1
                                            0x001a, # brainpoolP256r1
                                            0x001b, # brainpoolP384r1
                                            0x001c, # brainpoolP512r1
                                            0x001d, # ecdh_x25519
                                            0x001e, # ecdh_x448
                                            0x001f, # brainpoolP256r1tls13
                                            0x0020, # brainpoolP384r1tls13
                                            0x0021, # brainpoolP512r1tls13
                                            0x0022, # GC256A        [draft-smyshlyaev-tls12-gost-suites]
                                            0x0023, # GC256B        [draft-smyshlyaev-tls12-gost-suites]
                                            0x0024, # GC256C        [draft-smyshlyaev-tls12-gost-suites]
                                            0x0025, # GC256D        [draft-smyshlyaev-tls12-gost-suites]
                                            0x0026, # GC512A        [draft-smyshlyaev-tls12-gost-suites]
                                            0x0027, # GC512B        [draft-smyshlyaev-tls12-gost-suites]
                                            0x0028, # GC512C        [draft-smyshlyaev-tls12-gost-suites]
                                            0x0029, # curveSM2      [draft-yang-tls-tls13-sm-suites]
                                                    # Finite Field Groups (DHE):
                                            0x0100, # ffdhe2048
                                            0x0101, # ffdhe3072
                                            0x0102, # ffdhe4096
                                            0x0103, # ffdhe6144
                                            0x0104, # ffdhe8192
                                         ],
                                       ],
            CHECK                      => q(VALUE),
            COMMENT                       => q(renamed from "elliptic_curves"),
    },
ec_point_formats => {
            ID    => 11,                            # Hex:      0x000b
            CH       => [qw(len2 len1 val1List)],   # Example:  0x0002 0x01 0x00
            CH_TEXT  => ["length", "ec point formats list length", \%TLS_EC_POINT_FORMATS],
            RX          => [qw(len2 len1 val1List)],
            RX_TEXT     => ["length", "ec point formats list length", \%TLS_EC_POINT_FORMATS],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(-)],
            RFC                  => [qw(8422)],
            DEFAULT                 => [ 
                                         [ 0x00,    # uncompressed,Y,[RFC8422]
                                           0x01,    # ansiX962_compressed_prime,Y,[RFC8422]
                                           0x02,    # ansiX962_compressed_char2,Y,[RFC8422]
                                         ],
                                       ],
            CHECK                      => q(VALUE),
            COMMENT                       => q(),
    },
srp => {
            ID    => 12,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(N),,
            TLS13             => [qw(-)],
            RFC                  => [qw(5054)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q(),
    },
signature_algorithms => {
            ID    => 13,                            # Hex: 0x000d
            CH       => [qw(len2 len2 val2List)],     # Example: 0x0020 0x001E 0x0601 0x0602 0x0603 0x0501 0x0502 0x0503 0x0401 0x0402 0x0403 0x0301 0x0302 0x0303 0x0201 0x0202 0x0203
            CH_TEXT  => ["length", "signature hash algorithms list length", \%TLS_SIGNATURE_SCHEME],
            RX          => [qw(len2 val2)],
            RX_TEXT     => ["length", \%TLS_SIGNATURE_SCHEME],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH CR)],
            RFC                  => [qw(8446)],
            DEFAULT                 => [
                                         [ 0x0201, # rsa_pkcs1_sha1,Y,[RFC8446]
                                           0x0202, # SHA1 DSA,[RFC8446] (Quelle suchen & prüfen!)
                                           0x0203, # ecdsa_sha1,Y,[RFC8446]

                                           0x0301, # SHA224 RSA (Quelle suchen & prüfen!)
                                           0x0302, # SHA224 DSA (Quelle suchen & prüfen!)
                                           0x0303, # SHA224 ECDSA (Quelle suchen & prüfen!)

                                           0x0401, # rsa_pkcs1_sha256,Y,[RFC8446]
                                           0x0402, # SHA256 DSA (Quelle suchen & prüfen!),[RFC8446] (Quelle suchen & prüfen!)
                                           0x0403, # ecdsa_secp256r1_sha256,Y,[RFC8446]
                                           0x0420, # rsa_pkcs1_sha256_legacy,N,[draft-davidben-tls13-pkcs1-00]

                                           0x0501, # rsa_pkcs1_sha384,Y,[RFC8446]
                                           0x0502, # Reserved for backward compatibility,,[RFC8446]
                                           0x0503, # ecdsa_secp384r1_sha384,Y,[RFC8446]

                                           0x0520, # rsa_pkcs1_sha384_legacy,N,[draft-davidben-tls13-pkcs1-00]

                                           0x0601, # rsa_pkcs1_sha512,Y,[RFC8446]
                                           0x0602, # dsa_pkcs1_sha512,Y,[RFC8446]? (Quelle suchen und prüfen!)
                                           0x0603, # ecdsa_secp521r1_sha512,Y,[RFC8446]

                                           0x0620, # rsa_pkcs1_sha512_legacy,N,[draft-davidben-tls13-pkcs1-00]

                                           0x0704, # eccsi_sha256,N,[draft-wang-tls-raw-public-key-with-ibc]
                                           0x0705, # iso_ibs1,N,[draft-wang-tls-raw-public-key-with-ibc]
                                           0x0706, # iso_ibs2,N,[draft-wang-tls-raw-public-key-with-ibc]
                                           0x0707, # iso_chinese_ibs,N,[draft-wang-tls-raw-public-key-with-ibc]
                                           0x0708, # sm2sig_sm3,N,[draft-yang-tls-tls13-sm-suites]
                                           0x0709, # gostr34102012_256a,N,[draft-smyshlyaev-tls13-gost-suites]
                                           0x070A, # gostr34102012_256b,N,[draft-smyshlyaev-tls13-gost-suites]
                                           0x070B, # gostr34102012_256c,N,[draft-smyshlyaev-tls13-gost-suites]
                                           0x070C, # gostr34102012_256d,N,[draft-smyshlyaev-tls13-gost-suites]
                                           0x070D, # gostr34102012_512a,N,[draft-smyshlyaev-tls13-gost-suites]
                                           0x070E, # gostr34102012_512b,N,[draft-smyshlyaev-tls13-gost-suites]
                                           0x070F, # gostr34102012_512c,N,[draft-smyshlyaev-tls13-gost-suites]

                                           0x0804, # rsa_pss_rsae_sha256,Y,[RFC8446]
                                           0x0805, # rsa_pss_rsae_sha384,Y,[RFC8446]
                                           0x0806, # rsa_pss_rsae_sha512,Y,[RFC8446]
                                           0x0807, # ed25519,Y,[RFC8446]
                                           0x0808, # ed448,Y,[RFC8446]
                                           0x0809, # rsa_pss_pss_sha256,Y,[RFC8446]
                                           0x080A, # rsa_pss_pss_sha384,Y,[RFC8446]
                                           0x080B, # rsa_pss_pss_sha512,Y,[RFC8446]

                                           0x081A, # ecdsa_brainpoolP256r1tls13_sha256,N,[RFC8734]
                                           0x081B, # ecdsa_brainpoolP384r1tls13_sha384,N,[RFC8734]
                                           0x081C, # ecdsa_brainpoolP512r1tls13_sha512,N,[RFC8734]
                                         ],
                                       ],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
use_srtp => {
            ID    => 14,
            CH       => [qw(len2 size2 val2List len1 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH EE)],
            RFC                  => [qw(5764)],
            DEFAULT                 => [
                                         [ 0x0001, # SRTPProtectionProfile SRTP_AES128_CM_HMAC_SHA1_80
                                           0x0002, # SRTPProtectionProfile SRTP_AES128_CM_HMAC_SHA1_32
                                           0x0005, # SRTPProtectionProfile SRTP_NULL_HMAC_SHA1_80
                                           0x0006, # SRTPProtectionProfile SRTP_NULL_HMAC_SHA1_32
                                         ]
                                       ],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
heartbeat => {
            ID    => 15,
            CH       => [qw(len2 val1)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH EE)],
            RFC                  => [qw(6520)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q(Syntax prüfen!),
    },
application_layer_protocol_negotiation => {
            ID    => 16,
            CH       => [qw(len2 len2 size1 raw size1 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH EE)],
            RFC                  => [qw(7301)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
status_request_v2 => {
            ID    => 17,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(-)],
            RFC                  => [qw(6961)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
signed_certificate_timestamp => {
            ID    => 18,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(N),
            TLS13             => [qw(CH CR CT)],
            RFC                  => [qw(6962)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
client_certificate_type => {
            ID    => 19,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH EE)],
            RFC                  => [qw(7250)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
server_certificate_type => {
            ID    => 20,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH EE)],
            RFC                  => [qw(7250)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
padding => {
            ID    => 21,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH)],
            RFC                  => [qw(7685)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q(val= 0x00-Bytes),
    },
encrypt_then_mac => {
            ID    => 22,                            # Hex:        0x0016
            CH       => [qw(len2 raw)],               # Example:    0x0000 (no data, only as marker)
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(-)],
            RFC                  => [qw(7366)],
            DEFAULT                 => [], #empty
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
extended_master_secret => {
            ID    => 23,                            # Hex:      0x0017
            CH       => [qw(len2 raw)],               # Example:  0x0000 (no data, only as marker)
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(-)],
            RFC                  => [qw(7627)],
            DEFAULT                 => [], #empty
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
token_binding => {
            ID    => 24,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(-)],
            RFC                  => [qw(8472)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
cached_info => {
            ID    => 25,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(-)],
            RFC                  => [qw(7924)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
tls_lts => {
            ID    => 26,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(N),
            TLS13             => [qw(-)],
            RFC                  => [qw(draft-gutmann-tls-lts)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
compress_certificate => {
            ID    => 27,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH CR)],
            RFC                  => [qw(draft-ietf-tls-certificate-compression)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q(TEMPORARY registered 2018-05-23 extension registered 2019-04-22 expires 2020-05-23),
    },
record_size_limit => {
            ID    => 28,
            CH       => [qw(len2 val2)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH EE)],
            RFC                  => [qw(8449)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
pwd_protect => {
            ID    => 29,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(N),
            TLS13             => [qw(CH)],
            RFC                  => [qw(8492)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
pwd_clear => {
            ID    => 30,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(N),
            TLS13             => [qw(CH)],
            RFC                  => [qw(8492)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
password_salt => {
            ID    => 31,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(N),
            TLS13             => [qw(CH SH HRR)],
            RFC                  => [qw(8492)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
#  32-34    Unassigned
session_ticket => {
            ID    => 35,                            # Hex:      0x0023
#            CH       => [qw(len2 val4 len2 raw)],     # Example:  0x0000 (no data)
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(-)],
            RFC                  => [qw(5077 8447)],
            DEFAULT                 => [], # empty
            CHECK                      => q(VALUE),
            COMMENT                       => q(renamed from "SessionTicket TLS"),
    },

#  36-40    Unassigned
# NOT official:
extended_random => {
            ID    => 40,
            CH        => [qw(len2 len2 raw)],
            RX           => [qw(len2 raw)],
            RECOMMENDED     => q(N!),
            TLS13              => [qw(?)],
            RFC                   => [qw(draft-rescorla-tls-extended-random-02)],
            DEFAULT                  => [],
            CHECK                       => q(VALUE),
            COMMENT                        => q(NSA; March 02, 2009; DO NOT USE!! https://gist.github.com/bonsaiviking/9921180: 0x0028, RSA BSAFE library),
    },
pre_shared_key => {
            ID    => 41,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH SH)],
            RFC                  => [qw(8446)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
early_data    => {
            ID    => 42,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH EE NST)],
            RFC                  => [qw(8446)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
supported_versions    => {
            ID    => 43,                            # Hex:      0x002b
            CH       => [qw(len2 len1 val2List)],     # Example:  0x0003 0x02 0x0304
            CH_TEXT  => ["length", "supported versions list length", \%TLS_PROTOCOL_VERSION],
            RX          => [qw(len2 val2)],
            RX_TEXT     => ["length", \%TLS_PROTOCOL_VERSION],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH SH HRR)],
            RFC                  => [qw(8446)],
            DEFAULT                 => [
                                         [ 0x0304, # TLS 1.3
                                           # 0x0303, # TLS 1.2
                                           # 0x0302, # TLS 1.1
                                           # 0x0301, # TLS 1.0
                                           # 0x0300, # SSL 3
                                         ],
                                       ],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
cookie    => {
            ID    => 44,
            CH       => [qw(len2 raw)],
            RX          => [qw(len2 raw)],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH HRR)],
            RFC                  => [qw(8446)],
            DEFAULT                 => [],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
psk_key_exchange_modes    => {                      # MUST be included if key_share is used
            ID    => 45,                            # Hex:      0x02d
            CH       => [qw(len2 len1 val1List)],   # Example:  0x0002 0x01 0x01
            CH_TEXT     => ["length", "PSK key exchange modes list length", %TLS_PSK_KEY_EXCHANGE_MODE],
            RX          => [qw(len2 val1)],
            RX_TEXT     => ["length", %TLS_PSK_KEY_EXCHANGE_MODE],
            RECOMMENDED    => q(Y),
            TLS13             => [qw(CH)],
            RFC                  => [qw(8446)],
            DEFAULT                 => [ 
                                         [ 0x00,    # psk_ke,Y,[RFC8446]
                                           0x01,    # psk_dhe_ke,Y,[RFC8446]
                                         ],
                                       ],
            CHECK                      => q(VALUE),
            COMMENT                       => q[],
    },
#  46    Unassigned
certificate_authorities    => {
            ID    => 47,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(Y),
            TLS13                => [qw(CH CR)],
            RFC                        => [qw(8446)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q[],
    },
oid_filters    => {
            ID    => 48,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(Y),
            TLS13                => [qw(CR)],
            RFC                        => [qw(8446)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q[],
    },
post_handshake_auth    => {
            ID    => 49,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(Y),
            TLS13                => [qw(CH)],
            RFC                        => [qw(8446)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q[],
    },
signature_algorithms_cert => {
            ID    => 50,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(Y),
            TLS13                => [qw(CH CR)],
            RFC                        => [qw(8446)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q[],
    },
key_share        => {                                               # MUST be the last extension if used
            ID    => 51,                                            # Hex: 0x0033
            CH        => [qw(len2 len2 sequence val2 size2 raw)],   # Example:  0x0026 0x0024 0x001d 0x0020 <raw32>
            CH_TEXT   => ["length", "client key share list length", "key share element", \%TLS_SUPPORTED_GROUPS, "key exchange length", "key exchange"],
            RX            => [qw(len2 val2 size2 raw)],
            RX_TEXT       => ["length", \%TLS_SUPPORTED_GROUPS, "key exchange length", "key exchange"],
            RECOMMENDED        => q(Y),
            TLS13                => [qw(CH SH HRR)],
            RFC                        => [qw(8446)],
            DEFAULT                        => [ 
                                                [                   # 1st sequence element
                                                  0x001d,           # Group x25519
                                                  "\x01\x02\x03\x04\x05\x07\x08\x09\x0A\x0B\x0C\x0D\x0E\x0F\x10\x11\x12\x13\x13\x14\x15\x16\x17\x18\x19\x1A\x1B\x1C\x1D\x1E\x1F\x20", # Key Exchange
                                                ],
                                                [                   # second sequence element
                                                  0x0017,           # Group secp256r1
                                                  "\x21\x22\x23\x24\x25\x27\x28\x29\x2A\x2B\x2C\x2D\x2E\x2F\x30\x31\x32\x33\x33\x34\x35\x36\x37\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x40"
                                                  . "\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\x53\x54\x55\x56\x57\x58\x59\x5A\x5B\x5C\x5D\x5E\x5F\x60\x61", # Key Exchange
                                                ],
                                              ],
            CHECK                            => q(VALUE),
            COMMENT                                => q[],
    },
transparency_info => {
            ID    => 52,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(Y),
            TLS13                => [qw(CH CR CT)],
            RFC                        => [qw(draft-ietf-trans-6962-bis)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q[],
    },
#  53-65279    Unassigned
supports_npn    => {
            ID    => 13172,                         # Hex:      0x3374
#            CH        => [qw(len2 len1 raw len1 raw)],# Example:  0x0000 (no data)
            CH        => [qw(len2 len1 raw)],# Example:  0x0000 (no data)
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(?),
            TLS13                => [qw(?)],
            RFC                        => [qw(draft-agl-tls-nextprotoneg-04)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q[],
    },
# NOT official:
channel_id_old    => {
            ID    => 33031,
            CH        => [qw(len2 val4 val4 val4 val4)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(N),
            TLS13                => [qw(?)],
            RFC                        => [qw(draft-balfanz-tls-channelid-00)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q(channel_id_old=0x754F),
    },
# NOT official:
channel_id    => {
            ID    => 33032,
            CH        => [qw(len2 val4 val4 val4 val4)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(N),
            TLS13                => [qw(?)],
            RFC                        => [qw(draft-balfanz-tls-channelid-01)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q(channel_id=0x7550),
    },
# NOT official:
opaque_prf_input    => {
            ID    => 38183,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(N!),
            TLS13                => [qw(?)],
            RFC                        => [qw(draft-rescorla-tls-opaque-prf-input-00)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q(NSA; December 13, 2006; DO NOT USE!! https://www.openssl.org/news/changelog.html#x44 [29 Mar 2010]: opaque_prf_input=0x9527),
    },
tack    => {
            ID    => 62208,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(?),
            TLS13                => [qw(?)],
            RFC                        => [qw(draft-perrin-tls-tack-02)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q(January 07, 2013, expired July 11, 2013),
    },

#
private_65280    => {
            ID    => 65280,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(?),
            TLS13                => [qw(?)],
            RFC                        => [qw(8446)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q(for private use),
    },
renegotiation_info    => {
            ID    => 65281,                             # Hex: 0xff01
            CH        => [qw(len2 len1 raw)],             # Example: 0x0001 0x00
            CH_TEXT   => ["length", "renegotiated connection data length", "client verify data"],
            RX            => [qw(len2 len1 raw)],
            RX_TEXT       => ["length", "renegotiated connection data length", "server verify data"],
            RECOMMENDED        => q(Y),
            TLS13                => [qw(-)],
            RFC                        => [qw(5746)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q(Default value is empty => len1=0x00 => len2=0x0001),
    },

#65282-65535 Reserved for Private Use
private_65282   => {
            ID    => 65282,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(?),
            TLS13                => [qw(?)],
            RFC                        => [qw(8446)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q(for private use),
    },
private_65283    => {
            ID    => 65283,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(?),
            TLS13                => [qw(?)],
            RFC                        => [qw(8446)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q(for private use),
    },
private_65284    => {
            ID    => 65284,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(?),
            TLS13                => [qw(?)],
            RFC                        => [qw(8446)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q(for private use),
    },
private_65285    => {
            ID    => 65285,
            CH        => [qw(len2 raw)],
            RX            => [qw(len2 raw)],
            RECOMMENDED        => q(?),
            TLS13                => [qw(?)],
            RFC                        => [qw(8446)],
            DEFAULT                        => [],
            CHECK                            => q(VALUE),
            COMMENT                                => q(for private use),
    },
); # %TLS_EXTENSIONS

# Compile a reverse Hash to %TLS_EXTENSIONS by the IDs
our %TLS_ID_TO_EXTENSIONS = (
    #----+-------------------------------------------------------------------------
    # ID        extension_name
    #----+-------------------------------------------------------------------------

 FORMAT => [    "Extension '%s':",                                   ],# define format for printf
);

foreach my $key (keys %TLS_EXTENSIONS) {                        # compile a reverse hash for extension IDs
    $TLS_ID_TO_EXTENSIONS{$TLS_EXTENSIONS{$key}{ID}}[0] = $key; # store it in the fiorstv element of an array for compatibility reasons with hashes above, e.g. %TLS_SUPPORTED_GROUPS
}


my %tls_extensions__text = ( # TODO: this information needs to be added to %tls_extensions above
    'extension' => {            # TLS extensions
        '00000'     => "renegotiation info length",     # 0x0000 ??
        '00001'     => "renegotiation length",          # 0x0001 ??
        '00009'     => "cert type",                     # 0x0009 ??
        '00010'     => "elliptic curves",               # 0x000a length=4
        '00011'     => "EC point formats",              # 0x000b length=2
        '00012'     => "SRP",                           # 0x000c ??
        '00015'     => "heartbeat",                     # 0x000f length=1
        '00035'     => "session ticket",                # 0x0023 length=0
        '13172'     => "next protocol",     # aka NPN   # 0x3374 length=NNN
        '62208'     => "TACK",                          # 0xf300 ??
        '65281'     => "renegotiation info",            # 0xff01 length=1
    },
); # %tls_extensions__text

our %tls_signature_algorithms = (
    #----------+--------------------+-----------------------
    # ID        name                 comment
    #----------+--------------------+-----------------------
                                    # Legacy algorithms
    0x0201  => "rsa_pkcs1_sha1",
    0x0203  => "ecdsa_sha1",
                                    # RSASSA-PKCS1-v1_5 algorithms
    0x0401  => "rsa_pkcs1_sha256",
    0x0501  => "rsa_pkcs1_sha384",
    0x0601  => "rsa_pkcs1_sha512",
                                    # ECDSA algorithms
    0x0403  => "ecdsa_secp256r1_sha256",
    0x0503  => "ecdsa_secp384r1_sha384",
    0x0603  => "ecdsa_secp521r1_sha512",
                                    # RSASSA-PSS algorithms with public key OID rsaEncryption
    0x0804  => "rsa_pss_rsae_sha256",
    0x0805  => "rsa_pss_rsae_sha384",
    0x0806  => "rsa_pss_rsae_sha512",
                                    # EdDSA algorithms
    0x0807  => "ed25519",
    0x0808  => "ed448",
                                    # RSASSA-PSS algorithms with public key OID RSASSA-PSS
    0x0809  => "rsa_pss_pss_sha256",
    0x080a  => "rsa_pss_pss_sha384",
    0x080b  => "rsa_pss_pss_sha512",
                                    # Reserved Code Points
    #0x0000..0x0200 => "obsolete_RESERVED",
    0x0202  => "dsa_sha1_RESERVED",
    #0x0204..0x0400 => "obsolete_RESERVED",
    0x0402  => "dsa_sha256_RESERVED",
    #0x0404..0x0500 => "obsolete_RESERVED",
    0x0502  => "dsa_sha384_RESERVED",
    #0x0504..0x0600 => "obsolete_RESERVED",
    0x0602  => "dsa_sha512_RESERVED",
    #0x0604..0x06FF => "obsolete_RESERVED",
    #0xFE00..0xFFFF => "private_use",
    0xFFFF  => "private_use",
    #----------+--------------------+-----------------------
); # %tls_signature_algorithms

our %tls_supported_groups = (   # RFC 8446
    #----------+--------------------+-----------------------
    # ID        name                 comment
    #----------+--------------------+-----------------------
    0x0001  => "obsolete_RESERVED", # 0x0001..0x0016 => "obsolete_RESERVED",
    0x0017  => "secp256r1",         # Elliptic Curve Groups (ECDHE)
    0x0018  => "secp384r1",         # 
    0x0019  => "secp521r1",         # 
    0x001A  => "obsolete_RESERVED", #0x001A..0x001C => "obsolete_RESERVED",
    0x001D  => "x25519",            #
    0x001E  => "x448",              #
    0x0100  => "ffdhe2048",         # Finite Field Groups (DHE)
    0x0101  => "ffdhe3072",         # 
    0x0102  => "ffdhe4096",         # 
    0x0103  => "ffdhe6144",         # 
    0x0104  => "ffdhe8192",         # 
                                    # Reserved Code Points
    0x01FC  => "ffdhe_private_use", # 0x01FC..0x01FF => "ffdhe_private_use",
    0xFE00  => "ecdhe_private_use", # 0xFE00..0xFEFF => "ecdhe_private_use",
    0xFF01  => "obsolete_RESERVED_ff01",
    0xFF02  => "obsolete_RESERVED_ff02",
    0xFFFF  => "FFFF",
    #----+--------------------------+-----------------------
); # %tls_supported_groups

our %ec_point_formats = (       # RFC 4492
    # http://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-8
    #--------+-----------------------------+----+---+--------------------------
    # ID          name                      RFC  DTLS other names
    #--------+-----------------------------+----+---+--------------------------
        0 => [qw( uncompressed              4492  Y   )],
        1 => [qw( ansiX962_compressed_prime 4492  Y   )],
        2 => [qw( ansiX962_compressed_char2 4492  Y   )],
      248 => [qw( reserved_248              4492  N   )],
      249 => [qw( reserved_249              4492  N   )],
      250 => [qw( reserved_250              4492  N   )],
      251 => [qw( reserved_251              4492  N   )],
      252 => [qw( reserved_252              4492  N   )],
      253 => [qw( reserved_253              4492  N   )],
      254 => [qw( reserved_254              4492  N   )],
      255 => [qw( reserved_255              4492  N   )],
    #----+-----------------------------+----+---+------------------------------
); # ec_point_formats

# Torsten: %ECCURVE_TYPE
our %ec_curve_types = ( # RFC 4492
    # http://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-8
    #--------+-----------------------------+----+---+--------------------------
    # ID          name                      RFC  DTLS other names
    #--------+-----------------------------+----+---+--------------------------
        0 => [qw( unassigned                4492  N   )],
        1 => [qw( explicit_prime            4492  Y   )],
        2 => [qw( explicit_char2            4492  Y   )],
        3 => [qw( named_curve               4492  Y   )],
      248 => [qw( reserved_248              4492  N   )],
      249 => [qw( reserved_249              4492  N   )],
      250 => [qw( reserved_250              4492  N   )],
      251 => [qw( reserved_251              4492  N   )],
      252 => [qw( reserved_252              4492  N   )],
      253 => [qw( reserved_253              4492  N   )],
      254 => [qw( reserved_254              4492  N   )],
      255 => [qw( reserved_255              4492  N   )],
    #--------+-----------------------------+----+---+--------------------------
); # ec_curve_types

# EX: incl. OIDs:
our %tls_curves = (
    #----+-------------------------------------+----+--+-------+---+-------------------------
    # ID      name                              RFC DTLS NIST  bits OID
    #----+-------------------------------------+----+--+-------+---+------------------------
    0 => [qw( unassigned                        IANA  -      -    0                      )],
    1 => [qw( sect163k1                         4492  Y  K-163  163 1.3.132.0.1          )],
    2 => [qw( sect163r1                         4492  Y      -  163 1.3.132.0.2          )],
    3 => [qw( sect163r2                         4492  Y  B-163  163 1.3.132.0.15         )],
    4 => [qw( sect193r1                         4492  Y      -  193 1.3.132.0.24         )],
    5 => [qw( sect193r2                         4492  Y      -  193 1.3.132.0.25         )],
    6 => [qw( sect233k1                         4492  Y  K-233  233 1.3.132.0.26         )],
    7 => [qw( sect233r1                         4492  Y  B-233  233 1.3.132.0.27         )],
    8 => [qw( sect239k1                         4492  Y      -  239 1.3.132.0.3          )],
    9 => [qw( sect283k1                         4492  Y  K-283  283 1.3.132.0.16         )],
   10 => [qw( sect283r1                         4492  Y  B-283  283 1.3.132.0.17         )],
   11 => [qw( sect409k1                         4492  Y  K-409  409 1.3.132.0.36         )],
   12 => [qw( sect409r1                         4492  Y  B-409  409 1.3.132.0.37         )],
   13 => [qw( sect571k1                         4492  Y  K-571  571 1.3.132.0.38         )],
   14 => [qw( sect571r1                         4492  Y  B-571  571 1.3.132.0.39         )],
   15 => [qw( secp160k1                         4492  Y      -  160 1.3.132.0.9          )],
   16 => [qw( secp160r1                         4492  Y      -  160 1.3.132.0.8          )],
   17 => [qw( secp160r2                         4492  Y      -  160 1.3.132.0.30         )],
   18 => [qw( secp192k1                         4492  Y      -  192 1.3.132.0.31         )], # ANSI X9.62 prime192v1, NIST P-192,
   19 => [qw( secp192r1                         4492  Y  P-192  192 1.2.840.10045.3.1.1  )], # ANSI X9.62 prime192v1
   20 => [qw( secp224k1                         4492  Y       - 224 1.3.132.0.32         )],
   21 => [qw( secp224r1                         4492  Y  P-224  224 1.3.132.0.33         )],
   22 => [qw( secp256k1                         4492  Y  P-256  256 1.3.132.0.10         )],
   23 => [qw( secp256r1                         4492  Y  P-256  256 1.2.840.10045.3.1.7  )], # ANSI X9.62 prime256v1
   24 => [qw( secp384r1                         4492  Y  P-384  384 1.3.132.0.34         )],
   25 => [qw( secp521r1                         4492  Y  P-521  521 1.3.132.0.35         )],
   26 => [qw( brainpoolP256r1                   7027  Y      -  256 1.3.36.3.3.2.8.1.1.7 )],
   27 => [qw( brainpoolP384r1                   7027  Y      -  384 1.3.36.3.3.2.8.1.1.11)],
   28 => [qw( brainpoolP512r1                   7027  Y      -  512 1.3.36.3.3.2.8.1.1.13)],
#  28 => [qw( brainpoolP521r1                   7027  Y      -  521 1.3.36.3.3.2.8.1.1.13)], # ACHTUNG: in manchen Beschreibungen dieser falsche String
   29 => [qw( ecdh_x25519                       4492bis Y    -  225                      )], # [draft-ietf-tls-tls][draft-ietf-tls-rfc4492bis])], #TEMPORARY-registered_2016-02-29,_expires 2017-03-01,
   30 => [qw( ecdh_x448                         4492bis Y    -  448                      )], # -"-
#  31 => [qw( eddsa_ed25519                     4492bis Y    -  448 1.3.101.100          )], # Signature curves, see https://tools.ietf.org/html/draft-ietf-tls-tls13-11
#  32 => [qw( eddsa_ed448                       4492bis Y    -  448 1.3.101.101          )], # -"-

  256 => [qw( ffdhe2048                         ietf-tls-negotiated-ff-dhe-10 Y - 2048   )],
  257 => [qw( ffdhe3072                         ietf-tls-negotiated-ff-dhe-10 Y - 3072   )],
  258 => [qw( ffdhe4096                         ietf-tls-negotiated-ff-dhe-10 Y - 4096   )],
  259 => [qw( ffdhe6144                         ietf-tls-negotiated-ff-dhe-10 Y - 6144   )],
  260 => [qw( ffdhe8192                         ietf-tls-negotiated-ff-dhe-10 Y - 8192   )],
65281 => [qw( arbitrary_explicit_prime_curves   4492  Y      -    ?                      )], # 0xFF01
65282 => [qw( arbitrary_explicit_char2_curves   4492  Y      -    ?                      )], # 0xFF02
    #----+-------------------------------------+----+--+-------+---+------------------------
    # following not from IANA
    # ID      name                              RFC DTLS NIST  bits OID
    #----+-------------------------------------+----+--+-------+---+------------------------
42001 => [qw( Curve3617                         ????  N      -   -1                      )],
42002 => [qw( secp112r1                         ????  N      -   -1 1.3.132.0.6          )],
42003 => [qw( secp112r2                         ????  N      -   -1 1.3.132.0.7          )],
42004 => [qw( secp113r1                         ????  N      -   -1 1.3.132.0.4          )],
42005 => [qw( secp113r2                         ????  N      -   -1 1.3.132.0.5          )],
42006 => [qw( secp131r1                         ????  N      -   -1 1.3.132.0.22         )],
42007 => [qw( secp131r2                         ????  N      -   -1 1.3.132.0.23         )],
42008 => [qw( secp128r1                         ????  N      -   -1 1.3.132.0.28         )],
42009 => [qw( secp128r2                         ????  N      -   -1 1.3.132.0.29         )],
42011 => [qw( ed25519                           ????  N Ed25519  -1 1.3.6.1.4.1.11591.15.1)], # PGP
42012 => [qw( brainpoolp160r1                   ????  N      -   -1 1.3.36.3.3.2.8.1.1.1 )],
42013 => [qw( brainpoolp192r1                   ????  N      -   -1 1.3.36.3.3.2.8.1.1.3 )],
42014 => [qw( brainpoolp224r1                   ????  N      -   -1 1.3.36.3.3.2.8.1.1.5 )],
42015 => [qw( brainpoolp320r1                   ????  N      -   -1 1.3.36.3.3.2.8.1.1.9 )],
42016 => [qw( brainpoolp512r1                   ????  N      -   -1 1.3.36.3.3.2.8.1.1.13)], # same as brainpoolP521r1
42020 => [qw( GOST2001-test                     ????  N      -   -1 1.2.643.2.2.35.0     )],
42021 => [qw( GOST2001-CryptoPro-A              ????  N      -   -1 1.2.643.2.2.35.1     )],
42022 => [qw( GOST2001-CryptoPro-B              ????  N      -   -1 1.2.643.2.2.35.2     )],
42023 => [qw( GOST2001-CryptoPro-C              ????  N      -   -1 1.2.643.2.2.35.3     )],
42024 => [qw( GOST2001-CryptoPro-A              ????  N      -   -1                      )], # GOST2001-CryptoPro-XchA
42025 => [qw( GOST2001-CryptoPro-C              ????  N      -   -1                      )], # GOST2001-CryptoPro-XchB
42026 => [qw( GOST2001-CryptoPro-A              ????  N      -   -1 1.2.643.2.2.36.0     )],
42027 => [qw( GOST2001-CryptoPro-C              ????  N      -   -1 1.2.643.2.2.36.1     )],
42031 => [qw( X9.62 prime192v2                  ????  N      -   -1 1.2.840.10045.3.1.2  )],
42032 => [qw( X9.62 prime192v3                  ????  N      -   -1 1.2.840.10045.3.1.3  )],
42033 => [qw( X9.62 prime239v1                  ????  N      -   -1 1.2.840.10045.3.1.4  )],
42034 => [qw( X9.62 prime239v2                  ????  N      -   -1 1.2.840.10045.3.1.5  )],
42035 => [qw( X9.62 prime239v3                  ????  N      -   -1 1.2.840.10045.3.1.6  )],
42041 => [qw( X9.62 c2tnb191v1                  ????  N      -   -1 1.2.840.10045.3.0.5  )],
42042 => [qw( X9.62 c2tnb191v2                  ????  N      -   -1 1.2.840.10045.3.0.6  )],
42043 => [qw( X9.62 c2tnb191v3                  ????  N      -   -1 1.2.840.10045.3.0.7  )],
42044 => [qw( X9.62 c2tnb239v1                  ????  N      -   -1 1.2.840.10045.3.0.11 )],
42045 => [qw( X9.62 c2tnb239v2                  ????  N      -   -1 1.2.840.10045.3.0.12 )],
42046 => [qw( X9.62 c2tnb239v3                  ????  N      -   -1 1.2.840.10045.3.0.13 )],
42047 => [qw( X9.62 c2tnb359v1                  ????  N      -   -1 1.2.840.10045.3.0.18 )],
42048 => [qw( X9.62 c2tnb431r1                  ????  N      -   -1 1.2.840.10045.3.0.20 )],
# fobidden curves
42061 => [qw( X9.62 c2pnb163v1                  ????  N      -   -1 1.2.840.10045.3.0.1  )],
42062 => [qw( X9.62 c2pnb163v2                  ????  N      -   -1 1.2.840.10045.3.0.2  )],
42063 => [qw( X9.62 c2pnb163v3                  ????  N      -   -1 1.2.840.10045.3.0.3  )],
42064 => [qw( X9.62 c2pnb176w1                  ????  N      -   -1 1.2.840.10045.3.0.4  )],
42065 => [qw( X9.62 c2pnb208w1                  ????  N      -   -1 1.2.840.10045.3.0.10 )],
42066 => [qw( X9.62 c2pnb272w1                  ????  N      -   -1 1.2.840.10045.3.0.16 )],
42067 => [qw( X9.62 c2pnb304w1                  ????  N      -   -1 1.2.840.10045.3.0.18 )],
42068 => [qw( X9.62 c2pnb368w1                  ????  N      -   -1 1.2.840.10045.3.0.19 )],
# unknown curves
42101 => [qw( prime192v1                        ????  N      -   92 )], # X9.62/SECG curve over a 192 bit prime field
42101 => [qw( prime192v2                        ????  N      -   92 )], # X9.62 curve over a 192 bit prime field
42101 => [qw( prime192v3                        ????  N      -   92 )], # X9.62 curve over a 192 bit prime field
42101 => [qw( prime239v1                        ????  N      -   39 )], # X9.62 curve over a 239 bit prime field
42101 => [qw( prime239v2                        ????  N      -   39 )], # X9.62 curve over a 239 bit prime field
42101 => [qw( prime239v3                        ????  N      -   39 )], # X9.62 curve over a 239 bit prime field
42101 => [qw( prime256v1                        ????  N      -   56 )], # X9.62/SECG curve over a 256 bit prime field
42101 => [qw( wap-wsg-idm-ecid-wtls1            ????  N      -  113 )], # WTLS curve over a 113 bit binary field
42101 => [qw( wap-wsg-idm-ecid-wtls3            ????  N      -  163 )], # NIST/SECG/WTLS curve over a 163 bit binary field
42101 => [qw( wap-wsg-idm-ecid-wtls4            ????  N      -  112 )], # SECG curve over a 113 bit binary field
42101 => [qw( wap-wsg-idm-ecid-wtls5            ????  N      -  163 )], # X9.62 curve over a 163 bit binary field
42101 => [qw( wap-wsg-idm-ecid-wtls6            ????  N      -  112 )], # SECG/WTLS curve over a 112 bit prime field
42101 => [qw( wap-wsg-idm-ecid-wtls7            ????  N      -  160 )], # SECG/WTLS curve over a 160 bit prime field
42101 => [qw( wap-wsg-idm-ecid-wtls8            ????  N      -  112 )], # WTLS curve over a 112 bit prime field
42101 => [qw( wap-wsg-idm-ecid-wtls9            ????  N      -  160 )], # WTLS curve over a 160 bit prime field
42101 => [qw( wap-wsg-idm-ecid-wtls10           ????  N      -  233 )], # NIST/SECG/WTLS curve over a 233 bit binary field
42101 => [qw( wap-wsg-idm-ecid-wtls11           ????  N      -  233 )], # NIST/SECG/WTLS curve over a 233 bit binary field
42101 => [qw( wap-wsg-idm-ecid-wtls12           ????  N      -  224 )], # WTLS curvs over a 224 bit prime field
42101 => [qw( Oakley-EC2N-3                     ????  N      -   55 )], # IPSec/IKE/Oakley curve #3 over a 155 bit binary field.
42101 => [qw( Oakley-EC2N-4                     ????  N      -   85 )], # IPSec/IKE/Oakley curve #4 over a 185 bit binary field
    #----+-------------------------------------+----+--+-------+---+------------------------
# unknown curves
41147 => [qw( Curve1147                         ????  N      -   -1 )], # http://www..wikipedia.org/wiki/Comparison_of_TLS_implementations
41187 => [qw( Curve511157                       ????  N      -   -1 )], # -"- ; aka M511
41417 => [qw( Curve41417                        ????  N      -   -1 )], # -"- ; aka Curve3617
42213 => [qw( Curve2213                         ????  N      -   -1 )], # -"- ; aka M221
42448 => [qw( Curve448                          ????  N      -   -1 )], # -"- ; aka Ed448-Goldilocks, aka ecdh_x448?
42519 => [qw( X25519                            ????  N      -   -1 )], # -"- ; aka ecdh_x25519?
42222 => [qw( E222                              ????  N      -   -1 )], # -"-
42382 => [qw( E382                              ????  N      -   -1 )], # -"-
42383 => [qw( E383                              ????  N      -   -1 )], # -"-
42521 => [qw( E521                              ????  N      -   -1 )], # -"-
42147 => [qw( GOST28147-89                      ????  N      -   -1 )], # -"-
42147 => [qw( GOST-R34.11-94                    ????  N      -   -1 )], # -"-
    #----+-------------------------------------+----+--+-------+---+------------------------
65165 => [qw( CurveCECPQ1                       ????  N      -   -1 )], # -"- ;
# unknown curves
#     => [qw( numsp256d1 )],
#     => [qw( numsp256t1 )],
#     => [qw( Curve25519 )],
); # %tls_curves

################
# FIPS-186-2 FIPS-186-3
#
# Aliases: P-256 -- NIST P-256 -- NIST-P256 -- NIST-256 -- secp256r1 -- prime256v1
#
# order_for_NIST_curves_by_ID = 23, 1, 3, 19, 21, 6, 7, 9, 10, 24, 11, 12, 25, 13, 14
################

our %data_oid   = (     # list of texts for some OIDs
        # TODO: nothing YET IMPLEMENTED except for EV
        # TODO: generate this table using Net::SSLeay functions like:
        #   Net::SSLeay::OBJ_nid2ln(),  Net::SSLeay::OBJ_ln2nid()
        #   Net::SSLeay::OBJ_nid2sn(),  Net::SSLeay::OBJ_sn2nid(),
        #   Net::SSLeay::OBJ_nid2obj(), Net::SSLeay::OBJ_obj2nid(),
        #   Net::SSLeay::OBJ_txt2obj(), Net::SSLeay::OBJ_txt2nid(),
        #   Net::SSLeay::OBJ_obj2txt(),
        # all constants and values are defined in openssl/crypto/objects/obj_dat.h
        #   print "nid ". Net::SSLeay::OBJ_txt2nid("CN"); # --> 13
        #   print "Nam ". Net::SSLeay::OBJ_obj2txt( Net::SSLeay::OBJ_txt2obj("1.3.6.1.5.5.7.3.3"), 0); # --> Code Signing
        #   print "nam ". Net::SSLeay::OBJ_obj2txt( Net::SSLeay::OBJ_txt2obj("CN"), 0); # --> commonName
        #   print "oid ". Net::SSLeay::OBJ_obj2txt( Net::SSLeay::OBJ_txt2obj("CN"), 1); # --> 2.5.4.3
        #   print "OID ". Net::SSLeay::OBJ_obj2txt( Net::SSLeay::OBJ_nid2obj( 13 ), 1); # --> 2.5.4.3
        # we should use NIDs to generate the hash, as all other strings are
        # case sensitive. get NIDs with:
        #   grep NID_ openssl/crypto/objects/objects.h | awk '{print $3}' | sort -n
        # so we can loop from 0..180 (or 300 if checks are possible)
        # see also: http://www.zytrax.com/books/ldap/apa/oid.html
        #
        # wir koennen dann einen Parser fuer OIDs bauen:
        #   loop ueber OID und dabei immer .N vom Ende wegnehmen und Rest mit OBJ_obj2txt() ausgeben
        #   # 1.3.6.1.4 -->  "" . identified-organization . dot . iana . Private
        #   # 2.5.29.32 -->  "" . directory services (X.500) . id-ce . X509v3 Certificate Policies

#   '1.3.6.1'                   => {iso(1) org(3) dod(6) iana(1)}
    '1.3.6.1'                   => {'txt' => "Internet OID"},
#   '1.3.6.1.5.5.7.1'           => {'txt' => "Private Extensions"},
    '1.3.6.1.5.5.7.1.1'         => {'txt' => "Authority Information Access"}, # authorityInfoAccess
    '1.3.6.1.5.5.7.1.12'        => {'txt' => $OSaft::Text::STR{UNDEF}},
    '1.3.6.1.5.5.7.1.14'        => {'txt' => "Proxy Certification Information"},
    '1.3.6.1.5.5.7.1.24'        => {'txt' => "id-pe-tlsfeature"},
    '1.3.6.1.5.5.7.3.1'         => {'txt' => "Server Authentication"},
    '1.3.6.1.5.5.7.3.2'         => {'txt' => "Client Authentication"},
    '1.3.6.1.5.5.7.3.3'         => {'txt' => "Code Signing"},
    '1.3.6.1.5.5.7.3.4'         => {'txt' => "Email Protection"},
    '1.3.6.1.5.5.7.3.5'         => {'txt' => "IPSec end system"},
    '1.3.6.1.5.5.7.3.6'         => {'txt' => "IPSec tunnel"},
    '1.3.6.1.5.5.7.3.7'         => {'txt' => "IPSec user"},
    '1.3.6.1.5.5.7.3.8'         => {'txt' => "Timestamping"},
    '1.3.6.1.5.5.7.48.1'        => {'txt' => "ocsp"},
    '1.3.6.1.5.5.7.48.2'        => {'txt' => "caIssuer"},
    '1.3.6.1.4.1.11129.2.5.1'   => {'txt' => $OSaft::Text::STR{UNDEF}},  # Certificate Policy?
    '1.3.6.1.4.1.14370.1.6'     => {'txt' => $OSaft::Text::STR{UNDEF}},  # Certificate Policy?
    '1.3.6.1.4.1.311.10.3.3'    => {'txt' => "Microsoft Server Gated Crypto"},
    '1.3.6.1.4.1.311.10.11'     => {'txt' => "Microsoft Server: EV additional Attributes"},
    '1.3.6.1.4.1.311.10.11.11'  => {'txt' => "Microsoft Server: EV ??friendly name??"},
    '1.3.6.1.4.1.311.10.11.83'  => {'txt' => "Microsoft Server: EV ??root program??"},
    '1.3.6.1.4.1.4146.1.10'     => {'txt' => $OSaft::Text::STR{UNDEF}},  # Certificate Policy?
    '1.3.6.1.5.5.7.8.7'         => {'txt' => "otherName"},
    '2.16.840.1.113730.4.1'     => {'txt' => "Netscape SGC"},
    '1.2.840.113549.1.1.1'      => {'txt' => "SubjectPublicKeyInfo"}, # ???
    '1.2.840.113549.1.1.5'      => {'txt' => "SignatureAlgorithm"},
#   '2.5.29'                    => {'txt' => "Standard Extensions according RFC 5280"},
    # EV: OIDs used in EV Certificates
    '2.5.4.10'                  => {'txt' => "EV Certificate: subject:organizationName"},
    '2.5.4.11'                  => {'txt' => "EV Certificate: subject:organizationalUnitName"},
    '2.5.4.15'                  => {'txt' => "EV Certificate: subject:businessCategory"},
    '2.5.4.3'                   => {'txt' => "EV Certificate: subject:commonName"}, # or SubjectAlternativeName:dNSName
    # EV: Jurisdiction of Incorporation or Registration
    '1.3.6.1.4.1.311.60.2.1.1'  => {'txt' => "EV Certificate: subject:jurisdictionOfIncorporationLocalityName"},
    '1.3.6.1.4.1.311.60.2.1.2'  => {'txt' => "EV Certificate: subject:jurisdictionOfIncorporationStateOrProvinceName"},
    '1.3.6.1.4.1.311.60.2.1.3'  => {'txt' => "EV Certificate: subject:jurisdictionOfIncorporationCountryName"},
    '2.5.4.5'                   => {'txt' => "EV Certificate: subject:serialNumber"},
    # EV: Physical Address of Place of Business
    '2.5.4.6'                   => {'txt' => "EV Certificate: subject:countryName"},
    '2.5.4.7'                   => {'txt' => "EV Certificate: subject:localityName"},
    '2.5.4.8'                   => {'txt' => "EV Certificate: subject:stateOrProvinceName"},
    '2.5.4.9'                   => {'txt' => "EV Certificate: subject:streetAddress"},
    '2.5.4.17'                  => {'txt' => "EV Certificate: subject:postalCode"},
    # EV: Compliance with European Union Qualified Certificates Standard In addition, RFC 3739
    '1.3.6.1.4.1.311.60.2.1'    => {'txt' => "EV Certificate: qcStatements:qcStatement:statementId"},
    # EV: others
    '1.3.6.1.4.1.311.60.1.1'    => {'txt' => "EV Certificate: ??fake root??"},
    '2.5.29.32.0'               => {'txt' => "EV Certificate: subject:anyPolicy"},
    '2.5.29.35'                 => {'txt' => "EV Certificate: subject:authorityKeyIdentifier"}, # Authority key id
    '2.5.29.37'                 => {'txt' => "EV Certificate: subject:extendedKeyUsage"}, # Extended key usage
    '0.9.2342.19200300.100.1.25'=> {'txt' => "EV Certificate: subject:domainComponent"},
    # others
    '2.5.4.4'                   => {'txt' => "subject:surname"},
    '2.5.4.12'                  => {'txt' => "subject:title"},
    '2.5.4.41'                  => {'txt' => "subject:name"},
    '2.5.4.42'                  => {'txt' => "subject:givenName"},
    '2.5.4.43'                  => {'txt' => "subject:intials"},
    '2.5.4.44'                  => {'txt' => "subject:generationQualifier"},
    '2.5.4.46'                  => {'txt' => "subject:dnQualifier"},
    '2.5.29.14'                 => {'txt' => "subject:subjectKeyIdentifier"}, # Subject key id
    '2.5.29.15'                 => {'txt' => "subject:keyUsage"},             # Key usage
    '2.5.29.17'                 => {'txt' => "subject:subjectAlternateName"}, # Subject alternative name
    '2.5.29.19'                 => {'txt' => "subject:basicConstraints"},     # Basic constraints
    '2.5.29.31'                 => {'txt' => "subject:crlDistributionPoints"},# CRL distribution points
    '2.5.29.32'                 => {'txt' => "subject:certificatePolicies"},  # Certificate Policies
    '2.5.29.37'                 => {'txt' => "subject:extendedKeyUsage"},     # Extended key usage
    '2.16.840.1.113733.1.7.23.6'=> {'txt' => $OSaft::Text::STR{UNDEF}},  # Certificate Policy?
    '2.16.840.1.113733.1.7.48.1'=> {'txt' => $OSaft::Text::STR{UNDEF}},  #  ''
    '2.16.840.1.113733.1.7.54'  => {'txt' => $OSaft::Text::STR{UNDEF}},  #  ''
    '0.9.2342.19200300.100.1.3' => {'txt' => "subject:mail"},
    # TODO: see http://oidref.com/
    #'2.16.840.1.114028.10.1.2'  => {'txt' => "Entrust Extended Validation (EV) Certification Practice Statement (CPS)"},
    #'2.16.840.1.114412.1.3.0.2' => {'txt' => "DigiCert Extended Validation (EV) Certification Practice Statement (CPS) v. 1.0.3"},
    #'2.16.840.1.114412.2.1'     => {'txt' => "DigiCert Extended Validation (EV) Certification Practice Statement (CPS) v. 1.0.3"},
    #'2.16.578.1.26.1.3.3'       => {'txt' => ""},
    #'1.3.6.1.4.1.17326.10.14.2.1.2' => {'txt' => "Camerfirma Certification Practice Statement (CPS) v3.2.3"},
    #'1.3.6.1.4.1.17326.10.8.12.1.2' => {'txt' => "Camerfirma Certification Practice Statement (CPS) v3.2.3"},
    #'1.3.6.1.4.1.13177.10.1.3.10'   => {'txt' => "SSL SECURE WEB SERVER CERTIFICATES"},
); # %data_oid

our %cfg = (    # main data structure for configuration
    'mename'        => "O-Saft ", # my name pretty printed
    'need_netdns'   => 0,       # used for better error message handling only
    'need_timelocal'=> 0,       # -"-
    'need_netinfo'  => 1,       # 0: do not load Net::SSLinfo
    # following initialised in _osaft_init()
    'me'            => "",
    'ARG0'          => "",
    'ARGV'          => [],      # arguments passed on command-line
    'RC-ARGV'       => [],      # arguments read from RC-FILE (set in caller)
    'RC-FILE'       => "",      # our RC-FILE, search in pwd only!
    # following should be in %text, but as %cfg is available everywhere,
    # it's better defined here and initialised in _osaft_init()
    'prefix_trace'  => "",      # prefix string used in trace   messages
    'prefix_verbose'=> "",      # prefix string used in verbose messages

   # config. key        default   description
   #------------------+---------+----------------------------------------------
    'try'           => 0,       # 1: do not execute openssl, just show
    'exec'          => 0,       # 1: if +exec command used
    'trace'         => 0,       # 1: trace yeast, 2=trace Net::SSLeay and Net::SSLinfo also
    'traceME'       => 0,       # 1: trace yeast only, but no modules
                                # -1: trace modules only, but not yeast
    'time0'         => 0,       # current time, must be set in main
    'linux_debug'   => 0,       # passed to Net::SSLeay::linux_debug
    'verbose'       => 0,       # used for --v
    'v_cipher'      => 0,       # used for --v-cipher
    'proxyhost'     => "",      # FQDN or IP of proxy to be used
    'proxyport'     => 0,       # port for proxy
    'proxyauth'     => "",      # authentication string used for proxy
    'proxyuser'     => "",      # username for proxy authentication (Basic or Digest Auth)
    'proxypass'     => "",      # password for proxy authentication (Basic or Digest Auth)
    'starttls'      => "",      # use STARTTLS if not empty
                                # protocol to be used with STARTTLS; default: SMTP
                                # valid protocols: SMTP, IMAP, IMAP2, POP3, FTPS, LDAP, RDP, XMPP
    'starttls_delay'=> 0,       # STARTTLS: time to wait in seconds (to slow down the requests)
    'starttls_phase'=> [],      # STARTTLS: Array for customised STARTTLS sequences
    'starttls_error'=> [],      # STARTTLS: Array for customised STARTTLS sequences error handling
    'slow_server_delay' => 0,   # time to wait in seconds after a connection via proxy or before starting STARTTLS sequence
    'connect_delay' => 0,       # time to wait in seconds for starting next cipher check
    'socket_reuse'  => 1,       # 0: close and reopen sockets when SSL connect fails
                                # 1: reuse existing sockets, even if SSL connect failed
    'ignore_no_conn'=> 0,       # 1: ignore warnings if connection fails, check target anyway
    'protos_next'   =>          # all names known for ALPN or NPN
                       'http/1.1,h2c,h2c-14,spdy/1,npn-spdy/2,spdy/2,spdy/3,spdy/3.1,spdy/4a2,spdy/4a4,grpc-exp,h2-14,h2-15,http/2.0,h2',
                                # even Net::SSLeay functions most likely use an
                                # array,  this is a string with comma-separated
                                # names as used by openssl
                                # NOTE: must not contain any white spaces!
    'protos_alpn'   => [],      # initially same as cfg{protos_next}, see _cfg_init()
    'protos_npn'    => [],      # "-"
    'slowly'        => 0,       # passed to Net::SSLeay::slowly
    'usesni'        => 1,       # use SNI extensionn by default (for TLSv1 and above)
    'sni_name'      => undef,   # if set, name to be used for connection with SNI
                                # must be set to $host if undef and 'use_sni_name'=1 (see below)
                                # all other strings are used verbatim, even empty one
    'use_sni_name'  => 0,       # 0: use hostname; 1: use name provided by --sni-name
                                # used by Net::SSLhello only
    'sclient_opt'   => "",      # argument or option passed to openssl s_client command
    'no_cert_txt'   => "",      # change default text if no data from cert retrieved
    'ca_depth'      => undef,   # depth of peer certificate verification verification
    'ca_crl'        => undef,   # URL where to find CRL file
    'ca_file'       => undef,   # PEM format file with CAs
    'ca_path'       => undef,   # path to directory with PEM files for CAs
                                # see Net::SSLinfo why undef as default
    'ca_files'      => [qw(ca-certificates.crt certificates.crt certs.pem cert.pem)],
                                # common PEM filenames for CAs; 1st used as default
                                # cert.pem instead of certs.pem on Android :-(
    'ca_paths'      => [qw(/etc/ssl/certs       /usr/lib/certs           /System/Library/OpenSSL /etc/tls/certs)],
                                # common paths to PEM files for CAs; 1st used as default
    'openssl_cnfs'  => [qw(/etc/ssl/openssl.cnf /usr/lib/ssl/openssl.cnf /System//Library/OpenSSL/openssl.cnf /usr/ssl/openssl.cnf)],
                                # common openssl.cnf files for openssl; 1st used as default
    'openssl_cnf'   => undef,   # full path to openssl's openssl.cnf
    'openssl_env'   => undef,   # environment variable OPENSSL if defined
    'openssl_fips'  => undef,   # NOT YET USED
    'openssl_msg'   => "",      # '-msg': option needed for openssl versions older than 1.0.2 to get the dh_parameter
    'ignorecase'    => 1,       # 1: compare some strings case insensitive
    'ignorenoreply' => 1,       # 1: treat "no reply" as heartbeat not enabled
    'label'         => 'long',  # fomat of labels
    'labels'        => [qw(full long short key)],   # all supported label formats
    'version'       => [],      # contains the versions to be checked
    'versions'      =>          # all supported versions; SEE Note:%prot (in o-saft.pl)
                       # [reverse sort keys %prot], # do not use generic list 'cause we want special order
                       [qw(SSLv2 SSLv3 TLSv1 TLSv11 TLSv12 TLSv13 DTLSv09 DTLSv1 DTLSv11 DTLSv12 DTLSv13)],
    'DTLS_versions' => [qw(DTLSv09 DTLSv1 DTLSv11 DTLSv12 DTLSv13)],
                                # temporary list 'cause DTLS not supported by openssl (6/2015)
    'SSLv2'         => 1,       # 1: check this SSL version
    'SSLv3'         => 1,       # 1:   "
    'TLSv1'         => 1,       # 1:   "
    'TLSv11'        => 1,       # 1:   "
    'TLSv12'        => 1,       # 1:   "
    'TLSv13'        => 1,       # 1:   "
                                # NOTE: DTLS currently (6/2015) disabled by default 'cause not supported by openssl
    'DTLSv09'       => 0,       # 1:   "
    'DTLSv1'        => 0,       # 1:   "
    'DTLSv11'       => 0,       # 1:   "
    'DTLSv12'       => 0,       # 1:   "
    'DTLSv13'       => 0,       # 1:   "
    'TLS1FF'        => 0,       # dummy for future use
    'DTLSfamily'    => 0,       # dummy for future use
    'cipher'        => [],      # ciphers we got with --cipher=
    'cipherpattern' => "ALL:NULL:eNULL:aNULL:LOW:EXP", # openssl pattern for all ciphers
                                # should simply be   ALL:COMPLEMENTOFALL,  but
                                # have seen implementations  where it does not
                                # list all compiled-in ciphers, hence the long
                                # list
                                # TODO: must be same as in Net::SSLinfo or used from there
    'cipherpatterns'    => {    # openssl patterns for cipher lists
        # key             description                cipher pattern for openssl
        #----------------+--------------------------+---------------------------
        'null'      => [ "Null Ciphers",            'NULL:eNULL'              ], 
        'anull'     => [ "Anonymous NULL Ciphers",  'aNULL'                   ], 
        'anon'      => [ "Anonymous DH Ciphers",    'ADH'                     ], 
        'adh'       => [ "Anonymous DH Ciphers",    'ADH'                     ], 
        'aes'       => [ "AES Ciphers",             'AES'   ], 
        'aes128'    => [ "AES128 Ciphers",          'AES128'], 
        'aes256'    => [ "AES256 Ciphers",          'AES256'], 
        'aesGCM'    => [ "AESGCM Ciphers",          'AESGCM'], 
        'chacha'    => [ "CHACHA20 Ciphers",        'CHACHA'], # NOTE: not possible with some openssl
        'dhe'       => [ "Ephermeral DH Ciphers",   'EDH'   ], # NOTE: DHE not possible some openssl
        'edh'       => [ "Ephermeral DH Ciphers",   'EDH'                     ], 
        'ecdh'      => [ "Ecliptical curve DH Ciphers",             'ECDH'    ], 
        'ecdsa'     => [ "Ecliptical curve DSA Ciphers",            'ECDSA'   ], 
        'ecdhe'     => [ "Ephermeral ecliptical curve DH Ciphers",  'EECDH'   ], # TODO:  ECDHE not possible with openssl
        'eecdh'     => [ "Ephermeral ecliptical curve DH Ciphers",  'EECDH'   ], 
        'aecdh'     => [ "Anonymous ecliptical curve DH Ciphers",   'AECDH'   ], 
        'exp40'     => [ "40 Bit encryption",       'EXPORT40'                ], 
        'exp56'     => [ "56 Bit export ciphers",   'EXPORT56'                ], 
        'export'    => [ "all Export Ciphers",      'EXPORT'],
        'exp'       => [ "all Export Ciphers",      'EXPORT'], # alias for export
        'des'       => [ "DES Ciphers",             'DES:!ADH:!EXPORT:!aNULL' ], 
        '3des'      => [ "Triple DES Ciphers",      '3DES'  ], # TODO: 3DES:!ADH:!aNULL
        'fips'      => [ "FIPS compliant Ciphers",  'FIPS'  ], # NOTE: not possible with some openssl
        'gost'      => [ "all GOST Ciphers",        'GOST'  ], # NOTE: not possible with some openssl
        'gost89'    => [ "all GOST89 Ciphers",      'GOST89'], # NOTE: not possible with some openssl
        'gost94'    => [ "all GOST94 Ciphers",      'GOST94'], # NOTE: not possible with some openssl
        'idea'      => [ "IDEA Ciphers",            'IDEA'  ], # NOTE: not possible with some openssl
        'krb'       => [ "KRB5 Ciphers",            'KRB5'  ], # alias for krb5
        'krb5'      => [ "KRB5 Ciphers",            'KRB5'  ], 
        'md5'       => [ "Ciphers with MD5 Mac",    'MD5'   ], 
        'psk'       => [ "PSK Ciphers",             'PSK'   ], 
        'rc2'       => [ "RC2 Ciphers",             'RC2'   ], # NOTE: not possible with some openssl
        'rc4'       => [ "RC4 Ciphers",             'RC4'   ], 
        'rsa'       => [ "RSA Ciphers",             'RSA'   ], 
        'seed'      => [ "Seed Ciphers",            'SEED'  ], 
        'sslv2'     => [ "all SSLv2 Ciphers",       'SSLv2' ], # NOTE: not possible with some openssl
        'sslv3'     => [ "all SSLv3 Ciphers",       'SSLv3' ], # NOTE: not possible with some openssl
        'tlsv1'     => [ "all TLSv1 Ciphers",       'TLSv1' ], # NOTE: not possible with some openssl
        'tlsv11'    => [ "all TLSv11 Ciphers",      'TLSv1' ], # alias for tlsv1
        'tlsv12'    => [ "all TLSv12 Ciphers",      'TLSv1.2' ],
        'srp'       => [ "SRP Ciphers",             'SRP'   ], 
        'sha'       => [ "Ciphers with SHA1 Mac",   'SHA'   ], 
        'sha'       => [ "Ciphers with SHA1 Mac",   'SHA'   ], 
        'sha1'      => [ "Ciphers with SHA1 Mac",   'SHA1'  ], # NOTE: not possible with some openssl
        'sha2'      => [ "Ciphers with SHA256 Mac", 'SHA256'],
        'sha256'    => [ "Ciphers with SHA256 Mac", 'SHA256'],
        'sha384'    => [ "Ciphers with SHA384 Mac", 'SHA384'],
        'sha512'    => [ "Ciphers with SHA512 Mac", 'SHA512'], # NOTE: not possible with some openssl
        'weak'      => [ "Weak grade encryption",   'LOW:3DES:DES:RC4:ADH:EXPORT'  ],
#       'low'       => [ "Low grade encryption",    'LOW:!ADH'    ],    # LOW according openssl
        'low'       => [ "Low grade encryption",    'LOW:3DES:RC4:!ADH' ],
        'medium'    => [ "Medium grade encryption", 'MEDIUM:!NULL:!aNULL:!SSLv2:!3DES:!RC4' ], 
        'high'      => [ "High grade encryption",   'HIGH:!NULL:!aNULL:!DES:!3DES' ], 
        #----------------+--------------------------+---------------------------
        # TODO: list with 'key exchange': kRSA, kDHr, kDHd, kDH, kEDH, kECDHr, kECDHe, kECDH, kEECDH
    }, # cipherpatterns
    'ciphermode'    => 'intern',# cipher scan mode, any of 'ciphermodes'
    'ciphermodes'   => [qw(dump intern openssl ssleay)],
                    # modes how to scan for ciphers;
                    # NOTE: commands_int must contain the commands cipher_dump
                    #       cipher_intern, cipher_openssl and cipher_ssleay
    'ciphers'       => [],      # contains all ciphers to be tested # TODO: change from cipher names to keys
    'cipherrange'   => 'intern',# the range to be used from 'cipherranges'
    'cipherranges'  => {        # constants for ciphers (NOTE: written as hex)
                    # Technical (perl) note for definition of these ranges:
                    # Each range is defined as a string like  key=>"2..5, c..f"
                    # instead of an array like  key=>[2..5, c..f]  which would
                    # result in  key=>[2 3 4 5 c d e f] .
                    # This expansion of the range is done at compile time  and
                    # so will consume a huge amount of memory at runtime.
                    # Using a string instead of the expanded array reduces the
                    # memory footprint,  but requires use of  eval()  when the
                    # range is needed:  eval($cfg{cipherranges}->{rfc})
                    # Each string must be syntax for perl's range definition.
        'rfc'       =>          # constants for ciphers defined in various RFCs
                       "0x03000000 .. 0x030000FF, 0x03001300 .. 0x030013FF,
                        0x0300C000 .. 0x0300C1FF, 0x0300CC00 .. 0x0300CCFF,
                        0x0300D000 .. 0x0300D0FF,
                        0x0300FE00 .. 0x0300FFFF,
                       ",
                            # GREASE ciphers added in _cfg_init()
        'shifted'   =>          # constants for ciphers defined in various RFCs shifted with an offset of 64 (=0x40) Bytes
                       "0x03000100 .. 0x0300013F, 0x0300FE00 .. 0x0300FFFF,",
                                # see _cfg_init(): + rfc
        'long'      =>          # more lazy list of constants for cipher
                       "0x03000000 .. 0x030013FF, 0x0300C000 .. 0x0300FFFF,",
        'huge'      =>          # huge range of constants for cipher
                       "0x03000000 .. 0x0300FFFF",
        'safe'      =>          # safe full range of constants for cipher
                                # because some network stack (NIC) will crash for 0x033xxxxx
                       "0x03000000 .. 0x032FFFFF",
        'full'      =>          # full range of constants for cipher
                       "0x03000000 .. 0x03FFFFFF",
# TODO:                 0x03000000,   0x03FFFFFF,   # used as return by microsoft testserver and also by SSL-honeypot (US)
        'SSLv2_base'=>          # constants for ciphers for SSLv2
                       "0x02000000,   0x02010080, 0x02020080, 0x02030080, 0x02040080,
                        0x02050080,   0x02060040, 0x02060140, 0x020700C0, 0x020701C0,
                        0x02FF0800,   0x02FF0810, 0x02FFFFFF,
                       ",
                        # 0x02FF0810,   0x02FF0800, 0x02FFFFFF,   # obsolete SSLv2 ciphers
                        # 0x0300FEE0,   0x0300FEE1, 0x0300FEFE, 0x0300FEFF, # obsolete FIPS ciphers
        'SSLv2_rfc' =>          # additional constants for ciphers for SSLv2
                       "0x03000000 .. 0x03000002, 0x03000007 .. 0x0300002C, 0x030000FF,",
        'SSLv2_rfc+'=>          # additional constants for ciphers for SSLv2 long list
                       "0x03000000 .. 0x0300002F, 0x030000FF,",
        'SSLv2_FIPS'=>          # additional constants for FIPS ciphers (SSLv2 and SSLv3)
                       "0x0300FEE0,   0x0300FEE1, 0x0300FEFE, 0x0300FEFF,",
        'SSLv2'     => "",      # constants for ciphers according RFC for SSLv2
                                # see _cfg_init(): SSLv2_base + SSLv2_rfc + SSLv2_FIPS
                                # see Note(a) above also
# TODO:                 0x02000000,   0x02FFFFFF,   # increment even only
# TODO:                 0x03000000,   0x03FFFFFF,   # increment  odd only
        'SSLv2_long'=> "",      # more lazy list of constants for ciphers for SSLv2
                                # see _cfg_init(): SSLv2_base + SSLv2_rfc+ + SSLv2_FIPS
        'SSLv3'     =>          # constants for SSLv3 ciphers (without SSLv2 ciphers)
                       "0x03000000 .. 0x0300003A, 0x03000041 .. 0x03000046,
                        0x03000060 .. 0x03000066, 0x03000080 .. 0x0300009B,
                        0x0300C000 .. 0x0300C022, 0x0300FEE0 .. 0x0300FEFF,
                        0x0300FF00 .. 0x0300FF03, 0x0300FF80 .. 0x0300FF83, 0x0300FFFF,
                       ",
        'SSLv3_SSLv2' => "",    # SSLv3 and SSLv2 ciphers; initialised in _cfg_init()
                                # see _cfg_init(): SSLv2_base + SSLv2_rfc+ + SSLv3
# TODO: 'SSLv3_old' =>          # constants for SSLv3 ciphers (without SSLv2 ciphers)
# TODO:                "0x03000000 .. 0x0300002F, 0x030000FF",  # old SSLv3 ciphers
        'TLSv10'    => "",      # same as SSLv3
        'TLSv11'    => "",      # same as SSLv3
        'TLSv12'    =>          # constants for TLSv1.2 ciphers
                       "0x0300003B .. 0x03000040, 0x03000067 .. 0x0300006D,
                        0x0300009C .. 0x030000A7, 0x030000BA .. 0x030000C5,
                        0x0300C023 .. 0x0300C032, 0x0300C072 .. 0x0300C079,
                        0x0300CC13 .. 0x0300CC15, 0x0300D000 .. 0x0300D005,
                        0x0300FFFF,
                       ",
        'TLSv13'    =>          # constants for TLSv1.3 ciphers
                       "0x03001301 .. 0x03001305, 0x0300FF85, 0x0300FF87,
                        0x030000C6,   0x030000C7, 0x0300C0B4, 0x0300C0B5,
                       ",
                            # GREASE ciphers added in _cfg_init()
        'GREASE'    =>          # constants for GREASE ciphers
                       "0x03000A0A, 0x03001A1A, 0x03002A2A, 0x03003A3A, 0x03004A4A,
                        0x03005A5A, 0x03006A6A, 0x03007A7A, 0x03008A8A, 0x03009A9A,
                        0x0300AAAA, 0x0300BABA, 0x0300CACA, 0x0300DADA, 0x0300EAEA, 0x0300FAFA,
                       ",
        'c0xx'      => "0x0300C000 .. 0x0300C0FF",  # constants for ciphers using ecc
        'ccxx'      => "0x0300CC00 .. 0x0300CCFF",  # constants for ciphers using ecc
        'ecc'       =>          # constants for ciphers using ecc
                       "0x0300C000 .. 0x0300C0FF, 0x0300CC00 .. 0x0300CCFF,",
        'intern'    => "",      # internal list, computed later ...
                                # see _cfg_init(): shifted
    }, # cipherranges
    'cipher_dh'     => 0,       # 1: +cipher also prints DH parameters (default will be changed in future)
    'cipher_md5'    => 1,       # 0: +cipher does not use *-MD5 ciphers except for SSLv2
   #{ removed 10/2017 as they are not used
   #'cipher_alpn'   => 1,       # 0: +cipher does not use ALPN
   #'cipher_npn'    => 1,       # 0: +cipher does not use  NPN ($Net::SSLinfo::use_nextprot is for openssl only)
   #}
    'cipher_ecdh'   => 1,       # 0: +cipher does not use TLS curves extension
    'cipher_alpns'  => [],      # contains all protocols to be passed for +cipher checks
    'cipher_npns'   => [],      # contains all protocols to be passed for +cipher checks
    'ciphercurves'  =>          # contains all curves to be passed for +cipher checks
                       [
                        qw(prime192v1 prime256v1),
                        qw(sect163k1 sect163r1 sect193r1           sect233k1 sect233r1),
                        qw(sect283k1 sect283r1 sect409k1 sect409r1 sect571k1 sect571r1),
                        qw(secp160k1 secp160r1 secp160r2 secp192k1 secp224k1 secp224r1),
                        qw(secp256k1 secp384r1 secp521r1),
                        qw(brainpoolP256r1 brainpoolP384r1 brainpoolP512r1),
                                # TODO: list NOT YET complete, see %tls_curves
                                #       adapted to Mosman's openssl 1.0.2dev (5/2017)
                                #qw(ed25519 ecdh_x25519 ecdh_x448),
                                #qw(prime192v2 prime192v3 prime239v1 prime239v2 prime239v3),
                                #qw(sect193r2 secp256r1 ),
                        ],

    # List of all extensions sent by protocol
    'extensions_by_prot' => {   # List all Extensions used by protocol, SSLv2 does not support extensions by design
         'SSLv3'    => [],      # SSLv3 does not support extensions as originally defined, may be back-ported
         'TLSv1'    => [qw(renegotiation_info supported_groups ec_point_formats session_ticket)],
         'TLSv11'   => [qw(renegotiation_info supported_groups ec_point_formats session_ticket)],
         'TLSv12'   => [qw(renegotiation_info supported_groups ec_point_formats signature_algorithms )],
         'TLSv13'   => [qw(supported_versions supported_groups ec_point_formats signature_algorithms
                           session_ticket renegotiation_info encrypt_then_mac
                           extended_master_secret psk_key_exchange_modes key_share
                        )],
    }, # extensions_by_prot

   # following keys for commands, naming scheme:
   #     do         - the list off all commands to be performed
   #     commands_* - internal list for various types of commands
   #     cmd-*      - list for "summary" commands, can be redifined by user
   #     need-*     - list of commands which need a speciphic check
   #
   # TODO: need to unify  cmd-* and need-* and regex->cmd-*;
   #       see also _need_* functions and "construct list for special commands"
   #       in o-saft.pl
   # config. key       list       description
   #------------------+---------+----------------------------------------------
    'do'            => [],      # commands to be performed
    'commands'      => [],      # contains all commands from %data, %checks and commands_int
                                # will be constructed in main, see: construct list for special commands
    'commands_cmd'  => [],      # contains all cmd-* commands from below
    'commands_usr'  => [],      # contains all commands defined by user with
                                # option --cfg-cmd=* ; see _cfg_set()
    'commands_exp'  => [        # experimental commands
                       ],
    'commands_notyet'=>[        # commands and checks NOT YET IMPLEMENTED
                        qw(zlib lzo open_pgp fallback closure sgc scsv time
                           cps_valid cipher_order cipher_weak
                        ),
                       ],
    'commands_int'  => [        # add internal commands
                                # these have no key in %data or %checks
                        qw(
                         cipher cipher_intern cipher_openssl cipher_ssleay
                         cipher_dump   cipher_dh cipher_default
                         bsi check check_sni dump ev exec help info info--v http
                         quick list libversion sigkey sizes s_client version quit
                        ),
                                # internal (debugging) commands
                      # qw(options cert_type),  # will be seen with +info--v only
                                # keys not used as command
                        qw(cn_nosni valid_years valid_months valid_days valid_host)
                       ],
    'commands_hint' => [        # checks which are NOT YET fully implemented
                                # these are mainly all commands for compliance
                                # see also: cmd-bsi
                        qw(rfc_7525 tr_02102+ tr_02102- tr_03116+ tr_03116-)
                       ],
    'cmd-beast'     => [qw(beast)],                 # commands for +beast
    'cmd-crime'     => [qw(crime)],                 # commands for +crime
    'cmd-drown'     => [qw(drown)],                 # commands for +drown
    'cmd-freak'     => [qw(freak)],                 # commands for +freak
    'cmd-lucky13'   => [qw(lucky13)],               # commands for +lucky13
    'cmd-robot'     => [qw(robot)],                 # commands for +robot
    'cmd-sweet32'   => [qw(sweet32)],               # commands for +sweet32
    'cmd-http'      => [],      # commands for +http, computed below
    'cmd-hsts'      => [],      # commands for +hsts, computed below
    'cmd-info'      => [],      # commands for +info, simply anything from %data
    'cmd-info--v'   => [],      # commands for +info --v
    'cmd-check'     => [],      # commands for +check, simply anything from %checks
    'cmd-sizes'     => [],      # commands for +sizes
    'cmd-quick'     => [        # commands for +quick
                        qw(
                         sslversion hassslv2 hassslv3 hastls12
                         cipher_selected cipher_strong cipher_null cipher_adh
                         cipher_exp cipher_cbc cipher_des cipher_rc4 cipher_edh
                         cipher_pfs beast crime drown freak heartbleed logjam
                         lucky13 poodle rc4 robot sloth sweet32
                         fingerprint_hash fp_not_md5 sha2signature pub_encryption
                         pub_enc_known email serial subject dates verify heartbeat
                         expansion compression hostname hsts_sts crl master_secret
                         renegotiation resumption tr_02102+ tr_02102- rfc_7525
                       )],
    'cmd-ev'        => [qw(cn subject altname dv ev ev- ev+ ev_chars)], # commands for +ev
    'cmd-bsi'       => [        # commands for +bsi
                                # see also: commands_hint
                        qw(after dates crl cipher_rc4 renegotiation
                           tr_02102+ tr_02102- tr_03116+ tr_03116-
                       )],
    'cmd-pfs'       => [qw(cipher_pfs cipher_pfsall session_random)],   # commands for +pfs
    'cmd-sni'       => [qw(sni hostname certfqdn)],  # commands for +sni
    'cmd-sni--v'    => [qw(sni cn altname verify_altname verify_hostname hostname wildhost wildcard)],
    'cmd-vulns'     => [        # commands for checking known vulnerabilities
                        qw(
                         beast breach ccs crime drown freak heartbleed logjam
                         lucky13 poodle rc4 robot sloth sweet32 time
                         hassslv2 hassslv3 compression cipher_pfs session_random
                         renegotiation resumption
                       )],
    'cmd-prots'     => [        # commands for checking protocols
                        qw(hassslv2 hassslv3 hastls10 hastls11 hastls12 hastls13 hasalpn hasnpn session_protocol fallback_protocol alpn alpns npns next_protocols https_protocols http_protocols https_svc http_svc)
                       ],
    'cmd-NL'        => [        # commands which need NL when printed
                                # they should be available with +info --v only
                        qw(certificate extensions pem pubkey sigdump text
                         chain chain_verify ocsp_response_data)
                       ],

   # need-* lists used to improve performance and warning messages
    'need-sslv3'    => [        # commands which need SSLv3 protocol
                        qw(check cipher cipher_dh cipher_strong cipher_selected
                         cipher_weak protocols hassslv3 beast freak poodle
                         tr_02102+ tr_02102- tr_03116+ tr_03116- rfc_7525
                       )],
    'need-cipher'   => [        # commands which need +cipher
                        qw(check cipher cipher_dh  cipher_strong cipher_weak
                         cipher_dump cipher_intern cipher_ssleay cipher_openssl
                         cipher_null cipher_adh cipher_cbc cipher_des cipher_edh
                         cipher_exp  cipher_rc4 cipher_pfs cipher_pfsall
                         beast crime time breach drown freak logjam
                         lucky13 poodle rc4 robot sloth sweet32
                         tr_02102+ tr_02102- tr_03116+ tr_03116- rfc_7525
                         hassslv2 hassslv3 hastls10 hastls11 hastls12 hastls13
                       )],
                                # TODO: need simple check for protocols
    'need-default'  => [        # commands which need selected cipher
                        qw(check cipher cipher_default
                         cipher_dump cipher_intern cipher_ssleay cipher_openssl
                         cipher_pfs  cipher_order  cipher_strong cipher_selected),
                        qw(sslv3  tlsv1   tlsv10  tlsv11 tlsv12),
                                # following checks may cause errors because
                                # missing functionality (i.e in openssl) # 10/2015
                        qw(sslv2  tlsv13  dtlsv09 dtlvs1 dtlsv11 dtlsv12 dtlsv13)
                       ],
    'need-checkssl' => [        # commands which need checkssl() # TODO: needs to be verified
                        qw(check beast crime time breach freak
                         cipher_pfs cipher_pfsall cipher_cbc cipher_des
                         cipher_edh cipher_exp cipher_rc4 cipher_selected
                         ev+ ev- tr_02102+ tr_02102- tr_03116+ tr_03116-
                         ocsp_response ocsp_response_status ocsp_stapling
                         ocsp_uri ocsp_valid
                         rfc_7525 rfc_6125_names rfc_2818_names
                       )],
    'need-checkalnp'=> [        # commands which need checkalpn()
                        qw(alpns alpn hasalpn npns npn hasnpn),
                       ],
    'need-checkbleed'   => [ qw(heartbleed) ],
    'need-check_dh' => [        # commands which need check_dh()
                        qw(logjam dh_512 dh_2048 ecdh_256 ecdh_512)
                       ],
    'need-checkdest'=> [        # commands which need checkdest()
                        qw(reversehost ip resumption renegotiation
                         session_protocol session_ticket session_random session_lifetime
                         krb5 psk_hint psk_identity srp heartbeat ocsp_stapling
                         cipher_selected cipher_pfs ccs crime
                       )],
    'need-checkhttp'=> [qw(https_pins)],# commands which need checkhttp(); more will be added in _init
    'need-checkprot'=> [        # commands which need checkprot(), should be same as in 'cmd-prots'
                        qw(
                         sslversion
                         hassslv2 hassslv3 hastls10 hastls11 hastls12 hastls13
                         alpns alpn hasalpn npns npn hasnpn
                         crime drown poodle
                       )],
    'need-checksni' => [        # commands which need checksni()
                        qw(hostname certfqdn cn cn_nosni sni)
                       ],
    'need-checkchr' => [        # commands which always need checking various characters
                        qw(cn subject issuer altname ext_crl ocsp_uri),
                       ],
    'data_hex'      => [        # data values which are in hex values
                                # used in conjunction with --format=hex
                                # not useful in this list: serial extension
                        qw(
                         fingerprint fingerprint_hash fingerprint_md5
                         fingerprint_sha1 fingerprint_sha2
                         sigkey_value pubkey_value modulus
                         master_key session_id session_ticket
                       )],      # fingerprint is special, see _ishexdata()
   #------------------+---------+----------------------------------------------

    'ignore-out'    => [qw(https_body)],# commands (output) to be ignored, SEE Note:ignore-out
   # out->option key           default   description
   #--------------------------+-----+------------------------------------------
    'out' =>    {      # configurations for data to be printed
        'disabled'          => 1,   # 1: print disabled ciphers
        'enabled'           => 1,   # 1: print enabled ciphers
        'header'            => 0,   # 1: print header lines in output
        'hostname'          => 0,   # 1: print hostname (target) as prefix for each line
        'hint_cipher'       => 1,   # 1: print hints for +cipher command
        'hint_check'        => 1,   # 1: print hints for +check commands
        'hint_info'         => 1,   # 1: print hints for +info commands
        'hint'              => 1,   # 1: print hints for +cipher +check +info
        'http_body'         => 0,   # 1: print received HTTP body if explicitly requested
        'traceARG'          => 0,   # 1: (trace) print argument processing
        'traceCMD'          => 0,   # 1: (trace) print command processing
        'traceKEY'          => 0,   # 1: print internal variable names for %data and %checks
        'traceTIME'         => 0,   # 1: (trace) print additional time for benchmarking
        'time_absolut'      => 0,   # 1: (trace) --traceTIME uses absolut timestamps
        'warning'           => 1,   # 1: print warnings
        'score'             => 0,   # 1: print scoring
        'ignore'            => [qw(https_body)],
                                    # commands (output) to be ignored, SEE Note:ignore-out
        'warnings_no_dups'  => [qw(303 304 412)],
                                    # do not print these warnings multiple times
                                    # SEE  Note:warning-no-duplicates
                                    # 410 not added, as it appears once per protocol only
        'warnings_printed'  => [],  # list of unique warning numbers already printed
                                    # SEE  Note:warning-no-duplicates
        'exitcode'          => 0,   # 1: print verbose checks for exit status
        'exitcode_checks'   => 1,   # 0: do not count "no" checks for --exitcode
        'exitcode_cipher'   => 1,   # 0: do not count any ciphers for --exitcode
        'exitcode_medium'   => 1,   # 0: do not count MEDIUM ciphers for --exitcode
        'exitcode_weak'     => 1,   # 0: do not count  WEAK  ciphers for --exitcode
        'exitcode_low'      => 1,   # 0: do not count  LOW   ciphers for --exitcode
        'exitcode_pfs'      => 1,   # 0: do not count ciphers without PFS for --exitcode
        'exitcode_prot'     => 1,   # 0: do not count protocols other than TLSv12 for --exitcode
        'exitcode_sizes'    => 1,   # 0: do not count size checks for --exitcode
        'exitcode_quiet'    => 0,   # 1: do not print "EXIT status" message
    }, # out
   #--------------------------+-----+------------------------------------------

   # use->option key     default  description
   #----------------------+-----+----------------------------------------------
    'use' =>    {      # configurations to use or do some specials
        'mx'            => 0,   # 1: make MX-Record DNS lookup
        'dns'           => 1,   # 1: make DNS reverse lookup
        'http'          => 1,   # 1: make HTTP  request with default (Net::LLeay) settings
                                # 2: make HTTP  request without headers User-Agent and Accept
        'https'         => 1,   # 1: make HTTPS request with default (Net::LLeay) settings
                                # 2: make HTTPS request without headers User-Agent and Accept
        'forcesni'      => 0,   # 1: do not check if SNI seems to be supported by Net::SSLeay
        'sni'           => 1,   # 0: do not make connection in SNI mode
                                # 1: make connection with SNI set (can be empty string)
                                # 3: test with and without SNI mode (used with Net::SSLhello::checkSSLciphers only)
        'lwp'           => 0,   # 1: use perls LWP module for HTTP checks # TODO: NOT YET IMPLEMENTED
        'alpn'          => 1,   # 0: do not use -alpn option for openssl
        'npn'           => 1,   # 0: do not use -nextprotoneg option for openssl
        'reconnect'     => 1,   # 0: do not use -reconnect option for openssl
        'extdebug'      => 1,   # 0: do not use -tlsextdebug option for openssl
        'cert'          => 1,   # 0: do not get data from certificate
        'no_comp'       => 0,   # 0: do not use OP_NO_COMPRESSION for connetion in Net::SSLeay
        'ssl_lazy'      => 0,   # 1: lazy check for available SSL protocol functionality (Net::SSLeay problem)
        'nullssl2'      => 0,   # 1: complain if SSLv2 enabled but no ciphers accepted
        'ssl_error'     => 1,   # 1: stop connecting to target after ssl-error-max failures
        'experimental'  => 0,   # 1: use, print experimental functionality
        'exitcode'      => 0,   # 1: exit with status code if any check is "no"
                                # see also 'out'->'exitcode'
    }, # use
   #----------------------+-----+----------------------------------------------

   # SEE Note:tty
   # following keys used when --tty (or similar) option was used
   # i.g. the code will use the values only   if defined $cfg{'tty'}->{'width'}
   # option key        default    description
   #------------------+---------+----------------------------------------------
    'tty' =>    {      # configuration for tty and behaviour according tty
        'width'     => undef,   # screen width (columns) of the tty
                                # NOTE: the value undef is used to detect if the
                                #       option --tty was used
        'ident'     => 2,       # left ident spaces, used to replace leftmost 8 spaces
        'arrow'     => "↲",     # "continous arrow when line is split
                                # ← 0x2190, ↲ 0x21b2, ⮠ 0x2ba0, ⤶ 0x2936, ⤸ 0x2938, 
                                # NOTE: it's mandatory to have:  "use utf8"
    }, # tty

   # option key        default    description
   #------------------+---------+----------------------------------------------
    'opt-v'         => 0,       # 1 when option -v was given
    'opt-V'         => 0,       # 1 when option -V was given
    'format'        => "",      # empty means some slightly adapted values (no \s\n)
    'formats'       => [qw(csv html json ssv tab xml fullxml raw hex 0x esc)],
                                # not yet used: csv html json ssv tab xml fullxml
    'tmplib'        => "/tmp/yeast-openssl/",   # temp. directory for openssl and its libraries
    'pass_options'  => "",      # options to be passeed thru to other programs
    'mx_domains'    => [],      # list of mx-domain:port to be processed
    'hosts'         => [],      # list of targets (host:port) to be processed
                                # since 18.07.18 used in checkAllCiphers.pl only
    'targets'       => [],      # list of targets (host:port, prot, path, etc.)
                                # to be processed;  anon. list, each element is
                                # array; first element contains defaults (see
                                # @target_defaults below)
    'port'          => undef,   # port for currently scanned target
    'host'          => "",      # currently scanned target
    'ip'            => "",      # currently scanned target's IP (machine readable format)
    'IP'            => "",      # currently scanned target's IP (human readable, doted octet)
    'rhost'         => "",      # currently scanned target's reverse resolved name
    'DNS'           => "",      # currently scanned target's other IPs and names (DNS aliases)
    'timeout'       => 2,       # default timeout in seconds for connections
                                # NOTE: some servers do not connect SSL within
                                #       this time,  this may result in ciphers
                                #       marked as  "not supported"
                                #       it's recommended to set timeout =3  or
                                #       higher, which results in a performance
                                #       bottleneck, obviously
                                #  see 'sslerror' settings and options also

   #----------------+----------------------------------------------------------
    'openssl'  =>   {  # configurations for various openssl functionality
                       # same data structure as Net::SSLinfo's %_OpenSSL_opt
                       # not all values used yet
                       # default value 1 means supported by openssl, will be
                       # structure initialised correctly in _check_openssl()
                       # which uses Net::SSLinfo::s_client_check()
        #------------------+-------+-------------------------------------------
        # key (=option) supported=1  warning message if option is missing
        #------------------+-------+-------------------------------------------
        '-CAfile'           => [ 1, "using -CAfile disabled"        ],
        '-CApath'           => [ 1, "using -CApath disabled"        ],
        '-alpn'             => [ 1, "checks with ALPN disabled"     ],
        '-npn'              => [ 1, "checks with NPN  disabled"     ],
        '-nextprotoneg'     => [ 1, "checks with NPN  disabled"     ], # alias for -npn
        '-reconnect'        => [ 1, "checks with openssl reconnect disabled"],
        '-fallback_scsv'    => [ 1, "checks for TLS_FALLBACK_SCSV wrong"    ],
        '-comp'             => [ 1, "<<NOT YET USED>>"              ],
        '-no_comp'          => [ 1, "<<NOT YET USED>>"              ],
        '-no_tlsext'        => [ 1, "<<NOT YET USED>>"              ],
        '-no_ticket'        => [ 1, "<<NOT YET USED>>"              ],
        '-serverinfo'       => [ 1, "checks without TLS extension disabled" ],
        '-servername'       => [ 1, "checks with TLS extension SNI disabled"],
        '-serverpref'       => [ 1, "<<NOT YET USED>>"              ],
        '-showcerts'        => [ 1, "<<NOT YET USED>>"              ],
        '-curves'           => [ 1, "using -curves disabled"        ],
        '-debug'            => [ 1, "<<NOT YET USED>>"              ],
        '-bugs'             => [ 1, "<<NOT YET USED>>"              ],
        '-key'              => [ 1, "<<NOT YET USED>>"              ],
        '-msg'              => [ 1, "using -msg disabled, DH paramaters missing or wrong"],
        '-nbio'             => [ 1, "<<NOT YET USED>>"              ],
        '-psk'              => [ 1, "PSK  missing or wrong"         ],
        '-psk_identity'     => [ 1, "PSK identity missing or wrong" ],
        '-pause'            => [ 1, "<<NOT YET USED>>"              ],
        '-prexit'           => [ 1, "<<NOT YET USED>>"              ],
        '-proxy'            => [ 1, "<<NOT YET USED>>"              ],
        '-quiet'            => [ 1, "<<NOT YET USED>>"              ],
        '-sigalgs'          => [ 1, "<<NOT YET USED>>"              ],
        '-state'            => [ 1, "<<NOT YET USED>>"              ],
        '-status'           => [ 1, "<<NOT YET USED>>"              ],
        '-strict'           => [ 1, "<<NOT YET USED>>"              ],
        '-nbio_test'        => [ 1, "<<NOT YET USED>>"              ],
        '-tlsextdebug'      => [ 1, "TLS extension missing or wrong"],
        '-client_sigalgs'   => [ 1, "<<NOT YET USED>>"              ],
        '-record_padding'   => [ 1, "<<NOT YET USED>>"              ],
        '-no_renegotiation' => [ 1, "<<NOT YET USED>>"              ],
        '-legacyrenegotiation'      => [ 1, "<<NOT YET USED>>"      ],
        '-legacy_renegotiation'     => [ 1, "<<NOT YET USED>>"      ],
        '-legacy_server_connect'    => [ 1, "<<NOT YET USED>>"      ],
        '-no_legacy_server_connect' => [ 1, "<<NOT YET USED>>"      ],
        #------------------+-------+-------------------------------------------
    }, # openssl
    'openssl_option_map' => {   # map our internal option to openssl option; used our Net:SSL*
        # will be initialised from %prot
     },
    'openssl_version_map' => {  # map our internal option to openssl version (hex value); used our Net:SSL*
        # will be initialised from %prot
     },

   # ssleay->option      default  description
   #----------------------+-----+----------------------------------------------
    'ssleay'   =>   {  # configurations for various Net::SSLeay functionality
                                # 1: if available is default (see _check_functions())
        'openssl'       => 1,   # OPENSSL_VERSION_NUMBER()
        'get_alpn'      => 1,   # P_alpn_selected available()
        'get_npn'       => 1,   # P_next_proto_negotiated()
        'set_alpn'      => 1,   # CTX_set_alpn_protos()
        'set_npn'       => 1,   # CTX_set_next_proto_select_cb()
        'can_npn'       => 1,   # same as get_npn, just an alias
        'can_ecdh'      => 1,   # can_ecdh()
        'can_sni'       => 1,   # for openssl version > 0x01000000
        'can_ocsp'      => 1,   # OCSP_cert2ids
        'iosocket'      => 1,   # $IO::Socket::SSL::VERSION # TODO: wrong container
    },
    # 'ssl_error'               # see 'use' above
    'sslerror' =>   {  # configurations for TCP SSL protocol
        'timeout'       => 1,   # timeout to receive ssl-answer
        'max'           => 5,   # max. consecutive errors
        'total'         => 10,  # max. overall errors
                                # following are NOT YET fully implemented:
        'delay'         => 0,   # if > 0 continue trying to connect after this time
        'per_prot'      => 1,   # if > 0 detection and count are per SSL version
        'ignore_no_conn' => 0,  # 0: ignore warnings if connection fails, check target anyway
                                # 1: print  warnings if connection fails, don't check target
        'ignore_handshake' => 1,# 1: treat "failed handshake" as error,   don't check target
    }, # ssl_error
    'sslhello' =>   {  # configurations for TCP SSL protocol (mainly used in Net::SSLhello)
        'timeout'       => 2,   # timeout to receive ssl-answer
        'retry'         => 2,   # number of retry when timeout
        'maxciphers'    => 32,  # number of ciphers sent in SSL3/TLS Client-Hello
        'usesignaturealg' => 1, # 1: use extension "signature algorithm"
        'useecc'        => 1,   # 1: use supported elliptic curves
        'useecpoint'    => 1,   # 1: use ec_point_formats extension
        'usereneg'      => 0,   # 1: secure renegotiation
        'double_reneg'  => 0,   # 0: do not send reneg_info extension if the cipher_spec already includes SCSV
                                #    "TLS_EMPTY_RENEGOTIATION_INFO_SCSV" {0x00, 0xFF}
        'nodatanocipher'=> 1,   # 1: do not abort testing next cipher for some TLS intolerant Servers 'NoData or Timeout Equals to No Cipher'
    },
   #----------------------+-----+----------------------------------------------
    'legacy'            => "simple",
    'legacys'           => [    # list of known values
                            qw(cnark sslaudit sslcipher ssldiagnos sslscan dump
                            ssltest ssltest-g sslyze testsslserver thcsslcheck
                            openssl simple full compact quick owasp osaft o-saft)
                           ],
                           # SSLAudit, THCSSLCheck, TestSSLServer are converted using lc()
                           # osaft o-saft are used for comfort
    'usr_args'          => [],  # list of all arguments --usr* (to be used in o-saft-usr.pm)
   #------------------+---------+----------------------------------------------
    'data'  => {       # data provided (mainly used for testing and debugging)
        'file_sclient'  => "",  # file containing data from "openssl s_client "
        'file_ciphers'  => "",  # file containing data from "openssl ciphers"
        'file_pem'      => "",  # file containing certificate(s) in PEM format
        'file_pcap'     => "",  # file containing data in PCAP format
                                # i.e. "openssl s_client -showcerts ..."
    }, # data
   #------------------+---------+----------------------------------------------

   # regex->type           RegEx
   #----------------------+----------------------------------------------------
    'regex' => {
        # RegEx for matching commands and options
        'cmd-http'      => '^h?(?:ttps?|sts)_', # match keys for HTTP
        'cmd-hsts'      => '^h?sts',            # match keys for (H)STS
        'cmd-sizes'     => '^(?:cnt|len)_',     # match keys for length, sizes etc.
        'cmd-cfg'       => '(?:cmd|checks?|data|info|hint|text|scores?)',# --cfg-* commands
        'commands_int'  => '^(?:cn_nosni|valid_(?:year|month|day|host)s?)', # internal data only, no command
        'opt_empty'     => '(?:[+]|--)(?:cmd|help|host|port|format|legacy|timeout|trace|openssl|(?:cipher|proxy|sep|starttls|exe|lib|ca-|cfg-|ssl-|usr-).*)',
                           # these options may have no value
                           # i.e.  --cmd=   ; this may occour in CGI mode
        'std_format'    => '^(?:unix|raw|crlf|utf8|win32|perlio)$', # match keys for --std-format

        # RegEx for matching strings to anonymise in output 
        'anon_output'   => '',  # pattern for strings to be anonymised in output
                           # SEE Note:anon-out

        # RegEx for matching SSL protocol keys in %data and %checks
        'SSLprot'       => '^(SSL|D?TLS)v[0-9]',    # match keys SSLv2, TLSv1, ...

        # RegEx for matching SSL cipher-suite names
        # First some basic RegEx used later on, either in following RegEx or
        # as $cfg{'regex'}->{...}  itself.
        '_or-'          => '[\+_-]',
                           # tools use _ or - as separator character; + used in openssl
        'ADHorDHA'      => '(?:A(?:NON[_-])?DH|DH(?:A|[_-]ANON))[_-]',
                           # Anonymous DH has various acronyms:
                           #     ADH, ANON_DH, DHA, DH-ANON, DH_Anon, ...
                           # TODO:missing: AECDH
        'RC4orARC4'     => '(?:ARC(?:4|FOUR)|RC4)',
                           # RC4 has other names due to copyright problems:
                           #     ARC4, ARCFOUR, RC4
        '3DESorCBC3'    => '(?:3DES(?:[_-]EDE)[_-]CBC|DES[_-]CBC3)',
                           # Tripple DES is used as 3DES-CBC, 3DES-EDE-CBC, or DES-CBC3
        'DESor3DES'     => '(?:[_-]3DES|DES[_-]_192)',
                           # Tripple DES is used as 3DES or DES_192
        'DHEorEDH'      => '(?:DHE|EDH)[_-]',
                           # DHE and EDH are 2 acronyms for the same thing
        'EC-DSA'        => 'EC(?:DHE|EDH)[_-]ECDSA',
        'EC-RSA'        => 'EC(?:DHE|EDH)[_-]RSA',
                           # ECDHE-RSA or ECDHE-ECDSA
        'EC'            => 'EC(?:DHE|EDH)[_-]',
        'EXPORT'        => 'EXP(?:ORT)?(?:40|56|1024)?[_-]',
                           # EXP, EXPORT, EXPORT40, EXP1024, EXPORT1024, ...
        'FRZorFZA'      => '(?:FORTEZZA|FRZ|FZA)[_-]',
                           # FORTEZZA has abbreviations FZA and FRZ
                           # unsure about FORTEZZA_KEA
        'SHA2'          => 'sha(?:2|224|256|384|512)',
                           # any SHA2, just sha2 is too lazy
        'AES-GCM'       => 'AES(?:128|256)[_-]GCM[_-]SHA(?:256|384|512)',
                           # any AES128-GCM or AES256-GCM
        'SSLorTLS'      => '^(?:SSL[23]?|TLS[12]?|PCT1?)[_-]',
                           # Numerous protocol prefixes are in use:
                           #     PTC, PCT1, SSL, SSL2, SSL3, TLS, TLS1, TLS2,
        'aliases'       => '(?:(?:DHE|DH[_-]ANON|DSS|RAS|STANDARD)[_-]|EXPORT_NONE?[_-]?XPORT|STRONG|UNENCRYPTED)',
                           # various variants for aliases to select cipher groups

        # RegEx for matching various strings
        'compression'   =>'(?:DEFLATE|LZO)',    # if compression available
        'nocompression' =>'(?:NONE|NULL|^\s*$)',# if no compression available
        'encryption'    =>'(?:encryption|ecPublicKey)', # anything containing this string
        'encryption_ok' =>'(?:(?:(?:(?:md[245]|ripemd160|sha(?:1|224|256|384|512))with)?[rd]saencryption)|id-ecPublicKey)',
                           # well known strings to identify signature and public
                           # key encryption:
                           # rsaencryption, dsaencryption, md[245]withrsaencryption,
                           # ripemd160withrsa shaXXXwithrsaencryption
                           # id-ecPublicKey
        'encryption_no' =>'(?:rsa(?:ssapss)?|sha1withrsa|dsawithsha1?|dsa_with_sha256)',
                           # rsa, rsassapss, sha1withrsa, dsawithsha*, dsa_with_sha256
        'security'      => '(?:HIGH|MEDIUM|LOW|WEAK|NONE)',
                           # well known "security" strings, should be used case-insensitive
        'isIP'          => '(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)',
        'isDNS'         => '(?:[a-z0-9.-]+)',
        'isIDN'         => '(?:xn--)',
        'leftwild'      => '^\*(?:[a-z0-9.-]+)',
        'doublewild'    => '(?:[a-z0-9.-]+\*[a-z0-9-]+\*)', # x*x or x*.x*
        'invalidwild'   => '(?:\.\*\.)',            # no .*.
        'invalidIDN'    => '(?:xn--[a-z0-9-]*\*)',  # no * right of xn--
        'isSPDY3'       => '(?:spdy\/3)',           # match in protocols (NPN)
                           # TODO: lazy match as it matches spdy/3.1 also

        # TODO: replace following RegEx by concrete list of constants
        # RegEx matching OWASP TLS Cipher String Cheat Sheet
            # matching list of concrete constants would be more accurate, but
            # that cannot be done with RegEx or ranges, unfortunatelly
        'OWASP_AA'      => '^(TLS(?:v?13)?[_-](?:AES|CHACHA20)[_-])',  # newer (2021 and later) openssl use strange names for TLSv1.3
        'OWASP_A'       => '^(?:TLSv1[123]?)?(?:(EC)?(?:DHE|EDH).*?(?:AES...[_-]GCM|CHACHA20-POLY1305)[_-]SHA)',
        'OWASP_B'       => '^(?:TLSv1[123]?)?(?:(EC)?(?:DHE|EDH).*?(?:AES|CHACHA).*?(?!GCM|POLY1305)[_-]SHA)',
        'OWASP_C'       => '^((?:TLSv1[123]?)?.*?(?:AES...|RSA)[_-]|(?:(?:EC)?DHE-)?PSK[_-]CHACHA)',
            # all ECDHE-PSK-CHACHA* DHE-PSK-CHACHA* and PSK-CHACHA* are C too
        'OWASP_D'       => '(?:^SSLv[23]|(?:NULL|EXP(?:ORT)?(?:40|56|1024)|A(?:EC|NON[_-])?DH|DH(?:A|[_-]ANON)|ECDSA|DSS|CBC|DES|MD[456]|RC[24]))',
        'OWASP_NA'      => '(?:ARIA|CAMELLIA|ECDS[AS]|GOST|IDEA|SEED|CECPQ)',
            # PCT are not SSL/TLS; will produce 'miss' in internal tests
        # TODO: need exception, i.e. TLSv1 and TLSv11
        'notOWASP_A    '=> '^(?:TLSv11?)',
        'notOWASP_B'    => '',
        'notOWASP_C'    => '',
        'notOWASP_D'    => '',

        # RegEx containing pattern to identify vulnerable ciphers
            #
            # In a perfect (perl) world we can use negative lokups like
            #     (ABC)(?!XYZ)
            # which means: contains `ABC' but not `XYZ' where `XYZ' could be to
            # the right or left of `ABC'.
            # But in real world,  some perl implementations  fail to match such
            # pattern correctly. Hence we define two pattern:  one for positive
            # match and second for the negative (not) match. Both patterns must
            # be used programatically.
            # Key 'TYPE' must match and key 'notTYPE' must not match.
        # The following RegEx define what is "vulnerable":
            # NOTE: the  (?:SSL[23]?|TLS[12]|PCT1?[_-])  protocol prefix is not
            #       yet used in the checks,  but its optional in the RegEx here
            #       note also that internal strings are like SSLv2, TLSv11, etc
            #       which would not match the protocol prefix in the RegEx here
        'BEAST'     => '^(?:SSL[23]?|TLS[12]|PCT1?[_-])?.*?[_-]CBC',# borrowed from 'Lucky13'. There may be another better RegEx.
#       'BREACH'    => '^(?:SSL[23]?|TLS[12]|PCT1?[_-])?',
        'FREAK'     => '^(?:SSL[23]?)?(?:EXP(?:ORT)?(?:40|56|1024)?[_-])',
                       # EXP? is same as regex{EXPORT} above
        'notCRIME'  => '(?:NONE|NULL|^\s*$)',   # same as nocompression (see above)
#       'TIME'      => '^(?:SSL[23]?|TLS[12]|PCT1?[_-])?',
        'Lucky13'   => '^(?:SSL[23]?|TLS[12]|PCT1?[_-])?.*?[_-]CBC',
        'Logjam'    => 'EXP(?:ORT)?(?:40|56|1024)?[_-]',        # match against cipher
                       # Logjam is same as regex{EXPORT} above
        'POODLE'    => '^(?:SSL[23]?|TLS1)?[A-Z].*?[_-]CBC',    # must not match TLS11, hence [A-Z]
        'ROBOT'     => '^(?:(?:SSLv?3|TLSv?1(?:[12]))[_-])?(?:A?DH[_-])?(RC2|RC4|RSA)[_-]',
        'notROBOT'  => '(?:(?:EC)?DHE[_-])',                    # match against cipher
                       # ROBOT are all TLS_RCA except those with DHE or ECDHE
        'SLOTH'     => '(?:(EXP(?:ORT)?|NULL).*MD5$|EC(?:DHE|EDH)[_-]ECDSA[_-].*(?:MD5|SHA)$)',
        'Sweet32'   => '(?:[_-](?:CBC||CBC3|3DES|DES|192)[_-])',# match against cipher
        'notSweet32'=> '(?:[_-]AES[_-])',                       # match against cipher
        # The following RegEx define what is "not vulnerable":
        'PFS'       => '^(?:(?:SSLv?3|TLSv?1(?:[12])?|PCT1?)[_-])?((?:EC)?DHE|EDH)[_-]',
        'TR-02102'  => '(?:DHE|EDH)[_-](?:PSK[_-])?(?:(?:EC)?[DR]S[AS])[_-]',
                       # ECDHE_ECDSA | ECDHE_RSA | DHE_DSS | DHE_RSA PSK_ECDSS
                       # ECDHE_ECRSA, ECDHE_ECDSS or DHE_DSA does not exist, hence lazy RegEx above
        'notTR-02102'     => '[_-]SHA$',
                       # ciphers with SHA1 hash are not allowed
        'TR-02102-noPFS'  => '(?:EC)?DH)[_-](?:EC)?(?:[DR]S[AS])[_-]',
                       # if PFS not possible, see TR-02102-2_2016 3.3.1
        'TR-03116+' => 'EC(?:DHE|EDH)[_-](?:PSK|(?:EC)?(?:[DR]S[AS]))[_-]AES128[_-](?:GCM[_-])?SHA256',
        'TR-03116-' => 'EC(?:DHE|EDH)[_-](?:PSK|(?:EC)?(?:[DR]S[AS]))[_-]AES(?:128|256)[_-](?:GCM[_-])?SHA(?:256|384)',
                       # in strict mode only:
                       #  ECDHE-ECDSA-AES128.*SHA256 ECDHE-RSA-AES128.*SHA256 RSA-PSK-AES128-SHA256 ECDHE-PSK-AES128-SHA256
                       # in lazy mode (for curiosity) we also allow:
                       #  ECDHE-ECDSA-AES256.*SHA256 ECDHE-RSA-AES256.*SHA256
                       #  ECDHE-ECDSA-AES256.*SHA384 ECDHE-RSA-AES256.*SHA384
        'notTR-03116'     => '(?:PSK[_-]AES256|[_-]SHA$)',
                       # NOTE: for curiosity again, notTR-03116 is for strict mode only
        'RFC7525'   => 'EC(?:DHE|EDH)[_-](?:PSK|(?:EC)?(?:[DR]S[AS]))[_-]AES128[_-](?:GCM[_-])?SHA256',
        '1.3.6.1.5.5.7.1.1'  =>  '(?:1\.3\.6\.1\.5\.5\.7\.1\.1|authorityInfoAccess)',
        'NSA-B'     =>'(?:ECD(?:H|SA).*?AES.*?GCM.*?SHA(?:256|384|512))',

        # RegEx containing pattern for compliance checks
        # The following RegEx define what is "not compliant":
        'notISM'    => '(?:NULL|A(?:NON[_-])?DH|DH(?:A|[_-]ANON)[_-]|(?:^DES|[_-]DES)[_-]CBC[_-]|MD5|RC)',
        'notPCI'    => '(?:NULL|(?:A(?:NON[_-])?DH|DH(?:A|[_-]ANON)|(?:^DES|[_-]DES)[_-]CBC|EXP(?:ORT)?(?:40|56|1024)?)[_-])',
        'notFIPS-140'=>'(?:(?:ARC(?:4|FOUR)|RC4)|MD5|IDEA)',
        'FIPS-140'  => '(?:(?:3DES(?:[_-]EDE)[_-]CBC|DES[_-]CBC3)|AES)', # these are compliant

        # RegEx for checking invalid characers (used in compliance and EV checks)
        'nonprint'  => '/[\x00-\x1f\x7f-\xff]+/',          # not printable;  m/[:^print:]/
        'crnlnull'  => '/[\r\n\t\v\0]+/',                  # CR, NL, TABS and NULL

        # RegEx for checking EV-SSL
        # they should matching:   /key=value/other-key=other-value
        '2.5.4.10'  => '(?:2\.5\.4\.10|organizationName|O)',
        '2.5.4.11'  => '(?:2\.5\.4\.1?|organizationalUnitName|OU)',
        '2.5.4.15'  => '(?:2\.5\.4\.15|businessCategory)',
        '2.5.4.3'   => '(?:2\.5\.4\.3|commonName|CN)',
        '2.5.4.5'   => '(?:2\.5\.4\.5|serialNumber)',
        '2.5.4.6'   => '(?:2\.5\.4\.6|countryName|C)',
        '2.5.4.7'   => '(?:2\.5\.4\.7|localityName|L)',
        '2.5.4.8'   => '(?:2\.5\.4\.8|stateOrProvinceName|SP|ST)', # TODO: is ST a bug?
        '2.5.4.9'   => '(?:2\.5\.4\.9|street(?:Address)?)', # '/street=' is very lazy
        '2.5.4.17'  => '(?:2\.5\.4\.17|postalCode)',
#       '?.?.?.?'   => '(?:?\.?\.?\.?|domainComponent|DC)',
#       '?.?.?.?'   => '(?:?\.?\.?\.?|surname|SN)',
#       '?.?.?.?'   => '(?:?\.?\.?\.?|givenName|GN)',
#       '?.?.?.?'   => '(?:?\.?\.?\.?|pseudonym)',
#       '?.?.?.?'   => '(?:?\.?\.?\.?|initiala)',
#       '?.?.?.?'   => '(?:?\.?\.?\.?|title)',
        '1.3.6.1.4.1.311.60.2.1.1' => '(?:1\.3\.6\.1\.4\.1\.311\.60\.2\.1\.1|jurisdictionOfIncorporationLocalityName)',
        '1.3.6.1.4.1.311.60.2.1.2' => '(?:1\.3\.6\.1\.4\.1\.311\.60\.2\.1\.2|jurisdictionOfIncorporationStateOrProvinceName)',
        '1.3.6.1.4.1.311.60.2.1.3' => '(?:1\.3\.6\.1\.4\.1\.311\.60\.2\.1\.3|jurisdictionOfIncorporationCountryName)',

        'EV-chars'  => '[a-zA-Z0-9,./:= @?+\'()-]',         # valid characters in EV definitions
        'notEV-chars'=>'[^a-zA-Z0-9,./:= @?+\'()-]',        # not valid characters in EV definitions
        'EV-empty'  => '^(?:n\/a|(?:in|not )valid)\s*$',    # empty string, or "invalid" or "not valid"

    }, # regex
   #----------------------+----------------------------------------------------

    'hints' => {       # texts used for hints, SEE Note:hints
       # key for hints must be same as a command (without leading +), otherwise
       # it will not be used automatically.
       # 'key'      => "any string, may contain \t and \n",
       #--------------+--------------------------------------------------------
        'help=warnings' => "consider building the file using: 'make warnings-info'",
        'renegotiation' => "checks only if renegotiation is implemented serverside according RFC 5746 ",
        'drown'     => "checks only if the target server itself is vulnerable to DROWN ",
        'robot'     => "checks only if the target offers ciphers vulnerable to ROBOT ",
        'cipher'    => "+cipher : functionality changed, please see '$cfg__me --help=TECHNIC'",
        'cipherall' => "+cipherall : functionality changed, please see '$cfg__me --help=TECHNIC'",
        'cipherraw' => "+cipherraw : functionality changed, please see '$cfg__me --help=TECHNIC'",
       #--------------+--------------------------------------------------------
    }, # hints
   #------------------+--------------------------------------------------------
    'ourstr' => {
        # RegEx to match strings of our own output, see OUTPUT in o-saft-man.pm
        # first all that match a line at beginning:
        'error'     => qr(^\*\*ERR),            # see STR{ERROR}
        'warning'   => qr(^\*\*WARN),           # see STR{WARN}
        'hint'      => qr(^\!\!Hint),           # see STR{HINT}
        'dbx'       => qr(^#dbx#),              # see STR{DBX}
        'headline'  => qr(^={1,3} ),            # headlines
        'keyline'   => qr(^#\[),                # dataline prefixed with key
        'verbose'   => qr(^#[^[]),              # verbose output
        # matches somewhere in the line:
        'undef'     => qr(\<\<undef),           # see STR{UNDEF}
        'yeast'     => qr(\<\<.*?\>\>),         # additional information
        'na'        => qr(N\/A),                # N/A
        'yes'       => qr(:\s*yes),             # good check result; # TODO: : needs to be $text{separator}
        'no'        => qr(:\s*no ),             # bad check result
    }, # ourstr
   #------------------+--------------------------------------------------------
    'compliance' => {           # description of RegEx above for compliance checks
        'TR-02102'  => "no RC4, only eclipic curve, only SHA256 or SHA384, need CRL and AIA, no wildcards, and verifications ...",
        'TR-03116'  => "TLSv1.2, only ECDSA, RSA or PSK ciphers, only eclipic curve, only SHA224 or SHA256, need OCSP-Stapling CRL and AIA, no wildcards, and verifications ...",
        'ISM'       => "no NULL cipher, no Anonymous Auth, no single DES, no MD5, no RC ciphers",
        'PCI'       => "no NULL cipher, no Anonymous Auth, no single DES, no Export encryption, DH > 1023",
        'FIPS-140'  => "must be TLSv1 or 3DES or AES, no IDEA, no RC4, no MD5",
        'FIPS-140-2'=> "-- NOT YET IMPLEMENTED --",      # TODO:
        'RFC7525'   => "TLS 1.2; AES with GCM; ECDHE and SHA256 or SHA384; HSTS",
        #
        # NIST SP800-52 recommendations for clients (best first):
        #   TLS_DHE_DSS_WITH_AES_256_CBC_SHA
        #   TLS_DHE_RSA_WITH_AES_256_CBC_SHA
        #   TLS_RSA_WITH_AES_256_CBC_SHA
        #   TLS_DH_DSS_WITH_AES_256_CBC_SHA
        #   TLS_DH_RSA_WITH_AES_256_CBC_SHA
        #   TLS_DHE_DSS_WITH_AES_128_CBC_SHA
        #   TLS_DHE_RSA_WITH_AES_128_CBC_SHA
        #   TLS_RSA_WITH_AES_128_CBC_SHA
        #   TLS_DH_DSS_WITH_AES_128_CBC_SHA
        #   TLS_DH_RSA_WITH_AES_128_CBC_SHA
        #   TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA
        #   TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA
        #   TLS_RSA_WITH_3DES_EDE_CBC_SHA
        #   TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA
        #   TLS_DH_RSA_WITH_3DES_EDE_CBC
        #   TLS_RSA_WITH_RC4_128_SHA2
        #
        # NIST SP800-52 recommendations for server (best first):
        #    same as above except TLS_RSA_WITH_RC4_128_SHA2
        #
        # Supported by (most) browsers (see SSL_comp_report2011.pdf):
        #   TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384_P384  (IE8 only)
        #   TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA*
        #   TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA*
        #   TLS_DHE_RSA_WITH_AES_256_CBC_SHA
        #   TLS_DHE_RSA_WITH_AES_128_CBC_SHA
        #   TLS_RSA_WITH_RC4_128_SHA
        #   TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA
        #
        # NIST SP800-57 recommendations for key management (part 1):
        'NSA-B'     => "must be AES with CTR or GCM; ECDSA or ECDH and SHA256 or SHA512",
    },
    'sig_algorithms' => [       # signature algorithms; (2016) not yet used
        qw(
           dsaEncryption dsaEncryption-old dsaWithSHA dsaWithSHA1 dsa_With_SHA256
           ecdsa-with-SHA256
           md2WithRSAEncryption    md4WithRSAEncryption  md5WithRSAEncryption
           None   ripemd160WithRSA rsa  rsaEncryption    rsassapss
           shaWithRSAEncryption    sha1WithRSAEncryption sha1WithRSA
           sha224WithRSAEncryption sha256WithRSAEncryption
           sha384WithRSAEncryption sha512WithRSAEncryption
        ),
           "rsassapss (invalid pss parameters)"
    ],
    'sig_algorithm_common' => [ # most common signature algorithms; (2016) not yet used
        qw(None ecdsa-with-SHA256
           sha1WithRSAEncryption   sha256WithRSAEncryption
           sha384WithRSAEncryption sha512WithRSAEncryption
        )
    ],
   #------------------+-----------------+--------------------------------------
    'files' => {       # list of files used in the tool
        'RC-FILE'   => "",              # computed at startup
        'SELF'      => "o-saft.pl",
        'coding'    => "coding.txt",
        'glossary'  => "glossary.txt",
        'help'      => "help.txt",
        'links'     => "links.txt",
        'rfc'       => "rfc.txt",
        'tools'     => "tools.txt",
        # following are used in o-saft.tcl, but are generate with o-saft-man.pm
        # the keys --help* are used as pattern
        # TODO: hardcoded  docs/  and  o-saft.pl  should be configurable
        '--help'                => "docs/o-saft.pl.--help",
        '--help=alias'          => "docs/o-saft.pl.--help=alias",
        '--help=checks'         => "docs/o-saft.pl.--help=checks",
        '--help=commands'       => "docs/o-saft.pl.--help=commands",
        '--help=data'           => "docs/o-saft.pl.--help=data",
        '--help=glossar'        => "docs/o-saft.pl.--help=glossar",
        '--help=opts'           => "docs/o-saft.pl.--help=opts",
        '--help=regex'          => "docs/o-saft.pl.--help=regex",
        '--help=rfc'            => "docs/o-saft.pl.--help=rfc",
        '--help=warnings'       => "docs/o-saft.pl.--help=warnings",
        '--help=ciphers-text'   => "docs/o-saft.pl.--help=ciphers-text",
    }, # files
   #------------------+-----------------+--------------------------------------
    'done'      => {},          # defined in caller
); # %cfg

our %target_desc = (    # description of table used for printing targets
    #--------------+-----------------------------------------------------------
    # key             description
    #--------------+-----------------------------------------------------------
    'Nr'          , # unique index number, idx=0 used for default settings
    'Protocol'    , # protocol to be checked (schema in URL)
    'Host'        , # hostname or IP passed as argument, IPv6 enclosed in []
    'Port'        , # port as passed as argument or default
    'Auth'        , # authentication string used in URL, if any
    'Proxy'       , # proxy to be used for connection, index to cfg{targets}[]
                    # 0 if no proxy, -1 for a proxy itself
    'Path'        , # path used in URL
    'orig. Argument', # original argument, used for debugging only
    # following are run-time values
    'Time started', # timestamp, connection request started
    'Time opened' , # timestamp, connection request completed
    'Time stopped', # timestamp, connection closed
    'Errors'      , # encountered connection errors
                    # TODO: may be changed to list of errors in future
    #--------------+-----------------------------------------------------------
); # %target_desc

#                       Nr, Prot., Host, Port, Auth, Proxy, Path, orig., run-time ...
our @target_defaults = [ 0, "https", "", "443",  "",  0,    "", "<<defaults>>", 0, 0, 0, 0, ];
   # <<defaults>> just for documentation when printed with --v, --trace, etc.

our %dbx = (    # save hardcoded settings (command lists, texts), and debugging data
                # used in o-saft-dbx.pm only
    'argv'      => undef,       # normal options and arguments
    'cfg'       => undef,       # config options and arguments
    'exe'       => undef,       # executable, library, environment
    'file'      => undef,       # read files
    'cmd-check' => undef,
    'cmd-http'  => undef,
    'cmd-info'  => undef,
    'cmd-quick' => undef,
); # %dbx

#_____________________________________________________________________________
#_________________________________________________________ internal methods __|

# SEE Perl:Undefined subroutine
*_warn    = sub { print(join(" ", "**WARNING:", @_), "\n"); return; } if not defined &_warn;
*_dbx     = sub { print(join(" ", "#dbx#"     , @_), "\n"); return; } if not defined &_dbx;
*_trace   = sub {
     local $\ = undef;
     my $func = shift;  # avoid space after :: below
     print(join(" ", "#$cfg{'me'}::$func", @_), "\n") if (0 < $cfg{'trace'});
     return;
} if not defined &_trace;
*_trace1  = sub { _trace(@_) if (1 < $cfg{'trace'});        return; } if not defined &_trace1;
*_trace2  = sub { _trace(@_) if (2 < $cfg{'trace'});        return; } if not defined &_trace2;
*_trace3  = sub { _trace(@_) if (3 < $cfg{'trace'});        return; } if not defined &_trace3;

#_____________________________________________________________________________
#__________________________________________________________________ methods __|

=pod

=head2 tls_text2key($text)

Convert text to internal key: 0x00,0x26 -> 0x03000026

=head2 tls_key2text($key)

Convert internal key to text: 0x03000026 -> 0x00,0x26

=head2 tls_const2text($constant_name)

Convert TLS constant name to text (just replac _ by space).

=cut

sub tls_text2key        {
    my $txt = shift;
       $txt =~ s/(,|0x)//g;
    if (4 < length($txt)) {
       $txt = "0x02$txt";    # SSLv2
    } else {
       $txt = "0x0300$txt";  # SSLv3, TLSv1.x
    }
    return $txt;
}

sub tls_key2text        {
    my $key = shift;
    if ($key =~ m/^0x0300/) {
       $key =~ s/0x0300//;      #   03000004 ->     0004
    } else {
       $key =~ s/^0x02//;       # 0x02030080 ->   030080
    }
       $key =~ s/(..)/,0x$1/g;  #       0001 -> ,0x00,0x04
       $key =~ s/^,//;          # ,0x00,0x04 ->  0x00,0x04
       $key =  "     $key" if (10 > length($key));
    return "$key";
}

sub tls_const2text      {  my $c=shift; $c =~ s/_/ /g; return $c; }

=pod

=head2 get_ciphers_range($range)

Get cipher suite hex values for given C<$range>.

=head2 get_cipher_owasp($cipher)

Get OWASP rating of given C<%cipher>.

=head2 get_openssl_version($cmd)

Call external $cmd (which is a full path for L<openssl|openssl>, usually) executable
to retrive its version. Returns version string.
=cut

sub get_ciphers_range   {
    #? retrun array of cipher-suite hex values for given range
    my $ssl   = shift;
    my $range = shift;
       $range = 'SSLv2' if ($ssl eq 'SSLv2');   # but SSLv2 needs its own list
    my @all;
    _trace("get_ciphers_range($ssl, $range)");
    #  NOTE: following eval must not use the block form because the value
    #        needs to be evaluated
    foreach my $c (eval($cfg{'cipherranges'}->{$range}) ) { ## no critic qw(BuiltinFunctions::ProhibitStringyEval)
        push(@all, sprintf("0x%08X",$c));
    }
    _trace2("get_ciphers_range()\t= @all");
    return @all;
} # get_ciphers_range

sub get_cipher_owasp    {
    #? return OWASP rating for cipher suite name (see $cfg{regex}->{{OWASP_*}
    my $cipher  = shift;
    my $sec     = "miss";
    return  $sec if not defined $cipher;    # defensive programming (key missing in %ciphers)
    return  $sec if ($cipher =~ m/^\s*$/);  # ..
    # following sequence is important:
    $sec = "-?-" if ($cipher =~ /$cfg{'regex'}->{'OWASP_NA'}/); # unrated in OWASP TLS Cipher Cheat Sheet (2018)
    $sec = "C"   if ($cipher =~ /$cfg{'regex'}->{'OWASP_C'}/);  # 1st legacy
    $sec = "B"   if ($cipher =~ /$cfg{'regex'}->{'OWASP_B'}/);  # 2nd broad compatibility
    $sec = "A"   if ($cipher =~ /$cfg{'regex'}->{'OWASP_A'}/);  # 3rd best practice
    $sec = "D"   if ($cipher =~ /$cfg{'regex'}->{'OWASP_D'}/);  # finally brocken ciphers, overwrite previous
    if (" D" ne $sec) {     # if it is A, B or C check OWASP_NA again
        $sec = "-?-" if ($cipher =~ /$cfg{'regex'}->{'OWASP_NA'}/);
    }
    $sec = "A"   if ($cipher =~ /$cfg{'regex'}->{'OWASP_AA'}/); # some special for TLSv1.3 only, aleways secure
    # TODO: implement when necessary: notOWASP_A, notOWASP_B, notOWASP_C, notOWASP_D
    return $sec;
} # get_cipher_owasp

sub get_openssl_version {
    # we do a simple call, no checks, should work on all platforms
    # get something like: OpenSSL 1.0.1k 8 Jan 2015
    my $cmd  = shift;
    my $data = qx($cmd version);
    chomp $data;
    _trace("get_openssl_version: $data");
    $data =~ s#^.*?(\d+(?:\.\d+)*).*$#$1#; # get version number without letters
    _trace("get_openssl_version()\t= $data");
    return $data;
} # get_openssl_version


=pod

=head2 get_dh_paramter($cipher, $data)

Parse output of `openssl -msg' (given in $data) and returns DH parameters.
Returns empty string if none found.
=cut

sub get_dh_paramter     {
    my ($cipher, $data) = @_;
    if ($data =~ m#Server Temp Key:#) {
        $data =~ s/.*?Server Temp Key:\s*([^\n]*)\n.*/$1/si;
        _trace("get_dh_paramter(){ Server Temp Key\t= $data }");
        return $data;
    }
    # else continue extracting DH parameters from ServerKeyExchange-Message
    my $dh = "";
    # we may get a ServerKeyExchange-Message with the -msg option
    # <<< TLS 1.2 Handshake [length 040f], ServerKeyExchange
    #     0c 00 04 0b 01 00 c1 41 38 da 2e b3 7e 68 71 31
    #     86 da 01 e5 95 fa 7e 83 9b a2 28 1b a5 fb d2 72
    #     ...
    # >>> TLS 1.2 ChangeCipherSpec [length 0001]
    return "" if ($data !~ m#ServerKeyExchange#);

    # this is a long RegEx and cannot be chunked
    ## no critic qw(RegularExpressions::ProhibitComplexRegexes)
    $data =~ s{
            .*?Handshake
            \s*?\[length\s*([0-9a-fA-F]{2,4})\]\,?
            \s*?ServerKeyExchange
            \s*[\n\r]+(.*?)
            [\n\r][<>]+.*
        }
        {$1_$2}xsi;
    ## use critic
    _trace("get_dh_paramter: #{ DHE RAW data:\n$data\n#}\n");
    $data =~ s/\s+/ /gi;          # squeeze multible spaces
    $data =~ s/[^0-9a-f_]//gi;    # remove all none hex characters and non separator
    my ($lenStr, $len) = 0;
    ($lenStr, $data) = split(/_/, $data);   # 2 strings with Hex Octetts!
    _trace3("get_dh_paramter: #{ DHE RAW data): len: $lenStr\n$data\n#}\n");
    $len = hex($lenStr);
    my $message = pack("H*", $data);

    # parse message header
    my $msgData = "";
    my ($msgType, $msgFirstByte, $msgLen) = 0;
       ($msgType,       # C
        $msgFirstByte,  # C
        $msgLen,        # n
        $msgData)   = unpack("C C n a*", $message);

    if (0x0C == $msgType) { # is ServerKeyExchange
        # get info about the session cipher and prepare parameter $keyExchange
        # for parseServerKeyExchange()
        my $keyExchange = $cipher;
        _trace1("get_dh_paramter: cipher: $keyExchange");
        $keyExchange =~ s/^((?:EC)?DHE?)_anon.*/A$1/;   # DHE_anon -> EDH, ECDHE_anon -> AECDH, DHE_anon -> ADHE
        $keyExchange =~ s/^((?:EC)?DH)E.*/E$1/;         # DHE -> EDH, ECDHE -> EECDH
        $keyExchange =~ s/^(?:E|A|EA)((?:EC)?DH).*/$1/; # EDH -> DH, ADH -> DH, EECDH -> ECDH
        _trace1(" get_dh_paramter: keyExchange (DH or ECDH) = $keyExchange");
        # get length of 'dh_parameter' manually from '-msg' data if the
        # 'session cipher' uses a keyExchange with DHE and DH_anon
        # (according RFC 2246/RFC 5246: sections 7.4.3)
        $dh = Net::SSLhello::parseServerKeyExchange($keyExchange, $msgLen, $msgData);
    }

    chomp $dh;
    _trace("get_dh_paramter(){ ServerKeyExchange\t= $dh }");
    return $dh;
} # get_dh_paramter

# TODO: get_target_* and set_target_* should be named get_cfg_target_* ...

=pod

=head2 get_target_nr($idx)

=head2 get_target_prot($idx)

=head2 get_target_host($idx)

=head2 get_target_port($idx)

=head2 get_target_auth($idx)

=head2 get_target_proxy($idx)

=head2 get_target_path($idx)

=head2 get_target_orig($idx)

=head2 get_target_start($idx)

=head2 get_target_open($idx)

=head2 get_target_stop($idx)

=head2 get_target_error($idx)

Get information from internal C<%cfg{'targets'}> data structure.

=head2 set_target_nr($idx, $index)

=head2 set_target_prot($idx, $protocol)

=head2 set_target_host($idx, $host_or_IP)

=head2 set_target_port($idx, $port)

=head2 set_target_auth($idx, $auth-string)

=head2 set_target_proxy($idx, $proxy-index))

=head2 set_target_path($idx $path)

=head2 set_target_orig($idx, $original-argument))

=head2 set_target_start($idx, $start-timestamp)

=head2 set_target_open($idx, $open-timestamp)

=head2 set_target_stop($idx, $end-timestamp)

=head2 set_target_error($idx, $errors)

Set information in internal C<%cfg{'targets'}> data structure.


=cut

sub get_target_nr    { my $i=shift; return $cfg{'targets'}[$i][0];  }
sub get_target_prot  { my $i=shift; return $cfg{'targets'}[$i][1];  }
sub get_target_host  { my $i=shift; return $cfg{'targets'}[$i][2];  }
sub get_target_port  { my $i=shift; return $cfg{'targets'}[$i][3];  }
sub get_target_auth  { my $i=shift; return $cfg{'targets'}[$i][4];  }
sub get_target_proxy { my $i=shift; return $cfg{'targets'}[$i][5];  }
sub get_target_path  { my $i=shift; return $cfg{'targets'}[$i][6];  }
sub get_target_orig  { my $i=shift; return $cfg{'targets'}[$i][7];  }
sub get_target_start { my $i=shift; return $cfg{'targets'}[$i][8];  }
sub get_target_open  { my $i=shift; return $cfg{'targets'}[$i][9];  }
sub get_target_stop  { my $i=shift; return $cfg{'targets'}[$i][10]; }
sub get_target_error { my $i=shift; return $cfg{'targets'}[$i][11]; }
sub set_target_nr    { my $i=shift; $cfg{'targets'}[$i][0]  = shift; return; }
sub set_target_prot  { my $i=shift; $cfg{'targets'}[$i][1]  = shift; return; }
sub set_target_host  { my $i=shift; $cfg{'targets'}[$i][2]  = shift; return; }
sub set_target_port  { my $i=shift; $cfg{'targets'}[$i][3]  = shift; return; }
sub set_target_auth  { my $i=shift; $cfg{'targets'}[$i][4]  = shift; return; }
sub set_target_proxy { my $i=shift; $cfg{'targets'}[$i][5]  = shift; return; }
sub set_target_path  { my $i=shift; $cfg{'targets'}[$i][6]  = shift; return; }
sub set_target_orig  { my $i=shift; $cfg{'targets'}[$i][7]  = shift; return; }
sub set_target_start { my $i=shift; $cfg{'targets'}[$i][8]  = shift; return; }
sub set_target_open  { my $i=shift; $cfg{'targets'}[$i][9]  = shift; return; }
sub set_target_stop  { my $i=shift; $cfg{'targets'}[$i][10] = shift; return; }
sub set_target_error { my $i=shift; $cfg{'targets'}[$i][11] = shift; return; }


=pod

=head2 osaft::osaft_sleep($wait)

Wrapper to simulate "sleep" with perl's select.

=head2 osaft::printhint($cmd,@text)

Print hint for specified command, additionl text will be appended.

=cut

sub osaft_sleep     {
    #? wrapper for IO::select
    my $wait = shift;
    select(undef, undef, undef, $wait); ## no critic qw(BuiltinFunctions::ProhibitSleepViaSelect)
    return;
} # osaft_sleep

sub printhint       {
    #? Print hint for specified command.
    my $cmd  = shift;
    my @args = @_;
    print $OSaft::Text::STR{HINT}, $cfg{'hints'}->{$cmd}, join(" ", @args) if (defined $cfg{'hints'}->{$cmd});
    return;
} # printhint

=pod

=head2 osaft::test_cipher_regex( )

Internal test function: apply regex to intended text/list.

=cut


#_____________________________________________________________________________
#____________________________________________________ internal test methods __|

sub __regex_head    { return sprintf("= %s\t%s\t%s\t%s", "PFS", "OWASP", "owasp", "cipher"); }
sub __regex_line    { return "=------+-------+-------+---------------------------------------"; }

sub test_cipher_regex   {
    #? check regex if cipher supports PFS, uses internal sub and not regex directly
    local $\ = "\n";
    print "
=== internal data structure: various RegEx to check cipher properties ===
=
= Check RegEx to detect ciphers, which support PFS using the internal function
= ::_is_ssl_pfs() .
    \$cfg{'regex'}->{'PFS'}:      # match ciphers supporting PFS
      $cfg{'regex'}->{'PFS'}
=
= Check to which RegEx for OWASP scoring a given cipher matches.
=
    \$cfg{'regex'}->{'OWASP_NA'}: # unrated in OWASP TLS Cipher Cheat Sheet (2018)
      $cfg{'regex'}->{'OWASP_NA'}
    \$cfg{'regex'}->{'OWASP_C'}:  # 1st legacy
      $cfg{'regex'}->{'OWASP_C'}
    \$cfg{'regex'}->{'OWASP_B'}:  # 2nd broad compatibility
      $cfg{'regex'}->{'OWASP_B'}
    \$cfg{'regex'}->{'OWASP_A'}:  # 3rd best practice
      $cfg{'regex'}->{'OWASP_A'}
    \$cfg{'regex'}->{'OWASP_D'}:  # finally brocken ciphers, overwrite previous
      $cfg{'regex'}->{'OWASP_D'}
    \$cfg{'regex'}->{'OWASP_AA'}: # last secure TLSv1.3
      $cfg{'regex'}->{'OWASP_AA'}
=
";
    print __regex_head();
    print __regex_line();
    foreach my $key (sort (OSaft::Ciphers::get_keys_list())) {
        my $ssl    = OSaft::Ciphers::get_ssl( $key);
        my $cipher = OSaft::Ciphers::get_name($key);
        my $is_pfs = (::_is_ssl_pfs($ssl, $cipher) eq "") ? "no" : "yes";
        my @o = ('', '', '', '', '');
        # following sequence of check should be the same as in get_cipher_owasp()
        $o[4] = "-?-" if ($cipher =~ /$cfg{'regex'}->{'OWASP_NA'}/);
        $o[2] = "C"   if ($cipher =~ /$cfg{'regex'}->{'OWASP_C'}/);
        $o[1] = "B"   if ($cipher =~ /$cfg{'regex'}->{'OWASP_B'}/);
        $o[0] = "A"   if ($cipher =~ /$cfg{'regex'}->{'OWASP_A'}/);
        $o[3] = "D"   if ($cipher =~ /$cfg{'regex'}->{'OWASP_D'}/);
        $o[0] = "A"   if ($cipher =~ /$cfg{'regex'}->{'OWASP_AA'}/);
        printf("  %s\t%s\t%s\t%s\n", $is_pfs, get_cipher_owasp($cipher), join("", @o), $cipher);
    }
    print __regex_line();
    print __regex_head();
    print "
= PFS values:
=   yes   cipher supports PFS
=   no    cipher does not supports PFS
= OWASP values:
=   x     value A or B or C or D or -?- as returned by get_cipher_owasp()
=   miss  cipher not matched by any RegEx, programming error
= owasp values:
=   xx    list of all matching OWASP_x RegEx
";
    return;
} # test_cipher_regex

sub test_cipher_sort    {
    #? check sorting cipher according strength
    # TODO: see ../o-saft-dbx.pm  _yeast_ciphers_sorted()
    return;
} # test_cipher_sort

#_____________________________________________________________________________
#___________________________________________________ initialisation methods __|

sub _prot_init_value    {
    #? initialise default values in %prot
    foreach my $ssl (keys %prot) {
        $prot{$ssl}->{'cnt'}            = 0;
        $prot{$ssl}->{'-?-'}            = 0;
        $prot{$ssl}->{'WEAK'}           = 0;
        $prot{$ssl}->{'LOW'}            = 0;
        $prot{$ssl}->{'MEDIUM'}         = 0;
        $prot{$ssl}->{'HIGH'}           = 0;
        $prot{$ssl}->{'OWASP_AA'}       = 0;
        $prot{$ssl}->{'OWASP_A'}        = 0;
        $prot{$ssl}->{'OWASP_B'}        = 0;
        $prot{$ssl}->{'OWASP_C'}        = 0;
        $prot{$ssl}->{'OWASP_D'}        = 0;
        $prot{$ssl}->{'OWASP_NA'}       = 0;
        $prot{$ssl}->{'OWASP_miss'}     = 0;    # for internal use
        $prot{$ssl}->{'protocol'}       = 0;
        $prot{$ssl}->{'ciphers_pfs'}    = [];
        $prot{$ssl}->{'cipher_pfs'}     = $OSaft::Text::STR{UNDEF};
        $prot{$ssl}->{'default'}        = $OSaft::Text::STR{UNDEF};
        $prot{$ssl}->{'cipher_strong'}  = $OSaft::Text::STR{UNDEF};
        $prot{$ssl}->{'cipher_weak'}    = $OSaft::Text::STR{UNDEF};
    }
    return;
} # _prot_init_value

sub _cfg_init       {
    #? initialise dynamic settings in %cfg, copy data from %prot
    # initialise targets with entry containing defaults
    push(@{$cfg{'targets'}}, @target_defaults);
    $cfg{'openssl_option_map'} ->{$_} = $prot{$_}->{'opt'} foreach (keys %prot);
    $cfg{'openssl_version_map'}->{$_} = $prot{$_}->{'hex'} foreach (keys %prot);
    $cfg{'protos_alpn'} = [split(/,/, $cfg{'protos_next'})];
    $cfg{'protos_npn'}  = [split(/,/, $cfg{'protos_next'})];
    # initialise alternate protocols and curves for cipher checks
    $cfg{'cipher_alpns'}= [split(/,/, $cfg{'protos_next'})];
    $cfg{'cipher_npns'} = [split(/,/, $cfg{'protos_next'})];
    # incorporate some environment variables
    $cfg{'openssl_env'} = $ENV{'OPENSSL'}      if (defined $ENV{'OPENSSL'});
    $cfg{'openssl_cnf'} = $ENV{'OPENSSL_CONF'} if (defined $ENV{'OPENSSL_CONF'});
    $cfg{'openssl_fips'}= $ENV{'OPENSSL_FIPS'} if (defined $ENV{'OPENSSL_FIPS'});
    # initialise cipherranges
    $cfg{'cipherranges'}->{'SSLv2'}        = $cfg{'cipherranges'}->{'SSLv2_base'}
                                           . $cfg{'cipherranges'}->{'SSLv2_rfc'}
                                           . $cfg{'cipherranges'}->{'SSLv2_FIPS'};
    $cfg{'cipherranges'}->{'SSLv2_long'}   = $cfg{'cipherranges'}->{'SSLv2_base'}
                                           . $cfg{'cipherranges'}->{'SSLv2_rfc+'}
                                           . $cfg{'cipherranges'}->{'SSLv2_FIPS'};
    $cfg{'cipherranges'}->{'SSLv3_SSLv2'}  = $cfg{'cipherranges'}->{'SSLv2_base'}
                                           . $cfg{'cipherranges'}->{'SSLv2_rfc+'}
                                           . $cfg{'cipherranges'}->{'SSLv3'};
    $cfg{'cipherranges'}->{'TLSv10'}       = $cfg{'cipherranges'}->{'SSLV3'};
    $cfg{'cipherranges'}->{'TLSv11'}       = $cfg{'cipherranges'}->{'SSLV3'};
    $cfg{'cipherranges'}->{'rfc'}         .= $cfg{'cipherranges'}->{'GREASE'};
    $cfg{'cipherranges'}->{'shifted'}     .= $cfg{'cipherranges'}->{'rfc'};
    $cfg{'cipherranges'}->{'TLSv13'}      .= $cfg{'cipherranges'}->{'GREASE'};
    $cfg{'cipherranges'}->{'intern'}       = $cfg{'cipherranges'}->{'shifted'};
    return;
} # _cfg_init

sub _cmd_init       {
    #? initialise dynamic settings in %cfg for commands
    foreach my $key (sort keys %cfg) {  # well-known "summary" commands
        push(@{$cfg{'commands_cmd'}}, $key) if ($key =~ m/^cmd-/);
    }
    # SEE Note:Testing, sort
    @{$cfg{'commands_cmd'}} = sort(@{$cfg{'commands_cmd'}});
    @{$cfg{'cmd-info--v'}}  = sort(@{$cfg{'cmd-info--v'}});
    return;
} # _cmd_init

sub _dbx_init       {
    #? initialise settings for debugging
    $dbx{'cmd-check'} = $cfg{'cmd-check'};
    $dbx{'cmd-http'}  = $cfg{'cmd-http'};
    $dbx{'cmd-info'}  = $cfg{'cmd-info'};
    $dbx{'cmd-quick'} = $cfg{'cmd-quick'};
    push(@{$dbx{file}}, "osaft.pm");    # set myself
    return;
} # _dbx_init

sub _osaft_init     {
    #? additional generic initialisations for data structures
    my $me =  $0;       # done here to instead of package's "main" to avoid
       $me =~ s#.*[/\\]##;  # multiple variable definitions of $me
    $cfg{'me'}      = $me;
    $cfg{'RC-FILE'} = "./.$me";
    $cfg{'ARG0'}    = $0;
    $cfg{'ARGV'}    = [@ARGV];
    $cfg{'prefix_trace'}    = "#${me}::";
    $cfg{'prefix_verbose'}  = "#${me}: ";
    _prot_init_value(); # initallise WEAK, LOW, MEDIUM, HIGH, default, pfs, protocol
    _cfg_init();        # initallise dynamic data in %cfg
    _cmd_init();        # initallise dynamic commands in %cfg
    _dbx_init();        # initallise debugging data in %dbx
    foreach my $k (keys %data_oid) {
        $data_oid{$k}->{val} = "<<check error>>"; # set a default value
    }
    return;
} # _osaft_init

#_____________________________________________________________________________
#_____________________________________________________________________ main __|

sub _main_lib       {
    #? print own documentation or special required one
    my @argv = @_;
    push(@argv, "--help") if (0 > $#argv);
    binmode(STDOUT, ":unix:utf8");
    binmode(STDERR, ":unix:utf8");
    # got arguments, do something special
    while (my $arg = shift @argv) {
        # ----------------------------- commands
        if ($arg =~ m/^--?h(?:elp)?$/)   {
            OSaft::Text::print_pod($0, __PACKAGE__, $SID_osaft);
            exit 0;
        }
        if ($arg =~ /^version$/)         { print "$SID_osaft\n"; next; }
        if ($arg =~ /^[-+]?V(ERSION)?$/) { print "$VERSION\n";   next; }
        if ($arg =~ m/^--(?:test[_.-]?)regex/) {
            $arg = "--test-regex";
            printf("#$0: direct testing not yet possible, please try:\n   o-saft.pl $arg\n");
        }
    }
    exit 0;
} # _main_lib

sub osaft_done      {}; # dummy to check successful include

_osaft_init();          # complete initialisations

## PACKAGE }
# } # osaft.pm

{ # OSaft/Text.pm
## PACKAGE {

#!# Copyright (c) 2022, Achim Hoffmann
#!# This  software is licensed under GPLv2. Please see o-saft.pl for details.

package OSaft::Text;


use warnings;

my  $SID_text   =  "@(#) Text.pm 1.6 22/11/04 10:51:16";
our $VERSION    =  "22.11.22";

#_____________________________________________________________________________
#________________________________________________ public (export) variables __|

our %STR = (
    'ERROR'     => "**ERROR: ",
    'WARN'      => "**WARNING: ",
    'HINT'      => "!!Hint: ",
    'USAGE'     => "**USAGE: ",
    'DBX'       => "#dbx# ",
    'UNDEF'     => "<<undef>>",
    'NOTXT'     => "<<>>",
    'MAKEVAL'   => "<<value not printed (OSAFT_MAKE exists)>>",
);

use Exporter qw(import);
use base     qw(Exporter);
our @EXPORT_OK  = qw( %STR print_pod text_done );

# SEE Perl:constant

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

=pod

=encoding utf8

=head1 _____________________________________________________________________________

=head1 NAME

OSaft::Text -- common texts for O-Saft and related tools


=head1 SYNOPSIS

=over 2

=item use OSaft::Text;          # in perl code

=item OSaft/Text.pm --help      # on command-line will print help

=back


=head1 OPTIONS

=over 4

=item --help

=back


=head1 DESCRIPTION

Utility package for O-Saft (o-saft.pl and related tools).  It declares and
defines common  L</TEXTS>  to be used in the calling tool.
All variables and methods are defined in the  OSaft::Text  namespace.


=head1 TEXTS

Perlish spoken, all texts are variables:

=over 4

=item %STR{ERROR}

=item %STR{WARN}

=item %STR{HINT}

=item %STR{USAGE}

=item %STR{DBX}

=item %STR{UNDEF}

=item %STR{NOTXT}

=item %STR{MAKEVAL}

=back


=head1 METHODS

=head2 OSaft::Text::print_pod($file)

Print POD for specified file, exits program.


=head1 SEE ALSO

# ...


=head1 VERSION

1.6 2022/11/04


=head1 AUTHOR

22-feb-22 Achim Hoffmann

=cut

#_____________________________________________________________________________
#_________________________________________________________ internal methods __|

# SEE Perl:Undefined subroutine
*_warn    = sub { print(join(" ", "**WARNING:", @_), "\n"); return; } if not defined &_warn;
*_dbx     = sub { print(join(" ", "#dbx#"     , @_), "\n"); return; } if not defined &_dbx;

#_____________________________________________________________________________
#__________________________________________________________________ methods __|

sub print_pod       {
    #? print POD of specified file; exits program
    my $file = shift;   # filename where to read POD from
    my $pack = shift;   # package name
    my $vers = shift;   # package version
    printf("# %s %s\n", $pack, $vers);
    if (eval {require Pod::Perldoc;}) {
        # pod2usage( -verbose => 1 );
        exit( Pod::Perldoc->run(args=>[$file]) );
    }
    if (qx(perldoc -V)) {   ## no critic qw(InputOutput::ProhibitBacktickOperators)
            # may return:  You need to install the perl-doc package to use this program.
            #exec "perldoc $0"; # scary ...
        printf("# no Pod::Perldoc installed, please try:\n  perldoc $file\n");
    }
    exit 0;
} # print_pod

#_____________________________________________________________________________
#____________________________________________________ internal test methods __|

#_____________________________________________________________________________
#_____________________________________________________________________ main __|


sub _main_text      {
    my @argv = @_;
    push(@argv, "--help") if (0 > $#argv);
    binmode(STDOUT, ":unix:utf8"); ## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
    binmode(STDERR, ":unix:utf8"); ## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
    # got arguments, do something special
    while (my $arg = shift @argv) {
        print_pod($0, __PACKAGE__, $SID_text)   if ($arg =~ m/^--?h(?:elp)?$/x);# print own help
        if ($arg =~ m/^--(?:test[_.-]?)text/x) {
            $arg = "--test-text";
            printf("#$0: direct testing not yet possible, please try:\n   o-saft.pl $arg\n");
        }
    }
    exit 0;
} # _main_text

sub text_done  {};      # dummy to check successful include

## PACKAGE }
} # OSaft/Text.pm

{ # OSaft/Ciphers.pm
## PACKAGE {

#!# Copyright (c) 2022, Achim Hoffmann
#!# This  software is licensed under GPLv2. Please see o-saft.pl for details.

package OSaft::Ciphers;

## no critic qw(ControlStructures::ProhibitPostfixControls)
#  We believe it's better readable (severity 2 only).

## no critic qw(ValuesAndExpressions::ProhibitMagicNumbers)
#  We use perlish multiplication vor strings, like "'-' x 7", (severity 2 only).

## no critic qw(RegularExpressions::RequireExtendedFormatting)
#  We use /x as needed for human readability only.

## no critic qw(ValuesAndExpressions::ProhibitImplicitNewlines)
#  We use here documents as needed for human readability.

## no critic qw(BuiltinFunctions::RequireBlockGrep)
#  other people, other opinions

# test resources with:
# /usr/bin/time --quiet -a -f "%U %S %E %P %Kk %Mk" OSaft/Ciphers.pm  alias
# 0.02  0.00  0:00.02 100%  0k  9496k  # 3/2022
# 0.02  0.00  0:00.03 100%  0k  9924k  # 11/2022


use warnings;
use Carp;
our @CARP_NOT   = qw(OSaft::Ciphers); # TODO: funktioniert nicht

BEGIN {
    # SEE Perl:@INC
    # SEE Perl:BEGIN perlcritic
    my $_me   = $0;     $_me   =~ s#.*[/\\]##x;
    my $_path = $0;     $_path =~ s#[/\\][^/\\]*$##x;
    unshift(@INC, $_path)   if (1 > (grep{/^$_path$/} @INC));
    unshift(@INC, "..")     if (1 > (grep{/^\.\.$/}   @INC));
    unshift(@INC, ".")      if (1 > (grep{/^\.$/}     @INC));
}

my  $SID_ciphers= "@(#) Ciphers.pm 2.80 22/11/17 17:47:35";
our $VERSION    = "22.11.22";   # official verion number of this file

#-# use OSaft::Text qw(%STR print_pod);

# SEE Note:Stand-alone
$::osaft_standalone = 0 if not defined $::osaft_standalone; ## no critic qw(Variables::ProhibitPackageVars)

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

# More public documentation, see start of methods section, and at end of file.

=pod

=encoding utf8


=head1 _____________________________________________________________________________

=head1 NAME

OSaft::Ciphers - common Perl module to define cipher suites for O-Saft


=head1 SYNOPSIS

=over 2

=item  use OSaft::Ciphers;     # from within Perl code

=item  OSaft::Ciphers.pm       # on command line will print help

=back


=head1 DESCRIPTION

Utility package for O-Saft (o-saft.pl and related tools). This package contains
the primary data structure for cipher suites. Common L</VARIABLES> and L</METHODS>
are declares and defined to be used in the calling tool.

The documentation is intended for developers. Users should read any of the help
texts for example provided by O-Saft, i.e. C<o-saft.pl --help>.

This module provides  additional functionality  to list and check the used data
structures for the cipher suites. All  L</COMMANDS> and L</OPTIONS>  of this tool
are only for this additional functionality, please read descriptions there.

=head2 Used Functions

Following functions (methods) must be defined in the calling program:

None (03/2022).


=head1 CONCEPT

The main data structure is  C<%ciphers>, which will be defined herein.
Ciphers (more precisely: cipher suites) are defined statically as Perl __DATA__
herein. Each cipher is defined statically in one line with TAB-separated values
for example:

    0x0300003D HIGH  HIGH  TLSv12  RSA  RSA  AES  256  SHA256 .. AES256-SHA256

For a more detailed description, please use:

    OSaft/Ciphers.pm description
    OSaft/Ciphers.pm --test-ciphers-description

or consult the source code directly, in particular  C<%ciphers_desc>.

The main key -aka ID- to identify a cipher suite is a 32-bit key where the last
16 bits are the numbers as defined by IANA and/or various RFCs.
This key is also used in all other data structures related to ciphers.

Each cipher suite is defined as a Perl array (see above)  and will be converted
to a Perl hash at initialisation like:

    '0x0300003D' => { ssl=>"TLSv12", keyx=>"RSA", enc=>"AES", ... },

Such a hash is simpler to use. Finally a getter method (see L</METHODS>) is
provided for each value.

=cut

#This approach to specify the definition,  which must be done by developers,  is
#based on the consideration that the data structure needs to be  maintained very
#carefully. Therefore the description of  all (known) cipher suites is done in a
#simple table, which just contains TAB-separated words.  This table will then be
#converted into the %ciphers hash automatically when this module is loaded. It's
#the author's opinion, that tabular data is more easy to maintain by humans than
#structured data.

=pod

=head2 Variables

All variables except C<$cipher_results> are constants, and hence read-only. There
is no need to change them in the calling program.

=head2 Methods

Because all variables are constants, mainly getter methods are provided.
The only setter method is C<set_sec> which is used to redefine the security value
of an cipher by the user with the option  "--cfg-cipher=CIPHER=value"

=head2 Testing

The getter methods can be used directly, see:  OSaft/Ciphers.pm --usage

=head2 Documentaion

This documentation describes the public variables and methods only, but not the
internal ones, in particular the  C<show_*()> functions.  Please see the source
itself for that.


=head1 VARIABLES

=over 4

=item %ciphers

Hash with all cipher suites and paramters of each suite. Indexed by cipher ID.

=item %ciphers_desc

Describes the data structure in C<%ciphers>.

=item %ciphers_notes

Notes and comments for a specific cipher, documentation only.
Will be referenced in C<%ciphers>.

=item $cipher_results

Pointer to hash with all checked ciphers.

=back

=cut

#_____________________________________________________________________________
#________________________________________________ public (export) variables __|

# SEE Perl:perlcritic
## no critic qw(Variables::ProhibitPackageVars)

use Exporter qw(import);
use base     qw(Exporter);
our @EXPORT_OK  = qw(
        %ciphers
        %ciphers_desc
        %ciphers_notes
        $cipher_results
        ciphers_done
);
#   methods not exported, see METHODS description above

our %ciphers_desc   = ( # description of %ciphers table
    'head'          => [qw( openssl sec  ssl  keyx auth enc  bits mac  rfc  names const notes)],
                            # array of all culumns used most tables (including
                            # the definition below in DATA);
                            # abbreviations used by openssl:
                            # SSLv2, SSLv3, TLSv1, TLSv1.1, TLSv1.2
                            # Kx=  key exchange (DH is diffie-hellman)
                            # Au=  authentication
                            # Enc= encryption with bit size
                            # Mac= mac encryption algorithm
                            # 
    'hex'      => 'Hex Code',       # hex key for cipher suite
                            #
    'openssl'  => 'OpenSSL STRENGTH', # LOW, MEDIUM, HIGH as reported by openssl 0.9.8 .. 1.0.1h
                            # WEAK as reported by openssl 0.9.8 as EXPORT
                            # weak unqualified by openssl or known vulnerable
                            # NOTE: weak includes NONE (no security at all)
                            # high unqualified by openssl, but considerd secure
    'sec'      => 'Security',       # weak, medium, high
                            # weak unqualified by openssl or known vulnerable
                            # high unqualified by openssl, but considerd secure
    'ssl'      => 'SSL/TLS Version',# Protocol Version:
                            # SSLv2, SSLv3, TLSv1, TLSv11, TLSv12, TLSv13, DTLS0.9, DTLS1.0, PCT
                            # NOTE: all SSLv3 are also TLSv1, TLSv11, TLSv12
                            # (cross-checked with sslaudit.ini)
    'keyx'     => 'Key Exchange',   # DH, ECDH, ECDH/ECDSA, RSA, KRB5, PSK, SRP, GOST, ECCPWD
                            # last column is a : separated list (only export from openssl)
                            # different versions of openssl report  ECDH or ECDH/ECDSA
    'auth'     => 'Authentication', # None, DSS, RSA, ECDH, ECDSA, KRB5, PSK, GOST01, GOST94
    'enc'      => 'Encryption Type',# Algorithm: None, AES, AESCCM, AESGCM, ARIA, CAMELLIA, DES, 3DES, FZA, GOST89, IDEA, RC4, RC2, SEED
    'bits'     => 'Encryption Size',# Key size in bits
    'enc_size' => 'Block Size',     # encryption block size in bits
    'mac'      => 'MAC/Hash Type',  # Algorithm: MD5, SHA1, SHA256, SHA384, AEAD, GOST89, GOST94
    'mac_size' => 'MAC/Hash Size',  # size of MAC in bits (usually coded in its name (type)
#   'dtls'     => 'DTLS OK', # Y  if cipher is compatible for DTLS, N  otherwise
#                            # (information from IANA)
    'rfc'      => 'RFC(s)',         # RFC number where cipher was defined
    'pfs'      => 'PFS',            # )f cipher ha perfect forward secrecy
    'suite'    => 'Cipher Suite',   # cipher suite name, mainly those used by OpenSSL
    'name'     => 'OpenSSL Name',   # cipher suite name used by OpenSSL
    'names'    => '(Alias) Names',  # Comma-separated list of cipher suite name and aliases
    'const'    => 'Constant Names', # Comma-separated list of cipher suite constants
    'notes'    => 'Notes/Comments', # Comma-separated list of notes and comments
                            # for this cipher suite; for eaxmple: EXPORT, OSX
                            # each value is used as key to %ciphers_notes
                            # 
    'sample'        => { # example
      '0x0300003D'  => [split /\s+/, q(HIGH HIGH TLSv12 RSA  RSA  AES  256  SHA256 5246 AES256-SHA256,Alias RSA_WITH_AES_256_SHA256,RSA_WITH_AES_256_CBC_SHA256 L )],
                            # qw// would result in Perl warning:
                            #   Possible attempt to separate words with commas
                            # q// is one word, hence it must be splitted to become an array
        },
    'additional_notes'  => '
Note about Constant names:
  Depending on the source of the constant, a different prefix in the name is
  used, such as TLS_ SSL_ SSL_CK_ SSL3_CK_ TLS1_CK_
  Hence no prefix at all is used here.
Note about TLS version:
  Usually the lowest/oldest protocol version is shown. But this cipher suite
  may also be used in a newer protocol version also.
  Following normalised strings are used for protocol versions:
      SSLv2, SSLv3, DTLS0.9, DTLS1.0, TLSv10, TLSv11, TLSv12, TLSv13, PCT
  SSL/TLS  is used for pseudo cipher suites.
        ',
); # %ciphers_desc

our %ciphers        = ( # list of all ciphers
    # will be generated in _ciphers_init() from <DATA>
    #--------------+-------+-------+----+----+----+----+----+----+----+-----------+-----------+-----+
    # key       => [qw( openssl sec ssl  keyx auth enc  bits mac  rfc  name;alias  const       notes )],
    #--------------+-------+-------+----+----+----+----+----+----+----+-----------+-----------+-----+
    #--------------+-------+-------+----+----+----+----+----+----+----+-----------+-----------+-----+
# ...
); # %ciphers

our @cipher_iana_recomended =
    #? list of all ciphers (hex keys) recommended by IANA, see
    # http://www.iana.org/assignments/tls-parameters/tls-parameters.txt August 2022
    qw(
    0x0300009E 0x0300009F 0x030000AA 0x030000AB 0x03001301 0x03001302 0x03001303 0x0300130$
    0x0300C02B 0x0300C02C 0x0300C02F 0x0300C030 0x0300C09E 0x0300C09F 
    0x0300C0A6 0x0300C0A7 0x0300C0A8 0x0300C0A9 0x0300CCAA 0x0300CCAC 0x0300CCAD
    0x0300D001 0x0300D002 0x0300D005
); # cipher_iana_recomended

our $cipher_results = { # list of checked ciphers
    #--------------+--------+--------------+----------+
    # key       => [  ssl    supported ], # cipher suite name
    #--------------+--------+--------------+----------+
#  '0x02010080' => [ SSLv3,  yes ],  # RC4-MD5
#  '0x03000004' => [ SSLv3,  yes ],  # RC4-MD5
#  '0x0300003D' => [ TLSv12, yes ],  # AES256-SHA256
#  '0x02FF0810' => [ SSLv3,  no  ],  # NULL
    #--------------+--------+--------------+----------+
}; # $cipher_results

our %ciphers_notes  = ( # list of notes and comments for ciphers
    # these texts are referenced in %ciphers
    #------------------+---------,
    # hex       =>      'text'   ,
    #------------------+---------,
    #------------------+---------,
# ...
); # %ciphers_notes

#_____________________________________________________________________________
#_________________________________________________________ internal methods __|

# SEE Perl:Undefined subroutine
*_warn    = sub { print(join(" ", "**WARNING:", @_), "\n"); return; } if not defined &_warn;
*_dbx     = sub { print(join(" ", "#dbx#"     , @_), "\n"); return; } if not defined &_dbx;
*_trace   = sub { print(join(" ", "#${0}::",    @_), "\n") if (0 < $cfg{'trace'});   return; } if not defined &_trace;
*_trace2  = sub { print(join(" ", "#${0}::",    @_), "\n") if (2 < $cfg{'trace'});   return; } if not defined &_trace2;
*_v_print = sub { print(join(" ", "#${0}: ",    @_), "\n") if (0 < $cfg{'verbose'}); return; } if not defined &_v_print;
*_v2print = sub { print(join(" ", "#${0}: ",    @_), "\n") if (1 < $cfg{'verbose'}); return; } if not defined &_v2print;

#_____________________________________________________________________________
#__________________________________________________________________ methods __|

=pod

=head1 METHODS

No methods are exported. The full package name must be used, which improves the
readability of the program code. Methods intended for external use are:


=head2 text2key($text)

Convert hex text to internal key: 0x00,0x3D --> 0x0300003D.

=head2 key2text($key)

Convert internal key to hex text: 0x0300003D --> 0x00,0x3D.

=head2 set_sec(   $cipher_key)

Set value for 'security' in for specified cipher key.

=cut

sub text2key    {
    #? return internal hex key for given hex, return as is if not hex
    my $txt = shift;
    my $key = uc($txt); # we use upper case only
       $key =~ s/(,|0X)//g;     # 0x00,0x26  --> 0026
    return $txt if ($key !~ m/^[0-9A-F]+$/); # unknown format, return as is
    return "0x$key" if (8 == length($key));
    if (4 < length($key)) {
       # SSLv2: quick&dirty: expects 6 characers
       $key = "0x02$key";       # 010080     --> 0x02010080
    } else {
       # SSLv3, TLSv1.x
       while (6 > length($key)) { $key = "0$key"; }
       $key = "0x03$key";       # 000026     --> 0x03000026
    }
    return $key;
} # text2key

sub key2text    {
    #? return internal hex key converted to openssl-style hex key
    # strips 0x03,0x00
    # return as is if not hex
    my $key = shift;
    return $key if ($key !~ m/^0x[0-9A-F]+$/i); # unknown format, return as is
       # NOTE: invalid keys like 0x0300001E-bug should not be converted
       $key =~ s/0x//i;         #    0x0026  --> 0026 (necessary in test-mode only)
    if (6 < length($key)) {     #   from     -->     to
       $key =~ s/^42//;         # 0x42420001 -->   420001 ; internal use in future
       $key =~ s/^02//;         # 0x02010080 -->   010080
       $key =~ s/^0300//;       # 0x03000004 -->     0004
    }
       $key =~ s/(..)/,0x$1/g;  #       0001 --> ,0x00,0x04
       $key =~ s/^,//;          # ,0x00,0x04 -->  0x00,0x04
       $key =  "     $key" if (10 > length($key));
    return "$key";
} # key2text

sub set_sec     { my ($key, $val) = @_; $ciphers{$key}->{'sec'} = $val; return; }
    #? set value in $ciphers{$key}->{'sec'} hash

=pod

=head2 get_param( $cipher_key, $key)

=head2 get_openssl( $cipher_key)

=head2 get_ssl(   $cipher_key)

=head2 get_sec(   $cipher_key)

=head2 get_keyx(  $cipher_key)

=head2 get_auth(  $cipher_key)

=head2 get_enc(   $cipher_key)

=head2 get_bits(  $cipher_key)

=head2 get_mac(   $cipher_key)

=head2 get_dtls(  $cipher_key)

=head2 get_rfc(   $cipher_key)

=head2 get_notes( $cipher_key)

=head2 get_name(  $cipher_key)

=head2 get_names( $cipher_key)

=head2 get_aliases( $cipher_key)

Return all cipher suite names except the first cipher suite name.

=head2 get_const( $cipher_key)

=head2 get_consts($cipher_key)

=head2 get_note(  $cipher_key)

=head2 get_notes( $cipher_key)

=head2 get_encsize( $cipher_key)

Return encryption block size of cipher suite.

=cut

# some people prefer to use a getter function to get data from objects
# each function returns a spcific value (column) from the %ciphers table
# see %ciphers_desc about description of the columns
# returns $OSaft::Text::STR{UNDEF} if requested cipher (hex key) is missing
sub get_param   {
    #? internal method to return required value from %ciphers ($cipher is hex-key)
    #? returns array or string depending on calling context
    my ($hex, $key) = @_;
    #_trace("get_param($hex,$key)");
        $hex = text2key($hex);      # normalize cipher key
    # if (0 < (grep{/^$hex/i} %ciphers))  # TODO: brauchen wir das für defense programming?
    if ('ARRAY' eq ref($ciphers{$hex}->{$key})) {
        return wantarray ? @{$ciphers{$hex}->{$key}} : join(' ', @{$ciphers{$hex}->{$key}});
    } else {
        return               $ciphers{$hex}->{$key} || "";
    }
    return $OSaft::Text::STR{UNDEF}; # never reached
} # get_param

sub get_openssl { return  get_param(shift, 'openssl');  }
sub get_sec     { return  get_param(shift, 'sec'  );    }
sub get_ssl     { return  get_param(shift, 'ssl'  );    }
sub get_keyx    { return  get_param(shift, 'keyx' );    }
sub get_auth    { return  get_param(shift, 'auth' );    }
sub get_enc     { return  get_param(shift, 'enc'  );    }
sub get_bits    { return  get_param(shift, 'bits' );    }
sub get_mac     { return  get_param(shift, 'mac'  );    }
sub get_rfc     { return  get_param(shift, 'rfc'  );    }
sub get_name    { return (get_param(shift, 'names'))[0];}
#sub get_name    { my @n = get_param(shift, 'names'); print "# get_name: $n[0]"; return $n[0];}
sub get_names   { return  get_param(shift, 'names');    }
sub get_aliases { my @a = get_names(shift); return @a[1 .. $#a]; }
#or get_aliases { my @a = get_names(shift); shift @a; return @a; }
sub get_const   { return (get_param(shift, 'const'))[0];}
sub get_consts  { return  get_param(shift, 'const');    }
sub get_note    { return (get_param(shift, 'notes'))[0];}
sub get_notes   { return  get_param(shift, 'notes');    }

sub _get_name   {
    #? internal method to return cipher suite name when paramater is hex-key or cipher suite name
    # simple check: asumes a key, if it matches 0x
    my $txt = shift;
    return $txt if ($txt !~ m/0x/);
    return get_name($txt);
} # _get_name

sub get_encsize {
    #? return encryption block size, based on (OpenSSL's) cipher suite name
    #? $cipher is hex-key or cipher suite name
    my $name= _get_name(shift);
    return '128'        if ($name =~ m/AES/);
    return '64'         if ($name =~ m/Blowfish/i);
    return '128'        if ($name =~ m/CAMELLIA/);
    return '-'          if ($name =~ m/-CHACHA/);
    return '64'         if ($name =~ m/-CBC3/);
    return '64'         if ($name =~ m/-3DES/);
    return '-'          if ($name =~ m/DES-CBC/);   # 3DES and CBC3 matched before
    return '-?-'        if ($name =~ m/DES-CFB/);
    return '-?-'        if ($name =~ m/GOST/);
    return '64'         if ($name =~ m/IDEA/);
    return '-'          if ($name =~ m/NULL/);
    return '64'         if ($name =~ m/RC2-/);
    return '-'          if ($name =~ m/RC4/);
    return '128'        if ($name =~ m/SEED/);
    return '-?-';   # shoud be $OSaft::Text::STR{UNDEF}, but that's nasty in HTML
} # get_encsize

# following not yet used, as this information is defined in %ciphers
#
# =pod
# 
# =head2 get_encmode( $cipher_key)
# 
# Return type of encryption mode of cipher suite.
# 
# =head2 get_enctype( $cipher_key)
# 
# Return type of encryption of cipher suite.
# 
# =head2 get_mactype( $cipher_key)
# 
# Return type of MAC of cipher suite.
# 
# =cut
# 
# sub get_encmode {
#     #? return encryption mode, based on (OpenSSL's) cipher suite name
#     #? $cipher is hex-key or cipher suite name
#     # NOTE: use get_enc() instead
#     my $name= _get_name(shift);
#     return 'GCM'        if ($name =~ m/-GCM/);
#     return 'CBC'        if ($name =~ m/-CBC/);
#     return 'CBC'        if ($name =~ m/-CAMELLIA/);
#     return 'CBC'        if ($name =~ m/-IDEA/);
#     return 'CBC'        if ($name =~ m/-SEED/);
#     return 'CBC'        if ($name =~ m/-RC2/);
#     return '-'          if ($name =~ m/-RC4/);
#     return '-'          if ($name =~ m/-CHACHA20/);
#     return '-'          if ($name =~ m/-NULL/);
#     return 'CBC';   # anything else is CBC (i.e. if CBC is not part of the suite name)
# } # get_encmode
# 
# sub get_enctype {
#     #? return encryption type, based on (OpenSSL's) cipher suite name
#     #? $cipher is hex-key or cipher suite name
#     my $name= _get_name(shift);
#     return 'AES'        if ($name =~ m/-AES/);  # matches: -AES128 -AES256 -AES-
#     return 'AES'        if ($name =~ m/AES/);   # matches: AES128- AES256-
#     return 'ARIA'       if ($name =~ m/-ARIA/);
#     return 'CCM8'       if ($name =~ m/-CCM8/);
#     return 'CCM'        if ($name =~ m/-CCM/);
#     return 'CAMELLIA'   if ($name =~ m/-CAMELLIA/);
#     return 'CHACHA20'   if ($name =~ m/-CHACHA20/);
#     return 'CAST'       if ($name =~ m/-CAST/);
#     return 'GOST'       if ($name =~ m/-GOST/); # TODO: GOST01 and GOST89 and GOST94?
#     return 'IDEA'       if ($name =~ m/-IDEA/);
#     return 'SEED'       if ($name =~ m/-SEED/);
#     return '3DES'       if ($name =~ m/-CBC3/);
#     return '3DES'       if ($name =~ m/-3DES/);
#     return 'DES'        if ($name =~ m/-DES/);
#     return 'RC4'        if ($name =~ m/-RC4/);
#     return 'RC2'        if ($name =~ m/-RC2/);
#     return 'None'       if ($name =~ m/-NULL/);
#     return '-?-';   # shoud be $OSaft::Text::STR{UNDEF}, but that's nasty in HTML
# } # get_enctype
# 
# sub get_mactype {
#     #? return encryption key, based on (OpenSSL's) cipher suite name
#     #? $cipher is hex-key or cipher suite name
#     my $name= _get_name(shift);
#     return 'SHA384'     if ($name =~ m/-SHA384/);
#     return 'SHA256'     if ($name =~ m/-SHA256/);
#     return 'SHA128'     if ($name =~ m/-SHA128/);
#     return 'SHA'        if ($name =~ m/-SHA1/); # matches: -SHA1$
#     return 'SHA'        if ($name =~ m/-SHA/);  # matches: -SHA$
#     return 'MD5'        if ($name =~ m/-MD5/);
#     return 'MD4'        if ($name =~ m/-MD4/);
#     return 'RMD'        if ($name =~ m/-RMD/);
#     return 'POLY1305'   if ($name =~ m/-POLY1305/);
#     return 'GOST'       if ($name =~ m/-GOST/); # TODO: GOST01 and GOST89 and GOST94?
#     return 'AEAD'       if ($name =~ m/-GCM/);
#     return '-?-';   # shoud be $OSaft::Text::STR{UNDEF}, but that's nasty in HTML
# } # get_mactype

=pod

=head2 get_key(   $cipher_name)

Get hex key for given cipher name; searches in cipher suite names and in cipher
suite constants. Given name must match exactly.

=head2 get_data(  $cipher_key)

Get all data for given cipher key from internal C<%ciphers> data structure.

=head2 get_iana(  $cipher_key)

Return "yes" if cipher suite is recommended by IANA, "no" otherwise.

=head2 get_pfs(   $cipher_key|$cipher_name)

Return "yes" if cipher suite supports PFS, "no" otherwise.

=head2 get_keys_list()

Get list of all defined (internal) hex keys for cipher suites in C<%ciphers>.
Returns space-separetd string or array depending on calling context.

=head2 get_names_list()

Get list of all defined cipher suite names in C<%ciphers>.
Returns space-separetd string or array depending on calling context.

=head2 find_names( $cipher_pattern)

Find all matching cipher names for given cipher name (pattern).

=head2 find_keys( $cipher_pattern)

Find all matching hex keys for given cipher name (pattern).

=head2 find_name( $cipher)

Find cipher key(s) for given cipher name or cipher constant.

=cut

sub get_key     {
    #? return hex key for given cipher name; searches in cipher suite names and constants
    my $txt = shift;
    my $key = uc($txt);
       $key =~ s/X/x/g; # 0X... -> 0x...
    return $key if defined $ciphers{$key};  # cipher's hex key itself
    foreach my $key (keys %ciphers) {
        my @names = get_names($key);
        return $key if (0 < (grep{/^$txt$/i} @names));
            # TODO above grep my return "Use of uninitialized value $_"
            #      if the passed key is not found in @names
    }
    # any other text, try to normalise ...      # example:  SSL_CK_NULL_WITH_MD5
    $txt =~ s/^(?:SSL[23]?|TLS1?)_//;   # strip any prefix: CK_NULL_WITH_MD5 
    $txt =~ s/^(?:CK|TXT)_//;           # strip any prefix: NULL_WITH_MD5
    foreach my $key (keys %ciphers) {
        my @names = get_const($key);
        return $key if (0 < (grep{/^$txt$/i} @names));
    }
    _warn("521: no key found for '$txt'");  # most likely a programming error %cfg or <DATA> herein
    return '';
} # get_key

sub get_data    {
    #? return all data for given cipher key from internal %ciphers data structure
    my $key = shift;
    return $OSaft::Text::STR{UNDEF} if (not defined $ciphers{$key});
    # my @x = sort values %{$ciphers{$key}}; # lasy approach not used
    return join("\t", 
            get_param($key, 'openssl'),
            get_param($key, 'sec'  ),
            get_param($key, 'ssl'  ),
            get_param($key, 'keyx' ),
            get_param($key, 'auth' ),
            get_param($key, 'enc'  ),
            get_param($key, 'bits' ),
            get_param($key, 'mac'  ),
            get_param($key, 'rfc'  ),
            #get_param($key, 'dtls' ), # not yet implemented
            get_param($key, 'names'),
            get_param($key, 'const'),
            get_param($key, 'notes'),
    );
} # get_data

sub get_iana    {
    #? return "yes" if cipher suite is recommended by IANA, "no" otherwise
    my $key = shift;
       $key = text2key($key);       # normalize cipher key
    return (grep{ /^$key/i} @cipher_iana_recomended) ? "yes" : "no";
} # get_iana

sub get_pfs     {
    #? return "yes" if cipher suite supports PFS, "no" otherwise
    my $key  = shift;
    my $name = $key;
    if ($key =~ /^0x[0-9A-F]{8}$/i) {
       $name = get_name($key);
    }
    return (($name =~ m/^(?:EC)?DHE/) or ($name =~ m/^(?:EXP-)?EDH-/)) ? "yes" : "no";
        # EDH- and EXP-EDH- for ancient names
} # get_pfs

sub get_keys_list   {
    #? return list of all defined (internal) hex keys for cipher suites in %ciphers
    my @keys = grep{ /^0x[0-9a-fA-F]{8}$/} keys %ciphers;   # only valid keys
    return wantarray ? (sort @keys) : join(' ', (sort @keys));
    # SEE Note:Testing, sort
} # get_keys_list 

sub get_names_list  {
    #? return list of all defined cipher suite names in %ciphers
    my @list;
    foreach my $key (sort keys %ciphers) {
        next if ($key !~ m/^0x[0-9a-fA-F]{8}$/);# extract only valid keys
        push(@list, get_name($key));
    }
    return wantarray ? (sort @list) : join(' ', (sort @list));
    # SEE Note:Testing, sort
} # get_names_list

sub find_keys   {
    #? TODO  find all hex key for which given cipher pattern matches in %ciphers
    my $pattern = shift;
    _trace("find_keys($pattern)");
    return map({get_key($_);} grep(/$pattern/, get_names_list()));
} # find_keys

sub find_names  {
    #? TODO  find all cipher suite names for which given cipher pattern matches in %ciphers
    my $pattern = shift;
    _trace("find_names($pattern)");
    return grep(/$pattern/, get_names_list());
} # find_names

sub find_name   {
    #? TODO  check if given cipher name is a known cipher
    #  checks in %ciphers, if not found search in all aliases and constants
    #  example: RC4_128_WITH_MD5 -> RC4-MD5 ;  RSA_WITH_AES_128_SHA256 -> AES256-SHA256
    # Note: duplicate name (like RC4_128_WITH_MD5) are no problem, because they
    #       use the same cipher suite name (like RC4-MD5).
# TODO: need $ssl parameter because of duplicate names (SSLv3, TLSv10)
    my $cipher  = shift;
    my @list;
    _trace("find_name: search $cipher");
    my $key = get_key($cipher);
    return $key if $key !~ m/^\s*$/;
    # try fuzzy search in names and const:
    foreach my $key (sort keys %ciphers) {
        my $name = get_name($key);
        next if not $name;
        next if $name =~ m/^\s*$/;
        if ($name !~ m/$cipher/i) {
            my @const = get_consts($key);
#dbx print "C = @const\n";
        # TODO
        }
        _warn("513: partial match for cipher name found '$cipher'");
        push(@list, $key);
    }
    return @list;
# TODO: # $rex_name = s/([_-])/.?/g; $rex_name = s/DHE/EDH/;
    #return $OSaft::Text::STR{UNDEF};
} # find_name

=pod

=head2 sort_names(@ciphers)

Sort ciphers according their strength. Returns list with most strongest first. 

C<@ciphers> is a list of cipher suite names. These names should be those used by
openssl(1)  .

=head2 sort_results(%unsorted)

Sort ciphers according their strength. Returns list with most strongest first. 

C<%unsorted> is a reference to a hash) of cipher suite hex keys.
=cut

sub sort_names      {
    #? sort array of cipher suite names according their strength
    # cipher suites must be given as array
    # NOTE: the returned list may not be exactly sorted according the cipher's
    #       strength, just roughly
    # known insecure, i.e. CBC, DES, NULL, etc. ciphers are added at the end
    # all ciphers classified "insecure" are added to end of the result list,
    # these (insecure) ciphers are not sorted according their strength as it
    # doesn't make much sense to distinguish "more" or "less" insecure
    my @ciphers = @_;
    my @sorted  ;
    my @latest  ;
    my $cnt_in  = scalar @ciphers;  # number of passed ciphers; see check at end

    _trace("sort_names(){ $cnt_in ciphers: @ciphers }");

    # Algorithm:
    #  1. remove all known @insecure ciphers from given list
    #  2. start building new list with most @strength cipher first
    #  3. add previously removed @insecure ciphers to new list

    # define list of RegEx to match openssl cipher suite names
    # each regex could be seen as a  class of ciphers with the same strength
    # the list defines the strength in descending order, most strength first
    # NOTE the list may contain pattern, which actually do not match a valid
    # cipher suite name; doese't matter, but may avoid future adaptions, see
    # warning at end also

    my @insecure = (
        qw((?:RC[24]))  ,               # all RC2 and RC4
        qw((?:CBC|DES)) ,               # all CBC, DES, 3DES
        qw((?:DSA|DSS)) ,               # all DSA, DSS
        qw((?:MD[2345])),               # all MD
        qw(DH.?(?i:anon)),              # Anon needs to be caseless
        qw((?:NULL))    ,               # all NULL
        qw((?:SCSV))    ,               # dummy ciphers (avoids **WARNING: 412: for INFO_SCSV)
        qw((?:GREASE-))    ,            # dummy ciphers (avoids **WARNING: 412: for GREASE*)
    );
    my @strength = (
        qw(CECPQ1[_-].*?CHACHA)       ,
        qw(CECPQ1[_-].*?AES256.GCM)   ,
        qw(^(TLS_|TLS13-))   ,
        qw((?:ECDHE|EECDH).*?CHACHA)  , # 1. all ecliptical curve, ephermeral, GCM
        qw((?:ECDHE|EECDH).*?512.GCM) , # .. sorts -ECDSA before -RSA
        qw((?:ECDHE|EECDH).*?384.GCM) ,
        qw((?:ECDHE|EECDH).*?256.GCM) ,
        qw((?:ECDHE|EECDH).*?128.GCM) ,
        qw((?:EDH|DHE).*?CHACHA)  ,     # 2. all ephermeral, GCM
        qw((?:EDH|DHE).*?PSK)     ,
        qw((?:EDH|DHE).*?512.GCM) ,     # .. sorts AES before CAMELLIA
        qw((?:EDH|DHE).*?384.GCM) ,
        qw((?:EDH|DHE).*?256.GCM) ,
        qw((?:EDH|DHE).*?128.GCM) ,
        qw(ECDH[_-].*?CHACHA)   ,       # 3. all ecliptical curve, GCM
        qw(ECDH[_-].*?512.GCM)  ,       # .. sorts -ECDSA before -RSA
        qw(ECDH[_-].*?384.GCM)  ,
        qw(ECDH[_-].*?256.GCM)  ,
        qw(ECDH[_-].*?128.GCM)  ,
        qw(ECDHE.*?CHACHA),             # 4. all remaining ecliptical curve, ephermeral
        qw(ECDHE.*?512) ,
        qw(ECDHE.*?384) ,
        qw(ECDHE.*?256) ,
        qw(ECDHE.*?128) ,
        qw(ECDH[_-].*?CHACHA),          # 5. all remaining ecliptical curve
        qw(ECDH[_-].*?512) ,
        qw(ECDH[_-].*?384) ,
        qw(ECDH[_-].*?256) ,
        qw(ECDH[_-].*?128) ,
        qw(ECCPWD[_-])  ,               # 6. unknown ecliptical curve
        qw(AES)     ,                   # 7. all AES and specials
        qw(KRB5)    ,
        qw(SRP)     ,
        qw(PSK)     ,
        qw(GOST)    ,
        qw((?:IANA|LEGACY)[_-]GOST2012),# 
        qw(FZA)     ,
        qw((?:PSK|RSA).*?CHACHA),
        qw(CHACHA)  ,
        qw((?:EDH|DHE).*?CHACHA),       # 8. all DH
        qw((?:EDH|DHE).*?512) ,
        qw((?:EDH|DHE).*?384) ,
        qw((?:EDH|DHE).*?256) ,
        qw((?:EDH|DHE).*?128) ,
        qw((?:EDH|DHE).*?(?:RSA|DSS)) ,
        qw(CAMELLIA) ,                  # 9. unknown strength
        qw((?:SEED|IDEA|ARIA|SM4)),
        qw(^(?:SHA256-|SHA384-)),
        qw(RSA[_-]) ,                   # 10.
        qw(DH[_-])  ,
        qw(RC)      ,
        qw(EXP)     ,                   # 11. Export ...
        qw(AEC.*?256) ,                 # insecure
        qw(AEC.*?128) ,
        qw(AEC)     ,
        qw(ADH.*?256) ,                 # no encryption
        qw(ADH.*?128) ,
        qw(ADH)     ,
        qw(PCT_)    ,                   # not an SSL/TLS protocol, just to keep our checks quiet
    );
    foreach my $rex (@insecure) {               # remove all known insecure suites
        _trace2("sort_names: insecure regex\t= $rex }");
        push(@latest, grep{ /$rex/} @ciphers);  # add matches to result
        @ciphers    = grep{!/$rex/} @ciphers;   # remove matches from original list
    }
    foreach my $rex (@strength) {               # sort according strength
        $rex = qr/^(?:(?:SSL|TLS)[_-])?$rex/;   # allow IANA constant names too
        _trace2("sort_names(): regex\t= $rex }");
        push(@sorted, grep{ /$rex/} @ciphers);  # add matches to result
        @ciphers    = grep{!/$rex/} @ciphers;   # remove matches from original list
    }
    # TODO: @ciphers should now be empty, check ...
    push(@sorted, @latest);                     # add insecure ciphers again
    my $cnt_out = scalar @sorted;
    if ($cnt_in != $cnt_out) {
        # print warning if above algorithm misses ciphers;
        # uses Perl's warn() instead of our _warn() to clearly inform the user
        # that the code here needs to be fixed
        my @miss;
        for my $i (0..$#ciphers) {
            push(@miss, $ciphers[$i]) unless grep {$_ eq $ciphers[$i]} @sorted;
        }
        @miss = sort @miss; # SEE Note:Testing, sort
        warn $OSaft::Text::STR{WARN}, "412: missing ciphers in sorted list ($cnt_out < $cnt_in): @miss"; ## no critic qw(ErrorHandling::RequireCarping)
    }
    @sorted = grep{!/^\s*$/} @sorted;           # remove empty names, if any ...
    _trace("sort_names(){ $cnt_out ciphers\t= @sorted }");
    return @sorted;
} # sort_names

sub sort_results    {   ## no critic qw(Subroutines::ProhibitExcessComplexity)
    #? sort array of ciphers according their strength
    # returns array with sorted cipher keys
    # only used when ckecking for ciphers with openssl
#TODO: should be same as sort_names()
    my $unsorted= shift;    # hash with $key => yes-or-no
    my @sorted;             # array to be returned
    my @tmp_arr;
    foreach my $key (sort keys %$unsorted) {
        next if ($key =~ m/^\s*$/);         # defensive programming ..
        my $cipher    = get_name($key);
        if (not defined $cipher) {  # defensive programming ..
            _warn("862: unknown cipher key '$key'; key ignored");
            next;
        }
        my $sec_osaft = lc(get_sec($key));# lower case
        my $sec_owasp = osaft::get_cipher_owasp($cipher);
           $sec_owasp = "N/A" if ('-?-' eq $sec_owasp); # sort at end
        # Idea about sorting according severity/security risk of a cipher:
        #   * sort first according OWASP rating A, B, C
        #   then use a weight for each cipher:
        #   * most secure cipher first
        #   * prefer ECDHE over DHE over ECDH
        #   * prefer SHA384 over /SHA256 over SHA
        #   * prefer CHACHA over AES
        #   * prefer AES265 over AES128
        #   * sort any anon (ADH, DHA, ..) and EXPort at end
        #   * NULL is last
        # then use OpenSSL/O-Saft rating, hence the string to be sorted looks
        # like:
        #       # A 20 high ...
        #       # A 23 high ...
        #       # B 33 high ...
        #       # B 37 medium ...
        # One line in incomming array in @unsorted:
        #       # TLSv12, ECDHE-RSA-AES128-GCM-SHA256, yes
        # will be converted to following line:
        #       # A 20 HIGH ECDHE-RSA-AES128-GCM-SHA256 TLSv12 yes
        my $weight = 50; # default if nothing below matches
        $weight  = 19 if ($cipher =~ /^ECDHE/i);
        $weight  = 25 if ($cipher =~ /^ECDHE.ECDS/i);
        $weight  = 29 if ($cipher =~ /^(?:DHE|EDH)/i);
        $weight  = 39 if ($cipher =~ /^ECDH[_-]/i);
        $weight  = 59 if ($cipher =~ /^(?:DES|RC)/i);
        $weight  = 69 if ($cipher =~ /^EXP/i);
        $weight  = 89 if ($cipher =~ /^A/i);    # NOTE: must be before ^AEC
        $weight  = 79 if ($cipher =~ /^AEC/i);  # NOTE: must be after ^A
        $weight  = 99 if ($cipher =~ /^NULL/i);
        $weight -= 10 if ($cipher =~ /^TLS_/);  # some TLSv1.3 start with TLS_*
        $weight -= 10 if ($cipher =~ /^TLS13-/);# some TLSv1.3 start or TLS13_*
        $weight -= 5  if ($cipher =~ /SHA512$/);
        $weight -= 4  if ($cipher =~ /SHA384$/);
        $weight -= 3  if ($cipher =~ /SHA256$/);
        $weight -= 3  if ($cipher =~ /SHA128$/);
        $weight -= 2  if ($cipher =~ /256.SHA$/);
        $weight -= 1  if ($cipher =~ /128.SHA$/);
        $weight -= 3  if ($cipher =~ /CHACHA/);
        $weight -= 2  if ($cipher =~ /256.GCM/);
        $weight -= 1  if ($cipher =~ /128.GCM/);
        # TODO: need to "rate"  -CBC- and -RC4- and -DSS-
        push(@tmp_arr, "$sec_owasp $weight $key"); #  $cipher ${$line}[0] ${$line}[2]");
    }
    foreach my $line (sort @tmp_arr) {  # sorts according $sec_owasp
        my @arr = split(" ", $line);
        push(@sorted, $arr[2]);
    }
    return @sorted;
} # sort_results


#_____________________________________________________________________________
#____________________________________________________ internal test methods __|

sub show_getter03   {
    #? show hardcoded example for all getter functions for key 0x03000003 (aka 0x00,0x03)
    _v_print((caller(0))[3]);
#   0x00,0x03	RSA  40   N    RC4  RSA(512) MD5  4346,6347  0    WEAK SSLv3  export
#   0x00,0x03   EXP-RC4-MD5    RSA_RC4_40_MD5
# C,0x00,0x03   RSA_EXPORT_WITH_RC4_40_MD5

    my $cipher = "0x00,0x03";       # 0x03000003
    $cipher = text2key("0x00,0x03");# normalize cipher key
    printf("# testing example: $cipher (aka 0x00,0x03) ...\n");
    printf("# %s(%s)\t%s\t%-14s\t# %s\n", "function", "cipher key", "key", "value", "(expected)");
    printf("#----------------------+-------+----------------+---------------\n");
    #printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_dtls",  $cipher, "dtls", get_dtls( $cipher), "N");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_bits",  $cipher, "bits", get_bits( $cipher), "40");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_enc",   $cipher, "enc",  get_enc(  $cipher), "RC4");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_keyx",  $cipher, "keyx", get_keyx( $cipher), "RSA(512)");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_auth",  $cipher, "auth", get_auth( $cipher), "RSA");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_mac",   $cipher, "mac",  get_mac(  $cipher), "MD5");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_rfc",   $cipher, "rfc",  get_rfc(  $cipher), "4346,6347");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_sec",   $cipher, "sec",  get_sec(  $cipher), "WEAK");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_ssl",   $cipher, "ssl",  get_ssl(  $cipher), "SSLv3");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_notes", $cipher, "tags", get_notes($cipher), "export");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_name",  $cipher, "name", get_name( $cipher), "EXP-RC4-MD5");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_iana",  $cipher, "iana", get_iana( $cipher), "no");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_pfs",   $cipher, "pfs",  get_iana( $cipher), "no");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_encsize",$cipher,"encsize", get_encsize( $cipher), "-");
    printf("%-8s %s\t%s\t%-14s\t# %s\n", "get_data",  $cipher, "data", get_data( $cipher), "WEAK WEAK SSLv3 RSA(512) RSA RC4 40 MD5 4346,6347 EXP-RC4-MD5 RSA_WITH_RC4_40_MD5,RSA_RC4_40_MD5,RSA_EXPORT_WITH_RC4_40_MD5,RC4_128_EXPORT40_WITH_MD5 export");
    printf("#----------------------+-------+----------------+---------------\n");
    return;
} # show_getter03

sub show_getter     {
    #? show example for all getter functions for specified cipher key
    my $key = shift;
    _v_print((caller(0))[3]);
    if ($key !~ m/^[x0-9a-fA-F,]+$/) {   # no cipher given, print hardcoded example
        printf("# unknown cipher key '$key'; using hardcoded default instead\n");
        show_getter03;
        return;
    }
    print "= testing: $key ...\n";
    $key = text2key($key);    # normalize cipher key
    if (not defined $ciphers{$key}) {
        _warn("511: undefined cipher '$key'");
        return;
    }
    printf("= %s(%s)\t%s\t%s\n", "function", "cipher key", "key", "value");
    printf("=----------------------+-------+----------------\n");
    #printf("%-8s %s\t%s\t%s\n", "get_dtls",  $key, "dtls",  get_dtls( $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_bits",  $key, "bits",  get_bits( $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_enc",   $key, "enc",   get_enc(  $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_keyx",  $key, "keyx",  get_keyx( $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_auth",  $key, "auth",  get_auth( $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_mac",   $key, "mac",   get_mac(  $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_rfc",   $key, "rfc",   get_rfc(  $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_sec",   $key, "sec",   get_sec(  $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_ssl",   $key, "ssl",   get_ssl(  $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_name",  $key, "name",  get_name( $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_names", $key, "names", get_names($key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_const", $key, "const", get_const($key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_const", $key, "const", get_const($key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_note",  $key, "note",  get_note( $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_notes", $key, "notes", get_notes($key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_iana",  $key, "iana",  get_iana( $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_pfs",   $key, "pfs",   get_iana( $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_encsize",$key, "encsize", get_encsize( $key) );
    printf("%-10s(%s)\t%s\t%s\n", "get_data",  $key, "data",  get_data( $key) );
    printf("=----------------------+-------+----------------\n");
    return;
} # show_getter

sub show_description {
    #? print textual description for columns %ciphers hash
    _v_print((caller(0))[3]);
    local $\ = "\n";
    print "
=== internal data structure: overview of %ciphers ===
";

    my $hex = '0x0300003D'; # our sample
    my $idx = 0;
    print ("= %ciphers : example line:\n");
    # we should get the example $ciphers_desc{sample}
    printf("  '$hex' -> ["); # TODO 0x00,0x3D
    foreach (@{$ciphers_desc{head}}) {
        printf("\t%s", $ciphers_desc{sample}->{$hex}[$idx]);
        $idx++;
    }
    print (" ]");
    print ("\n= %ciphers : tabular description of above (example) line:\n");
    print ("=-------+--------------+-----------------------+--------");
    printf("= [%s]\t%15s\t%16s\t%s\n", "nr", "key", "description", "example");
    print ("=-------+--------------+-----------------------+--------");
    $idx = 0;
    foreach (@{$ciphers_desc{head}}) {
        my $txt = $ciphers_desc{$ciphers_desc{head}[$idx]}; # quick dirty
        printf("  [%s]\t%15s\t%-20s\t%s\n", $idx, $ciphers_desc{head}[$idx],
            $txt, $ciphers_desc{sample}->{$hex}[$idx]);
        $idx++;
    }
    printf("=-------+--------------+-----------------------+--------");

    print ("\n\n= %ciphers : description of one line as Perl code:\n");
    print ("=------+--------------------------------+---------------+---------------");
    printf("= varname  %-23s\t# example result# description\n", "%ciphers hash");
    print ("=------+--------------------------------+---------------+---------------");
    $idx = 0;
    foreach my $col (@{$ciphers_desc{head}}) {
        my $var = $ciphers_desc{head}[$idx];    # quick dirty
        my $txt = $ciphers_desc{$var};
        printf("%6s = \$ciphers{'%s'}{%s};\t# %-7s\t# %s\n",
            '$' . $var, $hex, $col, $ciphers_desc{sample}->{$hex}[$idx], $txt);
        $idx++;
    }
    print ("= additional following methods are available:");
    printf("%6s = \$ciphers{'%s'}{%s};\t# %-7s\t# %s\n",
            '$' . 'name', $hex, 'name', 'AES256-SHA256', $ciphers_desc{'name'});
    printf("%6s = \$ciphers{'%s'}{%s};\t# %-7s\t# %s\n",
            '$' . 'alias', $hex, 'alias', 'Alias', $ciphers_desc{'names'});
    print ("=------+--------------------------------+---------------+---------------");

    print  "\n= \%cipher_results : description of hash:\n";
# currently (12/2015)
    print ("=-------------------------------------------+-------");
    print ("=           %hash{  ssl   }->{'cipher key'} = value;");
    print ("=-------------------------------------------+-------");
    print ("  %cipher_results{'TLSv12'}->{'0x0300003D'} = 'yes';"); # AES256-SHA256
    print ("  %cipher_results{'SSLv3'} ->{'0x02FF0810'} = 'no'; "); # NULL-NULL
    print ("=-------------------------------------------+-------");

    return;
} # show_description

sub show_sorted     {
    #? print %ciphers sorted according strength
    _v_print((caller(0))[3]);
    local $\ = "\n";
    my $head = "= OWASP openssl self    IANA    cipher suite";
    my $line = "=------+-------+-------+-------+----------------------------------------------";
    print << 'EoT';

=== internal data structure: ciphers sorted according strength ===
=
= Show overview of all available ciphers sorted according OWASP scoring.
=
=   description of columns:
=       OWASP       - OWASP scoring (A, B, C, D)
=       openssl     - strength given bei OpenSSL
=       self        - strength according own rules
=       IANA        - "yes" if recommended by IANA
=       cipher suite- OpenSSL suite name
EoT
    print ($line);
    print ($head);
    print ($line);
    my @sorted;
    my @unsorted;
    push(@unsorted, get_name($_)) foreach sort keys %ciphers;
    foreach my $c (sort_names(@unsorted)) {
        my $key = get_key($c);
        push(@sorted, sprintf("%4s\t%s\t%s\t%s\t%s",
                               get_cipher_owasp($c), get_openssl($key),
                               get_sec($key), get_iana($key), $c
            ));
    }
    print foreach sort @sorted;
    print ($line);
    print ($head);
    printf("=\n");
    printf("= %4s sorted ciphers\n",  scalar @sorted);
    printf("= %4s ignored ciphers\n", ((keys %ciphers) - (scalar @sorted)));
    return;
} # show_sorted

sub show_overview   {
    #? print overview of internal checks about %ciphers
    _v_print((caller(0))[3]);
    local $\ = "\n";
    print << 'EoT';

=== internal data structure: information about ciphers ===
=
= This function prints a simple overview of all available ciphers. The purpose
= is to show if the internal data structure provides all necessary data.
=
=   description of columns:
=       key         - hex key for cipher suite
=       security    - cipher suite security is known
=       name        - cipher suite (OpenSSL) name exists
=       aliases     - cipher suite has other kown cipher suite names
=       const       - cipher suite constant name exists
=       cipher suite- cipher suite name (OpenSSL)
=   description of values:
=       *    value present (also if None or for pseudo ciphers)
=       -    value missing
=       -?-  security unknown/undefined
=       miss security missing in data structure
=
= No Perl or other warnings should be printed.
= Note: following columns should have a  *  in columns
=       security, name, const
EoT

    my $line = sprintf("=%s+%s+%s+%s+%s+%s", "-" x 14, "-"x 7, "-" x 7, "-" x 7, "-" x 7, "-" x 21);
    my $head = sprintf("= %-13s%s\t%s\t%s\t%s\t%s", "key", "security", "name", "aliases", "const", "cipher suite");
    print($line);
    print($head);
    print($line);
    my %err;    # count incomplete settings
    my $cnt = 0;
    foreach my $key (sort keys %ciphers) {
         $cnt++;
         my $sec    = $ciphers{$key}->{'sec'};
         my $name   = "-";
         my $alias  = "-";
         my $const  = "-";
         my $cipher = $ciphers{$key}->{'names'}[0];
         # TODO: compare direct access of %cipher* with results of method get_*
         $sec   = "*" if ($sec =~ m/None|weak|low|medium|high/i); # TODO: $cfg{'regex'}->{'security'}/i);
         $sec   = "-" if ($sec ne "*" and $sec ne "-?-"); # anything else is -
         $name  = "*" if $ciphers{$key}->{'names'}[0] ne "";
         $alias = "*" if $ciphers{$key}->{'names'}    ne "-";
         $const = "*" if $ciphers{$key}->{'const'}[0] ne "";
         printf("%12s\t%s\t%s\t%s\t%s\t%s\n", $key, $sec, $name, $alias, $const, $cipher);
         $err{'security'}++ if ('*' ne $sec );
         $err{'name'}++     if ('*' ne $name);
         $err{'const'}++    if ('*' ne $const);
         $err{'aliases'}++  if ('*' ne $alias);
    }
    print($line);
    print($head);
    printf("=\n= %s ciphers\n", $cnt);
    printf("= identified errors: ");
    printf("%6s=%-2s,", $_, $err{$_}) foreach sort keys %err;
    printf("\n");
    return;
} # show_overview

sub show_all_names  {
    #? show aliases, constants or RFCs for cipher suite names depending on $type
    #  $type: name | const | rfc
    my $type = shift;
    _v_print((caller(0))[3]);
    my $text = $type;
       $text = "name"     if $type =~ /names/;  # lazy check
       $text = "constant" if $type =~ /const/;  # lazy check
       $text = "RFC"      if $type =~ /rfc/;    #
    my $txt_cols = 
"=       cipher name - (most common) cipher suite $text
=       alias names - known aliases for cipher suite $text";
       $txt_cols =
"=       cipher name - cipher suite name as used in openssl
=       RFC         - RFC numbers, where cipher suite is described" if ("rfc" eq $type);
    local $\ = "\n";
    print "
=== internal data structure: overview of various cipher suite ${text}s ===
=
=   description of columns:
=       key         - hex key for cipher suite
$txt_cols
";
    my $line = sprintf("=%s+%s+%s\n", "-" x 14, "-" x 39, "-" x 31);
    printf("$line");
    printf("= %-13s\t%-37s\t%s\n", "key", "cipher name", "$text  names");
    printf("$line");
    foreach my $key (sort keys %ciphers) {
        my @names   = [];
        my $name    = "";
        if ('rfc' eq $type) {
            $name   = $ciphers{$key}->{'names'}[0];
            my $rfc = $ciphers{$key}->{'rfc'};
            next if "-" eq $rfc;
            @names  = $rfc;
        } else {
            @names  = @{$ciphers{$key}->{$type}};
            $name   = shift @names;
            next if 1 > scalar @names;
        }
        printf("%s\t%-37s\t@names\n", $key, $name);
    }
    printf("$line");
    printf("= %-13s\t%-37s\t%s\n", "key", "cipher name", "alias names");
    return;
} # show_all_names

sub show_ssltest    {
    #? print internal list of ciphers in format like ssltest
    # %ciphers are sorted by protocol and name  # SEE Note:Testing, sort
    _v_print((caller(0))[3]);
    my $last_k  = "";
    foreach my $key (sort { $ciphers{$a}->{ssl}   cmp $ciphers{$b}->{ssl} ||
                            $ciphers{$a}->{names} cmp $ciphers{$b}->{names}
                          } keys %ciphers) {
        if ($last_k ne $ciphers{$key}->{ssl}) {
            $last_k =  $ciphers{$key}->{ssl};
            printf("%s Ciphers Supported...\n", $ciphers{$key}->{ssl});
        }
        my $name    = $ciphers{$key}->{'names'}[0]; # special value
        my $auth =  $ciphers{$key}->{auth};
           $auth =  "No" if ($auth =~ /none/i);
        my $keyx =  $ciphers{$key}->{keyx};
           $keyx =~ s/[()]//g;
        my $bits =  $ciphers{$key}->{bits};
        if ($bits =~ m/\d+/) {
           $bits =  sprintf("%03d", $ciphers{$key}->{bits});
        } else {
           $bits =  "-?-";
           $bits =  "000" if ($ciphers{$key}->{enc} =~ m/None/i);
        }
#   NULL-MD5, None 000 bits, No Auth, MD5 MAC, RSA512 Kx
        printf("   %s, %s %s bits, %s Auth, %s MAC, %s Kx\n", $name,
                $ciphers{$key}->{enc}, $bits, $auth, $ciphers{$key}->{mac}, $keyx);
    }
    return;
} # show_ssltest

sub show_ciphers    {   ## no critic qw(Subroutines::ProhibitExcessComplexity)
    #? print internal list of ciphers in specified format
    my $format = shift;
    _v_print((caller(0))[3]);
    local $\ = "\n";
    if ($format !~ m/(?:dump|full|osaft|openssl|simple|show)/) {
        _warn("520: unknown format '$format'");
        return;
    }

    my $out_header  = 1;
    my $txt_head    = "";
    if ($format eq "openssl") { # like 'openssl ciphers'
        print join(":", get_names_list());
        return;
    }
    if ($format =~ m/openssl/) {
        print << "EoT";
= Output is similar (order of columns) but not identical to result of
= 'openssl ciphers -[vV]' command.
EoT
        $out_header = 0;
        $txt_head   = "";
    } else {
        my $idx = 0;
        foreach (@{$ciphers_desc{head}}) {  # build description from %ciphers_desc
            my $txt = $ciphers_desc{$ciphers_desc{head}[$idx]}; # quick dirty
            $txt_head .= sprintf("=      %-12s - %s\n", $ciphers_desc{head}[$idx], $txt);
            $idx++;
        }
    }

    my @columns = @{$ciphers_desc{head}}; # cannot be used because we want specific order
    @columns = qw(openssl sec ssl keyx auth enc bits mac rfc names const notes) if ($format =~ m/^(?:dump|full|osaft)/);
    @columns = qw(ssl keyx auth enc bits mac)     if ($format =~ m/^(?:openssl)/);
    @columns = qw(ssl keyx auth enc bits mac sec) if ($format =~ m/^(?:show)/);
    @columns = qw(sec ssl keyx auth enc bits mac) if ($format =~ m/^(?:simple)/);

    # table head
    my $line    = sprintf("=%s\n", "-" x 77 );
    my $head    = "";
    if ($format =~ m/^(?:dump|full|osaft)/) {
# 0x02000000    weak   SSLv2   RSA(512) RSA    None    Mac     -?-     NULL-MD5 NULL_WITH_MD5 -
        $line = sprintf("=%9s%s%s\n", "-" x 14, "+-------" x 9, "+---------------" x 3 );
        $head = sprintf("= %-13s\t%9s\n", "key",    join("\t", @columns));
    }
    if ($format =~ m/^(?:show)/) {
# 0x02000000    SSLv2   RSA(512) RSA    None   0       Mac     weak     NULL-MD5
        $line = sprintf("=%s%s+%s\n", "-" x 14, "+-------" x 7, "-" x 15 );
        $head = sprintf("= %-13s\t%s\t%s\n", "key", join("\t", @columns), "cipher name");
    }
    if ($format =~ m/^(?:simple)/) {
# 0x02000000    weak SSLv2 RSA(512) RSA None 0 Mac NULL-MD5
        # no fomated header just a line
        $head = sprintf("= %-13s\t%s\t%s\n", "key", join(" ",  @columns), "cipher name");
    }
    if ($format =~ m/^openssl-V/) {
#         0x00,0x3D - AES256-SHA256           TLSv1.2 Kx=RSA      Au=RSA  Enc=AES(256)  Mac=SHA256
#    0x00,0x00,0x00 - NULL-MD5                SSLv2   Kx=RSA(512) Au=RSA  Enc=None(0)   Mac
        $line = sprintf("=%s+%s+%s+%s+%s+%s+%s\n",
               "-" x 19, "-" x 24, "-" x 5, "-" x 11, "-" x 7, "-" x 11, "-" x 7 );
        $head = sprintf("=% 18s - %-23s %-5s %-11s %-7s %-11s %s\n",
               "key", "name", @columns[0..2], "enc(bit)", "mac");
    }
    if (0 < $out_header) {
        printf("%s", << "EoT"); # printf to avoid trailing \n

=== internal %ciphers data ===
=
= Show a full overview of all available ciphers.
=
=   description of columns (if available):
=      key          - internal hex key for cipher suite
=      hex          - hex key for cipher suite (like openssl)
=      cipher name  - OpenSSL suite name
$txt_head
EoT
       printf($line);
       printf($head);
       printf($line);
    }

    # table data (format should be same as for table head above)
    my $cnt = 0;
    foreach my $key (sort keys %ciphers) {
        $cnt++;
        my $hex     = key2text($key);   # 0x02010080 --> 0x01,0x00,0x80
        my $name    = $ciphers{$key}->{'names'}[0]; # special value
        my $const   = $ciphers{$key}->{'const'}[0]; # special value
        my $note    = $ciphers{$key}->{'notes'}[0]; # special value
        my @values;
        if ($format =~ m/^(?:dump|full|osaft)/) {
            push(@values, $key);
            push(@values, $ciphers{$key}->{$_}) foreach @columns[0..8];
           #push(@values, join(",", @{$ciphers{$key}->{$_}})) foreach @columns[9..11];
            push(@values, join(",", @{$ciphers{$key}->{names}}));
            push(@values, join(",", @{$ciphers{$key}->{const}}));
            push(@values, join(",", @{$ciphers{$key}->{notes}}));
            printf("%s\n", join("\t", @values));
        }
        if ($format =~ m/^(?:show)/) {
            push(@values, $key);
            push(@values, $ciphers{$key}->{$_}) foreach @columns;
            push(@values, $name);
            printf("%s\n", join("\t", @values));
        }
        if ($format =~ m/^(?:simple)/) {
            push(@values, $ciphers{$key}->{$_}) foreach @columns;
            push(@values, $name);
            printf("%s\t%s\n", $key, join(" ", @values));
        }
        if ($format =~ m/^(?:openssl-v)/) {
            push(@values, $name);
            push(@values, $ciphers{$key}->{$_}) foreach @columns;
            printf("%-23s %-6s Kx=%-8s Au=%-4s Enc=%s(%s) Mac=%s\n", @values);
        }
        if ($format =~ m/^(?:openssl-V)/) {
            push(@values, $hex, $name);
            push(@values, $ciphers{$key}->{$_}) foreach @columns;
            printf("%19s - %-23s %-6s Kx=%-8s Au=%-4s Enc=%s(%s) Mac=%s\n", @values);
        }
    } # keys

    # table footer
    if (0 < $out_header) {
        printf($line);
        printf($head);
        printf("=\n= %s ciphers\n", $cnt);
    }
    return;
} # show_ciphers

sub show            {   ## no critic qw(Subroutines::ProhibitExcessComplexity)
    #? dispatcher for various --test-cipher-* options; show information
    my $arg = shift;    # any --test-cipher-*
       $arg =~ s/^--test[._-]?ciphers?[._-]?//;   # normalize
    _v_print((caller(0))[3]);
    #_dbx("arg=$arg");
    local $\ = "\n";
    return                  if ($arg =~ m/^version/i            ); # done in main
    show_all_names('const') if ($arg eq 'constants'             );
    show_all_names('names') if ($arg eq 'aliases'               );
    show_all_names('rfc')   if ($arg eq 'rfcs'                  );
    show_description()      if ($arg eq 'description'           );
    show_description()      if ($arg =~ m/^ciphers.?description/);
    show_overview()         if ($arg eq 'overview'              );
    show_ssltest()          if ($arg eq 'ssltest'               );
    show_sorted()           if ($arg =~ m/^(owasp|sort(?:ed)?)/ );
        ## no critic qw(RegularExpressions::ProhibitCaptureWithoutTest)
    show_ciphers($1)        if ($arg =~ m/^(dump|full|osaft|openssl(?:-[vV])?|show|simple)/);
    show_getter($1)         if ($arg =~ m/^getter=?(.*)/        );
    print text2key($1)      if ($arg =~ m/^text2key=(.*)/       );
    print key2text($1)      if ($arg =~ m/^key2text=(.*)/       );
    print get_key($1)       if ($arg =~ m/^(?:get.)?key=(.*)/   );
    print get_sec($1)       if ($arg =~ m/^(?:get.)?sec=(.*)/   );
    print get_ssl($1)       if ($arg =~ m/^(?:get.)?ssl=(.*)/   );
    print get_keyx($1)      if ($arg =~ m/^(?:get.)?keyx=(.*)/  );
    print get_auth($1)      if ($arg =~ m/^(?:get.)?auth=(.*)/  );
    print get_enc($1)       if ($arg =~ m/^(?:get.)?enc=(.*)/   );
    print get_bits($1)      if ($arg =~ m/^(?:get.)?bits=(.*)/  );
    print get_mac($1)       if ($arg =~ m/^(?:get.)?mac=(.*)/   );
    print get_rfc($1)       if ($arg =~ m/^(?:get.)?rfc=(.*)/   );
    print get_name($1)      if ($arg =~ m/^(?:get.)?name=(.*)/  );
    print get_const($1)     if ($arg =~ m/^(?:get.)?const=(.*)/ );
    print get_note($1)      if ($arg =~ m/^(?:get.)?note=(.*)/  );
    print get_openssl($1)   if ($arg =~ m/^(?:get.)?openssl=(.*)/);
    print get_encsize($1)   if ($arg =~ m/^(?:get.)?encsize=(.*)/);
    print get_iana($1)      if ($arg =~ m/^(?:get.)?iana=(.*)/  );
    print get_pfs($1)       if ($arg =~ m/^(?:get.)?pfs=(.*)/   );
    print find_name($1)     if ($arg =~ m/^find.?name=(.*)/     );
    # enforce string value for returned arrays
    print join(" ", find_names($1))     if ($arg =~ m/^find.?names=(.*)/     );
    print join(" ", find_keys($1))      if ($arg =~ m/^find.?keys=(.*)/      );
    print join(" ", get_names($1))      if ($arg =~ m/^(?:get.)?names=(.*)/  );
    print join(" ", get_aliases($1))    if ($arg =~ m/^(?:get.)?aliases=(.*)/);
    print join(" ", get_consts($1))     if ($arg =~ m/^(?:get.)?consts=(.*)/ );
    print join(" ", get_notes($1))      if ($arg =~ m/^(?:get.)?notes=(.*)/  );
    print join(" ", get_keys_list())    if ($arg =~ m/^(?:get.)?keys.?list/  );
    print join(" ", get_names_list())   if ($arg =~ m/^(?:get.)?names.?list/ );
    if ($arg =~ m/^regex/) {
        printf("#$0: direct testing not yet possible here, please try:\n   o-saft.pl --test-ciphers-regex\n");
    }
    return;
} # show

#_____________________________________________________________________________
#___________________________________________________ initialisation methods __|

sub _ciphers_init   {
    #? initialisations of %cihers data structures from <DATA>
    # example:   #0     #1      #2      #3      #4          #5      #6      #7 ...
    #     0x02020080    WEAK    WEAK    SSLv2   RSA(512)    RSA     RC4     40    MD5    -?-    EXP-RC4-MD5    RC4_128_EXPORT40_WITH_MD5    EXPORT
    my $du = *DATA; # avoid Perl warning "... used only once: possible typo ..."
       $du = *main::DATA; # ...
    my $fh = *DATA;
       $fh = *main::DATA if (0 < $::osaft_standalone);  # SEE Note:Stand-alone
    while (my $line = <$fh>) {
        chomp $line;
        next if ($line =~ m/^\s*$/);
        next if ($line =~ m/^\s*#/);
        last if ($line =~ m/__END/);
        my @fields = split(/\t/, $line);
        my $len    = $#fields;
        my $key    = $fields[0];
        if ($key  !~ /^0x[0-9A-F]{8}/) {
            _warn(sprintf("504: DATA line%4d: wrong hex key '%s'", $., $key));
            next;
        }
        if (13 != $len+1) {
            _warn(sprintf("505: DATA line%4d: wrong number of TAB-separated fields '%s' != 13\n", $., $len));
            next;
        }
        # now loop over @fields, but assign each to the hash; keys see %ciphers_desc
        $ciphers{$key}->{'openssl'} = $fields[1]  || '';
        $ciphers{$key}->{'sec'}     = $fields[2]  || '';
        $ciphers{$key}->{'ssl'}     = $fields[3]  || '';
        $ciphers{$key}->{'keyx'}    = $fields[4]  || '';
        $ciphers{$key}->{'auth'}    = $fields[5]  || '';
        $ciphers{$key}->{'enc'}     = $fields[6]  || '';
        $ciphers{$key}->{'bits'}    = ($fields[7] || '0 '); # our values are strings, but perl cast to int, which renders 0 as ''; ugly, very ugly hack
        $ciphers{$key}->{'mac'}     = $fields[8]  || '';
        $ciphers{$key}->{'rfc'}     = $fields[9]  || '';
        @{$ciphers{$key}->{'names'}}= split(/,/, $fields[10]);
        @{$ciphers{$key}->{'const'}}= split(/,/, $fields[11]);
        @{$ciphers{$key}->{'notes'}}= split(/,/, $fields[12]);
       #$ciphers{$key}->{'suite'}   = # is first in $fields[10], 
    }
    return;
} # _ciphers_init

#_____________________________________________________________________________
#_____________________________________________________________________ main __|

sub _main_ciphers_usage {
    #? print usage
    my $name = (caller(0))[1];
    print "# commands to show internal cipher tables:\n";
    foreach my $cmd (qw(alias const dump description openssl rfc simple sort overview )) {
        printf("\t%s %s\n", $name, $cmd);
    }
    print "# commands to show cipher data:\n";
    foreach my $cmd (qw(key=CIPHER-NAME getter=KEY)) {
        printf("\t%s %s\n", $name, $cmd);
    }
    print "# various commands (examples):\n";
    printf("\t$name version\n");
    printf("\t$name getter=0x0300CCA9\n");  # avoid: Possible attempt to separate words with commas at ...
    foreach my $cmd (qw(key=ECDHE-ECDSA-CHACHA20-POLY1305-SHA256 )) {
        printf("\t%s %s\n", $name, $cmd);
    }
    print "#\n# all commands can also be used as '--test-ciphers-CMD\n";
    return;
} # _main_ciphers_usage

sub _main_ciphers   {
    #? print own documentation or special required one
    ## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
    #  see t/.perlcriticrc for detailed description of "no critic"
    my @argv = @_;
    #  SEE Perl:binmode()
    binmode(STDOUT, ":unix:utf8");
    binmode(STDERR, ":unix:utf8");
    print_pod($0, __PACKAGE__, $SID_ciphers)     if (0 > $#argv);
    # got arguments, do something special
    while (my $arg = shift @argv) {
        print_pod($0, __PACKAGE__, $SID_ciphers) if ($arg =~ m/^--?h(?:elp)?$/); # print own help
        _main_ciphers_usage()      if ($arg eq '--usage');
        # ----------------------------- options
        $cfg{'verbose'}++          if ($arg eq '--v');
        # ----------------------------- commands
        print "$SID_ciphers\n"     if ($arg =~ /^version$/);
        print "$VERSION\n"         if ($arg =~ /^[-+]?V(ERSION)?$/);
        print "$VERSION\n"         if ($arg =~ /^--test.?ciphers.?version/i);
        # allow short option without --test-ciphers- prefix
        $arg =~ s/^--test.?ciphers.?//; # remove if there
        show("--test-ciphers-$arg");
    }
    exit 0;
} # _main_ciphers

sub ciphers_done    {}; # dummy to check successful include

_ciphers_init();

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

=pod

=head1 COMMANDS

If called from command line, like

  OSaft/Ciphers.pm [OPTIONS ..] [COMMANDS]

this modules provides following commands:

=over 4

=item version

- just print the module's version

=item description

- print description of all data structures

=item overview

- print overview of various (internal) checks according cipher definitions

=item aliases

- print overview of known cipher suite names

=item constants

- print overview of known cipher suite constant names

=item rfcs

- print overview of cipher suites and corresponding RFCs

=item dump

- print internal lists of ciphers (all data, internal format)

=item show

- print internal lists of ciphers (simple human readable format)

=item simple

- print internal lists of ciphers (simple space-separated format)

=item sorted

- print internal lists of ciphers (sorted according OWASP scoring)

=item openssl

- print internal lists of ciphers (format like "openssl ciphers -V")

=item ssltest

- print internal lists of ciphers (format like "ssltest --list")

=item getter

- print example for all getter functions for specified cipher key

=back

All commands can be used with or without '+' prefix, for example 'dump' is same
as '+dump'. They can also be used with '--test-ciphers-' perfix, for example:
'--test-ciphers-show'.

=over 4

=item get_METHOD=HEX

- print cipher suite value for 'METHOD', for valid 'get_METHOD' see  METHODS  above

=item find_keys=CIPHER-SUITE

- print cipher suite internal key for matching cipher names 'CIPHER-SUITE'

=item find_names=CIPHER-SUITE

- print cipher suite names for matching cipher names 'CIPHER-SUITE'

=back


=head1 OPTIONS

=over 4

=item --usage

- print usage for L<COMMANDS> of CLI mode

=item --v

- print verbose messages (in CLI mode only), must precede all commands

=back


=head1 NOTES

It's often recommended not to export constants and variables from modules, see
for example  http://perldoc.perl.org/Exporter.html#Good-Practices . The main
purpose of this module is defining variables. Hence we export them.


=head1 SEE ALSO

# ...


=head1 VERSION

2.80 2022/11/17


=head1 AUTHOR

28-may-16 Achim Hoffmann

=cut

## PACKAGE }
} # OSaft/Ciphers.pm

{ # OSaft/Data.pm
## PACKAGE {

#!# Copyright (c) 2022, Achim Hoffmann
#!# This  software is licensed under GPLv2. Please see o-saft.pl for details.

package OSaft::Data;


use warnings;

my  $SID_data   =  "@(#) Data.pm 1.9 22/11/06 12:21:32";
our $VERSION    =  "22.06.22";

BEGIN {
    # SEE Perl:@INC
    # SEE Perl:BEGIN perlcritic
    my $_me   = $0;     $_me   =~ s#.*[/\\]##x;
    my $_path = $0;     $_path =~ s#[/\\][^/\\]*$##x;
    unshift(@INC, $_path)   if (1 > (grep{/^$_path$/} @INC));
    unshift(@INC, "..")     if (1 > (grep{/^\.\.$/}   @INC));
    unshift(@INC, ".")      if (1 > (grep{/^\.$/}     @INC));
}

#-# use OSaft::Text qw(print_pod);

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

=pod

=encoding utf8


=head1 _____________________________________________________________________________

=head1 NAME

OSaft::Data -- common SSL/TLS-connection data for O-Saft and related tools


=head1 DESCRIPTION

Utility package for O-Saft (o-saft.pl and related tools).  It declares and
defines common  L</VARIABLES>  to be used in the calling tool.
All variables and methods are defined in the  OSaft::Data  namespace.


=head1 SYNOPSIS

=over 2

=item use OSaft::Data;          # in perl code

=item OSaft/Data.pm --help      # on command-line will print help

=item OSaft/Data.pm data        # show content of %data

=item OSaft/Data.pm checks      # show content of %checks

=item OSaft/Data.pm check_cert  # show content of %check_cert

=item OSaft/Data.pm check_conn  # show content of %check_conn

=item OSaft/Data.pm check_http  # show content of %check_http

=item OSaft/Data.pm check_dest  # show content of %check_dest

=item OSaft/Data.pm check_size  # show content of %check_size

=item OSaft/Data.pm shorttexts  # show content of %shorttexts

=back


=head1 OPTIONS

=over 4

=item --help

=back


=head1 VARIABLES

=over 4

=item %checks

Computed checks.

=item %check_cert

Collected and checked certificate data.

=item %check_conn

Collected and checked connection data.

=item %check_dest

Collected and checked target (connection) data.

=item %check_http

Collected HTTP and HTTPS data.

=item %check_size

Collected and checked length and count data.

=item %data

Data from connection and certificate details.

=item %data0

Same as %data with 'val' only. Contains values from first connection only.

=item %info

Same as %data with values only.

=item %shorttexts

=back

=cut

#_____________________________________________________________________________
#________________________________________________ public (export) variables __|

# SEE Perl:perlcritic
## no critic qw(Variables::ProhibitPackageVars)

use Exporter qw(import);
use base     qw(Exporter);
our @EXPORT_OK  = qw(
        %checks
        %check_cert
        %check_conn
        %check_dest
        %check_http
        %check_size
        %data
        %data0
        %info
        %shorttexts
        data_done
);

# NOTE: do not change names of keys in %data and all %check_* as these keys
#       are used in output with --trace-key

# SEE Note:Data Structures
our %info   = (         # keys are identical to %data
    'alpn'          => "",
    'npn'           => "",
    'alpns'         => "",
    'npns'          => "",
);

our %data0  = ();       # same as %data but has 'val' only, no 'txt'
                        # contains values from first connection only

our %data   = (         # connection and certificate details
    # values from Net::SSLinfo, will be processed in print_data()
    #----------------------+-------------------------------------------------------------+-----------------------------------
    # +command                    => value from Net::SSLinfo::*()                               => label to be printed
    #----------------------+-------------------------------------------------------------+-----------------------------------
    'cn_nosni'          => {'val' => "",                                                  'txt' => "Certificate CN without SNI"},
    'pem'               => {'val' => sub { Net::SSLinfo::pem(             $_[0], $_[1])}, 'txt' => "Certificate PEM"},
    'text'              => {'val' => sub { Net::SSLinfo::text(            $_[0], $_[1])}, 'txt' => "Certificate PEM decoded"},
    'cn'                => {'val' => sub { Net::SSLinfo::cn(              $_[0], $_[1])}, 'txt' => "Certificate Common Name"},
    'subject'           => {'val' => sub { Net::SSLinfo::subject(         $_[0], $_[1])}, 'txt' => "Certificate Subject"},
    'issuer'            => {'val' => sub { Net::SSLinfo::issuer(          $_[0], $_[1])}, 'txt' => "Certificate Issuer"},
    'altname'           => {'val' => sub { Net::SSLinfo::altname(         $_[0], $_[1])}, 'txt' => "Certificate Subject's Alternate Names"},
    'cipher_selected'   => {'val' => sub { Net::SSLinfo::selected(        $_[0], $_[1])}, 'txt' => "Selected Cipher"},  # SEE Note:Selected Cipher
    'ciphers_local'     => {'val' => sub { Net::SSLinfo::cipher_openssl()              }, 'txt' => "Local SSLlib Ciphers"},
    'ciphers'           => {'val' => sub { join(" ",  Net::SSLinfo::ciphers($_[0], $_[1]))}, 'txt' => "Client Ciphers"},
    'dates'             => {'val' => sub { join(" .. ", Net::SSLinfo::dates($_[0], $_[1]))}, 'txt' => "Certificate Validity (date)"},
    'before'            => {'val' => sub { Net::SSLinfo::before(          $_[0], $_[1])}, 'txt' => "Certificate valid since"},
    'after'             => {'val' => sub { Net::SSLinfo::after(           $_[0], $_[1])}, 'txt' => "Certificate valid until"},
    'aux'               => {'val' => sub { Net::SSLinfo::aux(             $_[0], $_[1])}, 'txt' => "Certificate Trust Information"},
    'email'             => {'val' => sub { Net::SSLinfo::email(           $_[0], $_[1])}, 'txt' => "Certificate Email Addresses"},
    'pubkey'            => {'val' => sub { Net::SSLinfo::pubkey(          $_[0], $_[1])}, 'txt' => "Certificate Public Key"},
    'pubkey_algorithm'  => {'val' => sub { Net::SSLinfo::pubkey_algorithm($_[0], $_[1])}, 'txt' => "Certificate Public Key Algorithm"},
    'pubkey_value'      => {'val' => sub {  ::__SSLinfo('pubkey_value',   $_[0], $_[1])}, 'txt' => "Certificate Public Key Value"},
    'modulus_len'       => {'val' => sub { Net::SSLinfo::modulus_len(     $_[0], $_[1])}, 'txt' => "Certificate Public Key Length"},
    'modulus'           => {'val' => sub { Net::SSLinfo::modulus(         $_[0], $_[1])}, 'txt' => "Certificate Public Key Modulus"},
    'modulus_exponent'  => {'val' => sub { Net::SSLinfo::modulus_exponent($_[0], $_[1])}, 'txt' => "Certificate Public Key Exponent"},
    'serial'            => {'val' => sub { Net::SSLinfo::serial(          $_[0], $_[1])}, 'txt' => "Certificate Serial Number"},
    'serial_hex'        => {'val' => sub { Net::SSLinfo::serial_hex(      $_[0], $_[1])}, 'txt' => "Certificate Serial Number (hex)"},
    'serial_int'        => {'val' => sub { Net::SSLinfo::serial_int(      $_[0], $_[1])}, 'txt' => "Certificate Serial Number (int)"},
    'certversion'       => {'val' => sub { Net::SSLinfo::version(         $_[0], $_[1])}, 'txt' => "Certificate Version"},
    'sigdump'           => {'val' => sub { Net::SSLinfo::sigdump(         $_[0], $_[1])}, 'txt' => "Certificate Signature (hexdump)"},
    'sigkey_len'        => {'val' => sub { Net::SSLinfo::sigkey_len(      $_[0], $_[1])}, 'txt' => "Certificate Signature Key Length"},
    'signame'           => {'val' => sub { Net::SSLinfo::signame(         $_[0], $_[1])}, 'txt' => "Certificate Signature Algorithm"},
    'sigkey_value'      => {'val' => sub {  ::__SSLinfo('sigkey_value',   $_[0], $_[1])}, 'txt' => "Certificate Signature Key Value"},
    'trustout'          => {'val' => sub { Net::SSLinfo::trustout(        $_[0], $_[1])}, 'txt' => "Certificate trusted"},
    'extensions'        => {'val' => sub {  ::__SSLinfo('extensions',     $_[0], $_[1])}, 'txt' => "Certificate extensions"},
    'tlsextdebug'       => {'val' => sub {  ::__SSLinfo('tlsextdebug',    $_[0], $_[1])}, 'txt' => "TLS extensions (debug)"},
    'tlsextensions'     => {'val' => sub {  ::__SSLinfo('tlsextensions',  $_[0], $_[1])}, 'txt' => "TLS extensions"},
    'ext_authority'     => {'val' => sub {  ::__SSLinfo('ext_authority',  $_[0], $_[1])}, 'txt' => "Certificate extensions Authority Information Access"},
    'ext_authorityid'   => {'val' => sub {  ::__SSLinfo('ext_authorityid',  $_[0], $_[1])}, 'txt' => "Certificate extensions Authority key Identifier"},
    'ext_constraints'   => {'val' => sub {  ::__SSLinfo('ext_constraints',  $_[0], $_[1])}, 'txt' => "Certificate extensions Basic Constraints"},
    'ext_cps'           => {'val' => sub {  ::__SSLinfo('ext_cps',        $_[0], $_[1])}, 'txt' => "Certificate extensions Certificate Policies"},
    'ext_cps_cps'       => {'val' => sub {  ::__SSLinfo('ext_cps_cps',    $_[0], $_[1])}, 'txt' => "Certificate extensions Certificate Policies: CPS"},
    'ext_cps_policy'    => {'val' => sub {  ::__SSLinfo('ext_cps_policy', $_[0], $_[1])}, 'txt' => "Certificate extensions Certificate Policies: Policy"},
    'ext_cps_notice'    => {'val' => sub {  ::__SSLinfo('ext_cps_notice', $_[0], $_[1])}, 'txt' => "Certificate extensions Certificate Policies: User Notice"},
    'ext_crl'           => {'val' => sub {  ::__SSLinfo('ext_crl',        $_[0], $_[1])}, 'txt' => "Certificate extensions CRL Distribution Points"},
    'ext_subjectkeyid'  => {'val' => sub {  ::__SSLinfo('ext_subjectkeyid', $_[0], $_[1])}, 'txt' => "Certificate extensions Subject Key Identifier"},
    'ext_keyusage'      => {'val' => sub {  ::__SSLinfo('ext_keyusage',   $_[0], $_[1])}, 'txt' => "Certificate extensions Key Usage"},
    'ext_extkeyusage'   => {'val' => sub {  ::__SSLinfo('ext_extkeyusage',  $_[0], $_[1])}, 'txt' => "Certificate extensions Extended Key Usage"},
    'ext_certtype'      => {'val' => sub {  ::__SSLinfo('ext_certtype',   $_[0], $_[1])}, 'txt' => "Certificate extensions Netscape Cert Type"},
    'ext_issuer'        => {'val' => sub {  ::__SSLinfo('ext_issuer',     $_[0], $_[1])}, 'txt' => "Certificate extensions Issuer Alternative Name"},
    'ocsp_uri'          => {'val' => sub { Net::SSLinfo::ocsp_uri(        $_[0], $_[1])}, 'txt' => "Certificate OCSP Responder URL"},
    'ocspid'            => {'val' => sub {  ::__SSLinfo('ocspid',         $_[0], $_[1])}, 'txt' => "Certificate OCSP Hashes"},
    'ocsp_subject_hash' => {'val' => sub {  ::__SSLinfo('ocsp_subject_hash',$_[0], $_[1])}, 'txt' => "Certificate OCSP Subject Hash"},
    'ocsp_public_hash'  => {'val' => sub {  ::__SSLinfo('ocsp_public_hash', $_[0], $_[1])}, 'txt' => "Certificate OCSP Public Key Hash"},
    'ocsp_response'     => {'val' => sub { Net::SSLinfo::ocsp_response(   $_[0], $_[1])}, 'txt' => "Target's OCSP Response"},
    'ocsp_response_data'=> {'val' => sub { Net::SSLinfo::ocsp_response_data(     $_[0], $_[1])}, 'txt' => "Target's OCSP Response Data"},
    'ocsp_response_status'=> {'val' => sub { Net::SSLinfo::ocsp_response_status( $_[0], $_[1])}, 'txt' => "Target's OCSP Response Status"},
    'ocsp_cert_status'  => {'val' => sub { Net::SSLinfo::ocsp_cert_status($_[0], $_[1])}, 'txt' => "Target's OCSP Response Cert Status"},
    'ocsp_next_update'  => {'val' => sub { Net::SSLinfo::ocsp_next_update($_[0], $_[1])}, 'txt' => "Target's OCSP Response Next Update"},
    'ocsp_this_update'  => {'val' => sub { Net::SSLinfo::ocsp_this_update($_[0], $_[1])}, 'txt' => "Target's OCSP Response This Update"},
    'subject_hash'      => {'val' => sub { Net::SSLinfo::subject_hash(    $_[0], $_[1])}, 'txt' => "Certificate Subject Name Hash"},
    'issuer_hash'       => {'val' => sub { Net::SSLinfo::issuer_hash(     $_[0], $_[1])}, 'txt' => "Certificate Issuer Name Hash"},
    'selfsigned'        => {'val' => sub { Net::SSLinfo::selfsigned(      $_[0], $_[1])}, 'txt' => "Certificate Validity (signature)"},
    'fingerprint_type'  => {'val' => sub { Net::SSLinfo::fingerprint_type($_[0], $_[1])}, 'txt' => "Certificate Fingerprint Algorithm"},
    'fingerprint_hash'  => {'val' => sub {  ::__SSLinfo('fingerprint_hash', $_[0], $_[1])}, 'txt' => "Certificate Fingerprint Hash Value"},
    'fingerprint_sha2'  => {'val' => sub {  ::__SSLinfo('fingerprint_sha2', $_[0], $_[1])}, 'txt' => "Certificate Fingerprint SHA2"},
    'fingerprint_sha1'  => {'val' => sub {  ::__SSLinfo('fingerprint_sha1', $_[0], $_[1])}, 'txt' => "Certificate Fingerprint SHA1"},
    'fingerprint_md5'   => {'val' => sub {  ::__SSLinfo('fingerprint_md5',  $_[0], $_[1])}, 'txt' => "Certificate Fingerprint  MD5"},
    'fingerprint'       => {'val' => sub {  ::__SSLinfo('fingerprint',      $_[0], $_[1])}, 'txt' => "Certificate Fingerprint"},
    'cert_type'         => {'val' => sub { Net::SSLinfo::cert_type(       $_[0], $_[1])}, 'txt' => "Certificate Type (bitmask)"},
    'sslversion'        => {'val' => sub { Net::SSLinfo::SSLversion(      $_[0], $_[1])}, 'txt' => "Selected SSL Protocol"},
    'resumption'        => {'val' => sub { Net::SSLinfo::resumption(      $_[0], $_[1])}, 'txt' => "Target supports Resumption"},
    'renegotiation'     => {'val' => sub { Net::SSLinfo::renegotiation(   $_[0], $_[1])}, 'txt' => "Target supports Renegotiation"},
    'compression'       => {'val' => sub { Net::SSLinfo::compression(     $_[0], $_[1])}, 'txt' => "Target supports Compression"},
    'expansion'         => {'val' => sub { Net::SSLinfo::expansion(       $_[0], $_[1])}, 'txt' => "Target supports Expansion"},
    'krb5'              => {'val' => sub { Net::SSLinfo::krb5(            $_[0], $_[1])}, 'txt' => "Target supports Krb5"},
    'psk_hint'          => {'val' => sub { Net::SSLinfo::psk_hint(        $_[0], $_[1])}, 'txt' => "Target supports PSK Identity Hint"},
    'psk_identity'      => {'val' => sub { Net::SSLinfo::psk_identity(    $_[0], $_[1])}, 'txt' => "Target supports PSK"},
    'srp'               => {'val' => sub { Net::SSLinfo::srp(             $_[0], $_[1])}, 'txt' => "Target supports SRP"},
    'heartbeat'         => {'val' => sub {   ::__SSLinfo('heartbeat',     $_[0], $_[1])}, 'txt' => "Target supports Heartbeat"},
    'master_secret'     => {'val' => sub { Net::SSLinfo::master_secret(   $_[0], $_[1])}, 'txt' => "Target supports Extended Master Secret"},
#    master_secret  is alias for extended_master_secret, TLS 1.3 and later
    'next_protocols'    => {'val' => sub { Net::SSLinfo::next_protocols(  $_[0], $_[1])}, 'txt' => "Target's advertised protocols"},
#   'alpn'              => {'val' => sub { Net::SSLinfo::alpn(            $_[0], $_[1])}, 'txt' => "Target's selected protocol (ALPN)"}, # old, pre 17.04.17 version
    'alpn'              => {'val' => sub { return $info{'alpn'};                       }, 'txt' => "Target's selected protocol (ALPN)"},
    'npn'               => {'val' => sub { return $info{'npn'};                        }, 'txt' => "Target's selected protocol  (NPN)"},
    'alpns'             => {'val' => sub { return $info{'alpns'};                      }, 'txt' => "Target's supported ALPNs"},
    'npns'              => {'val' => sub { return $info{'npns'};                       }, 'txt' => "Target's supported  NPNs"},
    'master_key'        => {'val' => sub { Net::SSLinfo::master_key(      $_[0], $_[1])}, 'txt' => "Target's Master-Key"},
    'public_key_len'    => {'val' => sub { Net::SSLinfo::public_key_len(  $_[0], $_[1])}, 'txt' => "Target's Server public key length"}, # value reported by openssl s_client -debug ...
    'session_id'        => {'val' => sub { Net::SSLinfo::session_id(      $_[0], $_[1])}, 'txt' => "Target's Session-ID"},
    'session_id_ctx'    => {'val' => sub { Net::SSLinfo::session_id_ctx(  $_[0], $_[1])}, 'txt' => "Target's Session-ID-ctx"},
    'session_protocol'  => {'val' => sub { Net::SSLinfo::session_protocol($_[0], $_[1])}, 'txt' => "Target's selected SSL Protocol"},
    'session_ticket'    => {'val' => sub { Net::SSLinfo::session_ticket(  $_[0], $_[1])}, 'txt' => "Target's TLS Session Ticket"},
    'session_lifetime'  => {'val' => sub { Net::SSLinfo::session_lifetime($_[0], $_[1])}, 'txt' => "Target's TLS Session Ticket Lifetime"},
    'session_timeout'   => {'val' => sub { Net::SSLinfo::session_timeout( $_[0], $_[1])}, 'txt' => "Target's TLS Session Timeout"},
    'session_starttime' => {'val' => sub { Net::SSLinfo::session_starttime($_[0],$_[1])}, 'txt' => "Target's TLS Session Start Time EPOCH"},
    'session_startdate' => {'val' => sub { Net::SSLinfo::session_startdate($_[0],$_[1])}, 'txt' => "Target's TLS Session Start Time locale"},
    'dh_parameter'      => {'val' => sub { Net::SSLinfo::dh_parameter(    $_[0], $_[1])}, 'txt' => "Target's DH Parameter"},
    'chain'             => {'val' => sub { Net::SSLinfo::chain(           $_[0], $_[1])}, 'txt' => "Certificate Chain"},
    'chain_verify'      => {'val' => sub { Net::SSLinfo::chain_verify(    $_[0], $_[1])}, 'txt' => "CA Chain Verification (trace)"},
    'verify'            => {'val' => sub { Net::SSLinfo::verify(          $_[0], $_[1])}, 'txt' => "Validity Certificate Chain"},
    'error_verify'      => {'val' => sub { Net::SSLinfo::error_verify(    $_[0], $_[1])}, 'txt' => "CA Chain Verification error"},
    'error_depth'       => {'val' => sub { Net::SSLinfo::error_depth(     $_[0], $_[1])}, 'txt' => "CA Chain Verification error in level"},
    'verify_altname'    => {'val' => sub { Net::SSLinfo::verify_altname(  $_[0], $_[1])}, 'txt' => "Validity Alternate Names"},
    'verify_hostname'   => {'val' => sub { Net::SSLinfo::verify_hostname( $_[0], $_[1])}, 'txt' => "Validity Hostname"},
    'https_protocols'   => {'val' => sub { Net::SSLinfo::https_protocols( $_[0], $_[1])}, 'txt' => "HTTPS Alternate-Protocol"},
    'https_svc'         => {'val' => sub { Net::SSLinfo::https_svc(       $_[0], $_[1])}, 'txt' => "HTTPS Alt-Svc header"},
    'https_status'      => {'val' => sub { Net::SSLinfo::https_status(    $_[0], $_[1])}, 'txt' => "HTTPS Status line"},
    'https_server'      => {'val' => sub { Net::SSLinfo::https_server(    $_[0], $_[1])}, 'txt' => "HTTPS Server banner"},
    'https_location'    => {'val' => sub { Net::SSLinfo::https_location(  $_[0], $_[1])}, 'txt' => "HTTPS Location header"},
    'https_refresh'     => {'val' => sub { Net::SSLinfo::https_refresh(   $_[0], $_[1])}, 'txt' => "HTTPS Refresh header"},
    'https_alerts'      => {'val' => sub { Net::SSLinfo::https_alerts(    $_[0], $_[1])}, 'txt' => "HTTPS Error alerts"},
    'https_pins'        => {'val' => sub { Net::SSLinfo::https_pins(      $_[0], $_[1])}, 'txt' => "HTTPS Public-Key-Pins header"},
    'https_body'        => {'val' => sub { Net::SSLinfo::https_body(      $_[0], $_[1])}, 'txt' => "HTTPS Body"},
    'https_sts'         => {'val' => sub { Net::SSLinfo::https_sts(       $_[0], $_[1])}, 'txt' => "HTTPS STS header"},
    'hsts_httpequiv'    => {'val' => sub { Net::SSLinfo::hsts_httpequiv(  $_[0], $_[1])}, 'txt' => "HTTPS STS in http-equiv"},
    'hsts_maxage'       => {'val' => sub { Net::SSLinfo::hsts_maxage(     $_[0], $_[1])}, 'txt' => "HTTPS STS MaxAge"},
    'hsts_subdom'       => {'val' => sub { Net::SSLinfo::hsts_subdom(     $_[0], $_[1])}, 'txt' => "HTTPS STS include sub-domains"},
    'hsts_preload'      => {'val' => sub { Net::SSLinfo::hsts_preload(    $_[0], $_[1])}, 'txt' => "HTTPS STS preload"},
    'http_protocols'    => {'val' => sub { Net::SSLinfo::http_protocols(  $_[0], $_[1])}, 'txt' => "HTTP Alternate-Protocol"},
    'http_svc'          => {'val' => sub { Net::SSLinfo::http_svc(        $_[0], $_[1])}, 'txt' => "HTTP Alt-Svc header"},
    'http_status'       => {'val' => sub { Net::SSLinfo::http_status(     $_[0], $_[1])}, 'txt' => "HTTP Status line"},
    'http_location'     => {'val' => sub { Net::SSLinfo::http_location(   $_[0], $_[1])}, 'txt' => "HTTP Location header"},
    'http_refresh'      => {'val' => sub { Net::SSLinfo::http_refresh(    $_[0], $_[1])}, 'txt' => "HTTP Refresh header"},
    'http_sts'          => {'val' => sub { Net::SSLinfo::http_sts(        $_[0], $_[1])}, 'txt' => "HTTP STS header"},
    #----------------------+-------------------------------------------------------------+-----------------------------------
    'options'           => {'val' => sub { Net::SSLinfo::options(         $_[0], $_[1])}, 'txt' => "internal used SSL options bitmask"},
    'fallback_protocol' => {'val' => sub { print('$prot{fallback}->{val} in _data_init');},'txt' => "Target's fallback SSL Protocol"},
    #----------------------+-------------------------------------------------------------+-----------------------------------
    # following not printed by default, but can be used as command
#   'PROT'              => {'val' => sub { return $prot{'PROT'}->{'default'}           }, 'txt' => "Target default PROT     cipher"},
    # all others will be added below
    #----------------------+-------------------------------------------------------------+-----------------------------------
    # following are used for checkdates() only, they must not be a command!
    # they are not printed with +info or +check; values are integer
    'valid_years'       => {'val' =>  0, 'txt' => "certificate validity in years"      },
    'valid_months'      => {'val' =>  0, 'txt' => "certificate validity in months"     },
    'valid_days'        => {'val' =>  0, 'txt' => "certificate validity in days"       },  # approx. value, accurate if < 30
    'valid_host'        => {'val' =>  0, 'txt' => "dummy used for printing DNS stuff"  },
    #----------------------+-------------------------------------------------------------+-----------------------------------
); # %data
# need s_client for: compression|expansion|selfsigned|chain|verify|resumption|renegotiation|next_protocols|
# need s_client for: krb5|psk_hint|psk_identity|master_secret|srp|master_key|public_key_len|session_id|session_id_ctx|session_protocol|session_ticket|session_lifetime|session_timeout|session_starttime|session_startdate

our %checks = (
    # key           =>  {val => "", txt => "label to be printed", score => 0, typ => "connection"},
    #
    # default for 'val' is "" (empty string), default for 'score' is 0
    # 'typ' is any of certificate, connection, destination, https, sizes
    # both will be set in sub _init_all(), please see below

    # the default "" value means "check = ok/yes", otherwise: "check =failed/no"

); # %checks

our %check_cert = (  # certificate data
    #------------------+-----------------------------------------------------
    # key                     => label to be printed (description)
    #------------------+-----------------------------------------------------
    'verify'        => {'txt' => "Certificate chain validated"},
    'fp_not_md5'    => {'txt' => "Certificate Fingerprint is not MD5"},
    'dates'         => {'txt' => "Certificate is valid"},
    'expired'       => {'txt' => "Certificate is not expired"},
    'certfqdn'      => {'txt' => "Certificate is valid according given hostname"},
    'wildhost'      => {'txt' => "Certificate's wildcard does not match hostname"},
    'wildcard'      => {'txt' => "Certificate does not contain wildcards"},
    'rootcert'      => {'txt' => "Certificate is not root CA"},
    'selfsigned'    => {'txt' => "Certificate is not self-signed"},
    'dv'            => {'txt' => "Certificate Domain Validation (DV)"},
    'ev+'           => {'txt' => "Certificate strict Extended Validation (EV)"},
    'ev-'           => {'txt' => "Certificate lazy Extended Validation (EV)"},
    'ocsp_uri'      => {'txt' => "Certificate has OCSP Responder URL"},
    'cps'           => {'txt' => "Certificate has Certification Practice Statement"},
    'crl'           => {'txt' => "Certificate has CRL Distribution Points"},
    'zlib'          => {'txt' => "Certificate has (TLS extension) compression"},
    'lzo'           => {'txt' => "Certificate has (GnuTLS extension) compression"},
    'open_pgp'      => {'txt' => "Certificate has (TLS extension) authentication"},
    'ocsp_valid'    => {'txt' => "Certificate has valid OCSP URL"},
    'cps_valid'     => {'txt' => "Certificate has valid CPS URL"},
    'crl_valid'     => {'txt' => "Certificate has valid CRL URL"},
    'sernumber'     => {'txt' => "Certificate Serial Number size RFC 5280"},
    'constraints'   => {'txt' => "Certificate Basic Constraints is false"},
    'sha2signature' => {'txt' => "Certificate Private Key Signature SHA2"},
    'modulus_exp_1' => {'txt' => "Certificate Public Key Modulus Exponent <>1"},
    'modulus_size_oldssl' => {'txt' => "Certificate Public Key Modulus >16385 bits"},
    'modulus_exp_65537' =>{'txt'=> "Certificate Public Key Modulus Exponent =65537"},
    'modulus_exp_oldssl'=>{'txt'=> "Certificate Public Key Modulus Exponent >65537"},
    'pub_encryption'=> {'txt' => "Certificate Public Key with Encryption"},
    'pub_enc_known' => {'txt' => "Certificate Public Key Encryption known"},
    'sig_encryption'=> {'txt' => "Certificate Private Key with Encryption"},
    'sig_enc_known' => {'txt' => "Certificate Private Key Encryption known"},
    'rfc_6125_names'=> {'txt' => "Certificate Names compliant to RFC 6125"},
    'rfc_2818_names'=> {'txt' => "Certificate subjectAltNames compliant to RFC 2818"},
    # following checks in subjectAltName, CRL, OCSP, CN, O, U
    'nonprint'      => {'txt' => "Certificate does not contain non-printable characters"},
    'crnlnull'      => {'txt' => "Certificate does not contain CR, NL, NULL characters"},
    'ev_chars'      => {'txt' => "Certificate has no invalid characters in extensions"},
# TODO: SRP is a target feature but also named a `Certificate (TLS extension)'
#    'srp'           => {'txt' => "Certificate has (TLS extension) authentication"},
    #------------------+-----------------------------------------------------
    # extensions:
    #   KeyUsage:
    #     0 - digitalSignature
    #     1 - nonRepudiation
    #     2 - keyEncipherment
    #     3 - dataEncipherment
    #     4 - keyAgreement
    #     5 - keyCertSign      # indicates this is CA cert
    #     6 - cRLSign
    #     7 - encipherOnly
    #     8 - decipherOnly
    # verify, is-trusted: certificate must be trusted, not expired (after also)
    #  common name or altname matches given hostname
    #     1 - no chain of trust
    #     2 - not before
    #     4 - not after
    #     8 - hostname mismatch
    #    16 - revoked
    #    32 - bad common name
    #    64 - self-signed
    # possible problems with chains:
    #   - contains untrusted certificate
    #   - chain incomplete/not resolvable
    #   - chain too long (depth)
    #   - chain size too big
    #   - contains illegal characters
    # TODO: wee need an option to specify the the local certificate storage!
); # %check_cert

our %check_conn = (  # connection data
    #------------------+-----------------------------------------------------
#   'ip'            => {'txt' => "IP for given hostname "}, # 12/2019: no check implemented
    'reversehost'   => {'txt' => "Given hostname is same as reverse resolved hostname"},
    'hostname'      => {'txt' => "Connected hostname equals certificate's Subject"},
    'beast'         => {'txt' => "Connection is safe against BEAST attack (any cipher)"},
    'breach'        => {'txt' => "Connection is safe against BREACH attack"},
    'ccs'           => {'txt' => "Connection is safe against CCS Injection attack"},
    'crime'         => {'txt' => "Connection is safe against CRIME attack"},
    'drown'         => {'txt' => "Connection is safe against DROWN attack"},
    'time'          => {'txt' => "Connection is safe against TIME attack"},
    'freak'         => {'txt' => "Connection is safe against FREAK attack"},
    'heartbleed'    => {'txt' => "Connection is safe against Heartbleed attack"},
    'logjam'        => {'txt' => "Connection is safe against Logjam attack"},
    'lucky13'       => {'txt' => "Connection is safe against Lucky 13 attack"},
    'poodle'        => {'txt' => "Connection is safe against POODLE attack"},
    'rc4'           => {'txt' => "Connection is safe against RC4 attack"},
    'robot'         => {'txt' => "Connection is safe against ROBOT attack"},
    'sloth'         => {'txt' => "Connection is safe against SLOTH attack"},
    'sweet32'       => {'txt' => "Connection is safe against Sweet32 attack"},
    'sni'           => {'txt' => "Connection is not based on SNI"},
     # NOTE: following keys use mixed case letters, that's ok 'cause these
     #       checks are not called by their own commands; ugly hack ...
    #------------------+-----------------------------------------------------
); # %check_conn

our %check_dest = (  # target (connection) data
    #------------------+-----------------------------------------------------
    'sgc'           => {'txt' => "Target supports Server Gated Cryptography (SGC)"},
    'hassslv2'      => {'txt' => "Target does not support SSLv2"},
    'hassslv3'      => {'txt' => "Target does not support SSLv3"},      # POODLE
    'hastls10'      => {'txt' => "Target supports TLSv1"},
    'hastls11'      => {'txt' => "Target supports TLSv1.1"},
    'hastls12'      => {'txt' => "Target supports TLSv1.2"},
    'hastls13'      => {'txt' => "Target supports TLSv1.3"},
    'hasalpn'       => {'txt' => "Target supports ALPN"},
    'hasnpn'        => {'txt' => "Target supports  NPN"},
    'cipher_strong' => {'txt' => "Target selects strongest cipher"},
    'cipher_order'  => {'txt' => "Target does not honors client's cipher order"}, # NOT YET USED
    'cipher_weak'   => {'txt' => "Target does not accept weak cipher"},
    'cipher_null'   => {'txt' => "Target does not accept NULL ciphers"},
    'cipher_adh'    => {'txt' => "Target does not accept ADH ciphers"},
    'cipher_exp'    => {'txt' => "Target does not accept EXPORT ciphers"},
    'cipher_cbc'    => {'txt' => "Target does not accept CBC ciphers"},
    'cipher_des'    => {'txt' => "Target does not accept DES ciphers"},
    'cipher_rc4'    => {'txt' => "Target does not accept RC4 ciphers"},
    'cipher_edh'    => {'txt' => "Target supports EDH ciphers"},
    'cipher_pfs'    => {'txt' => "Target supports PFS (selected cipher)"},
    'cipher_pfsall' => {'txt' => "Target supports PFS (all ciphers)"},
    'closure'       => {'txt' => "Target understands TLS closure alerts"},
    'compression'   => {'txt' => "Target does not support Compression"},
    'fallback'      => {'txt' => "Target supports fallback from TLSv1.1"},
    'ism'           => {'txt' => "Target is ISM compliant (ciphers only)"},
    'pci'           => {'txt' => "Target is PCI compliant (ciphers only)"},
    'fips'          => {'txt' => "Target is FIPS-140 compliant"},
#   'nsab'          => {'txt' => "Target is NSA Suite B compliant"},
    'tr_02102+'     => {'txt' => "Target is strict TR-02102-2 compliant"},
    'tr_02102-'     => {'txt' => "Target is  lazy  TR-02102-2 compliant"},
    'tr_03116+'     => {'txt' => "Target is strict TR-03116-4 compliant"},
    'tr_03116-'     => {'txt' => "Target is  lazy  TR-03116-4 compliant"},
    'rfc_7525'      => {'txt' => "Target is RFC 7525 compliant"},
    'sstp'          => {'txt' => "Target does not support method SSTP"},
    'resumption'    => {'txt' => "Target supports Resumption"},
    'renegotiation' => {'txt' => "Target supports Secure Renegotiation"},
    'krb5'          => {'txt' => "Target supports Krb5"},
    'psk_hint'      => {'txt' => "Target supports PSK Identity Hint"},
    'psk_identity'  => {'txt' => "Target supports PSK"},
    'srp'           => {'txt' => "Target supports SRP"},
    'ocsp_stapling' => {'txt' => "Target supports OCSP Stapling"},
    'master_secret' => {'txt' => "Target supports Extended Master Secret"},
    'session_ticket'=> {'txt' => "Target supports TLS Session Ticket"}, # sometimes missing ...
    'session_lifetime'  =>{ 'txt'=> "Target TLS Session Ticket Lifetime"},
    'session_starttime' =>{ 'txt'=> "Target TLS Session Start Time match"},
    'session_random'=> {'txt' => "Target TLS Session Ticket is random"},
    'heartbeat'     => {'txt' => "Target does not support heartbeat extension"},
    'scsv'          => {'txt' => "Target does not support SCSV"},
    # following for information, checks not useful; see "# check target specials" in checkdest also
#    'master_key'    => {'txt' => "Target supports Master-Key"},
#    'session_id'    => {'txt' => "Target supports Session-ID"},
    'dh_512'        => {'txt' => "Target DH Parameter >= 512 bits"},
    'dh_2048'       => {'txt' => "Target DH Parameter >= 2048 bits"},
    'ecdh_256'      => {'txt' => "Target DH Parameter >= 256 bits (ECDH)"},
    'ecdh_512'      => {'txt' => "Target DH Parameter >= 512 bits (ECDH)"},
    #------------------+-----------------------------------------------------
); # %check_dest

our %check_size = (  # length and count data
    # counts and sizes are integer values, key mast have prefix (len|cnt)_
    #------------------+-----------------------------------------------------
    'len_pembase64' => {'txt' => "Certificate PEM (base64) size"},  # <(2048/8*6)
    'len_pembinary' => {'txt' => "Certificate PEM (binary) size"},  # < 2048
    'len_subject'   => {'txt' => "Certificate Subject size"},       # <  256
    'len_issuer'    => {'txt' => "Certificate Issuer size"},        # <  256
    'len_cps'       => {'txt' => "Certificate CPS size"},           # <  256
    'len_crl'       => {'txt' => "Certificate CRL size"},           # <  256
    'len_crl_data'  => {'txt' => "Certificate CRL data size"},
    'len_ocsp'      => {'txt' => "Certificate OCSP size"},          # <  256
    'len_oids'      => {'txt' => "Certificate OIDs size"},
    'len_publickey' => {'txt' => "Certificate Public Key size"},    # > 1024
    # \---> same as modulus_len
    'len_sigdump'   => {'txt' => "Certificate Signature Key size"} ,# > 1024
    'len_altname'   => {'txt' => "Certificate Subject Altname size"},
    'len_chain'     => {'txt' => "Certificate Chain size"},         # < 2048
    'len_sernumber' => {'txt' => "Certificate Serial Number size"}, # <=  20 octets
    'cnt_altname'   => {'txt' => "Certificate Subject Altname count"}, # == 0
    'cnt_wildcard'  => {'txt' => "Certificate Wildcards count"},    # == 0
    'cnt_chaindepth'=> {'txt' => "Certificate Chain Depth count"},  # == 1
    'cnt_ciphers'   => {'txt' => "Total number of offered ciphers"},# <> 0
    'cnt_totals'    => {'txt' => "Total number of checked ciphers"},
    'cnt_checks_noo'=> {'txt' => "Total number of check results 'no(<<)'"},
    'cnt_checks_no' => {'txt' => "Total number of check results 'no'"},
    'cnt_checks_yes'=> {'txt' => "Total number of check results 'yes'"},
    'cnt_exitcode'  => {'txt' => "Total number of insecure checks"},# == 0
    #------------------+-----------------------------------------------------
# TODO: cnt_ciphers, len_chain, cnt_chaindepth
); # %check_size

our %check_http = (  # HTTP vs. HTTPS data
    # key must have prefix (hsts|sts); see $cfg{'regex'}->{'cmd-http'}
    #------------------+-----------------------------------------------------
    'sts_maxage0d'  => {'txt' => "STS max-age not reset"},           # max-age=0 is bad
    'sts_maxage1d'  => {'txt' => "STS max-age less than one day"},   # weak
    'sts_maxage1m'  => {'txt' => "STS max-age less than one month"}, # low
    'sts_maxage1y'  => {'txt' => "STS max-age less than one year"},  # medium
    'sts_maxagexy'  => {'txt' => "STS max-age more than one year"},  # high
    'sts_maxage18'  => {'txt' => "STS max-age more than 18 weeks"},  #
    'sts_expired'   => {'txt' => "STS max-age < certificate's validity"},
    'hsts_sts'      => {'txt' => "Target sends STS header"},
    'sts_maxage'    => {'txt' => "Target sends STS header with proper max-age"},
    'sts_subdom'    => {'txt' => "Target sends STS header with includeSubdomain"},
    'sts_preload'   => {'txt' => "Target sends STS header with preload"},
    'hsts_is301'    => {'txt' => "Target redirects with status code 301"}, # RFC 6797 requirement
    'hsts_is30x'    => {'txt' => "Target redirects not with 30x status code"}, # other than 301, 304
    'hsts_fqdn'     => {'txt' => "Target redirect matches given host"},
    'http_https'    => {'txt' => "Target redirects HTTP to HTTPS"},
    'hsts_location' => {'txt' => "Target sends STS and no Location header"},
    'hsts_refresh'  => {'txt' => "Target sends STS and no Refresh header"},
    'hsts_redirect' => {'txt' => "Target redirects HTTP without STS header"},
    'hsts_samehost' => {'txt' => "Target redirects HTTP to HTTPS same host"},
    'hsts_ip'       => {'txt' => "Target does not send STS header for IP"},
    'hsts_httpequiv'=> {'txt' => "Target does not send STS in meta tag"},
    'https_pins'    => {'txt' => "Target sends Public-Key-Pins header"},
    #------------------+-----------------------------------------------------
); # %check_http

our %shorttexts = (
    #------------------+------------------------------------------------------
    # %check +check     short label text
    #------------------+------------------------------------------------------
    'ip'            => "IP for hostname",
    'DNS'           => "DNS for hostname",
    'reversehost'   => "Reverse hostname",
    'hostname'      => "Hostname equals Subject",
    'expired'       => "Not expired",
    'certfqdn'      => "Valid for hostname",
    'wildhost'      => "Wilcard for hostname",
    'wildcard'      => "No wildcards",
    'sni'           => "Not SNI based",
    'sernumber'     => "Size Serial Number",
    'sha2signature' => "Signature is SHA2",
    'rootcert'      => "Not root CA",
    'ocsp_uri'      => "OCSP URL",
    'ocsp_valid'    => "OCSP valid",
    'hassslv2'      => "No SSLv2",
    'hassslv3'      => "No SSLv3",
    'hastls10'      => "TLSv1",
    'hastls11'      => "TLSv1.1",
    'hastls12'      => "TLSv1.2",
    'hastls13'      => "TLSv1.3",
    'hasalpn'       => "Supports ALPN",
    'hasnpn'        => "Supports  NPN",
    'alpn'          => "Selected ALPN",
    'npn'           => "Selected  NPN",
    'alpns'         => "Supported ALPNs",
    'npns'          => "Supported  NPNs",
    'master_secret' => "Supports Extended Master Secret",
#   'master_secret' => "Supports EMS",
    'next_protocols'=> "(NPN) Protocols",
    'cipher_strong' => "Strongest cipher selected",
    'cipher_order'  => "Client's cipher order",
    'cipher_weak'   => "Weak cipher selected",
    'cipher_null'   => "No NULL ciphers",
    'cipher_adh'    => "No ADH ciphers",
    'cipher_exp'    => "No EXPORT ciphers",
    'cipher_cbc'    => "No CBC ciphers",
    'cipher_des'    => "No DES ciphers",
    'cipher_rc4'    => "No RC4 ciphers",
    'cipher_edh'    => "EDH ciphers",
    'cipher_pfs'    => "PFS (selected cipher)",
    'cipher_pfsall' => "PFS (all ciphers)",
    'sgc'           => "SGC supported",
    'cps'           => "CPS supported",
    'crl'           => "CRL supported",
    'cps_valid'     => "CPS valid",
    'crl_valid'     => "CRL valid",
    'dv'            => "DV supported",
    'ev+'           => "EV supported (strict)",
    'ev-'           => "EV supported (lazy)",
    'ev_chars'      => "No invalid characters in extensions",
    'beast'         => "Safe to BEAST (cipher)",
    'breach'        => "Safe to BREACH",
    'ccs'           => "Safe to CCS",
    'crime'         => "Safe to CRIME",
    'drown'         => "Safe to DROWN",
    'time'          => "Safe to TIME",
    'freak'         => "Safe to FREAK",
    'heartbleed'    => "Safe to Heartbleed",
    'lucky13'       => "Safe to Lucky 13",
    'logjam'        => "Safe to Logjam",
    'poodle'        => "Safe to POODLE",
    'rc4'           => "Safe to RC4 attack",
    'robot'         => "Safe to ROBOT",
    'sloth'         => "Safe to SLOTH",
    'sweet32'       => "Safe to Sweet32",
    'scsv'          => "SCSV not supported",
    'constraints'   => "Basic Constraints is false",
    'modulus_exp_1' => "Modulus Exponent <>1",
    'modulus_size_oldssl'  => "Modulus >16385 bits",
    'modulus_exp_65537' =>"Modulus Exponent =65537",
    'modulus_exp_oldssl'=>"Modulus Exponent >65537",
    'pub_encryption'=> "Public Key with Encryption",
    'pub_enc_known' => "Public Key Encryption known",
    'sig_encryption'=> "Private Key with Encryption",
    'sig_enc_known' => "Private Key Encryption known",
    'rfc_6125_names'=> "Names according RFC 6125",
    'rfc_2818_names'=> "subjectAltNames according RFC 2818",
    'closure'       => "TLS closure alerts",
    'fallback'      => "Fallback from TLSv1.1",
    'zlib'          => "ZLIB extension",
    'lzo'           => "GnuTLS extension",
    'open_pgp'      => "OpenPGP extension",
    'ism'           => "ISM compliant",
    'pci'           => "PCI compliant",
    'fips'          => "FIPS-140 compliant",
    'sstp'          => "SSTP",
#   'nsab'          => "NSA Suite B compliant",
    'tr_02102+'     => "TR-02102-2 compliant (strict)",
    'tr_02102-'     => "TR-02102-2 compliant (lazy)",
    'tr_03116+'     => "TR-03116-4 compliant (strict)",
    'tr_03116-'     => "TR-03116-4 compliant (lazy)",
    'rfc_7525'      => "RFC 7525 compliant",
    'resumption'    => "Resumption",
    'renegotiation' => "Renegotiation",     # NOTE: used in %data and %check_dest
    'hsts_sts'      => "STS header",
    'sts_maxage'    => "STS long max-age",
    'sts_maxage0d'  => "STS max-age not reset",
    'sts_maxage1d'  => "STS max-age < 1 day",
    'sts_maxage1m'  => "STS max-age < 1 month",
    'sts_maxage1y'  => "STS max-age < 1 year",
    'sts_maxagexy'  => "STS max-age > 1 year",
    'sts_maxage18'  => "STS max-age > 18 weeks",
    'sts_expired'   => "STS max-age < certificate's validity",
    'sts_subdom'    => "STS includeSubdomain",
    'sts_preload'   => "STS preload",
    'hsts_httpequiv'=> "STS not in meta tag",
    'hsts_ip'       => "STS header not for IP",
    'hsts_location' => "STS and Location header",
    'hsts_refresh'  => "STS and no Refresh header",
    'hsts_redirect' => "STS within redirects",
    'http_https'    => "Redirects HTTP",
    'hsts_fqdn'     => "Redirects to same host",
    'hsts_is301'    => "Redirects with 301",
    'hsts_is30x'    => "Redirects not with 30x",
    'https_pins'    => "Public-Key-Pins",
    'selfsigned'    => "Validity (signature)",
    'chain'         => "Certificate chain",
    'verify'        => "Chain verified",
    'chain_verify'  => "CA Chain trace",
    'error_verify'  => "CA Chain error",
    'error_depth'   => "CA Chain error in level",
    'nonprint'      => "No non-printables",
    'crnlnull'      => "No CR, NL, NULL",
    'compression'   => "Compression",
    'expansion'     => "Expansion",
    'krb5'          => "Krb5 Principal",
    'psk_hint'      => "PSK Identity Hint",
    'psk_identity'  => "PSK Identity",
    'ocsp_stapling' => "OCSP Stapling",
    'ocsp_response'     => "OCSP Response",
    'ocsp_response_data'=> "OCSP Response Data",
    'ocsp_response_status' => "OCSP Response Status",
    'ocsp_cert_status'  => "OCSP Response Cert Status",
    'ocsp_next_update'  => "OCSP Response Next Update",
    'ocsp_this_update'  => "OCSP Response This Update",
    'srp'               => "SRP Username",
    'master_key'        => "Master-Key",
    'public_key_len'    => "Server public key length",
    'session_id'        => "Session-ID",
    'session_id_ctx'    => "Session-ID-ctx",
    'session_protocol'  => "Selected SSL Protocol",
    'session_ticket'    => "TLS Session Ticket",
    'session_lifetime'  => "TLS Session Ticket Lifetime",
    'session_random'    => "TLS Session Ticket random",
    'session_timeout'   => "TLS Session Timeout",
    'session_startdate' => "TLS Session Start Time locale",
    'session_starttime' => "TLS Session Start Time EPOCH",
    'dh_parameter'  => "DH Parameter",
    'dh_512'        => "DH Parameter >= 512",
    'dh_2048'       => "DH Parameter >= 2048",
    'ecdh_256'      => "DH Parameter >= 256 (ECDH)",
    'ecdh_512'      => "DH Parameter >= 512 (ECDH)",
    'ext_authority' => "Authority Information Access",
    'ext_authorityid'=>"Authority key Identifier",
    'ext_constraints'=>"Basic Constraints",
    'ext_cps'       => "Certificate Policies",
    'ext_cps_cps'   => "Certificate Policies: CPS",
    'ext_cps_policy'=> "Certificate Policies: Policy",
    'ext_cps_notice'=> "Certificate Policies: User Notice",
    'ext_crl'       => "CRL Distribution Points",
    'ext_subjectkeyid'=>"Subject Key Identifier",
    'ext_keyusage'  => "Key Usage",
    'ext_extkeyusage'=>"Extended Key Usage",
    'ext_certtype'  => "Netscape Cert Type",
    'ext_issuer'    => "Issuer Alternative Name",
    'fallback_protocol' => "Fallback SSL Protocol",
    'len_pembase64' => "Size PEM (base64)",
    'len_pembinary' => "Size PEM (binary)",
    'len_subject'   => "Size subject",
    'len_issuer'    => "Size issuer",
    'len_cps'       => "Size CPS",
    'len_crl'       => "Size CRL",
    'len_crl_data'  => "Size CRL data",
    'len_ocsp'      => "Size OCSP",
    'len_oids'      => "Size OIDs",
    'len_altname'   => "Size altname",
    'len_publickey' => "Size pubkey",
    'len_sigdump'   => "Size signature key",
    'len_chain'     => "Size certificate chain",
    'len_sernumber' => "Size serial number",
    'cnt_altname'   => "Count altname",
    'cnt_wildcard'  => "Count wildcards",
    'cnt_chaindepth'=> "Count chain depth",
    'cnt_ciphers'   => "Count ciphers",
    'cnt_totals'    => "Checked ciphers",
    'cnt_checks_noo'=> "Checks 'no(<<)'",
    'cnt_checks_no' => "Checks 'no'",
    'cnt_checks_yes'=> "Checks 'yes'",
    #------------------+------------------------------------------------------
    # %data +command    short label text
    #------------------+------------------------------------------------------
    'pem'           => "PEM",
    'text'          => "PEM decoded",
    'cn'            => "Common Name",
    'subject'       => "Subject",
    'issuer'        => "Issuer",
    'altname'       => "Subject AltNames",
    'ciphers'       => "Client Ciphers",
    'ciphers_local' => "SSLlib Ciphers",
    'cipher_selected'   => "Selected Cipher",
    'dates'         => "Validity (date)",
    'before'        => "Valid since",
    'after'         => "Valid until",
    'tlsextdebug'   => "TLS Extensions (debug)",
    'tlsextensions' => "TLS Extensions",
    'extensions'    => "Extensions",
    'heartbeat'     => "Heartbeat",     # not really a `key', but an extension
    'aux'           => "Trust",
    'email'         => "Email",
    'pubkey'        => "Public Key",
    'pubkey_algorithm'  => "Public Key Algorithm",
    'pubkey_value'  => "Public Key Value",
    'modulus_len'   => "Public Key Length",
    'modulus'       => "Public Key Modulus",
    'modulus_exponent'  => "Public Key Exponent",
    'serial'        => "Serial Number",
    'serial_hex'    => "Serial Number (hex)",
    'serial_int'    => "Serial Number (int)",
    'certversion'   => "Certificate Version",
    'sslversion'    => "SSL Protocol",
    'signame'       => "Signature Algorithm",
    'sigdump'       => "Signature (hexdump)",
    'sigkey_len'    => "Signature Key Length",
    'sigkey_value'  => "Signature Key Value",
    'trustout'      => "Trusted",
    'ocspid'        => "OCSP Hashes",
    'ocsp_subject_hash' => "OCSP Subject Hash",
    'ocsp_public_hash'  => "OCSP Public Hash",
    'subject_hash'  => "Subject Hash",
    'issuer_hash'   => "Issuer Hash",
    'fp_not_md5'    => "Fingerprint not MD5",
    'cert_type'     => "Certificate Type (bitmask)",
    'verify_hostname'   => "Hostname valid",
    'verify_altname'    => "AltNames valid",
    'fingerprint_hash'  => "Fingerprint Hash",
    'fingerprint_type'  => "Fingerprint Algorithm",
    'fingerprint_sha2'  => "Fingerprint SHA2",
    'fingerprint_sha1'  => "Fingerprint SHA1",
    'fingerprint_md5'   => "Fingerprint  MD5",
    'fingerprint'       => "Fingerprint:",
    'https_protocols'   => "HTTPS Alternate-Protocol",
    'https_body'    => "HTTPS Body",
    'https_svc'     => "HTTPS Alt-Svc header",
    'https_status'  => "HTTPS Status line",
    'https_server'  => "HTTPS Server banner",
    'https_location'=> "HTTPS Location header",
    'https_alerts'  => "HTTPS Error alerts",
    'https_refresh' => "HTTPS Refresh header",
    'https_pins'    => "HTTPS Public-Key-Pins header",
    'https_sts'     => "HTTPS STS header",
    'hsts_maxage'   => "HTTPS STS MaxAge",
    'hsts_subdom'   => "HTTPS STS sub-domains",
    'hsts_preload'  => "HTTPS STS preload",
    'hsts_is301'    => "HTTP Status code is 301",
    'hsts_is30x'    => "HTTP Status code not 30x",
    'hsts_samehost' => "HTTP redirect to same host",
    'http_protocols'=> "HTTP Alternate-Protocol",
    'http_svc'      => "HTTP Alt-Svc header",
    'http_status'   => "HTTP Status line",
    'http_location' => "HTTP Location header",
    'http_refresh'  => "HTTP Refresh header",
    'http_sts'      => "HTTP STS header",
    'options'       => "internal SSL bitmask",
    #------------------+------------------------------------------------------
    # more texts dynamically, see "adding more shorttexts" below
); # %shorttexts

#_____________________________________________________________________________
#_________________________________________________________ internal methods __|

# SEE Perl:Undefined subroutine
*_warn    = sub { print(join(" ", "**WARNING:", @_), "\n"); return; } if not defined &_warn;
*_dbx     = sub { print(join(" ", "#dbx#"     , @_), "\n"); return; } if not defined &_dbx;

#_____________________________________________________________________________
#__________________________________________________________________ methods __|

=pod

=head1 METHODS

None.

=cut

#_____________________________________________________________________________
#____________________________________________________ internal test methods __|

sub show            {
    #? dispatcher for various --test-data-* options to show information
    # output similar (but not identical) to o-saft-man::man_table()
    my $arg = shift;
    printf("= %%$arg\n");
    #if ('info' eq $arg)   { # not yet used
    #printf("%21s -\t%s\n", $_, $info{$_}->{txt}) foreach (sort keys %info);
    #}
    if ('data' eq $arg)   {
        printf("%21s -\t%s\n", $_, $data{$_}->{txt})       foreach (sort keys %data);
    }
    if ('checks' eq $arg) {
        printf("%21s -\t%s\n", $_, $checks{$_}->{txt})     foreach (sort keys %checks);
    }
    if ('check_cert' eq $arg) {
        printf("%21s -\t%s\n", $_, $check_cert{$_}->{txt}) foreach (sort keys %check_cert);
    }
    if ('check_conn' eq $arg) {
        printf("%21s -\t%s\n", $_, $check_conn{$_}->{txt}) foreach (sort keys %check_conn);
    }
    if ('check_dest' eq $arg) {
        printf("%21s -\t%s\n", $_, $check_dest{$_}->{txt}) foreach (sort keys %check_dest);
    }
    if ('check_size' eq $arg) {
        printf("%21s -\t%s\n", $_, $check_size{$_}->{txt}) foreach (sort keys %check_size);
    }
    if ('check_http' eq $arg) {
        printf("%21s -\t%s\n", $_, $check_http{$_}->{txt}) foreach (sort keys %check_http);
    }
    if ('shorttexts' eq $arg) {
        printf("%21s -\t%s\n", $_, $shorttexts{$_})        foreach (sort keys %shorttexts);
    }
    return if ($arg =~ /check_/); # cert conn dest size http
    print <<"EoHelp";

= Please use  o-saft.pl --help=$arg  for formated output.
EoHelp
    return;
} # show

#_____________________________________________________________________________
#___________________________________________________ initialisation methods __|

sub _data_init      {
    #? initialise variables

    # construct %checks from %check_* and set 'typ'
    foreach my $key (keys %check_conn) { $checks{$key}->{txt} = $check_conn{$key}->{txt}; $checks{$key}->{typ} = 'connection'; }
    foreach my $key (keys %check_cert) { $checks{$key}->{txt} = $check_cert{$key}->{txt}; $checks{$key}->{typ} = 'certificate'; }
    foreach my $key (keys %check_dest) { $checks{$key}->{txt} = $check_dest{$key}->{txt}; $checks{$key}->{typ} = 'destination'; }
    foreach my $key (keys %check_size) { $checks{$key}->{txt} = $check_size{$key}->{txt}; $checks{$key}->{typ} = 'sizes'; }
    foreach my $key (keys %check_http) { $checks{$key}->{txt} = $check_http{$key}->{txt}; $checks{$key}->{typ} = 'https'; }
    foreach my $key (keys %checks)     { $checks{$key}->{val} = ""; }
    # more data added to %checks after defining %cfg, see main

    # TODO: must be done in main:
    #$data{'fallback_protocol'}->{'val'} = sub { return $prot{'fallback'}->{val}  };
    ## add keys from %prot to %shorttext,
    #foreach my $ssl (keys %prot) {
    #    my $key = lc($ssl); # keys in data are all lowercase (see: convert all +CMD)
    #    $shorttexts{$key} = "Default $prot{$ssl}->{txt} cipher";
    #}

    return;
} # _data_init

#_____________________________________________________________________________
#_____________________________________________________________________ main __|

sub _main_data      {
    my @argv = @_;
    push(@argv, "--help") if (0 > $#argv);
    binmode(STDOUT, ":unix:utf8"); ## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
    binmode(STDERR, ":unix:utf8"); ## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
    # got arguments, do something special
    while (my $arg = shift @argv) {
        print_pod($0, __PACKAGE__, $SID_data)   if ($arg =~ m/^--?h(?:elp)?$/x);
        # ----------------------------- options
#       if ($arg =~ m/^--(?:v|trace.?CMD)/i) { $VERBOSE++; next; }  # allow --v
        # ----------------------------- commands
        if ($arg =~ /^version$/)         { print "$SID_data\n"; next; }
        if ($arg =~ /^[-+]?V(ERSION)?$/) { print "$VERSION\n";  next; }
        $arg =~ s/^(?:--test.?data)//;
show($arg);
            $arg = "--test-data";
#?#         printf("#$0: direct testing not yet possible, please try:\n   o-saft.pl $arg\n");
    }
    exit 0;
} # _main_data

sub data_done       {}; # dummy to check successful include

_data_init();

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

=pod

=head1 SEE ALSO

# ...

=head1 VERSION

1.9 2022/11/06

=head1 AUTHOR

22-jun-22 Achim Hoffmann

=cut

## PACKAGE }
} # OSaft/Data.pm

{ # OSaft/Doc/Data.pm
## PACKAGE {

#!# Copyright (c) 2022, Achim Hoffmann
#!# This software is licensed under GPLv2.  Please see o-saft.pl for details.

package OSaft::Doc::Data;

## no critic qw(Documentation::RequirePodSections)
#        Our POD below is fine, Perl::Critic (severity 2) is too pedantic here.

## no critic qw(RegularExpressions::ProhibitFixedStringMatches)
#        Using regex instead of strings is not bad.  Perl::Critic (severity 2)
#        is too pedantic here.

## no critic qw(ControlStructures::ProhibitPostfixControls)
#        We believe it's better readable (severity 2 only)

## no critic qw(RegularExpressions::RequireExtendedFormatting)
#        Most of our regex are easy to read, it's the nature of the code herein
#        to have simple and complex regex.  /x is used for human readability as
#        needed.


use warnings;

BEGIN { # mainly required for testing ...
    # SEE Perl:@INC
    # SEE Perl:BEGIN perlcritic
    my $_me   = $0;     $_me   =~ s#.*[/\\]##x;
    my $_path = $0;     $_path =~ s#[/\\][^/\\]*$##x;
    unshift(@INC, $_path)   if (1 > (grep{/^$_path$/} @INC));
    unshift(@INC, "..")     if (1 > (grep{/^\.\.$/}   @INC));
    unshift(@INC, ".")      if (1 > (grep{/^\.$/}     @INC));
}

my  $SID_data   = "@(#) Data.pm 1.56 22/11/04 00:30:15";
our $VERSION    = "22.11.22";   # official verion number of this file

# binmode(...); # inherited from parent, SEE Perl:binmode()

#-# use OSaft::Text qw(print_pod);

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

=pod

=encoding utf8


=head1 _____________________________________________________________________________

=head1 NAME

OSaft::Doc::Data - common Perl module to read data for user documentation


=head1 SYNOPSIS

=over 2

=item  use OSaft::Doc::Data;        # from within perl code

=item OSaft/Doc/Data --usage        # on command line will print short usage

=item OSaft/Doc/Data [COMMANDS]     # on command line will print help

=back

=cut

#_____________________________________________________________________________
#_________________________________________________________ internal methods __|

# SEE Perl:Undefined subroutine
*_warn    = sub { print(join(" ", "**WARNING:", @_), "\n"); return; } if not defined &_warn;
*_dbx     = sub { print(join(" ", "#dbx#"     , @_), "\n"); return; } if not defined &_dbx;

sub _replace_var    {
    #? replace $0 by name and $VERSION by version in array, return array
    my ($name, $version, @arr) = @_;
    # SEE Perl:map()
    s#\$VERSION#$version#g  for @arr;   # add current VERSION
    s#(?<!`)\$0#$name#g     for @arr;   # my name
    return @arr;
} # _replace_var

sub _get_standalone {
    #? return help.txt with path in standalone mode
    # o-saft-standalone.pl may be in installtion path or in contrib/ directory
    # hence various places for help.txt are checked
    my $file = shift;
    $file =~ s#^\.\./##;
    $file =~ s#contrib/##;              # remove if in path
    $file =  "OSaft/Doc/$file";         # try this one ..
    $file =  "../$file" if (not -e $file);  # .. or this one
    $file =  ""         if (not -e $file);
    return $file;
} # _get_standalone

sub _get_filehandle {
    #? return open file handle for passed filename,
    #? return Perl's DATA file handle of this file if file does not exist
    # this function is a wrapper for Perl's DATA
    my $file = shift || "";
    my $fh; # same as *FH
    local $\ = "\n";
    #dbx# print "#Data.pm $0, file=$file, ",__FILE__;
    if ("" ne $file) {
        # file may be in same directory as caller, or in same as this module
        if (not -e $file) {
            my  $path = __FILE__;
                $path =~ s#^/(OSaft/.*)#$1#;# own module directory
                $path =~ s#/[^/\\]*$##;     # relative path of this file
                # Dirty hack: some OS return an absolute path for  __FILE__ ;
                # then $file would not be found because that path is wrong. If
                # the path begins with /OSaft the leading / is simply removed.
                # NOTE: This behaviour (on older Mac OSX) is considered a bug
                #       in Perl there.
            $file = "$path/$file";
            # following line for gen_standalone.sh (used with make)
            $file =  _get_standalone($file);
        }
    }
    #dbx# print "#Data.pm file=$file ";
    if ("" ne $file and -e $file) {
        ## no critic qw(InputOutput::RequireBriefOpen)
        #  file hadnle needs to be closd by caller
        if (not open($fh, '<:encoding(UTF-8)', $file)) {
            _warn("190: open('$file'): $!");
        }
    } else {
        $fh = __PACKAGE__ . "::DATA";   # same as:  *OSaft::Doc::Data::DATA
        _warn("191: no '$file' found, using '$fh'") if not -e $file;
    }
    #dbx# print "#Data.pm file=$file , FH=*$fh";
    return $fh;
} # _get_filehandle

#_____________________________________________________________________________
#__________________________________________________________________ methods __|

sub get_egg     {
    #? get easter egg from text
    my $fh      = _get_filehandle(shift);
    my $egg     = "";   # set empty to avoid "Use of uninitialized value" later
    while (<$fh>) { $egg .= $_ if (m/^#begin/..m/^#end/); }
    $egg =~ s/#(begin|end) .*\n//g;
    close($fh);
    return scalar reverse "\n$egg";
} # get_egg

=pod

=head1 METHODS

=head2 get($file,$name,$version)

Return all data from file and replace $0 by $name. Returns data as string.

=cut

sub get         {
    #? return data from file as string, replace $0 by $name
    my $file    = shift;
    my $name    = shift || "o-saft.pl";
    my $version = shift || $VERSION;
    my $fh      = _get_filehandle($file);
    return _replace_var($name, $version, <$fh>);
    # TODO: misses  close($fh);
} # get

=pod

=head2 get_as_text($file)

Return all data from file as is. Returns data as string.

=cut

sub get_as_text { my $fh = _get_filehandle(shift); return <$fh>; }
# TODO: misses  close($fh);

=pod

=head2 get_markup($file,$name,$version)

Return all data converted to internal markup format. Returns array of lines.

=cut

sub get_markup    {
    #? return data with internal markup, returns array of lines
    my $file    = shift;
    my $parent  = shift || "o-saft.pl";
    my $version = shift || $VERSION;
    my @txt;
    my $fh      = _get_filehandle($file);
    return "" if ("" eq $fh);           # defensive programming
    # Preformat plain text with markup for further simple substitutions. We
    # use a modified  &  instead of < >  POD markup as it is easy to parse.
    # &  was choosen because it rarely appears in texts and  is not  a meta
    # character in any of the supported  output formats (text, wiki, html),
    # and also causes no problems inside regex.
    for (<$fh>) {   ## no critic qw(InputOutput::ProhibitReadlineInForLoop)
                    #  There is no differnce if the array is allocated by
                    #  using a local variable or implecitely in the loop
        ## no critic qw(RegularExpressions::ProhibitComplexRegexes)
            # it's the nature of some regex to be complex
        # SEE MARKUP
        next if (m/^#begin/..m/^#end/); # remove egg
        next if (/^#/);                 # remove comments
        next if (/^\s*#.*#$/);          # remove formatting lines
        s/^([A-Z].*)/=head1 $1/;
        s/^ {4}([^ ].*)/=head2 $1/;
        s/^ {6}([^ ].*)/=head3 $1/;
        # for =item keep spaces as they are needed in man_help()
        s/^( +[a-z0-9]+\).*)/=item * $1/;# list item, starts with letter or digit and )
        s/^( +\*\* .*)/=item $1/;       # list item, second level
        s/^( +\* .*)/=item $1/;         # list item, first level
        s/^( {11})([^ ].*)/=item * $1$2/;# list item
        s/^( {14})([^ ].*)/S&$1$2&/;    # exactly 14 spaces used to highlight line
        s/^( {18})([^ ].*)/S&$1$2&/;    # exactly 18
        # check for other markup in lines which are not code examples or
        # already injected other markup;
        # SEE Note:Markup for Tool Examples;  SEE Note:Markup for Internal Links
        # quick&dirty: identifying code examples by
        #     $0 o-saft o-saft.tcl o-saft-docker checkAllCiphers.pl perl perlapp perl2exe
        # quick&dirty: should also not match  X& ... & as no other potential
        # markup should be substituted in there
        if (not m/^(?:=|S&|\s+(?:\$0|o-saft|o-saft.tcl|o-saft-docker|checkAllCiphers.pl|perl|perl2exe|perlapp)\s)/
            and not m/X&[^&]*(?:\+|--)/
           ) {  # more markup, ...
            s#(\s)+(a-zA-Z[^ ]+)(\s+)#$1'$2'$3#g;   # markup literal character class as code
            # our commands and options; SEE Note:Markup for Commands and Options
            s#(\s)((?:\+|--)[^,\s).]+)([,\s).])#$1I&$2&$3#g;
                # TODO: fails for something like:  --opt=foo="bar"
                # TODO: above substitute fails for something like:  --opt --opt
                #        hence same substitute again (should be sufficent then)
            s#([A-Z]L)&#$1 &#g;         # SEE Note:Upercase Markup
################ --option=,   extra behandeln
                # quick&dirty to avoid further inerpretation of L& , i.e. SSL
                # ugly hack as it adds a space
            s#(\s)((?:\+|--)[^,\s).]+)([,\s).])#$1I&$2&$3#g;
        }
        if (not m/^S/ and not m/^ {14,}/) {
            # special markup for tools, tool name ending with (1), ... (3pm)
            s/((?:Net::SSLeay|ldd|openssl|timeout|IO::Socket(?:::SSL|::INET)?)\(\d(?:pm)?\))/L&$1&/g;
            # special markup for own tools
            s/((?:Net::SSL(?:hello|info)|o-saft(?:-dbx|-man|-usr|-README)(?:\.pm)?))/L&$1&/g;
        }
        s/  (L&[^&]*&)/ $1/g;
        s/(L&[^&]*&)  /$1 /g;
            # If external references are enclosed in double spaces, we squeeze
            # leading and trailing spaces 'cause additional characters will be
            # added later (i.e. in man_help()). Just pretty printing ...
        if (m/^ /) {
            # add internal links; quick&dirty list here
            # we only want to catch header lines, hence all capital letters
            s/ ((?:DEBUG|RC|USER)-FILE)/ X&$1&/g;
            s/ (CONFIGURATION (?:FILE|OPTIONS))/ X&$1&/g;
            s/ (SHELL TWEAKS)/ X&$1&/g;
            s/ (SEE ALSO)/ X&$1&/g;
            s/ (EXIT STATUS)/ X&$1&/g;
            s/ (CIPHER NAMES)/ X&$1&/g;
            s/ (LAZY SYNOPSIS)/ X&$1&/g;
            s/ (KNOWN PROBLEMS)/ X&$1&/g;
            s/ (BUILD DOCKER IMAGE)/ X&$1&/g;
            s/ (BUILD DOCKER IMAGE)/ X&$1&/g;
            s/ (TECHNICAL INFORMATION)/ X&$1&/g;
            s/ (NAME|CONCEPTS|ENVIRONMENT)/ X&$1&/g;
            s/ (COMMANDS|OPTIONS|RESULTS|CHECKS|OUTPUT|CUSTOMISATION) / X&$1& /g;
            s/ (LIMITATIONS|DEPENDENCIES|INSTALLATION|DOCKER|TESTING) / X&$1& /g;
            s/ (SCORING|EXAMPLES|ATTRIBUTION|DOCUMENTATION|VERSION) / X&$1& /g;
            s/ (DESCRIPTION|SYNOPSIS|QUICKSTART|SECURITY|DEBUG|AUTHOR) / X&$1& /g;
        }
        push(@txt, $_);
    }
    close($fh);
    return _replace_var($parent, $version, @txt);
} # get_markup

# NOTE: NOT YET READY, not yet used (hence no POD also)
#=pod
#
#=head2 get_text($file)
#
#Same as  get()  but with some variables substituted.
#
#=cut

sub get_text    {
    my $file    = shift;
    my $label   = shift || "";  # || to avoid "Use of uninitialised value"
       $label   = lc($label);
    my $anf     = uc($label);
    my $end     = "[A-Z]";
#   _man_dbx("man_help($anf, $end) ...");
    # no special help, print full one or parts of it
    my $txt = join ("", get_markup($file));
#   #if (1 < (grep{/^--v/} @ARGV)) {     # with --v --v
#   #    print scalar reverse "\n\n$egg";
#   #    return;
#   #}
#print "T $txt T";
    if ($label =~ m/^name/i)    { $end = "TODO";  }
    #$txt =~ s{.*?(=head. $anf.*?)\n=head. $end.*}{$1}ms;# grep all data
        # above terrible performance and unreliable, hence in peaces below
    $txt =~ s/.*?\n=head1 $anf//ms;
    $txt =~ s/\n=head1 $end.*//ms;      # grep all data
    $txt = "\n=head1 $anf" . $txt;
    $txt =~ s/\n=head2 ([^\n]*)/\n    $1/msg;
    $txt =~ s/\n=head3 ([^\n]*)/\n      $1/msg;
    $txt =~ s/\n=(?:[^ ]+ (?:\* )?)([^\n]*)/\n$1/msg;# remove inserted markup
    $txt =~ s/\nS&([^&]*)&/\n$1/g;
    $txt =~ s/[IX]&([^&]*)&/$1/g;       # internal links without markup
    $txt =~ s/L&([^&]*)&/"$1"/g;        # external links, must be last one
    if (0 < (grep{/^--v/} @ARGV)) {     # do not use $^O but our own option
        # some systems are tooo stupid to print strings > 32k, i.e. cmd.exe
        _warn("192: using workaround to print large strings.\n\n");
        print foreach split(//, $txt);  # print character by character :-((
    } else {
        #print $txt;
    }
#print "t $txt t";
    if ($label =~ m/^todo/i)    {
        print "\n  NOT YET IMPLEMENTED\n";
# TODO: {
#        foreach my $label (sort keys %checks) {
#            next if (0 >= _is_member($label, \@{$cfg{'commands-NOTYET'}}));
#            print "        $label\t- " . $checks{$label}->{txt} . "\n";
#        }
# TODO: }
    }
    return $txt;
} # get_text

=pod

=head2 print_as_text($file)

Same as  get()  but prints text directly.

=cut

sub print_as_text { my $fh = _get_filehandle(shift); print  <$fh>; close($fh); return; }

=pod

=head1 COMMANDS

If called from command line, like

  OSaft/Doc/Data.pm COMMANDS [file]

this modules provides following COMMANDS:

=head2 VERSION

Print VERSION version.

=head2 version

Print internal version.

=head2 list

Print list of *.txt files in current directory. These files may be used for
following commands.

=head2 get filename

Call get(filename).

=head2 get_as_text filename

Call get_as_text(filename).

=head2 get_markup filename

Call get_markup(filename).

=head2 get_text filename

Call get_text(filename).

=head2 print_as_text filename

Call print_as_text(filename).

=head1 OPTIONS

=over 4

=item --V

Print VERSION version.

=back

=cut

sub list        {
    #? return sorted list of available .txt files
    #  sorted list simplifies tests ...
    my $dir = $0;
       $dir =~ s#[/\\][^/\\]*$##;
    my @txt;
    opendir(DIR, $dir) or return $!;
    while (my $file = readdir(DIR)) {
        next unless (-f "$dir/$file");
        next unless ($file =~ m/\.txt$/);
        push(@txt, $file);
    }
    closedir(DIR);
    return join("\n", sort @txt);
} # list

#_____________________________________________________________________________
#____________________________________________________ internal test methods __|

# none, piblic methods used directly

#_____________________________________________________________________________
#___________________________________________________ initialisation methods __|

# none

#_____________________________________________________________________________
#_____________________________________________________________________ main __|

sub _main_doc_usage {
    #? print usage
    my $name = (caller(0))[1];
    print "# various commands:\n";
    foreach my $cmd (qw(version +VERSION)) {
        printf("\t%s %s\n", $name, $cmd);
    }
    printf("\t$name list\t# list available files\n");
    print "# commands to get text from file in various formats(examples):\n";
    foreach my $cmd (qw(get get-markup get-text get-as-text print)) {
        printf("\t%s %s help.txt\n", $name, $cmd);
    }
    printf("\t$name ciphers=dumptab > c.csv; libreoffice c.csv\n");
    return;
}; # _main_doc_usage

sub _main_doc   {
    #? print own documentation or that from specified file
    ## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
    #  see t/.perlcriticrc for detailed description of "no critic"
    my @argv = @_;
    #  SEE Perl:binmode()
    binmode(STDOUT, ":unix:utf8");
    binmode(STDERR, ":unix:utf8");
    print_pod($0, __PACKAGE__, $SID_data)       if (0 > $#argv);
    # got arguments, do something special
    while (my $cmd = shift @argv) {
        my $arg    = shift @argv; # get 2nd argument, which is filename
        print_pod($0, __PACKAGE__, $SID_data)   if ($cmd =~ /^--?h(?:elp)?$/);
        _main_doc_usage()       if ($cmd eq '--usage');
        # ----------------------------- commands
        print list() . "\n"     if ($cmd =~ /^list$/);
        print get($arg)         if ($cmd =~ /^get$/);
        print get_as_text($arg) if ($cmd =~ /^get.?as.?text/);
        print get_markup($arg)  if ($cmd =~ /^get.?mark(up)?/);
        print get_text($arg)    if ($cmd =~ /^get.?text/);
        print_as_text($arg)     if ($cmd =~ /^print$/);
        print "$SID_data\n"     if ($cmd =~ /^version$/);
        print "$VERSION\n"      if ($cmd =~ /^[-+]?V(ERSION)?$/);
    }
    exit 0;
} # _main_doc

sub doc_data_done   {}; # dummy to check successful include

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

=pod

=head1 MARKUP

Following notations / markups are used for public (user) documentation
(for example help.txt):

=over 2

=item TITLE

Titles start at beginning of a line, i.g. all upper case characters.

=item SUB-Title

Sub-titles start at beginning of a line preceeded by 4 or 6 spaces.

=item code

Code lines start at beginning of a line preceeded by 14 or more spaces.

=item "text in double quotes"

References to text or cite.

=item 'text in single quotes'

References to verbatim text elsewhere or constant string in description.

It is difficult to markup character classes like  a-zA-Z-  this way (using
quotes), because any character may be part of the class, including quotes or
those used for markup. For Example will  a-zA-Z-  look like  C<a-zA-Z->  in
POD format. Hence character classes are defined literally without markup to
avoid confusion.  However, when generating documentation it is assumed that
strings (words) beginning with  a-zA-Z  are character classes.

=item '* list item

Force list item (first level) in generated markup.

=item ** list item

Force list item (second level) in generated markup.

=item d) list item

Force list item in generated markup (d may be a digit or character).

=item $VERSION

Will be replaced by current version string (as defined in caller).

=item $0

Will be replaced by caller's name (i.g. o-saft.pl).

=item `$0'

Will not be replaced, but kept as is.

=back

Referenses to titles are written in all upper case characters and prefixed
and suffixed with 2 spaces or a . (dot) or , (comma).

There is only one special markup used:

=over 2

=item X&Some title here&

Which refers to sub-titles. It must be used to properly markup internal
links to sub-sections if the title is not written in all upper case.

=back

All head lines for sections (see TITLE above) must be preceded by 2 empty
lines. All head lines for commands and options should contain just this command
or option. Aliases for commands or options should be written in their own line
(to avoid confusion in some other parsers, like Tcl).

List items should be followed by an empty line.

Texts in section headers should not contain any quote characters.  I.g. no
other markup is used. Even lines starting with  '#'  as first character are
usually not treated as comment line but verbatim text.

=head2 Special markups

=head3 Left hand space

=over 6

=item none        - head line level 1

=item exactly 4   - head line level 2

=item exactly 6   - head line level 3

=item exactly 11  - list item

=item exactly 14  - code line

=back

=head3 Left hand *:

=over 6

=item spaces *    - list item level 1

=item spaces **   - list item level 2

=back

=head3 Left hand digit or letter followed by )

List item may start with letter or digit fowwed by ) .

=head3 Special markups for o-saft.tcl

The sub-titles in the COMMANDS and OPTIONS sections must look like:

=over 6

=item Commands for whatever text

=item Commands to whatever text

=item Options for whatever text

=back

Means that the prefixes  "Commands for"  and  "Options for"  are used to
identify groups of commands and options. If a sub-title does not start
with these prefixes, all following commands and options are ignored.


=head1 SEE ALSO

# ...


=head1 VERSION

1.56 2022/11/04


=head1 AUTHOR

17-oct-17 Achim Hoffmann

=cut

## PACKAGE }
} # OSaft/Doc/Data.pm

{ # o-saft-usr.pm
## PACKAGE {

#!# Copyright (c) 2022, Achim Hoffmann
#!# This  software is licensed under GPLv2. Please see o-saft.pl for details.

package main;   # ensure that main:: variables are used

## no critic qw(Documentation::RequirePodSections)
# SEE Perl:perlcritic


use warnings;

no warnings 'redefine'; ## no critic qw(TestingAndDebugging::ProhibitNoWarnings)
   # must be herein, as most subroutines are already defined in main
   # warnings pragma is local to this file!

BEGIN { # mainly required for testing ...
    # SEE Perl:BEGIN perlcritic
    my $_path = $0;     $_path =~ s#[/\\][^/\\]*$##x;
    unshift(@INC, $_path)   if (1 > (grep{/^$_path$/} @INC));
    unshift(@INC, "..")     if (1 > (grep{/^\.\.$/}   @INC));
    unshift(@INC, ".")      if (1 > (grep{/^\.$/}     @INC));
}

#-# use OSaft::Text qw(%STR print_pod);

my  $SID_usr    = "@(#) o-saft-usr.pm 2.6 22/10/31 20:24:01";


#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

=pod

=encoding utf8


=head1 _____________________________________________________________________________

=head1 NAME

o-saft-usr.pm - module for o-saft.pl's user definable functions

=head1 SYNOPSIS

=over 2

=item require q{o-saft-usr.pm};     # in perl code

=item o-saft-usr.pm --help          # on command-line will print help

=back


=head1 DESCRIPTION

Defines all functions for user customisation.

WARNING: this is not a perl module defined with `package', but uses:
    package main;
hence is is recommended that all variables and function use a unique
prefix like:
    usr_  or _usr_

=head2 Functions defined herein

=over 4

=item usr_pre_init( )

At beginning, right before initialising internal data.

=item usr_pre_file( )

At beginning, right after initialising internal data.

=item usr_pre_args( )

Right before reading command-line arguments.  All internal structures
and variables are initialised, all external files are read (except
configuration files specified witj  I<--cfg_*=>  option.

=item usr_pre_exec( )

All command-line arguments are read. Right before executing myself.

=item usr_pre_cipher( )

Before getting list of ciphers.

=item usr_pre_main( )

Before executing commands.

=item usr_pre_host( )

Before starting loop over all given hosts.

=item usr_pre_info( )

DNS stuff and SNI connection checked. Before doing commands per host.

=item usr_pre_open( )

Before opening connection.

=item usr_pre_cmds( )

Before listing or checking anything.  SSL connection  is open and all
data available in  $Net::SSLinfo::* .

=item usr_pre_data( )

All data according SSL connection and ciphers available in %data  and
@results. Before doing any checks and before printing anything.

=item usr_pre_print( )

All checks are done, ready to print data from %checks also.

=item usr_pre_next( )

Host completely processed. Right before next host.

=item usr_pre_exit( )

Right before program exit.

=item usr_version()

Return version of this interface.

=back

=head2 Variables which may be used herein

They must be defined as `our' in L<o-saft.pl|o-saft.pl>:

=over 4

=item $VERSION

=item %data

=item %cfg, i.e. trace, traceARG, traceCMD, traceKEY, verbose

=item %checks

=item %org

=back

Functions being used in L<o-saft.pl|o-saft.pl> shoudl be defined as empty stub there.
For example:

#   sub usr_pre_args() {}

=cut

#_____________________________________________________________________________
#__________________________________________________________________ methods __|

sub _usr_dbx { my @args = @_; _trace(join(" ", @args, "\n")); return; } # requires --v

# user functions
# -------------------------------------
# These functions are called in o-saft.pl

sub usr_version     { return "16.09.16"; }  # changed only if fucntionality changed!

sub usr_pre_init    {
    _usr_dbx("usr_pre_init ...");
    return;
};

sub usr_pre_file    {
    _usr_dbx("usr_pre_file ...");
    return;
};

sub usr_pre_args    {
    _usr_dbx("usr_pre_args ...");
    return;
};

sub usr_pre_exec    {
    _usr_dbx("usr_pre_exec ...");
    # All arguments and options are parsed.
    # Unknown commands are not available with _is_do() but can be
    # searched for in cfg{'done'}->{'arg_cmds'} which allows users
    # to "create" and use their own commands without changing 
    # o-saft.pl itself. However, o-saft.pl will print a WARNING then.
    return;
};

sub usr_pre_cipher  {
    _usr_dbx("usr_pre_cipher ...");
    return;
};

sub usr_pre_main    {
    _usr_dbx("usr_pre_main ...");
    return;
};

sub usr_pre_host    {
    _usr_dbx("usr_pre_host ...");
    return;
};

sub usr_pre_info    {
    _usr_dbx("usr_pre_info ...");
    return;
};

sub usr_pre_open    {
    _usr_dbx("usr_pre_open ...");
    ###
    ### sample code for using your own socket
    ###
    #use IO::Socket;
    #$Net::SSLinfo::socket = IO::Socket::INET->new(PeerHost=>'localhost', PeerPort=>443, Proto=>'tcp') 
    #or die "**ERROR usr_pre_open socket(): $!\n";
    return;
};

sub usr_pre_cmds    {
    _usr_dbx("usr_pre_cmds ...");
    return;
};

sub usr_pre_data    {
    _usr_dbx("usr_pre_data ...");
    return;
};

sub usr_pre_print   {
    _usr_dbx("usr_pre_print ...");
    return;
};

sub usr_pre_next    {
    _usr_dbx("usr_pre_next ...");
    return;
};

sub usr_pre_exit    {
    _usr_dbx("usr_pre_exit ...");
    return;
};

sub _main_usr       {
    my $arg = shift || "--help";    # without argument print own help
    ## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
    #   see t/.perlcriticrc for detailed description of "no critic"
    #  SEE Perl:binmode()
    binmode(STDOUT, ":unix:utf8");
    binmode(STDERR, ":unix:utf8");
    print_pod($0, __FILE__, $SID_usr)   if ($arg =~ m/--?h(elp)?$/x);
    # no other options implemented yet
    print "$SID_usr\n"      if ($arg =~ /^version$/);
   #print "$VERSION\n"      if ($arg =~ /^[-+]?V(ERSION)?$/);
    exit 0;
} # _main

sub usr_done        {}; # dummy to check successful include

=pod

=head1 VERSION

2.6 2022/10/31

=head1 AUTHOR

13-nov-13 Achim Hoffmann

=cut

## PACKAGE }
} # o-saft-usr.pm

{ # o-saft-man.pm
## PACKAGE {

#!# Copyright (c) 2022, Achim Hoffmann
#!# This  software is licensed under GPLv2. Please see o-saft.pl for details.

package main;   # ensure that main:: variables are used

## no critic qw(RegularExpressions::ProhibitCaptureWithoutTest)
# NOTE:  This often happens in comma separated statements, see above.
#        It may also happen after postfix statements.
#        Need to check regularily for this problem ...

## no critic qw(RegularExpressions::ProhibitComplexRegexes)
#        Yes, we have very complex regex here.

## no critic qw(RegularExpressions::RequireExtendedFormatting)
#        We believe that most RegEx are not too complex.

## no critic qw(InputOutput::RequireBriefOpen)
#        We always close our filehandles, Perl::Critic is too stupid to read
#        over 15 lines.

## no critic qw(Documentation::RequirePodSections)
#        Perl::Critic is uses a strange list of required sections in POD.
#        See  t/.perlcriticrc .

## no critic qw(Variables::ProhibitPunctuationVar)
#        We want to use $\ $0 etc.

## no critic qw(Variables::ProhibitPackageVars)

## no critic qw(ControlStructures::ProhibitPostfixControls  Modules::RequireVersionVar)
## no critic qw(RegularExpressions::RequireDotMatchAnything RegularExpressions::RequireLineBoundaryMatching)
## no critic qw(ValuesAndExpressions::ProhibitEmptyQuotes   RegularExpressions::ProhibitFixedStringMatches)
## no critic qw(ValuesAndExpressions::ProhibitMagicNumbers  ValuesAndExpressions::RequireUpperCaseHeredocTerminator)
## no critic qw(ValuesAndExpressions::ProhibitNoisyQuotes   )
## no critic qw(BuiltinFunctions::ProhibitBooleanGrep       BuiltinFunctions::ProhibitStringySplit)
#        Keep severity 2 silent.
# NOTE:  Modules::RequireVersionVar fails because the "no critic" pragma is to late here.


use warnings;
use vars qw(%checks %data %text); ## no critic qw(Variables::ProhibitPackageVars)
use utf8;
# binmode(...); # inherited from parent

BEGIN {     # SEE Perl:BEGIN perlcritic
    # SEE Perl:@INC
    my $_me   = $0;     $_me   =~ s#.*[/\\]##;
    my $_path = $0;     $_path =~ s#[/\\][^/\\]*$##;
    unshift(@INC, $_path)   if (1 > (grep{/^$_path$/} @INC));
    unshift(@INC, "..")     if (1 > (grep{/^\.\.$/}   @INC));
    unshift(@INC, ".")      if (1 > (grep{/^\.$/}     @INC));
}

#-# use OSaft::Text qw(%STR print_pod);
#-# use OSaft::Ciphers; # required if called standalone only

my  $SID_man= "@(#) o-saft-man.pm 2.84 22/11/21 18:46:50";
my  $parent = (caller(0))[1] || "O-Saft";# filename of parent, O-Saft if no parent
    $parent =~ s:.*/::;
    $parent =~ s:\\:/:g;                # necessary for Windows only
my  $ich    = (caller(1))[1];           # tricky to get filename of myself when called from BEGIN
    $ich    = "o-saft-man.pm" if (not defined $ich); # sometimes it's empty :-((
    $ich    =~ s:.*/::;
my  $version= "$SID_man";               # version of myself
    $version=~ s:^.{5}::;               # remove leading @(#) as already part of the *.txt files
    $version=  _VERSION() if (defined &_VERSION); # or parent's if available
my  $cfg_header = 0;                    # we may be called from within parents BEGIN, hence no %cfg available
    $cfg_header = 1 if (0 < (grep{/^--header/} @ARGV));
my  $mytool = qr/(?:$parent|o-saft.tcl|o-saft|checkAllCiphers.pl)/;# regex for our tool names
my  @help   = OSaft::Doc::Data::get_markup("help.txt", $parent, $version);
our $VERBOSE    = 0;  # >1: option --v
    $VERBOSE++ if (0 < $cfg{'verbose'});# if called via o-saft.pl
   # VERBOSE instead of verbose because of perlcritic
local $\    = "";

# SEE Note:Stand-alone
$::osaft_standalone = 0 if not defined $::osaft_standalone; ## no critic qw(Variables::ProhibitPackageVars)

#_____________________________________________________________________________
#_____________________________________________ texts for user documentation __|

# Following texts are excerpts or abstracts of the user documentation defined
# in   OSAFT/Doc/help.txt .
# Currently (2021) it is difficult to extract them programmatically from that
# file. For better maintenance, they are defined here as internal variables.
# TODO needs to be computed from OSAFT/Doc/help.txt, somehow ...

my $_cmd_brief  = <<'EoBrief';
+info             Overview of most important details of the SSL connection.
+cipher           Check target for ciphers (using libssl).
+check            Check the SSL connection for security issues.
+protocols        Check for protocols supported by target.
+vulns            Check for various vulnerabilities.
EoBrief

my $_commands   = <<'EoCmds';
                  Commands for information about this tool
+dump             Dumps internal data for SSL connection and target certificate.
+exec             Internal command; should not be used directly.
+help             Complete documentation.
+list             Show all ciphers supported by this tool.
+libversion       Show version of openssl.
+quit             Show internal data and exit, used for debugging only.
+VERSION          Just show version and exit.
+version          Show version information for program and Perl modules.

                  Commands to check SSL details
+bsi              Various checks according BSI TR-02102-2 and TR-03116-4 compliance.
+check            Check the SSL connection for security issues.
+check_sni        Check for Server Name Indication (SNI) usage.
+ev               Various checks according certificate's extended Validation (EV).
+http             Perform HTTP checks.
+info             Overview of most important details of the SSL connection.
+info--v          More detailled overview.
+quick            Quick overview of checks.
+protocols        Check for protocols supported by target.
+s_client         Dump data retrieved from  "openssl s_client ..."  call.
+sizes            Check length, size and count of some values in the certificate.
+sni              Check for Server Name Indication (SNI) usage.
+sts              Various checks according STS HTTP header.
+vulns            Check for various vulnerabilities.

                  Commands to test ciphers provided by target
+cipher           Check target for ciphers (using libssl).
+cipher-dh        Check target for ciphers (using libssl), prints also DH parameter.
+cipher-default   Check target for (default) selected cipher for each protocol.
+cipher-null      Check if target accepts NULL ciphers.
+cipher-adh       Check if target accepts ciphers with anonymous key exchange.
+cipher-exp       Check if target accepts EXPORT ciphers.
+cipher-cbc       Check if target accepts CBC ciphers.
+cipher-des       Check if target accepts DES ciphers.
+cipher-rc4       Check if target accepts RC4 ciphers.
+cipher-edh       Check if target supports ephemeral ciphers.
+cipher-pfs       Check if target supports ciphers with PFS.
+cipher-strong    Check if target selects strongest cipher.
+cipher-selected  Selected cipher.

EoCmds

my $_voodoo     = <<'EoHelp';
# begin voodoo

# Some documentation is plain text, which is  DATA  in Perl sources. As such,
# it  is  not detected as source,  not as comment,  and  not as documentation
# by most tools analyzing the source code.
# O-Saft's public user documentation is plain text stored in  separate files.
# These files are usually also not counted as source.
# Unfortunately, some people solely believe in statistics generated by  magic
# tools. They use such statistics to measure for example code quality without
# looking themself at the code.
# Hence the purpose of this file is to provide real comment and documentation
# lines from our documentation in format of the used programming language.
# Hopefully, if these people read this, they change the workflow (means: they
# also review the source code) or adapt their conclusions having in mind that
# statistics can be manipulated in many ways. Here we go ...
#
# Disclaimer: No offence meant anyhow, neither against any analyzing tool nor
# against anyone using them. It is just a reminder to use the tools and their
# results in a wise manner. Measuring quality is more than just automatically
# generated statistics!

# end voodoo
EoHelp

#_____________________________________________________________________________
#____________________________________________________________ HTML snippets __|

my %html = (
    'title'         => 'O - S a f t  --  OWASP - SSL advanced forensic tool',

    'nonce'         => '4f2d53616674',
    'script_nonce'  => '<script nonce="4f2d53616674">',

    'doctype'       => "<!DOCTYPE html>\n",

    'copyright'     => << 'EoCOPY',
 <hr><p><span style="display:none">&copy; Achim Hoffmann 2022</span></p>
EoCOPY

    'links'         => << 'EoLINK',
 <a href="https://github.com/OWASP/O-Saft/"   target=_github >Repository</a> &nbsp;
 <a href="https://github.com/OWASP/O-Saft/blob/master/o-saft.tgz" target=_tar class=b >Download (stable)</a>
 <a href="https://github.com/OWASP/O-Saft/archive/master.zip" target=_tar class=b >Download (newest)</a><br><br>
 <a href="https://owasp.org/www-project-o-saft/" target=_owasp  >O-Saft Home</a>
EoLINK

    'action'        => '__HTML_cgi_bin__',

    'meta'          => << 'EoMETA',

  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <meta http-equiv="Content-Security-Policy" content="script-src 'unsafe-inline'">
  <!-- CSP in meta tag is not recommended, but it servs as hint how to set
       the HTTP header Content-Security-Policy -->
  <meta name="viewport" content="width=device-width,initial-scale=0.4">
  <title>__HTML_title__</title>
EoMETA

    'script_func1'  => << 'EoFUNC',

  function _i(id){return document.getElementById(id);}
  function toggle_checked(id){id=_i(id);id.checked=(id.checked=='false')?'true':'false';}
  function toggle_display(id){
	if("string" === typeof id){ id=_i(id).style; } else { id=id.style };
	if("" === id.display){ id.display='none';} /* Chrome hack */
	id.display = (id.display=='none')?'block':'none';
	return false;
  }
  function schema_is_file(){
	if (/^file:/.test(location.protocol)===true) { return true; }
	return false;
  }

EoFUNC

    'script_func2'  => << 'EoFUNC',

  function osaft_buttons(){
  // generated buttons for most common commands in <table id="osaft_buttons">
	var buttons = ['+quick', '+check', '+cipher', '+info', '+protocols', '+vulns' ];
	var table   = _i('osaft_buttons');
	for (var b in buttons) {
	        // <input type=submit name="--cmd" value="+check" ><div class=q
	        // id='c+check'></div><br>
	        tr = document.createElement('TR');
	        td = document.createElement('TD');
	        cc = document.createElement('INPUT');
	        cc.type   = 'submit'; cc.name='--cmd'; cc.value=buttons[b];
	        cc.title  = 'execute: o-saft.pl ' + buttons[b];
	        //cc.target = 'o-saft.pl_' + buttons[b];
	        td.appendChild(cc);
	        tr.appendChild(td);
	        td = document.createElement('TD');
	        td.setAttribute('class', 'q');
	        td.id='q' + buttons[b];
	        tr.appendChild(td);
	        table.appendChild(tr);
	}
	return;
  }
  function osaft_commands(){
  /* get help texts from generated HTML for commands and add it to command
   * button (generated by osaft_buttons, see above) of cgi-GUI
   * existing  tag of text paragraph containing help text has  id=h+cmd
   * generated tag of  quick button  containing help text has  id=q+cmd
   */
	osaft_buttons();
	var arr = document.getElementsByTagName('p');
	for (var p=0; p<arr.length; p++) {
	    if (/^h./.test(arr[p].id)===true) {
	        var id = arr[p].id.replace(/^h/, 'q');
	        if (_i(id) != undefined) {
	            // button exists, add help text
	            _i(id).innerHTML = _i(arr[p].id).innerHTML;
	        }
	    }
	}
	return;
  }
  function osaft_options(){
  /* get help texts from generated HTML for options and add it to option
   * checkbox of cgi-GUI (actually add it to the parent's title tag)
   * existing  tag of text paragraph containing help text has  id=h--OPT
   * generated tag of quick checkbox containing help text has  id=q--OPT
   */
	var arr = document.getElementsByTagName('p');
	for (var p=0; p<arr.length; p++) {
	    if (/^h./.test(arr[p].id)===true) {
	        var id = arr[p].id.replace(/^h/, 'q');
	        // TODO: *ssl and *tls must use *SSL
	        if (_i(id) != undefined) {
	            obj = _i(id).parentNode;
	            if (/^LABEL$/.test(obj.nodeName)===true) {
	                // checkbox exists, add help text to surrounding
	                // LABEL
	                obj.title = _i(arr[p].id).innerHTML;
	            }
	        }
	    }
	}
	return;
  }
  function osaft_enable(){
  /* check all input fields with type=text if they are disabled, which was set
   * by osaft_submit(), then removes the disabled attribute for these tags
   */
	var arr = document.getElementsByTagName('input');
	for (var tag=0; tag<arr.length; tag++) {
	    if (/^text$/.test(arr[tag].type)===true) {
	        arr[tag].removeAttribute('disabled');
	    }
	}
	return;
  }
  function osaft_submit(){
  /* check all input fields with type=text, if its value is empty the attribute
   * disabled is added to the input tag to ensure that no  name=value  for this
   * input field will be submitted
   * return true (so that the form will be submitted)
   */
	var arr = document.getElementsByTagName('input');
	for (var tag=0; tag<arr.length; tag++) {
	    if (/^text$/.test(arr[tag].type)===true) {
	        if (arr[tag].value === '') {
	            arr[tag].setAttribute('disabled', true);
	        }
	    }
	}
	// ensure that all input fields are enabled again after submit
	setTimeout("osaft_enable()",2000);
	return true;
  }
  function osaft_handler(from,to){
  /* set form's action and a's href attribute if schema is file:
   * replace all href attributes also to new schema
   */
	var rex = new RegExp(from.replace(/\//g, '.'),"");  // lazy convertion to Regex
	var url = document.forms["o-saft"].action;          // in case we need it
	if (/^file:/.test(location.protocol)===false) { return false; } // not a file: schema
	var arr = document.getElementsByTagName('form');
	for (var tag=0; tag<arr.length; tag++) {
	    if (rex.test(arr[tag].action)===true) {
	        arr[tag].action = arr[tag].action.replace(rex, to).replace(/^file:/, 'osaft:');
	    }
	}
	//dbx// alert(document.forms["o-saft"].action);
	var arr = document.getElementsByTagName('a');
	for (var tag=0; tag<arr.length; tag++) {
	    if (rex.test(arr[tag].href)===true) {
	        arr[tag].href = arr[tag].href.replace(rex, to).replace(/^file:/, 'osaft:');
	    }
	}
	return false;
  }
  function osaft_disable_help(){
  // disable help-buttons
	return;  // -- NOT YET WORKING --
	var arr = document.getElementsByTagName('a');
	for (var p=0; p<arr.length; p++) {
	    if (arr[p].className==="b") {
	        arr[p].setAttribute('disabled', true);  // not working
	        arr[p].setAttribute('display', 'none'); // not working
	        //arr[p].disabled = true;  // not working
	        //alert(arr[p].href+" "+arr[p].display);
	    }
	}
	return;
  }
  function toggle_handler(){
  // toggle display of "schema" button
	if (true===schema_is_file()) { return; }
	toggle_display("schema");
	return;
  }
EoFUNC

    'script_endall' => << 'EoFUNC',

 <script nonce="4f2d53616674">
  /* keep JavaScript's DOM happy */
  if (_i('a')){ _i('a').style.display='block'; }
  if (_i('b')){ _i('b').style.display='none';  }
  if (_i('c')){ _i('c').style.display='none';  }
  if (_i('warn')){ _i('warn').style.display='block'; }
  /* adapt display of some buttons (if corresponding function exists) */
  if ("function" === typeof osaft_disable_help) {
    if (true === schema_is_file()) { osaft_disable_help(); }
  }
  if ("function" === typeof toggle_handler) { toggle_handler(); }
 </script>
EoFUNC

    'script_endcgi' => << 'EoFUNC',

 <script nonce="4f2d53616674">
  var osaft_action_http="__HTML_cgi_bin__"; // default action used in FORM and A tags; see osaft_handler()
  var osaft_action_file="/o-saft.cgi";      // default action used if file: ; see osaft_handler()
  osaft_commands("a");              // generate quick buttons
  osaft_options();                  // generate title for quick options
  toggle_handler();                 // show "change schema" button if file:
  toggle_checked("q--header");      // want nice output
  toggle_checked("q--enabled");     // avoid huge cipher lists
  toggle_checked("q--no-tlsv13");   // most likely not yet implemented
  toggle_checked("o--header");      // .. also as option ..
  toggle_checked("o--enabled");     // .. also as option ..
  toggle_checked("o--no-tlsv13");   // .. also as option ..
 </script>
EoFUNC

    'style_root'    => << 'EoROOT',

/* variable definitions */
 :root {
    /* color and background */
    --bg-osaft:     #fff;
    --bg-black:     #000;
    --bg-blue:      #226;               /* darkblue  */
    --bg-head:      linear-gradient(#000,#fff);    /* black,white */
    --bg-menu:      linear-gradient(#000,#aaa);    /* black,grey */
    --bg-mbox:      rgba(0,0,0,0.9);
    --bg-mdiv:      linear-gradient(#fff,#226);
    --bg-button:    linear-gradient(#d3d3d3,#fff);  /* lightgray */
    --bg-start:     linear-gradient(#ffd700,#ff0);  /* gold */
    --bg-start-h:   linear-gradient(#ff0,#ffd700);  /* gold */
    --bg-hover:     #d3d3d3;            /* lightgray */
    --bg-literal:   #d3d3d3;            /* lightgray */
    --border-0:     0px solid #fff;
    --border-1:     1px solid #000;     /* black */
    --border-w:     1px solid #fff;     /* white */
    --radius-10:    0px 10px 10px 10px;
    --radius-20:    0px  0px 20px 20px;
    --shadow:       1px  4px  4px #666;
 }
EoROOT

    'style_button'  => << 'EoButton',

 [type=submit] {        /* submit/start buttons */
    text-align:     left;
    font-size:      80%;
    font-weight:    bold;
    min-width:      10em;
    background:     var(--bg-start);
    box-shadow:     var(--shadow);
    border:         var(--border-1);
    border-radius:  4px;
 }
 [type="submit"]:hover  { background:var(--bg-start-h); }

 .navdiv div a, .b {    /* help buttons */
    display:        block;
    margin:         0.2em;
    padding:        0px 0.2em 0px 0.2em;
    text-decoration:none;
    font-size:      90%;
    font-weight:    bold;
    color:          #000;
    background:     var(--bg-button);
    box-shadow:     var(--shadow);
    border:         var(--border-1);
    border-radius:  4px;
   }
 .b { display: inline-block; }              /* ^top and start button */
EoButton

    'style'         => << 'EoSTYLE',

 body   { margin:0px 0.5em 0px 0.5em; background:#f2eff2; font: 16pt Arial, Helvetica, sans-serif; }
/* { page header */
 body > h2          { margin: 0px -0.3em 0px -0.3em; padding:1em; background:var(--bg-head);color:white;border-radius:var(--radius-20); }
 body > h2 > span   { margin-bottom:2em;font-size:120%;border:var(--border-0);}
/* } page header */
/* { help page only */
 h3, h4, h5         { margin-bottom: 0.2em; }
 body > h3          { margin-top:    1.2em; }
 body   h4          { margin-left:     1em; }       /* mainly +cmd and --opt */
/* } help page only */
/* { cgi page only */
 body h4 [class="i"] {margin-left:    -1em; }       /* mainly +cmd and --opt */
 fieldset           { margin:     0px;  }
 fieldset > details:nth-child(2) > div  { z-index:2; } /* "Simple GUI" on top */
 fieldset > details > div       { margin:0.1em 0.55em 0px -0.85em; background:white; overflow-y:scroll; }
/*
fieldset > details > div:focus  { display:block; } // geht nicht
*/
/* for menu bar left vertical instead top horizontal:
 *   .navdiv { float:left; }
 *   .navdiv > details  { min-width:4em; }
*/
 .navdiv            { background:black; color:white; padding:0.3em; min-height:1.5em; font-weight:bold; position:sticky; top: 0px; z-index:5 }
 .navdiv > details:first-child >summary  { list-style:none; font-size:120%; max-width:2em !important; }
 .navdiv > details:first-child { margin-left:0.1em; }
 .navdiv > details       { margin-left: 0.8em; float:left; }
 .navdiv > details   div { margin-left:-0.3em; background:var(--bg-menu); z-index:3;  }
 .navdiv > details > div > input[type="submit"]  { display:block; }
 .navdiv > details > div > label         { font-weight:normal; display:block; }
 .navdiv > details > div > details > div { margin-left:0.8em; } /* submenu */
 details > div           { padding:0.5em; border:var(--border-1); border-radius:var(--radius-10); position:absolute; }
 details > div > li      { margin-left: 2.2em; }    /* lists in texts        */
 details > div > table   { font-size:   100%;  }    /* Simple GUI (unsure why necessary)*/
 details[open] > summary { text-decoration:underline; }
/* } cgi page only */
 li                 { margin-left: 1.2em; }         /* lists in texts        */
 li[class="n"]      { margin-left: 2.2em; list-style-type:none; } /* "comments" in text */
 p                  { margin: 0px 0px 0.5em 1em; }  /* all texts     */
 p > a[class="b"]   { margin-left:-1em; }           /* ^top button only      */
 label[class="i"]   { margin-right:1em; min-width:8em; border:var(--border-w); display:inline-block; } 
 label[class="i"]:hover { background:var(--bg-hover);border-bottom:var(--border-1);}
 b                  { margin-left: 1em; }           /* for discrete commands #FIXME: wrong in cgi page */
 .r                 { float:right;      }           /* help buttons          */
 .l                 { margin-left: 2em; }           /* label for options     */
 .c                 { margin-left: 3em; padding:0.1em;  font-size:12pt !important; font-family:monospace; background:var(--bg-literal);} /* literal text block; #TODO: white-space:pro   */
 span[class="c"]    { margin-left:0.1em;}           /* literal text (inline) */
/* dirty hack for mobile-friendly A tag's title= attribute;
 * placed left bound below tag; browser's title still visible
 * does not work for BUTTON and INPUT tags
 */
 [title]            { position:relative; }
 a[class="b"][title]:hover:after,
 a[class="b r"][title]:hover:after {
    content: attr(title);
    position:absolute; z-index:99; top:100%; left:-1em; padding:0.3em;
    border-radius:2px; background:var(--bg-mbox); color:white;
    font-weight:normal;
 }
EoSTYLE

    'style_ciphers' => << 'EoSTYLE_C',

 body                 {padding:   1em;       }
 body > h1            {padding-top:1em;  margin-top:1em; }
 body > h2            {padding:   1em;   margin-top:-0.3em; height:1.5em;width:94%;color:white;background:linear-gradient(#000,#fff);border-radius:0px 0px 20px 20px;box-shadow:0 5px 5px #c0c0c0;position:fixed;top:0px; }
 body > h2 > span     {font-size:120%; }
 h2 > a[class="b"]    {float:right;      margin-top:1em; font-size:70%; border-radius:5px;}
 /* table { border-collapse: collapse; } * nicht verwenden */
 /* table { table-layout: fixed;       } * geht nicht      */
 table th    {background:#aaa;   }
 tbody tr:nth-child(even) {background:#fff; }
 tbody tr:nth-child(odd)  {background:#eee; }
 tbody td:first-child   {text-align:right;  }
 tbody td               {width: 5em;        }
 thead                  {position: sticky; top:3em; }
 details                {padding: 0.2em; font-weight:bold;     }
 details:nth-child(even){background:#fff;   }
 details:nth-child(odd) {background:#eee;   }
 details summary:hover  {background:#ffd700;}
 details span:first-child  {text-align:right; min-width:15em;  }
 details span           {padding:   0.2em; display:inline-block; min-width:6em; border-radius:4px 4px 4px 4px; }
 details div            {margin-top:0.5ex; font-size:90%; border:1px solid #000; border-top:0px solid #000; border-radius:0px 0px 10px 10px; }
 details dl             {padding:   0.2em; display:block;        }
 details dt,dd          {padding:   0.5ex; display:inline-block; }
 details dt             {min-width: 12em;  text-align:left;font-weight:bold;}
 /* automatically generate colour of tag based on the sec attribute */
 [sec="-"]              {background-color:#f00; }
 [sec^="weak"]          {background-color:#f00; }
 [sec^="WEAK"]          {background-color:#f00; }
 [sec="-?-"]            {background-color:#ff0; }
 [sec^="LOW"]           {background-color:#fd8; }
 [sec^="medium"]        {background-color:#ff4; }
 [sec^="MEDIUM"]        {background-color:#ff4; }
 [sec^="high"]          {background-color:#4f4; }
 [sec^="HIGH"]          {background-color:#3f3; }
 [typ="PFS"]            {background-color:#4f4; }
 /* automatically generate content if tag from attribute typ= */
 [typ]::before          {content:attr(typ);     }
 dd[typ]                {border:1px solid #ffd700;}
 td[typ]                {border:1px solid #fff; }
 [typ]:hover            {border:1px solid #aaa; }
 [typ]:hover ::after    {border:1px solid #000; border-radius:3px; position:absolute; margin-left:0.5em; background:#fd8; min-width:19em; }
 /* following definitons should be generated from OSaft/Doc/glossar.txt  */
 /* sequence of following definitions important: more lacy pattern first */
 [typ="-"]:hover       ::after  {content:"\2014  none / null / nothing";}
 [typ="-?-"]:hover     ::after  {content:"\2014  unknown";}
 [typ^="ADH"]:hover    ::after  {content:"\2014  Anonymous Diffie-Hellman";}
 [typ="AEAD"]:hover    ::after  {content:"\2014  Authenticated Encryption with Additional Data";}
 [typ^="AES"]:hover    ::after  {content:"\2014  Advanced Encryption Standard";}
 [typ="AESGCM"]:hover  ::after  {content:"\2014  AEAD algorithms AEAD_AES_128_GCM and AEAD_AES_256_GCM";}
 [typ^="ARIA"]:hover   ::after  {content:"\2014  128-bit symmetric block cipher";}
 [typ="ARIAGCM"]:hover ::after  {content:"\2014  symmetric key block cipher encryption algorithm with GCM";}
 [typ="CAMELLIA"]:hover    ::after  {content:"\2014  symmetric key block cipher encryption algorithm";}
 [typ="CAMELLIAGCM"]:hover ::after  {content:"\2014  CAMELLIA with GCM";}
 [typ="CAST"]:hover    ::after  {content:"\2014  Carlisle Adams and Stafford Tavares, block cipher";}
 [typ="CBC"]:hover     ::after  {content:"\2014  Cyclic Block Chaining (aka Cypher Block Chaining)";}
 [typ^="CECPQ"]:hover  ::after  {content:"\2014  Combined elliptic Curve and Post-Quantum Cryptography Key Exchange";}
 [typ^="ChaCha"]:hover ::after  {content:"\2014  stream cipher algorithm (with 256-bit key)";}
 [typ="DES"]:hover     ::after  {content:"\2014  Data Encryption Standard";}
 [typ="3DES"]:hover    ::after  {content:"\2014  Tripple Data Encryption Standard";}
 [typ="DSS"]:hover     ::after  {content:"\2014  Digital Signature Standard";}
 [typ="DH"]:hover      ::after  {content:"\2014  Diffie-Hellman";}
 [typ^="DHE"]:hover    ::after  {content:"\2014  Diffie-Hellman ephemeral (same as EDH)";}
 [typ="DHEPSK"]:hover  ::after  {content:"\2014  Diffie-Hellman ephemeral with pre-shared key";}
 [typ="DH/DSS"]:hover  ::after  {content:"\2014  Diffie-Hellman with DSS";}
 [typ="DH/RSA"]:hover  ::after  {content:"\2014  Diffie-Hellman with RSA";}
 [typ="DH(512)"]:hover ::after  {content:"\2014  Diffie-Hellman (512 bit)";}
 [typ="ECCPWD"]:hover  ::after  {content:"\2014  Elliptic Curve Cryptography (with password?)";}
 [typ^="ECDH"]:hover   ::after  {content:"\2014  Elliptic Curve Diffie-Hellman";}
 [typ^="ECDHE"]:hover  ::after  {content:"\2014  Ephemeral Elliptic Curve Diffie-Hellman";}
 [typ="ECDH/ECDSA"]:hover  ::after  {content:"\2014  Elliptic Curve Diffie-Hellman with ECDSA";}
 [typ="ECDH/RSA"]:hover    ::after  {content:"\2014  Elliptic Curve Diffie-Hellman with RSA";}
 [typ="ECDHEPSK"]:hover    ::after  {content:"\2014  Elliptic Curve Diffie-Hellman with pre-shared key";}
 [typ="ECDSA"]:hover   ::after  {content:"\2014  Elliptic Curve Digital Signature Algorithm";}
 [typ^="EDH"]:hover    ::after  {content:"\2014  Ephemeral Diffie-Hellman";}
 [typ="FZA"]:hover     ::after  {content:"\2014  Fortezza encryption";}
 [typ^="GOST"]:hover   ::after  {content:"\2014  Gossudarstwenny Standard, block cipher";}
 [typ="IDEA"]:hover    ::after  {content:"\2014  International Data Encryption Algorithm";}
 [typ="KRB"]:hover     ::after  {content:"\2014  Key Exchange Kerberos";}
 [typ="KRB5"]:hover    ::after  {content:"\2014  Key Exchange Kerberos 5";}
 [typ="MD2"]:hover     ::after  {content:"\2014  Message Digest 2";}
 [typ="MD4"]:hover     ::after  {content:"\2014  Message Digest 4";}
 [typ="MD5"]:hover     ::after  {content:"\2014  Message Digest 5";}
 [typ="None"]:hover    ::after  {content:"\2014  no encryption / plain text";}
 [typ="RC2"]:hover     ::after  {content:"\2014  Rivest Cipher 2, block cipher";}
 [typ="RC4"]:hover     ::after  {content:"\2014  Rivest Cipher 4, stream cipher (aka Ron's Code)";} # dumm '
 [typ="RC5"]:hover     ::after  {content:"\2014  Rivest Cipher 5, block cipher";}
 [typ="RIPEMD"]:hover  ::after  {content:"\2014  RACE Integrity Primitives Evaluation Message Digest";}
 [typ="RSA"]:hover     ::after  {content:"\2014  Rivest Sharmir Adelman (public key cryptographic algorithm)";}
 [typ="RSAPSK"]:hover  ::after  {content:"\2014  Rivest Sharmir Adelman with pre-shared key";}
 [typ="RSA(512)"]:hover ::after {content:"\2014  Rivest Sharmir Adelman (512 bit)";}
 [typ="PCT"]:hover     ::after  {content:"\2014  Private Communications Transport";}
 [typ="PSK"]:hover     ::after  {content:"\2014  Pre-shared Key";}
 [typ="SEED"]:hover    ::after  {content:"\2014  128-bit symmetric block cipher";}
 [typ="SHA"]:hover     ::after  {content:"\2014  Secure Hash Algorithm";}
 [typ="SHA1"]:hover    ::after  {content:"\2014  Secure Hash Algorithm";}
 [typ="SHA256"]:hover  ::after  {content:"\2014  Secure Hash Algorithm (256 bit)";}
 [typ="SHA384"]:hover  ::after  {content:"\2014  Secure Hash Algorithm (384 bit)";}
 [typ="SHA512"]:hover  ::after  {content:"\2014  Secure Hash Algorithm (512 bit)";}
 [typ="SRP"]:hover     ::after  {content:"\2014  Secure Remote Password protocol";}
 [typ="SSLv2"]:hover   ::after  {content:"\2014  Secure Socket Layer 2";}
 [typ="SSLv3"]:hover   ::after  {content:"\2014  Secure Socket Layer 3";}
 [typ="TLSv10"]:hover  ::after  {content:"\2014  Transport Level Secure 1.0";}
 [typ="TLSv11"]:hover  ::after  {content:"\2014  Transport Level Secure 1.1";}
 [typ="TLSv12"]:hover  ::after  {content:"\2014  Transport Level Secure 1.2";}
 [typ="TLSv13"]:hover  ::after  {content:"\2014  Transport Level Secure 1.3";}
 /* not yet working: setting CSS variables and then use them
  dd[val]            {--data: attr(val); --index: var(--data);}
 */
EoSTYLE_C

    'body_anf'      => << 'EoBODY',
<body>
 <h2 title="__HTML_version__" ><span id="txt" >__HTML_title__</span>
     <button id="schema" style="float: right;" onclick="osaft_handler(osaft_action_http,osaft_action_file);" title="change schema of all&#13;action and href attributes">Change to osaft: schema</button>
 </h2>
EoBODY

    'form_anf'      => << 'EoFORM',

 <a name="aFORM"></a>
 <form id="o-saft" action="__HTML_cgi_bin__" method="GET" onsubmit="return osaft_submit()" target="cmd" >
  <noscript><div>
All options, even those without values, are passed to __HTML_cgi_bin__ .
  </div></noscript>
  <input  type="hidden" name="--cgi" value="" >
EoFORM

    'fieldset'      => << 'EoFIELDSET',
  <fieldset>
    <p>
    Host[:Port]:: <input type="text" name="--url"  size="40" title="hostname or hostname:port or URL" >
    <input type="submit" name="--cmd" value="+check" title="execute: o-saft.pl +check ..." onclick='this.value="+check";' >
    <input type="reset"  value="clear" title="clear all settings or reset to defaults"/>
    </p>
EoFIELDSET

    'form_end'      => << 'EoFORM',
  </fieldset>
 </form>
 <hr>
EoFORM

    'warning_box'   => << 'EoWARN',
 <!-- print "Note" text box for CGI usage; only visible with fragment #Note -->
 <style>
  /* message box "Note", if necessary # TODO: font-size not working in firefox */
  .m            {opacity:1; pointer-events:none; position:fixed; transition:opacity 400ms ease-in; background:var(--bg-mbox); top:0; right:0; bottom:0; left:0; z-index:9; }
  .m > div      {position:relative; min-width:10em; margin:4em auto; padding:1em; border-radius:8px;   background:var(--bg-mdiv); font-size:120%; }
  .m > div > a  {opacity:1; pointer-events:auto; }
  .m > div > a  {position:absolute; width:1.1em; top:0.1em;      right:0.2em; line-height:1.1em;   background:var(--bg-blue); color:#fff; text-align:center;  text-decoration:none; font-weight:bold; border-radius:8px; box-shadow:1px 3px 3px #5bb; }
  .m > div > a:hover  {background: #5bb; }
  .m > div > h3       {margin:-0.8em 0px 1em 0px; border-bottom:var(--border-1); }
  .m > div > h3:before{content:"\00a0\00a0\00a0" }
 </style>
 <div id="warn" class="m"> <div>
  <a  id="seen" href="" onclick="toggle_display('warn');return false;" title="I understand">X</a>
  <h3>O-Saft as CGI </h3>
  <p>This is a sample implementation to show O-Saft's functionality.</p>
  <p>It is not intended to be used for regular tests of foreign servers.</p>
  <p>The server may be slow and is short on memory, so please don't expect miracles.</p>
 </div> </div>
EoWARN

);

#_____________________________________________________________________________
#_________________________________________________________ internal methods __|

# SEE Perl:Undefined subroutine
*_warn = sub { print($OSaft::Text::STR{WARN}, join(" ", @_), "\n"); } if not defined &_warn;
*_hint = sub { print($OSaft::Text::STR{HINT}, join(" ", @_), "\n"); } if not defined &_hint;
*_dbx  = sub { print($OSaft::Text::STR{DBX},  join(" ", @_), "\n"); } if not defined &_dbx;

sub _get_filename   {
# TODO: move to osaft.pm or alike
    my $src = shift || "o-saft.pl";
    foreach my $dir (@INC) {    # find the proper file
        if (-e "$dir/$src") {
            $src = "$dir/$src";
            last;
        }
    }
    return $src;
} # _get_filename

sub _man_dbx        {   # similar to _y_CMD
    # When called from within parent's BEGIN{} section, options are not yet
    # parsed, and so not available in %cfg. Hence we use @ARGV to check for
    # options, which is not performant, but fast enough here.
    my @txt = @_;
    my $anf = "";
    my $end = "";
    if (0 < (grep{/^--help=gen.cgi/i} @ARGV)) {
        # debug messages should be HTML comments when generating HTML
        $anf = "<!-- "; $end = " -->";
        # TODO: need to sanitise @txt : remove <!-- and/or -->
    }
    if (0 < $VERBOSE) {
        print $anf . "#" . $ich . ": " . join(' ', @txt) . "$end\n";
    }
    return;
} # _man_dbx

sub _man_use_tty    {   # break long lines of text; SEE Note:tty
    # set screen width in $cfg{'tty'}->{'width'}
    _man_dbx("_man_use_tty() ...");
    return if not defined $cfg{'tty'}->{'width'};
    my $_len = 80;
    my $cols = $cfg{'tty'}->{'width'};
    if (10 > $cols) {   # size smaller 10 doesn't make sense
        $cols = $ENV{COLUMNS} || 0;  # ||0 avoids perl's "Use of uninitialized value"
        if ($cols =~ m/^[1-9][0-9]+$/) {    # ensure that we get numbers
            $cfg{'tty'}->{'width'} = $cols;
            return;
        }
        # try with tput, if it fails try with stty; errors silently ignored
        $cols = qx(\\tput cols 2>/dev/null) || undef; ## no critic qw(InputOutput::ProhibitBacktickOperators)
        if (not defined $cols) {    # tput failed or missing
            $cols =  qx(\\stty size 2>/dev/null)      ## no critic qw(InputOutput::ProhibitBacktickOperators)
                     || $_len; # default if stty fails
            $cols =~ s/^[^ ]* //;   # stty returns:  23 42  ; extract 42
        }
        $cfg{'tty'}->{'width'} = $cols;
    }
    $cfg{'tty'}->{'width'} = 80 if (10 > $cfg{'tty'}->{'width'});   # safe fallback
    _man_dbx("_man_use_tty: " . $cfg{'tty'}->{'width'});
    return;
} # _man_use_tty

sub _man_squeeze    {   # break long lines of text; SEE Note:tty
    # if len is undef, default from %cfg is used
    my $len   = shift;
    my $txt   = shift;
    return $txt if not defined $cfg{'tty'}->{'width'};
    # if a width is defined, --tty  was used
    # Keep in mind that  help.txt  is formatted to fit in 80 columns,  hence a
    # width > 80 does not change the total length of the line (which is always
    # < 80), but changes the number of left most spaces.
    $txt =~ s/[\t]/    /g;    # replace all TABs
    my $max   = $cfg{'tty'}->{'width'} - 2;     # let's have one space right
    my $ident = ' ' x $cfg{'tty'}->{'ident'};   # default ident spaces
    if (defined $len) {
        # break long lines at max size and ident remaining with len
        $ident = "$cfg{'tty'}->{'arrow'}\n" . ' ' x $len;
        $txt =~ s/(.{$max})/$1$ident/g;
    } else {
        # change left most 8 spaces to specified number of spaces
        # break long lines at max size
        # break long lines at max size and ident with specified number of spaces
        $txt =~ s/\n {8}/$ident/g;              # reduced existing identation
        $ident = "$cfg{'tty'}->{'arrow'}\n" . $ident;
        $max--;
    }
    #$max--;
    $txt =~ s/(.{$max})/$1$ident/g;             # squeeze line length
    return $txt;
} # _man_squeeze

sub _man_usr_value  {
    #? return value of argument $_[0] from @{$cfg{'usr_args'}}
    # expecting something like  usr-action=/some.cgi  in $cfg{'usr_args'}
    my $key =  shift;
       $key =~ s/^(?:--|\+)//;  # strip leading chars
    my @arg =  "";              # key, value # Note: value is anything right to leftmost = 
    map({@arg = split(/=/, $_, 2) if /^$key/} @{$cfg{'usr_args'}}); # does not allow multiple $key in 'usr_args'
    return $arg[1];
} # _man_usr_value

sub _man_get_version {
    # ugly, but avoids global variable elsewhere or passing as argument
    no strict; ## no critic qw(TestingAndDebugging::ProhibitNoStrict)
    my $v = '2.84'; $v = _VERSION() if (defined &_VERSION);
    return $v;
} # _man_get_version

sub _man_html_init  {
    #? initialise %html hash
    my $tipp    = _man_get_version();   # get official version
    my $cgi_bin = _man_usr_value('user-action') || _man_usr_value('usr-action') || "/cgi-bin/o-saft.cgi";
        # get action from --usr-action= or set to default (defensive programming)
    # this function is called once, usually, hence it's save to modify %html directly
    $html{'action'}         =~ s/__HTML_cgi_bin__/$cgi_bin/g;
    $html{'form_anf'}       =~ s/__HTML_cgi_bin__/$cgi_bin/g;
    $html{'script_endcgi'}  =~ s/__HTML_cgi_bin__/$cgi_bin/g;
    $html{'body_anf'}       =~ s/__HTML_version__/$tipp/g;
    $html{'body_anf'}       =~ s/__HTML_title__/$html{'title'}/g;
    $html{'meta'}           =~ s/__HTML_title__/$html{'title'}/g;
    return;
} # _man_html_init

sub _man_file_get   {
    #? get filename containing text for specified keyword
    my $typ = shift;
    return OSaft::Doc::Data::get_as_text('glossary.txt')    if ('abbr'  eq $typ);
    return OSaft::Doc::Data::get_as_text('links.txt')       if ('links' eq $typ);
    return OSaft::Doc::Data::get_as_text('rfc.txt')         if ('rfc'   eq $typ);
    return '';
} # _man_file_get

sub _man_http_head  {
    #? print HTTP headers (for CGI mode)
    return "" if (0 >= (grep{/--cgi.?trace/} @ARGV));
    # Checking @ARGV for --cgi-trace is ok, as this option is for simulating
    # CGI mode only, in o-saft.pl SEE Note:CGI mode
    # When called from o-saft.cgi, HTTP headers are already written.
    return "X-Cite: Perl is a mess. But that's okay, because the problem space is also a mess. Larry Wall\r\n"
         . "Content-type: text/html; charset=utf-8\r\n"
         . "\r\n"
         . _man_dbx("_man_http_head() ...")  # note that it must be after all HTTP headers
    ;
} # _man_http_head

sub _man_html_head  {
    #? print header of HTML page
    # SEE HTML:JavaScript
    _man_dbx("_man_html_head() ...");
    return $html{'doctype'}
         . '<html><head>'
         . $html{'meta'}
         . $html{'script_nonce'}
         . $html{'script_func1'}
         . $html{'script_func2'}
         . '</script>' . "\n"
         . '<style>'
         . $html{'style_root'}
         . $html{'style_button'}
         . $html{'style'}
         . '</style>' . "\n"
         . '</head>'  . "\n"
         . $html{'body_anf'}
    ;
} # _man_html_head

sub _man_html_details {
    #? print details scope with summary text and div content
    my $sum = shift;
    my $open= shift;
    my $txt = shift;
    return << "EoDetails";
    <details $open><summary>$sum</summary>
      <div>
$txt
      </div>
    </details><!-- $sum -->
EoDetails
} # _man_html_details

sub _man_help_button {
    #? return href tag for a help button
    my $cmd   = shift;      # must be --help=* option; also used for button text
    my $class = shift;      # value for class= attribute (if not empty)
    my $title = shift;      # value for title= attribute
    my $href  = $html{'action'};
    my $txt   = $cmd;       # 
       $txt  =~ s/.*--.*help=//; # button text without --help and other options
       $txt  =~ s/&.*$//;   # button text without --help and other options
       $class = qq(class="$class") if ($class !~ m/^\s*$/);
    return qq(        <a $class target="_help" href="$href?--cgi&--header&$cmd" title="$title" >$txt</a>\n);
} # _man_help_button

sub _man_cmd_button {
    #? return input tag for a cmd button
    my $cmd = shift;
    return qq(        <input target="_cmd" type="submit" name="--cmd" value="$cmd" title="execute o-saft.pl $cmd" >\n);
} # _man_cmd_button

sub _man_opt_button {
    #? return input tag for a opt button
    my $opt = shift;
    my $val = shift;
    return qq(        <label><input type="checkbox" name="$opt" value="$val" >$opt</label>\n);
} # _man_cmd_button

sub _man_menu_bar   {
    #? print menu bar
    my $menu  = _man_help_button("--help=ciphers-html&--content-type=html", '',
                                 "open window with list of cipher suites (html format)")
              . qq(        <a target="_help" href="docs/o-saft.html#aABOUT%20CGI" >! Help (this CGI form)</a>)
              . qq(        <a target="_help" href="docs/o-saft.html" >? Help (complete help)</a>);
    my $cmds;
       $cmds .= _man_cmd_button($_)     foreach qw(+check +cipher +info +quick +vulns +protocols);
    my $opts  = _man_opt_button('--format', 'html');
       $opts .= _man_opt_button($_, '') foreach qw(--header --enabled --no-dns --no-http --no-sni --no-sslv2 --no-sslv3);
    my $help  =
         _man_help_button("--help",         '', "open window with complete help (plain text)")
       . _man_help_button("--help=command", '', "open window with help for commands")
       . _man_help_button("--help=checks",  '', "open window with help for checks")
       . _man_help_button("--help=example", '', "open window with examples")
       . _man_help_button("--help=opt",     '', "open window with help for options")
       . _man_help_button("--help=FAQ",     '', "open window with FAQs")
       . _man_help_button("--help=abbr",    '', "open window with the glossar")
       . _man_help_button("--help=todo",    '', "open window with help for ToDO")
       . _man_help_button("--help=ciphers-text", '', "open window with list of cipher suites (text format)")
       . _man_help_button("--help=ciphers-html&--content-type=html", '', "open window with list of cipher suites (html format)");
    return qq(  <div  class="navdiv">\n)
         . _man_html_details("☰",    '', $menu)
         . _man_html_details("Cmd",  '', $cmds)
         . _man_html_details("Opt",  '', $opts)
         . _man_html_details("Help", '', $help)
         . qq(  </div> <!-- class=navdiv -->\n);
} # _man_menu_bar

sub _man_cgi_simple {
    #? generate list of options for "Simple GUI"
    my $txt = qq(       <table id="osaft_buttons">\n       </table>\n);
        # Above  <table>  contains the quick buttons for some commands. These
        # quick buttons should get their description from the later generated
        # help text in this page. Hence the buttons are generated later using
        # JavaScript function  osaft_buttons() so that the corresponding help
        # text can be derived from the HTML page itself. SEE HTML:JavaScript
    $txt   .= qq(       <hr>\n);
    $txt   .= qq(       <div class="n">\n);
    # show most common used options; layout by lines using BR
        # <div class=n> contains checkboxes for some options.These checkboxes
        # are added in following  foreach loop.
    foreach my $key (qw(no-sslv2 no-sslv3 no-tlsv1 no-tlsv11 no-tlsv12 no-tlsv13 BR
                     no-dns dns no-cert BR
                     no-sni sni   BR
                     no-http http BR
                     header  no-header  no-warnings format=html   BR
                     enabled disabled   legacy=owasp BR
                     traceKEY traceCMD  trace v     cgi-no-header BR
                 )) {
        if ('BR' eq $key) { $txt .= "        <br>\n"; next; }
        my $tag_nam = "--$key";
        $txt .= _man_html_cbox('cgi', "        ", "q$tag_nam", $tag_nam, "", $tag_nam) . "\n";
    }
    $txt .= "       </div><!-- class=n -->";
    $txt .= _man_html_go("cgi");
    return $txt;
} # _man_cgi_simple

sub _man_html_form  {
    #? print HTML form for CGI
    my $cgi_bin = $html{'action'};
    my $txt;
    _man_dbx("_man_html_form() ...");
    return $html{'form_anf'}
         . _man_menu_bar()
         . $html{'fieldset'}
         . _man_html_details("Simple GUI", '', _man_cgi_simple())
         . _man_html_details("Full GUI Commands & Options", 'open',
                             _man_html('cgi', 'COMMANDS', 'LAZY')
           . '<input type=reset  value="clear" title="clear all settings or reset to defaults"/>'
                # print help starting at COMMANDS and a reset button
           )
         . $html{'form_end'}
         . $html{'script_endcgi'}
         ;
} # _man_html_form

sub _man_html_foot  {
    #? print footer of HTML page
    _man_dbx("_man_html_foot() ...");
    return $html{'links'}
         . $html{'copyright'}
         . $html{'script_endall'}
         . '</body></html>'
    ;
} # _man_html_foot

sub _man_html_cbox  {   ## no critic qw(Subroutines::ProhibitManyArgs)
    #? return input checkbox tag with clickable label and hover highlight
    my ($mode, $prefix, $tag_id, $tag_nam, $tag_val, $cmd_txt) = @_;
    my $title = '';
       $title = 'experimental option' if ("--format=html" eq $cmd_txt); # TODO: experimental hack
    return $cmd_txt if ($mode ne 'cgi');        # for "html" nothing special
    return sprintf(qq(%s<label class="i" for="%s"><input type="checkbox" id="%s" name="%s" value="%s" title="%s" >%s</label>&#160;&#160;),
                    $prefix, $tag_id, $tag_id, $tag_nam, $tag_val, $title, $cmd_txt);
} # _man_html_cbox

sub _man_html_chck  {
    #? return checkbox, or input field with clickable label (to reset input)
    # to be used for +commands and --options
    my $mode    = shift; # cgi or html
    my $cmd_opt = shift || "";                  # +cmd or --opt or --opt=value
    my $tag_nam = $cmd_opt;
    my $tag_val = '';
    return '' if ($cmd_opt !~ m/^(?:-|\+)+/);   # defensive programming
    return $cmd_opt if ($mode ne 'cgi');        # for "html" nothing special
    # $cmd_opt may contain:  "--opt1 --opt2"; hence split at spaces and use first
    if ($cmd_opt =~ m/^(?:\+)/) { # is command, print simple checkbox
        $tag_val =  scalar((split(/\s+/, $cmd_opt))[0]);
        $tag_nam =  '--cmd';
    } else { # is optionm print simple checkbox or input field
        # options are  --opt  or  --opt=VALUE;  SEE HTML:INPUT
        $tag_val =  '';                         # checkbox with empty value
        $tag_nam =  scalar((split(/\s+/, $cmd_opt))[0]);
        my ($key, $val) = split(/=/, $tag_nam); # split into key and value
        if (defined $val && $val =~ m/^[A-Z0-9:_-]+/) { # --opt=VALUE
            my $label = qq(<label class="l" >$key=</label>);
            my $input = qq(<input type="text" id="$tag_nam" name="$key" value="" placeholder="$val">);
            return "$label$input";
        # else: see below
        }
    }
    return _man_html_cbox($mode, "", "o$cmd_opt", $tag_nam, $tag_val, $cmd_opt);
} # _man_html_chck

sub _man_name_ankor {
    #? return name for an ankor tag without commas
    my $n = shift;
    $n =~ s/,//g;  # remove comma
    #$n =~ s/\s/_/g;# replace spaces
    return $n;
} # _man_name_ankor

sub _man_html_ankor {
    #? return ankor tag for each word in given parameter
    my $n = shift;
    my $a = '';
    return qq(<a name="a$n"></a>) if ($n !~ m/^[-\+]+/);
    foreach my $n (split(/[\s,]+/,$n)) {
        $a .= sprintf("<a name='a%s'></a>", _man_name_ankor($n));
    }
    return $a;
} # _man_html_ankor

sub _man_html_go    {
    #? return button "Top" and button "start"
    # SEE HTML:start
    my $key = shift;
    return "" if ($key ne 'cgi');
    my $top = qq(        <a class="b" href="#aFORM" title="return to top">^</a>\n);
    my $run = qq(        <input type="submit" value="start" title="execute o-saft.pl with selected commands and options"/>\n);
    return "$top$run";
} # _man_html_go

sub _man_html_cmds  {
    #? return checkboxes for commands not found in help.txt but are generated dynamically
    my $key = shift;
    my $txt = "";
    my $cmds= _man_cmd_from_source(); # get all command from %data and %check_*
    # $cmds.= _man_cmd_from_rcfile(); # RC-FILE not used here
    _man_dbx("_man_html_cmds($key) ...");
    foreach my $cmd (split(/[\r\n]/, $cmds)) {
        next if ($cmd =~ m/^\s*$/);
        $cmd =~ s/^\s*//;
        if ($cmd =~ m/^[+]/) {
            my $desc = "";
            ($cmd, $desc) = split(/\s+/, $cmd, 2);
            $txt .= sprintf("<b>%s </b> %s<br />\n", _man_html_cbox($key, "", "c$cmd", "--cmd", $cmd, $cmd), $desc);
                # TODO: <b> should be <h4>, but as h4 is a display:block tag,
                #   the remainig text $desc would be rendered in a new line;
                #   to avoid this, a <span> with proper CSS needs to be used
        } else {
            $txt .= _man_html_go($key) . "\n";
            $txt .= sprintf("%s\n<h3>%s</h3>\n", _man_html_ankor($cmd), $cmd);
        }
    }
    #print "## $txt ##"; exit;
    return $txt;
} # _man_html_cmds

sub _man_html       {   ## no critic qw(Subroutines::ProhibitExcessComplexity)
    #? print text in HTML format
    my $key = shift;    # cgi or html
    my $anf = shift;    # pattern where to start extraction
    my $end = shift;    # pattern where to stop extraction
    my $txt;
    my $skip= 0;
    my $c   = 0;
    my $h   = 0;
    my $a   = "";       # NOTE: Perl::Critic is scary, SEE Perlcritic:LocalVars
    my $p   = "";       # for closing p Tag
    _man_dbx("_man_html($key, $anf, $end) ...");
    while ($_ = shift @help) {
        # NOTE: sequence of following m// and s/// is important
        # FIXME: need  s!<<!&lt;&lt;!g; before any print
        last if/^TODO/;
        $h=1 if/^=head1 $anf/;
        $h=0 if/^=head1 $end/;
        next if (0 == $h);                          # ignore "out of scope"
        if (0 < $skip) { $skip--; next; }           # skip some texts
        # TODO: does not work:      <p onclick='toggle_display(this);return false;'>\n",
m!<<\s*undef! or s!<<!&lt;&lt;!g;                            # encode special markup
        m/^=head1 (.*)/   && do {
                    $txt .= sprintf("$p\n<h1>%s %s </h1>\n", _man_html_ankor($1),$1);
                    $p="";
                    next;
                };
        m/^=head2 (.*)/   && do {
                    my $x=$1;
                    if ($x =~ m/Discrete commands to test/) {
                        # SEE Help:Syntax
                        # command used for +info and +check have no description in @help
                        $txt .= _man_html_cmds($key); # extract commands from dource code
                    } else {
                        $txt .= _man_html_go($key);
                        $txt .= _man_html_ankor($x) . "\n";
                        $txt .= sprintf("<h3>%s %s </h3> <p>\n", _man_html_chck($key,$x), $x );
                    }
                    next;
                };
        m/^=head3 (.*)/   && do {
                    # commands and options expected with =head3 only
                    $a=$1; ## no critic qw(Variables::RequireLocalizedPunctuationVars)
                    if ('cgi' eq $key) {
                        $txt .= _man_help_button($a, "b r", "open window with special help") if ($a =~ m/--help/);
                    }
                    $txt .= _man_html_ankor($a) . "\n";
                    $txt .= sprintf("<h4>%s </h4> <p>\n", _man_html_chck($key,$a));
                    next;
                };
        m/Discrete commands,/ && do { $skip=2; next; }; # skip next 3 lines; SEE Help:Syntax
        # encode special markup
        m/(--help=[A-Za-z0-9_.-]+)/ && do {         # add button for own help (must be first in sequence)
                    if ('cgi' eq $key) {
                        $txt .= _man_help_button($1, "b r", "open window with special help");
                    }
                };
        m/^\s*S&([^&]*)&/ && do {
                    # code or example line
                    my $v=$1;
                    $v=~s!<<!&lt;&lt;!g;
                    $txt .= qq(<div class="c" >$v</div>\n);
                    next
                };
        s!"([^"]*)"!<cite>$1</cite>!g;              # markup examples
        s!'([^']*)'!<span class="c" >$1</span>!g;   # markup examples
        #dbx# m/-SSL/ && do { print STDERR "##1 $_ ###"; };
        m![IX]&(?:[^&]*)&! && do {
                    # avoid spaces in internal links to anchors
                    # FIXME: dirty hack, probably bug in get_markup()
                    s/\s+&/&/g;                     # trim trailing spaces
                };
        s!I&([^&]*)&!<a href="#a$1">$1</a>!g;       # markup commands and options
        s!X&([^&]*)&!<a href="#a$1">$1</a>!g;       # markup references inside help
        s!L&([^&]*)&!<i>$1</i>!g;                   # markup other references
            # L& must be done after I& ad/or X& to avoid mismatch to i.e.  I&-SSL&
        s!^\s+($mytool .*)!<div class="c" >$1</div>!; # example line
        # detect lists, very lazy ... # SEE HTML:Known Bugs
        m/^=item +\* (.*)/    && do { $txt .= "<li>$1</li>\n";next;};
        m/^=item +\*\* (.*)/  && do { $txt .= "<li type=square style='margin-left:3em'>$1 </li>\n";next;};
        s/^(?:=[^ ]+ )//;                           # remove remaining markup
        s!<<!&lt;&lt;!g;                            # encode remaining special markup
        # add paragraph for formatting, SEE HTML:p and HTML:JavaScript
        m/^\s*$/ && do { ## no critic qw(Variables::RequireLocalizedPunctuationVars)
                    $a = "id='h$a'" if ('' ne $a);
                    $txt .= "$p<p $a>";
                    $p = "</p>";
                    $a = '';
                }; # SEE Perlcritic:LocalVars
        s!(^ {12}.*)!<li class="n">$1</li>!;        # 12 spaces are used in lists, mainly
        $txt .= $_;
    }
    $txt .= "$p"; # if not empty, otherwise harmless
    return $txt;
} # _man_html

sub _man_head       {   ## no critic qw(Subroutines::RequireArgUnpacking)
    #? print table header line (dashes)
    my $len1 = shift;   # this line triggers Perl::Critic, stupid :-/
    my @args = @_;      # .. hence "no critic" pragma above
    _man_dbx("_man_head(..) ...");
    my $len0 = $len1 - 1;
    return "" if (1 > $cfg_header);
    return sprintf("=%${len0}s | %s\n", @args)
         . sprintf("=%s+%s\n", '-' x  $len1, '-'x60);
} # _man_head

sub _man_foot       {
    #? print table footer line (dashes)
    my $len1 = shift;   # expected length of first (left) string
    return "" if (1 > $cfg_header);
    return sprintf("=%s+%s\n", '-'x $len1, '-'x60);
} # _man_foot

sub _man_opt        {   ## no critic qw(Subroutines::RequireArgUnpacking)
    #? print line in  "KEY - VALUE"  format
    my @args = @_; # key, sep, value
    my $len  = 16;
       $len  = 1 if ($args[1] eq "="); # allign left for copy&paste
    my $txt  = sprintf("%${len}s%s%s\n", @args);
    return _man_squeeze((16+length($_[1])), $txt);
} # _man_opt

sub _man_cfg        {
    #? print line in configuration format
    my ($typ, $key, $sep, $txt) = @_;
    $txt =  '"' . $txt . '"' if ($typ =~ m/^cfg(?!_cmd)/);
    $key =  "--$typ=$key"    if ($typ =~ m/^cfg/);
    return _man_opt($key, $sep, $txt);
} # _man_cfg

sub _man_txt        {
    #? print text configuration format (replaces \n\r\t )
    my ($typ, $key, $sep, $txt) = @_;
    $txt =~ s/(\n)/\\n/g;
    $txt =~ s/(\r)/\\r/g;
    $txt =~ s/(\t)/\\t/g;
    return _man_cfg($typ, $key, $sep, $txt);
} # _man_txt

sub _man_pod_item   {
    #? print line as POD =item
    my $line = shift;
    return "=over\n\n$line\n=back\n";
} # _man_pod_item

sub _man_doc_opt    {
    #? print text from file $typ in  "KEY - VALUE"  format
    #  type is:   abbr, links, rfc
    #  format is: opt, POD
    my ($typ, $sep, $format) = @_;  # format is POD or opt
    my  $url  = "";
    my  @txt  = _man_file_get($typ);
    my  $opt;
    # OSaft::Doc::*::get()  returns one line for each term;  format is:
    #   term followd by TAB (aka \t) followed by description text
    foreach my $line (@txt) {
        chomp  $line;
        next if ($line =~ m/^\s*$/);
        next if ($line =~ m/^\s*#/);
        my ($key, $val) = split("\t", $line);
            $key =~ s/\s*$//;
        if ('rfc' eq $typ) {    # RFC is different, adapt $key and $val
            $url = $val if ($key eq "url"); # should be first line only
            $val = $val . "\n\t\t\t$url/html/rfc$key";
            $key = "RFC $key";
        }
        $opt .= _man_opt($key, $sep, $val)          if ('opt' eq $format);
        $opt .= _man_pod_item("$key $sep $val\n")   if ('POD' eq $format);
    }
    return $opt;
} # _man_doc_opt

sub _man_doc_pod    {
    #? print text from file $typ in  POD  format
    my ($typ, $sep) = @_;
    my  @txt  = _man_file_get($typ);
    # print comment lines only, hence add # to each line
    my  $help = "@txt";
        $help =~ s/\n/\n#/g;
    #_man_doc_opt($typ, $sep, "POD");   # if real POD should be printed
    return << "EoHelp";
# begin $typ

# =head1 $typ

$help
# end $typ

EoHelp
} # _man_doc_pod

sub _man_pod_head   {
    #? print start of POD format
    my $txt = <<'EoHelp';
#!/usr/bin/perldoc
#?
# Generated by o-saft.pl .
# Unfortunately the format in  @help is incomplete,  for example proper  =over
# and corresponding =back  paragraph is missing. It is mandatory around  =item
# paragraphs. However, to avoid tools complaining about that,  =over and =back
# are added to each  =item  to avoid error messages in the viewer tools.
# Hence the additional identations for text following the =item are missing.
# Tested viewers: podviewer, perldoc, pod2usage, tkpod

EoHelp
    $txt .= "=pod\n\n";             # must be variable to not confuse perldoc
    $txt .= "=encoding utf8\n\n";   # for utf8  SEE POD:Syntax
    return $txt;
} # _man_pod_head

sub _man_pod_text   {
    #? print text in POD format
    my $code  = 0;  # 1 if last printed line was `source code' format
    my $empty = 0;  # 1 if last printed line was empty
    my $pod;
    while ($_ = shift @help) {          # @help already looks like POD
        last if m/^(?:=head[1] )?END\s+#/;# very last line in this file
        m/^$/ && do {  ## no critic qw(RegularExpressions::ProhibitFixedStringMatches)
            if (0 == $empty)  { $pod .= $_; $empty++; } # empty line, but only one
            next;
        };
        s/^(\s*(?:o-saft\.|checkAll|yeast\.).*)/S&$1&/; # dirty hack; adjust with 14 spaces
        s/^ {1,13}//;                   # remove leftmost spaces (they are invalid for POD); 14 and more spaces indicate a line with code or example
        s/^S&\s*([^&]*)&/\t$1/ && do {  # code or example line
            $pod .= "\n" if (0 == ($empty + $code));
            $pod .= $_; $empty = 0; $code++; next; # no more changes
        };
        $code = 0;
        s:['`]([^']*)':C<$1>:g;         # markup literal text; # dumm '
        s:(^|\s)X&([^&]*)&:$1L</$2>:g;  # markup references inside help
        s:(^|\s)L&([^&]*)&:$1L<$2|$2>:g;# markup other references
        #s:L<[^(]*(\([^\)]*\)\>).*:>:g; # POD does not like section in link
        s:(^|\s)I&([^&]*)&:$1I<$2>:g;   # markup commands and options
        s/^([A-Z., -]+)$/B<$1>/;        # bold
        s/^(=item)\s+(.*)/$1 $2/;       # squeeze spaces
        my $line = $_;
        m/^=/ && do {                   # paragraph line
            # each paragraph line must be surrounded by empty lines
            # =item paragraph must be inside =over .. =back
            $pod .= "\n"        if (0 == $empty);
            $pod .= "$line"     if $line =~ m/^=[hovbefpc].*/;  # any POD keyword
            $pod .= _man_pod_item "$line" if $line =~ m/^=item/;# POD =item keyword
            $pod .= "\n";
            $empty = 1;
            next;
        };
        $pod .= "$line";
        $empty = 0;
    }
    return $pod;
} # _man_pod_text

sub _man_pod_foot   {
    #? print end of POD format
    my $pod = <<'EoHelp';
Generated with:

        o-saft.pl --no-warnings --no-header --help=gen-pod > o-saft.pod

EoHelp
    $pod .= "=cut\n\n";
    $pod .= _man_doc_pod('abbr', "-");  # this is for voodoo, see below
    $pod .= _man_doc_pod('rfc',  "-");  # this is for voodoo, see below
    $pod .= $_voodoo;
    return $pod;
} # _man_pod_foot

sub _man_wiki_head  {
    #? print start of mediawiki format
    return <<'EoHelp';
==O-Saft==
This is O-Saft's documentation as you get with:
 o-saft.pl --help
<small>On Windows following must be used:
 o-saft.pl --help --v
</small>

__TOC__ <!-- autonumbering is ugly here, but can only be switched of by changing MediaWiki:Common.css -->
<!-- position left is no good as the list is too big and then overlaps some texts
{|align=right
 |<div>__TOC__</div>
 |}
-->

[[Category:OWASP Project]]  [[Category:OWASP_Builders]]  [[Category:OWASP_Defenders]]  [[Category:OWASP_Tool]]  [[Category:SSL]]  [[Category:Test]]
----
EoHelp
} # _man_wiki_head

sub _man_wiki_text  {
    #? print text of mediawiki format
    #  convert POD syntax to mediawiki syntax
    my $pod;
    my $mode =  shift;
    while ($_ = shift @help) {
        last if/^=head1 TODO/;
        s/^=head1 (.*)/====$1====/;
        s/^=head2 (.*)/=====$1=====/;
        s/^=head3 (.*)/======$1======/;
        s/^=item (\*\* .*)/$1/;         # list item, second level
        s/^=item (\* .*)/$1/;           # list item, first level
        s/^=[^= ]+ *//;                 # remove remaining markup and leading spaces
        m/^=/ && do { $pod .= $_; next; };  # no more changes in header lines
        s:['`]([^']*)':<code>$1</code>:g;  # markup examples # dumm '
        s/^S&([^&]*)&/  $1/ && do { $pod .= $_; next; }; # code or example line; no more changes
        s/X&([^&]*)&/[[#$1|$1]]/g;      # markup references inside help
        s/L&([^&]*)&/\'\'$1\'\'/g;      # markup other references
        s/I&([^&]*)&/\'\'$1\'\'/g;      # markup commands and options
        s/^ +//;                        # remove leftmost spaces (they are useless in wiki)
        if ('colon' eq $mode) {
            s/^([^=].*)/:$1/;           # ident all lines for better readability
        } else {
            s/^([^=*].*)/:$1/;          # ...
        }
        s/^:?\s*($mytool)/  $1/;        # myself becomes wiki code line
        s/^:\s+$/\n/;                   # remove empty lines
        $pod .= $_;
    }
    return $pod;
} # _man_wiki_text

sub _man_wiki_foot  {
    #? print end of mediawiki format
    return <<'EoHelp';
----
<small>
Content of this wiki page generated with:
 o-saft.pl --no-warning --no-header --help=gen-wiki
</small>

EoHelp
} # _man_wiki_foot

sub _man_cmd_from_source {
    #? return all command from %data and %check_*
    my $txt  = "";
    my $skip = 1;
    my $fh   = undef;
    if (open($fh, '<:encoding(UTF-8)', _get_filename("OSaft/Data.pm"))) { # need full path for $parent file here
        # TODO: o-saft.pl hardcoded, need a better method to identify the proper file
        while(<$fh>) {
            # find start of data structure
            # all structure look like:
            #    our %check_some = ( # description
            #          'key' => {... 'txt' => "description of value"},
            #    );
            # where we extract the description of the checked class from first
            # line and the command and its description from the data lines
            if (m/^(?:my|our)\s+%(?:check_(?:[a-z0-9_]+)|data)\s*=\s*\(\s*##*\s*(.*)/) {
                $skip = 0;
                $txt .= "\n                  Commands to show results of checked $1\n";
                next;
            }
            if (m/^\s*\)\s*;/) { $skip = 1; next; } # find end of data structure
            next if (1 == $skip);
            next if (m/^\s*'(?:SSLv2|SSLv3|D?TLSv1|TLSv11|TLSv12|TLSv13)-/); # skip internal counter
            if (m/^\s+'([^']*)'.*"([^"]*)"/) {
                my $key = $1;
                my $val = $2;
                my $len = "%-17s";
                   $len = "%s " if (length($key) > 16); # ensure that there is at least one space
                my $t   = "\t";
               #   $t  .= "\t" if (length($1) < 7);
                $txt .= sprintf("+$len%s\n", $1, $2);
            }
        }
        close($fh); ## no critic qw(InputOutput::RequireCheckedClose)
    } else {
            $txt .= sprintf("%s cannot read '%s'; %s\n", $OSaft::Text::STR{ERROR}, _get_filename("o-saft.pl"), $!);
    }
    return $txt;
} # _man_cmd_from_source

sub _man_cmd_from_rcfile {
    #? return all command RC-FILE
    my $txt  = "\n                  Commands locally defined in $cfg{'RC-FILE'}\n";
    my $val  = "";
    my $skip = 1;
    my $fh   = undef;
    if (open($fh, '<:encoding(UTF-8)', $cfg{'RC-FILE'})) {
        # TODO: need a better method to identify the proper file, RC-FILE is
        #       wrong when this file was called directly
        while(<$fh>) {
            if (m/^##[?]\s+([a-zA-Z].*)/) { # looks like:  ##? Some text here ...
                $skip = 0;
                $val  = $1;
                next;
            }
            if (m/^--cfg_cmd=([^=]*)=/) {   # looks like:  --cfg_cmd=MyCommad=list items
                next if (1 == $skip);   # continue only if previous match succedded
                $skip = 1;
                $txt .= sprintf("+%-17s%s\n", $1, $val);
                $val  = "";
            }
        }
        close($fh); ## no critic qw(InputOutput::RequireCheckedClose)
    } else {
            $txt .= sprintf("%s cannot read '%s'; %s\n", $OSaft::Text::STR{ERROR}, $cfg{'RC-FILE'}, $!);
    }
    return $txt;
} # _man_cmd_from_rcfile

sub _man_ciphers_get     {
    #? helper function for man_ciphers(): return %ciphers as simple line-oriented text
    # SEE Cipher:text  for detaiiled description and generated data format
    _man_dbx("_man_ciphers_get() ..");
    my $ciphers = "";
    foreach my $key (sort keys %ciphers) {
        my $name  = OSaft::Ciphers::get_name ($key);
        next if not $name;              # defensive programming
        next if $name =~ m/^\s*$/;      # defensive programming
        my $sec   = OSaft::Ciphers::get_sec  ($key);
        my $hex   = OSaft::Ciphers::key2text ($key);
        my $mac   = OSaft::Ciphers::get_mac  ($key);
        my @alias = OSaft::Ciphers::get_names($key);
        my @_keep = grep { $alias[$_] ne $name } 0..$#alias;
           @alias = @alias[@_keep];      # remove names, which equal $name
        my $pfs   = OSaft::Ciphers::get_pfs  ($key);
        my $rfc   = OSaft::Ciphers::get_rfc  ($key);
        my $rfcs  = "";
        foreach my $key (split(/,/, $rfc)) {
            # replace RFC-number, if any, with URL
            my $num = $key;
               $num =~ s/[^0-9]//g;
            if ("" eq $num) {
                $rfcs .= $key;
            } else {
                # TODO: also make URL for something like:  6655?
                $rfcs .= "https://www.rfc-editor.org/rfc/rfc$num";
                # old style URL ('til 2020):
                #   https://tools.ietf.org/html/rfcXXXX
                #   https://tools.ietf.org/rfc/rfcXXXX.txt
                # modern style URL (2022 ...):
                #   https://www.rfc-editor.org/rfc/rfcXXXX
                #   https://www.rfc-editor.org/rfc/rfcXXXX.txt
            }
            $rfcs .= " , ";
        }
        # keep in mind that the code marked with following comment:
            # take care for sequence!
        # relies on the sequence of line in following $ciphers
        $rfcs =~ s/ , $//;   # remove trailing ,
#             .  "\n\tIANA name:\t"      . OSaft::Ciphers::get_iana  ($key)
#             .  "\n\tGnuTLS name:\t"    . OSaft::Ciphers::get_gnutls($key)
        $ciphers .= "\n$hex\t$sec\t$name"
             .  "\nname\t"      . $name
             .  "\nnames\t"     . join(', ', @alias)
             .  "\nconst\t"     . join(', ', OSaft::Ciphers::get_consts($key))
             .  "\nopenssl\t"   . OSaft::Ciphers::get_openssl($key)
             .  "\nssl\t"       . OSaft::Ciphers::get_ssl    ($key)
             .  "\nkeyx\t"      . OSaft::Ciphers::get_keyx   ($key)
             .  "\nauth\t"      . OSaft::Ciphers::get_auth   ($key)
             .  "\nenc\t"       . OSaft::Ciphers::get_enc    ($key)
             .  "\nbits\t"      . OSaft::Ciphers::get_bits   ($key)
             .  "\nenc_size\t"  . OSaft::Ciphers::get_encsize($key)
             .  "\nmac\t"       . $mac
             .  "\nmac_size\t"  . ''
             .  "\npfs\t"       . $pfs
             .  "\nrfc\t"       . $rfcs
             .  "\nnotes\t"     . OSaft::Ciphers::get_notes($key)
             .  "\n"
             ;
    }
    return $ciphers;
} # _man_ciphers_get

sub _man_ciphers_html_dl {
    #? helper function for man_ciphers_html(): return DL tag with content
    my $dl = shift;
       $dl =~ s/\n$//;  # remove trailing \n
    return << "EoHTML";
    <div>
      <dl>
$dl
      </dl>
    </div>
EoHTML
} # _man_ciphers_html_dl

sub _man_ciphers_html_li {
    #? helper function for man_ciphers_html(): return LI tag with content
    my ($hex, $sec, $name, $dl) = @_;
    $name = "" if not defined $name;    # defensive programming
    $dl   =~ s/\n$//;
    return << "EoHTML";

  <details title="show details">
    <summary> <span>$hex</span> <span sec="$sec">$sec</span> $name </summary>
$dl
  </details>
EoHTML
} # _man_ciphers_html_li

sub _man_ciphers_html_ul {
    #? helper function for man_ciphers_html(): return UL tag with content
    #  generate simple list with UL and LI tags from given text
    my $ciphers = shift;
    my $ul  = '';
    #
    # <li onclick="toggle_display(this);return false;" title="show details">
    #         <span sec=weak>weak</span>
    #             cipher
    #         <div id="a">
    #             <dl><dt>name:</dt><dd>RC4-MD5</dd><dl>
    #         </div>
    #     </li>
    my ($hex, $sec, $name, $dl); $dl = "";
    foreach my $line (split(/\n/, $ciphers)) {
        chomp($line);
        next if $line =~ m/^\s*$/;
        $line =~ s/^\s*//;              # remove leading whitespace
        ($hex, $sec, $name) = split(/\t/, $line);
        if ($line =~ m/^0x/) {
            if ("" ne $dl) {            # new cipher, print previous one
                $ul .= _man_ciphers_html_li($hex, $sec, $name, _man_ciphers_html_dl($dl));
                $dl  = "";
            }
            ($hex, $sec, $name) = split(/\t/, $line);
            next;
        }
        my ($key, $val) = split(/\t/, $line);
        my  $txt =  $key;
        $txt =~ s/$key/$OSaft::Ciphers::ciphers_desc{$key}/; # convert internal key to human readable text
        $sec =  "";
        $sec =  "sec='$val'" if ("openssl" eq $key);# OpenSSL STRENGTH should also be marked
        $sec =  "sec='$val'" if ("sec"     eq $key);
        $dl .= "      <dt>${txt}:</dt><dd $sec typ='$val' ><t> </t></dd><br />\n";
        # <t> tag necessary, otherwise dd::after will not work
    }
    # print last cipher
    $ul .= _man_ciphers_html_li($hex, $sec, $name, _man_ciphers_html_dl($dl)) if ("" ne $dl);
    return "$ul\n";
    #return "$ul\n  </p>\n";
} # _man_ciphers_html_ul

sub _man_ciphers_html_tb {
    #? helper function for man_ciphers_html(): return TABLE tag with content
    #  generate html table with all columns
    # SEE Cipher:text and Cipher:HTML
    my  $ciphers  = shift;
    my  $tab  = '  <table><thead>';
        $tab .= "\n    <tr>\n";
    # following not yet working
#      <colgroup>
#        <col style="width: 10%;">
#        <col style="width: 10%;">
#        <col style="width: 10%;">
#        ...
#      </colgroup>
#
    # build table header; cannot use "keys %ciphers_desc" because it's random
    # and we also want mixed rowspan and colspan
    # take care for sequence!
    $tab .= "      <th rowspan=2>$OSaft::Ciphers::ciphers_desc{'hex'}</th>\n";
    $tab .= "      <th rowspan=2>$OSaft::Ciphers::ciphers_desc{'sec'}</th>\n";
    $tab .= "      <th colspan=3>Names</th>\n";
    $tab .= "      <th rowspan=2>$OSaft::Ciphers::ciphers_desc{'openssl'}</th>\n";
    $tab .= "      <th rowspan=2>$OSaft::Ciphers::ciphers_desc{'ssl'}</th>\n";
    $tab .= "      <th rowspan=2>$OSaft::Ciphers::ciphers_desc{'keyx'}</th>\n";
    $tab .= "      <th rowspan=2>Authen-tication</th>\n";   # $OSaft::Ciphers::ciphers_desc{'auth'};
    $tab .= "      <th colspan=3>Encryption</th>\n";        # $OSaft::Ciphers::ciphers_desc{'enc'}
    $tab .= "      <th colspan=1>MAC</th>\n";
    $tab .= "      <th rowspan=2>$OSaft::Ciphers::ciphers_desc{'pfs'}</th>\n";
    $tab .= "      <th rowspan=2>RFC(s)&#xa0;URL</th>\n";   # $OSaft::Ciphers::ciphers_desc{'rfc'};
    $tab .= "      <th rowspan=2>$OSaft::Ciphers::ciphers_desc{'notes'}</th>\n";
    $tab .= "    </tr>\n";
    $tab .= "\n    <tr>\n";
    # second header line (for those with colpan= above
    foreach my $key (qw(suite names const enc bits enc_size mac)) {
        my $txt =  $OSaft::Ciphers::ciphers_desc{$key};
           $txt =~ s|^Encryption ||;
           $txt =~ s|MAC\s*/\s*HASH||i;
        $tab .= "      <th>$txt</th>\n";
    }
    $tab .= "    </tr></thead><tbody>\n";
    # build table lines
    my ($hex, $sec, $name, $td); $td = "";
    foreach my $line (split(/\n/, $ciphers)) {
        chomp($line);
        next if $line =~ m/^\s*$/;
        next if $line =~ m/^mac_/;
        next if $line =~ m/^name\s/;
        $line =~ s/^\s*//;              # remove leading whitespace
        if ($line =~ m/^0x/) {
            if ("" ne $td) {            # new cipher, print previous one
                $tab .= "    <tr>\n$td    </tr>\n";
                $td   = "";
            }
            ($hex, $sec, $name) = split(/\t/, $line);
            $td .= "        <td>$hex</td>\n";
            $td .= "        <td><span sec='$sec'>$sec</span></td>\n";
            $td .= "        <td>$name</td>\n";
            next;
        }
        my ($key, $val) = split(/\t/, $line);
        $sec = "";
        $sec = "sec='$val'" if ("openssl" eq $key); # OpenSSL STRENGTH should also be marked
        $sec = "sec='$val'" if ("sec" eq $key); # OpenSSL STRENGTH should also be marked
        $td .= "        <td typ='$val' $sec><t> </t></td>\n";
        # <t> tag necessary, otherwise td::after will not work
    }
    # print last cipher
    $tab .= "    <tr>\n$td    </tr>\n" if ("" ne $td);
    return "$tab\n  </tbody></table>\n";
} # _man_ciphers_html_tb

# TODO: instead of <dd><t> .. and <td><t> .. try to use <details>, see:
# https://developer.mozilla.org/en-US/docs/Web/HTML/Element/details

#_____________________________________________________________________________
#__________________________________________________________________ methods __|

sub man_docs_write  {
    #? generate all static help files
    # this function writes to files, not to STDOUT
    # TODO: anything hardcoded here, at least directory should be a parameter
    # NOTE: $cfg{'files'} should be same as $cfg(docs-help-all) in o-saft.tcl
    _man_dbx("man_docs_write() ...");
    if ($ich eq $cfg{me}) {
        _warn("094:", "'$parent' used as program name in generated files");
        _hint("documentation files should be generated using '$cfg{files}{SELF} --help=gen-docs'");
    }
    my $fh  = undef;
    foreach my $mode (keys %{$cfg{'files'}}) {
        next if $mode !~ m/^--help/;
        next if $mode =~ m/^--help=warnings/;   # TODO:
        my $doc = "$cfg{'files'}{$mode}";
        #_dbx# print("doc=$doc\n");
        open($fh, '>:encoding(UTF-8)', $doc) or do {
            _warn("093:", "help file '$doc' cannot be opened: $! ; ignored");
            next;
        };
        print $fh man_alias()           if ($mode =~ /alias$/);
        print $fh man_commands()        if ($mode =~ /commands?$/);
        print $fh man_options()         if ($mode =~ /opts$/);
        print $fh man_ciphers('text')   if ($mode =~ /ciphers.?text$/);
        print $fh man_help('NAME')      if ($mode =~ /help$/);
        print $fh man_help('CHECKS')    if ($mode =~ /checks$/);
        print $fh man_table('rfc')      if ($mode =~ /rfc$/);
        print $fh man_table('regex')    if ($mode =~ /regex$/);
        print $fh man_table('abbr')     if ($mode =~ /glossary?$/);
        print $fh man_table('data')     if ($mode =~ /data$/);
        close($fh);
    }
    exit(0);
    return; ##no critic qw(ControlStructures::ProhibitUnreachableCode)
} # man_docs_write

sub man_help_brief  {
    #? print overview of help commands (invoked with --h)
    # TODO: get this data from internal data structure when it is ready ...
    # extract all --help= options with their description from @help
    # using a foreach loop instead of regex to avoid memory polution
    _man_dbx("man_help_brief() ...");
    my %opts;
    my $skip  = 1;
    my $idx   = 0;  # perl hashes are sorted randomly, we want to keep the sequence in @help
    my $key   = "";
    foreach my $line (@help) {  # note: @help is in POD format
        # we expect somthing like:
        #    =head2 Options for help and documentation
        #    =head3 --help=cmds
        #
        #          Show available commands; short form.
        #
        #    ...
        #
        $skip = 1 if ($line =~ m/^=head2\s+Options for /);
        $skip = 0 if ($line =~ m/^=head2\s+Options for help/);
        next      if ($line =~ m/^=head2\s+Options for help/);
        next if (1 == $skip);
        next if ($line =~ m/^\s*$/);
        chomp $line;
        #_dbx "$line" if $skip == 0;
        if ($line =~ m/^=head3\s+--h/) {    # --h and --help and --help=*
            $idx++;
            $key  = $line;
            $key  =~ s/^=head3\s+//;
            $opts{$idx}->{'opt'} = $key;
            next;
        }
        $line =~ s/^\s*//;                  # normalise
        $line =~ s![IX]&([^&]*)&!$1!g;      # remove markup
        $line =  sprintf("\n%17s %s", " ", $line) if (defined $opts{$idx}->{'txt'});
        $opts{$idx}->{'txt'} .= $line;
    }
    my $pod = "\n" . _man_head(15, "Option", "Description");
    foreach my $key (sort {$a <=> $b} keys %opts) {
       $pod .= sprintf("%-17s %s\n", $opts{$key}->{'opt'}, $opts{$key}->{'txt'}||"");
    }
    $pod .=        _man_foot(15);
    $pod .= "\n" . _man_head(15, "Command", "Description");
    $pod .= _man_squeeze(18, $_cmd_brief);  # first most important commands, manually crafted here
    $pod .= _man_foot(15);
    my $opt = "";
       $opt = " --header" if (0 < $cfg_header); # be nice to the user
    $pod .= qq(\nFor more options  see: $cfg{me}$opt --help=opt);
    $pod .= qq(\nFor more commands see: $cfg{me}$opt --help=commands\n\n);
    return $pod;
} # man_help_brief

sub man_commands    {
    #? print commands and short description
    # data is mainly extracted from $parents internal data structure
    _man_dbx("man_commands($parent) ...");
    # SEE Help:Syntax
    my $txt = "\n" . _man_head(15, "Command", "Description");
    $txt .= _man_squeeze(18, $_commands);   # first print general commands, manually crafted here
    $txt .= _man_squeeze(18, _man_cmd_from_source());
    $txt .= _man_squeeze(18, _man_cmd_from_rcfile());
    $txt .= _man_foot(15) . "\n";
    return $txt;
} # man_commands

sub man_warnings    {
    #? print warning messages defined in code
    #? recommended usage:   $0 --header --help=warnings
    # data is extracted from separate file, which could be created by make
    _man_dbx("man_warnings($parent) ...");
    my $pod  = "";
    my $txt  = "";
    my $rex  = '.STR\{(?:ERROR|WARN|HINT)},|' . join('|', $OSaft::Text::STR{ERROR}, $STR{WARN}, $STR{HINT});
       $rex  =~ s/([*!])/\\$1/g;# escape meta chars in text
       $rex  = qr($rex);        # match our own messages only
    my $fh   = undef;
    my $doc  = 'docs/o-saft.pl.--help=warnings';
        # file generated by: "make doc.data", which calls "make warnings-info"
        # TODO: need some kind of configuration for the filename
    _man_dbx("man_warnings: rex=$rex");
    if (not open($fh, '<:encoding(UTF-8)', $doc)) {
        _warn("091:", "help file '$doc' cannot be opened: $! ; ignored");
        _hint($cfg{'hints'}->{'help=warnings'});
        return $pod;
    } # else
    # parse file and collect messages from there, print warnings while parsing
    # first,  otherwise it is difficult (for human readers) to distinguish the
    # collected messages from the warning messages printed while parsing; also
    # note that Perl's  warn()  and not  our own  _warn()  is used, because it
    # prints the line number from the read file,  which contains the line with
    # unknown/unexpected syntax
    # following formats of a line are expected:
    #       **WARNING: 042: text ..."    -- _warn() called with only one parameter
    #       **WARNING: 091:", "text ..." -- _warn() called with two parameters
    #       print $OSaft::Text::STR{WARN}, "text ..."  -- print used to print message
    #dbx# _dbx("rex $rex\n");
    while(<$fh>) {
        next if (m/^\s*#/);
        next if (m/^\s*$/);
        if (not m/$rex/) {
            warn($OSaft::Text::STR{WARN}, "092:", " help file '$doc' unknown syntax: '$_' ; ignored"); ## no critic qw(ErrorHandling::RequireCarping)
            next;
        }
        my ($err, $nr, $msg)  = m/($rex\s*)"?([0-9]{3}:?)(.*)/;
        my  $bad = 0;
            $bad = 1 if (not defined $err or $err =~ m/^$/);
            $bad = 1 if (not defined $nr  or $nr  =~ m/^$/);
            $bad = 1 if (not defined $msg or $msg =~ m/^$/);
        if ($bad == 1) {
             # unexpected format, silently print and continue
             #dbx# _dbx("bad $_");
             $txt .= $_;
             next;
        }
        $err =~ s/\$OSaft::Text::STR\{ERROR}/$STR{ERROR}/;
        $err =~ s/\$OSaft::Text::STR\{WARN}/$STR{WARN}/;
        $err =~ s/, *//;
        $msg =~ s/^[", ]*//;
        $txt .= sprintf("%s%s\t- %s\n", $err, $nr, $msg);
    }
    close($fh); ## no critic qw(InputOutput::RequireCheckedClose)
    # print collected messages
    $pod .= <<"EoHelp";

=== Warning and error messages ===

= Messages numbers and texts used in $cfg{'me'} and its own modules.
= Note that message texts may contain variables, like '\$key', which are
=      replaced with propper texts at runtime.

# TODO: some missing, i.e. 002: 003: 004:

EoHelp
    $pod .= _man_head(15, "Error/Warning", "Message text");
    $pod .= $txt;
    $pod .= _man_foot(15);
    # TODO: return if (($cfg{'out'}->{'warning'} + $cfg{'out'}->{'hint'}) < 2);
    return $pod;
} # man_warnings

sub man_opt_help    {
    #? print program's --help* options
    _man_dbx("man_opt_help() ..");
    my $txt = "";
    foreach (@help) { $txt .= $_ if (m/Options for help and documentation/..m/Options for all commands/); };
        # TODO: quick&dirty match against to fixed strings (=head lines)
    $txt =~ s/^=head.//msg;
    $txt =~ s/Options for all commands.*.//msg;
    $txt = _man_squeeze(undef, $txt);
    return $txt;
} # man_opt_help

sub man_ciphers_html{
    #? print ciphers in HTML format
    my $txt = shift;
    _man_dbx("man_ciphers_html() ..");
    my $cnt = scalar(keys %ciphers);
    my $htm = 
            $html{'doctype'}
          . '<html><head>'
          . $html{'meta'}
          . '<style>'
          . $html{'style_root'}
          . $html{'style_button'}
          . $html{'style_ciphers'}
          . '</style></head>'
          . << "EoHTML";

<body>
  <h2><span id="txt" >$html{'title'}</span>
  <a class="b" title="Toggle Layout: table or list" href="/cgi-bin/o-saft.cgi?--cgi&--header&--content-type=html&--help=ciphers-list">table <> list</a>
  </h2>
  <h1> $cnt Cipher Suites</h1>
EoHTML

    $htm .= _man_ciphers_html_tb($txt);
    $htm .= '</body></html>';
    return $htm;
} # man_ciphers_html

sub man_ciphers_list{
    #? print ciphers in HTML format
    my $txt = shift;
    _man_dbx("man_ciphers_html() ..");
    my $cnt = scalar(keys %ciphers);
    my $head= $html{'meta'};
    my $htm = 
            $html{'doctype'}
          . '<html><head>'
          . $html{'meta'}
          . '<style>'
          . $html{'style_root'}
          . $html{'style_button'}
          . $html{'style_ciphers'}
          . '</style></head>'
          . << "EoHTML";

<body>
  <h2><span id="txt" >$html{'title'}</span>
  <a class="b" title="Toggle Layout: table or list" href="/cgi-bin/o-saft.cgi?--cgi&--header&--content-type=html&--help=ciphers-html">table <> list</a>
  </h2>
  <h1> $cnt Cipher Suites</h1>
EoHTML

    $htm .= _man_ciphers_html_ul($txt);
    $htm .= '</body></html>';
    return $htm;
} # man_ciphers_list

sub man_ciphers_text{
    #? print ciphers in simple line-based text format
    my $txt = shift;
    my $keys= "";
    _man_dbx("man_ciphers_text() ..");
    if (0 < $VERBOSE) {
        foreach my $key (keys %OSaft::Ciphers::ciphers_desc) {
            next if "additional_notes" eq $key;
            $keys .= "#\t$key\t$OSaft::Ciphers::ciphers_desc{$key}\n";
        }
    }
    # _man_head() and _man_food() doesn't make sense here
    foreach my $key (keys %OSaft::Ciphers::ciphers_desc) {
        # convert internal keys to human readable text
	# $key must be followed by white space
        $txt =~ s/\n$key\s/\n\t$OSaft::Ciphers::ciphers_desc{$key}\t/g;
    }
    my $note= $OSaft::Ciphers::ciphers_desc{'additional_notes'};
       $note=~ s/\n/\n= /g;    # add text for note with usual = prefix
       # see also %ciphers_desc in OSaft::Ciphers.pm;
    return "$keys$txt$note\n";
} # man_ciphers_text

sub man_ciphers     {
    #? print ciphers, $typ denotes type of output: text or html
    # see also https://ciphersuite.info/cs/
    my $typ = shift;# text or html
    _man_dbx("man_ciphers($typ) ..");
    my $txt = _man_ciphers_get();
    return man_ciphers_html($txt) if ('html' eq $typ);
    return man_ciphers_list($txt) if ('list' eq $typ);
    return man_ciphers_text($txt) if ('text' eq $typ);
    return "";
} # man_ciphers

sub man_table       {   ## no critic qw(Subroutines::ProhibitExcessComplexity)
    #? print data from hash in tabular form, $typ denotes hash
    # header of table is not printed if $typ is cfg-*
    # NOTE critic: McCabe 22 (tested 5/2016) is not that bad here ;-)
    my $typ = shift;# NOTE: lazy matches against $typ below, take care with future changes
       $typ =~ s/^cipher(pattern|range)/$1/;# normalise: cipherrange and range are possible
    my $pod =  "";
    _man_dbx("man_table($typ) ..");
    my %types = (
        # typ        header left    separator  header right
        #-----------+---------------+-------+-------------------------------
        'regex' => ["key",           " - ",  " Regular Expressions used internally"],
        'ourstr'=> ["key",           " - ",  " Regular Expressions to match own output"],
        'abbr'  => ["Abbrevation",   " - ",  " Description"],
        'intern'=> ["Command",       "    ", " list of commands"],
        'compl' => ["Compliance",    " - ",  " Brief description of performed checks"],
        'range' => ["range name",    " - ",  " hex values in this range"],
        'pattern' =>["pattern name", " - ",  " pattern description; used pattern"],
        'rfc'   => ["Number",        " - ",  " RFC Title and URL"],
        'links' => ["Title",         " - ",  " URL"],
        'check' => ["key",           " - ",  " Label text"],
        'data'  => ["key",           " - ",  " Label text"],
        'hint'  => ["key",           " - ",  " Hint text"],
        'text'  => ["key",           " - ",  " text"],
        'cmd'   => ["key",           " - ",  " list of commands"],
    );
    my $txt = "";
    my $sep = "\t";
    if (defined $types{$typ}) { # defensive programming
       $sep = $types{$typ}->[1];
    } else {
       if ($typ =~ m/(?:^cfg[_-]|[_-]cfg$)/) {
           # the purpose of cfg_* is to print the results in a format so that
           # they can be used with copy&paste as command-line arguments
           # simply change the separator to =  while other headers are unused
           # (because no header printed at all)
           $sep = "=" if ($typ =~ m/(?:^cfg[_-]|[_-]cfg$)/);
       } else {
           # this is a programming error, hence always printed on STDERR
           print STDERR "**WARNING: 510: unknown table type '$typ'; using 'text' instead.\n";
           return $pod; # avoid uninitialised value; return as no data for $typ is available
       }
    }
    _man_dbx("man_table($typ) ...");
    if ($typ !~ m/^cfg/) {
        $pod .= _man_head(16, $types{$typ}->[0], $types{$typ}->[2]);
    }

    # first only lists, which cannot be redefined with --cfg-*= (doesn't make sense)

    TABLE: {
    if ($typ =~ m/(abbr|links?|rfc)/) {
        $pod .= _man_doc_opt($typ, $sep, 'opt');    # abbr, rfc, links, ...
        last;
    }

    if ($typ eq 'compl') {
        $pod .= _man_opt($_, $sep, $cfg{'compliance'}->{$_})    foreach (sort keys %{$cfg{'compliance'}});
        last;
    }

    if ($typ eq 'intern') {
        # first list command with all internal commands_*
        foreach my $key (sort keys %cfg) {
            next if ($key !~ m/^commands_(?:.*)/);
            $pod .= _man_opt($key,        $sep, "+" . join(' +', @{$cfg{$key}}));
        }
        foreach my $key (sort keys %cfg) {
            next if ($key !~ m/^cmd-(.*)/);
            $pod .= _man_opt("cmd-" . $1, $sep, "+" . join(' +', @{$cfg{$key}}));
        }
        last;
    }

    # now all lists, which can be redefined with --cfg-*=
    # _man_cfg() prints different data for  --help=TYP and --help=TYP-cfg
    if ($typ =~ m/(hint|ourstr|pattern|range|regex)/) {
        my $list = $1;
           $list =~ s/^cfg[._-]?//;
           $list =~ s/[._-]?cfg$//;
           $list =  'hints' if ($list =~ m/hint/);  # the key in %cfg is 'hints'; 'hint' is different
           $list =  'cipherpatterns' if ($list =~ m/pattern/);
           $list =  'cipherranges'   if ($list =~ m/range/);
        # TODO: --cfg_range=* and --cfg-regex=*  are not yet implemented
        #       however, we can print it using --help=cfg-regex
        foreach my $key (sort keys %{$cfg{$list}}) {
            $txt =  $cfg{$list}->{$key} || "";  # "" to avoid "Use of uninitialized value ..."
            if ('ARRAY' eq ref($cfg{$list}->{$key})) {
                $txt = join("\t", @{$cfg{$list}->{$key}});
            }
            if ('range' eq $typ) {
                $txt =~ s/     */                   /g; # adjust leading spaces
            }
            $pod .= _man_cfg($typ, $key, $sep, $txt);
        }
        last;
    }
    if ($typ =~ m/cmd/) {
        foreach my $key (sort keys %cfg) {
            next if ($key !~ m/^cmd-/);
            $txt =  $cfg{$key};
            if ('ARRAY' eq ref($cfg{$key})) {
                $txt = join(" ", @{$cfg{$key}});
            }
            $key =~ s/^cmd.// if ($typ =~ m/cfg/);
                # $key in %cfg looks like  cmd-sni, but when configuring the
                # key in RC-FILE it looks like  --cfg_cmd=sni=   ...
            $pod .= _man_cfg($typ, $key, $sep, $txt);
        }
        last;
    }
    if ($typ =~ m/check/) {
        foreach my $key (sort keys %checks) {
            $pod .= _man_cfg($typ, $key, $sep, $checks{$key}->{txt});
        }
        last;
    }
    if ($typ =~ m/(?:data|info)/) {
        foreach my $key (sort keys %data) {
            $pod .= _man_cfg($typ, $key, $sep, $data{$key}->{txt});
        }
        last;
    }
    if ($typ =~ m/text/) {
        foreach my $key (sort keys %text) {
            #_dbx "$key : " . ref($text{$key});
            if ('' eq ref($text{$key})) {   # string
                $pod .= _man_txt($typ, $key, $sep, $text{$key});
            }
            if ('HASH' eq ref($text{$key})) {
                # TODO: not yet printed, as it may confuse the user
                #foreach my $k (sort keys $text{$key}) {
                #    $txt  = $text{$key}->{$k};
                #    $pod .= _man_txt($typ, "$key($k)", $sep, $txt);
                #}
            }
        }
        last;
    }
    } # TABLE
    if ($typ !~ m/cfg/) {
        $pod .= _man_foot(16);
    } else {
        # additional message here is like a WARNING or Hint,
        # do not print it if any of them is disabled
        $pod .=  <<"EoHelp" if (($cfg{'out'}->{'warning'} + $cfg{'out'}->{'hint'}) > 1);
= Format is:  KEY=TEXT ; NL, CR and TAB are printed as \\n, \\r and \\t
= (Don't be confused about multiple  =  as they are part of  TEXT.)
= The string  @@  inside texts is used as placeholder.
= NOTE: " are not escaped!

EoHelp
    }
    return $pod;
} # man_table

sub man_alias       {
    #? print alias and short description (if available)
    #
    # Aliases are extracted from the source code. All lines handling aliases
    # for commands or options are marked with the pattern  # alias:
    # From these lines we extract the regex, the real option or command and
    # the comment.
    #
    #                 /------- regex -------\         /--- command ----\  /pattern\ /--- comment ---
    # Examples of lines to match:
    #    if ($arg eq  '--nosslnodataeqnocipher'){$arg='--nodatanocipher';} # alias:
    #    if ($arg =~ /^--ca(?:cert(?:ificate)?)$/i)  { $arg = '--cafile';} # alias: curl, openssl, wget, ...
    #    if ($arg =~ /^--cadirectory$/i)     { $arg = '--capath';        } # alias: curl, openssl, wget, ...
    #    if ($arg eq  '-c')                  { $arg = '--capath';        } # alias: ssldiagnose.exe
    #   #if ($arg eq  '--protocol')          { $arg = '--SSL';           } # alias: ssldiagnose.exe
    #
    _man_dbx("man_alias() ..");
    my $pod = "\n" . _man_head(27, "Alias (regex)         ", "command or option   # used by ...");
    my $txt =  "";
    my $fh  = undef;
    my $p   = '[._-]'; # regex for separators as used in o-saft.pl
    if (open($fh, '<:encoding(UTF-8)', _get_filename("o-saft.pl"))) { # need full path for $parent file here
        # TODO: o-saft.pl hardcoded, need a better method to identify the proper file
        while(<$fh>) {
            next if (not m(# alias:));
            next if (not m|^\s*#?if[^/']*.([^/']+).[^/']+.([^/']+).[^#]*#\s*alias:\s*(.*)?|);
            my $commt =  $3;
            my $alias =  $2;
            my $regex =  $1;
            # simplify regex for better (human) readability
            $regex =~ s/^\^//;      # remove leading ^
            $regex =~ s/^\\//;      # remove leading \
            $regex =~ s/\$$//;      # remove trailing $
            $regex =~ s/\(\?:/(/g;  # remove ?: in all groups
            $regex =~ s/\[\+\]/+/g; # replace [+] with +
            $regex =~ s/\$p\?/-/g;  # replace variable
            # check if alias is command or option
            if ($alias !~ m/^[+-]/) {
                # look not like command or option, use comment
                $alias = $commt if ($commt =~ m/^[+-]/);
            }
            if (29 > length($regex)) {
                $txt  = sprintf("%-29s%-21s# %s\n", $regex, $alias, $commt);
            } else {
                # pretty print if regex is to large for first column
                $txt  = sprintf("%s\n", $regex);
                $txt .= sprintf("%-29s%-21s# %s\n", "", $alias, $commt);
            }
            $pod .= _man_squeeze(29, $txt);
        }
        close($fh); ## no critic qw(InputOutput::RequireCheckedClose)
    }
    $pod .= _man_foot(27);
    $pod .= <<'EoHelp';
= Note for names in  Alias  column:
=   For option names  - or _ characters are not shown, they are stripped anyway.
=   For command names - or _ characters are also possible, but only - is shown.

EoHelp
    return $pod
} # man_alias

sub man_options     {
    #? print program's options
    my @txt  = grep{/^=head. (General|Option|--)/} @help;   # get options only
    foreach my $line (@txt) { $line =~ s/^=head. *//}       # remove leading markup
    my($end) = grep{$txt[$_] =~ /^Options vs./} 0..$#txt;   # find end of OPTIONS section
    # no need for _man_squeeze()
    return join('', "OPTIONS\n", splice(@txt, 0, $end));    # print anything before end
} # man_options

sub man_toc         {
    #? print help table of contents
    my $typ     = lc(shift) || "";      # || to avoid uninitialised value
    my $toc;
    _man_dbx("man_toc() ..");
    foreach my $txt (grep{/^=head. /} @help) {  # note: @help is in POD format
        next if ($txt !~ m/^=head/);
        next if ($txt =~ m/^=head. *END/);  # skip last line
        if ($typ =~ m/cfg/) {
            $txt =~ s/^=head1 *(.*)/{ $toc .= "--help=$1\n"}/e;
        } else {
            # print =head1 and =head2
            # just =head1 is lame, =head1 and =head2 and =head3 is too much
            $txt =~ s/^=head([12]) *(.*)/{ $toc .= "  " x $1 . $2 . "\n"}/e; # use number from =head as ident
        }
        # TODO:  $toc = _man_squeeze(6, $txt); # not really necessary
    }
    return $toc;
} # man_toc

sub man_pod         {
    #? print complete POD page for o-saft.pl --help=gen-pod
    _man_dbx("man_pod() ...");
    return
        _man_pod_head() .
        _man_pod_text() .
        _man_pod_foot();
} # man_pod

sub man_man         {
    #? print complete MAN page for o-saft.pl --help=gen-man
    # executable  pod2man is used instead of Pod::Man, mainly because Pod::Man
    # can only read from STDIN or a file, but input here for Pod::Man may come
    # from variables; 
    _man_dbx("man_man() ...");
    my $pod = "o-saft.pod";         # TODO: dirty hack to find proper .pod file
       $pod = "docs/o-saft.pod"     if (! -e $pod);
       $pod = "../docs/o-saft.pod"  if (! -e $pod);
    exec("pod2man --name=o-saft.pl --center='OWASP - SSL advanced forensic tool' --utf8 $pod" );
    # return;
} # man_man

sub man_html        {
    #? print complete HTML page for o-saft.pl --help=gen-html
    #? recommended usage:   $0 --no-warning --no-header --help=gen-html
    # for concept and functionality of the generated page  SEE HTML:HTML
    _man_dbx("man_html() ...");
    return
        _man_http_head() .
        _man_html_head() .
        _man_html('html', 'NAME', 'TODO') . # print complete help
        _man_html_foot();
} # man_html

sub man_cgi         {
    #? print complete HTML page for o-saft.pl used as CGI
    #? recommended usage:      $0 --no-warning --no-header --help=gen-cgi
    #?    o-saft.cgi?--cgi=&--usr&--no-warning&--no-header=&--cmd=html
    # for concept and functionality of the generated page  SEE HTML:CGI
    #
    # <a href="$cgi_bin?--cgi&--help=html"    target=_help >help (HTML format)</a>
    # previous link not generated because it prints multiple HTTP headers
    #
    # <from action= > and <a href= > values (link) must be specified using the
    # option  --usr-action=  at script start.
    #
    #my $cgi_bin = _man_usr_value('user-action') || _man_usr_value('usr-action') || "/cgi-bin/o-saft.cgi";
    _man_dbx("man_cgi() ...");
    return
        _man_http_head() .
        _man_html_head() .
        _man_html_form() .
        $html{'warning_box'} .  # not exactly the place in HTML for this <div>, but syntactically ok
        _man_html_foot();
    # TODO: osaft_action_http, osaft_action_file should be set dynamically
} # man_cgi

sub man_wiki        {
    #? print documentation for o-saft.pl in mediawiki format (to be used at owasp.org until 2019)
    #? recommended usage:   $0 --no-warning --no-header --help=gen-wiki
    my $mode =  shift;
        # currently only mode=colon is implemented to print  :*  instead of *
        # Up to VERSION 15.12.15 list items * and ** where printed without
        # leading : (colon). Some versions of mediawiki did not support :*
        # so we can switch this behavior now.
    _man_dbx("man_wiki($mode) ...");
    return
        _man_wiki_head()      .
        _man_wiki_text($mode) .
        _man_wiki_foot();
} # man_wiki

sub man_help        {
    #? print complete user documentation for o-saft.pl as plain text (man-style)
    # called when no special help, prints full help text or parts of it
    my $label   = lc(shift) || "";      # || to avoid uninitialised value
    my $anf     = uc($label);
    my $end     = "[A-Z]";
    my $hlp;
    _man_dbx("man_help($anf, $end) ...");
    if (0 < $::osaft_standalone) {  ## no critic qw(Variables::ProhibitPackageVars)
        # in standalone mode use $0 instead of $parent (which is "O-Saft")
        @help   = OSaft::Doc::Data::get_markup("help.txt", $0, $version);
    }
    my $txt = join ('', @help);
        # = OSaft::Doc::Data::get("help.txt", $parent, $version);
    if (1 < (grep{/^--v/} @ARGV)) {     # with --v --v
        return OSaft::Doc::Data::get_egg("help.txt");
    }
    if ($label =~ m/^name/i)    { $end = "TODO";  }
    #$txt =~ s{.*?(=head. $anf.*?)\n=head. $end.*}{$1}ms;# grep all data
        # above terrible performance and unreliable, hence in peaces below
    $txt =~ s/.*?\n=head1 $anf//ms;
    $txt =~ s/\n=head1 $end.*//ms;      # grep all data
    $txt =  "\n=head1 $anf" . $txt;
    $txt =~ s/\n=head2 ([^\n]*)/\n    $1/msg;
    $txt =~ s/\n=head3 ([^\n]*)/\n      $1/msg;
    $txt =~ s/\n=(?:[^ ]+ (?:\* )?)([^\n]*)/\n$1/msg;# remove inserted markup
    $txt =~ s/\nS&([^&]*)&/\n$1/g;
    $txt =~ s/[IX]&([^&]*)&/$1/g;       # internal links without markup
    $txt =~ s/L&([^&]*)&/"$1"/g;        # external links, must be last one
    $txt =  _man_squeeze(undef, $txt);
    if (0 < (grep{/^--v/} @ARGV)) {     # do not use $^O but our own option
        # some systems are tooo stupid to print strings > 32k, i.e. cmd.exe
        print "**WARNING: using workaround to print large strings.\n\n";
        $hlp .= $_ foreach split(//, $txt);  # print character by character :-((
    } else {
        $hlp .= $txt;
    }
    if ($label =~ m/^todo/i)    {
        $hlp .= "\n  NOT YET IMPLEMENTED\n";
        foreach my $label (sort keys %checks) {
            next if (0 >= _is_member($label, \@{$cfg{'commands_notyet'}}));
            $hlp .= "        $label\t- " . $checks{$label}->{txt} . "\n";
        }
    }
    return $hlp;
} # man_help

sub man_src_grep    {
    #? search for given text in source file, then pretty print
    my $hlp = shift;
    my $pod = "\n";
       $pod .= _man_head(14, "Option    ", "Description where program terminates");
    my $fh  = undef;
    if (open($fh, '<:encoding(UTF-8)', _get_filename("o-saft.pl"))) { # need full path for $parent file here
        # TODO: o-saft.pl hardcoded, need a better method to identify the proper file
        while(<$fh>) {
            next if (m(^\s*#));
            next if (not m(_(?:EXIT|NEXT).*$hlp));
            my $opt     = $_;
            my $comment = $_;
            if ($opt =~ m/exit=/) {
                # line looks like: _yeast_EXIT("exit=BEGIN0 - BEGIN start");
                # or             : _yeast_NEXT("exit=HOST0 - host start");
                $opt =~ s/^[^"]*"/--/;    $opt =~ s/ - .*$//s;
                $comment =~ s/^[^-]*//; $comment =~ s/".*$//s;
            }
           $pod .= sprintf("%-15s%s\n", $opt, $comment);
        }
        close($fh); ## no critic qw(InputOutput::RequireCheckedClose)
    }
    $pod .= _man_foot(14);
    return $pod;
} # man_src_grep

sub printhelp       {   ## no critic qw(Subroutines::ProhibitExcessComplexity)
    #? simple dispatcher for various help requests
    #  NOTE critic: as said: *this code is a simple dispatcher*, that's it
    my $hlp = shift;
    my $txt;
    _man_dbx("printhelp($hlp) ...");
    _man_use_tty();
    _man_html_init();   # must be called here, because function may be call anywhere
    # NOTE: some lower case strings are special
    $txt = man_help('NAME')             if ($hlp =~ /^$/);           ## no critic qw(RegularExpressions::ProhibitFixedStringMatches)
    $txt = man_help('TODO')             if ($hlp =~ /^todo$/i);      ## no critic qw(RegularExpressions::ProhibitFixedStringMatches)
    $txt = man_help('KNOWN PROBLEMS')   if ($hlp =~ /^(err(?:or)?|problem)s?$/i);
    $txt = man_help('KNOWN PROBLEMS')   if ($hlp =~ /^faq/i);
    $txt .= man_help('LIMITATIONS')     if ($hlp =~ /^faq/i);
    print  man_help($hlp)               if ($hlp =~ /^(?:CHECKS?|CUSTOM)$/); # case-sensitive!
           return                       if ($hlp =~ /^(?:CHECKS?|CUSTOM)$/); # ugly, but there is 'check' below
        # NOTE: bad design, as we have headlines in the documentation which
        #       are also used as spezial meaning (see below). In particular
        #       CHECKS  is a  headline for a section  in the documentation,
        #       while  checks  is used to print the labels of all performed
        #       checks. Workaround is to treat all-uppercase words as head-
        #       line of a section (see matches above), and anything else as
        #       special meaning (see matches below).
    # all following matches against $hlp are exact matches, see  ^  and  $
    # hence exactly one match is expected
    $hlp = lc($hlp);    # avoid i in regex
    $txt = man_toc($1)          if ($hlp =~ /^((?:toc|contents?)(?:.cfg)?)$/);
    $txt = man_html()           if ($hlp =~ /^(gen-)?html$/);
    $txt = man_wiki('colon')    if ($hlp =~ /^(gen-)?wiki$/);
    $txt = man_pod()            if ($hlp =~ /^(gen-)?pod$/);
    $txt = man_man()            if ($hlp =~ /^(gen-)?man$/);
    $txt = man_man()            if ($hlp =~ /^(gen-)?[nt]roff$/);
    $txt = man_cgi()            if ($hlp =~ /^(gen-)?cgi$/);
    $txt = man_ciphers('text')  if ($hlp =~ /^(gen-)?-?ciphers$/);
    $txt = man_ciphers('text')  if ($hlp =~ /^(gen-)?-?ciphers.?text$/);
    $txt = man_ciphers('list')  if ($hlp =~ /^(gen-)?-?ciphers.?list$/);
    $txt = man_ciphers('html')  if ($hlp =~ /^(gen-)?-?ciphers.?html$/);
    $txt = man_alias()          if ($hlp =~ /^alias(es)?$/);
    $txt = man_commands()       if ($hlp =~ /^commands?$/);
    $txt = man_options()        if ($hlp =~ /^opts?$/);
    $txt = man_warnings()       if ($hlp =~ /^warnings?$/);
    $txt = man_opt_help()       if ($hlp =~ /^help$/);
    $txt = man_help_brief()     if ($hlp =~ /^help[_.-]brief$/); # --h
    $txt = man_table('rfc')     if ($hlp =~ /^(gen-)?rfcs?$/);
    $txt = man_table('links')   if ($hlp =~ /^(gen-)?links?$/);
    $txt = man_table('abbr')    if ($hlp =~ /^(gen-)?(abbr|abk|glossary?)$/);
    $txt = man_table('compl')   if ($hlp =~ /^compliance$/);# alias
    $txt = man_table($1)        if ($hlp =~ /^(compl|hint|intern|pattern|range|regex)s?$/);
    $txt = man_table($1)        if ($hlp =~ /^(cipher[_.-]?(?:pattern|range|regex|ourstr)?)s?$/);
    # anything below requires data defined in parent
    $txt = man_table($1)        if ($hlp =~ /^(cmd|check|data|info|ourstr|text)s?$/);
    $txt = man_table('cfg_'.$1) if ($hlp =~ /^cfg[_.-]?(cmd|check|data|info|hint|text|range|regex|ourstr)s?$/);
    $txt = man_src_grep("exit=")if ($hlp =~ /^exit$/);
    if ($hlp =~ /^cmds$/)       { # print program's commands
        $txt = "# $parent commands:\t+"     . join(' +', @{$cfg{'commands'}});
        # no need for _man_squeeze()
    }
    if ($hlp =~ /^legacys?$/)   { # print program's legacy options
        $txt = "# $parent legacy values:\t" . join(' ',  @{$cfg{'legacys'}});
        # no need for _man_squeeze()
    }
    if ($hlp =~ m/^tools$/)     { # description for O-Saft tools
        my @txt = OSaft::Doc::Data::get("tools.txt", $parent, $version);
        #$txt = _man_squeeze(undef, "@txt"); # TODO: does not work well here
        $txt = join("", @txt);
    }
    if ($hlp =~ m/^Program.?Code$/i) { # print Program Code description
        my @txt = OSaft::Doc::Data::get("coding.txt", $parent, $version);
        #$txt = _man_squeeze(undef, "@txt"); # TODO: does not work well here
        $txt = join("", @txt);
    }
    if (not $txt)               { # nothing matched so far, print special section from help
        _man_dbx("printhelp: " . uc($hlp));
        $txt = man_help(uc($hlp))   if ($hlp !~ m/^[+-]-?/);    # bare words only
    }
    print $txt || "";
    return;
} # printhelp

#_____________________________________________________________________________
#_____________________________________________________________________ main __|

sub _main_man       {
    #? print own documentation or special required one
    push(@ARGV, "--help") if 0 > $#ARGV;
    #  SEE Perl:binmode()
    binmode(STDOUT, ":unix:utf8"); ## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
    binmode(STDERR, ":unix:utf8"); ## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
    while (my $arg = shift @ARGV) {
        # --help and --gen-docs is special, anything els handled in printhelp()
        #TODO: __FILE__ must be __PACKAGE__ if this file is a perl module
        print_pod($0, __FILE__, $SID_man) if ($arg =~ m/--?h(?:elp)?$/x);
        # ----------------------------- options
        if ($arg =~ m/^--(?:v|trace.?CMD)/i) { $VERBOSE++; next; }  # allow --v
        # ----------------------------- commands
        if ($arg =~ /^version$/)         { print "$SID_man\n"; next; }
       #if ($arg =~ /^[-+]?V(ERSION)?$/) { print "$VERSION\n"; next; }
        man_docs_write()            if ($arg =~ m/--(?:help=)?gen[_.=-]?docs/x);
        # testing this module is technically the same as getting the text
        $arg =~ s/--help[_.=-]?//;  # allow --help=* and simply *
        $arg =~ s/--test[_.=-]?//;  # allow --test-* also,
	next if ($arg =~ m/^[+-]-?/);   # ignore other options
        printhelp($arg);
    }
    exit 0;
} # _main_man

sub saft_man_done   {}; # dummy to check successful include

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

=pod

=encoding utf8


=head1 _____________________________________________________________________________

=head1 NAME

o-saft-man.pm - Perl module to handle O-Saft's documentation


=head1 DESCRIPTION

This module provides functionality to generate O-Saft's user documentation
in various formats. Supported formats are:

=over 2

=item * POD

=item * *roff (man page)

=item * HTML

=item * mediawiki

=item * Plain Text

=back

Additionally various parts of the  documentation can be generated.  Please
see  L<METHODS>  below.


=head1 SYNOPSIS

=over 2

=item * require q{o-saft-man.pm}; printhelp($format); # in Perl code

=item * o-saft-man.pm --help        # on command-line will print help

=item * o-saft-man.pm [<$format>]   # on command-line

=back

For compatibility with other programs and modules it also supports:

=over 2

=item * o-saft-man.pm --help=<$format>

=item * o-saft-man.pm --test-<$format>

=back


=head1 METHODS

=over 2

=item * printhelp($format)

Public method for  all functionality.  The generated output format depends
on the $format parameter, which is a literal string, as follows:

=over 2

=item * pod     -> all documentation in POD format

=item * man     -> all documentation in MAN (nroff) format

=item * html    -> all documentation in HTML format

=item * wiki    -> all documentation in mediawiki format

=item * NAME    -> all documentation in plain text (man-style) format

=item * <empty>

=item * NAME    -> all documentation in plain text (man-style) format

=item * ciphers-text -> list all ciphers with all information in text format

=item * ciphers-list -> list all ciphers with all information in HTML list format

=item * ciphers-html -> list all ciphers with all information in HTML table format

=item * contents

=item * toc     -> table of contents for documentation as plain text

=item * help    -> list all options to get (help) information

=item * cgi     -> all documentation as HTML for CGI usage

=item * alias   -> list of all aliases for commands and options

=item * cmds    -> list of all commands (just the commands)

=item * command -> list of all commands with brief description

=item * opts    -> list of all options (just the options)

=item * options -> list of all options with full description

=item * legacy  -> list of legacy options

=item * checks  -> list of all SSL/TLS checks (each can be used as command)

=item * data    -> list of all SSL/TLS data values (each can be used as command)

=item * info    -> list of all SSL/TLS info values (each can be used as command)

=item * pattern -> list of supported pttern for SSL/TLS cipher ranges (for +cipher)

=item * range   -> list of supported SSL/TLS cipher ranges (for +cipher)

=item * regex   -> list of most RegEx used internaly for SSL/TLS checks

=item * ourstr  -> list with RegEx matching special strings used in output

=item * tools   -> list of tools delivered with o-saft.pl

=item * hint    -> list texts used in !!Hint messages

=item * abbr

=item * glossar -> list of abbrevations and terms according SSL/TLS

=item * links   -> list of links according SSL/TLS (incomplete)

=item * rfc     -> list of RFCs according SSL/TLS (incomplete)

=item * faq     -> lists known problems and limitations

=item * todo    -> show list of TODOs

=item * error   -> show known problems about warning and error messages

=item * warnings -> show used message texts for warnings and errors

=item * intern  -> show internal grouped commands

=item * Program.Code  -> description of coding style, conventions, etc.

=back

=back

If any other string is used,  'printhelp()'  extracts just the section of
the documention which is headed by that string.

The  I<--header>  option can be used for simple formatting.

Note that above list is also documented in ./OSaft/Doc/help.txt in section
"Options for help and documentation".
In a perfect world it would be extracted from there (or vice versa).


=head1 VERSION

2.84 2022/11/21


=head1 AUTHOR

14-nov-14 Achim Hoffmann

=cut

## PACKAGE }
} # o-saft-man.pm

{ # o-saft-dbx.pm
## PACKAGE {

#!# Copyright (c) 2022 Achim Hoffmann
#!# This  software is licensed under GPLv2. Please see o-saft.pl for details.

package main;   # ensure that main:: variables are used, if not defined herein

# HACKER's INFO
#       Following (internal) functions from o-saft.pl are used:
#       _is_cfg_do()
#       _is_cfg_intern()
#       _is_member()
#       _need_cipher()

## no critic qw(Subroutines::RequireArgUnpacking)
#        Parameters are ok for trace output.

## no critic qw(Subroutines::ProhibitUnusedPrivateSubroutines)
#        That's intended.

## no critic qw(ValuesAndExpressions::ProhibitImplicitNewlines)
#        That's intended in strings; perlcritic is too pedantic.

## no critic qw(RegularExpressions::RequireExtendedFormatting)
#        We believe that most RegEx are not too complex.

# for Severity 2 only:
## no critic qw(ValuesAndExpressions::ProhibitMagicNumbers)
#        We have some constants herein, that's ok.

## no critic qw(ValuesAndExpressions::ProhibitNoisyQuotes)
#        We have a lot of single character strings, herein, that's ok.

## no critic qw(TestingAndDebugging::RequireUseStrict)
#  `use strict;' not useful here, as we mainly use our global variables
use warnings;

no warnings 'redefine'; ## no critic qw(TestingAndDebugging::ProhibitNoWarnings)
   # must be herein, as most subroutines are already defined in main
   # warnings pragma is local to this file!
no warnings 'once';     ## no critic qw(TestingAndDebugging::ProhibitNoWarnings)
   # "... used only once: possible typo ..." appears when called as main only

BEGIN { # mainly required for testing ...
    # SEE Perl:@INC
    # SEE Perl:BEGIN perlcritic
    my $_me   = $0;     $_me   =~ s#.*[/\\]##x;
    my $_path = $0;     $_path =~ s#[/\\][^/\\]*$##x;
    unshift(@INC, $_path)   if (1 > (grep{/^$_path$/} @INC));
    unshift(@INC, "..")     if (1 > (grep{/^\.\.$/}   @INC));
    unshift(@INC, ".")      if (1 > (grep{/^\.$/}     @INC));
}

#-# use OSaft::Text qw(%STR print_pod);

my  $SID_dbx= "@(#) o-saft-dbx.pm 2.24 22/11/05 13:11:14";

#_____________________________________________________________________________
#__________________________________________________________________ methods __|
# debug methods

sub _yTIME      {
    return "" if (not _is_cfg_out('traceTIME'));
    my $now = time() - ($time0 || 0);
       $now = time() if (_is_cfg_out('time_absolut'));# $time0 defined in main
       $now +=1 if (0 > $now);  # fix runtime error: $now == -1
    return sprintf(" %02s:%02s:%02s", (localtime($now))[2,1,0]);
}
sub __yeast     { return $cfg{'prefix_verbose'} . $_[0]; }
sub ___ARG      { return $cfg{'prefix_verbose'} .            " ARG: " . join(" ", @_);    }
sub ___CMD      { return $cfg{'prefix_verbose'} . _yTIME() . " CMD: " . join(" ", @_);    }
sub __line      { return "#----------------------------------------------------" . $_[0]; }
sub ___ARR      { return join(" ", "[", sort(@_), "]"); }
sub __INIT      { return sprintf("%s%21s= %s", $cfg{'prefix_verbose'}, $_[0], $_[1]);     }
sub __TRAC      { return sprintf("%s%14s= %s", $cfg{'prefix_verbose'}, $_[0], $_[1]);     }
sub _y_ARG      { local $\ = "\n"; print ___ARG(@_) if (_is_cfg_out('traceARG')); return; }
sub _y_CMD      { local $\ = "\n"; print ___CMD(@_) if (_is_cfg_out('traceCMD')); return; }
sub _yeast      { local $\ = "\n"; print __yeast($_[0]);return; }
sub _yINIT      { local $\ = "\n"; print __INIT(@_);    return; }
sub _yTRAC      { local $\ = "\n"; print __TRAC(@_);    return; }
sub _yline      { _yeast(__line($_[0]));                return; }
sub _ynull      { _yeast("value <<undef>> means that internal variable is not defined @_"); return; }
sub __trac      {}      # forward declaration
sub __trac      {
    #? print variable according its type, understands: CODE, SCALAR, ARRAY, HASH
    my $ref  = shift;   # must be a hash reference
    my $key  = shift;
    my $data = "";
    if (not defined $ref->{$key}) {
        # undef is special, avoid perl warnings
        return __TRAC($key, "<<undef>>");
    }
    SWITCH: for (ref($ref->{$key})) {   # ugly but save use of $_ here
        /^$/    && do { $data .= __TRAC($key, $ref->{$key}); last SWITCH; };
        /CODE/  && do { $data .= __TRAC($key, "<<code>>");   last SWITCH; };
        /SCALAR/&& do { $data .= __TRAC($key, $ref->{$key}); last SWITCH; };
        /ARRAY/ && do { $data .= __TRAC($key, ___ARR(@{$ref->{$key}})); last SWITCH; };
        /HASH/  && do { last SWITCH if (2 >= $ref->{'trace'});      # print hashes for full trace only
                        $data .= __yeast("# - - - - HASH: $key = {");
                        foreach my $k (sort keys %{$ref->{$key}}) {
                            $data .= __TRAC("    ".$key."->".$k, join("-", ${$ref->{$key}}{$k})); # TODO: output needs to be improved
                        };
                        $data .= __yeast("# - - - - HASH: $key }");
                        last SWITCH;
                      };
        # DEFAULT
                        $data .= __yeast($OSaft::Text::STR{WARN} . " user defined type '$_' skipped");
    } # SWITCH

    return $data;
} # __trac

sub _yeast_trac { local $\ = "\n"; my $d = __trac(@_); print $d if ($d !~ m/^\s*$/); return; }
    #? print variable according its type, understands: CODE, SCALAR, ARRAY, HASH
    #  avoids printing of empty lines

sub _yeast_ciphers_list {
    #? print ciphers fromc %cfg (output optimised for +cipher)
    return if (0 >= ($cfg{'trace'} + $cfg{'verbose'}));
    _yline(" ciphers {");
    my $_cnt = scalar @{$cfg{'ciphers'}};
    my $need = _need_cipher();
    my $ciphers = "@{$cfg{'ciphers'}}"; # not yet used
    _yeast("  _need_cipher= $need");
    if (0 < $need) {
        # avoid printing huge lists
        my @range;
        if ($cfg{'cipherrange'} =~ m/(full|huge|long|safe|rfc|intern)/i) {
            # avoid huge (useless output)
            $_cnt = 0xffffff;
            $_cnt = 0x2fffff if ($cfg{'cipherrange'} =~ m/safe/i);
            $_cnt = 0xffff   if ($cfg{'cipherrange'} =~ m/long/i);
            $_cnt = 0xffff   if ($cfg{'cipherrange'} =~ m/huge/i);
            $_cnt = 2051     if ($cfg{'cipherrange'} =~ m/rfc/i);   # estimated count
            $_cnt = 2640     if ($cfg{'cipherrange'} =~ m/intern/i);# estimated count
            @range = "<<huge list not printed>>";
        } else {
            # expand smaller list
            @range = osaft::get_ciphers_range('TLSv13', $cfg{'cipherrange'});
               # NOTE: osaft::get_ciphers_range() first arg is the SSL version,
               #       which is usually unknown here, hence TLSv13 is passed
            $_cnt = scalar @range;
        }
        $_cnt = sprintf("%5s", $_cnt);  # format count
        _yeast("use cipher from openssl= " . $cmd{'extciphers'});
        _yeast("      starttls= " . $cfg{'starttls'});
        _yeast(" cipherpattern= " . $cfg{'cipherpattern'});
        _yeast("   cipherrange= " . $cfg{'cipherrange'});
        # format range text
        foreach my $txt (split(/\n/, $cfg{'cipherranges'}->{$cfg{'cipherrange'}})) {
            next if $txt =~ m/^\s*$/;
            $txt =~ s/^\s*/                /;
            _yeast($txt);
        }
        _yeast(" $_cnt ciphers= @range");
    }
    _yline(" ciphers }");
    return;
} # _yeast_ciphers_list

sub _yeast_targets      {
    #? print information about targets to be processed
    my $trace   = shift;
    my $prefix  = shift;
    my @targets = @_;
    #print " === print internal data structures for a targets === ";
    if (0 == $trace) { # simple list
        printf("%s%14s= [ ", $prefix, "targets");
        foreach my $target (@targets) {
            next if (0 == @{$target}[0]);       # first entry conatins default settings
            printf("%s:%s%s ", @{$target}[2..3,6]);
               # the perlish way instead of get_target_{host,port,path}
        }
        printf("]\n");
    } else {
        printf("%s%14s targets = [\n", $prefix, "# - - - -ARRAY");
        printf("%s#  Index %6s %24s : %5s %10s %5s %-16s %s\n",
                $prefix, "Prot.", "Hostname or IP", "Port", "Auth", "Proxy", "Path", "Orig. Parameter");
        foreach my $target (@targets) {
            #next if (0 == @{$target}[0]);       # first entry conatins default settings
            printf("%s   [%3s] %6s %24s : %5s %10s %5s %-16s %s\n", $prefix, @{$target}[0,1..7]);
        }
        printf("%s%14s ]\n", $prefix, "# - - - -ARRAY");
    }
    return;
} # _yeast_targets

sub _yeast_init {   ## no critic qw(Subroutines::ProhibitExcessComplexity)
    #? print important content of %cfg and %cmd hashes
    #? more output if 1<trace; full output if 2<trace
    return if (0 >= ($cfg{'trace'} + $cfg{'verbose'}));
    local $\ = "\n";
    my $arg = " (does not exist)";
    ## no critic qw(Variables::ProhibitPackageVars); they are intended here
    if (-f $cfg{'RC-FILE'}) { $arg = " (exists)"; }
    _yeast("!!Hint: use --trace=2  to see Net::SSLinfo variables") if (2 > $cfg{'trace'});
    _yeast("!!Hint: use --trace=2  to see external commands")      if (2 > $cfg{'trace'});
    _yeast("!!Hint: use --trace=3  to see full %cfg")              if (3 > $cfg{'trace'});
    _ynull();
    _yeast("#") if (3 > $cfg{'trace'});
    _yline("");
    _yTRAC("_yeast_init::SID", $SID_dbx) if (2 > $cfg{'trace'});
    _yTRAC("$0", _VERSION());    # $0 is same as $ARG0
    # official VERSIONs, not those of the current files !
    _yTRAC("::osaft",  $osaft::VERSION);
    _yTRAC("Net::SSLhello", $Net::SSLhello::VERSION) if defined($Net::SSLhello::VERSION);
    _yTRAC("Net::SSLinfo",  $Net::SSLinfo::VERSION);
    # quick info first
    _yTRAC("RC-FILE", $cfg{'RC-FILE'} . $arg);
    _yTRAC("--rc",    ((grep{/(?:--rc)$/i}     @ARGV) > 0)? 1 : 0);
    _yTRAC("--no-rc", ((grep{/(?:--no.?rc)$/i} @ARGV) > 0)? 1 : 0);
    _yTRAC("verbose", $cfg{'verbose'});
    _yTRAC("trace",  "$cfg{'trace'}, traceARG=$cfg{'out'}->{'traceARG'}, traceCMD=$cfg{'out'}->{'traceCMD'}, traceKEY=$cfg{'out'}->{'traceKEY'}, traceTIME=$cfg{'out'}->{'traceTIME'}");
    _yTRAC("time_absolut", $cfg{'out'}->{'time_absolut'});
    _yTRAC("dbx{file}", "[ " . join(", ", @{$dbx{'file'}}) . " ]");

    if (1 < $cfg{'trace'}) {
        _yline(" Net::SSLinfo {");
        _yTRAC("::trace",         $Net::SSLinfo::trace);
        _yTRAC("::linux_debug",   $Net::SSLinfo::linux_debug);
        _yTRAC("::slowly",        $Net::SSLinfo::slowly);
        _yTRAC("::timeout",       $Net::SSLinfo::timeout);
        _yTRAC("::use_openssl",   $Net::SSLinfo::use_openssl);
        _yTRAC("::use_sclient",   $Net::SSLinfo::use_sclient);
        _yTRAC("::use_extdebug",  $Net::SSLinfo::use_extdebug);
        _yTRAC("::use_nextprot",  $Net::SSLinfo::use_nextprot);
        _yTRAC("::use_reconnect", $Net::SSLinfo::use_reconnect);
        _yTRAC("::use_SNI",       $Net::SSLinfo::use_SNI);
        _yTRAC("::use_http",      $Net::SSLinfo::use_http);
        _yTRAC("::no_cert",       $Net::SSLinfo::no_cert);
        _yTRAC("::no_cert_txt",   $Net::SSLinfo::no_cert_txt);
        _yTRAC("::protos_alpn",   $Net::SSLinfo::protos_alpn);
        _yTRAC("::protos_npn",    $Net::SSLinfo::protos_npn);
        _yTRAC("::sclient_opt",   $Net::SSLinfo::sclient_opt);
        _yTRAC("::ignore_case",   $Net::SSLinfo::ignore_case);
        _yTRAC("::timeout_sec",   $Net::SSLinfo::timeout_sec);
        _yline(" Net::SSLinfo }");
    }

    _yline(" %cmd {");
    if (2 > $cfg{'trace'}) {    # user friendly information
        _yeast("          path= " . ___ARR(@{$cmd{'path'}}));
        _yeast("          libs= " . ___ARR(@{$cmd{'libs'}}));
        _yeast("     envlibvar= $cmd{'envlibvar'}");
        _yeast("       timeout= $cmd{'timeout'}");
        _yeast("       openssl= $cmd{'openssl'}");
    } else {    # full information
        foreach my $key (sort keys %cmd) { _yeast_trac(\%cmd, $key); }
    }
    _yeast("    extopenssl= $cmd{'extopenssl'}");   # user friendly always
    _yeast("use cipher from openssl= $cmd{'extciphers'}");  # dito.
    _yline(" %cmd }");

    if (1 < $cfg{'trace'}) {    # full information
        _yline(" complete %cfg {");
        foreach my $key (sort keys %cfg) {
            if ($key =~ m/(hints|openssl|ssleay|sslerror|sslhello|regex|^out|^use)$/) { # |data
                # TODO: ugly data structures ... should be done by _yTRAC()
                _yeast("# - - - - HASH: $key = {");
                foreach my $k (sort keys %{$cfg{$key}}) {
                    if ($key =~ m/openssl/) {
                        _yTRAC($k, ___ARR(@{$cfg{$key}{$k}}));
                    } else {
                        #_yTRAC($k, $cfg{$key}{$k});
                        _yeast_trac($cfg{$key}, $k);
                    };
                };
                _yeast("# - - - - HASH: $key }");
            } else {
                if ($key =~ m/targets/) {   # TODO: quick&dirty to get full data
                    _yeast_targets($cfg{'trace'}, $cfg{'prefix_verbose'}, @{$cfg{'targets'}});
                } else {
                    if ("time0" eq $key and defined $ENV{'OSAFT_MAKE'}) {
                        # SEE Make:OSAFT_MAKE (in Makefile.pod)
                        my $t0 = $cfg{'time0'};
                        $cfg{'time0'} = $OSaft::Text::STR{MAKEVAL};
                        _yeast_trac(\%cfg, $key);
                        $cfg{'time0'} = $t0;
                    } else {
                        _yeast_trac(\%cfg, $key);
                    }
                }
            }
        }
        _yline(" %cfg }");
        return;
    }
    # else  user friendly information
    my $sni_name = $cfg{'sni_name'} || "<<undef>>"; # default is Perl's undef
    my $port     = $cfg{'port'} || "<<undef>>";     # default is Perl's undef
    _yline(" user-friendly cfg {");
    _yeast("      ca_depth= $cfg{'ca_depth'}") if defined $cfg{'ca_depth'};
    _yeast("       ca_path= $cfg{'ca_path'}")  if defined $cfg{'ca_path'};
    _yeast("       ca_file= $cfg{'ca_file'}")  if defined $cfg{'ca_file'};
    _yeast("       use_SNI= $Net::SSLinfo::use_SNI, force-sni=$cfg{'use'}->{'forcesni'}, sni_name=$sni_name");
    _yeast("  default port= $port (last specified)");
    _yeast_targets($cfg{'trace'}, $cfg{'prefix_verbose'}, @{$cfg{'targets'}});
    _yeast("     use->http= $cfg{'use'}->{'http'}");
    _yeast("    use->https= $cfg{'use'}->{'https'}");
    _yeast(" out->hostname= $cfg{'out'}->{'hostname'}");
    _yeast("   out->header= $cfg{'out'}->{'header'}");
    foreach my $key (qw(format legacy starttls starttls_delay slow_server_delay cipherrange)) {
        _yTRAC($key, $cfg{$key});
    }
    _yeast("        cipher= " . ___ARR(@{$cfg{'cipher'}}));
    foreach my $key (qw(starttls_phase starttls_error)) {
        _yeast(      "$key= " . ___ARR(@{$cfg{$key}}));
    }
    _yeast("   SSL version= " . ___ARR(@{$cfg{'version'}}));
    printf("%s",__TRAC("SSL versions", "[ "));  # no \n !
    printf("%s=%s ", $_, $cfg{$_}) foreach (@{$cfg{'versions'}});
    printf("]\n");
    _yeast(" special SSLv2= null-sslv2=$cfg{'use'}->{'nullssl2'}, ssl-lazy=$cfg{'use'}->{'ssl_lazy'}");
    _yeast(" ignore output= " . ___ARR(@{$cfg{'ignore-out'}}));
    _yeast(" user commands= " . ___ARR(@{$cfg{'commands_usr'}}));
    _yeast("given commands= " . ___ARR(@{$cfg{'done'}->{'arg_cmds'}}));
    _yeast("      commands= " . ___ARR(@{$cfg{'do'}}));
    _yline(" user-friendly cfg }");
    _yeast("(more information with: --trace=2  or  --trace=3 )") if (1 > $cfg{'trace'});
    # $cfg{'ciphers'} may not yet set, print with _yeast_ciphers_list()
    return;
} # _yeast_init

sub _yeast_exit {
    #? print collected just be program exit
    if (0 < $cfg{'trace'}) {
        _yTRAC("cfg'exitcode'", $cfg{'use'}->{'exitcode'});
        _yTRAC("exit status",   (($cfg{'use'}->{'exitcode'}==0) ? 0 : $checks{'cnt_checks_no'}->{val}));
    }
    _y_CMD("internal administration ..");
    _y_CMD('@cfg{done} {');
    foreach my $key (sort keys %{$cfg{'done'}}) {
        # cannot use  _yeast_trac(\%{$cfg{'done'}}, $key);
        # because we want the CMD prefix here
        my $label = sprintf("  %-10s=", $key);
        if ('arg_cmds' eq $key) {
            _y_CMD("$label\t[" . join(" ", @{$cfg{'done'}->{$key}}) . "]");
        } else {
            _y_CMD("$label\t" . $cfg{'done'}->{$key});
        }
    }
    _y_CMD('@cfg{done} }');
    return;
} # _yeast_exit

sub _yeast_args {
    #? print information about command line arguments
    return if (not _is_cfg_out('traceARG'));
    # using _y_ARG() may be a performance penulty, but it's trace anyway ...
    _yline(" ARGV {");
    _y_ARG("# summary of all arguments and options from command-line");
    _y_ARG("       called program ARG0= " . $cfg{'ARG0'});
    _y_ARG("     passed arguments ARGV= " . ___ARR(@{$cfg{'ARGV'}}));
    _y_ARG("                   RC-FILE= " . $cfg{'RC-FILE'});
    _y_ARG("      from RC-FILE RC-ARGV= ($#{$cfg{'RC-ARGV'}} more args ...)");
    if (0 >= $cfg{'verbose'}) {
    _y_ARG("      !!Hint:  use --v to get the list of all RC-ARGV");
    _y_ARG("      !!Hint:  use --v --v to see the processed RC-ARGV");
                  # NOTE: ($cfg{'trace'} does not work here
    }
    _y_ARG("      from RC-FILE RC-ARGV= " . ___ARR(@{$cfg{'RC-ARGV'}})) if (0 < $cfg{'verbose'});
    my $txt = "[ ";
    foreach my $target (@{$cfg{'targets'}}) {
        next if (0 == @{$target}[0]);   # first entry conatins default settings
        $txt .= sprintf("%s:%s ", @{$target}[2..3]); # the perlish way
    }
    $txt .= "]";
    _y_ARG("         collected targets= " . $txt);
    if (1 < $cfg{'verbose'}) {
    _y_ARG(" #--v { processed files, arguments and options");
    _y_ARG("    read files and modules= ". ___ARR(@{$dbx{file}}));
    _y_ARG("processed  exec  arguments= ". ___ARR(@{$dbx{exe}}));
    _y_ARG("processed normal arguments= ". ___ARR(@{$dbx{argv}}));
    _y_ARG("processed config arguments= ". ___ARR(map{"`".$_."'"} @{$dbx{cfg}}));
    _y_ARG(" #--v }");
    }
    _yline(" ARGV }");
    return;
} # _yeast_args

sub _yeast_rcfile {
    #? print content read from RC-FILE ## NOT YET USED ##
    return if (0 >= ($cfg{'trace'} + $cfg{'verbose'}));
    _yline(" RC-FILE {");
    _yline(" RC-FILE }");
    return;
} # _yeast_rcfile {

sub _v_print    { local $\ = "\n"; print $cfg{'prefix_verbose'} . join(" ", @_) if (0 < $cfg{'verbose'}); return; }
sub _v2print    { local $\ = "\n"; print $cfg{'prefix_verbose'} . join(" ", @_) if (1 < $cfg{'verbose'}); return; }
sub _v3print    { local $\ = "\n"; print $cfg{'prefix_verbose'} . join(" ", @_) if (2 < $cfg{'verbose'}); return; }
sub _v4print    { local $\ = "";   print $cfg{'prefix_verbose'} . join(" ", @_) if (3 < $cfg{'verbose'}); return; }
sub _trace      { print $cfg{'prefix_trace'} . $_[0]         if (0 < $cfg{'trace'}); return; }
sub _trace0     { print $cfg{'prefix_trace'}                 if (0 < $cfg{'trace'}); return; }
sub _trace1     { print $cfg{'prefix_trace'} . join(" ", @_) if (1 < $cfg{'trace'}); return; }
sub _trace2     { print $cfg{'prefix_trace'} . join(" ", @_) if (2 < $cfg{'trace'}); return; }
sub _trace3     { print $cfg{'prefix_trace'} . join(" ", @_) if (3 < $cfg{'trace'}); return; }
sub _trace_     { local $\ = "";  print  " " . join(" ", @_) if (0 < $cfg{'trace'}); return; }
# if --trace-arg given
sub _trace_cmd  { printf("%s %s->\n", $cfg{'prefix_trace'}, join(" ",@_)) if (_is_cfg_out('traceCMD')); return; }

sub _vprintme   {
    #? write own version, command-line arguments and date and time
    my ($s,$m,$h,$mday,$mon,$year,$wday,$yday,$isdst) = localtime();
    return if (0 >= ($cfg{'verbose'} + $cfg{'trace'}));
    _yeast("$0 " . _VERSION());
    _yeast("$0 " . join(" ", @{$cfg{'ARGV'}}));
    if (defined $ENV{'OSAFT_MAKE'}) {   # SEE Make:OSAFT_MAKE (in Makefile.pod)
        _yeast("$0 dd.mm.yyyy HH:MM:SS (OSAFT_MAKE exists)");
    } else {
        _yeast("$0 " . sprintf("%02s.%02s.%s %02s:%02s:%02s", $mday, ($mon +1), ($year +1900), $h, $m, $s));
    }
    return;
} # _vprintme

#_____________________________________________________________________________
#_________________________________________________________ internal methods __|

# subs for formatted table
sub __data      { return (_is_member(shift, \@{$cfg{'commands'}}) > 0)   ? "*" : "?"; }
sub __data_title{ return sprintf("=%19s %s %s %s %s %s %s %s", @_); }
sub __data_head { return __data_title("key", "command", " %data  ", "%checks", "cmd-ch.", "short ", "intern ", " score"); }
sub __data_line { return sprintf("=%19s+%s+%s+%s+%s+%s+%s+%s", "-"x19, "-"x7, "-"x7, "-"x7, "-"x7, "-"x7, "-"x7, "-"x7); }
sub __data_data { return sprintf("%20s\t%s\t%s\t%s\t%s\t%s\t%s\t%s", @_); }

# subs for fomated maps
sub __prot_option       {
    my $data;
    foreach my $key (sort keys %{$cfg{'openssl_option_map'}})  {
        $data .= __trac(\%{$cfg{'openssl_option_map'}}, $key) . "\n";
    }
    chomp  $data;   # remove last \n
    return $data;
} # __prot_option

sub __prot_version      {
    my $data;
    foreach my $key (sort keys %{$cfg{'openssl_version_map'}}) {
        $data .= __yeast(sprintf("%14s= ", $key) . sprintf("0x%04X 0x%08x",
                                 ${$cfg{'openssl_version_map'}}{$key},
                                 ${$cfg{'openssl_version_map'}}{$key})
                        ) . "\n";
    }
    chomp  $data;   # remove last \n
    return $data;
} # __prot_version

#_____________________________________________________________________________
#____________________________________________________ internal test methods __|

sub _yeast_test_help    {
    local $\ = "\n";
    printf("#%s:\n", (caller(0))[3]);
    print "
=== commands for internal testing ===
=
= Print list of commands for internal testing/information.
=
=   command/option  prints this information
=  ----------------+----------------------------------------------
=   --tests         this text
=   --test-init     data structure  %cfg after initialisation
=   --test-data     overview of all available commands and checks
=   --test-maps     internal data strucures '%cfg{openssl}', '%cfg{ssleay}'
=   --test-prot     internal data according protocols
=   --test-regex    results for applying various texts to regex
=   --test-memory   overview of variables' memory usage
=   --test-methods  available methods for openssl in Net::SSLeay
=   --test-sclient  available options for 'openssl s_client' from Net::SSLeay
=   --test-sslmap   constants for SSL protocols from Net::SSLeay
=   --test-ssleay   information about Net::SSLeay capabilities
=   --test-ciphers-*    various ciphers listings; available with o-saft.pl only
=  ----------------+----------------------------------------------
=";
    # o-saft.tcl --test-o-saft  # just for completeness, not used here
    # NOTE: description above should be similar to those in
    #       OSaft/Doc/help.txt
    return $data;
} # _yeast_test_help

sub _yeast_test_data    {
    local $\ = "\n";
    printf("#%s:\n", (caller(0))[3]);
    print "
=== internal data structure: overview of commands, %data and %checks ===
=
= Print a simple overview of all available commands for  +info  and  +check .
= The purpose is to show if a proper key is defined in  %data and %checks  for
= each command from  %cfg{'commands'}  and vice versa.
=
=   column      description
=  ------------+--------------------------------------------------
=   key         key in %cfg{'commands'}
=   command     key (see above) available as command: +key
=   data        command returns %data  (part of +info)
=   checks      command returns %check (part of +check)
=   cmd-ch.     command listed in ...
=   short       desciption of command available as short text
=   intern      internal command only, not avaialable as +key
=  ------------+--------------------------------------------------
=";

    my $old;
    my @yeast = ();     # list of potential internal, private commands
    my $cmd = " ";
    print __data_head();
    print __data_line();
    $old = "";
    foreach my $key
            (sort {uc($a) cmp uc($b)}
                @{$cfg{'commands'}}, keys %data, keys %shorttexts, keys %checks
            )
            # we use sort case-insensitively, hence the BLOCK for comparsion
            # it also avoids the warning: sort (...) interpreted as function
    {
        next if ($key eq $old); # unique
        $old = $key;
        if ((not defined $checks{$key}) and (not defined $data{$key})) {
            push(@yeast, $key); # probably internal command
            next;
        }
        $cmd = "+" if (0 < _is_member($key, \@{$cfg{'commands'}})); # command available as is
        $cmd = "-" if ($key =~ /$cfg{'regex'}->{'SSLprot'}/i);      # all SSL/TLS commands are for checks only
        print __data_data(  #__/--- check value -------\    true : false  # column
            $key, $cmd,
            (defined $data{$key})                ? __data( $key) : " ",   # data
            (defined $checks{$key})                     ?   "*"  : " ",   # checks
            ((_is_member($key, \@{$dbx{'cmd-check'}}) > 0)
            || ($key =~ /$cfg{'regex'}->{'SSLprot'}/i)) ?   "*"  : "!",   # cmd-ch.
            (defined $shorttexts{$key})                 ?   "*"  : " ",   # short
            (_is_cfg_intern($key))                      ?   "I"  : " ",   # intern
            (defined $checks{$key}->{score}) ? $checks{$key}->{score} : ".",
            );
    }
# FIXME: @{$dbx{'cmd-check'}} is incomplete when o-saft-dbx.pm is require'd in
#        main; some checks above then fail (mainly those matching
#        $cfg{'regex'}->{'SSLprot'}, hence the dirty additional
#        || ($key =~ /$cfg{'regex'}->{'SSLprot'}/)
#               
    print __data_line();
    print __data_head();
    print "=
=   +  command (key) present
=   I  command is an internal command or alias (ok in column 'intern')
=   -  command (key) used internal for checks only (ok in column 'command')
=   *  key present
=      key not present
=   ?  key in %data present but missing in \$cfg{commands}
=   !  key in %cfg{cmd-check} present but missing in redefined %cfg{cmd-check}
=   .  no score defined in %checks{key}
=
= A shorttext should be available for each command and all data keys, except:
=      cn_nosni, ext_*, valid_*
=
= Internal or summary commands:
=      " . join(" ", @yeast) . "\n";
    return;
} # _yeast_test_data

sub _yeast_test_init    {
    local $\ = "\n";
    local $Data::Dumper::Deparse=1; # parse code, see man Data::Dumper
    my $line = "#--------------------+-------------------------------------------";
    printf("#%s:\n", (caller(0))[3]);
    print "
=== internal data structure: initialisation of %cfg, %data and %checks ===
=
= Print initialised data structure  %data and %checks  after all  command-line
= options have been applied.
=
";
#ah not ok: use Sub::Identify ':all';
    _yline(" %cfg {");  # only data which influences initialisations
    print __yeast("#                key | value");
    print __yeast($line);
    print __INIT("ARGV", ___ARR(@{$cfg{'ARGV'}}));
    _yline(" %cfg{use} {");
    foreach my $key (sort keys %{$cfg{'use'}}) {
        print __INIT($key, $cfg{'use'}{$key});
    }
    _yline(" %cfg{use} }");
    print __yeast($line);
    _yline(" %cfg }");
    _yline(" %data {");
    print __yeast("#                key | value (function code)");
    print __yeast($line);
    foreach my $key (sort keys %data) { # ugly and slow code
        # use Dumper() to get code, returns something like:
        #     $VAR1 = sub {
        #                 package OSaft::Data;
        #                 use warnings;
        #                 use strict;
        #                 Net::SSLinfo::version($_[0], $_[1]);
        #             };
        # the line with "package" occours only if the data is in another namespace
        # we only want the code line, hence remove the others
        my $code = Dumper($data{$key}->{val});
        $code =~ s/^\$VAR.*//;
        $code =~ s/(?:};)?\s*$//g;
        $code =~ s/package\s*.*;//g;
        $code =~ s/use\s*(?:strict|warnings);//g;
        $code =~ s/\n//g;
        $code =~ s/^\s*//g;
        print __INIT($key, $code);
    }
    print __yeast($line);
    _yline(" %data }");
    _yline(" %checks {");
    print __yeast("#                key | value");
    print __yeast($line);
    foreach my $key (sort keys %checks) {
        print __INIT($key, $checks{$key}->{val});
    }
    print __yeast($line);
    _yline(" %checks }");
    return;
} # _yeast_test_init

sub _yeast_test_maps    {
    printf("#%s:\n", (caller(0))[3]);
    print "
=== internal data structure %cfg{openssl}, %cfg{ssleay} ===
=
= Print internal mappings for openssl functionality (mainly options).
=
";
    local $\ = "\n";
    my $data = Net::SSLinfo::test_sslmap();
       $data =~ s/^#/#$cfg{'me'}/smg;
    print $data;
    _yline(" %cfg{openssl_option_map} {");
    print __prot_option();
    _yline(" %cfg{openssl_version_map} {");
    print __prot_version();
    return;
} # _yeast_test_maps

sub _yeast_test_prot    {
    printf("#%s:\n", (caller(0))[3]);
    print "
=== internal data structure according protocols ===
=
= Print information about SSL/TLS protocols in various internal variables.
=
";
    local $\ = "\n";
    my $ssl = $cfg{'regex'}->{'SSLprot'};
    _ynull("\n");
    _yline(" %cfg {");
    foreach my $key (sort keys %cfg) {
        # targets= is array of arrays, prints ARRAY ref here only
        _yeast_trac(\%cfg, $key) if ($key =~ m/$ssl/);
    }
    _yline(" }");
    _yline(" %cfg{openssl_option_map} {");
    print __prot_option();
    _yline(" }");
    _yline(" %cfg{openssl_version_map} {");
    print __prot_version();
    _yline(" }");
    # %check_conn and %check_dest are temporary and should be inside %checks
    _yline(" %checks {");
    foreach my $key (sort keys %checks) {
        # $checks{$key}->{val} undefined at beginning
        _yeast(sprintf("%14s= ", $key) . $checks{$key}->{txt}) if ($key =~ m/$ssl/);
    }
    _yline(" }");
    _yline(" %shorttexts {");
    foreach my $key (sort keys %shorttexts) {
        _yeast(sprintf("%14s= ",$key) . $shorttexts{$key}) if ($key =~ m/$ssl/);
    }
    _yline(" }");
    if (0 < ($cfg{'trace'} + $cfg{'verbose'})){
    }
    return;
} # _yeast_test_prot

sub _yeast_test_methods {
    printf("#%s:\n", (caller(0))[3]);
    print "
=== internal list of methods to call openssl ===
=
= Print available methods in Net::SSLeay.
=
";
    my $list = Net::SSLinfo::test_methods();
       $list =~ s/ /\n# /g;
    print "# $list";
    return;
} # _yeast_test_methods

sub _yeast_test_sclient {
    printf("#%s:\n", (caller(0))[3]);
    print "
=== internal list of openssl s_client options ===
=
= Print available options for 'openssl s_client' from Net::SSLeay.
=
";
    my $list = Net::SSLinfo::test_sclient();
       $list =~ s/ /\n# /g;
    print "# $list";
    return;
} # _yeast_test_sclient

sub _yeast_test_sslmap  {
    printf("#%s:\n", (caller(0))[3]);
    print "
=== internal list of constants for SSL protocols ===
=
= Print available constants for SSL protocols in Net::SSLeay.
=
";
    print Net::SSLinfo::test_sslmap();
    return;
} # _yeast_test_sslmap

sub _yeast_test_ssleay  {
    printf("#%s:\n", (caller(0))[3]);
    print "
=== internal data of from Net::SSLeay ===
=
= Print information about Net::SSLeay capabilities.
=
";
    print Net::SSLinfo::test_ssleay();
    return;
} # _yeast_test_ssleay

sub _yeast_test_memory  {
    #? print overview of memory usage of variables
    # This is not part of the functionality of O-Saft itself, but more like
    # a quality or performance check.
    # I.g. it should be implemented in makefiles or alike, but is done here
    # in the source because the variables are avaiable in the source only.
    printf("#%s:\n", (caller(0))[3]);
    require Devel::Size;    # require instead of use to avoid dependencies (i.e. in checkAllCiphers.pl)
    my %types = (   # TODO: not yet used
        'ARRAY'   => '@',
        'CODE'    => '{',
        'FORMAT'  => '#',
        'GLOB'    => '*',
        'HASH'    => '%',
        'IO'      => '&',
        'LVALUE'  => '=',
        'REF'     => '\\',
        'REGEXP'  => '/',
        'SCALAR'  => '$',
        'VSTRING' => '"',
    );
    print "
=== memory usage of internal variables ===
=
= Use  --v  to get more details.
=
";
    if (0 < ($cfg{'trace'} + $cfg{'verbose'})){
        foreach my $k (keys %cfg) {
	    printf("%6s\t%s\n", Devel::Size::total_size(\$cfg{$k}),    "%cfg{$k}");
        }
        foreach my $k (keys %checks) {
	    printf("%6s\t%s\n", Devel::Size::total_size(\$checks{$k}), "%checks{$k}");
        }
        #foreach my $k (keys %ciphers) {    # useless, as each entry is about 2k
	#    printf("%6s\t%s\n", Devel::Size::total_size(\$ciphers{$k}), "%ciphers{$k}");
        #}
        foreach my $k (keys %dbx) {
	    printf("%6s\t%s\n", Devel::Size::total_size(\$dbx{$k}),    "%dbx{$k}");
        }
        #foreach my $k (keys %data) {       # most entries report 42k, which is wrong
	#    printf("%6s\t%s\n", Devel::Size::total_size(\$data{$k}), "%data{$k}");
        #}
    }
    my $bytes = 0;
    my $line  = "=------+----------------";
    # get all global variables and grep for our ones
    # ugly code, but generic
    print "= Bytes variable\n$line";
    foreach my $v (sort keys %main::) {
        #print Dumper $v; # liefert den gesamten Hash
        next if ("*{$main::{$v}}" !~ m/\*main::/);
        next if ($main::{$v} =~ m/::$/);           # avoid "Segmentation fault"
        next if (not grep {/^(cfg|check|cipher|cmd|data|dbx|info|osaft|short|text)/} $v) ;
        next if (    grep {/^check(cipher|http)/} $v) ; # avoid "Segmentation fault"
        # TODO: my $typ = ref($main::{$v}); # not yet working
        #dbx print "K $v $main::{$v} => $t";
        my $size = Devel::Size::total_size(\$main::{$v});
        $bytes += $size;
        printf("%7s\t%s\n", $size, $v);#if (exists $main::{$v});
    }
    print "$line";
    printf("%7s\t(%2.2f MB) total\n", $bytes, $bytes/1024/1024);
    # the traditional way ...
    #print "%cfg    : ", Devel::Size::total_size(\%cfg);
    #print "%data   : ", Devel::Size::total_size(\%data);
    #print "%checks : ", Devel::Size::total_size(\%checks);
    #print "%ciphers: ", Devel::Size::total_size(\%ciphers);
    #print "\@results: ", Devel::Size::total_size(\@cipher_results);
    #print "%text   : ", Devel::Size::total_size(\%text);
    #print "%_SSLinfo   : ", Devel::Size::total_size(\%Net::SSLinfo::_SSLinfo);
    return;
} # _yeast_test_memory

sub _yeast_test {
    #? dispatcher for internal tests, initiated with option --test-*
    my $arg = shift;    # normalised option, like --testinit, --testcipherlist
    _yeast($arg);
    OSaft::Ciphers::show($arg)  if ($arg =~ /^--test[._-]?cipher/);
    _yeast_test_help()          if ('--test'          eq $arg);
    _yeast_test_help()          if ('--tests'         eq $arg);
    _yeast_test_sclient()       if ('--testsclient'   eq $arg); # Net::SSLinfo
    _yeast_test_ssleay()        if ('--testssleay'    eq $arg); # Net::SSLinfo
    _yeast_test_sslmap()        if ('--testsslmap'    eq $arg); # Net::SSLinfo
    _yeast_test_methods()       if ('--testmethods'   eq $arg); # Net::SSLinfo
    _yeast_test_memory()        if ('--testmemory'    eq $arg);
    $arg =~ s/^[+-]-?tests?[._-]?//; # remove --test
    osaft::test_cipher_regex()  if ('regex'           eq $arg);
    _yeast_test_data()          if ('data'            eq $arg);
    _yeast_test_init()          if ('init'            eq $arg);
    _yeast_test_maps()          if ('maps'            eq $arg);
    _yeast_test_prot()          if ('prot'            eq $arg);
    $arg =~ s/^ciphers?[._-]?//;    # allow --test-cipher* and --test-cipher-*
    OSaft::Ciphers::show($arg)  if ($arg =~ /^cipher/); # allow --test-cipher* and cipher-*
    if ('list' eq $arg) {
        # _yeast_ciphers_list() relies on some special $cfg{} settings
        # enforce printing cipher information by adding  +cipher, this
        # should not harm other functionality, as _yeast_test() is for
        # debugging only and will exit then
        $cfg{'verbose'} = 1;
        push(@{$cfg{'do'}}, 'cipher'); # enforce printing cipher informations
        push(@{$cfg{'version'}}, 'TLSv1') if (0 > $#{$cfg{'version'}});
        _yeast_ciphers_list();
    }
    return;
} # _yeast_test

#_____________________________________________________________________________
#_____________________________________________________________________ main __|

sub _main_dbx       {
    my $arg = shift || "--help";    # without argument print own help
    ## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
    #   see t/.perlcriticrc for detailed description of "no critic"
    #  SEE Perl:binmode()
    binmode(STDOUT, ":unix:utf8");
    binmode(STDERR, ":unix:utf8");
    print_pod($0, __FILE__, $SID_dbx)   if ($arg =~ m/--?h(elp)?$/x);   # print own help
    # else
    # ----------------------------- commands
    if ($arg eq 'version')              { print "$SID_dbx\n"; exit 0; }
    if ($arg =~ m/^[-+]?V(ERSION)?$/)   { print "$VERSION\n"; exit 0; }
    if ($arg =~ m/--tests?$/) { _yeast_test_help(); exit 0; }
    if ($arg =~ m/--(yeast|test)[_.-]?(.*)/) {
        $arg = "--test-$2";
        printf("#$0: direct testing not yet possible, please try:\n   o-saft.pl $arg\n");
    }
    exit 0;
} # _main_dbx

sub dbx_done        {}; # dummy to check successful include

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

=pod

=encoding utf8

=head1 _____________________________________________________________________________

=head1 NAME

o-saft-dbx.pm - module for tracing o-saft.pl


=head1 SYNOPSIS

=over 2

=item require "o-saft-dbx.pm";

=item o-saft-dbx.pm <L<OPTIONS|OPTIONS>>

=back


=head1 OPTIONS

=over 2

=item --help

=item --tests

List available commands or options for internal testing.

=item --test-ciphers-list

=item --test-ciphers-show

=item --test-ciphers-sort

=item --test-ciphers-overview

=item --test-regex

=item --test-data

=item --test-init

=item --test-maps

=item --test-prot

See  I<--tests>  for description of these options.

=back


=head1 DESCRIPTION

Defines all functions needed for trace and debug output in  L<o-saft.pl|o-saft.pl>.


=head1 METHODS

=head2 Functions defined herein

=over 4

=item _yeast_ciphers_list( )

=item _yeast_trac( )

=item _yeast_init( )

=item _yeast_exit( )

=item _yeast_args( )

=item _yeast( )

=item _y_ARG( ), _y_CMD( ), _yline( )

=item _vprintme( )

=item _v_print( ), _v2print( ), _v3print( ), _v4print( )

=item _trace( ), _trace1( ), _trace2( ), _trace_cmd( )

=back

=head2 Functions for internal testing; initiated with option  C<--test-*>

=over 4

=item _yeast_test_help( )

=item _yeast_test_data( )

=item _yeast_test_init( )

=item _yeast_test_maps( )

=item _yeast_test_prot( )

=item _yeast_test_methods( )

=item _yeast_test_sclient( )

=item _yeast_test_sslmap( )

=item _yeast_test_ssleay( )

=item _yeast_test( )

=back

=head2 Variables which may be used herein

They must be defined as `our' in L<o-saft.pl|o-saft.pl>:

=over 4


=item $SID_main

=item %data

=item %cfg, i.e. trace, traceARG, traceCMD, traceKEY, time_absolut, verbose

=item %checks

=item %dbx

=item $time0

=back

Functions being used in L<o-saft.pl|o-saft.pl> should be defined as empty stub there.
For example:

#   sub _yeast_init() {}


=head1 SPECIALS

If you want to do special debugging, you can define proper functions here.
They don't need to be defined in L<o-saft.pl|o-saft.pl> if they are used only here.
In that case simply call the function in C<_yeast_init> or C<_yeast_exit>
they are called at beginning and end of L<o-saft.pl|o-saft.pl>.
It's just important that  L<o-saft.pl|o-saft.pl>  was called with either the I<--v>
or any I<--trace*>  option, which then loads this file automatically.


=head1 VERSION

2.24 2022/11/05

=head1 AUTHOR

13-nov-13 Achim Hoffmann

=cut

## PACKAGE }
} # o-saft-dbx.pm

{ # OSaft/error_handler.pm
#!/usr/bin/perl -w
# Filename: error_handler.pm
#!#############################################################################
#!#                    Copyright (c) 2022, Torsten Gigler
#!#   This script is part of the OWASP-Project 'o-saft'.
#!#   It's a simple library 'OSaft::error_handler' stores and optionally
#!#   prints all classified errors for other parts of o-saft.
#!#----------------------------------------------------------------------------
#!#   THIS Software is in ALPHA state, please give us feed back via
#!#   https://lists.owasp.org/mailman/listinfo/o-saft
#!#----------------------------------------------------------------------------
#!#   This software is provided "as is", without warranty of any kind, express or
#!#   implied,  including  but not limited to  the warranties of merchantability,
#!#   fitness for a particular purpose.  In no event shall the  copyright holders
#!#   or authors be liable for any claim, damages or other liability.
#!#   This software is distributed in the hope that it will be useful.
#!#
#!#   This  software is licensed under GPLv2.
#!#
#!#   GPL - The GNU General Public License, version 2
#!#      as specified in:  http://www.gnu.org/licenses/gpl-2.0
#!#      or a copy of it https://github.com/OWASP/O-Saft/blob/master/LICENSE.md
#!#   Permits anyone the right to use and modify the software without limitations
#!#   as long as proper  credits are given  and the original  and modified source
#!#   code are included. Requires  that the final product, software derivate from
#!#   the original  source or any  software  utilizing a GPL  component, such  as
#!#   this, is also licensed under the same GPL license.
#!#############################################################################
#!# WARNING:
#!#   This is no "academically" certified code,  but written to be understood and
#!#   modified by humans (you:) easily.  Please see the documentation  in section
#!#   "Program Code" at the end of this file if you want to improve the program.
#!#############################################################################

#?#############################################################################
#? package 'error_handler' stores and optionally prints all classified errors.
#? The latest error can be called back, eg. if the last retry missed.
#? This package uses static class methods and static data within the handler
#? to store and read the last error.
#? To use it call 'use OSaft::error_handler qw(:subs :sslhello_constants)'
#? exported subs:
#?     error_handler->new({<hash-key>=><value>}); set new values for a new error
#?         with <hash-key>=
#?             type:    no error (OERR_NO_ERROR(=1)) or type of the error(<0)
#?                      (see sslhello_constants, constant OERR_...), needs to be
#?                      a more severe error than the stored error type (=smaller value)
#?             module:  text: module or package of the caller where the error occured
#?             sub      text: sub of the caller where the error occored
#?             id       text: id inside the sub to identify the exact location where
#?                            the error occured
#?             message: text: error message providede by the caller
#?             print:   1: prints a standardized warning to stdout; 0: no output (default)
#?             warn:    1: prints a standardized warning to stderr; 0: no output (default)
#?             trace:   1: prints a standardized trace to stdouti (default); 0: no output
#?     error_handler->reset_err(<hash_ref (optional)>):
#?                                                reset the last error, optionally set a new error using hash_ref
#?     error_handler->is_err():                   returns '1' if an error has occured
#?     error_handler->get_err_type():             get (internal) number of the last error type
#?     error_handler->get_err_type_name():        get name of the last error type
#?     error_handler->get_err_val():              get a value of the error hash
#?     error_handler->get_err_str():              get and print an error message
#?
#? mainly used for testing and debugging:
#?     error_handler->get_err_hash(<prefix>, <hash_ref (optional)>):
#?                                                get the error hash as string, <prefix> is an optional prefix after a new
#?                                                line (e.g. some spaces for the indent),
#?                                                if the optional 'hash_ref' is valid this hash is used
#?     error_handler->get_all_err_types():        get all possible defined error types and their internal representation
#?                                                as a string
#? ----------------------------------------------------------------------------
#? constants:
#? sslhello_contants:                             CONSTANTS used for SSLHello: import them using 
#?                                                'use OSaft::error_handler qw(:subs :sslhello_constants)'
#?#############################################################################

package OSaft::error_handler;


use warnings;
use Carp;

use Exporter qw(import);

use constant {  ## no critic qw(ValuesAndExpressions::ProhibitConstantPragma)
    # the version number of this package
    OERR_VERSION                                => '19.11.19',

    # error types (general)
    OERR_NO_ERROR                               =>     1,   # no error
    OERR_UNKNOWN_TYPE                           => -9999,   # unknown error type, needs to be the most fatal error (=smallest number)

    # error texts
    OERR_UNDEFINED_TXT                          => "<<undefined>>",
    OERR_UNKNOWN_TXT                            => "<<unknown>>",

    #special error types for SSLhello, the smaller value is more severe (they may be changed here if needed)
    OERR_SSLHELLO_ABORT_PROGRAM                 => -9000,   # error: abort running this program -> exit
    OERR_SSLHELLO_ABORT_HOST                    =>   -99,   # error: abort testing this host
    OERR_SSLHELLO_RETRY_HOST                    =>   -94,   # error: retry testing this host
    OERR_SSLHELLO_ABORT_PROTOCOL                =>   -89,   # error: abort testing this protocol for this host
    OERR_SSLHELLO_RETRY_PROTOCOL                =>   -84,   # error: retry testing this protocol for this host
    OERR_SSLHELLO_ABORT_CIPHERS                 =>   -79,   # error: abort testing this cipher(s) for this protocol
    OERR_SSLHELLO_RETRY_CIPHERS                 =>   -74,   # error: retry testing this cipher(s) for this protocol
    OERR_SSLHELLO_ABORT_EXTENSIONS              =>   -69,   # error: abort testing this extensions for this ciphers
    OERR_SSLHELLO_RETRY_EXTENSIONS              =>   -64,   # error: retry testing this extensions for this ciphers
    OERR_SSLHELLO_TEST_EXTENSIONS               =>   -59,   # test all possible values for listed extensions
    OERR_SSLHELLO_RETRY_RECORD                  =>   -49,   # error: retry to send this record (e.g. DTLS)
    OERR_SSLHELLO_MERGE_RECORD_FRAGMENTS        =>   -39,   # try to merge fragmented record
    OERR_SSLHELLO_MERGE_DTLS                    =>   -29,   # try to merge fragmented DTLS packets
    OERR_SSLHELLO_ERROR_MESSAGE_IGNORED         =>    -1,   # error message ignored
};
our $VERSION = OERR_VERSION;

our @EXPORT_OK =  ( qw(
    new is_err get_err_str reset_err get_err_val get_err_type get_err_type _name get_err_hash get_all_err_types version
    OERR_VERSION
    OERR_UNKNOWN_TYPE
    OERR_NO_ERROR
    OERR_UNDEFINED_TXT
    OERR_UNKNOWN_TXT
    OERR_SSLHELLO_ABORT_PROGRAM
    OERR_SSLHELLO_ABORT_HOST
    OERR_SSLHELLO_RETRY_HOST
    OERR_SSLHELLO_ABORT_PROTOCOL
    OERR_SSLHELLO_RETRY_PROTOCOL
    OERR_SSLHELLO_ABORT_CIPHERS
    OERR_SSLHELLO_RETRY_CIPHERS
    OERR_SSLHELLO_ABORT_EXTENSIONS
    OERR_SSLHELLO_RETRY_EXTENSIONS
    OERR_SSLHELLO_TEST_EXTENSIONS
    OERR_SSLHELLO_RETRY_RECORD
    OERR_SSLHELLO_MERGE_RECORD_FRAGMENTS
    OERR_SSLHELLO_MERGE_DTLS
    OERR_SSLHELLO_ERROR_MESSAGE_IGNORED
   )
);

our %EXPORT_TAGS =  (
    subs =>             [qw(new is_err get_err_str reset_err get_err_val 
                            get_err_type get_err_type_name get_err_hash get_all_err_types
    )],                 #all subs besides 'version'
    sslhello_contants => [qw(
        OERR_VERSION
        OERR_NO_ERROR
        OERR_UNKNOWN_TYPE
        OERR_UNDEFINED_TXT
        OERR_UNKNOWN_TXT
        OERR_SSLHELLO_ABORT_PROGRAM
        OERR_SSLHELLO_ABORT_HOST
        OERR_SSLHELLO_RETRY_HOST
        OERR_SSLHELLO_ABORT_PROTOCOL
        OERR_SSLHELLO_RETRY_PROTOCOL
        OERR_SSLHELLO_ABORT_CIPHERS
        OERR_SSLHELLO_RETRY_CIPHERS
        OERR_SSLHELLO_ABORT_EXTENSIONS
        OERR_SSLHELLO_RETRY_EXTENSIONS
        OERR_SSLHELLO_TEST_EXTENSIONS
        OERR_SSLHELLO_RETRY_RECORD
        OERR_SSLHELLO_MERGE_RECORD_FRAGMENTS
        OERR_SSLHELLO_MERGE_DTLS
        OERR_SSLHELLO_ERROR_MESSAGE_IGNORED
    )],
);

# reverse hash to show the names of the used constants in the modules that use this package
my $ERROR_TYPE_RHASH_REF = { 
   (OERR_NO_ERROR)                              => 'OERR_NO_ERROR',
   (OERR_UNKNOWN_TYPE)                          => 'OERR_UNKNOWN_TYPE',
   (OERR_SSLHELLO_ABORT_PROGRAM)                => 'OERR_SSLHELLO_ABORT_PROGRAM',
   (OERR_SSLHELLO_ABORT_HOST)                   => 'OERR_SSLHELLO_ABORT_HOST',
   (OERR_SSLHELLO_RETRY_HOST)                   => 'OERR_SSLHELLO_RETRY_HOST',
   (OERR_SSLHELLO_ABORT_PROTOCOL)               => 'OERR_SSLHELLO_ABORT_PROTOCOL',
   (OERR_SSLHELLO_RETRY_PROTOCOL)               => 'OERR_SSLHELLO_RETRY_PROTOCOL',
   (OERR_SSLHELLO_ABORT_CIPHERS)                => 'OERR_SSLHELLO_ABORT_CIPHERS',
   (OERR_SSLHELLO_RETRY_CIPHERS)                => 'OERR_SSLHELLO_RETRY_CIPHERS',
   (OERR_SSLHELLO_ABORT_EXTENSIONS)             => 'OERR_SSLHELLO_ABORT_EXTENSIONS',
   (OERR_SSLHELLO_RETRY_EXTENSIONS)             => 'OERR_SSLHELLO_RETRY_EXTENSIONS',
   (OERR_SSLHELLO_TEST_EXTENSIONS)              => 'OERR_SSLHELLO_TEST_EXTENSIONS',
   (OERR_SSLHELLO_RETRY_RECORD)                 => 'OERR_SSLHELLO_RETRY_RECORD',
   (OERR_SSLHELLO_MERGE_RECORD_FRAGMENTS)       => 'OERR_SSLHELLO_MERGE_RECORD_FRAGMENTS',
   (OERR_SSLHELLO_MERGE_DTLS)                   => 'OERR_SSLHELLO_MERGE_DTLS',
   (OERR_SSLHELLO_ERROR_MESSAGE_IGNORED)        => 'OERR_SSLHELLO_ERROR_MESSAGE_IGNORED',
};

# static hash object to store the last error
my %err_hash = (
    type      => OERR_NO_ERROR,
    module    => "",
    sub       => OERR_UNDEFINED_TXT,
    id        => "",
    message   => OERR_UNDEFINED_TXT,
    print     => 0,
    warn      => 0,
    trace     => 1,
);


#?---------------------------------------------------------------------------------------
#? sub version ()
#? prints the official version number of error_handler (yy-mm-dd)
sub version {
    local $\ = ""; # no auto '\n' at the end of the line
    print "OSaft::error_handler (". OERR_VERSION .")\n";
    return;
} # version


#?---------------------------------------------------------------------------------------
#? sub _compile_err_str (;$)
#? internal sub that compiles a string ($err_str) based on the hash keys of $err_hash
#? $err_hash{type} should be defined and known. If it isn't the err_string
#? remarks this lack all other hash keys are suppressed if they do not exist
#? or are not defined no input variables needed
#? if the optional variable 'hash_ref' is used, the referenced hash is used instead of the $err_hash

sub _compile_err_str {  ## no critic qw(Subroutines::ProhibitExcessComplexity)
    my ($arg_ref) = @_;                         # $arg_ref is optional, internal function: no $class!

    unless (defined ($arg_ref) && ($arg_ref)) { # use \$err_hash if $arg_ref is not defined (default)
        $arg_ref = \%err_hash;
    }  elsif ($err_hash{trace}) {
        print "    \$arg_ref defined: $arg_ref\n";
    }

    my $err_str="";
    $err_str  = $arg_ref->{module}              if ( (exists ($arg_ref->{module}))  && (defined ($arg_ref->{module}))  );
    $err_str .= "::".$arg_ref->{sub}            if ( (exists ($arg_ref->{sub}))     && (defined ($arg_ref->{sub}))     );
    $err_str .= " (".$arg_ref->{id}."):"        if ( (exists ($arg_ref->{id}))      && (defined ($arg_ref->{id}))      );
    $err_str .= " ".$arg_ref->{message}         if ( (exists ($arg_ref->{message})) && (defined ($arg_ref->{message})) );
    if ( (exists ($arg_ref->{type})) && (defined ($arg_ref->{type})) ) {    # type key is used
        # check if is type is known (defind in the reverse hash):
        if ( (exists ($ERROR_TYPE_RHASH_REF->{$arg_ref->{type}})) && (defined ($ERROR_TYPE_RHASH_REF->{$arg_ref->{type}})) ) {
            if ( (exists ($arg_ref->{trace})) && (0<$arg_ref->{trace}) ) {  # show the type if trace is used
                $err_str .= " [Type=".$ERROR_TYPE_RHASH_REF->{$arg_ref->{type}};
                $err_str .= "(".$arg_ref->{type}.")"        if (2<$arg_ref->{trace});
                $err_str .= "]";
            } # end trace
        } else {                                                            # unknown type (not defined in ERROR_TYPE_RHASH_REF)
            $err_str .= " [Type= ".(OERR_UNKNOWN_TXT)." (".$arg_ref->{type}.")]";
        }
    } else {                                                                # undefined type
        $err_str .= " [Type=".(OERR_UNDEFINED_TXT)."]";
    }
    return ($err_str);
} # _compile_err_str


#?---------------------------------------------------------------------------------------
#? sub new($$):
#? set default values of an error hash and set values for received elements
#? parameters:
#?   $class:      added automatically when method is used
#?   $arg_ref:    the referenced hash ovwerwrites the $err_hash if its type is
#?                more fatal than the old type
sub new {
    my ($class, $arg_ref) = @_;                 # $class is not used
    my $tmp_err_str       = "";
    my $tmp_text          = "";

    # error handling inside error handling:
    # undefined/unknown error type in static err_hash
    unless ( (exists ($ERROR_TYPE_RHASH_REF->{$err_hash{type}})) && (defined ($ERROR_TYPE_RHASH_REF->{$err_hash{type}})) ) {
        $tmp_err_str = _compile_err_str();
        $tmp_text    = "OSaft::error_handler->new: internal error: unknown error type in";
        print qq($tmp_text "$tmp_err_str".) if ($err_hash{trace});
        carp (qq($tmp_text "$tmp_err_str".));
        $err_hash{type} = OERR_UNKNOWN_TYPE;    # define error type to 'unknown', which is the most fatal
    } else {
        # undefined $arg_ref: no new error
        unless (defined ($arg_ref)) {
            $arg_ref->{type}    = OERR_UNKNOWN_TYPE; # define error type to 'unknown', which is the most fatal
            $arg_ref->{module}  = 'OSaft::error_handler';
            $arg_ref->{sub}     = 'new';
            $arg_ref->{message} = "internal error: undefined \$arg_ref";
            $tmp_err_str        = _compile_err_str($arg_ref);
            print "$tmp_err_str" if ($err_hash{trace});
            carp ($tmp_err_str);
            return 0;
        }
        # undefined/unknown Error Type in new $arg_ref->{type}
        unless ( (exists ($ERROR_TYPE_RHASH_REF->{$arg_ref->{type}})) && (defined ($ERROR_TYPE_RHASH_REF->{$arg_ref->{type}})) ) {
            $tmp_err_str = _compile_err_str($arg_ref);
            print qq($tmp_text "$tmp_err_str".) if ($err_hash{trace});
            carp (qq($tmp_text "$tmp_err_str".));
            $arg_ref->{type} = OERR_UNKNOWN_TYPE; # define error type to 'unknown', which is the most fatal
        }
        if ($err_hash{type} < $arg_ref->{type}) { # new error is less important than the previous
             my $old_err_str =  _compile_err_str();
             $tmp_err_str    =  _compile_err_str($arg_ref);
             $tmp_text       = "OSaft::error_handler->new: new error type in";
             print qq($tmp_text "$tmp_err_str" is less important than the previous "$old_err_str".) if ($err_hash{trace});
             carp (qq($tmp_text "$tmp_err_str" is less important than the previous "$old_err_str".));
             return 0;
        }
    }
    %err_hash = (
        %err_hash,                              # previous keys and values
        %$arg_ref                               # keys and values overwrite the previous
    ) if ($arg_ref);

    my $err_str = _compile_err_str();
    print "$err_str\n" if ($err_hash{print});
    carp ($err_str)    if ($err_hash{warn});
    return 1;
} # new


#?---------------------------------------------------------------------------------------
#? reset the error_handler (no error)
#? opionally owerwrite it with the hash values referenced by arg_ref
sub reset_err {
    my ($class, $arg_ref) = @_;                 # $class is not used
    %err_hash = (                               # reset to default values and overwrite by optional hash arg_ref
        type      => OERR_NO_ERROR,
        module    => "",
        sub       => OERR_UNKNOWN_TXT,
        id        => "",
        message   => OERR_UNKNOWN_TXT,
        print     => 0,
        warn      => 0,
        trace     => 1,
    );
    %err_hash = (
        %err_hash,                              # previous keys and values
        %$arg_ref                               # keys and values overwrite the previous if $arg_ref is defined and not empty
    ) if ($arg_ref);

    if (2<$err_hash{trace}) {
        my $err_str = _compile_err_str();
        print "$err_str\n";
    }
    return 1;
} # reset_err


#?---------------------------------------------------------------------------------------
#? sub is_err():
#? returns true (1) if an error is stored in the hash of the error_handler
sub is_err {
    if ( (exists ($err_hash{type})) && (defined ($err_hash{type})) ) {
        return ($err_hash{type} != OERR_NO_ERROR);
    } else { # internal error: no type defined
       my $err_str = "OSaft::error_handler->is_err: internal error: undefined error type in \$error_hash: ";
       $err_str .= _compile_err_str();
       print "$err_str\n" if (2<$err_hash{trace});
       carp ($err_str);
       return (1);
   }
} # is_err


#?---------------------------------------------------------------------------------------
#? sub get_err_type():
#? get error type (number)
sub get_err_type {
    if ( (exists ($err_hash {type})) && (defined ($err_hash {type})) ) {
        return ($err_hash {type});
    } else {
        print "Error type is ".OERR_UNDEFINED_TXT if ($err_hash{trace});
        carp ("Error type is ".OERR_UNDEFINED_TXT);
    }
    return (undef);
} # get_err_type


#?---------------------------------------------------------------------------------------
#? sub get_err_type_name():
#? get error type ame
sub get_err_type_name {
    if ( (exists ($err_hash {type})) && (defined ($err_hash {type})) ) {
        return ($ERROR_TYPE_RHASH_REF->{$err_hash{type}}) if ( (exists ($ERROR_TYPE_RHASH_REF->{$err_hash{type}})) && (defined ($ERROR_TYPE_RHASH_REF->{$err_hash{type}})) );
        return (OERR_UNKNOWN_TXT);
    } else {
        print "Error type is ".OERR_UNDEFINED_TXT if ($err_hash{trace});
        carp ("Error type is ".OERR_UNDEFINED_TXT);
    }
    return (OERR_UNDEFINED_TXT);
} # get_err_type_name


#?---------------------------------------------------------------------------------------
#? sub get_err_val():
#? get a single value of an error hash element
#? parameters:
#?   $class:      added automatically when method is used
#?   $key_arg:    hash key where the value sould be fetched
sub get_err_val {
    my ($class, $key_arg) = @_;                 # $class is not used
    return ($err_hash {$key_arg}) if ( (exists ($err_hash {$key_arg})) && (defined ($err_hash {$key_arg})) );
    return;
} # get_err_val


#?---------------------------------------------------------------------------------------
#? sub get_err_str():
#? get the error string
#? no input variable needed
sub get_err_str {
    unless ( (exists ($ERROR_TYPE_RHASH_REF->{$err_hash{type}})) && (defined ($ERROR_TYPE_RHASH_REF->{$err_hash{type}})) ) { # undefined Error Type
        my $tmp_err_str = _compile_err_str();
        my$tmp_text     = "OSaft::error_handler->get_err_str: internal error: unknown error type in";
        print qq($tmp_text "$tmp_err_str".\n) if ($err_hash{trace});
        carp (qq($tmp_text "$tmp_err_str".\n));
        $err_hash{type} = OERR_UNKNOWN_TYPE;    # overwrite error type to unknown, which is the most fatal
    }
    return (_compile_err_str());
} #get_err_str


#?---------------------------------------------------------------------------------------
#? sub get_err_hash ($;$$):
#? get the error hash as string (mainly used for debugging)
#? parameters:
#?   $class:      added automatically when method is used
#?   $prefix:     optional prefix after new line (e.g. some spaces for the indent)
#?   $hash_ref:   optional ref to an error_hash (default: %err_hash)
#? returns the compiled output
sub get_err_hash {
    my ($class, $prefix, $hash_ref) = @_;           # $class is not used later, it is added automatically when calling the method
    my $err_hash_str                = "";
    $prefix =   ""         if (not defined($prefix));   # default is no indent
    $hash_ref = \%err_hash if (not defined($hash_ref)); # default is the error_hash
    print ">get_err_hash\n" if (2<$err_hash{trace});
    #_trace "\n\$class =   $class\n";
    #_trace "\$hash_ref = ".\%$err_hash."\n";
    foreach my $err_key (sort (keys(%$hash_ref)) ) {
        $err_hash_str .= $prefix if ($err_hash_str !~ /^$/x);   # not the first line
        $err_hash_str .= "\$hash->\{$err_key\} => ".$hash_ref->{$err_key}."\n";
    }
    return ($err_hash_str);
} # get_err_hash


#?---------------------------------------------------------------------------------------
#? sub get_all_err_types($;$)
#? get all possible defined error types and their internal representation as
#? a string (mainly used for debugging)
#? parameters:
#?   $class:      added automatically when method is used
#?   $prefix:     optional prefix after new line (e.g. some spaces for the indent)
sub get_all_err_types {
    my ($class, $prefix) = @_;
    my $err_types_str="";
    print ">get_all_err_types\n" if ($err_hash{trace});
    foreach my $key (sort {$a <=> $b} (keys(%$ERROR_TYPE_RHASH_REF)) ) {
        $err_types_str .= $prefix if ($err_types_str !~ /^$/x); # not the first line
        $err_types_str .= "ERROR_TYPE_RHASH_REF\{$key\} => ".$ERROR_TYPE_RHASH_REF->{$key}."\n";
    }
    return ($err_types_str);
} # get_all_err_types

1;
} # OSaft/error_handler.pm

package main;
{ # Net/SSLinfo.pm
## PACKAGE {

#!#############################################################################
#!#             Copyright (c) 2022, Achim Hoffmann
#!#----------------------------------------------------------------------------
#!# If this tool is valuable for you and we meet some day,  you can spend me an
#!# O-Saft. I'll accept good wine or beer too :-). Meanwhile -- 'til we meet --
#!# your're encouraged to make a donation to any needy child you see.   Thanks!
#!#----------------------------------------------------------------------------
#!# This software is provided "as is", without warranty of any kind, express or
#!# implied,  including  but not limited to  the warranties of merchantability,
#!# fitness for a particular purpose.  In no event shall the  copyright holders
#!# or authors be liable for any claim, damages or other liability.
#!# This software is distributed in the hope that it will be useful.
#!#
#!# This  software is licensed under GPLv2.
#!#
#!# GPL - The GNU General Public License, version 2
#!#                       as specified in:  http://www.gnu.org/licenses/gpl-2.0
#!#      or a copy of it https://github.com/OWASP/O-Saft/blob/master/LICENSE.md
#!# Permits anyone the right to use and modify the software without limitations
#!# as long as proper  credits are given  and the original  and modified source
#!# code are included. Requires  that the final product, software derivate from
#!# the original  source or any  software  utilising a GPL  component, such  as
#!# this, is also licensed under the same GPL license.
#!#############################################################################

package Net::SSLinfo;


use warnings;
use constant {
    SSLINFO         => 'Net::SSLinfo',
    SSLINFO_ERR     => '#Net::SSLinfo::errors:',
    SSLINFO_HASH    => '<<openssl>>',
    SSLINFO_UNDEF   => '<<undefined>>',
    SSLINFO_PEM     => '<<N/A (no PEM)>>',
};
my  $SID_sslinfo    =  "@(#) SSLinfo.pm 1.283 22/11/23 21:12:47";
our $VERSION        =  "22.11.22";  # official verion number of tis file

#-# use OSaft::Text qw(print_pod %STR);
use Socket;
use Net::SSLeay;
BEGIN {
    Net::SSLeay::load_error_strings();
    Net::SSLeay::SSLeay_add_ssl_algorithms();   # Important!
    Net::SSLeay::randomize();
    if (1.45 > $Net::SSLeay::VERSION) {
        warn("**WARNING: 081: ancient Net::SSLeay $Net::SSLeay::VERSION < 1.49; cannot use ::initialize");
    } else {
        Net::SSLeay::initialize();
    }
}

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

# Documentaion starts here, so  POD-style inline documentation  can be used for
# functions also which will be extracted automatically by POD tools. All public
# functions will be prefixed with a POD description.
#
# Dragons with perldoc:
#   =head2
#       Needs at least one space between ( and ) , otherwise formatting will be
#       wrong.
#   C<$something>
#       Does not print  "$something"  but simply  $something  unless  $somthing
#       contains = or * character, i.e. $some=thing. Hence we use I<$something>
#       instead.

# NOTE: This module should not use any  print(), warn() or die() calls to avoid
#       unexpected behaviours in the calling program. Exception are:
#           warn()  when used to inform about ancient modules
#           print() when used in trace mode (0 < $trace).

## no critic qw(ErrorHandling::RequireCarping)
#  NOTE: See NOTE above.

## no critic qw(Subroutines::ProhibitExcessComplexity)
#  it's the nature of some checks to be complex
#  a max_mccabe = 40 would be nice, but cannot be set per file

## no critic qw(Subroutines::ProhibitSubroutinePrototypes)
#  NOTE: See t/.perlcriticrc

## no critic qw(RegularExpressions::RequireExtendedFormatting)
#  because we use /x as needed for human readability

##### critic qw(InputOutput::ProhibitBacktickOperators)
#  used at commands where we need backticks or qx()

## no critic qw(Variables::ProhibitPackageVars)
#  using package variables are considered ok in this package, check in future again

=pod

=encoding utf8

=head1 _____________________________________________________________________________

=head1 NAME

Net::SSLinfo -- perl extension for SSL connection and certificate data

=head1 SYNOPSIS

    # on command line:
    Net::SSLinfo.pm                 # print help
    Net::SSLinfo.pm --help          # print help
    Net::SSLinfo.pm +VERSION        # print version string
    Net::SSLinfo.pm version         # print internal version string
    Net::SSLinfo.pm --test-sclient  # print available options for 'openssl s_client'
    Net::SSLinfo.pm --test-sslmap   # print constants for SSL protocols
    Net::SSLinfo.pm --test-openssl  # print information about openssl capabilities
    Net::SSLinfo.pm --test-ssleay   # print information about Net::SSLeay capabilities
    Net::SSLinfo.pm --test-methods  # print available methods in Net::SSLeay
    Net::SSLinfo.pm unknown-host    # print empty data structure
    Net::SSLinfo.pm your.tld        # print data from your.tld

    # from within perl scripts:
    use Net::SSLinfo;
    print join("\n",
        PEM("www.example.com",443),
        dates(),
        selected()
        ciphers()
        );
    do_ssl_close("www.example.com",443);

=head1 DESCRIPTION

This module is an extension to L<Net::SSLeay(3pm)> to provide information
according a SSL connection to a specific server.

The purpose is to give as much as possible information to the user (caller)
according the specified server aka hostname without struggling with the
internals of SSL as needed by Net::SSLeay.

=head1 RETURN VALUES

All methods return a string on success, empty string otherwise.

No output is written on STDOUT or STDERR. Errors need to be retrived using
I<Net::SSLinfo::errors()> method.

=head1 DEBUGGING

Simple tracing can be activated with I<$Net::SSLinfo::trace=1>. If set to 2
or greater, more data will be printed, for example the complete request and
response data as well as data which covers more than one line.

I<$Net::SSLinfo::trace=2> or I<$Net::SSLinfo::trace=3> will be passed to
I<$Net::SSLeay::trace>.
I<$Net::SSLeay::linux_debug=1> will be set if trace > 2.

Debugging of low level SSL can be enabled by setting I<$Net::SSLeay::trace>,
see L<Net::SSLeay> for details.
Note that Net::SSLeay may print on STDERR with I<$Net::SSLeay::trace> set.

In trace messages empty or undefined strings are written as "<<undefined>>".

I<$Net::SSLinfo::prefix_trace> contains the string used as prefix for each
message printed with trace

=over

=item $Net::SSLeay::linux_debug

Passed to Net::SSLeay; default: 0

=item $Net::SSLinfo::slowly

Passed to Net::SSLeay; default: 0

=back

=head1 VARIABLES

Following variables are supported:

=over

=item $Net::SSLinfo::ca_crl

URL where to find CRL file; default: ''

=item $Net::SSLinfo::ca_file

File in PEM format file with all CAs;   default: ''

Value will not be used at all is set C<undef>.

=item $Net::SSLinfo::ca_path

Directory with PEM files for all CAs;   default: ''

Value will not be used at all is set C<undef>.

=item $Net::SSLinfo::ca_depth

Depth of peer certificate verification; default: 9

Value will not be used at all if set C<undef>.

=item $Net::SSLinfo::no_compression

Set SSL/TLS option to use compression; default: 1

=item $Net::SSLinfo::ignore_handshake

If set to "1" connection attempts returning "faild handshake" will be
treated as errorM default: 0.

=item $Net::SSLinfo::proxyhost

FQDN or IP of proxy to be used; default: ''.

=item $Net::SSLinfo::proxyport

Port for proxy; default: ''.

=item $Net::SSLinfo::proxypass

Username for proxy authentication (Basic or Digest Auth); default: ''.

=item $Net::SSLinfo::proxyuser

Password for proxy authentication (Basic or Digest Auth); default: ''.

=item $Net::SSLinfo::proxyauth

Authentication string used for proxy; default: ''.

=item Net::SSLinfo::target_url

URL to be used when makeing HTTP/HTTPS connection (to get HTTP data).

=item $Net::SSLinfo::socket

Socket to be used for connection.  This must be a file descriptor and
it's assumed to be an AF_INET or AF_INET6 TCP STREAM type connection.
Note: the calling application is responsible for closing the socket.

=item $Net::SSLinfo::socket_reuse

If set to "1" sockets will be reused if a SSL connection fails and is
opened again. The socket will be closed and reopend if set to "0".

Background: some servers complain with an TLS Alert  if such a socket
will be reused. In such cases the default "1" should be set to "0".

=item $Net::SSLinfo::starttls

Use STARTTLS if not empty.

=item $Net::SSLinfo::openssl

Path for openssl executable to be used; default: openssl

=item $Net::SSLinfo::timeout

Path for timeout executable to be used; default: timeout

=item $Net::SSLinfo::use_openssl

More information  according the  SSL connection and  the certificate,
additional to that of Net::SSLeay, can be retrived using the  openssl
executable. If set to "1" openssl will be used also; default: 1

If disabled, the values returned will be: #

=item $Net::SSLinfo::use_sclient

Some information  according the  SSL connection and the certificate,
can only be retrived using   "openssl s_client ...".   Unfortunately
the use may result in a  performance penulty  on some systems and so
it can be disabled with "0"; default: 1

If disabled, the values returned will be: #

=item $Net::SSLinfo::use_SNI

If set to "1", "$Net::SSLinfo::sni_name"  will be used as SNI when opening
the connection. If set to "0", no SNI will be used.
SNI is needed if there are multiple SSL hostnames on the same IP address.
This can be used to check if the target supports SNI; default: 1

=item $Net::SSLinfo::sni_name

The specified string will be used as hostname for SNI.  It will be used if
$Net::SSLinfo::use_SNI is set to 1.
supports SNI; default: ""

=item $Net::SSLinfo::use_http

If set to "1", make a simple  HTTP request on the open  SSL connection and
parse the response for additional SSL/TLS related information (for example
Strict-Transport-Security header); default: 1

=item $Net::SSLinfo::use_https

If set to "1", make a simple  HTTPS  request on the open  SSL connection.

=item $Net::SSLinfo::use_alpn

If set to "1",  protocols from  "$Net::SSLinfo::protos_alpn"  are used for
the ALPN option to open the SSL connection.

=item $Net::SSLinfo::use_npn

If set to "1",  protocols from  "$Net::SSLinfo::protos_npn"  are  used for
the NPN option to open the SSL connection.

=item $Net::SSLinfo::protos_alpn

List of protocols to be used for ALPN option when opening a SSL connection.
Used if  "$Net::SSLinfo::use_alpn" is set.

=item $Net::SSLinfo::protos_npn

List of protocols to be used for NPN option when opening a SSL connection.
Used if  "$Net::SSLinfo::use_npn" is set.

=item $Net::SSLinfo::no_cert

The target may allow connections using SSL protocol,  but does not provide
a certificate. In this case all calls to functions to get details from the
certificate fail (most likely with "segmentation fault" or alike).
Due to the behaviour of the used low level ssl libraries,  there is no way
to detect this failure automatically. If the calling programm terminates
abnormally with an error, then setting this value can help.

If set to "0", collect data from target's certificate; this is default.
If set to "1", don't collect data from target's certificate  and return an
empty string.
If set to "2", don't collect data from target's certificate and return the
string defined in  "$Net::SSLinfo::no_cert_txt".

=item $Net::SSLinfo::no_cert_txt

String to be used if "$Net::SSLinfo::no_cert" is set.
Default is (same as openssl): "unable to load certificate"

=item $Net::SSLinfo::method

Will be set to the Net::SSLeay::*_method used to in do_ssl_open().

=item $Net::SSLinfo::file_sclient

Use content of this file instead opening connection with openssl.
Used for debugging.  Note: there are no checks if the content of this file
matches the other parameters, in particular the host and port.

=item $Net::SSLinfo::verbose

Print some verbose messages.

=back

=head1 EXAMPLES

See SYNOPSIS above.

=head1 LIMITATIONS

=head2 Collected data with openssl

Some data is collected using an external openssl executable. The output of
this executable is used to find proper information. Hence some data may be
missing or detected wrong due to different output formats of openssl.
If in doubt use "$Net::SSLinfo::use_openssl = 0" to disable openssl usage.

Port 443 is used when calling:
    Net::SSLinfo.pm your.tld

=head2 Threads

This module is not thread-save as it only supports one internal object for
socket handles. However, it will work if all threads use the same hostname.

=head1 KNOWN PROBLEMS

=head2 Certificate Verification

The verification of the target's certificate chain relies on the installed
root CAs. As this tool uses  Net::SSLeay  which usually relies on  openssl
and its libraries, the (default) settings in these libraries are effective
for our certificate chain verification.

I.g. the root CAs can be provided in a single combined PEM format file, or
in a directory containing one file per CA with a proper link which name is
the CA's hash value. Therefore the library uses the  CAPFILE and/or CAPATH
environment variable. The tools, like openssl, have options to pass proper
values for the file and path.

We provide these settings in the variables:  I<$Net::SSLinfo::ca_file>,
I<$Net::SSLinfo::ca_path>,  I<$Net::SSLinfo::ca_depth> .

Please see  B<VARIABLES>  for details.

Unfortunately the  default settings  for the libraries and tools differ on
various platforms, so there is  no simple way to check if the verification
was successful as expected.

In particular the behaviour is unpredictable if the  environment variables
are set and our internal variables (see above) too. Hence, we recommend to
either ensure that  no environment variables are in use,  or our variables
are set  C<undef>.

=head2 Errors

Net::SSLeay::X509_get_subject_name()   from version 1.49 sometimes crashes
with segmentation fault.

Error message like:
  panic: sv_setpvn called with negative strlen at Net/SSLinfo.pm line 552,
     <DATA> line 1384.

Reason most likely Net::SSLeay Version (version<1.49) which doesn't define
C<Net::SSLeay::X509_NAME_get_text_by_NID()>.

=begin HACKER_INFO

Internal documentation only.

=head1 General Program Flow

=over

=item _ssleay_socket()

    socket()
    connect()
    select()

=item _ssleay_ctx_new()

    Net::SSLeay::CTX_tlsv1_2_new()
    Net::SSLeay::CTX_set_ssl_version()
    Net::SSLeay::CTX_set_options()
    Net::SSLeay::CTX_set_timeout()

=item _ssleay_ctx_ca()

    Net::SSLeay::CTX_set_verify()
    Net::SSLeay::CTX_load_verify_locations()
    Net::SSLeay::CTX_set_verify_depth()

=item _ssleay_ssl_new()

    Net::SSLeay::new()
    Net::SSLeay::set_tlsext_host_name()
    Net::SSLeay::ctrl()

=item _ssleay_ssl_np()
    Net::SSLeay::CTX_set_alpn_protos()
    Net::SSLeay::CTX_set_next_proto_select_cb()

=item do_ssl_new()

    _ssleay_socket()
    _ssleay_ctx_new()
    _ssleay_ctx_ca()
    _ssleay_ssl_new()
    _ssleay_ssl_np()
    Net::SSLeay::connect()

=item do_ssl_open()

    do_ssl_new()
    _ssleay_cert_get()
    Net::SSLeay::*()  # getter
    $_SSLinfo{'*'}    # getter
    Net::SSLeay::write() && Net::SSLeay::ssl_read_all  # HTTPS
    _header_get()   # getter
    Net::SSLeay::get_http()
    $headers        # getter
    _openssl_x509() # getter using openssl
    do_openssl()

=item do_ssl_free()

    close(socket)
    Net::SSLeay::free()
    Net::SSLeay::CTX_free()

=item do_ssl_close()

    do_ssl_free()
    _SSLinfo_reset()

=back

=head1 General Usage

=over

=item Open TCP connection and collect data

    do_ssl_open(host,port)
    #... check some stuff
    do_ssl_close()

=item Open TCP connection

    do_ssl_new(host,port,ssl-version,cipher))
    #... check some stuff
    do_ssl_free()

=back

=end HACKER_INFO

=head1 METHODS

All methods are simple getters to retrieve information from `SSL objects'.
The general usage is:

=over

=item # 1. very first call with hostname and port

    my $value = method('hostname', 8443);

=item # 2. very first call with hostname only, port defaults to 443

    my $value = method('hostname');

=item # 3. continous call, hostname and port not necessary

    my $value = method();

=back

Methods named C<do_*> open and close the TCP connections. They are called
automatically by the getters (see above) if at least a C<hostname> parameter
is given. It's obvious, that for these  C<do_*>  methods the  C<hostname>
parameter is mandatory.

All following descriptions omit the  C<hostname, port> parameter as they all
follow the rules describend above.

=cut

#_____________________________________________________________________________
#________________________________________________ public (export) variables __|

use Exporter qw(import);
use base     qw(Exporter);
my  @EXPORT = qw(
        net_sslinfo_done
        ssleay_methods
        test_methods
        test_sclient
        test_sslmap
        test_ssleay
        datadump
        s_client_check
        s_client_get_optionlist
        s_client_opt_get
        do_ssl_new
        do_ssl_free
        do_ssl_open
        do_ssl_close
        do_openssl
        set_cipher_list
        options
        errors
        PEM
        pem
        text
        fingerprint
        fingerprint_hash
        fingerprint_text
        fingerprint_type
        fingerprint_sha2
        fingerprint_sha1
        fingerprint_md5
        cert_type
        email
        serial
        serial_int
        serial_hex
        modulus
        modulus_len
        modulus_exponent
        subject_hash
        issuer_hash
        aux
        pubkey
        pubkey_algorithm
        pubkey_value
        signame
        sigdump
        sigkey_len
        sigkey_value
        extensions
        tlsextdebug
        tlsextensions
        heartbeat
        trustout
        ocsp_uri
        ocspid
        ocsp_response
        ocsp_response_data
        ocsp_response_status
        ocsp_cert_status
        ocsp_next_update
        ocsp_this_update
        before
        after
        dates
        issuer
        subject
        default
        selected
        cipher_list
        cipher_openssl
        cipher_local
        ciphers
        cn
        commonname
        altname
        subjectaltnames
        authority
        owner
        certificate
        SSLversion
        version
        keysize
        keyusage
        https_protocols
        https_svc
        https_body
        https_status
        https_server
        https_alerts
        https_location
        https_refresh
        https_pins
        http_protocols
        http_svc
        http_status
        http_location
        http_refresh
        http_sts
        hsts
        hsts_httpequiv
        hsts_maxage
        hsts_subdom
        hsts_preload
        verify_hostname
        verify_altname
        verify_alias
        verify
        error_verify
        error_depth
        chain
        chain_verify
        compression
        expansion
        extended_master_secret
        master_secret
        next_protocols
        alpn
        no_alpn
        next_protocol
        krb5
        master_key
        psk_hint
        psk_identity
        public_key_len
        session_id
        session_id_ctx
        session_startdate
        session_starttime
        session_lifetime
        session_ticket
        session_ticket_hint
        session_timeout
        session_protocol
        srp
        renegotiation
        resumption
        dh_parameter
        selfsigned
        s_client
        error
        CTX_method
);
    # insert above in vi with:
    # :r !sed -ne 's/^sub \([a-zA-Z][^ (]*\).*/\t\t\1/p' %

our $HAVE_XS = eval {
        local $SIG{'__DIE__'} = 'DEFAULT';
        eval {
            require XSLoader;
            XSLoader::load('Net::SSLinfo', $VERSION);
            1;
        } or do {
            require DynaLoader;
            bootstrap Net::SSLinfo $VERSION;
            1;
        };

    } ? 1 : 0;

#_____________________________________________________________________________
#___________________________________________________________ initialisation __|

my $_protos = 'http/1.1,h2c,h2c-14,spdy/1,npn-spdy/2,spdy/2,spdy/3,spdy/3.1,spdy/4a2,spdy/4a4,h2-14,h2-15,http/2.0,h2';
    # NOTE: most weak protocol first, cause we check for vulnerabilities
    # next protocols not yet configurable
    # h2c*  - HTTP 2 Cleartext
    # protocols may have prefix `exp' which should not be checked by server
    # grpc-exp not yet supported (which has -exp suffix, strange ...)
$Net::SSLinfo::timeout     = 'timeout'; # timeout executable
$Net::SSLinfo::openssl     = 'openssl'; # openssl executable
$Net::SSLinfo::use_openssl = 1; # 1 use installed openssl executable
$Net::SSLinfo::use_sclient = 1; # 1 use openssl s_client ...
$Net::SSLinfo::use_extdebug= 1; # 0 do not use openssl with -tlsextdebug option
$Net::SSLinfo::use_nextprot= 1; # 0 do not use openssl with -nextprotoneg option
$Net::SSLinfo::use_reconnect=1; # 0 do not use openssl with -reconnect option
$Net::SSLinfo::sclient_opt = '';# option for openssl s_client command
$Net::SSLinfo::file_sclient= '';# file to read "open s_client" data from
$Net::SSLinfo::sni_name    = '';# use this as hostname for SNI
$Net::SSLinfo::use_SNI     = 1; # 1 use SNI to connect to target; 0: do not use SNI; string: use this as hostname for SNI
$Net::SSLinfo::use_https   = 1; # 1 make HTTPS request and retrive additional data
$Net::SSLinfo::use_http    = 1; # 1 make HTTP  request and retrive additional data
$Net::SSLinfo::use_alpn    = 1; # 1 to set ALPN option using $Net::SSLinfo::protos_alpn
$Net::SSLinfo::use_npn     = 1; # 1 to set NPN option using $Net::SSLinfo::protos_npn
$Net::SSLinfo::protos_alpn = $_protos;
$Net::SSLinfo::protos_npn  = $_protos;
$Net::SSLinfo::no_cert     = 0; # 0 collect data from target's certificate
                                # 1 don't collect data from target's certificate
                                #   return empty string
                                # 2 don't collect data from target's certificate
                                #   return string $Net::SSLinfo::no_cert_txt
$Net::SSLinfo::no_cert_txt = 'unable to load certificate'; # same as openssl 1.0.x
$Net::SSLinfo::ignore_case = 1; # 1 match hostname, CN case insensitive
$Net::SSLinfo::target_url  = '/'; # URL to use when connecting with get_http(s)
$Net::SSLinfo::ignore_handshake = 0; # 1 treat "failed handshake" as error
$Net::SSLinfo::timeout_sec = 3; # time in seconds for timeout executable
$Net::SSLinfo::starttls    = '';# use STARTTLS if not empty
$Net::SSLinfo::proxyhost   = '';# FQDN or IP of proxy to be used
$Net::SSLinfo::proxyport   = '';# port for proxy
$Net::SSLinfo::proxypass   = '';# username for proxy authentication (Basic or Digest Auth)
$Net::SSLinfo::proxyuser   = '';# password for proxy authentication (Basic or Digest Auth)
$Net::SSLinfo::proxyauth   = '';# authentication string used for proxy
$Net::SSLinfo::method      = '';# used Net::SSLeay::*_method
$Net::SSLinfo::socket_reuse= 1; # 0: close and reopen socket for each connection
$Net::SSLinfo::no_compression   = 0; # 1: use OP_NO_COMPRESSION for connetion in Net::SSLeay
$Net::SSLinfo::socket   = undef;# socket to be used for connection
$Net::SSLinfo::ca_crl   = undef;# URL where to find CRL file
$Net::SSLinfo::ca_file  = undef;# PEM format file with CAs
$Net::SSLinfo::ca_path  = undef;# path to directory with PEM files for CAs
$Net::SSLinfo::ca_depth = undef;# depth of peer certificate verification verification
                                # 0=verification is off, returns always "Verify return code: 0 (ok)"
                                # 9=complete verification (max. value, openssl's default)
                                # undef= not used, means system default is used
$Net::SSLinfo::trace       = 0; # 1=simple debugging Net::SSLinfo
                                # 2=trace     including $Net::SSLeay::trace=2
                                # 3=dump data including $Net::SSLeay::trace=3
$Net::SSLinfo::prefix_trace= '#' . SSLINFO . '::';  # prefix string used in trace   messages
$Net::SSLinfo::verbose     = 0; # 1: print some verbose messages
$Net::SSLinfo::linux_debug = 0; # passed to Net::SSLeay::linux_debug
$Net::SSLinfo::slowly      = 0; # passed to Net::SSLeay::slowly

$Net::SSLeay::slowly       = 0;

# avoid perl warning "... used only once: possible typo ..."
my $dumm_1   = $Net::SSLinfo::linux_debug;
my $dumm_2   = $Net::SSLinfo::proxyport;
my $dumm_3   = $Net::SSLinfo::proxypass;
my $dumm_4   = $Net::SSLinfo::proxyuser;
my $dumm_5   = $Net::SSLinfo::proxyauth;
my $dumm_6   = $Net::SSLinfo::ca_crl;
my $dumm_7   = $Net::SSLinfo::use_nextprot;
my $trace    = $Net::SSLinfo::trace;

# forward declarations
sub do_ssl_open($$$@);
sub do_ssl_close($$);
sub do_openssl($$$$);

# define some shortcuts to avoid $Net::SSLinfo::*
my $_echo    = '';              # dangerous if aliased or wrong one found
my $_timeout = undef;
my $_openssl = undef;

#_____________________________________________________________________________
#_________________________________________________________ internal methods __|

# SEE Perl:Undefined subroutine
*_warn    = sub { print(join(" ", "**WARNING:", @_), "\n"); return; } if not defined &_warn;
*_dbx     = sub { print(join(" ", "#dbx#"     , @_), "\n"); return; } if not defined &_dbx;

# need our own _trace() methods
sub _trace      { my $txt=shift; local $\="\n"; print $Net::SSLinfo::prefix_trace . $txt if (0  < $trace); return; }
sub _trace1     { my $txt=shift; local $\="\n"; print $Net::SSLinfo::prefix_trace . $txt if (1 == $trace); return; }
sub _trace2     { my $txt=shift; local $\="\n"; print $Net::SSLinfo::prefix_trace . $txt if (1  < $trace); return; }

sub _verbose    { my $txt=shift; local $\="\n"; print $Net::SSLinfo::prefix_trace . $txt if (0  < $Net::SSLinfo::verbose); return; }

sub _traceset   {
    $trace = $Net::SSLinfo::trace;          # set global variable
    $Net::SSLeay::trace = $trace    if (1 < $trace);
        # must set $Net::SSLeay::trace here again as $Net::SSLinfo::trace
        # might unset when Net::SSLinfo called initially;
    $Net::SSLeay::linux_debug = 1   if (2 < $trace);
        # Net::SSLeay 1.72 uses linux_debug with trace > 2 only
    $Net::SSLeay::slowly = $Net::SSLinfo::slowly;
    return;
}

sub _setcommand {
    #? check for external command $command; returns command or empty string
    my $command = shift;
    return '' if ('' eq $command);
    my $cmd;
    my $opt = "version";
       $opt = "--version" if ($command =~ m/timeout$/);
    _trace("_setcommand($command) $opt 2>&1");
    $cmd = qx($command $opt 2>&1);  ## no critic qw(InputOutput::ProhibitBacktickOperators)
    if (defined $cmd) {
        # chomp() and _trace() here only to avoid "Use of uninitialized value $cmd ..."
        chomp $cmd;
        _trace2("_setcommand: #{ $cmd #}");
        $cmd = "$command";
        if ($cmd =~ m#timeout$#) {
            # some timout implementations require -t option, i.e. BusyBox v1.26.2
            # hence we check if it works with -t and add it to $cmd
            $cmd = "$cmd -t " if (qx($cmd -t 2 pwd 2>&1) !~ m/timeout/);  ## no critic qw(InputOutput::ProhibitBacktickOperators)
        }
    } else {
        _trace("_setcommand: $command = ''");
        $cmd = '';  # i.e. Mac OS X does not have timeout by default; can work without ...
    }
    if ($^O !~ m/MSWin32/) {
        # Windows is too stupid for secure program calls
        $cmd = '\\' .  $cmd if (($cmd ne '') and ($cmd !~ /\//));
    }
    _trace("_setcommand cmd=$cmd");
    return $cmd;
} # _setcommand

sub _setcmd     {
    #? check for external commands and initialise if necessary
    # set global variabales $_openssl and $_timeout
    return if (defined $_timeout);  # lazy check
    $_openssl   = _setcommand($Net::SSLinfo::openssl);
    $_timeout   = _setcommand($Net::SSLinfo::timeout);
    $_timeout  .= " $Net::SSLinfo::timeout_sec" if (defined $_timeout);
    _trace("#_setcmd: _openssl=$_openssl ; _timeout=$_timeout");
    if ($^O !~ m/MSWin32/) {
        # Windows is too stupid for secure program calls
        $_echo  = '\\' .  $_echo;
    }
    return;
} # _setcmd

sub _traceSSLbitmasks   {
    # print bitmasks of available SSL constants
    my $txt  = shift; # prefix string as in _trace()
    my $mask = shift;
    # cannot use _trace() 'cause we want our own formatting
    _traceset();
    ## no critic (TestingAndDebugging::ProhibitProlongedStrictureOverride)
    #  NOTE: perlcritic is too pedantic
    foreach my $op (sort qw(
            OP_ALL
            OP_MICROSOFT_SESS_ID_BUG
            OP_NETSCAPE_CHALLENGE_BUG
            OP_LEGACY_SERVER_CONNECT
            OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG
            OP_TLSEXT_PADDING
            OP_MICROSOFT_BIG_SSLV3_BUFFER
            OP_SAFARI_ECDHE_ECDSA_BUG
            OP_SSLEAY_080_CLIENT_DH_BUG
            OP_TLS_D5_BUG
            OP_TLS_BLOCK_PADDING_BUG
            OP_DONT_INSERT_EMPTY_FRAGMENTS
            OP_NO_QUERY_MTU
            OP_COOKIE_EXCHANGE
            OP_NO_TICKET
            OP_CISCO_ANYCONNECT
            OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION
            OP_NO_COMPRESSION
            OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION
            OP_SINGLE_ECDH_USE
            OP_SINGLE_DH_USE
            OP_CIPHER_SERVER_PREFERENCE
            OP_TLS_ROLLBACK_BUG 
            OP_NO_SSLv2
            OP_NO_SSLv3
            OP_NO_TLSv1
            OP_NO_TLSv1_1
            OP_NO_TLSv1_2
            OP_NO_TLSv1_3
            OP_NO_SSL_MASK
            OP_NETSCAPE_CA_DN_BUG
            OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG
            OP_CRYPTOPRO_TLSEXT_BUG
            OP_SSLREF2_REUSE_CERT_TYPE_BUG
            OP_MSIE_SSLV2_RSA_PADDING
            OP_EPHEMERAL_RSA
            OP_PKCS1_CHECK_1
            OP_PKCS1_CHECK_2
            OP_ALLOW_NO_DHE_KEX
            OP_NON_EXPORT_FIRST
            OP_NO_CLIENT_RENEGOTIATION
            OP_NO_ENCRYPT_THEN_MAC
            OP_NO_RENEGOTIATION
            OP_PRIORITIZE_CHACHA
            )) {
        no strict;  ## no critic (TestingAndDebugging::ProhibitNoStrict)
            # necessary as we use {"Net::SSLeay::$op"}
        printf("#%s: %-30s ", $txt, $op);
        ## my $_op_sub = \&{"Net::SSLeay::$op"}; # will not catch all values and errors; hence eval() below
        my $opt;
        my $_ok = eval { $opt = &{"Net::SSLeay::$op"}; };
        if (defined $_ok) {
            my $bit = (($mask & $opt)>0) || 0;
            printf("0x%08x %s\n", $opt, $bit);
        } else {
            printf("<<$@>>\n"); # error string from Net::SSLeay instead <<undef>>
        }
    }
    return;
} # _traceSSLbitmasks

#_____________________________________________________________________________
#__________________________________________________ internal data structure __|

sub _ssleay_value_get   {
    #? retrun value of $type (option, timeout, verify_mode, verify_depth, OP) for specified function as formated string
    #  returns <<undef>> if specified function does not exist
    #  $func is i.e.: Net::SSLeay::CTX_v3_new, Net::SSLeay::CTX_v23_new
    my $type= shift;
    my $func= shift;
    my $val = "<<undef>>";
       $val =    undef  if ('OP_or_undef' eq $type);
    _traceset();
    _trace("_ssleay_value_get('$type', '$func')");
    if (defined &$func) {
       $val = sprintf('0x%08x', Net::SSLeay::CTX_get_options(&$func())) if ('options' eq $type);
       $val =                   Net::SSLeay::CTX_get_timeout(&$func())  if ('timeout' eq $type);
       $val = sprintf('0x%08x', Net::SSLeay::CTX_get_verify_mode( &$func())) if ('verify_mode'  eq $type);
       $val =                   Net::SSLeay::CTX_get_verify_depth(&$func())  if ('verify_depth' eq $type);
       $val = sprintf('0x%08x', &$func())   if ('OP' eq $type);
       $val = sprintf('0x%08x', &$func())   if ('OP_or_undef' eq $type);
    }
    _trace("_ssleay_value_get ret=" . ($val || "undef"));
    return $val;
} # _ssleay_value_get

my %_OpenSSL_opt = (    # openssl capabilities
    # openssl has various capabilities which can be used with options.
    # Depending on the version of openssl, these options are available or not.
    # The data structure contains the important options, each as key where its
    # value is  1  if the option is available at openssl.
    # Currently only options for openssl's  s_client  command are supported.
    # This data structure is for one openssl command. More than one command is
    # not expected, not useful, hence it is thread save.
    # NOTE:  some options are present in different spellings because different
    #        openssl version use different spellings, grrr.
    'done'          => 0, # set to 1 if initialised
    'data'          => '',# contains output from "openssl s_client -help"
    #--------------+------------
    # key (=option) supported=1
    #--------------+------------
    '-CAfile'       => 0,
    '-CApath'       => 0,
    '-alpn'         => 0,
    '-npn'          => 0, # same as -nextprotoneg
    '-nextprotoneg' => 0,
    '-reconnect'    => 0,
    '-fallback_scsv'=> 0,
    '-comp'         => 0,
    '-no_comp'      => 0,
    '-no_ticket'    => 0,
    '-no_tlsext'    => 0,
    '-serverinfo'   => 0,
    '-servername'   => 0,
    '-serverpref'   => 0,
    '-showcerts'    => 0,
    '-curves'       => 0,
    '-debug'        => 0,
    '-bugs'         => 0,
    '-key'          => 0,
    '-msg'          => 0,
    '-nbio'         => 0,
    '-psk'          => 0,
    '-psk_identity' => 0,
    '-pause'        => 0,
    '-prexit'       => 0,
    '-proxy'        => 0,
    '-quiet'        => 0,
    '-sigalgs'      => 0,
    '-state'        => 0,
    '-status'       => 0,
    '-strict'       => 0,
    '-nbio_test'    => 0,
    '-tlsextdebug'  => 0,
    '-client_sigalgs'           => 0,
    '-record_padding'           => 0,
    '-no_renegotiation'         => 0,
    '-legacyrenegotiation'      => 0,
    '-legacy_renegotiation'     => 0,
    '-legacy_server_connect'    => 0,
    '-no_legacy_server_connect' => 0,
    #--------------+------------
    # options in server mode
    #--------------+------------
    #'-anti_replay'  => 0,
    #'-no_anti_replay'           => 0,
    #'-dhparam'      => 0,
    #'-prioritize_chacha'        => 0,
    #'-no_resumption_on_reneg'   => 0,
);

my %_SSLmap = ( # map libssl's constants to speaking names
    # SSL and openssl is a pain, for setting protocols it needs a bitmask
    # and SSL itself returns a hex constant, which is different
    #                 /----- returned by Net::SSLeay::version($ssl)
    #                 |      bitmask used in Net::SSLeay::CTX_set_options()
    # key             v      v          example bitmask
    #-------------+---------+---------------------------------------------
    'SSLv2'     => [0x0002,  undef],  # 0x01000000
    'SSLv3'     => [0x0300,  undef],  # 0x02000000
    'TLSv1'     => [0x0301,  undef],  # 0x04000000
    'TLSv11'    => [0x0302,  undef],  # 0x08000000
    'TLSv12'    => [0x0303,  undef],  # 0x10000000
    'TLSv13'    => [0x0304,  undef],  # 0x10000000
    'TLS1FF'    => [0x03FF,  undef],  #
    'DTLSfamily'=> [0xFE00,  undef],  #
    'DTLSv09'   => [0x0100,  undef],  # 0xFEFF in some openssl versions
    'DTLSv1'    => [0xFEFF,  undef],  # ??
    'DTLSv11'   => [0xFEFE,  undef],  # ??
    'DTLSv12'   => [0xFEFD,  undef],  # ??
    'DTLSv13'   => [0xFEFF,  undef],  # ??
);
# unfortunately not all openssl and/or Net::SSLeay versions have all constants,
# hence we need to assign values dynamically (to avoid perl errors)
$_SSLmap{'SSLv2'}  [1] = _ssleay_value_get('OP_or_undef', *Net::SSLeay::OP_NO_SSLv2);
$_SSLmap{'SSLv3'}  [1] = _ssleay_value_get('OP_or_undef', *Net::SSLeay::OP_NO_SSLv3);
$_SSLmap{'TLSv1'}  [1] = _ssleay_value_get('OP_or_undef', *Net::SSLeay::OP_NO_TLSv1);
$_SSLmap{'TLSv11'} [1] = _ssleay_value_get('OP_or_undef', *Net::SSLeay::OP_NO_TLSv1_1);
$_SSLmap{'TLSv12'} [1] = _ssleay_value_get('OP_or_undef', *Net::SSLeay::OP_NO_TLSv1_2);
$_SSLmap{'TLSv13'} [1] = _ssleay_value_get('OP_or_undef', *Net::SSLeay::OP_NO_TLSv1_3);
$_SSLmap{'DTLSv1'} [1] = _ssleay_value_get('OP_or_undef', *Net::SSLeay::OP_NO_DTLSv1);
$_SSLmap{'DTLSv11'}[1] = _ssleay_value_get('OP_or_undef', *Net::SSLeay::OP_NO_DTLSv1_1);
$_SSLmap{'DTLSv12'}[1] = _ssleay_value_get('OP_or_undef', *Net::SSLeay::OP_NO_DTLSv1_2);
$_SSLmap{'DTLSv13'}[1] = _ssleay_value_get('OP_or_undef', *Net::SSLeay::OP_NO_DTLSv1_3);
    # NOTE: we use the bitmask provided by the system
    # NOTE: all checks are done now, we don't need to fiddle around that later
    #       we just need to check for undef then
# TODO: %_SSLmap should be inherited from $cfg{openssl_version_map} or vice versa
my %_SSLhex = map { $_SSLmap{$_}[0] => $_ } keys %_SSLmap;  # reverse map

sub _SSLversion_get { return $_SSLmap{$_[0]}[0]; }  ## no critic qw(Subroutines::RequireArgUnpacking)
sub _SSLbitmask_get { return $_SSLmap{$_[0]}[1]; }  ## no critic qw(Subroutines::RequireArgUnpacking)
                                # for 'no critic' above, see comment far below

my %_SSLtemp= ( # temporary internal data structure when establishing a connection
    # 'key'     => 'value',     # description
    #-------------+-------------+---------------------------------------------
    'addr'      => undef,       # raw INET IP for hostname (FQDN)
    'socket'    => undef,       # socket handle of new connection
    'ctx'       => undef,       # handle for Net::SSLeay::CTX_new()
    'ssl'       => undef,       # handle for Net::SSLeay
    'method'    => '',          # used Net::SSLeay::*_method
    'errors'    => [],          # stack for errors, if any
    'PEM_text'  => '',          # temp. storage oF PEM to avoid multiple openssl calls
    #-------------+-------------+---------------------------------------------
); # %_SSLtemp

sub _SSLtemp_reset  {
    #? reset internal data structure%_SSLtemp ; for internal use only
    foreach my $key (keys %_SSLtemp) { $_SSLtemp{$key} = undef; }
    $_SSLtemp{'method'}     = '';
    $_SSLtemp{'errors'}     = [];
    $_SSLtemp{'PEM_text'}   = '';
    return;
} # _SSLtemp_reset

my %_SSLinfo= ( # our internal data structure
    'key'       => 'value',     # description
    #-------------+-------------+---------------------------------------------
    'host'      => '',          # hostname (FQDN) or IP as given by user
    'addr'      => undef,       # raw INET IP for hostname (FQDN)
    'ip'        => '',          # human readable IP for hostname (FQDN)
    'port'      => 443,         # port as given by user (default 443)
    'ctx'       => undef,       # handle for Net::SSLeay::CTX_new()
    'ssl'       => undef,       # handle for Net::SSLeay
    '_options'  => '',          # option bitmask used for connection
    'errors'    => [],          # stack for errors, if any
    'cipherlist'=> 'ALL:NULL:eNULL:aNULL:LOW', # we want to test really all ciphers available
    'verify_cnt'=> 0,           # Net::SSLeay::set_verify() call counter
    # now store the data we get from above handles
    'SSLversion'=> '',          # Net::SSLeay::version(); used protocol version
    'version'   => '',          # certificate version
    'error_verify'  => '',      # error string of certificate chain check
    'error_depth'   => '',      # integer value of depth where certificate chain check failed
    'keysize'   => '',
    'keyusage'  => '',
    'altname'   => '',
    'cn'        => '',
    'subject'   => '',
    'issuer'    => '',
    'before'    => '',
    'after'     => '',
    'PEM'       => '',
    'text'      => '',
    'cert_type' => '',          # X509 certificate type  EXPERIMENTAL
    'ciphers'           => [],  # list of ciphers offered by local SSL implementation
    # all following are available when calling  openssl only
    's_client'          => "",  # data we get from `openssl s_client -connect ...'
    'ciphers_openssl'   => "",  # list of ciphers returned by openssl executable
    'subject_hash'      => "",  #
    'issuer_hash'       => "",  #
    'aux'               => "",  #
    'ocsp_response'     => "",  # selected data from OCSP Response Data
    'ocsp_response_data'=> "",  # complete OCSP Response with "openssl -tlsextdebug -status .."
    'ocsp_response_status'=>"", # OCSP Response Data: Response Status
    'ocsp_cert_status'  => "",  # OCSP Response Data: Cert Status
    'ocsp_next_update'  => "",  # OCSP Response Data: Next Update
    'ocsp_this_update'  => "",  # OCSP Response Data: This Update
    'pubkey'            => "",  # certificates public key
    'pubkey_algorithm'  => "",  # certificates public key algorithm
    'pubkey_value'      => "",  # certificates public key value (same as modulus)
    'signame'           => "",  #
    'sigdump'           => "",  # algorithm and value of signature key
    'sigkey_len'        => "",  # bit length  of signature key
    'sigkey_value'      => "",  # value       of signature key
    'extensions'        => "",  #
    'tlsextdebug'       => "",  # TLS extension visible with "openssl -tlsextdebug .."
    'tlsextensions'     => "",  # TLS extension visible with "openssl -tlsextdebug .."
    'email'             => "",  # the email address(es)
    'heartbeat'         => "",  # heartbeat supported
    'serial'            => "",  # the serial number, string as provided by openssl: int (hex)
    'serial_hex'        => "",  # the serial number as Integer
    'serial_int'        => "",  # the serial number as hex
    'modulus'           => "",  # the modulus of the public key
    'modulus_len'       => "",  # bit length  of the public key
    'modulus_exponent'  => "",  # exponent    of the public key
    'fingerprint_text'  => "",  # the fingerprint text
    'fingerprint_type'  => "",  # just the fingerprint hash algorithm
    'fingerprint_hash'  => "",  # the fingerprint hash value
    'fingerprint_sha2'  => "",  # SHA2 fingerprint (if available)
    'fingerprint_sha1'  => "",  # SHA1 fingerprint (if available)
    'fingerprint_md5'   => "",  # MD5  fingerprint (if available)
    'selected'          => "",  # cipher selected for session by server
    # all following need output from "openssl s_client ..."
    'verify'            => "",  # certificate chain verification
    'chain'             => "",  # certificate's CA chain
    'chain_verify'      => "",  # certificate's CA chain verifacion trace
    'dh_parameter'      => "",  # DH Parameter (starting with openssl 1.0.2a)
    'renegotiation'     => "",  # renegotiation supported
    'resumption'        => "",  # resumption supported
    'selfsigned'        => "",  # self-signed certificate
    'compression'       => "",  # compression supported
    'expansion'         => "",  # expansion supported
    'next_protocols'    => "",  # Protocols advertised by server
    'alpn'              => "",  # ALPN protocol
    'no_alpn'           => "",  # No ALPN negotiated
    'next_protocol'     => "",  # Next protocol
    'krb5'              => "",  # Krb Principal
    'psk_hint'          => "",  # PSK identity hint
    'psk_identity'      => "",  # PSK identity
    'srp'               => "",  # SRP username
    'master_key'        => "",  # Master-Key
    'master_secret'     => "",  # Extended master secret
    'public_key_len'    => "",  # Server public key
    'session_id'        => "",  # Session-ID
    'session_id_ctx'    => "",  # Session-ID-ctx
    'session_startdate' => "",  # TLS session start time (human readable)
    'session_starttime' => "",  # TLS session start time (seconds EPOCH)
    'session_lifetime'  => "",  # TLS session ticket lifetime hint
    'session_ticket'    => "",  # TLS session ticket
    'session_timeout'   => "",  # SSL-Session Timeout
    'session_protocol'  => "",  # SSL-Session Protocol
    # following from HTTP(S) request
    'https_protocols'   => "",  # HTTPS Alternate-Protocol header
    'https_svc'         => "",  # HTTPS Alt-Svc, X-Firefox-Spdy header
    'https_body'        => "",  # HTTPS response (HTML body)
    'https_status'      => "",  # HTTPS response (aka status) line
    'https_server'      => "",  # HTTPS Server header
    'https_alerts'      => "",  # HTTPS Alerts send by server
    'https_location'    => "",  # HTTPS Location header send by server
    'https_refresh'     => "",  # HTTPS Refresh header send by server
    'https_pins'        => "",  # HTTPS Public Key Pins header
    'http_protocols'    => "",  # HTTP Alternate-Protocol header
    'http_svc'          => "",  # HTTP Alt-Svc, X-Firefox-Spdy header
    'http_status'       => "",  # HTTP response (aka status) line
    'http_location'     => "",  # HTTP Location header send by server
    'http_refresh'      => "",  # HTTP Refresh header send by server
    'http_sts'          => "",  # HTTP Strict-Transport-Security header send by server (whish is very bad)
    'https_sts'         => "",  # complete STS header
    'hsts_httpequiv'    => "",  # http-equiv meta tag in HTTP body
    'hsts_maxage'       => "",  # max-age attribute of STS header
    'hsts_subdom'       => "",  # includeSubDomains attribute of STS header
    'hsts_preload'      => "",  # preload attribute of STS header
    #-------------+-------------+---------------------------------------------
); # %_SSLinfo

#  $_SSLinfo_random # SEE Make:OSAFT_MAKE (in Makefile.pod)
my $_SSLinfo_random = qr/ctx|master_key|session_(?:startdate|starttime|ticket)|ssl|x509/; # handled special
my $_SSLinfo_random_text = $OSaft::Text::STR{MAKEVAL};

sub _SSLinfo_reset  {
    #? reset internal data structure%_SSLinfo ; for internal use only
    foreach my $key (keys %_SSLinfo) { $_SSLinfo{$key} = ''; }
    # some are special
    $_SSLinfo{'key'}        = 'value';
    $_SSLinfo{'ctx'}        = undef;
    $_SSLinfo{'ssl'}        = undef;
    $_SSLinfo{'addr'}       = undef;
    $_SSLinfo{'port'}       = 443;
    $_SSLinfo{'errors'}     = [];
    $_SSLinfo{'ciphers'}    = [];
    $_SSLinfo{'cipherlist'} = 'ALL:NULL:eNULL:aNULL:LOW';
    $_SSLinfo{'verify_cnt'} = 0;
    $_SSLinfo{'ciphers_openssl'} = '';
    return;
} # _SSLinfo_reset

sub _SSLinfo_print  {
    #? print some data in $_SSLinfo (for --verbose)
    foreach my $key (sort qw(
            subject_hash
            issuer_hash
            aux
            ocsp_response
            ocsp_response_data
            ocsp_response_status
            ocsp_cert_status
            ocsp_next_update
            ocsp_this_update
            pubkey
            pubkey_algorithm
            pubkey_value
            signame
            sigdump
            sigkey_len
            sigkey_value
            extensions
            tlsextdebug
            tlsextensions
            email
            heartbeat
            serial
            serial_hex
            serial_int
            modulus
            modulus_len
            modulus_exponent
            fingerprint_text
            fingerprint_type
            fingerprint_hash
            fingerprint_sha2
            fingerprint_sha1
            fingerprint_md5
            selected
            verify
            chain
            chain_verify
            dh_parameter
            renegotiation
            resumption
            selfsigned
            compression
            expansion
            next_protocols
            alpn
            no_alpn
            next_protocol
            krb5
            psk_hint
            psk_identity
            srp
            master_secret
            master_key
            public_key_len
            session_id
            session_id_ctx
            session_startdate
            session_starttime
            session_lifetime
            session_ticket
            session_timeout
            session_protocol
            ))
            # not yet:
            #  cert_type
            #  ciphers
            #  s_client
            #  ciphers_openssl
            # not HTTP(S)
    {
        next if (not defined $_SSLinfo{$key});
        _verbose("$key=$_SSLinfo{$key}"); 
    }
    return;
} # _SSLinfo_print

#_____________________________________________________________________________
#______________________________________________________ public test methods __|

sub ssleay_methods  {
            # not yet
            #  cert_type
            #  ciphers
            #  s_client
            #  ciphers_openssl
    #? returns list of available Net::SSLeay::*_method; most important first
# TODO:  check for mismatch Net::SSLeay::*_method and Net::SSLeay::CTX_*_new
    my @list;
    # following sequence is important: most modern methods first; DTLS not yet important
    push(@list, 'TLSv1_3_method'  ) if (defined &Net::SSLeay::TLSv1_3_method);  # Net::SSLeay > 1.72
    push(@list, 'TLSv1_2_method'  ) if (defined &Net::SSLeay::TLSv1_2_method);
    push(@list, 'TLSv1_1_method'  ) if (defined &Net::SSLeay::TLSv1_1_method);
    push(@list, 'TLSv1_method'    ) if (defined &Net::SSLeay::TLSv1_method);
    push(@list, 'SSLv23_method'   ) if (defined &Net::SSLeay::SSLv23_method);
    push(@list, 'SSLv3_method'    ) if (defined &Net::SSLeay::SSLv3_method);
    push(@list, 'SSLv2_method'    ) if (defined &Net::SSLeay::SSLv2_method);
    push(@list, 'DTLSv1_3_method' ) if (defined &Net::SSLeay::DTLSv1_3_method); # Net::SSLeay > 1.72
    push(@list, 'DTLSv1_2_method' ) if (defined &Net::SSLeay::DTLSv1_2_method); # Net::SSLeay > 1.72
    push(@list, 'DTLSv1_1_method' ) if (defined &Net::SSLeay::DTLSv1_1_method); # Net::SSLeay > 1.72
    push(@list, 'DTLSv1_method'   ) if (defined &Net::SSLeay::DTLSv1_method);   # Net::SSLeay > 1.72
    push(@list, 'DTLS_method'     ) if (defined &Net::SSLeay::DTLS_method);     # Net::SSLeay > 1.72
    push(@list, 'CTX_tlsv1_3_new' ) if (defined &Net::SSLeay::CTX_tlsv1_3_new);
    push(@list, 'CTX_tlsv1_2_new' ) if (defined &Net::SSLeay::CTX_tlsv1_2_new);
    push(@list, 'CTX_tlsv1_1_new' ) if (defined &Net::SSLeay::CTX_tlsv1_1_new);
    push(@list, 'CTX_tlsv1_0_new' ) if (defined &Net::SSLeay::CTX_tlsv1_0_new);
    push(@list, 'CTX_tlsv1_new'   ) if (defined &Net::SSLeay::CTX_tlsv1_new);
    push(@list, 'CTX_v23_new'     ) if (defined &Net::SSLeay::CTX_v23_new);
    push(@list, 'CTX_v3_new'      ) if (defined &Net::SSLeay::CTX_v3_new);
    push(@list, 'CTX_v2_new'      ) if (defined &Net::SSLeay::CTX_v2_new);
    push(@list, 'CTX_new_with_method')  if (defined &Net::SSLeay::CTX_new_with_method);
    push(@list, 'CTX_new'         ) if (defined &Net::SSLeay::CTX_new);
    push(@list, 'CTX_dtlsv1_3_new') if (defined &Net::SSLeay::CTX_dtlsv1_3_new);
    push(@list, 'CTX_dtlsv1_2_new') if (defined &Net::SSLeay::CTX_dtlsv1_2_new);
    push(@list, 'CTX_dtlsv1_new'  ) if (defined &Net::SSLeay::CTX_dtlsv1_new);
    push(@list, 'CTX_get_options' ) if (defined &Net::SSLeay::CTX_get_options);
    push(@list, 'CTX_set_options' ) if (defined &Net::SSLeay::CTX_set_options);
    push(@list, 'CTX_set_timeout' ) if (defined &Net::SSLeay::CTX_set_timeout);
    push(@list, 'CTX_set_alpn_protos')  if (defined &Net::SSLeay::CTX_set_alpn_protos); # Net::SSLeay > 1.72 ??
    push(@list, 'CTX_set_next_proto_select_cb') if (defined &Net::SSLeay::CTX_set_next_proto_select_cb);
    return @list;
} # ssleay_methods

sub test_methods    {
    #? return openssl s_client availabilities (options for s_client)
    return join(" ", sort(ssleay_methods()));
} # test_methods

sub test_sclient    {
    #? return openssl s_client availabilities (options for s_client)
    return join(" ", sort(s_client_get_optionlist()) );
} # test_sclient

sub test_sslmap     {
    #? return internal data structure %_SSLmap
    my $line = "#---------------+--------+-------------";
    my $data = "$line\n# _SSLmap{ key    SSLeay  bitmask\n$line\n";
    foreach my $_ssl (sort keys %_SSLmap) {
        my $mask = "<<undef>>";
           $mask = $_SSLmap{$_ssl}[1] if defined $_SSLmap{$_ssl}[1];
        $data  .= sprintf("#%14s\t= 0x%04X  %s\n", $_ssl, $_SSLmap{$_ssl}[0], $mask);
    }
    $data .= "$line";
    return $data;
} # test_sslmap

sub test_ssleay     {
    #? return availability and information about Net::SSLeay
    ## no critic qw(ValuesAndExpressions::ProhibitImplicitNewlines)
    #  a here document is not possible here, or at least more cumbersome,
    #  because Perl code is used inside
    my @list = ssleay_methods();
    my $line = "#------------+------------------+-------------";
    my $data = "# Net::SSLeay{ function           1=available
$line
#            ::SSLv2_method     = " . ((grep{/^SSLv2_method$/}     @list) ? 1 : 0) . "
#            ::SSLv3_method     = " . ((grep{/^SSLv3_method$/}     @list) ? 1 : 0) . "
#            ::SSLv23_method    = " . ((grep{/^SSLv23_method$/}    @list) ? 1 : 0) . "
#            ::TLSv1_method     = " . ((grep{/^TLSv1_method$/}     @list) ? 1 : 0) . "
#            ::TLSv1_1_method   = " . ((grep{/^TLSv1_1_method$/}   @list) ? 1 : 0) . "
#            ::TLSv1_2_method   = " . ((grep{/^TLSv1_2_method$/}   @list) ? 1 : 0) . "
#{ following missing in Net::SSLeay (up to 1.72):
#            ::TLSv1_3_method   = " . ((grep{/^TLSv1_3_method$/}   @list) ? 1 : 0) . "
#            ::DTLSv1_method    = " . ((grep{/^DTLSv1_method$/}    @list) ? 1 : 0) . "
#            ::DTLSv1_2_method  = " . ((grep{/^DTLSv1_2_method$/}  @list) ? 1 : 0) . "
#            ::DTLS_method      = " . ((grep{/^DTLS_method$/}      @list) ? 1 : 0) . "
#}
#            ::CTX_new_with_method  = " . ((grep{/^CTX_new_with_method$/} @list) ? 1 : 0) . "
#            ::CTX_new          = " . ((grep{/^CTX_new$/}          @list) ? 1 : 0) . "
#            ::CTX_v2_new       = " . ((grep{/^CTX_v2_new$/}       @list) ? 1 : 0) . "
#            ::CTX_v3_new       = " . ((grep{/^CTX_v3_new$/}       @list) ? 1 : 0) . "
#            ::CTX_v23_new      = " . ((grep{/^CTX_v23_new$/}      @list) ? 1 : 0) . "
#            ::CTX_tlsv1_new    = " . ((grep{/^CTX_tlsv1_new$/}    @list) ? 1 : 0) . "
#            ::CTX_tlsv1_0_new  = " . ((grep{/^CTX_tlsv1_0_new$/}  @list) ? 1 : 0) . "
#            ::CTX_tlsv1_1_new  = " . ((grep{/^CTX_tlsv1_1_new$/}  @list) ? 1 : 0) . "
#            ::CTX_tlsv1_2_new  = " . ((grep{/^CTX_tlsv1_2_new$/}  @list) ? 1 : 0) . "
#            ::CTX_tlsv1_3_new  = " . ((grep{/^CTX_tlsv1_3_new$/}  @list) ? 1 : 0) . "
#            ::CTX_dtlsv1_new   = " . ((grep{/^CTX_dtlsv1_new$/}   @list) ? 1 : 0) . "
#            ::CTX_dtlsv1_2_new = " . ((grep{/^CTX_dtlsv1_2_new$/} @list) ? 1 : 0) . "
#            ::CTX_dtlsv1_3_new = " . ((grep{/^CTX_dtlsv1_3_new$/} @list) ? 1 : 0) . "
#            ::CTX_get_options  = " . ((grep{/^CTX_get_options$/}  @list) ? 1 : 0) . "
#            ::CTX_set_options  = " . ((grep{/^CTX_set_options$/}  @list) ? 1 : 0) . "
#            ::CTX_set_timeout  = " . ((grep{/^CTX_set_timeout$/}  @list) ? 1 : 0) . "
#            ::CTX_set_alpn_protos  = " . ((grep{/^CTX_set_alpn_protos$/}  @list) ? 1 : 0) . "
#            ::CTX_set_next_proto_select_cb = " . ((grep{/^CTX_set_next_proto_select_cb$/}  @list) ? 1 : 0) . "
$line
# Net::SSLeay} function\n";
    no warnings 'once'; ## no critic qw(TestingAndDebugging::ProhibitNoWarnings)
        # TODO: perl's strict is picky for OP_NO_DTLS* below
    $data .= "# Net::SSLeay{ constant           hex value
$line
#            ::OP_NO_SSLv2      = " . _ssleay_value_get('OP', *Net::SSLeay::OP_NO_SSLv2) . "
#            ::OP_NO_SSLv3      = " . _ssleay_value_get('OP', *Net::SSLeay::OP_NO_SSLv3) . "
#            ::OP_NO_TLSv1      = " . _ssleay_value_get('OP', *Net::SSLeay::OP_NO_TLSv1) . "
#            ::OP_NO_TLSv1_1    = " . _ssleay_value_get('OP', *Net::SSLeay::OP_NO_TLSv1_1)  . "
#            ::OP_NO_TLSv1_2    = " . _ssleay_value_get('OP', *Net::SSLeay::OP_NO_TLSv1_2)  . "
#            ::OP_NO_TLSv1_3    = " . _ssleay_value_get('OP', *Net::SSLeay::OP_NO_TLSv1_3)  . "
#            ::OP_NO_DTLSv09    = " . _ssleay_value_get('OP', *Net::SSLeay::OP_NO_DTLSv09)  . "
#            ::OP_NO_DTLSv1     = " . _ssleay_value_get('OP', *Net::SSLeay::OP_NO_DTLSv1)   . "
#            ::OP_NO_DTLSv1_1   = " . _ssleay_value_get('OP', *Net::SSLeay::OP_NO_DTLSv1_1) . "
#            ::OP_NO_DTLSv1_2   = " . _ssleay_value_get('OP', *Net::SSLeay::OP_NO_DTLSv1_2) . "
#            ::OP_NO_DTLSv1_3   = " . _ssleay_value_get('OP', *Net::SSLeay::OP_NO_DTLSv1_3) . "
$line
# Net::SSLeay} constant\n";
    $data .= "# Net::SSLeay{ call
#      experimental ...
# Net::SSLeay::CTX_new {
#            ::CTX_get_options(CTX)= " . _ssleay_value_get('options', *Net::SSLeay::CTX_new) . "
# Net::SSLeay::CTX_new }
# Net::SSLeay::CTX_v3_new {
#            ::CTX_get_options(CTX)= " . _ssleay_value_get('options', *Net::SSLeay::CTX_v3_new)  . "
# Net::SSLeay::CTX_v3_new }
# Net::SSLeay::CTX_v23_new {
#            ::CTX_get_options(CTX)= " . _ssleay_value_get('options', *Net::SSLeay::CTX_v23_new) . "
#            ::CTX_get_timeout(CTX)= " . _ssleay_value_get('timeout', *Net::SSLeay::CTX_v23_new) . "
#            ::CTX_get_verify_mode(CTX) = " . _ssleay_value_get('verify_mode',  *Net::SSLeay::CTX_v23_new) . "
#            ::CTX_get_verify_depth(CTX)= " . _ssleay_value_get('verify_depth', *Net::SSLeay::CTX_v23_new) . "
# Net::SSLeay::CTX_v23_new }
# Net::SSLeay::CTX_tlsv1_2_new {
#            ::CTX_get_options(CTX)= " . _ssleay_value_get('options', *Net::SSLeay::CTX_tlsv1_2_new) . "
#            ::CTX_get_timeout(CTX)= " . _ssleay_value_get('timeout', *Net::SSLeay::CTX_tlsv1_2_new) . "
#            ::CTX_get_verify_mode(CTX) = " . _ssleay_value_get('verify_mode',  *Net::SSLeay::CTX_tlsv1_2_new) . "
#            ::CTX_get_verify_depth(CTX)= " . _ssleay_value_get('verify_depth', *Net::SSLeay::CTX_tlsv1_2_new) . "
# Net::SSLeay::CTX_tlsv1_2_new }
# Net::SSLeay} call\n";

    return $data;
} # test_ssleay

sub _dump           {
    my $key = shift;
    my $txt = shift;
    my $val = shift;
    return sprintf("#{ %-12s=%s%s #}\n", $key, $txt, ($val || "<<undefined>>"));
} # _dump

sub datadump        {
    #? return internal data structure
    my $prefix  = shift;    # get prefix as parameter
    my $data    = $prefix;
       $data   .= " datadump #{\n";
    if ($Net::SSLinfo::use_sclient > 1) {
       $data   .= _dump('s_client', " ", $_SSLinfo{'s_client'});
    } else {
       $data   .= _dump('s_client', " ", "#### please set 'Net::SSLinfo::use_sclient > 1' to dump s_client data also ###");
    }
    $data .= _dump('PEM',     " ", $_SSLinfo{'PEM'});
    $data .= _dump('text',    " ", $_SSLinfo{'text'});
    $data .= _dump('ciphers', " ", join(' ', @{$_SSLinfo{'ciphers'}}));
    $data .= _dump('addr',    " ", join('.', unpack('W4', $_SSLinfo{'addr'}||"")));  # pretty print IP
    foreach my $key (sort keys %_SSLinfo) { # SEE Note:Testing, sort
        next if ($key =~ m/addr|ciphers|errors|PEM|text|fingerprint_|s_client/); # handled special
        if ($key =~ m/$_SSLinfo_random/) {  # handled special
            if (defined $ENV{'OSAFT_MAKE'}) {
                # SEE Make:OSAFT_MAKE (in Makefile.pod)
                # ugly hack here, but simplifies testing with make; however, this code is for debugging only
                $data .= _dump($key, " ", $_SSLinfo_random_text);
                next;
            }
        }
        $data .= _dump($key, " ", $_SSLinfo{$key});
    }
    foreach my $key (sort keys %_SSLinfo) { # SEE Note:Testing, sort
        next if ($key !~ m/fingerprint_/);
        $data .= _dump($key, " ", $_SSLinfo{$key});
    }
    $data .= _dump('errors',  "\n", join("\n ** ", @{$_SSLinfo{'errors'}}));
    $data .= "$Net::SSLinfo::prefix_trace$prefix datadump #}"; # quick&dirty global prefix_trace
    return $data;
} # datadump

#_____________________________________________________________________________
#______________________________________________ internal SSL helper methods __|

### _OpenSSL_opt_get()  defined later to avoid forward declaration

sub _SSLinfo_get    {
    # get specified value from %_SSLinfo, first parameter 'key' is mandatory
    my ($key, $host, $port) = @_;
    _traceset();
    _trace("_SSLinfo_get('$key'," . ($host||'') . "," . ($port||'') . ")");
    if ($key eq 'ciphers_openssl') {
        _trace("_SSLinfo_get($key): WARNING: function obsolete, please use cipher_openssl()");
        return '';
    }
    if ($key eq 'errors') { # always there, no need to connect target
        #src = Net::SSLeay::ERR_peek_error;      # just returns number
        #src = Net::SSLeay::ERR_peek_last_error; # should work since openssl 0.9.7
        return wantarray ? @{$_SSLinfo{$key}} : join("\n", @{$_SSLinfo{$key}});
    }
    if (not defined $_SSLinfo{'ssl'}) {
        # if-condition only to avoid multiple calls, improves performance and produces less trace output
        return '' if not defined do_ssl_open($host, $port, '');
    }
    if ($key eq 'ciphers') { # special handling
        return wantarray ? @{$_SSLinfo{$key}} : join(' ', @{$_SSLinfo{$key}});
        return wantarray ? @{$_SSLinfo{$key}} : join(':', @{$_SSLinfo{$key}}); # if we want `openssl ciphers' format
    }
    if ($key eq 'dates') {
       _trace("_SSLinfo_get 'dates'=" . $_SSLinfo{'before'} . " " . $_SSLinfo{'after'});
        return ( $_SSLinfo{'before'}, $_SSLinfo{'after'});
    }
    if (0 < $trace) {
        # prepare data to be printed by trace_()
        my $value = $_SSLinfo{$key} || '';
           $value = "<<use --trace=2 to print data>>" if ($value =~ m/[\r\n]/);
        _trace("_SSLinfo_get '$key'=$value");
    }
    return (grep{/^$key$/} keys %_SSLinfo) ? $_SSLinfo{$key} : '';
} # _SSLinfo_get

#
# general internal functions
#

sub _check_host     {
    #? convert hostname to IP and store in $_SSLinfo{'host'}, returns 1 on success
    my $host = shift;
    _trace("_check_host(" . ($host||'') . ")");
    $host  = $_SSLinfo{'host'} unless defined $host;
    my $ip = undef;
    if($ip = gethostbyname($host)) {    # check result of assignment!
        $_SSLinfo{'host'} = $host;
        $_SSLinfo{'addr'} = $ip;
        $_SSLinfo{'ip'}   = join('.', unpack('W4', $ip));
    } else {
        push(@{$_SSLinfo{'errors'}}, "_check_host: $!");
    }
    _trace("_check_host $_SSLinfo{'host'} $_SSLinfo{'ip'}");
    #dbx# _trace("_check_host =" . ((defined $ip) ? 1 : undef));
    return (defined $ip) ? 1 : undef;
} # _check_host

sub _check_port     {
    #? convert port name to number and store in $_SSLinfo{'port'}, returns 1 on success
    my $port = shift;
    _trace("_check_port(" . ($port||'') . ")");
    $port  = $_SSLinfo{'port'} unless defined $port;
    $port  = getservbyname($port, 'tcp') unless $port =~ /^\d+$/;
    push(@{$_SSLinfo{'errors'}}, "_check_port: $!") if ($! !~ m/^\s*$/);
    $_SSLinfo{'port'} = $port if (defined $port);
    #dbx# _trace("_check_port =$port");
    return (defined $port) ? 1 : undef;
} # _check_port

sub _check_peer     {
    # TBD
    my ($ok, $x509_store_ctx) = @_;
    _trace("_check_peer($ok, $x509_store_ctx)");
    $_SSLinfo{'verify_cnt'} += 1;
    return $ok;
} # _check_peer

sub _check_crl      {
    # TBD
    my $ssl = shift;
    _trace("_check_crl()");
    return;
} # _check_crl

sub _check_client_cert {print "##check_client_cert\n"; return; }
#$my $err = Net::SSLeay::set_verify ($ssl, Net::SSLeay::VERIFY_CLIENT_ONCE, \&_check_client_cert );

sub _ssleay_cert_get    {
    #? get specified value from SSLeay certificate
        # wrapper to get data provided by certificate
        # note that all these function may produce "segmentation fault" or alike if
        # the target does not have/use a certificate but allows connection with SSL
    my ($key, $x509) = @_;
    _traceset();
    _trace("_ssleay_cert_get('$key', x509)");
    if (0 != $Net::SSLinfo::no_cert) {
        _trace("_ssleay_cert_get 'use_cert' $Net::SSLinfo::no_cert .");
        return $Net::SSLinfo::no_cert_txt if (2 == $Net::SSLinfo::no_cert);
        return '';
    }

    if (not $x509) {
        # ugly check to avoid "Segmentation fault" if $x509 is 0 or undef
        return $Net::SSLinfo::no_cert_txt if ($key =~ m/^(PEM|version|md5|sha1|sha2|subject|issuer|before|after|serial_hex|cn|policies|error_depth|cert_type|serial|altname)/); ## no critic qw(RegularExpressions::ProhibitComplexRegexes)
    }

    return Net::SSLeay::PEM_get_string_X509(     $x509) || ''   if ($key eq 'PEM');
    return Net::SSLeay::X509_get_version(        $x509) + 1     if ($key eq 'version');
    return Net::SSLeay::X509_get_fingerprint(    $x509,  'md5') if ($key eq 'md5');
    return Net::SSLeay::X509_get_fingerprint(    $x509, 'sha1') if ($key eq 'sha1');
    return Net::SSLeay::X509_get_fingerprint(  $x509, 'sha256') if ($key eq 'sha2');
    return Net::SSLeay::X509_NAME_oneline(        Net::SSLeay::X509_get_subject_name($x509)) if ($key eq 'subject');
    return Net::SSLeay::X509_NAME_oneline(        Net::SSLeay::X509_get_issuer_name( $x509)) if ($key eq 'issuer');
    return Net::SSLeay::P_ASN1_UTCTIME_put2string(Net::SSLeay::X509_get_notBefore(   $x509)) if ($key eq 'before');
    return Net::SSLeay::P_ASN1_UTCTIME_put2string(Net::SSLeay::X509_get_notAfter(    $x509)) if ($key eq 'after');
    return Net::SSLeay::P_ASN1_INTEGER_get_hex(Net::SSLeay::X509_get_serialNumber(   $x509)) if ($key eq 'serial_hex');
    return Net::SSLeay::X509_NAME_get_text_by_NID(
                    Net::SSLeay::X509_get_subject_name($x509), &Net::SSLeay::NID_commonName) if ($key eq 'cn');
    return Net::SSLeay::X509_NAME_get_text_by_NID(
                    Net::SSLeay::X509_get_subject_name($x509), &Net::SSLeay::NID_certificate_policies) if ($key eq 'policies');
    return Net::SSLeay::X509_STORE_CTX_get_error_depth($x509)   if ($key eq 'error_depth');
    return Net::SSLeay::X509_certificate_type(         $x509)   if ($key eq 'cert_type');
    return Net::SSLeay::X509_subject_name_hash(        $x509)   if ($key eq 'subject_hash');
    return Net::SSLeay::X509_issuer_name_hash(         $x509)   if ($key eq 'issuer_hash');

    my $ret = '';
    if ($key =~ 'serial') {
#dbx# print "#SERIAL# $key #\n";
# TODO: dead code as Net::SSLeay::X509_get_serialNumber() does not really return an integer
        $ret = Net::SSLeay::P_ASN1_INTEGER_get_hex(Net::SSLeay::X509_get_serialNumber(   $x509));
        return $ret if($key eq 'serial_hex');
        my $int = hex($ret);
        return $int if($key eq 'serial_int');
        return "$int (0x$ret)"; # if($key eq 'serial');
    }

    if ($key eq 'altname') {
        my @altnames = Net::SSLeay::X509_get_subjectAltNames($x509); # returns array of (type, string)
        _trace2("_ssleay_cert_get: Altname: " . join(' ', @altnames));
        while (@altnames) {             # construct string like openssl
            my ($type, $name) = splice(@altnames, 0, 2);
            # TODO: replace ugly code by %_SSLtypemap
            $type = 'DNS'           if ($type eq '2');
            $type = 'URI'           if ($type eq '6');
            $type = 'X400'          if ($type eq '3');
            $type = 'DIRNAME'       if ($type eq '4');
            $type = 'EDIPARTY'      if ($type eq '5');
            $type = 'IPADD'         if ($type eq '7');
            $type = 'RID'           if ($type eq '8');
            $type = 'email'         if ($type eq '1');
            $name = '<<undefined>>' if(($type eq '0') && ($name!~/^/));
            $type = 'othername'     if ($type eq '0');
            $name = join('.', unpack('W4', $name)) if ($type eq 'IPADD');
            # all other types are used as is, so we see what's missing
            $ret .= ' ' . join(':', $type, $name);
        }
    }
    _trace("_ssleay_cert_get '$key'=$ret");  # or warn "$OSaft::Text::STR{WARN} wrong key '$key' given; ignored";
    return $ret;
} # _ssleay_cert_get

sub _ssleay_socket  {
    #? craete TLS socket or use given socket
    # side-effects: uses $Net::SSLinfo::starttls, $Net::SSLinfo::proxyhost  ::proxyport
    my $host    = shift;
    my $port    = shift;
    my $socket  = shift;
    my $src     = '';   # function (name) where something failed
    my $err     = '';
    my $dum     = '';
    _traceset();
    _trace("_ssleay_socket(" . ($host||'') . "," . ($port||'') . ")");
    return $socket if (defined $socket);
    local $! = undef;   # avoid using cached error messages

    TRY: {
        unless (($Net::SSLinfo::starttls) || ($Net::SSLinfo::proxyhost)) {
               # $Net::SSLinfo::proxyport was already checked in main
            #1a. no proxy and not starttls
            # $host and $port may be undefined, hence the ugly setting of $src
            # to avoid Perl's "Use of uninitialized value $host in concatenation ... "
            # _check_host() and _check_port() woll work poper with undef values
            $src = '_check_host(' . ($host||'') . ')'; if (not defined _check_host($host)) { $err = $!; last; }
            $src = '_check_port(' . ($port||'') . ')'; if (not defined _check_port($port)) { $err = $!; last; }
            $src = 'socket()';
                    socket( $socket, &AF_INET, &SOCK_STREAM, 0) or do {$err = $!} and last;
            $src = 'connect()';
            $dum=()=connect($socket, sockaddr_in($_SSLinfo{'port'}, $_SSLinfo{'addr'})) or do {$err = $!} and last;
        } else {
            #1b. starttls or via proxy
            require Net::SSLhello;      # ok here, as perl handles multiple includes proper
            Net::SSLhello::version() if (1 < $trace); # TODO: already done in _yeast_init()
            $src = 'Net::SSLhello::openTcpSSLconnection()';
            # open TCP connection via proxy and do STARTTLS if requested
            # NOTE that $host cannot be checked here because the proxy does
            # DNS and also has the routes to the host
            ($socket = Net::SSLhello::openTcpSSLconnection($host, $port)) or do {$err = $!} and last;
        }
        ## no critic qw(InputOutput::ProhibitOneArgSelect)
        select($socket); local $| = 1; select(STDOUT);  # Eliminate STDIO buffering
        ## use critic
        return $socket;
    }; # TRY
    push(@{$_SSLinfo{'errors'}}, "_ssleay_socket() failed calling $src: $err");
    _trace("_ssleay_socket retu=undef");
    return;
} # _ssleay_socket

sub _ssleay_ctx_new {
    #? get SSLeay CTX object; returns ctx object or undef
    my $method  = shift;# CTX method to be used for creating object
    my $ctx     = undef;# CTX object to be created
    my $ssl     = undef;
    my $src     = '';   # function (name) where something failed
    my $err     = '';
    my $old     = '';
    _traceset();
    _trace("_ssleay_ctx_new($method)");
    $src = "Net::SSLeay::$method";
    _trace("_ssleay_ctx_new: $src");
    local $! = undef;   # avoid using cached error messages

    TRY: {
        # no proper generic way to replace following ugly SWITCH code, however: it's save
        # calling function already checked for CTX_*  and  *_method, but we do
        # not have the information (aka result from ssleay_methods()) here, so
        # we need to check for existance of  *_method  again
        # CTX_* (i.e. CTX_v23_new) returns an object, errors are on error stack
        # last gets out of TRY block
        $_   = $method; # { # SWITCH
        /CTX_tlsv1_3_new/  && do {
            #2.1. prepare SSL's context object
            ($ctx = Net::SSLeay::CTX_tlsv1_3_new()) or last;# create object
            #2.2. set default protocol version
            if (defined &Net::SSLeay::TLSv1_3_method) {
                $src = 'Net::SSLeay::CTX_set_ssl_version(TLSv1_3_method)';
                Net::SSLeay::CTX_set_ssl_version($ctx, Net::SSLeay::TLSv1_3_method()) or do {$err = $!} and last;
                # allow all versions for backward compatibility; user specific
                # restrictions are done later with  CTX_set_options()
                $src = '';  # push error on error stack at end of SWITCH
            } else {
                $src = 'Net::SSLeay::TLSv1_3_method()';
            }
        };
        /CTX_tlsv1_2_new/  && do {
            ($ctx = Net::SSLeay::CTX_tlsv1_2_new()) or last;
            if (defined &Net::SSLeay::TLSv1_2_method) {
                $src = 'Net::SSLeay::CTX_set_ssl_version(TLSv1_2_method)';
                Net::SSLeay::CTX_set_ssl_version($ctx, Net::SSLeay::TLSv1_2_method()) or do {$err = $!} and last;
                $src = '';
            } else {
                $src = 'Net::SSLeay::TLSv1_2_method()';
            }
            # default timeout is 7200
        };
        /CTX_tlsv1_1_new/  && do {
            ($ctx = Net::SSLeay::CTX_tlsv1_1_new()) or last;
            if (defined &Net::SSLeay::TLSv1_1_method) {
                $src = 'Net::SSLeay::CTX_set_ssl_version(TLSv1_1_method)';
                Net::SSLeay::CTX_set_ssl_version($ctx, Net::SSLeay::TLSv1_1_method()) or do {$err = $!} and last;
                $src = '';
            } else {
                $src = 'Net::SSLeay::TLSv1_1_method()';
            }
        };
        /CTX_tlsv1_new/    && do {
            ($ctx = Net::SSLeay::CTX_tlsv1_new()) or last;
            if (defined &Net::SSLeay::TLSv1_method) {
                $src = 'Net::SSLeay::CTX_set_ssl_version(TLSv1_method)';
                Net::SSLeay::CTX_set_ssl_version($ctx, Net::SSLeay::TLSv1_method())   or do {$err = $!} and last;
                $src = '';
            } else {
                $src = 'Net::SSLeay::TLSv1_2_method()';
            }
        };
        /CTX_v23_new/      && do {
            # we use CTX_v23_new() 'cause of CTX_new() sets SSL_OP_NO_SSLv2
            ($ctx = Net::SSLeay::CTX_v23_new()) or last;
            if (defined &Net::SSLeay::SSLv23_method) {
                $src = 'Net::SSLeay::CTX_set_ssl_version(SSLv23_method)';
                Net::SSLeay::CTX_set_ssl_version($ctx, Net::SSLeay::SSLv23_method())  or do {$err = $!} and last;
                $src = '';
            } else {
                $src = 'Net::SSLeay::SSLv23_method()';
            }
            # default timeout is 300
        };
        /CTX_v3_new/       && do {
            ($ctx = Net::SSLeay::CTX_v3_new()) or last;
            if (defined &Net::SSLeay::SSLv3_method) {
                $src = 'Net::SSLeay::CTX_set_ssl_version(SSLv3_method)';
                Net::SSLeay::CTX_set_ssl_version($ctx, Net::SSLeay::SSLv3_method())   or do {$err = $!} and last;
                $src = '';
            } else {
                $src = 'Net::SSLeay::SSLv3_method()';
            }
        };
        /CTX_v2_new/       && do {
            ($ctx = Net::SSLeay::CTX_v2_new()) or last;
            if (defined &Net::SSLeay::SSLv2_method) {
                $src = 'Net::SSLeay::CTX_set_ssl_version(SSLv2_method)';
                Net::SSLeay::CTX_set_ssl_version($ctx, Net::SSLeay::SSLv2_method())   or do {$err = $!} and last;
                $src = '';
            } else {
                $src = 'Net::SSLeay::SSLv2_method()';
            }
        };
        /CTX_dtlsv1_3_new/ && do {
        };
        /CTX_dtlsv1_2_new/ && do {
        };
        /CTX_dtlsv1_1_new/ && do {
        };
        /CTX_dtlsv1_new/   && do {
        };
        #} # SWITCH
        return if (not $ctx); # no matching method, ready
        $_SSLinfo{'CTX_method'} = $method;  # for debugging only
        if ('' ne $src) {
            # setting protocol options failed (see SWITCH above)
            push(@{$_SSLinfo{'errors'}}, "_ssleay_ctx_new() WARNING '$src' not available, using system default for '$method'");
            # if we don't have proper  *_method(), we better use the system's
            # default behaviour, because anything else  would stick  on the
            # specified protocol version, like SSLv3_method()
        }
        #2.3. set protocol options
        my  $options  = &Net::SSLeay::OP_ALL;
            # sets all options, even those for all protocol versions (which are removed later)
        if (0 < $Net::SSLinfo::no_compression) {
            $options |= &Net::SSLeay::OP_NO_COMPRESSION;
            # default:  OP_ALL does not contain OP_NO_COMPRESSION
            # this is ok as we want to detect if targets support compression,
            # disabling compression must be requested with special option
        }
            #test# # quick$dirty disable SSL_OP_TLSEXT_PADDING 0x00000010L (see ssl.h)
            #test# $options ^= 0x00000010;
            # OP_CIPHER_SERVER_PREFERENCE, OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION
            # should also be set now
        $src = 'Net::SSLeay::CTX_set_options()';
            #   Net::SSLeay::CTX_set_options(); # can not fail according description!
                Net::SSLeay::CTX_set_options($ctx, 0); # reset options
                Net::SSLeay::CTX_set_options($ctx, $options);
        $src = 'Net::SSLeay::CTX_set_timeout()';
        ($old = Net::SSLeay::CTX_set_timeout($ctx, $Net::SSLinfo::timeout_sec)) or do {$err = $!; } and last;
        _trace("_ssleay_ctx_new ::CTX_get_session_cache_mode(CTX)= " . sprintf('0x%08x', Net::SSLeay::CTX_get_session_cache_mode($ctx)));
        _trace("_ssleay_ctx_new ::CTX_get_timeout(CTX)= $old -> " . Net::SSLeay::CTX_get_timeout($ctx));
        _trace("_ssleay_ctx_new ::CTX_get_options(CTX)= " . sprintf('0x%08x', Net::SSLeay::CTX_get_options($ctx)));
        _traceSSLbitmasks(
               SSLINFO . "::_ssleay_ctx_new CTX options",
               Net::SSLeay::CTX_get_options($ctx)
              ) if (0 < $trace);
        _trace("_ssleay_ctx_new: $ctx");
        return $ctx;
    } # TRY
    # reach here if ::CTX_* failed
    push(@{$_SSLinfo{'errors'}}, "_ssleay_ctx_new() failed calling $src: $err");
    _trace("_ssleay_ctx_new ret=undef");
    return;
} # _ssleay_ctx_new

sub _ssleay_ctx_ca  {
    #? set certificate verify options (client mode); returns undef on failure
    #  uses settings from $Net::SSLinfo::ca*
    my $ctx     = shift;
    my $ssl     = undef;
    my $src     = '';   # function (name) where something failed
    my $err     = '';
    my $cafile  = '';
    my $capath  = '';
    _traceset();
    _trace("_ssleay_ctx_ca($ctx)");
    TRY: {
        Net::SSLeay::CTX_set_verify($ctx, &Net::SSLeay::VERIFY_NONE, \&_check_peer);
            # we're in client mode where only  VERYFY_NONE  or  VERYFY_PEER  is
            # used; as we want to get all information,  even if something  went
            # wrong, we use VERIFY_NONE so we can proceed collecting data
            # possible values:
            #  0 = SSL_VERIFY_NONE
            #  1 = SSL_VERIFY_PEER
            #  2 = SSL_VERIFY_FAIL_IF_NO_PEER_CERT
            #  4 = SSL_VERIFY_CLIENT_ONCE
# TODO: SSL_OCSP_NO_STAPLE
        $src = 'Net::SSLeay::CTX_load_verify_locations()';
        $cafile = $Net::SSLinfo::ca_file || '';
        if ($cafile !~ m#^(?:[a-zA-Z0-9_,.\\/()-])*$#) {
            $err = "invalid characters for " . '$Net::SSLinfo::ca_file; not used';
            last;
        }
        $capath = $Net::SSLinfo::ca_path || '';
        if ($capath !~ m#^(?:[a-zA-Z0-9_,.\\/()-]*)$#) {
            $err = "invalid characters for " . '$Net::SSLinfo::ca_path; not used';
            last;
        }
        if (($capath . $cafile) ne '') { # CTX_load_verify_locations() fails if both are empty
            Net::SSLeay::CTX_load_verify_locations($ctx, $cafile, $capath) or do {$err = $!} and last;
            # CTX_load_verify_locations()  sets SSLeay's error stack,  which is
            # roughly the same as $!
        }
        $src = 'Net::SSLeay::CTX_set_verify_depth()';
        if (defined $Net::SSLinfo::ca_depth) {
            if ($Net::SSLinfo::ca_depth !~ m/^[0-9]$/) {
                $err = "invalid value '$Net::SSLinfo::ca_depth' for " . '$Net::SSLinfo::ca_depth; not used';
                last;
            }
            Net::SSLeay::CTX_set_verify_depth($ctx, $Net::SSLinfo::ca_depth);
        }
        # TODO: certificate CRL
        # just code example, not yet tested
        #
        # enable Net::SSLeay CRL checking:
        #   &Net::SSLeay::X509_STORE_set_flags
        #       (&Net::SSLeay::CTX_get_cert_store($ssl),
        #        &Net::SSLeay::X509_V_FLAG_CRL_CHECK);
        return 1; # success
    } # TRY
    push(@{$_SSLinfo{'errors'}}, "_ssleay_ctx_ca() failed calling $src: $err");
    _trace("_ssleay_ctx_ca ret=undef");
    return;
} # _ssleay_ctx_ca

sub _ssleay_ssl_new {
    #? create new SSL object; return SSL object or undef
    #  uses $Net::SSLinfo::use_SNI
    my $ctx     = shift;
    my $host    = shift;
    my $socket  = shift;
    my $cipher  = shift;
    my $ssl     = undef;
    my $src     = '';   # function (name) where something failed
    my $err     = '';
    _traceset();
    _trace("_ssleay_ssl_new($ctx)");
    TRY: {
        #3. prepare SSL object
        $src = 'Net::SSLeay::new()';
        ($ssl=  Net::SSLeay::new($ctx))                        or do {$err = $!} and last;
        $src = 'Net::SSLeay::set_fd()';
                Net::SSLeay::set_fd($ssl, fileno($socket))     or do {$err = $!} and last;
        $src = "Net::SSLeay::set_cipher_list($cipher)";
                Net::SSLeay::set_cipher_list($ssl, $cipher)    or do {$err = $!} and last;
        if (0 < $Net::SSLinfo::use_SNI) {
            my $sni  = $Net::SSLinfo::sni_name;
            _trace("_ssleay_ssl_new: SNI");
            if (1.45 <= $Net::SSLeay::VERSION) {
                $src = 'Net::SSLeay::set_tlsext_host_name()';
                Net::SSLeay::set_tlsext_host_name($ssl, $sni)  or do {$err = $!} and last;
            } else {
                # quick&dirty instead of:
                #  use constant SSL_CTRL_SET_TLSEXT_HOSTNAME => 55
                #  use constant TLSEXT_NAMETYPE_host_name    => 0
                $src = 'Net::SSLeay::ctrl()';
                Net::SSLeay::ctrl($ssl, 55, 0, $sni)           or do {$err = $!} and last;
                # TODO: ctrl() sometimes fails but does not return errors, reason yet unknown
            }
        }
        return $ssl;
    } # TRY
    push(@{$_SSLinfo{'errors'}}, "_ssleay_ssl_new() failed calling $src: $err");
    _trace("_ssleay_ssl_new ret=undef");
    return;
} # _ssleay_ssl_new

sub _ssleay_ssl_np  {
    #? sets CTX for ALPN and/or NPN if possible
    # returns -1 on success, otherwise array with errors
    # Note: check if functionality is available should be done before,
    #       for defensive programming, it's done here again
    # Note  that parameters are different: ALPN array ref. vs. NPN array
    my $ctx         = shift;
    my $protos_alpn = shift;
    my $protos_npn  = shift;
    my @protos_alpn = split(/,/, $protos_alpn); # Net::SSLeay wants a list
    my @protos_npn  = split(/,/, $protos_npn);
    _trace("_ssleay_ssl_np(ctx, $protos_alpn, $protos_npn)");
    my $src;
    my @err;
    # functions return 0 on success, hence: && do{} to catch errors
    # ALPN (Net-SSLeay > 1.55, openssl >= 1.0.2)
    if ($protos_alpn !~ m/^\s*$/) {
        if (exists &Net::SSLeay::CTX_set_alpn_protos) {
            $src = 'Net::SSLeay::CTX_set_alpn_protos()';
            Net::SSLeay::CTX_set_alpn_protos($ctx, [@protos_alpn]) && do {
                push(@err, "_ssleay_ssl_np(),alpn failed calling $src: $!");
            };
        }
    }
    # NPN  (Net-SSLeay > 1.45, openssl >= 1.0.1)
    if ($protos_npn !~ m/^\s*$/) {
        if (exists &Net::SSLeay::CTX_set_next_proto_select_cb) {
            $src = 'Net::SSLeay::CTX_set_next_proto_select_cb()';
            Net::SSLeay::CTX_set_next_proto_select_cb($ctx, @protos_npn) && do {
                push(@err, "_ssleay_ssl_np(),npn  failed calling $src: $!");
            };
        }
    }
    _trace("_ssleay_ssl_np err=$#err");
    return @err;
} # _ssleay_ssl_np

sub _header_get     {
    #? get value for specified header from given HTTP response; empty if not exists
    my $head    = shift;   # header to search for
    my $response= shift; # response where to serach
    my $value   = '';
    _trace("__header_get('$head', <<response>>)");
    if ($response =~ m/[\r\n]$head\s*:/i) {
        $value  =  $response;
        $value  =~ s/.*?[\r\n]$head\s*:\s*([^\r\n]*).*$/$1/ims;
    }
    return $value;
} # _header_get

sub _openssl_MS     {
    #? wrapper to call external openssl executable on windows
    my $mode = shift;   # must be openssl command
    my $host = shift;   # '' if not used
    my $port = shift;   # '' if not used
    my $text = shift;   # text to be piped to openssl
    my $data = '';
    return '' if ($^O !~ m/MSWin32/);

    _trace("_openssl_MS($mode, $host, $port)");
    if ('' eq $_openssl) {
        _trace("_openssl_MS($mode): WARNING: no openssl");
        return SSLINFO_HASH;
    }
    $host .= ':' if ($port ne '');
    $text = '""' if (not defined $text);
    chomp $text;
    $text = '""' if ($text !~ /[\r\n]/);
        # $data = `echo '$text' | $_openssl $mode ... 2>&1`;
        # windows hangs even with empty STDIN, hence we use cmd.exe always
    # convert multiple lines to an echo for each line
    $text =~ s/\n/\n echo /g;
    $text = "(echo $text)"; # it's a subshell now with multiple echo commands
    my $err = '';
    my $src = 'open';
    my $tmp = '.\\_yeast.bat'; # do not use $ENV{'TMP'} as it can be empty or unset
    _trace2("_openssl_MS $mode $host$port: cmd.exe /D /C /S $tmp");
    TRY: {
        my $fh;
        open($fh, '>', $tmp)                or do {$err = $!} and last;
        print $fh "$text | $_openssl $mode $host$port 2>&1";
        close($fh);
        #dbx# print `cat $tmp`;
        $src = 'cmd.exe';
        ($data =  `cmd.exe /D /S /C $tmp`)  or do {$err = $!} and last; ## no critic qw(InputOutput::ProhibitBacktickOperators)
        $src = 'unlink';
        unlink  $tmp                        or do {$err = $!} and last;
         $data =~ s#^[^)]*[^\r\n]*.##s;          # remove cmd.exe's output
         $data =~ s#WARN.*?openssl.cnf[\r\n]##;  # remove WARNINGs
        _trace2("_openssl_MS $mode $host$port : $data #");
    }
    if ('' ne $err) {
        $text = "_openssl_MS() failed calling $src: $err";
        _trace2($text);
        push(@{$_SSLinfo{'errors'}}, $text);
        return '';
    }
    return $data;
} # _openssl_MS

sub _openssl_x509   {
    #? call external openssl executable to retrive more data from PEM
    my $pem  = shift;
    my $mode = shift;   # must be one of openssl x509's options
    my $data = '';
    _trace("_openssl_x509($mode,...)");
    _setcmd();
    if ($_openssl eq '') {
        _trace("_openssl_x509($mode): WARNING: no openssl");
        return SSLINFO_HASH;
    }
    if ('' eq $pem) {
        # if PEM is empty, openssl may return an error like:
        # unable to load certificate
        # 140593914181264:error:0906D06C:PEM routines:PEM_read_bio:no start line:pem_lib.c:701:Expecting: TRUSTED CERTIFICATE
        _trace("_openssl_x509($mode): WARNING: no PEM");
        return $Net::SSLinfo::no_cert_txt;
    }

######## 4/2021
# TODO: external openssl is called for every $mode to extract some data from
#       the given $pem.  In practice openssl "simply extracts" the requested
#       information $mode from the textual representation of $pem.
# idea: convert $pem once to text ($mode==-text), then all other data can be
#       extracted from that text; results in one external openssl call.
# currently 4/2021 openssl is call ca. 13 times
# see more comments labeled 14apr21
########

    #if ($mode =~ m/^-(text|email|modulus|serial|fingerprint|subject_hash|trustout)$/) {
    #   # supported by openssl's x509 (0.9.8 and higher)
    #}
    if ($mode =~ m/^-?(version|pubkey|signame|sigdump|aux|extensions)$/) {
        # openssl works the other way around:
        #   define as -certopt what should *not* be printed
        # hence we use a list with all those no_* options and remove that one
        # which should be printed
        my $m =  'no_' . $mode;
        $mode =  '-text -certopt no_header,no_version,no_serial,no_signame,no_validity,no_subject,no_issuer,no_pubkey,no_sigdump,no_aux,no_extensions,ext_default,ext_dump';
            # ca_default   not used as it's already in $_SSLinfo{'text'}
        $mode =~ s/$m//;
        $mode =~ s/,,/,/;  # need to remove , also, otherwise we get everything
    }
    if ($mode =~ m/^-?ocsp/) {
        $mode = "x509 $mode";
        # openssl x509 -ocspid returns data only without noout, probably a bug
    } else {
        $mode = "x509 -noout $mode";
    }
    if (1 < $trace) {
        _trace("_openssl_x509: openssl $mode < '$pem'");
    } else {
        _trace("_openssl_x509: openssl $mode");
    }
    if ($^O !~ m/MSWin32/) {
        $data = `echo '$pem' | $_openssl $mode 2>&1`; ## no critic qw(InputOutput::ProhibitBacktickOperators)
    } else { # it's sooooo simple, except on Windows :-(
        $data = _openssl_MS($mode, '', '', $pem);
    }
    chomp $data;
    $data =~ s/\n?-----BEGIN.*$//s if ( $mode =~ m/ -ocsp/); # see above
    $data =~ s/\s*$//;  # be sure ...
    $data =~ s/\s*Version:\s*//i if (($mode =~ m/ -text /) && ($mode !~ m/version,/)); # ugly test for version
    #_dbx# print "#3 $data \n#3";
    _trace2("_openssl_x509 '$mode'=$data");
    return $data;
} # _openssl_x509

#_____________________________________________________________________________
#__________________________________________________________________ methods __|

=pod

=head2 s_client_check()

Check if specified openssl executable is available and check capabilities of
"s_client"  command..
Returns  undef  if openssl is not available.

=head2 s_client_get_optionlist

Get list of options for openssl s_client command. Returns array.

=head2 s_client_opt_get($option)

Returns 1 if specified option is available for openssl s_client.

=cut

sub s_client_check  {
    #? store capabilities of "openssl s_client" command in %_OpenSSL_opt
    return 1 if (0 < $_OpenSSL_opt{'done'});
    _traceset();
    _trace("s_client_check()");
    _setcmd();
    if ('' eq $_openssl) {
        _trace("s_client_check(): WARNING: no openssl");
        return undef; ## no critic qw(Subroutines::ProhibitExplicitReturnUndef)
    }

    # check with "openssl s_client --help" where --help most likely is unknown
    # and hence forces the usage message which will be analysed
    # Note: following checks asume that the  returned usage properly describes
    #       openssl's capabilities
    # Partial example of output:
    # unknown option --help
    # usage: s_client args
    #
    #  -host host     - use -connect instead
    #  -port port     - use -connect instead
    #  -connect host:port - who to connect to (default is localhost:4433)
    #  -proxy host:port - use HTTP proxy to connect
    #...
    #  -CApath arg   - PEM format directory of CA's
    #  -CAfile arg   - PEM format file of CA's
    #  -reconnect    - Drop and re-make the connection with the same Session-ID
    #  -pause        - sleep(1) after each read(2) and write(2) system call
    #  -debug        - extra output
    #  -msg          - Show protocol messages
    #  -nbio_test    - more ssl protocol testing
    #  -psk_identity arg - PSK identity
    #  -psk arg      - PSK in hex (without 0x)
    #  -fallback_scsv - send TLS_FALLBACK_SCSV
    #  -bugs         - Switch on all SSL implementation bug workarounds
    #...
    #  -servername host  - Set TLS extension servername in ClientHello
    #  -tlsextdebug      - hex dump of all TLS extensions received
    #  -status           - request certificate status from server
    #  -no_ticket        - disable use of RFC4507bis session tickets
    #  -serverinfo types - send empty ClientHello extensions
    #  -curves arg       - Elliptic curves to advertise
    #  -sigalgs arg      - Signature algorithms to support
    #  -nextprotoneg arg - enable NPN extension
    #  -alpn arg         - enable ALPN extension
    #  -legacy_renegotiation - enable use of legacy renegotiation
    #  -no_tlsext        - Don't send any TLS extensions
    #
    if ($^O =~ m/MSWin32/) {
        $_OpenSSL_opt{'data'} = _openssl_MS('s_client -help', '', '', '');  # no host:port
    } else {
        $_OpenSSL_opt{'data'} = qx($_openssl s_client -help 2>&1);  ## no critic qw(InputOutput::ProhibitBacktickOperators)
    }
    #_trace("data{ $_OpenSSL_opt{'data'} }";

    # store data very simple: set value to 1 if option appears in output
    foreach my $key (sort keys %_OpenSSL_opt) {
        next if ($key !~ m/^-/);    # ensure that only options are set
        $_OpenSSL_opt{$key} = grep{/^ *$key\s/} split("\n", $_OpenSSL_opt{'data'}); # returns 1 or 0
    }
    $_OpenSSL_opt{'-npn'} = $_OpenSSL_opt{'-nextprotoneg'}; # -npn is an alias
    $_OpenSSL_opt{'done'} = 1;
    _trace("s_client_check ret=1");
    return 1;
} # s_client_check

sub _OpenSSL_opt_get{
    #? get specified value from %_OpenSSL_opt, parameter 'key' is mandatory
    my $key = shift;
    _traceset();
    if (0 <= $_OpenSSL_opt{'done'}) {
        # initialise %_OpenSSL_opt
        if (not defined s_client_check()) {
            _trace("_OpenSSL_opt_get('$key') undef");
            return SSLINFO_HASH;
        }
    }
    _trace("_OpenSSL_opt_get('$key')=" . ($_OpenSSL_opt{$key} || 0));
    return (grep{/^$key$/} keys %_OpenSSL_opt) ? $_OpenSSL_opt{$key} : '';
} # _OpenSSL_opt_get

sub s_client_get_optionlist { return (grep{/^-/} keys %_OpenSSL_opt); }

sub s_client_opt_get{ return _OpenSSL_opt_get(shift); }

=pod

=head2 do_ssl_free($ctx,$ssl,$socket)

Destroy and free L<Net::SSLeay> allocated objects.
=cut

sub do_ssl_free     {
    #? free SSL objects of NET::SSLeay TCP connection
    my ($ctx, $ssl, $socket) = @_;
    close($socket)              if (defined $socket);
    Net::SSLeay::free($ssl)     if (defined $ssl); # or warn "$OSaft::Text::STR{WARN} Net::SSLeay::free(): $!";
    Net::SSLeay::CTX_free($ctx) if (defined $ctx); # or warn "$OSaft::Text::STR{WARN} Net::SSLeay::CTX_free(): $!";
    return;
} # do_ssl_free

=pod

=head2 do_ssl_new($host,$port,$sslversions[,$cipherlist,$alpns,$npns,$socket])

Establish new SSL connection using L<Net::SSLeay>.

Returns array with $ssl object, $ctx object, $socket and CTX $method.
Errors, if any, are stored in $_SSLtemp{'errors'}.

This method is thread safe according the limitations described in L<Net::SSLeay>.
Use L<do_ssl_free($ctx,$ssl,$socket)> to free allocated objects.
=cut

sub do_ssl_new      {   ## no critic qw(Subroutines::ProhibitManyArgs)
    my ($host, $port, $sslversions, $cipher, $protos_alpn, $protos_npn, $socket) = @_;
    my $ctx     = undef;
    my $ssl     = undef;
    my $method  = undef;
    my $src;            # function (name) where something failed
    my $err     = '';   # error string, if any, from sub-system $src
    my $tmp_sock= undef;# newly opened socket,
                        # Note: $socket is only used to check if it is defined
    my $dum     = undef;
    $cipher     = '' if (not defined $cipher);      # cipher parameter is optional
    $protos_alpn= '' if (not defined $protos_alpn); # -"-
    $protos_npn = '' if (not defined $protos_npn);  # -"-
    _traceset();
    _trace("do_ssl_new(" . ($host||'') . ',' . ($port||'') . ',' . ($sslversions||'') . ','
                       . ($cipher||'') . ',' . ($protos_alpn||'') . ',socket)');
    _SSLtemp_reset();   # assumes that handles there are already freed

    TRY: {

        # TRY_PROTOCOL: {
        # Open TCP connection and innitilise SSL connection.
        # This nitialisation is done with Net::SSLeay's CTX_*_new and *_method
        # methods (i.e. CTX_tlsv1_2_new and TLSv1_2_method).
        # Remember the concepts: work with ancient (perl, openssl) installations
        # Hence we try all known methods, starting with the most modern first.
        # The list of methods and its sequence is provided by  ssleay_methods.
        # We loop over this list of methods (aka protocols) until a valid  CTX
        # object will be returned.
        # NOTE: _ssleay_ctx_new() gets $ctx_new but also needs *_method, which
        #       is not passed as argument.  Hence  _ssleay_ctx_new()  needs to
        #       check for it again, ugly ... may change in future ...
        #
        # Some servers (godaddy.com 11/2016) behave strange if the socket will
        # be reused. In particular they respond with an TLS Alert, complaining
        # that the protocol is not allowed (alert message 70).
        # * Until Version 17.03.17
        #   The socket (if it exists) will be closed and then reopend.
        # FIXME: 11/2016:  not tested if the $Net::SSLinfo::socket is provided
        #        by the caller
        # * Version 17.04.17
        #   Socket opened only if it is undef; the caller is responsibel for a
        #   proper $socket value.

        my @list = ssleay_methods();
        foreach my $ctx_new (@list) {
            next if ($ctx_new !~ m/^CTX_/);
            next if ($ctx_new =~ m/CTX_new$/);  # CTX_new
            next if ($ctx_new =~ m/_method$/);  # i.e. CTX_new_with_method
            next if ($ctx_new =~ m/_options$/); # i.e. CTX_get_options
            next if ($ctx_new =~ m/_timeout$/); # i.e. CTX_set_timeout
            $method = $ctx_new;
            _trace("do_ssl_new: $method ...");
            $src = $ctx_new;

            #0. first reset Net::SSLeay objects if they exist
            do_ssl_free($ctx, $ssl, $tmp_sock);
            $ctx        = undef;
            $ssl        = undef;
            $tmp_sock   = undef;

            #1a. open TCP connection; no way to continue if it fails
            ($tmp_sock = _ssleay_socket($host, $port, $tmp_sock)) or do {$src = '_ssleay_socket()'} and last TRY;
            # TODO: need to pass ::starttls, ::proxyhost and ::proxyport

            #1b. get SSL's context object
            ($ctx = _ssleay_ctx_new($ctx_new))  or do {$src = '_ssleay_ctx_new()'} and next;

            #1c. disable not specified SSL versions, limit as specified by user
            foreach my $_ssl (sort keys %_SSLmap) {
                # $sslversions  passes the version which should be supported,  but
                # openssl and hence Net::SSLeay, configures what  should *not*  be
                # supported, so we skip all versions found in  $sslversions
                next if ($sslversions =~ m/^\s*$/); # no version given, leave default
                next if (grep{/^$_ssl$/} split(/ /, $sslversions));
                my $bitmask = _SSLbitmask_get($_ssl);
                if (defined $bitmask) {        # if there is a bitmask, disable this version
                    _trace("do_ssl_new: OP_NO_$_ssl");  # NOTE: constant name *not* as in ssl.h
                    Net::SSLeay::CTX_set_options($ctx, $bitmask);
                }
                #$Net::SSLeay::ssl_version = 2;  # Insist on SSLv2
                #  or =3  or =10  seems not to work, reason unknown, hence CTX_set_options() above
            }
# TODO: Client-Cert see smtp_tls_cert.pl
# TODO: proxy settings work in HTTP mode only
##Net::SSLeay::set_proxy('some.tld', 84, 'z00', 'pass');
##print "#ERR= $!";

            #1d. set certificate verification options
            ($dum = _ssleay_ctx_ca($ctx))       or do {$src = '_ssleay_ctx_ca()' } and next;

            #1e. set ALPN and NPN option
            my @err = _ssleay_ssl_np($ctx, $protos_alpn, $protos_npn);
            if (0 < $#err) {     # somthing failed, just collect errors
                push(@{$_SSLtemp{'errors'}}, @err);
            }

            #1f. prepare SSL object
            ($ssl = _ssleay_ssl_new($ctx, $host, $tmp_sock, $cipher)) or do {$src = '_ssleay_ssl_new()'} and next;

            #1g. connect SSL
            local $SIG{PIPE} = 'IGNORE';        # Avoid "Broken Pipe"
            my $ret;
            $src = 'Net::SSLeay::connect() ';
            $ret =  Net::SSLeay::connect($ssl); # may call _check_peer() ..
            if (0 > $ret) {
                $src .= " failed start with $ctx_new()"; # i.e. no matching protocol
                $err  = $!;
                push(@{$_SSLtemp{'errors'}}, "do_ssl_new() $src: $err");
                next;
            }
            # following check only if requested; fails to often
            if ($Net::SSLinfo::ignore_handshake <= 0){
              if (0 == $ret) {
                $src .= " failed handshake with $ctx_new()";
                $err  = $!;
                push(@{$_SSLtemp{'errors'}}, "do_ssl_new() $src: $err");
                next;
              }
            }
            $src = '';
            last;
        } # TRY_PROTOCOL }
        if ('' eq $src) {
            # avoid printing empty line, hence "if -1 < $#"
            _trace(join("\n" . SSLINFO_ERR . ' ', '', @{$_SSLtemp{'errors'}})) if (-1 < $#{$_SSLtemp{'errors'}});
            _trace(" errors reseted.");
            @{$_SSLtemp{'errors'}} = ();        # messages no longer needed
            goto finished;
        } else {
            # connection failed (see TRY_PROTOCOL above)
            push(@{$_SSLtemp{'errors'}}, "do_ssl_new() connection failed in '$src': $err");
            $src = " failed to connect";
            last;
        }
        #goto finished if (not $ctx); # TODO: not yet properly tested 11/2016
        _trace("do_ssl_new: $method");

    } # TRY

    # error handling
    close($tmp_sock) if (defined $tmp_sock);
    push(@{$_SSLtemp{'errors'}}, "do_ssl_new() failed calling $src: $err");
    if (1 < $trace) {
        Net::SSLeay::print_errs(SSLINFO_ERR);
        print SSLINFO_ERR . $_ foreach @{$_SSLtemp{'errors'}};
    }
    _trace("do_ssl_new() failed.");
    return;

    finished:
    _trace("do_ssl_new() done.");
    return wantarray ? ($ssl, $ctx, $tmp_sock, $method) : $ssl;
} # do_ssl_new

=pod

=head2 do_ssl_open($host,$port,$sslversions[,$cipherlist])

Opens new SSL connection with Net::SSLeay and stores collected data.

I<$sslversions> is space-separated list of SSL versions to be used. Following
strings are allowed for versions: C<SSLv2 SSLv3 TLSv1 TLSv11 TLSv12 DTLSv1>.
If I<$sslversions> is empty, the system's default settings of versions are used.
If I<$cipherlist> is missing or empty, default C<ALL:NULL:eNULL:aNULL:LOW> will be used.

Returns array with $ssl object and $ctx object.

This method is called automatically by all other functions, hence no need to
call it directly.

Use L<do_ssl_close($host,$port)> to free allocated objects.

This method tries to use the most modern methods provided by Net::SSLeay to
establish the connections, i.e. CTX_tlsv1_2_new or CTX_v23_new. If a method
is not available,  the next one will be used.  The sequence of used methods
is hardcoded with most modern first. The current sequence can be seen with:

C<perl -MNet::SSLinfo -le 'print join"\n",Net::SSLinfo::ssleay_methods();'>
=cut

# from openssl/x509_vfy.h
sub _X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT () { return 18; }
sub _FLAGS_ALLOW_SELFSIGNED () { return 0x00000001; }

sub do_ssl_open($$$@) {
    my ($host, $port, $sslversions, $cipher) = @_;
    $cipher = '' if (not defined $cipher);  # cipher parameter is optional
    #$port   = _check_port($port);
        # TODO: port may be empty for some calls; results in "... uninitialised
        #       value $port ..."; need to check if call can provide a port
        #       mainly happens if called with --ignore-no-connect
    _traceset();
    _trace("do_ssl_open(" . ($host||'') . "," . ($port||'') . "," . ($sslversions||'') . "," . ($cipher||'') . ")");
    goto finished_return if (defined $_SSLinfo{'ssl'});
    #_traceSSLbitmasks(
    #    SSLINFO . "::do_ssl_open SSL version bitmask",
    #    &Net::SSLeay::OP_ALL
    #) if (0 < $trace);
    # TODO: no real value for _traceSSLbitmasks() 

    $Net::SSLinfo::target_url =~ s:^\s*$:/:;# set to / if empty
    _verbose("do_ssl_open " . ($host||'') . ":" . ($port||'') . $Net::SSLinfo::target_url );
    #_SSLinfo_reset(); # <== does not work yet as it clears everything
    if ($cipher =~ m/^\s*$/) {
        $cipher = $_SSLinfo{'cipherlist'};
    } else {
        $_SSLinfo{'cipherlist'} = $cipher;
    }
    _trace("do_ssl_open cipherlist: $_SSLinfo{'cipherlist'}");
    my $ctx     = undef;
    my $ssl     = undef;
    my $socket  = undef;
    my $method  = undef;
    my $src;            # function (name) where something failed
    my $err     = '';   # error string, if any, from sub-system $src

    # initialise %_OpenSSL_opt
    $src = 's_client_check';
    if (0 < $Net::SSLinfo::use_openssl) {
        if (not defined s_client_check()) {
            push(@{$_SSLinfo{'errors'}}, "do_ssl_open() WARNING $src: undefined");
       }
    }

    {
      no warnings;  ## no critic (TestingAndDebugging::ProhibitNoWarnings)
      if (defined $Net::SSLinfo::next_protos) { # < 1.182
        warn("$OSaft::Text::STR{WARN} 090: Net::SSLinfo::next_protos no longer supported, please use Net::SSLinfo::protos_alpn instead");
      }
    }

    TRY: {

        #0. first reset Net::SSLinfo objects if they exist
        # note that $ctx and $ssl is still local and not in %_SSLinfo
        Net::SSLeay::free($ssl)      if (defined $ssl);
        Net::SSLeay::CTX_free($ctx)  if (defined $ctx);
        if (1 > $Net::SSLinfo::socket_reuse) {
            close($Net::SSLinfo::socket) if (defined $Net::SSLinfo::socket);
            $Net::SSLinfo::socket = undef;
        }

        #1. open TCP connection; no way to continue if it fails
        $src = 'Net::SSinfo::do_ssl_new()';
        ($ssl, $ctx, $socket, $method) = do_ssl_new($host, $port, $sslversions,
               $cipher, $Net::SSLinfo::protos_alpn, $Net::SSLinfo::protos_npn,
               $Net::SSLinfo::socket);
        if (not defined $ssl) { $err = 'undef $ssl'; last; }
        if (not defined $ctx) { $err = 'undef $ctx'; last; }
        $_SSLinfo{'ctx'}      = $ctx;
        $_SSLinfo{'ssl'}      = $ssl;
        $_SSLinfo{'method'}   = $method;
        $Net::SSLinfo::method = $method;
        $Net::SSLinfo::socket = $socket;
        push(@{$_SSLinfo{'errors'}}, @{$_SSLtemp{'errors'}});
        _trace("do_ssl_open: $Net::SSLinfo::method");

#print "### ext= ". Net::SSLeay::get_tlsext_status_type($ssl);

        # from here on mainly IO::Socket::SSL is used from within Net::SSLeay
        # using Net::SSLeay::trace is most likely same as IO::Socket::SSL::DEBUG
        #dbx# $Net::SSLeay::trace     = 2;
        #dbx# $IO::Socket::SSL::DEBUG = 1;
        #dbx# Net::SSLeay::print_errs();

        #5. SSL established, let's get information
        # TODO: starting from here implement error checks
        $src = 'Net::SSLeay::get_peer_certificate()';
        my $x509= Net::SSLeay::get_peer_certificate($ssl);
            # $x509 may be undef or 0; this may cause "Segmentation fault"s in
            # some Net::SSLeay::X509_* methods; hence we always use _ssleay_cert_get

        #5a. get internal data
        # Some values may be overwritten below (see %match_map below).
        $_SSLinfo{'x509'}       = $x509;
        $_SSLinfo{'_options'}  .= sprintf("0x%016x", Net::SSLeay::CTX_get_options($ctx)) if $ctx;
        $_SSLinfo{'SSLversion'} = $_SSLhex{Net::SSLeay::version($ssl)};
            # TODO: Net::SSLeay's documentation also has:
            #    get_version($ssl); get_cipher_version($ssl);
            # but they are not implemented (up to 1.49)
        $_SSLinfo{'session_protocol'}   = $_SSLinfo{'SSLversion'};
        $_SSLinfo{'session_starttime'}  = Net::SSLeay::SESSION_get_time($ssl);
        $_SSLinfo{'session_timeout'}    = Net::SSLeay::SESSION_get_timeout($ssl);

        #5b. store actually used ciphers for this connection
        my $i   = 0;
        my $c   = '';
        push(@{$_SSLinfo{'ciphers'}}, $c) while ($c = Net::SSLeay::get_cipher_list($ssl, $i++));
        $_SSLinfo{'selected'}   = Net::SSLeay::get_cipher($ssl);
            # same as above:      Net::SSLeay::CIPHER_get_name(Net::SSLeay::get_current_cipher($ssl));

        #5c. store certificate information
        $_SSLinfo{'certificate'}= Net::SSLeay::dump_peer_certificate($ssl);  # same as issuer + subject
        #$_SSLinfo{'master_key'} = Net::SSLeay::SESSION_get_master_key($ssl); # TODO: returns binary, hence see below
        $_SSLinfo{'PEM'}        = _ssleay_cert_get('PEM',     $x509);
            # 'PEM' set empty for example when $Net::SSLinfo::no_cert is in use
            # this inhibits warnings inside perl (see  NO Certificate  below)
        $_SSLinfo{'subject'}    = _ssleay_cert_get('subject', $x509);
        $_SSLinfo{'issuer'}     = _ssleay_cert_get('issuer',  $x509);
        $_SSLinfo{'before'}     = _ssleay_cert_get('before',  $x509);
        $_SSLinfo{'after'}      = _ssleay_cert_get('after',   $x509);
        $_SSLinfo{'policies'}   = _ssleay_cert_get('policies',$x509);
        if (1.45 <= $Net::SSLeay::VERSION) {
            $_SSLinfo{'version'}= _ssleay_cert_get('version', $x509);
        } else {
            warn("$OSaft::Text::STR{WARN} 651: Net::SSLeay >= 1.45 required for getting version");
        }
        if (1.33 <= $Net::SSLeay::VERSION) {# condition stolen from IO::Socket::SSL,
            $_SSLinfo{'altname'}= _ssleay_cert_get('altname', $x509);
        } else {
            warn("$OSaft::Text::STR{WARN} 652: Net::SSLeay >= 1.33 required for getting subjectAltNames");
        }
        if (1.30 <= $Net::SSLeay::VERSION) {# condition stolen from IO::Socket::SSL
            $_SSLinfo{'cn'}     = _ssleay_cert_get('cn', $x509);
            $_SSLinfo{'cn'}     =~ s{\0$}{};# work around Bug in Net::SSLeay <1.33 (from IO::Socket::SSL)
        } else {
            warn("$OSaft::Text::STR{WARN} 653: Net::SSLeay >= 1.30 required for getting commonName");
        }
        if (1.45 <= $Net::SSLeay::VERSION) {
            $_SSLinfo{'fingerprint_md5'} = _ssleay_cert_get('md5',  $x509);
            $_SSLinfo{'fingerprint_sha1'}= _ssleay_cert_get('sha1', $x509);
            $_SSLinfo{'fingerprint_sha2'}= _ssleay_cert_get('sha2', $x509);
        } else {
            warn("$OSaft::Text::STR{WARN} 654: Net::SSLeay >= 1.45 required for getting fingerprint_md5");
        }
        if (1.46 <= $Net::SSLeay::VERSION) {# see man Net::SSLeay
            #$_SSLinfo{'pubkey_value'}   = Net::SSLeay::X509_get_pubkey($x509);
                # TODO: returns a structure, needs to be unpacked
            $_SSLinfo{'error_verify'}   = Net::SSLeay::X509_verify_cert_error_string(Net::SSLeay::get_verify_result($ssl));
            $_SSLinfo{'error_depth'}    = _ssleay_cert_get('error_depth', $x509);
            $_SSLinfo{'serial_hex'}     = _ssleay_cert_get('serial_hex',  $x509);
            $_SSLinfo{'cert_type'}      = sprintf("0x%x  <<experimental>>", _ssleay_cert_get('cert_type', $x509) || 0);
            $_SSLinfo{'subject_hash'}   = sprintf("%x", _ssleay_cert_get('subject_hash', $x509) || 0);
            $_SSLinfo{'issuer_hash'}    = sprintf("%x", _ssleay_cert_get('issuer_hash',  $x509) || 0);
                # previous two values are integers, need to be converted to
                # hex, we omit a leading 0x so they can be used elswhere
        } else {
            warn("$OSaft::Text::STR{WARN} 655: Net::SSLeay >= 1.46 required for getting some certificate checks");
        }
        $_SSLinfo{'commonName'} = $_SSLinfo{'cn'};
        $_SSLinfo{'authority'}  = $_SSLinfo{'issuer'};
        $_SSLinfo{'owner'}      = $_SSLinfo{'subject'};
            # used by IO::Socket::SSL, allow for compatibility and lazy user
            #   owner commonName cn subject issuer authority subjectAltNames
            #   alias: owner == subject, issuer == authority, commonName == cn

        # TODO: certificate chain depth, OCSP
        # see: http://search.cpan.org/~mikem/Net-SSLeay-1.68/lib/Net/SSLeay.pod#Certificate_verification_and_Online_Status_Revocation_Protocol_%28OCSP%29

        #5d. get OSCP related data
# TODO: related constants
#        TLSEXT_STATUSTYPE_ocsp V_OCSP_CERTSTATUS_GOOD V_OCSP_CERTSTATUS_REVOKED
#        V_OCSP_CERTSTATUS_UNKNOWN
# TODO: check if supported
#        if (not exists &Net::SSLeay::OCSP_cert2ids) { $cfg{'ssleay'}->{'can_ocsp'} = 0 }
#        # same as IO::Socket::SSL::can_ocsp() IO::Socket::SSL::can_ocsp_staple()
# TODO:
	 # see:https://mojolicious.org/perldoc/Net/SSLeay (same as)
         #     https://metacpan.org/pod/release/MIKEM/Net-SSLeay-1.81/lib/Net/SSLeay.pod
         # # Extract OCSP_RESPONSE.
         # my $resp = eval { Net::SSLeay::d2i_OCSP_RESPONSE($content) };

         # # Check status of response.
         # my $status = Net::SSLeay::OCSP_response_status($resp);
         # if ($status != Net::SSLeay::OCSP_RESPONSE_STATUS_SUCCESSFUL())
         # die "OCSP response failed: " .  Net::SSLeay::OCSP_response_status_str($status);

         # # set TLS extension before doing SSL_connect
         # Net::SSLeay::set_tlsext_status_type($ssl, Net::SSLeay::TLSEXT_STATUSTYPE_ocsp());

        #5e. get data related to HTTP(S)
        if (0 < $Net::SSLinfo::use_https) {
            _trace("do_ssl_open HTTPS {");
            #dbx# $host .= 'x'; # TODO: <== some servers behave strange if a wrong hostname is passed
            # TODO: test with a browser User-Agent
            my $ua = "User-Agent: Mozilla/5.0 (quark rv:52.0) Gecko/20100101 Firefox/52.0";
            my $response = '';
            my $request  = "GET $Net::SSLinfo::target_url HTTP/1.1\r\n";
               $request .= "Host: $host\r\nConnection: close\r\n\r\n";
# $t1 = time();
#           ($ctx = Net::SSLeay::CTX_v23_new()) or do {$src = 'Net::SSLeay::CTX_v23_new()'} and last;
            # FIXME: need to find proper method instead hardcoded CTX_v23_new(); see _ssleay_ctx_new
            #dbx# $Net::SSLeay::trace     = 2;
            $src = 'Net::SSLeay::write()';
#print "#dbx $request\n";
            Net::SSLeay::write($ssl, $request) or {$err = $!} and last;
            $src = 'Net::SSLeay::ssl_read_all()';
            # use ::ssl_read_all() instead of ::read() to get HTTP body also
            $response = Net::SSLeay::ssl_read_all($ssl) || "<<GET failed>>";
            _trace("do_ssl_open: request $host:$port");
            if (1 == $trace) {
                _trace("do_ssl_open: request  #{<<use --trace=2 to print data>>#}");
                _trace("do_ssl_open: response #{\n$response #}") if ($response =~ m/<<GET failed/); # always
                _trace("do_ssl_open: response #{<<use --trace=2 to print data>>#}");
            } else {
                # matches $trace==0 too; that's ok as handled correctly in _trace()
                _trace2("do_ssl_open: request  #{\n$request");  _trace("do_ssl_open request #}");
                _trace2("do_ssl_open: response #{\n$response"); _trace("do_ssl_open response #}");
            }
            if ($response =~ /handshake_failed/) {  # may get: http2_handshake_failed
                $response = "<<HTTP handshake failed>>";
                # no last; # as it will break checks outside
            }
            if ($response =~ /bad client magic byte string/) {  # http2_handshake_failed
                # dirty hack with goto
                #$Net::SSLinfo::protos_alpn = "";
                #goto TRY;
                $response =  "<<Received bad client magic byte string>>";
            }
# TODO: Net::SSLeay::read() fails sometimes, i.e. for fancyssl.hboeck.de
# 03/2015: even using ssl_write_all() and ssl_read_all() does not help
# TODO: reason unknown, happens probably if server requires SNI
# $t2 = time(); set error = "<<timeout: Net::SSLeay::read()>>";
            $_SSLinfo{'https_body'}     =  $response;
            $_SSLinfo{'https_body'}     =~ s/.*?\r\n\r\n(.*)/$1/ms;
            $_SSLinfo{'https_location'} =  _header_get('Location', $response);
                # if a new Location is send for HTTPS, we should not follow
            $_SSLinfo{'https_status'}   =  $response;
            $_SSLinfo{'https_status'}   =~ s/[\r\n].*$//ms; # get very first line
            $_SSLinfo{'https_server'}   =  _header_get('Server',   $response);
            $_SSLinfo{'https_refresh'}  =  _header_get('Refresh',  $response);
            $_SSLinfo{'https_pins'}     =  _header_get('Public-Key-Pins',    $response);
            $_SSLinfo{'https_protocols'}=  _header_get('Alternate-Protocol', $response);
            $_SSLinfo{'https_svc'}      =  _header_get('Alt-Svc',  $response);
            $_SSLinfo{'https_svc'}      .= _header_get('X-Firefox-Spdy',     $response);
            $_SSLinfo{'https_sts'}      =  _header_get('Strict-Transport-Security', $response);
            $_SSLinfo{'hsts_httpequiv'} =  $_SSLinfo{'https_body'};
            $_SSLinfo{'hsts_httpequiv'} =~ s/.*?(http-equiv=["']?Strict-Transport-Security[^>]*).*/$1/ims;
            $_SSLinfo{'hsts_httpequiv'} = '' if ($_SSLinfo{'hsts_httpequiv'} eq $_SSLinfo{'https_body'});
            $_SSLinfo{'hsts_maxage'}    =  $_SSLinfo{'https_sts'};
            $_SSLinfo{'hsts_maxage'}    =~ s/.*?max-age=([^;" ]*).*/$1/i;
            $_SSLinfo{'hsts_subdom'}    = 'includeSubDomains' if ($_SSLinfo{'https_sts'} =~ m/includeSubDomains/i);
            $_SSLinfo{'hsts_preload'}   = 'preload' if ($_SSLinfo{'https_sts'} =~ m/preload/i);
# TODO:     $_SSLinfo{'hsts_alerts'}    =~ s/.*?((?:alert|error|warning)[^\r\n]*).*/$1/i;
# TODO: HTTP header:
#    X-Firefox-Spdy: 3.1
#    X-Firefox-Spdy: h2             (seen at policy.mta-sts.google.com 9/2016)
#           X-Firefox-Spdy  most likely returned only for proper User-Agent
            _trace("do_ssl_open HTTPS }");
        }
        if (0 < $Net::SSLinfo::use_http) {
            _trace("do_ssl_open HTTP {");   # HTTP uses its own connection ...
            my %headers;
            my $response = '';
            my $request  = '';
            _trace("do_ssl_open ::use_http: $Net::SSLinfo::use_http");
            # TODO: add 'Authorization:'=>'Basic ZGVtbzpkZW1v',
            # NOTE: Net::SSLeay always sets  Accept:*/*
            $src = 'Net::SSLeay::get_http()';
            ($response, $_SSLinfo{'http_status'}, %headers) =
                Net::SSLeay::get_http($host, 80, $Net::SSLinfo::target_url,
                  Net::SSLeay::make_headers(
                        'Host'       => $host,
                        'Connection' => 'close',
                  )
                  # TODO: test with a browser User-Agent
                  # 'User-Agent' => 'Mozilla/5.0 (quark rv:52.0) Gecko/20100101 Firefox/52.0';
                );
            # NOTE that get_http() returns all keys in %headers capitalised
            my $headers = "";   # for trace only
            foreach my $h (sort keys %headers) { $headers .= "$h: $headers{$h}\n"; }
            _trace("do_ssl_open: request $host:$port");
            if (1 == $trace) {
                _trace("do_ssl_open: request  #{<<use --trace=2 to print data>>#}");
                _trace("do_ssl_open: response #{\n$response #}") if ($response =~ m/<<GET failed/); # always
                _trace("do_ssl_open: response #{<<use --trace=2 to print data>>#}");
            } else {
                # matches $trace==0 too; that's ok as handled correctly in _trace()
                _trace2("do_ssl_open: request  #{\n$request");  _trace("do_ssl_open request #}");
                _trace2("do_ssl_open: response #{\n$response"); _trace("do_ssl_open response #}");
            }
                # Net::SSLeay 1.58 (and before)
                # Net::SSLeay::get_http() may return:
                # Read error: Connection reset by peer (,199725) at blib/lib/Net/SSLeay.pm (autosplit into blib/lib/auto/Net/SSLeay/tcp_read_all.al) line 535.
                # Read error: Die Verbindung wurde vom Kommunikationspartner zurückgesetzt (,199725) at blib/lib/Net/SSLeay.pm (autosplit into blib/lib/auto/Net/SSLeay/tcp_read_all.al) line 535.
                #
                # Unfortunately in this case  Net::SSLeay::ERR_get_error is 0
                # and  Net::SSLeay::print_errs()  returns nothing even the error
		# is present as string (according current locale) in $!.
                # It still may return a response and a status, hence there is
                # need to handle it special as the check for the status below
                # already does the work.
		# The error is printed by Net/SSLeay, and cannot be omitted.
                #
                # Following error ocours (Net::SSLeay 1.58) when _http() failed:
                # Use of uninitialised value $headers in split at blib/lib/Net/SSLeay.pm (autosplit into blib/lib/auto/Net/SSLeay/do_httpx2.al) line 1291.

# $t3 = time(); set error = "<<timeout: Net::SSLeay::get_http()>>";
            if ($_SSLinfo{'http_status'} =~ m:^HTTP/... ([1234][0-9][0-9]|500) :) {
                # TODO: not tested if following grep() catches multiple occourances
                $_SSLinfo{'http_location'}  =  $headers{(grep{/^Location$/i} keys %headers)[0] || ''};
                $_SSLinfo{'http_refresh'}   =  $headers{(grep{/^Refresh$/i}  keys %headers)[0] || ''};
                $_SSLinfo{'http_sts'}       =  $headers{(grep{/^Strict-Transport-Security$/i} keys %headers)[0] || ''};
                $_SSLinfo{'http_svc'}       =  $headers{(grep{/^Alt-Svc$/i}  keys %headers)[0] || ''} || '';
                $_SSLinfo{'http_svc'}      .=  $headers{(grep{/^X-Firefox-Spdy$/i}    keys %headers)[0] || ''} || '';
                $_SSLinfo{'http_protocols'} =  $headers{(grep{/^Alternate-Protocol/i} keys %headers)[0] || ''};
                # TODO: http_protocols somtimes fails, reason unknown (03/2015)
            } else { # any status code > 500
                #no print "$OSaft::Text::STR{WARN} http:// connection refused; consider using --no-http"; # no print here!
                push(@{$_SSLinfo{'errors'}}, "do_ssl_open WARNING $src: " . $_SSLinfo{'http_status'});
                if ($_SSLinfo{'http_status'} =~ m:^HTTP/... (50[12345]) :) {
                    # If we get status 50x, there is most likely a (local)
                    # proxy which is not able to connect to the target.
                    # This could either be 'cause the target refuses the
                    # connection (status 503 and 504) or 'cause the proxy
                    # itself has a problem.
                    # HTTP headers and response may contain more hints.
                    push(@{$_SSLinfo{'errors'}}, "do_ssl_open WARNING $src: check HTTP gateway");
                #} else { Net::SSLeay::get_http() most likely returns status 900
                }
                $response = ''; # avoid uninitialised value later
            }
            _trace("do_ssl_open HTTP }");
        }

        if (0 == $Net::SSLinfo::use_openssl) {
            # calling external openssl is a performance penulty
            # it would be better to manually parse $_SSLinfo{'text'} but that
            # needs to be adapted to changes of openssl's output then
            _trace("do_ssl_open without openssl done.");
            goto finished;
        }

        #5f. get data from openssl, if required
        # NOTE: all following are only available when openssl is used
        #       those alredy set before will be overwritten

        # NO Certificate {
        # We get following data using openssl executable.
        # There is no need  to check  $Net::SSLinfo::no_cert  as openssl is
        # clever enough to return following strings if the cert is missing:
        #         unable to load certificate
        # If we use  'if (defined $_SSLinfo{'PEM'}) '  instead of an empty
        # $_SSLinfo{'PEM'}  (see initial setting above),  then  all values
        # would contain an empty string instead of the the openssl warning:
        #         unable to load certificate
# 14apr21 my $cert = Net::SSLeay::get_peer_certificate($ssl);
# 14apr21 my $id = eval { Net::SSLeay::OCSP_cert2ids($ssl,$cert) };
# 14apr21 my $id = Net::SSLeay::OCSP_cert2ids($ssl,$cert) ;
# 14apr21 print "#### ID $id ";
# 14apr21 print "#### PEM=$_SSLinfo{'PEM'} ";
        my $fingerprint                 = _openssl_x509($_SSLinfo{'PEM'}, '-fingerprint');
        chomp $fingerprint;
        $_SSLinfo{'fingerprint_text'}   = $fingerprint;
        $_SSLinfo{'fingerprint'}        = $fingerprint; #alias
       ($_SSLinfo{'fingerprint_type'},  $_SSLinfo{'fingerprint_hash'}) = split(/=/, $fingerprint);
        $_SSLinfo{'fingerprint_type'}   = $Net::SSLinfo::no_cert_txt if (not defined $_SSLinfo{'fingerprint_type'});
        $_SSLinfo{'fingerprint_hash'}   = $Net::SSLinfo::no_cert_txt if (not defined $_SSLinfo{'fingerprint_hash'});
        $_SSLinfo{'fingerprint_type'}   =~ s/\s+.*$//;
        $_SSLinfo{'fingerprint_type'}   =~ s/(^[^\s]*).*/$1/ if (m/^[^\s]*/);  # TODO: ugly check
        $_SSLinfo{'subject_hash'}       = _openssl_x509($_SSLinfo{'PEM'}, '-subject_hash');
        $_SSLinfo{'issuer_hash'}        = _openssl_x509($_SSLinfo{'PEM'}, '-issuer_hash');
        $_SSLinfo{'version'}            = _openssl_x509($_SSLinfo{'PEM'}, 'version');
        $_SSLinfo{'text'}               = _openssl_x509($_SSLinfo{'PEM'}, '-text');
        $_SSLinfo{'modulus'}            = _openssl_x509($_SSLinfo{'PEM'}, '-modulus');
       #$_SSLinfo{'serial'}             = _openssl_x509($_SSLinfo{'PEM'}, '-serial'); # done below
        $_SSLinfo{'email'}              = _openssl_x509($_SSLinfo{'PEM'}, '-email');
        $_SSLinfo{'trustout'}           = _openssl_x509($_SSLinfo{'PEM'}, '-trustout');
        $_SSLinfo{'ocsp_uri'}           = _openssl_x509($_SSLinfo{'PEM'}, '-ocsp_uri');
        $_SSLinfo{'ocspid'}             = _openssl_x509($_SSLinfo{'PEM'}, '-ocspid');
        $_SSLinfo{'aux'}                = _openssl_x509($_SSLinfo{'PEM'}, 'aux');
        $_SSLinfo{'pubkey'}             = _openssl_x509($_SSLinfo{'PEM'}, 'pubkey');
        $_SSLinfo{'extensions'}         = _openssl_x509($_SSLinfo{'PEM'}, 'extensions');
        $_SSLinfo{'signame'}            = _openssl_x509($_SSLinfo{'PEM'}, 'signame');
        $_SSLinfo{'sigdump'}            = _openssl_x509($_SSLinfo{'PEM'}, 'sigdump');
       ($_SSLinfo{'sigkey_value'}       =  $_SSLinfo{'sigdump'}) =~ s/.*?\n//ms;
       ($_SSLinfo{'pubkey_algorithm'}   =  $_SSLinfo{'pubkey'})  =~ s/^.*?Algorithm: ([^\r\n]*).*/$1/si;
       ($_SSLinfo{'pubkey_value'}       =  $_SSLinfo{'pubkey'})  =~ s/^.*?Modulus ?([^\r\n]*)//si;
            # damn Windows: some versions behave like *NIX and return:
            #                Modulus (2048 bit):
            # but some versions return:
            #                Modulus:
            # which makes the regex dirty: space followed by question mark
        $_SSLinfo{'pubkey_value'}       =~ s/^.*?pub:([^\r\n]*)//si;
            # public key with EC use  "pub:" instead of "Modulus:"
        $_SSLinfo{'pubkey_value'}       =~ s/(Exponent|ASN1 OID).*//si;
            # public key with EC use  "ASN1 OID:" instead of "Exponent:"
        $_SSLinfo{'modulus_exponent'}   =  $_SSLinfo{'pubkey'};
        $_SSLinfo{'modulus_exponent'}   =~ s/^.*?(?:Exponent|ASN1 OID): (.*)$/$1/si;
        $_SSLinfo{'modulus'}            =~ s/^[^=]*=//i;
        $_SSLinfo{'signame'}            =~ s/^[^:]*: //i;
        $_SSLinfo{'modulus_len'}        =  4 * length($_SSLinfo{'modulus'});
            # Note: modulus is hex value where 2 characters are 8 bit
        if ($_SSLinfo{'sigkey_value'} ne $Net::SSLinfo::no_cert_txt) {
            $_SSLinfo{'sigkey_len'}     =  $_SSLinfo{'sigkey_value'};
            $_SSLinfo{'sigkey_len'}     =~ s/[\s\n]//g;
            $_SSLinfo{'sigkey_len'}     =~ s/[:]//g;
            $_SSLinfo{'sigkey_len'}     =  4 * length($_SSLinfo{'sigkey_len'});
        }
        chomp $_SSLinfo{'fingerprint_hash'};
        chomp $_SSLinfo{'modulus'};
        chomp $_SSLinfo{'pubkey'};
        chomp $_SSLinfo{'signame'};
        # NO Certificate }

        $_SSLinfo{'s_client'}       = do_openssl('s_client', $host, $port, '');
            # this should be the first call to openssl herein
        my  $eee = $_SSLinfo{'s_client'};
        if ($eee =~ m/.*(?:\*\*ERROR)/) {   # pass errors to caller
            $eee =~ s/.*(\*\*ERROR[^\n]*).*/$1/s;
            push(@{$_SSLinfo{'errors'}}, "do_ssl_open WARNING openssl: $eee");
        } else {
            $eee =  '';
        }
        # FIXME: lazy and incomplete approach to pass errors

            # from s_client: (if openssl supports -nextprotoneg)
            #    Protocols advertised by server: spdy/4a4, spdy/3.1, spdy/3, http/1.1

            # from s_client: (openssl > 1.0.1)
            #    Peer signing digest: SHA512
            #    Server Temp Key: DH, 2048 bits
            #    Server Temp Key: ECDH, P-256, 256 bits

            # from s_client (openssl 1.1.x and newer):
            #  Server public key is 2048 bit

            # from s_client:
            #  SSL-Session:
            #  SSL-Session:
            #    Protocol  : TLSv1
            #    Cipher    : ECDHE-RSA-RC4-SHA
            #    Session-ID: 322193A0D243EDD1C07BA0B2E68D1044CDB06AF0306B67836558276E8E70655C
            #    Session-ID-ctx:
            #    Master-Key: EAC0900291A1E5B73242C3C1F5DDCD4BAA7D9F8F4BC6E640562654B51E024143E5403716F9BF74672AF3703283456403
            #    Key-Arg   : None
            #    Krb5 Principal: None
            #    PSK identity: None
            #    PSK identity hint: None
            #    SRP username: None
            #    Timeout   : 300 (sec)
            #    Compression: zlib compression
            #    Expansion: zlib compression
            #    TLS session ticket lifetime hint: 100800 (seconds)
            #    TLS session ticket:
            #    0000 - 00 82 87 03 7b 42 7f b5-a2 fc 9a 95 9c 95 2c f3   ....{B........,.
            #    0010 - 69 91 54 a9 5b 7a 32 1c-08 b1 6e 3c 8c b7 b8 1f   i.T.[z2...n<....
            #    0020 - e4 89 63 3e 3c 0c aa bd-96 70 30 b2 cd 1e 2d c0   ..c><....p0...-.
            #    0030 - e7 fe 10 cd d4 82 e9 8f-d8 ee 91 16 02 42 7b 93   .............B}.
            #    0040 - fc 93 82 c4 d3 fd 0a f3-c6 3d 77 ab 1d 25 4f 5a   .........=w..%OZ
            #    0050 - fc 44 9a 21 3e cb 18 e9-a4 44 1b 30 7c 98 4d 04   .D.!>....D.0|.M.
            #    0060 - bb 12 3e 67 c8 9a ad 99-b4 50 32 81 1e 54 70 2d   ..>g.....P2..Tp-
            #    0070 - 06 08 82 30 9a 94 82 6f-e2 fa c7 e8 5a 19 af dc   ...0...o....Z...
            #    0080 - 70 45 71 f9 d1 e6 a8 d7-3c c2 c6 b8 e1 d5 4f dd   pEq.....<.....O.
            #    0090 - 52 12 f3 90 0c 51 c5 81-6c 9e 69 b6 bd 0c e6 e6   R....Q..l.i.....
            #    00a0 - 4c d4 72 33                                       L.r3
            #
            #    Start Time: 1435254245
            #    Extended master secret: yes
        my %match_map = (
            # %_SSLinfo key       string to match in s_client output
            #-------------------+-----------------------------------
            'session_id'       => "Session-ID:",
            'session_id_ctx'   => "Session-ID-ctx:",
            'master_key'       => "Master-Key:",
            'master_secret'    => "Extended master secret:",
            'krb5'             => "Krb5 Principal:",
            'psk_identity'     => "PSK identity:",
            'psk_hint'         => "PSK identity hint:",
            'srp'              => "SRP username:",
            'compression'      => "Compression:",
            'expansion'        => "Expansion:",
            'alpn'             => "ALPN protocol:",
            'no_alpn'          => "No ALPN negotiated", # has no value, see below
            'next_protocol'    => "Next protocol:",
            'next_protocols'   => "Protocols advertised by server:",
            'session_protocol' => "Protocol\\s+:",      # \s must be meta
            'session_timeout'  => "Timeout\\s+:",       # \s must be meta
            'session_lifetime' => "TLS session ticket lifetime hint:",
            'session_starttime'=> "Start Time:",
            #'session_ticket'   => "TLS session ticket:",
                # this is a multiline value, must be handled special, see below
            #'renegotiation'    => "Renegotiation",
                # Renegotiation comes with different values, see below
            'dh_parameter'     => "Server Temp Key:",
            #'ocsp_response_data' => "OCSP response:",
                # this is a multiline value, must be handled special, see below
            #'public_key_len'   => "Server public key",
                # this line has no  :  hence must be handled special, see below
        );
        my $d    = '';
        my $data = $_SSLinfo{'text'};
        # from text:
        #        Serial Number: 11598581680733355983 (0xa0f670963276ffcf)
        $d = $data; $d =~ s/.*?Serial Number:\s*(.*?)\n.*/$1/si;
        $_SSLinfo{'serial'}             = $d;
        $d =~ s/\s.*$//;
        $_SSLinfo{'serial_int'}         = $d;
            # getting integer value from text representation 'cause
            # Net::SSLeay does not have a proper function
            # and converting the retrived hex value to an int with
            # hex($hex)  returns an error without module bigint
        if ($d =~ m/[0-9a-f]:/i) {
            # some certs return  09:f5:fd:2e:a5:2a:85:48:db:be:5d:a0:5d:b6
            # or similar, then we try to convert to integer manually
            $d =~ s/://g;
            my $b = 8;  # the usual size in 64-bit systems
            if (8 < length($d)) {   # check if we are on 32-bit system
                # on 32-bit systems perl may handle large numbers correctly
                # if compiled properly, can be checked with $Config{ivsize}
                # so we need the value which requires loading the module
                #
                # cannot use eval with block form here, needs to be quoted
                ## no critic qw(BuiltinFunctions::ProhibitStringyEval)
                if (eval('use Config; $b = $Config{ivsize};')) {
                    # use $Config{ivsize}
                } else {
                    $err = "use Config";
                    push(@{$_SSLinfo{'errors'}}, "do_ssl_open Cfg failed calling $src: $err");
                    $_SSLinfo{'serial_int'} = "<<$err failed>>";
                }
                ## use critic
            }
            if (($b < length($d))   # larger than integer of this architecture
              ||(16 < length($d)))  # to large at all
            {  # ugly check if we need bigint
                if (eval {require Math::BigInt;}) {
                    $_SSLinfo{'serial_int'} = Math::BigInt->from_hex($d);
                } else {
                    $err = "Math::BigInt->from_hex($d)";
                    push(@{$_SSLinfo{'errors'}}, "do_ssl_open Big failed calling $src: $err");
                    $_SSLinfo{'serial_int'} = "<<$err failed>>";
                }
            } else {
                $_SSLinfo{'serial_int'} = hex($d);
            }
        }

        $data = $_SSLinfo{'s_client'};
            # Note: as openssl s_client is called with -resume, the retrived
            # data may contain output of s_client up to 5 times
            # it's not ensured that all 5 data sets are identical, hence
            # we need to check them all -at least the last one-
            # Unfortunately all following checks use all 5 data sets.
        foreach my $key (sort keys %match_map) {
            my $regex = $match_map{$key};
            $d = $data;
            $d =~ s/.*?$regex[ \t]*([^\n\r]*)\n.*/$1/si;
            _trace("do_ssl_open: match key:   $key\t= $regex");
            if ($data =~ m/$regex/) {
                $_SSLinfo{$key} = $d;
                $_SSLinfo{$key} = $regex if ($key eq 'no_alpn');
                    # no_alpn: single line, has no value: No ALPN negotiated
                _trace("do_ssl_open: match value: $key\t= $_SSLinfo{$key}");
            }
        }
            # from s_client:
            # ....
            #     Start Time: 1544899903
            #     Timeout   : 300 (sec)
            #     Verify return code: 0 (ok)
            # ---
        my $key = 'session_starttime';
        $_SSLinfo{'session_startdate'} = scalar localtime($_SSLinfo{$key});
            # add human readable time

            # from s_client:
            #  OCSP response: no response sent
            # or:
            #  OCSP response:
            #  ======================================
            #  OCSP Response Data:
            #      OCSP Response Status: successful (0x0)
            #      Response Type: Basic OCSP Response
            #      Version: 1 (0x0)
            #      Responder Id: 1C6C1E3B17EDF8DAB15CEBCDBC2D315868862497
            #      Produced At: Jul  7 16:34:44 2018 GMT
            #      Responses:
            #      Certificate ID:
            #        Hash Algorithm: sha1
            #        Issuer Name Hash: 881A4A74FEFF4652F354BB510FD3A4EEEFE0A1C8
            #        Issuer Key Hash: 919E3B446C3D579C42772A34D74FD1CC4A972CDA
            #        Serial Number: 2000036E72ADED906765595FAE000000036E72
            #      Cert Status: good
            #      This Update: Jul  7 16:34:44 2018 GMT
            #      Next Update: Jul 11 16:34:44 2018 GMT
            #          Response Single Extensions:
            #              OCSP Archive Cutoff:
            #                  Jul  7 16:34:44 2017 GMT
            #
            #      Signature Algorithm: sha256WithRSAEncryption
            #      ....
            # (following Signature and Certificate date not shown and skipped)
            # TODO: extract single values 'ocsp_response_*' from above output,
            #       can be done with %match_map
        $d = $data;
        $d =~ s/.*?OCSP response:\s*([a-zA-Z0-9,. -]+)[\n\r].*/$1/si;
        if ($d =~ m/^\s*$/) {   # probably complete OCSP Response Data:
            $d = $data;
            $d =~ s/.*?OCSP response:\s*[\n\r]+(.*?)[\n\r][\n\r].*/$1/si;
            $d =~ s/^[\n\r]*//;
            if ($d =~ m/OCSP Response Status:\s*([^\n\r]+)[\n\r]/i) {
                $_SSLinfo{'ocsp_response_status'}  = $1;
            }
            if ($d =~ m/Cert Status:\s*([^\n\r]+)[\n\r]/i) {
                $_SSLinfo{'ocsp_cert_status'}  = $1;
            }
            if ($d =~ m/This Update:\s*([^\n\r]+)[\n\r]/i) {
                $_SSLinfo{'ocsp_this_update'}  = $1;
            }
            if ($d =~ m/Next Update:\s*([^\n\r]+)[\n\r]/i) {
                $_SSLinfo{'ocsp_next_update'}  = $1;
            }
            $_SSLinfo{'ocsp_response'}  = 
                  "Response Status: " . $_SSLinfo{'ocsp_response_status'}
                . "; Cert Status: "   . $_SSLinfo{'ocsp_cert_status'}
                . "; This Update: "   . $_SSLinfo{'ocsp_this_update'}
                . "; Next Update: "   . $_SSLinfo{'ocsp_next_update'};
            # TODO: no extract more important values
        } else {                # probably only  OCSP response:
            $_SSLinfo{'ocsp_response'}  = $d;
        }
        $_SSLinfo{'ocsp_response_data'} = $d; # complete string, both cases above

        $d = $data; $d =~ s/.*?Server public key is *([^\n\r]*)[\n\r].*/$1/si;
        $_SSLinfo{'public_key_len'} = $d if ($data =~ m/Server public key is /);

        $d = $data; $d =~ s/.*?TLS session ticket:\s*[\n\r]+(.*?)\n\n.*/$1_/si;
        if ($data =~ m/TLS session ticket:/) {
            $d =~ s/\s*[0-9a-f]{4}\s*-\s*/_/gi;   # replace leading numbering with marker
            $d =~ s/^_//g;         # remove useless marker
            $d =~ s/   .{16}//g;   # remove traling characters
            $d =~ s/[^0-9a-f]//gi; # remove all none hex characters
            $_SSLinfo{'session_ticket'} = $d;
        }

            # from s_client:
            #   Secure Renegotiation IS supported
            #   Secure Renegotiation IS NOT supported
            # TODO: pedantically we also need to check if "RENEGOTIATING" is
            #       there, as just the information "IS supported" does not
            #       mean that it works
        $d = $data; $d =~ s/.*?((?:Secure\s*)?Renegotiation[^\n]*)\n.*/$1/si; $_SSLinfo{'renegotiation'}  = $d;

            # from s_client:
            #    Reused, TLSv1/SSLv3, Cipher is RC4-SHA
            #    Session-ID: F4AD8F441FDEBDCE445D4BD676EE592F6A0CEDA86F08860DF824F8D29049564F
            #    Start Time: 1387270456
            # we do a simple check: just grep for "Reused" in s_client
            # in details it should check if all "Reused" strings are
            # identical *and* the "Session-ID" is the same for all
            # if more than 2 "New" are detected, we assume no resumption
            # finally "Reused" must be part of s_client data
            # should also check "Start Time"
        $d = $data;
        my $cnt =()= $d =~ m/(New|Reused),/g;
        if ($cnt < 3) {
            _trace("do_ssl_open: slow target server; resumption not detected; try to increase \$Net::SSLinfo::timeout_sec");
        } else {
            $cnt =()= $d =~ m/New,/g;
            _trace("do_ssl_open: checking resumption: found $cnt `New' ");
            if ($cnt > 2) { # too much "New" reconnects, assume no resumption
                $cnt =()= $d =~ m/Reused,/g;
                _trace("do_ssl_open: checking resumption: found $cnt `Reused' ");
                $_SSLinfo{'resumption'} = 'no';
            } else {
                $d =~ s/.*?(Reused,[^\n]*).*/$1/si;
                $_SSLinfo{'resumption'} = $d if ($d =~ m/Reused,/);
            }
        }

            # from s_client (different openssl return different strings):
            #       verify error:num=10:certificate has expired
            #       verify error:num=18:self signed certificate
            #       verify error:num=20:unable to get local issuer certificate
            #       verify error:num=21:unable to verify the first certificate
            #       verify error:num=27:certificate not trusted
            #
            # s_client returns at end:
            #       Verify return code: 0 (ok)
            # or just one of following, even if more than one applies:
            #       Verify return code: 10 (certificate has expired)
            #       Verify return code: 19 (self signed certificate in certificate chain)
            #       Verify return code: 20 (unable to get local issuer certificate)
            #       Verify return code: 21 (unable to verify the first certificate)
            #
            # following matches any line, but return first only:
            # TODO: need more extensive tests with different servers and openssl versions
        $d = $data; $d =~ s/.*?Verify (?:error|return code):\s*((?:num=)?[\d]*[^\n]*).*/$1/si;
        $_SSLinfo{'verify'}         = $d;
        # TODO: $_SSLinfo{'verify_host'}= $ssl->verify_hostname($host, 'http');  # returns 0 or 1
        # scheme can be: ldap, pop3, imap, acap, nntp http, smtp

        $d =~ s/.*?(self signed.*)/$1/si;
        $_SSLinfo{'selfsigned'}     = $d;
            # beside regex above, which relies on strings returned from s_client
            # we can compare subject_hash and issuer_hash, which are eqal when
            # self-digned

            # from s_client:
            # $_SSLinfo{'s_client'} grep
            #       Certificate chain
        $d = $data; $d =~ s/.*?Certificate chain[\r\n]+(.*?)[\r\n]+---[\r\n]+.*/$1/si;
        $_SSLinfo{'chain'}          = $d;

            # from s_client:
            # $_SSLinfo{'s_client'} grep
            #       depth=  ... ---
        $d = $data; $d =~ s/.*?(depth=-?[0-9]+.*?)[\r\n]+---[\r\n]+.*/$1/si;
        $_SSLinfo{'chain_verify'}   = $d;

        #dbx# print "TLS: $data\n";
            # from s_client -tlsextdebug -nextprotoneg
            # TLS server extension "server name" (id=0), len=0
            # TLS server extension "renegotiation info" (id=65281), len=1
            # TLS server extension "session ticket" (id=35), len=0
            # TLS server extension "heartbeat" (id=15), len=1
            # TLS server extension "EC point formats" (id=11), len=4
            # TLS server extension "next protocol" (id=13172), len=25
            # TLS server extension "session ticket" (id=35), len=0
        foreach my $line (split(/[\r\n]+/, $data)) {
            next if ($line !~ m/TLS server extension/i);
            $d = $line;
            $d =~ s/TLS server extension\s*"([^"]*)"/$1/i;
                # remove prefix text, but leave id= and len= for caller
            my $rex =  $d;  # $d may contain regex meta characters, like ()
               $rex =~ s#([(/*)])#\\$1#g;
            next if ((grep{/$rex/} split(/\n/, $_SSLinfo{'tlsextensions'})) > 0);
            $_SSLinfo{'tlsextdebug'}   .= "\n" . $line;
            $_SSLinfo{'tlsextensions'} .= "\n" . $d;
            $_SSLinfo{'heartbeat'}= $d if ($d =~ m/heartbeat/);
            # following already done, see above, hence with --trace only
            _trace("do_ssl_open: -tlsextdebug  $d") if ($d =~ m/session ticket/);
            _trace("do_ssl_open: -tlsextdebug  $d") if ($d =~ m/renegotiation info/);
        }
        $_SSLinfo{'tlsextensions'} =~ s/\([^)]*\),?\s+//g;  # remove additional information
        $_SSLinfo{'tlsextensions'} =~ s/\s+len=\d+//g;      # ...

        _trace("do_ssl_open(with openssl done.");
        _trace1("do_ssl_open <<use --trace=2 to print data collected from openssl>>");
        _trace2(Net::SSLinfo::datadump("do_ssl_open"));
        goto finished;
    } # TRY

    #6. error handling
    push(@{$_SSLinfo{'errors'}}, "do_ssl_open TRY failed calling $src: $err");
    if (1 < $trace) {
        Net::SSLeay::print_errs(SSLINFO_ERR);
        print SSLINFO_ERR . $_ foreach @{$_SSLinfo{'errors'}};
    }
    _trace("do_ssl_open failed.");
    return;

    finished:
    _SSLinfo_print();   # --verbose only
    finished_return:
    _trace("do_ssl_open done.");
    return wantarray ? ($_SSLinfo{'ssl'}, $_SSLinfo{'ctx'}) : $_SSLinfo{'ssl'};
} # do_ssl_open

=pod

=head2 do_ssl_close( )

Close L<Net::SSLeay> connection and free allocated objects.
=cut

sub do_ssl_close($$)  {
    #? close TCP connection for SSL
    my ($host, $port) = @_;
    _trace("do_ssl_close($host,$port)");
    do_ssl_free($_SSLinfo{'ctx'}, $_SSLinfo{'ssl'}, $Net::SSLinfo::socket);
    _SSLinfo_reset();
    $Net::SSLinfo::socket = undef;
    $Net::SSLinfo::method = '';
    return;
} # do_ssl_close

=pod

=head2 do_openssl($command,$host,$port,$data)

Wrapper for call of external L<openssl(1)> executable. Handles special
behaviours on some platforms.

If I<$command> equals C<s_client> it will add C<-reconnect -connect> to the
openssl call. All other values of I<$command> will be used verbatim.
Note that the SSL version must be part (added) as proper openssl option
to C<$command> as this option cannot preceed the command in openssl..

Examples for I<$command>:

    ciphers -sslv3

    s_client -tlsv1_1 -connect

The value of I<$data>, if set, is piped to openssl.

Returns retrieved data or '<<openssl>>' if openssl or s_client missing.
Returns '<<undefined>>' if PEM missing.
=cut

sub do_openssl($$$$)  {
    #? call external openssl executable to retrive more data
    my $mode = shift;   # must be openssl command
    my $host = shift;
    my $port = shift || '';  # may be empty for some calls
    my $pipe = shift || '';  # piped data is optional
    my $data = '';
    my $capath = $Net::SSLinfo::ca_path || '';
    my $cafile = $Net::SSLinfo::ca_file || '';
    _trace("do_openssl($mode,$host,$port...).");
    _setcmd();
    if ('' eq $_openssl) {
        _trace("do_openssl($mode): WARNING: no openssl");
        return SSLINFO_HASH;
    }
    if ($mode =~ m/^-?s_client$/) {
        if ($Net::SSLinfo::file_sclient !~ m/^\s*$/) {
            if (open(my $fh, '<:encoding(UTF-8)', $Net::SSLinfo::file_sclient)) {
                undef $/;   # get anything
                $data = <$fh>;
                close($fh);
                return $data;
            }
            _trace("do_openssl($mode): WARNING: cannot open $Net::SSLinfo::file_sclient");
            return SSLINFO_HASH;
        }
        if (0 == $Net::SSLinfo::use_sclient) {
            _trace2("do_openssl($mode): WARNING: no openssl s_client");
            return SSLINFO_HASH;
        }
# TODO: Optionen hier entfernen, muss im Caller gemacht werden
        # pass -alpn option to validate 'protocols' support later
        # pass -nextprotoneg option to validate 'protocols' support later
        # pass -reconnect option to validate 'resumption' support later
        # pass -tlsextdebug option to validate 'heartbeat' support later
        # pass -status option to get 'ocsp_response_data' support later
        # NOTE that openssl 1.x or later is required for -nextprotoneg
        # NOTE that openssl 1.0.2 or later is required for -alpn
        $mode  = 's_client' . $Net::SSLinfo::sclient_opt;
# FIXME: { following fixes general verify, but not self signed
        $mode .= ' -CApath ' . $capath if ('' ne $capath);
        $mode .= ' -CAfile ' . $cafile if ('' ne $cafile);
# }
        $mode .= ' -reconnect'   if (1 == $Net::SSLinfo::use_reconnect);
        $mode .= ' -tlsextdebug' if (1 == $Net::SSLinfo::use_extdebug);
        $mode .= ' -status';
    }
    if (($mode =~ m/^-?s_client$/)
    ||  ($mode =~ m/^-?s_client.*?-cipher/)) {
        $mode .= ' -alpn '         . $Net::SSLinfo::protos_alpn if (1 == $Net::SSLinfo::use_alpn);
        $mode .= ' -nextprotoneg ' . $Net::SSLinfo::protos_npn  if (1 == $Net::SSLinfo::use_npn);
    }
    if ($mode =~ m/^-?s_client/) {
        $mode .= ' -connect'     if  ($mode !~ m/-connect/);
    }
    $host = $port = '' if ($mode =~ m/^-?(ciphers)/);   # TODO: may be scary
    _trace("do_openssl($mode): echo '' | $_timeout $_openssl $mode $host:$port 2>&1"); 
    _verbose("$_timeout $_openssl $mode $host:$port");
        # TODO: both, _trace and _verbose, may produce useless trailing : 
    if ($^O !~ m/MSWin32/) {
        $host .= ':' if ($port ne '');
        $pipe  = 'HEAD / HTTP/1.1' if ($pipe =~ m/^$/); # avoid in access.log: "\n" 400 750 "-" "-"
        #dbx# print "echo $pipe | $_timeout $_openssl $mode $host$port 2>&1";
        $data  = `echo $pipe | $_timeout $_openssl $mode $host$port 2>&1`;  ## no critic qw(InputOutput::ProhibitBacktickOperators)
        if ($data =~ m/(\nusage:|unknown option)/s) {
            #$data =~ s/((?:usage:|unknown option)[^\r\n]*).*/$1/g;
            my $u1 = $data; $u1 =~ s/.*?(unknown option[^\r\n]*).*/$1/s;
            my $u2 = $data; $u2 =~ s/.*?\n(usage:[^\r\n]*).*/$1/s;
            $data = "**ERROR: $u1\n**ERROR: $u2\n"; # pass basic error string to caller
            _trace("do_openssl($mode): WARNING: openssl does not support -nextprotoneg option");
            push(@{$_SSLinfo{'errors'}}, "do_openssl($mode) failed: $data");
            # try to do it again with mostly safe options
            $mode =  's_client';
            $mode .= ' -CApath ' . $capath if ('' ne $capath);
            $mode .= ' -CAfile ' . $cafile if ('' ne $cafile);
            $mode .= ' -reconnect'   if (1 == $Net::SSLinfo::use_reconnect);
            $mode .= ' -connect';
            $data .= `echo $pipe | $_timeout $_openssl $mode $host$port 2>&1`;  ## no critic qw(InputOutput::ProhibitBacktickOperators)
        }
    } else {
        $data = _openssl_MS($mode, $host, $port, '');
        if ($data =~ m/(\nusage:|unknown option)/s) { # we like performance penulties ...
            _trace("do_openssl($mode): WARNING: openssl does not support -nextprotoneg option");
            $data = _openssl_MS($mode, $host, $port, '');
        }
    }
    if ($mode =~ m/^-?(ciphers)/) { # check for errors in getting cipher list
        if ($data =~ m/^\s*(?:Error|openssl)(?: |:)/i) {
            push(@{$_SSLinfo{'errors'}}, "do_openssl($mode) failed: $data");
            $data =  '';
        }
    }
    chomp $data;
    $data =~ s/\s*$//;  # be sure ...
    return $data;
} # do_openssl

# From here on, we use a pod sections for multiple functions, then the
# corresponding function definitions follow that section. This is done
# to make the code more readable for humans.

=pod

=head2 set_cipher_list($ssl,$cipherlist)

Set cipher list for connection. List is colon-separated list of ciphers.

Returns empty string on success, errors otherwise.
=cut

sub set_cipher_list {
    my $ssl    = shift;
    my $cipher = shift;
    Net::SSLeay::set_cipher_list($ssl, $cipher) or return SSLINFO . '::set_cipher_list(' . $cipher . ')';
    $_SSLinfo{'cipherlist'} = $cipher;
    return '';
}

=pod

=head2 errors( )

Get list of errors, intenal ones but most likely from I<$Net::SSLeay::*> calls.

=head2 s_client( )

Dump data retrived from "openssl s_client ..." call. For debugging only.

=head2 options( )

Return hex value bitmask of (openssl) options used to establish connection.
Useful for debugging and trouble shooting.

=head2 PEM( ), pem( )

Get certificate in PEM format.

=head2 text( )

Get certificate in human readable format.

=head2 before( )

Get date before certificate is valid.

=head2 after( )

Get date after certificate is valid.

=head2 dates( )

Get dates when certificate is valid.

=head2 issuer( )

Get issuer of certificate.

=head2 subject( )

Get subject of certificate.

=head2 selected( )

Get cipher selected by server for current session. Returns ciphers string.

=head2 cipher_list($pattern)

Get cipher list offered by local SSL implementation (i.g. Net::SSLeay).
Returns space-separated list of ciphers.
Returns array if used in array context, a single string otherwise.

Requires successful connection to target.

=head2 cipher_openssl($pattern)

Get cipher list offered by local openssl implementation. Returns colon-separated list of ciphers.

Does not require connection to any target.

=head2 ciphers($pattern)

Returns List of ciphers provided for current connection to target.
Calls cipher_list() or cipher_openssl() depending on Net::SSLinfo::use_openssl.

=cut

sub cipher_list     {
    my $pattern = shift || $_SSLinfo{'cipherlist'}; # use default if unset
    my ($ctx, $ssl, $cipher);
    my $priority = 0;
    my @list;
    _trace("cipher_list($pattern)");
    TRY: { # defensive programming with simple error checks
        # just getting local ciphers does not need sophisticated error handling
        ($ctx = Net::SSLeay::CTX_new()) or last;
        ($ssl=  Net::SSLeay::new($ctx)) or last;
        Net::SSLeay::set_cipher_list($ssl, $pattern) or last;
            # second parameter must not be empty; default see above
        push(@list, $cipher) while ($cipher = Net::SSLeay::get_cipher_list($ssl, $priority++));
    } # TRY
    Net::SSLeay::free($ssl)     if (defined $ssl);
    Net::SSLeay::CTX_free($ctx) if (defined $ctx);
    return (wantarray) ? @list : join(' ', @list);
} # cipher_list

sub cipher_openssl  {
    my $pattern = shift || $_SSLinfo{'cipherlist'}; # use default if unset
    my $list;
    _trace("cipher_openssl($pattern)");
    _setcmd();
    _trace2("cipher_openssl: openssl ciphers $pattern");
    $list = do_openssl("ciphers $pattern", '', '', '');
    chomp  $list;
    return (wantarray) ? split(/[:\s]+/, $list) : $list;
} # cipher_openssl

## no critic qw(Subroutines::RequireArgUnpacking)
# "critic Subroutines::RequireArgUnpacking" disabled from hereon for a couple
# of subs because using explicit variable declarations in each sub would make
# (human) reading more difficult; it is also ensured that the called function
# _SSLinfo_get()  does not modify the parameters.

sub cipher_local    {
    warn("$OSaft::Text::STR{WARN} 451: function obsolete, please use cipher_openssl()");
    return cipher_openssl(@_);
} # cipher_local

sub ciphers         {
    return cipher_list(   @_) if ($Net::SSLinfo::use_openssl == 0);
    return cipher_openssl(@_);
} # ciphers

=pod

All following functions have  $host and $port  parameter and return
information according the the connection, certificate for this connection.

=head2 cn( ), commonname( )

Get common name (CN) from certificate.

=head2 altname( )

Get alternate name (subjectAltNames) from certificate.

=head2 authority( )

Get authority (issuer) from certificate.

=head2 owner( )

Get owner (subject) from certificate.

=head2 certificate( )

Get certificate (subject, issuer) from certificate.

=head2 SSLversion( )

Get SSL protocol version used by connection.

=head2 version( )

Get version from certificate.
=cut

# TODO: not yet implemented
#=head2 keysize( )
#
#Get certificate private key size.
#
#=head2 keyusage( )
#
#Get certificate X509v3 Extended Key Usage (Version 3 and TLS only?)

=pod

=head2 ssleay_methods( )

Return list of available methods:  Net::SSLeay::*_method and
Net::SSLeay::CTX_*_new . Most important (newest) method first.

=head2 test_ssleay( )

Test availability and print information about Net::SSLeay:
Example: C<perl -MNet::SSLinfo -le 'print Net::SSLinfo::test_ssleay();'>

=head2 datadump( )

Print all available (by Net::SSLinfo) data.

Due to huge amount of data, the value for s_client is usually omitted.
Please set I<$Net::SSLinfo::use_sclient gt 1> to print this data also.

=head2 (details)

All following require that I<$Net::SSLinfo::use_openssl=1;> being set.

=head2 compression( )

Get target's compression support.

=head2 exapansion( )

Get target's exapansion support.

=head2 next_protocols( )

Get (NPN) protocols advertised by server,

=head2 alpn( )

Get target's selected protocol (ALPN).

=head2 no_alpn( )

Get target's not negotiated message (ALPN).

=head2 next_protocol( )

Get target's next protocol message (ALPN).

=head2 krb5

Get target's Krb5 Principal.

=head2 psk_identity

Get target's PSK identity.

=head2 psk_hint

Get target's PSK identity hint.

=head2 srp

Get target's SRP username.

=head2 master_key

Get target's Master-Key.

=head2 master_secret

Get target's support for Extended master secret.

=head2 extended_master_secret

Same as master_secret .

=head2 public_key_len

Get target's Server public key length.

=head2 session_id

Get target's TLS Session-ID.

=head2 session_id_ctx

Get target's TLS Session-ID-ctx.

=head2 session_protocol

Get target's announced SSL protocols.

=head2 session_startdate

Get target's TLS Start Time (human readable format))

=head2 session_starttime

Get target's TLS Start Time (seconds since EPOCH)

=head2 session_ticket

Get target's TLS session ticket.

=head2 session_ticket_hint, session_lifetime

Get target's TLS session ticket lifetime hint.

=head2 session_timeout

Get target's SSL session timeout.

=head2 dh_parameter( )

Get targets DH parameter.

=head2 fingerprint_hash( )

Get certificate fingerprint hash value.

=head2 fingerprint_md5( )

Get  MD5 fingerprint if available (Net::SSLeay >= 1.49)

=head2 fingerprint_sha1( )

Get SHA1 fingerprint if available (Net::SSLeay >= 1.49)

=head2 fingerprint_sha2( )

Get SHA2 fingerprint if available (Net::SSLeay >= 1.49)

=head2 fingerprint_type( )

Get certificate fingerprint hash algorithm.

=head2 fingerprint_text( )

Get certificate fingerprint, which is the hash algorthm followed by the hash
value. This is usually the same as I<fingerprint_type()=fingerprint_hash()>.

=head2 fingerprint( )

Alias for I<fingerprint_text()>.

=head2 email( )

Get certificate email address(es).

=head2 serial_hex( )

Get certificate serial number as hex value.

=head2 serial_int( )

Get certificate serial number as integer value.

=head2 serial( )

Get certificate serial number as integer and hex value.

=head2 modulus( )

Get certificate modulus of the public key.

=head2 modulus_exponent( )

Get certificate modulus' exponent of the public key.

=head2 modulus_len( )

Get certificate modulus (bit) length of the public key.

=head2 ocsp_response( )

Get OCSP Response (compact list with values from ocsp_response_data()).

=head2 ocsp_response_data( )

Get complete OCSP Response Data.

=head2 ocsp_response_status( )

Get OCSP Response Status value.

=head2 ocsp_cert_status( )

Get OCSP Response Cert Status value.

=head2 ocsp_next_update( )

Get OCSP Response Next Update date.

=head2 ocsp_this_update( )

Get OCSP Response This Update date.

=head2 pubkey( )

Get certificate's public key.

=head2 pubkey_algorithm( )

Get certificate's public key algorithm.

=head2 pubkey_value( )

Get certificate's public key value.
Same as I<modulus()>  but may be different format.

=head2 renegotiation( )

Get certificate's renegotiation support.

=head2 resumption( )

Get certificate's resumption support.
Some target servers respond with  `New' and `Reused'  connections in
unexpected sequence. If `Reused' is found and less than 3 `New' then
resumption is assumed.

If resumption is not detected, increasing the timeout with i.e.
I<$Net::SSLinfo::timeout_sec = 5>  may return different results.

=head2 sigkey_len( )

Get certificate signature key (bit).

=head2 sigkey_value( )

Get certificate signature value (hexdump).

=head2 subject_hash( ), issuer_hash( )

Get certificate subject/issuer hash value (in hex).

=head2 verify( )

Get result of certificate chain verification.

=head2 error_verify( )

Get error string of certificate chain verification, if any.

=head2 error_depth( )

Get depth where certificate chain verification failed.

=head2 chain( )

Get certificate's CA chain.

=head2 chain_verify( )

Get certificate's CA chain verification trace (for debugging only).

=head2 selfsigned( )

If certificate is self signed.

=head2 https_alerts( )

Get HTTPS alerts send by server.

=head2 https_protocols( )

Get HTTPS Alterenate-Protocol header.

=head2 https_svc( )

Get HTTPS Alt-Svc and X-Firefox-Spdy header.

=head2 https_body( )

Get HTTPS response (body)

=head2 https_status( )

Get HTTPS response (aka status) line.

=head2 https_server( )

Get HTTPS Server header.

=head2 https_location( )

Get HTTPS Location header.

=head2 https_refresh( )

Get HTTPS Refresh header.

=head2 http_protocols( )

Get HTTP Alterenate-Protocol header.

=head2 http_svc( )

Get HTTP Alt-Svc and X-Firefox-Spdy header.

=head2 http_status( )

Get HTTP response (aka status) line.

=head2 http_location( )

Get HTTP Location header.

=head2 http_refresh( )

Get HTTP Refresh header.

=head2 http_sts( )

Get HTTP Strict-Transport-Security header, if any.

=head2 hsts_httpequiv( )

Get hhtp-equiv=Strict-Transport-Security attribute from HTML body, if any.

=head2 hsts( )

Get complete STS header.

=head2 hsts_maxage( )

Get max-age attribute of STS header.

=head2 hsts_subdom( )

Get includeSubDomains attribute of STS header.

=head2 hsts_preload( )

Get preload attribute of STS header.

=head2 https_pins( )

Get pins attribute of STS header.

=head2 CTX_method( )

Get used Net::SSLeay::CTX_*_new) method. Useful for debugging only.

=cut

sub errors          { return _SSLinfo_get('errors',           $_[0], $_[1]); }
sub s_client        { return _SSLinfo_get('s_client',         $_[0], $_[1]); }
sub options         { return _SSLinfo_get('_options',         $_[0], $_[1]); }
sub PEM             { return _SSLinfo_get('PEM',              $_[0], $_[1]); }
sub pem             { return _SSLinfo_get('PEM',              $_[0], $_[1]); } # alias for PEM
sub text            { return _SSLinfo_get('text',             $_[0], $_[1]); }
sub before          { return _SSLinfo_get('before',           $_[0], $_[1]); }
sub after           { return _SSLinfo_get('after',            $_[0], $_[1]); }
sub dates           { return _SSLinfo_get('dates',            $_[0], $_[1]); }
sub issuer          { return _SSLinfo_get('issuer',           $_[0], $_[1]); }
sub subject         { return _SSLinfo_get('subject',          $_[0], $_[1]); }
#sub default         { return _SSLinfo_get('selected',         $_[0], $_[1]); } # alias; used in VERSION < 14.11.14
sub selected        { return _SSLinfo_get('selected',         $_[0], $_[1]); }
sub cn              { return _SSLinfo_get('cn',               $_[0], $_[1]); }
sub commonname      { return _SSLinfo_get('cn',               $_[0], $_[1]); } # alias for cn
sub altname         { return _SSLinfo_get('altname',          $_[0], $_[1]); }
sub subjectaltnames { return _SSLinfo_get('altname',          $_[0], $_[1]); } # alias for altname
sub authority       { return _SSLinfo_get('authority',        $_[0], $_[1]); }
sub owner           { return _SSLinfo_get('owner',            $_[0], $_[1]); } # alias for subject
sub certificate     { return _SSLinfo_get('certificate',      $_[0], $_[1]); }
sub SSLversion      { return _SSLinfo_get('SSLversion',       $_[0], $_[1]); }
sub version         { return _SSLinfo_get('version',          $_[0], $_[1]); }
sub keysize         { return _SSLinfo_get('keysize',          $_[0], $_[1]); } # NOT IMPLEMENTED
sub keyusage        { return _SSLinfo_get('keyusage',         $_[0], $_[1]); } # NOT IMPLEMENTED
sub email           { return _SSLinfo_get('email',            $_[0], $_[1]); }
sub modulus         { return _SSLinfo_get('modulus',          $_[0], $_[1]); }
sub serial_hex      { return _SSLinfo_get('serial_hex',       $_[0], $_[1]); }
sub serial_int      { return _SSLinfo_get('serial_int',       $_[0], $_[1]); }
sub serial          { return _SSLinfo_get('serial',           $_[0], $_[1]); }
sub aux             { return _SSLinfo_get('aux',              $_[0], $_[1]); }
sub extensions      { return _SSLinfo_get('extensions',       $_[0], $_[1]); }
sub tlsextdebug     { return _SSLinfo_get('tlsextdebug',      $_[0], $_[1]); }
sub tlsextensions   { return _SSLinfo_get('tlsextensions',    $_[0], $_[1]); }
sub heartbeat       { return _SSLinfo_get('heartbeat',        $_[0], $_[1]); }
sub trustout        { return _SSLinfo_get('trustout',         $_[0], $_[1]); }
sub ocsp_uri        { return _SSLinfo_get('ocsp_uri',         $_[0], $_[1]); }
sub ocspid          { return _SSLinfo_get('ocspid',           $_[0], $_[1]); }
sub ocsp_response   { return _SSLinfo_get('ocsp_response',    $_[0], $_[1]); }
sub ocsp_response_data   { return _SSLinfo_get('ocsp_response_data',   $_[0], $_[1]); }
sub ocsp_response_status { return _SSLinfo_get('ocsp_response_status', $_[0], $_[1]); }
sub ocsp_cert_status{ return _SSLinfo_get('ocsp_cert_status', $_[0], $_[1]); }
sub ocsp_next_update{ return _SSLinfo_get('ocsp_next_update', $_[0], $_[1]); }
sub ocsp_this_update{ return _SSLinfo_get('ocsp_this_update', $_[0], $_[1]); }
sub pubkey          { return _SSLinfo_get('pubkey',           $_[0], $_[1]); }
sub signame         { return _SSLinfo_get('signame',          $_[0], $_[1]); }
sub sigdump         { return _SSLinfo_get('sigdump',          $_[0], $_[1]); }
sub sigkey_value    { return _SSLinfo_get('sigkey_value',     $_[0], $_[1]); }
sub sigkey_len      { return _SSLinfo_get('sigkey_len',       $_[0], $_[1]); }
sub subject_hash    { return _SSLinfo_get('subject_hash',     $_[0], $_[1]); }
sub issuer_hash     { return _SSLinfo_get('issuer_hash',      $_[0], $_[1]); }
sub verify          { return _SSLinfo_get('verify',           $_[0], $_[1]); }
sub error_verify    { return _SSLinfo_get('error_verify',     $_[0], $_[1]); }
sub error_depth     { return _SSLinfo_get('error_depth',      $_[0], $_[1]); }
sub chain           { return _SSLinfo_get('chain',            $_[0], $_[1]); }
sub chain_verify    { return _SSLinfo_get('chain_verify',     $_[0], $_[1]); }
sub compression     { return _SSLinfo_get('compression',      $_[0], $_[1]); }
sub expansion       { return _SSLinfo_get('expansion',        $_[0], $_[1]); }
sub next_protocols  { return _SSLinfo_get('next_protocols',   $_[0], $_[1]); }
sub protocols       { return _SSLinfo_get('next_protocols',   $_[0], $_[1]); } # alias for backward compatibility (< 1.169)
sub alpn            { return _SSLinfo_get('alpn',             $_[0], $_[1]); }
sub no_alpn         { return _SSLinfo_get('no_alpn',          $_[0], $_[1]); }
sub next_protocol   { return _SSLinfo_get('next_protocol',    $_[0], $_[1]); }
sub krb5            { return _SSLinfo_get('krb5',             $_[0], $_[1]); }
sub psk_hint        { return _SSLinfo_get('psk_hint',         $_[0], $_[1]); }
sub psk_identity    { return _SSLinfo_get('psk_identity',     $_[0], $_[1]); }
sub srp             { return _SSLinfo_get('srp',              $_[0], $_[1]); }
sub master_key      { return _SSLinfo_get('master_key',       $_[0], $_[1]); }
sub master_secret   { return _SSLinfo_get('master_secret',    $_[0], $_[1]); }
sub extended_master_secret  { return _SSLinfo_get('master_secret', $_[0], $_[1]); } # alias
sub public_key_len  { return _SSLinfo_get('public_key_len',   $_[0], $_[1]); }
sub session_id      { return _SSLinfo_get('session_id',       $_[0], $_[1]); }
sub session_id_ctx  { return _SSLinfo_get('session_id_ctx',   $_[0], $_[1]); }
sub session_startdate{return _SSLinfo_get('session_startdate',$_[0], $_[1]); }
sub session_starttime{return _SSLinfo_get('session_starttime',$_[0], $_[1]); }
sub session_lifetime{ return _SSLinfo_get('session_lifetime', $_[0], $_[1]); }
sub session_ticket_hint{return _SSLinfo_get('session_lifetime',$_[0],$_[1]); } # alias
sub session_ticket  { return _SSLinfo_get('session_ticket',   $_[0], $_[1]); }
sub session_timeout { return _SSLinfo_get('session_timeout',  $_[0], $_[1]); }
sub session_protocol{ return _SSLinfo_get('session_protocol', $_[0], $_[1]); }
sub fingerprint_hash{ return _SSLinfo_get('fingerprint_hash', $_[0], $_[1]); }
sub fingerprint_text{ return _SSLinfo_get('fingerprint_text', $_[0], $_[1]); }
sub fingerprint_type{ return _SSLinfo_get('fingerprint_type', $_[0], $_[1]); }
sub fingerprint_sha2{ return _SSLinfo_get('fingerprint_sha2', $_[0], $_[1]); }
sub fingerprint_sha1{ return _SSLinfo_get('fingerprint_sha1', $_[0], $_[1]); }
sub fingerprint_md5 { return _SSLinfo_get('fingerprint_md5' , $_[0], $_[1]); }
sub fingerprint     { return _SSLinfo_get('fingerprint',      $_[0], $_[1]); } # alias for fingerprint_text
sub cert_type       { return _SSLinfo_get('cert_type',        $_[0], $_[1]); }
sub modulus_len     { return _SSLinfo_get('modulus_len',      $_[0], $_[1]); }
sub modulus_exponent{ return _SSLinfo_get('modulus_exponent', $_[0], $_[1]); }
sub pubkey_algorithm{ return _SSLinfo_get('pubkey_algorithm', $_[0], $_[1]); }
sub pubkey_value    { return _SSLinfo_get('pubkey_value',     $_[0], $_[1]); }
sub renegotiation   { return _SSLinfo_get('renegotiation',    $_[0], $_[1]); }
sub resumption      { return _SSLinfo_get('resumption',       $_[0], $_[1]); }
sub dh_parameter    { return _SSLinfo_get('dh_parameter',     $_[0], $_[1]); }
sub selfsigned      { return _SSLinfo_get('selfsigned',       $_[0], $_[1]); }
sub https_protocols { return _SSLinfo_get('https_protocols',  $_[0], $_[1]); }
sub https_body      { return _SSLinfo_get('https_body',       $_[0], $_[1]); }
sub https_svc       { return _SSLinfo_get('https_svc',        $_[0], $_[1]); }
sub https_status    { return _SSLinfo_get('https_status',     $_[0], $_[1]); }
sub https_server    { return _SSLinfo_get('https_server',     $_[0], $_[1]); }
sub https_alerts    { return _SSLinfo_get('https_alerts',     $_[0], $_[1]); }
sub https_location  { return _SSLinfo_get('https_location',   $_[0], $_[1]); }
sub https_refresh   { return _SSLinfo_get('https_refresh',    $_[0], $_[1]); }
sub https_pins      { return _SSLinfo_get('https_pins',       $_[0], $_[1]); }
sub http_protocols  { return _SSLinfo_get('http_protocols',   $_[0], $_[1]); }
sub http_svc        { return _SSLinfo_get('http_svc',         $_[0], $_[1]); }
sub http_status     { return _SSLinfo_get('http_status',      $_[0], $_[1]); }
sub http_location   { return _SSLinfo_get('http_location',    $_[0], $_[1]); }
sub http_refresh    { return _SSLinfo_get('http_refresh',     $_[0], $_[1]); }
sub http_sts        { return _SSLinfo_get('http_sts',         $_[0], $_[1]); }
sub https_sts       { return _SSLinfo_get('https_sts',        $_[0], $_[1]); }
sub hsts_httpequiv  { return _SSLinfo_get('hsts_httpequiv',   $_[0], $_[1]); }
sub hsts_maxage     { return _SSLinfo_get('hsts_maxage',      $_[0], $_[1]); }
sub hsts_subdom     { return _SSLinfo_get('hsts_subdom',      $_[0], $_[1]); }
sub hsts_preload    { return _SSLinfo_get('hsts_preload',     $_[0], $_[1]); }
sub CTX_method      { return _SSLinfo_get('CTX_method',       $_[0], $_[1]); }

=pod

=head2 verify_hostname( )

Verify if given hostname matches common name (CN) in certificate.
=cut

############ TODO:  do_ssl_open  vorbereiten fuer verify_*
sub verify_hostname {
    my ($host, $port) = @_;
    return if (not defined do_ssl_open($host, $port, ''));
    return $Net::SSLinfo::no_cert_txt if (0 != $Net::SSLinfo::no_cert);
    my $cname = $_SSLinfo{'cn'};
    my $match = '';
    if (1 == $Net::SSLinfo::ignore_case) {
        $host = lc($host);
        $cname= lc($cname);
    }
    $match = ($host eq $cname) ? 'matches' : 'does not match';
    return sprintf("Given hostname '%s' %s CN '%s' in certificate", $host, $match, $cname);
} # verify_hostname

=head2 verify_altname( ), verify_alias( )

Verify if given hostname matches alternate name (subjectAltNames) in certificate.
=cut

sub verify_altname  {
    my ($host, $port) = @_;
    return if (not defined do_ssl_open($host, $port, ''));
    return $Net::SSLinfo::no_cert_txt if (0 != $Net::SSLinfo::no_cert);
    _trace("verify_altname($host)");
    my $match = 'does not match';
    my $cname = $_SSLinfo{'altname'};
    return "No alternate name defined in certificate" if ('' eq $cname);
    _trace("verify_altname: $cname");
    foreach my $alt (split(/ /, $cname)) {
        # list of strings like: DNS:some.tld DNS:other.tld email:who@some.tld
        # $alt may contain  (  or  {  , see escape $rex below
        next if ($alt =~ m/^\s*$/);
        my ($type, $name) = split(/:/, $alt);
#dbx# print "#ALT# $alt: ($type, $name)";
# TODO: implement IP and URI; see also o-saft.pl: _checkwildcards()
        push(@{$_SSLinfo{'errors'}}, "verify_altname() $type not supported in SNA") if ($type !~ m/DNS/i);
        my $rex = $name;
        if (1 == $Net::SSLinfo::ignore_case) {
            $host = lc($host);
            $rex  = lc($rex);
        }
        $rex =~ s/[.]/\\./g;        # escape meta characters
        $rex =~ s/([({[])/\\$1/g;   # escape meta characters
        if ($name =~ m/[*]/) {
            $rex =~ s/(\*)/[^.]*/;
        }
        _trace("verify_altname: $host =~ $rex ");
        if ($host  =~ /^$rex$/) {
            $match =  'matches';
            $cname =  $alt;   # only show matching name
            $cname =~ s/^[a-zA-Z0-9]+://;   # remove leading type, i.e. DNS:
            last;
        # else
            # $cname still contains type like DNS:
        }
    }
    _trace("verify_altname() done.");
    return sprintf("Given hostname '%s' %s alternate name '%s' in certificate", $host, $match, $cname);
} # verify_altname

sub verify_alias    { return verify_altname($_[0], $_[1]); }

sub error           {
    # TBD
    #return Net::SSLeay::ERR_get_error;
} # error

#_____________________________________________________________________________
#_____________________________________________________________________ main __|

sub _main           {
    #? print own documentation or special required one
    ## no critic qw(InputOutput::RequireEncodingWithUTF8Layer)
    #  see t/.perlcriticrc for detailed description of "no critic"
    my @argv = @_;
    push(@argv, "--help") if (0 > $#argv);
    binmode(STDOUT, ":unix:utf8");
    binmode(STDERR, ":unix:utf8");
    local $\="\n";
    # got arguments, do something special; any -option or +command exits
    while (my $arg = shift @argv) {
        if ($arg =~ m/^--?h(?:elp)?$/)          { local undef $\; print_pod($0, __PACKAGE__, $SID_sslinfo); }
        # ----------------------------- options
        if ($arg =~ m/^--(?:v|trace.?)/i)       { $Net::SSLinfo::verbose++; next; }
        # ----------------------------- commands
        if ($arg =~ m/^version$/)               { print "$SID_sslinfo";     next; }
        if ($arg =~ m/^[+-]?VERSION/i)          { print "$VERSION";         next; }
        if ($arg =~ m/^(?:--test)?.?ssleay/)    { print test_ssleay();      next; }
        if ($arg =~ m/^(?:--test)?.?sslmap/)    { print test_sslmap();      next; }
        if ($arg =~ m/^(?:--test)?.?s_?client/) { print test_sclient();     next; }
        if ($arg =~ m/^(?:--test)?.?methods/)   { print test_methods();     next; }
        if ($arg =~ m/^[+-]/)                   { next; }   # silently ignore unknown options
        # treat remaining args as hostname to test
        do_ssl_open( $arg, 443, '');
        print Net::SSLinfo::datadump("main");
    }
    exit 0;
} # _main

#_____________________________________________________________________________
#_____________________________________________________ public documentation __|

=pod

=head1 DEPENDENCIES

L<Net::SSLeay(3pm)>
L<Math::BigInt(3pm)>  (required if necessary only)

=head1 SEE ALSO

L<Net::SSLeay(1)>

=head1 AUTHOR

08-aug-12 Achim Hoffmann

=cut

sub net_sslinfo_done {};        # dummy to check successful include
## PACKAGE }

my $_ssinfo_dum = $Net::SSLinfo::next_protos; # avoid Perl warning: "used only once: possible typo ..."
} # Net/SSLinfo.pm

{ # Net/SSLhello.pm
no strict 'subs';
## PACKAGE {
# Filename : SSLhello.pm
#!#############################################################################
#!#                    Copyright (c) 2022, Torsten Gigler
#!#             This module is part of the OWASP-Project 'o-saft'
#!# It simulates the SSLhello packets to check SSL parameters like the ciphers
#!#         indepenantly from any SSL library like Openssl or gnutls.
#!#----------------------------------------------------------------------------
#!#       THIS Software is in ALPHA state, please give us feed back via
#!#              https://lists.owasp.org/mailman/listinfo/o-saft
#!#----------------------------------------------------------------------------
#!# This software is provided "as is", without warranty of any kind, express or
#!# implied,  including  but not limited to  the warranties of merchantability,
#!# fitness for a particular purpose.  In no event shall the  copyright holders
#!# or authors be liable for any claim, damages or other liability.
#!# This software is distributed in the hope that it will be useful.
#!#
#!# This  software is licensed under GPLv2.
#!#
#!# GPL - The GNU General Public License, version 2
#!#                       as specified in:  http://www.gnu.org/licenses/gpl-2.0
#!#      or a copy of it https://github.com/OWASP/O-Saft/blob/master/LICENSE.md
#!# Permits anyone the right to use and modify the software without limitations
#!# as long as proper  credits are given  and the original  and modified source
#!# code are included. Requires  that the final product, software derivate from
#!# the original  source or any  software  utilizing a GPL  component, such  as
#!# this, is also licensed under the same GPL license.
#!#############################################################################

#!# WARNING:
#!# This is no "academically" certified code,  but written to be understood and
#!# modified by humans (you:) easily.  Please see the documentation  in section
#!# "Program Code" at the end of this file if you want to improve the program.

# TODO:  TLSv13: Decrypt and parse also the encrypted extensions.

## no critic qw(Subroutines::ProhibitSubroutinePrototypes)
#  NOTE:  Contrary to  Perl::Critic  we consider prototypes as useful, even if
#         the compile-time checks of Perl are not perfect,  Perl may give some
#         hints.

## no critic qw(Variables::ProhibitPackageVars)
#  NOTE:  we have a couple of global variables, but do not want to write them
#         in all CAPS (as it would be required by Perl::Critic)

## no critic qw(Subroutines::ProhibitExcessComplexity ControlStructures::ProhibitDeepNests Subroutines::ProhibitManyArgs)
#  yes, parts of this is is complex

## no critic qw(RegularExpressions::RequireExtendedFormatting)
#  because we use /x as needed for human readability

package Net::SSLhello;


use warnings;

BEGIN {
    # section required only when called as: Net/SSLhello.pm or ./SSLhello.pm
    my $_me   = $0; $_me   =~ s#.*[/\\]##;
    if ("SSLhello.pm" eq $_me) {
        my $_path = $0; $_path =~ s#[/\\][^/\\]*$##;
        unshift(@INC, ".", "lib");
        unshift(@INC, $ENV{PWD}, "$ENV{PWD}/lib") if (defined $ENV{'PWD'});
        unshift(@INC, "bin");
        if ($_path !~ m#^[.]/*$#) { # . already added
            unshift(@INC, "$_path", "$_path/lib") if ($_me ne $_path);
        }
        unshift(@INC, "../") if ($0 =~ m#^(?:[.]/)?SSLhello.pm#); # call in Net/
    }
}

our $VERSION    = "22.06.22";
my  $SID_sslhelo= "@(#) SSLhello.pm 1.53 22/07/05 00:00:34",
my  $SSLHELLO   = "O-Saft::Net::SSLhello";

use Socket; ## TBD will be deleted soon TBD ###
use IO::Socket::INET;
#require IO::Select if ($Net::SSLhello::trace > 1);
use Carp;
    # use internal error_handler, get all constants used for SSLHELLO, for subs
    # the full names will be used (includung OSaft::error_handler-><sub>)
#-# use OSaft::Text qw(%STR);
######################################################## public documentation #

=pod

=head1 _____________________________________________________________________________

=head1 NAME

Net::SSLhello - Perl module for SSL to simulate SSLhello packets to check SSL parameters (especially ciphers).
Connections via proxy and using STARTTLS (SMTP, IMAP, POP3, FTPS, LDAP, RDP, XMPP and experimental: ACAP) are supported.

=head1 SYNOPSIS

use Net::SSLhello;

=head1 DESCRIPTION

SSLhello.pm is a Perl Module that is part of the OWASP-Project 'o-saft'.
It checks some basic SSL/TLS configuration of a server, like ciphers and extensions (planned) of the SSL/TLS protocol. These checks work independently from any SSL library like OpenSSL or gnutls. It does this by simulating the first packets of a SSL/TLS connection. It sends a ClientHello message and analyses the ServerHello packet that is answered by the server. It gives you a wide range of options for this, so you can even check ciphers that are not yet defined, reserved or obsolete, by their 2-octet-values (see http://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-4).

As it simulates only the first part of the SSL/TLS handshake, it is really fast. Another advantage of this is that it can even analyse SSL/TLS ciphers of servers that verify client certificates without any need to provide a certificate (which is normally done later in the SSL/TLS handshake).

Export Functions:
$socket = openTcpSSLconnection ($host; $port); # Open a TCP/IP connection to a host on a port (via proxy) and doing STARTTLS if requested
@accepted = Net::SSLhello::checkSSLciphers ($host, $port, $ssl, @testing); # Check a list if ciphers (@testing), output: @accepted ciphers (if the first 2 ciphers are equal the server has an order)
Net::SSLhello::printCipherStringArray ($cfg{'legacy'}, $host, $port, $ssl, $sni, @accepted); # print the list of ciphers (@accepted ciphers)

=head1 METHODS

=cut


#our %main::cfg;    # provided by caller
our $dtlsEpoch = 0; # for DTLS only (globally)
our %_SSLhello;     # our internal data structure
our %resultHash;    # Hash that collects results
our %extensions_params_hash; # hasgh that (temporarily) defines parameters for an extension
our $my_error = ""; # global store for error message

use Exporter qw(import);
use base qw(Exporter);
our @EXPORT_OK  = qw(
        net_sslhello_done
        checkSSLciphers
        compileClientHello
        compileSSL2CipherArray
        compileTLSCipherArray
        hexCodedCipher
        hexCodedSSL2Cipher
        hexCodedString
        hexCodedTLSCipher
        openTcpSSLconnection
        parseServerHello
        parseServerKeyExchange
        parseSSL2_ServerHello
        parseTLS_Extension
        parseTLS_ServerHello
        printCipherStringArray
        printParameters
        printSSL2CipherList
        printTLSCipherList
        version
);

our $HAVE_XS = eval {
        local $SIG{'__DIE__'} = 'DEFAULT';
        eval {
            require XSLoader;
            XSLoader::load('Net::SSLhello', $VERSION);
            1;
        } or do {
            require DynaLoader;
            bootstrap Net::SSLhello $VERSION;
            1;
        };

    } ? 1 : 0;

use constant {  ## no critic qw(ValuesAndExpressions::ProhibitConstantPragma)
    _MY_SSL3_MAX_CIPHERS                => 64, # Max nr of ciphers sent in a SSL3/TLS Client-Hello to test if they are supported by the server, e.g. 32, 48, 64, 128, ...
    _MY_PRINT_CIPHERS_PER_LINE          =>  8, # Nr of ciphers printed in a trace
    _PROXY_CONNECT_MESSAGE1             => "CONNECT ",
    _PROXY_CONNECT_MESSAGE2             => " HTTP/1.1\n\n",
    _MAX_SEGMENT_COUNT_TO_RESET_RETRY_COUNT => 16, # Max number og TCP-Segments that can reset the retry counter to '0' for next read
    _SLEEP_B4_2ND_READ                  => 0.5,  # Sleep before second read (STARTTLS and proxy) [in sec.x]
    _DTLS_SLEEP_AFTER_FOUND_A_CIPHER    => 0.75, # DTLS-Protocol: Sleep after found a cipher to segregate the following request [in sec.x]
    _DTLS_SLEEP_AFTER_NO_CIPHERS_FOUND  => 0.05  # DTLS-Protocol: Sleep after not found a cipher to segregate the following request [in sec.x]
};

#our $LONG_PACKET = 1940; # try to get a 2nd or 3rd segment for long packets
#
#
#defaults for global parameters
$Net::SSLhello::trace               = 0;# 1=simple debugging Net::SSLhello
$Net::SSLhello::traceTIME           = 0;# 1=trace prints timestamp
$Net::SSLhello::usesni              = 1;# 0=do not use SNI extension, 1=use SNI extension (protocol >=tlsv1), 2(or 3): toggle sni (run twice per protocol without and with sni)
$Net::SSLhello::use_sni_name        = 0;# 0=use hostname (default), 1: use sni_name for SNI mode connections
$Net::SSLhello::sni_name            = "1";# name to be used for SNI mode connection is use_sni_name=1; ###FIX: "1": quickfix until migration of o-saft.pl is compleated (tbd)
$Net::SSLhello::force_TLS_extensions= 0;# prevent to not to use TLS extensions in SSLv3
$Net::SSLhello::timeout             = 2;# time in seconds
$Net::SSLhello::retry               = 3;# number of retry when timeout occurs
$Net::SSLhello::connect_delay       = 0;# time to wait in seconds for starting next cipher check
$Net::SSLhello::usereneg            = 0;# secure renegotiation
$Net::SSLhello::use_signature_alg   = 1;# signature_algorithm: 0 (off), 1 (auto on if >=TLSv1.2, >=DTLS1.2), 2: always on
$Net::SSLhello::useecc              = 1;# use 'Supported Elliptic' Curves Extension
$Net::SSLhello::useecpoint          = 1;# use 'ec_point_formats' extension
$Net::SSLhello::starttls            = 0;# 1= do STARTTLS
$Net::SSLhello::starttlsType        = "SMTP";# default: SMTP
@Net::SSLhello::starttlsPhaseArray  = [];# STARTTLS: customised phases (1-5) and error handling (6-8)
$Net::SSLhello::starttlsDelay       = 0;# STARTTLS: time to wait in seconds (to slow down the requests)
$Net::SSLhello::slowServerDelay     = 0;# proxy and STARTTLS: time to wait in seconds (for slow proxies and STARTTLS servers)
$Net::SSLhello::double_reneg        = 0;# 0=Protection against double renegotiation info is active
$Net::SSLhello::proxyhost           = "";#
$Net::SSLhello::proxyport           = "";#
$Net::SSLhello::experimental        = 0;# 0: experimental functions are protected (=not active)
$Net::SSLhello::max_ciphers         = _MY_SSL3_MAX_CIPHERS; # max nr of ciphers sent in a SSL3/TLS Client-Hello to test if they are supported by the server
$Net::SSLhello::max_sslHelloLen     = 16388; # according RFC: 16383+5 bytes; max len of sslHello messages (some implementations had issues with packets longer than 256 bytes)
$Net::SSLhello::noDataEqNoCipher    = 1; # 1= for some TLS intolerant servers 'NoData or timeout equals to no cipher' supported -> Do NOT abort to test next ciphers
$Net::SSLhello::extensions_by_prot  = \%{$cfg{extensions_by_prot}}; # get the list of all extensions used by protocol, SSLv2 does not support any extensions by design
$Net::SSLhello::check_extensions    = [ qw(supported_groups) ]; # List of extensions to be checked for all supported params
$Net::SSLhello::extensions_max_values = 50; # max retries to check for additional variables of extensions. Acts as watchdog protecting against endless loops while checking for extensions 

my %RECORD_TYPE = ( # RFC 5246
    'change_cipher_spec'    => 20,
    'alert'                 => 21,
    'handshake'             => 22,
    'application_data'      => 23,
    'heartbeat'             => 24,
    '255'                   => 255,
    '<<undefined>>'         => -1       # added for internal use
);

my %HANDSHAKE_TYPE = ( # RFC 5246
    'hello_request'         => 0,
    'client_hello'          => 1,
    'server_hello'          => 2,
    'hello_verify_request'  => 3,       # rfc4347 DTLS
    'certificate'           => 11,
    'server_key_exchange'   => 12,
    'certificate_request'   => 13,
    'server_hello_done'     => 14,
    'certificate_verify'    => 15,
    'client_key_exchange'   => 16,
    'finished'              => 20,
    '255'                   => 255,
    '<<undefined>>'         => -1,      # added for internal use
    '<<fragmented_message>>'=> -99      # added for internal use
);

my %PROTOCOL_VERSION = (
    'SSLv2'      => 0x0002,
    'SSLv3'      => 0x0300,
    'TLSv1'      => 0x0301, # TLS1.0 = SSL3.1
    'TLSv11'     => 0x0302, # TLS1.1
    'TLSv12'     => 0x0303, # TLS1.2
    'TLSv13'     => 0x0304, # TLS1.3, not YET specified
    'TLSv1.FF'   => 0x03FF, # Last possible Version of TLS1.x (NOT specified)
    'DTLSv09'    => 0x0100, # DTLS, OpenSSL pre 0.9.8f, not finally standardised (udp)
    'DTLSfamily' => 0xFE00, # DTLS1.FF, no defined PROTOCOL, for internal usea only (udp)
    'DTLSv1'     => 0xFEFF, # DTLS1.0 (udp)
    'DTLSv11'    => 0xFEFE, # DTLS1.1 (udp), has NEVER been used
    'DTLSv12'    => 0xFEFD, # DTLS1.2 (udp)
    'DTLSv13'    => 0xFEFC, # DTLS1.3 (udp), not YET specified
    'SCSV'       => 0x03FF  # adapted to o-saft.pl, was TLS1.FF # FIXME: TLS1.FF was better ;-) TBD: change it at o-saft.pl and delete it here
);

# reverse hash of PROTOCOL_VERSION
my %PROTOCOL_NAME_BY_HEX = reverse %PROTOCOL_VERSION;

# http://www.iana.org/assignments/tls-parameters/tls-parameters-6.csv
# Value,Description,DTLS-OK,Reference
my %TLS_AlertDescription = (
     0 => [qw(close_notify  Y  [RFC5246])],
    10 => [qw(unexpected_message  Y  [RFC5246])],
    20 => [qw(bad_record_mac  Y  [RFC5246])],
    21 => [qw(decryption_failed  Y  [RFC5246])],
    22 => [qw(record_overflow  Y  [RFC5246])],
    30 => [qw(decompression_failure  Y  [RFC5246])],
    40 => [qw(handshake_failure  Y  [RFC5246])],
    41 => [qw(no_certificate_RESERVED  Y  [RFC5246])],
    42 => [qw(bad_certificate  Y  [RFC5246])],
    43 => [qw(unsupported_certificate  Y  [RFC5246])],
    44 => [qw(certificate_revoked  Y  [RFC5246])],
    45 => [qw(certificate_expired  Y  [RFC5246])],
    46 => [qw(certificate_unknown  Y  [RFC5246])],
    47 => [qw(illegal_parameter  Y  [RFC5246])],
    48 => [qw(unknown_ca  Y  [RFC5246])],
    49 => [qw(access_denied  Y  [RFC5246])],
    50 => [qw(decode_error  Y  [RFC5246])],
    51 => [qw(decrypt_error  Y  [RFC5246])],
    60 => [qw(export_restriction_RESERVED  Y  [RFC5246])],
    70 => [qw(protocol_version  Y  [RFC5246])],
    71 => [qw(insufficient_security  Y  [RFC5246])],
    80 => [qw(internal_error  Y  [RFC5246])],
    86 => [qw(inappropriate_fallback  Y  [RFC5246_update-Draft-2014-05-31])], ### added according 'https://datatracker.ietf.org/doc/draft-bmoeller-tls-downgrade-scsv/?include_text=1'
    90 => [qw(user_canceled  Y  [RFC5246])],
    100 => [qw(no_renegotiation  Y  [RFC5246])],
    109 => [qw(missing_extension Y [RFC8446])],
    110 => [qw(unsupported_extension  Y  [RFC5246])],
    111 => [qw(certificate_unobtainable  Y  [RFC6066])],
    112 => [qw(unrecognized_name  Y  [RFC6066])],
    113 => [qw(bad_certificate_status_response  Y  [RFC6066])],
    114 => [qw(bad_certificate_hash_value  Y  [RFC6066])],
    115 => [qw(unknown_psk_identity  Y  [RFC4279])],
    116 => [qw(certificate_required  Y   [RFC8446])],
    120 => [qw(no_application_protocol Y [RFC7301][RFC8447])],
);

my %ECCURVE_TYPE = ( # RFC 4492
    'explicit_prime'        => 1,
    'explicit_char2'        => 2,
    'named_curve'           => 3,
    'reserved_248'          => 248,
    'reserved_249'          => 249,
    'reserved_250'          => 250,
    'reserved_251'          => 251,
    'reserved_252'          => 252,
    'reserved_253'          => 253,
    'reserved_254'          => 254,
    'reserved_255'          => 255,
);

#http://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-10
#Value =>     Description   bits(added) DTLS-OK RECOMMENDED Reference
#my %TLS_SUPPORTED_GROUPS = (
my %ECC_NAMED_CURVE = (
     0 => [qw(Reverved_0              0 N   N   [RFC8447])],
     1 => [qw(sect163k1             163 Y   N   [RFC4492])],
     2 => [qw(sect163r1             163 Y   N   [RFC4492])],
     3 => [qw(sect163r2             163 Y   N   [RFC4492])],
     4 => [qw(sect193r1             193 Y   N   [RFC4492])],
     5 => [qw(sect193r2             193 Y   N   [RFC4492])],
     6 => [qw(sect233k1             233 Y   N   [RFC4492])],
     7 => [qw(sect233r1             233 Y   N   [RFC4492])],
     8 => [qw(sect239k1             239 Y   N   [RFC4492])],
     9 => [qw(sect283k1             283 Y   N   [RFC4492])],
    10 => [qw(sect283r1             283 Y   N   [RFC4492])],
    11 => [qw(sect409k1             409 Y   N   [RFC4492])],
    12 => [qw(sect409r1             409 Y   N   [RFC4492])],
    13 => [qw(sect571k1             571 Y   N   [RFC4492])],
    14 => [qw(sect571r1             571 Y   N   [RFC4492])],
    15 => [qw(secp160k1             160 Y   N   [RFC4492])],
    16 => [qw(secp160r1             160 Y   N   [RFC4492])],
    17 => [qw(secp160r2             160 Y   N   [RFC4492])],
    18 => [qw(secp192k1             192 Y   N   [RFC4492])],
    19 => [qw(secp192r1             192 Y   N   [RFC4492])],
    20 => [qw(secp224k1             224 Y   N   [RFC4492])],
    21 => [qw(secp224r1             224 Y   N   [RFC4492])],
    22 => [qw(secp256k1             256 Y   N   [RFC4492])],
    23 => [qw(secp256r1             256 Y   Y   [RFC4492])],
    24 => [qw(secp384r1             384 Y   Y   [RFC4492])],
    25 => [qw(secp521r1             521 Y   N   [RFC4492])],
    26 => [qw(brainpoolP256r1       256 Y   Y   [RFC7027])],
    27 => [qw(brainpoolP384r1       384 Y   Y   [RFC7027])],
    28 => [qw(brainpoolP512r1       512 Y   Y   [RFC7027])],
    29 => [qw(x25519                255 Y   Y   [RFC8446][RFC8422])],
    30 => [qw(x448                  448 Y   Y   [RFC8446][RFC8422])],
    31 => [qw(brainpoolP256r1tls13  256 Y   N   [RFC8734])],
    32 => [qw(brainpoolP384r1tls13  384 Y   N   [RFC8734])],
    33 => [qw(brainpoolP512r1tls13  512 Y   N   [RFC8734])],
    34 => [qw(GC256A                256 Y   N   [draft-smyshlyaev-tls12-gost-suites])],
    35 => [qw(GC256B                256 Y   N   [draft-smyshlyaev-tls12-gost-suites])],
    36 => [qw(GC256C                256 Y   N   [draft-smyshlyaev-tls12-gost-suites])],
    37 => [qw(GC256D                256 Y   N   [draft-smyshlyaev-tls12-gost-suites])],
    38 => [qw(GC512A                512 Y   N   [draft-smyshlyaev-tls12-gost-suites])],
    39 => [qw(GC512B                512 Y   N   [draft-smyshlyaev-tls12-gost-suites])],
    40 => [qw(GC512C                512 Y   N   [draft-smyshlyaev-tls12-gost-suites])],
    41 => [qw(curveSM2              256 N   N   [draft-yang-tls-tls13-sm-suites])],
#   42-255  Unassigned
   256 => [qw(ffdhe2048            2048 Y   N   [RFC7919])],
   257 => [qw(ffdhe3072            3072 Y   N   [RFC7919])],
   258 => [qw(ffdhe4096            4096 Y   N   [RFC7919])],
   259 => [qw(ffdhe6144            6144 Y   N   [RFC7919])],
   260 => [qw(ffdhe8192            8192 Y   N   [RFC7919])],
#  261-507 Unassigned,
   508 => [qw(Private_508             NN Y   N   [RFC7919])],
   509 => [qw(Private_509             NN Y   N   [RFC7919])],
   510 => [qw(Private_510             NN Y   N   [RFC7919])],
   511 => [qw(Private_511             NN Y   N   [RFC7919])],
#  512-2569    Unassigned           ,
  2570 => [qw(Reserved_2570          NN Y   N   [RFC8701])],
# 2571-6681    Unassigned           ,
  6682 => [qw(Reserved_6682          NN Y   N   [RFC8701])],
# 6683-10793   Unassigned           ,
 10794 => [qw(Reserved_10794         NN Y   N   [RFC8701])],
#10795-14905   Unassigned           ,
 14906 => [qw(Reserved_14906         NN Y   N   [RFC8701])],
#14907-19017   Unassigned           ,
 19018 => [qw(Reserved_19018         NN Y   N   [RFC8701])],
#19019-23129   Unassigned           ,
 23130 => [qw(Reserved_23130         NN Y   N   [RFC8701])],
#23131-27241   Unassigned           ,
 27242 => [qw(Reserved_27242         NN Y   N   [RFC8701])],
#27243-31353   Unassigned           ,
 31354 => [qw(Reserved_31354         NN Y   N   [RFC8701])],
#31355-35465   Unassigned           ,
 35466 => [qw(Reserved_35466         NN Y   N   [RFC8701])],
#35467-39577   Unassigned           ,
 39578 => [qw(Reserved_39578         NN Y   N   [RFC8701])],
#39579-43689   Unassigned           ,
 43690 => [qw(Reserved_43690         NN Y   N   [RFC8701])],
#43691-47801   Unassigned           ,
 47802 => [qw(Reserved_47802         NN Y   N   [RFC8701])],
#47803-51913   Unassigned           ,
 51914 => [qw(Reserved_51914         NN Y   N   [RFC8701])],
#51915-56025   Unassigned           ,
 56026 => [qw(Reserved_56026         NN Y   N   [RFC8701])],
#56027-60137   Unassigned           ,
 60138 => [qw(Reserved_60138         NN Y   N   [RFC8701])],
#60139-64249   Unassigned           ,
 64250 => [qw(Reserved_64250         NN Y   N   [RFC8701])],
#64251-65023   Unassigned           ,
#65024-65279   Reserved_for_Private_Use NN Y N [RFC8422],
#65280         Unassigned
 65281 => [qw(arbitrary_explicit_prime_curves  -variable- Y    N   [RFC8422])],
 65282 => [qw(arbitrary_explicit_char2_curves  -variable- Y    N   [RFC8422])],
#65283-65535  Unassigned          ,
);

##################################################################################
# List of Functions
##################################################################################
sub checkSSLciphers         ($$$@);
sub printCipherStringArray  ($$$$$@);
sub _timedOut;
sub _error;
sub _compileAllBytes        ($$$$$$;$$);
sub _decode_val             ($$$;$$$$$$);
sub _sprintf_hex_val        ($$;$);


# TODO: import/export of the trace-function from o-saft-dbx.pm;
# this is a workaround to get trace running using parameter '$Net::SSLhello::trace'
## forward declarations
#sub _trace  {};
#sub _trace1 {};
#sub _trace2 {};
#sub _trace3 {};
## Print errors; debugging
#sub _error    { local $\ = "\n"; print ">>>Net::SSLhello>>> ERROR: " . join(" ", @_); }
#sub _trace_   { _trace (@_); }
#sub _trace1_  { _trace1(@_); }
#sub _trace2_  { _trace2(@_); }
#sub _trace3_  { _trace3(@_); }
#sub _trace4($){ print "# Net::SSLhello::" . join(" ", @_) if ($Net::SSLhello::trace >3); }
#sub _trace4_  { _trace4(@_); }

sub _y_ts      { if ($Net::SSLhello::traceTIME <= 0)  { return ""; }            return sprintf("[%02s:%02s:%02s] ", (localtime)[2,1,0]) }

sub _trace($)  { my @messages = @_; local $\ = ""; print "#" . _y_ts() . $SSLHELLO . "::" . $messages[0]                 if ($Net::SSLhello::trace > 0); return }
sub _trace0($) { my @messages = @_; local $\ = ""; print "#" . _y_ts() . $SSLHELLO . "::"                                if ($Net::SSLhello::trace > 0); return }
sub _trace1($) { my @messages = @_; local $\ = ""; print "# " . _y_ts() . $SSLHELLO . "::" . join(" ", @messages)        if ($Net::SSLhello::trace > 1); return }
sub _trace2($) { my @messages = @_; local $\ = ""; print "# --> " . _y_ts() . $SSLHELLO . "::" . join(" ", @messages)    if ($Net::SSLhello::trace > 2); return }
sub _trace3($) { my @messages = @_; local $\ = ""; print "# --> " . _y_ts() . $SSLHELLO . "::" . join(" ", @messages)    if ($Net::SSLhello::trace ==3); return }
sub _trace4($) { my @messages = @_; local $\ = ""; print "#   ---> " . _y_ts() . $SSLHELLO . "::" . join(" ", @messages) if ($Net::SSLhello::trace > 3); return }
sub _trace5($) { my @messages = @_; local $\ = ""; print "#   ---> " . _y_ts() . $SSLHELLO . "::" . join(" ", @messages) if ($Net::SSLhello::trace > 4); return }
sub _trace_($) { my @messages = @_; local $\ = ""; print " " . join(" ", @messages)                                     if ($Net::SSLhello::trace > 0); return }
sub _trace1_($){ my @messages = @_; local $\ = ""; print " " . join(" ", @messages)                                     if ($Net::SSLhello::trace > 1); return }
sub _trace2_($){ my @messages = @_; local $\ = ""; print join(" ", @messages)                                           if ($Net::SSLhello::trace > 2); return }
sub _trace3_($){ my @messages = @_; local $\ = ""; print join(" ", @messages)                                           if ($Net::SSLhello::trace ==3); return }
sub _trace4_($){ my @messages = @_; local $\ = ""; print join(" ", @messages)                                           if ($Net::SSLhello::trace > 3); return }
sub _trace5_($){ my @messages = @_; local $\ = ""; print join(" ", @messages)                                           if ($Net::SSLhello::trace > 4); return }

sub _carp   {
    #? print warning message if wanted
    # don't print if --no-warning given
    my @txt = @_;
    return if ((grep{/(:?--no.?warn)/ix} @main::ARGV) > 0);
    local $\ = "\n"; carp($OSaft::Text::STR{WARN}, join(" ", @txt));
    return;
}

sub _hint   {
    #? print hint message if wanted
    # don't print if --no-hint given
    my @txt = @_;
    return if ((grep{/(:?--no.?hint)/ix} @main::ARGV) > 0);
    local $\ = "\n"; print($OSaft::Text::STR{HINT}, join(" ", @txt));
    return;
}

#if (! eval("require o-saft-dbx.pm;")) {
#        # o-saft-dbx.pm may not be installed, try to find in program's directory
#        push(@INC, $main::mepath);
#        require "o-saft-dbx.pm";
#}


#   trace output for known and unknown formts
sub _sprintf_hex_val ($$;$) {
    my $_format         = shift(@_);
    my $_val_ref        = shift(@_);
    my $_indent         = shift(@_) || 0;
    my $_hex_str        = "";
    my $_format_string  = $_format || "-- undef --";

    _trace5_(" " x $_indent . "#   ---> _sprintf_hex_val: \$_format: '$_format_string' -> ");
    if (! defined ($_format)) {                                     # guess format, if not defined
        if (! defined ($_val_ref)) {
            _trace5 ("-- undefined value --\n");
            return ("-- undefined value --");
        }
        _trace5_ ("if (\$\$_val_ref =~ /\^\\d+\$/); defined (\$\$_val_ref) = " . defined ($$_val_ref) ." -> ");
        if (! defined ($$_val_ref)) {
            _trace5_ ("'' (empty value)\n");
            return ("");
        }
        if ($$_val_ref =~ /^\d+$/) {                                # number
            _trace5_ ("number (auto) -> ");
            if ($$_val_ref <= 0xFF) {
                $_format = "%02X";
            } elsif ($$_val_ref <= 0xFFFF) {
                $_format = "%04X";
            } elsif ($$_val_ref <= 0xFFFFFFFF) {
                $_format = "%08X";
            } else {                                                # number is too big
                $_format = "%016X";
            }
        } else {                                                    # no number
            $_format = "";
        }
    }
    if ($_format ne "") {
        _trace5_ ("formated string: ");
        $_hex_str = sprintf($_format, $$_val_ref);
        $_hex_str =~ s/[0-9A-Fa-f]{2}/"$& "/eigx;                   # add a space after 2 Hex vals
    } else {                                                        # unformated string
        _trace5_ ("val: unformated string: ");
        $_hex_str = sprintf("%*v2.2x", ' ', $$_val_ref);
    }
    $_hex_str =~ s/\s*$//;                                          # remove white spaces at line ends
    $_hex_str =~ s/((?:[0-9A-Fa-f]{2}\s){16})(?=[0-9A-Fa-f]{2})/"$&\n"." " x $_indent/eigx; # addd a colon and a space between value and descriptiond a new line each 16 HEX-octetts if last octett has not been reached
    _trace5_ ("$_hex_str\n");
    return ($_hex_str);
}

sub _sprintf_val_description ($$;$$) {
    my $_def_hash_ref   = shift(@_);
    my $_val_ref        = shift(@_);
    my $_indent         = shift(@_) || 0;
    my $_descr_sep      = shift(@_) || " ";
    my $_descr_str      = "";
    my $_text_sep       = ": ";                                     # add a colon and a space between value and description
    if ($Net::SSLhello::trace >= 5) {                               #               ? value if TRUE                         : value if FALSE
        my $_val_ref_print      = (defined ($_val_ref))                             ? ref ($_val_ref) . ": "
                                                                                       . _sprintf_hex_val (undef, $_val_ref, $_indent)
                                                                                                                            : "-- undef --";
        my $_def_hash_ref_print = (defined ($_def_hash_ref))                        ? ref ($_def_hash_ref)                  : "-- undef --";
        if ( (defined ($_def_hash_ref)) && (ref ($_def_hash_ref) eq "HASH") ) {
            $_def_hash_ref_print   .= ": ->{FORMAT}: ";
            $_def_hash_ref_print   .= (defined ($_def_hash_ref->{FORMAT}))          ? "defined"                             : "-- undef --";
            if (defined($_val_ref)) {
                $_def_hash_ref_print   .= ", ->{$$_val_ref}: ";
                $_def_hash_ref_print   .= (defined ($_def_hash_ref->{$$_val_ref}))  ? "defined"                             : "-- undef --";
            }
        }
        print " " x $_indent . "#   ---> _sprintf_val_description: (\$_val_ref = <<$_val_ref_print>>, \$_def_hash_ref = <<$_def_hash_ref_print>>)\n";
    }
    return ("") if (! defined($_def_hash_ref));
    return ("") if (! defined($_val_ref));
    if (ref ($_def_hash_ref) eq "HASH") {                           # $_def_hash_ref is a REF to a HASH
        # _trace5_ (" " x ($_indent + 3) . "#   ---> _sprintf_val_description: \$_def_hash_ref is a HASH\n");
        if (defined ($_def_hash_ref->{FORMAT})) {
            # _trace5_ (" " x ($_indent + 3) . "#   ---> _sprintf_val_description: \$_def_hash_ref->{FORMAT} is defined\n");
            if (defined ($_def_hash_ref->{$$_val_ref})) {
                # _trace5_ (" " x ($_indent + 3) . "#   ---> _sprintf_val_description: \$_def_hash_ref->{$$_val_ref} is defined\n");
                if (ref ($_def_hash_ref->{FORMAT}) eq "ARRAY") {
                    _trace5_ (" " x $_indent . "#   ---> add ".(@{$_def_hash_ref->{FORMAT}})." description(s)\n");
                    $_descr_str .= $_text_sep;                      # add a colon and a space between value and description(s)
                    for (my $_j = 0; $_j < (@{$_def_hash_ref->{FORMAT}}); $_j++) { # all elements of the description array for $$_val_ref
                        $_descr_str .= $_descr_sep if ($_j >= 1);
                        _trace5_ (" " x $_indent . "#   ---> \$_descr_str .= sprintf \($_def_hash_ref->{FORMAT}[$_j], $_def_hash_ref->{$$_val_ref}[$_j]\)\n");
                        $_descr_str .= sprintf ($_def_hash_ref->{FORMAT}[$_j], $_def_hash_ref->{$$_val_ref}[$_j]) if (defined ($_def_hash_ref->{$$_val_ref}[$_j]));
                    }
                }
            }
        }
    } elsif (ref ($_def_hash_ref) eq "SCALAR") {                    # $_def_hash_ref is a REF to a SCALAR, e.g. text
        $_descr_str .= $_text_sep.$$_def_hash_ref;
    } elsif (ref (\$_def_hash_ref) eq "SCALAR") {                   # $_def_hash_ref is not a REF but a SCALAR, e.g. text
        $_descr_str .= $_text_sep.$_def_hash_ref;
    }
    _trace5_(" " x ($_indent). "# ---> _sprintf_val_description: \$_descr_str = '$_descr_str'\n");
    return ($_descr_str);
}

sub _decode_val ($$$;$$$$$$) {
    #? decodes and (s)sprints values and up to double nested arrays (= arrays of arrays of arrays)
    #? prints and adds warnings to the output if the variable is even more deeply nestested or in an unsupported format
    my $_format         = shift(@_);                                # reference to a sprintf-format to print the value, or "" for unformatted strings or undef for autoformat for unknown formats (best effort)
    my $_val_ref        = shift(@_);                                # reference to a scalar or an up to double nested array (= array of array of array)
    my $_def_hash_ref   = shift(@_);                                # definition to decode the value: might be a ref to a hash, a ref to this ref or a simple scalara or undef
    my $_first_indent   = shift(@_) || 0;                           # optional: ident in the first line
    my $_next_indent    = shift(@_) || 0;                           # optional: ident from the second line onwards
    my $_text_sep       = shift(@_) || ":\n". " " x $_next_indent;  # optional: add a colon, a new line and an indent between section headline (e.g. 'sequence') and value
    my $_sub_sep        = shift(@_) || ", ";                        # optional: sub seperators of elements or arrays
    my $_sub_sub_sep    = shift(@_) || " | ";                       # optional: sub-sub seperators of array elements or nested arrays (arrays of arrays)
    my $_sub3_sep       = shift(@_) || " / ";                       # optional: sub³ seperators of nested array elements (or error messages for more deeply nested attays 
    my $_sub_lines      = 0;
    my $_sub_sub_lines  = 0;
    my $_sub3_lines     = 0;
    my $_decode_str     = "";
    my $_format_print   = $_format;
    $_format_print      = "-- undef --" if (! defined ($_format));

    _trace5_ (" " x $_next_indent . "# _decode_val (\$_format: '$_format_print', \$val_ref, \$_def_hash_ref, \$_first_indent: '$_first_indent', \$_next_indent: '$_next_indent', \$_text_sep: '$_text_sep', \$_sub_sep: '$_sub_sep', \$_sub_sub_sep: '$_sub_sub_sep', \$_sub3_sep: '$_sub3_sep ')\n");
    $_decode_str = " " x $_first_indent;
    if (defined ($_def_hash_ref)) {
        _trace5_ (" " x ($_next_indent + 2) ."# --->> def_hash-ref-Type:     ".ref($_def_hash_ref)."<<\n");
        _trace5_ (" " x ($_next_indent + 2) ."# --->> def_hash-ref-ref-Type: ".ref($$_def_hash_ref)."<<\n") if (ref ($_def_hash_ref) eq 'REF');
        _trace5_ (" " x ($_next_indent + 2) ."# --->> def_hash-val-Type:     ".ref(\$_def_hash_ref)."<<\n");
        $_def_hash_ref = $$_def_hash_ref if (ref ($_def_hash_ref) eq 'REF');           # reference to a reference => reference
        if (ref ($_def_hash_ref) eq "HASH") {                       # $_def_hash_ref is a REF to a HASH
            $_decode_str .= $_def_hash_ref->{TEXT}.$_text_sep if (defined ($_def_hash_ref->{TEXT}));
        }
        if (! defined($_val_ref)) {                                 # check for (simple) SCALAR info if any value define (e.g. section headline, e.g. 'sequence'
            if (ref ($_def_hash_ref) eq "SCALAR") {                 # $_def_hash_ref is a REF to a SCALAR, e.g. text
                $_decode_str .= $$_def_hash_ref.$_text_sep;
            } elsif (ref (\$_def_hash_ref) eq "SCALAR") {           # $_def_hash_ref is not a REF but a SCALAR, e.g. text
                $_decode_str .= $_def_hash_ref.$_text_sep;
            }
        }
        _trace5_ (" " x ($_next_indent + 2) . "# \$_decode_str: $_decode_str\n");
    }
    return ($_decode_str) if (! defined($_val_ref));
    _trace5_ (" " x ($_next_indent + 2) ."# ---> val-Type:     ".ref($_val_ref)."<\n");
    _trace5_ (" " x ($_next_indent + 2) ."# ---> val-ref-Type: ".ref($$_val_ref)."<\n") if (ref ($_val_ref) eq 'REF');
    $_val_ref = $$_val_ref if (ref ($_val_ref) eq 'REF');           # reference to a reference => reference
    if (ref ($_val_ref) eq 'SCALAR') {                              # value
        $_decode_str .= _sprintf_hex_val         ($_format,       $_val_ref, $_next_indent + 2);
        $_decode_str .= _sprintf_val_description ($_def_hash_ref, $_val_ref, $_next_indent + 2);
    } elsif (ref ($_val_ref) eq 'ARRAY') {                          # array
        $_decode_str .= "[ ";
        $_next_indent += 2;
        if ( (@{$_val_ref}) >= 1) {
            foreach my $ele (@{$_val_ref}) {
                _trace5_ (" " x ($_next_indent + 2)."# ---|> val-ref-Type (\$ele): ".ref(\$ele)."<|\n");
                $_decode_str .=  $_sub_sep if ($_sub_lines++ > 0);  # add a sup-sep an a new line with an indent für next nested array;
                if (ref (\$ele) eq 'SCALAR') {                      # values of the array
                    $_decode_str .= _sprintf_hex_val         ($_format,       \$ele, $_next_indent + 2);
                    $_decode_str .= _sprintf_val_description ($_def_hash_ref, \$ele, $_next_indent + 2);
                } elsif (ref ($ele) eq 'ARRAY') {                   # nested array, e.g. sequence
                    $_decode_str .=  "[ ";
                    $_next_indent += 2;
                    if ( (@{$ele}) >= 1) {
                        $_sub_sub_lines = 0;                        # reset sub_sub_lines
                        foreach my $ele_ele (@{$ele}) {
                            _trace5_ (" " x ($_next_indent + 2)."# ---||> val-ref-Type (\$ele_ele): ".ref(\$ele_ele)."<||\n");
                            $_decode_str .= $_sub_sub_sep if ($_sub_sub_lines++ > 0);                           # add a sub-sub-separator if not the first element
                            if (ref (\$ele_ele) eq 'SCALAR') {      # values of the nested array (array of arrays)
                                $_decode_str .= _sprintf_hex_val         ($_format,       \$ele_ele, $_next_indent + 2);
                                $_decode_str .= _sprintf_val_description ($_def_hash_ref, \$ele_ele, $_next_indent + 2);
                            } elsif (ref ($ele_ele) eq 'ARRAY') {   # doulble nested array (array of array of arrays)
                                $_decode_str .=  "[ ";
                                $_next_indent += 2;
                                if ( (@{$ele_ele}) >= 1) {
                                    $_sub3_lines = 0;               # reset sub_sub_lines
                                    foreach my $ele3 (@{$ele_ele}) {
                                        _trace5_ (" " x ($_next_indent + 2)."# --|||> val-ref-Type (\$ele3):    ".ref(\$ele3)."<|||\n");
                                        $_decode_str .= $_sub3_sep if ($_sub3_lines++ > 0); # add a sub3-separator if not the first element
                                        if (ref (\$ele3) eq 'SCALAR') { # values of the double nested array (array of array of arrays)
                                            $_decode_str .= _sprintf_hex_val         ($_format,       \$ele3, $_next_indent + 2);
                                            $_decode_str .= _sprintf_val_description ($_def_hash_ref, \$ele3, $_next_indent + 2);
                                        } else {                    # deeply nested array is not supported
                                            _trace2_ (" " x ($_next_indent + 2) ."# --|||> **WARNING: SSLhello::_decode_val: try to print unsupported or deeply nested val type (\$ele3): '" . ref(\$ele3) ."/". ref($ele3) ."' <|||\n");
                                            carp ("**WARNING: SSLhello::_decode_val: try to print unsupported or deeply nested val type (\$ele3): '" . ref(\$ele3) ."/". ref($ele3) ."'\n");

                                            $_decode_str .= "[ --- unsupported or deeply nested val type (\$ele3): '". ref(\$ele3) ."/". ref($ele3) ."' --- ]";
                                        } # ref (\$ele3)
                                    } # foreach $ele3
                                }
                                $_decode_str .= " ]";
                                $_next_indent -= 2;
                            } else {                                # unsupported val type of $ele_ele
                                _trace2_ (" " x ($_next_indent + 2) ."**WARNING: SSLhello::_decode_val: try to print unsupported val-refref-Type (\$ele_ele):    ".ref($ele_ele)."<\n");
                                carp ("**WARNING: SSLhello::_decode_val: try to print unsupported val type (\$ele_ele): '" . ref(\$ele_ele) ."/". ref($ele_ele) ."'\n");
                                $_decode_str .= "[ --- unsupported val type (\$ele_ele): '". ref(\$ele_ele) ."/". ref($ele_ele) ."' --- ]";
                            } # ref (\$ele_ele)
                        } # foreach $ele_ele
                    }
                    $_decode_str .= " ]";
                    $_next_indent -= 2;
                } else {                                            # unsupported val type of $ele
                    _trace2_ (" " x ($_next_indent + 2) ."**WARNING: SSLhello::_decode_val: try to print unsupported val-refref-Type (\$ele):    ".ref($ele)."<\n");
                    carp ("**WARNING: SSLhello::_decode_val: try to print unsupported val type (\$ele): '" . ref(\$ele) ."/". ref($ele) . "'\n");
                    $_decode_str .= "[ --- unsupported val type (\$ele_ele): '". ref(\$ele) ."/". ref($ele) ."' --- ]";
                } # ref (\$ele)
            } # foreach $ele
        }
        $_decode_str .= " ]";
        $_next_indent -= 2;
    } else {                                                        # unsupported val type of $$_val_ref
        _trace2_ (" " x ($_next_indent + 2) ."**WARNING: SSLhello::_decode_val: try to print unsupported val-refref-Type:             " . ref($_val_ref)."<\n");
        carp ("**WARNING: SSLhello::_decode_val: try to print unsupported val type: '" . ref(\$_val_ref) ."/". ref($_val_ref) ."'\n");
        $_decode_str .= "[ --- unsupported val type: '". ref(\$_val_ref) ."/". ref($_val_ref) ."' --- ]";
    } # if ref ($_val_ref)
#    $_next_indent -= 3;
    _trace5_ (" " x $_next_indent . "#   ---> _decode_val: \$_decode_str: '$_decode_str'\n");
    return ($_decode_str);
} # end of _decode_val ();

###################################################################################

my $CHALLENGE = "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20o-saft\xbb\xcc\xdd\xee\xff"; # 16-32 bytes,

##################################################################################
# sslv2
##################################################################################
#http://www-archive.mozilla.org/projects/security/pki/nss/ssl/draft02.html
##################################################################################
# Information: not all parameters are used within SSLhello.pm

#C.1 Protocol Version Codes
my $SSL_CLIENT_VERSION            = 0x0002;
my $SSL_SERVER_VERSION            = 0x0002;

#C.2 Protocol Message Codes
#The following values define the message codes that are used by version 2 of the SSL Handshake Protocol.

# SSL2_PROTOCOL_MESSAGE_CODES
my $SSL_MT_ERROR                = 0;
my $SSL_MT_CLIENT_HELLO         = 1;
my $SSL_MT_CLIENT_MASTER_KEY    = 2;
my $SSL_MT_CLIENT_FINISHED      = 3;
my $SSL_MT_SERVER_HELLO         = 4;
my $SSL_MT_SERVER_VERIFY        = 5;
my $SSL_MT_SERVER_FINISHED      = 6;
my $SSL_MT_REQUEST_CERTIFICATE  = 7;
my $SSL_MT_CLIENT_CERTIFICATE   = 8;

#C.3 Error Message Codes
#The following values define the error codes used by the ERROR message.
my $SSL_PE_NO_CIPHER            = 0x0001;
my $SSL_PE_NO_CERTIFICATE       = 0x0002;
my $SSL_PE_BAD_CERTIFICATE      = 0x0004;
my $SSL_PE_UNSUPPORTED_CERTIFICATE_TYPE = 0x0006;

#C.5 Certificate Type Codes
#The following values define the certificate type codes used in the SERVER-HELLO and CLIENT-CERTIFICATE messages.
my $SSL_CT_X509_CERTIFICATE     = 0x01;

#C.6 Authentication Type Codes
#The following values define the authentication type codes used in the REQUEST-CERTIFICATE message.
my $SSL_AT_MD5_WITH_RSA_ENCRYPTION  = 0x01;

#C.7 Upper/Lower Bounds
#The following values define upper/lower bounds for various protocol parameters.
my $SSL_MAX_MASTER_KEY_LENGTH_IN_BITS   = 256;
my $SSL_MAX_SESSION_ID_LENGTH_IN_BYTES  = 16;
my $SSL_MIN_RSA_MODULUS_LENGTH_IN_BYTES = 64;
my $SSL_MAX_RECORD_LENGTH_2_BYTE_HEADER = 32767;
my $SSL_MAX_RECORD_LENGTH_3_BYTE_HEADER = 16383;

#C.8 Recommendations
#Because protocols have to be implemented to be of value, we recommend the following values for various operational parameters. This is only a recommendation, and not a strict requirement for conformance to the protocol.

#################################################################
my %cipherHexHash = (
#!#----------------------------------------+-------------+--------------------+
#!# Protocol: SSL2 (uppercase!)
#!#----------------------------------------+-------------+--------------------+
#!# cipher suite hex value => [ cipher_name1 cipher_name2 ],
#!#----------------------------------------+-------------+--------------------+
  '0x020700C0'=> [qw(DES_192_EDE3_CBC_WITH_MD5                DES-CBC3-MD5)],
  '0x020701C0'=> [qw(DES_192_EDE3_CBC_WITH_SHA                DES-CBC3-SHA)],
  '0x02060040'=> [qw(DES_CBC_WITH_MD5                         DES-CBC-MD5)],
  '0x02060140'=> [qw(DES_CBC_WITH_SHA                         DES-CBC-SHA)],
  '0x02FF0800'=> [qw(DES_64_CFB64_WITH_MD5_1                  DES-CFB-M1)],
  '0x02050080'=> [qw(IDEA_CBC_WITH_MD5                        IDEA-CBC-MD5)],
  '0x02FF0810'=> [qw(NULL                                     NULL)],
  '0x02000000'=> [qw(NULL_WITH_MD5                            NULL-MD5)],
  '0x02040080'=> [qw(RC2_128_CBC_EXPORT40_WITH_MD5            EXP-RC2-CBC-MD5)],
  '0x02030080'=> [qw(RC2_128_CBC_WITH_MD5                     RC2-CBC-MD5)],
  '0x02020080'=> [qw(RC4_128_EXPORT40_WITH_MD5                EXP-RC4-MD5)],
  '0x02010080'=> [qw(RC4_128_WITH_MD5                         RC4-MD5)],
  '0x02080080'=> [qw(RC4_64_WITH_MD5                          RC4-64-MD5)],

#!#----------------------------------------+-------------+--------------------+
#!# Protocol: SSL3 (invented)
#!#----------------------------------------+-------------+--------------------+
#!# cipher suite hex value => [ cipher_name1 cipher_name2 ],
#!#----------------------------------------+-------------+--------------------+
  '0x0300001B'=> [qw(DH_anon_WITH_3DES_EDE_CBC_SHA            ADH-DES-CBC3-SHA)],
  '0x03000019'=> [qw(DH_anon_EXPORT_WITH_DES40_CBC_SHA        EXP-ADH-DES-CBC-SHA)],
  '0x0300001A'=> [qw(DH_anon_WITH_DES_CBC_SHA                 ADH-DES-CBC-SHA)],
  '0x03000018'=> [qw(DH_anon_WITH_RC4_128_MD5                 ADH-RC4-MD5)],
  '0x03000017'=> [qw(DH_anon_EXPORT_WITH_RC4_40_MD5           EXP-ADH-RC4-MD5)],
  '0x0300000D'=> [qw(DH_DSS_WITH_3DES_EDE_CBC_SHA             DH-DSS-DES-CBC3-SHA)],
  '0x0300000B'=> [qw(DH_DSS_EXPORT_WITH_DES40_CBC_SHA         EXP-DH-DSS-DES-CBC-SHA)],
  '0x0300000C'=> [qw(DH_DSS_WITH_DES_CBC_SHA                  DH-DSS-DES-CBC-SHA)],
  '0x03000010'=> [qw(DH_RSA_WITH_3DES_EDE_CBC_SHA             DH-RSA-DES-CBC3-SHA)],
  '0x0300000E'=> [qw(DH_RSA_EXPORT_WITH_DES40_CBC_SHA         EXP-DH-RSA-DES-CBC-SHA)],
  '0x0300000F'=> [qw(DH_RSA_WITH_DES_CBC_SHA                  DH-RSA-DES-CBC-SHA)],
  '0x03000013'=> [qw(EDH_DSS_WITH_3DES_EDE_CBC_SHA            EDH-DSS-DES-CBC3-SHA)],
  '0x03000011'=> [qw(EDH_DSS_EXPORT_WITH_DES40_CBC_SHA        EXP-EDH-DSS-DES-CBC-SHA)],
  '0x03000012'=> [qw(EDH_DSS_WITH_DES_CBC_SHA                 EDH-DSS-DES-CBC-SHA)],
  '0x03000016'=> [qw(EDH_RSA_WITH_3DES_EDE_CBC_SHA            EDH-RSA-DES-CBC3-SHA)],
  '0x03000014'=> [qw(EDH_RSA_EXPORT_WITH_DES40_CBC_SHA        EXP-EDH-RSA-DES-CBC-SHA)],
  '0x03000015'=> [qw(EDH_RSA_WITH_DES_CBC_SHA                 EDH-RSA-DES-CBC-SHA)],
  '0x0300001D'=> [qw(FZA_DMS_FZA_SHA                          FZA-FZA-CBC-SHA)],
  '0x0300001C'=> [qw(FZA_DMS_NULL_SHA                         FZA-NULL-SHA)],
  '0x0300001E'=> [qw(FZA_DMS_RC4_SHA/KRB5_WITH_DES_CBC_SHA    FZA-RC4-SHA/KRB5-DES-SHA)],
  '0x03000023'=> [qw(KRB5_WITH_3DES_EDE_CBC_MD5               KRB5-DES-CBC3-MD5)],
  '0x0300001F'=> [qw(KRB5_WITH_3DES_EDE_CBC_SHA               KRB5-DES-CBC3-SHA)],
  '0x03000029'=> [qw(KRB5_EXPORT_WITH_DES_CBC_40_MD5          EXP-KRB5-DES-CBC-MD5)],
  '0x03000026'=> [qw(KRB5_EXPORT_WITH_DES_CBC_40_SHA          EXP-KRB5-DES-CBC-SHA)],
  '0x03000022'=> [qw(KRB5_WITH_DES_CBC_MD5                    KRB5-DES-CBC-MD5)],
  '0x0300001E'=> [qw(KRB5_WITH_DES_CBC_SHA                    KRB5-DES-CBC-SHA)],
  '0x03000025'=> [qw(KRB5_WITH_IDEA_CBC_MD5                   KRB5-IDEA-CBC-MD5)],
  '0x03000021'=> [qw(KRB5_WITH_IDEA_CBC_SHA                   KRB5-IDEA-CBC-SHA)],
  '0x0300002A'=> [qw(KRB5_WITH_RC2_CBC_40_MD5                 EXP-KRB5-RC2-CBC-MD5)],
  '0x03000027'=> [qw(KRB5_EXPORT_WITH_RC2_CBC_40_SHA          EXP-KRB5-RC2-CBC-SHA)],
  '0x03000024'=> [qw(KRB5_WITH_RC4_128_MD5                    KRB5-RC4-MD5)],
  '0x03000020'=> [qw(KRB5_WITH_RC4_128_SHA                    KRB5-RC4-SHA)],
  '0x0300002B'=> [qw(KRB5_EXPORT_WITH_RC4_40_MD5              EXP-KRB5-RC4-MD5)],
  '0x03000028'=> [qw(KRB5_EXPORT_WITH_RC4_40_SHA              EXP-KRB5-RC4-SHA)],
  '0x0300000A'=> [qw(RSA_WITH_3DES_EDE_CBC_SHA                DES-CBC3-SHA)],
  '0x03000008'=> [qw(RSA_EXPORT_WITH_DES40_CBC_SHA            EXP-DES-CBC-SHA)],
  '0x03000009'=> [qw(RSA_WITH_DES_CBC_SHA                     DES-CBC-SHA)],
  '0x03000007'=> [qw(RSA_WITH_IDEA_SHA                        IDEA-CBC-SHA)],
  '0x03000000'=> [qw(NULL_WITH_NULL_NULL                      NULL-NULL)],
  '0x03000001'=> [qw(RSA_WITH_NULL_MD5                        NULL-MD5)],
  '0x03000002'=> [qw(RSA_WITH_NULL_SHA                        NULL-SHA)],
  '0x03000006'=> [qw(RSA_EXPORT_WITH_RC2_CBC_40_MD5           EXP-RC2-CBC-MD5)],
  '0x03000004'=> [qw(RSA_WITH_RC4_128_MD5                     RC4-MD5)],
  '0x03000005'=> [qw(RSA_WITH_RC4_128_SHA                     RC4-SHA)],
  '0x03000003'=> [qw(RSA_EXPORT_WITH_RC4_40_MD5               EXP-RC4-MD5)],
  '0x030000FF'=> [qw(EMPTY_RENEGOTIATION_INFO_SCSV            SCSV-RENEG)], #activated 'Signaling Cipher Suite Value'
  '0x03005600'=> [qw(FALLBACK_SCSV_DRAFT                      SCSV-FALLBACK-DRAFT)], ### added according 'https://datatracker.ietf.org/doc/draft-bmoeller-tls-downgrade-scsv/?include_text=1'

#!#----------------------------------------+-------------+--------------------+
#!# Protocol:  TLS 1.0 (invented)
#!#----------------------------------------+-------------+--------------------+
#!# cipher suite hex value => [ cipher_name1 cipher_name2 ],
#!#----------------------------------------+-------------+--------------------+
  '0x030000A6'=> [qw(DH_anon_WITH_AES_128_GCM_SHA256          ADH-AES128-GCM-SHA256)],
  '0x03000034'=> [qw(DH_anon_WITH_AES_128_CBC_SHA             ADH-AES128-SHA)],
  '0x0300006C'=> [qw(DH_anon_WITH_AES_128_CBC_SHA256          ADH-AES128-SHA256)],
  '0x030000A7'=> [qw(DH_anon_WITH_AES_256_GCM_SHA384          ADH-AES256-GCM-SHA384)],
  '0x0300003A'=> [qw(DH_anon_WITH_AES_256_CBC_SHA             ADH-AES256-SHA)],
  '0x0300006D'=> [qw(DH_anon_WITH_AES_256_CBC_SHA256          ADH-AES256-SHA256)],
  '0x03000046'=> [qw(DH_anon_WITH_CAMELLIA_128_CBC_SHA        ADH-CAMELLIA128-SHA)],
  '0x03000089'=> [qw(DH_anon_WITH_CAMELLIA_256_CBC_SHA        ADH-CAMELLIA256-SHA)],
  '0x0300009B'=> [qw(DH_anon_WITH_SEED_CBC_SHA                ADH-SEED-SHA)],
  '0x03000063'=> [qw(DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA      EXP1024-DHE-DSS-DES-CBC-SHA)],
  '0x03000065'=> [qw(DHE_DSS_EXPORT1024_WITH_RC4_56_SHA       EXP1024-DHE-DSS-RC4-SHA)],
  '0x030000A2'=> [qw(DHE_DSS_WITH_AES_128_GCM_SHA256          DHE-DSS-AES128-GCM-SHA256)],
  '0x03000032'=> [qw(DHE_DSS_WITH_AES_128_CBC_SHA             DHE-DSS-AES128-SHA)],
  '0x03000040'=> [qw(DHE_DSS_WITH_AES_128_CBC_SHA256          DHE-DSS-AES128-SHA256)],
  '0x030000A3'=> [qw(DHE_DSS_WITH_AES_256_GCM_SHA384          DHE-DSS-AES256-GCM-SHA384)],
  '0x03000038'=> [qw(DHE_DSS_WITH_AES_256_CBC_SHA             DHE-DSS-AES256-SHA)],
  '0x0300006A'=> [qw(DHE_DSS_WITH_AES_256_CBC_SHA256          DHE-DSS-AES256-SHA256)],
  '0x03000044'=> [qw(DHE_DSS_WITH_CAMELLIA_128_CBC_SHA        DHE-DSS-CAMELLIA128-SHA)],
  '0x03000087'=> [qw(DHE_DSS_WITH_CAMELLIA_256_CBC_SHA        DHE-DSS-CAMELLIA256-SHA)],
  '0x03000066'=> [qw(DHE_DSS_WITH_RC4_128_SHA                 DHE-DSS-RC4-SHA)],
  '0x03000099'=> [qw(DHE_DSS_WITH_SEED_CBC_SHA                DHE-DSS-SEED-SHA)],
  '0x0300009E'=> [qw(DHE_RSA_WITH_AES_128_GCM_SHA256          DHE-RSA-AES128-GCM-SHA256)],
  '0x03000033'=> [qw(DHE_RSA_WITH_AES_128_CBC_SHA             DHE-RSA-AES128-SHA)],
  '0x03000067'=> [qw(DHE_RSA_WITH_AES_128_CBC_SHA256          DHE-RSA-AES128-SHA256)],
  '0x0300009F'=> [qw(DHE_RSA_WITH_AES_256_GCM_SHA384          DHE-RSA-AES256-GCM-SHA384)],
  '0x03000039'=> [qw(DHE_RSA_WITH_AES_256_CBC_SHA             DHE-RSA-AES256-SHA)],
  '0x0300006B'=> [qw(DHE_RSA_WITH_AES_256_CBC_SHA256          DHE-RSA-AES256-SHA256)],
  '0x03000045'=> [qw(DHE_RSA_WITH_CAMELLIA_128_CBC_SHA        DHE-RSA-CAMELLIA128-SHA)],
  '0x03000088'=> [qw(DHE_RSA_WITH_CAMELLIA_256_CBC_SHA        DHE-RSA-CAMELLIA256-SHA)],
  '0x0300009A'=> [qw(DHE_RSA_WITH_SEED_CBC_SHA                DHE-RSA-SEED-SHA)],
  '0x030000A4'=> [qw(DH_DSS_WITH_AES_128_GCM_SHA256           DH-DSS-AES128-GCM-SHA256)],
  '0x03000030'=> [qw(DH_DSS_WITH_AES_128_CBC_SHA              DH-DSS-AES128-SHA)],
  '0x0300003E'=> [qw(DH_DSS_WITH_AES_128_CBC_SHA256           DH-DSS-AES128-SHA256)],
  '0x030000A5'=> [qw(DH_DSS_WITH_AES_256_GCM_SHA384           DH-DSS-AES256-GCM-SHA384)],
  '0x03000036'=> [qw(DH_DSS_WITH_AES_256_CBC_SHA              DH-DSS-AES256-SHA)],
  '0x03000068'=> [qw(DH_DSS_WITH_AES_256_CBC_SHA256           DH-DSS-AES256-SHA256)],
  '0x03000042'=> [qw(DH_DSS_WITH_CAMELLIA_128_CBC_SHA         DH-DSS-CAMELLIA128-SHA)],
  '0x03000085'=> [qw(DH_DSS_WITH_CAMELLIA_256_CBC_SHA         DH-DSS-CAMELLIA256-SHA)],
  '0x03000097'=> [qw(DH_DSS_WITH_SEED_CBC_SHA                 DH-DSS-SEED-SHA)],
  '0x030000A0'=> [qw(DH_RSA_WITH_AES_128_GCM_SHA256           DH-RSA-AES128-GCM-SHA256)],
  '0x03000031'=> [qw(DH_RSA_WITH_AES_128_CBC_SHA              DH-RSA-AES128-SHA)],
  '0x0300003F'=> [qw(DH_RSA_WITH_AES_128_CBC_SHA256           DH-RSA-AES128-SHA256)],
  '0x030000A1'=> [qw(DH_RSA_WITH_AES_256_GCM_SHA384           DH-RSA-AES256-GCM-SHA384)],
  '0x03000037'=> [qw(DH_RSA_WITH_AES_256_CBC_SHA              DH-RSA-AES256-SHA)],
  '0x03000069'=> [qw(DH_RSA_WITH_AES_256_CBC_SHA256           DH-RSA-AES256-SHA256)],
  '0x03000043'=> [qw(DH_RSA_WITH_CAMELLIA_128_CBC_SHA         DH-RSA-CAMELLIA128-SHA)],
  '0x03000086'=> [qw(DH_RSA_WITH_CAMELLIA_256_CBC_SHA         DH-RSA-CAMELLIA256-SHA)],
  '0x03000098'=> [qw(DH_RSA_WITH_SEED_CBC_SHA                 DH-RSA-SEED-SHA)],
  '0x0300C009'=> [qw(ECDHE_ECDSA_WITH_AES_128_CBC_SHA         ECDHE-ECDSA-AES128-SHA)],
  '0x0300C02B'=> [qw(ECDHE_ECDSA_WITH_AES_128_GCM_SHA256      ECDHE-ECDSA-AES128-GCM-SHA256)],
  '0x0300C023'=> [qw(ECDHE_ECDSA_WITH_AES_128_CBC_SHA256      ECDHE-ECDSA-AES128-SHA256)],
  '0x0300C00A'=> [qw(ECDHE_ECDSA_WITH_AES_256_CBC_SHA         ECDHE-ECDSA-AES256-SHA)],
  '0x0300C02C'=> [qw(ECDHE_ECDSA_WITH_AES_256_GCM_SHA384      ECDHE-ECDSA-AES256-GCM-SHA384)],
  '0x0300C024'=> [qw(ECDHE_ECDSA_WITH_AES_256_CBC_SHA384      ECDHE-ECDSA-AES256-SHA384)],
  '0x0300C008'=> [qw(ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA        ECDHE-ECDSA-DES-CBC3-SHA)],
  '0x0300C006'=> [qw(ECDHE_ECDSA_WITH_NULL_SHA                ECDHE-ECDSA-NULL-SHA)],
  '0x0300C007'=> [qw(ECDHE_ECDSA_WITH_RC4_128_SHA             ECDHE-ECDSA-RC4-SHA)],
  '0x0300C013'=> [qw(ECDHE_RSA_WITH_AES_128_CBC_SHA           ECDHE-RSA-AES128-SHA)],
  '0x0300C02F'=> [qw(ECDHE_RSA_WITH_AES_128_GCM_SHA256        ECDHE-RSA-AES128-GCM-SHA256)],
  '0x0300C027'=> [qw(ECDHE_RSA_WITH_AES_128_CBC_SHA256        ECDHE-RSA-AES128-SHA256)],
  '0x0300C014'=> [qw(ECDHE_RSA_WITH_AES_256_CBC_SHA           ECDHE-RSA-AES256-SHA)],
  '0x0300C030'=> [qw(ECDHE_RSA_WITH_AES_256_GCM_SHA384        ECDHE-RSA-AES256-GCM-SHA384)],
  '0x0300C028'=> [qw(ECDHE_RSA_WITH_AES_256_CBC_SHA384        ECDHE-RSA-AES256-SHA384)],
  '0x0300C012'=> [qw(ECDHE_RSA_WITH_3DES_EDE_CBC_SHA          ECDHE-RSA-DES-CBC3-SHA)],
  '0x0300C010'=> [qw(ECDHE_RSA_WITH_NULL_SHA                  ECDHE-RSA-NULL-SHA)],
  '0x0300C011'=> [qw(ECDHE_RSA_WITH_RC4_128_SHA               ECDHE-RSA-RC4-SHA)],
  '0x0300C004'=> [qw(ECDH_ECDSA_WITH_AES_128_CBC_SHA          ECDH-ECDSA-AES128-SHA)],
  '0x0300C02D'=> [qw(ECDH_ECDSA_WITH_AES_128_GCM_SHA256       ECDH-ECDSA-AES128-GCM-SHA256)],
  '0x0300C025'=> [qw(ECDH_ECDSA_WITH_AES_128_CBC_SHA256       ECDH-ECDSA-AES128-SHA256)],
  '0x0300C005'=> [qw(ECDH_ECDSA_WITH_AES_256_CBC_SHA          ECDH-ECDSA-AES256-SHA)],
  '0x0300C02E'=> [qw(ECDH_ECDSA_WITH_AES_256_GCM_SHA384       ECDH-ECDSA-AES256-GCM-SHA384)],
  '0x0300C026'=> [qw(ECDH_ECDSA_WITH_AES_256_CBC_SHA384       ECDH-ECDSA-AES256-SHA384)],
  '0x0300C003'=> [qw(ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA         ECDH-ECDSA-DES-CBC3-SHA)],
  '0x0300C001'=> [qw(ECDH_ECDSA_WITH_NULL_SHA                 ECDH-ECDSA-NULL-SHA)],
  '0x0300C002'=> [qw(ECDH_ECDSA_WITH_RC4_128_SHA              ECDH-ECDSA-RC4-SHA)],
  '0x0300C00E'=> [qw(ECDH_RSA_WITH_AES_128_CBC_SHA            ECDH-RSA-AES128-SHA)],
  '0x0300C031'=> [qw(ECDH_RSA_WITH_AES_128_GCM_SHA256         ECDH-RSA-AES128-GCM-SHA256)],
  '0x0300C029'=> [qw(ECDH_RSA_WITH_AES_128_CBC_SHA256         ECDH-RSA-AES128-SHA256)],
  '0x0300C00F'=> [qw(ECDH_RSA_WITH_AES_256_CBC_SHA            ECDH-RSA-AES256-SHA)],
  '0x0300C032'=> [qw(ECDH_RSA_WITH_AES_256_GCM_SHA384         ECDH-RSA-AES256-GCM-SHA384)],
  '0x0300C02A'=> [qw(ECDH_RSA_WITH_AES_256_CBC_SHA384         ECDH-RSA-AES256-SHA384)],
  '0x0300C00D'=> [qw(ECDH_RSA_WITH_3DES_EDE_CBC_SHA           ECDH-RSA-DES-CBC3-SHA)],
  '0x0300C00B'=> [qw(ECDH_RSA_WITH_NULL_SHA                   ECDH-RSA-NULL-SHA)],
  '0x0300C00C'=> [qw(ECDH_RSA_WITH_RC4_128_SHA                ECDH-RSA-RC4-SHA)],
  '0x0300C018'=> [qw(ECDH_anon_WITH_AES_128_CBC_SHA           AECDH-AES128-SHA)],
  '0x0300C019'=> [qw(ECDH_anon_WITH_AES_256_CBC_SHA           AECDH-AES256-SHA)],
  '0x0300C017'=> [qw(ECDH_anon_WITH_3DES_EDE_CBC_SHA          AECDH-DES-CBC3-SHA)],
  '0x0300C015'=> [qw(ECDH_anon_WITH_NULL_SHA                  AECDH-NULL-SHA)],
  '0x0300C016'=> [qw(ECDH_anon_WITH_RC4_128_SHA               AECDH-RC4-SHA)],
  '0x0300008B'=> [qw(PSK_WITH_3DES_EDE_CBC_SHA                PSK-3DES-EDE-CBC-SHA)],
  '0x0300008C'=> [qw(PSK_WITH_AES_128_CBC_SHA                 PSK-AES128-CBC-SHA)],
  '0x0300008D'=> [qw(PSK_WITH_AES_256_CBC_SHA                 PSK-AES256-CBC-SHA)],
  '0x0300008A'=> [qw(PSK_WITH_RC4_128_SHA                     PSK-RC4-SHA)],
  '0x03000062'=> [qw(RSA_EXPORT1024_WITH_DES_CBC_SHA          EXP1024-DES-CBC-SHA)],
  '0x03000061'=> [qw(RSA_EXPORT1024_WITH_RC2_CBC_56_MD5       EXP1024-RC2-CBC-MD5)],
  '0x03000060'=> [qw(RSA_EXPORT1024_WITH_RC4_56_MD5           EXP1024-RC4-MD5)],
  '0x03000064'=> [qw(RSA_EXPORT1024_WITH_RC4_56_SHA           EXP1024-RC4-SHA)],
  '0x0300009C'=> [qw(RSA_WITH_AES_128_GCM_SHA256              AES128-GCM-SHA256)],
  '0x0300002F'=> [qw(RSA_WITH_AES_128_CBC_SHA                 AES128-SHA)],
  '0x0300003C'=> [qw(RSA_WITH_AES_128_CBC_SHA256              AES128-SHA256)],
  '0x0300009D'=> [qw(RSA_WITH_AES_256_GCM_SHA384              AES256-GCM-SHA384)],
  '0x03000035'=> [qw(RSA_WITH_AES_256_CBC_SHA                 AES256-SHA)],
  '0x0300003D'=> [qw(RSA_WITH_AES_256_CBC_SHA256              AES256-SHA256)],
  '0x03000041'=> [qw(RSA_WITH_CAMELLIA_128_CBC_SHA            CAMELLIA128-SHA)],
  '0x03000084'=> [qw(RSA_WITH_CAMELLIA_256_CBC_SHA            CAMELLIA256-SHA)],
  '0x0300003B'=> [qw(RSA_WITH_NULL_SHA256                     NULL-SHA256)],
  '0x03000096'=> [qw(RSA_WITH_SEED_CBC_SHA                    SEED-SHA)],
  '0x0300C01C'=> [qw(SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA        SRP-DSS-3DES-EDE-CBC-SHA)],
  '0x0300C01F'=> [qw(SRP_SHA_DSS_WITH_AES_128_CBC_SHA         SRP-DSS-AES-128-CBC-SHA)],
  '0x0300C022'=> [qw(SRP_SHA_DSS_WITH_AES_256_CBC_SHA         SRP-DSS-AES-256-CBC-SHA)],
  '0x0300C01B'=> [qw(SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA        SRP-RSA-3DES-EDE-CBC-SHA)],
  '0x0300C01E'=> [qw(SRP_SHA_RSA_WITH_AES_128_CBC_SHA         SRP-RSA-AES-128-CBC-SHA)],
  '0x0300C021'=> [qw(SRP_SHA_RSA_WITH_AES_256_CBC_SHA         SRP-RSA-AES-256-CBC-SHA)],
  '0x0300C01A'=> [qw(SRP_SHA_WITH_3DES_EDE_CBC_SHA            SRP-3DES-EDE-CBC-SHA)],
  '0x0300C01D'=> [qw(SRP_SHA_WITH_AES_128_CBC_SHA             SRP-AES-128-CBC-SHA)],
  '0x0300C020'=> [qw(SRP_SHA_WITH_AES_256_CBC_SHA             SRP-AES-256-CBC-SHA)],

#!#----------------------------------------+-------------+--------------------+
#!# Protocol:  http://tools.ietf.org/html/draft-chudov-cryptopro-cptls-04
#!# added manually 20140209:  GOST 28147-89 Cipher Suites for Transport Layer Security (TLS)
#!#                   draft-chudov-cryptopro-cptls-04 (2008-12-08)
#!#----------------------------------------+-------------+--------------------+
#!# cipher suite hex value => [ cipher_name1 cipher_name2 ],
#!#----------------------------------------+-------------+--------------------+
  '0x03000080'=> [qw(GOSTR341094_WITH_28147_CNT_IMIT      GOSTR341094-28147-CNT-IMIT)],
  '0x03000081'=> [qw(GOSTR341001_WITH_28147_CNT_IMIT      GOSTR341001-28147-CNT-IMIT)],
  '0x03000082'=> [qw(GOSTR341094_WITH_NULL_GOSTR3411      GOSTR341094-NULL-GOSTR3411)],
  '0x03000083'=> [qw(GOSTR341001_WITH_NULL_GOSTR3411      GOSTR341001-NULL-GOSTR3411)],

#!#----------------------------------------+-------------+--------------------+
#!# Protocol:  http://tools.ietf.org/html/draft-mavrogiannopoulos-chacha-tls-01
#!# added manually 20140209: ChaCha Stream Cipher for Transport Layer Security
#!# 20160330: renamed Ciphers 0x0300CC12 .. 0x0300CC19 as hex-numbers changed
#!#           in version 05 of the draft: __OLD, __OLD
#!#----------------------------------------+-------------+--------------------+
#!# cipher suite hex value => [ cipher_name1 cipher_name2 ],
#!#----------------------------------------+-------------+--------------------+
  '0x0300CC12'=> [qw(RSA_WITH_CHACHA20_POLY1305__OLD         RSA-CHACHA20-POLY1305__OLD)],
  '0x0300CC13'=> [qw(ECDHE_RSA_WITH_CHACHA20_POLY1305__OLD   ECDHE-RSA-CHACHA20-POLY1305__OLD)],
  '0x0300CC14'=> [qw(ECDHE_ECDSA_WITH_CHACHA20_POLY1305__OLD ECDHE-ECDSA-CHACHA20-POLY1305__OLD)],

  '0x0300CC15'=> [qw(DHE_RSA_WITH_CHACHA20_POLY1305__OLD     DHE-RSA-CHACHA20-POLY1305__OLD)],
  '0x0300CC16'=> [qw(DHE_PSK_WITH_CHACHA20_POLY1305__OLD     DHE-PSK-CHACHA20-POLY1305__OLD)],

  '0x0300CC17'=> [qw(PSK_WITH_CHACHA20_POLY1305__OLD         PSK-CHACHA20-POLY1305__OLD)],
  '0x0300CC18'=> [qw(ECDHE_PSK_WITH_CHACHA20_POLY1305__OLD   ECDHE-PSK-CHACHA20-POLY1305__OLD)],
  '0x0300CC19'=> [qw(RSA_PSK_WITH_CHACHA20_POLY1305__OLD     RSA-PSK-CHACHA20-POLY1305__OLD)],

  '0x0300CC20'=> [qw(RSA_WITH_CHACHA20_SHA              RSA-CHACHA20-SHA)],
  '0x0300CC21'=> [qw(ECDHE_RSA_WITH_CHACHA20_SHA        ECDHE-RSA-CHACHA20-SHA)],
  '0x0300CC22'=> [qw(ECDHE_ECDSA_WITH_CHACHA20_SHA      ECDHE-ECDSA-CHACHA20-SHA)],

  '0x0300CC23'=> [qw(DHE_RSA_WITH_CHACHA20_SHA          DHE-RSA-CHACHA20-SHA)],
  '0x0300CC24'=> [qw(DHE_PSK_WITH_CHACHA20_SHA          DHE-PSK-CHACHA20-SHA)],

  '0x0300CC25'=> [qw(PSK_WITH_CHACHA20_SHA              PSK-CHACHA20-SHA)],
  '0x0300CC26'=> [qw(ECDHE_PSK_WITH_CHACHA20_SHA        ECDHE-PSK-CHACHA20-SHA)],
  '0x0300CC27'=> [qw(RSA_PSK_WITH_CHACHA20_SHA          RSA-PSK-CHACHA20-SHA)],

#!#----------------------------------------+-------------+--------------------+
#!# Protocol:  http://tools.ietf.org/html/draft-mavrogiannopoulos-chacha-tls-05
#!# added manually 20160330: NEW ChaCha Stream Cipher for Transport Layer Security
#!# ATTENTION: the same Ciphers existed before using 0x0300CC12 .. 0x0300CC19
#!#----------------------------------------+-------------+--------------------+
#!# cipher suite hex value => [ cipher_name1 cipher_name2 ],
#!#----------------------------------------+-------------+--------------------+
  '0x0300CCA0'=> [qw(RSA_WITH_CHACHA20_POLY1305         RSA-CHACHA20-POLY1305)],
  '0x0300CCA1'=> [qw(ECDHE_RSA_WITH_CHACHA20_POLY1305   ECDHE-RSA-CHACHA20-POLY1305)],
  '0x0300CCA2'=> [qw(ECDHE_ECDSA_WITH_CHACHA20_POLY1305 ECDHE-ECDSA-CHACHA20-POLY1305)],

  '0x0300CCA3'=> [qw(DHE_RSA_WITH_CHACHA20_POLY1305     DHE-RSA-CHACHA20-POLY1305)],
  '0x0300CCA4'=> [qw(DHE_PSK_WITH_CHACHA20_POLY1305     DHE-PSK-CHACHA20-POLY1305)],

  '0x0300CCA5'=> [qw(PSK_WITH_CHACHA20_POLY1305         PSK-CHACHA20-POLY1305)],
  '0x0300CCA6'=> [qw(ECDHE_PSK_WITH_CHACHA20_POLY1305   ECDHE-PSK-CHACHA20-POLY1305)],
  '0x0300CCA7'=> [qw(RSA_PSK_WITH_CHACHA20_POLY1305     RSA-PSK-CHACHA20-POLY1305)],

#!#----------------------------------------+-------------+--------------------+
#!# Protocol: https://tools.ietf.org/html/draft-ietf-tls-chacha20-poly1305-04
#!# added manually 20160331:
#!#           ChaCha20-Poly1305 Cipher Suites for Transport Layer Security (TLS)
#!#----------------------------------------+-------------+--------------------+
#!# cipher suite hex value => [ cipher_name1 cipher_name2 ],
#!#----------------------------------------+-------------+--------------------+

# CipherSuite TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256   = {0xTBD, 0xTBD} {0xCC, 0xA8}
# CipherSuite TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = {0xTBD, 0xTBD} {0xCC, 0xA9}
# CipherSuite TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256     = {0xTBD, 0xTBD} {0xCC, 0xAA}

# CipherSuite TLS_PSK_WITH_CHACHA20_POLY1305_SHA256         = {0xTBD, 0xTBD} {0xCC, 0xAB}
# CipherSuite TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256   = {0xTBD, 0xTBD} {0xCC, 0xAC}
# CipherSuite TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256     = {0xTBD, 0xTBD} {0xCC, 0xAD}
# CipherSuite TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256     = {0xTBD, 0xTBD} {0xCC, 0xAE}
  '0x0300CCA8'=> [qw(ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256   ECDHE-RSA-CHACHA20-POLY1305-SHA256)],
  '0x0300CCA9'=> [qw(ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 ECDHE-ECDSA-CHACHA20-POLY1305-SHA256)],
  '0x0300CCAA'=> [qw(DHE_RSA_WITH_CHACHA20_POLY1305_SHA256     DHE-RSA-CHACHA20-POLY1305-SHA256)],

  '0x0300CCAB'=> [qw(PSK_WITH_CHACHA20_POLY1305_SHA256         PSK-CHACHA20-POLY1305-SHA256)],
  '0x0300CCAC'=> [qw(ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256   ECDHE-PSK-CHACHA20-POLY1305-SHA256)],
  '0x0300CCAD'=> [qw(DHE_PSK_WITH_CHACHA20_POLY1305_SHA256     DHE-PSK-CHACHA20-POLY1305-SHA256)],
  '0x0300CCAE'=> [qw(RSA_PSK_WITH_CHACHA20_POLY1305_SHA256     RSA-PSK-CHACHA20-POLY1305-SHA256)],

#!#----------------------------------------+-------------+--------------------+
#!# Protocol:  http://tools.ietf.org/html/rfc5932
#!# added manually 20140630:  Camellia Cipher Suites for TLS
#!#----------------------------------------+-------------+--------------------+
#!# cipher suite hex value => [ cipher_name1 cipher_name2 ],
#!#----------------------------------------+-------------+--------------------+
# CipherSuite TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256      = { 0x00,0xBA };
# CipherSuite TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256   = { 0x00,0xBB };
# CipherSuite TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256   = { 0x00,0xBC };
# CipherSuite TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256  = { 0x00,0xBD };
# CipherSuite TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256  = { 0x00,0xBE };
# CipherSuite TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256  = { 0x00,0xBF };
  '0x030000BA'=> [qw(RSA_WITH_CAMELLIA_128_CBC_SHA256     RSA-CAMELLIA128-SHA256)],
  '0x030000BB'=> [qw(DH_DSS_WITH_CAMELLIA_128_CBC_SHA256  DH-DSS-CAMELLIA128-SHA256)],
  '0x030000BC'=> [qw(DH_RSA_WITH_CAMELLIA_128_CBC_SHA256  DH-RSA-CAMELLIA128-SHA256)],
  '0x030000BD'=> [qw(DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 DHE-DSS-CAMELLIA128-SHA256)],
  '0x030000BE'=> [qw(DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 DHE-RSA-CAMELLIA128-SHA256)],
  '0x030000BF'=> [qw(DH_anon_WITH_CAMELLIA_128_CBC_SHA256 ADH-CAMELLIA128-SHA256)],


# CipherSuite TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256      = { 0x00,0xC0 };
# CipherSuite TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256   = { 0x00,0xC1 };
# CipherSuite TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256   = { 0x00,0xC2 };
# CipherSuite TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256  = { 0x00,0xC3 };
# CipherSuite TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256  = { 0x00,0xC4 };
# CipherSuite TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256  = { 0x00,0xC5 };
  '0x030000C0'=> [qw(RSA_WITH_CAMELLIA_256_CBC_SHA256     RSA-CAMELLIA256-SHA256)],
  '0x030000C1'=> [qw(DH_DSS_WITH_CAMELLIA_256_CBC_SHA256  DH-DSS-CAMELLIA256-SHA256)],
  '0x030000C2'=> [qw(DH_RSA_WITH_CAMELLIA_256_CBC_SHA256  DH-RSA-CAMELLIA256-SHA256)],
  '0x030000C3'=> [qw(DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 DHE-DSS-CAMELLIA256-SHA256)],
  '0x030000C4'=> [qw(DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 DHE-RSA-CAMELLIA256-SHA256)],
  '0x030000C5'=> [qw(DH_anon_WITH_CAMELLIA_256_CBC_SHA256 ADH-CAMELLIA256-SHA256)],

#!#----------------------------------------+-------------+--------------------+
#!# Protocol:  http://tools.ietf.org/html/rfcrfc6367
#!# added manually 20140701:  Camellia Cipher Suites for TLS
#!#----------------------------------------+-------------+--------------------+
#!# cipher suite hex value => [ cipher_name1 cipher_name2 ],
#!#----------------------------------------+-------------+--------------------+
# CipherSuite TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = {0xC0,0x72};
# CipherSuite TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = {0xC0,0x73};
# CipherSuite TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256  = {0xC0,0x74};
# CipherSuite TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384  = {0xC0,0x75};
# CipherSuite TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256   = {0xC0,0x76};
# CipherSuite TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384   = {0xC0,0x77};
# CipherSuite TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256    = {0xC0,0x78};
# CipherSuite TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384    = {0xC0,0x79};
  '0x0300C072'=> [qw(ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256   ECDHE-ECDSA-CAMELLIA128-SHA256)],
  '0x0300C073'=> [qw(ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384   ECDHE-ECDSA-CAMELLIA256-SHA384)],
  '0x0300C074'=> [qw(ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256    ECDH-ECDSA-CAMELLIA128-SHA256)],
  '0x0300C075'=> [qw(ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384    ECDH-ECDSA-CAMELLIA256-SHA384)],
  '0x0300C076'=> [qw(ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256     ECDHE-RSA-CAMELLIA128-SHA256)],
  '0x0300C077'=> [qw(ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384     ECDHE-RSA-CAMELLIA256-SHA384)],
  '0x0300C078'=> [qw(ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256      ECDH-RSA-CAMELLIA128-SHA256)],
  '0x0300C079'=> [qw(ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384      ECDH-RSA-CAMELLIA256-SHA384)],

# CipherSuite TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256          = {0xC0,0x7A};
# CipherSuite TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384          = {0xC0,0x7B};
# CipherSuite TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256      = {0xC0,0x7C};
# CipherSuite TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384      = {0xC0,0x7D};
# CipherSuite TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256       = {0xC0,0x7E};
# CipherSuite TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384       = {0xC0,0x7F};
  '0x0300C07A'=> [qw(RSA_WITH_CAMELLIA_128_GCM_SHA256           RSA-CAMELLIA128-GCM-SHA256)],
  '0x0300C07B'=> [qw(RSA_WITH_CAMELLIA_256_GCM_SHA384           RSA-CAMELLIA256-GCM-SHA384)],
  '0x0300C07C'=> [qw(DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256       DHE-RSA-CAMELLIA128-GCM-SHA256)],
  '0x0300C07D'=> [qw(DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384       DHE-RSA-CAMELLIA256-GCM-SHA384)],
  '0x0300C07E'=> [qw(DH_RSA_WITH_CAMELLIA_128_GCM_SHA256        DH-RSA-CAMELLIA128-GCM-SHA256)],
  '0x0300C07F'=> [qw(DH_RSA_WITH_CAMELLIA_256_GCM_SHA384        DH-RSA-CAMELLIA256-GCM-SHA384)],

# CipherSuite TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256      = {0xC0,0x80};
# CipherSuite TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384      = {0xC0,0x81};
# CipherSuite TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256       = {0xC0,0x82};
# CipherSuite TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384       = {0xC0,0x83};
# CipherSuite TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256      = {0xC0,0x84};
# CipherSuite TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384      = {0xC0,0x85};
  '0x0300C080'=> [qw(DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256       DHE-DSS-CAMELLIA128-GCM-SHA256)],
  '0x0300C081'=> [qw(DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384       DHE-DSS-CAMELLIA256-GCM-SHA384)],
  '0x0300C082'=> [qw(DH_DSS_WITH_CAMELLIA_128_GCM_SHA256        DH-DSS-CAMELLIA128-GCM-SHA256)],
  '0x0300C083'=> [qw(DH_DSS_WITH_CAMELLIA_256_GCM_SHA384        DH-DSS-CAMELLIA256-GCM-SHA384)],
  '0x0300C084'=> [qw(DH_anon_DSS_WITH_CAMELLIA_128_GCM_SHA256   ADH-DSS-CAMELLIA128-GCM-SHA256)],
  '0x0300C085'=> [qw(DH_anon_DSS_WITH_CAMELLIA_256_GCM_SHA384   ADH-DSS-CAMELLIA256-GCM-SHA384)],

# CipherSuite TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256  = {0xC0,0x86};
# CipherSuite TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384  = {0xC0,0x87};
# CipherSuite TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256   = {0xC0,0x88};
# CipherSuite TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384   = {0xC0,0x89};
# CipherSuite TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256    = {0xC0,0x8A};
# CipherSuite TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384    = {0xC0,0x8B};
# CipherSuite TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256     = {0xC0,0x8C};
# CipherSuite TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384     = {0xC0,0x8D};
  '0x0300C086'=> [qw(ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256   ECDHE-ECDSA-CAMELLIA128-GCM-SHA256)],
  '0x0300C087'=> [qw(ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384   ECDHE-ECDSA-CAMELLIA256-GCM-SHA384)],
  '0x0300C088'=> [qw(ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256    ECDH-ECDSA-CAMELLIA128-GCM-SHA256)],
  '0x0300C089'=> [qw(ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384    ECDH-ECDSA-CAMELLIA256-GCM-SHA384)],
  '0x0300C08A'=> [qw(ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256     ECDHE-RSA-CAMELLIA128-GCM-SHA256)],
  '0x0300C08B'=> [qw(ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384     ECDHE-RSA-CAMELLIA256-GCM-SHA384)],
  '0x0300C08C'=> [qw(ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256      ECDH-RSA-CAMELLIA128-GCM-SHA256)],
  '0x0300C08D'=> [qw(ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384      ECDH-RSA-CAMELLIA256-GCM-SHA384)],

# CipherSuite TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256        = {0xC0,0x8E}; ##BUG in RFC6376##
# CipherSuite TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384        = {0xC0,0x8F};
# CipherSuite TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256    = {0xC0,0x90};
# CipherSuite TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384    = {0xC0,0x91};
# CipherSuite TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256    = {0xC0,0x92};
# CipherSuite TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384    = {0xC0,0x93};
  '0x0300C08E'=> [qw(PSK_WITH_CAMELLIA_128_GCM_SHA256           PSK-CAMELLIA128-GCM-SHA256)],
  '0x0300C08F'=> [qw(PSK_WITH_CAMELLIA_256_GCM_SHA384           PSK-CAMELLIA256-GCM-SHA384)],
  '0x0300C090'=> [qw(DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256       DHE-PSK-CAMELLIA128-GCM-SHA256)],
  '0x0300C091'=> [qw(DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384       DHE-PSK-CAMELLIA256-GCM-SHA384)],
  '0x0300C092'=> [qw(RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256       RSA-PSK-CAMELLIA128-GCM-SHA256)],
  '0x0300C093'=> [qw(RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384       RSA-PSK-CAMELLIA256-GCM-SHA384)],

# CipherSuite TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256        = {0xC0,0x94};
# CipherSuite TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384        = {0xC0,0x95};
# CipherSuite TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256    = {0xC0,0x96};
# CipherSuite TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384    = {0xC0,0x97};
# CipherSuite TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256    = {0xC0,0x98};
# CipherSuite TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384    = {0xC0,0x99};
  '0x0300C094'=> [qw(PSK_WITH_CAMELLIA_128_CBC_SHA256           PSK-CAMELLIA128-SHA256)],
  '0x0300C095'=> [qw(PSK_WITH_CAMELLIA_256_CBC_SHA384           PSK-CAMELLIA256-SHA384)],
  '0x0300C096'=> [qw(DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256       DHE-PSK-CAMELLIA128-SHA256)],
  '0x0300C097'=> [qw(DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384       DHE-PSK-CAMELLIA256-SHA384)],
  '0x0300C098'=> [qw(RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256       RSA-PSK-CAMELLIA128-SHA256)],
  '0x0300C099'=> [qw(RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384       RSA-PSK-CAMELLIA256-SHA384)],

# CipherSuite TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256  = {0xC0,0x9A};
# CipherSuite TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384  = {0xC0,0x9B};
  '0x0300C09A'=> [qw(ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256     ECDHE-PSK-CAMELLIA128-SHA256)],
  '0x0300C09B'=> [qw(ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384     ECDHE-PSK-CAMELLIA256-SHA384)],

#!#----------------------------------------+-------------+--------------------+
#!# P