/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_BIOSElement.h"
#include "OpenDRIM_BIOSElementAccess.h"

#include <iostream>

#define ToString(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value; os << endl
#define ToStringInt(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << (long) instance.value; os << endl
#define ToStringRef(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value.toString(); os << endl
#define ToStringArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringArrayInt(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << (long) instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringRefArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i].toString(); if (i < instance.value.size()-1) os << ","; } os << "]" << endl

ostream& operator<<(ostream& os, OpenDRIM_BIOSElement& instance) {
	os << "   [OpenDRIM_BIOSElement]" << endl;
	ToString("InstanceID", InstanceID, InstanceID_isNULL);
	ToString("Caption", Caption, Caption_isNULL);
	ToString("Description", Description, Description_isNULL);
	ToString("ElementName", ElementName, ElementName_isNULL);
	ToString("InstallDate", InstallDate, InstallDate_isNULL);
	ToStringArrayInt("OperationalStatus", OperationalStatus, OperationalStatus_isNULL);
	ToStringArray("StatusDescriptions", StatusDescriptions, StatusDescriptions_isNULL);
	ToString("Status", Status, Status_isNULL);
	ToStringInt("HealthState", HealthState, HealthState_isNULL);
	ToStringInt("CommunicationStatus", CommunicationStatus, CommunicationStatus_isNULL);
	ToStringInt("DetailedStatus", DetailedStatus, DetailedStatus_isNULL);
	ToStringInt("OperatingStatus", OperatingStatus, OperatingStatus_isNULL);
	ToStringInt("PrimaryStatus", PrimaryStatus, PrimaryStatus_isNULL);
	ToString("Name", Name, Name_isNULL);
	ToString("Version", Version, Version_isNULL);
	ToStringInt("SoftwareElementState", SoftwareElementState, SoftwareElementState_isNULL);
	ToString("SoftwareElementID", SoftwareElementID, SoftwareElementID_isNULL);
	ToStringInt("TargetOperatingSystem", TargetOperatingSystem, TargetOperatingSystem_isNULL);
	ToString("OtherTargetOS", OtherTargetOS, OtherTargetOS_isNULL);
	ToString("BuildNumber", BuildNumber, BuildNumber_isNULL);
	ToString("SerialNumber", SerialNumber, SerialNumber_isNULL);
	ToString("CodeSet", CodeSet, CodeSet_isNULL);
	ToString("IdentificationCode", IdentificationCode, IdentificationCode_isNULL);
	ToString("LanguageEdition", LanguageEdition, LanguageEdition_isNULL);
	ToString("Manufacturer", Manufacturer, Manufacturer_isNULL);
	ToString("PrimaryBIOS", PrimaryBIOS, PrimaryBIOS_isNULL);
	ToStringArray("ListOfLanguages", ListOfLanguages, ListOfLanguages_isNULL);
	ToString("CurrentLanguage", CurrentLanguage, CurrentLanguage_isNULL);
	ToString("LoadedStartingAddress", LoadedStartingAddress, LoadedStartingAddress_isNULL);
	ToString("LoadedEndingAddress", LoadedEndingAddress, LoadedEndingAddress_isNULL);
	ToString("LoadUtilityInformation", LoadUtilityInformation, LoadUtilityInformation_isNULL);
	ToString("ReleaseDate", ReleaseDate, ReleaseDate_isNULL);
	ToStringArray("RegistryURIs", RegistryURIs, RegistryURIs_isNULL);
	os << "   [\\OpenDRIM_BIOSElement]" << endl;
	return os;
}

int main() {
	
	string errorMessage;

	int errorCode = BIOS_OpenDRIM_BIOSElement_load(NULL, errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}

	cout << endl << "[enumInstances]" << endl;
	vector<OpenDRIM_BIOSElement> instances;
	
	errorCode = BIOS_OpenDRIM_BIOSElement_retrieve(NULL, NULL, instances, NULL, errorMessage, "ei");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	vector<OpenDRIM_BIOSElement>::iterator it = instances.begin();
	for (; it != instances.end(); ++it) {
		cout << *it;
	}
	
	cout << "[\\enumInstances]" << endl;
	cout << endl << "[enumInstanceNames & getInstance]" << endl;
	
	instances.clear();
	errorCode = BIOS_OpenDRIM_BIOSElement_retrieve(NULL, NULL, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	it = instances.begin();
	for (; it != instances.end(); ++it) {
		errorCode = BIOS_OpenDRIM_BIOSElement_getInstance(NULL, NULL, *it, NULL, errorMessage);
		if (errorCode != OK) {
			cout << "ERROR " << errorCode << ": " << errorMessage << endl;
			return -1;
		}
		cout << *it;
	}
	
	cout << "[\\enumInstanceNames & getInstance]" << endl;
	cout << endl;

	errorCode = BIOS_OpenDRIM_BIOSElement_unload(errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	return 0;
}
