/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_ConcretePCIIdentity.h"

CMPIObjectPath* PCI_OpenDRIM_ConcretePCIIdentity_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_ConcretePCIIdentity& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_ConcretePCIIdentity_classnames[0], OpenDRIM_ConcretePCIIdentity_NAMESPACE);

	if (!instance.SystemElement_isNULL)
		op.addKey("SystemElement", instance.SystemElement);

	if (!instance.SameElement_isNULL)
		op.addKey("SameElement", instance.SameElement);

	_L_;
	return op.getHdl();
}

CMPIInstance* PCI_OpenDRIM_ConcretePCIIdentity_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_ConcretePCIIdentity& instance) {
	_E_;
	Objectpath op(broker, PCI_OpenDRIM_ConcretePCIIdentity_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	_L_;
	return ci.getHdl();
}

void PCI_OpenDRIM_ConcretePCIIdentity_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_ConcretePCIIdentity& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("SystemElement", instance.SystemElement) == OK)
		instance.SystemElement_isNULL = false;

	if (op.getKey("SameElement", instance.SameElement) == OK)
		instance.SameElement_isNULL = false;

	_L_;
}

void PCI_OpenDRIM_ConcretePCIIdentity_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_ConcretePCIIdentity& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("SystemElement", instance.SystemElement) == OK)
		instance.SystemElement_isNULL = false;

	if (inst.getProperty("SameElement", instance.SameElement) == OK)
		instance.SameElement_isNULL = false;

	_L_;
}

