/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#include "OpenDRIM_GroupAssignedIdentityAccess.h"

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Simple_Identity_Management_CIM_Identity_load(broker, errorMessage));
	CF_assert(Simple_Identity_Management_CIM_ManagedElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Simple_Identity_Management_CIM_Identity_unload(errorMessage));
	CF_assert(Simple_Identity_Management_CIM_ManagedElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_isAssociated(const Instance& IdentityInfo, const Instance& ManagedElement, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_GroupAssignedIdentity>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_enumerateIdentityInfos(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_enumerateIdentityInfos(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			IdentityInfo_classnames[0], ManagedElement_classnames[0],
			IdentityInfo_role.c_str(), ManagedElement_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_referenceIdentityInfoToManagedElement(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_GroupAssignedIdentity& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath IdentityInfo_objectpath;
	instance.getIdentityInfo(IdentityInfo_objectpath);
	Instance IdentityInfo_instance;
	CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_getIdentityInfo(broker, ctx, IdentityInfo_objectpath, IdentityInfo_instance, NULL, errorMessage));
	
	Objectpath ManagedElement_objectpath;
	instance.getManagedElement(ManagedElement_objectpath);
	Instance ManagedElement_instance;
	CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_getManagedElement(broker, ctx, ManagedElement_objectpath, ManagedElement_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_isAssociated(IdentityInfo_instance, ManagedElement_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupAssignedIdentity& newInstance, const OpenDRIM_GroupAssignedIdentity& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupAssignedIdentity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupAssignedIdentity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_associatorIdentityInfoToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& IdentityInfo_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> ManagedElement_instances;
	if (discriminant=="a")
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<ManagedElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_isAssociated(IdentityInfo_instance, ManagedElement_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			ManagedElement_associatedInstances.push_back(ManagedElement_instances[i]);
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_associatorManagedElementToIdentityInfo(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& IdentityInfo_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> IdentityInfo_instances;
	if (discriminant=="a")
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_enumerateIdentityInfos(broker, ctx, IdentityInfo_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_enumerateIdentityInfos(broker, ctx, IdentityInfo_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_enumerateIdentityInfos(broker, ctx, IdentityInfo_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<IdentityInfo_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_isAssociated(IdentityInfo_instances[i], ManagedElement_instance, isAssociated, errorMessage));
		if (isAssociated)
			IdentityInfo_associatedInstances.push_back(IdentityInfo_instances[i]);
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_referenceIdentityInfoToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& IdentityInfo_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_GroupAssignedIdentity>& OpenDRIM_GroupAssignedIdentity_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < ManagedElement_instances.size(); i++) {
		OpenDRIM_GroupAssignedIdentity instance;
		instance.setIdentityInfo(((Instance) IdentityInfo_instance).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instances[i]).getObjectpath());
		
		OpenDRIM_GroupAssignedIdentity_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_referenceManagedElementToIdentityInfo(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& IdentityInfo_instances, vector<OpenDRIM_GroupAssignedIdentity>& OpenDRIM_GroupAssignedIdentity_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < IdentityInfo_instances.size(); i++) {
		OpenDRIM_GroupAssignedIdentity instance;
		instance.setIdentityInfo(((Instance) IdentityInfo_instances[i]).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instance).getObjectpath());
		
		OpenDRIM_GroupAssignedIdentity_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupAssignedIdentity_populate(OpenDRIM_GroupAssignedIdentity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

