# This file is a part of the OpenSurgSim project.
# Copyright 2014, SimQuest Solutions Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


# - Try to find MathJax
#
# Once done this will define
#  MATHJAX_FOUND
#  MATHJAX_DIR
#

if(NOT MATHJAX_DIR)
	find_path(MATHJAX_DIR
		NAMES MathJax.js
		PATHS "$ENV{MATHJAX_DIR}" "/usr/share/javascript/mathjax/"
		DOC "Path to local MathJax.js"
	)
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(MathJax
	"Could NOT find MathJax. To use a local version, set MATHJAX_DIR to the directory containing MathJax.js."
	MATHJAX_DIR
)

mark_as_advanced(MATHJAX_DIR)
