###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_drupal_38545.nasl 7371 2010-04-20 14:32:38Z chandra $
#
# Drupal Prior to 6.16 and 5.22 Multiple Security Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100523);
 script_bugtraq_id(38545);
 script_version ("1.0-$Revision: 7371 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Drupal Prior to 6.16 and 5.22 Multiple Security Vulnerabilities");

desc = "Overview:
Drupal is prone to multiple vulnerabilities, including cross-site
scripting issues, a phishing issue, and a security-bypass issue.

An attacker may leverage these issues to execute arbitrary code in the
browser of an unsuspecting user in the context of the affected site,
steal cookie-based authentication credentials, bypass security
restrictions, or perform other attacks.

These issues affect the following:

Drupal 5.x prior to 5.22 Drupal 6.x prior to 6.16

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/38545
http://drupal.org
http://drupal.org/node/731710

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Drupal version is < 6.16 or < 5.22");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("drupal_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/drupal")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_in_range(version:vers, test_version:"5", test_version2:"5.21") ||
     version_in_range(version:vers, test_version:"6", test_version2:"6.15")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
