#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: gollum <gollum@evilemail.com>
#
#  This script is released under the GNU GPL v2
#

if(description)
{
 script_id(15400);
 script_bugtraq_id(2933);
 script_cve_id("CVE-2001-1083");
 script_xref(name:"OSVDB", value:"5472");
 script_version ("$Revision: 8231 $");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 
 name = "ICECast crafted URL DoS";
 script_name(name);
 
 desc = "
The remote server runs a version of ICECast, an open source 
streaming audio server, which is older than version 1.3.11.

This version is affected by a remote denial of service because
Icecast server does not properly sanitize user-supplied input.

An remote attacker could send specially crafted URL, by adding '/', '\' or '.' to the end,
that may result in a loss of availability for the service.

*** openvas reports this vulnerability using only
*** information that was gathered.

Solution : Upgrade to a newer version.
Risk factor : High";


 script_description(desc);
 
 summary = "Check icecast version";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2004 David Maciejak");
		
 family = "Denial of Service";
 script_family(family);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 8000);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_http_port(default:8000);
if(!port) exit(0);

banner = tolower(get_http_banner(port:port));
if ( ! banner ) exit(0);

if("icecast/1." >< banner &&  egrep(pattern:"icecast/1\.(1\.|3\.([0-9]|10)[^0-9])", string:banner))
      security_hole(port);
