/* This file is part of the OWL API.
 * The contents of this file are subject to the LGPL License, Version 3.0.
 * Copyright 2014, The University of Manchester
 * 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 * Alternatively, the contents of this file may be used under the terms of the Apache License, Version 2.0 in which case, the provisions of the Apache License Version 2.0 are applicable instead of those above.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License. */
package org.semanticweb.owlapi.expression;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;

/**
 * Maps strings to OWL objects.
 *
 * @author Matthew Horridge, The University Of Manchester, Bio-Health Informatics Group
 * @since 2.2.0
 */
public interface OWLEntityChecker {

    /**
     * @param name name to resolve
     * @return OWLClass corresponding to name
     */
    @Nullable
    OWLClass getOWLClass(String name);

    /**
     * @param name name to resolve
     * @return OWLObjectProperty corresponding to name
     */
    @Nullable
    OWLObjectProperty getOWLObjectProperty(String name);

    /**
     * @param name name to resolve
     * @return OWLDataProperty corresponding to name
     */
    @Nullable
    OWLDataProperty getOWLDataProperty(String name);

    /**
     * @param name name to resolve
     * @return OWLNamedIndividual corresponding to name
     */
    @Nullable
    OWLNamedIndividual getOWLIndividual(String name);

    /**
     * @param name name to resolve
     * @return OWLDatatype corresponding to name
     */
    @Nullable
    OWLDatatype getOWLDatatype(String name);

    /**
     * @param name name to resolve
     * @return OWLAnnotationProperty corresponding to name
     */
    @Nullable
    OWLAnnotationProperty getOWLAnnotationProperty(String name);
}
