/*	MySQL_Data_Port

PIRL CVS  ID: MySQL_Data_Port.java,v 1.23 2012/04/16 06:08:57 castalia Exp

Copyright (C) 2001-2007  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package PIRL.Database;

import PIRL.PVL.Parameter;
import PIRL.PVL.Value;

import PIRL.Configuration.Configuration;
import PIRL.Configuration.Configuration_Exception;

import java.util.Vector;


/**	Provides access to a MySQL database via a JDBC <I>Data_Port</I>.
<P>
@see		JDBC_Data_Port

@author		Bradford Castalia, UA/PIRL
@version	1.23 
*/
public class MySQL_Data_Port
	extends JDBC_Data_Port
	implements Data_Port
{
private static final String
	ID			= "PIRL.Database.MySQL_Data_Port (1.23 2012/04/16 06:08:57)",
	Port_Type	= "MySQL";

/**	Required Configuration parameters and their default values.
<P>
<DL COMPACT>
	<DT><CODE>Database.DRIVER</CODE>		<DD>com.mysql.jdbc.Driver
	<DT><CODE>Configuration.HOST</CODE>		<DD>localhost
	<DT><CODE>Database.CATALOG</CODE>		<DD>mysql
</DL>
*/
public static final String
	URL_Specs[][] =
	{
	{Database.DRIVER,		"com.mysql.jdbc.Driver"},
	{Configuration.HOST,	"localhost"}
	};

/**	The Configuration parameter to use when specifying a specific
	port for connection to the database server.
*/
public static final String
	PORT = "port";

/**	Optional Configuration parameters.
<P>
	These parameters are based on the use of the MySQL Connector-J Driver,
	version 3.1.13.
<P>
<H4>Connection/Authentication Properties</H4>
<DL>
<DT><CODE>user</CODE>
	<DD>The name of the user to connect as. [none]
<DT><CODE>password</CODE>
	<DD>The password to use when connecting. [none]
<DT><CODE>socketFactory</CODE>
	<DD>The name of the class that the driver should use for
		creating socket connections to the server. This class must
		implement the interface 'com.mysql.jdbc.SocketFactory' and
		have public no-args constructor.
		[com.mysql.jdbc.StandardSocketFactory]
<DT><CODE>connectTimeout</CODE>
	<DD>Timeout for socket connect (in milliseconds), with 0 being
		no timeout. Only works on JDK-1.4 or newer. [0]
<DT><CODE>socketTimeout</CODE>
	<DD>Timeout on network socket operations (0 means no timeout). [0]
<DT><CODE>useConfigs</CODE>
	<DD>Load the comma-delimited list of configuration properties before 
		parsing the URL or applying user-specified properties. These 
		configurations are explained in the 'Configurations' of the 
		documentation.
<DT><CODE>interactiveClient</CODE>
	<DD>Set the CLIENT_INTERACTIVE flag, which tells MySQL to
	timeout connections based on INTERACTIVE_TIMEOUT instead of
	WAIT_TIMEOUT. [false]
<DT><CODE>propertiesTransform</CODE>
	<DD>An implementation of com.mysql.jdbc.ConnectionPropertiesTransform 
		that the driver will use to modify URL properties passed to the 
		driver before attempting a connection
<DT><CODE>useCompression</CODE>
	<DD>Use zlib compression when communicating with the server? [false]
</DL>
<P>
<H4>High Availability and Clustering</H4>
<DL>
<DT><CODE>autoReconnect</CODE>
	<DD>Should the driver attempt to re-connect if the connection
		dies (true or false)? [false]
<DT><CODE>autoReconnectForPools</CODE>
	<DD>Use a reconnection strategy appropriate for connection
		pools. [false]
<DT><CODE>failOverReadOnly</CODE>
	<DD>When failing over in autoReconnect mode, should the
		connection be set to 'read-only'? [true]
<DT><CODE>reconnectAtTxEnd</CODE>
	<DD>If autoReconnect is set to true, should the driver attempt
		reconnectionsat the end of every transaction? [false]
<DT><CODE>roundRobinLoadBalance</CODE>
	<DD>When autoReconnect is enabled, and failoverReadonly is
		false, should we pick hosts to connect to on a round-robin
		basis? [false]
<DT><CODE>queriesBeforeRetryMaster</CODE>
	<DD>Number of queries to issue before falling back to master
		when failed over (when using multi-host failover).
		Whichever condition is met first,
		'queriesBeforeRetryMaster' or 'secondsBeforeRetryMaster'
		will cause an attempt to be made to reconnect to the
		master. [50]
<DT><CODE>secondsBeforeRetryMaster</CODE>
	<DD>How long should the driver wait (seconds), when failed
		over, before attempting to reconnect to the master server?
		Whichever condition is met first,
		'queriesBeforeRetryMaster' or 'secondsBeforeRetryMaster'
		will cause an attempt to be made to reconnect to the
		master. [30]
<DT><CODE>enableDeprecatedAutoreconnect</CODE>
	<DD>Auto-reconnect functionality is deprecated starting with version 
		3.2, and will be removed in version 3.3. Set this property to 
		'true' to disable the check for the feature being configured. 
		[false]
</DL>
<P>
<H4>Security</H4>
<DL>
<DT><CODE>allowMultiQueries</CODE>
	<DD>Allow the use of ';' to delimit multiple queries during one
		statement. [false]
<DT><CODE>useSSL</CODE>
	<DD>Use SSL when communicating with the server? [false]
<DT><CODE>requireSSL</CODE>
	<DD>Require SSL connection if useSSL=true? [false]
<DT><CODE>allowUrlInLocalInfile</CODE>
	<DD>Should the driver allow URLs in 'LOAD DATA LOCAL INFILE' 
	statements? [false]
<DT><CODE>allowLoadLocalInfile</CODE>
	<DD>Should the driver allow use of 'LOAD DATA LOCAL INFILE...'. [true]
<DT><CODE>paranoid</CODE>
	<DD>Take measures to prevent exposure sensitive information in
		error messages and clear data structures holding sensitive data when
		possible? [false]
</DL>
<P>
<H4>Performance</H4>
<DL>
<DT><CODE>metadataCacheSize</CODE>
	<DD>The number of queries to cacheResultSetMetadata for if
		cacheResultSetMetaData is set to 'true' [50]
<DT><CODE>prepStmtCacheSize</CODE>
	<DD>If prepared statement caching is enabled, how many prepared
		statements should be cached? [25]
<DT><CODE>prepStmtCacheSqlLimit</CODE>
	<DD>If prepared statement caching is enabled, what's the
		largest SQL the driver will cache the parsing for? [256]
<DT><CODE>blobSendChunkSize</CODE>
	<DD>Chunk to use when sending BLOB/CLOBs via 
	    ServerPreparedStatements [1048576]
<DT><CODE>cacheCallableStmts</CODE>
	<DD>Should the driver cache the parsing stage of
		CallableStatements? [false]
<DT><CODE>cachePrepStmts</CODE>
	<DD>Should the driver cache the parsing stage of
		PreparedStatements? [false]
<DT><CODE>cacheResultSetMetadata</CODE>
	<DD>Should the driver cache ResultSetMetaData for Statements
		and PreparedStatements? (Req. JDK-1.4+) [false]
<DT><CODE>cacheServerConfiguration</CODE>
	<DD>Should the driver cache the results of 'SHOW VARIABLES' and 
		'SHOW COLLATION' on a per-URL basis? [false]
<DT><CODE>defaultFetchSize</CODE>
	<DD>The driver will call setFetchSize(n) with this value on all 
	     newly-created Statements [0]
<DT><CODE>dontTrackOpenResources</CODE>
	<DD>The JDBC specification requires the driver to automatically track 
	    and close resources, however if your application doesn't do a good 
	    job of explicitly calling close() on statements or result sets, 
	    this can cause memory leakage. Setting this property to true 
	    relaxes this constraint, and can be more memory efficient for some 
	    applications. [false]
<DT><CODE>dynamicCalendars</CODE>
	<DD>Should the driver retrieve the default calendar when required, or 
	    cache it per connection/session? [false]
<DT><CODE>elideSetAutoCommits</CODE>
	<DD>If using MySQL-4.1 or newer, should the driver only issue 
		'set autocommit=n' queries when the server's state doesn't match 
		the requested state by Connection.setAutoCommit(boolean)? [false]
<DT><CODE>holdResultsOpenOverStatementClose</CODE>
	<DD>Should the driver close result sets on Statement.close() as 
		required by the JDBC specification? [false]
<DT><CODE>rewriteBatchedStatements</CODE>
	<DD>Should the driver use multiqueries (irregardless of the setting of 
		"allowMultiQueries") as well as rewriting of prepared statements 
		for INSERT into multi-value inserts when executeBatch() is called? 
		Notice that this has the potential for SQL injection if using plain 
		java.sql.Statements and your code doesn't sanitize input correctly. 
		Notice that for prepared statements, server-side prepared 
		statements can not currently take advantage of this rewrite option, 
		and that if you don't specify stream lengths when using 
		PreparedStatement.set*Stream(),the driver won't be able to 
		determine the optimium number of parameters per batch and you might 
		receive anan error from the driver that the resultant packet is too 
		large. Statement.getGeneratedKeys() for these rewritten statements 
		only works when the entire batch includes INSERT statements. [false]
<DT><CODE>useFastIntParsing</CODE>
	<DD>Use internal String->Integer conversion routines to avoid excessive 
		object creation? [true]
<DT><CODE>useLocalSessionState</CODE>
	<DD>Should the driver refer to the internal values of autocommit and 
		transaction isolation that are set by Connection.setAutoCommit() 
		and Connection.setTransactionIsolation(), rather than querying the 
		database? [false]
<DT><CODE>useReadAheadInput</CODE>
	<DD>Use newer, optimized non-blocking, buffered input stream when 
		reading from the server? [true]
</DL>
<P>
<H4>Debugging and Profiling Properties</H4>
<DL>
<DT><CODE>logger</CODE>
	<DD>The name of a class that implements
		'com.mysql.jdbc.log.Log' that will be used to log messages
		to.(default logs to STDERR) [com.mysql.jdbc.log.StandardLogger]
<DT><CODE>profileSQL</CODE>
	<DD>Trace queries and their execution/fetch times to the
		configured logger? [false]
<DT><CODE>reportMetricsIntervalMillis</CODE>
	<DD>If 'gatherPerfMetrics' is enabled, how often should they be
		logged (in ms)? [30000]
<DT><CODE>maxQuerySizeToLog</CODE>
	<DD>Controls the maximum length/size of a query that will get logged 
		when profiling or tracing [2048]
<DT><CODE>packetDebugBufferSize</CODE>
	<DD>The maximum number of packets to retain when 'enablePacketDebug' is 
		true [20]
<DT><CODE>slowQueryThresholdMillis</CODE>
	<DD>If 'logSlowQueries' is enabled, how long should a query (in
		ms) before it is logged as 'slow'? [2000]
<DT><CODE>useUsageAdvisor</CODE>
	<DD>Should the driver issue 'usage' warnings advising proper
		and efficient usage of JDBC and MySQL Connector/J to the
		log? [false]
<DT><CODE>autoGenerateTestcaseScript</CODE>
	<DD>Should the driver dump the SQL it is executing, including 
	    server-side prepared statements to STDERR? [false]
<DT><CODE>dumpMetadataOnColumnNotFound</CODE>
	<DD>Should the driver dump the field-level metadata of a result set 
	    into the exception message when ResultSet.findColumn() 
	    fails? [false]
<DT><CODE>dumpQueriesOnException</CODE>
	<DD>Should the driver dump the contents of the query sent to the 
	    server in the message for SQLExceptions? [false]
<DT><CODE>enablePacketDebug</CODE>
	<DD>When enabled, a ring-buffer of 'packetDebugBufferSize' packets will
		be kept, and dumped when exceptions are thrown in key areas in the 
		driver's code [false]
<DT><CODE>explainSlowQueries</CODE>
	<DD>If 'logSlowQueries' is enabled, should the driver
		automatically issue an 'EXPLAIN' on the server and send the
		results to the configured log at a WARN level? [false]
<DT><CODE>logSlowQueries</CODE>
	<DD>Should queries that take longer than
		'slowQueryThresholdMillis' be logged? [false]
<DT><CODE>traceProtocol</CODE>
	<DD>Should trace-level network protocol be logged? [false]
</DL>	
<P>
<H4>Miscelaneous Properties</H4>
<DL>
<DT><CODE>useUnicode</CODE>
	<DD>Should the driver use Unicode character encodings when
		handling strings? Should only be used when the driver can't
		determine the character set mapping, or you are trying to
		'force' the driver to use a character set that MySQL either
		doesn't natively support (such as UTF-8)? [false]
<DT><CODE>characterEncoding</CODE>
	<DD>If <CODE>useUnicode</CODE> is true, what character encoding
		should the driver use when dealing with strings?
		[autodetect]
<DT><CODE>characterSetResults</CODE>
	<DD>Character set to tell the server to return results as.
<DT><CODE>connectionCollation</CODE>
	<DD>If set, tells the server to use this collation via 
	    'set collation_connection'
<DT><CODE>sessionVariables</CODE>
	<DD>A comma-separated list of name/value pairs to be sent as 
		SET SESSION ... to the server when the driver connects.
<DT><CODE>allowNanAndInf</CODE>
	<DD>Should the driver allow NaN or +/- INF values in 
		PreparedStatement.setDouble()? [false]
<DT><CODE>autoClosePStmtStreams</CODE>
	<DD>Should the driver automatically call .close() on streams/readers 
		passed as arguments via set*() methods? [false]
<DT><CODE>autoDeserialize</CODE>
	<DD>Should the driver automatically detect and de-serialize objects 
	    stored in BLOB fields? [false]
<DT><CODE>capitalizeTypeNames</CODE>
	<DD>Capitalize type names in DatabaseMetaData? (usually only
		useful when using WebObjects) [false]
<DT><CODE>clobberStreamingResults</CODE>
	<DD>This will cause a 'streaming' ResultSet to be automatically
		closed, and any oustanding data still streaming from the
		server to be discarded if another query is executed before
		all the data has been read from the server. [false]
<DT><CODE>continueBatchOnError</CODE>
	<DD>Should the driver continue processing batch commands if one
		statement fails? The JDBC spec allows either way. [true]
<DT><CODE>CreateDatabaseIfNotExist</CODE>
	<DD>Creates the database given in the URL if it doesn't yet exist. 
	    Assumes the configured user has permissions to create 
	    databases. [false]
<DT><CODE>emptyStringsConvertToZero</CODE>
	<DD>Should the driver allow conversions from empty string fields to 
		numeric values of '0'? [true]
<DT><CODE>emulateLocators</CODE>
	<DD>[false]
<DT><CODE>emulateUnsupportedPstmts</CODE>
	<DD>Should the driver detect prepared statements that are not supported
		by the server, and replace them with client-side emulated 
		versions? [true]
<DT><CODE>ignoreNonTxTables</CODE>
	<DD>Ignore non-transactional table warning for rollback? [false]
<DT><CODE>jdbcCompliantTruncation</CODE>
	<DD>Should the driver throw java.sql.DataTruncation exceptions when 
		data is truncated as is required by the JDBC specification when 
		connected to a server that supports warnings(MySQL 4.1.0 and 
		newer)? [true]
<DT><CODE>maxRows</CODE>
	<DD>The maximum number of rows to return (<=0 means return all
		rows). [-1]
<DT><CODE>noDatetimeStringSync</CODE>
	<DD>Don't ensure that 
		ResultSet.getDatetimeType().toString().equals(ResultSet.getString()) 	
		[false]
<DT><CODE>nullCatalogMeansCurrent</CODE>
	<DD>When DatabaseMetadataMethods ask for a 'catalog' parameter, does 
		the value null mean use the current catalog? (this is not 
		JDBC-compliant, but follows legacy behavior from earlier versions 
		of the driver) 	[true]
<DT><CODE>nullNamePatternMatchesAll</CODE>
	<DD>Should DatabaseMetaData methods that accept *pattern parameters 
		treat null the same as '%' (this is not JDBC-compliant, however 
		older versions of the driver accepted this departure from the 
		specification) 	[true]
<DT><CODE>overrideSupportsIntegrityEnhancementFacility</CODE>
	<DD>Should the driver return "true" for 
		DatabaseMetaData.supportsIntegrityEnhancementFacility() even if the 
		database doesn't support it to workaround applications that require 
		this method to return "true" to signal support of foreign keys, 
		even though the SQL specification states that this facility 
		contains much more than just foreign key support (one such 
		application being OpenOffice)? [false]
<DT><CODE>pedantic</CODE>
	<DD>Follow the JDBC spec to the letter. [false]
<DT><CODE>processEscapeCodesForPrepStmts</CODE>
	<DD>Should the driver process escape codes in queries that are 
		prepared? 	[true]
<DT><CODE>relaxAutoCommit</CODE>
	<DD>If the version of MySQL the driver connects to does not
		support transactions, still allow calls to commit(),
		rollback() and setAutoCommit()? [false]
<DT><CODE>retainStatementAfterResultSetClose</CODE>
	<DD>Should the driver retain the Statement reference in a ResultSet 
		after ResultSet.close() has been called. This is not JDBC-compliant 
		after JDBC-4.0. 	[false]
<DT><CODE>rollbackOnPooledClose</CODE>
	<DD>Should the driver issue a rollback() when the logical connection in 
		a pool is closed? 	[true]
<DT><CODE>runningCTS13</CODE>
	<DD>Enables workarounds for bugs in Sun's JDBC compliance testsuite 
		version 1.3 	[false]
<DT><CODE>serverTimezone</CODE>
	<DD>Override detection/mapping of timezone. Used when timezone
		from server doesn't map to Java timezone. [none]
<DT><CODE>strictUpdates</CODE>
	<DD>Should the driver do strict checking (all primary keys
		selected) of updatable result sets? [true]
<DT><CODE>tinyInt1isBit</CODE>
	<DD>Should the driver treat the datatype TINYINT(1) as the BIT type 
		(because the server silently converts BIT -> TINYINT(1) when 
		creating tables)? [true]
<DT><CODE>transformedBitIsBoolean</CODE>
	<DD>If the driver converts TINYINT(1) to a different type, should it 
		use BOOLEAN instead of BIT for future compatibility with 
		MySQL-5.0, as MySQL-5.0 has a BIT type? 	[false]
<DT><CODE>ultraDevHack</CODE>
	<DD>Create PreparedStatements for prepareCall() when required,
		because UltraDev is broken and issues a prepareCall() for
		_all_ statements? [false]
<DT><CODE>useGmtMillisForDatetimes</CODE>
	<DD>Convert between session timezone and GMT before creating Date 
		and Timestamp instances (value of "false" is legacy behavior, 
		"true" leads to more JDBC-compliant behavior. 	[false]
<DT><CODE>useHostsInPrivileges</CODE>
	<DD>Add '@hostname' to users in 
		DatabaseMetaData.getColumn/TablePrivileges() (true/false), defaults 
		to 'true'. 	[true]
<DT><CODE>useOldUTF8Behavior</CODE>
	<DD>Use the UTF-8 behavior the driver did when communicating with 4.0 
		and older servers 	[false]
<DT><CODE>useOnlyServerErrorMessages</CODE>
	<DD>Don't prepend 'standard' SQLState error messages to error messages 
		returned by the server. 	[true]
<DT><CODE>useServerPrepStmts</CODE>
	<DD>Use server-side prepared statements if the server supports
		them? [true]
<DT><CODE>useSqlStateCodes</CODE>
	<DD>Use SQL Standard state codes instead of 'legacy' X/Open/SQL state 
		codes (true/false), default is 'true' 	[true]
<DT><CODE>useStreamLengthsInPrepStmts</CODE>
	<DD>Honor stream length parameter in
		PreparedStatement/ResultSet.setXXXStream() method calls? [true]
<DT><CODE>useTimezone</CODE>
	<DD>Convert time/date types between client and server
		timezones? [false]
<DT><CODE>useUnbufferedInput</CODE>
	<DD>Don't use BufferedInputStream for reading data from the
		server? [true]
<DT><CODE>yearIsDateType</CODE>
	<DD>Should the JDBC driver treat the MySQL type "YEAR" as a 
		java.sql.Date, or as a SHORT? 	[true]
<DT><CODE>zeroDateTimeBehavior</CODE>
	<DD>What should happen when the driver encounters DATETIME values that 
		are composed entirely of zeroes (used by MySQL to represent invalid 
		dates)? Valid values are 'exception', 'round' and 'convertToNull'. 	
		[exception]
<DT><CODE>gatherPerfMetrics</CODE>
	<DD>Should the driver gather performance metrics, and report
		them via the configured logger every
		'reportMetricsIntervalMillis' milliseconds? [false]
<DT><CODE>useNewIO</CODE>
	<DD>Should the driver use the java.nio.* interfaces for network
		communication? [false]
<DT><CODE>callableStmtCacheSize</CODE>
	<DD>If 'cacheCallableStmts' is enabled, how many callable
		statements should be cached? [100]
<DT><CODE>initialTimeout</CODE>
	<DD>If <CODE>autoReconnect</CODE> is enabled, the initial time
		to wait between re-connect attempts (seconds). [2]
<DT><CODE>maxReconnects</CODE>
	<DD>If autoReconnect is enabled, how many times should the
		driver attempt to reconnect? [3]
</DL>
*/
public static final String
	Optional_Parameters[] =
	{
	"user",
	"password",
	"allowLoadLocalInfile",
	"allowUrlInLocalInfile",
	"allowMultiQueries",
	"allowNanAndInf",
	"autoClosePStmtStreams",
	"autoDeserialize",
	"autoReconnect",
	"autoReconnectForPools",
	"autoGenerateTestcaseScript",
	"blobSendChunkSize",
	"cacheCallableStmts",
	"cachePrepStmts",
	"cacheResultSetMetadata",
	"cacheServerConfiguration",
	"callableStmtCacheSize",
	"capitalizeTypeNames",
	"characterEncoding",
	"characterSetResults",
	"clobberStreamingResults",
	"connectTimeout",
	"connectionCollation",
	"continueBatchOnError",
	"createDatabaseIfNotExist",
	"defaultFetchSize",
	"dontTrackOpenResources",
	"dumpMetaDataOnColumnNotFound",
	"dumpQueriesOnException",
	"dynamicCalendars",  
	"elideSetAutoCommits",
	"emptyStringsConvertToZero",
	"emulateLocators",
	"emulateUnsupportedPstmts",
	"enableDeprecatedAutoreconnect",
	"enablePacketDebug",
	"explainSlowQueries",
	"failOverReadOnly",
	"gatherPerfMetrics",
	"holdResultsOpenOverStatementClose",
	"ignoreNonTxTables",
	"initialTimeout",
	"interactiveClient",
	"jdbcCompliantTruncation",
	"logger",
	"logSlowQueries",
	"maxQuerySizeToLog",
	"maxReconnects",
	"maxRows",
	"metadataCacheSize",
	"noDatetimeStringSync",
	"nullCatalogMeansCurrent",
	"nullNamePatternMatchesAll",
	"overrideSupportsIntegrityEnhancementFacility",
	"paranoid",
	"packetDebugBufferSize",
	"pedantic",
	"prepStmtCacheSize",
	"prepStmtCacheSqlLimit",
	"processEscapeCodesForPrepStmts",
	"profileSQL",
	"propertiesTransform",
	"queriesBeforeRetryMaster",
	"reconnectAtTxEnd",
	"relaxAutoCommit",
	"reportMetricsIntervalMillis",
	"requireSSL",
	"retainStatementAfterResultSetClose",
	"rewriteBatchedStatements",
	"rollbackOnPooledClose",
	"roundRobinLoadBalance",
	"runningCTS13",
	"secondsBeforeRetryMaster",
	"serverTimezone",
	"sessionVariables",
	"slowQueryThresholdMillis",
	"socketFactory",
	"socketTimeout",
	"strictUpdates",
	"tinyInt1isBit",
	"traceProtocol",
	"transformedBitIsBoolean",
	"ultraDevHack",
	"useCompression",
	"useConfigs",
	"useFastIntParsing",
	"useGmtMillisForDatetimes",
	"useHostsInPrivileges",
	"useLocalSessionState",
	"useNewIO",
	"useOldUTF8Behavior",
	"useOnlyServerErrorMessages",
	"useReadAheadInput",
	"useServerPrepStmts",
	"useSqlStateCodes",
	"useSSL",
	"useStreamLengthsInPrepStmts",
	"useTimezone",
	"useUnbufferedInput",
	"useUnicode",
	"useUsageAdvisor",
	"yearIsDateType",
	"zeroDateTimeBehavior"
	};

private static final String
	NL = Database.NL;


//	DEBUG control.
private static final int
	DEBUG_OFF		= 0,
	DEBUG_OPEN		= 1 << 0,

	DEBUG			= DEBUG_OFF;

/*==============================================================================
	Constructors
*/
/**	Creates the abstract JDBC_Data_Port finalizer class and registers
	the class ID and name of the Data_Port type.
*/
public MySQL_Data_Port ()
{
ID_Type (ID, Port_Type);
Treat_Schema_As_Catalog = false;
}

/*==============================================================================
	Methods
*/
//	Data_Port Implementation
/**	Implements the Data_Port <CODE>Parameters</CODE> method.
<P>
	@see	Data_Port#Parameters()
*/
public Configuration Parameters ()
	throws Database_Exception
{
try
	{
	Parameter
		parameters = new Parameter (Port_Type),
		group = new Parameter ("Required");
	int
		index;
	for (index = 0;
		 index < URL_Specs.length;
		 index++)
		group.Add (new Parameter (URL_Specs[index][0])
			.Value (URL_Specs[index][1]));
	parameters.Add (group);

	group = new Parameter ("Optional");
	group.Add (new Parameter (PORT));
	group.Add (new Parameter (Database.CATALOG));
	for (index = 0;
		 index < Optional_Parameters.length;
		 index++)
		group.Add (new Parameter (Optional_Parameters[index]));
	parameters.Add (group);
	return new Configuration (parameters);
	}
catch (Exception exception)
	{
	//	This shouldn't happen if the coding is correct.
	throw new Database_Exception
		(
		ID + NL
		+ exception.getMessage () + NL
		+"There is a coding flaw in the Parameters method!"
		);
	}
}

//	Data_Port Implementation
/**	Implements the Data_Port <CODE>Open</CODE> method.
<P>
	The Configuration that is supplied is conditionally set
	(existing parameters of the same name are not reset) with
	the required {@link #URL_Specs URL specifications} default
	values. Then the Configuration is provided to the base
	JDBC_Data_Port <CODE>{@link JDBC_Data_Port#Configure Configure}</CODE>
	method to load the JDBC driver and save the Configuration.
<P>
	The URL specifying how the connection will be made to the
	database server has the form:
<P>
	<B>jdbc:mysql://</B>[<I>HOST</I>][<B>:</B><I>PORT</I>]<B>/</B><I>CATALOG</I>[<B>?</B><I>param1</I><B>=</B><I>value1</I>[<B>&</B><I>param2</I><B>=</B><I>value2</I>][...]]
<P>
	All of the parameters will be sought in the Configuration.
	The paramN options are in the {@link #Optional_Parameters
	optional parameters} list. Parameters with these names in the
	Configuration will be included in the URL, otherwise they will
	be omitted.
<P>
	The URL specification is provided to the JDBC_Data_Port <CODE>
	{@link JDBC_Data_Port#Open_Data_Port Open_Data_Port} method
	which opens a connection to the database server.
<P>
	@param	configuration	The Configuration for this Data_Port.
	@throws	Database_Exception	If no Configuration is provided
		or the JDBC_Data_Port fails to load the driver or make
		the connection to the database server.
*/
public void Open
	(
	Configuration	configuration
	)
	throws Database_Exception
{
if ((DEBUG & DEBUG_OPEN) != 0)
	System.out.println (">>> MySQL_Data_Port.Open: Configuration -" + NL
		+ configuration.Description ());
//	Setup the configuration.
if (configuration == null)
	throw new Database_Exception
		(
		ID + NL
		+"An invalid (null) configuration was specified."
		);

//	Don't be case sensitive here.
boolean
	case_sensitive = configuration.Case_Sensitive (false);
try
	{
	//	Set the required parameters.
	if ((DEBUG & DEBUG_OPEN) != 0)
		{
		System.out.println
			("    MySQL_Data_Port.Open: Set_Conditionally (URL_Specs) -");
		for (int element = 0;
				 element < URL_Specs.length;
				 element++)
			System.out.println
				("      " + URL_Specs[element][0]
				+" - " + URL_Specs[element][1]);
		}
	configuration.Set_Conditionally (URL_Specs);

	//	Register the configuration, which loads our driver.
	if ((DEBUG & DEBUG_OPEN) != 0)
		System.out.println
			("    MySQL_Data_Port.Open: Configure");
	Configure (configuration);

	//	Assemble the URL.
	String
		URL = "jdbc:"
			+ Port_Type
			+ "://" + Config_Value (Configuration.HOST);
	String
		URL_part;
	if (! (URL_part = Config_Value (PORT)).equals (""))
		URL += ":" + URL_part;
	URL += "/" + Config_Value (Database.CATALOG);
	if ((DEBUG & DEBUG_OPEN) != 0)
		System.out.println
			("    MySQL_Data_Port.Open: Assembling the URL -" + NL
			+"      Port_Type - " + Port_Type + NL
			+"           HOST - " + Config_Value (Configuration.HOST) + NL
			+"           PORT - " + Config_Value (PORT) + NL
			+"        Catalog - " + Config_Value (Database.CATALOG) + NL
			+"    ->URL - " + URL + NL
			+"    Optional parameters -");

	//	Optional parameters:
	String
		delimiter = "?";
	for (int part = 0;
			 part < Optional_Parameters.length;
			 part++)
		{
		if ((DEBUG & DEBUG_OPEN) != 0)
			System.out.println
				("      " + Optional_Parameters[part]
				+" - " + Config_Value (Optional_Parameters[part]));
		URL_part = Config_Value (Optional_Parameters[part]);
		if (! URL_part.equals (""))
			{
			URL += delimiter + Optional_Parameters[part] + "=" + URL_part;
			if (delimiter.equals ("?"))
				delimiter = "&";
			}
		}

	//	Open the data port connection.
	if ((DEBUG & DEBUG_OPEN) != 0)
		System.out.println
			("    MySQL_Data_Port.Open: Open_Data_Port (" + URL + ")");
	Open_Data_Port (URL);
	}
catch (Configuration_Exception exception)
	{
	configuration.Case_Sensitive (case_sensitive);

	//	Copy the exception with password masked message.
	Configuration_Exception
		configuration_exception = new Configuration_Exception
			(Database_Exception.masked_String (exception.getMessage ()),
			exception.getCause ());
	configuration_exception.setStackTrace (exception.getStackTrace ());
	throw new Database_Exception (configuration_exception);
	}
catch (Database_Exception exception)
	{
	configuration.Case_Sensitive (case_sensitive);
	throw exception;
	}
}

/**	Specialization of the interface's Query method to provide
	implementation of the limit functionality using the MySQL
	specific capability.
<P>
	@see	JDBC_Data_Port#Query(String, int)
*/
public Vector Query
	(
	String	SQL_query,
	int		limit
	)
	throws Database_Exception
{
if (limit > 0 &&
	SQL_query != null &&
	SQL_query.toUpperCase ().indexOf ("LIMIT") < 0)
	SQL_query += " LIMIT " + limit;

return super.Query (SQL_query, limit);
}


}	//	End of class
