/*	test_Styled_Multiwriter

PIRL CVS ID: test_Styled_Multiwriter.java,v 1.3 2012/04/16 06:18:24 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Utilities.Styled_Multiwriter;
import	PIRL.Utilities.Multiwriter_IOException;

import	PIRL.Utilities.Checker;

import	java.io.StringWriter;
import	java.util.Iterator;

public class test_Styled_Multiwriter
{

public static void main
	(
	String[] arguments
	)
{
System.out.println
	("*** test_Styled_Multiwriter:\n"
	+ Styled_Multiwriter.ID);

Checker
	checker = new Checker ();
if (arguments.length > 0 &&
	arguments[0].startsWith ("-v"))
	checker.Verbose = true;

int
	status = 0;

try
	{
	if (checker.Verbose)
		System.out.println
			("--- Constructor");
	Styled_Multiwriter
		multiwriter = new Styled_Multiwriter ();

	StringWriter
		writer_0 = new StringWriter (),
		writer_1 = new StringWriter (),
		writer_2 = new StringWriter ();

	if (checker.Verbose)
		System.out.println
			("--- Add");
	checker.Check ("Add (null)", false, multiwriter.Add (null));
	checker.Check ("Add (writer_0)", true, multiwriter.Add (writer_0));
	checker.Check ("Add (writer_1)", true, multiwriter.Add (writer_1));
	checker.Check ("Add (writer_2)", true, multiwriter.Add (writer_2));
	checker.Check ("Add (writer_2) again", false, multiwriter.Add (writer_2));
	checker.Check ("Writers ().size ()", 3, multiwriter.Writers ().size ());

	String
		expected = "Test string";
	if (checker.Verbose)
		System.out.println
			("--- write (\"" + expected + "\")");
	multiwriter.write (expected);
	checker.Check ("write (\"" + expected + "\")", expected,
		writer_0.toString ());
	checker.Check ("write (\"" + expected + "\")", expected,
		writer_1.toString ());
	checker.Check ("write (\"" + expected + "\")", expected,
		writer_2.toString ());
	}
catch (Multiwriter_IOException exception)
	{
	System.out.println (exception + "\n"
		+ exception.Exceptions.size () + " exceptions -");
	Iterator
		exceptions = exception.Exceptions.iterator ();
	while (exceptions.hasNext ())
		System.out.println (exceptions.next ());
	System.out.println ();
	exception.printStackTrace (System.out);

	status = 1;
	}

System.out.println ("\nChecks: " + checker.Checks_Total );
System.out.println ("Passed: " + checker.Checks_Passed);
System.exit (status);
}


}
