---
layout: default
built_from_commit: 70303b65ae864066c583e1436011ff135847f6ad
title: 'Man Page: puppet report'
canonical: "/puppet/latest/man/report.html"
---

# Man Page: puppet report

> **NOTE:** This page was generated from the Puppet source code on 2024-08-29 17:41:46 -0700

## NAME
**puppet-report** - Create, display, and submit reports.

## SYNOPSIS
puppet report *action* \[\--terminus \_TERMINUS\]

## OPTIONS
Note that any setting that\'s valid in the configuration file is also a
valid long argument, although it may or may not be relevant to the
present action. For example, **server** and **run_mode** are valid
settings, so you can specify **\--server \<servername\>**, or
**\--run_mode \<runmode\>** as an argument.

See the configuration file documentation at
*https://puppet.com/docs/puppet/latest/configuration.html* for the full
list of acceptable parameters. A commented list of all configuration
options can also be generated by running puppet with **\--genconfig**.

\--render-as FORMAT

:   The format in which to render output. The most common formats are
    **json**, **s** (string), **yaml**, and **console**, but other
    options such as **dot** are sometimes available.

\--verbose

:   Whether to log verbosely.

\--debug

:   Whether to log debug information.

\--terminus \_TERMINUS

:   Indirector faces expose indirected subsystems of Puppet. These
    subsystems are each able to retrieve and alter a specific type of
    data (with the familiar actions of **find**, **search**, **save**,
    and **destroy**) from an arbitrary number of pluggable backends. In
    Puppet parlance, these backends are called terminuses.

    Almost all indirected subsystems have a **rest** terminus that
    interacts with the puppet master\'s data. Most of them have
    additional terminuses for various local data models, which are in
    turn used by the indirected subsystem on the puppet master whenever
    it receives a remote request.

    The terminus for an action is often determined by context, but
    occasionally needs to be set explicitly. See the \"Notes\" section
    of this face\'s manpage for more details.

## ACTIONS
**info** - Print the default terminus class for this face.

:   **SYNOPSIS**

    puppet report info \[\--terminus \_TERMINUS\]

    **DESCRIPTION**

    Prints the default terminus class for this subcommand. Note that
    different run modes may have different default termini; when in
    doubt, specify the run mode with the \'\--run_mode\' option.

**save** - API only: submit a report.

:   **SYNOPSIS**

    puppet report save \[\--terminus \_TERMINUS\] *report*

    **DESCRIPTION**

    API only: create or overwrite an object. As the Faces framework does
    not currently accept data from STDIN, save actions cannot currently
    be invoked from the command line.

    **RETURNS**

    Nothing.

**submit** - API only: submit a report with error handling.

:   **SYNOPSIS**

    puppet report submit \[\--terminus \_TERMINUS\] *report*

    **DESCRIPTION**

    API only: Submits a report to the puppet master. This action is
    essentially a shortcut and wrapper for the **save** action with the
    **rest** terminus, and provides additional details in the event of a
    failure.

## EXAMPLES
**save**

From the implementation of **puppet report submit** (API example):

begin Puppet::Transaction::Report.indirection.terminus_class = :rest
Puppet::Face\[:report, \"0.0.1\"\].save(report) Puppet.notice \"Uploaded
report for ##{report.name}\" rescue =\> detailPuppet.log_exception(detail, \"Could not send report: ##{detail}\") end
**submit**

API example:report = Puppet::Face\[:catalog, \'0.0.1\'\].apply
Puppet::Face\[:report, \'0.0.1\'\].submit(report) return report

## NOTES
This subcommand is an indirector face, which exposes **find**,
**search**, **save**, and **destroy** actions for an indirected
subsystem of Puppet. Valid termini for this face include:

-   **json**

-   **msgpack**

-   **processor**

-   **rest**

-   **yaml**

## COPYRIGHT AND LICENSE
Copyright 2011 by Puppet Inc. Apache 2 license; see COPYING
