
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2451179.5,
          {-0.1795,0.0,7.9092,0.07612,0.000382,0.0625}, /*cmx*/
          {-5.779392,-1.3072,-4.1302,-0.7473}, /*cfx*/
          {0.0893,0.00066,6.1408,0.02857,0.000213,0.048}, /*cmy*/
          {-3.382185,-4.7183,-1.0061,-4.5032}, /*cfy*/
          {-0.089,0.00057,8.7367,0.07768,0.000407,0.067}, /*cmz*/
          {-4.47025,-6.0098,-2.6136,-5.7988} /*cfz*/
     },
     {
          2451229.5,
          {-0.1754,0.00016,7.4941,0.04508,0.000896,0.0545}, /*cmx*/
          {-1.195564,-2.8814,-6.0342,-4.0809}, /*cfx*/
          {0.112,0.00031,6.1961,0.01502,0.000294,0.047}, /*cmy*/
          {-4.871196,-0.5173,-3.6146,-1.3858}, /*cfy*/
          {-0.0785,0.00142,9.0423,0.0405,0.000815,0.0655}, /*cmz*/
          {-6.121933,-1.3348,-4.4743,-2.6513} /*cfz*/
     },
     {
          2451279.5,
          {-0.1863,0.00192,7.5052,0.07076,0.000542,0.0565}, /*cmx*/
          {-2.537202,-1.0218,-4.2663,-0.5975}, /*cfx*/
          {0.1431,-1e-05,6.1632,0.02372,0.000277,0.0485}, /*cmy*/
          {-6.205722,-4.7242,-1.5872,-4.3158}, /*cfy*/
          {0.0395,0.00231,9.0481,0.06664,0.000516,0.0566}, /*cmz*/
          {-1.173402,-5.6383,-2.5706,-5.1795} /*cfz*/
     },
     {
          2451329.5,
          {-0.0925,0.00045,7.7713,0.01148,0.000778,0.0663}, /*cmx*/
          {-3.58054,-4.3262,-5.618,-3.6192}, /*cfx*/
          {0.1368,-0.00035,6.2026,0.0128,0.00035,0.0486}, /*cmy*/
          {-1.171066,-2.1969,-3.1915,-1.1493}, /*cfy*/
          {0.1314,-0.00014,8.6995,0.01,0.000762,0.062}, /*cmz*/
          {-2.274791,-3.684,-3.9715,-2.3263} /*cfz*/
     },
     {
          2451379.5,
          {-0.063,-0.00099,7.625,0.08491,0.0006,0.0501}, /*cmx*/
          {-5.179545,-0.5055,-1.6826,-1.0413}, /*cfx*/
          {0.1279,-0.00012,6.2819,0.04756,0.00041,0.0448}, /*cmy*/
          {-2.703399,-4.3035,-6.1781,-4.5976}, /*cfy*/
          {0.1437,0.00024,8.852,0.08654,0.000533,0.063}, /*cmz*/
          {-3.871381,-5.3416,-0.4158,-5.8768} /*cfz*/
     },
     {
          2451429.5,
          {-0.1505,-0.00022,7.6942,0.12921,0.000869,0.0569}, /*cmx*/
          {-0.885696,-2.3436,-4.1621,-5.0264}, /*cfx*/
          {0.1178,-0.00108,5.6379,0.05601,0.000666,0.0339}, /*cmy*/
          {-4.39383,-0.3393,-2.5031,-1.8534}, /*cfy*/
          {0.1438,-0.00038,9.2381,0.10866,0.000781,0.0732}, /*cmz*/
          {-5.731852,-0.9464,-2.5918,-3.307} /*cfz*/
     },
     {
          2451479.5,
          {-0.1385,-0.00158,8.7323,0.13917,0.001078,0.0694}, /*cmx*/
          {-2.9779,-4.3897,-0.2677,-2.4636}, /*cfx*/
          {0.0648,-0.00208,3.524,0.05872,0.000683,0.0196}, /*cmy*/
          {-5.906012,-3.1519,-5.3218,-4.7344}, /*cfy*/
          {0.1216,-0.00162,9.3075,0.12411,0.001021,0.0727}, /*cmz*/
          {-1.382011,-2.9531,-4.7299,-0.6824} /*cfz*/
     },
     {
          2451529.5,
          {-0.2224,0.00064,9.4207,0.12129,0.000825,0.0714}, /*cmx*/
          {-4.95725,-0.3162,-2.362,-6.0809}, /*cfx*/
          {-0.0284,-0.00087,2.9702,0.05679,0.000692,0.0284}, /*cmy*/
          {-0.215696,-5.933,-1.8478,-1.0427}, /*cfy*/
          {0.0567,-0.00052,8.8677,0.14132,0.000996,0.0653}, /*cmz*/
          {-3.391458,-5.0552,-0.6811,-4.4081} /*cfz*/
     },
     {
          2451579.5,
          {-0.2032,0.00059,8.8295,0.11458,0.000652,0.06}, /*cmx*/
          {-0.606756,-2.4049,-4.1278,-3.4824}, /*cfx*/
          {-0.0993,-0.00012,5.253,0.05835,0.000614,0.0394}, /*cmy*/
          {-1.573183,-2.4317,-4.4235,-4.5116}, /*cfy*/
          {0.01,-0.00199,8.4583,0.14122,0.000856,0.0598}, /*cmz*/
          {-5.501314,-0.8284,-2.7957,-2.1484} /*cfz*/
     },
     {
          2451629.5,
          {-0.1542,-0.00037,7.7813,0.12355,0.000688,0.0535}, /*cmx*/
          {-2.625991,-4.3385,-6.0339,-1.0655}, /*cfx*/
          {-0.0764,-0.00029,6.2748,0.06541,0.000633,0.0428}, /*cmy*/
          {-3.329059,-4.9004,-0.8789,-1.7635}, /*cfy*/
          {-0.087,-0.00058,8.7182,0.12913,0.000881,0.0714}, /*cmz*/
          {-1.316794,-2.7868,-4.7902,-6.0523} /*cfz*/
     },
     {
          2451679.5,
          {-0.174,0.0013,7.6835,0.13163,0.000767,0.0578}, /*cmx*/
          {-4.767884,-6.2433,-2.0113,-4.8673}, /*cfx*/
          {-0.1069,0.00064,5.5753,0.05474,0.000657,0.0345}, /*cmy*/
          {-5.068865,-1.1602,-3.4556,-5.1364}, /*cfy*/
          {-0.1074,-0.00053,9.2447,0.12004,0.000852,0.0757}, /*cmz*/
          {-3.295328,-4.7968,-0.5982,-3.3791} /*cfz*/
     },
     {
          2451729.5,
          {-0.1266,-0.00057,8.7741,0.11262,0.000708,0.0647}, /*cmx*/
          {-0.535607,-1.9451,-4.1398,-2.3072}, /*cfx*/
          {-0.0655,0.00017,3.5794,0.05048,0.000471,0.0222}, /*cmy*/
          {-0.195545,-3.9357,-6.0559,-1.5961}, /*cfy*/
          {-0.1392,-0.00055,9.3288,0.11143,0.000633,0.0707}, /*cmz*/
          {-5.195349,-0.5796,-2.5734,-0.6819} /*cfz*/
     },
     {
          2451779.5,
          {-0.1404,0.00061,9.3804,0.08579,0.000525,0.0688}, /*cmx*/
          {-2.395074,-3.9759,-5.8828,-5.8937}, /*cfx*/
          {-0.0593,0.0003,3.1827,0.04538,0.000417,0.0321}, /*cmy*/
          {-0.890489,-0.045,-2.207,-4.0161}, /*cfy*/
          {-0.1721,0.00033,8.8581,0.10662,0.000498,0.0617}, /*cmz*/
          {-0.810215,-2.5268,-4.3602,-4.374} /*cfz*/
     },
     {
          2451829.5,
          {-0.1145,0.00048,8.929,0.07945,0.000474,0.0657}, /*cmx*/
          {-4.15956,-5.9018,-1.276,-3.0909}, /*cfx*/
          {-0.0488,5e-05,4.956,0.03858,0.000408,0.0456}, /*cmy*/
          {-2.079,-2.4032,-4.4808,-0.8131}, /*cfy*/
          {-0.1468,-0.00113,8.4208,0.10513,0.000464,0.0601}, /*cmz*/
          {-2.739017,-4.3545,-0.0231,-1.7601} /*cfz*/
     },
     {
          2451879.5,
          {-0.0958,0.00073,7.9994,0.09,0.000377,0.0614}, /*cmx*/
          {-5.946936,-1.4522,-3.2832,-0.3015}, /*cfx*/
          {-0.0368,0.00045,6.1525,0.03967,0.000357,0.0507}, /*cmy*/
          {-3.609459,-4.8108,-0.6951,-4.045}, /*cfy*/
          {-0.2048,0.00038,8.5907,0.09744,0.00043,0.0638}, /*cmz*/
          {-4.651795,-6.154,-1.997,-5.2887} /*cfz*/
     },
     {
          2451929.5,
          {-0.0545,0.00082,7.416,0.09382,0.000292,0.0574}, /*cmx*/
          {-1.556437,-3.2103,-5.5781,-3.886}, /*cfx*/
          {-0.0251,0.00027,6.2518,0.03551,0.000301,0.0469}, /*cmy*/
          {-5.199736,-0.8636,-3.1195,-1.0048}, /*cfy*/
          {-0.195,-0.00069,9.1003,0.08248,0.000362,0.0676}, /*cmz*/
          {-0.195695,-1.6923,-3.918,-2.4437} /*cfz*/
     },
     {
          2451979.5,
          {0.0012,-0.00054,7.7696,0.07834,0.000526,0.0563}, /*cmx*/
          {-3.44306,-4.8899,-1.6168,-1.1785}, /*cfx*/
          {0.0005,0.00063,5.3534,0.02879,0.000151,0.0379}, /*cmy*/
          {-0.43391,-3.2882,-6.2811,-4.1489}, /*cfy*/
          {-0.2164,0.00016,9.3636,0.06522,0.000389,0.0706}, /*cmz*/
          {-1.915799,-3.5178,-0.1242,-5.8235} /*cfz*/
     },
     {
          2452029.5,
          {-0.0265,-0.00193,8.3108,0.01809,0.000855,0.0618}, /*cmx*/
          {-5.087321,-6.2373,-3.1886,-4.2172}, /*cfx*/
          {0.0233,0.00041,4.3241,0.0113,0.000362,0.0387}, /*cmy*/
          {-1.818533,-4.3119,-2.0194,-0.881}, /*cfy*/
          {-0.2236,0.00068,9.3335,0.01721,0.000682,0.0629}, /*cmz*/
          {-3.488502,-4.946,-1.8589,-2.5287} /*cfz*/
     },
     {
          2452079.5,
          {-0.1158,-0.0012,8.0919,0.06386,0.001155,0.0608}, /*cmx*/
          {-6.273235,-4.4409,-1.3133,-0.7674}, /*cfx*/
          {0.0534,0.00088,4.7498,0.02665,0.000459,0.0369}, /*cmy*/
          {-3.249301,-3.2369,-6.1716,-4.1672}, /*cfy*/
          {-0.1795,0.00174,9.3798,0.04708,0.000906,0.0735}, /*cmz*/
          {-4.732562,-3.0267,-6.1766,-5.6297} /*cfz*/
     },
     {
          2452129.5,
          {-0.1969,0.00033,7.9913,0.06448,0.000644,0.0534}, /*cmx*/
          {-1.274448,-2.5758,-3.5757,-4.3164}, /*cfx*/
          {0.0992,-0.00038,4.9957,0.02799,0.000386,0.0294}, /*cmy*/
          {-4.619829,-0.8187,-2.371,-1.0947}, /*cfy*/
          {-0.0821,-7e-05,9.3234,0.05103,0.000647,0.0749}, /*cmz*/
          {-6.050726,-1.2184,-2.0256,-2.6796} /*cfz*/
     },
     {
          2452179.5,
          {-0.148,-0.00095,8.8325,0.11317,0.000803,0.0652}, /*cmx*/
          {-3.105117,-4.5018,-0.1543,-1.6075}, /*cfx*/
          {0.0756,-0.00099,3.33,0.05172,0.000557,0.0176}, /*cmy*/
          {-5.976786,-3.2931,-5.3573,-3.8425}, /*cfy*/
          {-0.1057,-0.00038,9.2893,0.10255,0.000876,0.0771}, /*cmz*/
          {-1.503468,-3.0455,-4.617,-6.2713} /*cfz*/
     },
     {
          2452229.5,
          {-0.2019,0.00146,9.3968,0.11217,0.000771,0.0662}, /*cmx*/
          {-5.009987,-0.3359,-2.2746,-5.2353}, /*cfx*/
          {0.0309,2e-05,2.8573,0.05361,0.000652,0.0262}, /*cmy*/
          {-0.293982,-5.9154,-1.8168,-0.1326}, /*cfy*/
          {-0.1089,-0.00043,8.8743,0.13361,0.000979,0.0727}, /*cmz*/
          {-3.436293,-5.069,-0.6738,-3.654} /*cfz*/
     },
     {
          2452279.5,
          {-0.1409,0.00033,8.8945,0.11154,0.000642,0.0597}, /*cmx*/
          {-0.63159,-2.4078,-4.1359,-2.6301}, /*cfx*/
          {0.0114,-0.00017,5.04,0.05581,0.000586,0.0366}, /*cmy*/
          {-1.608861,-2.4071,-4.3522,-3.5424}, /*cfy*/
          {-0.1413,-0.00129,8.5067,0.14127,0.000859,0.0633}, /*cmz*/
          {-5.501635,-0.8409,-2.8572,-1.2274} /*cfz*/
     },
     {
          2452329.5,
          {-0.1053,0.00099,7.9086,0.11811,0.000672,0.0576}, /*cmx*/
          {-2.625011,-4.347,-5.9615,-0.2138}, /*cfx*/
          {0.0345,-0.00037,6.1968,0.06502,0.000569,0.0392}, /*cmy*/
          {-3.359998,-4.8746,-0.7475,-0.8782}, /*cfy*/
          {-0.2113,0.0003,8.7035,0.13069,0.000829,0.0653}, /*cmz*/
          {-1.308081,-2.8192,-4.8184,-5.227} /*cfz*/
     },
     {
          2452379.5,
          {-0.0581,0.0018,7.6142,0.12856,0.00081,0.0636}, /*cmx*/
          {-4.74378,-6.2306,-1.8554,-4.0256}, /*cfx*/
          {-0.0036,0.0,5.742,0.0573,0.000628,0.0336}, /*cmy*/
          {-5.136209,-1.0192,-3.3296,-4.3243}, /*cfy*/
          {-0.1846,-0.00077,9.1872,0.12214,0.000839,0.0726}, /*cmz*/
          {-3.30549,-4.8039,-0.5829,-2.6615} /*cfz*/
     },
     {
          2452429.5,
          {0.0183,-0.00014,8.5371,0.12151,0.000814,0.0673}, /*cmx*/
          {-0.537172,-1.9277,-4.111,-1.4664}, /*cfx*/
          {0.0011,-0.00116,3.9098,0.04888,0.000508,0.0216}, /*cmy*/
          {-0.401621,-3.759,-5.901,-1.0167}, /*cfy*/
          {-0.2284,0.00056,9.3875,0.1148,0.000677,0.0727}, /*cmz*/
          {-5.220673,-0.5727,-2.6023,-6.2506} /*cfz*/
     },
     {
          2452479.5,
          {0.0257,0.00092,9.3333,0.09651,0.000605,0.0681}, /*cmx*/
          {-2.442808,-3.9785,-6.0242,-5.1121}, /*cfx*/
          {-0.0541,-0.00088,2.7914,0.04615,0.000441,0.0289}, /*cmy*/
          {-1.209271,-0.0006,-2.1247,-3.4661}, /*cfy*/
          {-0.2084,0.0006,9.0556,0.10886,0.000523,0.0654}, /*cmz*/
          {-0.840297,-2.5638,-4.3857,-3.5957} /*cfz*/
     },
     {
          2452529.5,
          {0.0649,-0.00025,9.1304,0.08438,0.000525,0.0655}, /*cmx*/
          {-4.240693,-5.9426,-1.3805,-2.4316}, /*cfx*/
          {-0.1093,-0.00046,4.43,0.04212,0.000461,0.0455}, /*cmy*/
          {-2.246373,-2.3839,-4.4472,-0.2638}, /*cfy*/
          {-0.1651,-0.00018,8.5261,0.10728,0.000497,0.0612}, /*cmz*/
          {-2.776141,-4.4333,-6.1894,-0.9973} /*cfz*/
     },
     {
          2452579.5,
          {0.0472,0.00091,8.2654,0.09338,0.000488,0.0609}, /*cmx*/
          {-6.03992,-1.5359,-3.2034,-5.9955}, /*cfx*/
          {-0.1207,-8e-05,5.9268,0.04568,0.000442,0.0518}, /*cmy*/
          {-3.769629,-4.8131,-0.6514,-3.53}, /*cfy*/
          {-0.1754,0.0011,8.4588,0.10616,0.000545,0.0635}, /*cmz*/
          {-4.729026,-6.2357,-1.8665,-4.5926} /*cfz*/
     },
     {
          2452629.5,
          {0.0919,0.00081,7.5005,0.1077,0.00041,0.0555}, /*cmx*/
          {-1.679196,-3.357,-5.1397,-3.3517}, /*cfx*/
          {-0.1357,0.0005,6.3135,0.04622,0.000473,0.0488}, /*cmy*/
          {-5.40282,-0.9052,-3.1705,-0.5286}, /*cfy*/
          {-0.1298,-0.00036,8.9618,0.09991,0.000555,0.0667}, /*cmz*/
          {-0.34959,-1.8103,-3.7921,-1.8872} /*cfz*/
     },
     {
          2452679.5,
          {0.1493,0.0006,7.8205,0.11,0.000508,0.0601}, /*cmx*/
          {-3.710374,-5.1316,-0.9514,-0.7676}, /*cfx*/
          {-0.1049,0.00131,5.2946,0.04168,0.00044,0.033}, /*cmy*/
          {-0.700805,-3.4918,-5.4153,-3.6893}, /*cfy*/
          {-0.1432,0.00101,9.3536,0.09106,0.000536,0.0694}, /*cmz*/
          {-2.18255,-3.7291,-5.5118,-5.4642} /*cfz*/
     },
     {
          2452729.5,
          {0.1683,0.00087,8.9299,0.09054,0.000544,0.0681}, /*cmx*/
          {-5.625378,-0.7252,-2.8854,-4.2602}, /*cfx*/
          {-0.0378,0.00155,3.3823,0.04796,0.000325,0.0203}, /*cmy*/
          {-1.919239,-5.9078,-1.7501,-6.2507}, /*cfy*/
          {-0.0887,0.00025,9.1898,0.09341,0.00051,0.071}, /*cmz*/
          {-3.989178,-5.6264,-1.202,-2.7282} /*cfz*/
     },
     {
          2452779.5,
          {0.2126,-0.00097,9.3822,0.07248,0.000413,0.07}, /*cmx*/
          {-1.093608,-2.7354,-5.3,-1.3005}, /*cfx*/
          {0.0345,0.00078,3.2035,0.03724,0.000273,0.0263}, /*cmy*/
          {-2.606984,-1.7544,-4.6575,-2.4978}, /*cfy*/
          {-0.0929,0.00048,8.8222,0.0966,0.000563,0.0731}, /*cmz*/
          {-5.807665,-1.2188,-4.0723,-6.1836} /*cfz*/
     },
     {
          2452829.5,
          {0.1806,-0.0006,9.0641,0.03681,0.00077,0.0699}, /*cmx*/
          {-2.719646,-4.4752,-1.3439,-4.523}, /*cfx*/
          {0.0758,0.00035,4.1855,0.01104,0.000308,0.0324}, /*cmy*/
          {-3.742826,-2.8163,-0.2929,-5.5615}, /*cfy*/
          {-0.0563,-0.00137,8.736,0.04193,0.000941,0.0765}, /*cmz*/
          {-1.253526,-2.8286,-6.0331,-3.1264} /*cfz*/
     },
     {
          2452879.5,
          {0.1288,-0.00185,9.1071,0.04109,0.000784,0.0743}, /*cmx*/
          {-4.045524,-2.5584,-5.6637,-1.1818}, /*cfx*/
          {0.0879,-4e-05,3.812,0.02026,0.000437,0.0285}, /*cmy*/
          {-5.014685,-1.5582,-5.1808,-2.4067}, /*cfy*/
          {-0.1631,-0.00046,8.867,0.05458,0.001048,0.0727}, /*cmz*/
          {-2.564558,-0.9769,-4.1757,-6.0943} /*cfz*/
     },
     {
          2452929.5,
          {0.0387,0.0004,9.1619,0.04453,0.000547,0.0669}, /*cmx*/
          {-5.361665,-0.6593,-1.4912,-4.4919}, /*cfx*/
          {0.086,0.00079,3.9219,0.0282,0.000295,0.0313}, /*cmy*/
          {-0.183417,-0.4093,-1.8232,-5.4776}, /*cfy*/
          {-0.1635,-0.00019,8.6586,0.0594,0.000674,0.0746}, /*cmz*/
          {-3.870688,-5.3674,-0.117,-3.1619} /*cfz*/
     },
     {
          2452979.5,
          {0.0451,-0.00039,8.6813,0.08917,0.000556,0.0589}, /*cmx*/
          {-0.768256,-2.4948,-3.9757,-1.7559}, /*cfx*/
          {0.1136,-0.00014,5.3377,0.0469,0.000451,0.0401}, /*cmy*/
          {-1.705082,-2.6042,-4.3892,-2.6559}, /*cfy*/
          {-0.1815,0.00026,8.4717,0.11425,0.000635,0.0651}, /*cmz*/
          {-5.666123,-0.9652,-2.7975,-0.4969} /*cfz*/
     },
     {
          2453029.5,
          {0.0362,0.00131,7.8675,0.10826,0.000611,0.0557}, /*cmx*/
          {-2.67306,-4.3844,-5.9293,-5.6798}, /*cfx*/
          {0.1286,-0.00012,6.2401,0.0597,0.00048,0.0401}, /*cmy*/
          {-3.414161,-4.9183,-0.663,-6.2044}, /*cfy*/
          {-0.1828,0.00083,8.7233,0.12081,0.00068,0.0629}, /*cmz*/
          {-1.361978,-2.891,-4.8335,-4.3121} /*cfz*/
     },
     {
          2453079.5,
          {0.1028,0.00101,7.5485,0.12208,0.000789,0.0647}, /*cmx*/
          {-4.742742,-6.2345,-1.7617,-3.2819}, /*cfx*/
          {0.1013,-0.00045,5.878,0.05662,0.000561,0.0357}, /*cmy*/
          {-5.178335,-0.9504,-3.1929,-3.4574}, /*cfy*/
          {-0.1243,-0.00059,9.1802,0.11642,0.00073,0.0658}, /*cmz*/
          {-3.327833,-4.84,-0.5158,-1.81} /*cfz*/
     },
     {
          2453129.5,
          {0.1435,0.00038,8.3416,0.12483,0.000878,0.0719}, /*cmx*/
          {-0.531337,-1.9043,-4.0574,-0.6792}, /*cfx*/
          {0.0839,-0.00172,4.2171,0.04787,0.000514,0.023}, /*cmy*/
          {-0.512436,-3.5698,-5.732,-0.3144}, /*cfy*/
          {-0.1614,0.00135,9.3911,0.11297,0.00068,0.0674}, /*cmz*/
          {-5.238543,-0.5574,-2.5155,-5.4493} /*cfz*/
     },
     {
          2453179.5,
          {0.1742,0.00072,9.2589,0.10583,0.000675,0.0718}, /*cmx*/
          {-2.462403,-3.974,-6.1226,-4.284}, /*cfx*/
          {0.0041,-0.0013,2.6224,0.04524,0.000456,0.0254}, /*cmy*/
          {-1.496698,-6.1683,-2.0117,-2.8978}, /*cfy*/
          {-0.1035,0.00023,9.1738,0.10988,0.00057,0.0642}, /*cmz*/
          {-0.855866,-2.5517,-4.3757,-2.7973} /*cfz*/
     },
     {
          2453229.5,
          {0.2067,-0.00083,9.2776,0.09019,0.000522,0.065}, /*cmx*/
          {-4.28952,-5.9767,-1.5109,-1.6567}, /*cfx*/
          {-0.0788,-0.00068,3.8775,0.04307,0.000473,0.0411}, /*cmy*/
          {-2.375242,-2.348,-4.3915,-5.9615}, /*cfy*/
          {-0.0759,0.0008,8.6732,0.1081,0.000537,0.064}, /*cmz*/
          {-2.78893,-4.4626,-6.1408,-0.2233} /*cfz*/
     },
     {
          2453279.5,
          {0.1596,0.00051,8.5347,0.09344,0.000525,0.0584}, /*cmx*/
          {-6.10248,-1.586,-3.2028,-5.2626}, /*cfx*/
          {-0.0975,-0.00061,5.5726,0.04826,0.000474,0.0494}, /*cmy*/
          {-3.875606,-4.7926,-0.5619,-2.9478}, /*cfy*/
          {-0.0382,0.00137,8.4277,0.1097,0.000629,0.0672}, /*cmz*/
          {-4.754842,-6.2813,-1.7923,-3.8632} /*cfz*/
     },
     {
          2453329.5,
          {0.1829,-0.00058,7.6858,0.10997,0.000516,0.0532}, /*cmx*/
          {-1.73241,-3.4355,-5.0688,-2.6369}, /*cfx*/
          {-0.1381,0.00049,6.265,0.05331,0.000522,0.0488}, /*cmy*/
          {-5.537231,-0.8821,-3.1652,-6.2688}, /*cfy*/
          {0.021,0.00024,8.7989,0.11152,0.000692,0.0687}, /*cmz*/
          {-0.419039,-1.8687,-3.8668,-1.1702} /*cfz*/
     },
     {
          2453379.5,
          {0.1739,0.00027,7.7404,0.1233,0.000628,0.0564}, /*cmx*/
          {-3.799777,-5.265,-0.9753,-0.1281}, /*cfx*/
          {-0.113,0.00067,5.5089,0.04731,0.000583,0.0339}, /*cmy*/
          {-0.906257,-3.4534,-5.5289,-3.1708}, /*cfy*/
          {0.0374,0.00133,9.3081,0.10506,0.000682,0.0677}, /*cmz*/
          {-2.310918,-3.835,-5.704,-4.8173} /*cfz*/
     },
     {
          2453429.5,
          {0.1687,0.0002,8.8711,0.10801,0.000744,0.068}, /*cmx*/
          {-5.814161,-0.9151,-2.9739,-3.7487}, /*cfx*/
          {-0.0744,0.00091,3.4495,0.05558,0.000515,0.0207}, /*cmy*/
          {-2.202862,-6.1152,-1.8831,-5.6281}, /*cfy*/
          {0.1106,3e-05,9.2462,0.10767,0.000736,0.0664}, /*cmz*/
          {-4.181797,-5.8159,-1.2521,-2.2291} /*cfz*/
     },
     {
          2453479.5,
          {0.1848,-0.00119,9.3448,0.09226,0.000667,0.0671}, /*cmx*/
          {-1.38343,-3.0005,-4.8237,-0.9494}, /*cfx*/
          {-0.0367,0.00018,3.5188,0.05174,0.000562,0.0325}, /*cmy*/
          {-2.819831,-2.2242,-4.5125,-2.0015}, /*cfy*/
          {0.0978,0.00134,8.686,0.12352,0.000705,0.0667}, /*cmz*/
          {-6.110233,-1.4939,-3.4393,-5.8959} /*cfz*/
     },
     {
          2453529.5,
          {0.1333,-0.00016,8.6152,0.09829,0.000483,0.0613}, /*cmx*/
          {-3.202807,-5.0236,-0.6393,-4.4172}, /*cfx*/
          {-0.0158,0.00064,5.4708,0.04257,0.000411,0.0423}, /*cmy*/
          {-4.129541,-4.8895,-0.7423,-5.1946}, /*cfy*/
          {0.1726,0.00022,8.5103,0.12247,0.000584,0.0678}, /*cmz*/
          {-1.833022,-3.435,-5.7613,-3.2263} /*cfz*/
     },
     {
          2453579.5,
          {0.099,-0.00059,7.6363,0.09746,0.000556,0.0543}, /*cmx*/
          {-5.093656,-0.6052,-3.5203,-1.7373}, /*cfx*/
          {-0.0035,0.00022,6.2649,0.03683,0.000259,0.0436}, /*cmy*/
          {-5.730314,-1.0833,-3.746,-2.2217}, /*cfy*/
          {0.1956,0.00018,8.9515,0.09531,0.000585,0.0632}, /*cmz*/
          {-3.769925,-5.3255,-1.9061,-0.4816} /*cfz*/
     },
     {
          2453629.5,
          {0.0866,0.00146,7.3652,0.03275,0.001032,0.0545}, /*cmx*/
          {-0.607966,-2.1643,-5.306,-4.9275}, /*cfx*/
          {0.014,0.00129,6.0217,0.01411,0.000309,0.0453}, /*cmy*/
          {-0.978245,-2.8889,-6.277,-5.4958}, /*cfy*/
          {0.2069,-0.00125,9.2016,0.03053,0.000876,0.0749}, /*cmz*/
          {-5.469508,-0.6189,-3.7392,-3.651} /*cfz*/
     },
     {
          2453679.5,
          {0.1614,0.00031,7.4117,0.06615,0.001048,0.0543}, /*cmx*/
          {-1.819239,-0.2353,-3.3602,-1.7722}, /*cfx*/
          {0.0827,0.00072,6.21,0.01644,0.000382,0.0484}, /*cmy*/
          {-2.310885,-1.3002,-4.1812,-2.3017}, /*cfy*/
          {0.1406,-0.00193,9.0765,0.05599,0.000967,0.0681}, /*cmz*/
          {-0.446668,-4.9457,-1.8604,-0.302} /*cfz*/
     },
     {
          2453729.5,
          {0.161,0.00036,7.4688,0.04785,0.000585,0.0538}, /*cmx*/
          {-3.0498,-4.5835,-5.2784,-4.9831}, /*cfx*/
          {0.1195,0.00031,6.3767,0.02956,0.000269,0.0439}, /*cmy*/
          {-3.670378,-5.254,-0.2559,-5.4307}, /*cfy*/
          {0.0369,-0.0002,8.901,0.05129,0.000474,0.0601}, /*cmz*/
          {-1.727928,-3.1709,-3.9171,-3.6345} /*cfz*/
     },
     {
          2453779.5,
          {0.1941,-0.00032,7.4938,0.09887,0.000618,0.0611}, /*cmx*/
          {-4.860396,-0.04,-1.5897,-2.5499}, /*cfx*/
          {0.1221,-0.00044,5.9232,0.0458,0.000408,0.039}, /*cmy*/
          {-5.27574,-1.0461,-3.0913,-2.6424}, /*cfy*/
          {0.0542,-0.00043,9.2179,0.09147,0.000504,0.0676}, /*cmz*/
          {-3.446267,-4.9592,-0.2695,-0.9212} /*cfz*/
     },
     {
          2453829.5,
          {0.1622,0.00065,8.2099,0.117,0.000805,0.0716}, /*cmx*/
          {-0.56071,-1.9164,-3.9814,-6.2271}, /*cfx*/
          {0.1061,-0.00112,4.4576,0.04446,0.000467,0.026}, /*cmy*/
          {-0.583357,-3.4749,-5.5776,-5.8501}, /*cfy*/
          {0.0254,0.00121,9.3744,0.10132,0.000627,0.0671}, /*cmz*/
          {-5.282201,-0.5667,-2.3139,-4.5294} /*cfz*/
     },
     {
          2453879.5,
          {0.2033,-2e-05,9.1716,0.10853,0.000697,0.075}, /*cmx*/
          {-2.477724,-3.9636,-6.134,-3.5143}, /*cfx*/
          {0.0553,-0.00072,2.7103,0.04368,0.00045,0.0226}, /*cmy*/
          {-1.711074,-6.031,-1.8846,-2.2973}, /*cfy*/
          {0.0778,-0.00038,9.1976,0.10777,0.000629,0.0635}, /*cmz*/
          {-0.869029,-2.518,-4.316,-1.8891} /*cfz*/
     },
     {
          2453929.5,
          {0.2044,-0.00075,9.3713,0.09411,0.000501,0.068}, /*cmx*/
          {-4.315542,-6.0002,-1.6039,-0.8156}, /*cfx*/
          {-0.0007,-0.00039,3.4661,0.04191,0.000463,0.0341}, /*cmy*/
          {-2.488755,-2.2725,-4.314,-5.2579}, /*cfy*/
          {0.0715,0.00117,8.7672,0.10964,0.000583,0.0627}, /*cmz*/
          {-2.788307,-4.455,-6.168,-5.681} /*cfz*/
     },
     {
          2453979.5,
          {0.159,8e-05,8.7384,0.09254,0.000509,0.06}, /*cmx*/
          {-6.139337,-1.623,-3.176,-4.4216}, /*cfx*/
          {-0.0012,-0.0007,5.2398,0.04748,0.000467,0.0445}, /*cmy*/
          {-3.939274,-4.7632,-0.4327,-2.2602}, /*cfy*/
          {0.1271,0.00063,8.4643,0.11156,0.000676,0.0686}, /*cmz*/
          {-4.754671,-0.0192,-1.7652,-3.1472} /*cfz*/
     },
     {
          2454029.5,
          {0.1621,-0.00177,7.8519,0.10746,0.000604,0.0539}, /*cmx*/
          {-1.758452,-3.4597,-5.0015,-1.8198}, /*cfx*/
          {-0.0464,0.00053,6.1503,0.0564,0.000514,0.0463}, /*cmy*/
          {-5.614718,-0.8363,-3.0313,-5.6143}, /*cfy*/
          {0.1498,0.00057,8.6915,0.11836,0.00078,0.0733}, /*cmz*/
          {-0.441369,-1.8972,-3.8861,-0.4772} /*cfz*/
     },
     {
          2454079.5,
          {0.0903,-0.00039,7.6726,0.12884,0.000719,0.0546}, /*cmx*/
          {-3.822595,-5.3229,-0.9478,-5.6135}, /*cfx*/
          {-0.023,-0.00046,5.7108,0.05277,0.000644,0.0359}, /*cmy*/
          {-1.039932,-3.3163,-5.5208,-2.5808}, /*cfy*/
          {0.1834,0.00075,9.2339,0.11613,0.000759,0.0714}, /*cmz*/
          {-2.373413,-3.8889,-5.8655,-4.0862} /*cfz*/
     },
     {
          2454129.5,
          {0.0451,-0.00092,8.7024,0.12094,0.000834,0.066}, /*cmx*/
          {-5.899356,-1.0096,-3.0948,-3.1098}, /*cfx*/
          {-0.0351,-0.00053,3.6876,0.0562,0.000596,0.022}, /*cmy*/
          {-2.493061,-6.1056,-1.8699,-5.1145}, /*cfy*/
          {0.2315,-0.00082,9.3519,0.11503,0.000788,0.0647}, /*cmz*/
          {-4.282869,-5.9133,-1.4072,-1.5447} /*cfz*/
     },
     {
          2454179.5,
          {0.0099,-0.0009,9.3488,0.10005,0.000784,0.071}, /*cmx*/
          {-1.532002,-3.0986,-4.952,-0.3852}, /*cfx*/
          {-0.0774,-0.00091,3.1838,0.0568,0.000659,0.0344}, /*cmy*/
          {-3.104427,-2.3359,-4.5947,-1.4121}, /*cfy*/
          {0.1708,0.00052,8.8167,0.12815,0.000796,0.0628}, /*cmz*/
          {-6.237955,-1.6364,-3.4889,-5.3116} /*cfz*/
     },
     {
          2454229.5,
          {-0.0285,-0.00027,8.7178,0.10536,0.000674,0.0649}, /*cmx*/
          {-3.385635,-5.1577,-0.6177,-3.9139}, /*cfx*/
          {-0.1096,8e-05,5.3204,0.05101,0.000576,0.0452}, /*cmy*/
          {-4.36185,-5.0405,-0.8663,-4.6716}, /*cfy*/
          {0.2038,-0.00117,8.4472,0.13407,0.000716,0.0637}, /*cmz*/
          {-2.00223,-3.6099,-5.706,-2.7145} /*cfz*/
     },
     {
          2454279.5,
          {-0.0522,-0.00159,7.6505,0.11787,0.000516,0.0543}, /*cmx*/
          {-5.345977,-0.8069,-2.746,-1.4025}, /*cfx*/
          {-0.1275,4e-05,6.321,0.05241,0.000493,0.045}, /*cmy*/
          {-6.019732,-1.3249,-3.6141,-1.7643}, /*cfy*/
          {0.1555,-4e-05,8.8758,0.11746,0.000607,0.0674}, /*cmz*/
          {-4.038707,-5.5627,-1.4639,-0.083} /*cfz*/
     },
     {
          2454329.5,
          {-0.1356,-0.00024,7.5684,0.1105,0.00055,0.0592}, /*cmx*/
          {-1.133191,-2.6173,-5.1348,-5.2776}, /*cfx*/
          {-0.1043,0.00103,5.6699,0.03908,0.000335,0.0361}, /*cmy*/
          {-1.38297,-3.8844,-6.1203,-5.0576}, /*cfy*/
          {0.1328,7e-05,9.3535,0.09337,0.000456,0.0664}, /*cmz*/
          {-5.938932,-1.2358,-3.6024,-3.6284} /*cfz*/
     },
     {
          2454379.5,
          {-0.137,-2e-05,8.4531,0.07308,0.000886,0.0666}, /*cmx*/
          {-3.010419,-4.4126,-1.2541,-2.3491}, /*cfx*/
          {-0.0584,0.00084,4.1739,0.03003,0.000343,0.0277}, /*cmy*/
          {-2.794519,-6.2606,-3.343,-2.0165}, /*cfy*/
          {0.1388,0.0002,9.3311,0.06516,0.00072,0.0776}, /*cmz*/
          {-1.399312,-3.0558,-6.1639,-0.6199} /*cfz*/
     },
     {
          2454429.5,
          {-0.1734,0.00255,8.8072,0.04276,0.000151,0.0824}, /*cmx*/
          {-4.510193,-2.5721,-2.4166,-5.6536}, /*cfx*/
          {-0.0086,0.00011,3.4538,0.02829,0.000189,0.0292}, /*cmy*/
          {-4.106833,-5.0685,-3.0905,-4.7957}, /*cfy*/
          {0.1435,0.00175,9.2755,0.03982,0.000181,0.0653}, /*cmz*/
          {-2.886524,-1.4668,-0.0058,-3.6746} /*cfz*/
     },
     {
          2454479.5,
          {0.0221,0.00089,8.1902,0.02377,0.001016,0.0647}, /*cmx*/
          {-5.561374,-3.7931,-0.7045,-2.1391}, /*cfx*/
          {-0.0045,0.00065,4.5301,0.0126,0.000391,0.0338}, /*cmy*/
          {-5.597653,-5.8944,-2.4191,-1.8947}, /*cfy*/
          {0.2266,-0.00038,9.3961,0.01585,0.000834,0.067}, /*cmz*/
          {-3.997832,-2.4479,-5.6027,-0.3825} /*cfz*/
     },
     {
          2454529.5,
          {0.0243,0.00094,8.3687,0.07532,0.000505,0.0675}, /*cmx*/
          {-0.756372,-2.0628,-3.5567,-5.5258}, /*cfx*/
          {0.0326,0.00037,4.1885,0.02737,0.000292,0.0264}, /*cmy*/
          {-0.686751,-3.6712,-5.3255,-5.146}, /*cfy*/
          {0.2002,0.00034,9.3584,0.06202,0.000523,0.0751}, /*cmz*/
          {-5.460905,-0.703,-1.7429,-3.7552} /*cfz*/
     },
     {
          2454579.5,
          {0.0792,-0.00066,9.1083,0.09633,0.00059,0.0708}, /*cmx*/
          {-2.535657,-3.9846,-6.0057,-2.7451}, /*cfx*/
          {0.0564,0.00043,2.8587,0.03844,0.000383,0.0202}, /*cmy*/
          {-1.83745,-5.9996,-1.7625,-1.6284}, /*cfy*/
          {0.2058,-0.00069,9.1623,0.09505,0.00063,0.0696}, /*cmz*/
          {-0.921913,-2.5148,-4.1747,-1.0216} /*cfz*/
     },
     {
          2454629.5,
          {0.0527,2e-05,9.4099,0.09214,0.000483,0.0694}, /*cmx*/
          {-4.340263,-6.0015,-1.5851,-0.0009}, /*cfx*/
          {0.0625,0.00021,3.2638,0.03956,0.000431,0.0291}, /*cmy*/
          {-2.617762,-2.1819,-4.2281,-4.4224}, /*cfy*/
          {0.179,0.0007,8.791,0.1089,0.000605,0.0623}, /*cmz*/
          {-2.790457,-4.4447,-6.214,-4.7541} /*cfz*/
     },
     {
          2454679.5,
          {0.044,-0.00023,8.883,0.09038,0.000483,0.065}, /*cmx*/
          {-6.155534,-1.6446,-3.124,-3.596}, /*cfx*/
          {0.092,-0.00027,5.0125,0.04406,0.000442,0.0402}, /*cmy*/
          {-3.991859,-4.7098,-0.2738,-1.4306}, /*cfy*/
          {0.2152,-0.0006,8.4944,0.11302,0.000663,0.0634}, /*cmz*/
          {-4.742451,-0.0354,-1.7909,-2.3468} /*cfz*/
     },
     {
          2454729.5,
          {0.033,-0.00174,7.9566,0.10329,0.000663,0.0579}, /*cmx*/
          {-1.761584,-3.4581,-4.9258,-0.9806}, /*cfx*/
          {0.0673,0.00058,6.0752,0.05518,0.000489,0.0444}, /*cmy*/
          {-5.656485,-0.7744,-2.7982,-4.8055}, /*cfy*/
          {0.175,0.00051,8.637,0.12047,0.000796,0.0706}, /*cmz*/
          {-0.439808,-1.9128,-3.86,-6.0575} /*cfz*/
     },
     {
          2454779.5,
          {-0.0408,-0.00067,7.5778,0.13064,0.000822,0.0569}, /*cmx*/
          {-3.811004,-5.3229,-0.8926,-4.7334}, /*cfx*/
          {0.0914,-0.00125,5.8975,0.05725,0.000664,0.0375}, /*cmy*/
          {-1.108005,-3.165,-5.3998,-1.86}, /*cfy*/
          {0.2052,-0.00048,9.1582,0.1228,0.000805,0.0724}, /*cmz*/
          {-2.395841,-3.9076,-5.9192,-3.3795} /*cfz*/
     },
     {
          2454829.5,
          {-0.0998,-0.00159,8.4918,0.13263,0.000928,0.0628}, /*cmx*/
          {-5.926637,-1.043,-3.1621,-2.3374}, /*cfx*/
          {0.0476,-0.0013,4.0542,0.05655,0.000661,0.0254}, /*cmy*/
          {-2.693485,-5.9627,-1.7701,-4.5864}, /*cfy*/
          {0.1959,-0.00116,9.417,0.12115,0.000804,0.0652}, /*cmz*/
          {-4.333805,-5.9577,-1.5123,-0.7819} /*cfz*/
     },
     {
          2454879.5,
          {-0.1671,-7e-05,9.3371,0.10859,0.000848,0.0716}, /*cmx*/
          {-1.616551,-3.1511,-5.0738,-6.0581}, /*cfx*/
          {-0.0447,-0.00141,2.792,0.05906,0.000707,0.0363}, /*cmy*/
          {-3.398698,-2.3192,-4.5702,-0.8709}, /*cfy*/
          {0.1128,-0.00033,8.9984,0.1292,0.000818,0.0603}, /*cmz*/
          {-0.023223,-1.7143,-3.5176,-4.5655} /*cfz*/
     },
     {
          2454929.5,
          {-0.1653,0.00014,8.8888,0.10841,0.000766,0.0679}, /*cmx*/
          {-3.496878,-5.2243,-0.7302,-3.3516}, /*cfx*/
          {-0.0983,-0.00032,4.8981,0.0547,0.000662,0.0476}, /*cmy*/
          {-4.52207,-5.0422,-0.8838,-4.1158}, /*cfy*/
          {0.1062,-0.00235,8.4907,0.13645,0.000779,0.0604}, /*cmz*/
          {-2.0787,-3.7048,-5.687,-2.0365} /*cfz*/
     },
     {
          2454979.5,
          {-0.1643,-0.00033,7.8589,0.12267,0.000622,0.0579}, /*cmx*/
          {-5.452535,-0.9235,-2.7803,-0.7693}, /*cfx*/
          {-0.1355,-9e-05,6.2027,0.05984,0.000586,0.0498}, /*cmy*/
          {-6.189897,-1.3741,-3.6594,-1.1927}, /*cfy*/
          {-0.002,-0.00026,8.7502,0.12669,0.000709,0.0642}, /*cmz*/
          {-4.151091,-5.6734,-1.4906,-5.7447} /*cfz*/
     },
     {
          2455029.5,
          {-0.1886,0.00037,7.5971,0.12518,0.000611,0.0564}, /*cmx*/
          {-1.275263,-2.7972,-4.9617,-4.6837}, /*cfx*/
          {-0.1188,0.00076,5.7571,0.04779,0.00054,0.038}, /*cmy*/
          {-1.61073,-3.9356,-6.1588,-4.5586}, /*cfy*/
          {-0.035,-0.00075,9.2925,0.10595,0.00059,0.0674}, /*cmz*/
          {-6.114489,-1.3728,-3.3897,-3.0876} /*cfz*/
     },
     {
          2455079.5,
          {-0.1579,-0.00079,8.5705,0.10136,0.0006,0.0656}, /*cmx*/
          {-3.290769,-4.6751,-0.8617,-2.0341}, /*cfx*/
          {-0.0953,0.00093,3.953,0.04344,0.000299,0.0255}, /*cmy*/
          {-3.044935,-0.3471,-2.4557,-1.1819}, /*cfy*/
          {-0.0599,-0.00048,9.3174,0.0901,0.00045,0.0698}, /*cmz*/
          {-1.681179,-3.3186,-5.3849,-0.3231} /*cfz*/
     },
     {
          2455129.5,
          {-0.2095,0.00036,9.3218,0.06595,0.000532,0.0698}, /*cmx*/
          {-5.058657,-0.3498,-3.3611,-5.3338}, /*cfx*/
          {-0.0474,0.00061,2.9149,0.03488,0.000266,0.0215}, /*cmy*/
          {-3.904715,-2.4927,-5.6309,-3.8277}, /*cfy*/
          {-0.0732,0.00062,8.9846,0.07823,0.000613,0.0749}, /*cmz*/
          {-3.44683,-5.1389,-1.829,-3.6641} /*cfz*/
     },
     {
          2455179.5,
          {-0.1894,-0.00028,9.3407,0.00542,0.000642,0.0737}, /*cmx*/
          {-0.31606,-1.547,-4.9324,-2.1783}, /*cfx*/
          {-0.0169,0.00033,3.2777,0.011,0.000413,0.0281}, /*cmy*/
          {-4.902426,-2.6048,-0.6246,-0.389}, /*cfy*/
          {-0.0588,0.00179,8.7918,0.01139,0.000857,0.0747}, /*cmz*/
          {-5.044562,-6.1987,-3.4278,-0.4844} /*cfz*/
     },
     {
          2455229.5,
          {-0.2089,0.00129,9.3701,0.05435,0.000898,0.0704}, /*cmx*/
          {-1.506514,-6.0759,-2.9536,-4.9839}, /*cfx*/
          {-0.0046,0.00046,2.5576,0.03553,0.000477,0.0206}, /*cmy*/
          {-0.144598,-1.9374,-5.2223,-3.8566}, /*cfy*/
          {0.0703,0.00167,9.0604,0.06417,0.001037,0.0738}, /*cmz*/
          {-6.204241,-4.6416,-1.4969,-3.392} /*cfz*/
     },
     {
          2455279.5,
          {-0.1332,-0.00043,9.2674,0.04205,0.000417,0.0681}, /*cmx*/
          {-2.778923,-4.1957,-5.0331,-1.9659}, /*cfx*/
          {0.018,0.00109,2.6555,0.01464,0.000215,0.0178}, /*cmy*/
          {-1.714213,-0.1878,-1.1474,-0.6808}, /*cfy*/
          {0.1381,0.0001,9.0339,0.04151,0.000624,0.0761}, /*cmz*/
          {-1.174698,-2.6126,-3.5506,-0.3551} /*cfz*/
     },
     {
          2455329.5,
          {-0.1454,0.00085,9.3854,0.07675,0.000437,0.0661}, /*cmx*/
          {-4.41448,-6.0179,-1.3508,-5.4232}, /*cfx*/
          {0.0632,0.00083,3.2958,0.03328,0.000336,0.0283}, /*cmy*/
          {-2.730832,-2.2319,-4.1463,-3.5525}, /*cfy*/
          {0.1528,-0.0001,8.7541,0.09357,0.000532,0.066}, /*cmz*/
          {-2.855543,-4.4881,-6.1102,-3.8991} /*cfz*/
     },
     {
          2455379.5,
          {-0.112,-0.00031,8.9794,0.08519,0.000473,0.0649}, /*cmx*/
          {-6.174236,-1.6486,-3.0851,-2.774}, /*cfx*/
          {0.1168,0.00044,4.8857,0.03963,0.000407,0.0397}, /*cmy*/
          {-4.065775,-4.6487,-0.1342,-0.5516}, /*cfy*/
          {0.1559,-0.00125,8.4866,0.10982,0.000582,0.06}, /*cmz*/
          {-4.742574,-0.0686,-1.8065,-1.4144} /*cfz*/
     },
     {
          2455429.5,
          {-0.1271,-0.00048,8.0556,0.09827,0.000675,0.0618}, /*cmx*/
          {-1.748222,-3.4584,-4.8621,-0.1742}, /*cfx*/
          {0.1298,0.00048,6.063,0.05108,0.000468,0.0477}, /*cmy*/
          {-5.694231,-0.7008,-2.5383,-3.9518}, /*cfy*/
          {0.0768,0.00024,8.5821,0.11822,0.000729,0.0636}, /*cmz*/
          {-0.43172,-1.9312,-3.8025,-5.2253} /*cfz*/
     },
     {
          2455479.5,
          {-0.1389,-0.00043,7.4547,0.1297,0.000889,0.0638}, /*cmx*/
          {-3.773793,-5.3009,-0.828,-3.9118}, /*cfx*/
          {0.1483,-0.00134,6.1106,0.05905,0.000671,0.0434}, /*cmy*/
          {-1.141622,-3.0102,-5.2022,-1.0457}, /*cfy*/
          {0.0958,-0.00159,9.0724,0.12317,0.000817,0.0677}, /*cmz*/
          {-2.399022,-3.8964,-5.8572,-2.5898} /*cfz*/
     },
     {
          2455529.5,
          {-0.1802,-0.00109,8.2215,0.14259,0.001018,0.065}, /*cmx*/
          {-5.915153,-1.0325,-3.1901,-1.4626}, /*cfx*/
          {0.1038,-0.00099,4.5412,0.05787,0.000719,0.0324}, /*cmy*/
          {-2.804295,-5.7602,-1.6112,-4.0403}, /*cfy*/
          {0.0307,-0.00066,9.4296,0.12463,0.000833,0.0653}, /*cmz*/
          {-4.35068,-5.957,-1.534,-6.2417} /*cfz*/
     },
     {
          2451179.5,
          {-0.0009,-0.00018,20.1188,0.21466,0.000909,0.0037}, /*cmx*/
          {4.986918,3.2072,0.7895,-4.6195}, /*cfx*/
          {0.0027,7e-05,15.2226,0.09991,0.000585,0.0012}, /*cmy*/
          {1.063209,5.9688,3.6829,-1.6181}, /*cfy*/
          {0.0044,-0.00016,21.5994,0.23578,0.001232,0.0033}, /*cmz*/
          {0.014739,4.7781,2.2999,-4.5548} /*cfz*/
     },
     {
          2451219.5,
          {-0.006,7e-05,19.0567,0.16821,0.001821,0.005}, /*cmx*/
          {2.693612,0.9801,4.1772,-2.7049}, /*cfx*/
          {0.0054,-7e-05,15.5978,0.0755,0.000652,0.0015}, /*cmy*/
          {5.212472,3.5377,0.4461,-5.6229}, /*cfy*/
          {0.0043,-0.00021,22.2983,0.17185,0.001801,0.0027}, /*cmz*/
          {4.024767,2.4872,5.7132,-3.3659} /*cfz*/
     },
     {
          2451259.5,
          {0.0032,-0.00037,18.7558,0.01202,0.001739,0.0055}, /*cmx*/
          {0.576356,1.6255,2.1656,-4.1273}, /*cfx*/
          {0.0029,4e-05,15.4786,0.01447,0.000547,0.0021}, /*cmy*/
          {3.172958,1.9749,4.6745,-6.172}, /*cfy*/
          {0.0041,-0.00022,22.5249,0.00567,0.001777,0.0073}, /*cmz*/
          {1.933842,0.3419,3.7342,-5.6166} /*cfz*/
     },
     {
          2451299.5,
          {-0.0051,2e-05,19.2084,0.1337,0.002344,0.0017}, /*cmx*/
          {5.106094,0.2458,3.4388,-2.7579}, /*cfx*/
          {0.0044,0.0,15.7492,0.02565,0.000933,0.0013}, /*cmy*/
          {1.279101,2.7698,6.0422,-1.4858}, /*cfy*/
          {0.0042,-0.00016,22.0202,0.1278,0.002445,0.0037}, /*cmz*/
          {0.129393,1.9401,4.9913,-2.9693} /*cfz*/
     },
     {
          2451339.5,
          {0.0001,-0.00026,19.6586,0.0729,0.001822,0.0024}, /*cmx*/
          {3.27474,1.7279,1.1917,-3.4089}, /*cfx*/
          {0.0009,0.00017,15.8839,0.05869,0.000799,0.0034}, /*cmy*/
          {5.621309,4.3246,3.5012,-0.3171}, /*cfy*/
          {0.0029,-8e-05,21.4138,0.08434,0.001811,0.0048}, /*cmz*/
          {4.552559,3.0838,2.7104,-6.2108} /*cfz*/
     },
     {
          2451379.5,
          {-0.0077,0.00011,19.0348,0.21434,0.001673,0.0014}, /*cmx*/
          {1.076119,5.7174,4.6566,-1.3576}, /*cfx*/
          {0.0066,-0.00013,16.1585,0.121,0.001045,0.003}, /*cmy*/
          {3.504248,1.9482,0.2256,-3.7906}, /*cfy*/
          {0.0013,-7e-05,21.7839,0.22417,0.001557,0.0026}, /*cmz*/
          {2.358839,0.9206,5.8569,-3.8518} /*cfz*/
     },
     {
          2451419.5,
          {-0.0037,-8e-05,18.6565,0.30876,0.002119,0.006}, /*cmx*/
          {4.906705,3.3892,1.8254,-5.0966}, /*cfx*/
          {-0.001,0.0002,15.2942,0.1449,0.001637,0.0056}, /*cmy*/
          {1.291671,5.5837,3.4567,-1.1511}, /*cfy*/
          {-0.0056,0.00015,22.769,0.28444,0.002061,0.0028}, /*cmz*/
          {0.007843,4.824,3.1094,-1.3034} /*cfz*/
     },
     {
          2451459.5,
          {-0.0052,7e-05,20.2277,0.3552,0.002708,0.0059}, /*cmx*/
          {2.33286,0.9485,5.2607,-2.8872}, /*cfx*/
          {0.007,-0.00024,11.9718,0.14186,0.001881,0.0038}, /*cmy*/
          {5.40116,2.5504,0.4294,-3.9528}, /*cfy*/
          {-0.0006,-0.00019,23.4508,0.31355,0.002438,0.0017}, /*cmz*/
          {3.885829,2.3253,0.5595,-1.3885} /*cfz*/
     },
     {
          2451499.5,
          {-0.0008,-3e-05,22.7372,0.33008,0.002757,0.004}, /*cmx*/
          {6.097148,4.6555,2.6164,-6.13}, /*cfx*/
          {-0.0034,0.00026,7.4866,0.14668,0.001827,0.0035}, /*cmy*/
          {3.649754,5.6674,3.4818,-0.7141}, /*cfy*/
          {-0.0101,0.00023,23.0107,0.33905,0.002556,0.0039}, /*cmz*/
          {1.438096,6.0572,4.3013,-0.8585} /*cfz*/
     },
     {
          2451539.5,
          {0.0025,-4e-05,23.4016,0.29853,0.00228,0.0025}, /*cmx*/
          {3.667569,2.0256,0.1394,-4.3378}, /*cfx*/
          {0.0069,-0.0002,9.095,0.13556,0.001857,0.0029}, /*cmy*/
          {2.2826,2.5343,0.4405,-4.0107}, /*cfy*/
          {-0.0035,-5e-05,21.7007,0.36105,0.002522,0.0033}, /*cmz*/
          {5.206389,3.5307,1.7179,-4.7358} /*cfz*/
     },
     {
          2451579.5,
          {0.0011,0.00013,21.8969,0.2975,0.001995,0.0018}, /*cmx*/
          {1.255451,5.7679,4.0559,-3.6912}, /*cfx*/
          {0.0007,0.00017,13.5601,0.14603,0.001658,0.0013}, /*cmy*/
          {0.263746,5.6822,3.8033,-6.1158}, /*cfy*/
          {-0.0065,0.0002,20.9263,0.36467,0.002454,0.0049}, /*cmz*/
          {2.62863,1.0439,5.4042,-2.2361} /*cfz*/
     },
     {
          2451619.5,
          {0.0072,-0.0001,19.6378,0.31858,0.002004,0.0015}, /*cmx*/
          {5.059356,3.3239,1.6473,-4.9013}, /*cfx*/
          {0.0093,-0.00025,15.8629,0.16674,0.001543,0.0044}, /*cmy*/
          {4.289204,2.8176,0.7753,-3.9482}, /*cfy*/
          {-0.0029,0.00014,21.5629,0.34684,0.002361,0.0052}, /*cmz*/
          {0.062499,4.8494,2.8541,-0.2744} /*cfz*/
     },
     {
          2451659.5,
          {0.005,0.0,18.6002,0.34247,0.00215,0.001}, /*cmx*/
          {2.470448,0.9138,5.3341,-2.5658}, /*cfx*/
          {0.0,0.00015,15.3764,0.15361,0.001663,0.003}, /*cmy*/
          {1.999357,0.0307,4.0885,-0.8508}, /*cfy*/
          {0.0038,-2e-05,22.8122,0.31909,0.002197,0.0018}, /*cmz*/
          {3.854373,2.3548,0.3853,-4.3085} /*cfz*/
     },
     {
          2451699.5,
          {0.0055,-7e-05,20.0539,0.33464,0.00227,0.0043}, /*cmx*/
          {6.156576,4.7579,2.6895,-5.315}, /*cfx*/
          {0.0071,-0.00024,12.234,0.12436,0.001502,0.0041}, /*cmy*/
          {6.092562,3.3136,1.1842,-4.4506}, /*cfy*/
          {0.0014,0.00021,23.4732,0.29827,0.002021,0.0032}, /*cmz*/
          {1.427667,6.1343,4.2566,-1.9609} /*cfz*/
     },
     {
          2451739.5,
          {0.0061,-0.00018,22.415,0.29158,0.002059,0.0046}, /*cmx*/
          {3.68091,2.2566,0.1739,-3.2351}, /*cfx*/
          {-0.0014,0.00018,8.1222,0.11442,0.001267,0.0031}, /*cmy*/
          {4.245837,0.2626,4.4475,-1.4816}, /*cfy*/
          {0.0066,0.0,23.0948,0.29147,0.001884,0.0024}, /*cmz*/
          {5.307753,3.6558,1.8534,-0.5136} /*cfz*/
     },
     {
          2451779.5,
          {-0.0001,1e-05,23.4728,0.253,0.001672,0.0023}, /*cmx*/
          {1.313218,6.0164,4.0813,-0.3592}, /*cfx*/
          {0.0039,-6e-05,7.9746,0.10386,0.001223,0.0025}, /*cmy*/
          {2.824148,3.6072,1.5417,-5.1891}, /*cfy*/
          {0.0053,5e-05,22.0586,0.29397,0.001757,0.0007}, /*cmz*/
          {2.891792,1.2202,5.7089,-0.0813} /*cfz*/
     },
     {
          2451819.5,
          {0.0,-0.0001,22.8199,0.23866,0.001421,0.0041}, /*cmx*/
          {5.273182,3.5511,1.7961,-4.9419}, /*cfx*/
          {0.0012,0.00012,11.4743,0.10106,0.001158,0.0033}, /*cmy*/
          {1.005526,0.6538,5.0812,-2.1158}, /*cfy*/
          {0.004,6e-05,21.1828,0.29634,0.001641,0.0008}, /*cmz*/
          {0.446819,5.1054,3.2549,-0.9328} /*cfz*/
     },
     {
          2451859.5,
          {-0.0019,-7e-05,21.115,0.2445,0.001317,0.0028}, /*cmx*/
          {2.938446,1.1644,5.7761,-3.2408}, /*cfx*/
          {0.0038,2e-05,14.4322,0.11509,0.001043,0.0029}, /*cmy*/
          {5.179039,4.1211,2.3152,-0.4397}, /*cfy*/
          {0.0062,-0.00012,21.1397,0.28921,0.001555,0.0027}, /*cmz*/
          {4.274189,2.7286,0.8101,-1.849} /*cfz*/
     },
     {
          2451899.5,
          {-0.0044,0.0,19.3323,0.25854,0.00125,0.0024}, /*cmx*/
          {0.546988,5.1108,3.3622,-0.8985}, /*cfx*/
          {0.0032,5e-05,15.7344,0.12427,0.000972,0.0009}, /*cmy*/
          {2.981982,1.4816,5.7401,-3.4426}, /*cfy*/
          {-0.0004,8e-05,21.9144,0.27146,0.001479,0.0034}, /*cmz*/
          {1.849857,0.3563,4.654,-0.7329} /*cfz*/
     },
     {
          2451939.5,
          {-0.002,-0.00013,18.5857,0.26208,0.001176,0.0032}, /*cmx*/
          {4.378613,2.7923,0.7076,-4.8385}, /*cfx*/
          {0.003,2e-05,15.3047,0.11158,0.000869,0.0008}, /*cmy*/
          {0.781521,5.1577,2.9126,-1.131}, /*cfy*/
          {-0.0006,-3e-05,22.8655,0.2466,0.001326,0.0025}, /*cmz*/
          {5.767774,4.2611,2.1387,-4.9524} /*cfz*/
     },
     {
          2451979.5,
          {-0.0084,0.00019,19.3441,0.22928,0.001354,0.0017}, /*cmx*/
          {1.953873,0.4816,4.0594,-3.0481}, /*cfx*/
          {0.0034,-1e-05,13.4758,0.08408,0.00049,0.0021}, /*cmy*/
          {4.924508,2.5145,6.0488,-2.0134}, /*cfy*/
          {-0.0037,3e-05,23.4029,0.21208,0.001216,0.0052}, /*cmz*/
          {3.469414,1.8919,5.5334,-2.1839} /*cfz*/
     },
     {
          2452019.5,
          {-0.0042,-1e-05,20.4987,0.13451,0.002432,0.0019}, /*cmx*/
          {5.966431,4.5257,1.4423,-0.2214}, /*cfx*/
          {0.0009,9e-05,11.4524,0.0505,0.000933,0.0009}, /*cmy*/
          {2.874464,0.333,2.5992,-4.802}, /*cfy*/
          {-0.0071,0.00016,23.4755,0.13426,0.00204,0.0049}, /*cmz*/
          {1.266678,5.9236,2.7817,-0.6033} /*cfz*/
     },
     {
          2452059.5,
          {-0.0206,0.0008,20.5403,0.11094,0.000443,0.0081}, /*cmx*/
          {3.971021,5.8054,2.0668,-1.2892}, /*cfx*/
          {0.0033,0.0,11.2899,0.07151,0.00041,0.0058}, /*cmy*/
          {0.825085,0.2145,2.9529,-2.8464}, /*cfy*/
          {-0.0044,7e-05,23.482,0.06646,0.000275,0.0104}, /*cmz*/
          {5.544776,0.927,3.8588,-2.9256} /*cfz*/
     },
     {
          2452099.5,
          {-0.0043,-4e-05,19.5018,0.02531,0.002826,0.0055}, /*cmx*/
          {2.235452,3.882,0.7199,-3.198}, /*cfx*/
          {0.0058,-0.00013,13.2918,0.03001,0.001158,0.0024}, /*cmy*/
          {5.11455,4.4457,2.2157,-5.8397}, /*cfy*/
          {0.0,-0.00015,23.2633,0.0056,0.002267,0.0012}, /*cmz*/
          {3.724896,4.9974,2.1133,-0.6175} /*cfz*/
     },
     {
          2452139.5,
          {-0.0134,0.0004,19.8855,0.21126,0.001624,0.0078}, /*cmx*/
          {0.152316,5.0739,3.9256,-1.0252}, /*cfx*/
          {0.0028,0.0,12.5254,0.08296,0.001176,0.0036}, /*cmy*/
          {3.112009,0.5828,5.1668,-3.0771}, /*cfy*/
          {-0.0039,0.0,23.3526,0.17877,0.001707,0.0019}, /*cmz*/
          {1.669904,0.1986,5.3815,-2.213} /*cfz*/
     },
     {
          2452179.5,
          {-0.001,-0.00014,21.7775,0.29305,0.002118,0.0033}, /*cmx*/
          {4.062781,2.6772,0.8024,-5.1455}, /*cfx*/
          {0.0043,-0.00011,9.0035,0.12134,0.001501,0.0034}, /*cmy*/
          {1.171965,3.9251,1.9583,-5.5441}, /*cfy*/
          {-0.0053,1e-05,23.341,0.27113,0.002121,0.0018}, /*cmz*/
          {5.668424,4.078,2.5045,-5.34} /*cfz*/
     },
     {
          2452219.5,
          {-0.0063,0.00027,23.3722,0.28741,0.002202,0.0036}, /*cmx*/
          {1.658915,0.1301,4.5017,-1.9101}, /*cfx*/
          {-0.0002,0.00013,7.1156,0.1314,0.001705,0.0027}, /*cmy*/
          {6.049904,0.943,5.106,-2.3119}, /*cfy*/
          {-0.0039,-8e-05,22.4597,0.32298,0.002302,0.0044}, /*cmz*/
          {3.260521,1.588,6.1507,-2.8234} /*cfz*/
     },
     {
          2452259.5,
          {-0.0003,8e-05,23.0105,0.2785,0.001989,0.0026}, /*cmx*/
          {5.561238,3.8597,2.0904,-1.1422}, /*cfx*/
          {0.0041,-2e-05,10.9767,0.12793,0.001735,0.0016}, /*cmy*/
          {4.380638,4.1411,2.1956,-5.8447}, /*cfy*/
          {-0.0096,0.00022,21.2441,0.34986,0.002265,0.0042}, /*cmz*/
          {0.755937,5.386,3.5473,-0.3987} /*cfz*/
     },
     {
          2452299.5,
          {0.0014,8e-05,21.0864,0.29151,0.001902,0.001}, /*cmx*/
          {3.156542,1.3858,6.0016,-0.7732}, /*cfx*/
          {0.0024,0.0001,14.7245,0.14908,0.001566,0.0031}, /*cmy*/
          {2.234985,1.1444,5.5669,-1.956}, /*cfy*/
          {-0.0012,-9e-05,20.9746,0.34881,0.002226,0.0039}, /*cmz*/
          {4.480314,2.9245,0.993,-4.5915} /*cfz*/
     },
     {
          2452339.5,
          {0.0002,0.00021,19.0407,0.31944,0.001929,0.0019}, /*cmx*/
          {0.661347,5.2488,3.5377,-0.709}, /*cfx*/
          {0.0028,6e-05,16.0868,0.16481,0.001575,0.0039}, /*cmy*/
          {6.244811,4.658,2.5366,-5.9293}, /*cfy*/
          {-0.0033,0.00016,21.9213,0.32813,0.002204,0.004}, /*cmz*/
          {1.951191,0.4659,4.7908,-2.3082} /*cfz*/
     },
     {
          2452379.5,
          {0.0082,-0.00015,18.7027,0.3382,0.002058,0.0016}, /*cmx*/
          {4.349579,2.8382,0.9344,-2.8158}, /*cfx*/
          {0.0042,-3e-05,14.8527,0.14541,0.001682,0.0042}, /*cmy*/
          {3.975207,1.8611,5.8981,-2.6115}, /*cfy*/
          {0.0022,2e-05,23.0667,0.30505,0.002126,0.0026}, /*cmz*/
          {5.776444,4.27,2.3473,-0.5221} /*cfz*/
     },
     {
          2452419.5,
          {0.001,0.00016,20.6357,0.32082,0.002172,0.0059}, /*cmx*/
          {1.783915,0.3947,4.6203,-1.3087}, /*cfx*/
          {0.0013,6e-05,11.262,0.12155,0.001477,0.0039}, /*cmy*/
          {1.842308,5.1178,2.9731,-0.1721}, /*cfy*/
          {0.004,4e-05,23.4536,0.29257,0.001989,0.0018}, /*cmz*/
          {3.368257,1.7779,6.2066,-4.4481} /*cfz*/
     },
     {
          2452459.5,
          {0.0032,-4e-05,22.8117,0.27884,0.001995,0.0032}, /*cmx*/
          {5.625335,4.1781,2.1487,-5.5457}, /*cfx*/
          {0.0035,-6e-05,7.6225,0.11415,0.001294,0.0031}, /*cmy*/
          {0.119035,2.0991,6.2379,-3.4127}, /*cfy*/
          {0.0031,0.00014,22.881,0.29159,0.00183,0.001}, /*cmz*/
          {0.969165,5.5867,3.8019,-3.2509} /*cfz*/
     },
     {
          2452499.5,
          {-0.0005,4e-05,23.4456,0.24925,0.001679,0.0034}, /*cmx*/
          {3.273279,1.6646,6.0719,-2.5834}, /*cfx*/
          {0.0008,9e-05,8.6921,0.10447,0.001258,0.0024}, /*cmy*/
          {4.942694,5.4272,3.3808,-0.7368}, /*cfy*/
          {0.0092,-0.00014,21.8128,0.29683,0.001741,0.0009}, /*cmz*/
          {4.828627,3.1566,1.3922,-1.9881} /*cfz*/
     },
     {
          2452539.5,
          {-0.0028,5e-05,22.4635,0.24414,0.001476,0.0047}, /*cmx*/
          {0.947377,5.4874,3.7952,-1.1784}, /*cfx*/
          {0.0062,-0.00011,12.3579,0.10841,0.00119,0.003}, /*cmy*/
          {3.026976,2.4627,0.6472,-4.4493}, /*cfy*/
          {0.0056,0.0,21.0543,0.30169,0.001746,0.0015}, /*cmz*/
          {2.369101,0.7658,5.2355,-1.134} /*cfz*/
     },
     {
          2452579.5,
          {-0.0022,-6e-05,20.5683,0.25811,0.001484,0.0026}, /*cmx*/
          {4.870602,3.1,1.5347,-6.1654}, /*cfx*/
          {0.0018,0.00013,15.0596,0.12778,0.001123,0.0015}, /*cmy*/
          {0.875027,5.9523,4.142,-2.9538}, /*cfy*/
          {0.0036,0.0,21.2308,0.30067,0.00178,0.0022}, /*cmz*/
          {6.181431,4.6647,2.7823,-4.9875} /*cfz*/
     },
     {
          2452619.5,
          {-0.0056,6e-05,18.8438,0.28603,0.001617,0.0028}, /*cmx*/
          {2.422727,0.7535,5.412,-2.8626}, /*cfx*/
          {0.008,-0.00018,15.9115,0.13802,0.00122,0.0019}, /*cmy*/
          {4.930512,3.2937,1.2404,-4.9477}, /*cfy*/
          {0.0041,-0.00014,22.2051,0.29211,0.001817,0.0036}, /*cmz*/
          {3.738901,2.2593,0.3549,-3.1866} /*cfz*/
     },
     {
          2452659.5,
          {-0.0081,0.00016,18.7103,0.31127,0.001807,0.0034}, /*cmx*/
          {6.16983,4.6822,2.8065,-1.0583}, /*cfx*/
          {0.0026,5e-05,14.6304,0.12463,0.001388,0.0005}, /*cmy*/
          {2.709163,0.5583,4.6868,-1.6828}, /*cfy*/
          {-0.0023,2e-05,23.185,0.28053,0.001823,0.003}, /*cmz*/
          {1.337901,6.1039,4.2479,-0.8792} /*cfz*/
     },
     {
          2452699.5,
          {-0.0037,-3e-05,20.6024,0.30325,0.001953,0.0012}, /*cmx*/
          {3.65323,2.2737,0.2013,-0.98}, /*cfx*/
          {0.006,-0.00016,11.2862,0.10885,0.001229,0.0027}, /*cmy*/
          {0.605579,3.8737,1.829,-4.6217}, /*cfy*/
          {-0.0006,-0.00017,23.4522,0.27547,0.001749,0.0038}, /*cmz*/
          {5.245186,3.6455,1.8372,-5.0348} /*cfz*/
     },
     {
          2452739.5,
          {-0.0069,0.00021,22.7585,0.26438,0.001729,0.0026}, /*cmx*/
          {1.241593,6.0741,3.951,-0.4569}, /*cfx*/
          {0.0,0.00011,7.7602,0.10239,0.000965,0.0021}, /*cmy*/
          {5.137226,0.9497,5.0591,-1.5978}, /*cfy*/
          {-0.005,0.0,22.893,0.27666,0.001532,0.0045}, /*cmz*/
          {2.869449,1.2063,5.5763,-2.9026} /*cfz*/
     },
     {
          2452779.5,
          {0.0013,-8e-05,23.506,0.22231,0.001249,0.0024}, /*cmx*/
          {5.205537,3.5755,1.1851,-2.8869}, /*cfx*/
          {0.0041,-7e-05,7.9622,0.07932,0.000711,0.0017}, /*cmy*/
          {3.665931,4.4244,1.8905,-5.0027}, /*cfy*/
          {-0.0067,2e-05,22.084,0.26396,0.001354,0.0034}, /*cmz*/
          {0.490087,5.1009,2.5818,-0.1272} /*cfz*/
     },
     {
          2452819.5,
          {-0.003,0.00017,22.9794,0.15987,0.00189,0.0044}, /*cmx*/
          {2.970287,1.2236,4.3797,-1.5329}, /*cfx*/
          {0.0025,1e-05,10.0554,0.04044,0.000875,0.0025}, /*cmy*/
          {1.863269,1.7746,5.0076,-1.6271}, /*cfy*/
          {-0.0022,-0.00023,21.7857,0.18703,0.002413,0.0043}, /*cmz*/
          {4.456751,2.8276,5.9448,-4.4422} /*cfz*/
     },
     {
          2452859.5,
          {0.0122,-0.00063,22.5838,0.0379,0.000219,0.0082}, /*cmx*/
          {0.904733,2.0105,3.2519,-4.1694}, /*cfx*/
          {0.0068,-0.00024,10.3335,0.04712,0.000573,0.0038}, /*cmy*/
          {6.217745,3.0945,5.1887,-5.368}, /*cfy*/
          {-0.0035,-0.00017,21.9824,0.05169,0.000192,0.0088}, /*cmz*/
          {2.37582,3.8445,4.7875,-5.6893} /*cfz*/
     },
     {
          2452899.5,
          {-0.0005,-1e-05,23.0613,0.01354,0.001996,0.0028}, /*cmx*/
          {5.339246,5.8219,3.5224,-1.0852}, /*cfx*/
          {-0.0005,0.00013,9.0118,0.03193,0.000835,0.0019}, /*cmy*/
          {4.212592,2.8453,4.156,-0.8104}, /*cfy*/
          {-0.0092,0.00014,22.032,0.01384,0.002467,0.0019}, /*cmz*/
          {0.562246,2.3432,5.1069,-0.9989} /*cfz*/
     },
     {
          2452939.5,
          {0.0028,-0.00013,22.8974,0.15448,0.001272,0.0028}, /*cmx*/
          {3.306052,1.671,0.6217,-4.6961}, /*cfx*/
          {0.005,-0.0001,10.6309,0.0853,0.000805,0.0004}, /*cmy*/
          {2.172512,1.8151,0.3357,-4.3798}, /*cfy*/
          {-0.0041,-9e-05,21.467,0.18762,0.001526,0.0066}, /*cmz*/
          {4.780883,3.1497,2.2348,-5.0539} /*cfz*/
     },
     {
          2452979.5,
          {-0.0015,0.00015,21.8093,0.22424,0.001424,0.002}, /*cmx*/
          {1.067104,5.6047,4.1849,-3.9953}, /*cfx*/
          {0.0004,0.00017,13.6528,0.11815,0.001173,0.0013}, /*cmy*/
          {0.082298,5.4955,3.7996,-0.2105}, /*cfy*/
          {-0.0042,-1e-05,20.9133,0.27791,0.001661,0.0046}, /*cmz*/
          {2.436031,0.8613,5.5317,-3.1462} /*cfz*/
     },
     {
          2453019.5,
          {0.0049,-7e-05,19.9866,0.26722,0.001624,0.0013}, /*cmx*/
          {4.986296,3.239,1.7156,-4.1405}, /*cfx*/
          {0.0074,-0.00015,15.7948,0.14574,0.001241,0.0033}, /*cmy*/
          {4.160017,2.8017,0.9394,-3.9181}, /*cfy*/
          {-0.0035,4e-05,21.2553,0.30349,0.001867,0.0029}, /*cmz*/
          {6.267136,4.767,2.9121,-0.2838} /*cfz*/
     },
     {
          2453059.5,
          {0.0055,-3e-05,18.5605,0.30512,0.001832,0.0015}, /*cmx*/
          {2.496735,0.8753,5.4622,-2.504}, /*cfx*/
          {0.0018,0.00011,16.046,0.15111,0.001411,0.0035}, /*cmy*/
          {1.899669,0.1437,4.3024,-1.4734}, /*cfy*/
          {0.0019,-9e-05,22.3535,0.299,0.001922,0.0038}, /*cmz*/
          {3.818812,2.3383,0.4327,-4.6637} /*cfz*/
     },
     {
          2453099.5,
          {0.0042,4e-05,19.034,0.32448,0.002032,0.0038}, /*cmx*/
          {6.212012,4.7661,2.8212,-5.6235}, /*cfx*/
          {0.0074,-0.0002,14.0392,0.12917,0.0015,0.0039}, /*cmy*/
          {5.952488,3.6206,1.4554,-4.8574}, /*cfy*/
          {-0.0008,0.00017,23.2964,0.2874,0.001906,0.0024}, /*cmz*/
          {1.409357,6.1603,4.3003,-3.5799} /*cfz*/
     },
     {
          2453139.5,
          {0.0076,-0.00015,21.2542,0.30509,0.002081,0.0055}, /*cmx*/
          {3.69927,2.3154,0.2514,-3.638}, /*cfx*/
          {0.0,0.00013,10.1315,0.11322,0.001326,0.0026}, /*cmy*/
          {3.898877,0.6007,4.8169,-2.2244}, /*cfy*/
          {0.0054,-4e-05,23.3981,0.28289,0.001873,0.0007}, /*cmz*/
          {5.306185,3.6936,1.9018,-5.0949} /*cfz*/
     },
     {
          2453179.5,
          {0.0022,1e-05,23.1307,0.26683,0.001849,0.0015}, /*cmx*/
          {1.29452,6.0919,4.1111,-1.2216}, /*cfx*/
          {0.0043,-0.0001,7.3425,0.10776,0.001254,0.0029}, /*cmy*/
          {2.308929,3.9196,1.8326,-5.4555}, /*cfy*/
          {0.0069,-4e-05,22.6331,0.2891,0.001826,0.0009}, /*cmz*/
          {2.912596,1.2463,5.7671,-5.2355} /*cfz*/
     },
     {
          2453219.5,
          {0.004,-0.00018,23.3538,0.24503,0.001604,0.0036}, /*cmx*/
          {5.239313,3.5903,1.7898,-5.1921}, /*cfx*/
          {0.0018,7e-05,9.5159,0.10214,0.001283,0.0024}, /*cmy*/
          {0.757252,0.9677,5.2871,-2.8276}, /*cfy*/
          {0.006,2e-05,21.5651,0.29959,0.001779,0.0019}, /*cmz*/
          {0.484586,5.1108,3.3392,-4.8917} /*cfz*/
     },
     {
          2453259.5,
          {0.0015,-0.00012,22.064,0.24837,0.001536,0.0036}, /*cmx*/
          {2.908955,1.1525,5.7951,-3.7859}, /*cfx*/
          {0.0029,5e-05,13.1464,0.11413,0.001271,0.002}, /*cmy*/
          {5.042199,4.3178,2.5328,-0.3469}, /*cfy*/
          {0.0093,-0.00015,20.9979,0.30605,0.001781,0.0028}, /*cmz*/
          {4.299419,2.713,0.913,-3.6059} /*cfz*/
     },
     {
          2453299.5,
          {-0.0029,0.0,20.0529,0.27194,0.001622,0.0012}, /*cmx*/
          {0.525448,5.0515,3.5006,-2.2448}, /*cfx*/
          {0.0048,-1e-05,15.4851,0.13857,0.001272,0.0007}, /*cmy*/
          {2.857674,1.5587,5.9559,-3.6121}, /*cfy*/
          {0.0035,2e-05,21.4121,0.30594,0.001892,0.0012}, /*cmz*/
          {1.820511,0.3179,4.7585,-1.1984} /*cfz*/
     },
     {
          2453339.5,
          {-0.001,-0.00018,18.5585,0.30886,0.001834,0.0035}, /*cmx*/
          {4.314237,2.6875,1.0528,-5.1016}, /*cfx*/
          {0.0021,0.00011,15.8399,0.14838,0.00149,0.0021}, /*cmy*/
          {0.612399,5.1525,2.9967,-0.5104}, /*cfy*/
          {0.0035,-0.00011,22.4903,0.30202,0.002062,0.0046}, /*cmz*/
          {5.652678,4.1772,2.3117,-5.2811} /*cfz*/
     },
     {
          2453379.5,
          {-0.0077,0.00012,19.1384,0.33575,0.002203,0.0019}, /*cmx*/
          {1.730612,0.299,4.69,-3.4763}, /*cfx*/
          {0.0066,-0.00014,13.8003,0.13258,0.001687,0.0028}, /*cmy*/
          {4.676709,2.2749,0.102,-2.9535}, /*cfy*/
          {0.003,-0.00019,23.3525,0.30091,0.002178,0.0043}, /*cmz*/
          {3.234806,1.7002,6.1514,-3.4004} /*cfz*/
     },
     {
          2453419.5,
          {-0.0014,-0.00013,21.6164,0.32144,0.002469,0.003}, /*cmx*/
          {5.480347,4.1047,2.0654,-4.5139}, /*cfx*/
          {-0.0011,0.00017,9.6401,0.12876,0.001532,0.0039}, /*cmy*/
          {2.667757,5.4348,3.3296,-0.2384}, /*cfy*/
          {-0.0043,4e-05,23.2866,0.31003,0.002207,0.0031}, /*cmz*/
          {0.821527,5.4743,3.7049,-0.9951} /*cfz*/
     },
     {
          2453459.5,
          {-0.0019,1e-05,23.3755,0.28662,0.002243,0.0024}, /*cmx*/
          {3.05426,1.5252,5.8506,-2.3478}, /*cfx*/
          {0.0051,-0.00013,7.5603,0.1256,0.001532,0.0032}, /*cmy*/
          {1.208547,2.4125,0.2259,-3.2851}, /*cfy*/
          {-0.0014,-0.00018,22.3167,0.32689,0.002158,0.0046}, /*cmz*/
          {4.655637,2.9798,1.2174,-5.0237} /*cfz*/
     },
     {
          2453499.5,
          {-0.0018,0.00011,22.922,0.27384,0.001824,0.0038}, /*cmx*/
          {0.680885,5.2389,3.4113,-5.4304}, /*cfx*/
          {0.0,0.00016,10.9712,0.11522,0.001432,0.0034}, /*cmy*/
          {5.822663,5.6129,3.6171,-0.4124}, /*cfy*/
          {-0.0084,0.00015,21.3434,0.33691,0.00207,0.0026}, /*cmz*/
          {2.15028,0.5226,4.9235,-3.2695} /*cfz*/
     },
     {
          2453539.5,
          {0.0051,-0.00011,20.9628,0.27758,0.001443,0.0053}, /*cmx*/
          {4.575037,2.7712,0.8616,-3.9552}, /*cfx*/
          {0.0066,-0.00011,14.3629,0.12545,0.001088,0.0045}, /*cmy*/
          {3.718938,2.6243,0.6628,-3.9851}, /*cfy*/
          {-0.0026,-8e-05,21.3817,0.3221,0.001909,0.0015}, /*cmz*/
          {5.913462,4.371,2.2556,-5.2784} /*cfz*/
     },
     {
          2453579.5,
          {0.0006,0.00019,19.0872,0.26344,0.001397,0.0036}, /*cmx*/
          {2.140601,0.3965,4.0979,-1.8157}, /*cfx*/
          {0.0027,8e-05,15.6427,0.11805,0.000758,0.0017}, /*cmy*/
          {1.511221,6.2006,3.7464,-1.2487}, /*cfy*/
          {-0.002,-2e-05,22.2684,0.27348,0.001716,0.0017}, /*cmz*/
          {3.467509,1.9436,5.6394,-2.5153} /*cfz*/
     },
     {
          2453619.5,
          {0.0072,-9e-05,18.4642,0.17306,0.002839,0.0055}, /*cmx*/
          {6.049042,4.4265,1.3018,-5.3485}, /*cfx*/
          {0.0071,-0.00013,15.3053,0.07504,0.00081,0.0016}, /*cmy*/
          {5.634592,3.7641,0.3591,-5.0298}, /*cfy*/
          {-0.0046,0.00017,22.992,0.17159,0.002501,0.0023}, /*cmz*/
          {1.171483,5.8803,2.7851,-5.2847} /*cfz*/
     },
     {
          2453659.5,
          {-0.0114,0.00082,18.4191,0.11329,0.000272,0.0064}, /*cmx*/
          {3.99614,5.5561,1.3642,-1.3858}, /*cfx*/
          {0.0013,0.00016,15.216,0.02611,0.000131,0.0026}, /*cmy*/
          {3.602192,3.6759,0.3521,-5.5546}, /*cfy*/
          {-0.0031,5e-05,23.0137,0.07335,7.8e-05,0.0121}, /*cmz*/
          {5.413818,0.9696,2.493,-2.6094} /*cfz*/
     },
     {
          2453699.5,
          {0.0046,-4e-05,18.5904,0.04825,0.002547,0.002}, /*cmx*/
          {2.307771,3.6183,0.5797,-2.797}, /*cfx*/
          {0.0045,0.0,16.0414,0.01907,0.000975,0.0015}, /*cmy*/
          {1.693664,0.9565,6.0386,-2.9418}, /*cfy*/
          {0.0,-0.00015,22.2685,0.02602,0.002306,0.0032}, /*cmz*/
          {3.62409,5.6557,2.1408,-5.9431} /*cfz*/
     },
     {
          2453739.5,
          {0.0004,0.00018,18.5321,0.15809,0.001418,0.0023}, /*cmx*/
          {0.283817,4.9864,4.1817,-0.3264}, /*cfx*/
          {0.0038,2e-05,16.1399,0.09042,0.000759,0.0033}, /*cmy*/
          {5.945607,4.3373,2.8531,-5.9915}, /*cfy*/
          {-0.0046,0.00015,22.2322,0.16051,0.001259,0.0041}, /*cmz*/
          {1.591892,0.1492,5.499,-2.5557} /*cfz*/
     },
     {
          2453779.5,
          {0.0082,-0.00013,18.5221,0.25252,0.001434,0.0029}, /*cmx*/
          {4.220296,2.7104,1.2391,-4.2258}, /*cfx*/
          {0.0067,-0.00012,15.2382,0.11676,0.001099,0.0034}, /*cmy*/
          {3.793764,1.8101,6.0319,-3.5568}, /*cfy*/
          {-0.0035,0.00017,22.9076,0.23361,0.001459,0.0035}, /*cmz*/
          {5.620653,4.1464,2.5228,-1.0342} /*cfz*/
     },
     {
          2453819.5,
          {0.0031,0.00012,19.8133,0.28688,0.001743,0.0036}, /*cmx*/
          {1.757146,0.3613,4.7807,-1.8683}, /*cfx*/
          {0.0015,8e-05,12.6538,0.1114,0.001264,0.0026}, /*cmy*/
          {1.652789,5.3054,3.1956,-0.5245}, /*cfy*/
          {0.0002,7e-05,23.4252,0.25733,0.001656,0.0017}, /*cmz*/
          {3.297957,1.7498,0.0059,-0.5623} /*cfz*/
     },
     {
          2453859.5,
          {0.0055,-5e-05,21.9691,0.27724,0.001889,0.0044}, /*cmx*/
          {5.608336,4.2158,2.2222,-5.7385}, /*cfx*/
          {0.0046,-0.00011,8.88,0.10774,0.001188,0.002}, /*cmy*/
          {6.003119,2.3483,0.2698,-3.8885}, /*cfy*/
          {0.0,0.0002,23.2437,0.26984,0.001703,0.0015}, /*cmz*/
          {0.9485,5.6001,3.8753,-1.2202} /*cfz*/
     },
     {
          2453899.5,
          {0.0046,-6e-05,23.3508,0.25339,0.001742,0.0025}, /*cmx*/
          {3.247034,1.7258,6.0825,-3.3727}, /*cfx*/
          {-0.0007,0.00015,7.4101,0.10435,0.001195,0.0027}, /*cmy*/
          {4.514954,5.7123,3.6342,-1.1846}, /*cfy*/
          {0.0066,-3e-05,22.3773,0.28279,0.001725,0.0019}, /*cmz*/
          {4.849098,3.1773,1.4746,-1.9377} /*cfz*/
     },
     {
          2453939.5,
          {0.0013,1e-05,23.1522,0.24278,0.001564,0.0032}, /*cmx*/
          {0.923829,5.527,3.7726,-1.4744}, /*cfx*/
          {0.0041,-6e-05,10.3759,0.10289,0.001244,0.0014}, /*cmy*/
          {2.835578,2.7652,0.8773,-5.0222}, /*cfy*/
          {0.0043,0.0001,21.3717,0.29688,0.001776,0.0033}, /*cmz*/
          {2.419591,0.7786,5.3283,-1.3862} /*cfz*/
     },
     {
          2453979.5,
          {0.0004,-6e-05,21.6264,0.25177,0.001574,0.0027}, /*cmx*/
          {4.870814,3.1043,1.5293,-6.1712}, /*cfx*/
          {0.0,0.00018,13.8485,0.12012,0.001246,0.0014}, /*cmy*/
          {0.772159,6.1553,4.4291,-2.2492}, /*cfy*/
          {0.003,0.00013,20.9943,0.30886,0.001862,0.003}, /*cmz*/
          {6.231539,4.6704,2.859,-6.1422} /*cfz*/
     },
     {
          2454019.5,
          {-0.0028,0.0,19.5755,0.28215,0.001772,0.002}, /*cmx*/
          {2.461642,0.729,5.4848,-3.7624}, /*cfx*/
          {0.007,-0.00013,15.8095,0.14483,0.001321,0.0006}, /*cmy*/
          {4.842869,3.4322,1.5372,-5.5812}, /*cfy*/
          {0.0067,-0.00011,21.6202,0.31258,0.002001,0.0027}, /*cmz*/
          {3.752353,2.2612,0.4023,-3.0606} /*cfz*/
     },
     {
          2454059.5,
          {-0.0072,0.00011,18.4074,0.32804,0.002074,0.0025}, /*cmx*/
          {6.210226,4.6394,2.9309,-0.9406}, /*cfx*/
          {0.0024,9e-05,15.6241,0.14955,0.001674,0.0026}, /*cmy*/
          {2.584002,0.7227,4.8465,-1.8989}, /*cfy*/
          {0.0,9e-05,22.7663,0.30978,0.002195,0.0062}, /*cmz*/
          {1.298474,6.094,4.2513,-1.3848} /*cfz*/
     },
     {
          2454099.5,
          {-0.0009,-0.00022,19.6843,0.3543,0.002488,0.0013}, /*cmx*/
          {3.60558,2.2072,0.2118,-2.8556}, /*cfx*/
          {0.0068,-0.00019,12.8198,0.13268,0.001836,0.0045}, /*cmy*/
          {0.382157,4.0109,1.8996,-4.9658}, /*cfy*/
          {0.0009,-9e-05,23.4503,0.31183,0.002389,0.004}, /*cmz*/
          {5.151165,3.5929,1.8027,-6.0634} /*cfz*/
     },
     {
          2454139.5,
          {-0.0087,0.00023,22.3796,0.32673,0.002628,0.004}, /*cmx*/
          {1.080239,5.9479,3.895,-0.3188}, /*cfx*/
          {-0.0007,0.00014,8.3611,0.135,0.0017,0.0043}, /*cmy*/
          {4.797894,0.8459,5.0166,-2.0757}, /*cfy*/
          {-0.0044,6e-05,23.0439,0.32793,0.002466,0.0035}, /*cmz*/
          {2.710548,1.0638,5.5895,-2.8913} /*cfz*/
     },
     {
          2454179.5,
          {-0.0011,-2e-05,23.4824,0.29108,0.002271,0.0035}, /*cmx*/
          {4.939421,3.327,1.4474,-4.0427}, /*cfx*/
          {0.0049,-0.00011,8.4922,0.12691,0.001773,0.0046}, /*cmy*/
          {3.43261,4.0549,1.9352,-5.1821}, /*cfy*/
          {-0.0082,0.00014,21.8634,0.35175,0.002413,0.0039}, /*cmz*/
          {0.218255,4.8343,3.0199,-0.9672} /*cfz*/
     },
     {
          2454219.5,
          {-0.0027,0.00018,22.1886,0.28856,0.001968,0.0035}, /*cmx*/
          {2.54256,0.774,5.3394,-1.9127}, /*cfx*/
          {0.001,0.00013,12.7578,0.12866,0.00163,0.004}, /*cmy*/
          {1.534506,0.8977,5.3022,-2.599}, /*cfy*/
          {-0.0036,-8e-05,21.1294,0.36072,0.002331,0.0013}, /*cmz*/
          {3.947561,2.3519,0.4236,-1.2431} /*cfz*/
     },
     {
          2454259.5,
          {0.0012,9e-05,19.8281,0.3082,0.001828,0.0042}, /*cmx*/
          {0.089673,4.6105,2.8732,-0.0893}, /*cfx*/
          {0.0055,-6e-05,15.4645,0.1504,0.001432,0.004}, /*cmy*/
          {5.609789,4.2623,2.2655,-5.8864}, /*cfy*/
          {-0.0091,0.00026,21.6784,0.34237,0.002218,0.0031}, /*cmz*/
          {1.393993,6.1636,4.151,-0.8186} /*cfz*/
     },
     {
          2454299.5,
          {0.0078,-0.0001,18.4492,0.32183,0.001728,0.0032}, /*cmx*/
          {3.820332,2.2113,0.2068,-3.884}, /*cfx*/
          {0.0041,1e-05,15.5568,0.14163,0.001373,0.0018}, /*cmy*/
          {3.345977,1.506,5.5358,-2.9589}, /*cfy*/
          {-0.0005,-3e-05,22.8226,0.30615,0.001952,0.0016}, /*cmz*/
          {5.196484,3.6847,1.619,-3.4474} /*cfz*/
     },
     {
          2454339.5,
          {0.0027,0.0002,19.3841,0.29155,0.001661,0.0031}, /*cmx*/
          {1.26963,6.1011,3.664,-1.3713}, /*cfx*/
          {0.0054,-8e-05,13.3454,0.10495,0.000924,0.0014}, /*cmy*/
          {1.153897,4.9516,2.5982,-5.4237}, /*cfy*/
          {-0.0048,0.00027,23.4587,0.26387,0.001508,0.0055}, /*cmz*/
          {2.80238,1.2174,5.2071,-1.6141} /*cfz*/
     },
     {
          2454379.5,
          {0.0103,-0.00018,21.2619,0.20572,0.00199,0.0026}, /*cmx*/
          {5.16579,3.7269,0.7449,-5.7167}, /*cfx*/
          {0.0024,1e-05,10.301,0.06997,0.000782,0.0019}, /*cmy*/
          {5.412684,2.2295,5.0374,-2.3445}, /*cfy*/
          {-0.0014,0.00014,23.3743,0.20512,0.001862,0.0055}, /*cmz*/
          {0.500369,5.119,2.0757,-6.1235} /*cfz*/
     },
     {
          2454419.5,
          {0.0021,0.00015,22.0725,0.02417,0.002229,0.0058}, /*cmx*/
          {3.020109,1.5079,4.9084,-0.2739}, /*cfx*/
          {0.0071,-0.00021,8.6682,0.04433,0.001081,0.0024}, /*cmy*/
          {3.464883,1.6972,3.1362,-4.0724}, /*cfy*/
          {-0.0057,0.00034,23.1559,0.03601,0.00209,0.0057}, /*cmz*/
          {4.644583,3.3632,6.268,-2.1099} /*cfz*/
     },
     {
          2454459.5,
          {0.0078,-0.00013,21.1884,0.15281,0.002487,0.0015}, /*cmx*/
          {1.21557,3.1281,6.208,-4.7911}, /*cfx*/
          {0.006,-0.00014,10.1187,0.09012,0.00119,0.0018}, /*cmy*/
          {1.327129,0.9838,4.2405,-2.1767}, /*cfy*/
          {-0.0021,0.00013,23.4723,0.1219,0.002179,0.0038}, /*cmz*/
          {2.808081,4.421,1.2744,-6.0764} /*cfz*/
     },
     {
          2454499.5,
          {0.0002,0.00026,20.2886,0.07388,0.001673,0.0059}, /*cmx*/
          {5.682159,4.3571,3.9487,-0.2714}, /*cfx*/
          {0.0044,-6e-05,11.7053,0.02619,0.000779,0.0024}, /*cmy*/
          {5.629379,3.5345,2.16,-5.7572}, /*cfy*/
          {-0.0035,0.0002,23.4388,0.06906,0.001578,0.002}, /*cmz*/
          {0.956708,5.7661,5.3389,-3.4637} /*cfz*/
     },
     {
          2454539.5,
          {0.0076,-0.00011,21.226,0.20546,0.001204,0.0034}, /*cmx*/
          {3.511715,2.1469,0.6806,-4.1431}, /*cfx*/
          {0.0014,4e-05,10.0615,0.07191,0.000823,0.0023}, /*cmy*/
          {3.669524,0.5345,5.0955,-2.6828}, /*cfy*/
          {0.0021,-2e-05,23.3998,0.18766,0.001279,0.0004}, /*cmz*/
          {5.109972,3.5424,2.2938,-4.3945} /*cfz*/
     },
     {
          2454579.5,
          {0.0027,9e-05,22.7349,0.23497,0.001491,0.0047}, /*cmx*/
          {1.21331,6.0638,4.2449,-1.7008}, /*cfx*/
          {0.0029,-5e-05,7.5182,0.09025,0.000987,0.002}, /*cmy*/
          {1.925758,4.0331,2.087,-5.9738}, /*cfy*/
          {0.0055,-7e-05,22.9566,0.24121,0.001487,0.0004}, /*cmz*/
          {2.837042,1.2,5.9148,-3.5266} /*cfz*/
     },
     {
          2454619.5,
          {0.005,-8e-05,23.4635,0.23318,0.001534,0.0028}, /*cmx*/
          {5.190762,3.6208,1.8279,-0.2166}, /*cfx*/
          {0.0021,0.0,7.9444,0.09554,0.001143,0.0024}, /*cmy*/
          {0.443457,1.1992,5.4979,-3.58}, /*cfy*/
          {0.0038,8e-05,22.067,0.27208,0.001612,0.0028}, /*cmz*/
          {0.483519,5.103,3.4474,-4.9019} /*cfz*/
     },
     {
          2454659.5,
          {0.0018,0.0,22.838,0.23666,0.001514,0.0021}, /*cmx*/
          {2.885252,1.1795,5.7945,-3.7816}, /*cfx*/
          {0.0018,3e-05,11.3288,0.10371,0.001245,0.0008}, /*cmy*/
          {4.893812,4.5744,2.7505,-5.9527}, /*cfy*/
          {0.0088,-0.00012,21.2252,0.29329,0.001716,0.004}, /*cmz*/
          {4.346217,2.7205,1.0126,-3.971} /*cfz*/
     },
     {
          2454699.5,
          {-0.002,5e-05,21.1311,0.25632,0.00159,0.0022}, /*cmx*/
          {0.544273,5.0573,3.5156,-2.0687}, /*cfx*/
          {0.0057,-0.0001,14.4555,0.12874,0.001281,0.0013}, /*cmy*/
          {2.777548,1.7432,6.2544,-4.0759}, /*cfy*/
          {0.0058,0.0,21.0833,0.30658,0.001893,0.0021}, /*cmz*/
          {1.87776,0.3372,4.8463,-1.9763} /*cfz*/
     },
     {
          2454739.5,
          {-0.0001,-0.00016,19.1656,0.29369,0.001848,0.0019}, /*cmx*/
          {4.392396,2.6827,1.1619,-6.2591}, /*cfx*/
          {0.0016,0.00013,15.9683,0.1543,0.001425,0.0017}, /*cmy*/
          {0.545437,5.3228,3.3148,-5.9605}, /*cfy*/
          {0.0071,-0.00012,21.8657,0.31318,0.002125,0.0044}, /*cmz*/
          {5.685591,4.2086,2.3714,-5.5719} /*cfz*/
     },
     {
          2454779.5,
          {-0.0073,0.0001,18.4782,0.34073,0.002258,0.0024}, /*cmx*/
          {1.822265,0.2998,4.844,-2.0234}, /*cfx*/
          {0.0089,-0.00024,15.2411,0.15336,0.00181,0.0044}, /*cmy*/
          {4.56458,2.5533,0.3429,-3.7714}, /*cfy*/
          {0.0072,-0.00022,22.9814,0.31705,0.002352,0.0058}, /*cmz*/
          {3.233436,1.7379,6.1681,-3.7582} /*cfz*/
     },
     {
          2454819.5,
          {-0.0048,-4e-05,20.3522,0.35797,0.002768,0.0027}, /*cmx*/
          {5.495103,4.1248,2.1021,-5.3191}, /*cfx*/
          {-0.0016,0.00021,11.7536,0.13935,0.001852,0.0049}, /*cmy*/
          {2.395481,5.7295,3.6072,-0.5155}, /*cfy*/
          {-0.0019,7e-05,23.4613,0.32486,0.002494,0.0019}, /*cmz*/
          {0.794353,5.4897,3.691,-1.6659} /*cfz*/
     },
     {
          2454859.5,
          {-0.0068,0.00011,22.915,0.32243,0.002736,0.0053}, /*cmx*/
          {2.987297,1.5354,5.7898,-2.2788}, /*cfx*/
          {0.0064,-0.00023,7.5691,0.14311,0.001774,0.0042}, /*cmy*/
          {0.698665,2.5655,0.3739,-3.6901}, /*cfy*/
          {0.0023,-0.00029,22.8005,0.34337,0.002521,0.0042}, /*cmz*/
          {4.613721,2.9432,1.1817,-4.9836} /*cfz*/
     },
     {
          2454899.5,
          {-0.0064,0.00018,23.2996,0.29528,0.002251,0.0041}, /*cmx*/
          {0.568811,5.1801,3.328,-0.0567}, /*cfx*/
          {-0.0034,0.00027,9.634,0.13131,0.001812,0.005}, /*cmy*/
          {5.555023,5.7155,3.6356,-0.8061}, /*cfy*/
          {-0.0064,6e-05,21.5728,0.36242,0.0025,0.0017}, /*cmz*/
          {2.08724,0.4318,4.8929,-3.4401} /*cfz*/
     },
     {
          2454939.5,
          {0.0005,-1e-05,21.4782,0.3004,0.001967,0.0023}, /*cmx*/
          {4.436083,2.6459,0.9513,-4.2648}, /*cfx*/
          {0.0056,-0.00012,13.8873,0.14409,0.001601,0.0028}, /*cmy*/
          {3.512066,2.5797,0.6956,-4.3001}, /*cfy*/
          {-0.0031,-0.0001,21.1452,0.36389,0.002467,0.0023}, /*cmz*/
          {5.79272,4.2333,2.2959,-4.6961} /*cfz*/
     },
     {
          2454979.5,
          {0.0,0.00018,19.1567,0.32287,0.001946,0.0043}, /*cmx*/
          {1.936088,0.2147,4.7849,-2.1055}, /*cfx*/
          {-0.0009,0.00024,15.8513,0.16167,0.001507,0.004}, /*cmy*/
          {1.25564,6.0065,3.9124,-1.4537}, /*cfy*/
          {-0.0025,-5e-05,22.0043,0.34368,0.002363,0.0029}, /*cmz*/
          {3.241776,1.7478,6.0204,-2.8159} /*cfz*/
     },
     {
          2455019.5,
          {0.0054,1e-05,18.5343,0.33779,0.002042,0.0033}, /*cmx*/
          {5.616463,4.0975,2.1394,-0.1922}, /*cfx*/
          {0.0073,-0.00018,14.9972,0.14174,0.001548,0.0008}, /*cmy*/
          {5.266788,3.1935,0.9556,-3.9078}, /*cfy*/
          {-0.0045,0.00013,23.1233,0.31324,0.002106,0.0037}, /*cmz*/
          {0.768075,5.5261,3.5248,-5.5734} /*cfz*/
     },
     {
          2455059.5,
          {0.0048,9e-05,20.3812,0.31052,0.002011,0.0011}, /*cmx*/
          {3.052426,1.6672,5.7656,-2.8933}, /*cfx*/
          {-0.0008,0.00016,11.6915,0.11201,0.001187,0.002}, /*cmy*/
          {3.120998,0.1836,4.3239,-0.8323}, /*cfy*/
          {0.0027,-0.0001,23.4788,0.28616,0.001718,0.0053}, /*cmz*/
          {4.641218,3.0293,1.0353,-4.0413} /*cfz*/
     },
     {
          2455099.5,
          {0.0046,6e-05,22.5757,0.25021,0.001563,0.0008}, /*cmx*/
          {0.639691,5.4762,3.1106,-5.9734}, /*cfx*/
          {0.0045,-0.00016,8.0515,0.09327,0.000768,0.0019}, /*cmy*/
          {1.308632,3.5356,1.1842,-3.9788}, /*cfy*/
          {0.0001,0.00013,22.9915,0.259,0.001309,0.0032}, /*cmz*/
          {2.270597,0.5938,4.6433,-1.8655} /*cfz*/
     },
     {
          2455139.5,
          {0.0094,-0.00019,23.4745,0.18365,0.001401,0.002}, /*cmx*/
          {4.64716,3.0358,0.1002,-2.3119}, /*cfx*/
          {-0.0006,9e-05,7.4801,0.06076,0.000722,0.0009}, /*cmy*/
          {6.058581,0.8264,4.0558,-1.0942}, /*cfy*/
          {0.0068,-0.00014,22.2873,0.21016,0.001635,0.0053}, /*cmz*/
          {6.235364,4.5511,1.5669,-5.5194} /*cfz*/
     },
     {
          2455179.5,
          {0.0068,-7e-05,23.3925,0.06725,0.002076,0.0023}, /*cmx*/
          {2.51575,0.9306,4.0497,-5.8028}, /*cfx*/
          {0.0,5e-05,8.2458,0.0069,0.001138,0.0026}, /*cmy*/
          {4.274415,0.4961,1.8808,-3.5613}, /*cfy*/
          {0.0024,4e-05,22.0114,0.06829,0.00247,0.0015}, /*cmz*/
          {4.059848,2.574,5.5839,-3.9006} /*cfz*/
     },
     {
          2455219.5,
          {0.0146,-0.00048,23.4781,0.12263,0.001447,0.0065}, /*cmx*/
          {0.623226,2.2458,5.2592,-3.9867}, /*cfx*/
          {0.0,8e-05,6.8183,0.10405,0.000945,0.0042}, /*cmy*/
          {2.209526,0.0907,2.9042,-2.3488}, /*cfy*/
          {0.0039,-9e-05,22.4627,0.14592,0.001642,0.0071}, /*cmz*/
          {2.196262,3.7067,0.5369,-5.7005} /*cfz*/
     },
     {
          2455259.5,
          {0.0064,-7e-05,23.2205,0.02263,0.001723,0.0048}, /*cmx*/
          {5.103012,3.7369,3.4327,-6.01}, /*cfx*/
          {0.0042,-0.00013,6.3671,0.0169,0.000838,0.0017}, /*cmy*/
          {6.164597,5.1487,1.3184,-4.1204}, /*cfy*/
          {-0.0015,0.00021,22.7832,0.01994,0.001918,0.0023}, /*cmz*/
          {0.424961,5.3573,4.8886,-0.2288} /*cfz*/
     },
     {
          2455299.5,
          {0.0096,-0.00023,23.3627,0.15878,0.001048,0.0048}, /*cmx*/
          {3.038462,1.5435,0.3052,-4.2187}, /*cfx*/
          {-0.0009,0.00012,6.9604,0.0579,0.000585,0.0017}, /*cmy*/
          {4.353638,5.4188,4.0322,-1.8423}, /*cfy*/
          {0.0041,-1e-05,22.4623,0.1696,0.001286,0.0017}, /*cmz*/
          {4.631928,3.0032,2.0242,-4.5767} /*cfz*/
     },
     {
          2455339.5,
          {0.0036,1e-05,23.3445,0.20366,0.001257,0.002}, /*cmx*/
          {0.824087,5.4832,3.908,-2.9304}, /*cfx*/
          {0.0024,-5e-05,9.1046,0.08396,0.000937,0.0014}, /*cmy*/
          {2.628411,2.8223,1.066,-5.8261}, /*cfy*/
          {0.004,5e-05,21.7171,0.24127,0.001448,0.0022}, /*cmz*/
          {2.354713,0.7162,5.5444,-1.9521} /*cfz*/
     },
     {
          2455379.5,
          {0.0041,-0.00011,22.377,0.2269,0.001423,0.0021}, /*cmx*/
          {4.83052,3.1,1.5561,-5.4889}, /*cfx*/
          {-0.0007,0.00013,12.3967,0.10378,0.001154,0.0015}, /*cmy*/
          {0.648675,0.0453,4.6423,-1.6348}, /*cfy*/
          {0.0034,0.00012,21.1059,0.28142,0.001656,0.0035}, /*cmz*/
          {6.249184,4.655,2.9948,-6.2424} /*cfz*/
     },
     {
          2455419.5,
          {0.0023,-0.00013,20.5679,0.25756,0.001658,0.0029}, /*cmx*/
          {2.48614,0.7301,5.5237,-4.3886}, /*cfx*/
          {0.0034,-1e-05,15.0365,0.13246,0.001283,0.0009}, /*cmy*/
          {4.771553,3.5985,1.8625,-0.5282}, /*cfy*/
          {0.009,-0.00013,21.2309,0.30356,0.001863,0.0023}, /*cmz*/
          {3.798072,2.2745,0.508,-3.8082} /*cfz*/
     },
     {
          2455459.5,
          {-0.0026,0.0,18.7882,0.30502,0.001978,0.0002}, /*cmx*/
          {0.025926,4.6451,3.0863,-0.1616}, /*cfx*/
          {0.0013,0.00012,16.0058,0.15562,0.00155,0.0035}, /*cmy*/
          {2.522763,0.9268,5.1725,-1.9859}, /*cfy*/
          {0.0032,0.00011,22.1656,0.31339,0.002148,0.0046}, /*cmz*/
          {1.333978,6.1366,4.319,-1.7538} /*cfz*/
     },
     {
          2455499.5,
          {0.0023,-0.00035,18.7115,0.35597,0.002387,0.0037}, /*cmx*/
          {3.715097,2.2365,0.3987,-3.8836}, /*cfx*/
          {0.0036,-3e-05,14.6103,0.1501,0.001987,0.0044}, /*cmy*/
          {0.261408,4.3867,2.1863,-5.7404}, /*cfy*/
          {0.0048,-8e-05,23.1935,0.31911,0.002469,0.0041}, /*cmz*/
          {5.167475,3.6574,1.8403,-5.9366} /*cfz*/
     },
     {
          2455539.5,
          {-0.0103,0.00021,21.1058,0.35922,0.002829,0.0028}, /*cmx*/
          {1.114914,6.0164,3.9591,-0.3746}, /*cfx*/
          {0.0,9e-05,10.4688,0.14071,0.001939,0.0058}, /*cmy*/
          {4.435473,1.2073,5.383,-2.3607}, /*cfy*/
          {0.0004,-1e-05,23.3923,0.33227,0.002651,0.0026}, /*cmz*/
          {2.719853,1.1176,5.6136,-3.3507} /*cfz*/
     }

};

static unsigned idn_list[] = {2,90};
static double freq_list[] = {19.7027,4.9788};
static double delt_list[] = {50.0,40.0};

BDL_Dataset mars_9910 = {
     2, /*nsat*/
     2451179.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};

