# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ConfidentialLedgerEnclaves(msrest.serialization.Model):
    """Information about the enclaves running the Confidential Ledger.

    All required parameters must be populated in order to send to Azure.

    :param current_node_id: Required. Id of the Confidential Ledger node responding to the request.
    :type current_node_id: str
    :param enclave_quotes: Required. Dictionary of enclave quotes, indexed by node id.
    :type enclave_quotes: dict[str,
     ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.EnclaveQuote]
    """

    _validation = {
        'current_node_id': {'required': True},
        'enclave_quotes': {'required': True},
    }

    _attribute_map = {
        'current_node_id': {'key': 'currentNodeId', 'type': 'str'},
        'enclave_quotes': {'key': 'enclaveQuotes', 'type': '{EnclaveQuote}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfidentialLedgerEnclaves, self).__init__(**kwargs)
        self.current_node_id = kwargs['current_node_id']
        self.enclave_quotes = kwargs['enclave_quotes']


class ConfidentialLedgerError(msrest.serialization.Model):
    """An error response from Confidential Ledger.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: An error response from Confidential Ledger.
    :vartype error:
     ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.ConfidentialLedgerErrorBody
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ConfidentialLedgerErrorBody'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfidentialLedgerError, self).__init__(**kwargs)
        self.error = None


class ConfidentialLedgerErrorBody(msrest.serialization.Model):
    """An error response from Confidential Ledger.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: An error response from Confidential Ledger.
    :vartype inner_error:
     ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.ConfidentialLedgerErrorBody
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'inner_error': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'inner_error': {'key': 'innererror', 'type': 'ConfidentialLedgerErrorBody'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfidentialLedgerErrorBody, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.inner_error = None


class Consortium(msrest.serialization.Model):
    """List of members in the consortium.

    All required parameters must be populated in order to send to Azure.

    :param members: Required.
    :type members:
     list[~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.ConsortiumMember]
    """

    _validation = {
        'members': {'required': True},
    }

    _attribute_map = {
        'members': {'key': 'members', 'type': '[ConsortiumMember]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Consortium, self).__init__(**kwargs)
        self.members = kwargs['members']


class ConsortiumMember(msrest.serialization.Model):
    """Describes a member of the consortium.

    All required parameters must be populated in order to send to Azure.

    :param certificate: Required. PEM-encoded certificate associated with the member.
    :type certificate: str
    :param id: Required. Identifier assigned to the member.
    :type id: str
    """

    _validation = {
        'certificate': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConsortiumMember, self).__init__(**kwargs)
        self.certificate = kwargs['certificate']
        self.id = kwargs['id']


class Constitution(msrest.serialization.Model):
    """The governance script for the application.

    All required parameters must be populated in order to send to Azure.

    :param digest: Required. SHA256 digest of the constitution script.
    :type digest: str
    :param script: Required. Contents of the constitution.
    :type script: str
    """

    _validation = {
        'digest': {'required': True},
        'script': {'required': True},
    }

    _attribute_map = {
        'digest': {'key': 'digest', 'type': 'str'},
        'script': {'key': 'script', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Constitution, self).__init__(**kwargs)
        self.digest = kwargs['digest']
        self.script = kwargs['script']


class EnclaveQuote(msrest.serialization.Model):
    """Contains the enclave quote.

    All required parameters must be populated in order to send to Azure.

    :param node_id: Required. ID assigned to this node.
    :type node_id: str
    :param mrenclave: MRENCLAVE value of the code running in the enclave.
    :type mrenclave: str
    :param quote_version: Required. Version of the quote presented.
    :type quote_version: str
    :param raw: Required. Raw SGX quote, parsable by tools like Open Enclave's oeverify.
    :type raw: str
    """

    _validation = {
        'node_id': {'required': True},
        'quote_version': {'required': True},
        'raw': {'required': True},
    }

    _attribute_map = {
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'mrenclave': {'key': 'mrenclave', 'type': 'str'},
        'quote_version': {'key': 'quoteVersion', 'type': 'str'},
        'raw': {'key': 'raw', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnclaveQuote, self).__init__(**kwargs)
        self.node_id = kwargs['node_id']
        self.mrenclave = kwargs.get('mrenclave', None)
        self.quote_version = kwargs['quote_version']
        self.raw = kwargs['raw']


class LedgerEntry(msrest.serialization.Model):
    """An entry in the ledger.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param contents: Required. Contents of the ledger entry.
    :type contents: str
    :ivar sub_ledger_id: Identifier for sub-ledgers.
    :vartype sub_ledger_id: str
    :ivar transaction_id: A unique identifier for the state of the ledger. If returned as part of a
     LedgerEntry, it indicates the state from which the entry was read.
    :vartype transaction_id: str
    """

    _validation = {
        'contents': {'required': True},
        'sub_ledger_id': {'readonly': True},
        'transaction_id': {'readonly': True},
    }

    _attribute_map = {
        'contents': {'key': 'contents', 'type': 'str'},
        'sub_ledger_id': {'key': 'subLedgerId', 'type': 'str'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LedgerEntry, self).__init__(**kwargs)
        self.contents = kwargs['contents']
        self.sub_ledger_id = None
        self.transaction_id = None


class LedgerQueryResult(msrest.serialization.Model):
    """The result of querying for a ledger entry from an older transaction id. The ledger entry is available in the response only if the returned state is Ready.

    All required parameters must be populated in order to send to Azure.

    :param state: Required. State of a ledger query. Possible values include: "Loading", "Ready".
    :type state: str or
     ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.ConfidentialLedgerQueryState
    :param entry: The ledger entry found as a result of the query. This is only available if the
     query is in Ready state.
    :type entry:
     ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.LedgerEntry
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'entry': {'key': 'entry', 'type': 'LedgerEntry'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LedgerQueryResult, self).__init__(**kwargs)
        self.state = kwargs['state']
        self.entry = kwargs.get('entry', None)


class LedgerUser(msrest.serialization.Model):
    """Details about a Confidential Ledger user.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param assigned_role: Required. Represents an assignable role. Possible values include:
     "Administrator", "Contributor", "Reader".
    :type assigned_role: str or
     ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.ConfidentialLedgerUserRoleName
    :ivar user_id: Identifier for the user. This must either be an AAD object id or a certificate
     fingerprint.
    :vartype user_id: str
    """

    _validation = {
        'assigned_role': {'required': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'assigned_role': {'key': 'assignedRole', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LedgerUser, self).__init__(**kwargs)
        self.assigned_role = kwargs['assigned_role']
        self.user_id = None


class LedgerWriteResult(msrest.serialization.Model):
    """Returned as a result of a write to the Confidential Ledger, the transaction id in the response indicates when the write will become durable.

    All required parameters must be populated in order to send to Azure.

    :param sub_ledger_id: Required. Identifier for sub-ledgers.
    :type sub_ledger_id: str
    """

    _validation = {
        'sub_ledger_id': {'required': True},
    }

    _attribute_map = {
        'sub_ledger_id': {'key': 'subLedgerId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LedgerWriteResult, self).__init__(**kwargs)
        self.sub_ledger_id = kwargs['sub_ledger_id']


class MerkleProofElement(msrest.serialization.Model):
    """An item in the Merkle proof.

    :param left:
    :type left: str
    :param right:
    :type right: str
    """

    _attribute_map = {
        'left': {'key': 'left', 'type': 'str'},
        'right': {'key': 'right', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MerkleProofElement, self).__init__(**kwargs)
        self.left = kwargs.get('left', None)
        self.right = kwargs.get('right', None)


class PagedLedgerEntries(msrest.serialization.Model):
    """Paginated ledger entries returned in response to a query.

    All required parameters must be populated in order to send to Azure.

    :param state: Required. State of a ledger query. Possible values include: "Loading", "Ready".
    :type state: str or
     ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.ConfidentialLedgerQueryState
    :param next_link: Path from which to retrieve the next page of results.
    :type next_link: str
    :param entries: Required. Array of ledger entries.
    :type entries:
     list[~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.LedgerEntry]
    """

    _validation = {
        'state': {'required': True},
        'entries': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'entries': {'key': 'entries', 'type': '[LedgerEntry]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedLedgerEntries, self).__init__(**kwargs)
        self.state = kwargs['state']
        self.next_link = kwargs.get('next_link', None)
        self.entries = kwargs['entries']


class ReceiptContents(msrest.serialization.Model):
    """A receipt certifying the transaction at the specified id.

    All required parameters must be populated in order to send to Azure.

    :param leaf: Required. Merkle tree leaf for this transaction.
    :type leaf: str
    :param node_id: Required. Id of the node returning the receipt.
    :type node_id: str
    :param proof: Required. Merkle proof.
    :type proof:
     list[~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.MerkleProofElement]
    :param root: Required. Root of the Merkle tree at the time the transaction was recorded.
    :type root: str
    :param signature: Required. Signature by the node, with its certificate, over the Merkle root.
    :type signature: str
    """

    _validation = {
        'leaf': {'required': True},
        'node_id': {'required': True},
        'proof': {'required': True},
        'root': {'required': True},
        'signature': {'required': True},
    }

    _attribute_map = {
        'leaf': {'key': 'leaf', 'type': 'str'},
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'proof': {'key': 'proof', 'type': '[MerkleProofElement]'},
        'root': {'key': 'root', 'type': 'str'},
        'signature': {'key': 'signature', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReceiptContents, self).__init__(**kwargs)
        self.leaf = kwargs['leaf']
        self.node_id = kwargs['node_id']
        self.proof = kwargs['proof']
        self.root = kwargs['root']
        self.signature = kwargs['signature']


class RoleAssignment(msrest.serialization.Model):
    """Object for assigning a role to a user.

    All required parameters must be populated in order to send to Azure.

    :param role_name: Required. Represents an assignable role. Possible values include:
     "Administrator", "Contributor", "Reader".
    :type role_name: str or
     ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.ConfidentialLedgerUserRoleName
    :param description: Description of the role.
    :type description: str
    """

    _validation = {
        'role_name': {'required': True},
    }

    _attribute_map = {
        'role_name': {'key': 'roleName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleAssignment, self).__init__(**kwargs)
        self.role_name = kwargs['role_name']
        self.description = kwargs.get('description', None)


class TransactionReceipt(msrest.serialization.Model):
    """A receipt certifying the transaction at the specified id.

    All required parameters must be populated in order to send to Azure.

    :param receipt: A receipt certifying the transaction at the specified id.
    :type receipt:
     ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.ReceiptContents
    :param state: Required. State of a ledger query. Possible values include: "Loading", "Ready".
    :type state: str or
     ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.ConfidentialLedgerQueryState
    :param transaction_id: Required. A unique identifier for the state of the ledger. If returned
     as part of a LedgerEntry, it indicates the state from which the entry was read.
    :type transaction_id: str
    """

    _validation = {
        'state': {'required': True},
        'transaction_id': {'required': True},
    }

    _attribute_map = {
        'receipt': {'key': 'receipt', 'type': 'ReceiptContents'},
        'state': {'key': 'state', 'type': 'str'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransactionReceipt, self).__init__(**kwargs)
        self.receipt = kwargs.get('receipt', None)
        self.state = kwargs['state']
        self.transaction_id = kwargs['transaction_id']


class TransactionStatus(msrest.serialization.Model):
    """Response returned to a query for the transaction status.

    All required parameters must be populated in order to send to Azure.

    :param state: Required. Represents the state of the transaction. Possible values include:
     "Committed", "Pending".
    :type state: str or
     ~azure.confidentialledger._generated/_generated_ledger.v0_1_preview.models.TransactionState
    :param transaction_id: Required. A unique identifier for the state of the ledger. If returned
     as part of a LedgerEntry, it indicates the state from which the entry was read.
    :type transaction_id: str
    """

    _validation = {
        'state': {'required': True},
        'transaction_id': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'transaction_id': {'key': 'transactionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransactionStatus, self).__init__(**kwargs)
        self.state = kwargs['state']
        self.transaction_id = kwargs['transaction_id']
