# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.carbonoptimization.aio import CarbonOptimizationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCarbonOptimizationMgmtCarbonServiceOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CarbonOptimizationMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_carbon_service_query_carbon_emission_reports(self, resource_group):
        response = await self.client.carbon_service.query_carbon_emission_reports(
            query_parameters={
                "carbonScopeList": ["str"],
                "categoryType": "str",
                "dateRange": {"end": "2020-02-20", "start": "2020-02-20"},
                "orderBy": "str",
                "pageSize": 0,
                "reportType": "ItemDetailsReport",
                "sortDirection": "str",
                "subscriptionList": ["str"],
                "locationList": ["str"],
                "resourceGroupUrlList": ["str"],
                "resourceTypeList": ["str"],
                "skipToken": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_carbon_service_query_carbon_emission_data_available_date_range(self, resource_group):
        response = await self.client.carbon_service.query_carbon_emission_data_available_date_range()

        # please add some check logic here by yourself
        # ...
