/***************************************************************************
                          listviews.cpp  -  description
                             -------------------
    begin                : Mon M�r 3 2003
    copyright            : (C) 2003 by Harald Krippel
    email                : harald@hte-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "main.h"
#include "listviews.hpp"
#include "glcontrol.hpp"
#include "CQcakeDlg.hpp"

#include <plib/ssgaSky.h>
#include "guitext.hpp"
#include "guibutton.hpp"
#include "guiosbutton.hpp"
#include "guiinput.hpp"
//#include "netclient.hpp"
#include "tribarrier.hpp"
#include "usercamera.hpp"
#include "alsound.hpp"
#include "qcskysystem.hpp"
#include "qcfog.hpp"

FolderListItem::FolderListItem( QTreeWidget * parent )
  :QTreeWidgetItem( parent )
{
   init();
}

FolderListItem::FolderListItem( FolderListItem * parent )
  :QTreeWidgetItem( parent )
{
   init();
}

FolderListItem::FolderListItem( QTreeWidget * parent, FolderListItem * after )
  :QTreeWidgetItem( parent , after )  
{
   init();
}

FolderListItem::FolderListItem( FolderListItem * parent, FolderListItem * after )
  :QTreeWidgetItem( parent , after )
{
   init();
}

void FolderListItem::init()
{

    gl= NULL;
    light= NULL;
    objtrans= NULL;
    fire= NULL;
    wavesys= NULL;
    sky= NULL;
    dialog= NULL;
    player= NULL;
    partsys= NULL;
    fog=NULL;
    barrier= NULL;
    body= NULL;
    scriptprog= NULL;
    guitext= NULL;
    guibutton= NULL;
    guiosbutton= NULL;
    guiinput= NULL;
//    client= NULL;
    tribarrier= NULL;
    usercam= NULL;
    cursor= NULL;
    sound= NULL;
    media= NULL;

    groundcollision = 0;
    collision= 0;
}
void FolderListItem::cleanup()
{

  if(gl != NULL){
//    delete gl; // don delete gl !!
    gl= NULL;
  }
  if(light != NULL){
//    delete light;
    light= NULL;
  }
  if( objtrans!= NULL){
//    delete objtrans;
    objtrans= NULL;
  }
  if( fire!= NULL){
//    delete fire;
    fire= NULL;
  }
  if(wavesys != NULL){
//    delete wavesys;
    wavesys= NULL;
  }
  if(partsys != NULL){
//    delete partsys;
    partsys= NULL;
  }
  if(fog != NULL){
    delete fog;
    fog= NULL;
  }
  if(sky != NULL){
    delete sky;
    sky= NULL;
  }
  if(dialog != NULL){
//    delete dialog;
    dialog= NULL;
  }
  if(player != NULL){
    delete player;
    player= NULL;
  }
  if(barrier != NULL){
    delete barrier;
    barrier= NULL;
  }
  if(body != NULL){
    delete body;
    body= NULL;
  }
  if(scriptprog != NULL){
    delete scriptprog;
    scriptprog= NULL;
  }
  if(guitext != NULL){
    puDeleteObject((puObject *)this->guitext);
//    delete guitext;
    guitext= NULL;
  }
  if(guibutton != NULL){
    puDeleteObject((puObject *)this->guibutton);
//    delete guibutton;
    guibutton= NULL;
  }
  if(guiosbutton != NULL){
    puDeleteObject((puObject *)this->guiosbutton);
//    delete guiosbutton;
    guiosbutton= NULL;
  }
  if(guiinput != NULL){
    puDeleteObject((puObject *)this->guiinput);
//    delete guiinput;
    guiinput= NULL;
  }
/*
  if(client != NULL){
    delete client;
    client= NULL;
  }
*/
  if(tribarrier != NULL){
    delete tribarrier;
    tribarrier= NULL;
  }
  if(usercam != NULL){
    delete usercam;
    usercam= NULL;
  }
  if(cursor != NULL){
    delete cursor;
    cursor= NULL;
  }
  if(sound != NULL){
//    delete sound;
    sound= NULL;
  }
  if(media != NULL){
    delete media;
    media= NULL;
  }
  groundcollision = 0;
  collision= 0;
}
/*
 *  Destroys the object and frees any allocated resources
 */
FolderListItem::~FolderListItem()
{
   cleanup();
}

FolderListItem * FolderListItem::search_id(FolderListItem * i,const int id)
{
    int a=0;
    FolderListItem *founditem=NULL;

    if ( !i )
         return NULL;
    for(a=0; a < i->childCount (); a++) {
      QTreeWidgetItem *ichild = i->child(a);
      if(ichild != NULL){
        if(((FolderListItem *)ichild)->GetValue("tmpid").toInt() == id){
          return((FolderListItem *)ichild);
        }
        founditem = search_id((FolderListItem *)ichild,id);
        if(founditem != NULL){ 
           return(founditem);
        }
      }
    }
    return NULL;
}

void FolderListItem::scene_cleanup(FolderListItem * i)
{
    int a=0;

    if ( !i )
         return;
    for(a=0; a < i->childCount (); a++) {
      QTreeWidgetItem *ichild = i->child(a);
      if(ichild != NULL){
          ((FolderListItem *)ichild)->cleanup();
          if(((FolderListItem *)ichild)->text(1) == "TMPOBJ"){
             QTreeWidgetItem *tempi = i->takeChild(a);
             if(tempi != NULL){
                  delete tempi;
             }
          } else {
             scene_cleanup((FolderListItem *)ichild);
          }
       }
    }
    return;
}

void FolderListItem::scene_RedrawGUI(FolderListItem * i)
{
    int a;

    if ( !i )
         return;
    for(a=0; a < i->childCount (); a++) {
      QTreeWidgetItem *ichild = i->child(a);
      if(ichild != NULL){
        if(((FolderListItem *)ichild)->text(1) == "GUI-TXT"){
          ((FolderListItem *)ichild)->gl->setFocusGUIText((FolderListItem *)ichild);
        }
        if(((FolderListItem *)ichild)->text(1) == "GUI-BUTTON"){
          ((FolderListItem *)ichild)->gl->setFocusGUIButton((FolderListItem *)ichild);
        }
        if(((FolderListItem *)ichild)->text(1) == "GUI-OSBUTTON"){
          ((FolderListItem *)ichild)->gl->setFocusGUIOSButton((FolderListItem *)ichild);
        }
        if(((FolderListItem *)ichild)->text(1) == "GUI-INPUT"){
          ((FolderListItem *)ichild)->gl->setFocusGUIInput((FolderListItem *)ichild);
        }
        scene_RedrawGUI((FolderListItem *)ichild);
       }
    }
    return;
}

QString FolderListItem::GetValue(const QString & item )
{
    int a;
    
    if( !this )
       return("");
              
    for(a=0; a < this->childCount (); a++) {
       QTreeWidgetItem *ichild = this->child(a);
       if(ichild != NULL){
          if(ichild->text(0) == item){
//                qWarning( item + " OK !" );
           return(ichild->text(1));
           }
       }
    }
//    QString msg = item + " nicht gefunden !";
//    qWarning( msg.toAscii());
    return("");
}

QString FolderListItem::GetValue(const QString & item, FolderListItem *i)
{
    int a;

    if( !i )
      return("");
    
    for(a=0; a < i->childCount (); a++) {
       QTreeWidgetItem *ichild = i->child(a);
       if(ichild != NULL){
          if(ichild->text(0) == item){
//                qWarning( item + " OK !" );
          return(ichild->text(1));
          }
       }
    }
//    QString msg = item + " nicht gefunden !";
//    qWarning( msg.toAscii());

    return("");
}

void FolderListItem::SetValue(const QString & item, const QString & value)
{
    int a;

    if( !this )
      return;
    for(a=0; a < this->childCount (); a++) {
       QTreeWidgetItem *ichild = this->child(a);
       if(ichild != NULL){
          if(ichild->text(0) == item){
//            qWarning( item + " OK !" );
              ichild->setText(1,value);
              return;
          }
       }
    }
    QString msg = item + " nicht gefunden !";
    qWarning( msg.toAscii());

    return;
}
void FolderListItem::SetValue(const QString & item, const QString & value, FolderListItem *i)
{
    int a;

    if( !i )
      return;

    for(a=0; a < i->childCount (); a++) {
       QTreeWidgetItem *ichild = i->child(a);
       if(ichild != NULL){
          if(ichild->text(0) == item){
//            qWarning( item + " OK !" );
              ichild->setText(1,value);
              return;
          }
       }
    } 
    QString msg = item + " nicht gefunden !";
    qWarning( msg.toAscii());

    return;
}

void FolderListItem::viewCamera()
{
  if(gl != NULL){
    gl->switchCamera(this);
  }
}

void FolderListItem::updategl()
{
    if(this->text(1) == "LAMP"){
            qWarning(  "update light " );
            if(gl != NULL){
              gl->setFocusLamp(this);
            }
    }
    if(this->text(1) == "FIRE"){
      if(objtrans != NULL && fire != NULL){
            qWarning(  "update fire " );
            if(gl != NULL){
              gl->setFocusFire(this);
            }
      }
    }
    if(this->text(1) == "OBJECT"){
      if(objtrans != NULL ){
            qWarning(  "update OBJECT " );
            if(gl != NULL){
              gl->setFocusObject(this);
            }
      }
    }
    if(this->text(1) == "BARRIER"){
      if(objtrans != NULL ){
            qWarning(  "update BARRIER " );
            if(gl != NULL){
              gl->setFocusBarrier(this);
            }
      }
    }
    if(this->text(1) == "BODY"){
      if(objtrans != NULL ){
            qWarning(  "update BODY " );
            if(gl != NULL){
              gl->setFocusBody(this);
            }
      }
    }
    if(this->text(1) == "PARTSYS"){
      if(objtrans != NULL ){
            qWarning(  "update PARTSYS " );
            if(gl != NULL){
              gl->setFocusDefault(this);
            }
      }
    }
    if(this->text(1) == "WAVESYS"){
      if(objtrans != NULL && wavesys != NULL){
            qWarning(  "update WAVESYS " );
            if(gl != NULL){
              gl->setFocusWaveSys(this);
            }
      }
    }
    if(this->text(1) == "CAMERA"){
      if(objtrans != NULL ){
            qWarning(  "update CAMERA " );
            if(gl != NULL){
              gl->setFocusCamera(this);
            }
      }
    }
    if(this->text(1) == "FOG"){
            qWarning(  "update FOG " );
            if(gl != NULL){
              gl->setFocusFog(this);
            }
    }
    if(this->text(1) == "PLAYER"){
      if(objtrans != NULL ){
            qWarning(  "update PLAYER " );
            if(gl != NULL){
              gl->setFocusPlayer(this);
            }
      }
    }
    if(this->text(1) == "SKY"){
      if(sky != NULL ){
            qWarning(  "update SKY " );
            if(gl != NULL){
              gl->setFocusSky(this);
            }
      }
    }
    if(this->text(1) == "SCENE"){
            qWarning(  "update SCENE " );
            if(gl != NULL){
              gl->setFocusScene(this);
            }
    }
    if(this->text(1) == "SOUND"){
            qWarning(  "update SOUND " );
            if(gl != NULL){
              gl->setFocusSound(this);
            }
    }
    if(this->text(1) == "MEDIA"){
            qWarning(  "update MEDIA " );
            if(gl != NULL){
              gl->setFocusMedia(this);
            }
    }
    if(this->text(1) == "SPL"){
            qWarning(  "update SPL " );
            if(gl != NULL){
              gl->setFocusScriptprg(this);
            }
    }
    if(this->text(1) == "JS"){
            qWarning(  "update QTS " );
            if(gl != NULL){
              gl->setFocusScriptprg(this);
            }
    }
    if(this->text(1) == "PYTHON"){
            qWarning(  "update PYTHON " );
            if(gl != NULL){
              gl->setFocusScriptprg(this);
            }
    }
    if(this->text(1) == "SHADER"){
            qWarning(  "update SHADER " );
            if(gl != NULL){
              gl->setFocusScriptprg(this);
            }
    }
    if(this->text(1) == "CURSOR"){
            qWarning(  "update CURSOR " );
            if(gl != NULL){
              gl->setFocusCursor(this);
            }
    }
    if(this->text(1) == "GUI-TXT"){
            qWarning(  "update GUI-TXT " );
            if(gl != NULL){
              gl->setFocusGUIText(this);
            }
    }
    if(this->text(1) == "GUI-INPUT"){
            qWarning(  "update GUI-INPUT " );
            if(gl != NULL){
              gl->setFocusGUIInput(this);
            }
    }
    if(this->text(1) == "GUI-BUTTON"){
            qWarning(  "update GUI-BUTTON " );
            if(gl != NULL){
              gl->setFocusGUIButton(this);
            }
    }
    if(this->text(1) == "GUI-OSBUTTON"){
            qWarning(  "update GUI-OSBUTTON " );
            if(gl != NULL){
              gl->setFocusGUIOSButton(this);
            }
    }
}

void FolderListItem::updateDialog()
{
    if(dialog != NULL){
         dialog->slotGetData(this);
    }
}

// add to this->objtrans  a new item with an object from origitem
int FolderListItem::addTmpObject(FolderListItem * origitem, sgCoord pos, int id)
{
    char mybuff[256];
    QString type = origitem->text(1);
    FolderListItem *Item;
    QString msg = "addTmpObject " + type;
    qWarning( msg.toAscii() );
     FolderListItem *thisItem=new  FolderListItem(this);
     thisItem->setText( 0, "Nonamed");
     thisItem->setText( 1, "TMPOBJ" );
     sprintf(mybuff,"%ld",g_nextid);
     thisItem->setText( 2, mybuff);

     if(gl){
       if( type == "OBJECT"){
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "scax");
         Item->setText( 1, origitem->GetValue( "scax" ));
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "scay");
         Item->setText( 1, origitem->GetValue( "scay" ));
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "scaz");
         Item->setText( 1, origitem->GetValue( "scaz" ));
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );

         if(gl != NULL){
           if(gl->addTmpObject( thisItem, origitem, objtrans , pos, id)){
              // error -> cleanup
              delete thisItem;
              return -1;
           }
         }
       }
     }
     return g_nextid++;
}

void FolderListItem::addObject(const QString & type)
{
    char mybuff[256];
    FolderListItem *Item;
    QString msg = "addObject " + type;
    qWarning( msg.toAscii() );
     FolderListItem *thisItem=new  FolderListItem(this,this);
     thisItem->setText( 0, "Nonamed");
     thisItem->setText( 1, type );
     sprintf(mybuff,"%ld",g_nextid);
     g_nextid++;
     thisItem->setText( 2, mybuff);
     
     if( type == "SCENE"){
         thisItem->setText( 0, "Scene X");

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "wgx");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "wgy");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "wgz");
         Item->setText( 1, "-9.81" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cgplane");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "color_back");
         Item->setText( 1, "01AFFF" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );
     }
     
     if(gl){
       
       if( type == "LAMP"){
         thisItem->setText( 0, "Lamp 1");
         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "sdexpo");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "sdcut");
         Item->setText( 1, "90" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "sconst");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "slinear");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "squadratic");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "color_amb");
         Item->setText( 1, "808080" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "color_dif");
         Item->setText( 1, "FFFFFF" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "color_spe");
         Item->setText( 1, "FFFFFF" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "lensflare");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "headlight");
         Item->setText( 1, "0" );
         
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "spotlight");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "sx");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "sy");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "sz");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "number");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );
       }
       
       if( type == "OBJECT"){

         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "file");
         Item->setText( 1, "error.ac" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "barrier");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );
         if(gl != NULL){
           if(gl->loadObject(thisItem, objtrans)){
              // error -> cleanup
              g_nextid--;
              delete thisItem;
           }
         }
       }

       if( type == "CAMERA"){

         thisItem->setText( 0, "Camera");

//         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "x");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "y");
         Item->setText( 1, "-40" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "z");
         Item->setText( 1, "0" );
/*
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "trax");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tray");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "traz");
         Item->setText( 1, "0" );
*/
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "scax");
         Item->setText( 1, "1" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "scay");
         Item->setText( 1, "1" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "scaz");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "rotx");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "roty");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "rotz");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "number");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "dx");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "dy");
         Item->setText( 1, "0" );
         
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "dz");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "fovw");
         Item->setText( 1, "60" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "fovh");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "near");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "far");
         Item->setText( 1, QString().setNum(MAX_FAR));

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "bind");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "camego");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cam2d");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "camfix");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "camrotw");
         Item->setText( 1, "-90.0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "camhight");
         Item->setText( 1, "5.0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "camradius");
         Item->setText( 1, "-10.0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "file");
         Item->setText( 1, "camera.ac" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );
         if(gl != NULL){
           gl->addCamera(thisItem, objtrans);
         }
       }

       if( type == "FIRE"){
         thisItem->setText( 0, "Fire");
         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "radius");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "height");
         Item->setText( 1, "5" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "speed");
         Item->setText( 1, "2" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "hotcolor");
         Item->setText( 1, "FF3319" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );
         if(gl != NULL){
           gl->addFire(thisItem, objtrans);
         }
       }
       if( type == "PARTSYS"){
         thisItem->setText( 0, "Particle System");
         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addPartSys(thisItem, objtrans);
         }
       }
       if( type == "WAVESYS"){
         thisItem->setText( 0, "Wave System");
         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "size");
         Item->setText( 1, "400" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "texsx");
         Item->setText( 1, "3" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "texsy");
         Item->setText( 1, "3" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "wspeed");
         Item->setText( 1, "10" );
         
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "envmap");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addWaveSys(thisItem, objtrans);
         }
       }
       if( type == "FOG"){
         thisItem->setText( 0, "Fog");
//         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "density");
         Item->setText( 1, "0.02" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "linear");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "exp");
         Item->setText( 1, "1" );
         
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "exp2");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "start");
         Item->setText( 1, "2" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "end");
         Item->setText( 1, "100" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "color");
         Item->setText( 1, "FFFFFF" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "dontcare");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "fastest");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "nicest");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addFog(thisItem);
         }
       }
       if( type == "PLAYER"){

         thisItem->setText( 0, "Player");
         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "file");
         Item->setText( 1, "error.ac" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "online");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "rotsp");
         Item->setText( 1, "100" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "transp");
         Item->setText( 1, "20" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "fmax2");
         Item->setText( 1, "2" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "kbforward");
         Item->setText( 1, "w" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "kbback");
         Item->setText( 1, "s" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "kbleft");
         Item->setText( 1, "a" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "kbright");
         Item->setText( 1, "d" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "kbd");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "joystick");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "ax1");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "ay1");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "ax2");
         Item->setText( 1, "3" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "ay2");
         Item->setText( 1, "4" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "maus");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "network");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "camego");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cam2d");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "camfix");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "kbcamrotadd");
         Item->setText( 1, "4" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "kbcamrotsub");
         Item->setText( 1, "6" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "kbcamradadd");
         Item->setText( 1, "5" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "kbcamradsub");
         Item->setText( 1, "8" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "kbcamheightadd");
         Item->setText( 1, "+" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "kbcamheightsub");
         Item->setText( 1, "-" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "camrotw");
         Item->setText( 1, "-90.0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "camhight");
         Item->setText( 1, "5.0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "camradius");
         Item->setText( 1, "-10.0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addPlayer(thisItem, objtrans);
         }
       }
       if( type == "BARRIER"){
         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "file");
         Item->setText( 1, "minibox.ac" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "viewbox");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addBarrier(thisItem, objtrans);
         }
       }
       if( type == "BODY"){
         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "file");
         Item->setText( 1, "minibox.ac" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "online");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "mass");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "lvx");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "lvy");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "lvz");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "avx");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "avy");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "avz");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "box");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cylinder");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "sphere");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "viewbox");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );
         if(gl != NULL){
           gl->addBody(thisItem, objtrans);
         }
       }
       if( type == "SKY"){

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "file");
         Item->setText( 1, "tuxedo.ac" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "sunroth");
         Item->setText( 1, "40" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "sunrotv");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "moonroth");
         Item->setText( 1, "65" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "moonrotv");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl1on");
         Item->setText( 1, "1" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl2on");
         Item->setText( 1, "1" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl3on");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl1h");
         Item->setText( 1, "2000" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl2h");
         Item->setText( 1, "3000" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl3h");
         Item->setText( 1, "1000" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl1s");
         Item->setText( 1, "50" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl2s");
         Item->setText( 1, "20" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl3s");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl1d");
         Item->setText( 1, "50" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl2d");
         Item->setText( 1, "20" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "cl3d");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addSky(thisItem, objtrans);
         }
       }
       if( type == "SPL"){

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "file");
         Item->setText( 1, "nonamed.spl" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addSpl(thisItem, objtrans);
         }
       }
       if( type == "JS"){

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "file");
         Item->setText( 1, "nonamed.js" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addQTScript(thisItem, objtrans);
         }
       }
       if( type == "PYTHON"){

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "file");
         Item->setText( 1, "nonamed.js" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addPython(thisItem, objtrans);
         }
       }
       if( type == "SHADER"){

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "vfile");
         Item->setText( 1, "nonamed.vert" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "ffile");
         Item->setText( 1, "nonamed.frag" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addShader(thisItem, objtrans);
         }
       }
       if( type == "SOUND"){

         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "file");
         Item->setText( 1, "" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "url");
         Item->setText( 1, "" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "play");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "loop");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "relativexyz");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "viewbox");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "rate");
         Item->setText( 1, "44100" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "stereo");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "bps");
         Item->setText( 1, "16" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "volume");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addSound(thisItem, objtrans);
         }
       }
       if( type == "MEDIA"){

         addCoord(thisItem);

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "path");
         Item->setText( 1, "data" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "file");
         Item->setText( 1, "" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "url");
         Item->setText( 1, "" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "play");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "loop");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "fullscreen");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "viewbox");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "volume");
         Item->setText( 1, "100" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addMedia(thisItem, objtrans);
         }
       }
       if( type == "CURSOR"){
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "mx");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "my");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "type");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "x");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "y");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "z");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addCursor(thisItem);
         }
       }
       if( type == "GUI-TXT"){

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "x");
         Item->setText( 1, "10" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "y");
         Item->setText( 1, "10" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "place");
         Item->setText( 1, "4" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "label");
         Item->setText( 1, "text" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "colorlabel");
         Item->setText( 1, "FFFFFF" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addGUITXT(thisItem);
         }
       }
       if( type == "GUI-INPUT"){

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "x");
         Item->setText( 1, "10" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "y");
         Item->setText( 1, "10" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "place");
         Item->setText( 1, "4" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "maxx");
         Item->setText( 1, "90" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "maxy");
         Item->setText( 1, "30" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "label");
         Item->setText( 1, "text" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "colorlabel");
         Item->setText( 1, "FFFFFF" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addGUIInput(thisItem);
         }
       }
       if( type == "GUI-BUTTON"){

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "x");
         Item->setText( 1, "10" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "y");
         Item->setText( 1, "10" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "place");
         Item->setText( 1, "4" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "maxx");
         Item->setText( 1, "90" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "maxy");
         Item->setText( 1, "30" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "legend");
         Item->setText( 1, "nonamed" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "colorlabel");
         Item->setText( 1, "FFFFFF" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addGUIButton(thisItem);
         }
       }
       if( type == "GUI-OSBUTTON"){

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "x");
         Item->setText( 1, "10" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "y");
         Item->setText( 1, "10" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "place");
         Item->setText( 1, "4" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "maxx");
         Item->setText( 1, "90" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "maxy");
         Item->setText( 1, "30" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "legend");
         Item->setText( 1, "nonamed" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "colorlabel");
         Item->setText( 1, "FFFFFF" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tmpid");
         Item->setText( 1, mybuff );

         if(gl != NULL){
           gl->addGUIOSButton(thisItem);
         }
       }
     }
}

void  FolderListItem::addCoord(FolderListItem *thisItem)
{
         FolderListItem *Item=new  FolderListItem(thisItem);
         Item->setText( 0, "on");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "x");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "y");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "z");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "trax");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "tray");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "traz");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "scax");
         Item->setText( 1, "1" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "scay");
         Item->setText( 1, "1" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "scaz");
         Item->setText( 1, "1" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "rotx");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "roty");
         Item->setText( 1, "0" );
         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "rotz");
         Item->setText( 1, "0" );

         Item=new  FolderListItem(thisItem);
         Item->setText( 0, "number");
         Item->setText( 1, "1" );
}


void  FolderListItem::update(sgCoord  *pos)
{
      if(this->text(1) == "OBJECT"){
        if(this->objtrans != NULL){
          this->objtrans->setTransform ( pos,this->GetValue("scax").toFloat(),this->GetValue("scay").toFloat(),this->GetValue("scaz").toFloat() ) ;
        }
      }
      if(this->text(1) == "TMPOBJ"){
        if(this->objtrans != NULL){
            this->objtrans->setTransform ( pos,this->GetValue("scax").toFloat(),this->GetValue("scay").toFloat(),this->GetValue("scaz").toFloat() ) ;
        }
      }
      if(this->text(1) == "FIRE"){
        if(this->objtrans != NULL){
            this->objtrans->setTransform ( pos ) ;
        }
      }
      if(this->text(1) == "WAVESYS"){
        if(this->objtrans != NULL){
            this->objtrans->setTransform ( pos ) ;
        }
      }
      if(this->text(1) == "PARTSYS"){
        if(this->objtrans != NULL){
            this->objtrans->setTransform ( pos ) ;
        }
      }
      if(this->text(1) == "CAMERA"){
        if(this->objtrans != NULL){
            this->objtrans->setTransform ( pos ) ;
        }
      }
      if(this->text(1) == "BARRIER"){
        if(this->barrier != NULL){
            this->barrier->pos.xyz[0] = pos->xyz[0];
            this->barrier->pos.xyz[1] = pos->xyz[1];
            this->barrier->pos.xyz[2] = pos->xyz[2];

            this->barrier->pos.hpr[0] = pos->hpr[0];
            this->barrier->pos.hpr[1] = pos->hpr[1];
            this->barrier->pos.hpr[2] = pos->hpr[2];
            this->barrier->setPosition ();
          }
      }
      if(this->text(1) == "PLAYER"){
        if( this->player != NULL){
            this->player->pos.xyz[0] = pos->xyz[0];
            this->player->pos.xyz[1] = pos->xyz[1];
            this->player->pos.xyz[2] = pos->xyz[2];

            this->player->pos.hpr[0] = pos->hpr[0];
            this->player->pos.hpr[1] = pos->hpr[1];
            this->player->pos.hpr[2] = pos->hpr[2];
            this->player->SetPosition ();
        }
      }
      if(this->text(1) == "BODY"){
        if(this->body != NULL){
            this->body->pos.xyz[0] = pos->xyz[0];
            this->body->pos.xyz[1] = pos->xyz[1];
            this->body->pos.xyz[2] = pos->xyz[2];

            this->body->pos.hpr[0] = pos->hpr[0];
            this->body->pos.hpr[1] = pos->hpr[1];
            this->body->pos.hpr[2] = pos->hpr[2];
            this->body->setPosition ();
        }
      }
      if(this->text(1) == "LAMP"){

      }
      if(this->text(1) == "CURSOR"){

      }
      if(this->text(1) == "SOUND"){
        if(this->sound != NULL){
             this->sound->setPosition(pos->xyz[0], pos->xyz[1], pos->xyz[2]);
        }
      }
      if(this->text(1) == "MEDIA"){
        if(this->sound != NULL){
             this->sound->setPosition(pos->xyz[0], pos->xyz[1], pos->xyz[2]);
        }
      }
}

void  FolderListItem::getPosition(sgCoord *pos)
{
    sgMat4 m ;

      if(this->text(1) == "OBJECT"){
        if(this->objtrans != NULL){
          this->objtrans->getTransform ( m ) ;
          sgSetCoord  ( pos, m ) ;
        }
      }
      if(this->text(1) == "TMPOBJ"){
        if(this->objtrans != NULL){
          this->objtrans->getTransform ( m ) ;
          sgSetCoord  ( pos, m ) ;
        }
      }
      if(this->text(1) == "FIRE"){
        if(this->objtrans != NULL){
          this->objtrans->getTransform ( m ) ;
          sgSetCoord  ( pos, m ) ;
        }
      }
      if(this->text(1) == "WAVESYS"){
        if(this->objtrans != NULL){
          this->objtrans->getTransform ( m ) ;
          sgSetCoord  ( pos, m ) ;
        }
      }
      if(this->text(1) == "PARTSYS"){
        if(this->objtrans != NULL){
          this->objtrans->getTransform ( m ) ;
          sgSetCoord  ( pos, m ) ;
        }
      }
      if(this->text(1) == "CAMERA"){
        if(this->objtrans != NULL){
          this->objtrans->getTransform ( m ) ;
          sgSetCoord  ( pos, m ) ;
        }
      }
      if(this->text(1) == "BARRIER"){
        if(this->barrier != NULL){
          this->barrier->getPosition (pos);
        }
      }
      if(this->text(1) == "PLAYER"){
        if( this->player != NULL){
          this->player->GetPosition (pos);
        }
      }
      if(this->text(1) == "BODY"){
        if(this->body != NULL){
          this->body->getPosition (pos);
        }
      }
      if(this->text(1) == "LAMP"){

      }
      if(this->text(1) == "CURSOR"){
        if(this->cursor != NULL){
          this->cursor->getPosition(pos);
        }
      }
      if(this->text(1) == "SOUND"){
      }
      if(this->text(1) == "MEDIA"){
      }
}

void  FolderListItem::Rotation ( float h, float p, float r )
{
    sgMat4 m ;
    sgMat4 mh ;

      if(this->text(1) == "OBJECT"){
        sgMakeCoordMat4 ( mh, 0, 0, 0, h, p, r ) ;
        this->objtrans->getTransform ( m ) ;
        sgPreMultMat4  ( m, mh ) ;
        this->objtrans->setTransform ( m ) ;
      }
      if(this->text(1) == "TMPOBJ"){
        sgMakeCoordMat4 ( mh, 0, 0, 0, h, p, r ) ;
        this->objtrans->getTransform ( m ) ;
        sgPreMultMat4  ( m, mh ) ;
        this->objtrans->setTransform ( m ) ;
      }
      if(this->text(1) == "CAMERA"){
        sgMakeCoordMat4 ( mh, 0, 0, 0, h, p, r ) ;
        this->objtrans->getTransform ( m ) ;
        sgPreMultMat4  ( m, mh ) ;
        this->objtrans->setTransform ( m ) ;
      }
      if(this->text(1) == "FIRE"){
        sgMakeCoordMat4 ( mh, 0, 0, 0, h, p, r ) ;
        this->objtrans->getTransform ( m ) ;
        sgPreMultMat4  ( m, mh ) ;
        this->objtrans->setTransform ( m ) ;
      }
      if(this->text(1) == "WAVESYS"){
        sgMakeCoordMat4 ( mh, 0, 0, 0, h, p, r ) ;
        this->objtrans->getTransform ( m ) ;
        sgPreMultMat4  ( m, mh ) ;
        this->objtrans->setTransform ( m ) ;
      }
      if(this->text(1) == "PARTSYS"){
        sgMakeCoordMat4 ( mh, 0, 0, 0, h, p, r ) ;
        this->objtrans->getTransform ( m ) ;
        sgPreMultMat4  ( m, mh ) ;
        this->objtrans->setTransform ( m ) ;
      }
      if(this->text(1) == "BODY"){
          this->body->Rotation(h,p,r);
      }
      if(this->text(1) == "BARRIER"){
          this->barrier->setRotation(h,p,r);
      }
}
