/*****************************************************************************
 * help.cpp - QStarDict, a dictionary application for learning foreign       *
 *            languages                                                      *
 * Copyright (C) 2008-2023 Alexander Rodin                                   *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License along   *
 * with this program; if not, write to the Free Software Foundation, Inc.,   *
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.               *
 *****************************************************************************/

#include "help.h"

#include <QFileInfo>
#include <QLocale>
#include <QDebug>

namespace
{

QString helpFilePathForLocale(const QString &locale)
{
    return QString(QSTARDICT_DOCS_DIR) + "/" + locale + "/index.html";
}

}

namespace QStarDict
{

QString Help::helpFilePath()
{
    QString locale = QLocale::system().name();
    QString path = helpFilePathForLocale(locale);
    if (!QFileInfo(path).exists())
        path = helpFilePathForLocale("en_GB");
    return path;
}

}
