% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ballgown-subset-method.R
\docType{methods}
\name{subset}
\alias{subset}
\alias{subset,ballgown-method}
\title{subset ballgown objects to specific samples or genomic locations}
\usage{
subset(x, ...)

\S4method{subset}{ballgown}(x, cond, genomesubset = TRUE)
}
\arguments{
\item{x}{a ballgown object}

\item{...}{further arguments to generic subset}

\item{cond}{Condition on which to subset. See details.}

\item{genomesubset}{if TRUE, subset \code{x} to a specific part of the 
genome. Otherwise, subset x to only include specific samples. TRUE by 
default.}
}
\value{
a subsetted ballgown object, containing only the regions or samples
  satisfying \code{cond}.
}
\description{
subset ballgown objects to specific samples or genomic locations
}
\details{
To use \code{subset}, you must provide the \code{cond} argument as a
  string representing a logical expression specifying your desired subset.
  The subset expression can either involve column names of
  \code{texpr(x, "all")} (if \code{genomesubset} is \code{TRUE}) or of 
  \code{pData(x)} (if \code{genomesubset} is \code{FALSE}). For example, if
  you wanted a ballgown object for only chromosome 22, you might call 
  \code{subset(x, "chr == 'chr22'")}. (Be sure to handle quotes within
  character strings appropriately).
}
\examples{
data(bg)
bg_twogenes = subset(bg, "gene_id=='XLOC_000454' | gene_id=='XLOC_000024'")
bg_twogenes 
# ballgown instance with 4 assembled transcripts and 20 samples

bg_group0 = subset(bg, "group == 0", genomesubset=FALSE)
bg_group0 
# ballgown instance with 100 assembled transcripts and 10 samples
}
\author{
Alyssa Frazee
}
