% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/335-extractDrugMDE.R
\name{extractDrugMDE}
\alias{extractDrugMDE}
\title{Calculate Molecular Distance Edge (MDE) Descriptors for C, N and O}
\usage{
extractDrugMDE(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{nAtomLAC}.
}
\description{
Calculate Molecular Distance Edge (MDE) Descriptors for C, N and O
}
\details{
This descriptor calculates the 10 molecular distance edge (MDE) descriptor
described in Liu, S., Cao, C., & Li, Z, and in addition it calculates
variants where O and N are considered.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugMDE(mol)
head(dat)}
}
\references{
Liu, S., Cao, C., & Li, Z. (1998).
Approach to estimation and prediction for normal boiling point (NBP)
of alkanes based on a novel molecular distance-edge (MDE) vector, lambda.
Journal of chemical information and computer sciences, 38(3), 387-394.
}
