% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R, R/generics.R
\name{physical.default}
\alias{physical.default}
\alias{physical<-.default}
\alias{virtual.default}
\alias{virtual<-.default}
\alias{print.physical}
\alias{print.virtual}
\alias{PhysVirt}
\alias{physical}
\alias{physical<-}
\alias{virtual}
\alias{virtual<-}
\title{Physical and virtual attributes}
\usage{
\method{physical}{default}(x)

\method{physical}{default}(x) <- value

\method{virtual}{default}(x)

\method{virtual}{default}(x) <- value

\method{print}{physical}(x, ...)

\method{print}{virtual}(x, ...)

physical(x)

physical(x) <- value

virtual(x)

virtual(x) <- value
}
\arguments{
\item{x}{a ff or ram object}

\item{value}{a list with named elements}

\item{...}{further arguments}
}
\value{
\code{physical} and \code{virtual} returns a list with named elements
}
\description{
Compatibility functions (to package ff) for getting and setting physical and
virtual attributes.
}
\details{
ff objects have physical and virtual attributes, which have different
copying semantics: physical attributes are shared between copies of ff
objects while virtual attributes might differ between copies.
\code{\link[ff:as.ff]{ff::as.ram()}} will retain some physical and virtual atrributes in
the ram clone, such that \code{\link[ff:as.ff]{ff::as.ff()}} can restore an ff object
with the same attributes.
}
\examples{

  physical(bit(12))
  virtual(bit(12))
}
\seealso{
\code{\link[ff:physical.ff]{ff::physical.ff()}}, \code{\link[ff:physical.ffdf]{ff::physical.ffdf()}}
}
\author{
Jens Oehlschlägel
}
\keyword{IO}
\keyword{attribute}
\keyword{data}
