% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_url.R
\name{url_build}
\alias{url_build}
\alias{url_parse}
\title{Build and parse URLs}
\usage{
url_build(url, path = NULL, query = NULL)

url_parse(url)
}
\arguments{
\item{url}{(character) a url, length 1}

\item{path}{(character) a path, length 1}

\item{query}{(list) a named list of query parameters}
}
\value{
\code{url_build} returns a character string URL; \code{url_parse}
returns a list with URL components
}
\description{
Build and parse URLs
}
\examples{
url_build("https://httpbin.org")
url_build("https://httpbin.org", "get")
url_build("https://httpbin.org", "post")
url_build("https://httpbin.org", "get", list(foo = "bar"))

url_parse("httpbin.org")
url_parse("http://httpbin.org")
url_parse(url = "https://httpbin.org")
url_parse("https://httpbin.org/get")
url_parse("https://httpbin.org/get?foo=bar")
url_parse("https://httpbin.org/get?foo=bar&stuff=things")
url_parse("https://httpbin.org/get?foo=bar&stuff=things[]")
}
