% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous-material.R
\name{scale_color_material}
\alias{scale_color_material}
\alias{scale_colour_material}
\alias{scale_fill_material}
\title{Material Design Color Palettes}
\usage{
scale_color_material(palette = c("red", "pink", "purple", "deep-purple",
  "indigo", "blue", "light-blue", "cyan", "teal", "green", "light-green",
  "lime", "yellow", "amber", "orange", "deep-orange", "brown", "grey",
  "blue-grey"), alpha = 1, reverse = FALSE, ...)

scale_colour_material(palette = c("red", "pink", "purple", "deep-purple",
  "indigo", "blue", "light-blue", "cyan", "teal", "green", "light-green",
  "lime", "yellow", "amber", "orange", "deep-orange", "brown", "grey",
  "blue-grey"), alpha = 1, reverse = FALSE, ...)

scale_fill_material(palette = c("red", "pink", "purple", "deep-purple",
  "indigo", "blue", "light-blue", "cyan", "teal", "green", "light-green",
  "lime", "yellow", "amber", "orange", "deep-orange", "brown", "grey",
  "blue-grey"), alpha = 1, reverse = FALSE, ...)
}
\arguments{
\item{palette}{Palette type.
There are 19 available options:
\itemize{
\item \code{"red"}
\item \code{"pink"}
\item \code{"purple"}
\item \code{"deep-purple"}
\item \code{"indigo"}
\item \code{"blue"}
\item \code{"light-blue"}
\item \code{"cyan"}
\item \code{"teal"}
\item \code{"green"}
\item \code{"light-green"}
\item \code{"lime"}
\item \code{"yellow"}
\item \code{"amber"}
\item \code{"orange"},
\item \code{"deep-orange"}
\item \code{"brown"}
\item \code{"grey"}
\item \code{"blue-grey"}}
See the \href{https://material.io/guidelines/style/color.html}{material
design color guidelines} for details.}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}

\item{reverse}{Logical. Should the order of the colors be reversed?}

\item{...}{additional parameters for \code{\link[ggplot2]{discrete_scale}}}
}
\description{
See \code{\link{pal_material}} for details.
}
\examples{
library("ggplot2")
library("reshape2")
data("mtcars")

cor = abs(cor(mtcars))
cor_melt = melt(cor)

ggplot(cor_melt,
       aes(x = Var1, y = Var2, fill = value)) +
  geom_tile(colour = "black", size = 0.3) +
  theme_bw() + scale_fill_material("blue-grey")
}
\author{
Nan Xiao <\email{me@nanx.me}> |
<\href{https://nanx.me}{https://nanx.me}>
}
