% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-base64.R
\name{image_uri}
\alias{image_uri}
\title{Encode an image file to a data URI}
\usage{
image_uri(f)
}
\arguments{
\item{f}{the path to the image file}
}
\value{
a character string (the data URI)
}
\description{
This function takes an image file and uses the \pkg{markdown} package to
encode it as a base64 string, which can be used in the \code{img} tag in
HTML.
}
\examples{
uri = image_uri(file.path(R.home("doc"), "html", "logo.jpg"))
cat(sprintf("<img src=\"\%s\" />", uri), file = "logo.html")
if (interactive()) browseURL("logo.html")  # you can check its HTML source
}
\references{
\url{http://en.wikipedia.org/wiki/Data_URI_scheme}
}
\author{
Wush Wu and Yihui Xie
}
