% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkt.R
\name{st_astext}
\alias{st_astext}
\alias{st_asewkt}
\title{Return Well-known Text representation of simple feature geometry}
\usage{
st_astext(x, digits = options("digits"), ..., EWKT = FALSE)

st_asewkt(x, digits = options("digits"))
}
\arguments{
\item{x}{object of class \code{sfg}, \code{sfc}, or \code{sf}}

\item{digits}{integer; number of decimal digits to print}

\item{...}{ignored}

\item{EWKT}{logical; use PostGIS Enhanced WKT (includes srid)}
}
\description{
Return Well-known Text representation of simple feature geometry or coordinate reference system
}
\details{
The returned WKT representation of simple feature geometry conforms to the
\href{https://www.ogc.org/standard/sfa/}{simple features access} specification and extensions (if \code{EWKT = TRUE}),
\href{http://postgis.net/docs/using_postgis_dbmanagement.html#EWKB_EWKT}{known as EWKT}, supported by
PostGIS and other simple features implementations for addition of SRID to a WKT string.

\code{st_asewkt()} returns the Well-Known Text (WKT) representation of
the geometry with SRID meta data.
}
\examples{
library(sf)
pt <- st_sfc(st_point(c(1.0002,2.3030303)), crs = 4326)
st_astext(pt, 3)
st_asewkt(pt, 3)
}
