% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sys_call_stack}
\alias{sys_call_stack}
\alias{sys.function_digest}
\alias{sys.function_nframe}
\alias{sys.function_frame}
\alias{sys.source_file}
\title{System Call Stack Utilities}
\usage{
sys.function_digest(n = NULL)

sys.function_nframe(fun)

sys.function_frame(fun)

sys.source_file()
}
\arguments{
\item{n}{a single frame}

\item{fun}{the function object to find in the call stack.}
}
\description{
System Call Stack Utilities
}
\section{Functions}{
\itemize{
\item \code{sys.function_digest}: computes digest hash for each function in the call stack.

\item \code{sys.function_nframe}: returns the index of the frame that calls a given function.

\item \code{sys.function_frame}: returns the frame that calls a given function.

\item \code{sys.source_file}: returns path to the script that is being sourced either
by \link[base:source]{base::source} or \link[base:sys.source]{base::sys.source}.
}}

