% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adverb-compose.R
\name{compose}
\alias{compose}
\title{Compose multiple functions together to create a new function}
\usage{
compose(..., .dir = c("backward", "forward"))
}
\arguments{
\item{...}{Functions to apply in order (from right to left by
default). Formulas are converted to functions in the usual way.

\link[rlang:dyn-dots]{Dynamic dots} are supported. In particular, if
your functions are stored in a list, you can splice that in with
\verb{!!!}.}

\item{.dir}{If \code{"backward"} (the default), the functions are called
in the reverse order, from right to left, as is conventional in
mathematics. If \code{"forward"}, they are called from left to right.}
}
\value{
A function
}
\description{
Create a new function that is the composition of multiple functions,
i.e. \code{compose(f, g)} is equivalent to \code{function(...) f(g(...))}.
}
\section{Adverbs}{
This function is called an adverb because it modifies the effect of a
function (a verb). If you'd like to include a function created an adverb
in a package, be sure to read \link{faq-adverbs-export}.
}

\examples{
not_null <- compose(`!`, is.null)
not_null(4)
not_null(NULL)

add1 <- function(x) x + 1
compose(add1, add1)(8)

fn <- compose(\(x) paste(x, "foo"), \(x) paste(x, "bar"))
fn("input")

# Lists of functions can be spliced with !!!
fns <- list(
  function(x) paste(x, "foo"),
  \(x) paste(x, "bar")
)
fn <- compose(!!!fns)
fn("input")
}
\seealso{
Other adverbs: 
\code{\link{auto_browse}()},
\code{\link{insistently}()},
\code{\link{negate}()},
\code{\link{partial}()},
\code{\link{possibly}()},
\code{\link{quietly}()},
\code{\link{safely}()},
\code{\link{slowly}()}
}
\concept{adverbs}
