% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend.R
\name{extend}
\alias{extend}
\alias{extend,Satellite-method}
\title{Extend a Satellite object}
\usage{
\S4method{extend}{Satellite}(x, y, subset = TRUE, value = NA)
}
\arguments{
\item{x}{Satellite object.}

\item{y}{Target \code{Extent}, see \code{\link[raster]{extent}}.}

\item{subset}{Logical. If \code{TRUE} (default), all layers but the extended 
ones are being dropped, else the extended layers are appended to the initial
Satellite object.}

\item{value}{Fill value assigned to new cells passed to 
\code{\link[raster]{extend}}, defaults to \code{NA}.}
}
\value{
A Satellite object consisting of extended layers only or, if 
\code{subset = FALSE}, a Satellite object with the extended layers appended.
}
\description{
The function is a wrapper around \code{\link[raster]{extend}} to easily 
extend a Satellite object to a larger spatial extent.
}
\examples{
\dontrun{
## sample data
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC08*.TIF"), full.names = TRUE)
sat <- satellite(files)

## geographic extent of georg-gassmann-stadium (utm 32-n)
ext_ggs <- raster::extent(482606.4, 482781.4, 5627239, 5627489)

## extend satellite object by specified extent
sat_ggs <- extend(sat, ext_ggs)

plot(sat)
plot(sat_ggs)
}
}
\seealso{
This function is a wrapper around \code{\link[raster]{extend}}.
}
