% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_kernel_histogram.R
\name{apply_kernel_histogram}
\alias{apply_kernel_histogram}
\title{apply_kernel_histogram}
\usage{
apply_kernel_histogram(
  fhistogram,
  filter = "circle",
  mask = default_kernel(filter, radius, sigma),
  radius = 2,
  sigma = radius/2,
  threads = 0
)
}
\arguments{
\item{fhistogram}{Matrix or array interpreted as histogram of floating-point values.}

\item{filter}{Use the pre-defined filter, either \code{circle}, \code{square}, \code{gauss}. Defaults to \code{circle}.}

\item{mask}{Custom kernel used for blurring, overrides \code{filter}. Must be a square matrix of odd size.}

\item{radius}{Radius of the kernel (counted without the "middle" pixel"), defaults to 2. The generated kernel matrix will be a square with (2*radius+1) pixels on each side.}

\item{sigma}{Radius of the Gaussian function selected by \code{filter}, defaults to \code{radius/2}.}

\item{threads}{Number of parallel threads (default 0 chooses hardware concurrency).}
}
\value{
2D matrix with the histogram processed by the kernel application.
}
\description{
Apply a kernel to the given histogram.
}
