% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{loadSupport}
\alias{loadSupport}
\title{Load an app's supporting R files}
\usage{
loadSupport(appDir, renv = new.env(parent = globalenv()),
  globalrenv = globalenv())
}
\arguments{
\item{appDir}{The application directory}

\item{renv}{The environmeny in which the files in the \code{R/} directory should
be evaluated.}

\item{globalrenv}{The environment in which \code{global.R} should be evaluated. If
\code{NULL}, \code{global.R} will not be evaluated at all.}
}
\description{
Loads all of the supporting R files of a Shiny application. Specifically,
this function loads any top-level supporting \code{.R} files in the \code{R/} directory
adjacent to the \code{app.R}/\code{server.R}/\code{ui.R} files.
}
\details{
At the moment, this function is "opt-in" and only called if the option
\code{shiny.autoload.r} is set to \code{TRUE}.

The files are sourced in alphabetical order (as determined by
\link{list.files}). \code{global.R} is evaluated before the supporting R files in the
\code{R/} directory.
}
