% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_labels.R
\name{tidy_labels}
\alias{tidy_labels}
\title{Repair value labels}
\usage{
tidy_labels(x, ..., sep = "_", remove = FALSE)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's
\code{\link[tidyselect]{select_helpers}}.
See 'Examples'.}

\item{sep}{String that will be used to separate the suffixed value from the
old label when creating the new value label.}

\item{remove}{Logical, if \code{TRUE}, the original, duplicated value label will
be replaced by the value (i.e. the value is not the suffix of the
value label, but will become the value label itself). The
\code{sep}-argument will be ignored in such cases.}
}
\value{
\code{x}, with "repaired" (unique) value labels for each variable.
}
\description{
Duplicated value labels in variables may cause troubles when
             saving labelled data, or computing cross tabs (cf.
             \code{\link[sjmisc]{flat_table}} or \code{\link[sjPlot]{plot_xtab}}).
             \code{tidy_labels()} repairs duplicated value labels by suffixing
             them with the associated value.
}
\examples{
library(sjmisc)
set.seed(123)
x <- set_labels(
  sample(1:5, size = 20, replace = TRUE),
  labels = c("low" = 1, ".." = 2, ".." = 3, ".." = 4, "high" = 5)
)
frq(x)

z <- tidy_labels(x)
frq(z)

z <- tidy_labels(x, sep = ".")
frq(z)

z <- tidy_labels(x, remove = TRUE)
frq(z)

}
