% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.utilities.R
\name{control.list.accessor}
\alias{control.list.accessor}
\alias{$.control.list}
\title{Named element accessor for ergm control lists}
\usage{
\method{$}{control.list}(object, name)
}
\arguments{
\item{object}{list-coearceable object with elements to be searched}

\item{name}{literal character name of list element to search for and return}
}
\value{
Returns the named list element exactly matching \code{name}, or
\code{NULL} if no matching elements found
}
\description{
Utility method that overrides the standard `$' list accessor to disable
partial matching for ergm \code{control.list} objects
}
\details{
Executes \code{\link[base]{getElement}} instead of \code{\link[base]{$}} so
that element names must match exactly to be returned and partially matching
names will not return the wrong object.
}
\seealso{
see \code{\link{getElement}}
}
\author{
Pavel N. Krivitsky
}
