% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest-legacy.R
\name{nest_legacy}
\alias{nest_legacy}
\alias{unnest_legacy}
\title{Legacy versions of \code{nest()} and \code{unnest()}}
\usage{
nest_legacy(data, ..., .key = "data")

unnest_legacy(data, ..., .drop = NA, .id = NULL, .sep = NULL, .preserve = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Specification of columns to unnest. Use bare variable names or
functions of variables. If omitted, defaults to all list-cols.}

\item{.key}{The name of the new column, as a string or symbol. This argument
is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote strings and
symbols). The name is captured from the expression with \code{\link[rlang:ensym]{rlang::ensym()}}
(note that this kind of interface where symbols do not represent actual
objects is now discouraged in the tidyverse; we support it here for
backward compatibility).}

\item{.drop}{Should additional list columns be dropped? By default,
\code{unnest()} will drop them if unnesting the specified columns requires the
rows to be duplicated.}

\item{.id}{Data frame identifier - if supplied, will create a new column with
name \code{.id}, giving a unique identifier. This is most useful if the list
column is named.}

\item{.sep}{If non-\code{NULL}, the names of unnested data frame columns will
combine the name of the original list-col with the names from the nested
data frame, separated by \code{.sep}.}

\item{.preserve}{Optionally, list-columns to preserve in the output. These
will be duplicated in the same way as atomic vectors. This has
\code{\link[dplyr:select]{dplyr::select()}} semantics so you can preserve multiple variables with
\code{.preserve = c(x, y)} or \code{.preserve = starts_with("list")}.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("retired")}

tidyr 1.0.0 introduced a new syntax for \code{\link[=nest]{nest()}} and \code{\link[=unnest]{unnest()}}. The majority
of existing usage should be automatically translated to the new syntax with a
warning. However, if you need to quickly roll back to the previous behaviour,
these functions provide the previous interface. To make old code work as is,
add the following code to the top of your script:\preformatted{library(tidyr)
nest <- nest_legacy
unnest <- unnest_legacy
}
}
\examples{
# Nest and unnest are inverses
df <- data.frame(x = c(1, 1, 2), y = 3:1)
df \%>\% nest_legacy(y)
df \%>\% nest_legacy(y) \%>\% unnest_legacy()

# nesting -------------------------------------------------------------------
as_tibble(iris) \%>\% nest_legacy(-Species)
as_tibble(chickwts) \%>\% nest_legacy(weight)

# unnesting -----------------------------------------------------------------
df <- tibble(
  x = 1:2,
  y = list(
    tibble(z = 1),
    tibble(z = 3:4)
  )
)
df \%>\% unnest_legacy(y)

# You can also unnest multiple columns simultaneously
df <- tibble(
  a = list(c("a", "b"), "c"),
  b = list(1:2, 3),
  c = c(11, 22)
)
df \%>\% unnest_legacy(a, b)
# If you omit the column names, it'll unnest all list-cols
df \%>\% unnest_legacy()
}
