;; $Id: refdblib.dsl,v 1.3.4.1 2006/03/26 00:41:24 mhoenicka Exp $
;; Common definitions for the refdb html and print stylesheets

;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;; library functions (not refdb-specific)

(define (node-list-filter-by-attribute-token nodelist attname attvalue)
  ;; REFENTRY node-list-filter-by-attribute-token
  ;; PURP Returns the elements in 'nodelist' with an attribute "attname"
  ;; that has the value "attvalue"
  ;; DESC
  ;; Returns the selected elements in 'nodelist'
  ;; ARGS
  ;; ARG 'nodelist'
  ;; the nodelist which shall be filtered
  ;; /ARG
  ;; ARG 'attname'
  ;; the name of the attribute to check
  ;; /ARG
  ;; ARG 'attvalue'
  ;; the value of the attribute
  ;; /ARGS
  ;; /DESC
  ;; /REFENTRY
  (let loop ((result (empty-node-list)) (nl nodelist))
    (if (node-list-empty? nl)
	result
	(if (equal? (normalize (attribute-string attname (node-list-first nl))) attvalue)
	    (loop (node-list result (node-list-first nl))
		  (node-list-rest nl))
	    (loop result (node-list-rest nl))))))


;;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;; refdb-specific functions

(define (refdb-symbol-value varname)
  ;; REFENTRY refdb-symbol-value
  ;; PURP returns the value of a variable with the name of a given string
  ;; DESC
  ;; uses the associative list refdb-styleparams to access the values
  ;; of the above variables by their names in a string
  ;; ARGS
  ;; ARG 'varname'
  ;; the string that holds the name of a variable
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-symbol-value 'foo) where foo is a string. This will return
  ;; the value of the variable foo
  ;; /EXAMPLE
  ;; /REFENTRY
  (let ((a (assoc (string->symbol varname) refdb-styleparams)))
    (if a (cdr a) #f)))

(define (refdb-getstyle token)
  ;; REFENTRY refdb-getstyle
  ;; PURP retrieves style information based on token and the reference type
  ;; DESC
  ;; determines reference type and returns the proper style information
  ;; ARGS
  ;; ARG 'token'
  ;; this is roughly equivalent to an element, but the name of the token
  ;; stems from the name in the database, not from the DocBook element
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-getstyle "VOLUMESTYLE") will return "BOLD" if we are in a
  ;; "bibliomixed" element with the role attribute "JOUR" and the variable
  ;; "JOURVOLUMESTYLE" has the value "BOLD"
  ;; /EXAMPLE
  ;; /REFENTRY
  (let* ((intextrole (normalize (inherited-attribute-string (normalize "role") (ancestor (normalize "bibliomset") (current-node)))))
	 (reftype (normalize (attribute-string
			      (normalize "role") 
			      (ancestor (normalize "bibliomixed")))))
	 (var (cond ((equal? intextrole (normalize "multixref"))
		     (string-append "INTEXT" token))
		    ((equal? intextrole (normalize "bibliography"))
		     (string-append reftype token))
		    (else
		     (if (equal? intextrole (normalize "intextsq"))
			 (string-append "INTEXT" token)
			 (string-append intextrole token))))))
    (refdb-symbol-value var)))



(define (refdb-getfontweight token)
  ;; REFENTRY refdb-getfontweight
  ;; PURP retrieves the font weight
  ;; DESC
  ;; determines the font weight based on the requested token and the context
  ;; ARGS
  ;; ARG 'token'
  ;; this is roughly equivalent to an element, but the name of the token
  ;; stems from the name in the database, not from the DocBook element
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-getfontweight "VOLUMESTYLE") will return "'bold" if we are in a
  ;; "bibliomixed" element with the role attribute "JOUR" and the variable
  ;; "JOURVOLUMESTYLE" has the value "BOLD"
  ;; /EXAMPLE
  ;; /REFENTRY
  (let* ((weight (refdb-getstyle token)))
    (cond ((equal? weight "BOLD") 'bold)
	  ((equal? weight "BOLDITALIC") 'bold)
	  ((equal? weight "BOLDULINE") 'bold)
	  ((equal? weight "BOLDITULINE") 'bold)
	  (else 'medium))))


(define (refdb-getfontposture token)
  ;; REFENTRY refdb-getfontposture
  ;; PURP retrieves the font posture
  ;; DESC
  ;; determines the font posture based on the requested token and the context
  ;; ARGS
  ;; ARG 'token'
  ;; this is roughly equivalent to an element, but the name of the token
  ;; stems from the name in the database, not from the DocBook element
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-getfontposture "VOLUMESTYLE") will return "'italic" if we are in a
  ;; "bibliomixed" element with the role attribute "JOUR" and the variable
  ;; "JOURVOLUMESTYLE" has the value "ITALIC"
  ;; /EXAMPLE
  ;; /REFENTRY
  (let* ((posture (refdb-getstyle token)))
    (cond ((equal? posture "ITALIC") 'italic)
	  ((equal? posture "ITULINE") 'italic)
	  ((equal? posture "BOLDITALIC") 'italic)
	  ((equal? posture "BOLDITULINE") 'italic)
	  (else 'upright))))

(define (refdb-underline? token)
  ;; REFENTRY refdb-getfontposture
  ;; PURP retrieves the font posture
  ;; DESC
  ;; determines the font posture based on the requested token and the context
  ;; ARGS
  ;; ARG 'token'
  ;; this is roughly equivalent to an element, but the name of the token
  ;; stems from the name in the database, not from the DocBook element
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-getfontposture "VOLUMESTYLE") will return "'italic" if we are in a
  ;; "bibliomixed" element with the role attribute "JOUR" and the variable
  ;; "JOURVOLUMESTYLE" has the value "ITALIC"
  ;; /EXAMPLE
  ;; /REFENTRY
  (let* ((underline (refdb-getstyle token)))
    (cond ((equal? underline "ULINE") #t)
	  ((equal? underline "ITULINE") #t)
	  ((equal? underline "BOLDULINE") #t)
	  ((equal? underline "BOLDITULINE") #t)
	  (else #f))))

(define (refdb-getsizefactor token)
  ;; REFENTRY refdb-getsizefactor
  ;; PURP retrieves the size factor (for sub/superscript)
  ;; DESC
  ;; determines the font size factor based on the requested token
  ;; ARGS
  ;; ARG 'token'
  ;; this is roughly equivalent to an element, but the name of the token
  ;; stems from the name in the database, not from the DocBook element
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-getsizefactor "VOLUMESTYLE") will return "0.6" if we are in a
  ;; "bibliomixed" element with the role attribute "JOUR" and the variable
  ;; "JOURVOLUMESTYLE" has the value "SUB"
  ;; /EXAMPLE
  ;; /REFENTRY
  (let* ((sizefactor (refdb-getstyle token)))
    (cond ((equal? sizefactor "SUB") %ss-size-factor%)
	  ((equal? sizefactor "SUPER") %ss-size-factor%)
	  (else 1))))













