#![allow(
    dead_code,
    non_upper_case_globals,
    unused_assignments,
    unused_parens,
    while_true,
    clippy::assign_op_pattern,
    clippy::collapsible_if,
    clippy::comparison_chain,
    clippy::double_parens,
    clippy::unnecessary_cast,
    clippy::single_match,
    clippy::never_loop
)]

use core::cell::Cell;

use super::buffer::{hb_buffer_t, HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE};
use super::hb_glyph_info_t;
use super::machine_cursor::MachineCursor;
use super::ot_layout::*;
use super::ot_shaper_use::category;

static _use_syllable_machine_actions: [i8; 47] = [
    0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1,
    14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 19, 1, 20, 1, 21, 0, 0,
];
static _use_syllable_machine_key_offsets: [i16; 127] = [
    0, 2, 39, 67, 93, 107, 119, 126, 132, 137, 140, 142, 143, 154, 164, 173, 175, 183, 200, 216,
    231, 245, 265, 278, 297, 315, 336, 361, 363, 376, 379, 381, 407, 421, 433, 440, 446, 451, 454,
    456, 457, 468, 478, 487, 489, 497, 514, 530, 545, 559, 579, 592, 611, 629, 650, 675, 677, 679,
    692, 694, 696, 724, 750, 764, 776, 783, 789, 794, 797, 799, 800, 811, 821, 830, 832, 840, 857,
    873, 888, 902, 922, 935, 954, 972, 993, 1018, 1020, 1022, 1035, 1061, 1075, 1087, 1094, 1100,
    1105, 1108, 1110, 1111, 1122, 1132, 1141, 1143, 1151, 1168, 1184, 1199, 1213, 1233, 1246, 1265,
    1283, 1304, 1329, 1331, 1344, 1346, 1348, 1379, 1382, 1384, 1386, 1391, 1395, 1398, 1402, 0, 0,
];
static _use_syllable_machine_trans_keys: [u8; 1434] = [
    49, 51, 0, 1, 4, 5, 11, 12, 13, 14, 18, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
    37, 38, 39, 41, 42, 43, 45, 46, 47, 49, 51, 53, 44, 48, 11, 12, 14, 22, 23, 24, 25, 26, 27, 28,
    29, 30, 31, 32, 33, 34, 35, 37, 38, 39, 41, 42, 45, 46, 47, 53, 44, 48, 11, 12, 14, 22, 23, 24,
    25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 37, 38, 39, 45, 46, 47, 53, 44, 48, 1, 14, 23, 24,
    25, 26, 37, 38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 14, 24,
    25, 26, 45, 46, 47, 14, 25, 26, 45, 46, 47, 14, 26, 45, 46, 47, 14, 45, 46, 14, 46, 14, 14, 24,
    25, 26, 37, 38, 39, 45, 46, 47, 48, 14, 24, 25, 26, 38, 39, 45, 46, 47, 48, 14, 24, 25, 26, 39,
    45, 46, 47, 48, 1, 14, 14, 24, 25, 26, 45, 46, 47, 48, 14, 22, 23, 24, 25, 26, 33, 34, 35, 37,
    38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 33, 34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 14,
    23, 24, 25, 26, 34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 35, 37, 38, 39, 45,
    46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 28, 29, 33, 34, 35, 37, 38, 39, 45, 46, 47, 48, 53,
    14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 29, 33, 34, 35,
    37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 33, 34, 35, 37, 38, 39, 45, 46, 47,
    48, 53, 12, 14, 22, 23, 24, 25, 26, 27, 28, 29, 33, 34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 11,
    12, 14, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 34, 35, 37, 38, 39, 45, 46, 47, 53, 44, 48,
    1, 14, 1, 14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 14, 41, 42, 14, 42, 11, 12, 14, 22,
    23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 37, 38, 39, 44, 45, 46, 47, 48, 53, 1, 14,
    23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48,
    14, 24, 25, 26, 45, 46, 47, 14, 25, 26, 45, 46, 47, 14, 26, 45, 46, 47, 14, 45, 46, 14, 46, 14,
    14, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 14, 24, 25, 26, 38, 39, 45, 46, 47, 48, 14, 24, 25,
    26, 39, 45, 46, 47, 48, 1, 14, 14, 24, 25, 26, 45, 46, 47, 48, 14, 22, 23, 24, 25, 26, 33, 34,
    35, 37, 38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 33, 34, 35, 37, 38, 39, 45, 46, 47, 48,
    53, 14, 23, 24, 25, 26, 34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 35, 37, 38,
    39, 45, 46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 28, 29, 33, 34, 35, 37, 38, 39, 45, 46, 47,
    48, 53, 14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 29, 33,
    34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 33, 34, 35, 37, 38, 39, 45,
    46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 27, 28, 29, 33, 34, 35, 37, 38, 39, 45, 46, 47, 48,
    53, 11, 12, 14, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 34, 35, 37, 38, 39, 44, 45, 46, 47,
    48, 53, 1, 14, 1, 14, 1, 14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 13, 14, 4, 14, 11, 12,
    14, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 37, 38, 39, 41, 42, 44, 45, 46, 47,
    48, 53, 11, 12, 14, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 37, 38, 39, 44, 45,
    46, 47, 48, 53, 1, 14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 37,
    38, 39, 45, 46, 47, 48, 14, 24, 25, 26, 45, 46, 47, 14, 25, 26, 45, 46, 47, 14, 26, 45, 46, 47,
    14, 45, 46, 14, 46, 14, 14, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 14, 24, 25, 26, 38, 39, 45,
    46, 47, 48, 14, 24, 25, 26, 39, 45, 46, 47, 48, 1, 14, 14, 24, 25, 26, 45, 46, 47, 48, 14, 22,
    23, 24, 25, 26, 33, 34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 33, 34, 35, 37,
    38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 14, 23,
    24, 25, 26, 35, 37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 28, 29, 33, 34, 35,
    37, 38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22,
    23, 24, 25, 26, 29, 33, 34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 33,
    34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 27, 28, 29, 33, 34, 35, 37,
    38, 39, 45, 46, 47, 48, 53, 11, 12, 14, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 34, 35, 37,
    38, 39, 44, 45, 46, 47, 48, 53, 1, 14, 1, 14, 1, 14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47,
    48, 11, 12, 14, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 37, 38, 39, 45, 46, 47,
    53, 44, 48, 1, 14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 37, 38,
    39, 45, 46, 47, 48, 14, 24, 25, 26, 45, 46, 47, 14, 25, 26, 45, 46, 47, 14, 26, 45, 46, 47, 14,
    45, 46, 14, 46, 14, 14, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 14, 24, 25, 26, 38, 39, 45, 46,
    47, 48, 14, 24, 25, 26, 39, 45, 46, 47, 48, 1, 14, 14, 24, 25, 26, 45, 46, 47, 48, 14, 22, 23,
    24, 25, 26, 33, 34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 33, 34, 35, 37, 38,
    39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 14, 23, 24,
    25, 26, 35, 37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 28, 29, 33, 34, 35, 37,
    38, 39, 45, 46, 47, 48, 53, 14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22, 23,
    24, 25, 26, 29, 33, 34, 35, 37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 33, 34,
    35, 37, 38, 39, 45, 46, 47, 48, 53, 12, 14, 22, 23, 24, 25, 26, 27, 28, 29, 33, 34, 35, 37, 38,
    39, 45, 46, 47, 48, 53, 11, 12, 14, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 34, 35, 37, 38,
    39, 45, 46, 47, 53, 44, 48, 1, 14, 1, 14, 23, 24, 25, 26, 37, 38, 39, 45, 46, 47, 48, 4, 14,
    13, 14, 1, 5, 11, 12, 13, 14, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 37, 38,
    39, 41, 42, 45, 46, 47, 53, 44, 48, 14, 41, 42, 14, 42, 1, 5, 14, 50, 52, 54, 55, 14, 49, 50,
    51, 14, 50, 52, 14, 50, 52, 54, 11, 12, 14, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
    35, 37, 38, 39, 41, 42, 45, 46, 47, 49, 51, 53, 44, 48, 0, 0,
];
static _use_syllable_machine_single_lengths: [i8; 127] = [
    2, 35, 26, 24, 14, 12, 7, 6, 5, 3, 2, 1, 11, 10, 9, 2, 8, 17, 16, 15, 14, 20, 13, 19, 18, 21,
    23, 2, 13, 3, 2, 26, 14, 12, 7, 6, 5, 3, 2, 1, 11, 10, 9, 2, 8, 17, 16, 15, 14, 20, 13, 19, 18,
    21, 25, 2, 2, 13, 2, 2, 28, 26, 14, 12, 7, 6, 5, 3, 2, 1, 11, 10, 9, 2, 8, 17, 16, 15, 14, 20,
    13, 19, 18, 21, 25, 2, 2, 13, 24, 14, 12, 7, 6, 5, 3, 2, 1, 11, 10, 9, 2, 8, 17, 16, 15, 14,
    20, 13, 19, 18, 21, 23, 2, 13, 2, 2, 29, 3, 2, 2, 5, 2, 3, 4, 28, 0, 0,
];
static _use_syllable_machine_range_lengths: [i8; 127] = [
    0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
];
static _use_syllable_machine_index_offsets: [i16; 127] = [
    0, 3, 40, 68, 94, 109, 122, 130, 137, 143, 147, 150, 152, 164, 175, 185, 188, 197, 215, 232,
    248, 263, 284, 298, 318, 337, 359, 384, 387, 401, 405, 408, 435, 450, 463, 471, 478, 484, 488,
    491, 493, 505, 516, 526, 529, 538, 556, 573, 589, 604, 625, 639, 659, 678, 700, 726, 729, 732,
    746, 749, 752, 781, 808, 823, 836, 844, 851, 857, 861, 864, 866, 878, 889, 899, 902, 911, 929,
    946, 962, 977, 998, 1012, 1032, 1051, 1073, 1099, 1102, 1105, 1119, 1145, 1160, 1173, 1181,
    1188, 1194, 1198, 1201, 1203, 1215, 1226, 1236, 1239, 1248, 1266, 1283, 1299, 1314, 1335, 1349,
    1369, 1388, 1410, 1435, 1438, 1452, 1455, 1458, 1489, 1493, 1496, 1499, 1505, 1509, 1513, 1518,
    0, 0,
];
static _use_syllable_machine_cond_targs: [i8; 1675] = [
    120, 0, 1, 2, 31, 58, 60, 88, 89, 114, 1, 116, 102, 90, 91, 92, 93, 106, 108, 109, 110, 88,
    111, 103, 104, 105, 97, 98, 99, 117, 118, 119, 94, 95, 96, 120, 124, 113, 112, 1, 3, 4, 1, 17,
    5, 6, 7, 8, 21, 23, 24, 25, 3, 26, 18, 19, 20, 12, 13, 14, 29, 30, 9, 10, 11, 28, 27, 1, 3, 4,
    1, 17, 5, 6, 7, 8, 21, 23, 24, 25, 3, 26, 18, 19, 20, 12, 13, 14, 9, 10, 11, 28, 27, 1, 3, 1,
    5, 6, 7, 8, 12, 13, 14, 9, 10, 11, 15, 5, 1, 1, 5, 6, 7, 8, 12, 13, 14, 9, 10, 11, 15, 1, 1, 6,
    7, 8, 9, 10, 11, 1, 1, 7, 8, 9, 10, 11, 1, 1, 8, 9, 10, 11, 1, 1, 9, 10, 1, 1, 10, 1, 1, 1, 1,
    6, 7, 8, 12, 13, 14, 9, 10, 11, 15, 1, 1, 6, 7, 8, 13, 14, 9, 10, 11, 15, 1, 1, 6, 7, 8, 14, 9,
    10, 11, 15, 1, 16, 1, 1, 1, 6, 7, 8, 9, 10, 11, 15, 1, 1, 17, 5, 6, 7, 8, 18, 19, 20, 12, 13,
    14, 9, 10, 11, 15, 5, 1, 1, 5, 6, 7, 8, 18, 19, 20, 12, 13, 14, 9, 10, 11, 15, 5, 1, 1, 5, 6,
    7, 8, 19, 20, 12, 13, 14, 9, 10, 11, 15, 5, 1, 1, 5, 6, 7, 8, 20, 12, 13, 14, 9, 10, 11, 15, 5,
    1, 22, 1, 17, 5, 6, 7, 8, 23, 24, 18, 19, 20, 12, 13, 14, 9, 10, 11, 15, 5, 1, 1, 5, 6, 7, 8,
    12, 13, 14, 9, 10, 11, 15, 5, 1, 22, 1, 17, 5, 6, 7, 8, 24, 18, 19, 20, 12, 13, 14, 9, 10, 11,
    15, 5, 1, 22, 1, 17, 5, 6, 7, 8, 18, 19, 20, 12, 13, 14, 9, 10, 11, 15, 5, 1, 22, 1, 17, 5, 6,
    7, 8, 21, 23, 24, 18, 19, 20, 12, 13, 14, 9, 10, 11, 15, 5, 1, 3, 4, 1, 17, 5, 6, 7, 8, 21, 23,
    24, 25, 26, 18, 19, 20, 12, 13, 14, 9, 10, 11, 28, 27, 1, 3, 1, 1, 3, 1, 5, 6, 7, 8, 12, 13,
    14, 9, 10, 11, 15, 1, 1, 29, 30, 1, 1, 30, 1, 31, 32, 1, 45, 33, 34, 35, 36, 49, 51, 52, 53,
    31, 54, 46, 47, 48, 40, 41, 42, 55, 37, 38, 39, 56, 57, 1, 31, 1, 33, 34, 35, 36, 40, 41, 42,
    37, 38, 39, 43, 33, 1, 1, 33, 34, 35, 36, 40, 41, 42, 37, 38, 39, 43, 1, 1, 34, 35, 36, 37, 38,
    39, 1, 1, 35, 36, 37, 38, 39, 1, 1, 36, 37, 38, 39, 1, 1, 37, 38, 1, 1, 38, 1, 1, 1, 1, 34, 35,
    36, 40, 41, 42, 37, 38, 39, 43, 1, 1, 34, 35, 36, 41, 42, 37, 38, 39, 43, 1, 1, 34, 35, 36, 42,
    37, 38, 39, 43, 1, 44, 1, 1, 1, 34, 35, 36, 37, 38, 39, 43, 1, 1, 45, 33, 34, 35, 36, 46, 47,
    48, 40, 41, 42, 37, 38, 39, 43, 33, 1, 1, 33, 34, 35, 36, 46, 47, 48, 40, 41, 42, 37, 38, 39,
    43, 33, 1, 1, 33, 34, 35, 36, 47, 48, 40, 41, 42, 37, 38, 39, 43, 33, 1, 1, 33, 34, 35, 36, 48,
    40, 41, 42, 37, 38, 39, 43, 33, 1, 50, 1, 45, 33, 34, 35, 36, 51, 52, 46, 47, 48, 40, 41, 42,
    37, 38, 39, 43, 33, 1, 1, 33, 34, 35, 36, 40, 41, 42, 37, 38, 39, 43, 33, 1, 50, 1, 45, 33, 34,
    35, 36, 52, 46, 47, 48, 40, 41, 42, 37, 38, 39, 43, 33, 1, 50, 1, 45, 33, 34, 35, 36, 46, 47,
    48, 40, 41, 42, 37, 38, 39, 43, 33, 1, 50, 1, 45, 33, 34, 35, 36, 49, 51, 52, 46, 47, 48, 40,
    41, 42, 37, 38, 39, 43, 33, 1, 31, 32, 1, 45, 33, 34, 35, 36, 49, 51, 52, 53, 54, 46, 47, 48,
    40, 41, 42, 55, 37, 38, 39, 56, 57, 1, 31, 1, 1, 31, 1, 1, 31, 1, 33, 34, 35, 36, 40, 41, 42,
    37, 38, 39, 43, 1, 59, 1, 1, 58, 1, 1, 61, 62, 1, 75, 63, 64, 65, 66, 79, 81, 82, 83, 61, 84,
    76, 77, 78, 70, 71, 72, 29, 30, 85, 67, 68, 69, 86, 87, 1, 61, 62, 1, 75, 63, 64, 65, 66, 79,
    81, 82, 83, 61, 84, 76, 77, 78, 70, 71, 72, 85, 67, 68, 69, 86, 87, 1, 61, 1, 63, 64, 65, 66,
    70, 71, 72, 67, 68, 69, 73, 63, 1, 1, 63, 64, 65, 66, 70, 71, 72, 67, 68, 69, 73, 1, 1, 64, 65,
    66, 67, 68, 69, 1, 1, 65, 66, 67, 68, 69, 1, 1, 66, 67, 68, 69, 1, 1, 67, 68, 1, 1, 68, 1, 1,
    1, 1, 64, 65, 66, 70, 71, 72, 67, 68, 69, 73, 1, 1, 64, 65, 66, 71, 72, 67, 68, 69, 73, 1, 1,
    64, 65, 66, 72, 67, 68, 69, 73, 1, 74, 1, 1, 1, 64, 65, 66, 67, 68, 69, 73, 1, 1, 75, 63, 64,
    65, 66, 76, 77, 78, 70, 71, 72, 67, 68, 69, 73, 63, 1, 1, 63, 64, 65, 66, 76, 77, 78, 70, 71,
    72, 67, 68, 69, 73, 63, 1, 1, 63, 64, 65, 66, 77, 78, 70, 71, 72, 67, 68, 69, 73, 63, 1, 1, 63,
    64, 65, 66, 78, 70, 71, 72, 67, 68, 69, 73, 63, 1, 80, 1, 75, 63, 64, 65, 66, 81, 82, 76, 77,
    78, 70, 71, 72, 67, 68, 69, 73, 63, 1, 1, 63, 64, 65, 66, 70, 71, 72, 67, 68, 69, 73, 63, 1,
    80, 1, 75, 63, 64, 65, 66, 82, 76, 77, 78, 70, 71, 72, 67, 68, 69, 73, 63, 1, 80, 1, 75, 63,
    64, 65, 66, 76, 77, 78, 70, 71, 72, 67, 68, 69, 73, 63, 1, 80, 1, 75, 63, 64, 65, 66, 79, 81,
    82, 76, 77, 78, 70, 71, 72, 67, 68, 69, 73, 63, 1, 61, 62, 1, 75, 63, 64, 65, 66, 79, 81, 82,
    83, 84, 76, 77, 78, 70, 71, 72, 85, 67, 68, 69, 86, 87, 1, 61, 1, 1, 61, 1, 1, 61, 1, 63, 64,
    65, 66, 70, 71, 72, 67, 68, 69, 73, 1, 88, 89, 1, 102, 90, 91, 92, 93, 106, 108, 109, 110, 88,
    111, 103, 104, 105, 97, 98, 99, 94, 95, 96, 113, 112, 1, 88, 1, 90, 91, 92, 93, 97, 98, 99, 94,
    95, 96, 100, 90, 1, 1, 90, 91, 92, 93, 97, 98, 99, 94, 95, 96, 100, 1, 1, 91, 92, 93, 94, 95,
    96, 1, 1, 92, 93, 94, 95, 96, 1, 1, 93, 94, 95, 96, 1, 1, 94, 95, 1, 1, 95, 1, 1, 1, 1, 91, 92,
    93, 97, 98, 99, 94, 95, 96, 100, 1, 1, 91, 92, 93, 98, 99, 94, 95, 96, 100, 1, 1, 91, 92, 93,
    99, 94, 95, 96, 100, 1, 101, 1, 1, 1, 91, 92, 93, 94, 95, 96, 100, 1, 1, 102, 90, 91, 92, 93,
    103, 104, 105, 97, 98, 99, 94, 95, 96, 100, 90, 1, 1, 90, 91, 92, 93, 103, 104, 105, 97, 98,
    99, 94, 95, 96, 100, 90, 1, 1, 90, 91, 92, 93, 104, 105, 97, 98, 99, 94, 95, 96, 100, 90, 1, 1,
    90, 91, 92, 93, 105, 97, 98, 99, 94, 95, 96, 100, 90, 1, 107, 1, 102, 90, 91, 92, 93, 108, 109,
    103, 104, 105, 97, 98, 99, 94, 95, 96, 100, 90, 1, 1, 90, 91, 92, 93, 97, 98, 99, 94, 95, 96,
    100, 90, 1, 107, 1, 102, 90, 91, 92, 93, 109, 103, 104, 105, 97, 98, 99, 94, 95, 96, 100, 90,
    1, 107, 1, 102, 90, 91, 92, 93, 103, 104, 105, 97, 98, 99, 94, 95, 96, 100, 90, 1, 107, 1, 102,
    90, 91, 92, 93, 106, 108, 109, 103, 104, 105, 97, 98, 99, 94, 95, 96, 100, 90, 1, 88, 89, 1,
    102, 90, 91, 92, 93, 106, 108, 109, 110, 111, 103, 104, 105, 97, 98, 99, 94, 95, 96, 113, 112,
    1, 88, 1, 1, 88, 1, 90, 91, 92, 93, 97, 98, 99, 94, 95, 96, 100, 1, 115, 1, 1, 114, 1, 1, 31,
    31, 88, 89, 114, 1, 102, 90, 91, 92, 93, 106, 108, 109, 110, 88, 111, 103, 104, 105, 97, 98,
    99, 117, 118, 94, 95, 96, 113, 112, 1, 1, 117, 118, 1, 1, 118, 1, 31, 31, 1, 1, 121, 122, 122,
    123, 1, 1, 120, 121, 1, 1, 121, 122, 1, 1, 121, 122, 122, 1, 3, 4, 1, 17, 5, 6, 7, 8, 21, 23,
    24, 25, 3, 26, 18, 19, 20, 12, 13, 14, 29, 30, 9, 10, 11, 120, 0, 28, 27, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
];
static _use_syllable_machine_cond_actions: [i8; 1675] = [
    0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 0, 23, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 35, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    35, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 17,
    0, 0, 0, 0, 0, 0, 35, 17, 0, 0, 0, 0, 0, 35, 17, 0, 0, 0, 0, 35, 17, 0, 0, 35, 17, 0, 35, 17,
    35, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 17, 0, 0, 0, 0, 0,
    0, 0, 0, 35, 0, 17, 35, 17, 0, 0, 0, 0, 0, 0, 0, 35, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 35, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 17, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 35, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 0, 17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 0, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 35, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 0, 0, 17,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 0, 17, 35, 0, 17, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 35, 17, 0, 0, 35, 17, 0, 35, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0,
    0, 29, 11, 0, 0, 29, 11, 0, 29, 11, 29, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 9, 27, 11, 0, 0, 0, 0, 0, 0, 0, 29, 11,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 29, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 29, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0,
    11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 29, 0, 7, 25, 0, 9, 27, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 15, 33, 0, 13,
    31, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0,
    0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 11, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 0,
    29, 11, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 29, 11, 0, 0, 29, 11, 0, 29, 11, 29, 11, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 9,
    27, 11, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29,
    11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 29, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 11,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 7, 25, 0, 9, 27, 0, 11, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 29, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39,
    0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 21, 0,
    0, 0, 0, 0, 0, 39, 21, 0, 0, 0, 0, 0, 39, 21, 0, 0, 0, 0, 39, 21, 0, 0, 39, 21, 0, 39, 21, 39,
    21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 21, 0, 0, 0, 0, 0, 0,
    0, 0, 39, 0, 21, 39, 21, 0, 0, 0, 0, 0, 0, 0, 39, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 39, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 39, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 0, 21, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 0, 21, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 39, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 0, 0, 21, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 0, 21, 39, 0, 21, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 39, 0, 21, 39, 0, 21, 39, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 21, 0, 0, 39, 21, 0, 39, 0, 0, 41, 19, 0, 0, 0,
    0, 37, 19, 0, 0, 37, 19, 0, 0, 37, 19, 0, 0, 0, 37, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 43, 0, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 25, 27, 29, 33, 31,
    29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 25, 27, 29, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
    39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 41, 37, 37, 37, 37, 35, 0, 0,
];
static _use_syllable_machine_to_state_actions: [i8; 127] = [
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
];
static _use_syllable_machine_from_state_actions: [i8; 127] = [
    0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
];
static _use_syllable_machine_eof_trans: [i16; 127] = [
    1549, 1550, 1551, 1552, 1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560, 1561, 1562, 1563, 1564,
    1565, 1566, 1567, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580,
    1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1595, 1596,
    1597, 1598, 1599, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611, 1612,
    1613, 1614, 1615, 1616, 1617, 1618, 1619, 1620, 1621, 1622, 1623, 1624, 1625, 1626, 1627, 1628,
    1629, 1630, 1631, 1632, 1633, 1634, 1635, 1636, 1637, 1638, 1639, 1640, 1641, 1642, 1643, 1644,
    1645, 1646, 1647, 1648, 1649, 1650, 1651, 1652, 1653, 1654, 1655, 1656, 1657, 1658, 1659, 1660,
    1661, 1662, 1663, 1664, 1665, 1666, 1667, 1668, 1669, 1670, 1671, 1672, 1673, 0, 0,
];
static use_syllable_machine_start: i32 = 1;
static use_syllable_machine_first_final: i32 = 1;
static use_syllable_machine_error: i32 = -1;
static use_syllable_machine_en_main: i32 = 1;
#[derive(Clone, Copy)]
pub enum SyllableType {
    IndependentCluster,
    ViramaTerminatedCluster,
    SakotTerminatedCluster,
    StandardCluster,
    NumberJoinerTerminatedCluster,
    NumeralCluster,
    SymbolCluster,
    HieroglyphCluster,
    BrokenCluster,
    NonCluster,
}

pub fn find_syllables(buffer: &mut hb_buffer_t) {
    let mut cs = 0;
    let infos = Cell::as_slice_of_cells(Cell::from_mut(&mut buffer.info));
    let p0 = MachineCursor::new(infos, included);
    let mut p = p0;
    let mut ts = p0;
    let mut te = p0;
    let pe = p.end();
    let eof = p.end();
    let mut syllable_serial = 1u8;

    // Please manually replace assignments of 0 to p, ts, and te
    // to use p0 instead

    macro_rules! found_syllable {
        ($kind:expr) => {{
            found_syllable(ts.index(), te.index(), &mut syllable_serial, $kind, infos);
        }};
    }

    {
        cs = (use_syllable_machine_start) as i32;
        ts = p0;
        te = p0;
    }

    {
        let mut _klen = 0;
        let mut _trans = 0;
        let mut _keys: i32 = 0;
        let mut _acts: i32 = 0;
        let mut _nacts = 0;
        let mut __have = 0;
        '_resume: while (p != pe || p == eof) {
            '_again: while (true) {
                _acts = (_use_syllable_machine_from_state_actions[(cs) as usize]) as i32;
                _nacts = (_use_syllable_machine_actions[(_acts) as usize]) as u32;
                _acts += 1;
                while (_nacts > 0) {
                    match (_use_syllable_machine_actions[(_acts) as usize]) {
                        1 => {
                            ts = p;
                        }

                        _ => {}
                    }
                    _nacts -= 1;
                    _acts += 1;
                }
                if (p == eof) {
                    {
                        if (_use_syllable_machine_eof_trans[(cs) as usize] > 0) {
                            {
                                _trans =
                                    (_use_syllable_machine_eof_trans[(cs) as usize]) as u32 - 1;
                            }
                        }
                    }
                } else {
                    {
                        _keys = (_use_syllable_machine_key_offsets[(cs) as usize]) as i32;
                        _trans = (_use_syllable_machine_index_offsets[(cs) as usize]) as u32;
                        _klen = (_use_syllable_machine_single_lengths[(cs) as usize]) as i32;
                        __have = 0;
                        if (_klen > 0) {
                            {
                                let mut _lower: i32 = _keys;
                                let mut _upper: i32 = _keys + _klen - 1;
                                let mut _mid: i32 = 0;
                                while (true) {
                                    if (_upper < _lower) {
                                        {
                                            _keys += _klen;
                                            _trans += (_klen) as u32;
                                            break;
                                        }
                                    }
                                    _mid = _lower + ((_upper - _lower) >> 1);
                                    if ((infos[p.index()].get().use_category() as u8)
                                        < _use_syllable_machine_trans_keys[(_mid) as usize])
                                    {
                                        _upper = _mid - 1;
                                    } else if ((infos[p.index()].get().use_category() as u8)
                                        > _use_syllable_machine_trans_keys[(_mid) as usize])
                                    {
                                        _lower = _mid + 1;
                                    } else {
                                        {
                                            __have = 1;
                                            _trans += (_mid - _keys) as u32;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        _klen = (_use_syllable_machine_range_lengths[(cs) as usize]) as i32;
                        if (__have == 0 && _klen > 0) {
                            {
                                let mut _lower: i32 = _keys;
                                let mut _upper: i32 = _keys + (_klen << 1) - 2;
                                let mut _mid: i32 = 0;
                                while (true) {
                                    if (_upper < _lower) {
                                        {
                                            _trans += (_klen) as u32;
                                            break;
                                        }
                                    }
                                    _mid = _lower + (((_upper - _lower) >> 1) & !1);
                                    if ((infos[p.index()].get().use_category() as u8)
                                        < _use_syllable_machine_trans_keys[(_mid) as usize])
                                    {
                                        _upper = _mid - 2;
                                    } else if ((infos[p.index()].get().use_category() as u8)
                                        > _use_syllable_machine_trans_keys[(_mid + 1) as usize])
                                    {
                                        _lower = _mid + 2;
                                    } else {
                                        {
                                            _trans += ((_mid - _keys) >> 1) as u32;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                cs = (_use_syllable_machine_cond_targs[(_trans) as usize]) as i32;
                if (_use_syllable_machine_cond_actions[(_trans) as usize] != 0) {
                    {
                        _acts = (_use_syllable_machine_cond_actions[(_trans) as usize]) as i32;
                        _nacts = (_use_syllable_machine_actions[(_acts) as usize]) as u32;
                        _acts += 1;
                        while (_nacts > 0) {
                            match (_use_syllable_machine_actions[(_acts) as usize]) {
                                2 => {
                                    te = p + 1;
                                }
                                3 => {
                                    te = p + 1;
                                    {
                                        found_syllable!(SyllableType::ViramaTerminatedCluster);
                                    }
                                }
                                4 => {
                                    te = p + 1;
                                    {
                                        found_syllable!(SyllableType::SakotTerminatedCluster);
                                    }
                                }
                                5 => {
                                    te = p + 1;
                                    {
                                        found_syllable!(SyllableType::StandardCluster);
                                    }
                                }
                                6 => {
                                    te = p + 1;
                                    {
                                        found_syllable!(
                                            SyllableType::NumberJoinerTerminatedCluster
                                        );
                                    }
                                }
                                7 => {
                                    te = p + 1;
                                    {
                                        found_syllable!(SyllableType::NumeralCluster);
                                    }
                                }
                                8 => {
                                    te = p + 1;
                                    {
                                        found_syllable!(SyllableType::SymbolCluster);
                                    }
                                }
                                9 => {
                                    te = p + 1;
                                    {
                                        found_syllable!(SyllableType::HieroglyphCluster);
                                    }
                                }
                                10 => {
                                    te = p + 1;
                                    {
                                        found_syllable!(SyllableType::BrokenCluster);
                                        buffer.scratch_flags |=
                                            HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE;
                                    }
                                }
                                11 => {
                                    te = p + 1;
                                    {
                                        found_syllable!(SyllableType::NonCluster);
                                    }
                                }
                                12 => {
                                    te = p;
                                    p = p - 1;
                                    {
                                        found_syllable!(SyllableType::ViramaTerminatedCluster);
                                    }
                                }
                                13 => {
                                    te = p;
                                    p = p - 1;
                                    {
                                        found_syllable!(SyllableType::SakotTerminatedCluster);
                                    }
                                }
                                14 => {
                                    te = p;
                                    p = p - 1;
                                    {
                                        found_syllable!(SyllableType::StandardCluster);
                                    }
                                }
                                15 => {
                                    te = p;
                                    p = p - 1;
                                    {
                                        found_syllable!(
                                            SyllableType::NumberJoinerTerminatedCluster
                                        );
                                    }
                                }
                                16 => {
                                    te = p;
                                    p = p - 1;
                                    {
                                        found_syllable!(SyllableType::NumeralCluster);
                                    }
                                }
                                17 => {
                                    te = p;
                                    p = p - 1;
                                    {
                                        found_syllable!(SyllableType::SymbolCluster);
                                    }
                                }
                                18 => {
                                    te = p;
                                    p = p - 1;
                                    {
                                        found_syllable!(SyllableType::HieroglyphCluster);
                                    }
                                }
                                19 => {
                                    te = p;
                                    p = p - 1;
                                    {
                                        found_syllable!(SyllableType::BrokenCluster);
                                        buffer.scratch_flags |=
                                            HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE;
                                    }
                                }
                                20 => {
                                    te = p;
                                    p = p - 1;
                                    {
                                        found_syllable!(SyllableType::NonCluster);
                                    }
                                }
                                21 => {
                                    p = (te) - 1;
                                    {
                                        found_syllable!(SyllableType::SymbolCluster);
                                    }
                                }

                                _ => {}
                            }
                            _nacts -= 1;
                            _acts += 1;
                        }
                    }
                }
                break '_again;
            }
            if (p == eof) {
                {
                    if (cs >= 1) {
                        break '_resume;
                    }
                }
            } else {
                {
                    _acts = (_use_syllable_machine_to_state_actions[(cs) as usize]) as i32;
                    _nacts = (_use_syllable_machine_actions[(_acts) as usize]) as u32;
                    _acts += 1;
                    while (_nacts > 0) {
                        match (_use_syllable_machine_actions[(_acts) as usize]) {
                            0 => {
                                ts = p0;
                            }

                            _ => {}
                        }
                        _nacts -= 1;
                        _acts += 1;
                    }
                    p += 1;
                    continue '_resume;
                }
            }
            break '_resume;
        }
    }
}

#[inline]
fn found_syllable(
    start: usize,
    end: usize,
    syllable_serial: &mut u8,
    kind: SyllableType,
    buffer: &[Cell<hb_glyph_info_t>],
) {
    for i in start..end {
        let mut glyph = buffer[i].get();
        glyph.set_syllable((*syllable_serial << 4) | kind as u8);
        buffer[i].set(glyph);
    }

    *syllable_serial += 1;

    if *syllable_serial == 16 {
        *syllable_serial = 1;
    }
}

fn not_ccs_default_ignorable(i: &hb_glyph_info_t) -> bool {
    i.use_category() != category::CGJ
}

fn included(infos: &[Cell<hb_glyph_info_t>], i: usize) -> bool {
    let glyph = infos[i].get();
    if !not_ccs_default_ignorable(&glyph) {
        return false;
    }
    if glyph.use_category() == category::ZWNJ {
        for glyph2 in &infos[i + 1..] {
            if not_ccs_default_ignorable(&glyph2.get()) {
                return !_hb_glyph_info_is_unicode_mark(&glyph2.get());
            }
        }
    }
    true
}
