#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-11-02 10:02:29 
# conf/config-bugfix.sh

### P A R A M S
# none

### I N C L U D E S
. ./_include.sh

### M O D I F I E D   F I L E S ...
logindefs=login.defs

### ... W I T H   A C C E S S
INST_UID=root
INST_GID=root
INST_MOD=644

### S T A R T

# D E B I A N : F I X   E X I S T I N G   L O G I N . D E F S
function fixDebian163635()
{
	echo 'fix debian #163635 ${logindefs}'
	grep '^CLOSE_SESSIONS[[:space:]]yes' ${ETCDIR}/${logindefs}
	if [ "$?" != "0" ] ; then
	echo "${ETCDIR}/${logindefs} must have CLOSE_SESSION yes"
	awk 'BEGIN {
		FS=" ";
		}
		{
		if(match($0,"^CLOSE_SESSIONS"))
			print "CLOSE_SESSIONS yes"
		else
			print
		}' ${ETCDIR}/${logindefs} > ${TMPDIR}/${logindefs}
	#cat ${TMPDIR}/${logindefs} | grep -v "^#" | grep -v "^$"

	# I N S T A L L
	echo install modified ${logindefs} to ${ETCDIR}
	${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_MOD} ${TMPDIR}/${logindefs} ${ETCDIR} > /dev/null

	# C L E A N U P
	rm -f ${TMPDIR}/${logindefs}
	fi
}

function fixFam()
{
	service=fam

	# service stop
	if ${SERVICESTATUS} ${service} > /dev/null; then
		echo "stop ${service}"
		echo "${service}, the File Alteration Monitor, has to be stopped."
		echo "${service}, by keeping monitored files open, stops proper share unmounting on session exit."
		${SERVICE} ${service} stop > /dev/null
	fi

	# service autostart
	echo "disable ${service} automatic startup"
	${SERVICEREMOVE} ${service} > /dev/null 2> /dev/null
}

function fixAvahi()
{
	service=${AVAHISERVICE}

	# service stop
	if ${SERVICESTATUS} ${service} > /dev/null; then
		echo "stop ${service}"
		echo "${service}, the Avahi daemon, has to be stopped."
		echo "${service}, by interfering in naming, stops proper DNS resolution."
		${SERVICE} ${service} stop > /dev/null
	fi

	# service autostart
	echo "disable ${service} automatic startup"
	${SERVICEREMOVE} ${service} > /dev/null 2> /dev/null
}

function fixSeLinux()
{
	if [ -e /etc/sysconfig/selinux ]; then
		selinux=`grep '^SELINUX=' /etc/sysconfig/selinux`
		selinux=${selinux#'SELINUX='}
		if [ "${selinux}" == "enforcing" ]; then
			echo "WARNING:se linux enforcing mode"
			echo "a number of problems may arise due to SE linux being enforced, depending on version of policies"
			selinuxtype=`grep '^SELINUXTYPE=' /etc/sysconfig/selinux`
			selinuxtype=${selinuxtype#'SELINUXTYPE='}
			echo "se linux ${selinuxtype} type"
		else
			echo "se linux ${selinux}"
		fi
	fi
}

function fixSeLinuxFC5()
{
	if [ "${DISTRIBUTIONTAG}" == "Bordeaux" ]; then
		./config-selinux.sh install
		./config-selinux.sh sethomes
	fi
}

function fixTestparm()
{
	# prevent testparm from failing
	varrunsamba=/var/run/samba
	if [ ! -d "${varrunsamba}" ]; then
		echo "create ${varrunsamba}"
		mkdir "${varrunsamba}"
		chown root.root "${varrunsamba}"
		chmod u=rwx,go=rx "${varrunsamba}"
	fi
}

# M A I N
echo "+fix bugs/incompatibilities"

#  D I S T R I B U T I O N
fixAvahi
fixTestparm
case ${DISTRIBUTION} in
	Redhat)
		fixSeLinux
		exit 0
		;;
	Fedora)
		fixSeLinux
		fixSeLinuxFC5
		exit 0
		;;
	Mandriva)
		exit 0
		;;
	Debian)
		fixDebian163635
		fixFam
		exit 0
		;;
	Ubuntu)
		fixFam
		exit 0
		;;
	*)
		;;
esac
