/* SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Copyright:
 *   2020      Evan Nemerson <evan@nemerson.com>
 *   2020      Hidayat Khan <huk2209@gmail.com>
 */

#define SIMDE_TEST_X86_AVX512_INSN subs

#include <test/x86/avx512/test-avx512.h>
#include <simde/x86/avx512/set.h>
#include <simde/x86/avx512/subs.h>

static int
test_simde_mm512_subs_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  82), INT8_C(  83), INT8_C( 117), INT8_C(  65),
                           INT8_C( -47), INT8_C(-122), INT8_C( 116), INT8_C(  14),
                           INT8_C(  76), INT8_C(   1), INT8_C( -50), INT8_C(   4),
                           INT8_C(  83), INT8_C( -77), INT8_C( 112), INT8_C(-102),
                           INT8_C(  99), INT8_C(-118), INT8_C( -47), INT8_C( -67),
                           INT8_C(  60), INT8_C( -34), INT8_C(  78), INT8_C(-110),
                           INT8_C( -58), INT8_C(  87), INT8_C( -61), INT8_C(  26),
                           INT8_C( -17), INT8_C( -46), INT8_C( 116), INT8_C( -20),
                           INT8_C(-120), INT8_C(  48), INT8_C(  24), INT8_C(  46),
                           INT8_C( 103), INT8_C( -34), INT8_C(  42), INT8_C(  51),
                           INT8_C( -65), INT8_C(  86), INT8_C(  61), INT8_C( -56),
                           INT8_C(  58), INT8_C( 119), INT8_C(  93), INT8_C(  -1),
                           INT8_C( -58), INT8_C(-121), INT8_C( -32), INT8_C(  98),
                           INT8_C( -66), INT8_C(  79), INT8_C(  99), INT8_C( -93),
                           INT8_C(  77), INT8_C( -56), INT8_C( -78), INT8_C(  39),
                           INT8_C( -50), INT8_C( -60), INT8_C( -68), INT8_C(  -4)),
      simde_mm512_set_epi8(INT8_C( 106), INT8_C(  39), INT8_C(-106), INT8_C(  14),
                           INT8_C( -28), INT8_C(  -2), INT8_C(  39), INT8_C( -28),
                           INT8_C(  54), INT8_C(  70), INT8_C( -19), INT8_C( -12),
                           INT8_C( -42), INT8_C(  28), INT8_C( -13), INT8_C(  -6),
                           INT8_C( 116), INT8_C(   2), INT8_C(  23), INT8_C( 121),
                           INT8_C( 112), INT8_C( -35), INT8_C(-124), INT8_C(  10),
                           INT8_C( -16), INT8_C(-117), INT8_C(  26), INT8_C(-125),
                           INT8_C(  36), INT8_C( 109), INT8_C(  29), INT8_C( -35),
                           INT8_C(  -9), INT8_C( -85), INT8_C( -38), INT8_C(  95),
                           INT8_C( -88), INT8_C(   3), INT8_C(   4), INT8_C( 100),
                           INT8_C(  85), INT8_C(  21), INT8_C(  66), INT8_C( -33),
                           INT8_C( -77), INT8_C(  -5), INT8_C(-126), INT8_C( 122),
                           INT8_C( -30), INT8_C( -83), INT8_C(  74), INT8_C(-108),
                           INT8_C(  83), INT8_C( -96), INT8_C( -57), INT8_C(-108),
                           INT8_C(  89), INT8_C(  59), INT8_C( 111), INT8_C( -47),
                           INT8_C( -10), INT8_C( -18), INT8_C(  20), INT8_C(-125)),
      simde_mm512_set_epi8(INT8_C( -24), INT8_C(  44), INT8_C( 127), INT8_C(  51),
                           INT8_C( -19), INT8_C(-120), INT8_C(  77), INT8_C(  42),
                           INT8_C(  22), INT8_C( -69), INT8_C( -31), INT8_C(  16),
                           INT8_C( 125), INT8_C(-105), INT8_C( 125), INT8_C( -96),
                           INT8_C( -17), INT8_C(-120), INT8_C( -70), INT8_C(-128),
                           INT8_C( -52), INT8_C(   1), INT8_C( 127), INT8_C(-120),
                           INT8_C( -42), INT8_C( 127), INT8_C( -87), INT8_C( 127),
                           INT8_C( -53), INT8_C(-128), INT8_C(  87), INT8_C(  15),
                           INT8_C(-111), INT8_C( 127), INT8_C(  62), INT8_C( -49),
                           INT8_C( 127), INT8_C( -37), INT8_C(  38), INT8_C( -49),
                           INT8_C(-128), INT8_C(  65), INT8_C(  -5), INT8_C( -23),
                           INT8_C( 127), INT8_C( 124), INT8_C( 127), INT8_C(-123),
                           INT8_C( -28), INT8_C( -38), INT8_C(-106), INT8_C( 127),
                           INT8_C(-128), INT8_C( 127), INT8_C( 127), INT8_C(  15),
                           INT8_C( -12), INT8_C(-115), INT8_C(-128), INT8_C(  86),
                           INT8_C( -40), INT8_C( -42), INT8_C( -88), INT8_C( 121)) },
    { simde_mm512_set_epi8(INT8_C(-108), INT8_C(-116), INT8_C(  21), INT8_C(-123),
                           INT8_C( -53), INT8_C(  42), INT8_C(  66), INT8_C(  13),
                           INT8_C(   9), INT8_C( 115), INT8_C(  86), INT8_C( 126),
                           INT8_C( -24), INT8_C(  35), INT8_C(  -5), INT8_C( 103),
                           INT8_C(  38), INT8_C( 111), INT8_C(  24), INT8_C( -71),
                           INT8_C(  -1), INT8_C(  17), INT8_C( -63), INT8_C( -13),
                           INT8_C(  14), INT8_C(  82), INT8_C(  78), INT8_C(-102),
                           INT8_C(  -7), INT8_C(  93), INT8_C(  25), INT8_C( 103),
                           INT8_C( 113), INT8_C( -15), INT8_C( -19), INT8_C( -73),
                           INT8_C( -11), INT8_C( 103), INT8_C( -97), INT8_C( 123),
                           INT8_C(  28), INT8_C(  53), INT8_C( -15), INT8_C( 122),
                           INT8_C(   3), INT8_C( -54), INT8_C( -61), INT8_C(  58),
                           INT8_C( -44), INT8_C(  -3), INT8_C( -43), INT8_C( -35),
                           INT8_C(-118), INT8_C( -18), INT8_C(  15), INT8_C(  54),
                           INT8_C(-102), INT8_C( -58), INT8_C( -74), INT8_C( -70),
                           INT8_C(  46), INT8_C(  48), INT8_C( -35), INT8_C(  92)),
      simde_mm512_set_epi8(INT8_C(   6), INT8_C(  68), INT8_C(  77), INT8_C( -94),
                           INT8_C( -48), INT8_C(-101), INT8_C(  -8), INT8_C(  82),
                           INT8_C(  50), INT8_C( -15), INT8_C(   6), INT8_C(  30),
                           INT8_C( -47), INT8_C( -15), INT8_C( -14), INT8_C( -97),
                           INT8_C(  28), INT8_C( -47), INT8_C( -92), INT8_C( -84),
                           INT8_C( -37), INT8_C( -33), INT8_C(-123), INT8_C( -19),
                           INT8_C(  58), INT8_C(  29), INT8_C(  93), INT8_C( -55),
                           INT8_C(-127), INT8_C( -60), INT8_C(  32), INT8_C( 116),
                           INT8_C( -46), INT8_C(  51), INT8_C( -40), INT8_C(  10),
                           INT8_C(   4), INT8_C(  50), INT8_C(  48), INT8_C(  53),
                           INT8_C(  78), INT8_C(  21), INT8_C(  64), INT8_C( 107),
                           INT8_C(  16), INT8_C(  48), INT8_C( -46), INT8_C(  62),
                           INT8_C(  75), INT8_C(  85), INT8_C(-115), INT8_C( -14),
                           INT8_C( -99), INT8_C(  86), INT8_C(-116), INT8_C( -74),
                           INT8_C(  38), INT8_C(  27), INT8_C(-115), INT8_C(  55),
                           INT8_C( -91), INT8_C( -71), INT8_C( -14), INT8_C( -84)),
      simde_mm512_set_epi8(INT8_C(-114), INT8_C(-128), INT8_C( -56), INT8_C( -29),
                           INT8_C(  -5), INT8_C( 127), INT8_C(  74), INT8_C( -69),
                           INT8_C( -41), INT8_C( 127), INT8_C(  80), INT8_C(  96),
                           INT8_C(  23), INT8_C(  50), INT8_C(   9), INT8_C( 127),
                           INT8_C(  10), INT8_C( 127), INT8_C( 116), INT8_C(  13),
                           INT8_C(  36), INT8_C(  50), INT8_C(  60), INT8_C(   6),
                           INT8_C( -44), INT8_C(  53), INT8_C( -15), INT8_C( -47),
                           INT8_C( 120), INT8_C( 127), INT8_C(  -7), INT8_C( -13),
                           INT8_C( 127), INT8_C( -66), INT8_C(  21), INT8_C( -83),
                           INT8_C( -15), INT8_C(  53), INT8_C(-128), INT8_C(  70),
                           INT8_C( -50), INT8_C(  32), INT8_C( -79), INT8_C(  15),
                           INT8_C( -13), INT8_C(-102), INT8_C( -15), INT8_C(  -4),
                           INT8_C(-119), INT8_C( -88), INT8_C(  72), INT8_C( -21),
                           INT8_C( -19), INT8_C(-104), INT8_C( 127), INT8_C( 127),
                           INT8_C(-128), INT8_C( -85), INT8_C(  41), INT8_C(-125),
                           INT8_C( 127), INT8_C( 119), INT8_C( -21), INT8_C( 127)) },
    { simde_mm512_set_epi8(INT8_C(   2), INT8_C( -77), INT8_C( -19), INT8_C(  41),
                           INT8_C( -13), INT8_C(  75), INT8_C(-123), INT8_C(  96),
                           INT8_C( -86), INT8_C( -24), INT8_C( -27), INT8_C( -84),
                           INT8_C(  35), INT8_C( -86), INT8_C( -72), INT8_C( -97),
                           INT8_C(  44), INT8_C(  11), INT8_C(-106), INT8_C(  44),
                           INT8_C(   0), INT8_C(  90), INT8_C( -79), INT8_C(  91),
                           INT8_C( 119), INT8_C(  59), INT8_C( 105), INT8_C(-128),
                           INT8_C( 110), INT8_C( -29), INT8_C(  67), INT8_C( 114),
                           INT8_C( -39), INT8_C( -49), INT8_C( 105), INT8_C( -40),
                           INT8_C( -33), INT8_C( 120), INT8_C( -27), INT8_C( 100),
                           INT8_C( -90), INT8_C(  86), INT8_C( -18), INT8_C( -57),
                           INT8_C(  84), INT8_C( -26), INT8_C( -77), INT8_C(  17),
                           INT8_C( -47), INT8_C(  51), INT8_C( -83), INT8_C(  53),
                           INT8_C(  71), INT8_C(  96), INT8_C( 110), INT8_C( -89),
                           INT8_C(  27), INT8_C( -45), INT8_C(-126), INT8_C(  40),
                           INT8_C(  95), INT8_C( -87), INT8_C( -62), INT8_C( -52)),
      simde_mm512_set_epi8(INT8_C( -84), INT8_C( 127), INT8_C(  61), INT8_C( -16),
                           INT8_C(  30), INT8_C(   6), INT8_C(-112), INT8_C( 104),
                           INT8_C( -60), INT8_C( -88), INT8_C( -39), INT8_C( -19),
                           INT8_C(  44), INT8_C(  36), INT8_C( 105), INT8_C( 120),
                           INT8_C( -26), INT8_C(  21), INT8_C(  14), INT8_C(  42),
                           INT8_C(  49), INT8_C( -84), INT8_C(-120), INT8_C(-107),
                           INT8_C( 123), INT8_C( -47), INT8_C(  21), INT8_C( -10),
                           INT8_C(  95), INT8_C( 124), INT8_C( -33), INT8_C( -34),
                           INT8_C( -33), INT8_C( -71), INT8_C(  11), INT8_C(  74),
                           INT8_C( 104), INT8_C( 108), INT8_C( -35), INT8_C( -59),
                           INT8_C( -55), INT8_C(-126), INT8_C( 107), INT8_C(  23),
                           INT8_C(  29), INT8_C( -27), INT8_C( 123), INT8_C(  23),
                           INT8_C( -83), INT8_C( -90), INT8_C(   9), INT8_C(  94),
                           INT8_C(  91), INT8_C(  69), INT8_C( -51), INT8_C(-103),
                           INT8_C( -72), INT8_C( -45), INT8_C(  16), INT8_C( 108),
                           INT8_C( -80), INT8_C(  27), INT8_C(  58), INT8_C( -83)),
      simde_mm512_set_epi8(INT8_C(  86), INT8_C(-128), INT8_C( -80), INT8_C(  57),
                           INT8_C( -43), INT8_C(  69), INT8_C( -11), INT8_C(  -8),
                           INT8_C( -26), INT8_C(  64), INT8_C(  12), INT8_C( -65),
                           INT8_C(  -9), INT8_C(-122), INT8_C(-128), INT8_C(-128),
                           INT8_C(  70), INT8_C( -10), INT8_C(-120), INT8_C(   2),
                           INT8_C( -49), INT8_C( 127), INT8_C(  41), INT8_C( 127),
                           INT8_C(  -4), INT8_C( 106), INT8_C(  84), INT8_C(-118),
                           INT8_C(  15), INT8_C(-128), INT8_C( 100), INT8_C( 127),
                           INT8_C(  -6), INT8_C(  22), INT8_C(  94), INT8_C(-114),
                           INT8_C(-128), INT8_C(  12), INT8_C(   8), INT8_C( 127),
                           INT8_C( -35), INT8_C( 127), INT8_C(-125), INT8_C( -80),
                           INT8_C(  55), INT8_C(   1), INT8_C(-128), INT8_C(  -6),
                           INT8_C(  36), INT8_C( 127), INT8_C( -92), INT8_C( -41),
                           INT8_C( -20), INT8_C(  27), INT8_C( 127), INT8_C(  14),
                           INT8_C(  99), INT8_C(   0), INT8_C(-128), INT8_C( -68),
                           INT8_C( 127), INT8_C(-114), INT8_C(-120), INT8_C(  31)) },
    { simde_mm512_set_epi8(INT8_C(  17), INT8_C(  99), INT8_C( -13), INT8_C( -49),
                           INT8_C(  45), INT8_C(-128), INT8_C(  55), INT8_C( 105),
                           INT8_C( -34), INT8_C( -51), INT8_C( -97), INT8_C(-103),
                           INT8_C(-124), INT8_C( 111), INT8_C(  74), INT8_C(  75),
                           INT8_C( 102), INT8_C(  98), INT8_C(-117), INT8_C(   9),
                           INT8_C( -74), INT8_C(  61), INT8_C(  99), INT8_C( 124),
                           INT8_C(  79), INT8_C(-114), INT8_C(  19), INT8_C(  97),
                           INT8_C(-100), INT8_C(-124), INT8_C( -17), INT8_C( -62),
                           INT8_C(  25), INT8_C(  -3), INT8_C(  -7), INT8_C(  72),
                           INT8_C(-117), INT8_C( -27), INT8_C( -56), INT8_C(  92),
                           INT8_C( -20), INT8_C( -53), INT8_C(   2), INT8_C( -38),
                           INT8_C( -81), INT8_C(  59), INT8_C(  66), INT8_C(  90),
                           INT8_C(  36), INT8_C( 100), INT8_C( 112), INT8_C( 123),
                           INT8_C( -72), INT8_C( -97), INT8_C(-115), INT8_C(  17),
                           INT8_C( -93), INT8_C(-122), INT8_C(  31), INT8_C(  27),
                           INT8_C( 109), INT8_C( 115), INT8_C(  53), INT8_C( -96)),
      simde_mm512_set_epi8(INT8_C( -43), INT8_C( -18), INT8_C( 114), INT8_C( -29),
                           INT8_C( 118), INT8_C(  -1), INT8_C( -20), INT8_C( -38),
                           INT8_C( -80), INT8_C(  88), INT8_C(-111), INT8_C( -91),
                           INT8_C(  44), INT8_C( -72), INT8_C( 106), INT8_C(  19),
                           INT8_C( -46), INT8_C( 107), INT8_C(  46), INT8_C(  44),
                           INT8_C( -65), INT8_C(-128), INT8_C(  41), INT8_C(  44),
                           INT8_C(  68), INT8_C(  69), INT8_C( -78), INT8_C( -47),
                           INT8_C( 109), INT8_C( 120), INT8_C( -57), INT8_C( -95),
                           INT8_C(  95), INT8_C(  80), INT8_C( -30), INT8_C(  97),
                           INT8_C( -48), INT8_C( -97), INT8_C( 111), INT8_C( -80),
                           INT8_C(-122), INT8_C( -81), INT8_C( -71), INT8_C(  85),
                           INT8_C(  77), INT8_C( -42), INT8_C(-115), INT8_C( -77),
                           INT8_C(  29), INT8_C(  77), INT8_C(  64), INT8_C( -20),
                           INT8_C(  27), INT8_C(  41), INT8_C(  13), INT8_C( 109),
                           INT8_C(  22), INT8_C( -98), INT8_C(  20), INT8_C( -28),
                           INT8_C(  66), INT8_C(  -7), INT8_C(-113), INT8_C(-119)),
      simde_mm512_set_epi8(INT8_C(  60), INT8_C( 117), INT8_C(-127), INT8_C( -20),
                           INT8_C( -73), INT8_C(-127), INT8_C(  75), INT8_C( 127),
                           INT8_C(  46), INT8_C(-128), INT8_C(  14), INT8_C( -12),
                           INT8_C(-128), INT8_C( 127), INT8_C( -32), INT8_C(  56),
                           INT8_C( 127), INT8_C(  -9), INT8_C(-128), INT8_C( -35),
                           INT8_C(  -9), INT8_C( 127), INT8_C(  58), INT8_C(  80),
                           INT8_C(  11), INT8_C(-128), INT8_C(  97), INT8_C( 127),
                           INT8_C(-128), INT8_C(-128), INT8_C(  40), INT8_C(  33),
                           INT8_C( -70), INT8_C( -83), INT8_C(  23), INT8_C( -25),
                           INT8_C( -69), INT8_C(  70), INT8_C(-128), INT8_C( 127),
                           INT8_C( 102), INT8_C(  28), INT8_C(  73), INT8_C(-123),
                           INT8_C(-128), INT8_C( 101), INT8_C( 127), INT8_C( 127),
                           INT8_C(   7), INT8_C(  23), INT8_C(  48), INT8_C( 127),
                           INT8_C( -99), INT8_C(-128), INT8_C(-128), INT8_C( -92),
                           INT8_C(-115), INT8_C( -24), INT8_C(  11), INT8_C(  55),
                           INT8_C(  43), INT8_C( 122), INT8_C( 127), INT8_C(  23)) },
    { simde_mm512_set_epi8(INT8_C(-124), INT8_C( -73), INT8_C(  74), INT8_C(   5),
                           INT8_C(  -9), INT8_C(  17), INT8_C( -81), INT8_C( -54),
                           INT8_C(  -5), INT8_C( -33), INT8_C( -12), INT8_C(  26),
                           INT8_C(  86), INT8_C( 122), INT8_C( -44), INT8_C( -23),
                           INT8_C(   0), INT8_C(  43), INT8_C( -25), INT8_C(-122),
                           INT8_C( -79), INT8_C(-122), INT8_C( -88), INT8_C(-121),
                           INT8_C(-102), INT8_C(  66), INT8_C( -93), INT8_C( 105),
                           INT8_C( 109), INT8_C( -68), INT8_C(  24), INT8_C( -54),
                           INT8_C(  40), INT8_C(  68), INT8_C(   2), INT8_C(  60),
                           INT8_C(   0), INT8_C(   5), INT8_C(  59), INT8_C( -54),
                           INT8_C( -76), INT8_C(  27), INT8_C( -23), INT8_C(  77),
                           INT8_C(-108), INT8_C( -28), INT8_C(-114), INT8_C(  56),
                           INT8_C( -54), INT8_C(-108), INT8_C( -15), INT8_C( -89),
                           INT8_C(-103), INT8_C( -45), INT8_C(  74), INT8_C(  -3),
                           INT8_C(-108), INT8_C(  55), INT8_C( -79), INT8_C( -62),
                           INT8_C(  14), INT8_C( 106), INT8_C( -16), INT8_C( -10)),
      simde_mm512_set_epi8(INT8_C( -47), INT8_C( 124), INT8_C(  57), INT8_C( -74),
                           INT8_C(  20), INT8_C( 124), INT8_C(  70), INT8_C( -69),
                           INT8_C( -65), INT8_C( -12), INT8_C( 124), INT8_C( -90),
                           INT8_C(-113), INT8_C(  63), INT8_C( -79), INT8_C( -70),
                           INT8_C( -76), INT8_C( -34), INT8_C( -60), INT8_C(  -4),
                           INT8_C( -41), INT8_C(  60), INT8_C(  77), INT8_C( -57),
                           INT8_C(  13), INT8_C(   2), INT8_C( 111), INT8_C( -39),
                           INT8_C(  41), INT8_C(  54), INT8_C( -37), INT8_C( 114),
                           INT8_C(  92), INT8_C(-111), INT8_C(  77), INT8_C(  14),
                           INT8_C(-104), INT8_C( -39), INT8_C( -74), INT8_C(  66),
                           INT8_C(  16), INT8_C( -26), INT8_C( -89), INT8_C(-114),
                           INT8_C( -68), INT8_C(   6), INT8_C(  62), INT8_C( -93),
                           INT8_C(  55), INT8_C(-113), INT8_C( -60), INT8_C( -56),
                           INT8_C( -37), INT8_C(   2), INT8_C( -15), INT8_C(  88),
                           INT8_C(  26), INT8_C(  54), INT8_C(  82), INT8_C( 124),
                           INT8_C( -38), INT8_C(-107), INT8_C(  40), INT8_C(  13)),
      simde_mm512_set_epi8(INT8_C( -77), INT8_C(-128), INT8_C(  17), INT8_C(  79),
                           INT8_C( -29), INT8_C(-107), INT8_C(-128), INT8_C(  15),
                           INT8_C(  60), INT8_C( -21), INT8_C(-128), INT8_C( 116),
                           INT8_C( 127), INT8_C(  59), INT8_C(  35), INT8_C(  47),
                           INT8_C(  76), INT8_C(  77), INT8_C(  35), INT8_C(-118),
                           INT8_C( -38), INT8_C(-128), INT8_C(-128), INT8_C( -64),
                           INT8_C(-115), INT8_C(  64), INT8_C(-128), INT8_C( 127),
                           INT8_C(  68), INT8_C(-122), INT8_C(  61), INT8_C(-128),
                           INT8_C( -52), INT8_C( 127), INT8_C( -75), INT8_C(  46),
                           INT8_C( 104), INT8_C(  44), INT8_C( 127), INT8_C(-120),
                           INT8_C( -92), INT8_C(  53), INT8_C(  66), INT8_C( 127),
                           INT8_C( -40), INT8_C( -34), INT8_C(-128), INT8_C( 127),
                           INT8_C(-109), INT8_C(   5), INT8_C(  45), INT8_C( -33),
                           INT8_C( -66), INT8_C( -47), INT8_C(  89), INT8_C( -91),
                           INT8_C(-128), INT8_C(   1), INT8_C(-128), INT8_C(-128),
                           INT8_C(  52), INT8_C( 127), INT8_C( -56), INT8_C( -23)) },
    { simde_mm512_set_epi8(INT8_C(   5), INT8_C( -68), INT8_C( -18), INT8_C( -37),
                           INT8_C(   5), INT8_C(  16), INT8_C(-109), INT8_C( -67),
                           INT8_C( -62), INT8_C(  -4), INT8_C(  14), INT8_C(-109),
                           INT8_C( -29), INT8_C(-121), INT8_C(-109), INT8_C( -55),
                           INT8_C(   1), INT8_C( -38), INT8_C( 107), INT8_C(  55),
                           INT8_C( -36), INT8_C( -76), INT8_C(  35), INT8_C( -40),
                           INT8_C(  10), INT8_C( -90), INT8_C( -48), INT8_C(-112),
                           INT8_C(  -9), INT8_C( -53), INT8_C( 105), INT8_C(  27),
                           INT8_C( -97), INT8_C(-124), INT8_C(   4), INT8_C( -36),
                           INT8_C( -16), INT8_C( -87), INT8_C( -89), INT8_C(-104),
                           INT8_C( -30), INT8_C(-101), INT8_C(  69), INT8_C(  79),
                           INT8_C(  59), INT8_C( -97), INT8_C( -15), INT8_C(  17),
                           INT8_C( 106), INT8_C( -85), INT8_C( 126), INT8_C(-121),
                           INT8_C( -91), INT8_C(  26), INT8_C(-115), INT8_C(-117),
                           INT8_C(  91), INT8_C(  73), INT8_C( -60), INT8_C(  69),
                           INT8_C( -23), INT8_C(  48), INT8_C(  70), INT8_C(  -8)),
      simde_mm512_set_epi8(INT8_C(  91), INT8_C(-103), INT8_C(  69), INT8_C(  61),
                           INT8_C( -82), INT8_C(  73), INT8_C( 122), INT8_C( -22),
                           INT8_C( 122), INT8_C(  76), INT8_C(  -9), INT8_C( 121),
                           INT8_C(-123), INT8_C(-119), INT8_C(-127), INT8_C( 126),
                           INT8_C( 105), INT8_C(  10), INT8_C(-120), INT8_C(-127),
                           INT8_C( -50), INT8_C(  15), INT8_C( -93), INT8_C( -86),
                           INT8_C(-125), INT8_C(  45), INT8_C( -39), INT8_C(-119),
                           INT8_C(  74), INT8_C( -92), INT8_C( -78), INT8_C(  53),
                           INT8_C(  17), INT8_C( -21), INT8_C( 105), INT8_C(-102),
                           INT8_C(  -1), INT8_C( -19), INT8_C( 110), INT8_C( -84),
                           INT8_C( -93), INT8_C(  19), INT8_C( -98), INT8_C(-128),
                           INT8_C( -23), INT8_C(  49), INT8_C( 100), INT8_C( 122),
                           INT8_C( -96), INT8_C(-103), INT8_C(  60), INT8_C( -24),
                           INT8_C(  23), INT8_C( -52), INT8_C( -37), INT8_C( -56),
                           INT8_C( -50), INT8_C(   4), INT8_C( -69), INT8_C(   1),
                           INT8_C( -25), INT8_C( -10), INT8_C(  93), INT8_C(  51)),
      simde_mm512_set_epi8(INT8_C( -86), INT8_C(  35), INT8_C( -87), INT8_C( -98),
                           INT8_C(  87), INT8_C( -57), INT8_C(-128), INT8_C( -45),
                           INT8_C(-128), INT8_C( -80), INT8_C(  23), INT8_C(-128),
                           INT8_C(  94), INT8_C(  -2), INT8_C(  18), INT8_C(-128),
                           INT8_C(-104), INT8_C( -48), INT8_C( 127), INT8_C( 127),
                           INT8_C(  14), INT8_C( -91), INT8_C( 127), INT8_C(  46),
                           INT8_C( 127), INT8_C(-128), INT8_C(  -9), INT8_C(   7),
                           INT8_C( -83), INT8_C(  39), INT8_C( 127), INT8_C( -26),
                           INT8_C(-114), INT8_C(-103), INT8_C(-101), INT8_C(  66),
                           INT8_C( -15), INT8_C( -68), INT8_C(-128), INT8_C( -20),
                           INT8_C(  63), INT8_C(-120), INT8_C( 127), INT8_C( 127),
                           INT8_C(  82), INT8_C(-128), INT8_C(-115), INT8_C(-105),
                           INT8_C( 127), INT8_C(  18), INT8_C(  66), INT8_C( -97),
                           INT8_C(-114), INT8_C(  78), INT8_C( -78), INT8_C( -61),
                           INT8_C( 127), INT8_C(  69), INT8_C(   9), INT8_C(  68),
                           INT8_C(   2), INT8_C(  58), INT8_C( -23), INT8_C( -59)) },
    { simde_mm512_set_epi8(INT8_C( -89), INT8_C(  43), INT8_C(  52), INT8_C(  82),
                           INT8_C( -37), INT8_C(  55), INT8_C( 112), INT8_C( -22),
                           INT8_C( -75), INT8_C( -36), INT8_C( -34), INT8_C( -15),
                           INT8_C(  35), INT8_C( -42), INT8_C(-101), INT8_C(  -5),
                           INT8_C(   2), INT8_C(  35), INT8_C(  14), INT8_C( -73),
                           INT8_C( -50), INT8_C( -33), INT8_C( -65), INT8_C(  94),
                           INT8_C(  -6), INT8_C( -21), INT8_C( -28), INT8_C(  21),
                           INT8_C( 102), INT8_C( -87), INT8_C( 114), INT8_C( 125),
                           INT8_C( 113), INT8_C( 124), INT8_C(-121), INT8_C(-122),
                           INT8_C(  23), INT8_C( 107), INT8_C(  24), INT8_C( 126),
                           INT8_C(  80), INT8_C(  59), INT8_C(  39), INT8_C( -61),
                           INT8_C(-105), INT8_C(  32), INT8_C(  55), INT8_C(  -9),
                           INT8_C(  60), INT8_C(-125), INT8_C(  72), INT8_C( -36),
                           INT8_C(  77), INT8_C( -65), INT8_C( 117), INT8_C( -85),
                           INT8_C(  98), INT8_C( -83), INT8_C( -69), INT8_C( -52),
                           INT8_C(  41), INT8_C( -10), INT8_C( -18), INT8_C(  56)),
      simde_mm512_set_epi8(INT8_C(  22), INT8_C( 122), INT8_C( -90), INT8_C(   2),
                           INT8_C( -65), INT8_C(  51), INT8_C( -94), INT8_C( -50),
                           INT8_C( -15), INT8_C(  19), INT8_C( -19), INT8_C(  66),
                           INT8_C( 119), INT8_C(-118), INT8_C(-112), INT8_C(-116),
                           INT8_C(  44), INT8_C( -12), INT8_C(  31), INT8_C(  43),
                           INT8_C( -16), INT8_C( -37), INT8_C( -24), INT8_C( -32),
                           INT8_C( -95), INT8_C( -86), INT8_C( -96), INT8_C(  80),
                           INT8_C(  68), INT8_C(  13), INT8_C(  -8), INT8_C(  67),
                           INT8_C( 107), INT8_C(-125), INT8_C( 104), INT8_C( -80),
                           INT8_C(  97), INT8_C( -78), INT8_C( 106), INT8_C( -53),
                           INT8_C( -36), INT8_C( -90), INT8_C(  74), INT8_C( -72),
                           INT8_C(  59), INT8_C( -81), INT8_C(  -8), INT8_C( -25),
                           INT8_C( -55), INT8_C( -99), INT8_C(  20), INT8_C(   9),
                           INT8_C( -89), INT8_C( -90), INT8_C( 108), INT8_C(  56),
                           INT8_C( -19), INT8_C(  81), INT8_C( 122), INT8_C(   6),
                           INT8_C(-119), INT8_C( 122), INT8_C( -35), INT8_C( 106)),
      simde_mm512_set_epi8(INT8_C(-111), INT8_C( -79), INT8_C( 127), INT8_C(  80),
                           INT8_C(  28), INT8_C(   4), INT8_C( 127), INT8_C(  28),
                           INT8_C( -60), INT8_C( -55), INT8_C( -15), INT8_C( -81),
                           INT8_C( -84), INT8_C(  76), INT8_C(  11), INT8_C( 111),
                           INT8_C( -42), INT8_C(  47), INT8_C( -17), INT8_C(-116),
                           INT8_C( -34), INT8_C(   4), INT8_C( -41), INT8_C( 126),
                           INT8_C(  89), INT8_C(  65), INT8_C(  68), INT8_C( -59),
                           INT8_C(  34), INT8_C(-100), INT8_C( 122), INT8_C(  58),
                           INT8_C(   6), INT8_C( 127), INT8_C(-128), INT8_C( -42),
                           INT8_C( -74), INT8_C( 127), INT8_C( -82), INT8_C( 127),
                           INT8_C( 116), INT8_C( 127), INT8_C( -35), INT8_C(  11),
                           INT8_C(-128), INT8_C( 113), INT8_C(  63), INT8_C(  16),
                           INT8_C( 115), INT8_C( -26), INT8_C(  52), INT8_C( -45),
                           INT8_C( 127), INT8_C(  25), INT8_C(   9), INT8_C(-128),
                           INT8_C( 117), INT8_C(-128), INT8_C(-128), INT8_C( -58),
                           INT8_C( 127), INT8_C(-128), INT8_C(  17), INT8_C( -50)) },
    { simde_mm512_set_epi8(INT8_C( 105), INT8_C(-115), INT8_C( 121), INT8_C(-101),
                           INT8_C(   0), INT8_C(  63), INT8_C( -42), INT8_C( -34),
                           INT8_C(  -5), INT8_C( -47), INT8_C(-123), INT8_C( -52),
                           INT8_C( -86), INT8_C( -28), INT8_C( -63), INT8_C(  20),
                           INT8_C( -60), INT8_C( -63), INT8_C(  99), INT8_C(  78),
                           INT8_C(  56), INT8_C( -72), INT8_C( -55), INT8_C( -72),
                           INT8_C(  79), INT8_C( -81), INT8_C( 124), INT8_C( -85),
                           INT8_C( -65), INT8_C( 122), INT8_C( -25), INT8_C( -58),
                           INT8_C( -64), INT8_C(  52), INT8_C( -12), INT8_C(   1),
                           INT8_C( -62), INT8_C( -28), INT8_C( -28), INT8_C(-104),
                           INT8_C(  54), INT8_C(-103), INT8_C( -55), INT8_C( -22),
                           INT8_C( -91), INT8_C(   6), INT8_C(  -9), INT8_C( -31),
                           INT8_C(  18), INT8_C(-111), INT8_C(  58), INT8_C(  71),
                           INT8_C( -73), INT8_C( -96), INT8_C(  28), INT8_C(  -4),
                           INT8_C(  47), INT8_C(  66), INT8_C( 121), INT8_C(  38),
                           INT8_C(  69), INT8_C(-107), INT8_C( -57), INT8_C(-120)),
      simde_mm512_set_epi8(INT8_C( -49), INT8_C(  15), INT8_C( -15), INT8_C( -59),
                           INT8_C(-113), INT8_C( 102), INT8_C( -48), INT8_C( -78),
                           INT8_C(  31), INT8_C(  94), INT8_C(  79), INT8_C(  92),
                           INT8_C( 106), INT8_C( -68), INT8_C(  96), INT8_C( -97),
                           INT8_C( -27), INT8_C(-118), INT8_C( -11), INT8_C( 112),
                           INT8_C(-125), INT8_C(  70), INT8_C(  26), INT8_C( -38),
                           INT8_C( -16), INT8_C(-112), INT8_C(  10), INT8_C(  98),
                           INT8_C(  -4), INT8_C( 120), INT8_C( -33), INT8_C(-127),
                           INT8_C( -65), INT8_C( -40), INT8_C(  88), INT8_C(  -6),
                           INT8_C(  74), INT8_C(  41), INT8_C(  39), INT8_C(  79),
                           INT8_C(-125), INT8_C(  -7), INT8_C(  62), INT8_C(-112),
                           INT8_C(-119), INT8_C(  -9), INT8_C(  71), INT8_C( -68),
                           INT8_C( -79), INT8_C(  48), INT8_C( -20), INT8_C( -97),
                           INT8_C(-116), INT8_C( 120), INT8_C( -65), INT8_C(   6),
                           INT8_C( -32), INT8_C( -75), INT8_C(-106), INT8_C(  26),
                           INT8_C( -96), INT8_C(  50), INT8_C( -45), INT8_C(  16)),
      simde_mm512_set_epi8(INT8_C( 127), INT8_C(-128), INT8_C( 127), INT8_C( -42),
                           INT8_C( 113), INT8_C( -39), INT8_C(   6), INT8_C(  44),
                           INT8_C( -36), INT8_C(-128), INT8_C(-128), INT8_C(-128),
                           INT8_C(-128), INT8_C(  40), INT8_C(-128), INT8_C( 117),
                           INT8_C( -33), INT8_C(  55), INT8_C( 110), INT8_C( -34),
                           INT8_C( 127), INT8_C(-128), INT8_C( -81), INT8_C( -34),
                           INT8_C(  95), INT8_C(  31), INT8_C( 114), INT8_C(-128),
                           INT8_C( -61), INT8_C(   2), INT8_C(   8), INT8_C(  69),
                           INT8_C(   1), INT8_C(  92), INT8_C(-100), INT8_C(   7),
                           INT8_C(-128), INT8_C( -69), INT8_C( -67), INT8_C(-128),
                           INT8_C( 127), INT8_C( -96), INT8_C(-117), INT8_C(  90),
                           INT8_C(  28), INT8_C(  15), INT8_C( -80), INT8_C(  37),
                           INT8_C(  97), INT8_C(-128), INT8_C(  78), INT8_C( 127),
                           INT8_C(  43), INT8_C(-128), INT8_C(  93), INT8_C( -10),
                           INT8_C(  79), INT8_C( 127), INT8_C( 127), INT8_C(  12),
                           INT8_C( 127), INT8_C(-128), INT8_C( -12), INT8_C(-128)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_subs_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_subs_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  52), INT8_C(-124), INT8_C( -17), INT8_C(  -9),
                           INT8_C(  31), INT8_C(  67), INT8_C( -76), INT8_C(  -4),
                           INT8_C( -52), INT8_C(  99), INT8_C( 106), INT8_C( -35),
                           INT8_C(-115), INT8_C(-127), INT8_C( 121), INT8_C( -60),
                           INT8_C( -27), INT8_C(  73), INT8_C( -21), INT8_C( -51),
                           INT8_C(-127), INT8_C(  68), INT8_C( 109), INT8_C(  35),
                           INT8_C(  96), INT8_C(   3), INT8_C( -62), INT8_C( -43),
                           INT8_C( -75), INT8_C( 102), INT8_C(-105), INT8_C(  63),
                           INT8_C(  64), INT8_C( 114), INT8_C( 112), INT8_C(  10),
                           INT8_C( 108), INT8_C(  71), INT8_C( -40), INT8_C(  20),
                           INT8_C( -40), INT8_C(  26), INT8_C( -94), INT8_C( 107),
                           INT8_C( -89), INT8_C(  22), INT8_C(  55), INT8_C( 105),
                           INT8_C(  23), INT8_C(  52), INT8_C(  82), INT8_C(  50),
                           INT8_C( -48), INT8_C(  77), INT8_C(  73), INT8_C(  98),
                           INT8_C( -85), INT8_C( 123), INT8_C(  15), INT8_C(  36),
                           INT8_C(-103), INT8_C(  18), INT8_C( -81), INT8_C(   9)),
      UINT64_C(          2070647823),
      simde_mm512_set_epi8(INT8_C(  87), INT8_C( 118), INT8_C(  10), INT8_C( -53),
                           INT8_C( -21), INT8_C( -77), INT8_C(  81), INT8_C(  16),
                           INT8_C( 125), INT8_C(  53), INT8_C( -93), INT8_C( -44),
                           INT8_C( -14), INT8_C( -81), INT8_C(  93), INT8_C( -81),
                           INT8_C(  69), INT8_C(  88), INT8_C(  17), INT8_C(-127),
                           INT8_C(  49), INT8_C(  91), INT8_C(  55), INT8_C( -23),
                           INT8_C( -84), INT8_C(  12), INT8_C( -97), INT8_C( -75),
                           INT8_C(  99), INT8_C(  54), INT8_C( -92), INT8_C( -28),
                           INT8_C(  -2), INT8_C(  69), INT8_C(-102), INT8_C(  42),
                           INT8_C(  41), INT8_C(-101), INT8_C( -59), INT8_C( -72),
                           INT8_C( -53), INT8_C( -47), INT8_C( -78), INT8_C(  67),
                           INT8_C(  54), INT8_C(  12), INT8_C( -65), INT8_C( 101),
                           INT8_C(  77), INT8_C( -96), INT8_C( -15), INT8_C(  66),
                           INT8_C(  50), INT8_C(   9), INT8_C( -75), INT8_C( 102),
                           INT8_C(   2), INT8_C( -31), INT8_C(  83), INT8_C( -71),
                           INT8_C( -84), INT8_C( -66), INT8_C(-111), INT8_C(  -2)),
      simde_mm512_set_epi8(INT8_C(  87), INT8_C(-105), INT8_C(  96), INT8_C( -79),
                           INT8_C(  99), INT8_C(  74), INT8_C(  20), INT8_C( 120),
                           INT8_C(  60), INT8_C(  49), INT8_C( 101), INT8_C( -94),
                           INT8_C(  -5), INT8_C( 114), INT8_C(  17), INT8_C(   1),
                           INT8_C(  36), INT8_C( -92), INT8_C(  39), INT8_C(-108),
                           INT8_C( -15), INT8_C(  14), INT8_C( -15), INT8_C(  79),
                           INT8_C( 112), INT8_C( 108), INT8_C( -44), INT8_C( -18),
                           INT8_C( 125), INT8_C(  93), INT8_C( -92), INT8_C( -51),
                           INT8_C(  21), INT8_C( -19), INT8_C( -56), INT8_C( 114),
                           INT8_C( -95), INT8_C(  40), INT8_C( -27), INT8_C( -85),
                           INT8_C(  26), INT8_C(  29), INT8_C( -30), INT8_C(  53),
                           INT8_C( -69), INT8_C( -26), INT8_C(  79), INT8_C(-124),
                           INT8_C( -35), INT8_C( -29), INT8_C( -59), INT8_C( -99),
                           INT8_C(-118), INT8_C(  30), INT8_C( 105), INT8_C(   3),
                           INT8_C(  -2), INT8_C(  26), INT8_C(-121), INT8_C( 115),
                           INT8_C( -78), INT8_C(  10), INT8_C(   6), INT8_C( -16)),
      simde_mm512_set_epi8(INT8_C(  52), INT8_C(-124), INT8_C( -17), INT8_C(  -9),
                           INT8_C(  31), INT8_C(  67), INT8_C( -76), INT8_C(  -4),
                           INT8_C( -52), INT8_C(  99), INT8_C( 106), INT8_C( -35),
                           INT8_C(-115), INT8_C(-127), INT8_C( 121), INT8_C( -60),
                           INT8_C( -27), INT8_C(  73), INT8_C( -21), INT8_C( -51),
                           INT8_C(-127), INT8_C(  68), INT8_C( 109), INT8_C(  35),
                           INT8_C(  96), INT8_C(   3), INT8_C( -62), INT8_C( -43),
                           INT8_C( -75), INT8_C( 102), INT8_C(-105), INT8_C(  63),
                           INT8_C(  64), INT8_C(  88), INT8_C( -46), INT8_C( -72),
                           INT8_C( 127), INT8_C(  71), INT8_C( -32), INT8_C(  13),
                           INT8_C( -40), INT8_C( -76), INT8_C( -48), INT8_C( 107),
                           INT8_C( 123), INT8_C(  22), INT8_C(-128), INT8_C( 127),
                           INT8_C( 112), INT8_C(  52), INT8_C(  82), INT8_C( 127),
                           INT8_C( -48), INT8_C( -21), INT8_C(  73), INT8_C(  98),
                           INT8_C( -85), INT8_C( 123), INT8_C(  15), INT8_C(  36),
                           INT8_C(  -6), INT8_C( -76), INT8_C(-117), INT8_C(  14)) },
    { simde_mm512_set_epi8(INT8_C( -60), INT8_C( -92), INT8_C( -73), INT8_C( -20),
                           INT8_C( -84), INT8_C( -11), INT8_C( -28), INT8_C(-123),
                           INT8_C( -48), INT8_C(-118), INT8_C(-107), INT8_C(  73),
                           INT8_C( -80), INT8_C(  46), INT8_C(-117), INT8_C( -85),
                           INT8_C( -21), INT8_C( -54), INT8_C( -49), INT8_C(  -8),
                           INT8_C(  51), INT8_C( 126), INT8_C(  22), INT8_C(  70),
                           INT8_C( -86), INT8_C( -98), INT8_C( -17), INT8_C( -29),
                           INT8_C(  75), INT8_C( 115), INT8_C(  61), INT8_C(  76),
                           INT8_C( -65), INT8_C(  43), INT8_C( -13), INT8_C(  -2),
                           INT8_C(  81), INT8_C( -26), INT8_C(  -6), INT8_C( -15),
                           INT8_C( -40), INT8_C(  72), INT8_C(  66), INT8_C(  32),
                           INT8_C(  22), INT8_C( -74), INT8_C( -73), INT8_C(  67),
                           INT8_C(  75), INT8_C( -18), INT8_C( -97), INT8_C(  75),
                           INT8_C( -47), INT8_C(  32), INT8_C(  26), INT8_C(-108),
                           INT8_C(  31), INT8_C( 110), INT8_C(-101), INT8_C( -57),
                           INT8_C(  28), INT8_C( -50), INT8_C( -16), INT8_C(  37)),
      UINT64_C(          3026541283),
      simde_mm512_set_epi8(INT8_C( -66), INT8_C( -12), INT8_C( -24), INT8_C(-107),
                           INT8_C(-117), INT8_C(  63), INT8_C(  42), INT8_C(  79),
                           INT8_C( -78), INT8_C( -79), INT8_C( -22), INT8_C( -52),
                           INT8_C( -78), INT8_C(  -8), INT8_C( -61), INT8_C( 101),
                           INT8_C(-111), INT8_C(  35), INT8_C( -89), INT8_C( 127),
                           INT8_C(  50), INT8_C(-115), INT8_C(  91), INT8_C( -72),
                           INT8_C( -97), INT8_C( -34), INT8_C( -80), INT8_C( -31),
                           INT8_C( -60), INT8_C( 119), INT8_C(-106), INT8_C(  66),
                           INT8_C(  75), INT8_C(-108), INT8_C(-113), INT8_C( 120),
                           INT8_C(  36), INT8_C( 112), INT8_C( -45), INT8_C(  41),
                           INT8_C(  90), INT8_C( -32), INT8_C(  22), INT8_C(  86),
                           INT8_C(  72), INT8_C( -20), INT8_C(  -4), INT8_C(-125),
                           INT8_C( -37), INT8_C(  84), INT8_C( -95), INT8_C( -66),
                           INT8_C( 109), INT8_C(  18), INT8_C( 120), INT8_C(-115),
                           INT8_C(  83), INT8_C(  26), INT8_C(-108), INT8_C(-128),
                           INT8_C( 113), INT8_C( -65), INT8_C(  84), INT8_C( -78)),
      simde_mm512_set_epi8(INT8_C(-100), INT8_C(-107), INT8_C( 106), INT8_C( -87),
                           INT8_C(  61), INT8_C( -94), INT8_C(   7), INT8_C(  84),
                           INT8_C(  25), INT8_C(  77), INT8_C(  24), INT8_C(  35),
                           INT8_C(  56), INT8_C( -72), INT8_C(  65), INT8_C( -77),
                           INT8_C(  81), INT8_C( 110), INT8_C( 109), INT8_C(  26),
                           INT8_C( -46), INT8_C(   6), INT8_C(  -4), INT8_C( -76),
                           INT8_C(  49), INT8_C(  67), INT8_C( -22), INT8_C(  12),
                           INT8_C(  66), INT8_C( -76), INT8_C( -71), INT8_C(  20),
                           INT8_C( -11), INT8_C(  97), INT8_C(  20), INT8_C(  -1),
                           INT8_C(  69), INT8_C(  54), INT8_C( -68), INT8_C( 104),
                           INT8_C(  61), INT8_C( -16), INT8_C( -52), INT8_C( -98),
                           INT8_C(-126), INT8_C(-109), INT8_C(  86), INT8_C(  51),
                           INT8_C(  95), INT8_C( -88), INT8_C(   6), INT8_C(-121),
                           INT8_C(  49), INT8_C(  97), INT8_C( -69), INT8_C( 125),
                           INT8_C(  57), INT8_C(  79), INT8_C(   6), INT8_C(   7),
                           INT8_C(  37), INT8_C(-119), INT8_C( -51), INT8_C(  99)),
      simde_mm512_set_epi8(INT8_C( -60), INT8_C( -92), INT8_C( -73), INT8_C( -20),
                           INT8_C( -84), INT8_C( -11), INT8_C( -28), INT8_C(-123),
                           INT8_C( -48), INT8_C(-118), INT8_C(-107), INT8_C(  73),
                           INT8_C( -80), INT8_C(  46), INT8_C(-117), INT8_C( -85),
                           INT8_C( -21), INT8_C( -54), INT8_C( -49), INT8_C(  -8),
                           INT8_C(  51), INT8_C( 126), INT8_C(  22), INT8_C(  70),
                           INT8_C( -86), INT8_C( -98), INT8_C( -17), INT8_C( -29),
                           INT8_C(  75), INT8_C( 115), INT8_C(  61), INT8_C(  76),
                           INT8_C(  86), INT8_C(  43), INT8_C(-128), INT8_C( 121),
                           INT8_C(  81), INT8_C(  58), INT8_C(  -6), INT8_C( -15),
                           INT8_C( -40), INT8_C( -16), INT8_C(  74), INT8_C(  32),
                           INT8_C(  22), INT8_C(  89), INT8_C( -73), INT8_C(-128),
                           INT8_C(  75), INT8_C( 127), INT8_C( -97), INT8_C(  55),
                           INT8_C(  60), INT8_C(  32), INT8_C( 127), INT8_C(-108),
                           INT8_C(  26), INT8_C( -53), INT8_C(-114), INT8_C( -57),
                           INT8_C(  28), INT8_C( -50), INT8_C( 127), INT8_C(-128)) },
    { simde_mm512_set_epi8(INT8_C(  66), INT8_C(  28), INT8_C( -53), INT8_C(  48),
                           INT8_C( -75), INT8_C( -97), INT8_C( -42), INT8_C(  47),
                           INT8_C( -33), INT8_C( -17), INT8_C( 113), INT8_C( 120),
                           INT8_C(-111), INT8_C(  14), INT8_C(  77), INT8_C(-108),
                           INT8_C(  25), INT8_C( -42), INT8_C( 109), INT8_C( -97),
                           INT8_C( -19), INT8_C( -18), INT8_C(  -1), INT8_C( -50),
                           INT8_C( -87), INT8_C( -70), INT8_C(  94), INT8_C( -91),
                           INT8_C(  23), INT8_C(  33), INT8_C( -10), INT8_C(  81),
                           INT8_C(  81), INT8_C( -63), INT8_C(  35), INT8_C(  44),
                           INT8_C(  11), INT8_C(-124), INT8_C( -20), INT8_C(  71),
                           INT8_C( -25), INT8_C(-112), INT8_C(   2), INT8_C(  59),
                           INT8_C(  21), INT8_C(-113), INT8_C(  35), INT8_C( -40),
                           INT8_C( -89), INT8_C( -74), INT8_C( -34), INT8_C( 115),
                           INT8_C( -51), INT8_C(  30), INT8_C(-104), INT8_C( 117),
                           INT8_C( 127), INT8_C(  -8), INT8_C(  57), INT8_C( -73),
                           INT8_C(  40), INT8_C(  -7), INT8_C(  90), INT8_C(-110)),
      UINT64_C(          3345097188),
      simde_mm512_set_epi8(INT8_C(  58), INT8_C(-128), INT8_C(-123), INT8_C(  -3),
                           INT8_C(  74), INT8_C( -78), INT8_C(-124), INT8_C( -30),
                           INT8_C(  21), INT8_C(  86), INT8_C( -53), INT8_C(-116),
                           INT8_C(-126), INT8_C(  10), INT8_C(-123), INT8_C( -78),
                           INT8_C(   2), INT8_C( 100), INT8_C( -90), INT8_C( -79),
                           INT8_C( -46), INT8_C( -83), INT8_C(  11), INT8_C(-120),
                           INT8_C( -56), INT8_C(  -4), INT8_C( -39), INT8_C(-114),
                           INT8_C( -98), INT8_C(-108), INT8_C( -22), INT8_C(  24),
                           INT8_C( 127), INT8_C( -20), INT8_C(   7), INT8_C( -16),
                           INT8_C(  -8), INT8_C(  19), INT8_C( 119), INT8_C( -44),
                           INT8_C(   7), INT8_C( -47), INT8_C(-126), INT8_C(-119),
                           INT8_C(   1), INT8_C( 111), INT8_C( -95), INT8_C( -67),
                           INT8_C(  38), INT8_C( -19), INT8_C(  96), INT8_C( -21),
                           INT8_C( -76), INT8_C(-123), INT8_C(-115), INT8_C( -61),
                           INT8_C(  96), INT8_C(  30), INT8_C( 105), INT8_C(  -4),
                           INT8_C(  44), INT8_C(  54), INT8_C(  89), INT8_C(  40)),
      simde_mm512_set_epi8(INT8_C( -42), INT8_C(  43), INT8_C(   6), INT8_C( -97),
                           INT8_C( -90), INT8_C(  -4), INT8_C( -71), INT8_C(  33),
                           INT8_C(   1), INT8_C(   3), INT8_C( -91), INT8_C( -62),
                           INT8_C(-106), INT8_C(  -6), INT8_C(  35), INT8_C(  67),
                           INT8_C(  97), INT8_C(  46), INT8_C(  89), INT8_C(  56),
                           INT8_C( -84), INT8_C( -39), INT8_C( -70), INT8_C(  78),
                           INT8_C( -49), INT8_C(  94), INT8_C(  -1), INT8_C( -23),
                           INT8_C( -88), INT8_C( -11), INT8_C(-128), INT8_C( -62),
                           INT8_C( 106), INT8_C( 125), INT8_C( -71), INT8_C( -96),
                           INT8_C( -28), INT8_C( -58), INT8_C( -40), INT8_C( -32),
                           INT8_C( -13), INT8_C( -84), INT8_C( -69), INT8_C( -40),
                           INT8_C(-122), INT8_C( 117), INT8_C( 115), INT8_C( -87),
                           INT8_C( 101), INT8_C( -82), INT8_C( -68), INT8_C( -48),
                           INT8_C(  42), INT8_C(  29), INT8_C(  67), INT8_C(   9),
                           INT8_C( -44), INT8_C(  54), INT8_C(-101), INT8_C( -13),
                           INT8_C( 111), INT8_C( 110), INT8_C( 114), INT8_C( -57)),
      simde_mm512_set_epi8(INT8_C(  66), INT8_C(  28), INT8_C( -53), INT8_C(  48),
                           INT8_C( -75), INT8_C( -97), INT8_C( -42), INT8_C(  47),
                           INT8_C( -33), INT8_C( -17), INT8_C( 113), INT8_C( 120),
                           INT8_C(-111), INT8_C(  14), INT8_C(  77), INT8_C(-108),
                           INT8_C(  25), INT8_C( -42), INT8_C( 109), INT8_C( -97),
                           INT8_C( -19), INT8_C( -18), INT8_C(  -1), INT8_C( -50),
                           INT8_C( -87), INT8_C( -70), INT8_C(  94), INT8_C( -91),
                           INT8_C(  23), INT8_C(  33), INT8_C( -10), INT8_C(  81),
                           INT8_C(  21), INT8_C(-128), INT8_C(  35), INT8_C(  44),
                           INT8_C(  11), INT8_C(  77), INT8_C( 127), INT8_C( -12),
                           INT8_C( -25), INT8_C(  37), INT8_C( -57), INT8_C(  59),
                           INT8_C(  21), INT8_C(-113), INT8_C(-128), INT8_C( -40),
                           INT8_C( -89), INT8_C( -74), INT8_C( 127), INT8_C( 115),
                           INT8_C( -51), INT8_C(  30), INT8_C(-104), INT8_C( -70),
                           INT8_C( 127), INT8_C( -24), INT8_C( 127), INT8_C( -73),
                           INT8_C(  40), INT8_C( -56), INT8_C(  90), INT8_C(-110)) },
    { simde_mm512_set_epi8(INT8_C( 127), INT8_C(  66), INT8_C(  63), INT8_C( -46),
                           INT8_C(  90), INT8_C(  39), INT8_C( -89), INT8_C(-105),
                           INT8_C( -51), INT8_C( -46), INT8_C( 111), INT8_C( -45),
                           INT8_C( -76), INT8_C(-112), INT8_C( -37), INT8_C(-120),
                           INT8_C(  50), INT8_C( -97), INT8_C(  -2), INT8_C( 121),
                           INT8_C(  68), INT8_C(-106), INT8_C( 101), INT8_C( 115),
                           INT8_C( -29), INT8_C(  59), INT8_C(  77), INT8_C( -36),
                           INT8_C( 111), INT8_C(  95), INT8_C(  48), INT8_C( 113),
                           INT8_C( -97), INT8_C( 105), INT8_C( -37), INT8_C( -42),
                           INT8_C(  -7), INT8_C(  31), INT8_C(  45), INT8_C(  -5),
                           INT8_C( -29), INT8_C(  44), INT8_C(  78), INT8_C( -25),
                           INT8_C( -47), INT8_C(-119), INT8_C( -90), INT8_C( 115),
                           INT8_C(  44), INT8_C(  94), INT8_C( 127), INT8_C( -12),
                           INT8_C(  90), INT8_C( 111), INT8_C( -20), INT8_C(-110),
                           INT8_C( -82), INT8_C( -19), INT8_C( -79), INT8_C(-128),
                           INT8_C(  -6), INT8_C(-119), INT8_C( 100), INT8_C( 125)),
      UINT64_C(          1390729414),
      simde_mm512_set_epi8(INT8_C(  89), INT8_C(  39), INT8_C( 109), INT8_C( 109),
                           INT8_C( -71), INT8_C( -81), INT8_C(  67), INT8_C(  48),
                           INT8_C( -43), INT8_C(  31), INT8_C( -36), INT8_C( -53),
                           INT8_C(  -7), INT8_C(  84), INT8_C( -92), INT8_C( 124),
                           INT8_C( -22), INT8_C(  31), INT8_C(  42), INT8_C(-103),
                           INT8_C(  29), INT8_C(  75), INT8_C( -91), INT8_C(  75),
                           INT8_C( 107), INT8_C(  62), INT8_C( 126), INT8_C(   7),
                           INT8_C( -89), INT8_C( 119), INT8_C(  79), INT8_C( -38),
                           INT8_C(  18), INT8_C(  57), INT8_C(-102), INT8_C(  66),
                           INT8_C(  -7), INT8_C(  89), INT8_C(  57), INT8_C( -55),
                           INT8_C( -68), INT8_C(  21), INT8_C( -21), INT8_C(  -6),
                           INT8_C( -26), INT8_C( 122), INT8_C( 114), INT8_C(  83),
                           INT8_C(  80), INT8_C( 103), INT8_C( 109), INT8_C( -19),
                           INT8_C( -24), INT8_C( -48), INT8_C(  79), INT8_C(   5),
                           INT8_C(  66), INT8_C( -40), INT8_C( -14), INT8_C( -56),
                           INT8_C( -68), INT8_C( -68), INT8_C(-124), INT8_C( -65)),
      simde_mm512_set_epi8(INT8_C(-102), INT8_C(-123), INT8_C(  20), INT8_C(  36),
                           INT8_C(  70), INT8_C( -95), INT8_C(  63), INT8_C( 110),
                           INT8_C(  98), INT8_C(-128), INT8_C( -74), INT8_C( -50),
                           INT8_C(  17), INT8_C( -37), INT8_C(-104), INT8_C( -74),
                           INT8_C(  -4), INT8_C(  15), INT8_C( -59), INT8_C(  62),
                           INT8_C( -89), INT8_C( 103), INT8_C(  -5), INT8_C(  71),
                           INT8_C( 103), INT8_C(-119), INT8_C( -62), INT8_C( -47),
                           INT8_C( -78), INT8_C(  32), INT8_C( 104), INT8_C(  33),
                           INT8_C( -45), INT8_C( -54), INT8_C(  17), INT8_C(-117),
                           INT8_C(  96), INT8_C(  66), INT8_C( -18), INT8_C( -58),
                           INT8_C(-111), INT8_C(-110), INT8_C( -14), INT8_C(   7),
                           INT8_C(  85), INT8_C(-113), INT8_C(  19), INT8_C( -72),
                           INT8_C(  51), INT8_C( -49), INT8_C(  69), INT8_C( -80),
                           INT8_C(  34), INT8_C(  87), INT8_C(  88), INT8_C( -38),
                           INT8_C( -14), INT8_C( -30), INT8_C(-111), INT8_C( -87),
                           INT8_C(  37), INT8_C(  40), INT8_C( -30), INT8_C( -40)),
      simde_mm512_set_epi8(INT8_C( 127), INT8_C(  66), INT8_C(  63), INT8_C( -46),
                           INT8_C(  90), INT8_C(  39), INT8_C( -89), INT8_C(-105),
                           INT8_C( -51), INT8_C( -46), INT8_C( 111), INT8_C( -45),
                           INT8_C( -76), INT8_C(-112), INT8_C( -37), INT8_C(-120),
                           INT8_C(  50), INT8_C( -97), INT8_C(  -2), INT8_C( 121),
                           INT8_C(  68), INT8_C(-106), INT8_C( 101), INT8_C( 115),
                           INT8_C( -29), INT8_C(  59), INT8_C(  77), INT8_C( -36),
                           INT8_C( 111), INT8_C(  95), INT8_C(  48), INT8_C( 113),
                           INT8_C( -97), INT8_C( 111), INT8_C( -37), INT8_C( 127),
                           INT8_C(  -7), INT8_C(  31), INT8_C(  75), INT8_C(  -5),
                           INT8_C(  43), INT8_C( 127), INT8_C(  -7), INT8_C( -25),
                           INT8_C( -47), INT8_C( 127), INT8_C( -90), INT8_C( 115),
                           INT8_C(  29), INT8_C( 127), INT8_C( 127), INT8_C(  61),
                           INT8_C( -58), INT8_C( 111), INT8_C( -20), INT8_C(-110),
                           INT8_C(  80), INT8_C( -10), INT8_C( -79), INT8_C(-128),
                           INT8_C(  -6), INT8_C(-108), INT8_C( -94), INT8_C( 125)) },
    { simde_mm512_set_epi8(INT8_C(  91), INT8_C(  46), INT8_C( -16), INT8_C(  27),
                           INT8_C( -66), INT8_C( -93), INT8_C( -43), INT8_C(  14),
                           INT8_C( 100), INT8_C(-113), INT8_C(  32), INT8_C(  15),
                           INT8_C( -79), INT8_C(  63), INT8_C( -18), INT8_C( -96),
                           INT8_C(-119), INT8_C( 114), INT8_C( -87), INT8_C( -82),
                           INT8_C(  76), INT8_C( 117), INT8_C(  14), INT8_C( -65),
                           INT8_C( -37), INT8_C( -15), INT8_C(  43), INT8_C(   5),
                           INT8_C(-108), INT8_C(  -5), INT8_C( -84), INT8_C(  13),
                           INT8_C( -66), INT8_C(  80), INT8_C( -20), INT8_C(  34),
                           INT8_C(-122), INT8_C(-101), INT8_C( -91), INT8_C( -35),
                           INT8_C(  57), INT8_C( 117), INT8_C( -26), INT8_C( 112),
                           INT8_C(  59), INT8_C(  54), INT8_C(  91), INT8_C(-111),
                           INT8_C( 111), INT8_C(  34), INT8_C( -76), INT8_C(  65),
                           INT8_C( -31), INT8_C(  25), INT8_C( -63), INT8_C(-128),
                           INT8_C( -28), INT8_C(  80), INT8_C( -75), INT8_C(  83),
                           INT8_C( -23), INT8_C( -65), INT8_C( -75), INT8_C( -10)),
      UINT64_C(          2530018527),
      simde_mm512_set_epi8(INT8_C(  54), INT8_C( 110), INT8_C( -53), INT8_C( 100),
                           INT8_C(  94), INT8_C(  -2), INT8_C(  72), INT8_C(  95),
                           INT8_C( -61), INT8_C( -31), INT8_C(   2), INT8_C(  88),
                           INT8_C(  69), INT8_C(-117), INT8_C(  33), INT8_C( -57),
                           INT8_C( -67), INT8_C(  92), INT8_C( -31), INT8_C( -16),
                           INT8_C(-115), INT8_C( -91), INT8_C(   0), INT8_C( -73),
                           INT8_C(  -3), INT8_C( -71), INT8_C(  55), INT8_C( -82),
                           INT8_C( -28), INT8_C( -34), INT8_C( -40), INT8_C(  60),
                           INT8_C(  31), INT8_C(-113), INT8_C(  90), INT8_C( 114),
                           INT8_C(  73), INT8_C(  77), INT8_C( -29), INT8_C(  80),
                           INT8_C(-106), INT8_C( 121), INT8_C(-122), INT8_C(  -4),
                           INT8_C( 104), INT8_C( -76), INT8_C(  85), INT8_C( -33),
                           INT8_C( -62), INT8_C(  96), INT8_C( -27), INT8_C( -88),
                           INT8_C( -35), INT8_C( -58), INT8_C( -83), INT8_C(  36),
                           INT8_C( -16), INT8_C(  50), INT8_C(-127), INT8_C( -82),
                           INT8_C( 106), INT8_C(  56), INT8_C(  74), INT8_C( -59)),
      simde_mm512_set_epi8(INT8_C( -24), INT8_C( -30), INT8_C(  27), INT8_C( -44),
                           INT8_C( -74), INT8_C( -85), INT8_C( -66), INT8_C(  26),
                           INT8_C( -69), INT8_C( 112), INT8_C( -22), INT8_C(  62),
                           INT8_C(  24), INT8_C(-107), INT8_C( -41), INT8_C( -21),
                           INT8_C(  68), INT8_C( -34), INT8_C( 109), INT8_C(  58),
                           INT8_C(  16), INT8_C( -72), INT8_C( -84), INT8_C(  18),
                           INT8_C( -73), INT8_C( -54), INT8_C(  16), INT8_C( -93),
                           INT8_C( -51), INT8_C( -50), INT8_C(  54), INT8_C( -69),
                           INT8_C( -98), INT8_C(-113), INT8_C( -73), INT8_C(-124),
                           INT8_C( -65), INT8_C( -51), INT8_C(  43), INT8_C(  10),
                           INT8_C( -79), INT8_C(  35), INT8_C( -67), INT8_C(  69),
                           INT8_C(  84), INT8_C( -44), INT8_C( -48), INT8_C(  89),
                           INT8_C(  96), INT8_C(-100), INT8_C( -47), INT8_C( 114),
                           INT8_C(-109), INT8_C(   8), INT8_C(  51), INT8_C( 120),
                           INT8_C( -12), INT8_C(-128), INT8_C(  -4), INT8_C(-105),
                           INT8_C(  83), INT8_C(-123), INT8_C( -98), INT8_C(  -2)),
      simde_mm512_set_epi8(INT8_C(  91), INT8_C(  46), INT8_C( -16), INT8_C(  27),
                           INT8_C( -66), INT8_C( -93), INT8_C( -43), INT8_C(  14),
                           INT8_C( 100), INT8_C(-113), INT8_C(  32), INT8_C(  15),
                           INT8_C( -79), INT8_C(  63), INT8_C( -18), INT8_C( -96),
                           INT8_C(-119), INT8_C( 114), INT8_C( -87), INT8_C( -82),
                           INT8_C(  76), INT8_C( 117), INT8_C(  14), INT8_C( -65),
                           INT8_C( -37), INT8_C( -15), INT8_C(  43), INT8_C(   5),
                           INT8_C(-108), INT8_C(  -5), INT8_C( -84), INT8_C(  13),
                           INT8_C( 127), INT8_C(  80), INT8_C( -20), INT8_C( 127),
                           INT8_C(-122), INT8_C( 127), INT8_C( -72), INT8_C( -35),
                           INT8_C( -27), INT8_C(  86), INT8_C( -26), INT8_C( 112),
                           INT8_C(  20), INT8_C( -32), INT8_C(  91), INT8_C(-122),
                           INT8_C( 111), INT8_C(  34), INT8_C( -76), INT8_C(  65),
                           INT8_C( -31), INT8_C( -66), INT8_C( -63), INT8_C(-128),
                           INT8_C(  -4), INT8_C( 127), INT8_C( -75), INT8_C(  23),
                           INT8_C(  23), INT8_C( 127), INT8_C( 127), INT8_C( -57)) },
    { simde_mm512_set_epi8(INT8_C( 125), INT8_C( -29), INT8_C( 116), INT8_C( -26),
                           INT8_C(  78), INT8_C(  37), INT8_C( -43), INT8_C(  45),
                           INT8_C( -81), INT8_C(-109), INT8_C(  26), INT8_C( -51),
                           INT8_C( -54), INT8_C(  99), INT8_C( 124), INT8_C(   2),
                           INT8_C(  10), INT8_C(   6), INT8_C( -77), INT8_C( -61),
                           INT8_C(  59), INT8_C(  60), INT8_C(  42), INT8_C(  33),
                           INT8_C( 126), INT8_C(  88), INT8_C(  41), INT8_C(  66),
                           INT8_C(  98), INT8_C( 111), INT8_C(  94), INT8_C( -70),
                           INT8_C( 116), INT8_C( -40), INT8_C( -88), INT8_C(  13),
                           INT8_C(  50), INT8_C(  54), INT8_C(  32), INT8_C( -48),
                           INT8_C(  85), INT8_C(  12), INT8_C( -17), INT8_C(  78),
                           INT8_C(   2), INT8_C( -46), INT8_C(  21), INT8_C(  89),
                           INT8_C( -58), INT8_C( -19), INT8_C(  -7), INT8_C( -46),
                           INT8_C(  58), INT8_C( 120), INT8_C( -85), INT8_C(  46),
                           INT8_C(  80), INT8_C( -20), INT8_C(  94), INT8_C(  32),
                           INT8_C( -61), INT8_C(  80), INT8_C( -39), INT8_C( 109)),
      UINT64_C(          1874542844),
      simde_mm512_set_epi8(INT8_C(-100), INT8_C(   8), INT8_C( -30), INT8_C( -66),
                           INT8_C( -36), INT8_C( -55), INT8_C(-115), INT8_C(  64),
                           INT8_C(  70), INT8_C(  -8), INT8_C(-128), INT8_C(  84),
                           INT8_C( 103), INT8_C( -54), INT8_C(  15), INT8_C( -45),
                           INT8_C(-118), INT8_C( -27), INT8_C(  32), INT8_C( -75),
                           INT8_C(  62), INT8_C(  67), INT8_C( -42), INT8_C(   4),
                           INT8_C(  16), INT8_C(  45), INT8_C(  43), INT8_C(  21),
                           INT8_C(  14), INT8_C( -97), INT8_C( -37), INT8_C(  -6),
                           INT8_C(-100), INT8_C( -82), INT8_C(  58), INT8_C(  88),
                           INT8_C(  61), INT8_C(  74), INT8_C(   5), INT8_C(  44),
                           INT8_C(  61), INT8_C( -83), INT8_C(  68), INT8_C(  -3),
                           INT8_C(  41), INT8_C( 117), INT8_C( 116), INT8_C( -16),
                           INT8_C(  48), INT8_C( -35), INT8_C(  -2), INT8_C(  -9),
                           INT8_C( -72), INT8_C(  97), INT8_C(-100), INT8_C( 120),
                           INT8_C( -96), INT8_C(  21), INT8_C(  35), INT8_C(  38),
                           INT8_C( -30), INT8_C(  81), INT8_C(-111), INT8_C(  42)),
      simde_mm512_set_epi8(INT8_C( -63), INT8_C( 101), INT8_C( -21), INT8_C( -29),
                           INT8_C( -58), INT8_C(  75), INT8_C( -46), INT8_C(  -8),
                           INT8_C( -92), INT8_C(  68), INT8_C(  64), INT8_C(  71),
                           INT8_C(  50), INT8_C( -60), INT8_C(  45), INT8_C(  13),
                           INT8_C( 106), INT8_C(  39), INT8_C(  64), INT8_C(  94),
                           INT8_C( -73), INT8_C(  90), INT8_C( -93), INT8_C(-109),
                           INT8_C(-100), INT8_C(  76), INT8_C(  29), INT8_C( -99),
                           INT8_C(  84), INT8_C(  37), INT8_C(  69), INT8_C( 125),
                           INT8_C( -66), INT8_C( 106), INT8_C(  75), INT8_C(-109),
                           INT8_C(  19), INT8_C( 119), INT8_C( 108), INT8_C(  52),
                           INT8_C( -69), INT8_C(  84), INT8_C(   6), INT8_C(  75),
                           INT8_C(   9), INT8_C(-103), INT8_C( -24), INT8_C(   9),
                           INT8_C( -42), INT8_C( 127), INT8_C(  47), INT8_C( -53),
                           INT8_C(  93), INT8_C(  18), INT8_C(  -4), INT8_C( -42),
                           INT8_C( -20), INT8_C(  12), INT8_C( 100), INT8_C( -66),
                           INT8_C( -56), INT8_C( -47), INT8_C( -16), INT8_C( 104)),
      simde_mm512_set_epi8(INT8_C( 125), INT8_C( -29), INT8_C( 116), INT8_C( -26),
                           INT8_C(  78), INT8_C(  37), INT8_C( -43), INT8_C(  45),
                           INT8_C( -81), INT8_C(-109), INT8_C(  26), INT8_C( -51),
                           INT8_C( -54), INT8_C(  99), INT8_C( 124), INT8_C(   2),
                           INT8_C(  10), INT8_C(   6), INT8_C( -77), INT8_C( -61),
                           INT8_C(  59), INT8_C(  60), INT8_C(  42), INT8_C(  33),
                           INT8_C( 126), INT8_C(  88), INT8_C(  41), INT8_C(  66),
                           INT8_C(  98), INT8_C( 111), INT8_C(  94), INT8_C( -70),
                           INT8_C( 116), INT8_C(-128), INT8_C( -17), INT8_C(  13),
                           INT8_C(  42), INT8_C( -45), INT8_C(-103), INT8_C(  -8),
                           INT8_C( 127), INT8_C(  12), INT8_C(  62), INT8_C( -78),
                           INT8_C(  32), INT8_C( -46), INT8_C( 127), INT8_C( -25),
                           INT8_C( -58), INT8_C(-128), INT8_C(  -7), INT8_C( -46),
                           INT8_C(  58), INT8_C( 120), INT8_C( -85), INT8_C(  46),
                           INT8_C( -76), INT8_C(   9), INT8_C( -65), INT8_C( 104),
                           INT8_C(  26), INT8_C( 127), INT8_C( -39), INT8_C( 109)) },
    { simde_mm512_set_epi8(INT8_C(-105), INT8_C( -37), INT8_C(  57), INT8_C( -65),
                           INT8_C( -18), INT8_C( -12), INT8_C( -19), INT8_C( 108),
                           INT8_C(-104), INT8_C( -75), INT8_C(  90), INT8_C(  70),
                           INT8_C( -27), INT8_C(  72), INT8_C(  24), INT8_C( -76),
                           INT8_C( -96), INT8_C(-123), INT8_C(  29), INT8_C(-106),
                           INT8_C(  55), INT8_C( 118), INT8_C(  81), INT8_C(  39),
                           INT8_C( -71), INT8_C( -44), INT8_C( 102), INT8_C( -78),
                           INT8_C( -31), INT8_C( -59), INT8_C(  63), INT8_C(   2),
                           INT8_C(-102), INT8_C(  50), INT8_C(  51), INT8_C(-105),
                           INT8_C( -79), INT8_C(  83), INT8_C(  28), INT8_C( 101),
                           INT8_C(  60), INT8_C( -89), INT8_C(-127), INT8_C(  40),
                           INT8_C(  37), INT8_C( -30), INT8_C( -95), INT8_C( -95),
                           INT8_C( -12), INT8_C( -31), INT8_C(  -9), INT8_C(  29),
                           INT8_C(  10), INT8_C(  43), INT8_C(  -6), INT8_C( -78),
                           INT8_C( -94), INT8_C( 107), INT8_C( 111), INT8_C(   4),
                           INT8_C(  -9), INT8_C(  42), INT8_C( -92), INT8_C(  29)),
      UINT64_C(          3975530942),
      simde_mm512_set_epi8(INT8_C( -43), INT8_C(  17), INT8_C(-121), INT8_C(  17),
                           INT8_C( -38), INT8_C(  95), INT8_C(  94), INT8_C( -34),
                           INT8_C(  26), INT8_C(-107), INT8_C(  37), INT8_C(-105),
                           INT8_C(  52), INT8_C(  37), INT8_C(  92), INT8_C( -72),
                           INT8_C( -33), INT8_C( -75), INT8_C( -94), INT8_C(   1),
                           INT8_C( -71), INT8_C(  17), INT8_C(-112), INT8_C( -35),
                           INT8_C(  16), INT8_C( 122), INT8_C( -73), INT8_C(  18),
                           INT8_C(  88), INT8_C(  56), INT8_C( -10), INT8_C( -55),
                           INT8_C( 123), INT8_C(-125), INT8_C( -53), INT8_C(  -1),
                           INT8_C(   2), INT8_C(  36), INT8_C( 121), INT8_C( -35),
                           INT8_C(  48), INT8_C(  77), INT8_C( 102), INT8_C( -56),
                           INT8_C(  57), INT8_C( -53), INT8_C( -69), INT8_C( -26),
                           INT8_C( -26), INT8_C(  90), INT8_C(  94), INT8_C(  84),
                           INT8_C( -13), INT8_C(  64), INT8_C( 115), INT8_C(-119),
                           INT8_C( 126), INT8_C(  83), INT8_C(  55), INT8_C( -37),
                           INT8_C( -59), INT8_C(  31), INT8_C(  24), INT8_C(  17)),
      simde_mm512_set_epi8(INT8_C(  74), INT8_C(  90), INT8_C(  31), INT8_C(  63),
                           INT8_C( -50), INT8_C(   3), INT8_C(  34), INT8_C( -98),
                           INT8_C( -18), INT8_C(-126), INT8_C(  83), INT8_C(  80),
                           INT8_C(  21), INT8_C( 114), INT8_C( -45), INT8_C( -76),
                           INT8_C( -10), INT8_C( -63), INT8_C( -36), INT8_C(-104),
                           INT8_C( -48), INT8_C( -29), INT8_C( -85), INT8_C(   3),
                           INT8_C(-112), INT8_C( -72), INT8_C(  68), INT8_C(   5),
                           INT8_C( -84), INT8_C( -48), INT8_C(-110), INT8_C(-128),
                           INT8_C(  89), INT8_C( -17), INT8_C(  -2), INT8_C( -14),
                           INT8_C(  61), INT8_C(  40), INT8_C( -41), INT8_C(  78),
                           INT8_C( -65), INT8_C(  82), INT8_C( -97), INT8_C(-107),
                           INT8_C(  36), INT8_C(  59), INT8_C( -78), INT8_C(  61),
                           INT8_C(   9), INT8_C(  86), INT8_C( 122), INT8_C(   2),
                           INT8_C(  27), INT8_C( 124), INT8_C( -38), INT8_C(  23),
                           INT8_C( -78), INT8_C(  48), INT8_C(  17), INT8_C(  54),
                           INT8_C( 116), INT8_C(-115), INT8_C( 105), INT8_C( -48)),
      simde_mm512_set_epi8(INT8_C(-105), INT8_C( -37), INT8_C(  57), INT8_C( -65),
                           INT8_C( -18), INT8_C( -12), INT8_C( -19), INT8_C( 108),
                           INT8_C(-104), INT8_C( -75), INT8_C(  90), INT8_C(  70),
                           INT8_C( -27), INT8_C(  72), INT8_C(  24), INT8_C( -76),
                           INT8_C( -96), INT8_C(-123), INT8_C(  29), INT8_C(-106),
                           INT8_C(  55), INT8_C( 118), INT8_C(  81), INT8_C(  39),
                           INT8_C( -71), INT8_C( -44), INT8_C( 102), INT8_C( -78),
                           INT8_C( -31), INT8_C( -59), INT8_C(  63), INT8_C(   2),
                           INT8_C(  34), INT8_C(-108), INT8_C( -51), INT8_C(-105),
                           INT8_C( -59), INT8_C(  -4), INT8_C(  28), INT8_C( 101),
                           INT8_C( 113), INT8_C(  -5), INT8_C( 127), INT8_C(  51),
                           INT8_C(  37), INT8_C(-112), INT8_C( -95), INT8_C( -87),
                           INT8_C( -35), INT8_C(   4), INT8_C(  -9), INT8_C(  29),
                           INT8_C( -40), INT8_C(  43), INT8_C(  -6), INT8_C(-128),
                           INT8_C( 127), INT8_C( 107), INT8_C(  38), INT8_C( -91),
                           INT8_C(-128), INT8_C( 127), INT8_C( -81), INT8_C(  29)) },
    { simde_mm512_set_epi8(INT8_C( -61), INT8_C( -50), INT8_C( -30), INT8_C( 100),
                           INT8_C( -32), INT8_C(-100), INT8_C(   0), INT8_C( -53),
                           INT8_C( -74), INT8_C(  41), INT8_C(  37), INT8_C(  44),
                           INT8_C(   4), INT8_C( -98), INT8_C(  73), INT8_C( -60),
                           INT8_C(  85), INT8_C(  11), INT8_C(  90), INT8_C(  41),
                           INT8_C(  94), INT8_C( 105), INT8_C(  -3), INT8_C( -61),
                           INT8_C( 118), INT8_C( -95), INT8_C(-121), INT8_C( -38),
                           INT8_C(-104), INT8_C(  36), INT8_C(  86), INT8_C(  49),
                           INT8_C( 118), INT8_C( -55), INT8_C( -12), INT8_C( -47),
                           INT8_C(  98), INT8_C(  69), INT8_C(-107), INT8_C( 120),
                           INT8_C(  49), INT8_C( 116), INT8_C( -55), INT8_C( -29),
                           INT8_C(  93), INT8_C(-120), INT8_C( 116), INT8_C(  -2),
                           INT8_C(-100), INT8_C(-116), INT8_C( -60), INT8_C( -65),
                           INT8_C(  55), INT8_C(  64), INT8_C( -42), INT8_C( -46),
                           INT8_C(-101), INT8_C(  -6), INT8_C( -22), INT8_C(  36),
                           INT8_C( 111), INT8_C( -33), INT8_C(  84), INT8_C(  25)),
      UINT64_C(          2085281943),
      simde_mm512_set_epi8(INT8_C( 125), INT8_C(   0), INT8_C(  14), INT8_C(  82),
                           INT8_C(  68), INT8_C( -35), INT8_C( -43), INT8_C(  -7),
                           INT8_C(  68), INT8_C( 127), INT8_C( -94), INT8_C( -60),
                           INT8_C( -16), INT8_C( -81), INT8_C(-125), INT8_C(  75),
                           INT8_C(  -5), INT8_C( 103), INT8_C(  97), INT8_C( -56),
                           INT8_C(   5), INT8_C(  -6), INT8_C(  40), INT8_C(  58),
                           INT8_C( 106), INT8_C(-112), INT8_C( -85), INT8_C(   2),
                           INT8_C(  42), INT8_C( -58), INT8_C( -70), INT8_C( -97),
                           INT8_C(  95), INT8_C(  14), INT8_C( 116), INT8_C( -67),
                           INT8_C(   1), INT8_C(  68), INT8_C( -54), INT8_C( -13),
                           INT8_C( -11), INT8_C( -60), INT8_C( -44), INT8_C( 102),
                           INT8_C(  -9), INT8_C( -71), INT8_C( -51), INT8_C(  40),
                           INT8_C(   0), INT8_C( -81), INT8_C(  85), INT8_C(-103),
                           INT8_C(  21), INT8_C( 112), INT8_C(  59), INT8_C( -49),
                           INT8_C( -57), INT8_C(  28), INT8_C( -72), INT8_C( -76),
                           INT8_C( -32), INT8_C( -46), INT8_C( -10), INT8_C(  43)),
      simde_mm512_set_epi8(INT8_C(  65), INT8_C(  28), INT8_C( 112), INT8_C(  84),
                           INT8_C( -84), INT8_C(  90), INT8_C(  43), INT8_C( -27),
                           INT8_C(  82), INT8_C( -68), INT8_C( -29), INT8_C(-114),
                           INT8_C(  96), INT8_C(  68), INT8_C(  41), INT8_C(  -5),
                           INT8_C(  60), INT8_C(  55), INT8_C(  65), INT8_C(  51),
                           INT8_C(-116), INT8_C(  90), INT8_C( 113), INT8_C(  72),
                           INT8_C( 119), INT8_C( -14), INT8_C(  52), INT8_C(  73),
                           INT8_C( -28), INT8_C( -61), INT8_C(  83), INT8_C(  94),
                           INT8_C( 116), INT8_C( -75), INT8_C(   6), INT8_C( -97),
                           INT8_C( 114), INT8_C( 125), INT8_C( -13), INT8_C( -39),
                           INT8_C( -76), INT8_C( -78), INT8_C( 126), INT8_C(  42),
                           INT8_C( -31), INT8_C(-119), INT8_C(  44), INT8_C( -13),
                           INT8_C(  39), INT8_C(  26), INT8_C( 103), INT8_C( 126),
                           INT8_C( -63), INT8_C( -48), INT8_C( -12), INT8_C(  54),
                           INT8_C( -42), INT8_C(  31), INT8_C(   1), INT8_C( 119),
                           INT8_C( -34), INT8_C( -59), INT8_C(-107), INT8_C( 102)),
      simde_mm512_set_epi8(INT8_C( -61), INT8_C( -50), INT8_C( -30), INT8_C( 100),
                           INT8_C( -32), INT8_C(-100), INT8_C(   0), INT8_C( -53),
                           INT8_C( -74), INT8_C(  41), INT8_C(  37), INT8_C(  44),
                           INT8_C(   4), INT8_C( -98), INT8_C(  73), INT8_C( -60),
                           INT8_C(  85), INT8_C(  11), INT8_C(  90), INT8_C(  41),
                           INT8_C(  94), INT8_C( 105), INT8_C(  -3), INT8_C( -61),
                           INT8_C( 118), INT8_C( -95), INT8_C(-121), INT8_C( -38),
                           INT8_C(-104), INT8_C(  36), INT8_C(  86), INT8_C(  49),
                           INT8_C( 118), INT8_C(  89), INT8_C( 110), INT8_C(  30),
                           INT8_C(-113), INT8_C( -57), INT8_C(-107), INT8_C( 120),
                           INT8_C(  49), INT8_C(  18), INT8_C( -55), INT8_C( -29),
                           INT8_C(  22), INT8_C(-120), INT8_C( -95), INT8_C(  -2),
                           INT8_C( -39), INT8_C(-107), INT8_C( -18), INT8_C( -65),
                           INT8_C(  55), INT8_C(  64), INT8_C( -42), INT8_C( -46),
                           INT8_C( -15), INT8_C(  -6), INT8_C( -22), INT8_C(-128),
                           INT8_C( 111), INT8_C(  13), INT8_C(  97), INT8_C( -59)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_subs_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_subs_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(          2568138505),
      simde_mm512_set_epi8(INT8_C(  65), INT8_C( -91), INT8_C( -13), INT8_C( 114),
                           INT8_C( 123), INT8_C( 107), INT8_C(-108), INT8_C(  15),
                           INT8_C(  52), INT8_C(-124), INT8_C( -17), INT8_C(  -9),
                           INT8_C(  31), INT8_C(  67), INT8_C( -76), INT8_C(  -4),
                           INT8_C( -52), INT8_C(  99), INT8_C( 106), INT8_C( -35),
                           INT8_C(-115), INT8_C(-127), INT8_C( 121), INT8_C( -60),
                           INT8_C( -27), INT8_C(  73), INT8_C( -21), INT8_C( -51),
                           INT8_C(-127), INT8_C(  68), INT8_C( 109), INT8_C(  35),
                           INT8_C(  96), INT8_C(   3), INT8_C( -62), INT8_C( -43),
                           INT8_C( -75), INT8_C( 102), INT8_C(-105), INT8_C(  63),
                           INT8_C(  64), INT8_C( 114), INT8_C( 112), INT8_C(  10),
                           INT8_C( 108), INT8_C(  71), INT8_C( -40), INT8_C(  20),
                           INT8_C( -40), INT8_C(  26), INT8_C( -94), INT8_C( 107),
                           INT8_C( -89), INT8_C(  22), INT8_C(  55), INT8_C( 105),
                           INT8_C(  23), INT8_C(  52), INT8_C(  82), INT8_C(  50),
                           INT8_C( -48), INT8_C(  77), INT8_C(  73), INT8_C(  98)),
      simde_mm512_set_epi8(INT8_C(  87), INT8_C( 118), INT8_C(  10), INT8_C( -53),
                           INT8_C( -21), INT8_C( -77), INT8_C(  81), INT8_C(  16),
                           INT8_C( 125), INT8_C(  53), INT8_C( -93), INT8_C( -44),
                           INT8_C( -14), INT8_C( -81), INT8_C(  93), INT8_C( -81),
                           INT8_C(  69), INT8_C(  88), INT8_C(  17), INT8_C(-127),
                           INT8_C(  49), INT8_C(  91), INT8_C(  55), INT8_C( -23),
                           INT8_C( -84), INT8_C(  12), INT8_C( -97), INT8_C( -75),
                           INT8_C(  99), INT8_C(  54), INT8_C( -92), INT8_C( -28),
                           INT8_C(  -2), INT8_C(  69), INT8_C(-102), INT8_C(  42),
                           INT8_C(  41), INT8_C(-101), INT8_C( -59), INT8_C( -72),
                           INT8_C( -53), INT8_C( -47), INT8_C( -78), INT8_C(  67),
                           INT8_C(  54), INT8_C(  12), INT8_C( -65), INT8_C( 101),
                           INT8_C(  77), INT8_C( -96), INT8_C( -15), INT8_C(  66),
                           INT8_C(  50), INT8_C(   9), INT8_C( -75), INT8_C( 102),
                           INT8_C(   2), INT8_C( -31), INT8_C(  83), INT8_C( -71),
                           INT8_C( -84), INT8_C( -66), INT8_C(-111), INT8_C(  -2)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  98), INT8_C(   0), INT8_C(   0), INT8_C( -85),
                           INT8_C(-116), INT8_C(   0), INT8_C(   0), INT8_C( 127),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -57),
                           INT8_C(   0), INT8_C(   0), INT8_C(  25), INT8_C(   0),
                           INT8_C(-117), INT8_C(   0), INT8_C( -79), INT8_C(   0),
                           INT8_C(-128), INT8_C(  13), INT8_C( 127), INT8_C(   3),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  36), INT8_C(   0), INT8_C(   0), INT8_C( 100)) },
    { UINT64_C(          2987001584),
      simde_mm512_set_epi8(INT8_C(  31), INT8_C( 110), INT8_C(-101), INT8_C( -57),
                           INT8_C(  28), INT8_C( -50), INT8_C( -16), INT8_C(  37),
                           INT8_C(  87), INT8_C(-105), INT8_C(  96), INT8_C( -79),
                           INT8_C(  99), INT8_C(  74), INT8_C(  20), INT8_C( 120),
                           INT8_C(  60), INT8_C(  49), INT8_C( 101), INT8_C( -94),
                           INT8_C(  -5), INT8_C( 114), INT8_C(  17), INT8_C(   1),
                           INT8_C(  36), INT8_C( -92), INT8_C(  39), INT8_C(-108),
                           INT8_C( -15), INT8_C(  14), INT8_C( -15), INT8_C(  79),
                           INT8_C( 112), INT8_C( 108), INT8_C( -44), INT8_C( -18),
                           INT8_C( 125), INT8_C(  93), INT8_C( -92), INT8_C( -51),
                           INT8_C(  21), INT8_C( -19), INT8_C( -56), INT8_C( 114),
                           INT8_C( -95), INT8_C(  40), INT8_C( -27), INT8_C( -85),
                           INT8_C(  26), INT8_C(  29), INT8_C( -30), INT8_C(  53),
                           INT8_C( -69), INT8_C( -26), INT8_C(  79), INT8_C(-124),
                           INT8_C( -35), INT8_C( -29), INT8_C( -59), INT8_C( -99),
                           INT8_C(-118), INT8_C(  30), INT8_C( 105), INT8_C(   3)),
      simde_mm512_set_epi8(INT8_C( 100), INT8_C(-112), INT8_C( 127), INT8_C(  -1),
                           INT8_C( -76), INT8_C( 101), INT8_C(  90), INT8_C( -29),
                           INT8_C( -60), INT8_C( -92), INT8_C( -73), INT8_C( -20),
                           INT8_C( -84), INT8_C( -11), INT8_C( -28), INT8_C(-123),
                           INT8_C( -48), INT8_C(-118), INT8_C(-107), INT8_C(  73),
                           INT8_C( -80), INT8_C(  46), INT8_C(-117), INT8_C( -85),
                           INT8_C( -21), INT8_C( -54), INT8_C( -49), INT8_C(  -8),
                           INT8_C(  51), INT8_C( 126), INT8_C(  22), INT8_C(  70),
                           INT8_C( -86), INT8_C( -98), INT8_C( -17), INT8_C( -29),
                           INT8_C(  75), INT8_C( 115), INT8_C(  61), INT8_C(  76),
                           INT8_C( -65), INT8_C(  43), INT8_C( -13), INT8_C(  -2),
                           INT8_C(  81), INT8_C( -26), INT8_C(  -6), INT8_C( -15),
                           INT8_C( -40), INT8_C(  72), INT8_C(  66), INT8_C(  32),
                           INT8_C(  22), INT8_C( -74), INT8_C( -73), INT8_C(  67),
                           INT8_C(  75), INT8_C( -18), INT8_C( -97), INT8_C(  75),
                           INT8_C( -47), INT8_C(  32), INT8_C(  26), INT8_C(-108)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C( -27), INT8_C(  11),
                           INT8_C(   0), INT8_C(   0), INT8_C(-128), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-128), INT8_C(   0), INT8_C( -21), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  48), INT8_C( 127), INT8_C(   0),
                           INT8_C(-110), INT8_C( -11), INT8_C(  38), INT8_C(-128),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(          1908364466),
      simde_mm512_set_epi8(INT8_C(  57), INT8_C(  79), INT8_C(   6), INT8_C(   7),
                           INT8_C(  37), INT8_C(-119), INT8_C( -51), INT8_C(  99),
                           INT8_C( -66), INT8_C( -12), INT8_C( -24), INT8_C(-107),
                           INT8_C(-117), INT8_C(  63), INT8_C(  42), INT8_C(  79),
                           INT8_C( -78), INT8_C( -79), INT8_C( -22), INT8_C( -52),
                           INT8_C( -78), INT8_C(  -8), INT8_C( -61), INT8_C( 101),
                           INT8_C(-111), INT8_C(  35), INT8_C( -89), INT8_C( 127),
                           INT8_C(  50), INT8_C(-115), INT8_C(  91), INT8_C( -72),
                           INT8_C( -97), INT8_C( -34), INT8_C( -80), INT8_C( -31),
                           INT8_C( -60), INT8_C( 119), INT8_C(-106), INT8_C(  66),
                           INT8_C(  75), INT8_C(-108), INT8_C(-113), INT8_C( 120),
                           INT8_C(  36), INT8_C( 112), INT8_C( -45), INT8_C(  41),
                           INT8_C(  90), INT8_C( -32), INT8_C(  22), INT8_C(  86),
                           INT8_C(  72), INT8_C( -20), INT8_C(  -4), INT8_C(-125),
                           INT8_C( -37), INT8_C(  84), INT8_C( -95), INT8_C( -66),
                           INT8_C( 109), INT8_C(  18), INT8_C( 120), INT8_C(-115)),
      simde_mm512_set_epi8(INT8_C( 127), INT8_C(  -8), INT8_C(  57), INT8_C( -73),
                           INT8_C(  40), INT8_C(  -7), INT8_C(  90), INT8_C(-110),
                           INT8_C(-100), INT8_C(-107), INT8_C( 106), INT8_C( -87),
                           INT8_C(  61), INT8_C( -94), INT8_C(   7), INT8_C(  84),
                           INT8_C(  25), INT8_C(  77), INT8_C(  24), INT8_C(  35),
                           INT8_C(  56), INT8_C( -72), INT8_C(  65), INT8_C( -77),
                           INT8_C(  81), INT8_C( 110), INT8_C( 109), INT8_C(  26),
                           INT8_C( -46), INT8_C(   6), INT8_C(  -4), INT8_C( -76),
                           INT8_C(  49), INT8_C(  67), INT8_C( -22), INT8_C(  12),
                           INT8_C(  66), INT8_C( -76), INT8_C( -71), INT8_C(  20),
                           INT8_C( -11), INT8_C(  97), INT8_C(  20), INT8_C(  -1),
                           INT8_C(  69), INT8_C(  54), INT8_C( -68), INT8_C( 104),
                           INT8_C(  61), INT8_C( -16), INT8_C( -52), INT8_C( -98),
                           INT8_C(-126), INT8_C(-109), INT8_C(  86), INT8_C(  51),
                           INT8_C(  95), INT8_C( -88), INT8_C(   6), INT8_C(-121),
                           INT8_C(  49), INT8_C(  97), INT8_C( -69), INT8_C( 125)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-101), INT8_C( -58), INT8_C( -43),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  46),
                           INT8_C(  86), INT8_C(   0), INT8_C(-128), INT8_C( 121),
                           INT8_C( -33), INT8_C(  58), INT8_C(  23), INT8_C( -63),
                           INT8_C(   0), INT8_C( -16), INT8_C(   0), INT8_C( 127),
                           INT8_C(   0), INT8_C(  89), INT8_C(   0), INT8_C(   0),
                           INT8_C(-128), INT8_C(   0), INT8_C(-101), INT8_C(  55),
                           INT8_C(   0), INT8_C(   0), INT8_C( 127), INT8_C(   0)) },
    { UINT64_C(          3441334389),
      simde_mm512_set_epi8(INT8_C(  96), INT8_C(  30), INT8_C( 105), INT8_C(  -4),
                           INT8_C(  44), INT8_C(  54), INT8_C(  89), INT8_C(  40),
                           INT8_C(  99), INT8_C(  41), INT8_C(   5), INT8_C(  -2),
                           INT8_C( -57), INT8_C(  98), INT8_C(  33), INT8_C( -28),
                           INT8_C(  66), INT8_C(  28), INT8_C( -53), INT8_C(  48),
                           INT8_C( -75), INT8_C( -97), INT8_C( -42), INT8_C(  47),
                           INT8_C( -33), INT8_C( -17), INT8_C( 113), INT8_C( 120),
                           INT8_C(-111), INT8_C(  14), INT8_C(  77), INT8_C(-108),
                           INT8_C(  25), INT8_C( -42), INT8_C( 109), INT8_C( -97),
                           INT8_C( -19), INT8_C( -18), INT8_C(  -1), INT8_C( -50),
                           INT8_C( -87), INT8_C( -70), INT8_C(  94), INT8_C( -91),
                           INT8_C(  23), INT8_C(  33), INT8_C( -10), INT8_C(  81),
                           INT8_C(  81), INT8_C( -63), INT8_C(  35), INT8_C(  44),
                           INT8_C(  11), INT8_C(-124), INT8_C( -20), INT8_C(  71),
                           INT8_C( -25), INT8_C(-112), INT8_C(   2), INT8_C(  59),
                           INT8_C(  21), INT8_C(-113), INT8_C(  35), INT8_C( -40)),
      simde_mm512_set_epi8(INT8_C( -44), INT8_C(  54), INT8_C(-101), INT8_C( -13),
                           INT8_C( 111), INT8_C( 110), INT8_C( 114), INT8_C( -57),
                           INT8_C(  58), INT8_C(-128), INT8_C(-123), INT8_C(  -3),
                           INT8_C(  74), INT8_C( -78), INT8_C(-124), INT8_C( -30),
                           INT8_C(  21), INT8_C(  86), INT8_C( -53), INT8_C(-116),
                           INT8_C(-126), INT8_C(  10), INT8_C(-123), INT8_C( -78),
                           INT8_C(   2), INT8_C( 100), INT8_C( -90), INT8_C( -79),
                           INT8_C( -46), INT8_C( -83), INT8_C(  11), INT8_C(-120),
                           INT8_C( -56), INT8_C(  -4), INT8_C( -39), INT8_C(-114),
                           INT8_C( -98), INT8_C(-108), INT8_C( -22), INT8_C(  24),
                           INT8_C( 127), INT8_C( -20), INT8_C(   7), INT8_C( -16),
                           INT8_C(  -8), INT8_C(  19), INT8_C( 119), INT8_C( -44),
                           INT8_C(   7), INT8_C( -47), INT8_C(-126), INT8_C(-119),
                           INT8_C(   1), INT8_C( 111), INT8_C( -95), INT8_C( -67),
                           INT8_C(  38), INT8_C( -19), INT8_C(  96), INT8_C( -21),
                           INT8_C( -76), INT8_C(-123), INT8_C(-115), INT8_C( -61)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  81), INT8_C( -38), INT8_C(   0), INT8_C(   0),
                           INT8_C(  79), INT8_C(  90), INT8_C(   0), INT8_C( -74),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -75),
                           INT8_C(  31), INT8_C(  14), INT8_C(-128), INT8_C(   0),
                           INT8_C(  74), INT8_C(   0), INT8_C(   0), INT8_C( 127),
                           INT8_C(  10), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -93), INT8_C( -94), INT8_C(  80),
                           INT8_C(   0), INT8_C(  10), INT8_C(   0), INT8_C(  21)) },
    { UINT64_C(           706560777),
      simde_mm512_set_epi8(INT8_C(  44), INT8_C(  94), INT8_C( 127), INT8_C( -12),
                           INT8_C(  90), INT8_C( 111), INT8_C( -20), INT8_C(-110),
                           INT8_C( -82), INT8_C( -19), INT8_C( -79), INT8_C(-128),
                           INT8_C(  -6), INT8_C(-119), INT8_C( 100), INT8_C( 125),
                           INT8_C( -42), INT8_C(  43), INT8_C(   6), INT8_C( -97),
                           INT8_C( -90), INT8_C(  -4), INT8_C( -71), INT8_C(  33),
                           INT8_C(   1), INT8_C(   3), INT8_C( -91), INT8_C( -62),
                           INT8_C(-106), INT8_C(  -6), INT8_C(  35), INT8_C(  67),
                           INT8_C(  97), INT8_C(  46), INT8_C(  89), INT8_C(  56),
                           INT8_C( -84), INT8_C( -39), INT8_C( -70), INT8_C(  78),
                           INT8_C( -49), INT8_C(  94), INT8_C(  -1), INT8_C( -23),
                           INT8_C( -88), INT8_C( -11), INT8_C(-128), INT8_C( -62),
                           INT8_C( 106), INT8_C( 125), INT8_C( -71), INT8_C( -96),
                           INT8_C( -28), INT8_C( -58), INT8_C( -40), INT8_C( -32),
                           INT8_C( -13), INT8_C( -84), INT8_C( -69), INT8_C( -40),
                           INT8_C(-122), INT8_C( 117), INT8_C( 115), INT8_C( -87)),
      simde_mm512_set_epi8(INT8_C(  66), INT8_C( -40), INT8_C( -14), INT8_C( -56),
                           INT8_C( -68), INT8_C( -68), INT8_C(-124), INT8_C( -65),
                           INT8_C(  41), INT8_C( -59), INT8_C(-122), INT8_C( 101),
                           INT8_C(  82), INT8_C( -28), INT8_C( -40), INT8_C( -58),
                           INT8_C( 127), INT8_C(  66), INT8_C(  63), INT8_C( -46),
                           INT8_C(  90), INT8_C(  39), INT8_C( -89), INT8_C(-105),
                           INT8_C( -51), INT8_C( -46), INT8_C( 111), INT8_C( -45),
                           INT8_C( -76), INT8_C(-112), INT8_C( -37), INT8_C(-120),
                           INT8_C(  50), INT8_C( -97), INT8_C(  -2), INT8_C( 121),
                           INT8_C(  68), INT8_C(-106), INT8_C( 101), INT8_C( 115),
                           INT8_C( -29), INT8_C(  59), INT8_C(  77), INT8_C( -36),
                           INT8_C( 111), INT8_C(  95), INT8_C(  48), INT8_C( 113),
                           INT8_C( -97), INT8_C( 105), INT8_C( -37), INT8_C( -42),
                           INT8_C(  -7), INT8_C(  31), INT8_C(  45), INT8_C(  -5),
                           INT8_C( -29), INT8_C(  44), INT8_C(  78), INT8_C( -25),
                           INT8_C( -47), INT8_C(-119), INT8_C( -90), INT8_C( 115)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  91), INT8_C(   0),
                           INT8_C(-128), INT8_C(   0), INT8_C(-128), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  13),
                           INT8_C(-128), INT8_C(-106), INT8_C(   0), INT8_C(-128),
                           INT8_C(   0), INT8_C(  20), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -85), INT8_C( -27),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -75), INT8_C(   0), INT8_C(   0), INT8_C(-128)) },
    { UINT64_C(          3905965829),
      simde_mm512_set_epi8(INT8_C(  51), INT8_C( -49), INT8_C(  69), INT8_C( -80),
                           INT8_C(  34), INT8_C(  87), INT8_C(  88), INT8_C( -38),
                           INT8_C( -14), INT8_C( -30), INT8_C(-111), INT8_C( -87),
                           INT8_C(  37), INT8_C(  40), INT8_C( -30), INT8_C( -40),
                           INT8_C(  89), INT8_C(  39), INT8_C( 109), INT8_C( 109),
                           INT8_C( -71), INT8_C( -81), INT8_C(  67), INT8_C(  48),
                           INT8_C( -43), INT8_C(  31), INT8_C( -36), INT8_C( -53),
                           INT8_C(  -7), INT8_C(  84), INT8_C( -92), INT8_C( 124),
                           INT8_C( -22), INT8_C(  31), INT8_C(  42), INT8_C(-103),
                           INT8_C(  29), INT8_C(  75), INT8_C( -91), INT8_C(  75),
                           INT8_C( 107), INT8_C(  62), INT8_C( 126), INT8_C(   7),
                           INT8_C( -89), INT8_C( 119), INT8_C(  79), INT8_C( -38),
                           INT8_C(  18), INT8_C(  57), INT8_C(-102), INT8_C(  66),
                           INT8_C(  -7), INT8_C(  89), INT8_C(  57), INT8_C( -55),
                           INT8_C( -68), INT8_C(  21), INT8_C( -21), INT8_C(  -6),
                           INT8_C( -26), INT8_C( 122), INT8_C( 114), INT8_C(  83)),
      simde_mm512_set_epi8(INT8_C( 111), INT8_C(  34), INT8_C( -76), INT8_C(  65),
                           INT8_C( -31), INT8_C(  25), INT8_C( -63), INT8_C(-128),
                           INT8_C( -28), INT8_C(  80), INT8_C( -75), INT8_C(  83),
                           INT8_C( -23), INT8_C( -65), INT8_C( -75), INT8_C( -10),
                           INT8_C(-102), INT8_C(-123), INT8_C(  20), INT8_C(  36),
                           INT8_C(  70), INT8_C( -95), INT8_C(  63), INT8_C( 110),
                           INT8_C(  98), INT8_C(-128), INT8_C( -74), INT8_C( -50),
                           INT8_C(  17), INT8_C( -37), INT8_C(-104), INT8_C( -74),
                           INT8_C(  -4), INT8_C(  15), INT8_C( -59), INT8_C(  62),
                           INT8_C( -89), INT8_C( 103), INT8_C(  -5), INT8_C(  71),
                           INT8_C( 103), INT8_C(-119), INT8_C( -62), INT8_C( -47),
                           INT8_C( -78), INT8_C(  32), INT8_C( 104), INT8_C(  33),
                           INT8_C( -45), INT8_C( -54), INT8_C(  17), INT8_C(-117),
                           INT8_C(  96), INT8_C(  66), INT8_C( -18), INT8_C( -58),
                           INT8_C(-111), INT8_C(-110), INT8_C( -14), INT8_C(   7),
                           INT8_C(  85), INT8_C(-113), INT8_C(  19), INT8_C( -72)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -18), INT8_C(  16), INT8_C( 101), INT8_C(   0),
                           INT8_C( 118), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   4), INT8_C( 127), INT8_C(   0), INT8_C(  54),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 111), INT8_C(   0), INT8_C(   0),
                           INT8_C(-103), INT8_C(  23), INT8_C(  75), INT8_C(   3),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 127), INT8_C(   0), INT8_C( 127)) },
    { UINT64_C(           993418129),
      simde_mm512_set_epi8(INT8_C( -62), INT8_C(  96), INT8_C( -27), INT8_C( -88),
                           INT8_C( -35), INT8_C( -58), INT8_C( -83), INT8_C(  36),
                           INT8_C( -16), INT8_C(  50), INT8_C(-127), INT8_C( -82),
                           INT8_C( 106), INT8_C(  56), INT8_C(  74), INT8_C( -59),
                           INT8_C( -80), INT8_C( -22), INT8_C(   6), INT8_C( -65),
                           INT8_C(-106), INT8_C( -51), INT8_C(   4), INT8_C( -33),
                           INT8_C(  91), INT8_C(  46), INT8_C( -16), INT8_C(  27),
                           INT8_C( -66), INT8_C( -93), INT8_C( -43), INT8_C(  14),
                           INT8_C( 100), INT8_C(-113), INT8_C(  32), INT8_C(  15),
                           INT8_C( -79), INT8_C(  63), INT8_C( -18), INT8_C( -96),
                           INT8_C(-119), INT8_C( 114), INT8_C( -87), INT8_C( -82),
                           INT8_C(  76), INT8_C( 117), INT8_C(  14), INT8_C( -65),
                           INT8_C( -37), INT8_C( -15), INT8_C(  43), INT8_C(   5),
                           INT8_C(-108), INT8_C(  -5), INT8_C( -84), INT8_C(  13),
                           INT8_C( -66), INT8_C(  80), INT8_C( -20), INT8_C(  34),
                           INT8_C(-122), INT8_C(-101), INT8_C( -91), INT8_C( -35)),
      simde_mm512_set_epi8(INT8_C(  96), INT8_C(-100), INT8_C( -47), INT8_C( 114),
                           INT8_C(-109), INT8_C(   8), INT8_C(  51), INT8_C( 120),
                           INT8_C( -12), INT8_C(-128), INT8_C(  -4), INT8_C(-105),
                           INT8_C(  83), INT8_C(-123), INT8_C( -98), INT8_C(  -2),
                           INT8_C(  54), INT8_C( 110), INT8_C( -53), INT8_C( 100),
                           INT8_C(  94), INT8_C(  -2), INT8_C(  72), INT8_C(  95),
                           INT8_C( -61), INT8_C( -31), INT8_C(   2), INT8_C(  88),
                           INT8_C(  69), INT8_C(-117), INT8_C(  33), INT8_C( -57),
                           INT8_C( -67), INT8_C(  92), INT8_C( -31), INT8_C( -16),
                           INT8_C(-115), INT8_C( -91), INT8_C(   0), INT8_C( -73),
                           INT8_C(  -3), INT8_C( -71), INT8_C(  55), INT8_C( -82),
                           INT8_C( -28), INT8_C( -34), INT8_C( -40), INT8_C(  60),
                           INT8_C(  31), INT8_C(-113), INT8_C(  90), INT8_C( 114),
                           INT8_C(  73), INT8_C(  77), INT8_C( -29), INT8_C(  80),
                           INT8_C(-106), INT8_C( 121), INT8_C(-122), INT8_C(  -4),
                           INT8_C( 104), INT8_C( -76), INT8_C(  85), INT8_C( -33)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  63), INT8_C(  31),
                           INT8_C(  36), INT8_C(   0), INT8_C( -18), INT8_C( -23),
                           INT8_C(   0), INT8_C(   0), INT8_C(-128), INT8_C(   0),
                           INT8_C(   0), INT8_C( 127), INT8_C(  54), INT8_C(   0),
                           INT8_C(   0), INT8_C(  98), INT8_C(   0), INT8_C(-109),
                           INT8_C(-128), INT8_C(   0), INT8_C( -55), INT8_C( -67),
                           INT8_C(  40), INT8_C(   0), INT8_C(   0), INT8_C(  38),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -2)) },
    { UINT64_C(          1423233113),
      simde_mm512_set_epi8(INT8_C(  85), INT8_C(  12), INT8_C( -17), INT8_C(  78),
                           INT8_C(   2), INT8_C( -46), INT8_C(  21), INT8_C(  89),
                           INT8_C( -58), INT8_C( -19), INT8_C(  -7), INT8_C( -46),
                           INT8_C(  58), INT8_C( 120), INT8_C( -85), INT8_C(  46),
                           INT8_C(  80), INT8_C( -20), INT8_C(  94), INT8_C(  32),
                           INT8_C( -61), INT8_C(  80), INT8_C( -39), INT8_C( 109),
                           INT8_C( -24), INT8_C( -30), INT8_C(  27), INT8_C( -44),
                           INT8_C( -74), INT8_C( -85), INT8_C( -66), INT8_C(  26),
                           INT8_C( -69), INT8_C( 112), INT8_C( -22), INT8_C(  62),
                           INT8_C(  24), INT8_C(-107), INT8_C( -41), INT8_C( -21),
                           INT8_C(  68), INT8_C( -34), INT8_C( 109), INT8_C(  58),
                           INT8_C(  16), INT8_C( -72), INT8_C( -84), INT8_C(  18),
                           INT8_C( -73), INT8_C( -54), INT8_C(  16), INT8_C( -93),
                           INT8_C( -51), INT8_C( -50), INT8_C(  54), INT8_C( -69),
                           INT8_C( -98), INT8_C(-113), INT8_C( -73), INT8_C(-124),
                           INT8_C( -65), INT8_C( -51), INT8_C(  43), INT8_C(  10)),
      simde_mm512_set_epi8(INT8_C(  48), INT8_C( -35), INT8_C(  -2), INT8_C(  -9),
                           INT8_C( -72), INT8_C(  97), INT8_C(-100), INT8_C( 120),
                           INT8_C( -96), INT8_C(  21), INT8_C(  35), INT8_C(  38),
                           INT8_C( -30), INT8_C(  81), INT8_C(-111), INT8_C(  42),
                           INT8_C(  39), INT8_C(-112), INT8_C(  20), INT8_C(-116),
                           INT8_C( 111), INT8_C( -69), INT8_C(  64), INT8_C(  -4),
                           INT8_C( 125), INT8_C( -29), INT8_C( 116), INT8_C( -26),
                           INT8_C(  78), INT8_C(  37), INT8_C( -43), INT8_C(  45),
                           INT8_C( -81), INT8_C(-109), INT8_C(  26), INT8_C( -51),
                           INT8_C( -54), INT8_C(  99), INT8_C( 124), INT8_C(   2),
                           INT8_C(  10), INT8_C(   6), INT8_C( -77), INT8_C( -61),
                           INT8_C(  59), INT8_C(  60), INT8_C(  42), INT8_C(  33),
                           INT8_C( 126), INT8_C(  88), INT8_C(  41), INT8_C(  66),
                           INT8_C(  98), INT8_C( 111), INT8_C(  94), INT8_C( -70),
                           INT8_C( 116), INT8_C( -40), INT8_C( -88), INT8_C(  13),
                           INT8_C(  50), INT8_C(  54), INT8_C(  32), INT8_C( -48)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 127), INT8_C(   0), INT8_C( 113),
                           INT8_C(   0), INT8_C(-128), INT8_C(   0), INT8_C(   0),
                           INT8_C(  58), INT8_C( -40), INT8_C(   0), INT8_C( 119),
                           INT8_C(   0), INT8_C(-128), INT8_C(   0), INT8_C(   0),
                           INT8_C(-128), INT8_C(-128), INT8_C(   0), INT8_C(-128),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -73), INT8_C(   0), INT8_C(-128),
                           INT8_C(-115), INT8_C(   0), INT8_C(   0), INT8_C(  58)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_subs_epi8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_subs_epi16(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi16(INT16_C( 21075), INT16_C( 30017), INT16_C(-11898), INT16_C( 29710),
                            INT16_C( 19457), INT16_C(-12796), INT16_C( 21427), INT16_C( 28826),
                            INT16_C( 25482), INT16_C(-11843), INT16_C( 15582), INT16_C( 20114),
                            INT16_C(-14761), INT16_C(-15590), INT16_C( -4142), INT16_C( 29932),
                            INT16_C(-30672), INT16_C(  6190), INT16_C( 26590), INT16_C( 10803),
                            INT16_C(-16554), INT16_C( 15816), INT16_C( 14967), INT16_C( 24063),
                            INT16_C(-14713), INT16_C( -8094), INT16_C(-16817), INT16_C( 25507),
                            INT16_C( 19912), INT16_C(-19929), INT16_C(-12604), INT16_C(-17156)),
      simde_mm512_set_epi16(INT16_C( 27175), INT16_C(-27122), INT16_C( -6914), INT16_C( 10212),
                            INT16_C( 13894), INT16_C( -4620), INT16_C(-10724), INT16_C( -3078),
                            INT16_C( 29698), INT16_C(  6009), INT16_C( 28893), INT16_C(-31734),
                            INT16_C( -3957), INT16_C(  6787), INT16_C(  9325), INT16_C(  7645),
                            INT16_C( -2133), INT16_C( -9633), INT16_C(-22525), INT16_C(  1124),
                            INT16_C( 21781), INT16_C( 17119), INT16_C(-19461), INT16_C(-32134),
                            INT16_C( -7507), INT16_C( 19092), INT16_C( 21408), INT16_C(-14444),
                            INT16_C( 22843), INT16_C( 28625), INT16_C( -2322), INT16_C(  5251)),
      simde_mm512_set_epi16(INT16_C( -6100), INT16_C( 32767), INT16_C( -4984), INT16_C( 19498),
                            INT16_C(  5563), INT16_C( -8176), INT16_C( 32151), INT16_C( 31904),
                            INT16_C( -4216), INT16_C(-17852), INT16_C(-13311), INT16_C( 32767),
                            INT16_C(-10804), INT16_C(-22377), INT16_C(-13467), INT16_C( 22287),
                            INT16_C(-28539), INT16_C( 15823), INT16_C( 32767), INT16_C(  9679),
                            INT16_C(-32768), INT16_C( -1303), INT16_C( 32767), INT16_C( 32767),
                            INT16_C( -7206), INT16_C(-27186), INT16_C(-32768), INT16_C( 32767),
                            INT16_C( -2931), INT16_C(-32768), INT16_C(-10282), INT16_C(-22407)) },
    { simde_mm512_set_epi16(INT16_C(-27508), INT16_C(  5509), INT16_C(-13526), INT16_C( 16909),
                            INT16_C(  2419), INT16_C( 22142), INT16_C( -6109), INT16_C( -1177),
                            INT16_C(  9839), INT16_C(  6329), INT16_C(  -239), INT16_C(-15885),
                            INT16_C(  3666), INT16_C( 20122), INT16_C( -1699), INT16_C(  6503),
                            INT16_C( 29169), INT16_C( -4681), INT16_C( -2713), INT16_C(-24709),
                            INT16_C(  7221), INT16_C( -3718), INT16_C(   970), INT16_C(-15558),
                            INT16_C(-11011), INT16_C(-10787), INT16_C(-29970), INT16_C(  3894),
                            INT16_C(-25914), INT16_C(-18758), INT16_C( 11824), INT16_C( -8868)),
      simde_mm512_set_epi16(INT16_C(  1604), INT16_C( 19874), INT16_C(-12133), INT16_C( -1966),
                            INT16_C( 13041), INT16_C(  1566), INT16_C(-11791), INT16_C( -3425),
                            INT16_C(  7377), INT16_C(-23380), INT16_C( -9249), INT16_C(-31251),
                            INT16_C( 14877), INT16_C( 24009), INT16_C(-32316), INT16_C(  8308),
                            INT16_C(-11725), INT16_C(-10230), INT16_C(  1074), INT16_C( 12341),
                            INT16_C( 19989), INT16_C( 16491), INT16_C(  4144), INT16_C(-11714),
                            INT16_C( 19285), INT16_C(-29198), INT16_C(-25258), INT16_C(-29514),
                            INT16_C(  9755), INT16_C(-29385), INT16_C(-23111), INT16_C( -3412)),
      simde_mm512_set_epi16(INT16_C(-29112), INT16_C(-14365), INT16_C( -1393), INT16_C( 18875),
                            INT16_C(-10622), INT16_C( 20576), INT16_C(  5682), INT16_C(  2248),
                            INT16_C(  2462), INT16_C( 29709), INT16_C(  9010), INT16_C( 15366),
                            INT16_C(-11211), INT16_C( -3887), INT16_C( 30617), INT16_C( -1805),
                            INT16_C( 32767), INT16_C(  5549), INT16_C( -3787), INT16_C(-32768),
                            INT16_C(-12768), INT16_C(-20209), INT16_C( -3174), INT16_C( -3844),
                            INT16_C(-30296), INT16_C( 18411), INT16_C( -4712), INT16_C( 32767),
                            INT16_C(-32768), INT16_C( 10627), INT16_C( 32767), INT16_C( -5456)) },
    { simde_mm512_set_epi16(INT16_C(   691), INT16_C( -4823), INT16_C( -3253), INT16_C(-31392),
                            INT16_C(-21784), INT16_C( -6740), INT16_C(  9130), INT16_C(-18273),
                            INT16_C( 11275), INT16_C(-27092), INT16_C(    90), INT16_C(-20133),
                            INT16_C( 30523), INT16_C( 27008), INT16_C( 28387), INT16_C( 17266),
                            INT16_C( -9777), INT16_C( 27096), INT16_C( -8328), INT16_C( -6812),
                            INT16_C(-22954), INT16_C( -4409), INT16_C( 21734), INT16_C(-19695),
                            INT16_C(-11981), INT16_C(-21195), INT16_C( 18272), INT16_C( 28327),
                            INT16_C(  7123), INT16_C(-32216), INT16_C( 24489), INT16_C(-15668)),
      simde_mm512_set_epi16(INT16_C(-21377), INT16_C( 15856), INT16_C(  7686), INT16_C(-28568),
                            INT16_C(-15192), INT16_C( -9747), INT16_C( 11300), INT16_C( 27000),
                            INT16_C( -6635), INT16_C(  3626), INT16_C( 12716), INT16_C(-30571),
                            INT16_C( 31697), INT16_C(  5622), INT16_C( 24444), INT16_C( -8226),
                            INT16_C( -8263), INT16_C(  2890), INT16_C( 26732), INT16_C( -8763),
                            INT16_C(-13950), INT16_C( 27415), INT16_C(  7653), INT16_C( 31511),
                            INT16_C(-21082), INT16_C(  2398), INT16_C( 23365), INT16_C(-12903),
                            INT16_C(-18221), INT16_C(  4204), INT16_C(-20453), INT16_C( 15021)),
      simde_mm512_set_epi16(INT16_C( 22068), INT16_C(-20679), INT16_C(-10939), INT16_C( -2824),
                            INT16_C( -6592), INT16_C(  3007), INT16_C( -2170), INT16_C(-32768),
                            INT16_C( 17910), INT16_C(-30718), INT16_C(-12626), INT16_C( 10438),
                            INT16_C( -1174), INT16_C( 21386), INT16_C(  3943), INT16_C( 25492),
                            INT16_C( -1514), INT16_C( 24206), INT16_C(-32768), INT16_C(  1951),
                            INT16_C( -9004), INT16_C(-31824), INT16_C( 14081), INT16_C(-32768),
                            INT16_C(  9101), INT16_C(-23593), INT16_C( -5093), INT16_C( 32767),
                            INT16_C( 25344), INT16_C(-32768), INT16_C( 32767), INT16_C(-30689)) },
    { simde_mm512_set_epi16(INT16_C(  4451), INT16_C( -3121), INT16_C( 11648), INT16_C( 14185),
                            INT16_C( -8499), INT16_C(-24679), INT16_C(-31633), INT16_C( 19019),
                            INT16_C( 26210), INT16_C(-29943), INT16_C(-18883), INT16_C( 25468),
                            INT16_C( 20366), INT16_C(  4961), INT16_C(-25468), INT16_C( -4158),
                            INT16_C(  6653), INT16_C( -1720), INT16_C(-29723), INT16_C(-14244),
                            INT16_C( -4917), INT16_C(   730), INT16_C(-20677), INT16_C( 16986),
                            INT16_C(  9316), INT16_C( 28795), INT16_C(-18273), INT16_C(-29423),
                            INT16_C(-23674), INT16_C(  7963), INT16_C( 28019), INT16_C( 13728)),
      simde_mm512_set_epi16(INT16_C(-10770), INT16_C( 29411), INT16_C( 30463), INT16_C( -4902),
                            INT16_C(-20392), INT16_C(-28251), INT16_C( 11448), INT16_C( 27155),
                            INT16_C(-11669), INT16_C( 11820), INT16_C(-16512), INT16_C( 10540),
                            INT16_C( 17477), INT16_C(-19759), INT16_C( 28024), INT16_C(-14431),
                            INT16_C( 24400), INT16_C( -7583), INT16_C(-12129), INT16_C( 28592),
                            INT16_C(-31057), INT16_C(-18091), INT16_C( 19926), INT16_C(-29261),
                            INT16_C(  7501), INT16_C( 16620), INT16_C(  6953), INT16_C(  3437),
                            INT16_C(  5790), INT16_C(  5348), INT16_C( 17145), INT16_C(-28791)),
      simde_mm512_set_epi16(INT16_C( 15221), INT16_C(-32532), INT16_C(-18815), INT16_C( 19087),
                            INT16_C( 11893), INT16_C(  3572), INT16_C(-32768), INT16_C( -8136),
                            INT16_C( 32767), INT16_C(-32768), INT16_C( -2371), INT16_C( 14928),
                            INT16_C(  2889), INT16_C( 24720), INT16_C(-32768), INT16_C( 10273),
                            INT16_C(-17747), INT16_C(  5863), INT16_C(-17594), INT16_C(-32768),
                            INT16_C( 26140), INT16_C( 18821), INT16_C(-32768), INT16_C( 32767),
                            INT16_C(  1815), INT16_C( 12175), INT16_C(-25226), INT16_C(-32768),
                            INT16_C(-29464), INT16_C(  2615), INT16_C( 10874), INT16_C( 32767)) },
    { simde_mm512_set_epi16(INT16_C(-31561), INT16_C( 18949), INT16_C( -2287), INT16_C(-20534),
                            INT16_C( -1057), INT16_C( -3046), INT16_C( 22138), INT16_C(-11031),
                            INT16_C(    43), INT16_C( -6266), INT16_C(-20090), INT16_C(-22393),
                            INT16_C(-26046), INT16_C(-23703), INT16_C( 28092), INT16_C(  6346),
                            INT16_C( 10308), INT16_C(   572), INT16_C(     5), INT16_C( 15306),
                            INT16_C(-19429), INT16_C( -5811), INT16_C(-27420), INT16_C(-29128),
                            INT16_C(-13676), INT16_C( -3673), INT16_C(-26157), INT16_C( 19197),
                            INT16_C(-27593), INT16_C(-20030), INT16_C(  3690), INT16_C( -3850)),
      simde_mm512_set_epi16(INT16_C(-11908), INT16_C( 14774), INT16_C(  5244), INT16_C( 18107),
                            INT16_C(-16396), INT16_C( 31910), INT16_C(-28865), INT16_C(-20038),
                            INT16_C(-19234), INT16_C(-15108), INT16_C(-10436), INT16_C( 19911),
                            INT16_C(  3330), INT16_C( 28633), INT16_C( 10550), INT16_C( -9358),
                            INT16_C( 23697), INT16_C( 19726), INT16_C(-26407), INT16_C(-18878),
                            INT16_C(  4326), INT16_C(-22642), INT16_C(-17402), INT16_C( 16035),
                            INT16_C( 14223), INT16_C(-15160), INT16_C( -9470), INT16_C( -3752),
                            INT16_C(  6710), INT16_C( 21116), INT16_C( -9579), INT16_C( 10253)),
      simde_mm512_set_epi16(INT16_C(-19653), INT16_C(  4175), INT16_C( -7531), INT16_C(-32768),
                            INT16_C( 15339), INT16_C(-32768), INT16_C( 32767), INT16_C(  9007),
                            INT16_C( 19277), INT16_C(  8842), INT16_C( -9654), INT16_C(-32768),
                            INT16_C(-29376), INT16_C(-32768), INT16_C( 17542), INT16_C( 15704),
                            INT16_C(-13389), INT16_C(-19154), INT16_C( 26412), INT16_C( 32767),
                            INT16_C(-23755), INT16_C( 16831), INT16_C(-10018), INT16_C(-32768),
                            INT16_C(-27899), INT16_C( 11487), INT16_C(-16687), INT16_C( 22949),
                            INT16_C(-32768), INT16_C(-32768), INT16_C( 13269), INT16_C(-14103)) },
    { simde_mm512_set_epi16(INT16_C(  1468), INT16_C( -4389), INT16_C(  1296), INT16_C(-27715),
                            INT16_C(-15620), INT16_C(  3731), INT16_C( -7289), INT16_C(-27703),
                            INT16_C(   474), INT16_C( 27447), INT16_C( -9036), INT16_C(  9176),
                            INT16_C(  2726), INT16_C(-12144), INT16_C( -2101), INT16_C( 26907),
                            INT16_C(-24700), INT16_C(  1244), INT16_C( -3927), INT16_C(-22632),
                            INT16_C( -7525), INT16_C( 17743), INT16_C( 15263), INT16_C( -3823),
                            INT16_C( 27307), INT16_C( 32391), INT16_C(-23270), INT16_C(-29301),
                            INT16_C( 23369), INT16_C(-15291), INT16_C( -5840), INT16_C( 18168)),
      simde_mm512_set_epi16(INT16_C( 23449), INT16_C( 17725), INT16_C(-20919), INT16_C( 31466),
                            INT16_C( 31308), INT16_C( -2183), INT16_C(-31351), INT16_C(-32386),
                            INT16_C( 26890), INT16_C(-30591), INT16_C(-12785), INT16_C(-23638),
                            INT16_C(-31955), INT16_C( -9847), INT16_C( 19108), INT16_C(-19915),
                            INT16_C(  4587), INT16_C( 27034), INT16_C(   -19), INT16_C( 28332),
                            INT16_C(-23789), INT16_C(-24960), INT16_C( -5839), INT16_C( 25722),
                            INT16_C(-24423), INT16_C( 15592), INT16_C(  6092), INT16_C( -9272),
                            INT16_C(-12796), INT16_C(-17663), INT16_C( -6154), INT16_C( 23859)),
      simde_mm512_set_epi16(INT16_C(-21981), INT16_C(-22114), INT16_C( 22215), INT16_C(-32768),
                            INT16_C(-32768), INT16_C(  5914), INT16_C( 24062), INT16_C(  4683),
                            INT16_C(-26416), INT16_C( 32767), INT16_C(  3749), INT16_C( 32767),
                            INT16_C( 32767), INT16_C( -2297), INT16_C(-21209), INT16_C( 32767),
                            INT16_C(-29287), INT16_C(-25790), INT16_C( -3908), INT16_C(-32768),
                            INT16_C( 16264), INT16_C( 32767), INT16_C( 21102), INT16_C(-29545),
                            INT16_C( 32767), INT16_C( 16799), INT16_C(-29362), INT16_C(-20029),
                            INT16_C( 32767), INT16_C(  2372), INT16_C(   314), INT16_C( -5691)) },
    { simde_mm512_set_epi16(INT16_C(-22741), INT16_C( 13394), INT16_C( -9417), INT16_C( 28906),
                            INT16_C(-18980), INT16_C( -8463), INT16_C(  9174), INT16_C(-25605),
                            INT16_C(   547), INT16_C(  3767), INT16_C(-12577), INT16_C(-16546),
                            INT16_C( -1301), INT16_C( -7147), INT16_C( 26281), INT16_C( 29309),
                            INT16_C( 29052), INT16_C(-30842), INT16_C(  5995), INT16_C(  6270),
                            INT16_C( 20539), INT16_C( 10179), INT16_C(-26848), INT16_C( 14327),
                            INT16_C( 15491), INT16_C( 18652), INT16_C( 19903), INT16_C( 30123),
                            INT16_C( 25261), INT16_C(-17460), INT16_C( 10742), INT16_C( -4552)),
      simde_mm512_set_epi16(INT16_C(  5754), INT16_C(-23038), INT16_C(-16589), INT16_C(-23858),
                            INT16_C( -3821), INT16_C( -4798), INT16_C( 30602), INT16_C(-28532),
                            INT16_C( 11508), INT16_C(  7979), INT16_C( -3877), INT16_C( -5920),
                            INT16_C(-24150), INT16_C(-24496), INT16_C( 17421), INT16_C( -1981),
                            INT16_C( 27523), INT16_C( 26800), INT16_C( 25010), INT16_C( 27339),
                            INT16_C( -9050), INT16_C( 19128), INT16_C( 15279), INT16_C( -1817),
                            INT16_C(-13923), INT16_C(  5129), INT16_C(-22618), INT16_C( 27704),
                            INT16_C( -4783), INT16_C( 31238), INT16_C(-30342), INT16_C( -8854)),
      simde_mm512_set_epi16(INT16_C(-28495), INT16_C( 32767), INT16_C(  7172), INT16_C( 32767),
                            INT16_C(-15159), INT16_C( -3665), INT16_C(-21428), INT16_C(  2927),
                            INT16_C(-10961), INT16_C( -4212), INT16_C( -8700), INT16_C(-10626),
                            INT16_C( 22849), INT16_C( 17349), INT16_C(  8860), INT16_C( 31290),
                            INT16_C(  1529), INT16_C(-32768), INT16_C(-19015), INT16_C(-21069),
                            INT16_C( 29589), INT16_C( -8949), INT16_C(-32768), INT16_C( 16144),
                            INT16_C( 29414), INT16_C( 13523), INT16_C( 32767), INT16_C(  2419),
                            INT16_C( 30044), INT16_C(-32768), INT16_C( 32767), INT16_C(  4302)) },
    { simde_mm512_set_epi16(INT16_C( 27021), INT16_C( 31131), INT16_C(    63), INT16_C(-10530),
                            INT16_C( -1071), INT16_C(-31284), INT16_C(-21788), INT16_C(-16108),
                            INT16_C(-15167), INT16_C( 25422), INT16_C( 14520), INT16_C(-13896),
                            INT16_C( 20399), INT16_C( 31915), INT16_C(-16518), INT16_C( -6202),
                            INT16_C(-16332), INT16_C( -3071), INT16_C(-15644), INT16_C( -7016),
                            INT16_C( 13977), INT16_C(-13846), INT16_C(-23290), INT16_C( -2079),
                            INT16_C(  4753), INT16_C( 14919), INT16_C(-18528), INT16_C(  7420),
                            INT16_C( 12098), INT16_C( 31014), INT16_C( 17813), INT16_C(-14456)),
      simde_mm512_set_epi16(INT16_C(-12529), INT16_C( -3643), INT16_C(-28826), INT16_C(-12110),
                            INT16_C(  8030), INT16_C( 20316), INT16_C( 27324), INT16_C( 24735),
                            INT16_C( -6774), INT16_C( -2704), INT16_C(-31930), INT16_C(  6874),
                            INT16_C( -3952), INT16_C(  2658), INT16_C(  -904), INT16_C( -8319),
                            INT16_C(-16424), INT16_C( 22778), INT16_C( 18985), INT16_C( 10063),
                            INT16_C(-31751), INT16_C( 16016), INT16_C(-30217), INT16_C( 18364),
                            INT16_C(-20176), INT16_C( -4961), INT16_C(-29576), INT16_C(-16634),
                            INT16_C( -8011), INT16_C(-27110), INT16_C(-24526), INT16_C(-11504)),
      simde_mm512_set_epi16(INT16_C( 32767), INT16_C( 32767), INT16_C( 28889), INT16_C(  1580),
                            INT16_C( -9101), INT16_C(-32768), INT16_C(-32768), INT16_C(-32768),
                            INT16_C( -8393), INT16_C( 28126), INT16_C( 32767), INT16_C(-20770),
                            INT16_C( 24351), INT16_C( 29257), INT16_C(-15614), INT16_C(  2117),
                            INT16_C(    92), INT16_C(-25849), INT16_C(-32768), INT16_C(-17079),
                            INT16_C( 32767), INT16_C(-29862), INT16_C(  6927), INT16_C(-20443),
                            INT16_C( 24929), INT16_C( 19880), INT16_C( 11048), INT16_C( 24054),
                            INT16_C( 20109), INT16_C( 32767), INT16_C( 32767), INT16_C( -2952)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_subs_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_subs_epu8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C( 82), UINT8_C( 83), UINT8_C(117), UINT8_C( 65),
                             UINT8_C(209), UINT8_C(134), UINT8_C(116), UINT8_C( 14),
                             UINT8_C( 76), UINT8_C(  1), UINT8_C(206), UINT8_C(  4),
                             UINT8_C( 83), UINT8_C(179), UINT8_C(112), UINT8_C(154),
                             UINT8_C( 99), UINT8_C(138), UINT8_C(209), UINT8_C(189),
                             UINT8_C( 60), UINT8_C(222), UINT8_C( 78), UINT8_C(146),
                             UINT8_C(198), UINT8_C( 87), UINT8_C(195), UINT8_C( 26),
                             UINT8_C(239), UINT8_C(210), UINT8_C(116), UINT8_C(236),
                             UINT8_C(136), UINT8_C( 48), UINT8_C( 24), UINT8_C( 46),
                             UINT8_C(103), UINT8_C(222), UINT8_C( 42), UINT8_C( 51),
                             UINT8_C(191), UINT8_C( 86), UINT8_C( 61), UINT8_C(200),
                             UINT8_C( 58), UINT8_C(119), UINT8_C( 93), UINT8_C(255),
                             UINT8_C(198), UINT8_C(135), UINT8_C(224), UINT8_C( 98),
                             UINT8_C(190), UINT8_C( 79), UINT8_C( 99), UINT8_C(163),
                             UINT8_C( 77), UINT8_C(200), UINT8_C(178), UINT8_C( 39),
                             UINT8_C(206), UINT8_C(196), UINT8_C(188), UINT8_C(252)),
      simde_x_mm512_set_epu8(UINT8_C(106), UINT8_C( 39), UINT8_C(150), UINT8_C( 14),
                             UINT8_C(228), UINT8_C(254), UINT8_C( 39), UINT8_C(228),
                             UINT8_C( 54), UINT8_C( 70), UINT8_C(237), UINT8_C(244),
                             UINT8_C(214), UINT8_C( 28), UINT8_C(243), UINT8_C(250),
                             UINT8_C(116), UINT8_C(  2), UINT8_C( 23), UINT8_C(121),
                             UINT8_C(112), UINT8_C(221), UINT8_C(132), UINT8_C( 10),
                             UINT8_C(240), UINT8_C(139), UINT8_C( 26), UINT8_C(131),
                             UINT8_C( 36), UINT8_C(109), UINT8_C( 29), UINT8_C(221),
                             UINT8_C(247), UINT8_C(171), UINT8_C(218), UINT8_C( 95),
                             UINT8_C(168), UINT8_C(  3), UINT8_C(  4), UINT8_C(100),
                             UINT8_C( 85), UINT8_C( 21), UINT8_C( 66), UINT8_C(223),
                             UINT8_C(179), UINT8_C(251), UINT8_C(130), UINT8_C(122),
                             UINT8_C(226), UINT8_C(173), UINT8_C( 74), UINT8_C(148),
                             UINT8_C( 83), UINT8_C(160), UINT8_C(199), UINT8_C(148),
                             UINT8_C( 89), UINT8_C( 59), UINT8_C(111), UINT8_C(209),
                             UINT8_C(246), UINT8_C(238), UINT8_C( 20), UINT8_C(131)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C( 44), UINT8_C(  0), UINT8_C( 51),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 77), UINT8_C(  0),
                             UINT8_C( 22), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(151), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(136), UINT8_C(186), UINT8_C( 68),
                             UINT8_C(  0), UINT8_C(  1), UINT8_C(  0), UINT8_C(136),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(169), UINT8_C(  0),
                             UINT8_C(203), UINT8_C(101), UINT8_C( 87), UINT8_C( 15),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(219), UINT8_C( 38), UINT8_C(  0),
                             UINT8_C(106), UINT8_C( 65), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(133),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(150), UINT8_C(  0),
                             UINT8_C(107), UINT8_C(  0), UINT8_C(  0), UINT8_C( 15),
                             UINT8_C(  0), UINT8_C(141), UINT8_C( 67), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(168), UINT8_C(121)) },
    { simde_x_mm512_set_epu8(UINT8_C(148), UINT8_C(140), UINT8_C( 21), UINT8_C(133),
                             UINT8_C(203), UINT8_C( 42), UINT8_C( 66), UINT8_C( 13),
                             UINT8_C(  9), UINT8_C(115), UINT8_C( 86), UINT8_C(126),
                             UINT8_C(232), UINT8_C( 35), UINT8_C(251), UINT8_C(103),
                             UINT8_C( 38), UINT8_C(111), UINT8_C( 24), UINT8_C(185),
                             UINT8_C(255), UINT8_C( 17), UINT8_C(193), UINT8_C(243),
                             UINT8_C( 14), UINT8_C( 82), UINT8_C( 78), UINT8_C(154),
                             UINT8_C(249), UINT8_C( 93), UINT8_C( 25), UINT8_C(103),
                             UINT8_C(113), UINT8_C(241), UINT8_C(237), UINT8_C(183),
                             UINT8_C(245), UINT8_C(103), UINT8_C(159), UINT8_C(123),
                             UINT8_C( 28), UINT8_C( 53), UINT8_C(241), UINT8_C(122),
                             UINT8_C(  3), UINT8_C(202), UINT8_C(195), UINT8_C( 58),
                             UINT8_C(212), UINT8_C(253), UINT8_C(213), UINT8_C(221),
                             UINT8_C(138), UINT8_C(238), UINT8_C( 15), UINT8_C( 54),
                             UINT8_C(154), UINT8_C(198), UINT8_C(182), UINT8_C(186),
                             UINT8_C( 46), UINT8_C( 48), UINT8_C(221), UINT8_C( 92)),
      simde_x_mm512_set_epu8(UINT8_C(  6), UINT8_C( 68), UINT8_C( 77), UINT8_C(162),
                             UINT8_C(208), UINT8_C(155), UINT8_C(248), UINT8_C( 82),
                             UINT8_C( 50), UINT8_C(241), UINT8_C(  6), UINT8_C( 30),
                             UINT8_C(209), UINT8_C(241), UINT8_C(242), UINT8_C(159),
                             UINT8_C( 28), UINT8_C(209), UINT8_C(164), UINT8_C(172),
                             UINT8_C(219), UINT8_C(223), UINT8_C(133), UINT8_C(237),
                             UINT8_C( 58), UINT8_C( 29), UINT8_C( 93), UINT8_C(201),
                             UINT8_C(129), UINT8_C(196), UINT8_C( 32), UINT8_C(116),
                             UINT8_C(210), UINT8_C( 51), UINT8_C(216), UINT8_C( 10),
                             UINT8_C(  4), UINT8_C( 50), UINT8_C( 48), UINT8_C( 53),
                             UINT8_C( 78), UINT8_C( 21), UINT8_C( 64), UINT8_C(107),
                             UINT8_C( 16), UINT8_C( 48), UINT8_C(210), UINT8_C( 62),
                             UINT8_C( 75), UINT8_C( 85), UINT8_C(141), UINT8_C(242),
                             UINT8_C(157), UINT8_C( 86), UINT8_C(140), UINT8_C(182),
                             UINT8_C( 38), UINT8_C( 27), UINT8_C(141), UINT8_C( 55),
                             UINT8_C(165), UINT8_C(185), UINT8_C(242), UINT8_C(172)),
      simde_x_mm512_set_epu8(UINT8_C(142), UINT8_C( 72), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 80), UINT8_C( 96),
                             UINT8_C( 23), UINT8_C(  0), UINT8_C(  9), UINT8_C(  0),
                             UINT8_C( 10), UINT8_C(  0), UINT8_C(  0), UINT8_C( 13),
                             UINT8_C( 36), UINT8_C(  0), UINT8_C( 60), UINT8_C(  6),
                             UINT8_C(  0), UINT8_C( 53), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(120), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(190), UINT8_C( 21), UINT8_C(173),
                             UINT8_C(241), UINT8_C( 53), UINT8_C(111), UINT8_C( 70),
                             UINT8_C(  0), UINT8_C( 32), UINT8_C(177), UINT8_C( 15),
                             UINT8_C(  0), UINT8_C(154), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(137), UINT8_C(168), UINT8_C( 72), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(152), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(116), UINT8_C(171), UINT8_C( 41), UINT8_C(131),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0)) },
    { simde_x_mm512_set_epu8(UINT8_C(  2), UINT8_C(179), UINT8_C(237), UINT8_C( 41),
                             UINT8_C(243), UINT8_C( 75), UINT8_C(133), UINT8_C( 96),
                             UINT8_C(170), UINT8_C(232), UINT8_C(229), UINT8_C(172),
                             UINT8_C( 35), UINT8_C(170), UINT8_C(184), UINT8_C(159),
                             UINT8_C( 44), UINT8_C( 11), UINT8_C(150), UINT8_C( 44),
                             UINT8_C(  0), UINT8_C( 90), UINT8_C(177), UINT8_C( 91),
                             UINT8_C(119), UINT8_C( 59), UINT8_C(105), UINT8_C(128),
                             UINT8_C(110), UINT8_C(227), UINT8_C( 67), UINT8_C(114),
                             UINT8_C(217), UINT8_C(207), UINT8_C(105), UINT8_C(216),
                             UINT8_C(223), UINT8_C(120), UINT8_C(229), UINT8_C(100),
                             UINT8_C(166), UINT8_C( 86), UINT8_C(238), UINT8_C(199),
                             UINT8_C( 84), UINT8_C(230), UINT8_C(179), UINT8_C( 17),
                             UINT8_C(209), UINT8_C( 51), UINT8_C(173), UINT8_C( 53),
                             UINT8_C( 71), UINT8_C( 96), UINT8_C(110), UINT8_C(167),
                             UINT8_C( 27), UINT8_C(211), UINT8_C(130), UINT8_C( 40),
                             UINT8_C( 95), UINT8_C(169), UINT8_C(194), UINT8_C(204)),
      simde_x_mm512_set_epu8(UINT8_C(172), UINT8_C(127), UINT8_C( 61), UINT8_C(240),
                             UINT8_C( 30), UINT8_C(  6), UINT8_C(144), UINT8_C(104),
                             UINT8_C(196), UINT8_C(168), UINT8_C(217), UINT8_C(237),
                             UINT8_C( 44), UINT8_C( 36), UINT8_C(105), UINT8_C(120),
                             UINT8_C(230), UINT8_C( 21), UINT8_C( 14), UINT8_C( 42),
                             UINT8_C( 49), UINT8_C(172), UINT8_C(136), UINT8_C(149),
                             UINT8_C(123), UINT8_C(209), UINT8_C( 21), UINT8_C(246),
                             UINT8_C( 95), UINT8_C(124), UINT8_C(223), UINT8_C(222),
                             UINT8_C(223), UINT8_C(185), UINT8_C( 11), UINT8_C( 74),
                             UINT8_C(104), UINT8_C(108), UINT8_C(221), UINT8_C(197),
                             UINT8_C(201), UINT8_C(130), UINT8_C(107), UINT8_C( 23),
                             UINT8_C( 29), UINT8_C(229), UINT8_C(123), UINT8_C( 23),
                             UINT8_C(173), UINT8_C(166), UINT8_C(  9), UINT8_C( 94),
                             UINT8_C( 91), UINT8_C( 69), UINT8_C(205), UINT8_C(153),
                             UINT8_C(184), UINT8_C(211), UINT8_C( 16), UINT8_C(108),
                             UINT8_C(176), UINT8_C( 27), UINT8_C( 58), UINT8_C(173)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C( 52), UINT8_C(176), UINT8_C(  0),
                             UINT8_C(213), UINT8_C( 69), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 64), UINT8_C( 12), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(134), UINT8_C( 79), UINT8_C( 39),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(136), UINT8_C(  2),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 41), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 84), UINT8_C(  0),
                             UINT8_C( 15), UINT8_C(103), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 22), UINT8_C( 94), UINT8_C(142),
                             UINT8_C(119), UINT8_C( 12), UINT8_C(  8), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(131), UINT8_C(176),
                             UINT8_C( 55), UINT8_C(  1), UINT8_C( 56), UINT8_C(  0),
                             UINT8_C( 36), UINT8_C(  0), UINT8_C(164), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 27), UINT8_C(  0), UINT8_C( 14),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(114), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(142), UINT8_C(136), UINT8_C( 31)) },
    { simde_x_mm512_set_epu8(UINT8_C( 17), UINT8_C( 99), UINT8_C(243), UINT8_C(207),
                             UINT8_C( 45), UINT8_C(128), UINT8_C( 55), UINT8_C(105),
                             UINT8_C(222), UINT8_C(205), UINT8_C(159), UINT8_C(153),
                             UINT8_C(132), UINT8_C(111), UINT8_C( 74), UINT8_C( 75),
                             UINT8_C(102), UINT8_C( 98), UINT8_C(139), UINT8_C(  9),
                             UINT8_C(182), UINT8_C( 61), UINT8_C( 99), UINT8_C(124),
                             UINT8_C( 79), UINT8_C(142), UINT8_C( 19), UINT8_C( 97),
                             UINT8_C(156), UINT8_C(132), UINT8_C(239), UINT8_C(194),
                             UINT8_C( 25), UINT8_C(253), UINT8_C(249), UINT8_C( 72),
                             UINT8_C(139), UINT8_C(229), UINT8_C(200), UINT8_C( 92),
                             UINT8_C(236), UINT8_C(203), UINT8_C(  2), UINT8_C(218),
                             UINT8_C(175), UINT8_C( 59), UINT8_C( 66), UINT8_C( 90),
                             UINT8_C( 36), UINT8_C(100), UINT8_C(112), UINT8_C(123),
                             UINT8_C(184), UINT8_C(159), UINT8_C(141), UINT8_C( 17),
                             UINT8_C(163), UINT8_C(134), UINT8_C( 31), UINT8_C( 27),
                             UINT8_C(109), UINT8_C(115), UINT8_C( 53), UINT8_C(160)),
      simde_x_mm512_set_epu8(UINT8_C(213), UINT8_C(238), UINT8_C(114), UINT8_C(227),
                             UINT8_C(118), UINT8_C(255), UINT8_C(236), UINT8_C(218),
                             UINT8_C(176), UINT8_C( 88), UINT8_C(145), UINT8_C(165),
                             UINT8_C( 44), UINT8_C(184), UINT8_C(106), UINT8_C( 19),
                             UINT8_C(210), UINT8_C(107), UINT8_C( 46), UINT8_C( 44),
                             UINT8_C(191), UINT8_C(128), UINT8_C( 41), UINT8_C( 44),
                             UINT8_C( 68), UINT8_C( 69), UINT8_C(178), UINT8_C(209),
                             UINT8_C(109), UINT8_C(120), UINT8_C(199), UINT8_C(161),
                             UINT8_C( 95), UINT8_C( 80), UINT8_C(226), UINT8_C( 97),
                             UINT8_C(208), UINT8_C(159), UINT8_C(111), UINT8_C(176),
                             UINT8_C(134), UINT8_C(175), UINT8_C(185), UINT8_C( 85),
                             UINT8_C( 77), UINT8_C(214), UINT8_C(141), UINT8_C(179),
                             UINT8_C( 29), UINT8_C( 77), UINT8_C( 64), UINT8_C(236),
                             UINT8_C( 27), UINT8_C( 41), UINT8_C( 13), UINT8_C(109),
                             UINT8_C( 22), UINT8_C(158), UINT8_C( 20), UINT8_C(228),
                             UINT8_C( 66), UINT8_C(249), UINT8_C(143), UINT8_C(137)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(129), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 46), UINT8_C(117), UINT8_C( 14), UINT8_C(  0),
                             UINT8_C( 88), UINT8_C(  0), UINT8_C(  0), UINT8_C( 56),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 93), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 58), UINT8_C( 80),
                             UINT8_C( 11), UINT8_C( 73), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 47), UINT8_C( 12), UINT8_C( 40), UINT8_C( 33),
                             UINT8_C(  0), UINT8_C(173), UINT8_C( 23), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 70), UINT8_C( 89), UINT8_C(  0),
                             UINT8_C(102), UINT8_C( 28), UINT8_C(  0), UINT8_C(133),
                             UINT8_C( 98), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  7), UINT8_C( 23), UINT8_C( 48), UINT8_C(  0),
                             UINT8_C(157), UINT8_C(118), UINT8_C(128), UINT8_C(  0),
                             UINT8_C(141), UINT8_C(  0), UINT8_C( 11), UINT8_C(  0),
                             UINT8_C( 43), UINT8_C(  0), UINT8_C(  0), UINT8_C( 23)) },
    { simde_x_mm512_set_epu8(UINT8_C(132), UINT8_C(183), UINT8_C( 74), UINT8_C(  5),
                             UINT8_C(247), UINT8_C( 17), UINT8_C(175), UINT8_C(202),
                             UINT8_C(251), UINT8_C(223), UINT8_C(244), UINT8_C( 26),
                             UINT8_C( 86), UINT8_C(122), UINT8_C(212), UINT8_C(233),
                             UINT8_C(  0), UINT8_C( 43), UINT8_C(231), UINT8_C(134),
                             UINT8_C(177), UINT8_C(134), UINT8_C(168), UINT8_C(135),
                             UINT8_C(154), UINT8_C( 66), UINT8_C(163), UINT8_C(105),
                             UINT8_C(109), UINT8_C(188), UINT8_C( 24), UINT8_C(202),
                             UINT8_C( 40), UINT8_C( 68), UINT8_C(  2), UINT8_C( 60),
                             UINT8_C(  0), UINT8_C(  5), UINT8_C( 59), UINT8_C(202),
                             UINT8_C(180), UINT8_C( 27), UINT8_C(233), UINT8_C( 77),
                             UINT8_C(148), UINT8_C(228), UINT8_C(142), UINT8_C( 56),
                             UINT8_C(202), UINT8_C(148), UINT8_C(241), UINT8_C(167),
                             UINT8_C(153), UINT8_C(211), UINT8_C( 74), UINT8_C(253),
                             UINT8_C(148), UINT8_C( 55), UINT8_C(177), UINT8_C(194),
                             UINT8_C( 14), UINT8_C(106), UINT8_C(240), UINT8_C(246)),
      simde_x_mm512_set_epu8(UINT8_C(209), UINT8_C(124), UINT8_C( 57), UINT8_C(182),
                             UINT8_C( 20), UINT8_C(124), UINT8_C( 70), UINT8_C(187),
                             UINT8_C(191), UINT8_C(244), UINT8_C(124), UINT8_C(166),
                             UINT8_C(143), UINT8_C( 63), UINT8_C(177), UINT8_C(186),
                             UINT8_C(180), UINT8_C(222), UINT8_C(196), UINT8_C(252),
                             UINT8_C(215), UINT8_C( 60), UINT8_C( 77), UINT8_C(199),
                             UINT8_C( 13), UINT8_C(  2), UINT8_C(111), UINT8_C(217),
                             UINT8_C( 41), UINT8_C( 54), UINT8_C(219), UINT8_C(114),
                             UINT8_C( 92), UINT8_C(145), UINT8_C( 77), UINT8_C( 14),
                             UINT8_C(152), UINT8_C(217), UINT8_C(182), UINT8_C( 66),
                             UINT8_C( 16), UINT8_C(230), UINT8_C(167), UINT8_C(142),
                             UINT8_C(188), UINT8_C(  6), UINT8_C( 62), UINT8_C(163),
                             UINT8_C( 55), UINT8_C(143), UINT8_C(196), UINT8_C(200),
                             UINT8_C(219), UINT8_C(  2), UINT8_C(241), UINT8_C( 88),
                             UINT8_C( 26), UINT8_C( 54), UINT8_C( 82), UINT8_C(124),
                             UINT8_C(218), UINT8_C(149), UINT8_C( 40), UINT8_C( 13)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C( 59), UINT8_C( 17), UINT8_C(  0),
                             UINT8_C(227), UINT8_C(  0), UINT8_C(105), UINT8_C( 15),
                             UINT8_C( 60), UINT8_C(  0), UINT8_C(120), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 59), UINT8_C( 35), UINT8_C( 47),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 35), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 74), UINT8_C( 91), UINT8_C(  0),
                             UINT8_C(141), UINT8_C( 64), UINT8_C( 52), UINT8_C(  0),
                             UINT8_C( 68), UINT8_C(134), UINT8_C(  0), UINT8_C( 88),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 46),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(136),
                             UINT8_C(164), UINT8_C(  0), UINT8_C( 66), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(222), UINT8_C( 80), UINT8_C(  0),
                             UINT8_C(147), UINT8_C(  5), UINT8_C( 45), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(209), UINT8_C(  0), UINT8_C(165),
                             UINT8_C(122), UINT8_C(  1), UINT8_C( 95), UINT8_C( 70),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(200), UINT8_C(233)) },
    { simde_x_mm512_set_epu8(UINT8_C(  5), UINT8_C(188), UINT8_C(238), UINT8_C(219),
                             UINT8_C(  5), UINT8_C( 16), UINT8_C(147), UINT8_C(189),
                             UINT8_C(194), UINT8_C(252), UINT8_C( 14), UINT8_C(147),
                             UINT8_C(227), UINT8_C(135), UINT8_C(147), UINT8_C(201),
                             UINT8_C(  1), UINT8_C(218), UINT8_C(107), UINT8_C( 55),
                             UINT8_C(220), UINT8_C(180), UINT8_C( 35), UINT8_C(216),
                             UINT8_C( 10), UINT8_C(166), UINT8_C(208), UINT8_C(144),
                             UINT8_C(247), UINT8_C(203), UINT8_C(105), UINT8_C( 27),
                             UINT8_C(159), UINT8_C(132), UINT8_C(  4), UINT8_C(220),
                             UINT8_C(240), UINT8_C(169), UINT8_C(167), UINT8_C(152),
                             UINT8_C(226), UINT8_C(155), UINT8_C( 69), UINT8_C( 79),
                             UINT8_C( 59), UINT8_C(159), UINT8_C(241), UINT8_C( 17),
                             UINT8_C(106), UINT8_C(171), UINT8_C(126), UINT8_C(135),
                             UINT8_C(165), UINT8_C( 26), UINT8_C(141), UINT8_C(139),
                             UINT8_C( 91), UINT8_C( 73), UINT8_C(196), UINT8_C( 69),
                             UINT8_C(233), UINT8_C( 48), UINT8_C( 70), UINT8_C(248)),
      simde_x_mm512_set_epu8(UINT8_C( 91), UINT8_C(153), UINT8_C( 69), UINT8_C( 61),
                             UINT8_C(174), UINT8_C( 73), UINT8_C(122), UINT8_C(234),
                             UINT8_C(122), UINT8_C( 76), UINT8_C(247), UINT8_C(121),
                             UINT8_C(133), UINT8_C(137), UINT8_C(129), UINT8_C(126),
                             UINT8_C(105), UINT8_C( 10), UINT8_C(136), UINT8_C(129),
                             UINT8_C(206), UINT8_C( 15), UINT8_C(163), UINT8_C(170),
                             UINT8_C(131), UINT8_C( 45), UINT8_C(217), UINT8_C(137),
                             UINT8_C( 74), UINT8_C(164), UINT8_C(178), UINT8_C( 53),
                             UINT8_C( 17), UINT8_C(235), UINT8_C(105), UINT8_C(154),
                             UINT8_C(255), UINT8_C(237), UINT8_C(110), UINT8_C(172),
                             UINT8_C(163), UINT8_C( 19), UINT8_C(158), UINT8_C(128),
                             UINT8_C(233), UINT8_C( 49), UINT8_C(100), UINT8_C(122),
                             UINT8_C(160), UINT8_C(153), UINT8_C( 60), UINT8_C(232),
                             UINT8_C( 23), UINT8_C(204), UINT8_C(219), UINT8_C(200),
                             UINT8_C(206), UINT8_C(  4), UINT8_C(187), UINT8_C(  1),
                             UINT8_C(231), UINT8_C(246), UINT8_C( 93), UINT8_C( 51)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C( 35), UINT8_C(169), UINT8_C(158),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 25), UINT8_C(  0),
                             UINT8_C( 72), UINT8_C(176), UINT8_C(  0), UINT8_C( 26),
                             UINT8_C( 94), UINT8_C(  0), UINT8_C( 18), UINT8_C( 75),
                             UINT8_C(  0), UINT8_C(208), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 14), UINT8_C(165), UINT8_C(  0), UINT8_C( 46),
                             UINT8_C(  0), UINT8_C(121), UINT8_C(  0), UINT8_C(  7),
                             UINT8_C(173), UINT8_C( 39), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(142), UINT8_C(  0), UINT8_C(  0), UINT8_C( 66),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 57), UINT8_C(  0),
                             UINT8_C( 63), UINT8_C(136), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(110), UINT8_C(141), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 18), UINT8_C( 66), UINT8_C(  0),
                             UINT8_C(142), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 69), UINT8_C(  9), UINT8_C( 68),
                             UINT8_C(  2), UINT8_C(  0), UINT8_C(  0), UINT8_C(197)) },
    { simde_x_mm512_set_epu8(UINT8_C(167), UINT8_C( 43), UINT8_C( 52), UINT8_C( 82),
                             UINT8_C(219), UINT8_C( 55), UINT8_C(112), UINT8_C(234),
                             UINT8_C(181), UINT8_C(220), UINT8_C(222), UINT8_C(241),
                             UINT8_C( 35), UINT8_C(214), UINT8_C(155), UINT8_C(251),
                             UINT8_C(  2), UINT8_C( 35), UINT8_C( 14), UINT8_C(183),
                             UINT8_C(206), UINT8_C(223), UINT8_C(191), UINT8_C( 94),
                             UINT8_C(250), UINT8_C(235), UINT8_C(228), UINT8_C( 21),
                             UINT8_C(102), UINT8_C(169), UINT8_C(114), UINT8_C(125),
                             UINT8_C(113), UINT8_C(124), UINT8_C(135), UINT8_C(134),
                             UINT8_C( 23), UINT8_C(107), UINT8_C( 24), UINT8_C(126),
                             UINT8_C( 80), UINT8_C( 59), UINT8_C( 39), UINT8_C(195),
                             UINT8_C(151), UINT8_C( 32), UINT8_C( 55), UINT8_C(247),
                             UINT8_C( 60), UINT8_C(131), UINT8_C( 72), UINT8_C(220),
                             UINT8_C( 77), UINT8_C(191), UINT8_C(117), UINT8_C(171),
                             UINT8_C( 98), UINT8_C(173), UINT8_C(187), UINT8_C(204),
                             UINT8_C( 41), UINT8_C(246), UINT8_C(238), UINT8_C( 56)),
      simde_x_mm512_set_epu8(UINT8_C( 22), UINT8_C(122), UINT8_C(166), UINT8_C(  2),
                             UINT8_C(191), UINT8_C( 51), UINT8_C(162), UINT8_C(206),
                             UINT8_C(241), UINT8_C( 19), UINT8_C(237), UINT8_C( 66),
                             UINT8_C(119), UINT8_C(138), UINT8_C(144), UINT8_C(140),
                             UINT8_C( 44), UINT8_C(244), UINT8_C( 31), UINT8_C( 43),
                             UINT8_C(240), UINT8_C(219), UINT8_C(232), UINT8_C(224),
                             UINT8_C(161), UINT8_C(170), UINT8_C(160), UINT8_C( 80),
                             UINT8_C( 68), UINT8_C( 13), UINT8_C(248), UINT8_C( 67),
                             UINT8_C(107), UINT8_C(131), UINT8_C(104), UINT8_C(176),
                             UINT8_C( 97), UINT8_C(178), UINT8_C(106), UINT8_C(203),
                             UINT8_C(220), UINT8_C(166), UINT8_C( 74), UINT8_C(184),
                             UINT8_C( 59), UINT8_C(175), UINT8_C(248), UINT8_C(231),
                             UINT8_C(201), UINT8_C(157), UINT8_C( 20), UINT8_C(  9),
                             UINT8_C(167), UINT8_C(166), UINT8_C(108), UINT8_C( 56),
                             UINT8_C(237), UINT8_C( 81), UINT8_C(122), UINT8_C(  6),
                             UINT8_C(137), UINT8_C(122), UINT8_C(221), UINT8_C(106)),
      simde_x_mm512_set_epu8(UINT8_C(145), UINT8_C(  0), UINT8_C(  0), UINT8_C( 80),
                             UINT8_C( 28), UINT8_C(  4), UINT8_C(  0), UINT8_C( 28),
                             UINT8_C(  0), UINT8_C(201), UINT8_C(  0), UINT8_C(175),
                             UINT8_C(  0), UINT8_C( 76), UINT8_C( 11), UINT8_C(111),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(140),
                             UINT8_C(  0), UINT8_C(  4), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 89), UINT8_C( 65), UINT8_C( 68), UINT8_C(  0),
                             UINT8_C( 34), UINT8_C(156), UINT8_C(  0), UINT8_C( 58),
                             UINT8_C(  6), UINT8_C(  0), UINT8_C( 31), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 11),
                             UINT8_C( 92), UINT8_C(  0), UINT8_C(  0), UINT8_C( 16),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 52), UINT8_C(211),
                             UINT8_C(  0), UINT8_C( 25), UINT8_C(  9), UINT8_C(115),
                             UINT8_C(  0), UINT8_C( 92), UINT8_C( 65), UINT8_C(198),
                             UINT8_C(  0), UINT8_C(124), UINT8_C( 17), UINT8_C(  0)) },
    { simde_x_mm512_set_epu8(UINT8_C(105), UINT8_C(141), UINT8_C(121), UINT8_C(155),
                             UINT8_C(  0), UINT8_C( 63), UINT8_C(214), UINT8_C(222),
                             UINT8_C(251), UINT8_C(209), UINT8_C(133), UINT8_C(204),
                             UINT8_C(170), UINT8_C(228), UINT8_C(193), UINT8_C( 20),
                             UINT8_C(196), UINT8_C(193), UINT8_C( 99), UINT8_C( 78),
                             UINT8_C( 56), UINT8_C(184), UINT8_C(201), UINT8_C(184),
                             UINT8_C( 79), UINT8_C(175), UINT8_C(124), UINT8_C(171),
                             UINT8_C(191), UINT8_C(122), UINT8_C(231), UINT8_C(198),
                             UINT8_C(192), UINT8_C( 52), UINT8_C(244), UINT8_C(  1),
                             UINT8_C(194), UINT8_C(228), UINT8_C(228), UINT8_C(152),
                             UINT8_C( 54), UINT8_C(153), UINT8_C(201), UINT8_C(234),
                             UINT8_C(165), UINT8_C(  6), UINT8_C(247), UINT8_C(225),
                             UINT8_C( 18), UINT8_C(145), UINT8_C( 58), UINT8_C( 71),
                             UINT8_C(183), UINT8_C(160), UINT8_C( 28), UINT8_C(252),
                             UINT8_C( 47), UINT8_C( 66), UINT8_C(121), UINT8_C( 38),
                             UINT8_C( 69), UINT8_C(149), UINT8_C(199), UINT8_C(136)),
      simde_x_mm512_set_epu8(UINT8_C(207), UINT8_C( 15), UINT8_C(241), UINT8_C(197),
                             UINT8_C(143), UINT8_C(102), UINT8_C(208), UINT8_C(178),
                             UINT8_C( 31), UINT8_C( 94), UINT8_C( 79), UINT8_C( 92),
                             UINT8_C(106), UINT8_C(188), UINT8_C( 96), UINT8_C(159),
                             UINT8_C(229), UINT8_C(138), UINT8_C(245), UINT8_C(112),
                             UINT8_C(131), UINT8_C( 70), UINT8_C( 26), UINT8_C(218),
                             UINT8_C(240), UINT8_C(144), UINT8_C( 10), UINT8_C( 98),
                             UINT8_C(252), UINT8_C(120), UINT8_C(223), UINT8_C(129),
                             UINT8_C(191), UINT8_C(216), UINT8_C( 88), UINT8_C(250),
                             UINT8_C( 74), UINT8_C( 41), UINT8_C( 39), UINT8_C( 79),
                             UINT8_C(131), UINT8_C(249), UINT8_C( 62), UINT8_C(144),
                             UINT8_C(137), UINT8_C(247), UINT8_C( 71), UINT8_C(188),
                             UINT8_C(177), UINT8_C( 48), UINT8_C(236), UINT8_C(159),
                             UINT8_C(140), UINT8_C(120), UINT8_C(191), UINT8_C(  6),
                             UINT8_C(224), UINT8_C(181), UINT8_C(150), UINT8_C( 26),
                             UINT8_C(160), UINT8_C( 50), UINT8_C(211), UINT8_C( 16)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(126), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  6), UINT8_C( 44),
                             UINT8_C(220), UINT8_C(115), UINT8_C( 54), UINT8_C(112),
                             UINT8_C( 64), UINT8_C( 40), UINT8_C( 97), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 55), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(114), UINT8_C(175), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 31), UINT8_C(114), UINT8_C( 73),
                             UINT8_C(  0), UINT8_C(  2), UINT8_C(  8), UINT8_C( 69),
                             UINT8_C(  1), UINT8_C(  0), UINT8_C(156), UINT8_C(  0),
                             UINT8_C(120), UINT8_C(187), UINT8_C(189), UINT8_C( 73),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(139), UINT8_C( 90),
                             UINT8_C( 28), UINT8_C(  0), UINT8_C(176), UINT8_C( 37),
                             UINT8_C(  0), UINT8_C( 97), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 43), UINT8_C( 40), UINT8_C(  0), UINT8_C(246),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 12),
                             UINT8_C(  0), UINT8_C( 99), UINT8_C(  0), UINT8_C(120)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_subs_epu8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_subs_epu8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C(160), UINT8_C(209), UINT8_C( 53), UINT8_C(241),
                             UINT8_C(169), UINT8_C( 74), UINT8_C(195), UINT8_C(156),
                             UINT8_C(226), UINT8_C(114), UINT8_C(119), UINT8_C(203),
                             UINT8_C( 15), UINT8_C( 80), UINT8_C(207), UINT8_C(120),
                             UINT8_C(164), UINT8_C(171), UINT8_C( 95), UINT8_C(130),
                             UINT8_C(161), UINT8_C(  3), UINT8_C( 82), UINT8_C(197),
                             UINT8_C( 78), UINT8_C(216), UINT8_C(176), UINT8_C(131),
                             UINT8_C(213), UINT8_C( 21), UINT8_C( 48), UINT8_C(162),
                             UINT8_C(135), UINT8_C( 81), UINT8_C( 67), UINT8_C(242),
                             UINT8_C( 97), UINT8_C( 89), UINT8_C(174), UINT8_C( 64),
                             UINT8_C(170), UINT8_C(194), UINT8_C(235), UINT8_C(133),
                             UINT8_C( 33), UINT8_C(160), UINT8_C(236), UINT8_C(  7),
                             UINT8_C(224), UINT8_C( 63), UINT8_C(130), UINT8_C( 28),
                             UINT8_C( 83), UINT8_C(152), UINT8_C(149), UINT8_C(111),
                             UINT8_C(188), UINT8_C( 24), UINT8_C( 57), UINT8_C( 80),
                             UINT8_C(100), UINT8_C( 11), UINT8_C(241), UINT8_C(117)),
      UINT64_C(          2661966794),
      simde_x_mm512_set_epu8(UINT8_C(164), UINT8_C( 45), UINT8_C(193), UINT8_C(111),
                             UINT8_C( 96), UINT8_C(220), UINT8_C( 54), UINT8_C(232),
                             UINT8_C(214), UINT8_C(244), UINT8_C(236), UINT8_C( 74),
                             UINT8_C( 47), UINT8_C(180), UINT8_C(143), UINT8_C(214),
                             UINT8_C(  6), UINT8_C(178), UINT8_C( 35), UINT8_C(129),
                             UINT8_C( 21), UINT8_C(157), UINT8_C( 30), UINT8_C( 29),
                             UINT8_C(226), UINT8_C(222), UINT8_C( 14), UINT8_C(170),
                             UINT8_C(223), UINT8_C(200), UINT8_C( 41), UINT8_C(245),
                             UINT8_C(  7), UINT8_C(251), UINT8_C( 30), UINT8_C(217),
                             UINT8_C( 93), UINT8_C(228), UINT8_C(143), UINT8_C(  9),
                             UINT8_C(221), UINT8_C( 49), UINT8_C(207), UINT8_C( 44),
                             UINT8_C( 52), UINT8_C(108), UINT8_C(124), UINT8_C( 14),
                             UINT8_C(144), UINT8_C(229), UINT8_C(102), UINT8_C( 16),
                             UINT8_C( 61), UINT8_C(  2), UINT8_C(169), UINT8_C( 72),
                             UINT8_C(194), UINT8_C(122), UINT8_C(216), UINT8_C(151),
                             UINT8_C(244), UINT8_C(227), UINT8_C(  5), UINT8_C( 98)),
      simde_x_mm512_set_epu8(UINT8_C( 53), UINT8_C( 65), UINT8_C(131), UINT8_C(189),
                             UINT8_C(196), UINT8_C(200), UINT8_C(234), UINT8_C( 92),
                             UINT8_C( 99), UINT8_C(187), UINT8_C(123), UINT8_C(180),
                             UINT8_C(209), UINT8_C(163), UINT8_C( 86), UINT8_C( 26),
                             UINT8_C(192), UINT8_C( 36), UINT8_C(205), UINT8_C(108),
                             UINT8_C(173), UINT8_C( 71), UINT8_C(190), UINT8_C( 46),
                             UINT8_C(173), UINT8_C(156), UINT8_C( 59), UINT8_C(250),
                             UINT8_C( 13), UINT8_C(171), UINT8_C(  1), UINT8_C( 47),
                             UINT8_C(227), UINT8_C( 45), UINT8_C(181), UINT8_C( 45),
                             UINT8_C(116), UINT8_C( 89), UINT8_C(112), UINT8_C(127),
                             UINT8_C( 42), UINT8_C(134), UINT8_C(128), UINT8_C(206),
                             UINT8_C( 87), UINT8_C(206), UINT8_C( 39), UINT8_C(  7),
                             UINT8_C( 48), UINT8_C( 47), UINT8_C( 79), UINT8_C( 32),
                             UINT8_C( 39), UINT8_C(205), UINT8_C(174), UINT8_C(244),
                             UINT8_C(251), UINT8_C( 10), UINT8_C( 13), UINT8_C( 53),
                             UINT8_C(255), UINT8_C(222), UINT8_C( 66), UINT8_C( 52)),
      simde_x_mm512_set_epu8(UINT8_C(160), UINT8_C(209), UINT8_C( 53), UINT8_C(241),
                             UINT8_C(169), UINT8_C( 74), UINT8_C(195), UINT8_C(156),
                             UINT8_C(226), UINT8_C(114), UINT8_C(119), UINT8_C(203),
                             UINT8_C( 15), UINT8_C( 80), UINT8_C(207), UINT8_C(120),
                             UINT8_C(164), UINT8_C(171), UINT8_C( 95), UINT8_C(130),
                             UINT8_C(161), UINT8_C(  3), UINT8_C( 82), UINT8_C(197),
                             UINT8_C( 78), UINT8_C(216), UINT8_C(176), UINT8_C(131),
                             UINT8_C(213), UINT8_C( 21), UINT8_C( 48), UINT8_C(162),
                             UINT8_C(  0), UINT8_C( 81), UINT8_C( 67), UINT8_C(172),
                             UINT8_C(  0), UINT8_C(139), UINT8_C( 31), UINT8_C( 64),
                             UINT8_C(179), UINT8_C(194), UINT8_C( 79), UINT8_C(133),
                             UINT8_C(  0), UINT8_C(160), UINT8_C( 85), UINT8_C(  7),
                             UINT8_C(224), UINT8_C(182), UINT8_C( 23), UINT8_C( 28),
                             UINT8_C( 83), UINT8_C(152), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(112), UINT8_C( 57), UINT8_C( 80),
                             UINT8_C(  0), UINT8_C( 11), UINT8_C(  0), UINT8_C(117)) },
    { simde_x_mm512_set_epu8(UINT8_C(108), UINT8_C( 96), UINT8_C(  9), UINT8_C(145),
                             UINT8_C(131), UINT8_C(204), UINT8_C(151), UINT8_C(200),
                             UINT8_C(172), UINT8_C(193), UINT8_C(248), UINT8_C(227),
                             UINT8_C(159), UINT8_C( 34), UINT8_C( 70), UINT8_C( 14),
                             UINT8_C(229), UINT8_C( 98), UINT8_C( 73), UINT8_C(209),
                             UINT8_C( 59), UINT8_C(209), UINT8_C( 82), UINT8_C( 90),
                             UINT8_C(172), UINT8_C( 10), UINT8_C(185), UINT8_C(194),
                             UINT8_C(184), UINT8_C( 76), UINT8_C(173), UINT8_C( 75),
                             UINT8_C(136), UINT8_C(130), UINT8_C(227), UINT8_C(162),
                             UINT8_C(154), UINT8_C(158), UINT8_C(121), UINT8_C( 19),
                             UINT8_C(211), UINT8_C(197), UINT8_C( 15), UINT8_C( 80),
                             UINT8_C( 75), UINT8_C( 26), UINT8_C( 77), UINT8_C(210),
                             UINT8_C(117), UINT8_C( 85), UINT8_C(204), UINT8_C(  0),
                             UINT8_C(244), UINT8_C( 11), UINT8_C(128), UINT8_C(245),
                             UINT8_C(177), UINT8_C(132), UINT8_C(179), UINT8_C(117),
                             UINT8_C(215), UINT8_C( 43), UINT8_C(143), UINT8_C( 75)),
      UINT64_C(          1314676378),
      simde_x_mm512_set_epu8(UINT8_C(122), UINT8_C(121), UINT8_C( 15), UINT8_C(167),
                             UINT8_C(146), UINT8_C(  1), UINT8_C( 27), UINT8_C( 93),
                             UINT8_C(177), UINT8_C(197), UINT8_C(189), UINT8_C(233),
                             UINT8_C(110), UINT8_C( 47), UINT8_C( 66), UINT8_C( 91),
                             UINT8_C( 52), UINT8_C(  7), UINT8_C(197), UINT8_C( 20),
                             UINT8_C( 34), UINT8_C(208), UINT8_C(127), UINT8_C( 73),
                             UINT8_C(145), UINT8_C(  2), UINT8_C( 27), UINT8_C(235),
                             UINT8_C(109), UINT8_C(152), UINT8_C(220), UINT8_C(143),
                             UINT8_C(189), UINT8_C(222), UINT8_C(102), UINT8_C(126),
                             UINT8_C( 80), UINT8_C( 51), UINT8_C(253), UINT8_C(186),
                             UINT8_C( 51), UINT8_C(206), UINT8_C(118), UINT8_C( 48),
                             UINT8_C( 59), UINT8_C(184), UINT8_C(197), UINT8_C(107),
                             UINT8_C( 52), UINT8_C(  5), UINT8_C(208), UINT8_C(231),
                             UINT8_C(151), UINT8_C(166), UINT8_C(151), UINT8_C( 49),
                             UINT8_C( 74), UINT8_C(239), UINT8_C(157), UINT8_C(112),
                             UINT8_C(217), UINT8_C(111), UINT8_C( 21), UINT8_C(221)),
      simde_x_mm512_set_epu8(UINT8_C( 54), UINT8_C( 10), UINT8_C( 52), UINT8_C(157),
                             UINT8_C( 51), UINT8_C( 63), UINT8_C(190), UINT8_C(105),
                             UINT8_C(159), UINT8_C( 57), UINT8_C(152), UINT8_C(  2),
                             UINT8_C(134), UINT8_C(112), UINT8_C( 29), UINT8_C(  8),
                             UINT8_C(240), UINT8_C( 55), UINT8_C(110), UINT8_C(144),
                             UINT8_C(247), UINT8_C( 78), UINT8_C(254), UINT8_C( 89),
                             UINT8_C(189), UINT8_C(169), UINT8_C(164), UINT8_C(239),
                             UINT8_C(227), UINT8_C(187), UINT8_C( 11), UINT8_C(211),
                             UINT8_C(183), UINT8_C(  9), UINT8_C(204), UINT8_C(138),
                             UINT8_C(223), UINT8_C( 91), UINT8_C(198), UINT8_C( 18),
                             UINT8_C(178), UINT8_C(209), UINT8_C(152), UINT8_C(100),
                             UINT8_C(247), UINT8_C(142), UINT8_C( 53), UINT8_C( 94),
                             UINT8_C(238), UINT8_C(239), UINT8_C(151), UINT8_C(119),
                             UINT8_C(229), UINT8_C( 96), UINT8_C(245), UINT8_C(  0),
                             UINT8_C(141), UINT8_C( 95), UINT8_C(101), UINT8_C(146),
                             UINT8_C(141), UINT8_C( 37), UINT8_C( 41), UINT8_C(148)),
      simde_x_mm512_set_epu8(UINT8_C(108), UINT8_C( 96), UINT8_C(  9), UINT8_C(145),
                             UINT8_C(131), UINT8_C(204), UINT8_C(151), UINT8_C(200),
                             UINT8_C(172), UINT8_C(193), UINT8_C(248), UINT8_C(227),
                             UINT8_C(159), UINT8_C( 34), UINT8_C( 70), UINT8_C( 14),
                             UINT8_C(229), UINT8_C( 98), UINT8_C( 73), UINT8_C(209),
                             UINT8_C( 59), UINT8_C(209), UINT8_C( 82), UINT8_C( 90),
                             UINT8_C(172), UINT8_C( 10), UINT8_C(185), UINT8_C(194),
                             UINT8_C(184), UINT8_C( 76), UINT8_C(173), UINT8_C( 75),
                             UINT8_C(136), UINT8_C(213), UINT8_C(227), UINT8_C(162),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 55), UINT8_C( 19),
                             UINT8_C(211), UINT8_C(  0), UINT8_C( 15), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 42), UINT8_C( 77), UINT8_C(210),
                             UINT8_C(117), UINT8_C(  0), UINT8_C(204), UINT8_C(112),
                             UINT8_C(  0), UINT8_C( 70), UINT8_C(  0), UINT8_C(245),
                             UINT8_C(  0), UINT8_C(132), UINT8_C(179), UINT8_C(  0),
                             UINT8_C( 76), UINT8_C( 43), UINT8_C(  0), UINT8_C( 75)) },
    { simde_x_mm512_set_epu8(UINT8_C(206), UINT8_C(206), UINT8_C( 30), UINT8_C( 15),
                             UINT8_C(114), UINT8_C(103), UINT8_C( 13), UINT8_C(110),
                             UINT8_C(166), UINT8_C( 46), UINT8_C(130), UINT8_C(151),
                             UINT8_C( 16), UINT8_C( 40), UINT8_C(154), UINT8_C( 67),
                             UINT8_C(184), UINT8_C( 37), UINT8_C(207), UINT8_C( 94),
                             UINT8_C( 79), UINT8_C(202), UINT8_C(122), UINT8_C(203),
                             UINT8_C(179), UINT8_C(164), UINT8_C( 37), UINT8_C(173),
                             UINT8_C( 95), UINT8_C(170), UINT8_C( 47), UINT8_C(161),
                             UINT8_C(255), UINT8_C(185), UINT8_C(163), UINT8_C(181),
                             UINT8_C( 29), UINT8_C(148), UINT8_C(134), UINT8_C( 11),
                             UINT8_C(137), UINT8_C(213), UINT8_C(115), UINT8_C(139),
                             UINT8_C( 77), UINT8_C(129), UINT8_C( 55), UINT8_C(  6),
                             UINT8_C(222), UINT8_C(184), UINT8_C(104), UINT8_C( 68),
                             UINT8_C(167), UINT8_C( 53), UINT8_C( 35), UINT8_C( 81),
                             UINT8_C(255), UINT8_C(129), UINT8_C(219), UINT8_C(221),
                             UINT8_C(186), UINT8_C( 75), UINT8_C(231), UINT8_C(243)),
      UINT64_C(          1370699036),
      simde_x_mm512_set_epu8(UINT8_C(228), UINT8_C( 29), UINT8_C(156), UINT8_C(201),
                             UINT8_C(217), UINT8_C( 60), UINT8_C( 61), UINT8_C( 86),
                             UINT8_C(205), UINT8_C(204), UINT8_C( 26), UINT8_C( 35),
                             UINT8_C(113), UINT8_C( 54), UINT8_C( 44), UINT8_C(150),
                             UINT8_C(  5), UINT8_C(127), UINT8_C(118), UINT8_C(122),
                             UINT8_C(  8), UINT8_C( 76), UINT8_C( 62), UINT8_C( 54),
                             UINT8_C(171), UINT8_C(236), UINT8_C(228), UINT8_C( 23),
                             UINT8_C(167), UINT8_C( 85), UINT8_C(106), UINT8_C(203),
                             UINT8_C( 75), UINT8_C(211), UINT8_C(183), UINT8_C(233),
                             UINT8_C(230), UINT8_C(155), UINT8_C(159), UINT8_C(231),
                             UINT8_C( 53), UINT8_C( 16), UINT8_C(224), UINT8_C(218),
                             UINT8_C(254), UINT8_C(170), UINT8_C(229), UINT8_C(158),
                             UINT8_C(154), UINT8_C(108), UINT8_C(114), UINT8_C(193),
                             UINT8_C(254), UINT8_C( 39), UINT8_C(143), UINT8_C(155),
                             UINT8_C(241), UINT8_C(232), UINT8_C(128), UINT8_C(233),
                             UINT8_C(178), UINT8_C(  6), UINT8_C(154), UINT8_C(184)),
      simde_x_mm512_set_epu8(UINT8_C(165), UINT8_C(173), UINT8_C(234), UINT8_C(165),
                             UINT8_C(146), UINT8_C(243), UINT8_C( 52), UINT8_C( 89),
                             UINT8_C(227), UINT8_C( 93), UINT8_C(108), UINT8_C( 47),
                             UINT8_C(207), UINT8_C(115), UINT8_C(178), UINT8_C(155),
                             UINT8_C(250), UINT8_C(115), UINT8_C(  2), UINT8_C( 73),
                             UINT8_C(254), UINT8_C(119), UINT8_C( 72), UINT8_C(108),
                             UINT8_C( 90), UINT8_C( 96), UINT8_C( 56), UINT8_C(182),
                             UINT8_C( 64), UINT8_C(  8), UINT8_C(172), UINT8_C(169),
                             UINT8_C( 32), UINT8_C( 75), UINT8_C( 92), UINT8_C(114),
                             UINT8_C( 16), UINT8_C( 36), UINT8_C(161), UINT8_C( 46),
                             UINT8_C(214), UINT8_C(247), UINT8_C(176), UINT8_C( 43),
                             UINT8_C(168), UINT8_C(161), UINT8_C(148), UINT8_C( 77),
                             UINT8_C(231), UINT8_C(174), UINT8_C( 75), UINT8_C( 48),
                             UINT8_C(123), UINT8_C(251), UINT8_C(221), UINT8_C(100),
                             UINT8_C( 39), UINT8_C(159), UINT8_C( 61), UINT8_C( 37),
                             UINT8_C(160), UINT8_C(166), UINT8_C( 87), UINT8_C(103)),
      simde_x_mm512_set_epu8(UINT8_C(206), UINT8_C(206), UINT8_C( 30), UINT8_C( 15),
                             UINT8_C(114), UINT8_C(103), UINT8_C( 13), UINT8_C(110),
                             UINT8_C(166), UINT8_C( 46), UINT8_C(130), UINT8_C(151),
                             UINT8_C( 16), UINT8_C( 40), UINT8_C(154), UINT8_C( 67),
                             UINT8_C(184), UINT8_C( 37), UINT8_C(207), UINT8_C( 94),
                             UINT8_C( 79), UINT8_C(202), UINT8_C(122), UINT8_C(203),
                             UINT8_C(179), UINT8_C(164), UINT8_C( 37), UINT8_C(173),
                             UINT8_C( 95), UINT8_C(170), UINT8_C( 47), UINT8_C(161),
                             UINT8_C(255), UINT8_C(136), UINT8_C(163), UINT8_C(119),
                             UINT8_C( 29), UINT8_C(148), UINT8_C(134), UINT8_C(185),
                             UINT8_C(  0), UINT8_C(213), UINT8_C( 48), UINT8_C(175),
                             UINT8_C( 77), UINT8_C(129), UINT8_C( 81), UINT8_C( 81),
                             UINT8_C(222), UINT8_C(184), UINT8_C( 39), UINT8_C(145),
                             UINT8_C(167), UINT8_C(  0), UINT8_C( 35), UINT8_C( 55),
                             UINT8_C(255), UINT8_C(129), UINT8_C(219), UINT8_C(196),
                             UINT8_C( 18), UINT8_C(  0), UINT8_C(231), UINT8_C(243)) },
    { simde_x_mm512_set_epu8(UINT8_C(215), UINT8_C( 43), UINT8_C(249), UINT8_C(194),
                             UINT8_C(157), UINT8_C(199), UINT8_C( 98), UINT8_C(233),
                             UINT8_C( 27), UINT8_C(181), UINT8_C(227), UINT8_C( 75),
                             UINT8_C( 73), UINT8_C( 96), UINT8_C(149), UINT8_C(223),
                             UINT8_C(104), UINT8_C( 32), UINT8_C( 22), UINT8_C(168),
                             UINT8_C( 89), UINT8_C( 99), UINT8_C(164), UINT8_C(153),
                             UINT8_C( 65), UINT8_C(170), UINT8_C( 53), UINT8_C( 47),
                             UINT8_C(191), UINT8_C(169), UINT8_C( 40), UINT8_C( 76),
                             UINT8_C(114), UINT8_C(220), UINT8_C( 85), UINT8_C(210),
                             UINT8_C(141), UINT8_C( 16), UINT8_C( 66), UINT8_C(216),
                             UINT8_C(211), UINT8_C(107), UINT8_C(217), UINT8_C(119),
                             UINT8_C(250), UINT8_C( 64), UINT8_C(254), UINT8_C( 91),
                             UINT8_C( 35), UINT8_C(245), UINT8_C(193), UINT8_C( 56),
                             UINT8_C(248), UINT8_C(186), UINT8_C( 68), UINT8_C(150),
                             UINT8_C(220), UINT8_C(248), UINT8_C(101), UINT8_C(  0),
                             UINT8_C(116), UINT8_C(116), UINT8_C( 64), UINT8_C(175)),
      UINT64_C(          4015290579),
      simde_x_mm512_set_epu8(UINT8_C( 21), UINT8_C(153), UINT8_C(252), UINT8_C(180),
                             UINT8_C(184), UINT8_C( 70), UINT8_C( 16), UINT8_C(164),
                             UINT8_C( 32), UINT8_C(157), UINT8_C(177), UINT8_C(185),
                             UINT8_C( 75), UINT8_C(213), UINT8_C(118), UINT8_C( 48),
                             UINT8_C(250), UINT8_C(247), UINT8_C(144), UINT8_C(182),
                             UINT8_C( 89), UINT8_C(193), UINT8_C(215), UINT8_C(109),
                             UINT8_C( 32), UINT8_C( 44), UINT8_C( 30), UINT8_C(115),
                             UINT8_C(122), UINT8_C(173), UINT8_C( 22), UINT8_C(177),
                             UINT8_C(163), UINT8_C(190), UINT8_C(161), UINT8_C(157),
                             UINT8_C(186), UINT8_C(207), UINT8_C(230), UINT8_C( 94),
                             UINT8_C(188), UINT8_C( 54), UINT8_C(164), UINT8_C(150),
                             UINT8_C( 11), UINT8_C( 80), UINT8_C(167), UINT8_C(171),
                             UINT8_C(  7), UINT8_C(177), UINT8_C(223), UINT8_C(132),
                             UINT8_C(186), UINT8_C( 43), UINT8_C( 15), UINT8_C(205),
                             UINT8_C( 56), UINT8_C(209), UINT8_C( 90), UINT8_C(226),
                             UINT8_C(128), UINT8_C( 65), UINT8_C( 94), UINT8_C(244)),
      simde_x_mm512_set_epu8(UINT8_C( 31), UINT8_C( 58), UINT8_C(132), UINT8_C( 37),
                             UINT8_C(154), UINT8_C(  6), UINT8_C( 75), UINT8_C(156),
                             UINT8_C(149), UINT8_C(144), UINT8_C(181), UINT8_C(171),
                             UINT8_C(160), UINT8_C( 77), UINT8_C(155), UINT8_C(252),
                             UINT8_C(181), UINT8_C(149), UINT8_C( 69), UINT8_C( 75),
                             UINT8_C(202), UINT8_C( 32), UINT8_C( 21), UINT8_C( 82),
                             UINT8_C(184), UINT8_C(152), UINT8_C(217), UINT8_C( 20),
                             UINT8_C( 41), UINT8_C( 41), UINT8_C(  1), UINT8_C( 97),
                             UINT8_C(165), UINT8_C(111), UINT8_C(131), UINT8_C( 21),
                             UINT8_C( 63), UINT8_C( 20), UINT8_C(145), UINT8_C(147),
                             UINT8_C( 66), UINT8_C( 29), UINT8_C(208), UINT8_C( 15),
                             UINT8_C(209), UINT8_C(114), UINT8_C(194), UINT8_C(  3),
                             UINT8_C( 96), UINT8_C(111), UINT8_C( 93), UINT8_C(100),
                             UINT8_C(124), UINT8_C( 70), UINT8_C(116), UINT8_C(210),
                             UINT8_C( 69), UINT8_C(255), UINT8_C(157), UINT8_C(160),
                             UINT8_C( 53), UINT8_C( 12), UINT8_C(237), UINT8_C(134)),
      simde_x_mm512_set_epu8(UINT8_C(215), UINT8_C( 43), UINT8_C(249), UINT8_C(194),
                             UINT8_C(157), UINT8_C(199), UINT8_C( 98), UINT8_C(233),
                             UINT8_C( 27), UINT8_C(181), UINT8_C(227), UINT8_C( 75),
                             UINT8_C( 73), UINT8_C( 96), UINT8_C(149), UINT8_C(223),
                             UINT8_C(104), UINT8_C( 32), UINT8_C( 22), UINT8_C(168),
                             UINT8_C( 89), UINT8_C( 99), UINT8_C(164), UINT8_C(153),
                             UINT8_C( 65), UINT8_C(170), UINT8_C( 53), UINT8_C( 47),
                             UINT8_C(191), UINT8_C(169), UINT8_C( 40), UINT8_C( 76),
                             UINT8_C(  0), UINT8_C( 79), UINT8_C( 30), UINT8_C(210),
                             UINT8_C(123), UINT8_C(187), UINT8_C( 85), UINT8_C(  0),
                             UINT8_C(211), UINT8_C( 25), UINT8_C(217), UINT8_C(135),
                             UINT8_C(250), UINT8_C(  0), UINT8_C(254), UINT8_C( 91),
                             UINT8_C( 35), UINT8_C( 66), UINT8_C(130), UINT8_C( 32),
                             UINT8_C( 62), UINT8_C(186), UINT8_C( 68), UINT8_C(150),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(101), UINT8_C( 66),
                             UINT8_C(116), UINT8_C(116), UINT8_C(  0), UINT8_C(110)) },
    { simde_x_mm512_set_epu8(UINT8_C(181), UINT8_C( 56), UINT8_C(192), UINT8_C(150),
                             UINT8_C( 44), UINT8_C(209), UINT8_C( 13), UINT8_C(238),
                             UINT8_C(199), UINT8_C(135), UINT8_C(144), UINT8_C(  8),
                             UINT8_C( 13), UINT8_C(143), UINT8_C(242), UINT8_C(219),
                             UINT8_C(103), UINT8_C(252), UINT8_C(214), UINT8_C(167),
                             UINT8_C(  3), UINT8_C(136), UINT8_C(222), UINT8_C(241),
                             UINT8_C(  7), UINT8_C( 92), UINT8_C(141), UINT8_C(140),
                             UINT8_C(104), UINT8_C(125), UINT8_C(212), UINT8_C(114),
                             UINT8_C(114), UINT8_C(229), UINT8_C(235), UINT8_C(144),
                             UINT8_C(233), UINT8_C(188), UINT8_C( 95), UINT8_C(193),
                             UINT8_C( 27), UINT8_C(148), UINT8_C( 89), UINT8_C(138),
                             UINT8_C(232), UINT8_C(105), UINT8_C(208), UINT8_C(244),
                             UINT8_C( 62), UINT8_C(166), UINT8_C(227), UINT8_C( 87),
                             UINT8_C(254), UINT8_C( 17), UINT8_C(235), UINT8_C(147),
                             UINT8_C(215), UINT8_C(  8), UINT8_C(107), UINT8_C( 75),
                             UINT8_C(237), UINT8_C(121), UINT8_C( 75), UINT8_C( 80)),
      UINT64_C(          3983161372),
      simde_x_mm512_set_epu8(UINT8_C(105), UINT8_C(165), UINT8_C(196), UINT8_C(175),
                             UINT8_C( 21), UINT8_C( 33), UINT8_C( 59), UINT8_C( 91),
                             UINT8_C(173), UINT8_C( 84), UINT8_C(102), UINT8_C(234),
                             UINT8_C(240), UINT8_C( 97), UINT8_C( 44), UINT8_C(117),
                             UINT8_C(253), UINT8_C( 63), UINT8_C(177), UINT8_C(  7),
                             UINT8_C( 84), UINT8_C(101), UINT8_C( 54), UINT8_C(237),
                             UINT8_C(110), UINT8_C( 66), UINT8_C( 52), UINT8_C(158),
                             UINT8_C(218), UINT8_C(146), UINT8_C(129), UINT8_C(  7),
                             UINT8_C(170), UINT8_C( 34), UINT8_C( 11), UINT8_C( 33),
                             UINT8_C(109), UINT8_C( 75), UINT8_C(249), UINT8_C(174),
                             UINT8_C( 89), UINT8_C(221), UINT8_C(115), UINT8_C(113),
                             UINT8_C(179), UINT8_C( 55), UINT8_C(200), UINT8_C( 84),
                             UINT8_C(219), UINT8_C(209), UINT8_C(106), UINT8_C(223),
                             UINT8_C(220), UINT8_C(150), UINT8_C(243), UINT8_C( 88),
                             UINT8_C( 23), UINT8_C( 59), UINT8_C(210), UINT8_C(197),
                             UINT8_C( 39), UINT8_C(187), UINT8_C( 89), UINT8_C( 99)),
      simde_x_mm512_set_epu8(UINT8_C(202), UINT8_C( 54), UINT8_C( 42), UINT8_C(168),
                             UINT8_C( 22), UINT8_C(221), UINT8_C( 17), UINT8_C(189),
                             UINT8_C( 39), UINT8_C(155), UINT8_C(135), UINT8_C(162),
                             UINT8_C(148), UINT8_C(181), UINT8_C(120), UINT8_C( 52),
                             UINT8_C(206), UINT8_C( 24), UINT8_C(206), UINT8_C(117),
                             UINT8_C(240), UINT8_C( 17), UINT8_C(210), UINT8_C(188),
                             UINT8_C(193), UINT8_C(112), UINT8_C( 80), UINT8_C(199),
                             UINT8_C(136), UINT8_C( 33), UINT8_C( 97), UINT8_C(247),
                             UINT8_C(161), UINT8_C( 97), UINT8_C( 42), UINT8_C(181),
                             UINT8_C( 25), UINT8_C( 62), UINT8_C( 47), UINT8_C( 32),
                             UINT8_C( 10), UINT8_C(145), UINT8_C( 81), UINT8_C( 51),
                             UINT8_C(106), UINT8_C( 74), UINT8_C(253), UINT8_C( 27),
                             UINT8_C(198), UINT8_C( 49), UINT8_C(205), UINT8_C(189),
                             UINT8_C( 32), UINT8_C(168), UINT8_C(102), UINT8_C( 88),
                             UINT8_C( 86), UINT8_C(170), UINT8_C(185), UINT8_C( 98),
                             UINT8_C(232), UINT8_C( 43), UINT8_C( 26), UINT8_C(165)),
      simde_x_mm512_set_epu8(UINT8_C(181), UINT8_C( 56), UINT8_C(192), UINT8_C(150),
                             UINT8_C( 44), UINT8_C(209), UINT8_C( 13), UINT8_C(238),
                             UINT8_C(199), UINT8_C(135), UINT8_C(144), UINT8_C(  8),
                             UINT8_C( 13), UINT8_C(143), UINT8_C(242), UINT8_C(219),
                             UINT8_C(103), UINT8_C(252), UINT8_C(214), UINT8_C(167),
                             UINT8_C(  3), UINT8_C(136), UINT8_C(222), UINT8_C(241),
                             UINT8_C(  7), UINT8_C( 92), UINT8_C(141), UINT8_C(140),
                             UINT8_C(104), UINT8_C(125), UINT8_C(212), UINT8_C(114),
                             UINT8_C(  9), UINT8_C(  0), UINT8_C(  0), UINT8_C(144),
                             UINT8_C( 84), UINT8_C( 13), UINT8_C( 95), UINT8_C(142),
                             UINT8_C( 27), UINT8_C( 76), UINT8_C( 34), UINT8_C(138),
                             UINT8_C( 73), UINT8_C(105), UINT8_C(  0), UINT8_C(244),
                             UINT8_C( 62), UINT8_C(166), UINT8_C(  0), UINT8_C( 34),
                             UINT8_C(188), UINT8_C( 17), UINT8_C(235), UINT8_C(147),
                             UINT8_C(215), UINT8_C(  8), UINT8_C(107), UINT8_C( 99),
                             UINT8_C(  0), UINT8_C(144), UINT8_C( 75), UINT8_C( 80)) },
    { simde_x_mm512_set_epu8(UINT8_C( 98), UINT8_C( 81), UINT8_C(150), UINT8_C(221),
                             UINT8_C( 96), UINT8_C( 40), UINT8_C(142), UINT8_C( 23),
                             UINT8_C( 87), UINT8_C(207), UINT8_C(191), UINT8_C( 92),
                             UINT8_C( 77), UINT8_C(157), UINT8_C(184), UINT8_C(138),
                             UINT8_C(172), UINT8_C( 66), UINT8_C(  9), UINT8_C(115),
                             UINT8_C(240), UINT8_C(175), UINT8_C(107), UINT8_C( 49),
                             UINT8_C( 50), UINT8_C(243), UINT8_C( 59), UINT8_C( 91),
                             UINT8_C(  0), UINT8_C( 76), UINT8_C(  9), UINT8_C(  2),
                             UINT8_C( 15), UINT8_C( 39), UINT8_C(150), UINT8_C( 31),
                             UINT8_C( 12), UINT8_C(247), UINT8_C(212), UINT8_C( 40),
                             UINT8_C(158), UINT8_C( 81), UINT8_C(244), UINT8_C( 20),
                             UINT8_C(204), UINT8_C( 92), UINT8_C(198), UINT8_C(205),
                             UINT8_C( 11), UINT8_C( 60), UINT8_C(191), UINT8_C( 47),
                             UINT8_C( 22), UINT8_C(151), UINT8_C(149), UINT8_C( 16),
                             UINT8_C(247), UINT8_C(164), UINT8_C( 21), UINT8_C( 75),
                             UINT8_C(153), UINT8_C(240), UINT8_C(253), UINT8_C(242)),
      UINT64_C(            56397128),
      simde_x_mm512_set_epu8(UINT8_C(183), UINT8_C(245), UINT8_C(114), UINT8_C(158),
                             UINT8_C( 37), UINT8_C(  8), UINT8_C(173), UINT8_C( 26),
                             UINT8_C(128), UINT8_C( 46), UINT8_C(239), UINT8_C(202),
                             UINT8_C( 36), UINT8_C(170), UINT8_C( 57), UINT8_C( 95),
                             UINT8_C(183), UINT8_C(182), UINT8_C( 41), UINT8_C(122),
                             UINT8_C(112), UINT8_C(137), UINT8_C(112), UINT8_C( 40),
                             UINT8_C(142), UINT8_C( 91), UINT8_C( 37), UINT8_C( 25),
                             UINT8_C(202), UINT8_C(195), UINT8_C(221), UINT8_C(250),
                             UINT8_C(146), UINT8_C(239), UINT8_C( 69), UINT8_C(186),
                             UINT8_C(170), UINT8_C(230), UINT8_C(161), UINT8_C(178),
                             UINT8_C( 40), UINT8_C(125), UINT8_C(237), UINT8_C(124),
                             UINT8_C(248), UINT8_C( 56), UINT8_C(  8), UINT8_C( 55),
                             UINT8_C(249), UINT8_C(227), UINT8_C(149), UINT8_C(232),
                             UINT8_C( 71), UINT8_C(244), UINT8_C(128), UINT8_C( 10),
                             UINT8_C(194), UINT8_C(169), UINT8_C(169), UINT8_C( 87),
                             UINT8_C(140), UINT8_C(131), UINT8_C( 55), UINT8_C(150)),
      simde_x_mm512_set_epu8(UINT8_C(110), UINT8_C( 33), UINT8_C(123), UINT8_C(125),
                             UINT8_C( 28), UINT8_C(250), UINT8_C(180), UINT8_C(218),
                             UINT8_C(138), UINT8_C(236), UINT8_C( 38), UINT8_C(136),
                             UINT8_C(156), UINT8_C(154), UINT8_C(163), UINT8_C(128),
                             UINT8_C(  3), UINT8_C( 20), UINT8_C(100), UINT8_C(126),
                             UINT8_C(164), UINT8_C( 42), UINT8_C(151), UINT8_C(206),
                             UINT8_C(  0), UINT8_C(  4), UINT8_C(235), UINT8_C(224),
                             UINT8_C( 89), UINT8_C(213), UINT8_C( 61), UINT8_C(138),
                             UINT8_C( 77), UINT8_C( 74), UINT8_C( 61), UINT8_C(173),
                             UINT8_C( 87), UINT8_C(142), UINT8_C( 26), UINT8_C(213),
                             UINT8_C( 90), UINT8_C(221), UINT8_C( 14), UINT8_C( 55),
                             UINT8_C(246), UINT8_C(136), UINT8_C(230), UINT8_C(198),
                             UINT8_C(193), UINT8_C(138), UINT8_C(163), UINT8_C( 46),
                             UINT8_C( 13), UINT8_C(134), UINT8_C(202), UINT8_C( 58),
                             UINT8_C( 24), UINT8_C(220), UINT8_C( 93), UINT8_C(159),
                             UINT8_C(158), UINT8_C(228), UINT8_C( 77), UINT8_C( 48)),
      simde_x_mm512_set_epu8(UINT8_C( 98), UINT8_C( 81), UINT8_C(150), UINT8_C(221),
                             UINT8_C( 96), UINT8_C( 40), UINT8_C(142), UINT8_C( 23),
                             UINT8_C( 87), UINT8_C(207), UINT8_C(191), UINT8_C( 92),
                             UINT8_C( 77), UINT8_C(157), UINT8_C(184), UINT8_C(138),
                             UINT8_C(172), UINT8_C( 66), UINT8_C(  9), UINT8_C(115),
                             UINT8_C(240), UINT8_C(175), UINT8_C(107), UINT8_C( 49),
                             UINT8_C( 50), UINT8_C(243), UINT8_C( 59), UINT8_C( 91),
                             UINT8_C(  0), UINT8_C( 76), UINT8_C(  9), UINT8_C(  2),
                             UINT8_C( 15), UINT8_C( 39), UINT8_C(150), UINT8_C( 31),
                             UINT8_C( 12), UINT8_C(247), UINT8_C(135), UINT8_C(  0),
                             UINT8_C(158), UINT8_C(  0), UINT8_C(244), UINT8_C( 69),
                             UINT8_C(  2), UINT8_C(  0), UINT8_C(198), UINT8_C(205),
                             UINT8_C( 56), UINT8_C( 60), UINT8_C(191), UINT8_C( 47),
                             UINT8_C( 58), UINT8_C(110), UINT8_C(149), UINT8_C(  0),
                             UINT8_C(247), UINT8_C(  0), UINT8_C( 21), UINT8_C( 75),
                             UINT8_C(  0), UINT8_C(240), UINT8_C(253), UINT8_C(242)) },
    { simde_x_mm512_set_epu8(UINT8_C( 53), UINT8_C(227), UINT8_C(166), UINT8_C(167),
                             UINT8_C(220), UINT8_C( 62), UINT8_C(127), UINT8_C(188),
                             UINT8_C(162), UINT8_C( 93), UINT8_C( 87), UINT8_C( 20),
                             UINT8_C(253), UINT8_C(151), UINT8_C(167), UINT8_C( 97),
                             UINT8_C(141), UINT8_C( 56), UINT8_C( 46), UINT8_C(112),
                             UINT8_C(183), UINT8_C(242), UINT8_C(234), UINT8_C(225),
                             UINT8_C( 17), UINT8_C(244), UINT8_C(208), UINT8_C(134),
                             UINT8_C( 62), UINT8_C(227), UINT8_C(122), UINT8_C(145),
                             UINT8_C( 35), UINT8_C(116), UINT8_C( 86), UINT8_C( 57),
                             UINT8_C( 43), UINT8_C(  6), UINT8_C( 33), UINT8_C(  4),
                             UINT8_C(148), UINT8_C( 62), UINT8_C( 78), UINT8_C(134),
                             UINT8_C( 59), UINT8_C(194), UINT8_C(251), UINT8_C(176),
                             UINT8_C(131), UINT8_C(  3), UINT8_C(158), UINT8_C( 64),
                             UINT8_C(  7), UINT8_C( 23), UINT8_C(141), UINT8_C( 30),
                             UINT8_C( 80), UINT8_C(118), UINT8_C(234), UINT8_C(166),
                             UINT8_C(190), UINT8_C(141), UINT8_C(  8), UINT8_C(147)),
      UINT64_C(            22184990),
      simde_x_mm512_set_epu8(UINT8_C( 84), UINT8_C( 30), UINT8_C(240), UINT8_C(  3),
                             UINT8_C( 77), UINT8_C(250), UINT8_C(105), UINT8_C( 84),
                             UINT8_C( 36), UINT8_C(146), UINT8_C(  3), UINT8_C( 91),
                             UINT8_C( 21), UINT8_C( 50), UINT8_C( 15), UINT8_C(197),
                             UINT8_C(184), UINT8_C(164), UINT8_C(243), UINT8_C( 49),
                             UINT8_C(139), UINT8_C(155), UINT8_C( 62), UINT8_C(216),
                             UINT8_C(245), UINT8_C( 40), UINT8_C( 99), UINT8_C(208),
                             UINT8_C(124), UINT8_C(170), UINT8_C(118), UINT8_C(243),
                             UINT8_C(134), UINT8_C( 41), UINT8_C(113), UINT8_C( 32),
                             UINT8_C(248), UINT8_C( 57), UINT8_C( 20), UINT8_C(118),
                             UINT8_C(143), UINT8_C(142), UINT8_C(167), UINT8_C(111),
                             UINT8_C( 61), UINT8_C(150), UINT8_C( 44), UINT8_C(181),
                             UINT8_C(206), UINT8_C(236), UINT8_C( 29), UINT8_C(231),
                             UINT8_C(142), UINT8_C( 18), UINT8_C( 45), UINT8_C(166),
                             UINT8_C( 68), UINT8_C(228), UINT8_C( 11), UINT8_C( 98),
                             UINT8_C(196), UINT8_C(139), UINT8_C( 34), UINT8_C( 25)),
      simde_x_mm512_set_epu8(UINT8_C(  5), UINT8_C( 56), UINT8_C(136), UINT8_C(206),
                             UINT8_C(185), UINT8_C( 86), UINT8_C(170), UINT8_C(156),
                             UINT8_C( 56), UINT8_C( 24), UINT8_C(243), UINT8_C( 74),
                             UINT8_C( 28), UINT8_C( 35), UINT8_C(114), UINT8_C(  4),
                             UINT8_C( 15), UINT8_C(140), UINT8_C(233), UINT8_C(248),
                             UINT8_C(211), UINT8_C(113), UINT8_C(132), UINT8_C( 79),
                             UINT8_C( 67), UINT8_C( 31), UINT8_C(151), UINT8_C(212),
                             UINT8_C( 77), UINT8_C(114), UINT8_C(132), UINT8_C(196),
                             UINT8_C(210), UINT8_C(113), UINT8_C(221), UINT8_C(195),
                             UINT8_C( 83), UINT8_C(114), UINT8_C(111), UINT8_C(219),
                             UINT8_C(131), UINT8_C(244), UINT8_C(252), UINT8_C(192),
                             UINT8_C(162), UINT8_C(101), UINT8_C(212), UINT8_C( 52),
                             UINT8_C( 99), UINT8_C(238), UINT8_C( 29), UINT8_C(150),
                             UINT8_C(119), UINT8_C( 43), UINT8_C( 64), UINT8_C(199),
                             UINT8_C(174), UINT8_C( 41), UINT8_C( 78), UINT8_C( 66),
                             UINT8_C(152), UINT8_C(112), UINT8_C( 89), UINT8_C(237)),
      simde_x_mm512_set_epu8(UINT8_C( 53), UINT8_C(227), UINT8_C(166), UINT8_C(167),
                             UINT8_C(220), UINT8_C( 62), UINT8_C(127), UINT8_C(188),
                             UINT8_C(162), UINT8_C( 93), UINT8_C( 87), UINT8_C( 20),
                             UINT8_C(253), UINT8_C(151), UINT8_C(167), UINT8_C( 97),
                             UINT8_C(141), UINT8_C( 56), UINT8_C( 46), UINT8_C(112),
                             UINT8_C(183), UINT8_C(242), UINT8_C(234), UINT8_C(225),
                             UINT8_C( 17), UINT8_C(244), UINT8_C(208), UINT8_C(134),
                             UINT8_C( 62), UINT8_C(227), UINT8_C(122), UINT8_C(145),
                             UINT8_C( 35), UINT8_C(116), UINT8_C( 86), UINT8_C( 57),
                             UINT8_C( 43), UINT8_C(  6), UINT8_C( 33), UINT8_C(  0),
                             UINT8_C(148), UINT8_C(  0), UINT8_C( 78), UINT8_C(  0),
                             UINT8_C( 59), UINT8_C(194), UINT8_C(  0), UINT8_C(176),
                             UINT8_C(107), UINT8_C(  3), UINT8_C(158), UINT8_C( 64),
                             UINT8_C(  7), UINT8_C(  0), UINT8_C(141), UINT8_C( 30),
                             UINT8_C( 80), UINT8_C(118), UINT8_C(234), UINT8_C( 32),
                             UINT8_C( 44), UINT8_C( 27), UINT8_C(  0), UINT8_C(147)) },
    { simde_x_mm512_set_epu8(UINT8_C(235), UINT8_C(117), UINT8_C(121), UINT8_C(105),
                             UINT8_C( 64), UINT8_C(  2), UINT8_C( 13), UINT8_C(246),
                             UINT8_C(161), UINT8_C(246), UINT8_C(247), UINT8_C( 22),
                             UINT8_C(159), UINT8_C( 42), UINT8_C(201), UINT8_C( 79),
                             UINT8_C( 21), UINT8_C(172), UINT8_C(230), UINT8_C(126),
                             UINT8_C(213), UINT8_C(157), UINT8_C(132), UINT8_C(237),
                             UINT8_C(124), UINT8_C(235), UINT8_C(111), UINT8_C( 29),
                             UINT8_C( 89), UINT8_C( 58), UINT8_C(255), UINT8_C(134),
                             UINT8_C(101), UINT8_C( 62), UINT8_C(180), UINT8_C(233),
                             UINT8_C(164), UINT8_C(115), UINT8_C(231), UINT8_C( 98),
                             UINT8_C(155), UINT8_C(153), UINT8_C(181), UINT8_C(181),
                             UINT8_C( 69), UINT8_C(210), UINT8_C(151), UINT8_C( 85),
                             UINT8_C( 48), UINT8_C( 82), UINT8_C( 52), UINT8_C( 54),
                             UINT8_C( 55), UINT8_C(158), UINT8_C(113), UINT8_C(247),
                             UINT8_C(228), UINT8_C(233), UINT8_C( 78), UINT8_C( 66),
                             UINT8_C( 93), UINT8_C(202), UINT8_C(157), UINT8_C(212)),
      UINT64_C(          2103571959),
      simde_x_mm512_set_epu8(UINT8_C(144), UINT8_C( 21), UINT8_C(157), UINT8_C( 81),
                             UINT8_C(156), UINT8_C(133), UINT8_C(103), UINT8_C(155),
                             UINT8_C(182), UINT8_C(168), UINT8_C(151), UINT8_C(201),
                             UINT8_C( 69), UINT8_C(193), UINT8_C(130), UINT8_C( 74),
                             UINT8_C(226), UINT8_C(223), UINT8_C(134), UINT8_C( 37),
                             UINT8_C( 29), UINT8_C( 47), UINT8_C( 30), UINT8_C(250),
                             UINT8_C(230), UINT8_C( 55), UINT8_C( 98), UINT8_C( 11),
                             UINT8_C(116), UINT8_C( 66), UINT8_C(237), UINT8_C(241),
                             UINT8_C(184), UINT8_C(235), UINT8_C(101), UINT8_C( 24),
                             UINT8_C(135), UINT8_C( 72), UINT8_C(219), UINT8_C(214),
                             UINT8_C( 61), UINT8_C(252), UINT8_C(209), UINT8_C(153),
                             UINT8_C( 26), UINT8_C( 69), UINT8_C(254), UINT8_C( 81),
                             UINT8_C(112), UINT8_C(  1), UINT8_C( 13), UINT8_C(163),
                             UINT8_C( 13), UINT8_C( 42), UINT8_C(243), UINT8_C(185),
                             UINT8_C( 74), UINT8_C( 36), UINT8_C(112), UINT8_C(104),
                             UINT8_C( 13), UINT8_C(101), UINT8_C(  7), UINT8_C( 51)),
      simde_x_mm512_set_epu8(UINT8_C(133), UINT8_C(195), UINT8_C( 74), UINT8_C( 77),
                             UINT8_C(127), UINT8_C(119), UINT8_C(202), UINT8_C( 85),
                             UINT8_C(236), UINT8_C( 29), UINT8_C(224), UINT8_C( 26),
                             UINT8_C(102), UINT8_C(226), UINT8_C(128), UINT8_C(173),
                             UINT8_C(247), UINT8_C(167), UINT8_C(253), UINT8_C(107),
                             UINT8_C(195), UINT8_C( 44), UINT8_C(250), UINT8_C( 78),
                             UINT8_C( 22), UINT8_C(248), UINT8_C( 49), UINT8_C(127),
                             UINT8_C(226), UINT8_C(177), UINT8_C(135), UINT8_C( 20),
                             UINT8_C(199), UINT8_C(239), UINT8_C(100), UINT8_C(134),
                             UINT8_C(164), UINT8_C(130), UINT8_C(104), UINT8_C(154),
                             UINT8_C( 70), UINT8_C(141), UINT8_C(181), UINT8_C(104),
                             UINT8_C(215), UINT8_C( 61), UINT8_C(212), UINT8_C( 26),
                             UINT8_C(110), UINT8_C(215), UINT8_C(220), UINT8_C(161),
                             UINT8_C( 37), UINT8_C( 95), UINT8_C(129), UINT8_C(178),
                             UINT8_C(134), UINT8_C( 99), UINT8_C(129), UINT8_C( 29),
                             UINT8_C(214), UINT8_C(225), UINT8_C(121), UINT8_C(165)),
      simde_x_mm512_set_epu8(UINT8_C(235), UINT8_C(117), UINT8_C(121), UINT8_C(105),
                             UINT8_C( 64), UINT8_C(  2), UINT8_C( 13), UINT8_C(246),
                             UINT8_C(161), UINT8_C(246), UINT8_C(247), UINT8_C( 22),
                             UINT8_C(159), UINT8_C( 42), UINT8_C(201), UINT8_C( 79),
                             UINT8_C( 21), UINT8_C(172), UINT8_C(230), UINT8_C(126),
                             UINT8_C(213), UINT8_C(157), UINT8_C(132), UINT8_C(237),
                             UINT8_C(124), UINT8_C(235), UINT8_C(111), UINT8_C( 29),
                             UINT8_C( 89), UINT8_C( 58), UINT8_C(255), UINT8_C(134),
                             UINT8_C(101), UINT8_C(  0), UINT8_C(  1), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(231), UINT8_C( 60),
                             UINT8_C(155), UINT8_C(111), UINT8_C( 28), UINT8_C(181),
                             UINT8_C( 69), UINT8_C(210), UINT8_C(151), UINT8_C( 55),
                             UINT8_C(  2), UINT8_C(  0), UINT8_C(  0), UINT8_C(  2),
                             UINT8_C( 55), UINT8_C(  0), UINT8_C(113), UINT8_C(  7),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 75),
                             UINT8_C( 93), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_subs_epu8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_subs_epu8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(          1678504309),
      simde_x_mm512_set_epu8(UINT8_C(188), UINT8_C(227), UINT8_C(248), UINT8_C(  6),
                             UINT8_C(158), UINT8_C(170), UINT8_C( 99), UINT8_C(202),
                             UINT8_C(160), UINT8_C(209), UINT8_C( 53), UINT8_C(241),
                             UINT8_C(169), UINT8_C( 74), UINT8_C(195), UINT8_C(156),
                             UINT8_C(226), UINT8_C(114), UINT8_C(119), UINT8_C(203),
                             UINT8_C( 15), UINT8_C( 80), UINT8_C(207), UINT8_C(120),
                             UINT8_C(164), UINT8_C(171), UINT8_C( 95), UINT8_C(130),
                             UINT8_C(161), UINT8_C(  3), UINT8_C( 82), UINT8_C(197),
                             UINT8_C( 78), UINT8_C(216), UINT8_C(176), UINT8_C(131),
                             UINT8_C(213), UINT8_C( 21), UINT8_C( 48), UINT8_C(162),
                             UINT8_C(135), UINT8_C( 81), UINT8_C( 67), UINT8_C(242),
                             UINT8_C( 97), UINT8_C( 89), UINT8_C(174), UINT8_C( 64),
                             UINT8_C(170), UINT8_C(194), UINT8_C(235), UINT8_C(133),
                             UINT8_C( 33), UINT8_C(160), UINT8_C(236), UINT8_C(  7),
                             UINT8_C(224), UINT8_C( 63), UINT8_C(130), UINT8_C( 28),
                             UINT8_C( 83), UINT8_C(152), UINT8_C(149), UINT8_C(111)),
      simde_x_mm512_set_epu8(UINT8_C(164), UINT8_C( 45), UINT8_C(193), UINT8_C(111),
                             UINT8_C( 96), UINT8_C(220), UINT8_C( 54), UINT8_C(232),
                             UINT8_C(214), UINT8_C(244), UINT8_C(236), UINT8_C( 74),
                             UINT8_C( 47), UINT8_C(180), UINT8_C(143), UINT8_C(214),
                             UINT8_C(  6), UINT8_C(178), UINT8_C( 35), UINT8_C(129),
                             UINT8_C( 21), UINT8_C(157), UINT8_C( 30), UINT8_C( 29),
                             UINT8_C(226), UINT8_C(222), UINT8_C( 14), UINT8_C(170),
                             UINT8_C(223), UINT8_C(200), UINT8_C( 41), UINT8_C(245),
                             UINT8_C(  7), UINT8_C(251), UINT8_C( 30), UINT8_C(217),
                             UINT8_C( 93), UINT8_C(228), UINT8_C(143), UINT8_C(  9),
                             UINT8_C(221), UINT8_C( 49), UINT8_C(207), UINT8_C( 44),
                             UINT8_C( 52), UINT8_C(108), UINT8_C(124), UINT8_C( 14),
                             UINT8_C(144), UINT8_C(229), UINT8_C(102), UINT8_C( 16),
                             UINT8_C( 61), UINT8_C(  2), UINT8_C(169), UINT8_C( 72),
                             UINT8_C(194), UINT8_C(122), UINT8_C(216), UINT8_C(151),
                             UINT8_C(244), UINT8_C(227), UINT8_C(  5), UINT8_C( 98)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(146), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 45), UINT8_C(  0), UINT8_C( 50), UINT8_C( 50),
                             UINT8_C( 26), UINT8_C(  0), UINT8_C(133), UINT8_C(117),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 13)) },
    { UINT64_C(          4292756020),
      simde_x_mm512_set_epu8(UINT8_C(177), UINT8_C(132), UINT8_C(179), UINT8_C(117),
                             UINT8_C(215), UINT8_C( 43), UINT8_C(143), UINT8_C( 75),
                             UINT8_C( 53), UINT8_C( 65), UINT8_C(131), UINT8_C(189),
                             UINT8_C(196), UINT8_C(200), UINT8_C(234), UINT8_C( 92),
                             UINT8_C( 99), UINT8_C(187), UINT8_C(123), UINT8_C(180),
                             UINT8_C(209), UINT8_C(163), UINT8_C( 86), UINT8_C( 26),
                             UINT8_C(192), UINT8_C( 36), UINT8_C(205), UINT8_C(108),
                             UINT8_C(173), UINT8_C( 71), UINT8_C(190), UINT8_C( 46),
                             UINT8_C(173), UINT8_C(156), UINT8_C( 59), UINT8_C(250),
                             UINT8_C( 13), UINT8_C(171), UINT8_C(  1), UINT8_C( 47),
                             UINT8_C(227), UINT8_C( 45), UINT8_C(181), UINT8_C( 45),
                             UINT8_C(116), UINT8_C( 89), UINT8_C(112), UINT8_C(127),
                             UINT8_C( 42), UINT8_C(134), UINT8_C(128), UINT8_C(206),
                             UINT8_C( 87), UINT8_C(206), UINT8_C( 39), UINT8_C(  7),
                             UINT8_C( 48), UINT8_C( 47), UINT8_C( 79), UINT8_C( 32),
                             UINT8_C( 39), UINT8_C(205), UINT8_C(174), UINT8_C(244)),
      simde_x_mm512_set_epu8(UINT8_C(103), UINT8_C( 74), UINT8_C( 78), UINT8_C(251),
                             UINT8_C( 78), UINT8_C( 92), UINT8_C( 94), UINT8_C(154),
                             UINT8_C(108), UINT8_C( 96), UINT8_C(  9), UINT8_C(145),
                             UINT8_C(131), UINT8_C(204), UINT8_C(151), UINT8_C(200),
                             UINT8_C(172), UINT8_C(193), UINT8_C(248), UINT8_C(227),
                             UINT8_C(159), UINT8_C( 34), UINT8_C( 70), UINT8_C( 14),
                             UINT8_C(229), UINT8_C( 98), UINT8_C( 73), UINT8_C(209),
                             UINT8_C( 59), UINT8_C(209), UINT8_C( 82), UINT8_C( 90),
                             UINT8_C(172), UINT8_C( 10), UINT8_C(185), UINT8_C(194),
                             UINT8_C(184), UINT8_C( 76), UINT8_C(173), UINT8_C( 75),
                             UINT8_C(136), UINT8_C(130), UINT8_C(227), UINT8_C(162),
                             UINT8_C(154), UINT8_C(158), UINT8_C(121), UINT8_C( 19),
                             UINT8_C(211), UINT8_C(197), UINT8_C( 15), UINT8_C( 80),
                             UINT8_C( 75), UINT8_C( 26), UINT8_C( 77), UINT8_C(210),
                             UINT8_C(117), UINT8_C( 85), UINT8_C(204), UINT8_C(  0),
                             UINT8_C(244), UINT8_C( 11), UINT8_C(128), UINT8_C(245)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  1), UINT8_C(146), UINT8_C(  0), UINT8_C( 56),
                             UINT8_C(  0), UINT8_C( 95), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 91), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 32),
                             UINT8_C(  0), UINT8_C(194), UINT8_C(  0), UINT8_C(  0)) },
    { UINT64_C(          3647935965),
      simde_x_mm512_set_epu8(UINT8_C(141), UINT8_C( 95), UINT8_C(101), UINT8_C(146),
                             UINT8_C(141), UINT8_C( 37), UINT8_C( 41), UINT8_C(148),
                             UINT8_C(122), UINT8_C(121), UINT8_C( 15), UINT8_C(167),
                             UINT8_C(146), UINT8_C(  1), UINT8_C( 27), UINT8_C( 93),
                             UINT8_C(177), UINT8_C(197), UINT8_C(189), UINT8_C(233),
                             UINT8_C(110), UINT8_C( 47), UINT8_C( 66), UINT8_C( 91),
                             UINT8_C( 52), UINT8_C(  7), UINT8_C(197), UINT8_C( 20),
                             UINT8_C( 34), UINT8_C(208), UINT8_C(127), UINT8_C( 73),
                             UINT8_C(145), UINT8_C(  2), UINT8_C( 27), UINT8_C(235),
                             UINT8_C(109), UINT8_C(152), UINT8_C(220), UINT8_C(143),
                             UINT8_C(189), UINT8_C(222), UINT8_C(102), UINT8_C(126),
                             UINT8_C( 80), UINT8_C( 51), UINT8_C(253), UINT8_C(186),
                             UINT8_C( 51), UINT8_C(206), UINT8_C(118), UINT8_C( 48),
                             UINT8_C( 59), UINT8_C(184), UINT8_C(197), UINT8_C(107),
                             UINT8_C( 52), UINT8_C(  5), UINT8_C(208), UINT8_C(231),
                             UINT8_C(151), UINT8_C(166), UINT8_C(151), UINT8_C( 49)),
      simde_x_mm512_set_epu8(UINT8_C(255), UINT8_C(129), UINT8_C(219), UINT8_C(221),
                             UINT8_C(186), UINT8_C( 75), UINT8_C(231), UINT8_C(243),
                             UINT8_C( 54), UINT8_C( 10), UINT8_C( 52), UINT8_C(157),
                             UINT8_C( 51), UINT8_C( 63), UINT8_C(190), UINT8_C(105),
                             UINT8_C(159), UINT8_C( 57), UINT8_C(152), UINT8_C(  2),
                             UINT8_C(134), UINT8_C(112), UINT8_C( 29), UINT8_C(  8),
                             UINT8_C(240), UINT8_C( 55), UINT8_C(110), UINT8_C(144),
                             UINT8_C(247), UINT8_C( 78), UINT8_C(254), UINT8_C( 89),
                             UINT8_C(189), UINT8_C(169), UINT8_C(164), UINT8_C(239),
                             UINT8_C(227), UINT8_C(187), UINT8_C( 11), UINT8_C(211),
                             UINT8_C(183), UINT8_C(  9), UINT8_C(204), UINT8_C(138),
                             UINT8_C(223), UINT8_C( 91), UINT8_C(198), UINT8_C( 18),
                             UINT8_C(178), UINT8_C(209), UINT8_C(152), UINT8_C(100),
                             UINT8_C(247), UINT8_C(142), UINT8_C( 53), UINT8_C( 94),
                             UINT8_C(238), UINT8_C(239), UINT8_C(151), UINT8_C(119),
                             UINT8_C(229), UINT8_C( 96), UINT8_C(245), UINT8_C(  0)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(213), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 55), UINT8_C(168),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 42), UINT8_C(  0), UINT8_C( 13),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(112),
                             UINT8_C(  0), UINT8_C( 70), UINT8_C(  0), UINT8_C( 49)) },
    { UINT64_C(          2805277521),
      simde_x_mm512_set_epu8(UINT8_C(241), UINT8_C(232), UINT8_C(128), UINT8_C(233),
                             UINT8_C(178), UINT8_C(  6), UINT8_C(154), UINT8_C(184),
                             UINT8_C(219), UINT8_C(217), UINT8_C( 22), UINT8_C( 47),
                             UINT8_C( 81), UINT8_C(179), UINT8_C( 53), UINT8_C( 28),
                             UINT8_C(206), UINT8_C(206), UINT8_C( 30), UINT8_C( 15),
                             UINT8_C(114), UINT8_C(103), UINT8_C( 13), UINT8_C(110),
                             UINT8_C(166), UINT8_C( 46), UINT8_C(130), UINT8_C(151),
                             UINT8_C( 16), UINT8_C( 40), UINT8_C(154), UINT8_C( 67),
                             UINT8_C(184), UINT8_C( 37), UINT8_C(207), UINT8_C( 94),
                             UINT8_C( 79), UINT8_C(202), UINT8_C(122), UINT8_C(203),
                             UINT8_C(179), UINT8_C(164), UINT8_C( 37), UINT8_C(173),
                             UINT8_C( 95), UINT8_C(170), UINT8_C( 47), UINT8_C(161),
                             UINT8_C(255), UINT8_C(185), UINT8_C(163), UINT8_C(181),
                             UINT8_C( 29), UINT8_C(148), UINT8_C(134), UINT8_C( 11),
                             UINT8_C(137), UINT8_C(213), UINT8_C(115), UINT8_C(139),
                             UINT8_C( 77), UINT8_C(129), UINT8_C( 55), UINT8_C(  6)),
      simde_x_mm512_set_epu8(UINT8_C( 39), UINT8_C(159), UINT8_C( 61), UINT8_C( 37),
                             UINT8_C(160), UINT8_C(166), UINT8_C( 87), UINT8_C(103),
                             UINT8_C(228), UINT8_C( 29), UINT8_C(156), UINT8_C(201),
                             UINT8_C(217), UINT8_C( 60), UINT8_C( 61), UINT8_C( 86),
                             UINT8_C(205), UINT8_C(204), UINT8_C( 26), UINT8_C( 35),
                             UINT8_C(113), UINT8_C( 54), UINT8_C( 44), UINT8_C(150),
                             UINT8_C(  5), UINT8_C(127), UINT8_C(118), UINT8_C(122),
                             UINT8_C(  8), UINT8_C( 76), UINT8_C( 62), UINT8_C( 54),
                             UINT8_C(171), UINT8_C(236), UINT8_C(228), UINT8_C( 23),
                             UINT8_C(167), UINT8_C( 85), UINT8_C(106), UINT8_C(203),
                             UINT8_C( 75), UINT8_C(211), UINT8_C(183), UINT8_C(233),
                             UINT8_C(230), UINT8_C(155), UINT8_C(159), UINT8_C(231),
                             UINT8_C( 53), UINT8_C( 16), UINT8_C(224), UINT8_C(218),
                             UINT8_C(254), UINT8_C(170), UINT8_C(229), UINT8_C(158),
                             UINT8_C(154), UINT8_C(108), UINT8_C(114), UINT8_C(193),
                             UINT8_C(254), UINT8_C( 39), UINT8_C(143), UINT8_C(155)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 13), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(117), UINT8_C( 16), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 15), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(105), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0)) },
    { UINT64_C(          2080103780),
      simde_x_mm512_set_epu8(UINT8_C( 35), UINT8_C(245), UINT8_C(193), UINT8_C( 56),
                             UINT8_C(248), UINT8_C(186), UINT8_C( 68), UINT8_C(150),
                             UINT8_C(220), UINT8_C(248), UINT8_C(101), UINT8_C(  0),
                             UINT8_C(116), UINT8_C(116), UINT8_C( 64), UINT8_C(175),
                             UINT8_C(165), UINT8_C(173), UINT8_C(234), UINT8_C(165),
                             UINT8_C(146), UINT8_C(243), UINT8_C( 52), UINT8_C( 89),
                             UINT8_C(227), UINT8_C( 93), UINT8_C(108), UINT8_C( 47),
                             UINT8_C(207), UINT8_C(115), UINT8_C(178), UINT8_C(155),
                             UINT8_C(250), UINT8_C(115), UINT8_C(  2), UINT8_C( 73),
                             UINT8_C(254), UINT8_C(119), UINT8_C( 72), UINT8_C(108),
                             UINT8_C( 90), UINT8_C( 96), UINT8_C( 56), UINT8_C(182),
                             UINT8_C( 64), UINT8_C(  8), UINT8_C(172), UINT8_C(169),
                             UINT8_C( 32), UINT8_C( 75), UINT8_C( 92), UINT8_C(114),
                             UINT8_C( 16), UINT8_C( 36), UINT8_C(161), UINT8_C( 46),
                             UINT8_C(214), UINT8_C(247), UINT8_C(176), UINT8_C( 43),
                             UINT8_C(168), UINT8_C(161), UINT8_C(148), UINT8_C( 77)),
      simde_x_mm512_set_epu8(UINT8_C( 56), UINT8_C(209), UINT8_C( 90), UINT8_C(226),
                             UINT8_C(128), UINT8_C( 65), UINT8_C( 94), UINT8_C(244),
                             UINT8_C(183), UINT8_C( 61), UINT8_C(186), UINT8_C(254),
                             UINT8_C(239), UINT8_C( 84), UINT8_C(120), UINT8_C(211),
                             UINT8_C(215), UINT8_C( 43), UINT8_C(249), UINT8_C(194),
                             UINT8_C(157), UINT8_C(199), UINT8_C( 98), UINT8_C(233),
                             UINT8_C( 27), UINT8_C(181), UINT8_C(227), UINT8_C( 75),
                             UINT8_C( 73), UINT8_C( 96), UINT8_C(149), UINT8_C(223),
                             UINT8_C(104), UINT8_C( 32), UINT8_C( 22), UINT8_C(168),
                             UINT8_C( 89), UINT8_C( 99), UINT8_C(164), UINT8_C(153),
                             UINT8_C( 65), UINT8_C(170), UINT8_C( 53), UINT8_C( 47),
                             UINT8_C(191), UINT8_C(169), UINT8_C( 40), UINT8_C( 76),
                             UINT8_C(114), UINT8_C(220), UINT8_C( 85), UINT8_C(210),
                             UINT8_C(141), UINT8_C( 16), UINT8_C( 66), UINT8_C(216),
                             UINT8_C(211), UINT8_C(107), UINT8_C(217), UINT8_C(119),
                             UINT8_C(250), UINT8_C( 64), UINT8_C(254), UINT8_C( 91)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 83), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(165), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 25), UINT8_C(  0), UINT8_C(  3), UINT8_C(135),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(132), UINT8_C( 93),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 20), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(140), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 97), UINT8_C(  0), UINT8_C(  0)) },
    { UINT64_C(          3123384269),
      simde_x_mm512_set_epu8(UINT8_C( 96), UINT8_C(111), UINT8_C( 93), UINT8_C(100),
                             UINT8_C(124), UINT8_C( 70), UINT8_C(116), UINT8_C(210),
                             UINT8_C( 69), UINT8_C(255), UINT8_C(157), UINT8_C(160),
                             UINT8_C( 53), UINT8_C( 12), UINT8_C(237), UINT8_C(134),
                             UINT8_C( 21), UINT8_C(153), UINT8_C(252), UINT8_C(180),
                             UINT8_C(184), UINT8_C( 70), UINT8_C( 16), UINT8_C(164),
                             UINT8_C( 32), UINT8_C(157), UINT8_C(177), UINT8_C(185),
                             UINT8_C( 75), UINT8_C(213), UINT8_C(118), UINT8_C( 48),
                             UINT8_C(250), UINT8_C(247), UINT8_C(144), UINT8_C(182),
                             UINT8_C( 89), UINT8_C(193), UINT8_C(215), UINT8_C(109),
                             UINT8_C( 32), UINT8_C( 44), UINT8_C( 30), UINT8_C(115),
                             UINT8_C(122), UINT8_C(173), UINT8_C( 22), UINT8_C(177),
                             UINT8_C(163), UINT8_C(190), UINT8_C(161), UINT8_C(157),
                             UINT8_C(186), UINT8_C(207), UINT8_C(230), UINT8_C( 94),
                             UINT8_C(188), UINT8_C( 54), UINT8_C(164), UINT8_C(150),
                             UINT8_C( 11), UINT8_C( 80), UINT8_C(167), UINT8_C(171)),
      simde_x_mm512_set_epu8(UINT8_C( 62), UINT8_C(166), UINT8_C(227), UINT8_C( 87),
                             UINT8_C(254), UINT8_C( 17), UINT8_C(235), UINT8_C(147),
                             UINT8_C(215), UINT8_C(  8), UINT8_C(107), UINT8_C( 75),
                             UINT8_C(237), UINT8_C(121), UINT8_C( 75), UINT8_C( 80),
                             UINT8_C( 31), UINT8_C( 58), UINT8_C(132), UINT8_C( 37),
                             UINT8_C(154), UINT8_C(  6), UINT8_C( 75), UINT8_C(156),
                             UINT8_C(149), UINT8_C(144), UINT8_C(181), UINT8_C(171),
                             UINT8_C(160), UINT8_C( 77), UINT8_C(155), UINT8_C(252),
                             UINT8_C(181), UINT8_C(149), UINT8_C( 69), UINT8_C( 75),
                             UINT8_C(202), UINT8_C( 32), UINT8_C( 21), UINT8_C( 82),
                             UINT8_C(184), UINT8_C(152), UINT8_C(217), UINT8_C( 20),
                             UINT8_C( 41), UINT8_C( 41), UINT8_C(  1), UINT8_C( 97),
                             UINT8_C(165), UINT8_C(111), UINT8_C(131), UINT8_C( 21),
                             UINT8_C( 63), UINT8_C( 20), UINT8_C(145), UINT8_C(147),
                             UINT8_C( 66), UINT8_C( 29), UINT8_C(208), UINT8_C( 15),
                             UINT8_C(209), UINT8_C(114), UINT8_C(194), UINT8_C(  3)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 69), UINT8_C(  0), UINT8_C( 75), UINT8_C(107),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(194), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 81), UINT8_C(  0), UINT8_C( 21), UINT8_C( 80),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(123), UINT8_C(187), UINT8_C( 85), UINT8_C(  0),
                             UINT8_C(122), UINT8_C( 25), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(168)) },
    { UINT64_C(          3899248884),
      simde_x_mm512_set_epu8(UINT8_C(219), UINT8_C(209), UINT8_C(106), UINT8_C(223),
                             UINT8_C(220), UINT8_C(150), UINT8_C(243), UINT8_C( 88),
                             UINT8_C( 23), UINT8_C( 59), UINT8_C(210), UINT8_C(197),
                             UINT8_C( 39), UINT8_C(187), UINT8_C( 89), UINT8_C( 99),
                             UINT8_C( 19), UINT8_C(249), UINT8_C( 10), UINT8_C( 39),
                             UINT8_C(237), UINT8_C(106), UINT8_C( 56), UINT8_C( 28),
                             UINT8_C(181), UINT8_C( 56), UINT8_C(192), UINT8_C(150),
                             UINT8_C( 44), UINT8_C(209), UINT8_C( 13), UINT8_C(238),
                             UINT8_C(199), UINT8_C(135), UINT8_C(144), UINT8_C(  8),
                             UINT8_C( 13), UINT8_C(143), UINT8_C(242), UINT8_C(219),
                             UINT8_C(103), UINT8_C(252), UINT8_C(214), UINT8_C(167),
                             UINT8_C(  3), UINT8_C(136), UINT8_C(222), UINT8_C(241),
                             UINT8_C(  7), UINT8_C( 92), UINT8_C(141), UINT8_C(140),
                             UINT8_C(104), UINT8_C(125), UINT8_C(212), UINT8_C(114),
                             UINT8_C(114), UINT8_C(229), UINT8_C(235), UINT8_C(144),
                             UINT8_C(233), UINT8_C(188), UINT8_C( 95), UINT8_C(193)),
      simde_x_mm512_set_epu8(UINT8_C(198), UINT8_C( 49), UINT8_C(205), UINT8_C(189),
                             UINT8_C( 32), UINT8_C(168), UINT8_C(102), UINT8_C( 88),
                             UINT8_C( 86), UINT8_C(170), UINT8_C(185), UINT8_C( 98),
                             UINT8_C(232), UINT8_C( 43), UINT8_C( 26), UINT8_C(165),
                             UINT8_C(105), UINT8_C(165), UINT8_C(196), UINT8_C(175),
                             UINT8_C( 21), UINT8_C( 33), UINT8_C( 59), UINT8_C( 91),
                             UINT8_C(173), UINT8_C( 84), UINT8_C(102), UINT8_C(234),
                             UINT8_C(240), UINT8_C( 97), UINT8_C( 44), UINT8_C(117),
                             UINT8_C(253), UINT8_C( 63), UINT8_C(177), UINT8_C(  7),
                             UINT8_C( 84), UINT8_C(101), UINT8_C( 54), UINT8_C(237),
                             UINT8_C(110), UINT8_C( 66), UINT8_C( 52), UINT8_C(158),
                             UINT8_C(218), UINT8_C(146), UINT8_C(129), UINT8_C(  7),
                             UINT8_C(170), UINT8_C( 34), UINT8_C( 11), UINT8_C( 33),
                             UINT8_C(109), UINT8_C( 75), UINT8_C(249), UINT8_C(174),
                             UINT8_C( 89), UINT8_C(221), UINT8_C(115), UINT8_C(113),
                             UINT8_C(179), UINT8_C( 55), UINT8_C(200), UINT8_C( 84)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 72), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(186), UINT8_C(162), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(234),
                             UINT8_C(  0), UINT8_C( 58), UINT8_C(  0), UINT8_C(107),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 25), UINT8_C(  8), UINT8_C(120), UINT8_C( 31),
                             UINT8_C(  0), UINT8_C(133), UINT8_C(  0), UINT8_C(  0)) },
    { UINT64_C(          1783299355),
      simde_x_mm512_set_epu8(UINT8_C(158), UINT8_C( 81), UINT8_C(244), UINT8_C( 20),
                             UINT8_C(204), UINT8_C( 92), UINT8_C(198), UINT8_C(205),
                             UINT8_C( 11), UINT8_C( 60), UINT8_C(191), UINT8_C( 47),
                             UINT8_C( 22), UINT8_C(151), UINT8_C(149), UINT8_C( 16),
                             UINT8_C(247), UINT8_C(164), UINT8_C( 21), UINT8_C( 75),
                             UINT8_C(153), UINT8_C(240), UINT8_C(253), UINT8_C(242),
                             UINT8_C(202), UINT8_C( 54), UINT8_C( 42), UINT8_C(168),
                             UINT8_C( 22), UINT8_C(221), UINT8_C( 17), UINT8_C(189),
                             UINT8_C( 39), UINT8_C(155), UINT8_C(135), UINT8_C(162),
                             UINT8_C(148), UINT8_C(181), UINT8_C(120), UINT8_C( 52),
                             UINT8_C(206), UINT8_C( 24), UINT8_C(206), UINT8_C(117),
                             UINT8_C(240), UINT8_C( 17), UINT8_C(210), UINT8_C(188),
                             UINT8_C(193), UINT8_C(112), UINT8_C( 80), UINT8_C(199),
                             UINT8_C(136), UINT8_C( 33), UINT8_C( 97), UINT8_C(247),
                             UINT8_C(161), UINT8_C( 97), UINT8_C( 42), UINT8_C(181),
                             UINT8_C( 25), UINT8_C( 62), UINT8_C( 47), UINT8_C( 32)),
      simde_x_mm512_set_epu8(UINT8_C(249), UINT8_C(227), UINT8_C(149), UINT8_C(232),
                             UINT8_C( 71), UINT8_C(244), UINT8_C(128), UINT8_C( 10),
                             UINT8_C(194), UINT8_C(169), UINT8_C(169), UINT8_C( 87),
                             UINT8_C(140), UINT8_C(131), UINT8_C( 55), UINT8_C(150),
                             UINT8_C(104), UINT8_C(180), UINT8_C(190), UINT8_C(178),
                             UINT8_C(  3), UINT8_C( 92), UINT8_C(141), UINT8_C( 72),
                             UINT8_C( 98), UINT8_C( 81), UINT8_C(150), UINT8_C(221),
                             UINT8_C( 96), UINT8_C( 40), UINT8_C(142), UINT8_C( 23),
                             UINT8_C( 87), UINT8_C(207), UINT8_C(191), UINT8_C( 92),
                             UINT8_C( 77), UINT8_C(157), UINT8_C(184), UINT8_C(138),
                             UINT8_C(172), UINT8_C( 66), UINT8_C(  9), UINT8_C(115),
                             UINT8_C(240), UINT8_C(175), UINT8_C(107), UINT8_C( 49),
                             UINT8_C( 50), UINT8_C(243), UINT8_C( 59), UINT8_C( 91),
                             UINT8_C(  0), UINT8_C( 76), UINT8_C(  9), UINT8_C(  2),
                             UINT8_C( 15), UINT8_C( 39), UINT8_C(150), UINT8_C( 31),
                             UINT8_C( 12), UINT8_C(247), UINT8_C(212), UINT8_C( 40)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 71), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(103), UINT8_C(  0),
                             UINT8_C(143), UINT8_C(  0), UINT8_C( 21), UINT8_C(108),
                             UINT8_C(136), UINT8_C(  0), UINT8_C(  0), UINT8_C(245),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(150),
                             UINT8_C( 13), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_subs_epu8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_subs_epu16(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu16(UINT16_C( 21075), UINT16_C( 30017), UINT16_C( 53638), UINT16_C( 29710),
                              UINT16_C( 19457), UINT16_C( 52740), UINT16_C( 21427), UINT16_C( 28826),
                              UINT16_C( 25482), UINT16_C( 53693), UINT16_C( 15582), UINT16_C( 20114),
                              UINT16_C( 50775), UINT16_C( 49946), UINT16_C( 61394), UINT16_C( 29932),
                              UINT16_C( 34864), UINT16_C(  6190), UINT16_C( 26590), UINT16_C( 10803),
                              UINT16_C( 48982), UINT16_C( 15816), UINT16_C( 14967), UINT16_C( 24063),
                              UINT16_C( 50823), UINT16_C( 57442), UINT16_C( 48719), UINT16_C( 25507),
                              UINT16_C( 19912), UINT16_C( 45607), UINT16_C( 52932), UINT16_C( 48380)),
      simde_x_mm512_set_epu16(UINT16_C( 27175), UINT16_C( 38414), UINT16_C( 58622), UINT16_C( 10212),
                              UINT16_C( 13894), UINT16_C( 60916), UINT16_C( 54812), UINT16_C( 62458),
                              UINT16_C( 29698), UINT16_C(  6009), UINT16_C( 28893), UINT16_C( 33802),
                              UINT16_C( 61579), UINT16_C(  6787), UINT16_C(  9325), UINT16_C(  7645),
                              UINT16_C( 63403), UINT16_C( 55903), UINT16_C( 43011), UINT16_C(  1124),
                              UINT16_C( 21781), UINT16_C( 17119), UINT16_C( 46075), UINT16_C( 33402),
                              UINT16_C( 58029), UINT16_C( 19092), UINT16_C( 21408), UINT16_C( 51092),
                              UINT16_C( 22843), UINT16_C( 28625), UINT16_C( 63214), UINT16_C(  5251)),
      simde_x_mm512_set_epu16(UINT16_C(     0), UINT16_C(     0), UINT16_C(     0), UINT16_C( 19498),
                              UINT16_C(  5563), UINT16_C(     0), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 47684), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 43159), UINT16_C( 52069), UINT16_C( 22287),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C(     0), UINT16_C(  9679),
                              UINT16_C( 27201), UINT16_C(     0), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 38350), UINT16_C( 27311), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 16982), UINT16_C(     0), UINT16_C( 43129)) },
    { simde_x_mm512_set_epu16(UINT16_C( 38028), UINT16_C(  5509), UINT16_C( 52010), UINT16_C( 16909),
                              UINT16_C(  2419), UINT16_C( 22142), UINT16_C( 59427), UINT16_C( 64359),
                              UINT16_C(  9839), UINT16_C(  6329), UINT16_C( 65297), UINT16_C( 49651),
                              UINT16_C(  3666), UINT16_C( 20122), UINT16_C( 63837), UINT16_C(  6503),
                              UINT16_C( 29169), UINT16_C( 60855), UINT16_C( 62823), UINT16_C( 40827),
                              UINT16_C(  7221), UINT16_C( 61818), UINT16_C(   970), UINT16_C( 49978),
                              UINT16_C( 54525), UINT16_C( 54749), UINT16_C( 35566), UINT16_C(  3894),
                              UINT16_C( 39622), UINT16_C( 46778), UINT16_C( 11824), UINT16_C( 56668)),
      simde_x_mm512_set_epu16(UINT16_C(  1604), UINT16_C( 19874), UINT16_C( 53403), UINT16_C( 63570),
                              UINT16_C( 13041), UINT16_C(  1566), UINT16_C( 53745), UINT16_C( 62111),
                              UINT16_C(  7377), UINT16_C( 42156), UINT16_C( 56287), UINT16_C( 34285),
                              UINT16_C( 14877), UINT16_C( 24009), UINT16_C( 33220), UINT16_C(  8308),
                              UINT16_C( 53811), UINT16_C( 55306), UINT16_C(  1074), UINT16_C( 12341),
                              UINT16_C( 19989), UINT16_C( 16491), UINT16_C(  4144), UINT16_C( 53822),
                              UINT16_C( 19285), UINT16_C( 36338), UINT16_C( 40278), UINT16_C( 36022),
                              UINT16_C(  9755), UINT16_C( 36151), UINT16_C( 42425), UINT16_C( 62124)),
      simde_x_mm512_set_epu16(UINT16_C( 36424), UINT16_C(     0), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 20576), UINT16_C(  5682), UINT16_C(  2248),
                              UINT16_C(  2462), UINT16_C(     0), UINT16_C(  9010), UINT16_C( 15366),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C( 30617), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C(  5549), UINT16_C( 61749), UINT16_C( 28486),
                              UINT16_C(     0), UINT16_C( 45327), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C( 35240), UINT16_C( 18411), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C( 29867), UINT16_C( 10627), UINT16_C(     0), UINT16_C(     0)) },
    { simde_x_mm512_set_epu16(UINT16_C(   691), UINT16_C( 60713), UINT16_C( 62283), UINT16_C( 34144),
                              UINT16_C( 43752), UINT16_C( 58796), UINT16_C(  9130), UINT16_C( 47263),
                              UINT16_C( 11275), UINT16_C( 38444), UINT16_C(    90), UINT16_C( 45403),
                              UINT16_C( 30523), UINT16_C( 27008), UINT16_C( 28387), UINT16_C( 17266),
                              UINT16_C( 55759), UINT16_C( 27096), UINT16_C( 57208), UINT16_C( 58724),
                              UINT16_C( 42582), UINT16_C( 61127), UINT16_C( 21734), UINT16_C( 45841),
                              UINT16_C( 53555), UINT16_C( 44341), UINT16_C( 18272), UINT16_C( 28327),
                              UINT16_C(  7123), UINT16_C( 33320), UINT16_C( 24489), UINT16_C( 49868)),
      simde_x_mm512_set_epu16(UINT16_C( 44159), UINT16_C( 15856), UINT16_C(  7686), UINT16_C( 36968),
                              UINT16_C( 50344), UINT16_C( 55789), UINT16_C( 11300), UINT16_C( 27000),
                              UINT16_C( 58901), UINT16_C(  3626), UINT16_C( 12716), UINT16_C( 34965),
                              UINT16_C( 31697), UINT16_C(  5622), UINT16_C( 24444), UINT16_C( 57310),
                              UINT16_C( 57273), UINT16_C(  2890), UINT16_C( 26732), UINT16_C( 56773),
                              UINT16_C( 51586), UINT16_C( 27415), UINT16_C(  7653), UINT16_C( 31511),
                              UINT16_C( 44454), UINT16_C(  2398), UINT16_C( 23365), UINT16_C( 52633),
                              UINT16_C( 47315), UINT16_C(  4204), UINT16_C( 45083), UINT16_C( 15021)),
      simde_x_mm512_set_epu16(UINT16_C(     0), UINT16_C( 44857), UINT16_C( 54597), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C(  3007), UINT16_C(     0), UINT16_C( 20263),
                              UINT16_C(     0), UINT16_C( 34818), UINT16_C(     0), UINT16_C( 10438),
                              UINT16_C(     0), UINT16_C( 21386), UINT16_C(  3943), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 24206), UINT16_C( 30476), UINT16_C(  1951),
                              UINT16_C(     0), UINT16_C( 33712), UINT16_C( 14081), UINT16_C( 14330),
                              UINT16_C(  9101), UINT16_C( 41943), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 29116), UINT16_C(     0), UINT16_C( 34847)) },
    { simde_x_mm512_set_epu16(UINT16_C(  4451), UINT16_C( 62415), UINT16_C( 11648), UINT16_C( 14185),
                              UINT16_C( 57037), UINT16_C( 40857), UINT16_C( 33903), UINT16_C( 19019),
                              UINT16_C( 26210), UINT16_C( 35593), UINT16_C( 46653), UINT16_C( 25468),
                              UINT16_C( 20366), UINT16_C(  4961), UINT16_C( 40068), UINT16_C( 61378),
                              UINT16_C(  6653), UINT16_C( 63816), UINT16_C( 35813), UINT16_C( 51292),
                              UINT16_C( 60619), UINT16_C(   730), UINT16_C( 44859), UINT16_C( 16986),
                              UINT16_C(  9316), UINT16_C( 28795), UINT16_C( 47263), UINT16_C( 36113),
                              UINT16_C( 41862), UINT16_C(  7963), UINT16_C( 28019), UINT16_C( 13728)),
      simde_x_mm512_set_epu16(UINT16_C( 54766), UINT16_C( 29411), UINT16_C( 30463), UINT16_C( 60634),
                              UINT16_C( 45144), UINT16_C( 37285), UINT16_C( 11448), UINT16_C( 27155),
                              UINT16_C( 53867), UINT16_C( 11820), UINT16_C( 49024), UINT16_C( 10540),
                              UINT16_C( 17477), UINT16_C( 45777), UINT16_C( 28024), UINT16_C( 51105),
                              UINT16_C( 24400), UINT16_C( 57953), UINT16_C( 53407), UINT16_C( 28592),
                              UINT16_C( 34479), UINT16_C( 47445), UINT16_C( 19926), UINT16_C( 36275),
                              UINT16_C(  7501), UINT16_C( 16620), UINT16_C(  6953), UINT16_C(  3437),
                              UINT16_C(  5790), UINT16_C(  5348), UINT16_C( 17145), UINT16_C( 36745)),
      simde_x_mm512_set_epu16(UINT16_C(     0), UINT16_C( 33004), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C( 11893), UINT16_C(  3572), UINT16_C( 22455), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 23773), UINT16_C(     0), UINT16_C( 14928),
                              UINT16_C(  2889), UINT16_C(     0), UINT16_C( 12044), UINT16_C( 10273),
                              UINT16_C(     0), UINT16_C(  5863), UINT16_C(     0), UINT16_C( 22700),
                              UINT16_C( 26140), UINT16_C(     0), UINT16_C( 24933), UINT16_C(     0),
                              UINT16_C(  1815), UINT16_C( 12175), UINT16_C( 40310), UINT16_C( 32676),
                              UINT16_C( 36072), UINT16_C(  2615), UINT16_C( 10874), UINT16_C(     0)) },
    { simde_x_mm512_set_epu16(UINT16_C( 33975), UINT16_C( 18949), UINT16_C( 63249), UINT16_C( 45002),
                              UINT16_C( 64479), UINT16_C( 62490), UINT16_C( 22138), UINT16_C( 54505),
                              UINT16_C(    43), UINT16_C( 59270), UINT16_C( 45446), UINT16_C( 43143),
                              UINT16_C( 39490), UINT16_C( 41833), UINT16_C( 28092), UINT16_C(  6346),
                              UINT16_C( 10308), UINT16_C(   572), UINT16_C(     5), UINT16_C( 15306),
                              UINT16_C( 46107), UINT16_C( 59725), UINT16_C( 38116), UINT16_C( 36408),
                              UINT16_C( 51860), UINT16_C( 61863), UINT16_C( 39379), UINT16_C( 19197),
                              UINT16_C( 37943), UINT16_C( 45506), UINT16_C(  3690), UINT16_C( 61686)),
      simde_x_mm512_set_epu16(UINT16_C( 53628), UINT16_C( 14774), UINT16_C(  5244), UINT16_C( 18107),
                              UINT16_C( 49140), UINT16_C( 31910), UINT16_C( 36671), UINT16_C( 45498),
                              UINT16_C( 46302), UINT16_C( 50428), UINT16_C( 55100), UINT16_C( 19911),
                              UINT16_C(  3330), UINT16_C( 28633), UINT16_C( 10550), UINT16_C( 56178),
                              UINT16_C( 23697), UINT16_C( 19726), UINT16_C( 39129), UINT16_C( 46658),
                              UINT16_C(  4326), UINT16_C( 42894), UINT16_C( 48134), UINT16_C( 16035),
                              UINT16_C( 14223), UINT16_C( 50376), UINT16_C( 56066), UINT16_C( 61784),
                              UINT16_C(  6710), UINT16_C( 21116), UINT16_C( 55957), UINT16_C( 10253)),
      simde_x_mm512_set_epu16(UINT16_C(     0), UINT16_C(  4175), UINT16_C( 58005), UINT16_C( 26895),
                              UINT16_C( 15339), UINT16_C( 30580), UINT16_C(     0), UINT16_C(  9007),
                              UINT16_C(     0), UINT16_C(  8842), UINT16_C(     0), UINT16_C( 23232),
                              UINT16_C( 36160), UINT16_C( 13200), UINT16_C( 17542), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C( 41781), UINT16_C( 16831), UINT16_C(     0), UINT16_C( 20373),
                              UINT16_C( 37637), UINT16_C( 11487), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C( 31233), UINT16_C( 24390), UINT16_C(     0), UINT16_C( 51433)) },
    { simde_x_mm512_set_epu16(UINT16_C(  1468), UINT16_C( 61147), UINT16_C(  1296), UINT16_C( 37821),
                              UINT16_C( 49916), UINT16_C(  3731), UINT16_C( 58247), UINT16_C( 37833),
                              UINT16_C(   474), UINT16_C( 27447), UINT16_C( 56500), UINT16_C(  9176),
                              UINT16_C(  2726), UINT16_C( 53392), UINT16_C( 63435), UINT16_C( 26907),
                              UINT16_C( 40836), UINT16_C(  1244), UINT16_C( 61609), UINT16_C( 42904),
                              UINT16_C( 58011), UINT16_C( 17743), UINT16_C( 15263), UINT16_C( 61713),
                              UINT16_C( 27307), UINT16_C( 32391), UINT16_C( 42266), UINT16_C( 36235),
                              UINT16_C( 23369), UINT16_C( 50245), UINT16_C( 59696), UINT16_C( 18168)),
      simde_x_mm512_set_epu16(UINT16_C( 23449), UINT16_C( 17725), UINT16_C( 44617), UINT16_C( 31466),
                              UINT16_C( 31308), UINT16_C( 63353), UINT16_C( 34185), UINT16_C( 33150),
                              UINT16_C( 26890), UINT16_C( 34945), UINT16_C( 52751), UINT16_C( 41898),
                              UINT16_C( 33581), UINT16_C( 55689), UINT16_C( 19108), UINT16_C( 45621),
                              UINT16_C(  4587), UINT16_C( 27034), UINT16_C( 65517), UINT16_C( 28332),
                              UINT16_C( 41747), UINT16_C( 40576), UINT16_C( 59697), UINT16_C( 25722),
                              UINT16_C( 41113), UINT16_C( 15592), UINT16_C(  6092), UINT16_C( 56264),
                              UINT16_C( 52740), UINT16_C( 47873), UINT16_C( 59382), UINT16_C( 23859)),
      simde_x_mm512_set_epu16(UINT16_C(     0), UINT16_C( 43422), UINT16_C(     0), UINT16_C(  6355),
                              UINT16_C( 18608), UINT16_C(     0), UINT16_C( 24062), UINT16_C(  4683),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C(  3749), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C( 44327), UINT16_C(     0),
                              UINT16_C( 36249), UINT16_C(     0), UINT16_C(     0), UINT16_C( 14572),
                              UINT16_C( 16264), UINT16_C(     0), UINT16_C(     0), UINT16_C( 35991),
                              UINT16_C(     0), UINT16_C( 16799), UINT16_C( 36174), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C(  2372), UINT16_C(   314), UINT16_C(     0)) },
    { simde_x_mm512_set_epu16(UINT16_C( 42795), UINT16_C( 13394), UINT16_C( 56119), UINT16_C( 28906),
                              UINT16_C( 46556), UINT16_C( 57073), UINT16_C(  9174), UINT16_C( 39931),
                              UINT16_C(   547), UINT16_C(  3767), UINT16_C( 52959), UINT16_C( 48990),
                              UINT16_C( 64235), UINT16_C( 58389), UINT16_C( 26281), UINT16_C( 29309),
                              UINT16_C( 29052), UINT16_C( 34694), UINT16_C(  5995), UINT16_C(  6270),
                              UINT16_C( 20539), UINT16_C( 10179), UINT16_C( 38688), UINT16_C( 14327),
                              UINT16_C( 15491), UINT16_C( 18652), UINT16_C( 19903), UINT16_C( 30123),
                              UINT16_C( 25261), UINT16_C( 48076), UINT16_C( 10742), UINT16_C( 60984)),
      simde_x_mm512_set_epu16(UINT16_C(  5754), UINT16_C( 42498), UINT16_C( 48947), UINT16_C( 41678),
                              UINT16_C( 61715), UINT16_C( 60738), UINT16_C( 30602), UINT16_C( 37004),
                              UINT16_C( 11508), UINT16_C(  7979), UINT16_C( 61659), UINT16_C( 59616),
                              UINT16_C( 41386), UINT16_C( 41040), UINT16_C( 17421), UINT16_C( 63555),
                              UINT16_C( 27523), UINT16_C( 26800), UINT16_C( 25010), UINT16_C( 27339),
                              UINT16_C( 56486), UINT16_C( 19128), UINT16_C( 15279), UINT16_C( 63719),
                              UINT16_C( 51613), UINT16_C(  5129), UINT16_C( 42918), UINT16_C( 27704),
                              UINT16_C( 60753), UINT16_C( 31238), UINT16_C( 35194), UINT16_C( 56682)),
      simde_x_mm512_set_epu16(UINT16_C( 37041), UINT16_C(     0), UINT16_C(  7172), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C(     0), UINT16_C(  2927),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C( 22849), UINT16_C( 17349), UINT16_C(  8860), UINT16_C(     0),
                              UINT16_C(  1529), UINT16_C(  7894), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C( 23409), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 13523), UINT16_C(     0), UINT16_C(  2419),
                              UINT16_C(     0), UINT16_C( 16838), UINT16_C(     0), UINT16_C(  4302)) },
    { simde_x_mm512_set_epu16(UINT16_C( 27021), UINT16_C( 31131), UINT16_C(    63), UINT16_C( 55006),
                              UINT16_C( 64465), UINT16_C( 34252), UINT16_C( 43748), UINT16_C( 49428),
                              UINT16_C( 50369), UINT16_C( 25422), UINT16_C( 14520), UINT16_C( 51640),
                              UINT16_C( 20399), UINT16_C( 31915), UINT16_C( 49018), UINT16_C( 59334),
                              UINT16_C( 49204), UINT16_C( 62465), UINT16_C( 49892), UINT16_C( 58520),
                              UINT16_C( 13977), UINT16_C( 51690), UINT16_C( 42246), UINT16_C( 63457),
                              UINT16_C(  4753), UINT16_C( 14919), UINT16_C( 47008), UINT16_C(  7420),
                              UINT16_C( 12098), UINT16_C( 31014), UINT16_C( 17813), UINT16_C( 51080)),
      simde_x_mm512_set_epu16(UINT16_C( 53007), UINT16_C( 61893), UINT16_C( 36710), UINT16_C( 53426),
                              UINT16_C(  8030), UINT16_C( 20316), UINT16_C( 27324), UINT16_C( 24735),
                              UINT16_C( 58762), UINT16_C( 62832), UINT16_C( 33606), UINT16_C(  6874),
                              UINT16_C( 61584), UINT16_C(  2658), UINT16_C( 64632), UINT16_C( 57217),
                              UINT16_C( 49112), UINT16_C( 22778), UINT16_C( 18985), UINT16_C( 10063),
                              UINT16_C( 33785), UINT16_C( 16016), UINT16_C( 35319), UINT16_C( 18364),
                              UINT16_C( 45360), UINT16_C( 60575), UINT16_C( 35960), UINT16_C( 48902),
                              UINT16_C( 57525), UINT16_C( 38426), UINT16_C( 41010), UINT16_C( 54032)),
      simde_x_mm512_set_epu16(UINT16_C(     0), UINT16_C(     0), UINT16_C(     0), UINT16_C(  1580),
                              UINT16_C( 56435), UINT16_C( 13936), UINT16_C( 16424), UINT16_C( 24693),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C(     0), UINT16_C( 44766),
                              UINT16_C(     0), UINT16_C( 29257), UINT16_C(     0), UINT16_C(  2117),
                              UINT16_C(    92), UINT16_C( 39687), UINT16_C( 30907), UINT16_C( 48457),
                              UINT16_C(     0), UINT16_C( 35674), UINT16_C(  6927), UINT16_C( 45093),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C( 11048), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C(     0), UINT16_C(     0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_subs_epu16(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u16(r, ==, test_vec[i].r);
  }

  return 0;
}

SIMDE_TEST_FUNC_LIST_BEGIN
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_subs_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_subs_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_maskz_subs_epi8)

  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_subs_epi16)

  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_subs_epu8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_subs_epu8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_maskz_subs_epu8)

  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_subs_epu16)
SIMDE_TEST_FUNC_LIST_END

#include <test/x86/avx512/test-avx512-footer.h>
