5.3 Conditionnels

# Conditionnels

Une situation commune dans laquelle vous vous trouverez probablement est 
de non seulement jouer une note aléatoire (voir la précédente section 
sur l'aléatoire) mais de prendre une décision aléatoire basée sur le
résultat de l'exécution d'un code ou de tel autre code. Par exemple, 
vous pourriez vouloir jouer aléatoirement un tambour ou une cymbale. 
Nous pouvons y parvenir avec un ordre `if` (si).

## Pile ou Face 

Ainsi, faisons sauter une pièce : si c'est pile, joue un tambour, si 
c'est face, joue une cymbale. Facile. Nous pouvons émuler le saut d'une 
pièce avec notre fonction `one_in` (introduite dans la section traitant 
de l'aléatoire) en spécifiant une probabilité de 1 sur 2 : 
`one_in(2)`. Nous pouvons alors en utiliser le résultat pour décider 
entre deux bouts de code, le code pour jouer le tambour et le code pour 
jouer la cymbale :

```
loop do

  if one_in(2)
    sample :drum_heavy_kick
  else
    sample :drum_cymbal_closed
  end
  
  sleep 0.5
  
end
```


Notez que les ordres `if` ont trois parties :

* La question à poser
* Le premier choix de code à exécuter (si la réponse à la question est oui)
* Le second choix de code à exécuter (si la réponse à la question est non)

Typiquement, dans les langages de programmation, la notion de oui est 
représenté par le terme `true` (vrai) et la notion de non par le terme 
`false` (faux). Nous avons donc besoin de trouver une question qui nous 
donnera une réponse `vraie ("true")`  ou `fausse ("false")`, ce qui est 
exactement ce que fait `one_in`.

Notez comment le premier choix est encadré entre le `if` et le `else`, 
et le second choix est encadré entre le `else` et le `end`. Juste comme 
pour les blocs do/end, vous pouvez mettre plusieurs lignes dans chacun 
de ces endroits. Par exemple :

```
loop do

  if one_in(2)
    sample :drum_heavy_kick
    sleep 0.5
  else
    sample :drum_cymbal_closed
    sleep 0.25
  end
  
end
```

Cette fois nous "dormons" pour une durée différente et dépendante du choix 
qui est fait.

## If simple

Quelquefois, nous voulons optionnellement exécuter seulement une ligne 
de code. C'est possible en plaçant `if` à la fin et la question à la 
suite. Par exemple : 

```
use_synth :dsaw

loop do
  play 50, amp: 0.3, release: 2
  play 53, amp: 0.3, release: 2 if one_in(2)
  play 57, amp: 0.3, release: 2 if one_in(3)
  play 60, amp: 0.3, release: 2 if one_in(4)
  sleep 1.5
end
```
Ceci va jouer des accords de différents nombres avec la chance pour 
chaque note d'être jouée avec une probabilité différente.
