separate (ErrorHandler.Conversions.ToString.ControlFlowError)
procedure ControlFlowErrorExpl (E_Str   : in out E_Strings.T)

is
begin
   case Err_Type is
      when ErrorHandler.Misplaced_Exit =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "Exit statements must be of the form ""exit when c;"" where the closest" &
              " enclosing statement is a loop or ""if c then S; exit;"" where the" &
              " if statement has no else part and its closest enclosing" &
              " statement is a loop.  See the SPARK Definition for details.");
      when ErrorHandler.Misplaced_Return =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "A return statement may only occur as the last statement of a function.");
      when ErrorHandler.Missing_Return =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "SPARK requires that the last statement of a function be a return statement.");
      when others => null;
   end case;
end ControlFlowErrorExpl;
