/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.db.DBColumn;
import adql.parser.ADQLParser;
import adql.query.ADQLObject;
import adql.query.ADQLOrder;
import adql.query.ClauseADQL;
import adql.query.ClauseOffset;
import adql.query.TextPosition;
import adql.query.WithItem;
import adql.search.ISearchHandler;
import java.util.Iterator;

public abstract class ADQLSet
implements ADQLObject {
    protected final ADQLParser.ADQLVersion adqlVersion;
    protected ClauseADQL<WithItem> with;
    protected ClauseADQL<ADQLOrder> orderBy;
    protected ClauseOffset offset;
    protected TextPosition position = null;

    public ADQLSet() {
        this(ADQLParser.DEFAULT_VERSION);
    }

    public ADQLSet(ADQLParser.ADQLVersion version) {
        this.adqlVersion = version == null ? ADQLParser.DEFAULT_VERSION : version;
        this.with = new ClauseADQL("WITH");
        this.orderBy = new ClauseADQL("ORDER BY");
        this.offset = null;
    }

    public ADQLSet(ADQLSet toCopy) throws Exception {
        this.adqlVersion = toCopy.adqlVersion;
        this.with = (ClauseADQL)toCopy.with.getCopy();
        this.orderBy = (ClauseADQL)toCopy.orderBy.getCopy();
        this.offset = (ClauseOffset)toCopy.offset.getCopy();
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    public final ADQLParser.ADQLVersion getADQLVersion() {
        return this.adqlVersion;
    }

    public void reset() {
        this.with.clear();
        this.orderBy.clear();
        this.offset = null;
        this.position = null;
    }

    public final ClauseADQL<WithItem> getWith() {
        return this.with;
    }

    public void setWith(ClauseADQL<WithItem> newWith) throws NullPointerException {
        if (newWith == null) {
            throw new NullPointerException("Impossible to replace the WITH clause of a rows set by NULL!");
        }
        this.with = newWith;
        this.position = null;
    }

    public final ClauseADQL<ADQLOrder> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(ClauseADQL<ADQLOrder> newOrderBy) throws NullPointerException {
        if (newOrderBy == null) {
            this.orderBy.clear();
        } else {
            this.orderBy = newOrderBy;
        }
        this.position = null;
    }

    public abstract boolean hasLimit();

    public abstract int getLimit();

    public abstract void setNoLimit();

    public abstract void setLimit(int var1);

    public final ClauseOffset getOffset() {
        return this.offset;
    }

    public void setOffset(ClauseOffset newOffset) {
        this.offset = newOffset;
        this.position = null;
    }

    @Override
    public TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    public abstract DBColumn[] getResultingColumns();

    public Iterator<ADQLObject> search(ISearchHandler sHandler) {
        sHandler.search(this);
        return sHandler.iterator();
    }
}

