/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */


// sc
#include "RpListInfo.h"


RpListInfo::RpListInfo( const sc::String& url, svn::Revnumber rev,
  const svn::Date& date, const svn::DirEntries& entries )
: _url(url), _rev(rev), _date(date), _entries(entries)
{
}

const sc::String& RpListInfo::getUrl() const
{
  return _url;
}

const svn::Revnumber& RpListInfo::getRevnumber() const
{
  return _rev;
}

const svn::Date& RpListInfo::getDate() const
{
  return _date;
}

const svn::DirEntries& RpListInfo::getDirEntries() const
{
  return _entries;
}

unsigned long RpListInfo::getAge() const
{
  // in millisenconds..
  return (unsigned long)((apr_time_now() - _date) / 1000);
}

bool RpListInfo::isEmpty() const
{
  return _url.isEmpty();
}

void RpListInfo::operator=( const RpListInfo& src )
{
  _url  = src._url;
  _rev  = src._rev;
  _date = src._date;
  _entries = src._entries;
}

bool RpListInfo::operator==( const RpListInfo& info )
{
  return _url == info._url
    &&   _rev == info._rev
    &&   _date == info._date;
}
